{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE Rank2Types #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module Curry_Char
  ( d_C_isAscii
  , d_C_isLatin1
  , d_C_isAsciiLower
  , d_C_isAsciiUpper
  , d_C_isControl
  , d_C_isUpper
  , d_C_isLower
  , d_C_isAlpha
  , d_C_isDigit
  , d_C_isAlphaNum
  , d_C_isBinDigit
  , d_C_isOctDigit
  , d_C_isHexDigit
  , d_C_isSpace
  , d_C_toUpper
  , d_C_toLower
  , d_C_digitToInt
  , d_C_intToDigit )
  where

import Basics
import qualified Curry_Prelude


d_C_isAscii :: Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isAscii x1 cd cs = Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  cd cs) x1 cd cs) (Curry_Prelude.C_Char '\128'#) cd cs

d_C_isLatin1 :: Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isLatin1 x1 cd cs = Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  cd cs) x1 cd cs) (Curry_Prelude.C_Char '\255'#) cd cs

d_C_isAsciiLower :: Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isAsciiLower x1 cd cs = Curry_Prelude.d_OP_amp_amp (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  cd cs) x1 cd cs) (Curry_Prelude.C_Char 'a'#) cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  x1 (Curry_Prelude.C_Char 'z'#) cd cs) cd cs

d_C_isAsciiUpper :: Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isAsciiUpper x1 cd cs = Curry_Prelude.d_OP_amp_amp (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  cd cs) x1 cd cs) (Curry_Prelude.C_Char 'A'#) cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  x1 (Curry_Prelude.C_Char 'Z'#) cd cs) cd cs

d_C_isControl :: Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isControl x1 cd cs = Curry_Prelude.d_OP_bar_bar (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  cd cs) x1 cd cs) (Curry_Prelude.C_Char ' '#) cd cs)
  (Curry_Prelude.d_OP_amp_amp (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  cd cs) x1 cd cs) (Curry_Prelude.C_Char '\DEL'#) cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  x1 (Curry_Prelude.C_Char '\159'#) cd cs) cd cs) cd cs

d_C_isUpper :: Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isUpper x1 cd cs = Curry_Prelude.d_OP_amp_amp (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  cd cs) x1 cd cs) (Curry_Prelude.C_Char 'A'#) cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  x1 (Curry_Prelude.C_Char 'Z'#) cd cs) cd cs

d_C_isLower :: Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isLower x1 cd cs = Curry_Prelude.d_OP_amp_amp (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  cd cs) x1 cd cs) (Curry_Prelude.C_Char 'a'#) cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  x1 (Curry_Prelude.C_Char 'z'#) cd cs) cd cs

d_C_isAlpha :: Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isAlpha x1 cd cs = Curry_Prelude.d_OP_bar_bar (d_C_isUpper x1 cd cs)
  (d_C_isLower x1 cd cs) cd cs

d_C_isDigit :: Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isDigit x1 cd cs = Curry_Prelude.d_OP_amp_amp (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  cd cs) x1 cd cs) (Curry_Prelude.C_Char '0'#) cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  x1 (Curry_Prelude.C_Char '9'#) cd cs) cd cs

d_C_isAlphaNum :: Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isAlphaNum x1 cd cs = Curry_Prelude.d_OP_bar_bar (d_C_isAlpha x1 cd cs)
  (d_C_isDigit x1 cd cs) cd cs

d_C_isBinDigit :: Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isBinDigit x1 cd cs = Curry_Prelude.d_OP_bar_bar (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  cd cs) x1 cd cs) (Curry_Prelude.C_Char '0'#) cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  x1 (Curry_Prelude.C_Char '1'#) cd cs) cd cs

d_C_isOctDigit :: Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isOctDigit x1 cd cs = Curry_Prelude.d_OP_amp_amp (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  cd cs) x1 cd cs) (Curry_Prelude.C_Char '0'#) cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  x1 (Curry_Prelude.C_Char '7'#) cd cs) cd cs

d_C_isHexDigit :: Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isHexDigit x1 cd cs = Curry_Prelude.d_OP_bar_bar (d_C_isDigit x1 cd cs)
  (Curry_Prelude.d_OP_bar_bar (Curry_Prelude.d_OP_amp_amp
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  cd cs) x1 cd cs) (Curry_Prelude.C_Char 'A'#) cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  x1 (Curry_Prelude.C_Char 'F'#) cd cs) cd cs) (Curry_Prelude.d_OP_amp_amp
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  cd cs) x1 cd cs) (Curry_Prelude.C_Char 'a'#) cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  x1 (Curry_Prelude.C_Char 'f'#) cd cs) cd cs) cd cs) cd cs

d_C_isSpace :: Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isSpace x1 cd cs = Curry_Prelude.d_OP_bar_bar
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
  x1 (Curry_Prelude.C_Char ' '#) cd cs) (Curry_Prelude.d_OP_bar_bar
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
  x1 (Curry_Prelude.C_Char '\t'#) cd cs) (Curry_Prelude.d_OP_bar_bar
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
  x1 (Curry_Prelude.C_Char '\n'#) cd cs) (Curry_Prelude.d_OP_bar_bar
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
  x1 (Curry_Prelude.C_Char '\r'#) cd cs) (Curry_Prelude.d_OP_bar_bar
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
  x1 (Curry_Prelude.C_Char '\f'#) cd cs) (Curry_Prelude.d_OP_bar_bar
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
  x1 (Curry_Prelude.C_Char '\v'#) cd cs) (Curry_Prelude.d_OP_bar_bar
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
  x1 (Curry_Prelude.C_Char '\160'#) cd cs) (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_elem
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Int cd
  cs) (Curry_Prelude.d_C_ord x1 cd cs) cd cs) (Curry_Prelude.OP_Cons
  (Curry_Prelude.C_Int (5760)) (Curry_Prelude.OP_Cons (Curry_Prelude.C_Int
  (6158)) (Curry_Prelude.OP_Cons (Curry_Prelude.C_Int (8192))
  (Curry_Prelude.OP_Cons (Curry_Prelude.C_Int (8239)) (Curry_Prelude.OP_Cons
  (Curry_Prelude.C_Int (8287)) (Curry_Prelude.OP_Cons (Curry_Prelude.C_Int
  (12288)) Curry_Prelude.OP_List)))))) cd cs) cd cs) cd cs) cd cs) cd cs) cd cs)
  cd cs) cd cs

d_C_toUpper :: Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Char
d_C_toUpper x1 cd cs = d_C__case_10 x1 (d_C_isLower x1 cd cs) cd cs

d_C_toLower :: Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Char
d_C_toLower x1 cd cs = d_C__case_8 x1 (d_C_isUpper x1 cd cs) cd cs

d_C_digitToInt :: Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Int
d_C_digitToInt x1 cd cs = d_C__case_6 x1 (d_C_isDigit x1 cd cs) cd cs

d_C_intToDigit :: Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.C_Char
d_C_intToDigit x1 cd cs = d_C__case_2 x1 (Curry_Prelude.d_OP_amp_amp
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
  cd cs) x1 cd cs) (Curry_Prelude.C_Int (0)) cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
  x1 (Curry_Prelude.C_Int (9)) cd cs) cd cs) cd cs

d_C__case_2 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Char
d_C__case_2 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_chr
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    (Curry_Prelude.d_C_ord (Curry_Prelude.C_Char '0'#) cd cs) x1 cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_1 x1 (Curry_Prelude.d_OP_amp_amp
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
    cd cs) x1 cd cs) (Curry_Prelude.C_Int (10)) cd cs)
    (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
    x1 (Curry_Prelude.C_Int (15)) cd cs) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_2 x1 l cd cs)
    (d_C__case_2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_2 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_2 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Char._case_2" [show
    x1, show x2] info)
  _ -> failCons cd (consFail "Char._case_2" (showCons x2))

d_C__case_1 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Char
d_C__case_1 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_chr
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    (Curry_Prelude.d_C_ord (Curry_Prelude.C_Char 'A'#) cd cs) x1 cd cs)
    (Curry_Prelude.C_Int (10)) cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_0 (Curry_Prelude.d_C_otherwise cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_1 x1 l cd cs)
    (d_C__case_1 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_1 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_1 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Char._case_1" [show
    x1, show x2] info)
  _ -> failCons cd (consFail "Char._case_1" (showCons x2))

d_C__case_0 :: Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_Char
d_C__case_0 x1 cd cs = case x1 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "Char.intToDigit: argument not a digit value") cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_0 l cd cs)
    (d_C__case_0 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_0 z cd
    cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_0 e cd $! addCs c
    cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Char._case_0" [show
    x1] info)
  _ -> failCons cd (consFail "Char._case_0" (showCons x1))

d_C__case_6 :: Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Int
d_C__case_6 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    (Curry_Prelude.d_C_ord x1 cd cs) (Curry_Prelude.d_C_ord
    (Curry_Prelude.C_Char '0'#) cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_5 x1 (Curry_Prelude.d_OP_amp_amp
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
    cd cs) (Curry_Prelude.d_C_ord x1 cd cs) cd cs) (Curry_Prelude.d_C_ord
    (Curry_Prelude.C_Char 'A'#) cd cs) cd cs)
    (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
    (Curry_Prelude.d_C_ord x1 cd cs) (Curry_Prelude.d_C_ord
    (Curry_Prelude.C_Char 'F'#) cd cs) cd cs) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_6 x1 l cd cs)
    (d_C__case_6 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_6 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_6 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Char._case_6" [show
    x1, show x2] info)
  _ -> failCons cd (consFail "Char._case_6" (showCons x2))

d_C__case_5 :: Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Int
d_C__case_5 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    (Curry_Prelude.d_C_ord x1 cd cs) (Curry_Prelude.d_C_ord
    (Curry_Prelude.C_Char 'A'#) cd cs) cd cs) (Curry_Prelude.C_Int (10)) cd cs
  Curry_Prelude.C_False -> d_C__case_4 x1 (Curry_Prelude.d_OP_amp_amp
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
    cd cs) (Curry_Prelude.d_C_ord x1 cd cs) cd cs) (Curry_Prelude.d_C_ord
    (Curry_Prelude.C_Char 'a'#) cd cs) cd cs)
    (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
    (Curry_Prelude.d_C_ord x1 cd cs) (Curry_Prelude.d_C_ord
    (Curry_Prelude.C_Char 'f'#) cd cs) cd cs) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_5 x1 l cd cs)
    (d_C__case_5 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_5 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_5 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Char._case_5" [show
    x1, show x2] info)
  _ -> failCons cd (consFail "Char._case_5" (showCons x2))

d_C__case_4 :: Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Int
d_C__case_4 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    (Curry_Prelude.d_C_ord x1 cd cs) (Curry_Prelude.d_C_ord
    (Curry_Prelude.C_Char 'a'#) cd cs) cd cs) (Curry_Prelude.C_Int (10)) cd cs
  Curry_Prelude.C_False -> d_C__case_3 (Curry_Prelude.d_C_otherwise cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_4 x1 l cd cs)
    (d_C__case_4 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_4 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_4 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Char._case_4" [show
    x1, show x2] info)
  _ -> failCons cd (consFail "Char._case_4" (showCons x2))

d_C__case_3 :: Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_Int
d_C__case_3 x1 cd cs = case x1 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "Char.digitToInt: argument is not a digit") cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_3 l cd cs)
    (d_C__case_3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_3 z cd
    cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_3 e cd $! addCs c
    cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Char._case_3" [show
    x1] info)
  _ -> failCons cd (consFail "Char._case_3" (showCons x1))

d_C__case_8 :: Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Char
d_C__case_8 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_chr
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    (Curry_Prelude.d_C_ord x1 cd cs) (Curry_Prelude.d_C_ord
    (Curry_Prelude.C_Char 'A'#) cd cs) cd cs) (Curry_Prelude.d_C_ord
    (Curry_Prelude.C_Char 'a'#) cd cs) cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_7 x1 (Curry_Prelude.d_C_otherwise cd cs) cd
    cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_8 x1 l cd cs)
    (d_C__case_8 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_8 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_8 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Char._case_8" [show
    x1, show x2] info)
  _ -> failCons cd (consFail "Char._case_8" (showCons x2))

d_C__case_7 :: Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Char
d_C__case_7 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> x1
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_7 x1 l cd cs)
    (d_C__case_7 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_7 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_7 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Char._case_7" [show
    x1, show x2] info)
  _ -> failCons cd (consFail "Char._case_7" (showCons x2))

d_C__case_10 :: Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Char
d_C__case_10 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_chr
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    (Curry_Prelude.d_C_ord x1 cd cs) (Curry_Prelude.d_C_ord
    (Curry_Prelude.C_Char 'a'#) cd cs) cd cs) (Curry_Prelude.d_C_ord
    (Curry_Prelude.C_Char 'A'#) cd cs) cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_9 x1 (Curry_Prelude.d_C_otherwise cd cs) cd
    cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_10 x1 l cd cs)
    (d_C__case_10 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_10 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_10 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Char._case_10"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Char._case_10" (showCons x2))

d_C__case_9 :: Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Char
d_C__case_9 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> x1
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_9 x1 l cd cs)
    (d_C__case_9 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_9 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_9 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Char._case_9" [show
    x1, show x2] info)
  _ -> failCons cd (consFail "Char._case_9" (showCons x2))

