{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE Rank2Types #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module Curry_Dequeue
  ( C_Queue (..)
  , d_C_empty
  , d_C_cons
  , d_C_snoc
  , d_C_isEmpty
  , d_C_deqLength
  , d_C_deqHead
  , d_C_deqTail
  , d_C_deqLast
  , d_C_deqInit
  , d_C_deqReverse
  , d_C_rotate
  , d_C_matchHead
  , d_C_matchLast
  , d_C_listToDeq
  , d_C_deqToList )
  where

import Basics
import qualified Curry_Prelude


data C_Queue t0
  = C_S Curry_Prelude.C_Int (Curry_Prelude.OP_List t0) Curry_Prelude.C_Int
    (Curry_Prelude.OP_List t0)
  | Choice_C_Queue Cover ID (C_Queue t0) (C_Queue t0)
  | Choices_C_Queue Cover ID [C_Queue t0]
  | Fail_C_Queue Cover FailInfo
  | Guard_C_Queue Cover Constraints (C_Queue t0)

instance (Show t0) => Show (C_Queue t0) where
  showsPrec d (Choice_C_Queue cd i x y) = showsChoice d cd i x y
  showsPrec d (Choices_C_Queue cd i xs) = showsChoices d cd i xs
  showsPrec d (Guard_C_Queue cd c e) = showsGuard d cd c e
  showsPrec _ (Fail_C_Queue cd info) = showChar '!'
  showsPrec _ (C_S x1 x2 x3 x4) = showString "(S" . (showChar ' ' . (shows x1 .
    (showChar ' ' . (shows x2 . (showChar ' ' . (shows x3 . (showChar ' ' .
    (shows x4 . showChar ')'))))))))

instance (Read t0) => Read (C_Queue t0) where
  readsPrec d s = readParen ((>) d 10) (\r -> [(C_S x1 x2 x3 x4, r4) | (_, r0)
    <- readQualified "Dequeue" "S" r, (x1, r1) <- readsPrec 11 r0, (x2, r2) <-
    readsPrec 11 r1, (x3, r3) <- readsPrec 11 r2, (x4, r4) <- readsPrec 11 r3])
    s

instance NonDet (C_Queue t0) where
  choiceCons = Choice_C_Queue
  choicesCons = Choices_C_Queue
  failCons = Fail_C_Queue
  guardCons = Guard_C_Queue
  try (Choice_C_Queue cd i x y) = tryChoice cd i x y
  try (Choices_C_Queue cd i xs) = tryChoices cd i xs
  try (Fail_C_Queue cd info) = Fail cd info
  try (Guard_C_Queue cd c e) = Guard cd c e
  try x = Val x
  match f _ _ _ _ _ (Choice_C_Queue cd i x y) = f cd i x y
  match _ f _ _ _ _ (Choices_C_Queue cd i@(NarrowedID _ _) xs) = f cd i xs
  match _ _ f _ _ _ (Choices_C_Queue cd i@(FreeID _ _) xs) = f cd i xs
  match _ _ _ _ _ _ (Choices_C_Queue cd i _) = error
    ("Dequeue.Queue.match: Choices with ChoiceID " ++ show i)
  match _ _ _ f _ _ (Fail_C_Queue cd info) = f cd info
  match _ _ _ _ f _ (Guard_C_Queue cd c e) = f cd c e
  match _ _ _ _ _ f x = f x

instance (Generable t0) => Generable (C_Queue t0) where
  generate s c = Choices_C_Queue c (freeID [4] s) [C_S (generate (leftSupply
    (leftSupply s)) c) (generate (rightSupply (leftSupply s)) c) (generate
    (leftSupply (rightSupply s)) c) (generate (rightSupply (rightSupply s)) c)]

instance (NormalForm t0) => NormalForm (C_Queue t0) where
  ($!!) cont (C_S x1 x2 x3 x4) d cs = ($!!) (\y1 d cs -> ($!!) (\y2 d cs ->
    ($!!) (\y3 d cs -> ($!!) (\y4 d cs -> cont (C_S y1 y2 y3 y4) d cs) x4 d cs)
    x3 d cs) x2 d cs) x1 d cs
  ($!!) cont (Choice_C_Queue cd i x y) d cs = nfChoice cont cd i x y cd cs
  ($!!) cont (Choices_C_Queue cd i xs) d cs = nfChoices cont cd i xs d cs
  ($!!) cont (Guard_C_Queue cd c e) d cs = guardCons cd c (($!!) cont e d (addCs
    c cs))
  ($!!) _ (Fail_C_Queue cd info) _ _ = failCons cd info
  ($##) cont (C_S x1 x2 x3 x4) d cs = ($##) (\y1 d cs -> ($##) (\y2 d cs ->
    ($##) (\y3 d cs -> ($##) (\y4 d cs -> cont (C_S y1 y2 y3 y4) d cs) x4 d cs)
    x3 d cs) x2 d cs) x1 d cs
  ($##) cont (Choice_C_Queue cd i x y) d cs = gnfChoice cont cd i x y cd cs
  ($##) cont (Choices_C_Queue cd i xs) d cs = gnfChoices cont cd i xs d cs
  ($##) cont (Guard_C_Queue cd c e) d cs = guardCons cd c (($##) cont e d (addCs
    c cs))
  ($##) _ (Fail_C_Queue cd info) _ _ = failCons cd info
  showCons (C_S _ _ _ _) = "Dequeue.S _ _ _ _"
  showCons x = error ("Dequeue.Queue.showCons: no constructor: " ++ show x)
  searchNF search cont (C_S x1 x2 x3 x4) = search (\y1 -> search (\y2 -> search
    (\y3 -> search (\y4 -> cont (C_S y1 y2 y3 y4)) x4) x3) x2) x1
  searchNF _ _ x = error ("Dequeue.Queue.searchNF: no constructor: " ++ show x)

instance (Unifiable t0) => Unifiable (C_Queue t0) where
  (=.=) (C_S x1 x2 x3 x4) (C_S y1 y2 y3 y4) d cs = (&) ((=:=) x1 y1 d cs) ((&)
    ((=:=) x2 y2 d cs) ((&) ((=:=) x3 y3 d cs) ((=:=) x4 y4 d cs) d cs) d cs) d
    cs
  (=.=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  (=.<=) (C_S x1 x2 x3 x4) (C_S y1 y2 y3 y4) d cs = (&) ((=:<=) x1 y1 d cs) ((&)
    ((=:<=) x2 y2 d cs) ((&) ((=:<=) x3 y3 d cs) ((=:<=) x4 y4 d cs) d cs) d cs)
    d cs
  (=.<=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  bind cd i (C_S x3 x4 x5 x6) = (i :=: ChooseN 0 4) : concat [bind cd (leftID
    (leftID i)) x3, bind cd (rightID (leftID i)) x4, bind cd (leftID (rightID
    i)) x5, bind cd (rightID (rightID i)) x6]
  bind d i (Choice_C_Queue cd j x y) = [ConstraintChoice cd j (bind d i x) (bind
    d i y)]
  bind d i (Choices_C_Queue cd j@(FreeID _ _) xs) = bindOrNarrow d i cd j xs
  bind d i (Choices_C_Queue cd j@(NarrowedID _ _) xs) = [ConstraintChoices cd j
    (map (bind d i) xs)]
  bind _ _ (Choices_C_Queue cd i _) = error
    ("Dequeue.Queue.bind: Choices with ChoiceID: " ++ show i)
  bind _ _ (Fail_C_Queue cd info) = [Unsolvable info]
  bind d i (Guard_C_Queue cd c e) = getConstrList c ++ bind d i e
  lazyBind cd i (C_S x3 x4 x5 x6) = (i :=: ChooseN 0 4) : [leftID (leftID i) :=:
    LazyBind (lazyBind cd (leftID (leftID i)) x3), rightID (leftID i) :=:
    LazyBind (lazyBind cd (rightID (leftID i)) x4), leftID (rightID i) :=:
    LazyBind (lazyBind cd (leftID (rightID i)) x5), rightID (rightID i) :=:
    LazyBind (lazyBind cd (rightID (rightID i)) x6)]
  lazyBind d i (Choice_C_Queue cd j x y) = [ConstraintChoice cd j (lazyBind d i
    x) (lazyBind d i y)]
  lazyBind d i (Choices_C_Queue cd j@(FreeID _ _) xs) = lazyBindOrNarrow d i cd
    j xs
  lazyBind d i (Choices_C_Queue cd j@(NarrowedID _ _) xs) = [ConstraintChoices
    cd j (map (lazyBind d i) xs)]
  lazyBind _ _ (Choices_C_Queue cd i _) = error
    ("Dequeue.Queue.lazyBind: Choices with ChoiceID: " ++ show i)
  lazyBind _ _ (Fail_C_Queue cd info) = [Unsolvable info]
  lazyBind d i (Guard_C_Queue cd c e) = getConstrList c ++ [i :=: LazyBind
    (lazyBind d i e)]

instance (Curry t0) => Curry (C_Queue t0) where

d_C_empty :: forall t0 . (Curry_Prelude.Curry t0) => Cover -> ConstStore
  -> C_Queue t0
d_C_empty cd cs = C_S (Curry_Prelude.C_Int (0)) Curry_Prelude.OP_List
  (Curry_Prelude.C_Int (0)) Curry_Prelude.OP_List

d_C_cons :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> C_Queue t0 -> Cover
  -> ConstStore -> C_Queue t0
d_C_cons x1 x2 cd cs = case x2 of
  C_S x3 x4 x5 x6 -> d_C_check
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x3 (Curry_Prelude.C_Int (1)) cd cs) (Curry_Prelude.OP_Cons x1 x4) x5 x6 cd
    cs
  Choice_C_Queue d i l r -> narrow d i (d_C_cons x1 l cd cs) (d_C_cons x1 r cd
    cs)
  Choices_C_Queue d i xs -> narrows cs d i (\z -> d_C_cons x1 z cd cs) xs
  Guard_C_Queue d c e -> guardCons d c (d_C_cons x1 e cd $! addCs c cs)
  Fail_C_Queue d info -> failCons d (traceFail "Dequeue.cons" [show x1, show x2]
    info)
  _ -> failCons cd (consFail "Dequeue.cons" (showCons x2))

d_C_snoc :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> C_Queue t0 -> Cover
  -> ConstStore -> C_Queue t0
d_C_snoc x1 x2 cd cs = case x2 of
  C_S x3 x4 x5 x6 -> d_C_deqReverse (d_C_check
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x5 (Curry_Prelude.C_Int (1)) cd cs) (Curry_Prelude.OP_Cons x1 x6) x3 x4 cd
    cs) cd cs
  Choice_C_Queue d i l r -> narrow d i (d_C_snoc x1 l cd cs) (d_C_snoc x1 r cd
    cs)
  Choices_C_Queue d i xs -> narrows cs d i (\z -> d_C_snoc x1 z cd cs) xs
  Guard_C_Queue d c e -> guardCons d c (d_C_snoc x1 e cd $! addCs c cs)
  Fail_C_Queue d info -> failCons d (traceFail "Dequeue.snoc" [show x1, show x2]
    info)
  _ -> failCons cd (consFail "Dequeue.snoc" (showCons x2))

d_C_isEmpty :: forall t0 . (Curry_Prelude.Curry t0) => C_Queue t0 -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_C_isEmpty x1 cd cs = case x1 of
  C_S x2 x3 x4 x5 -> Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x2 x4 cd cs) (Curry_Prelude.C_Int (0)) cd cs
  Choice_C_Queue d i l r -> narrow d i (d_C_isEmpty l cd cs) (d_C_isEmpty r cd
    cs)
  Choices_C_Queue d i xs -> narrows cs d i (\z -> d_C_isEmpty z cd cs) xs
  Guard_C_Queue d c e -> guardCons d c (d_C_isEmpty e cd $! addCs c cs)
  Fail_C_Queue d info -> failCons d (traceFail "Dequeue.isEmpty" [show x1] info)
  _ -> failCons cd (consFail "Dequeue.isEmpty" (showCons x1))

d_C_deqLength :: forall t0 . (Curry_Prelude.Curry t0) => C_Queue t0 -> Cover
  -> ConstStore -> Curry_Prelude.C_Int
d_C_deqLength x1 cd cs = case x1 of
  C_S x2 x3 x4 x5 -> Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x2 x4 cd cs
  Choice_C_Queue d i l r -> narrow d i (d_C_deqLength l cd cs) (d_C_deqLength r
    cd cs)
  Choices_C_Queue d i xs -> narrows cs d i (\z -> d_C_deqLength z cd cs) xs
  Guard_C_Queue d c e -> guardCons d c (d_C_deqLength e cd $! addCs c cs)
  Fail_C_Queue d info -> failCons d (traceFail "Dequeue.deqLength" [show x1]
    info)
  _ -> failCons cd (consFail "Dequeue.deqLength" (showCons x1))

d_C_deqHead :: forall t0 . (Curry_Prelude.Curry t0) => C_Queue t0 -> Cover
  -> ConstStore -> t0
d_C_deqHead x1 cd cs = case x1 of
  C_S x2 x3 x4 x5 -> Curry_Prelude.d_C_head (d_C__case_11 x2 x3 x5
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
    x2 (Curry_Prelude.C_Int (0)) cd cs) cd cs) cd cs
  Choice_C_Queue d i l r -> narrow d i (d_C_deqHead l cd cs) (d_C_deqHead r cd
    cs)
  Choices_C_Queue d i xs -> narrows cs d i (\z -> d_C_deqHead z cd cs) xs
  Guard_C_Queue d c e -> guardCons d c (d_C_deqHead e cd $! addCs c cs)
  Fail_C_Queue d info -> failCons d (traceFail "Dequeue.deqHead" [show x1] info)
  _ -> failCons cd (consFail "Dequeue.deqHead" (showCons x1))

d_C_deqTail :: forall t0 . (Curry_Prelude.Curry t0) => C_Queue t0 -> Cover
  -> ConstStore -> C_Queue t0
d_C_deqTail x1 cd cs = case x1 of
  C_S x2 x3 x4 x5 -> d_C__case_10 x2 x5 x4 x3 cd cs
  Choice_C_Queue d i l r -> narrow d i (d_C_deqTail l cd cs) (d_C_deqTail r cd
    cs)
  Choices_C_Queue d i xs -> narrows cs d i (\z -> d_C_deqTail z cd cs) xs
  Guard_C_Queue d c e -> guardCons d c (d_C_deqTail e cd $! addCs c cs)
  Fail_C_Queue d info -> failCons d (traceFail "Dequeue.deqTail" [show x1] info)
  _ -> failCons cd (consFail "Dequeue.deqTail" (showCons x1))

d_C_deqLast :: forall t0 . (Curry_Prelude.Curry t0) => C_Queue t0 -> Cover
  -> ConstStore -> t0
d_C_deqLast x1 cd cs = case x1 of
  C_S x2 x3 x4 x5 -> Curry_Prelude.d_C_head (d_C__case_9 x4 x5 x3
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
    x4 (Curry_Prelude.C_Int (0)) cd cs) cd cs) cd cs
  Choice_C_Queue d i l r -> narrow d i (d_C_deqLast l cd cs) (d_C_deqLast r cd
    cs)
  Choices_C_Queue d i xs -> narrows cs d i (\z -> d_C_deqLast z cd cs) xs
  Guard_C_Queue d c e -> guardCons d c (d_C_deqLast e cd $! addCs c cs)
  Fail_C_Queue d info -> failCons d (traceFail "Dequeue.deqLast" [show x1] info)
  _ -> failCons cd (consFail "Dequeue.deqLast" (showCons x1))

d_C_deqInit :: forall t0 . (Curry_Prelude.Curry t0) => C_Queue t0 -> Cover
  -> ConstStore -> C_Queue t0
d_C_deqInit x1 cd cs = case x1 of
  C_S x2 x3 x4 x5 -> d_C__case_8 x4 x3 x2 x5 cd cs
  Choice_C_Queue d i l r -> narrow d i (d_C_deqInit l cd cs) (d_C_deqInit r cd
    cs)
  Choices_C_Queue d i xs -> narrows cs d i (\z -> d_C_deqInit z cd cs) xs
  Guard_C_Queue d c e -> guardCons d c (d_C_deqInit e cd $! addCs c cs)
  Fail_C_Queue d info -> failCons d (traceFail "Dequeue.deqInit" [show x1] info)
  _ -> failCons cd (consFail "Dequeue.deqInit" (showCons x1))

d_C_deqReverse :: forall t0 . (Curry_Prelude.Curry t0) => C_Queue t0 -> Cover
  -> ConstStore -> C_Queue t0
d_C_deqReverse x1 cd cs = case x1 of
  C_S x2 x3 x4 x5 -> C_S x4 x5 x2 x3
  Choice_C_Queue d i l r -> narrow d i (d_C_deqReverse l cd cs) (d_C_deqReverse
    r cd cs)
  Choices_C_Queue d i xs -> narrows cs d i (\z -> d_C_deqReverse z cd cs) xs
  Guard_C_Queue d c e -> guardCons d c (d_C_deqReverse e cd $! addCs c cs)
  Fail_C_Queue d info -> failCons d (traceFail "Dequeue.deqReverse" [show x1]
    info)
  _ -> failCons cd (consFail "Dequeue.deqReverse" (showCons x1))

d_C_rotate :: forall t0 . (Curry_Prelude.Curry t0) => C_Queue t0 -> Cover
  -> ConstStore -> C_Queue t0
d_C_rotate x1 cd cs = d_C_snoc (d_C_deqHead x1 cd cs) (d_C_deqTail x1 cd cs) cd
  cs

d_C_matchHead :: forall t0 . (Curry_Prelude.Curry t0) => C_Queue t0 -> Cover
  -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 t0 (C_Queue
  t0))
d_C_matchHead x1 cd cs = case x1 of
  C_S x2 x3 x4 x5 -> d_C__case_7 x2 x5 x4 x3 cd cs
  Choice_C_Queue d i l r -> narrow d i (d_C_matchHead l cd cs) (d_C_matchHead r
    cd cs)
  Choices_C_Queue d i xs -> narrows cs d i (\z -> d_C_matchHead z cd cs) xs
  Guard_C_Queue d c e -> guardCons d c (d_C_matchHead e cd $! addCs c cs)
  Fail_C_Queue d info -> failCons d (traceFail "Dequeue.matchHead" [show x1]
    info)
  _ -> failCons cd (consFail "Dequeue.matchHead" (showCons x1))

d_C_matchLast :: forall t0 . (Curry_Prelude.Curry t0) => C_Queue t0 -> Cover
  -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 t0 (C_Queue
  t0))
d_C_matchLast x1 cd cs = case x1 of
  C_S x2 x3 x4 x5 -> d_C__case_4 x4 x3 x2 x5 cd cs
  Choice_C_Queue d i l r -> narrow d i (d_C_matchLast l cd cs) (d_C_matchLast r
    cd cs)
  Choices_C_Queue d i xs -> narrows cs d i (\z -> d_C_matchLast z cd cs) xs
  Guard_C_Queue d c e -> guardCons d c (d_C_matchLast e cd $! addCs c cs)
  Fail_C_Queue d info -> failCons d (traceFail "Dequeue.matchLast" [show x1]
    info)
  _ -> failCons cd (consFail "Dequeue.matchLast" (showCons x1))

d_C_listToDeq :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  t0 -> Cover -> ConstStore -> C_Queue t0
d_C_listToDeq x1 cd cs = d_C_check (Curry_Prelude.d_C_length x1 cd cs) x1
  (Curry_Prelude.C_Int (0)) Curry_Prelude.OP_List cd cs

d_C_deqToList :: forall t0 . (Curry_Prelude.Curry t0) => C_Queue t0 -> Cover
  -> ConstStore -> Curry_Prelude.OP_List t0
d_C_deqToList x1 cd cs = case x1 of
  C_S x2 x3 x4 x5 -> Curry_Prelude.d_OP_plus_plus x3 (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_reverse cd cs) x5 cd cs) cd cs
  Choice_C_Queue d i l r -> narrow d i (d_C_deqToList l cd cs) (d_C_deqToList r
    cd cs)
  Choices_C_Queue d i xs -> narrows cs d i (\z -> d_C_deqToList z cd cs) xs
  Guard_C_Queue d c e -> guardCons d c (d_C_deqToList e cd $! addCs c cs)
  Fail_C_Queue d info -> failCons d (traceFail "Dequeue.deqToList" [show x1]
    info)
  _ -> failCons cd (consFail "Dequeue.deqToList" (showCons x1))

d_C_check :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List t0
  -> Cover -> ConstStore -> C_Queue t0
d_C_check x1 x2 x3 x4 cd cs =
  let x5 = Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
        x1 x3 cd cs
      x6 = Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
        (Curry_Prelude.d_OP_uscore_impl_hash_div_hash_Prelude_dot_Integral_hash_Prelude_dot_Int
        cd cs) x5 cd cs) (Curry_Prelude.C_Int (2)) cd cs
      x7 = Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
        x5 x6 cd cs
      x8 = Curry_Prelude.d_C_splitAt x6 x2 cd cs
      x9 = d_OP_check_dot_uscore_hash_selFP2_hash_f_tick x8 cd cs
      x10 = d_OP_check_dot_uscore_hash_selFP3_hash_rf_tick x8 cd cs
      x11 = Curry_Prelude.d_OP_plus_plus x4 (Curry_Prelude.d_C_apply
        (Curry_Prelude.d_C_reverse cd cs) x10 cd cs) cd cs
  in d_C__case_1 x3 x1 x11 x7 x9 x6 x4 x2
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
  x1
  (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
  (Curry_Prelude.d_OP_uscore_impl_hash_star_hash_Prelude_dot_Num_hash_Prelude_dot_Int
  (Curry_Prelude.C_Int (3)) x3 cd cs) (Curry_Prelude.C_Int (1)) cd cs) cd cs) cd
  cs

d_OP_check_dot_uscore_hash_selFP2_hash_f_tick :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List t0)
  (Curry_Prelude.OP_List t0) -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_OP_check_dot_uscore_hash_selFP2_hash_f_tick x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_check_dot_uscore_hash_selFP2_hash_f_tick l cd cs)
    (d_OP_check_dot_uscore_hash_selFP2_hash_f_tick r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_check_dot_uscore_hash_selFP2_hash_f_tick z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_check_dot_uscore_hash_selFP2_hash_f_tick e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Dequeue.check._#selFP2#f'" [show x1] info)
  _ -> failCons cd (consFail "Dequeue.check._#selFP2#f'" (showCons x1))

d_OP_check_dot_uscore_hash_selFP3_hash_rf_tick :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List t0)
  (Curry_Prelude.OP_List t0) -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_OP_check_dot_uscore_hash_selFP3_hash_rf_tick x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_check_dot_uscore_hash_selFP3_hash_rf_tick l cd cs)
    (d_OP_check_dot_uscore_hash_selFP3_hash_rf_tick r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_check_dot_uscore_hash_selFP3_hash_rf_tick z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_check_dot_uscore_hash_selFP3_hash_rf_tick e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Dequeue.check._#selFP3#rf'" [show x1] info)
  _ -> failCons cd (consFail "Dequeue.check._#selFP3#rf'" (showCons x1))

d_C__case_1 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List t0 -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> C_Queue t0
d_C__case_1 x3 x1 x11 x7 x9 x6 x4 x2 x12 cd cs = case x12 of
  Curry_Prelude.C_True -> C_S x1 x2 x3 x4
  Curry_Prelude.C_False -> d_C__case_0 x11 x7 x9 x6 (Curry_Prelude.d_C_otherwise
    cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_1 x3 x1 x11 x7 x9
    x6 x4 x2 l cd cs) (d_C__case_1 x3 x1 x11 x7 x9 x6 x4 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_1 x3 x1
    x11 x7 x9 x6 x4 x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_1 x3 x1 x11 x7 x9
    x6 x4 x2 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Dequeue._case_1"
    [show x3, show x1, show x11, show x7, show x9, show x6, show x4, show x2
    , show x12] info)
  _ -> failCons cd (consFail "Dequeue._case_1" (showCons x12))

d_C__case_0 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List t0
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List t0 -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> C_Queue t0
d_C__case_0 x11 x7 x9 x6 x12 cd cs = case x12 of
  Curry_Prelude.C_True -> C_S x6 x9 x7 x11
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_0 x11 x7 x9 x6 l
    cd cs) (d_C__case_0 x11 x7 x9 x6 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_0 x11
    x7 x9 x6 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_0 x11 x7 x9 x6 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Dequeue._case_0"
    [show x11, show x7, show x9, show x6, show x12] info)
  _ -> failCons cd (consFail "Dequeue._case_0" (showCons x12))

d_C__case_4 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List t0
  -> Cover -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 t0
  (C_Queue t0))
d_C__case_4 x4 x3 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_List -> d_C__case_3 x3 cd cs
  Curry_Prelude.OP_Cons x10 x11 -> Curry_Prelude.C_Just (Curry_Prelude.OP_Tuple2
    x10 (d_C_check x2 x3
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x4 (Curry_Prelude.C_Int (1)) cd cs) x11 cd cs))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_4 x4 x3 x2 l cd
    cs) (d_C__case_4 x4 x3 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_4 x4
    x3 x2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_4 x4 x3 x2 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Dequeue._case_4"
    [show x4, show x3, show x2, show x5] info)
  _ -> failCons cd (consFail "Dequeue._case_4" (showCons x5))

d_C__case_3 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List t0
  -> Cover -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 t0
  (C_Queue t0))
d_C__case_3 x3 cd cs = case x3 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_Nothing
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_2 x6 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_3 l cd cs)
    (d_C__case_3 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_3 z cd
    cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_3 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Dequeue._case_3"
    [show x3] info)
  _ -> failCons cd (consFail "Dequeue._case_3" (showCons x3))

d_C__case_2 :: forall t0 . (Curry_Prelude.Curry t0) => t0
  -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 t0 (C_Queue t0))
d_C__case_2 x6 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_Just (Curry_Prelude.OP_Tuple2 x6
    (d_C_empty cd cs))
  Curry_Prelude.OP_Cons x8 x9 -> Curry_Prelude.d_OP_dollar
    Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "Dequeue.matchLast: illegal queue") cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_2 x6 l cd cs)
    (d_C__case_2 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_2 x6 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_2 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Dequeue._case_2"
    [show x6, show x7] info)
  _ -> failCons cd (consFail "Dequeue._case_2" (showCons x7))

d_C__case_7 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List t0
  -> Cover -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 t0
  (C_Queue t0))
d_C__case_7 x2 x5 x4 x3 cd cs = case x3 of
  Curry_Prelude.OP_List -> d_C__case_6 x5 cd cs
  Curry_Prelude.OP_Cons x10 x11 -> Curry_Prelude.C_Just (Curry_Prelude.OP_Tuple2
    x10 (d_C_deqReverse (d_C_check x4 x5
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x2 (Curry_Prelude.C_Int (1)) cd cs) x11 cd cs) cd cs))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_7 x2 x5 x4 l cd
    cs) (d_C__case_7 x2 x5 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_7 x2
    x5 x4 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_7 x2 x5 x4 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Dequeue._case_7"
    [show x2, show x5, show x4, show x3] info)
  _ -> failCons cd (consFail "Dequeue._case_7" (showCons x3))

d_C__case_6 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List t0
  -> Cover -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 t0
  (C_Queue t0))
d_C__case_6 x5 cd cs = case x5 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_Nothing
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_5 x6 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_6 l cd cs)
    (d_C__case_6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_6 z cd
    cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_6 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Dequeue._case_6"
    [show x5] info)
  _ -> failCons cd (consFail "Dequeue._case_6" (showCons x5))

d_C__case_5 :: forall t0 . (Curry_Prelude.Curry t0) => t0
  -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 t0 (C_Queue t0))
d_C__case_5 x6 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_Just (Curry_Prelude.OP_Tuple2 x6
    (d_C_empty cd cs))
  Curry_Prelude.OP_Cons x8 x9 -> Curry_Prelude.d_OP_dollar
    Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "Dequeue.matchHead: illegal queue") cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_5 x6 l cd cs)
    (d_C__case_5 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_5 x6 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_5 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Dequeue._case_5"
    [show x6, show x7] info)
  _ -> failCons cd (consFail "Dequeue._case_5" (showCons x7))

d_C__case_8 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List t0
  -> Cover -> ConstStore -> C_Queue t0
d_C__case_8 x4 x3 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_List -> d_C_empty cd cs
  Curry_Prelude.OP_Cons x6 x7 -> d_C_check x2 x3
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x4 (Curry_Prelude.C_Int (1)) cd cs) x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_8 x4 x3 x2 l cd
    cs) (d_C__case_8 x4 x3 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_8 x4
    x3 x2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_8 x4 x3 x2 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Dequeue._case_8"
    [show x4, show x3, show x2, show x5] info)
  _ -> failCons cd (consFail "Dequeue._case_8" (showCons x5))

d_C__case_9 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_C__case_9 x4 x5 x3 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> x3
  Curry_Prelude.C_False -> x5
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_9 x4 x5 x3 l cd
    cs) (d_C__case_9 x4 x5 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_9 x4 x5
    x3 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_9 x4 x5 x3 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Dequeue._case_9"
    [show x4, show x5, show x3, show x6] info)
  _ -> failCons cd (consFail "Dequeue._case_9" (showCons x6))

d_C__case_10 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List t0
  -> Cover -> ConstStore -> C_Queue t0
d_C__case_10 x2 x5 x4 x3 cd cs = case x3 of
  Curry_Prelude.OP_List -> d_C_empty cd cs
  Curry_Prelude.OP_Cons x6 x7 -> d_C_deqReverse (d_C_check x4 x5
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x2 (Curry_Prelude.C_Int (1)) cd cs) x7 cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_10 x2 x5 x4 l cd
    cs) (d_C__case_10 x2 x5 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_10 x2
    x5 x4 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_10 x2 x5 x4 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Dequeue._case_10"
    [show x2, show x5, show x4, show x3] info)
  _ -> failCons cd (consFail "Dequeue._case_10" (showCons x3))

d_C__case_11 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_C__case_11 x2 x3 x5 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> x5
  Curry_Prelude.C_False -> x3
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_11 x2 x3 x5 l cd
    cs) (d_C__case_11 x2 x3 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_11 x2
    x3 x5 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_11 x2 x3 x5 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Dequeue._case_11"
    [show x2, show x3, show x5, show x6] info)
  _ -> failCons cd (consFail "Dequeue._case_11" (showCons x6))

