{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE Rank2Types #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module Curry_Directory
  ( d_C_doesFileExist
  , d_C_doesDirectoryExist
  , d_C_fileSize
  , d_C_getModificationTime
  , d_C_setCurrentDirectory
  , d_C_getDirectoryContents
  , d_C_createDirectory
  , d_C_createDirectoryIfMissing
  , d_C_removeDirectory
  , d_C_renameDirectory
  , d_C_getHomeDirectory
  , d_C_getTemporaryDirectory
  , d_C_getAbsolutePath
  , d_C_removeFile
  , d_C_renameFile
  , d_C_copyFile
  , d_C_getCurrentDirectory )
  where

import Basics
import qualified Curry_FilePath
import qualified Curry_List
import qualified Curry_Prelude
import qualified Curry_System
import qualified Curry_Time

import System.Directory
import System.IO
import System.Time

d_C_doesFileExist :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_Bool
d_C_doesFileExist x1 cd cs = Curry_Prelude.d_OP_dollar_hash_hash
  d_C_prim_doesFileExist x1 cd cs

d_C_doesDirectoryExist :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_Bool
d_C_doesDirectoryExist x1 cd cs = Curry_Prelude.d_OP_dollar_hash_hash
  d_C_prim_doesDirectoryExist x1 cd cs

d_C_fileSize :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_Int
d_C_fileSize x1 cd cs = Curry_Prelude.d_OP_dollar_hash_hash d_C_prim_fileSize x1
  cd cs

d_C_getModificationTime :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Time.C_ClockTime
d_C_getModificationTime x1 cd cs = Curry_Prelude.d_OP_dollar_hash_hash
  d_C_prim_getModificationTime x1 cd cs

d_C_setCurrentDirectory :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_setCurrentDirectory x1 cd cs = Curry_Prelude.d_OP_dollar_hash_hash
  d_C_prim_setCurrentDirectory x1 cd cs

d_C_getDirectoryContents :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_getDirectoryContents x1 cd cs = Curry_Prelude.d_OP_dollar_hash_hash
  d_C_prim_getDirectoryContents x1 cd cs

d_C_createDirectory :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_createDirectory x1 cd cs = Curry_Prelude.d_OP_dollar_hash_hash
  d_C_prim_createDirectory x1 cd cs

d_C_createDirectoryIfMissing :: Curry_Prelude.C_Bool -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
d_C_createDirectoryIfMissing x1 x2 cd cs = let x3 = Curry_Prelude.d_OP_dollar
                                                 (Curry_List.d_C_scanl1
                                                 (Curry_FilePath.d_OP_lt_slash_gt
                                                 cd cs))
                                                 (Curry_Prelude.d_OP_dollar
                                                 Curry_FilePath.d_C_splitDirectories
                                                 x2 cd cs) cd cs
  in d_C__case_7 x3 x1 cd cs

d_OP_createDirectoryIfMissing_dot_createDirs_dot_16 :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_OP_createDirectoryIfMissing_dot_createDirs_dot_16 x1 cd cs = case x1 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_done cd cs
  Curry_Prelude.OP_Cons x2 x3 -> Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (d_C_doesDirectoryExist x2 cd cs)
    (d_OP_createDirectoryIfMissing_dot_createDirs_dot_16_dot_uscore_hash_lambda2
    x2 x3) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_createDirectoryIfMissing_dot_createDirs_dot_16 l cd cs)
    (d_OP_createDirectoryIfMissing_dot_createDirs_dot_16 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_createDirectoryIfMissing_dot_createDirs_dot_16 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_createDirectoryIfMissing_dot_createDirs_dot_16 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Directory.createDirectoryIfMissing.createDirs.16" [show x1] info)
  _ -> failCons cd (consFail "Directory.createDirectoryIfMissing.createDirs.16"
    (showCons x1))

d_OP_createDirectoryIfMissing_dot_createDirs_dot_16_dot_uscore_hash_lambda2 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_OP_createDirectoryIfMissing_dot_createDirs_dot_16_dot_uscore_hash_lambda2 x1 x2 x3 cd cs =
  let x4 = x3
  in Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (d_C__case_6 x1 x4 cd cs) (d_OP_createDirectoryIfMissing_dot_createDirs_dot_16
  x2 cd cs) cd cs

d_C_removeDirectory :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_removeDirectory x1 cd cs = Curry_Prelude.d_OP_dollar_hash_hash
  d_C_prim_removeDirectory x1 cd cs

d_C_renameDirectory :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_renameDirectory x1 x2 cd cs = Curry_Prelude.d_OP_dollar_hash_hash
  (Curry_Prelude.d_OP_dollar_hash_hash (acceptCs id d_C_prim_renameDirectory) x1
  cd cs) x2 cd cs

d_C_getHomeDirectory :: Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_getHomeDirectory cd cs = d_C__case_5 (Curry_System.d_C_isWindows cd cs) cd
  cs

d_C_getTemporaryDirectory :: Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_getTemporaryDirectory cd cs = d_C__case_4 (Curry_System.d_C_isWindows cd cs)
  cd cs

d_C_getAbsolutePath :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_getAbsolutePath x1 cd cs = d_C__case_3 x1 (Curry_Prelude.d_C_apply
  (Curry_FilePath.d_C_isAbsolute cd cs) x1 cd cs) cd cs

d_OP_getAbsolutePath_dot_uscore_hash_lambda5 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_getAbsolutePath_dot_uscore_hash_lambda5 x1 x2 cd cs = let x3 = x2
  in Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_FilePath.d_C_normalise (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply (Curry_FilePath.d_OP_lt_slash_gt cd cs) x3 cd cs)
  (Curry_Prelude.d_C_drop (Curry_Prelude.C_Int (2)) x1 cd cs) cd cs) cd cs) cd
  cs

d_OP_getAbsolutePath_dot_uscore_hash_lambda8 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_getAbsolutePath_dot_uscore_hash_lambda8 x1 x2 cd cs = let x3 = x2
  in Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_FilePath.d_C_normalise (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply (Curry_FilePath.d_OP_lt_slash_gt cd cs) x3 cd cs) x1
  cd cs) cd cs) cd cs

d_C_removeFile :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_removeFile x1 cd cs = Curry_Prelude.d_OP_dollar_hash_hash
  d_C_prim_removeFile x1 cd cs

d_C_renameFile :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_renameFile x1 x2 cd cs = Curry_Prelude.d_OP_dollar_hash_hash
  (Curry_Prelude.d_OP_dollar_hash_hash (acceptCs id d_C_prim_renameFile) x1 cd
  cs) x2 cd cs

d_C_copyFile :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_copyFile x1 x2 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Prelude.d_C_readFile x1 cd cs) (Curry_Prelude.d_C_writeFile x2) cd cs

d_C__case_3 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_3 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (Curry_FilePath.d_C_normalise x1 cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_2 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) x1 (Curry_Prelude.toCurryString "~") cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_3 x1 l cd cs)
    (d_C__case_3 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_3 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_3 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Directory._case_3"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Directory._case_3" (showCons x2))

d_C__case_2 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_2 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> d_C_getHomeDirectory cd cs
  Curry_Prelude.C_False -> d_C__case_1 x1 (Curry_List.d_C_isPrefixOf
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) (Curry_Prelude.toCurryString "~/") x1 cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_2 x1 l cd cs)
    (d_C__case_2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_2 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_2 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Directory._case_2"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Directory._case_2" (showCons x2))

d_C__case_1 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_1 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (d_C_getHomeDirectory cd cs) (d_OP_getAbsolutePath_dot_uscore_hash_lambda5
    x1) cd cs
  Curry_Prelude.C_False -> d_C__case_0 x1 (Curry_Prelude.d_C_otherwise cd cs) cd
    cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_1 x1 l cd cs)
    (d_C__case_1 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_1 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_1 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Directory._case_1"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Directory._case_1" (showCons x2))

d_C__case_0 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_0 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (d_C_getCurrentDirectory cd cs)
    (d_OP_getAbsolutePath_dot_uscore_hash_lambda8 x1) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_0 x1 l cd cs)
    (d_C__case_0 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_0 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_0 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Directory._case_0"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Directory._case_0" (showCons x2))

d_C__case_4 :: Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_4 x1 cd cs = case x1 of
  Curry_Prelude.C_True -> Curry_System.d_C_getEnviron
    (Curry_Prelude.toCurryString "TMP") cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (Curry_Prelude.toCurryString "/tmp") cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_4 l cd cs)
    (d_C__case_4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_4 z cd
    cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_4 e cd $! addCs c
    cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Directory._case_4"
    [show x1] info)
  _ -> failCons cd (consFail "Directory._case_4" (showCons x1))

d_C__case_5 :: Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_5 x1 cd cs = case x1 of
  Curry_Prelude.C_True -> Curry_System.d_C_getEnviron
    (Curry_Prelude.toCurryString "USERPROFILE") cd cs
  Curry_Prelude.C_False -> Curry_System.d_C_getEnviron
    (Curry_Prelude.toCurryString "HOME") cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_5 l cd cs)
    (d_C__case_5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_5 z cd
    cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_5 e cd $! addCs c
    cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Directory._case_5"
    [show x1] info)
  _ -> failCons cd (consFail "Directory._case_5" (showCons x1))

d_C__case_6 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
d_C__case_6 x1 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_done cd cs
  Curry_Prelude.C_False -> d_C_createDirectory x1 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_6 x1 l cd cs)
    (d_C__case_6 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_6 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_6 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Directory._case_6"
    [show x1, show x4] info)
  _ -> failCons cd (consFail "Directory._case_6" (showCons x4))

d_C__case_7 :: Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C__case_7 x3 x1 cd cs = case x1 of
  Curry_Prelude.C_True -> d_OP_createDirectoryIfMissing_dot_createDirs_dot_16 x3
    cd cs
  Curry_Prelude.C_False -> d_OP_createDirectoryIfMissing_dot_createDirs_dot_16
    (Curry_Prelude.OP_Cons (Curry_List.d_C_last x3 cd cs) Curry_Prelude.OP_List)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_7 x3 l cd cs)
    (d_C__case_7 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_7 x3 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_7 x3 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Directory._case_7"
    [show x3, show x1] info)
  _ -> failCons cd (consFail "Directory._case_7" (showCons x1))

d_C_prim_doesFileExist :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_Bool
d_C_prim_doesFileExist x1 cd cs = external_d_C_prim_doesFileExist x1 cd cs

d_C_prim_doesDirectoryExist :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_Bool
d_C_prim_doesDirectoryExist x1 cd cs = external_d_C_prim_doesDirectoryExist x1
  cd cs

d_C_prim_fileSize :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_Int
d_C_prim_fileSize x1 cd cs = external_d_C_prim_fileSize x1 cd cs

d_C_prim_getModificationTime :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Time.C_ClockTime
d_C_prim_getModificationTime x1 cd cs = external_d_C_prim_getModificationTime x1
  cd cs

d_C_getCurrentDirectory :: Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_getCurrentDirectory cd cs = external_d_C_getCurrentDirectory cd cs

d_C_prim_setCurrentDirectory :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_prim_setCurrentDirectory x1 cd cs = external_d_C_prim_setCurrentDirectory x1
  cd cs

d_C_prim_getDirectoryContents :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_prim_getDirectoryContents x1 cd cs = external_d_C_prim_getDirectoryContents
  x1 cd cs

d_C_prim_createDirectory :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_prim_createDirectory x1 cd cs = external_d_C_prim_createDirectory x1 cd cs

d_C_prim_removeDirectory :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_prim_removeDirectory x1 cd cs = external_d_C_prim_removeDirectory x1 cd cs

d_C_prim_renameDirectory :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_prim_renameDirectory x1 x2 cd cs = external_d_C_prim_renameDirectory x1 x2
  cd cs

d_C_prim_removeFile :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_prim_removeFile x1 cd cs = external_d_C_prim_removeFile x1 cd cs

d_C_prim_renameFile :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_prim_renameFile x1 x2 cd cs = external_d_C_prim_renameFile x1 x2 cd cs

external_d_C_prim_doesFileExist :: Curry_Prelude.C_String -> Cover -> ConstStore
                                -> Curry_Prelude.C_IO Curry_Prelude.C_Bool
external_d_C_prim_doesFileExist s _ _ = toCurry doesFileExist s

external_d_C_prim_doesDirectoryExist :: Curry_Prelude.C_String -> Cover -> ConstStore
                                     -> Curry_Prelude.C_IO Curry_Prelude.C_Bool
external_d_C_prim_doesDirectoryExist s _ _ = toCurry doesDirectoryExist s

external_d_C_prim_fileSize :: Curry_Prelude.C_String -> Cover -> ConstStore
                           -> Curry_Prelude.C_IO Curry_Prelude.C_Int
external_d_C_prim_fileSize s _ _ = toCurry
  (\f -> do h <- openFile f ReadMode
            i <- hFileSize h
            hClose h
            return i
  ) s

external_d_C_prim_getModificationTime :: Curry_Prelude.C_String -> Cover -> ConstStore
                                      -> Curry_Prelude.C_IO Curry_Time.C_ClockTime
external_d_C_prim_getModificationTime s _ _ = toCurry getModificationTime s

external_d_C_getCurrentDirectory :: Cover -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_String)
external_d_C_getCurrentDirectory _ _ = toCurry getCurrentDirectory

external_d_C_prim_setCurrentDirectory :: Curry_Prelude.C_String -> Cover -> ConstStore
                                      -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
external_d_C_prim_setCurrentDirectory s _ _ = toCurry setCurrentDirectory s

external_d_C_prim_getDirectoryContents :: Curry_Prelude.C_String -> Cover -> ConstStore
                                       -> Curry_Prelude.C_IO (Curry_Prelude.OP_List (Curry_Prelude.C_String))
external_d_C_prim_getDirectoryContents s _ _ = toCurry getDirectoryContents s

external_d_C_prim_createDirectory :: Curry_Prelude.C_String -> Cover -> ConstStore
                                  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
external_d_C_prim_createDirectory s _ _ = toCurry createDirectory s

external_d_C_prim_removeFile :: Curry_Prelude.C_String -> Cover -> ConstStore
                             -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
external_d_C_prim_removeFile s _ _ = toCurry removeFile s

external_d_C_prim_removeDirectory :: Curry_Prelude.C_String -> Cover -> ConstStore
                                  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
external_d_C_prim_removeDirectory s _ _ = toCurry removeDirectory s

external_d_C_prim_renameFile :: Curry_Prelude.C_String -> Curry_Prelude.C_String -> Cover -> ConstStore
                             -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
external_d_C_prim_renameFile s1 s2 _ _ = toCurry renameFile s1 s2

external_d_C_prim_renameDirectory :: Curry_Prelude.C_String -> Curry_Prelude.C_String
                                  -> Cover -> ConstStore 
                                  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
external_d_C_prim_renameDirectory s1 s2 _ _= toCurry renameDirectory s1 s2
