{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE Rank2Types #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module Curry_FileGoodies
  ( d_C_separatorChar
  , d_C_pathSeparatorChar
  , d_C_suffixSeparatorChar
  , d_C_isAbsolute
  , d_C_dirName
  , d_C_baseName
  , d_C_splitDirectoryBaseName
  , d_C_stripSuffix
  , d_C_fileSuffix
  , d_C_splitBaseName
  , d_C_splitPath
  , d_C_lookupFileInPath
  , d_C_getFileInPath )
  where

import Basics
import qualified Curry_Directory
import qualified Curry_List
import qualified Curry_Prelude


d_C_separatorChar :: Cover -> ConstStore -> Curry_Prelude.C_Char
d_C_separatorChar cd cs = Curry_Prelude.C_Char '/'#

d_C_pathSeparatorChar :: Cover -> ConstStore -> Curry_Prelude.C_Char
d_C_pathSeparatorChar cd cs = Curry_Prelude.C_Char ':'#

d_C_suffixSeparatorChar :: Cover -> ConstStore -> Curry_Prelude.C_Char
d_C_suffixSeparatorChar cd cs = Curry_Prelude.C_Char '.'#

d_C_isAbsolute :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_C_isAbsolute x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x2 (d_C_separatorChar cd cs) cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.C_False
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_isAbsolute l cd cs)
    (d_C_isAbsolute r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_isAbsolute z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_isAbsolute e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "FileGoodies.isAbsolute" [show x1] info)
  _ -> failCons cd (consFail "FileGoodies.isAbsolute" (showCons x1))

d_C_dirName :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_dirName x1 cd cs = Curry_Prelude.d_C_fst (d_C_splitDirectoryBaseName x1 cd
  cs) cd cs

d_C_baseName :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_baseName x1 cd cs = Curry_Prelude.d_C_snd (d_C_splitDirectoryBaseName x1 cd
  cs) cd cs

d_C_splitDirectoryBaseName :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_splitDirectoryBaseName x1 cd cs = let x2 = Curry_Prelude.d_C_apply
                                            (Curry_Prelude.d_C_break
                                            (Curry_Prelude.d_C_flip (acceptCs id
                                            Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char)
                                            (d_C_separatorChar cd cs)) cd cs)
                                            (Curry_Prelude.d_C_apply
                                            (Curry_Prelude.d_C_reverse cd cs) x1
                                            cd cs) cd cs
                                          x3 = d_OP_splitDirectoryBaseName_dot_uscore_hash_selFP2_hash_rbase
                                            x2 cd cs
                                          x4 = d_OP_splitDirectoryBaseName_dot_uscore_hash_selFP3_hash_rdir
                                            x2 cd cs
  in d_C__case_3 x4 x3 (Curry_Prelude.d_C_null x4 cd cs) cd cs

d_OP_splitDirectoryBaseName_dot_uscore_hash_selFP2_hash_rbase :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitDirectoryBaseName_dot_uscore_hash_selFP2_hash_rbase x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitDirectoryBaseName_dot_uscore_hash_selFP2_hash_rbase l cd cs)
    (d_OP_splitDirectoryBaseName_dot_uscore_hash_selFP2_hash_rbase r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitDirectoryBaseName_dot_uscore_hash_selFP2_hash_rbase z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_splitDirectoryBaseName_dot_uscore_hash_selFP2_hash_rbase e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "FileGoodies.splitDirectoryBaseName._#selFP2#rbase" [show x1] info)
  _ -> failCons cd (consFail "FileGoodies.splitDirectoryBaseName._#selFP2#rbase"
    (showCons x1))

d_OP_splitDirectoryBaseName_dot_uscore_hash_selFP3_hash_rdir :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitDirectoryBaseName_dot_uscore_hash_selFP3_hash_rdir x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitDirectoryBaseName_dot_uscore_hash_selFP3_hash_rdir l cd cs)
    (d_OP_splitDirectoryBaseName_dot_uscore_hash_selFP3_hash_rdir r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitDirectoryBaseName_dot_uscore_hash_selFP3_hash_rdir z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_splitDirectoryBaseName_dot_uscore_hash_selFP3_hash_rdir e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "FileGoodies.splitDirectoryBaseName._#selFP3#rdir" [show x1] info)
  _ -> failCons cd (consFail "FileGoodies.splitDirectoryBaseName._#selFP3#rdir"
    (showCons x1))

d_C_stripSuffix :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_stripSuffix cd cs = Curry_Prelude.d_OP_dot Curry_Prelude.d_C_fst
  d_C_splitBaseName cd cs

d_C_fileSuffix :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_fileSuffix cd cs = Curry_Prelude.d_OP_dot Curry_Prelude.d_C_snd
  d_C_splitBaseName cd cs

d_C_splitBaseName :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_splitBaseName x1 cd cs = let x2 = Curry_Prelude.d_C_apply
                                   (Curry_Prelude.d_C_break
                                   (Curry_Prelude.d_C_flip (acceptCs id
                                   Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char)
                                   (d_C_suffixSeparatorChar cd cs)) cd cs)
                                   (Curry_Prelude.d_C_apply
                                   (Curry_Prelude.d_C_reverse cd cs) x1 cd cs)
                                   cd cs
                                 x3 = d_OP_splitBaseName_dot_uscore_hash_selFP5_hash_rsuffix
                                   x2 cd cs
                                 x4 = d_OP_splitBaseName_dot_uscore_hash_selFP6_hash_rbase
                                   x2 cd cs
  in d_C__case_2 x3 x4 x1 (Curry_Prelude.d_OP_bar_bar (Curry_Prelude.d_C_null x4
  cd cs) (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_elem
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) (d_C_separatorChar cd cs) cd cs) x3 cd cs) cd cs) cd cs

d_OP_splitBaseName_dot_uscore_hash_selFP5_hash_rsuffix :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitBaseName_dot_uscore_hash_selFP5_hash_rsuffix x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitBaseName_dot_uscore_hash_selFP5_hash_rsuffix l cd cs)
    (d_OP_splitBaseName_dot_uscore_hash_selFP5_hash_rsuffix r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitBaseName_dot_uscore_hash_selFP5_hash_rsuffix z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_splitBaseName_dot_uscore_hash_selFP5_hash_rsuffix e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "FileGoodies.splitBaseName._#selFP5#rsuffix" [show x1] info)
  _ -> failCons cd (consFail "FileGoodies.splitBaseName._#selFP5#rsuffix"
    (showCons x1))

d_OP_splitBaseName_dot_uscore_hash_selFP6_hash_rbase :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitBaseName_dot_uscore_hash_selFP6_hash_rbase x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitBaseName_dot_uscore_hash_selFP6_hash_rbase l cd cs)
    (d_OP_splitBaseName_dot_uscore_hash_selFP6_hash_rbase r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitBaseName_dot_uscore_hash_selFP6_hash_rbase z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_splitBaseName_dot_uscore_hash_selFP6_hash_rbase e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "FileGoodies.splitBaseName._#selFP6#rbase" [show x1] info)
  _ -> failCons cd (consFail "FileGoodies.splitBaseName._#selFP6#rbase"
    (showCons x1))

d_C_splitPath :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_splitPath x1 cd cs = case x1 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x2 x3 -> let x4 = Curry_Prelude.d_C_apply
                                       (Curry_Prelude.d_C_break
                                       (Curry_Prelude.d_C_flip (acceptCs id
                                       Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char)
                                       (d_C_pathSeparatorChar cd cs)) cd cs)
                                       (Curry_Prelude.OP_Cons x2 x3) cd cs
                                     x5 = d_OP_splitPath_dot_uscore_hash_selFP8_hash_ys
                                       x4 cd cs
                                     x6 = d_OP_splitPath_dot_uscore_hash_selFP9_hash_zs
                                       x4 cd cs
    in d_C__case_1 x6 x5 (Curry_Prelude.d_C_null x6 cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_splitPath l cd cs)
    (d_C_splitPath r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_splitPath z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_splitPath e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "FileGoodies.splitPath" [show x1] info)
  _ -> failCons cd (consFail "FileGoodies.splitPath" (showCons x1))

d_OP_splitPath_dot_uscore_hash_selFP8_hash_ys :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitPath_dot_uscore_hash_selFP8_hash_ys x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitPath_dot_uscore_hash_selFP8_hash_ys l cd cs)
    (d_OP_splitPath_dot_uscore_hash_selFP8_hash_ys r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitPath_dot_uscore_hash_selFP8_hash_ys z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_splitPath_dot_uscore_hash_selFP8_hash_ys e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "FileGoodies.splitPath._#selFP8#ys" [show x1] info)
  _ -> failCons cd (consFail "FileGoodies.splitPath._#selFP8#ys" (showCons x1))

d_OP_splitPath_dot_uscore_hash_selFP9_hash_zs :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitPath_dot_uscore_hash_selFP9_hash_zs x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitPath_dot_uscore_hash_selFP9_hash_zs l cd cs)
    (d_OP_splitPath_dot_uscore_hash_selFP9_hash_zs r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitPath_dot_uscore_hash_selFP9_hash_zs z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_splitPath_dot_uscore_hash_selFP9_hash_zs e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "FileGoodies.splitPath._#selFP9#zs" [show x1] info)
  _ -> failCons cd (consFail "FileGoodies.splitPath._#selFP9#zs" (showCons x1))

d_C_lookupFileInPath :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_lookupFileInPath x1 x2 x3 cd cs = d_C__case_0 x1 x3 x2 (d_C_isAbsolute x1 cd
  cs) cd cs

d_OP_lookupFileInPath_dot_lookupFirstFileWithSuffix_dot_35 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_lookupFileInPath_dot_lookupFirstFileWithSuffix_dot_35 x1 x2 cd cs =
  case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    Curry_Prelude.C_Nothing cd cs
  Curry_Prelude.OP_Cons x3 x4 -> let x5 = Curry_Prelude.d_OP_plus_plus x1 x3 cd
                                       cs
    in Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (Curry_Directory.d_C_doesFileExist x5 cd cs)
    (d_OP_lookupFileInPath_dot_lookupFirstFileWithSuffix_dot_35_dot_uscore_hash_lambda5
    x1 x5 x4) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_lookupFileInPath_dot_lookupFirstFileWithSuffix_dot_35 x1 l cd cs)
    (d_OP_lookupFileInPath_dot_lookupFirstFileWithSuffix_dot_35 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_lookupFileInPath_dot_lookupFirstFileWithSuffix_dot_35 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_lookupFileInPath_dot_lookupFirstFileWithSuffix_dot_35 x1 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "FileGoodies.lookupFileInPath.lookupFirstFileWithSuffix.35" [show x1, show
    x2] info)
  _ -> failCons cd (consFail
    "FileGoodies.lookupFileInPath.lookupFirstFileWithSuffix.35" (showCons x2))

d_OP_lookupFileInPath_dot_lookupFirstFileWithSuffix_dot_35_dot_uscore_hash_lambda5 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_lookupFileInPath_dot_lookupFirstFileWithSuffix_dot_35_dot_uscore_hash_lambda5 x1 x2 x3 x4 cd cs =
  case x4 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (Curry_Prelude.C_Just x2) cd cs
  Curry_Prelude.C_False -> d_OP_lookupFileInPath_dot_lookupFirstFileWithSuffix_dot_35
    x1 x3 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i
    (d_OP_lookupFileInPath_dot_lookupFirstFileWithSuffix_dot_35_dot_uscore_hash_lambda5
    x1 x2 x3 l cd cs)
    (d_OP_lookupFileInPath_dot_lookupFirstFileWithSuffix_dot_35_dot_uscore_hash_lambda5
    x1 x2 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z ->
    d_OP_lookupFileInPath_dot_lookupFirstFileWithSuffix_dot_35_dot_uscore_hash_lambda5
    x1 x2 x3 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c
    (d_OP_lookupFileInPath_dot_lookupFirstFileWithSuffix_dot_35_dot_uscore_hash_lambda5
    x1 x2 x3 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "FileGoodies.lookupFileInPath.lookupFirstFileWithSuffix.35._#lambda5" [show
    x1, show x2, show x3, show x4] info)
  _ -> failCons cd (consFail
    "FileGoodies.lookupFileInPath.lookupFirstFileWithSuffix.35._#lambda5"
    (showCons x4))

d_OP_lookupFileInPath_dot_lookupFirstFile_dot_35 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_lookupFileInPath_dot_lookupFirstFile_dot_35 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    Curry_Prelude.C_Nothing cd cs
  Curry_Prelude.OP_Cons x4 x5 -> Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (d_OP_lookupFileInPath_dot_lookupFirstFileWithSuffix_dot_35
    (Curry_Prelude.d_OP_plus_plus x4 (Curry_Prelude.OP_Cons (d_C_separatorChar
    cd cs) x1) cd cs) x2 cd cs)
    (d_OP_lookupFileInPath_dot_lookupFirstFile_dot_35_dot_uscore_hash_lambda2 x1
    x5 x2) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_lookupFileInPath_dot_lookupFirstFile_dot_35 x1 x2 l cd cs)
    (d_OP_lookupFileInPath_dot_lookupFirstFile_dot_35 x1 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_lookupFileInPath_dot_lookupFirstFile_dot_35 x1 x2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_lookupFileInPath_dot_lookupFirstFile_dot_35 x1 x2 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "FileGoodies.lookupFileInPath.lookupFirstFile.35" [show x1, show x2, show
    x3] info)
  _ -> failCons cd (consFail "FileGoodies.lookupFileInPath.lookupFirstFile.35"
    (showCons x3))

d_OP_lookupFileInPath_dot_lookupFirstFile_dot_35_dot_uscore_hash_lambda2 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_lookupFileInPath_dot_lookupFirstFile_dot_35_dot_uscore_hash_lambda2 x1 x2 x3 x4 cd cs =
  let x5 = x4
  in Curry_Prelude.d_C_maybe (d_OP_lookupFileInPath_dot_lookupFirstFile_dot_35
  x1 x3 x2 cd cs) (Curry_Prelude.d_OP_dot
  Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (acceptCs id Curry_Prelude.C_Just) cd cs) x5 cd cs

d_C_getFileInPath :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_getFileInPath x1 x2 x3 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (d_C_lookupFileInPath x1 x2 x3 cd cs)
  (d_OP_getFileInPath_dot_uscore_hash_lambda8 x1 x3) cd cs

d_OP_getFileInPath_dot_uscore_hash_lambda8 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_getFileInPath_dot_uscore_hash_lambda8 x1 x2 x3 cd cs = let x4 = x3
  in Curry_Prelude.d_C_maybe (Curry_Prelude.d_OP_dollar Curry_Prelude.d_C_error
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "File ")
  (Curry_Prelude.d_OP_plus_plus x1 (Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.toCurryString " not found in path ") (Curry_Prelude.d_C_concat
  (Curry_List.d_C_intersperse (Curry_Prelude.OP_Cons (d_C_pathSeparatorChar cd
  cs) Curry_Prelude.OP_List) x2 cd cs) cd cs) cd cs) cd cs) cd cs) cd cs)
  Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  x4 cd cs

d_C__case_0 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_0 x1 x3 x2 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> d_OP_lookupFileInPath_dot_lookupFirstFileWithSuffix_dot_35
    x1 x2 cd cs
  Curry_Prelude.C_False -> d_OP_lookupFileInPath_dot_lookupFirstFile_dot_35 x1
    x2 x3 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_0 x1 x3 x2 l cd
    cs) (d_C__case_0 x1 x3 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_0 x1 x3
    x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_0 x1 x3 x2 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "FileGoodies._case_0" [show x1, show x3, show x2, show x4] info)
  _ -> failCons cd (consFail "FileGoodies._case_0" (showCons x4))

d_C__case_1 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C__case_1 x6 x5 x7 cd cs = case x7 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons x5 Curry_Prelude.OP_List
  Curry_Prelude.C_False -> Curry_Prelude.OP_Cons x5 (d_C_splitPath
    (Curry_Prelude.d_C_tail x6 cd cs) cd cs)
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_1 x6 x5 l cd cs)
    (d_C__case_1 x6 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_1 x6 x5
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_1 x6 x5 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "FileGoodies._case_1" [show x6, show x5, show x7] info)
  _ -> failCons cd (consFail "FileGoodies._case_1" (showCons x7))

d_C__case_2 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_2 x3 x4 x1 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Tuple2 x1 Curry_Prelude.OP_List
  Curry_Prelude.C_False -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_reverse cd cs) (Curry_Prelude.d_C_tail x4 cd cs) cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_reverse cd cs) x3 cd cs)
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_2 x3 x4 x1 l cd
    cs) (d_C__case_2 x3 x4 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_2 x3 x4
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_2 x3 x4 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "FileGoodies._case_2" [show x3, show x4, show x1, show x5] info)
  _ -> failCons cd (consFail "FileGoodies._case_2" (showCons x5))

d_C__case_3 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_3 x4 x3 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.toCurryString
    ".") (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_reverse cd cs) x3 cd cs)
  Curry_Prelude.C_False -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_reverse cd cs) (Curry_Prelude.d_C_tail x4 cd cs) cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_reverse cd cs) x3 cd cs)
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_3 x4 x3 l cd cs)
    (d_C__case_3 x4 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_3 x4 x3
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_3 x4 x3 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "FileGoodies._case_3" [show x4, show x3, show x5] info)
  _ -> failCons cd (consFail "FileGoodies._case_3" (showCons x5))

