{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE Rank2Types #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module Curry_GetOpt
  ( C_ArgOrder (..)
  , C_OptDescr (..)
  , C_ArgDescr (..)
  , C_OptKind (..)
  , d_C_usageInfo
  , nd_C_usageInfo
  , d_C_getOpt
  , nd_C_getOpt
  , d_C_getOpt'
  , nd_C_getOpt' )
  where

import Basics
import qualified Curry_List
import qualified Curry_Prelude


data C_ArgOrder t0
  = C_RequireOrder
  | C_Permute
  | C_ReturnInOrder (Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
    -> ConstStore -> t0)
  | HO_C_ReturnInOrder (Func (Curry_Prelude.OP_List Curry_Prelude.C_Char) t0)
  | Choice_C_ArgOrder Cover ID (C_ArgOrder t0) (C_ArgOrder t0)
  | Choices_C_ArgOrder Cover ID [C_ArgOrder t0]
  | Fail_C_ArgOrder Cover FailInfo
  | Guard_C_ArgOrder Cover Constraints (C_ArgOrder t0)

instance (Show t0) => Show (C_ArgOrder t0) where
  showsPrec d (Choice_C_ArgOrder cd i x y) = showsChoice d cd i x y
  showsPrec d (Choices_C_ArgOrder cd i xs) = showsChoices d cd i xs
  showsPrec d (Guard_C_ArgOrder cd c e) = showsGuard d cd c e
  showsPrec _ (Fail_C_ArgOrder cd info) = showChar '!'
  showsPrec _ C_RequireOrder = showString "RequireOrder"
  showsPrec _ C_Permute = showString "Permute"
  showsPrec _ (C_ReturnInOrder x1) = showString "(ReturnInOrder" . (showChar
    ' ' . (shows x1 . showChar ')'))
  showsPrec _ (HO_C_ReturnInOrder x1) = showString "(ReturnInOrder" . (showChar
    ' ' . (shows x1 . showChar ')'))

instance (Read t0) => Read (C_ArgOrder t0) where
  readsPrec d s = readParen False (\r -> [(C_RequireOrder, r0) | (_, r0) <-
    readQualified "GetOpt" "RequireOrder" r]) s ++ (readParen False (\r ->
    [(C_Permute, r0) | (_, r0) <- readQualified "GetOpt" "Permute" r]) s ++
    readParen ((>) d 10) (\r -> [(C_ReturnInOrder x1, r1) | (_, r0) <-
    readQualified "GetOpt" "ReturnInOrder" r, (x1, r1) <- readsPrec 11 r0]) s)

instance NonDet (C_ArgOrder t0) where
  choiceCons = Choice_C_ArgOrder
  choicesCons = Choices_C_ArgOrder
  failCons = Fail_C_ArgOrder
  guardCons = Guard_C_ArgOrder
  try (Choice_C_ArgOrder cd i x y) = tryChoice cd i x y
  try (Choices_C_ArgOrder cd i xs) = tryChoices cd i xs
  try (Fail_C_ArgOrder cd info) = Fail cd info
  try (Guard_C_ArgOrder cd c e) = Guard cd c e
  try x = Val x
  match f _ _ _ _ _ (Choice_C_ArgOrder cd i x y) = f cd i x y
  match _ f _ _ _ _ (Choices_C_ArgOrder cd i@(NarrowedID _ _) xs) = f cd i xs
  match _ _ f _ _ _ (Choices_C_ArgOrder cd i@(FreeID _ _) xs) = f cd i xs
  match _ _ _ _ _ _ (Choices_C_ArgOrder cd i _) = error
    ("GetOpt.ArgOrder.match: Choices with ChoiceID " ++ show i)
  match _ _ _ f _ _ (Fail_C_ArgOrder cd info) = f cd info
  match _ _ _ _ f _ (Guard_C_ArgOrder cd c e) = f cd c e
  match _ _ _ _ _ f x = f x

instance (Generable t0) => Generable (C_ArgOrder t0) where
  generate s c = Choices_C_ArgOrder c (freeID [0, 0, 1] s) [C_RequireOrder
    , C_Permute, HO_C_ReturnInOrder (generate (leftSupply s) c)]

instance (NormalForm t0) => NormalForm (C_ArgOrder t0) where
  ($!!) cont C_RequireOrder d cs = cont C_RequireOrder d cs
  ($!!) cont C_Permute d cs = cont C_Permute d cs
  ($!!) cont (C_ReturnInOrder x1) d cs = ($!!) (\y1 d cs -> cont
    (C_ReturnInOrder y1) d cs) x1 d cs
  ($!!) cont (HO_C_ReturnInOrder x1) d cs = ($!!) (\y1 d cs -> cont
    (HO_C_ReturnInOrder y1) d cs) x1 d cs
  ($!!) cont (Choice_C_ArgOrder cd i x y) d cs = nfChoice cont cd i x y cd cs
  ($!!) cont (Choices_C_ArgOrder cd i xs) d cs = nfChoices cont cd i xs d cs
  ($!!) cont (Guard_C_ArgOrder cd c e) d cs = guardCons cd c (($!!) cont e d
    (addCs c cs))
  ($!!) _ (Fail_C_ArgOrder cd info) _ _ = failCons cd info
  ($##) cont C_RequireOrder d cs = cont C_RequireOrder d cs
  ($##) cont C_Permute d cs = cont C_Permute d cs
  ($##) cont (C_ReturnInOrder x1) d cs = ($##) (\y1 d cs -> cont
    (C_ReturnInOrder y1) d cs) x1 d cs
  ($##) cont (HO_C_ReturnInOrder x1) d cs = ($##) (\y1 d cs -> cont
    (HO_C_ReturnInOrder y1) d cs) x1 d cs
  ($##) cont (Choice_C_ArgOrder cd i x y) d cs = gnfChoice cont cd i x y cd cs
  ($##) cont (Choices_C_ArgOrder cd i xs) d cs = gnfChoices cont cd i xs d cs
  ($##) cont (Guard_C_ArgOrder cd c e) d cs = guardCons cd c (($##) cont e d
    (addCs c cs))
  ($##) _ (Fail_C_ArgOrder cd info) _ _ = failCons cd info
  showCons C_RequireOrder = "GetOpt.RequireOrder"
  showCons C_Permute = "GetOpt.Permute"
  showCons (C_ReturnInOrder _) = "GetOpt.ReturnInOrder _"
  showCons (HO_C_ReturnInOrder _) = "GetOpt.ReturnInOrder _"
  showCons x = error ("GetOpt.ArgOrder.showCons: no constructor: " ++ show x)
  searchNF _ cont C_RequireOrder = cont C_RequireOrder
  searchNF _ cont C_Permute = cont C_Permute
  searchNF search cont (C_ReturnInOrder x1) = search (\y1 -> cont
    (C_ReturnInOrder y1)) x1
  searchNF search cont (HO_C_ReturnInOrder x1) = search (\y1 -> cont
    (HO_C_ReturnInOrder y1)) x1
  searchNF _ _ x = error ("GetOpt.ArgOrder.searchNF: no constructor: " ++ show
    x)

instance (Unifiable t0) => Unifiable (C_ArgOrder t0) where
  (=.=) C_RequireOrder C_RequireOrder d cs = C_True
  (=.=) C_Permute C_Permute d cs = C_True
  (=.=) (C_ReturnInOrder x1) (C_ReturnInOrder y1) d cs = (=:=) x1 y1 d cs
  (=.=) (HO_C_ReturnInOrder x1) (HO_C_ReturnInOrder y1) d cs = (=:=) x1 y1 d cs
  (=.=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  (=.<=) C_RequireOrder C_RequireOrder d cs = C_True
  (=.<=) C_Permute C_Permute d cs = C_True
  (=.<=) (C_ReturnInOrder x1) (C_ReturnInOrder y1) d cs = (=:<=) x1 y1 d cs
  (=.<=) (HO_C_ReturnInOrder x1) (HO_C_ReturnInOrder y1) d cs = (=:<=) x1 y1 d
    cs
  (=.<=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  bind cd i C_RequireOrder = (i :=: ChooseN 0 0) : concat []
  bind cd i C_Permute = (i :=: ChooseN 1 0) : concat []
  bind cd i (C_ReturnInOrder x3) = (i :=: ChooseN 2 1) : concat [bind cd (leftID
    i) x3]
  bind cd i (HO_C_ReturnInOrder x3) = (i :=: ChooseN 2 1) : concat [bind cd
    (leftID i) x3]
  bind d i (Choice_C_ArgOrder cd j x y) = [ConstraintChoice cd j (bind d i x)
    (bind d i y)]
  bind d i (Choices_C_ArgOrder cd j@(FreeID _ _) xs) = bindOrNarrow d i cd j xs
  bind d i (Choices_C_ArgOrder cd j@(NarrowedID _ _) xs) = [ConstraintChoices cd
    j (map (bind d i) xs)]
  bind _ _ (Choices_C_ArgOrder cd i _) = error
    ("GetOpt.ArgOrder.bind: Choices with ChoiceID: " ++ show i)
  bind _ _ (Fail_C_ArgOrder cd info) = [Unsolvable info]
  bind d i (Guard_C_ArgOrder cd c e) = getConstrList c ++ bind d i e
  lazyBind cd i C_RequireOrder = (i :=: ChooseN 0 0) : []
  lazyBind cd i C_Permute = (i :=: ChooseN 1 0) : []
  lazyBind cd i (C_ReturnInOrder x3) = (i :=: ChooseN 2 1) : [leftID i :=:
    LazyBind (lazyBind cd (leftID i) x3)]
  lazyBind cd i (HO_C_ReturnInOrder x3) = (i :=: ChooseN 2 1) : [leftID i :=:
    LazyBind (lazyBind cd (leftID i) x3)]
  lazyBind d i (Choice_C_ArgOrder cd j x y) = [ConstraintChoice cd j (lazyBind d
    i x) (lazyBind d i y)]
  lazyBind d i (Choices_C_ArgOrder cd j@(FreeID _ _) xs) = lazyBindOrNarrow d i
    cd j xs
  lazyBind d i (Choices_C_ArgOrder cd j@(NarrowedID _ _) xs) =
    [ConstraintChoices cd j (map (lazyBind d i) xs)]
  lazyBind _ _ (Choices_C_ArgOrder cd i _) = error
    ("GetOpt.ArgOrder.lazyBind: Choices with ChoiceID: " ++ show i)
  lazyBind _ _ (Fail_C_ArgOrder cd info) = [Unsolvable info]
  lazyBind d i (Guard_C_ArgOrder cd c e) = getConstrList c ++ [i :=: LazyBind
    (lazyBind d i e)]

instance (Curry t0) => Curry (C_ArgOrder t0) where

data C_OptDescr t0
  = C_Option (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
    (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (C_ArgDescr t0)
    (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  | Choice_C_OptDescr Cover ID (C_OptDescr t0) (C_OptDescr t0)
  | Choices_C_OptDescr Cover ID [C_OptDescr t0]
  | Fail_C_OptDescr Cover FailInfo
  | Guard_C_OptDescr Cover Constraints (C_OptDescr t0)

instance (Show t0) => Show (C_OptDescr t0) where
  showsPrec d (Choice_C_OptDescr cd i x y) = showsChoice d cd i x y
  showsPrec d (Choices_C_OptDescr cd i xs) = showsChoices d cd i xs
  showsPrec d (Guard_C_OptDescr cd c e) = showsGuard d cd c e
  showsPrec _ (Fail_C_OptDescr cd info) = showChar '!'
  showsPrec _ (C_Option x1 x2 x3 x4) = showString "(Option" . (showChar ' ' .
    (shows x1 . (showChar ' ' . (shows x2 . (showChar ' ' . (shows x3 .
    (showChar ' ' . (shows x4 . showChar ')'))))))))

instance (Read t0) => Read (C_OptDescr t0) where
  readsPrec d s = readParen ((>) d 10) (\r -> [(C_Option x1 x2 x3 x4, r4) | (_
    , r0) <- readQualified "GetOpt" "Option" r, (x1, r1) <- readsPrec 11 r0, (x2
    , r2) <- readsPrec 11 r1, (x3, r3) <- readsPrec 11 r2, (x4, r4) <- readsPrec
    11 r3]) s

instance NonDet (C_OptDescr t0) where
  choiceCons = Choice_C_OptDescr
  choicesCons = Choices_C_OptDescr
  failCons = Fail_C_OptDescr
  guardCons = Guard_C_OptDescr
  try (Choice_C_OptDescr cd i x y) = tryChoice cd i x y
  try (Choices_C_OptDescr cd i xs) = tryChoices cd i xs
  try (Fail_C_OptDescr cd info) = Fail cd info
  try (Guard_C_OptDescr cd c e) = Guard cd c e
  try x = Val x
  match f _ _ _ _ _ (Choice_C_OptDescr cd i x y) = f cd i x y
  match _ f _ _ _ _ (Choices_C_OptDescr cd i@(NarrowedID _ _) xs) = f cd i xs
  match _ _ f _ _ _ (Choices_C_OptDescr cd i@(FreeID _ _) xs) = f cd i xs
  match _ _ _ _ _ _ (Choices_C_OptDescr cd i _) = error
    ("GetOpt.OptDescr.match: Choices with ChoiceID " ++ show i)
  match _ _ _ f _ _ (Fail_C_OptDescr cd info) = f cd info
  match _ _ _ _ f _ (Guard_C_OptDescr cd c e) = f cd c e
  match _ _ _ _ _ f x = f x

instance (Generable t0) => Generable (C_OptDescr t0) where
  generate s c = Choices_C_OptDescr c (freeID [4] s) [C_Option (generate
    (leftSupply (leftSupply s)) c) (generate (rightSupply (leftSupply s)) c)
    (generate (leftSupply (rightSupply s)) c) (generate (rightSupply
    (rightSupply s)) c)]

instance (NormalForm t0) => NormalForm (C_OptDescr t0) where
  ($!!) cont (C_Option x1 x2 x3 x4) d cs = ($!!) (\y1 d cs -> ($!!) (\y2 d cs ->
    ($!!) (\y3 d cs -> ($!!) (\y4 d cs -> cont (C_Option y1 y2 y3 y4) d cs) x4 d
    cs) x3 d cs) x2 d cs) x1 d cs
  ($!!) cont (Choice_C_OptDescr cd i x y) d cs = nfChoice cont cd i x y cd cs
  ($!!) cont (Choices_C_OptDescr cd i xs) d cs = nfChoices cont cd i xs d cs
  ($!!) cont (Guard_C_OptDescr cd c e) d cs = guardCons cd c (($!!) cont e d
    (addCs c cs))
  ($!!) _ (Fail_C_OptDescr cd info) _ _ = failCons cd info
  ($##) cont (C_Option x1 x2 x3 x4) d cs = ($##) (\y1 d cs -> ($##) (\y2 d cs ->
    ($##) (\y3 d cs -> ($##) (\y4 d cs -> cont (C_Option y1 y2 y3 y4) d cs) x4 d
    cs) x3 d cs) x2 d cs) x1 d cs
  ($##) cont (Choice_C_OptDescr cd i x y) d cs = gnfChoice cont cd i x y cd cs
  ($##) cont (Choices_C_OptDescr cd i xs) d cs = gnfChoices cont cd i xs d cs
  ($##) cont (Guard_C_OptDescr cd c e) d cs = guardCons cd c (($##) cont e d
    (addCs c cs))
  ($##) _ (Fail_C_OptDescr cd info) _ _ = failCons cd info
  showCons (C_Option _ _ _ _) = "GetOpt.Option _ _ _ _"
  showCons x = error ("GetOpt.OptDescr.showCons: no constructor: " ++ show x)
  searchNF search cont (C_Option x1 x2 x3 x4) = search (\y1 -> search (\y2 ->
    search (\y3 -> search (\y4 -> cont (C_Option y1 y2 y3 y4)) x4) x3) x2) x1
  searchNF _ _ x = error ("GetOpt.OptDescr.searchNF: no constructor: " ++ show
    x)

instance (Unifiable t0) => Unifiable (C_OptDescr t0) where
  (=.=) (C_Option x1 x2 x3 x4) (C_Option y1 y2 y3 y4) d cs = (&) ((=:=) x1 y1 d
    cs) ((&) ((=:=) x2 y2 d cs) ((&) ((=:=) x3 y3 d cs) ((=:=) x4 y4 d cs) d cs)
    d cs) d cs
  (=.=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  (=.<=) (C_Option x1 x2 x3 x4) (C_Option y1 y2 y3 y4) d cs = (&) ((=:<=) x1 y1
    d cs) ((&) ((=:<=) x2 y2 d cs) ((&) ((=:<=) x3 y3 d cs) ((=:<=) x4 y4 d cs)
    d cs) d cs) d cs
  (=.<=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  bind cd i (C_Option x3 x4 x5 x6) = (i :=: ChooseN 0 4) : concat [bind cd
    (leftID (leftID i)) x3, bind cd (rightID (leftID i)) x4, bind cd (leftID
    (rightID i)) x5, bind cd (rightID (rightID i)) x6]
  bind d i (Choice_C_OptDescr cd j x y) = [ConstraintChoice cd j (bind d i x)
    (bind d i y)]
  bind d i (Choices_C_OptDescr cd j@(FreeID _ _) xs) = bindOrNarrow d i cd j xs
  bind d i (Choices_C_OptDescr cd j@(NarrowedID _ _) xs) = [ConstraintChoices cd
    j (map (bind d i) xs)]
  bind _ _ (Choices_C_OptDescr cd i _) = error
    ("GetOpt.OptDescr.bind: Choices with ChoiceID: " ++ show i)
  bind _ _ (Fail_C_OptDescr cd info) = [Unsolvable info]
  bind d i (Guard_C_OptDescr cd c e) = getConstrList c ++ bind d i e
  lazyBind cd i (C_Option x3 x4 x5 x6) = (i :=: ChooseN 0 4) : [leftID (leftID
    i) :=: LazyBind (lazyBind cd (leftID (leftID i)) x3), rightID (leftID i) :=:
    LazyBind (lazyBind cd (rightID (leftID i)) x4), leftID (rightID i) :=:
    LazyBind (lazyBind cd (leftID (rightID i)) x5), rightID (rightID i) :=:
    LazyBind (lazyBind cd (rightID (rightID i)) x6)]
  lazyBind d i (Choice_C_OptDescr cd j x y) = [ConstraintChoice cd j (lazyBind d
    i x) (lazyBind d i y)]
  lazyBind d i (Choices_C_OptDescr cd j@(FreeID _ _) xs) = lazyBindOrNarrow d i
    cd j xs
  lazyBind d i (Choices_C_OptDescr cd j@(NarrowedID _ _) xs) =
    [ConstraintChoices cd j (map (lazyBind d i) xs)]
  lazyBind _ _ (Choices_C_OptDescr cd i _) = error
    ("GetOpt.OptDescr.lazyBind: Choices with ChoiceID: " ++ show i)
  lazyBind _ _ (Fail_C_OptDescr cd info) = [Unsolvable info]
  lazyBind d i (Guard_C_OptDescr cd c e) = getConstrList c ++ [i :=: LazyBind
    (lazyBind d i e)]

instance (Curry t0) => Curry (C_OptDescr t0) where

data C_ArgDescr t0
  = C_NoArg t0
  | C_ReqArg (Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
    -> t0) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  | HO_C_ReqArg (Func (Curry_Prelude.OP_List Curry_Prelude.C_Char) t0)
    (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  | C_OptArg (Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char)
    -> Cover -> ConstStore -> t0) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  | HO_C_OptArg (Func (Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
    Curry_Prelude.C_Char)) t0) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  | Choice_C_ArgDescr Cover ID (C_ArgDescr t0) (C_ArgDescr t0)
  | Choices_C_ArgDescr Cover ID [C_ArgDescr t0]
  | Fail_C_ArgDescr Cover FailInfo
  | Guard_C_ArgDescr Cover Constraints (C_ArgDescr t0)

instance (Show t0) => Show (C_ArgDescr t0) where
  showsPrec d (Choice_C_ArgDescr cd i x y) = showsChoice d cd i x y
  showsPrec d (Choices_C_ArgDescr cd i xs) = showsChoices d cd i xs
  showsPrec d (Guard_C_ArgDescr cd c e) = showsGuard d cd c e
  showsPrec _ (Fail_C_ArgDescr cd info) = showChar '!'
  showsPrec _ (C_NoArg x1) = showString "(NoArg" . (showChar ' ' . (shows x1 .
    showChar ')'))
  showsPrec _ (C_ReqArg x1 x2) = showString "(ReqArg" . (showChar ' ' . (shows
    x1 . (showChar ' ' . (shows x2 . showChar ')'))))
  showsPrec _ (HO_C_ReqArg x1 x2) = showString "(ReqArg" . (showChar ' ' .
    (shows x1 . (showChar ' ' . (shows x2 . showChar ')'))))
  showsPrec _ (C_OptArg x1 x2) = showString "(OptArg" . (showChar ' ' . (shows
    x1 . (showChar ' ' . (shows x2 . showChar ')'))))
  showsPrec _ (HO_C_OptArg x1 x2) = showString "(OptArg" . (showChar ' ' .
    (shows x1 . (showChar ' ' . (shows x2 . showChar ')'))))

instance (Read t0) => Read (C_ArgDescr t0) where
  readsPrec d s = readParen ((>) d 10) (\r -> [(C_NoArg x1, r1) | (_, r0) <-
    readQualified "GetOpt" "NoArg" r, (x1, r1) <- readsPrec 11 r0]) s ++
    (readParen ((>) d 10) (\r -> [(C_ReqArg x1 x2, r2) | (_, r0) <-
    readQualified "GetOpt" "ReqArg" r, (x1, r1) <- readsPrec 11 r0, (x2, r2) <-
    readsPrec 11 r1]) s ++ readParen ((>) d 10) (\r -> [(C_OptArg x1 x2
    , r2) | (_, r0) <- readQualified "GetOpt" "OptArg" r, (x1, r1) <- readsPrec
    11 r0, (x2, r2) <- readsPrec 11 r1]) s)

instance NonDet (C_ArgDescr t0) where
  choiceCons = Choice_C_ArgDescr
  choicesCons = Choices_C_ArgDescr
  failCons = Fail_C_ArgDescr
  guardCons = Guard_C_ArgDescr
  try (Choice_C_ArgDescr cd i x y) = tryChoice cd i x y
  try (Choices_C_ArgDescr cd i xs) = tryChoices cd i xs
  try (Fail_C_ArgDescr cd info) = Fail cd info
  try (Guard_C_ArgDescr cd c e) = Guard cd c e
  try x = Val x
  match f _ _ _ _ _ (Choice_C_ArgDescr cd i x y) = f cd i x y
  match _ f _ _ _ _ (Choices_C_ArgDescr cd i@(NarrowedID _ _) xs) = f cd i xs
  match _ _ f _ _ _ (Choices_C_ArgDescr cd i@(FreeID _ _) xs) = f cd i xs
  match _ _ _ _ _ _ (Choices_C_ArgDescr cd i _) = error
    ("GetOpt.ArgDescr.match: Choices with ChoiceID " ++ show i)
  match _ _ _ f _ _ (Fail_C_ArgDescr cd info) = f cd info
  match _ _ _ _ f _ (Guard_C_ArgDescr cd c e) = f cd c e
  match _ _ _ _ _ f x = f x

instance (Generable t0) => Generable (C_ArgDescr t0) where
  generate s c = Choices_C_ArgDescr c (freeID [1, 2, 2] s) [C_NoArg (generate
    (leftSupply s) c), HO_C_ReqArg (generate (leftSupply s) c) (generate
    (rightSupply s) c), HO_C_OptArg (generate (leftSupply s) c) (generate
    (rightSupply s) c)]

instance (NormalForm t0) => NormalForm (C_ArgDescr t0) where
  ($!!) cont (C_NoArg x1) d cs = ($!!) (\y1 d cs -> cont (C_NoArg y1) d cs) x1 d
    cs
  ($!!) cont (C_ReqArg x1 x2) d cs = ($!!) (\y1 d cs -> ($!!) (\y2 d cs -> cont
    (C_ReqArg y1 y2) d cs) x2 d cs) x1 d cs
  ($!!) cont (HO_C_ReqArg x1 x2) d cs = ($!!) (\y1 d cs -> ($!!) (\y2 d cs ->
    cont (HO_C_ReqArg y1 y2) d cs) x2 d cs) x1 d cs
  ($!!) cont (C_OptArg x1 x2) d cs = ($!!) (\y1 d cs -> ($!!) (\y2 d cs -> cont
    (C_OptArg y1 y2) d cs) x2 d cs) x1 d cs
  ($!!) cont (HO_C_OptArg x1 x2) d cs = ($!!) (\y1 d cs -> ($!!) (\y2 d cs ->
    cont (HO_C_OptArg y1 y2) d cs) x2 d cs) x1 d cs
  ($!!) cont (Choice_C_ArgDescr cd i x y) d cs = nfChoice cont cd i x y cd cs
  ($!!) cont (Choices_C_ArgDescr cd i xs) d cs = nfChoices cont cd i xs d cs
  ($!!) cont (Guard_C_ArgDescr cd c e) d cs = guardCons cd c (($!!) cont e d
    (addCs c cs))
  ($!!) _ (Fail_C_ArgDescr cd info) _ _ = failCons cd info
  ($##) cont (C_NoArg x1) d cs = ($##) (\y1 d cs -> cont (C_NoArg y1) d cs) x1 d
    cs
  ($##) cont (C_ReqArg x1 x2) d cs = ($##) (\y1 d cs -> ($##) (\y2 d cs -> cont
    (C_ReqArg y1 y2) d cs) x2 d cs) x1 d cs
  ($##) cont (HO_C_ReqArg x1 x2) d cs = ($##) (\y1 d cs -> ($##) (\y2 d cs ->
    cont (HO_C_ReqArg y1 y2) d cs) x2 d cs) x1 d cs
  ($##) cont (C_OptArg x1 x2) d cs = ($##) (\y1 d cs -> ($##) (\y2 d cs -> cont
    (C_OptArg y1 y2) d cs) x2 d cs) x1 d cs
  ($##) cont (HO_C_OptArg x1 x2) d cs = ($##) (\y1 d cs -> ($##) (\y2 d cs ->
    cont (HO_C_OptArg y1 y2) d cs) x2 d cs) x1 d cs
  ($##) cont (Choice_C_ArgDescr cd i x y) d cs = gnfChoice cont cd i x y cd cs
  ($##) cont (Choices_C_ArgDescr cd i xs) d cs = gnfChoices cont cd i xs d cs
  ($##) cont (Guard_C_ArgDescr cd c e) d cs = guardCons cd c (($##) cont e d
    (addCs c cs))
  ($##) _ (Fail_C_ArgDescr cd info) _ _ = failCons cd info
  showCons (C_NoArg _) = "GetOpt.NoArg _"
  showCons (C_ReqArg _ _) = "GetOpt.ReqArg _ _"
  showCons (HO_C_ReqArg _ _) = "GetOpt.ReqArg _ _"
  showCons (C_OptArg _ _) = "GetOpt.OptArg _ _"
  showCons (HO_C_OptArg _ _) = "GetOpt.OptArg _ _"
  showCons x = error ("GetOpt.ArgDescr.showCons: no constructor: " ++ show x)
  searchNF search cont (C_NoArg x1) = search (\y1 -> cont (C_NoArg y1)) x1
  searchNF search cont (C_ReqArg x1 x2) = search (\y1 -> search (\y2 -> cont
    (C_ReqArg y1 y2)) x2) x1
  searchNF search cont (HO_C_ReqArg x1 x2) = search (\y1 -> search (\y2 -> cont
    (HO_C_ReqArg y1 y2)) x2) x1
  searchNF search cont (C_OptArg x1 x2) = search (\y1 -> search (\y2 -> cont
    (C_OptArg y1 y2)) x2) x1
  searchNF search cont (HO_C_OptArg x1 x2) = search (\y1 -> search (\y2 -> cont
    (HO_C_OptArg y1 y2)) x2) x1
  searchNF _ _ x = error ("GetOpt.ArgDescr.searchNF: no constructor: " ++ show
    x)

instance (Unifiable t0) => Unifiable (C_ArgDescr t0) where
  (=.=) (C_NoArg x1) (C_NoArg y1) d cs = (=:=) x1 y1 d cs
  (=.=) (C_ReqArg x1 x2) (C_ReqArg y1 y2) d cs = (&) ((=:=) x1 y1 d cs) ((=:=)
    x2 y2 d cs) d cs
  (=.=) (HO_C_ReqArg x1 x2) (HO_C_ReqArg y1 y2) d cs = (&) ((=:=) x1 y1 d cs)
    ((=:=) x2 y2 d cs) d cs
  (=.=) (C_OptArg x1 x2) (C_OptArg y1 y2) d cs = (&) ((=:=) x1 y1 d cs) ((=:=)
    x2 y2 d cs) d cs
  (=.=) (HO_C_OptArg x1 x2) (HO_C_OptArg y1 y2) d cs = (&) ((=:=) x1 y1 d cs)
    ((=:=) x2 y2 d cs) d cs
  (=.=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  (=.<=) (C_NoArg x1) (C_NoArg y1) d cs = (=:<=) x1 y1 d cs
  (=.<=) (C_ReqArg x1 x2) (C_ReqArg y1 y2) d cs = (&) ((=:<=) x1 y1 d cs)
    ((=:<=) x2 y2 d cs) d cs
  (=.<=) (HO_C_ReqArg x1 x2) (HO_C_ReqArg y1 y2) d cs = (&) ((=:<=) x1 y1 d cs)
    ((=:<=) x2 y2 d cs) d cs
  (=.<=) (C_OptArg x1 x2) (C_OptArg y1 y2) d cs = (&) ((=:<=) x1 y1 d cs)
    ((=:<=) x2 y2 d cs) d cs
  (=.<=) (HO_C_OptArg x1 x2) (HO_C_OptArg y1 y2) d cs = (&) ((=:<=) x1 y1 d cs)
    ((=:<=) x2 y2 d cs) d cs
  (=.<=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  bind cd i (C_NoArg x3) = (i :=: ChooseN 0 1) : concat [bind cd (leftID i) x3]
  bind cd i (C_ReqArg x3 x4) = (i :=: ChooseN 1 2) : concat [bind cd (leftID i)
    x3, bind cd (rightID i) x4]
  bind cd i (HO_C_ReqArg x3 x4) = (i :=: ChooseN 1 2) : concat [bind cd (leftID
    i) x3, bind cd (rightID i) x4]
  bind cd i (C_OptArg x3 x4) = (i :=: ChooseN 2 2) : concat [bind cd (leftID i)
    x3, bind cd (rightID i) x4]
  bind cd i (HO_C_OptArg x3 x4) = (i :=: ChooseN 2 2) : concat [bind cd (leftID
    i) x3, bind cd (rightID i) x4]
  bind d i (Choice_C_ArgDescr cd j x y) = [ConstraintChoice cd j (bind d i x)
    (bind d i y)]
  bind d i (Choices_C_ArgDescr cd j@(FreeID _ _) xs) = bindOrNarrow d i cd j xs
  bind d i (Choices_C_ArgDescr cd j@(NarrowedID _ _) xs) = [ConstraintChoices cd
    j (map (bind d i) xs)]
  bind _ _ (Choices_C_ArgDescr cd i _) = error
    ("GetOpt.ArgDescr.bind: Choices with ChoiceID: " ++ show i)
  bind _ _ (Fail_C_ArgDescr cd info) = [Unsolvable info]
  bind d i (Guard_C_ArgDescr cd c e) = getConstrList c ++ bind d i e
  lazyBind cd i (C_NoArg x3) = (i :=: ChooseN 0 1) : [leftID i :=: LazyBind
    (lazyBind cd (leftID i) x3)]
  lazyBind cd i (C_ReqArg x3 x4) = (i :=: ChooseN 1 2) : [leftID i :=: LazyBind
    (lazyBind cd (leftID i) x3), rightID i :=: LazyBind (lazyBind cd (rightID i)
    x4)]
  lazyBind cd i (HO_C_ReqArg x3 x4) = (i :=: ChooseN 1 2) : [leftID i :=:
    LazyBind (lazyBind cd (leftID i) x3), rightID i :=: LazyBind (lazyBind cd
    (rightID i) x4)]
  lazyBind cd i (C_OptArg x3 x4) = (i :=: ChooseN 2 2) : [leftID i :=: LazyBind
    (lazyBind cd (leftID i) x3), rightID i :=: LazyBind (lazyBind cd (rightID i)
    x4)]
  lazyBind cd i (HO_C_OptArg x3 x4) = (i :=: ChooseN 2 2) : [leftID i :=:
    LazyBind (lazyBind cd (leftID i) x3), rightID i :=: LazyBind (lazyBind cd
    (rightID i) x4)]
  lazyBind d i (Choice_C_ArgDescr cd j x y) = [ConstraintChoice cd j (lazyBind d
    i x) (lazyBind d i y)]
  lazyBind d i (Choices_C_ArgDescr cd j@(FreeID _ _) xs) = lazyBindOrNarrow d i
    cd j xs
  lazyBind d i (Choices_C_ArgDescr cd j@(NarrowedID _ _) xs) =
    [ConstraintChoices cd j (map (lazyBind d i) xs)]
  lazyBind _ _ (Choices_C_ArgDescr cd i _) = error
    ("GetOpt.ArgDescr.lazyBind: Choices with ChoiceID: " ++ show i)
  lazyBind _ _ (Fail_C_ArgDescr cd info) = [Unsolvable info]
  lazyBind d i (Guard_C_ArgDescr cd c e) = getConstrList c ++ [i :=: LazyBind
    (lazyBind d i e)]

instance (Curry t0) => Curry (C_ArgDescr t0) where

data C_OptKind t0
  = C_Opt t0
  | C_UnreqOpt (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  | C_NonOpt (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  | C_EndOfOpts
  | C_OptErr (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  | Choice_C_OptKind Cover ID (C_OptKind t0) (C_OptKind t0)
  | Choices_C_OptKind Cover ID [C_OptKind t0]
  | Fail_C_OptKind Cover FailInfo
  | Guard_C_OptKind Cover Constraints (C_OptKind t0)

instance (Show t0) => Show (C_OptKind t0) where
  showsPrec d (Choice_C_OptKind cd i x y) = showsChoice d cd i x y
  showsPrec d (Choices_C_OptKind cd i xs) = showsChoices d cd i xs
  showsPrec d (Guard_C_OptKind cd c e) = showsGuard d cd c e
  showsPrec _ (Fail_C_OptKind cd info) = showChar '!'
  showsPrec _ (C_Opt x1) = showString "(Opt" . (showChar ' ' . (shows x1 .
    showChar ')'))
  showsPrec _ (C_UnreqOpt x1) = showString "(UnreqOpt" . (showChar ' ' . (shows
    x1 . showChar ')'))
  showsPrec _ (C_NonOpt x1) = showString "(NonOpt" . (showChar ' ' . (shows x1 .
    showChar ')'))
  showsPrec _ C_EndOfOpts = showString "EndOfOpts"
  showsPrec _ (C_OptErr x1) = showString "(OptErr" . (showChar ' ' . (shows x1 .
    showChar ')'))

instance (Read t0) => Read (C_OptKind t0) where
  readsPrec d s = readParen ((>) d 10) (\r -> [(C_Opt x1, r1) | (_, r0) <-
    readQualified "GetOpt" "Opt" r, (x1, r1) <- readsPrec 11 r0]) s ++
    (readParen ((>) d 10) (\r -> [(C_UnreqOpt x1, r1) | (_, r0) <- readQualified
    "GetOpt" "UnreqOpt" r, (x1, r1) <- readsPrec 11 r0]) s ++ (readParen ((>) d
    10) (\r -> [(C_NonOpt x1, r1) | (_, r0) <- readQualified "GetOpt" "NonOpt"
    r, (x1, r1) <- readsPrec 11 r0]) s ++ (readParen False (\r -> [(C_EndOfOpts
    , r0) | (_, r0) <- readQualified "GetOpt" "EndOfOpts" r]) s ++ readParen
    ((>) d 10) (\r -> [(C_OptErr x1, r1) | (_, r0) <- readQualified "GetOpt"
    "OptErr" r, (x1, r1) <- readsPrec 11 r0]) s)))

instance NonDet (C_OptKind t0) where
  choiceCons = Choice_C_OptKind
  choicesCons = Choices_C_OptKind
  failCons = Fail_C_OptKind
  guardCons = Guard_C_OptKind
  try (Choice_C_OptKind cd i x y) = tryChoice cd i x y
  try (Choices_C_OptKind cd i xs) = tryChoices cd i xs
  try (Fail_C_OptKind cd info) = Fail cd info
  try (Guard_C_OptKind cd c e) = Guard cd c e
  try x = Val x
  match f _ _ _ _ _ (Choice_C_OptKind cd i x y) = f cd i x y
  match _ f _ _ _ _ (Choices_C_OptKind cd i@(NarrowedID _ _) xs) = f cd i xs
  match _ _ f _ _ _ (Choices_C_OptKind cd i@(FreeID _ _) xs) = f cd i xs
  match _ _ _ _ _ _ (Choices_C_OptKind cd i _) = error
    ("GetOpt.OptKind.match: Choices with ChoiceID " ++ show i)
  match _ _ _ f _ _ (Fail_C_OptKind cd info) = f cd info
  match _ _ _ _ f _ (Guard_C_OptKind cd c e) = f cd c e
  match _ _ _ _ _ f x = f x

instance (Generable t0) => Generable (C_OptKind t0) where
  generate s c = Choices_C_OptKind c (freeID [1, 1, 1, 0, 1] s) [C_Opt (generate
    (leftSupply s) c), C_UnreqOpt (generate (leftSupply s) c), C_NonOpt
    (generate (leftSupply s) c), C_EndOfOpts, C_OptErr (generate (leftSupply s)
    c)]

instance (NormalForm t0) => NormalForm (C_OptKind t0) where
  ($!!) cont (C_Opt x1) d cs = ($!!) (\y1 d cs -> cont (C_Opt y1) d cs) x1 d cs
  ($!!) cont (C_UnreqOpt x1) d cs = ($!!) (\y1 d cs -> cont (C_UnreqOpt y1) d
    cs) x1 d cs
  ($!!) cont (C_NonOpt x1) d cs = ($!!) (\y1 d cs -> cont (C_NonOpt y1) d cs) x1
    d cs
  ($!!) cont C_EndOfOpts d cs = cont C_EndOfOpts d cs
  ($!!) cont (C_OptErr x1) d cs = ($!!) (\y1 d cs -> cont (C_OptErr y1) d cs) x1
    d cs
  ($!!) cont (Choice_C_OptKind cd i x y) d cs = nfChoice cont cd i x y cd cs
  ($!!) cont (Choices_C_OptKind cd i xs) d cs = nfChoices cont cd i xs d cs
  ($!!) cont (Guard_C_OptKind cd c e) d cs = guardCons cd c (($!!) cont e d
    (addCs c cs))
  ($!!) _ (Fail_C_OptKind cd info) _ _ = failCons cd info
  ($##) cont (C_Opt x1) d cs = ($##) (\y1 d cs -> cont (C_Opt y1) d cs) x1 d cs
  ($##) cont (C_UnreqOpt x1) d cs = ($##) (\y1 d cs -> cont (C_UnreqOpt y1) d
    cs) x1 d cs
  ($##) cont (C_NonOpt x1) d cs = ($##) (\y1 d cs -> cont (C_NonOpt y1) d cs) x1
    d cs
  ($##) cont C_EndOfOpts d cs = cont C_EndOfOpts d cs
  ($##) cont (C_OptErr x1) d cs = ($##) (\y1 d cs -> cont (C_OptErr y1) d cs) x1
    d cs
  ($##) cont (Choice_C_OptKind cd i x y) d cs = gnfChoice cont cd i x y cd cs
  ($##) cont (Choices_C_OptKind cd i xs) d cs = gnfChoices cont cd i xs d cs
  ($##) cont (Guard_C_OptKind cd c e) d cs = guardCons cd c (($##) cont e d
    (addCs c cs))
  ($##) _ (Fail_C_OptKind cd info) _ _ = failCons cd info
  showCons (C_Opt _) = "GetOpt.Opt _"
  showCons (C_UnreqOpt _) = "GetOpt.UnreqOpt _"
  showCons (C_NonOpt _) = "GetOpt.NonOpt _"
  showCons C_EndOfOpts = "GetOpt.EndOfOpts"
  showCons (C_OptErr _) = "GetOpt.OptErr _"
  showCons x = error ("GetOpt.OptKind.showCons: no constructor: " ++ show x)
  searchNF search cont (C_Opt x1) = search (\y1 -> cont (C_Opt y1)) x1
  searchNF search cont (C_UnreqOpt x1) = search (\y1 -> cont (C_UnreqOpt y1)) x1
  searchNF search cont (C_NonOpt x1) = search (\y1 -> cont (C_NonOpt y1)) x1
  searchNF _ cont C_EndOfOpts = cont C_EndOfOpts
  searchNF search cont (C_OptErr x1) = search (\y1 -> cont (C_OptErr y1)) x1
  searchNF _ _ x = error ("GetOpt.OptKind.searchNF: no constructor: " ++ show x)

instance (Unifiable t0) => Unifiable (C_OptKind t0) where
  (=.=) (C_Opt x1) (C_Opt y1) d cs = (=:=) x1 y1 d cs
  (=.=) (C_UnreqOpt x1) (C_UnreqOpt y1) d cs = (=:=) x1 y1 d cs
  (=.=) (C_NonOpt x1) (C_NonOpt y1) d cs = (=:=) x1 y1 d cs
  (=.=) C_EndOfOpts C_EndOfOpts d cs = C_True
  (=.=) (C_OptErr x1) (C_OptErr y1) d cs = (=:=) x1 y1 d cs
  (=.=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  (=.<=) (C_Opt x1) (C_Opt y1) d cs = (=:<=) x1 y1 d cs
  (=.<=) (C_UnreqOpt x1) (C_UnreqOpt y1) d cs = (=:<=) x1 y1 d cs
  (=.<=) (C_NonOpt x1) (C_NonOpt y1) d cs = (=:<=) x1 y1 d cs
  (=.<=) C_EndOfOpts C_EndOfOpts d cs = C_True
  (=.<=) (C_OptErr x1) (C_OptErr y1) d cs = (=:<=) x1 y1 d cs
  (=.<=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  bind cd i (C_Opt x3) = (i :=: ChooseN 0 1) : concat [bind cd (leftID i) x3]
  bind cd i (C_UnreqOpt x3) = (i :=: ChooseN 1 1) : concat [bind cd (leftID i)
    x3]
  bind cd i (C_NonOpt x3) = (i :=: ChooseN 2 1) : concat [bind cd (leftID i) x3]
  bind cd i C_EndOfOpts = (i :=: ChooseN 3 0) : concat []
  bind cd i (C_OptErr x3) = (i :=: ChooseN 4 1) : concat [bind cd (leftID i) x3]
  bind d i (Choice_C_OptKind cd j x y) = [ConstraintChoice cd j (bind d i x)
    (bind d i y)]
  bind d i (Choices_C_OptKind cd j@(FreeID _ _) xs) = bindOrNarrow d i cd j xs
  bind d i (Choices_C_OptKind cd j@(NarrowedID _ _) xs) = [ConstraintChoices cd
    j (map (bind d i) xs)]
  bind _ _ (Choices_C_OptKind cd i _) = error
    ("GetOpt.OptKind.bind: Choices with ChoiceID: " ++ show i)
  bind _ _ (Fail_C_OptKind cd info) = [Unsolvable info]
  bind d i (Guard_C_OptKind cd c e) = getConstrList c ++ bind d i e
  lazyBind cd i (C_Opt x3) = (i :=: ChooseN 0 1) : [leftID i :=: LazyBind
    (lazyBind cd (leftID i) x3)]
  lazyBind cd i (C_UnreqOpt x3) = (i :=: ChooseN 1 1) : [leftID i :=: LazyBind
    (lazyBind cd (leftID i) x3)]
  lazyBind cd i (C_NonOpt x3) = (i :=: ChooseN 2 1) : [leftID i :=: LazyBind
    (lazyBind cd (leftID i) x3)]
  lazyBind cd i C_EndOfOpts = (i :=: ChooseN 3 0) : []
  lazyBind cd i (C_OptErr x3) = (i :=: ChooseN 4 1) : [leftID i :=: LazyBind
    (lazyBind cd (leftID i) x3)]
  lazyBind d i (Choice_C_OptKind cd j x y) = [ConstraintChoice cd j (lazyBind d
    i x) (lazyBind d i y)]
  lazyBind d i (Choices_C_OptKind cd j@(FreeID _ _) xs) = lazyBindOrNarrow d i
    cd j xs
  lazyBind d i (Choices_C_OptKind cd j@(NarrowedID _ _) xs) = [ConstraintChoices
    cd j (map (lazyBind d i) xs)]
  lazyBind _ _ (Choices_C_OptKind cd i _) = error
    ("GetOpt.OptKind.lazyBind: Choices with ChoiceID: " ++ show i)
  lazyBind _ _ (Fail_C_OptKind cd info) = [Unsolvable info]
  lazyBind d i (Guard_C_OptKind cd c e) = getConstrList c ++ [i :=: LazyBind
    (lazyBind d i e)]

instance (Curry t0) => Curry (C_OptKind t0) where

d_C_usageInfo :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (C_OptDescr t0) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_usageInfo x1 x2 cd cs = let x3 = Curry_Prelude.d_C_apply
                                  (Curry_Prelude.d_OP_dot
                                  Curry_Prelude.d_C_unzip3
                                  (Curry_Prelude.d_C_concatMap d_C_fmtOpt cd cs)
                                  cd cs) x2 cd cs
                                x4 = d_OP_usageInfo_dot_uscore_hash_selFP2_hash_ss
                                  x3 cd cs
                                x5 = d_OP_usageInfo_dot_uscore_hash_selFP3_hash_ls
                                  x3 cd cs
                                x6 = d_OP_usageInfo_dot_uscore_hash_selFP4_hash_ds
                                  x3 cd cs
                                x7 = Curry_Prelude.d_C_zipWith3 (acceptCs
                                  (acceptCs id) d_OP_usageInfo_dot_paste_dot_2)
                                  (d_OP_usageInfo_dot_sameLen_dot_2 x4 cd cs)
                                  (d_OP_usageInfo_dot_sameLen_dot_2 x5 cd cs) x6
                                  cd cs
  in Curry_Prelude.d_C_unlines (Curry_Prelude.OP_Cons x1 x7) cd cs

nd_C_usageInfo :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (C_OptDescr t0) -> IDSupply
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
nd_C_usageInfo x1 x2 s cd cs = let s6 = s
  in s6 `seq` (let s4 = leftSupply s6
                   s5 = rightSupply s6
  in s4 `seq` (s5 `seq` (let x3 = let s3 = leftSupply s4
                                      s2 = rightSupply s4
                               in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply
                               (let s1 = leftSupply s2
                                    s0 = rightSupply s2
                               in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot
                               (wrapDX id Curry_Prelude.d_C_unzip3)
                               (Curry_Prelude.nd_C_concatMap (wrapNX id
                               nd_C_fmtOpt) s0 cd cs) s1 cd cs)) x2 s3 cd cs)
                             x4 = d_OP_usageInfo_dot_uscore_hash_selFP2_hash_ss
                               x3 cd cs
                             x5 = d_OP_usageInfo_dot_uscore_hash_selFP3_hash_ls
                               x3 cd cs
                             x6 = d_OP_usageInfo_dot_uscore_hash_selFP4_hash_ds
                               x3 cd cs
                             x7 = Curry_Prelude.nd_C_zipWith3 (wrapDX (wrapDX
                               (wrapDX id)) (acceptCs (acceptCs id)
                               d_OP_usageInfo_dot_paste_dot_2))
                               (d_OP_usageInfo_dot_sameLen_dot_2 x4 cd cs)
                               (d_OP_usageInfo_dot_sameLen_dot_2 x5 cd cs) x6 s5
                               cd cs
  in Curry_Prelude.d_C_unlines (Curry_Prelude.OP_Cons x1 x7) cd cs)))

d_OP_usageInfo_dot_uscore_hash_selFP2_hash_ss :: Curry_Prelude.OP_Tuple3
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_usageInfo_dot_uscore_hash_selFP2_hash_ss x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> x2
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (d_OP_usageInfo_dot_uscore_hash_selFP2_hash_ss l cd cs)
    (d_OP_usageInfo_dot_uscore_hash_selFP2_hash_ss r cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    d_OP_usageInfo_dot_uscore_hash_selFP2_hash_ss z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (d_OP_usageInfo_dot_uscore_hash_selFP2_hash_ss e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "GetOpt.usageInfo._#selFP2#ss" [show x1] info)
  _ -> failCons cd (consFail "GetOpt.usageInfo._#selFP2#ss" (showCons x1))

d_OP_usageInfo_dot_uscore_hash_selFP3_hash_ls :: Curry_Prelude.OP_Tuple3
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_usageInfo_dot_uscore_hash_selFP3_hash_ls x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> x3
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (d_OP_usageInfo_dot_uscore_hash_selFP3_hash_ls l cd cs)
    (d_OP_usageInfo_dot_uscore_hash_selFP3_hash_ls r cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    d_OP_usageInfo_dot_uscore_hash_selFP3_hash_ls z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (d_OP_usageInfo_dot_uscore_hash_selFP3_hash_ls e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "GetOpt.usageInfo._#selFP3#ls" [show x1] info)
  _ -> failCons cd (consFail "GetOpt.usageInfo._#selFP3#ls" (showCons x1))

d_OP_usageInfo_dot_uscore_hash_selFP4_hash_ds :: Curry_Prelude.OP_Tuple3
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_usageInfo_dot_uscore_hash_selFP4_hash_ds x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> x4
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (d_OP_usageInfo_dot_uscore_hash_selFP4_hash_ds l cd cs)
    (d_OP_usageInfo_dot_uscore_hash_selFP4_hash_ds r cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    d_OP_usageInfo_dot_uscore_hash_selFP4_hash_ds z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (d_OP_usageInfo_dot_uscore_hash_selFP4_hash_ds e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "GetOpt.usageInfo._#selFP4#ds" [show x1] info)
  _ -> failCons cd (consFail "GetOpt.usageInfo._#selFP4#ds" (showCons x1))

d_OP_usageInfo_dot_paste_dot_2 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_usageInfo_dot_paste_dot_2 x1 x2 x3 cd cs = Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.toCurryString "  ") (Curry_Prelude.d_OP_plus_plus x1
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "  ")
  (Curry_Prelude.d_OP_plus_plus x2 (Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.toCurryString "  ") x3 cd cs) cd cs) cd cs) cd cs) cd cs

d_OP_usageInfo_dot_flushLeft_dot_2 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_usageInfo_dot_flushLeft_dot_2 x1 x2 cd cs = Curry_Prelude.d_C_map
  (d_OP_usageInfo_dot_flushLeft_dot_2_dot_uscore_hash_lambda1 x1) x2 cd cs

d_OP_usageInfo_dot_flushLeft_dot_2_dot_uscore_hash_lambda1 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_usageInfo_dot_flushLeft_dot_2_dot_uscore_hash_lambda1 x1 x2 cd cs =
  Curry_Prelude.d_C_take x1 (Curry_Prelude.d_OP_plus_plus x2
  (Curry_Prelude.d_C_repeat (Curry_Prelude.C_Char ' '#) cd cs) cd cs) cd cs

d_OP_usageInfo_dot_sameLen_dot_2 :: Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_usageInfo_dot_sameLen_dot_2 x1 cd cs = d_OP_usageInfo_dot_flushLeft_dot_2
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_OP_dot (d_C_maximum
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Int cd
  cs)) (Curry_Prelude.d_C_map Curry_Prelude.d_C_length) cd cs) x1 cd cs) x1 cd
  cs

d_C_maximum :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> Curry_Prelude.OP_List t0
  -> Cover -> ConstStore -> t0
d_C_maximum x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "maximum with empty list") cd cs
  Curry_Prelude.OP_Cons x3 x4 -> Curry_Prelude.d_C_foldl1 (Curry_Prelude.d_C_max
    x1 cd cs) x2 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_maximum x1 l cd cs)
    (d_C_maximum x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_maximum x1 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_maximum x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt.maximum"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "GetOpt.maximum" (showCons x2))

nd_C_maximum :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> Curry_Prelude.OP_List t0
  -> IDSupply -> Cover -> ConstStore -> t0
nd_C_maximum x1 x2 s cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "maximum with empty list") cd cs
  Curry_Prelude.OP_Cons x3 x4 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_foldl1 (Curry_Prelude.nd_C_max x1
    s0 cd cs) x2 s1 cd cs))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C_maximum x1 l s cd cs)
    (nd_C_maximum x1 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C_maximum x1
    z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C_maximum x1 e s cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt.maximum"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "GetOpt.maximum" (showCons x2))

d_C_fmtOpt :: forall t0 . (Curry_Prelude.Curry t0) => C_OptDescr t0 -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple3
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_fmtOpt x1 cd cs = case x1 of
  C_Option x2 x3 x4 x5 -> let x6 = d_OP_fmtOpt_dot_sepBy_dot_19
                                (Curry_Prelude.C_Char ','#)
                                (Curry_Prelude.d_C_map (d_C_fmtShort x4) x2 cd
                                cs) cd cs
                              x7 = d_OP_fmtOpt_dot_sepBy_dot_19
                                (Curry_Prelude.C_Char ','#)
                                (Curry_Prelude.d_C_map (d_C_fmtLong x4) x3 cd
                                cs) cd cs
    in d_C__case_30 x5 x7 x6 (Curry_Prelude.d_C_lines x5 cd cs) cd cs
  Choice_C_OptDescr d i l r -> narrow d i (d_C_fmtOpt l cd cs) (d_C_fmtOpt r cd
    cs)
  Choices_C_OptDescr d i xs -> narrows cs d i (\z -> d_C_fmtOpt z cd cs) xs
  Guard_C_OptDescr d c e -> guardCons d c (d_C_fmtOpt e cd $! addCs c cs)
  Fail_C_OptDescr d info -> failCons d (traceFail "GetOpt.fmtOpt" [show x1]
    info)
  _ -> failCons cd (consFail "GetOpt.fmtOpt" (showCons x1))

nd_C_fmtOpt :: forall t0 . (Curry_Prelude.Curry t0) => C_OptDescr t0 -> IDSupply
  -> Cover -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple3
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C_fmtOpt x1 s cd cs = case x1 of
  C_Option x2 x3 x4 x5 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` (let x6 = d_OP_fmtOpt_dot_sepBy_dot_19
                                 (Curry_Prelude.C_Char ','#)
                                 (Curry_Prelude.nd_C_map (wrapNX id
                                 (nd_C_fmtShort x4)) x2 s0 cd cs) cd cs
                               x7 = d_OP_fmtOpt_dot_sepBy_dot_19
                                 (Curry_Prelude.C_Char ','#)
                                 (Curry_Prelude.nd_C_map (wrapNX id
                                 (nd_C_fmtLong x4)) x3 s1 cd cs) cd cs
    in d_C__case_30 x5 x7 x6 (Curry_Prelude.d_C_lines x5 cd cs) cd cs)))
  Choice_C_OptDescr d i l r -> narrow d i (nd_C_fmtOpt l s cd cs) (nd_C_fmtOpt r
    s cd cs)
  Choices_C_OptDescr d i xs -> narrows cs d i (\z -> nd_C_fmtOpt z s cd cs) xs
  Guard_C_OptDescr d c e -> guardCons d c (nd_C_fmtOpt e s cd $! addCs c cs)
  Fail_C_OptDescr d info -> failCons d (traceFail "GetOpt.fmtOpt" [show x1]
    info)
  _ -> failCons cd (consFail "GetOpt.fmtOpt" (showCons x1))

d_OP_fmtOpt_dot_sepBy_dot_19 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_fmtOpt_dot_sepBy_dot_19 x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x3 x4 -> d_C__case_29 x1 x3 x4 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_fmtOpt_dot_sepBy_dot_19 x1 l cd cs) (d_OP_fmtOpt_dot_sepBy_dot_19 x1 r
    cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_fmtOpt_dot_sepBy_dot_19 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_fmtOpt_dot_sepBy_dot_19 x1 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "GetOpt.fmtOpt.sepBy.19" [show x1, show x2] info)
  _ -> failCons cd (consFail "GetOpt.fmtOpt.sepBy.19" (showCons x2))

d_OP_fmtOpt_dot_uscore_hash_lambda3 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple3
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_fmtOpt_dot_uscore_hash_lambda3 x1 cd cs = Curry_Prelude.OP_Tuple3
  Curry_Prelude.OP_List Curry_Prelude.OP_List x1

d_C_fmtShort :: forall t0 . (Curry_Prelude.Curry t0) => C_ArgDescr t0
  -> Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_fmtShort x1 x2 cd cs = case x1 of
  C_NoArg x3 -> Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "-")
    (Curry_Prelude.OP_Cons x2 Curry_Prelude.OP_List) cd cs
  C_ReqArg x4 x5 -> Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString
    "-") (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.OP_Cons x2
    Curry_Prelude.OP_List) (Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.toCurryString " ") x5 cd cs) cd cs) cd cs
  C_OptArg x6 x7 -> Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString
    "-") (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.OP_Cons x2
    Curry_Prelude.OP_List) (Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.toCurryString "[") (Curry_Prelude.d_OP_plus_plus x7
    (Curry_Prelude.toCurryString "]") cd cs) cd cs) cd cs) cd cs
  Choice_C_ArgDescr d i l r -> narrow d i (d_C_fmtShort l x2 cd cs)
    (d_C_fmtShort r x2 cd cs)
  Choices_C_ArgDescr d i xs -> narrows cs d i (\z -> d_C_fmtShort z x2 cd cs) xs
  Guard_C_ArgDescr d c e -> guardCons d c (d_C_fmtShort e x2 cd $! addCs c cs)
  Fail_C_ArgDescr d info -> failCons d (traceFail "GetOpt.fmtShort" [show x1
    , show x2] info)
  _ -> failCons cd (consFail "GetOpt.fmtShort" (showCons x1))

nd_C_fmtShort :: forall t0 . (Curry_Prelude.Curry t0) => C_ArgDescr t0
  -> Curry_Prelude.C_Char -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
nd_C_fmtShort x1 x2 s cd cs = case x1 of
  C_NoArg x3 -> Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "-")
    (Curry_Prelude.OP_Cons x2 Curry_Prelude.OP_List) cd cs
  HO_C_ReqArg x4 x5 -> Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString
    "-") (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.OP_Cons x2
    Curry_Prelude.OP_List) (Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.toCurryString " ") x5 cd cs) cd cs) cd cs
  HO_C_OptArg x6 x7 -> Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString
    "-") (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.OP_Cons x2
    Curry_Prelude.OP_List) (Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.toCurryString "[") (Curry_Prelude.d_OP_plus_plus x7
    (Curry_Prelude.toCurryString "]") cd cs) cd cs) cd cs) cd cs
  Choice_C_ArgDescr d i l r -> narrow d i (nd_C_fmtShort l x2 s cd cs)
    (nd_C_fmtShort r x2 s cd cs)
  Choices_C_ArgDescr d i xs -> narrows cs d i (\z -> nd_C_fmtShort z x2 s cd cs)
    xs
  Guard_C_ArgDescr d c e -> guardCons d c (nd_C_fmtShort e x2 s cd $! addCs c
    cs)
  Fail_C_ArgDescr d info -> failCons d (traceFail "GetOpt.fmtShort" [show x1
    , show x2] info)
  _ -> failCons cd (consFail "GetOpt.fmtShort" (showCons x1))

d_C_fmtLong :: forall t0 . (Curry_Prelude.Curry t0) => C_ArgDescr t0
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_fmtLong x1 x2 cd cs = case x1 of
  C_NoArg x3 -> Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "--")
    x2 cd cs
  C_ReqArg x4 x5 -> Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString
    "--") (Curry_Prelude.d_OP_plus_plus x2 (Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.toCurryString "=") x5 cd cs) cd cs) cd cs
  C_OptArg x6 x7 -> Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString
    "--") (Curry_Prelude.d_OP_plus_plus x2 (Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.toCurryString "[=") (Curry_Prelude.d_OP_plus_plus x7
    (Curry_Prelude.toCurryString "]") cd cs) cd cs) cd cs) cd cs
  Choice_C_ArgDescr d i l r -> narrow d i (d_C_fmtLong l x2 cd cs) (d_C_fmtLong
    r x2 cd cs)
  Choices_C_ArgDescr d i xs -> narrows cs d i (\z -> d_C_fmtLong z x2 cd cs) xs
  Guard_C_ArgDescr d c e -> guardCons d c (d_C_fmtLong e x2 cd $! addCs c cs)
  Fail_C_ArgDescr d info -> failCons d (traceFail "GetOpt.fmtLong" [show x1
    , show x2] info)
  _ -> failCons cd (consFail "GetOpt.fmtLong" (showCons x1))

nd_C_fmtLong :: forall t0 . (Curry_Prelude.Curry t0) => C_ArgDescr t0
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
nd_C_fmtLong x1 x2 s cd cs = case x1 of
  C_NoArg x3 -> Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "--")
    x2 cd cs
  HO_C_ReqArg x4 x5 -> Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString
    "--") (Curry_Prelude.d_OP_plus_plus x2 (Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.toCurryString "=") x5 cd cs) cd cs) cd cs
  HO_C_OptArg x6 x7 -> Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString
    "--") (Curry_Prelude.d_OP_plus_plus x2 (Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.toCurryString "[=") (Curry_Prelude.d_OP_plus_plus x7
    (Curry_Prelude.toCurryString "]") cd cs) cd cs) cd cs) cd cs
  Choice_C_ArgDescr d i l r -> narrow d i (nd_C_fmtLong l x2 s cd cs)
    (nd_C_fmtLong r x2 s cd cs)
  Choices_C_ArgDescr d i xs -> narrows cs d i (\z -> nd_C_fmtLong z x2 s cd cs)
    xs
  Guard_C_ArgDescr d c e -> guardCons d c (nd_C_fmtLong e x2 s cd $! addCs c cs)
  Fail_C_ArgDescr d info -> failCons d (traceFail "GetOpt.fmtLong" [show x1
    , show x2] info)
  _ -> failCons cd (consFail "GetOpt.fmtLong" (showCons x1))

d_C_getOpt :: forall t0 . (Curry_Prelude.Curry t0) => C_ArgOrder t0
  -> Curry_Prelude.OP_List (C_OptDescr t0) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple3 (Curry_Prelude.OP_List t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_getOpt x1 x2 x3 cd cs = let x4 = d_C_getOpt' x1 x2 x3 cd cs
                                x5 = d_OP_getOpt_dot_uscore_hash_selFP6_hash_os
                                  x4 cd cs
                                x6 = d_OP_getOpt_dot_uscore_hash_selFP7_hash_xs
                                  x4 cd cs
                                x7 = d_OP_getOpt_dot_uscore_hash_selFP8_hash_us
                                  x4 cd cs
                                x8 = d_OP_getOpt_dot_uscore_hash_selFP9_hash_es
                                  x4 cd cs
  in Curry_Prelude.OP_Tuple3 x5 x6 (Curry_Prelude.d_OP_plus_plus x8
  (Curry_Prelude.d_C_map d_C_errUnrec x7 cd cs) cd cs)

nd_C_getOpt :: forall t0 . (Curry_Prelude.Curry t0) => C_ArgOrder t0
  -> Curry_Prelude.OP_List (C_OptDescr t0) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple3 (Curry_Prelude.OP_List t0)
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C_getOpt x1 x2 x3 s cd cs = let s2 = s
  in s2 `seq` (let s0 = leftSupply s2
                   s1 = rightSupply s2
  in s0 `seq` (s1 `seq` (let x4 = nd_C_getOpt' x1 x2 x3 s0 cd cs
                             x5 = d_OP_getOpt_dot_uscore_hash_selFP6_hash_os x4
                               cd cs
                             x6 = d_OP_getOpt_dot_uscore_hash_selFP7_hash_xs x4
                               cd cs
                             x7 = d_OP_getOpt_dot_uscore_hash_selFP8_hash_us x4
                               cd cs
                             x8 = d_OP_getOpt_dot_uscore_hash_selFP9_hash_es x4
                               cd cs
  in Curry_Prelude.OP_Tuple3 x5 x6 (Curry_Prelude.d_OP_plus_plus x8
  (Curry_Prelude.nd_C_map (wrapDX id d_C_errUnrec) x7 s1 cd cs) cd cs))))

d_OP_getOpt_dot_uscore_hash_selFP6_hash_os :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_Tuple4 (Curry_Prelude.OP_List t0)
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List t0
d_OP_getOpt_dot_uscore_hash_selFP6_hash_os x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple4 x2 x3 x4 x5 -> x2
  Curry_Prelude.Choice_OP_Tuple4 d i l r -> narrow d i
    (d_OP_getOpt_dot_uscore_hash_selFP6_hash_os l cd cs)
    (d_OP_getOpt_dot_uscore_hash_selFP6_hash_os r cd cs)
  Curry_Prelude.Choices_OP_Tuple4 d i xs -> narrows cs d i (\z ->
    d_OP_getOpt_dot_uscore_hash_selFP6_hash_os z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple4 d c e -> guardCons d c
    (d_OP_getOpt_dot_uscore_hash_selFP6_hash_os e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple4 d info -> failCons d (traceFail
    "GetOpt.getOpt._#selFP6#os" [show x1] info)
  _ -> failCons cd (consFail "GetOpt.getOpt._#selFP6#os" (showCons x1))

d_OP_getOpt_dot_uscore_hash_selFP7_hash_xs :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_Tuple4 (Curry_Prelude.OP_List t0)
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_getOpt_dot_uscore_hash_selFP7_hash_xs x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple4 x2 x3 x4 x5 -> x3
  Curry_Prelude.Choice_OP_Tuple4 d i l r -> narrow d i
    (d_OP_getOpt_dot_uscore_hash_selFP7_hash_xs l cd cs)
    (d_OP_getOpt_dot_uscore_hash_selFP7_hash_xs r cd cs)
  Curry_Prelude.Choices_OP_Tuple4 d i xs -> narrows cs d i (\z ->
    d_OP_getOpt_dot_uscore_hash_selFP7_hash_xs z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple4 d c e -> guardCons d c
    (d_OP_getOpt_dot_uscore_hash_selFP7_hash_xs e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple4 d info -> failCons d (traceFail
    "GetOpt.getOpt._#selFP7#xs" [show x1] info)
  _ -> failCons cd (consFail "GetOpt.getOpt._#selFP7#xs" (showCons x1))

d_OP_getOpt_dot_uscore_hash_selFP8_hash_us :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_Tuple4 (Curry_Prelude.OP_List t0)
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_getOpt_dot_uscore_hash_selFP8_hash_us x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple4 x2 x3 x4 x5 -> x4
  Curry_Prelude.Choice_OP_Tuple4 d i l r -> narrow d i
    (d_OP_getOpt_dot_uscore_hash_selFP8_hash_us l cd cs)
    (d_OP_getOpt_dot_uscore_hash_selFP8_hash_us r cd cs)
  Curry_Prelude.Choices_OP_Tuple4 d i xs -> narrows cs d i (\z ->
    d_OP_getOpt_dot_uscore_hash_selFP8_hash_us z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple4 d c e -> guardCons d c
    (d_OP_getOpt_dot_uscore_hash_selFP8_hash_us e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple4 d info -> failCons d (traceFail
    "GetOpt.getOpt._#selFP8#us" [show x1] info)
  _ -> failCons cd (consFail "GetOpt.getOpt._#selFP8#us" (showCons x1))

d_OP_getOpt_dot_uscore_hash_selFP9_hash_es :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_Tuple4 (Curry_Prelude.OP_List t0)
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_getOpt_dot_uscore_hash_selFP9_hash_es x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple4 x2 x3 x4 x5 -> x5
  Curry_Prelude.Choice_OP_Tuple4 d i l r -> narrow d i
    (d_OP_getOpt_dot_uscore_hash_selFP9_hash_es l cd cs)
    (d_OP_getOpt_dot_uscore_hash_selFP9_hash_es r cd cs)
  Curry_Prelude.Choices_OP_Tuple4 d i xs -> narrows cs d i (\z ->
    d_OP_getOpt_dot_uscore_hash_selFP9_hash_es z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple4 d c e -> guardCons d c
    (d_OP_getOpt_dot_uscore_hash_selFP9_hash_es e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple4 d info -> failCons d (traceFail
    "GetOpt.getOpt._#selFP9#es" [show x1] info)
  _ -> failCons cd (consFail "GetOpt.getOpt._#selFP9#es" (showCons x1))

d_C_getOpt' :: forall t0 . (Curry_Prelude.Curry t0) => C_ArgOrder t0
  -> Curry_Prelude.OP_List (C_OptDescr t0) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple4 (Curry_Prelude.OP_List t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_getOpt' x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Tuple4 Curry_Prelude.OP_List
    Curry_Prelude.OP_List Curry_Prelude.OP_List Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x4 x5 -> let x6 = d_C_getNext x4 x5 x2 cd cs
                                     x7 = d_OP_getOpt_tick_dot_uscore_hash_selFP16_hash_opt
                                       x6 cd cs
                                     x8 = d_OP_getOpt_tick_dot_uscore_hash_selFP17_hash_rest
                                       x6 cd cs
                                     x9 = d_C_getOpt' x1 x2 x8 cd cs
                                     x10 = d_OP_getOpt_tick_dot_uscore_hash_selFP12_hash_os
                                       x9 cd cs
                                     x11 = d_OP_getOpt_tick_dot_uscore_hash_selFP13_hash_xs
                                       x9 cd cs
                                     x12 = d_OP_getOpt_tick_dot_uscore_hash_selFP14_hash_us
                                       x9 cd cs
                                     x13 = d_OP_getOpt_tick_dot_uscore_hash_selFP15_hash_es
                                       x9 cd cs
    in d_OP_getOpt_tick_dot_procNextOpt_dot_61 x10 x13 x8 x12 x11 x7 x1 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_getOpt' x1 x2 l cd cs)
    (d_C_getOpt' x1 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_getOpt' x1
    x2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_getOpt' x1 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt.getOpt'"
    [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "GetOpt.getOpt'" (showCons x3))

nd_C_getOpt' :: forall t0 . (Curry_Prelude.Curry t0) => C_ArgOrder t0
  -> Curry_Prelude.OP_List (C_OptDescr t0) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple4 (Curry_Prelude.OP_List t0)
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C_getOpt' x1 x2 x3 s cd cs = case x3 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Tuple4 Curry_Prelude.OP_List
    Curry_Prelude.OP_List Curry_Prelude.OP_List Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x4 x5 -> let s3 = s
    in s3 `seq` (let s0 = leftSupply s3
                     s4 = rightSupply s3
                     s1 = leftSupply s4
                     s2 = rightSupply s4
    in s0 `seq` (s4 `seq` (s1 `seq` (s2 `seq` (let x6 = nd_C_getNext x4 x5 x2 s0
                                                     cd cs
                                                   x7 = d_OP_getOpt_tick_dot_uscore_hash_selFP16_hash_opt
                                                     x6 cd cs
                                                   x8 = d_OP_getOpt_tick_dot_uscore_hash_selFP17_hash_rest
                                                     x6 cd cs
                                                   x9 = nd_C_getOpt' x1 x2 x8 s1
                                                     cd cs
                                                   x10 = d_OP_getOpt_tick_dot_uscore_hash_selFP12_hash_os
                                                     x9 cd cs
                                                   x11 = d_OP_getOpt_tick_dot_uscore_hash_selFP13_hash_xs
                                                     x9 cd cs
                                                   x12 = d_OP_getOpt_tick_dot_uscore_hash_selFP14_hash_us
                                                     x9 cd cs
                                                   x13 = d_OP_getOpt_tick_dot_uscore_hash_selFP15_hash_es
                                                     x9 cd cs
    in nd_OP_getOpt_tick_dot_procNextOpt_dot_61 x10 x13 x8 x12 x11 x7 x1 s2 cd
    cs)))))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C_getOpt' x1 x2 l s cd
    cs) (nd_C_getOpt' x1 x2 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C_getOpt' x1
    x2 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C_getOpt' x1 x2 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt.getOpt'"
    [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "GetOpt.getOpt'" (showCons x3))

d_OP_getOpt_tick_dot_uscore_hash_selFP16_hash_opt :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover -> ConstStore
  -> C_OptKind t0
d_OP_getOpt_tick_dot_uscore_hash_selFP16_hash_opt x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_getOpt_tick_dot_uscore_hash_selFP16_hash_opt l cd cs)
    (d_OP_getOpt_tick_dot_uscore_hash_selFP16_hash_opt r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_getOpt_tick_dot_uscore_hash_selFP16_hash_opt z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_getOpt_tick_dot_uscore_hash_selFP16_hash_opt e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "GetOpt.getOpt'._#selFP16#opt" [show x1] info)
  _ -> failCons cd (consFail "GetOpt.getOpt'._#selFP16#opt" (showCons x1))

d_OP_getOpt_tick_dot_uscore_hash_selFP17_hash_rest :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_getOpt_tick_dot_uscore_hash_selFP17_hash_rest x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_getOpt_tick_dot_uscore_hash_selFP17_hash_rest l cd cs)
    (d_OP_getOpt_tick_dot_uscore_hash_selFP17_hash_rest r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_getOpt_tick_dot_uscore_hash_selFP17_hash_rest z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_getOpt_tick_dot_uscore_hash_selFP17_hash_rest e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "GetOpt.getOpt'._#selFP17#rest" [show x1] info)
  _ -> failCons cd (consFail "GetOpt.getOpt'._#selFP17#rest" (showCons x1))

d_OP_getOpt_tick_dot_uscore_hash_selFP12_hash_os :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_Tuple4 (Curry_Prelude.OP_List t0)
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List t0
d_OP_getOpt_tick_dot_uscore_hash_selFP12_hash_os x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple4 x2 x3 x4 x5 -> x2
  Curry_Prelude.Choice_OP_Tuple4 d i l r -> narrow d i
    (d_OP_getOpt_tick_dot_uscore_hash_selFP12_hash_os l cd cs)
    (d_OP_getOpt_tick_dot_uscore_hash_selFP12_hash_os r cd cs)
  Curry_Prelude.Choices_OP_Tuple4 d i xs -> narrows cs d i (\z ->
    d_OP_getOpt_tick_dot_uscore_hash_selFP12_hash_os z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple4 d c e -> guardCons d c
    (d_OP_getOpt_tick_dot_uscore_hash_selFP12_hash_os e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple4 d info -> failCons d (traceFail
    "GetOpt.getOpt'._#selFP12#os" [show x1] info)
  _ -> failCons cd (consFail "GetOpt.getOpt'._#selFP12#os" (showCons x1))

d_OP_getOpt_tick_dot_uscore_hash_selFP13_hash_xs :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_Tuple4 (Curry_Prelude.OP_List t0)
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_getOpt_tick_dot_uscore_hash_selFP13_hash_xs x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple4 x2 x3 x4 x5 -> x3
  Curry_Prelude.Choice_OP_Tuple4 d i l r -> narrow d i
    (d_OP_getOpt_tick_dot_uscore_hash_selFP13_hash_xs l cd cs)
    (d_OP_getOpt_tick_dot_uscore_hash_selFP13_hash_xs r cd cs)
  Curry_Prelude.Choices_OP_Tuple4 d i xs -> narrows cs d i (\z ->
    d_OP_getOpt_tick_dot_uscore_hash_selFP13_hash_xs z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple4 d c e -> guardCons d c
    (d_OP_getOpt_tick_dot_uscore_hash_selFP13_hash_xs e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple4 d info -> failCons d (traceFail
    "GetOpt.getOpt'._#selFP13#xs" [show x1] info)
  _ -> failCons cd (consFail "GetOpt.getOpt'._#selFP13#xs" (showCons x1))

d_OP_getOpt_tick_dot_uscore_hash_selFP14_hash_us :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_Tuple4 (Curry_Prelude.OP_List t0)
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_getOpt_tick_dot_uscore_hash_selFP14_hash_us x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple4 x2 x3 x4 x5 -> x4
  Curry_Prelude.Choice_OP_Tuple4 d i l r -> narrow d i
    (d_OP_getOpt_tick_dot_uscore_hash_selFP14_hash_us l cd cs)
    (d_OP_getOpt_tick_dot_uscore_hash_selFP14_hash_us r cd cs)
  Curry_Prelude.Choices_OP_Tuple4 d i xs -> narrows cs d i (\z ->
    d_OP_getOpt_tick_dot_uscore_hash_selFP14_hash_us z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple4 d c e -> guardCons d c
    (d_OP_getOpt_tick_dot_uscore_hash_selFP14_hash_us e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple4 d info -> failCons d (traceFail
    "GetOpt.getOpt'._#selFP14#us" [show x1] info)
  _ -> failCons cd (consFail "GetOpt.getOpt'._#selFP14#us" (showCons x1))

d_OP_getOpt_tick_dot_uscore_hash_selFP15_hash_es :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_Tuple4 (Curry_Prelude.OP_List t0)
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_getOpt_tick_dot_uscore_hash_selFP15_hash_es x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple4 x2 x3 x4 x5 -> x5
  Curry_Prelude.Choice_OP_Tuple4 d i l r -> narrow d i
    (d_OP_getOpt_tick_dot_uscore_hash_selFP15_hash_es l cd cs)
    (d_OP_getOpt_tick_dot_uscore_hash_selFP15_hash_es r cd cs)
  Curry_Prelude.Choices_OP_Tuple4 d i xs -> narrows cs d i (\z ->
    d_OP_getOpt_tick_dot_uscore_hash_selFP15_hash_es z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple4 d c e -> guardCons d c
    (d_OP_getOpt_tick_dot_uscore_hash_selFP15_hash_es e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple4 d info -> failCons d (traceFail
    "GetOpt.getOpt'._#selFP15#es" [show x1] info)
  _ -> failCons cd (consFail "GetOpt.getOpt'._#selFP15#es" (showCons x1))

d_OP_getOpt_tick_dot_procNextOpt_dot_61 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> C_OptKind t0 -> C_ArgOrder t0
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple4 (Curry_Prelude.OP_List t0)
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_getOpt_tick_dot_procNextOpt_dot_61 x1 x2 x3 x4 x5 x6 x7 cd cs = case x6 of
  C_Opt x8 -> Curry_Prelude.OP_Tuple4 (Curry_Prelude.OP_Cons x8 x1) x5 x4 x2
  C_UnreqOpt x9 -> Curry_Prelude.OP_Tuple4 x1 x5 (Curry_Prelude.OP_Cons x9 x4)
    x2
  C_NonOpt x10 -> d_C__case_28 x2 x4 x5 x1 x10 x3 x7 cd cs
  C_EndOfOpts -> d_C__case_27 x3 x7 cd cs
  C_OptErr x13 -> Curry_Prelude.OP_Tuple4 x1 x5 x4 (Curry_Prelude.OP_Cons x13
    x2)
  Choice_C_OptKind d i l r -> narrow d i
    (d_OP_getOpt_tick_dot_procNextOpt_dot_61 x1 x2 x3 x4 x5 l x7 cd cs)
    (d_OP_getOpt_tick_dot_procNextOpt_dot_61 x1 x2 x3 x4 x5 r x7 cd cs)
  Choices_C_OptKind d i xs -> narrows cs d i (\z ->
    d_OP_getOpt_tick_dot_procNextOpt_dot_61 x1 x2 x3 x4 x5 z x7 cd cs) xs
  Guard_C_OptKind d c e -> guardCons d c
    (d_OP_getOpt_tick_dot_procNextOpt_dot_61 x1 x2 x3 x4 x5 e x7 cd $! addCs c
    cs)
  Fail_C_OptKind d info -> failCons d (traceFail "GetOpt.getOpt'.procNextOpt.61"
    [show x1, show x2, show x3, show x4, show x5, show x6, show x7] info)
  _ -> failCons cd (consFail "GetOpt.getOpt'.procNextOpt.61" (showCons x6))

nd_OP_getOpt_tick_dot_procNextOpt_dot_61 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> C_OptKind t0 -> C_ArgOrder t0
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple4
  (Curry_Prelude.OP_List t0) (Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) (Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) (Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
nd_OP_getOpt_tick_dot_procNextOpt_dot_61 x1 x2 x3 x4 x5 x6 x7 s cd cs =
  case x6 of
  C_Opt x8 -> Curry_Prelude.OP_Tuple4 (Curry_Prelude.OP_Cons x8 x1) x5 x4 x2
  C_UnreqOpt x9 -> Curry_Prelude.OP_Tuple4 x1 x5 (Curry_Prelude.OP_Cons x9 x4)
    x2
  C_NonOpt x10 -> let s0 = s
    in s0 `seq` nd_C__case_28 x2 x4 x5 x1 x10 x3 x7 s0 cd cs
  C_EndOfOpts -> let s0 = s in s0 `seq` nd_C__case_27 x3 x7 s0 cd cs
  C_OptErr x13 -> Curry_Prelude.OP_Tuple4 x1 x5 x4 (Curry_Prelude.OP_Cons x13
    x2)
  Choice_C_OptKind d i l r -> narrow d i
    (nd_OP_getOpt_tick_dot_procNextOpt_dot_61 x1 x2 x3 x4 x5 l x7 s cd cs)
    (nd_OP_getOpt_tick_dot_procNextOpt_dot_61 x1 x2 x3 x4 x5 r x7 s cd cs)
  Choices_C_OptKind d i xs -> narrows cs d i (\z ->
    nd_OP_getOpt_tick_dot_procNextOpt_dot_61 x1 x2 x3 x4 x5 z x7 s cd cs) xs
  Guard_C_OptKind d c e -> guardCons d c
    (nd_OP_getOpt_tick_dot_procNextOpt_dot_61 x1 x2 x3 x4 x5 e x7 s cd $! addCs
    c cs)
  Fail_C_OptKind d info -> failCons d (traceFail "GetOpt.getOpt'.procNextOpt.61"
    [show x1, show x2, show x3, show x4, show x5, show x6, show x7] info)
  _ -> failCons cd (consFail "GetOpt.getOpt'.procNextOpt.61" (showCons x6))

d_C_getNext :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List (C_OptDescr t0) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_getNext x1 x2 x3 cd cs = case x1 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_26 x4 x2 x1 x5 x3
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x4 (Curry_Prelude.C_Char '-'#) cd cs) cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Tuple2 (C_NonOpt x1) x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_getNext l x2 x3 cd cs)
    (d_C_getNext r x2 x3 cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_getNext z x2
    x3 cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_getNext e x2 x3 cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt.getNext"
    [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "GetOpt.getNext" (showCons x1))

nd_C_getNext :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List (C_OptDescr t0) -> IDSupply
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 (C_OptKind t0)
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C_getNext x1 x2 x3 s cd cs = case x1 of
  Curry_Prelude.OP_Cons x4 x5 -> let s0 = s
    in s0 `seq` nd_C__case_26 x4 x2 x1 x5 x3
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x4 (Curry_Prelude.C_Char '-'#) cd cs) s0 cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Tuple2 (C_NonOpt x1) x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C_getNext l x2 x3 s cd
    cs) (nd_C_getNext r x2 x3 s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C_getNext z
    x2 x3 s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C_getNext e x2 x3 s
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt.getNext"
    [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "GetOpt.getNext" (showCons x1))

d_C_longOpt :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List (C_OptDescr t0) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_longOpt x1 x2 x3 cd cs = let x4 = Curry_Prelude.d_C_apply
                                   (Curry_Prelude.d_C_break
                                   (Curry_Prelude.d_C_flip (acceptCs id
                                   Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char)
                                   (Curry_Prelude.C_Char '='#)) cd cs) x1 cd cs
                                 x5 = d_OP_longOpt_dot_uscore_hash_selFP19_hash_opt
                                   x4 cd cs
                                 x6 = d_OP_longOpt_dot_uscore_hash_selFP20_hash_arg
                                   x4 cd cs
                                 x7 = d_OP_longOpt_dot_getWith_dot_97 x5 x3
                                   (acceptCs id
                                   (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                   (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                   cd cs))) cd cs
                                 x8 = d_C__case_22 x7 x3 x5
                                   (Curry_Prelude.d_C_null x7 cd cs) cd cs
                                 x9 = Curry_Prelude.d_C_foldr (acceptCs id
                                   d_OP_longOpt_dot_uscore_hash_lambda11)
                                   Curry_Prelude.OP_List x8 cd cs
                                 x10 = Curry_Prelude.d_OP_plus_plus
                                   (Curry_Prelude.toCurryString "--") x5 cd cs
  in d_OP_longOpt_dot_long_dot_97 x1 x10 x8 x9 x6 x2 cd cs

nd_C_longOpt :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List (C_OptDescr t0) -> IDSupply
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 (C_OptKind t0)
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C_longOpt x1 x2 x3 s cd cs = let s9 = s
  in s9 `seq` (let s10 = leftSupply s9
                   s11 = rightSupply s9
                   s2 = leftSupply s10
                   s5 = rightSupply s10
                   s6 = leftSupply s11
                   s12 = rightSupply s11
                   s7 = leftSupply s12
                   s8 = rightSupply s12
  in s10 `seq` (s11 `seq` (s2 `seq` (s5 `seq` (s6 `seq` (s12 `seq` (s7 `seq`
  (s8 `seq` (let x4 = let s1 = leftSupply s2
                          s0 = rightSupply s2
                   in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply
                   (Curry_Prelude.nd_C_break (wrapNX id (Curry_Prelude.nd_C_flip
                   (wrapDX (wrapDX id) (acceptCs id
                   Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char))
                   (Curry_Prelude.C_Char '='#))) s0 cd cs) x1 s1 cd cs)
                 x5 = d_OP_longOpt_dot_uscore_hash_selFP19_hash_opt x4 cd cs
                 x6 = d_OP_longOpt_dot_uscore_hash_selFP20_hash_arg x4 cd cs
                 x7 = let s4 = leftSupply s5
                          s3 = rightSupply s5
                   in s4 `seq` (s3 `seq` nd_OP_longOpt_dot_getWith_dot_97 x5 x3
                   (wrapDX (wrapNX id) (acceptCs id
                   (Curry_Prelude.nd_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                   (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                   s3 cd cs)))) s4 cd cs)
                 x8 = nd_C__case_22 x7 x3 x5 (Curry_Prelude.d_C_null x7 cd cs)
                   s6 cd cs
                 x9 = Curry_Prelude.nd_C_foldr (wrapDX (wrapNX id) (acceptCs id
                   nd_OP_longOpt_dot_uscore_hash_lambda11))
                   Curry_Prelude.OP_List x8 s7 cd cs
                 x10 = Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString
                   "--") x5 cd cs
  in nd_OP_longOpt_dot_long_dot_97 x1 x10 x8 x9 x6 x2 s8 cd cs)))))))))

d_OP_longOpt_dot_uscore_hash_selFP19_hash_opt :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_longOpt_dot_uscore_hash_selFP19_hash_opt x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_longOpt_dot_uscore_hash_selFP19_hash_opt l cd cs)
    (d_OP_longOpt_dot_uscore_hash_selFP19_hash_opt r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_longOpt_dot_uscore_hash_selFP19_hash_opt z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_longOpt_dot_uscore_hash_selFP19_hash_opt e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "GetOpt.longOpt._#selFP19#opt" [show x1] info)
  _ -> failCons cd (consFail "GetOpt.longOpt._#selFP19#opt" (showCons x1))

d_OP_longOpt_dot_uscore_hash_selFP20_hash_arg :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_longOpt_dot_uscore_hash_selFP20_hash_arg x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_longOpt_dot_uscore_hash_selFP20_hash_arg l cd cs)
    (d_OP_longOpt_dot_uscore_hash_selFP20_hash_arg r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_longOpt_dot_uscore_hash_selFP20_hash_arg z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_longOpt_dot_uscore_hash_selFP20_hash_arg e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "GetOpt.longOpt._#selFP20#arg" [show x1] info)
  _ -> failCons cd (consFail "GetOpt.longOpt._#selFP20#arg" (showCons x1))

d_OP_longOpt_dot_getWith_dot_97 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  (C_OptDescr t0) -> (Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (C_OptDescr t0)
d_OP_longOpt_dot_getWith_dot_97 x1 x2 x3 cd cs = Curry_Prelude.d_C_foldr
  (acceptCs id (d_OP_longOpt_dot_getWith_dot_97_dot_uscore_hash_lambda7 x1 x3))
  Curry_Prelude.OP_List x2 cd cs

nd_OP_longOpt_dot_getWith_dot_97 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  (C_OptDescr t0) -> Func (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) Curry_Prelude.C_Bool) -> IDSupply
  -> Cover -> ConstStore -> Curry_Prelude.OP_List (C_OptDescr t0)
nd_OP_longOpt_dot_getWith_dot_97 x1 x2 x3 s cd cs = let s0 = s
  in s0 `seq` Curry_Prelude.nd_C_foldr (wrapDX (wrapNX id) (acceptCs id
  (nd_OP_longOpt_dot_getWith_dot_97_dot_uscore_hash_lambda7 x1 x3)))
  Curry_Prelude.OP_List x2 s0 cd cs

d_OP_longOpt_dot_getWith_dot_97_dot_uscore_hash_lambda7 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_List Curry_Prelude.C_Char -> (Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Bool)
  -> C_OptDescr t0 -> Curry_Prelude.OP_List (C_OptDescr t0) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (C_OptDescr t0)
d_OP_longOpt_dot_getWith_dot_97_dot_uscore_hash_lambda7 x1 x2 x3 x4 cd cs =
  let x5 = x3 in d_C__case_21 x4 x1 x2 x5 cd cs

nd_OP_longOpt_dot_getWith_dot_97_dot_uscore_hash_lambda7 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_List Curry_Prelude.C_Char -> Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Func (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) Curry_Prelude.C_Bool) -> C_OptDescr t0
  -> Curry_Prelude.OP_List (C_OptDescr t0) -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (C_OptDescr t0)
nd_OP_longOpt_dot_getWith_dot_97_dot_uscore_hash_lambda7 x1 x2 x3 x4 s cd cs =
  let s0 = s in s0 `seq` (let x5 = x3 in nd_C__case_21 x4 x1 x2 x5 s0 cd cs)

d_OP_longOpt_dot_uscore_hash_lambda11 :: forall t0 . (Curry_Prelude.Curry
  t0) => C_OptDescr t0 -> Curry_Prelude.OP_List (C_ArgDescr t0) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (C_ArgDescr t0)
d_OP_longOpt_dot_uscore_hash_lambda11 x1 x2 cd cs = case x1 of
  C_Option x3 x4 x5 x6 -> Curry_Prelude.OP_Cons x5 x2
  Choice_C_OptDescr d i l r -> narrow d i (d_OP_longOpt_dot_uscore_hash_lambda11
    l x2 cd cs) (d_OP_longOpt_dot_uscore_hash_lambda11 r x2 cd cs)
  Choices_C_OptDescr d i xs -> narrows cs d i (\z ->
    d_OP_longOpt_dot_uscore_hash_lambda11 z x2 cd cs) xs
  Guard_C_OptDescr d c e -> guardCons d c (d_OP_longOpt_dot_uscore_hash_lambda11
    e x2 cd $! addCs c cs)
  Fail_C_OptDescr d info -> failCons d (traceFail "GetOpt.longOpt._#lambda11"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "GetOpt.longOpt._#lambda11" (showCons x1))

nd_OP_longOpt_dot_uscore_hash_lambda11 :: forall t0 . (Curry_Prelude.Curry
  t0) => C_OptDescr t0 -> Curry_Prelude.OP_List (C_ArgDescr t0) -> IDSupply
  -> Cover -> ConstStore -> Curry_Prelude.OP_List (C_ArgDescr t0)
nd_OP_longOpt_dot_uscore_hash_lambda11 x1 x2 s cd cs = case x1 of
  C_Option x3 x4 x5 x6 -> Curry_Prelude.OP_Cons x5 x2
  Choice_C_OptDescr d i l r -> narrow d i
    (nd_OP_longOpt_dot_uscore_hash_lambda11 l x2 s cd cs)
    (nd_OP_longOpt_dot_uscore_hash_lambda11 r x2 s cd cs)
  Choices_C_OptDescr d i xs -> narrows cs d i (\z ->
    nd_OP_longOpt_dot_uscore_hash_lambda11 z x2 s cd cs) xs
  Guard_C_OptDescr d c e -> guardCons d c
    (nd_OP_longOpt_dot_uscore_hash_lambda11 e x2 s cd $! addCs c cs)
  Fail_C_OptDescr d info -> failCons d (traceFail "GetOpt.longOpt._#lambda11"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "GetOpt.longOpt._#lambda11" (showCons x1))

d_OP_longOpt_dot_long_dot_97 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (C_OptDescr t0)
  -> Curry_Prelude.OP_List (C_ArgDescr t0) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (C_OptKind t0) (Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_OP_longOpt_dot_long_dot_97 x1 x2 x3 x4 x5 x6 cd cs = d_C__case_19 x6 x5 x4 x1
  x2 x3 (Curry_Prelude.OP_Tuple3 x4 x5 x6) cd cs

nd_OP_longOpt_dot_long_dot_97 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (C_OptDescr t0)
  -> Curry_Prelude.OP_List (C_ArgDescr t0) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_OP_longOpt_dot_long_dot_97 x1 x2 x3 x4 x5 x6 s cd cs = let s0 = s
  in s0 `seq` nd_C__case_19 x6 x5 x4 x1 x2 x3 (Curry_Prelude.OP_Tuple3 x4 x5 x6)
  s0 cd cs

d_C_shortOpt :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (C_OptDescr t0) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 (C_OptKind
  t0) (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_shortOpt x1 x2 x3 x4 cd cs = let x5 = Curry_Prelude.d_C_foldr (acceptCs id
                                       (d_OP_shortOpt_dot_uscore_hash_lambda16
                                       x1)) Curry_Prelude.OP_List x4 cd cs
                                     x6 = Curry_Prelude.d_C_foldr (acceptCs id
                                       d_OP_shortOpt_dot_uscore_hash_lambda21)
                                       Curry_Prelude.OP_List x5 cd cs
                                     x7 = Curry_Prelude.OP_Cons
                                       (Curry_Prelude.C_Char '-'#)
                                       (Curry_Prelude.OP_Cons x1
                                       Curry_Prelude.OP_List)
  in d_OP_shortOpt_dot_short_dot_147 x7 x5 x6 x2 x3 cd cs

nd_C_shortOpt :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (C_OptDescr t0) -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (C_OptKind t0) (Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
nd_C_shortOpt x1 x2 x3 x4 s cd cs = let s3 = s
  in s3 `seq` (let s0 = leftSupply s3
                   s4 = rightSupply s3
                   s1 = leftSupply s4
                   s2 = rightSupply s4
  in s0 `seq` (s4 `seq` (s1 `seq` (s2 `seq` (let x5 = Curry_Prelude.nd_C_foldr
                                                   (wrapDX (wrapNX id) (acceptCs
                                                   id
                                                   (nd_OP_shortOpt_dot_uscore_hash_lambda16
                                                   x1))) Curry_Prelude.OP_List
                                                   x4 s0 cd cs
                                                 x6 = Curry_Prelude.nd_C_foldr
                                                   (wrapDX (wrapNX id) (acceptCs
                                                   id
                                                   nd_OP_shortOpt_dot_uscore_hash_lambda21))
                                                   Curry_Prelude.OP_List x5 s1
                                                   cd cs
                                                 x7 = Curry_Prelude.OP_Cons
                                                   (Curry_Prelude.C_Char '-'#)
                                                   (Curry_Prelude.OP_Cons x1
                                                   Curry_Prelude.OP_List)
  in nd_OP_shortOpt_dot_short_dot_147 x7 x5 x6 x2 x3 s2 cd cs)))))

d_OP_shortOpt_dot_uscore_hash_lambda16 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_Char -> C_OptDescr t0 -> Curry_Prelude.OP_List
  (C_OptDescr t0) -> Cover -> ConstStore -> Curry_Prelude.OP_List (C_OptDescr
  t0)
d_OP_shortOpt_dot_uscore_hash_lambda16 x1 x2 x3 cd cs = let x4 = x2
  in d_C__case_8 x3 x1 x4 cd cs

nd_OP_shortOpt_dot_uscore_hash_lambda16 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_Char -> C_OptDescr t0 -> Curry_Prelude.OP_List
  (C_OptDescr t0) -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (C_OptDescr t0)
nd_OP_shortOpt_dot_uscore_hash_lambda16 x1 x2 x3 s cd cs = let s0 = s
  in s0 `seq` (let x4 = x2 in nd_C__case_8 x3 x1 x4 s0 cd cs)

d_OP_shortOpt_dot_uscore_hash_lambda16_dot_uscore_hash_lambda18 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_Char -> C_OptDescr t0 -> Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (C_OptDescr t0)
d_OP_shortOpt_dot_uscore_hash_lambda16_dot_uscore_hash_lambda18 x1 x2 x3 cd cs =
  d_C__case_7 x3 x1 x2
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
  x1 x3 cd cs) cd cs

nd_OP_shortOpt_dot_uscore_hash_lambda16_dot_uscore_hash_lambda18 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_Char -> C_OptDescr t0 -> Curry_Prelude.C_Char
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_List (C_OptDescr t0)
nd_OP_shortOpt_dot_uscore_hash_lambda16_dot_uscore_hash_lambda18 x1 x2 x3 s cd cs =
  let s0 = s
  in s0 `seq` nd_C__case_7 x3 x1 x2
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
  x1 x3 cd cs) s0 cd cs

d_OP_shortOpt_dot_uscore_hash_lambda21 :: forall t0 . (Curry_Prelude.Curry
  t0) => C_OptDescr t0 -> Curry_Prelude.OP_List (C_ArgDescr t0) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (C_ArgDescr t0)
d_OP_shortOpt_dot_uscore_hash_lambda21 x1 x2 cd cs = case x1 of
  C_Option x3 x4 x5 x6 -> Curry_Prelude.OP_Cons x5 x2
  Choice_C_OptDescr d i l r -> narrow d i
    (d_OP_shortOpt_dot_uscore_hash_lambda21 l x2 cd cs)
    (d_OP_shortOpt_dot_uscore_hash_lambda21 r x2 cd cs)
  Choices_C_OptDescr d i xs -> narrows cs d i (\z ->
    d_OP_shortOpt_dot_uscore_hash_lambda21 z x2 cd cs) xs
  Guard_C_OptDescr d c e -> guardCons d c
    (d_OP_shortOpt_dot_uscore_hash_lambda21 e x2 cd $! addCs c cs)
  Fail_C_OptDescr d info -> failCons d (traceFail "GetOpt.shortOpt._#lambda21"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "GetOpt.shortOpt._#lambda21" (showCons x1))

nd_OP_shortOpt_dot_uscore_hash_lambda21 :: forall t0 . (Curry_Prelude.Curry
  t0) => C_OptDescr t0 -> Curry_Prelude.OP_List (C_ArgDescr t0) -> IDSupply
  -> Cover -> ConstStore -> Curry_Prelude.OP_List (C_ArgDescr t0)
nd_OP_shortOpt_dot_uscore_hash_lambda21 x1 x2 s cd cs = case x1 of
  C_Option x3 x4 x5 x6 -> Curry_Prelude.OP_Cons x5 x2
  Choice_C_OptDescr d i l r -> narrow d i
    (nd_OP_shortOpt_dot_uscore_hash_lambda21 l x2 s cd cs)
    (nd_OP_shortOpt_dot_uscore_hash_lambda21 r x2 s cd cs)
  Choices_C_OptDescr d i xs -> narrows cs d i (\z ->
    nd_OP_shortOpt_dot_uscore_hash_lambda21 z x2 s cd cs) xs
  Guard_C_OptDescr d c e -> guardCons d c
    (nd_OP_shortOpt_dot_uscore_hash_lambda21 e x2 s cd $! addCs c cs)
  Fail_C_OptDescr d info -> failCons d (traceFail "GetOpt.shortOpt._#lambda21"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "GetOpt.shortOpt._#lambda21" (showCons x1))

d_OP_shortOpt_dot_short_dot_147 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  (C_OptDescr t0) -> Curry_Prelude.OP_List (C_ArgDescr t0)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_shortOpt_dot_short_dot_147 x1 x2 x3 x4 x5 cd cs = case x3 of
  Curry_Prelude.OP_List -> d_C__case_6 x5 x1 x4 cd cs
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_5 x5 x1 x2 x8 x4 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_shortOpt_dot_short_dot_147 x1 x2 l x4 x5 cd cs)
    (d_OP_shortOpt_dot_short_dot_147 x1 x2 r x4 x5 cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_shortOpt_dot_short_dot_147 x1 x2 z x4 x5 cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_shortOpt_dot_short_dot_147 x1 x2 e x4 x5 cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "GetOpt.shortOpt.short.147" [show x1, show x2, show x3, show x4, show x5]
    info)
  _ -> failCons cd (consFail "GetOpt.shortOpt.short.147" (showCons x3))

nd_OP_shortOpt_dot_short_dot_147 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  (C_OptDescr t0) -> Curry_Prelude.OP_List (C_ArgDescr t0)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_OP_shortOpt_dot_short_dot_147 x1 x2 x3 x4 x5 s cd cs = case x3 of
  Curry_Prelude.OP_List -> d_C__case_6 x5 x1 x4 cd cs
  Curry_Prelude.OP_Cons x8 x9 -> let s0 = s
    in s0 `seq` nd_C__case_5 x5 x1 x2 x8 x4 x9 s0 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (nd_OP_shortOpt_dot_short_dot_147 x1 x2 l x4 x5 s cd cs)
    (nd_OP_shortOpt_dot_short_dot_147 x1 x2 r x4 x5 s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    nd_OP_shortOpt_dot_short_dot_147 x1 x2 z x4 x5 s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (nd_OP_shortOpt_dot_short_dot_147 x1 x2 e x4 x5 s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "GetOpt.shortOpt.short.147" [show x1, show x2, show x3, show x4, show x5]
    info)
  _ -> failCons cd (consFail "GetOpt.shortOpt.short.147" (showCons x3))

d_C_errAmbig :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (C_OptDescr t0) -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> C_OptKind t0
d_C_errAmbig x1 x2 cd cs = let x3 = Curry_Prelude.d_OP_plus_plus
                                 (Curry_Prelude.toCurryString "option `")
                                 (Curry_Prelude.d_OP_plus_plus x2
                                 (Curry_Prelude.toCurryString
                                 "' is ambiguous; could be one of:") cd cs) cd
                                 cs
  in C_OptErr (d_C_usageInfo x3 x1 cd cs)

nd_C_errAmbig :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (C_OptDescr t0) -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> IDSupply
  -> Cover -> ConstStore -> C_OptKind t0
nd_C_errAmbig x1 x2 s cd cs = let s0 = s
  in s0 `seq` (let x3 = Curry_Prelude.d_OP_plus_plus
                     (Curry_Prelude.toCurryString "option `")
                     (Curry_Prelude.d_OP_plus_plus x2
                     (Curry_Prelude.toCurryString
                     "' is ambiguous; could be one of:") cd cs) cd cs
  in C_OptErr (nd_C_usageInfo x3 x1 s0 cd cs))

d_C_errReq :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> C_OptKind t0
d_C_errReq x1 x2 cd cs = C_OptErr (Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.toCurryString "option `") (Curry_Prelude.d_OP_plus_plus x2
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString
  "' requires an argument ") (Curry_Prelude.d_OP_plus_plus x1
  (Curry_Prelude.toCurryString "\n") cd cs) cd cs) cd cs) cd cs)

d_C_errUnrec :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_errUnrec x1 cd cs = Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.toCurryString "unrecognized option `")
  (Curry_Prelude.d_OP_plus_plus x1 (Curry_Prelude.toCurryString "'\n") cd cs) cd
  cs

d_C_errNoArg :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> C_OptKind t0
d_C_errNoArg x1 cd cs = C_OptErr (Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.toCurryString "option `") (Curry_Prelude.d_OP_plus_plus x1
  (Curry_Prelude.toCurryString "' doesn't allow an argument\n") cd cs) cd cs)

d_C__case_5 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (C_OptDescr t0) -> C_ArgDescr t0
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  (C_ArgDescr t0) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 (C_OptKind
  t0) (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_5 x5 x1 x2 x8 x4 x9 cd cs = case x9 of
  Curry_Prelude.OP_List -> d_C__case_4 x4 x5 x1 x8 cd cs
  Curry_Prelude.OP_Cons x23 x24 -> Curry_Prelude.OP_Tuple2 (d_C_errAmbig x2 x1
    cd cs) x5
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_5 x5 x1 x2 x8 x4
    l cd cs) (d_C__case_5 x5 x1 x2 x8 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_5 x5
    x1 x2 x8 x4 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_5 x5 x1 x2 x8 x4
    e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt._case_5"
    [show x5, show x1, show x2, show x8, show x4, show x9] info)
  _ -> failCons cd (consFail "GetOpt._case_5" (showCons x9))

nd_C__case_5 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (C_OptDescr t0) -> C_ArgDescr t0
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  (C_ArgDescr t0) -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (C_OptKind t0) (Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
nd_C__case_5 x5 x1 x2 x8 x4 x9 s cd cs = case x9 of
  Curry_Prelude.OP_List -> let s0 = s
    in s0 `seq` nd_C__case_4 x4 x5 x1 x8 s0 cd cs
  Curry_Prelude.OP_Cons x23 x24 -> let s0 = s
    in s0 `seq` Curry_Prelude.OP_Tuple2 (nd_C_errAmbig x2 x1 s0 cd cs) x5
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_5 x5 x1 x2 x8
    x4 l s cd cs) (nd_C__case_5 x5 x1 x2 x8 x4 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_5 x5
    x1 x2 x8 x4 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C__case_5 x5 x1 x2 x8
    x4 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt._case_5"
    [show x5, show x1, show x2, show x8, show x4, show x9] info)
  _ -> failCons cd (consFail "GetOpt._case_5" (showCons x9))

d_C__case_4 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> C_ArgDescr t0 -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 (C_OptKind
  t0) (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_4 x4 x5 x1 x8 cd cs = case x8 of
  C_NoArg x10 -> d_C__case_3 x5 x10 x4 cd cs
  C_ReqArg x13 x14 -> d_C__case_2 x5 x13 x1 x14 x4 cd cs
  C_OptArg x19 x20 -> d_C__case_0 x5 x19 x4 cd cs
  Choice_C_ArgDescr d i l r -> narrow d i (d_C__case_4 x4 x5 x1 l cd cs)
    (d_C__case_4 x4 x5 x1 r cd cs)
  Choices_C_ArgDescr d i xs -> narrows cs d i (\z -> d_C__case_4 x4 x5 x1 z cd
    cs) xs
  Guard_C_ArgDescr d c e -> guardCons d c (d_C__case_4 x4 x5 x1 e cd $! addCs c
    cs)
  Fail_C_ArgDescr d info -> failCons d (traceFail "GetOpt._case_4" [show x4
    , show x5, show x1, show x8] info)
  _ -> failCons cd (consFail "GetOpt._case_4" (showCons x8))

nd_C__case_4 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> C_ArgDescr t0 -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (C_OptKind t0) (Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
nd_C__case_4 x4 x5 x1 x8 s cd cs = case x8 of
  C_NoArg x10 -> d_C__case_3 x5 x10 x4 cd cs
  HO_C_ReqArg x13 x14 -> let s0 = s
    in s0 `seq` nd_C__case_2 x5 x13 x1 x14 x4 s0 cd cs
  HO_C_OptArg x19 x20 -> let s0 = s in s0 `seq` nd_C__case_0 x5 x19 x4 s0 cd cs
  Choice_C_ArgDescr d i l r -> narrow d i (nd_C__case_4 x4 x5 x1 l s cd cs)
    (nd_C__case_4 x4 x5 x1 r s cd cs)
  Choices_C_ArgDescr d i xs -> narrows cs d i (\z -> nd_C__case_4 x4 x5 x1 z s
    cd cs) xs
  Guard_C_ArgDescr d c e -> guardCons d c (nd_C__case_4 x4 x5 x1 e s cd $! addCs
    c cs)
  Fail_C_ArgDescr d info -> failCons d (traceFail "GetOpt._case_4" [show x4
    , show x5, show x1, show x8] info)
  _ -> failCons cd (consFail "GetOpt._case_4" (showCons x8))

d_C__case_0 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> (Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore -> t0)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_0 x5 x19 x4 cd cs = case x4 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Tuple2 (C_Opt
    (Curry_Prelude.d_C_apply x19 Curry_Prelude.C_Nothing cd cs)) x5
  Curry_Prelude.OP_Cons x21 x22 -> Curry_Prelude.OP_Tuple2 (C_Opt
    (Curry_Prelude.d_C_apply x19 (Curry_Prelude.C_Just x4) cd cs)) x5
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_0 x5 x19 l cd
    cs) (d_C__case_0 x5 x19 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_0 x5
    x19 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_0 x5 x19 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt._case_0"
    [show x5, show x19, show x4] info)
  _ -> failCons cd (consFail "GetOpt._case_0" (showCons x4))

nd_C__case_0 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Func (Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) t0 -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C__case_0 x5 x19 x4 s cd cs = case x4 of
  Curry_Prelude.OP_List -> let s0 = s
    in s0 `seq` Curry_Prelude.OP_Tuple2 (C_Opt (Curry_Prelude.nd_C_apply x19
    Curry_Prelude.C_Nothing s0 cd cs)) x5
  Curry_Prelude.OP_Cons x21 x22 -> let s0 = s
    in s0 `seq` Curry_Prelude.OP_Tuple2 (C_Opt (Curry_Prelude.nd_C_apply x19
    (Curry_Prelude.C_Just x4) s0 cd cs)) x5
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_0 x5 x19 l s cd
    cs) (nd_C__case_0 x5 x19 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_0 x5
    x19 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C__case_0 x5 x19 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt._case_0"
    [show x5, show x19, show x4] info)
  _ -> failCons cd (consFail "GetOpt._case_0" (showCons x4))

d_C__case_2 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> (Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> t0) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_2 x5 x13 x1 x14 x4 cd cs = case x4 of
  Curry_Prelude.OP_List -> d_C__case_1 x13 x1 x14 x5 cd cs
  Curry_Prelude.OP_Cons x17 x18 -> Curry_Prelude.OP_Tuple2 (C_Opt
    (Curry_Prelude.d_C_apply x13 x4 cd cs)) x5
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_2 x5 x13 x1 x14
    l cd cs) (d_C__case_2 x5 x13 x1 x14 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_2 x5
    x13 x1 x14 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_2 x5 x13 x1 x14
    e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt._case_2"
    [show x5, show x13, show x1, show x14, show x4] info)
  _ -> failCons cd (consFail "GetOpt._case_2" (showCons x4))

nd_C__case_2 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Func (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) t0 -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C__case_2 x5 x13 x1 x14 x4 s cd cs = case x4 of
  Curry_Prelude.OP_List -> let s0 = s
    in s0 `seq` nd_C__case_1 x13 x1 x14 x5 s0 cd cs
  Curry_Prelude.OP_Cons x17 x18 -> let s0 = s
    in s0 `seq` Curry_Prelude.OP_Tuple2 (C_Opt (Curry_Prelude.nd_C_apply x13 x4
    s0 cd cs)) x5
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_2 x5 x13 x1 x14
    l s cd cs) (nd_C__case_2 x5 x13 x1 x14 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_2 x5
    x13 x1 x14 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C__case_2 x5 x13 x1 x14
    e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt._case_2"
    [show x5, show x13, show x1, show x14, show x4] info)
  _ -> failCons cd (consFail "GetOpt._case_2" (showCons x4))

d_C__case_1 :: forall t0 . (Curry_Prelude.Curry t0) => (Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> t0) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_1 x13 x1 x14 x5 cd cs = case x5 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Tuple2 (d_C_errReq x14 x1 cd cs)
    Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x15 x16 -> Curry_Prelude.OP_Tuple2 (C_Opt
    (Curry_Prelude.d_C_apply x13 x15 cd cs)) x16
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_1 x13 x1 x14 l
    cd cs) (d_C__case_1 x13 x1 x14 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_1 x13
    x1 x14 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_1 x13 x1 x14 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt._case_1"
    [show x13, show x1, show x14, show x5] info)
  _ -> failCons cd (consFail "GetOpt._case_1" (showCons x5))

nd_C__case_1 :: forall t0 . (Curry_Prelude.Curry t0) => Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) t0 -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 (C_OptKind t0)
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C__case_1 x13 x1 x14 x5 s cd cs = case x5 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Tuple2 (d_C_errReq x14 x1 cd cs)
    Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x15 x16 -> let s0 = s
    in s0 `seq` Curry_Prelude.OP_Tuple2 (C_Opt (Curry_Prelude.nd_C_apply x13 x15
    s0 cd cs)) x16
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_1 x13 x1 x14 l
    s cd cs) (nd_C__case_1 x13 x1 x14 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_1 x13
    x1 x14 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C__case_1 x13 x1 x14 e
    s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt._case_1"
    [show x13, show x1, show x14, show x5] info)
  _ -> failCons cd (consFail "GetOpt._case_1" (showCons x5))

d_C__case_3 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> t0 -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (C_OptKind t0) (Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C__case_3 x5 x10 x4 cd cs = case x4 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Tuple2 (C_Opt x10) x5
  Curry_Prelude.OP_Cons x11 x12 -> Curry_Prelude.OP_Tuple2 (C_Opt x10)
    (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Cons (Curry_Prelude.C_Char '-'#)
    x4) x5)
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_3 x5 x10 l cd
    cs) (d_C__case_3 x5 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_3 x5
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_3 x5 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt._case_3"
    [show x5, show x10, show x4] info)
  _ -> failCons cd (consFail "GetOpt._case_3" (showCons x4))

d_C__case_6 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_6 x5 x1 x4 cd cs = case x4 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Tuple2 (C_UnreqOpt x1) x5
  Curry_Prelude.OP_Cons x6 x7 -> Curry_Prelude.OP_Tuple2 (C_UnreqOpt x1)
    (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Cons (Curry_Prelude.C_Char '-'#)
    x4) x5)
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_6 x5 x1 l cd cs)
    (d_C__case_6 x5 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_6 x5
    x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_6 x5 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt._case_6"
    [show x5, show x1, show x4] info)
  _ -> failCons cd (consFail "GetOpt._case_6" (showCons x4))

d_C__case_7 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Char
  -> Curry_Prelude.C_Char -> C_OptDescr t0 -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (C_OptDescr t0)
d_C__case_7 x3 x1 x2 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons x2 Curry_Prelude.OP_List
  Curry_Prelude.C_False -> Curry_Prelude.OP_List
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_7 x3 x1 x2 l cd
    cs) (d_C__case_7 x3 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_7 x3 x1
    x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_7 x3 x1 x2 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "GetOpt._case_7"
    [show x3, show x1, show x2, show x4] info)
  _ -> failCons cd (consFail "GetOpt._case_7" (showCons x4))

nd_C__case_7 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Char
  -> Curry_Prelude.C_Char -> C_OptDescr t0 -> Curry_Prelude.C_Bool -> IDSupply
  -> Cover -> ConstStore -> Curry_Prelude.OP_List (C_OptDescr t0)
nd_C__case_7 x3 x1 x2 x4 s cd cs = case x4 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons x2 Curry_Prelude.OP_List
  Curry_Prelude.C_False -> Curry_Prelude.OP_List
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_7 x3 x1 x2 l s
    cd cs) (nd_C__case_7 x3 x1 x2 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_7 x3
    x1 x2 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_7 x3 x1 x2 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "GetOpt._case_7"
    [show x3, show x1, show x2, show x4] info)
  _ -> failCons cd (consFail "GetOpt._case_7" (showCons x4))

d_C__case_8 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (C_OptDescr t0) -> Curry_Prelude.C_Char -> C_OptDescr t0 -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (C_OptDescr t0)
d_C__case_8 x3 x1 x4 cd cs = case x4 of
  C_Option x5 x6 x7 x8 -> Curry_Prelude.d_OP_plus_plus (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_concatMap
    (d_OP_shortOpt_dot_uscore_hash_lambda16_dot_uscore_hash_lambda18 x1 x4) cd
    cs) x5 cd cs) x3 cd cs
  Choice_C_OptDescr d i l r -> narrow d i (d_C__case_8 x3 x1 l cd cs)
    (d_C__case_8 x3 x1 r cd cs)
  Choices_C_OptDescr d i xs -> narrows cs d i (\z -> d_C__case_8 x3 x1 z cd cs)
    xs
  Guard_C_OptDescr d c e -> guardCons d c (d_C__case_8 x3 x1 e cd $! addCs c cs)
  Fail_C_OptDescr d info -> failCons d (traceFail "GetOpt._case_8" [show x3
    , show x1, show x4] info)
  _ -> failCons cd (consFail "GetOpt._case_8" (showCons x4))

nd_C__case_8 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (C_OptDescr t0) -> Curry_Prelude.C_Char -> C_OptDescr t0 -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (C_OptDescr t0)
nd_C__case_8 x3 x1 x4 s cd cs = case x4 of
  C_Option x5 x6 x7 x8 -> let s2 = s
    in s2 `seq` Curry_Prelude.d_OP_plus_plus (let s1 = leftSupply s2
                                                  s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_concatMap
    (wrapNX id (nd_OP_shortOpt_dot_uscore_hash_lambda16_dot_uscore_hash_lambda18
    x1 x4)) s0 cd cs) x5 s1 cd cs)) x3 cd cs
  Choice_C_OptDescr d i l r -> narrow d i (nd_C__case_8 x3 x1 l s cd cs)
    (nd_C__case_8 x3 x1 r s cd cs)
  Choices_C_OptDescr d i xs -> narrows cs d i (\z -> nd_C__case_8 x3 x1 z s cd
    cs) xs
  Guard_C_OptDescr d c e -> guardCons d c (nd_C__case_8 x3 x1 e s cd $! addCs c
    cs)
  Fail_C_OptDescr d info -> failCons d (traceFail "GetOpt._case_8" [show x3
    , show x1, show x4] info)
  _ -> failCons cd (consFail "GetOpt._case_8" (showCons x4))

d_C__case_19 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (C_ArgDescr t0)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (C_OptDescr t0)
  -> Curry_Prelude.OP_Tuple3 (Curry_Prelude.OP_List (C_ArgDescr t0))
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_19 x6 x5 x4 x1 x2 x3 x10 cd cs = case x10 of
  Curry_Prelude.OP_Tuple3 x7 x8 x9 -> d_C__case_18 x9 x1 x8 x2 x3 x7 cd cs
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i (d_C__case_19 x6 x5 x4 x1
    x2 x3 l cd cs) (d_C__case_19 x6 x5 x4 x1 x2 x3 r cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z -> d_C__case_19
    x6 x5 x4 x1 x2 x3 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c (d_C__case_19 x6 x5 x4 x1
    x2 x3 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail "GetOpt._case_19"
    [show x6, show x5, show x4, show x1, show x2, show x3, show x10] info)
  _ -> failCons cd (consFail "GetOpt._case_19" (showCons x10))

nd_C__case_19 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (C_ArgDescr t0)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (C_OptDescr t0)
  -> Curry_Prelude.OP_Tuple3 (Curry_Prelude.OP_List (C_ArgDescr t0))
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C__case_19 x6 x5 x4 x1 x2 x3 x10 s cd cs = case x10 of
  Curry_Prelude.OP_Tuple3 x7 x8 x9 -> let s0 = s
    in s0 `seq` nd_C__case_18 x9 x1 x8 x2 x3 x7 s0 cd cs
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i (nd_C__case_19 x6 x5 x4
    x1 x2 x3 l s cd cs) (nd_C__case_19 x6 x5 x4 x1 x2 x3 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z -> nd_C__case_19
    x6 x5 x4 x1 x2 x3 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c (nd_C__case_19 x6 x5 x4
    x1 x2 x3 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail "GetOpt._case_19"
    [show x6, show x5, show x4, show x1, show x2, show x3, show x10] info)
  _ -> failCons cd (consFail "GetOpt._case_19" (showCons x10))

d_C__case_18 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  (C_OptDescr t0) -> Curry_Prelude.OP_List (C_ArgDescr t0) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_18 x9 x1 x8 x2 x3 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_17 x10 x8 x9 x1 x2 x3 x11 cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Tuple2 (C_UnreqOpt
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "--") x1 cd cs))
    x9
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_18 x9 x1 x8 x2
    x3 l cd cs) (d_C__case_18 x9 x1 x8 x2 x3 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_18 x9
    x1 x8 x2 x3 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_18 x9 x1 x8 x2
    x3 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt._case_18"
    [show x9, show x1, show x8, show x2, show x3, show x7] info)
  _ -> failCons cd (consFail "GetOpt._case_18" (showCons x7))

nd_C__case_18 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  (C_OptDescr t0) -> Curry_Prelude.OP_List (C_ArgDescr t0) -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C__case_18 x9 x1 x8 x2 x3 x7 s cd cs = case x7 of
  Curry_Prelude.OP_Cons x10 x11 -> let s0 = s
    in s0 `seq` nd_C__case_17 x10 x8 x9 x1 x2 x3 x11 s0 cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Tuple2 (C_UnreqOpt
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "--") x1 cd cs))
    x9
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_18 x9 x1 x8 x2
    x3 l s cd cs) (nd_C__case_18 x9 x1 x8 x2 x3 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_18 x9
    x1 x8 x2 x3 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C__case_18 x9 x1 x8 x2
    x3 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt._case_18"
    [show x9, show x1, show x8, show x2, show x3, show x7] info)
  _ -> failCons cd (consFail "GetOpt._case_18" (showCons x7))

d_C__case_17 :: forall t0 . (Curry_Prelude.Curry t0) => C_ArgDescr t0
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (C_OptDescr t0) -> Curry_Prelude.OP_List (C_ArgDescr
  t0) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 (C_OptKind t0)
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_17 x10 x8 x9 x1 x2 x3 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> Curry_Prelude.OP_Tuple2 (d_C_errAmbig x3 x2
    cd cs) x9
  Curry_Prelude.OP_List -> d_C__case_16 x8 x9 x1 x2 x10 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_17 x10 x8 x9 x1
    x2 x3 l cd cs) (d_C__case_17 x10 x8 x9 x1 x2 x3 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_17 x10
    x8 x9 x1 x2 x3 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_17 x10 x8 x9 x1
    x2 x3 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt._case_17"
    [show x10, show x8, show x9, show x1, show x2, show x3, show x11] info)
  _ -> failCons cd (consFail "GetOpt._case_17" (showCons x11))

nd_C__case_17 :: forall t0 . (Curry_Prelude.Curry t0) => C_ArgDescr t0
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (C_OptDescr t0) -> Curry_Prelude.OP_List (C_ArgDescr
  t0) -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 (C_OptKind
  t0) (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C__case_17 x10 x8 x9 x1 x2 x3 x11 s cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> let s0 = s
    in s0 `seq` Curry_Prelude.OP_Tuple2 (nd_C_errAmbig x3 x2 s0 cd cs) x9
  Curry_Prelude.OP_List -> let s0 = s
    in s0 `seq` nd_C__case_16 x8 x9 x1 x2 x10 s0 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_17 x10 x8 x9 x1
    x2 x3 l s cd cs) (nd_C__case_17 x10 x8 x9 x1 x2 x3 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_17
    x10 x8 x9 x1 x2 x3 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C__case_17 x10 x8 x9 x1
    x2 x3 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt._case_17"
    [show x10, show x8, show x9, show x1, show x2, show x3, show x11] info)
  _ -> failCons cd (consFail "GetOpt._case_17" (showCons x11))

d_C__case_16 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> C_ArgDescr t0 -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_16 x8 x9 x1 x2 x10 cd cs = case x10 of
  C_NoArg x14 -> d_C__case_15 x9 x1 x2 x14 x8 cd cs
  C_ReqArg x17 x18 -> d_C__case_13 x9 x1 x17 x2 x18 x8 cd cs
  C_OptArg x23 x24 -> d_C__case_10 x9 x1 x23 x8 cd cs
  Choice_C_ArgDescr d i l r -> narrow d i (d_C__case_16 x8 x9 x1 x2 l cd cs)
    (d_C__case_16 x8 x9 x1 x2 r cd cs)
  Choices_C_ArgDescr d i xs -> narrows cs d i (\z -> d_C__case_16 x8 x9 x1 x2 z
    cd cs) xs
  Guard_C_ArgDescr d c e -> guardCons d c (d_C__case_16 x8 x9 x1 x2 e cd $!
    addCs c cs)
  Fail_C_ArgDescr d info -> failCons d (traceFail "GetOpt._case_16" [show x8
    , show x9, show x1, show x2, show x10] info)
  _ -> failCons cd (consFail "GetOpt._case_16" (showCons x10))

nd_C__case_16 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> C_ArgDescr t0 -> IDSupply
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 (C_OptKind t0)
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C__case_16 x8 x9 x1 x2 x10 s cd cs = case x10 of
  C_NoArg x14 -> d_C__case_15 x9 x1 x2 x14 x8 cd cs
  HO_C_ReqArg x17 x18 -> let s0 = s
    in s0 `seq` nd_C__case_13 x9 x1 x17 x2 x18 x8 s0 cd cs
  HO_C_OptArg x23 x24 -> let s0 = s
    in s0 `seq` nd_C__case_10 x9 x1 x23 x8 s0 cd cs
  Choice_C_ArgDescr d i l r -> narrow d i (nd_C__case_16 x8 x9 x1 x2 l s cd cs)
    (nd_C__case_16 x8 x9 x1 x2 r s cd cs)
  Choices_C_ArgDescr d i xs -> narrows cs d i (\z -> nd_C__case_16 x8 x9 x1 x2 z
    s cd cs) xs
  Guard_C_ArgDescr d c e -> guardCons d c (nd_C__case_16 x8 x9 x1 x2 e s cd $!
    addCs c cs)
  Fail_C_ArgDescr d info -> failCons d (traceFail "GetOpt._case_16" [show x8
    , show x9, show x1, show x2, show x10] info)
  _ -> failCons cd (consFail "GetOpt._case_16" (showCons x10))

d_C__case_10 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> (Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> t0) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (C_OptKind t0) (Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C__case_10 x9 x1 x23 x8 cd cs = case x8 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Tuple2 (C_Opt
    (Curry_Prelude.d_C_apply x23 Curry_Prelude.C_Nothing cd cs)) x9
  Curry_Prelude.OP_Cons x25 x26 -> d_C__case_9 x25 x9 x1 x26 x23
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x25 (Curry_Prelude.C_Char '='#) cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_10 x9 x1 x23 l
    cd cs) (d_C__case_10 x9 x1 x23 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_10 x9
    x1 x23 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_10 x9 x1 x23 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt._case_10"
    [show x9, show x1, show x23, show x8] info)
  _ -> failCons cd (consFail "GetOpt._case_10" (showCons x8))

nd_C__case_10 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Func (Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) t0 -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 (C_OptKind t0)
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C__case_10 x9 x1 x23 x8 s cd cs = case x8 of
  Curry_Prelude.OP_List -> let s0 = s
    in s0 `seq` Curry_Prelude.OP_Tuple2 (C_Opt (Curry_Prelude.nd_C_apply x23
    Curry_Prelude.C_Nothing s0 cd cs)) x9
  Curry_Prelude.OP_Cons x25 x26 -> let s0 = s
    in s0 `seq` nd_C__case_9 x25 x9 x1 x26 x23
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x25 (Curry_Prelude.C_Char '='#) cd cs) s0 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_10 x9 x1 x23 l
    s cd cs) (nd_C__case_10 x9 x1 x23 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_10 x9
    x1 x23 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C__case_10 x9 x1 x23 e
    s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt._case_10"
    [show x9, show x1, show x23, show x8] info)
  _ -> failCons cd (consFail "GetOpt._case_10" (showCons x8))

d_C__case_9 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> (Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> t0) -> Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 (C_OptKind t0)
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_9 x25 x9 x1 x26 x23 x27 cd cs = case x27 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Tuple2 (C_Opt
    (Curry_Prelude.d_C_apply x23 (Curry_Prelude.C_Just x26) cd cs)) x9
  Curry_Prelude.C_False -> Curry_Prelude.OP_Tuple2 (C_UnreqOpt
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "--") x1 cd cs))
    x9
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_9 x25 x9 x1 x26
    x23 l cd cs) (d_C__case_9 x25 x9 x1 x26 x23 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_9 x25
    x9 x1 x26 x23 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_9 x25 x9 x1 x26
    x23 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "GetOpt._case_9"
    [show x25, show x9, show x1, show x26, show x23, show x27] info)
  _ -> failCons cd (consFail "GetOpt._case_9" (showCons x27))

nd_C__case_9 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Func (Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) t0 -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C__case_9 x25 x9 x1 x26 x23 x27 s cd cs = case x27 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` Curry_Prelude.OP_Tuple2 (C_Opt (Curry_Prelude.nd_C_apply x23
    (Curry_Prelude.C_Just x26) s0 cd cs)) x9
  Curry_Prelude.C_False -> Curry_Prelude.OP_Tuple2 (C_UnreqOpt
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "--") x1 cd cs))
    x9
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_9 x25 x9 x1 x26
    x23 l s cd cs) (nd_C__case_9 x25 x9 x1 x26 x23 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_9 x25
    x9 x1 x26 x23 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_9 x25 x9 x1 x26
    x23 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "GetOpt._case_9"
    [show x25, show x9, show x1, show x26, show x23, show x27] info)
  _ -> failCons cd (consFail "GetOpt._case_9" (showCons x27))

d_C__case_13 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> (Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> t0) -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (C_OptKind t0) (Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C__case_13 x9 x1 x17 x2 x18 x8 cd cs = case x8 of
  Curry_Prelude.OP_List -> d_C__case_12 x17 x2 x18 x9 cd cs
  Curry_Prelude.OP_Cons x21 x22 -> d_C__case_11 x21 x9 x1 x22 x17
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x21 (Curry_Prelude.C_Char '='#) cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_13 x9 x1 x17 x2
    x18 l cd cs) (d_C__case_13 x9 x1 x17 x2 x18 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_13 x9
    x1 x17 x2 x18 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_13 x9 x1 x17 x2
    x18 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt._case_13"
    [show x9, show x1, show x17, show x2, show x18, show x8] info)
  _ -> failCons cd (consFail "GetOpt._case_13" (showCons x8))

nd_C__case_13 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Func (Curry_Prelude.OP_List Curry_Prelude.C_Char) t0
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> IDSupply
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 (C_OptKind t0)
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C__case_13 x9 x1 x17 x2 x18 x8 s cd cs = case x8 of
  Curry_Prelude.OP_List -> let s0 = s
    in s0 `seq` nd_C__case_12 x17 x2 x18 x9 s0 cd cs
  Curry_Prelude.OP_Cons x21 x22 -> let s0 = s
    in s0 `seq` nd_C__case_11 x21 x9 x1 x22 x17
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x21 (Curry_Prelude.C_Char '='#) cd cs) s0 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_13 x9 x1 x17 x2
    x18 l s cd cs) (nd_C__case_13 x9 x1 x17 x2 x18 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_13 x9
    x1 x17 x2 x18 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C__case_13 x9 x1 x17 x2
    x18 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt._case_13"
    [show x9, show x1, show x17, show x2, show x18, show x8] info)
  _ -> failCons cd (consFail "GetOpt._case_13" (showCons x8))

d_C__case_11 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> (Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> t0) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_11 x21 x9 x1 x22 x17 x23 cd cs = case x23 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Tuple2 (C_Opt
    (Curry_Prelude.d_C_apply x17 x22 cd cs)) x9
  Curry_Prelude.C_False -> Curry_Prelude.OP_Tuple2 (C_UnreqOpt
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "--") x1 cd cs))
    x9
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_11 x21 x9 x1 x22
    x17 l cd cs) (d_C__case_11 x21 x9 x1 x22 x17 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_11 x21
    x9 x1 x22 x17 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_11 x21 x9 x1 x22
    x17 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "GetOpt._case_11"
    [show x21, show x9, show x1, show x22, show x17, show x23] info)
  _ -> failCons cd (consFail "GetOpt._case_11" (showCons x23))

nd_C__case_11 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Func (Curry_Prelude.OP_List Curry_Prelude.C_Char) t0
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C__case_11 x21 x9 x1 x22 x17 x23 s cd cs = case x23 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` Curry_Prelude.OP_Tuple2 (C_Opt (Curry_Prelude.nd_C_apply x17 x22
    s0 cd cs)) x9
  Curry_Prelude.C_False -> Curry_Prelude.OP_Tuple2 (C_UnreqOpt
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "--") x1 cd cs))
    x9
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_11 x21 x9 x1 x22
    x17 l s cd cs) (nd_C__case_11 x21 x9 x1 x22 x17 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_11 x21
    x9 x1 x22 x17 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_11 x21 x9 x1 x22
    x17 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "GetOpt._case_11"
    [show x21, show x9, show x1, show x22, show x17, show x23] info)
  _ -> failCons cd (consFail "GetOpt._case_11" (showCons x23))

d_C__case_12 :: forall t0 . (Curry_Prelude.Curry t0) => (Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> t0) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_12 x17 x2 x18 x9 cd cs = case x9 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Tuple2 (d_C_errReq x18 x2 cd cs)
    Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x19 x20 -> Curry_Prelude.OP_Tuple2 (C_Opt
    (Curry_Prelude.d_C_apply x17 x19 cd cs)) x20
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_12 x17 x2 x18 l
    cd cs) (d_C__case_12 x17 x2 x18 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_12 x17
    x2 x18 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_12 x17 x2 x18 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt._case_12"
    [show x17, show x2, show x18, show x9] info)
  _ -> failCons cd (consFail "GetOpt._case_12" (showCons x9))

nd_C__case_12 :: forall t0 . (Curry_Prelude.Curry t0) => Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) t0 -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 (C_OptKind t0)
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C__case_12 x17 x2 x18 x9 s cd cs = case x9 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Tuple2 (d_C_errReq x18 x2 cd cs)
    Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x19 x20 -> let s0 = s
    in s0 `seq` Curry_Prelude.OP_Tuple2 (C_Opt (Curry_Prelude.nd_C_apply x17 x19
    s0 cd cs)) x20
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_12 x17 x2 x18 l
    s cd cs) (nd_C__case_12 x17 x2 x18 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_12
    x17 x2 x18 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C__case_12 x17 x2 x18 e
    s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt._case_12"
    [show x17, show x2, show x18, show x9] info)
  _ -> failCons cd (consFail "GetOpt._case_12" (showCons x9))

d_C__case_15 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> t0
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_15 x9 x1 x2 x14 x8 cd cs = case x8 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Tuple2 (C_Opt x14) x9
  Curry_Prelude.OP_Cons x15 x16 -> d_C__case_14 x15 x9 x1 x2
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x15 (Curry_Prelude.C_Char '='#) cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_15 x9 x1 x2 x14
    l cd cs) (d_C__case_15 x9 x1 x2 x14 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_15 x9
    x1 x2 x14 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_15 x9 x1 x2 x14
    e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt._case_15"
    [show x9, show x1, show x2, show x14, show x8] info)
  _ -> failCons cd (consFail "GetOpt._case_15" (showCons x8))

d_C__case_14 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_14 x15 x9 x1 x2 x16 cd cs = case x16 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Tuple2 (d_C_errNoArg x2 cd cs) x9
  Curry_Prelude.C_False -> Curry_Prelude.OP_Tuple2 (C_UnreqOpt
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "--") x1 cd cs))
    x9
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_14 x15 x9 x1 x2 l
    cd cs) (d_C__case_14 x15 x9 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_14 x15
    x9 x1 x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_14 x15 x9 x1 x2 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "GetOpt._case_14"
    [show x15, show x9, show x1, show x2, show x16] info)
  _ -> failCons cd (consFail "GetOpt._case_14" (showCons x16))

d_C__case_21 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (C_OptDescr t0) -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> (Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool) -> C_OptDescr t0 -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (C_OptDescr t0)
d_C__case_21 x4 x1 x2 x5 cd cs = case x5 of
  C_Option x6 x7 x8 x9 -> Curry_Prelude.d_OP_plus_plus (d_C__case_20 x7 x1 x2 x5
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Maybe
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) cd cs) (Curry_Prelude.d_C_apply (Curry_List.d_C_find
    (Curry_Prelude.d_C_apply x2 x1 cd cs) cd cs) x7 cd cs) cd cs)
    Curry_Prelude.C_Nothing cd cs) cd cs) x4 cd cs
  Choice_C_OptDescr d i l r -> narrow d i (d_C__case_21 x4 x1 x2 l cd cs)
    (d_C__case_21 x4 x1 x2 r cd cs)
  Choices_C_OptDescr d i xs -> narrows cs d i (\z -> d_C__case_21 x4 x1 x2 z cd
    cs) xs
  Guard_C_OptDescr d c e -> guardCons d c (d_C__case_21 x4 x1 x2 e cd $! addCs c
    cs)
  Fail_C_OptDescr d info -> failCons d (traceFail "GetOpt._case_21" [show x4
    , show x1, show x2, show x5] info)
  _ -> failCons cd (consFail "GetOpt._case_21" (showCons x5))

nd_C__case_21 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (C_OptDescr t0) -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Func (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) Curry_Prelude.C_Bool) -> C_OptDescr t0 -> IDSupply
  -> Cover -> ConstStore -> Curry_Prelude.OP_List (C_OptDescr t0)
nd_C__case_21 x4 x1 x2 x5 s cd cs = case x5 of
  C_Option x6 x7 x8 x9 -> let s16 = s
    in s16 `seq` Curry_Prelude.d_OP_plus_plus (let s15 = leftSupply s16
                                                   s14 = rightSupply s16
    in s15 `seq` (s14 `seq` nd_C__case_20 x7 x1 x2 x5 (let s13 = leftSupply s14
                                                           s11 = rightSupply s14
    in s13 `seq` (s11 `seq` Curry_Prelude.nd_C_apply (let s10 = leftSupply s11
                                                          s12 = rightSupply s11
                                                          s4 = leftSupply s12
                                                          s9 = rightSupply s12
    in s10 `seq` (s12 `seq` (s4 `seq` (s9 `seq` Curry_Prelude.nd_C_apply
    (let s3 = leftSupply s4
         s2 = rightSupply s4
    in s3 `seq` (s2 `seq`
    Curry_Prelude.nd_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Maybe
    (let s1 = leftSupply s2
         s0 = rightSupply s2
    in s1 `seq` (s0 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    s0 cd cs) s1 cd cs)) s3 cd cs)) (let s8 = leftSupply s9
                                         s7 = rightSupply s9
    in s8 `seq` (s7 `seq` Curry_Prelude.nd_C_apply (let s6 = leftSupply s7
                                                        s5 = rightSupply s7
    in s6 `seq` (s5 `seq` Curry_List.nd_C_find (Curry_Prelude.nd_C_apply x2 x1
    s5 cd cs) s6 cd cs)) x7 s8 cd cs)) s10 cd cs)))) Curry_Prelude.C_Nothing s13
    cd cs)) s15 cd cs)) x4 cd cs
  Choice_C_OptDescr d i l r -> narrow d i (nd_C__case_21 x4 x1 x2 l s cd cs)
    (nd_C__case_21 x4 x1 x2 r s cd cs)
  Choices_C_OptDescr d i xs -> narrows cs d i (\z -> nd_C__case_21 x4 x1 x2 z s
    cd cs) xs
  Guard_C_OptDescr d c e -> guardCons d c (nd_C__case_21 x4 x1 x2 e s cd $!
    addCs c cs)
  Fail_C_OptDescr d info -> failCons d (traceFail "GetOpt._case_21" [show x4
    , show x1, show x2, show x5] info)
  _ -> failCons cd (consFail "GetOpt._case_21" (showCons x5))

d_C__case_20 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> (Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool) -> C_OptDescr t0
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (C_OptDescr t0)
d_C__case_20 x7 x1 x2 x5 x8 cd cs = case x8 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons x5 Curry_Prelude.OP_List
  Curry_Prelude.C_False -> Curry_Prelude.OP_List
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_20 x7 x1 x2 x5 l
    cd cs) (d_C__case_20 x7 x1 x2 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_20 x7
    x1 x2 x5 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_20 x7 x1 x2 x5 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "GetOpt._case_20"
    [show x7, show x1, show x2, show x5, show x8] info)
  _ -> failCons cd (consFail "GetOpt._case_20" (showCons x8))

nd_C__case_20 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Func (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Func (Curry_Prelude.OP_List Curry_Prelude.C_Char) Curry_Prelude.C_Bool)
  -> C_OptDescr t0 -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (C_OptDescr t0)
nd_C__case_20 x7 x1 x2 x5 x8 s cd cs = case x8 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons x5 Curry_Prelude.OP_List
  Curry_Prelude.C_False -> Curry_Prelude.OP_List
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_20 x7 x1 x2 x5 l
    s cd cs) (nd_C__case_20 x7 x1 x2 x5 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_20 x7
    x1 x2 x5 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_20 x7 x1 x2 x5 e
    s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "GetOpt._case_20"
    [show x7, show x1, show x2, show x5, show x8] info)
  _ -> failCons cd (consFail "GetOpt._case_20" (showCons x8))

d_C__case_22 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (C_OptDescr t0) -> Curry_Prelude.OP_List (C_OptDescr t0)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (C_OptDescr t0)
d_C__case_22 x7 x3 x5 x8 cd cs = case x8 of
  Curry_Prelude.C_True -> d_OP_longOpt_dot_getWith_dot_97 x5 x3 (acceptCs id
    (Curry_List.d_C_isPrefixOf
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs))) cd cs
  Curry_Prelude.C_False -> x7
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_22 x7 x3 x5 l cd
    cs) (d_C__case_22 x7 x3 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_22 x7
    x3 x5 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_22 x7 x3 x5 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "GetOpt._case_22"
    [show x7, show x3, show x5, show x8] info)
  _ -> failCons cd (consFail "GetOpt._case_22" (showCons x8))

nd_C__case_22 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (C_OptDescr t0) -> Curry_Prelude.OP_List (C_OptDescr t0)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_List (C_OptDescr t0)
nd_C__case_22 x7 x3 x5 x8 s cd cs = case x8 of
  Curry_Prelude.C_True -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_longOpt_dot_getWith_dot_97 x5 x3 (wrapDX (wrapNX
    id) (acceptCs id (Curry_List.nd_C_isPrefixOf
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    s0 cd cs)))) s1 cd cs))
  Curry_Prelude.C_False -> x7
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_22 x7 x3 x5 l s
    cd cs) (nd_C__case_22 x7 x3 x5 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_22 x7
    x3 x5 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_22 x7 x3 x5 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "GetOpt._case_22"
    [show x7, show x3, show x5, show x8] info)
  _ -> failCons cd (consFail "GetOpt._case_22" (showCons x8))

d_C__case_26 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (C_OptDescr t0)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (C_OptKind t0) (Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C__case_26 x4 x2 x1 x5 x3 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> d_C__case_25 x2 x1 x3 x5 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.OP_Tuple2 (C_NonOpt x1) x2
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_26 x4 x2 x1 x5 x3
    l cd cs) (d_C__case_26 x4 x2 x1 x5 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_26 x4
    x2 x1 x5 x3 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_26 x4 x2 x1 x5 x3
    e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "GetOpt._case_26"
    [show x4, show x2, show x1, show x5, show x3, show x6] info)
  _ -> failCons cd (consFail "GetOpt._case_26" (showCons x6))

nd_C__case_26 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (C_OptDescr t0)
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C__case_26 x4 x2 x1 x5 x3 x6 s cd cs = case x6 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` nd_C__case_25 x2 x1 x3 x5 s0 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.OP_Tuple2 (C_NonOpt x1) x2
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_26 x4 x2 x1 x5
    x3 l s cd cs) (nd_C__case_26 x4 x2 x1 x5 x3 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_26 x4
    x2 x1 x5 x3 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_26 x4 x2 x1 x5
    x3 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "GetOpt._case_26"
    [show x4, show x2, show x1, show x5, show x3, show x6] info)
  _ -> failCons cd (consFail "GetOpt._case_26" (showCons x6))

d_C__case_25 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (C_OptDescr t0)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_25 x2 x1 x3 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_24 x6 x3 x2 x7
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x6 (Curry_Prelude.C_Char '-'#) cd cs) cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Tuple2 (C_NonOpt x1) x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_25 x2 x1 x3 l cd
    cs) (d_C__case_25 x2 x1 x3 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_25 x2
    x1 x3 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_25 x2 x1 x3 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt._case_25"
    [show x2, show x1, show x3, show x5] info)
  _ -> failCons cd (consFail "GetOpt._case_25" (showCons x5))

nd_C__case_25 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (C_OptDescr t0)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C__case_25 x2 x1 x3 x5 s cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> let s0 = s
    in s0 `seq` nd_C__case_24 x6 x3 x2 x7
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x6 (Curry_Prelude.C_Char '-'#) cd cs) s0 cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Tuple2 (C_NonOpt x1) x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_25 x2 x1 x3 l s
    cd cs) (nd_C__case_25 x2 x1 x3 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_25 x2
    x1 x3 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C__case_25 x2 x1 x3 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt._case_25"
    [show x2, show x1, show x3, show x5] info)
  _ -> failCons cd (consFail "GetOpt._case_25" (showCons x5))

d_C__case_24 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (C_OptDescr t0) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_24 x6 x3 x2 x7 x8 cd cs = case x8 of
  Curry_Prelude.C_True -> d_C__case_23 x3 x2 x7 cd cs
  Curry_Prelude.C_False -> d_C_shortOpt x6 x7 x2 x3 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_24 x6 x3 x2 x7 l
    cd cs) (d_C__case_24 x6 x3 x2 x7 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_24 x6
    x3 x2 x7 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_24 x6 x3 x2 x7 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "GetOpt._case_24"
    [show x6, show x3, show x2, show x7, show x8] info)
  _ -> failCons cd (consFail "GetOpt._case_24" (showCons x8))

nd_C__case_24 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (C_OptDescr t0) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C__case_24 x6 x3 x2 x7 x8 s cd cs = case x8 of
  Curry_Prelude.C_True -> let s0 = s in s0 `seq` nd_C__case_23 x3 x2 x7 s0 cd cs
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C_shortOpt x6 x7 x2 x3 s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_24 x6 x3 x2 x7 l
    s cd cs) (nd_C__case_24 x6 x3 x2 x7 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_24 x6
    x3 x2 x7 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_24 x6 x3 x2 x7 e
    s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "GetOpt._case_24"
    [show x6, show x3, show x2, show x7, show x8] info)
  _ -> failCons cd (consFail "GetOpt._case_24" (showCons x8))

d_C__case_23 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (C_OptDescr t0) -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (C_OptKind t0) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_23 x3 x2 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Tuple2 C_EndOfOpts x2
  Curry_Prelude.OP_Cons x8 x9 -> d_C_longOpt x7 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_23 x3 x2 l cd
    cs) (d_C__case_23 x3 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_23 x3
    x2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_23 x3 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt._case_23"
    [show x3, show x2, show x7] info)
  _ -> failCons cd (consFail "GetOpt._case_23" (showCons x7))

nd_C__case_23 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (C_OptDescr t0) -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 (C_OptKind t0)
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C__case_23 x3 x2 x7 s cd cs = case x7 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Tuple2 C_EndOfOpts x2
  Curry_Prelude.OP_Cons x8 x9 -> let s0 = s
    in s0 `seq` nd_C_longOpt x7 x2 x3 s0 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_23 x3 x2 l s cd
    cs) (nd_C__case_23 x3 x2 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_23 x3
    x2 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C__case_23 x3 x2 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt._case_23"
    [show x3, show x2, show x7] info)
  _ -> failCons cd (consFail "GetOpt._case_23" (showCons x7))

d_C__case_27 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> C_ArgOrder t0 -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple4 (Curry_Prelude.OP_List t0)
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_27 x3 x7 cd cs = case x7 of
  C_RequireOrder -> Curry_Prelude.OP_Tuple4 Curry_Prelude.OP_List x3
    Curry_Prelude.OP_List Curry_Prelude.OP_List
  C_Permute -> Curry_Prelude.OP_Tuple4 Curry_Prelude.OP_List x3
    Curry_Prelude.OP_List Curry_Prelude.OP_List
  C_ReturnInOrder x12 -> Curry_Prelude.OP_Tuple4 (Curry_Prelude.d_C_map x12 x3
    cd cs) Curry_Prelude.OP_List Curry_Prelude.OP_List Curry_Prelude.OP_List
  Choice_C_ArgOrder d i l r -> narrow d i (d_C__case_27 x3 l cd cs)
    (d_C__case_27 x3 r cd cs)
  Choices_C_ArgOrder d i xs -> narrows cs d i (\z -> d_C__case_27 x3 z cd cs) xs
  Guard_C_ArgOrder d c e -> guardCons d c (d_C__case_27 x3 e cd $! addCs c cs)
  Fail_C_ArgOrder d info -> failCons d (traceFail "GetOpt._case_27" [show x3
    , show x7] info)
  _ -> failCons cd (consFail "GetOpt._case_27" (showCons x7))

nd_C__case_27 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> C_ArgOrder t0 -> IDSupply
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple4 (Curry_Prelude.OP_List t0)
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C__case_27 x3 x7 s cd cs = case x7 of
  C_RequireOrder -> Curry_Prelude.OP_Tuple4 Curry_Prelude.OP_List x3
    Curry_Prelude.OP_List Curry_Prelude.OP_List
  C_Permute -> Curry_Prelude.OP_Tuple4 Curry_Prelude.OP_List x3
    Curry_Prelude.OP_List Curry_Prelude.OP_List
  HO_C_ReturnInOrder x12 -> let s0 = s
    in s0 `seq` Curry_Prelude.OP_Tuple4 (Curry_Prelude.nd_C_map x12 x3 s0 cd cs)
    Curry_Prelude.OP_List Curry_Prelude.OP_List Curry_Prelude.OP_List
  Choice_C_ArgOrder d i l r -> narrow d i (nd_C__case_27 x3 l s cd cs)
    (nd_C__case_27 x3 r s cd cs)
  Choices_C_ArgOrder d i xs -> narrows cs d i (\z -> nd_C__case_27 x3 z s cd cs)
    xs
  Guard_C_ArgOrder d c e -> guardCons d c (nd_C__case_27 x3 e s cd $! addCs c
    cs)
  Fail_C_ArgOrder d info -> failCons d (traceFail "GetOpt._case_27" [show x3
    , show x7] info)
  _ -> failCons cd (consFail "GetOpt._case_27" (showCons x7))

d_C__case_28 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> C_ArgOrder t0 -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple4 (Curry_Prelude.OP_List t0)
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_28 x2 x4 x5 x1 x10 x3 x7 cd cs = case x7 of
  C_RequireOrder -> Curry_Prelude.OP_Tuple4 Curry_Prelude.OP_List
    (Curry_Prelude.OP_Cons x10 x3) Curry_Prelude.OP_List Curry_Prelude.OP_List
  C_Permute -> Curry_Prelude.OP_Tuple4 x1 (Curry_Prelude.OP_Cons x10 x5) x4 x2
  C_ReturnInOrder x11 -> Curry_Prelude.OP_Tuple4 (Curry_Prelude.OP_Cons
    (Curry_Prelude.d_C_apply x11 x10 cd cs) x1) x5 x4 x2
  Choice_C_ArgOrder d i l r -> narrow d i (d_C__case_28 x2 x4 x5 x1 x10 x3 l cd
    cs) (d_C__case_28 x2 x4 x5 x1 x10 x3 r cd cs)
  Choices_C_ArgOrder d i xs -> narrows cs d i (\z -> d_C__case_28 x2 x4 x5 x1
    x10 x3 z cd cs) xs
  Guard_C_ArgOrder d c e -> guardCons d c (d_C__case_28 x2 x4 x5 x1 x10 x3 e
    cd $! addCs c cs)
  Fail_C_ArgOrder d info -> failCons d (traceFail "GetOpt._case_28" [show x2
    , show x4, show x5, show x1, show x10, show x3, show x7] info)
  _ -> failCons cd (consFail "GetOpt._case_28" (showCons x7))

nd_C__case_28 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> C_ArgOrder t0 -> IDSupply
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple4 (Curry_Prelude.OP_List t0)
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C__case_28 x2 x4 x5 x1 x10 x3 x7 s cd cs = case x7 of
  C_RequireOrder -> Curry_Prelude.OP_Tuple4 Curry_Prelude.OP_List
    (Curry_Prelude.OP_Cons x10 x3) Curry_Prelude.OP_List Curry_Prelude.OP_List
  C_Permute -> Curry_Prelude.OP_Tuple4 x1 (Curry_Prelude.OP_Cons x10 x5) x4 x2
  HO_C_ReturnInOrder x11 -> let s0 = s
    in s0 `seq` Curry_Prelude.OP_Tuple4 (Curry_Prelude.OP_Cons
    (Curry_Prelude.nd_C_apply x11 x10 s0 cd cs) x1) x5 x4 x2
  Choice_C_ArgOrder d i l r -> narrow d i (nd_C__case_28 x2 x4 x5 x1 x10 x3 l s
    cd cs) (nd_C__case_28 x2 x4 x5 x1 x10 x3 r s cd cs)
  Choices_C_ArgOrder d i xs -> narrows cs d i (\z -> nd_C__case_28 x2 x4 x5 x1
    x10 x3 z s cd cs) xs
  Guard_C_ArgOrder d c e -> guardCons d c (nd_C__case_28 x2 x4 x5 x1 x10 x3 e s
    cd $! addCs c cs)
  Fail_C_ArgOrder d info -> failCons d (traceFail "GetOpt._case_28" [show x2
    , show x4, show x5, show x1, show x10, show x3, show x7] info)
  _ -> failCons cd (consFail "GetOpt._case_28" (showCons x7))

d_C__case_29 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_29 x1 x3 x4 cd cs = case x4 of
  Curry_Prelude.OP_List -> x3
  Curry_Prelude.OP_Cons x5 x6 -> Curry_Prelude.d_OP_plus_plus x3
    (Curry_Prelude.OP_Cons x1 (Curry_Prelude.OP_Cons (Curry_Prelude.C_Char ' '#)
    (d_OP_fmtOpt_dot_sepBy_dot_19 x1 (Curry_Prelude.OP_Cons x5 x6) cd cs))) cd
    cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_29 x1 x3 l cd
    cs) (d_C__case_29 x1 x3 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_29 x1
    x3 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_29 x1 x3 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt._case_29"
    [show x1, show x3, show x4] info)
  _ -> failCons cd (consFail "GetOpt._case_29" (showCons x4))

d_C__case_30 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple3 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C__case_30 x5 x7 x6 x10 cd cs = case x10 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple3 x6 x7
    Curry_Prelude.OP_List) Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x8 x9 -> Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple3
    x6 x7 x8) (Curry_Prelude.d_C_map d_OP_fmtOpt_dot_uscore_hash_lambda3 x9 cd
    cs)
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_30 x5 x7 x6 l cd
    cs) (d_C__case_30 x5 x7 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_30 x5
    x7 x6 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_30 x5 x7 x6 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "GetOpt._case_30"
    [show x5, show x7, show x6, show x10] info)
  _ -> failCons cd (consFail "GetOpt._case_30" (showCons x10))

