{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE Rank2Types #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif
{-# LANGUAGE MultiParamTypeClasses #-}

module Curry_IO
  ( C_Handle (..)
  , C_IOMode (..)
  , C_SeekMode (..)
  , d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_IO_dot_Handle
  , nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_IO_dot_Handle
  , d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_IO_dot_Handle
  , d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_IO_dot_Handle
  , d_C_openFile
  , d_C_hClose
  , d_C_hFlush
  , d_C_hIsEOF
  , d_C_isEOF
  , d_C_hSeek
  , d_C_hWaitForInput
  , d_C_hWaitForInputs
  , d_C_hWaitForInputOrMsg
  , d_C_hWaitForInputsOrMsg
  , d_C_hReady
  , d_C_hGetChar
  , d_C_hGetLine
  , d_C_hGetContents
  , d_C_getContents
  , d_C_hPutChar
  , d_C_hPutStr
  , d_C_hPutStrLn
  , d_C_hPrint
  , nd_C_hPrint
  , d_C_hIsReadable
  , d_C_hIsWritable
  , d_C_hIsTerminalDevice
  , d_C_stdin
  , d_C_stdout
  , d_C_stderr )
  where

import Basics
import qualified Curry_Prelude

import           Control.Concurrent
import qualified Control.Exception  as C (IOException, catch, throw)
import           Control.Monad           (zipWithM)
import           System.IO
import           System.IO.Error         (isEOFError)

data C_IOMode
  = C_ReadMode
  | C_WriteMode
  | C_AppendMode
  | Choice_C_IOMode Cover ID C_IOMode C_IOMode
  | Choices_C_IOMode Cover ID [C_IOMode]
  | Fail_C_IOMode Cover FailInfo
  | Guard_C_IOMode Cover Constraints C_IOMode

instance Show C_IOMode where
  showsPrec d (Choice_C_IOMode cd i x y) = showsChoice d cd i x y
  showsPrec d (Choices_C_IOMode cd i xs) = showsChoices d cd i xs
  showsPrec d (Guard_C_IOMode cd c e) = showsGuard d cd c e
  showsPrec _ (Fail_C_IOMode cd info) = showChar '!'
  showsPrec _ C_ReadMode = showString "ReadMode"
  showsPrec _ C_WriteMode = showString "WriteMode"
  showsPrec _ C_AppendMode = showString "AppendMode"

instance Read C_IOMode where
  readsPrec _ s = readParen False (\r -> [(C_ReadMode, r0) | (_, r0) <-
    readQualified "IO" "ReadMode" r]) s ++ (readParen False (\r -> [(C_WriteMode
    , r0) | (_, r0) <- readQualified "IO" "WriteMode" r]) s ++ readParen False
    (\r -> [(C_AppendMode, r0) | (_, r0) <- readQualified "IO" "AppendMode" r])
    s)

instance NonDet C_IOMode where
  choiceCons = Choice_C_IOMode
  choicesCons = Choices_C_IOMode
  failCons = Fail_C_IOMode
  guardCons = Guard_C_IOMode
  try (Choice_C_IOMode cd i x y) = tryChoice cd i x y
  try (Choices_C_IOMode cd i xs) = tryChoices cd i xs
  try (Fail_C_IOMode cd info) = Fail cd info
  try (Guard_C_IOMode cd c e) = Guard cd c e
  try x = Val x
  match f _ _ _ _ _ (Choice_C_IOMode cd i x y) = f cd i x y
  match _ f _ _ _ _ (Choices_C_IOMode cd i@(NarrowedID _ _) xs) = f cd i xs
  match _ _ f _ _ _ (Choices_C_IOMode cd i@(FreeID _ _) xs) = f cd i xs
  match _ _ _ _ _ _ (Choices_C_IOMode cd i _) = error
    ("IO.IOMode.match: Choices with ChoiceID " ++ show i)
  match _ _ _ f _ _ (Fail_C_IOMode cd info) = f cd info
  match _ _ _ _ f _ (Guard_C_IOMode cd c e) = f cd c e
  match _ _ _ _ _ f x = f x

instance Generable C_IOMode where
  generate s c = Choices_C_IOMode c (freeID [0, 0, 0] s) [C_ReadMode
    , C_WriteMode, C_AppendMode]

instance NormalForm C_IOMode where
  ($!!) cont C_ReadMode d cs = cont C_ReadMode d cs
  ($!!) cont C_WriteMode d cs = cont C_WriteMode d cs
  ($!!) cont C_AppendMode d cs = cont C_AppendMode d cs
  ($!!) cont (Choice_C_IOMode cd i x y) d cs = nfChoice cont cd i x y cd cs
  ($!!) cont (Choices_C_IOMode cd i xs) d cs = nfChoices cont cd i xs d cs
  ($!!) cont (Guard_C_IOMode cd c e) d cs = guardCons cd c (($!!) cont e d
    (addCs c cs))
  ($!!) _ (Fail_C_IOMode cd info) _ _ = failCons cd info
  ($##) cont C_ReadMode d cs = cont C_ReadMode d cs
  ($##) cont C_WriteMode d cs = cont C_WriteMode d cs
  ($##) cont C_AppendMode d cs = cont C_AppendMode d cs
  ($##) cont (Choice_C_IOMode cd i x y) d cs = gnfChoice cont cd i x y cd cs
  ($##) cont (Choices_C_IOMode cd i xs) d cs = gnfChoices cont cd i xs d cs
  ($##) cont (Guard_C_IOMode cd c e) d cs = guardCons cd c (($##) cont e d
    (addCs c cs))
  ($##) _ (Fail_C_IOMode cd info) _ _ = failCons cd info
  showCons C_ReadMode = "IO.ReadMode"
  showCons C_WriteMode = "IO.WriteMode"
  showCons C_AppendMode = "IO.AppendMode"
  showCons x = error ("IO.IOMode.showCons: no constructor: " ++ show x)
  searchNF _ cont C_ReadMode = cont C_ReadMode
  searchNF _ cont C_WriteMode = cont C_WriteMode
  searchNF _ cont C_AppendMode = cont C_AppendMode
  searchNF _ _ x = error ("IO.IOMode.searchNF: no constructor: " ++ show x)

instance Unifiable C_IOMode where
  (=.=) C_ReadMode C_ReadMode d cs = C_True
  (=.=) C_WriteMode C_WriteMode d cs = C_True
  (=.=) C_AppendMode C_AppendMode d cs = C_True
  (=.=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  (=.<=) C_ReadMode C_ReadMode d cs = C_True
  (=.<=) C_WriteMode C_WriteMode d cs = C_True
  (=.<=) C_AppendMode C_AppendMode d cs = C_True
  (=.<=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  bind cd i C_ReadMode = (i :=: ChooseN 0 0) : concat []
  bind cd i C_WriteMode = (i :=: ChooseN 1 0) : concat []
  bind cd i C_AppendMode = (i :=: ChooseN 2 0) : concat []
  bind d i (Choice_C_IOMode cd j x y) = [ConstraintChoice cd j (bind d i x)
    (bind d i y)]
  bind d i (Choices_C_IOMode cd j@(FreeID _ _) xs) = bindOrNarrow d i cd j xs
  bind d i (Choices_C_IOMode cd j@(NarrowedID _ _) xs) = [ConstraintChoices cd j
    (map (bind d i) xs)]
  bind _ _ (Choices_C_IOMode cd i _) = error
    ("IO.IOMode.bind: Choices with ChoiceID: " ++ show i)
  bind _ _ (Fail_C_IOMode cd info) = [Unsolvable info]
  bind d i (Guard_C_IOMode cd c e) = getConstrList c ++ bind d i e
  lazyBind cd i C_ReadMode = (i :=: ChooseN 0 0) : []
  lazyBind cd i C_WriteMode = (i :=: ChooseN 1 0) : []
  lazyBind cd i C_AppendMode = (i :=: ChooseN 2 0) : []
  lazyBind d i (Choice_C_IOMode cd j x y) = [ConstraintChoice cd j (lazyBind d i
    x) (lazyBind d i y)]
  lazyBind d i (Choices_C_IOMode cd j@(FreeID _ _) xs) = lazyBindOrNarrow d i cd
    j xs
  lazyBind d i (Choices_C_IOMode cd j@(NarrowedID _ _) xs) = [ConstraintChoices
    cd j (map (lazyBind d i) xs)]
  lazyBind _ _ (Choices_C_IOMode cd i _) = error
    ("IO.IOMode.lazyBind: Choices with ChoiceID: " ++ show i)
  lazyBind _ _ (Fail_C_IOMode cd info) = [Unsolvable info]
  lazyBind d i (Guard_C_IOMode cd c e) = getConstrList c ++ [i :=: LazyBind
    (lazyBind d i e)]

instance Curry C_IOMode where

data C_SeekMode
  = C_AbsoluteSeek
  | C_RelativeSeek
  | C_SeekFromEnd
  | Choice_C_SeekMode Cover ID C_SeekMode C_SeekMode
  | Choices_C_SeekMode Cover ID [C_SeekMode]
  | Fail_C_SeekMode Cover FailInfo
  | Guard_C_SeekMode Cover Constraints C_SeekMode

instance Show C_SeekMode where
  showsPrec d (Choice_C_SeekMode cd i x y) = showsChoice d cd i x y
  showsPrec d (Choices_C_SeekMode cd i xs) = showsChoices d cd i xs
  showsPrec d (Guard_C_SeekMode cd c e) = showsGuard d cd c e
  showsPrec _ (Fail_C_SeekMode cd info) = showChar '!'
  showsPrec _ C_AbsoluteSeek = showString "AbsoluteSeek"
  showsPrec _ C_RelativeSeek = showString "RelativeSeek"
  showsPrec _ C_SeekFromEnd = showString "SeekFromEnd"

instance Read C_SeekMode where
  readsPrec _ s = readParen False (\r -> [(C_AbsoluteSeek, r0) | (_, r0) <-
    readQualified "IO" "AbsoluteSeek" r]) s ++ (readParen False (\r ->
    [(C_RelativeSeek, r0) | (_, r0) <- readQualified "IO" "RelativeSeek" r])
    s ++ readParen False (\r -> [(C_SeekFromEnd, r0) | (_, r0) <- readQualified
    "IO" "SeekFromEnd" r]) s)

instance NonDet C_SeekMode where
  choiceCons = Choice_C_SeekMode
  choicesCons = Choices_C_SeekMode
  failCons = Fail_C_SeekMode
  guardCons = Guard_C_SeekMode
  try (Choice_C_SeekMode cd i x y) = tryChoice cd i x y
  try (Choices_C_SeekMode cd i xs) = tryChoices cd i xs
  try (Fail_C_SeekMode cd info) = Fail cd info
  try (Guard_C_SeekMode cd c e) = Guard cd c e
  try x = Val x
  match f _ _ _ _ _ (Choice_C_SeekMode cd i x y) = f cd i x y
  match _ f _ _ _ _ (Choices_C_SeekMode cd i@(NarrowedID _ _) xs) = f cd i xs
  match _ _ f _ _ _ (Choices_C_SeekMode cd i@(FreeID _ _) xs) = f cd i xs
  match _ _ _ _ _ _ (Choices_C_SeekMode cd i _) = error
    ("IO.SeekMode.match: Choices with ChoiceID " ++ show i)
  match _ _ _ f _ _ (Fail_C_SeekMode cd info) = f cd info
  match _ _ _ _ f _ (Guard_C_SeekMode cd c e) = f cd c e
  match _ _ _ _ _ f x = f x

instance Generable C_SeekMode where
  generate s c = Choices_C_SeekMode c (freeID [0, 0, 0] s) [C_AbsoluteSeek
    , C_RelativeSeek, C_SeekFromEnd]

instance NormalForm C_SeekMode where
  ($!!) cont C_AbsoluteSeek d cs = cont C_AbsoluteSeek d cs
  ($!!) cont C_RelativeSeek d cs = cont C_RelativeSeek d cs
  ($!!) cont C_SeekFromEnd d cs = cont C_SeekFromEnd d cs
  ($!!) cont (Choice_C_SeekMode cd i x y) d cs = nfChoice cont cd i x y cd cs
  ($!!) cont (Choices_C_SeekMode cd i xs) d cs = nfChoices cont cd i xs d cs
  ($!!) cont (Guard_C_SeekMode cd c e) d cs = guardCons cd c (($!!) cont e d
    (addCs c cs))
  ($!!) _ (Fail_C_SeekMode cd info) _ _ = failCons cd info
  ($##) cont C_AbsoluteSeek d cs = cont C_AbsoluteSeek d cs
  ($##) cont C_RelativeSeek d cs = cont C_RelativeSeek d cs
  ($##) cont C_SeekFromEnd d cs = cont C_SeekFromEnd d cs
  ($##) cont (Choice_C_SeekMode cd i x y) d cs = gnfChoice cont cd i x y cd cs
  ($##) cont (Choices_C_SeekMode cd i xs) d cs = gnfChoices cont cd i xs d cs
  ($##) cont (Guard_C_SeekMode cd c e) d cs = guardCons cd c (($##) cont e d
    (addCs c cs))
  ($##) _ (Fail_C_SeekMode cd info) _ _ = failCons cd info
  showCons C_AbsoluteSeek = "IO.AbsoluteSeek"
  showCons C_RelativeSeek = "IO.RelativeSeek"
  showCons C_SeekFromEnd = "IO.SeekFromEnd"
  showCons x = error ("IO.SeekMode.showCons: no constructor: " ++ show x)
  searchNF _ cont C_AbsoluteSeek = cont C_AbsoluteSeek
  searchNF _ cont C_RelativeSeek = cont C_RelativeSeek
  searchNF _ cont C_SeekFromEnd = cont C_SeekFromEnd
  searchNF _ _ x = error ("IO.SeekMode.searchNF: no constructor: " ++ show x)

instance Unifiable C_SeekMode where
  (=.=) C_AbsoluteSeek C_AbsoluteSeek d cs = C_True
  (=.=) C_RelativeSeek C_RelativeSeek d cs = C_True
  (=.=) C_SeekFromEnd C_SeekFromEnd d cs = C_True
  (=.=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  (=.<=) C_AbsoluteSeek C_AbsoluteSeek d cs = C_True
  (=.<=) C_RelativeSeek C_RelativeSeek d cs = C_True
  (=.<=) C_SeekFromEnd C_SeekFromEnd d cs = C_True
  (=.<=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  bind cd i C_AbsoluteSeek = (i :=: ChooseN 0 0) : concat []
  bind cd i C_RelativeSeek = (i :=: ChooseN 1 0) : concat []
  bind cd i C_SeekFromEnd = (i :=: ChooseN 2 0) : concat []
  bind d i (Choice_C_SeekMode cd j x y) = [ConstraintChoice cd j (bind d i x)
    (bind d i y)]
  bind d i (Choices_C_SeekMode cd j@(FreeID _ _) xs) = bindOrNarrow d i cd j xs
  bind d i (Choices_C_SeekMode cd j@(NarrowedID _ _) xs) = [ConstraintChoices cd
    j (map (bind d i) xs)]
  bind _ _ (Choices_C_SeekMode cd i _) = error
    ("IO.SeekMode.bind: Choices with ChoiceID: " ++ show i)
  bind _ _ (Fail_C_SeekMode cd info) = [Unsolvable info]
  bind d i (Guard_C_SeekMode cd c e) = getConstrList c ++ bind d i e
  lazyBind cd i C_AbsoluteSeek = (i :=: ChooseN 0 0) : []
  lazyBind cd i C_RelativeSeek = (i :=: ChooseN 1 0) : []
  lazyBind cd i C_SeekFromEnd = (i :=: ChooseN 2 0) : []
  lazyBind d i (Choice_C_SeekMode cd j x y) = [ConstraintChoice cd j (lazyBind d
    i x) (lazyBind d i y)]
  lazyBind d i (Choices_C_SeekMode cd j@(FreeID _ _) xs) = lazyBindOrNarrow d i
    cd j xs
  lazyBind d i (Choices_C_SeekMode cd j@(NarrowedID _ _) xs) =
    [ConstraintChoices cd j (map (lazyBind d i) xs)]
  lazyBind _ _ (Choices_C_SeekMode cd i _) = error
    ("IO.SeekMode.lazyBind: Choices with ChoiceID: " ++ show i)
  lazyBind _ _ (Fail_C_SeekMode cd info) = [Unsolvable info]
  lazyBind d i (Guard_C_SeekMode cd c e) = getConstrList c ++ [i :=: LazyBind
    (lazyBind d i e)]

instance Curry C_SeekMode where

d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_IO_dot_Handle :: Cover -> ConstStore
  -> Curry_Prelude.OP_uscore_Dict_hash_Eq C_Handle
d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_IO_dot_Handle cd cs =
  Curry_Prelude.OP_uscore_Dict_hash_Eq (acceptCs id
  d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_IO_dot_Handle)
  (d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_IO_dot_Handle cd cs)

nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_IO_dot_Handle :: IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_uscore_Dict_hash_Eq C_Handle
nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_IO_dot_Handle s cd cs =
  Curry_Prelude.HO_OP_uscore_Dict_hash_Eq (wrapDX (wrapDX id) (acceptCs id
  d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_IO_dot_Handle)) (wrapDX
  (wrapDX id)
  (d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_IO_dot_Handle cd cs))

d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_IO_dot_Handle :: C_Handle
  -> C_Handle -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_IO_dot_Handle x1 x2 cd cs =
  Curry_Prelude.d_OP_dollar_hash (Curry_Prelude.d_OP_dollar_hash (acceptCs id
  d_C_handle_eq) x2 cd cs) x1 cd cs

d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_IO_dot_Handle :: Cover
  -> ConstStore -> C_Handle -> Cover -> ConstStore -> C_Handle -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_IO_dot_Handle cd cs =
  acceptCs id (Curry_Prelude.d_OP_uscore_def_hash_slash_eq_hash_Prelude_dot_Eq
  (d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_IO_dot_Handle cd cs))

d_C_openFile :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> C_IOMode -> Cover
  -> ConstStore -> Curry_Prelude.C_IO C_Handle
d_C_openFile x1 x2 cd cs = Curry_Prelude.d_OP_dollar_hash
  (Curry_Prelude.d_OP_dollar_hash_hash (acceptCs id d_C_prim_openFile) x1 cd cs)
  x2 cd cs

d_C_hClose :: C_Handle -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
d_C_hClose x1 cd cs = Curry_Prelude.d_OP_dollar_hash d_C_prim_hClose x1 cd cs

d_C_hFlush :: C_Handle -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
d_C_hFlush x1 cd cs = Curry_Prelude.d_OP_dollar_hash d_C_prim_hFlush x1 cd cs

d_C_hIsEOF :: C_Handle -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.C_Bool
d_C_hIsEOF x1 cd cs = Curry_Prelude.d_OP_dollar_hash d_C_prim_hIsEOF x1 cd cs

d_C_isEOF :: Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_Bool
d_C_isEOF cd cs = d_C_hIsEOF (d_C_stdin cd cs) cd cs

d_C_hSeek :: C_Handle -> C_SeekMode -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_hSeek x1 x2 x3 cd cs = Curry_Prelude.d_OP_dollar_hash
  (Curry_Prelude.d_OP_dollar_hash (Curry_Prelude.d_OP_dollar_hash (acceptCs
  (acceptCs id) d_C_prim_hSeek) x1 cd cs) x2 cd cs) x3 cd cs

d_C_hWaitForInput :: C_Handle -> Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.C_Bool
d_C_hWaitForInput x1 x2 cd cs = Curry_Prelude.d_OP_dollar_hash_hash
  (Curry_Prelude.d_OP_dollar_hash (acceptCs id d_C_prim_hWaitForInput) x1 cd cs)
  x2 cd cs

d_C_hWaitForInputs :: Curry_Prelude.OP_List C_Handle -> Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_Int
d_C_hWaitForInputs x1 x2 cd cs = Curry_Prelude.d_OP_dollar_hash_hash
  (Curry_Prelude.d_OP_dollar_hash_hash (acceptCs id d_C_prim_hWaitForInputs) x1
  cd cs) x2 cd cs

d_C_hWaitForInputOrMsg :: forall t0 . (Curry_Prelude.Curry t0) => C_Handle
  -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.C_Either C_Handle (Curry_Prelude.OP_List t0))
d_C_hWaitForInputOrMsg x1 x2 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (d_C_hWaitForInputsOrMsg (Curry_Prelude.OP_Cons x1 Curry_Prelude.OP_List) x2
  cd cs) (d_OP_hWaitForInputOrMsg_dot_uscore_hash_lambda2 x1) cd cs

d_OP_hWaitForInputOrMsg_dot_uscore_hash_lambda2 :: forall t0 . (Curry_Prelude.Curry
  t0) => C_Handle -> Curry_Prelude.C_Either Curry_Prelude.C_Int
  (Curry_Prelude.OP_List t0) -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.C_Either C_Handle (Curry_Prelude.OP_List t0))
d_OP_hWaitForInputOrMsg_dot_uscore_hash_lambda2 x1 x2 cd cs = let x3 = x2
  in Curry_Prelude.d_OP_dollar
  Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Prelude.d_C_either
  (d_OP_hWaitForInputOrMsg_dot_uscore_hash_lambda2_dot_uscore_hash_lambda4 x1)
  (acceptCs id Curry_Prelude.C_Right) x3 cd cs) cd cs

d_OP_hWaitForInputOrMsg_dot_uscore_hash_lambda2_dot_uscore_hash_lambda4 :: forall t0 . (Curry_Prelude.Curry
  t0) => C_Handle -> Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.C_Either C_Handle (Curry_Prelude.OP_List t0)
d_OP_hWaitForInputOrMsg_dot_uscore_hash_lambda2_dot_uscore_hash_lambda4 x1 x2 cd cs =
  Curry_Prelude.C_Left x1

d_C_hWaitForInputsOrMsg :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_List C_Handle -> Curry_Prelude.OP_List t0 -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_Either
  Curry_Prelude.C_Int (Curry_Prelude.OP_List t0))
d_C_hWaitForInputsOrMsg x1 x2 cd cs = Curry_Prelude.d_C_seq
  (Curry_Prelude.d_C_normalForm (Curry_Prelude.d_C_map
  Curry_Prelude.d_C_ensureNotFree (Curry_Prelude.d_C_ensureSpine x1 cd cs) cd
  cs) cd cs) (d_C_prim_hWaitForInputsOrMsg x1 x2 cd cs) cd cs

d_C_hReady :: C_Handle -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.C_Bool
d_C_hReady x1 cd cs = d_C_hWaitForInput x1 (Curry_Prelude.C_Int (0)) cd cs

d_C_hGetChar :: C_Handle -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.C_Char
d_C_hGetChar x1 cd cs = Curry_Prelude.d_OP_dollar_hash d_C_prim_hGetChar x1 cd
  cs

d_C_hGetLine :: C_Handle -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_hGetLine x1 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (d_C_hGetChar x1 cd cs) (d_OP_hGetLine_dot_uscore_hash_lambda6 x1) cd cs

d_OP_hGetLine_dot_uscore_hash_lambda6 :: C_Handle -> Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_hGetLine_dot_uscore_hash_lambda6 x1 x2 cd cs = let x3 = x2
  in d_C__case_0 x3 x1
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
  x3 (Curry_Prelude.C_Char '\n'#) cd cs) cd cs

d_OP_hGetLine_dot_uscore_hash_lambda6_dot_uscore_hash_lambda9 :: C_Handle
  -> Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_IO (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_hGetLine_dot_uscore_hash_lambda6_dot_uscore_hash_lambda9 x1 x2 x3 cd cs =
  case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (Curry_Prelude.OP_Cons x2 Curry_Prelude.OP_List) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (d_C_hGetLine x1 cd cs)
    (d_OP_hGetLine_dot_uscore_hash_lambda6_dot_uscore_hash_lambda9_dot_uscore_hash_lambda12
    x2) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i
    (d_OP_hGetLine_dot_uscore_hash_lambda6_dot_uscore_hash_lambda9 x1 x2 l cd
    cs) (d_OP_hGetLine_dot_uscore_hash_lambda6_dot_uscore_hash_lambda9 x1 x2 r
    cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z ->
    d_OP_hGetLine_dot_uscore_hash_lambda6_dot_uscore_hash_lambda9 x1 x2 z cd cs)
    xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c
    (d_OP_hGetLine_dot_uscore_hash_lambda6_dot_uscore_hash_lambda9 x1 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "IO.hGetLine._#lambda6._#lambda9" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "IO.hGetLine._#lambda6._#lambda9" (showCons x3))

d_OP_hGetLine_dot_uscore_hash_lambda6_dot_uscore_hash_lambda9_dot_uscore_hash_lambda12 :: Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_hGetLine_dot_uscore_hash_lambda6_dot_uscore_hash_lambda9_dot_uscore_hash_lambda12 x1 x2 cd cs =
  let x3 = x2
  in Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Prelude.OP_Cons x1 x3) cd cs

d_C_hGetContents :: C_Handle -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_hGetContents x1 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (d_C_hIsEOF x1 cd cs) (d_OP_hGetContents_dot_uscore_hash_lambda15 x1) cd cs

d_OP_hGetContents_dot_uscore_hash_lambda15 :: C_Handle -> Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_hGetContents_dot_uscore_hash_lambda15 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (d_C_hClose x1 cd cs)
    (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    Curry_Prelude.OP_List cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (d_C_hGetChar x1 cd cs)
    (d_OP_hGetContents_dot_uscore_hash_lambda15_dot_uscore_hash_lambda19 x1) cd
    cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i
    (d_OP_hGetContents_dot_uscore_hash_lambda15 x1 l cd cs)
    (d_OP_hGetContents_dot_uscore_hash_lambda15 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z ->
    d_OP_hGetContents_dot_uscore_hash_lambda15 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c
    (d_OP_hGetContents_dot_uscore_hash_lambda15 x1 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "IO.hGetContents._#lambda15" [show x1, show x2] info)
  _ -> failCons cd (consFail "IO.hGetContents._#lambda15" (showCons x2))

d_OP_hGetContents_dot_uscore_hash_lambda15_dot_uscore_hash_lambda19 :: C_Handle
  -> Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_hGetContents_dot_uscore_hash_lambda15_dot_uscore_hash_lambda19 x1 x2 cd cs =
  let x3 = x2
  in Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (d_C_hGetContents x1 cd cs)
  (d_OP_hGetContents_dot_uscore_hash_lambda15_dot_uscore_hash_lambda19_dot_uscore_hash_lambda21
  x3) cd cs

d_OP_hGetContents_dot_uscore_hash_lambda15_dot_uscore_hash_lambda19_dot_uscore_hash_lambda21 :: Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_hGetContents_dot_uscore_hash_lambda15_dot_uscore_hash_lambda19_dot_uscore_hash_lambda21 x1 x2 cd cs =
  let x3 = x2
  in Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Prelude.OP_Cons x1 x3) cd cs

d_C_getContents :: Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_getContents cd cs = d_C_hGetContents (d_C_stdin cd cs) cd cs

d_C_hPutChar :: C_Handle -> Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_hPutChar x1 x2 cd cs = Curry_Prelude.d_OP_dollar_hash_hash
  (Curry_Prelude.d_OP_dollar_hash (acceptCs id d_C_prim_hPutChar) x1 cd cs) x2
  cd cs

d_C_hPutStr :: C_Handle -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_hPutStr x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_done cd cs
  Curry_Prelude.OP_Cons x3 x4 -> Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (d_C_hPutChar x1 x3 cd cs) (d_C_hPutStr x1 x4 cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_hPutStr x1 l cd cs)
    (d_C_hPutStr x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_hPutStr x1 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_hPutStr x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "IO.hPutStr" [show
    x1, show x2] info)
  _ -> failCons cd (consFail "IO.hPutStr" (showCons x2))

d_C_hPutStrLn :: C_Handle -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_hPutStrLn x1 x2 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (d_C_hPutStr x1 x2 cd cs) (d_C_hPutChar x1 (Curry_Prelude.C_Char '\n'#) cd cs)
  cd cs

d_C_hPrint :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> C_Handle -> Cover
  -> ConstStore -> t0 -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
d_C_hPrint x1 x2 cd cs = Curry_Prelude.d_OP_dot (d_C_hPutStrLn x2)
  (Curry_Prelude.d_C_show x1 cd cs) cd cs

nd_C_hPrint :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> C_Handle -> IDSupply
  -> Cover -> ConstStore -> Func t0 (Curry_Prelude.C_IO Curry_Prelude.OP_Unit)
nd_C_hPrint x1 x2 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (d_C_hPutStrLn x2))
  (Curry_Prelude.nd_C_show x1 s0 cd cs) s1 cd cs))

d_C_hIsReadable :: C_Handle -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.C_Bool
d_C_hIsReadable x1 cd cs = Curry_Prelude.d_OP_dollar_hash d_C_prim_hIsReadable
  x1 cd cs

d_C_hIsWritable :: C_Handle -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.C_Bool
d_C_hIsWritable x1 cd cs = Curry_Prelude.d_OP_dollar_hash d_C_prim_hIsWritable
  x1 cd cs

d_C_hIsTerminalDevice :: C_Handle -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.C_Bool
d_C_hIsTerminalDevice x1 cd cs = Curry_Prelude.d_OP_dollar_hash
  d_C_prim_hIsTerminalDevice x1 cd cs

d_C__case_0 :: Curry_Prelude.C_Char -> C_Handle -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C__case_0 x3 x1 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    Curry_Prelude.OP_List cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (d_C_hIsEOF x1 cd cs)
    (d_OP_hGetLine_dot_uscore_hash_lambda6_dot_uscore_hash_lambda9 x1 x3) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_0 x3 x1 l cd cs)
    (d_C__case_0 x3 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_0 x3 x1
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_0 x3 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "IO._case_0" [show
    x3, show x1, show x4] info)
  _ -> failCons cd (consFail "IO._case_0" (showCons x4))

d_C_handle_eq :: C_Handle -> C_Handle -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_handle_eq x1 x2 cd cs = external_d_C_handle_eq x1 x2 cd cs

d_C_stdin :: Cover -> ConstStore -> C_Handle
d_C_stdin cd cs = external_d_C_stdin cd cs

d_C_stdout :: Cover -> ConstStore -> C_Handle
d_C_stdout cd cs = external_d_C_stdout cd cs

d_C_stderr :: Cover -> ConstStore -> C_Handle
d_C_stderr cd cs = external_d_C_stderr cd cs

d_C_prim_openFile :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> C_IOMode
  -> Cover -> ConstStore -> Curry_Prelude.C_IO C_Handle
d_C_prim_openFile x1 x2 cd cs = external_d_C_prim_openFile x1 x2 cd cs

d_C_prim_hClose :: C_Handle -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
d_C_prim_hClose x1 cd cs = external_d_C_prim_hClose x1 cd cs

d_C_prim_hFlush :: C_Handle -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
d_C_prim_hFlush x1 cd cs = external_d_C_prim_hFlush x1 cd cs

d_C_prim_hIsEOF :: C_Handle -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.C_Bool
d_C_prim_hIsEOF x1 cd cs = external_d_C_prim_hIsEOF x1 cd cs

d_C_prim_hSeek :: C_Handle -> C_SeekMode -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_prim_hSeek x1 x2 x3 cd cs = external_d_C_prim_hSeek x1 x2 x3 cd cs

d_C_prim_hWaitForInput :: C_Handle -> Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.C_Bool
d_C_prim_hWaitForInput x1 x2 cd cs = external_d_C_prim_hWaitForInput x1 x2 cd cs

d_C_prim_hWaitForInputs :: Curry_Prelude.OP_List C_Handle -> Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_Int
d_C_prim_hWaitForInputs x1 x2 cd cs = external_d_C_prim_hWaitForInputs x1 x2 cd
  cs

d_C_prim_hWaitForInputsOrMsg :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_List C_Handle -> Curry_Prelude.OP_List t0 -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_Either
  Curry_Prelude.C_Int (Curry_Prelude.OP_List t0))
d_C_prim_hWaitForInputsOrMsg x1 x2 cd cs = external_d_C_prim_hWaitForInputsOrMsg
  x1 x2 cd cs

d_C_prim_hGetChar :: C_Handle -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.C_Char
d_C_prim_hGetChar x1 cd cs = external_d_C_prim_hGetChar x1 cd cs

d_C_prim_hPutChar :: C_Handle -> Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_prim_hPutChar x1 x2 cd cs = external_d_C_prim_hPutChar x1 x2 cd cs

d_C_prim_hIsReadable :: C_Handle -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.C_Bool
d_C_prim_hIsReadable x1 cd cs = external_d_C_prim_hIsReadable x1 cd cs

d_C_prim_hIsWritable :: C_Handle -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.C_Bool
d_C_prim_hIsWritable x1 cd cs = external_d_C_prim_hIsWritable x1 cd cs

d_C_prim_hIsTerminalDevice :: C_Handle -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.C_Bool
d_C_prim_hIsTerminalDevice x1 cd cs = external_d_C_prim_hIsTerminalDevice x1 cd
  cs

type C_Handle = PrimData CurryHandle

instance ConvertCurryHaskell C_IOMode IOMode where
  toCurry ReadMode   = C_ReadMode
  toCurry WriteMode  = C_WriteMode
  toCurry AppendMode = C_AppendMode

  fromCurry C_ReadMode   = ReadMode
  fromCurry C_WriteMode  = WriteMode
  fromCurry C_AppendMode = AppendMode
  fromCurry _            = error "IOMode data with no ground term occurred"

instance ConvertCurryHaskell C_SeekMode SeekMode where
  toCurry AbsoluteSeek = C_AbsoluteSeek
  toCurry RelativeSeek = C_RelativeSeek
  toCurry SeekFromEnd  = C_SeekFromEnd

  fromCurry C_AbsoluteSeek = AbsoluteSeek
  fromCurry C_RelativeSeek = RelativeSeek
  fromCurry C_SeekFromEnd  = SeekFromEnd
  fromCurry _            = error "SeekMode data with no ground term occurred"


external_d_C_handle_eq :: C_Handle -> C_Handle -> Cover -> ConstStore -> Curry_Prelude.C_Bool
external_d_C_handle_eq (PrimData h1) (PrimData h2) _ _ = toCurry (h1 == h2)

external_d_C_stdin :: Cover -> ConstStore -> C_Handle
external_d_C_stdin _ _ = PrimData (OneHandle stdin)

external_d_C_stdout :: Cover -> ConstStore -> C_Handle
external_d_C_stdout _ _ = PrimData (OneHandle stdout)

external_d_C_stderr :: Cover -> ConstStore -> C_Handle
external_d_C_stderr _ _ = PrimData (OneHandle stderr)

external_d_C_prim_openFile :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> C_IOMode
                           -> Cover -> ConstStore -> Curry_Prelude.C_IO C_Handle
external_d_C_prim_openFile fn  mode _ _ =
  toCurry (\s m -> openFile s m >>= return . OneHandle) fn mode

external_d_C_prim_hClose :: C_Handle -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
external_d_C_prim_hClose handle _ _ = toCurry
  (\ch -> case ch of OneHandle h       -> hClose h
                     InOutHandle h1 h2 -> hClose h1 >> hClose h2) handle

external_d_C_prim_hFlush :: C_Handle -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
external_d_C_prim_hFlush h _ _ = toCurry (hFlush . outputHandle) h

external_d_C_prim_hIsEOF :: C_Handle -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_Bool
external_d_C_prim_hIsEOF h _ _ = toCurry (hIsEOF . inputHandle) h

external_d_C_prim_hSeek :: C_Handle -> C_SeekMode -> Curry_Prelude.C_Int
                        -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
external_d_C_prim_hSeek handle mode i _ _
  = toCurry (hSeek . inputHandle) handle mode i

external_d_C_prim_hWaitForInput :: C_Handle -> Curry_Prelude.C_Int -> Cover -> ConstStore
                                -> Curry_Prelude.C_IO Curry_Prelude.C_Bool
external_d_C_prim_hWaitForInput handle timeout _ _
  = toCurry (myhWaitForInput . inputHandle) handle timeout

myhWaitForInput :: Handle -> Int -> IO Bool
myhWaitForInput h timeout = C.catch (hWaitForInput h timeout) handler
  where
  handler :: C.IOException -> IO Bool
  handler e = if isEOFError e then return False else C.throw e

external_d_C_prim_hWaitForInputs :: Curry_Prelude.OP_List C_Handle -> Curry_Prelude.C_Int
                                 -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_Int
external_d_C_prim_hWaitForInputs hs i _ _ = toCurry selectHandle hs i

selectHandle :: [CurryHandle] -> Int -> IO Int
selectHandle handles timeout = do
  mvar <- newEmptyMVar
  threads <- zipWithM
              (\ i h -> forkIO (waitOnHandle (inputHandle h) i timeout mvar))
              [0 ..] handles
  inspectRes (length handles) mvar threads

inspectRes :: Int -> MVar (Maybe Int) -> [ThreadId] -> IO Int
inspectRes 0 _    _       = return (-1)
inspectRes n mvar threads = do
  res <- takeMVar mvar
  case res of
    Nothing -> inspectRes (n - 1) mvar threads
    Just v  -> mapM_ killThread threads >> return v

waitOnHandle :: Handle -> Int -> Int -> MVar (Maybe Int) -> IO ()
waitOnHandle h v timeout mvar = do
  ready <- myhWaitForInput h timeout
  putMVar mvar (if ready then Just v else Nothing)

external_d_C_prim_hWaitForInputsOrMsg ::
 Curry_Prelude.Curry a => Curry_Prelude.OP_List C_Handle -> Curry_Prelude.OP_List a -> Cover -> ConstStore
               -> Curry_Prelude.C_IO (Curry_Prelude.C_Either Curry_Prelude.C_Int (Curry_Prelude.OP_List a))
external_d_C_prim_hWaitForInputsOrMsg = error "hWaitForInputsOrMsg undefined"

external_d_C_prim_hGetChar :: C_Handle -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_Char
external_d_C_prim_hGetChar h _ _ = toCurry (hGetChar . inputHandle) h

external_d_C_prim_hPutChar :: C_Handle -> Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
external_d_C_prim_hPutChar h c _ _ = toCurry (hPutChar . outputHandle) h c

external_d_C_prim_hIsReadable :: C_Handle -> Cover -> ConstStore
                              -> Curry_Prelude.C_IO Curry_Prelude.C_Bool
external_d_C_prim_hIsReadable h _ _ = toCurry (hIsReadable . inputHandle) h

external_d_C_prim_hIsWritable :: C_Handle -> Cover -> ConstStore
                              -> Curry_Prelude.C_IO Curry_Prelude.C_Bool
external_d_C_prim_hIsWritable h _ _ = toCurry (hIsWritable . outputHandle) h

external_d_C_prim_hIsTerminalDevice :: C_Handle -> Cover -> ConstStore
                              -> Curry_Prelude.C_IO Curry_Prelude.C_Bool
external_d_C_prim_hIsTerminalDevice h _ _ =
    toCurry (hIsTerminalDevice . outputHandle) h
