{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE Rank2Types #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif
{-# LANGUAGE MultiParamTypeClasses #-}

module Curry_IOExts
  ( C_IORef (..)
  , d_C_execCmd
  , d_C_evalCmd
  , d_C_connectToCommand
  , d_C_readCompleteFile
  , d_C_updateFile
  , nd_C_updateFile
  , d_C_exclusiveIO
  , nd_C_exclusiveIO
  , d_C_setAssoc
  , d_C_getAssoc
  , d_C_readIORef
  , d_C_writeIORef
  , d_C_modifyIORef
  , nd_C_modifyIORef
  , d_C_newIORef )
  where

import Basics
import qualified Curry_IO
import qualified Curry_Prelude
import qualified Curry_System

import Data.IORef
import System.IO.Unsafe   (unsafePerformIO) -- for global associations
import System.Process     (readProcessWithExitCode, runInteractiveCommand)
import Control.Concurrent (forkIO)
import System.IO

d_C_execCmd :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO (Curry_Prelude.OP_Tuple3 Curry_IO.C_Handle
  Curry_IO.C_Handle Curry_IO.C_Handle)
d_C_execCmd x1 cd cs = Curry_Prelude.d_OP_dollar_hash_hash d_C_prim_execCmd x1
  cd cs

d_C_evalCmd :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO (Curry_Prelude.OP_Tuple3 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C_evalCmd x1 x2 x3 cd cs = Curry_Prelude.d_OP_dollar_hash_hash
  (Curry_Prelude.d_OP_dollar_hash_hash (Curry_Prelude.d_OP_dollar_hash_hash
  (acceptCs (acceptCs id) d_C_prim_evalCmd) x1 cd cs) x2 cd cs) x3 cd cs

d_C_connectToCommand :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_IO.C_Handle
d_C_connectToCommand x1 cd cs = Curry_Prelude.d_OP_dollar_hash_hash
  d_C_prim_connectToCmd x1 cd cs

d_C_readCompleteFile :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_readCompleteFile x1 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Prelude.d_C_readFile x1 cd cs)
  d_OP_readCompleteFile_dot_uscore_hash_lambda2 cd cs

d_OP_readCompleteFile_dot_f_dot_8 :: forall t0 t1 . (Curry_Prelude.Curry t1
  , Curry_Prelude.Curry t0) => Curry_Prelude.OP_List t0 -> t1 -> Cover
  -> ConstStore -> t1
d_OP_readCompleteFile_dot_f_dot_8 x1 x2 cd cs = case x1 of
  Curry_Prelude.OP_List -> x2
  Curry_Prelude.OP_Cons x3 x4 -> d_OP_readCompleteFile_dot_f_dot_8 x4 x2 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_readCompleteFile_dot_f_dot_8 l x2 cd cs)
    (d_OP_readCompleteFile_dot_f_dot_8 r x2 cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_readCompleteFile_dot_f_dot_8 z x2 cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_readCompleteFile_dot_f_dot_8 e x2 cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "IOExts.readCompleteFile.f.8" [show x1, show x2] info)
  _ -> failCons cd (consFail "IOExts.readCompleteFile.f.8" (showCons x1))

d_OP_readCompleteFile_dot_uscore_hash_lambda2 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_readCompleteFile_dot_uscore_hash_lambda2 x1 cd cs = let x2 = x1
  in d_OP_readCompleteFile_dot_f_dot_8 x2
  (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  x2 cd cs) cd cs

d_C_updateFile :: (Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_updateFile x1 x2 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (d_C_readCompleteFile x2 cd cs) (d_OP_updateFile_dot_uscore_hash_lambda5 x2
  x1) cd cs

nd_C_updateFile :: Func (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
nd_C_updateFile x1 x2 s cd cs = let s0 = s
  in s0 `seq`
  Curry_Prelude.nd_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (d_C_readCompleteFile x2 cd cs) (wrapNX id
  (nd_OP_updateFile_dot_uscore_hash_lambda5 x2 x1)) s0 cd cs

d_OP_updateFile_dot_uscore_hash_lambda5 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> (Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_OP_updateFile_dot_uscore_hash_lambda5 x1 x2 x3 cd cs = let x4 = x3
  in Curry_Prelude.d_C_writeFile x1 (Curry_Prelude.d_C_apply x2 x4 cd cs) cd cs

nd_OP_updateFile_dot_uscore_hash_lambda5 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Func (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
nd_OP_updateFile_dot_uscore_hash_lambda5 x1 x2 x3 s cd cs = let s0 = s
  in s0 `seq` (let x4 = x3
  in Curry_Prelude.d_C_writeFile x1 (Curry_Prelude.nd_C_apply x2 x4 s0 cd cs) cd
  cs)

d_C_exclusiveIO :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_IO t0 -> Cover -> ConstStore
  -> Curry_Prelude.C_IO t0
d_C_exclusiveIO x1 x2 cd cs = let x3 = Curry_Prelude.d_OP_dollar
                                    Curry_System.d_C_system
                                    (Curry_Prelude.d_OP_plus_plus
                                    (Curry_Prelude.toCurryString
                                    "lockfile-remove --lock-name ") x1 cd cs) cd
                                    cs
  in Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_System.d_C_system (Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.toCurryString "lockfile-create --lock-name ") x1 cd cs) cd cs)
  (Curry_Prelude.d_C_catch
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  x2 (d_OP_exclusiveIO_dot_uscore_hash_lambda8 x3) cd cs)
  (d_OP_exclusiveIO_dot_uscore_hash_lambda10 x3) cd cs) cd cs

nd_C_exclusiveIO :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_IO t0
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.C_IO t0
nd_C_exclusiveIO x1 x2 s cd cs = let s6 = s
  in s6 `seq` (let s0 = leftSupply s6
                   s5 = rightSupply s6
  in s0 `seq` (s5 `seq` (let x3 = Curry_Prelude.nd_OP_dollar (wrapDX id
                               Curry_System.d_C_system)
                               (Curry_Prelude.d_OP_plus_plus
                               (Curry_Prelude.toCurryString
                               "lockfile-remove --lock-name ") x1 cd cs) s0 cd
                               cs
  in let s4 = leftSupply s5
         s3 = rightSupply s5
  in s4 `seq` (s3 `seq`
  Curry_Prelude.nd_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_System.d_C_system (Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.toCurryString "lockfile-create --lock-name ") x1 cd cs) cd cs)
  (let s2 = leftSupply s3
       s1 = rightSupply s3
  in s2 `seq` (s1 `seq` Curry_Prelude.nd_C_catch
  (Curry_Prelude.nd_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  x2 (wrapNX id (nd_OP_exclusiveIO_dot_uscore_hash_lambda8 x3)) s1 cd cs)
  (wrapNX id (nd_OP_exclusiveIO_dot_uscore_hash_lambda10 x3)) s2 cd cs)) s4 cd
  cs))))

d_OP_exclusiveIO_dot_uscore_hash_lambda8 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_IO Curry_Prelude.C_Int -> t0 -> Cover -> ConstStore
  -> Curry_Prelude.C_IO t0
d_OP_exclusiveIO_dot_uscore_hash_lambda8 x1 x2 cd cs = let x3 = x2
  in Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  x1
  (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  x3 cd cs) cd cs

nd_OP_exclusiveIO_dot_uscore_hash_lambda8 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_IO Curry_Prelude.C_Int -> t0 -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.C_IO t0
nd_OP_exclusiveIO_dot_uscore_hash_lambda8 x1 x2 s cd cs = let s0 = s
  in s0 `seq` (let x3 = x2
  in Curry_Prelude.nd_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  x1
  (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  x3 cd cs) s0 cd cs)

d_OP_exclusiveIO_dot_uscore_hash_lambda10 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_IO Curry_Prelude.C_Int -> Curry_Prelude.C_IOError
  -> Cover -> ConstStore -> Curry_Prelude.C_IO t0
d_OP_exclusiveIO_dot_uscore_hash_lambda10 x1 x2 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  x1 (Curry_Prelude.d_C_ioError x2 cd cs) cd cs

nd_OP_exclusiveIO_dot_uscore_hash_lambda10 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_IO Curry_Prelude.C_Int -> Curry_Prelude.C_IOError
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.C_IO t0
nd_OP_exclusiveIO_dot_uscore_hash_lambda10 x1 x2 s cd cs = let s0 = s
  in s0 `seq`
  Curry_Prelude.nd_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  x1 (Curry_Prelude.d_C_ioError x2 cd cs) s0 cd cs

d_C_setAssoc :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_setAssoc x1 x2 cd cs = Curry_Prelude.d_OP_dollar_hash_hash
  (Curry_Prelude.d_OP_dollar_hash_hash (acceptCs id d_C_prim_setAssoc) x1 cd cs)
  x2 cd cs

d_C_getAssoc :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_getAssoc x1 cd cs = Curry_Prelude.d_OP_dollar_hash_hash d_C_prim_getAssoc x1
  cd cs

d_C_readIORef :: forall t0 . (Curry_Prelude.Curry t0) => C_IORef t0 -> Cover
  -> ConstStore -> Curry_Prelude.C_IO t0
d_C_readIORef x1 cd cs = Curry_Prelude.d_OP_dollar_hash d_C_prim_readIORef x1 cd
  cs

d_C_writeIORef :: forall t0 . (Curry_Prelude.Curry t0) => C_IORef t0 -> t0
  -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_writeIORef x1 x2 cd cs = Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_dollar_hash (acceptCs id d_C_prim_writeIORef) x1 cd cs) x2
  cd cs

d_C_modifyIORef :: forall t0 . (Curry_Prelude.Curry t0) => C_IORef t0 -> (t0
  -> Cover -> ConstStore -> t0) -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
d_C_modifyIORef x1 x2 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (d_C_readIORef x1 cd cs) (Curry_Prelude.d_OP_dot (d_C_writeIORef x1) x2 cd cs)
  cd cs

nd_C_modifyIORef :: forall t0 . (Curry_Prelude.Curry t0) => C_IORef t0 -> Func
  t0 t0 -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
nd_C_modifyIORef x1 x2 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq`
  Curry_Prelude.nd_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (d_C_readIORef x1 cd cs) (Curry_Prelude.nd_OP_dot (wrapDX id (d_C_writeIORef
  x1)) x2 s0 cd cs) s1 cd cs))

d_C_prim_execCmd :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_Tuple3 Curry_IO.C_Handle
  Curry_IO.C_Handle Curry_IO.C_Handle)
d_C_prim_execCmd x1 cd cs = external_d_C_prim_execCmd x1 cd cs

d_C_prim_evalCmd :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO (Curry_Prelude.OP_Tuple3 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C_prim_evalCmd x1 x2 x3 cd cs = external_d_C_prim_evalCmd x1 x2 x3 cd cs

d_C_prim_connectToCmd :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_IO.C_Handle
d_C_prim_connectToCmd x1 cd cs = external_d_C_prim_connectToCmd x1 cd cs

d_C_prim_setAssoc :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_prim_setAssoc x1 x2 cd cs = external_d_C_prim_setAssoc x1 x2 cd cs

d_C_prim_getAssoc :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_prim_getAssoc x1 cd cs = external_d_C_prim_getAssoc x1 cd cs

d_C_newIORef :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (C_IORef t0)
d_C_newIORef x1 cd cs = external_d_C_newIORef x1 cd cs

d_C_prim_readIORef :: forall t0 . (Curry_Prelude.Curry t0) => C_IORef t0
  -> Cover -> ConstStore -> Curry_Prelude.C_IO t0
d_C_prim_readIORef x1 cd cs = external_d_C_prim_readIORef x1 cd cs

d_C_prim_writeIORef :: forall t0 . (Curry_Prelude.Curry t0) => C_IORef t0 -> t0
  -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_prim_writeIORef x1 x2 cd cs = external_d_C_prim_writeIORef x1 x2 cd cs

external_d_C_prim_execCmd :: Curry_Prelude.C_String -> Cover -> ConstStore
  -> Curry_Prelude.C_IO (Curry_Prelude.OP_Tuple3 Curry_IO.C_Handle Curry_IO.C_Handle Curry_IO.C_Handle)
external_d_C_prim_execCmd str _ _ = toCurry
  (\s -> do (h1,h2,h3,_) <- runInteractiveCommand s
            return (OneHandle h1, OneHandle h2, OneHandle h3)) str

external_d_C_prim_evalCmd :: Curry_Prelude.C_String -> Curry_Prelude.OP_List Curry_Prelude.C_String -> Curry_Prelude.C_String
  -> Cover -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_Tuple3 Curry_Prelude.C_Int Curry_Prelude.C_String Curry_Prelude.C_String)
external_d_C_prim_evalCmd cmd args input _ _
  = toCurry readProcessWithExitCode cmd args input

external_d_C_prim_connectToCmd :: Curry_Prelude.C_String -> Cover -> ConstStore
                               -> Curry_Prelude.C_IO Curry_IO.C_Handle
external_d_C_prim_connectToCmd str _ _ = toCurry
  (\s -> do (hin,hout,herr,_) <- runInteractiveCommand s
            forkIO (forwardError herr)
            return (InOutHandle hout hin)) str

forwardError :: Handle -> IO ()
forwardError h = do
   eof <- hIsEOF h
   if eof then return ()
          else hGetLine h >>= hPutStrLn stderr >> forwardError h


-----------------------------------------------------------------------
-- Implementation of global associations as simple association lists
-- (could be later improved by a more efficient implementation, e.g., maps)

type Assocs = [(String,String)]

assocs :: IORef Assocs
assocs = unsafePerformIO (newIORef [])

external_d_C_prim_setAssoc :: Curry_Prelude.C_String -> Curry_Prelude.C_String -> Cover -> ConstStore
                           -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
external_d_C_prim_setAssoc str1 str2 _ _ = toCurry
  (\key val -> do as <- readIORef assocs
                  writeIORef assocs ((key,val):as)) str1 str2

external_d_C_prim_getAssoc :: Curry_Prelude.C_String -> Cover -> ConstStore
                           -> Curry_Prelude.C_IO (Curry_Prelude.C_Maybe (Curry_Prelude.C_String))
external_d_C_prim_getAssoc str _ _ = toCurry
  (\key -> do as <- readIORef assocs
              return (lookup key as)) str

-----------------------------------------------------------------------
-- Implementation of IORefs in Curry. Note that we store Curry values
-- (and not the corresponding Haskell values) in the Haskell IORefs
data C_IORef a
    = Choice_C_IORef Cover ID (C_IORef a) (C_IORef a)
    | Choices_C_IORef Cover ID ([C_IORef a])
    | Fail_C_IORef Cover FailInfo
    | Guard_C_IORef Cover  Constraints (C_IORef a)
    | C_IORef (IORef a)

instance Show (C_IORef a) where
  show = error "ERROR: no show for IORef"

instance Read (C_IORef a) where
  readsPrec = error "ERROR: no read for IORef"

instance NonDet (C_IORef a) where
  choiceCons = Choice_C_IORef
  choicesCons = Choices_C_IORef
  failCons = Fail_C_IORef
  guardCons = Guard_C_IORef
  try (Choice_C_IORef cd i x y) = tryChoice cd i x y
  try (Choices_C_IORef cd s xs) = tryChoices cd s xs
  try (Fail_C_IORef cd info) = Fail cd info
  try (Guard_C_IORef cd c e) = Guard cd c e
  try x = Val x
  match f _ _ _ _ _ (Choice_C_IORef  cd i x y)                 = f cd i x y
  match _ f _ _ _ _ (Choices_C_IORef cd i@(NarrowedID _ _) xs) = f cd i xs
  match _ _ f _ _ _ (Choices_C_IORef cd i@(FreeID _ _)     xs) = f cd i xs
  match _ _ _ _ _ _ (Choices_C_IORef _ i _)      =
    error ("IOExts.IORef.match: Choices with ChoiceID " ++ show i)
  match _ _ _ f _ _ (Fail_C_IORef cd info)                     = f cd info
  match _ _ _ _ f _ (Guard_C_IORef cd cs e)                    = f cd cs e
  match _ _ _ _ _ f x                                          = f x

instance Generable (C_IORef a) where
  generate _ _ = error "ERROR: no generator for IORef"

instance NormalForm (C_IORef a) where
  ($!!) cont ioref@(C_IORef _)            cd cs = cont ioref cd cs
  ($!!) cont (Choice_C_IORef d i io1 io2) cd cs = nfChoice cont d i io1 io2 cd cs
  ($!!) cont (Choices_C_IORef d i ios)    cd cs = nfChoices cont d  i ios cd cs
  ($!!) cont (Guard_C_IORef d c io)       cd cs
    = guardCons d c ((cont $!! io) cd $! (addCs c cs))
  ($!!) _    (Fail_C_IORef d info)        _  _  = failCons d info
  ($##) cont io@(C_IORef _)               cd cs = cont io cd cs
  ($##) cont (Choice_C_IORef d i io1 io2) cd cs = gnfChoice cont d i io1 io2 cd cs
  ($##) cont (Choices_C_IORef d i ios)    cd cs = gnfChoices cont d i ios cd cs
  ($##) cont (Guard_C_IORef d c io)       cd cs
    = guardCons d c ((cont $## io) cd $! (addCs c cs))
  ($##) _    (Fail_C_IORef d info)        cd cs = failCons d info
  searchNF _ cont ioref@(C_IORef _)        = cont ioref

instance Unifiable (C_IORef a) where
  (=.=) _ _ = error "(=.=) for C_IORef"
  (=.<=) _ _ = error "(=.<=) for C_IORef"
  bind cd i (Choice_C_IORef d j l r) = [(ConstraintChoice d j (bind cd i l) (bind cd i r))]
  bind cd i (Choices_C_IORef d j@(FreeID _ _) xs) = bindOrNarrow cd i d j xs
  bind cd i (Choices_C_IORef d j@(NarrowedID _ _) xs) = [(ConstraintChoices d j (map (bind cd i) xs))]
  bind _  _ (Fail_C_IORef cd info) = [Unsolvable info]
  bind cd i (Guard_C_IORef _ cs e) = (getConstrList cs) ++ (bind cd i e)
  lazyBind cd i (Choice_C_IORef d j l r) = [(ConstraintChoice d j (lazyBind cd i l) (lazyBind cd i r))]
  lazyBind cd i (Choices_C_IORef d j@(FreeID _ _) xs) = lazyBindOrNarrow cd i d j xs
  lazyBind cd i (Choices_C_IORef d j@(NarrowedID _ _) xs) = [(ConstraintChoices d j (map (lazyBind cd i) xs))]
  lazyBind _  _ (Fail_C_IORef cd info) = [Unsolvable info]
  lazyBind cd i (Guard_C_IORef _ cs e) = (getConstrList cs) ++ [(i :=: (LazyBind (lazyBind cd i e)))]

instance Curry_Prelude.Curry a => Curry_Prelude.Curry (C_IORef a)

instance ConvertCurryHaskell (C_IORef a) (IORef a) where
  fromCurry (C_IORef r) = r
  fromCurry _           = error "IORef with no ground term occurred"
  toCurry r             = C_IORef r

external_d_C_newIORef :: Curry_Prelude.Curry a => a -> Cover -> ConstStore
                      -> Curry_Prelude.C_IO (C_IORef a)
external_d_C_newIORef cv _ _ = toCurry (newIORef cv)

external_d_C_prim_readIORef :: Curry_Prelude.Curry a => C_IORef a -> Cover -> ConstStore
                            -> Curry_Prelude.C_IO a
external_d_C_prim_readIORef ref _ _ = fromIO (readIORef (fromCurry ref))

external_d_C_prim_writeIORef :: Curry_Prelude.Curry a => C_IORef a -> a
                             -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
external_d_C_prim_writeIORef ref cv _ _ = toCurry (writeIORef (fromCurry ref) cv)
