{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE Rank2Types #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module Curry_Maybe
  ( d_C_isJust
  , d_C_isNothing
  , d_C_fromJust
  , d_C_fromMaybe
  , d_C_listToMaybe
  , d_C_maybeToList
  , d_C_catMaybes
  , d_C_mapMaybe
  , nd_C_mapMaybe
  , d_OP_gt_gt_minus
  , nd_OP_gt_gt_minus
  , d_C_sequenceMaybe
  , d_C_mapMMaybe
  , nd_C_mapMMaybe
  , d_C_mplus )
  where

import Basics
import qualified Curry_Prelude


d_C_isJust :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Maybe t0
  -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_isJust x1 cd cs = case x1 of
  Curry_Prelude.C_Just x2 -> Curry_Prelude.C_True
  Curry_Prelude.C_Nothing -> Curry_Prelude.C_False
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (d_C_isJust l cd cs)
    (d_C_isJust r cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> d_C_isJust z cd
    cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (d_C_isJust e cd $! addCs c
    cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail "Maybe.isJust"
    [show x1] info)
  _ -> failCons cd (consFail "Maybe.isJust" (showCons x1))

d_C_isNothing :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Maybe
  t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_isNothing x1 cd cs = case x1 of
  Curry_Prelude.C_Nothing -> Curry_Prelude.C_True
  Curry_Prelude.C_Just x2 -> Curry_Prelude.C_False
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (d_C_isNothing l cd cs)
    (d_C_isNothing r cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> d_C_isNothing z
    cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (d_C_isNothing e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail "Maybe.isNothing"
    [show x1] info)
  _ -> failCons cd (consFail "Maybe.isNothing" (showCons x1))

d_C_fromJust :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Maybe t0
  -> Cover -> ConstStore -> t0
d_C_fromJust x1 cd cs = case x1 of
  Curry_Prelude.C_Just x2 -> x2
  Curry_Prelude.C_Nothing -> Curry_Prelude.d_C_error
    (Curry_Prelude.toCurryString "Maybe.fromJust: Nothing") cd cs
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (d_C_fromJust l cd cs)
    (d_C_fromJust r cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> d_C_fromJust z
    cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (d_C_fromJust e cd $! addCs
    c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail "Maybe.fromJust"
    [show x1] info)
  _ -> failCons cd (consFail "Maybe.fromJust" (showCons x1))

d_C_fromMaybe :: forall t0 . (Curry_Prelude.Curry t0) => t0
  -> Curry_Prelude.C_Maybe t0 -> Cover -> ConstStore -> t0
d_C_fromMaybe x1 x2 cd cs = case x2 of
  Curry_Prelude.C_Nothing -> x1
  Curry_Prelude.C_Just x3 -> x3
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (d_C_fromMaybe x1 l cd cs)
    (d_C_fromMaybe x1 r cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> d_C_fromMaybe x1
    z cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (d_C_fromMaybe x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail "Maybe.fromMaybe"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Maybe.fromMaybe" (showCons x2))

d_C_listToMaybe :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  t0 -> Cover -> ConstStore -> Curry_Prelude.C_Maybe t0
d_C_listToMaybe x1 cd cs = case x1 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_Nothing
  Curry_Prelude.OP_Cons x2 x3 -> Curry_Prelude.C_Just x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_listToMaybe l cd cs)
    (d_C_listToMaybe r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_listToMaybe
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_listToMaybe e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Maybe.listToMaybe"
    [show x1] info)
  _ -> failCons cd (consFail "Maybe.listToMaybe" (showCons x1))

d_C_maybeToList :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Maybe
  t0 -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_C_maybeToList x1 cd cs = case x1 of
  Curry_Prelude.C_Nothing -> Curry_Prelude.OP_List
  Curry_Prelude.C_Just x2 -> Curry_Prelude.OP_Cons x2 Curry_Prelude.OP_List
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (d_C_maybeToList l cd cs)
    (d_C_maybeToList r cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> d_C_maybeToList
    z cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (d_C_maybeToList e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail "Maybe.maybeToList"
    [show x1] info)
  _ -> failCons cd (consFail "Maybe.maybeToList" (showCons x1))

d_C_catMaybes :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  (Curry_Prelude.C_Maybe t0) -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_C_catMaybes x1 cd cs = Curry_Prelude.d_C_foldr (acceptCs id
  d_OP_catMaybes_dot_uscore_hash_lambda3) Curry_Prelude.OP_List x1 cd cs

d_OP_catMaybes_dot_uscore_hash_lambda3 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_Maybe t0 -> Curry_Prelude.OP_List t0 -> Cover
  -> ConstStore -> Curry_Prelude.OP_List t0
d_OP_catMaybes_dot_uscore_hash_lambda3 x1 x2 cd cs = case x1 of
  Curry_Prelude.C_Just x3 -> Curry_Prelude.OP_Cons x3 x2
  Curry_Prelude.C_Nothing -> x2
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i
    (d_OP_catMaybes_dot_uscore_hash_lambda3 l x2 cd cs)
    (d_OP_catMaybes_dot_uscore_hash_lambda3 r x2 cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z ->
    d_OP_catMaybes_dot_uscore_hash_lambda3 z x2 cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c
    (d_OP_catMaybes_dot_uscore_hash_lambda3 e x2 cd $! addCs c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail
    "Maybe.catMaybes._#lambda3" [show x1, show x2] info)
  _ -> failCons cd (consFail "Maybe.catMaybes._#lambda3" (showCons x1))

d_C_mapMaybe :: forall t0 t1 . (Curry_Prelude.Curry t1, Curry_Prelude.Curry
  t0) => (t0 -> Cover -> ConstStore -> Curry_Prelude.C_Maybe t1) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t1
d_C_mapMaybe x1 cd cs = Curry_Prelude.d_OP_dot d_C_catMaybes
  (Curry_Prelude.d_C_map x1) cd cs

nd_C_mapMaybe :: forall t0 t1 . (Curry_Prelude.Curry t1, Curry_Prelude.Curry
  t0) => Func t0 (Curry_Prelude.C_Maybe t1) -> IDSupply -> Cover -> ConstStore
  -> Func (Curry_Prelude.OP_List t0) (Curry_Prelude.OP_List t1)
nd_C_mapMaybe x1 s cd cs = let s0 = s
  in s0 `seq` Curry_Prelude.nd_OP_dot (wrapDX id d_C_catMaybes) (wrapNX id
  (Curry_Prelude.nd_C_map x1)) s0 cd cs

d_OP_gt_gt_minus :: forall t0 t1 . (Curry_Prelude.Curry t1, Curry_Prelude.Curry
  t0) => Curry_Prelude.C_Maybe t0 -> (t0 -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe t1) -> Cover -> ConstStore -> Curry_Prelude.C_Maybe
  t1
d_OP_gt_gt_minus x1 x2 cd cs = case x1 of
  Curry_Prelude.C_Nothing -> Curry_Prelude.C_Nothing
  Curry_Prelude.C_Just x3 -> Curry_Prelude.d_C_apply x2 x3 cd cs
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (d_OP_gt_gt_minus l x2 cd
    cs) (d_OP_gt_gt_minus r x2 cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> d_OP_gt_gt_minus
    z x2 cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (d_OP_gt_gt_minus e x2
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail "Maybe.>>-" [show
    x1, show x2] info)
  _ -> failCons cd (consFail "Maybe.>>-" (showCons x1))

nd_OP_gt_gt_minus :: forall t0 t1 . (Curry_Prelude.Curry t1, Curry_Prelude.Curry
  t0) => Curry_Prelude.C_Maybe t0 -> Func t0 (Curry_Prelude.C_Maybe t1)
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.C_Maybe t1
nd_OP_gt_gt_minus x1 x2 s cd cs = case x1 of
  Curry_Prelude.C_Nothing -> Curry_Prelude.C_Nothing
  Curry_Prelude.C_Just x3 -> let s0 = s
    in s0 `seq` Curry_Prelude.nd_C_apply x2 x3 s0 cd cs
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (nd_OP_gt_gt_minus l x2 s
    cd cs) (nd_OP_gt_gt_minus r x2 s cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z ->
    nd_OP_gt_gt_minus z x2 s cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (nd_OP_gt_gt_minus e x2 s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail "Maybe.>>-" [show
    x1, show x2] info)
  _ -> failCons cd (consFail "Maybe.>>-" (showCons x1))

d_C_sequenceMaybe :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_List (Curry_Prelude.C_Maybe t0) -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List t0)
d_C_sequenceMaybe x1 cd cs = case x1 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_Just Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x2 x3 -> d_OP_gt_gt_minus x2
    (d_OP_sequenceMaybe_dot_uscore_hash_lambda5 x3) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_sequenceMaybe l cd cs)
    (d_C_sequenceMaybe r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_C_sequenceMaybe z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_sequenceMaybe e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Maybe.sequenceMaybe" [show x1] info)
  _ -> failCons cd (consFail "Maybe.sequenceMaybe" (showCons x1))

d_OP_sequenceMaybe_dot_uscore_hash_lambda5 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_List (Curry_Prelude.C_Maybe t0) -> t0 -> Cover
  -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List t0)
d_OP_sequenceMaybe_dot_uscore_hash_lambda5 x1 x2 cd cs = d_OP_gt_gt_minus
  (d_C_sequenceMaybe x1 cd cs)
  (d_OP_sequenceMaybe_dot_uscore_hash_lambda5_dot_uscore_hash_lambda6 x2) cd cs

d_OP_sequenceMaybe_dot_uscore_hash_lambda5_dot_uscore_hash_lambda6 :: forall t0 . (Curry_Prelude.Curry
  t0) => t0 -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List t0)
d_OP_sequenceMaybe_dot_uscore_hash_lambda5_dot_uscore_hash_lambda6 x1 x2 cd cs =
  Curry_Prelude.C_Just (Curry_Prelude.OP_Cons x1 x2)

d_C_mapMMaybe :: forall t0 t1 . (Curry_Prelude.Curry t1, Curry_Prelude.Curry
  t0) => (t0 -> Cover -> ConstStore -> Curry_Prelude.C_Maybe t1) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List t1)
d_C_mapMMaybe x1 cd cs = Curry_Prelude.d_OP_dot d_C_sequenceMaybe
  (Curry_Prelude.d_C_map x1) cd cs

nd_C_mapMMaybe :: forall t0 t1 . (Curry_Prelude.Curry t1, Curry_Prelude.Curry
  t0) => Func t0 (Curry_Prelude.C_Maybe t1) -> IDSupply -> Cover -> ConstStore
  -> Func (Curry_Prelude.OP_List t0) (Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_List t1))
nd_C_mapMMaybe x1 s cd cs = let s0 = s
  in s0 `seq` Curry_Prelude.nd_OP_dot (wrapDX id d_C_sequenceMaybe) (wrapNX id
  (Curry_Prelude.nd_C_map x1)) s0 cd cs

d_C_mplus :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Maybe t0
  -> Curry_Prelude.C_Maybe t0 -> Cover -> ConstStore -> Curry_Prelude.C_Maybe t0
d_C_mplus x1 x2 cd cs = case x1 of
  Curry_Prelude.C_Nothing -> x2
  Curry_Prelude.C_Just x3 -> x1
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (d_C_mplus l x2 cd cs)
    (d_C_mplus r x2 cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> d_C_mplus z x2
    cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (d_C_mplus e x2 cd $! addCs
    c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail "Maybe.mplus" [show
    x1, show x2] info)
  _ -> failCons cd (consFail "Maybe.mplus" (showCons x1))

