{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE Rank2Types #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module Curry_ReadNumeric
  ( d_C_readInt, d_C_readNat, d_C_readHex, d_C_readOct, d_C_readBin )
  where

import Basics
import qualified Curry_Char
import qualified Curry_Prelude


d_C_readInt :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_readInt x1 cd cs = let x2 = Curry_Prelude.d_C_dropWhile
                             Curry_Char.d_C_isSpace x1 cd cs
  in d_C__case_7 x2 cd cs

d_OP_readInt_dot_uscore_hash_lambda2 :: Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_readInt_dot_uscore_hash_lambda2 x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> Curry_Prelude.C_Just (Curry_Prelude.OP_Tuple2
    (Curry_Prelude.d_OP_uscore_impl_hash_negate_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x2 cd cs) x3)
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_readInt_dot_uscore_hash_lambda2 l cd cs)
    (d_OP_readInt_dot_uscore_hash_lambda2 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_readInt_dot_uscore_hash_lambda2 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_readInt_dot_uscore_hash_lambda2 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "ReadNumeric.readInt._#lambda2" [show x1] info)
  _ -> failCons cd (consFail "ReadNumeric.readInt._#lambda2" (showCons x1))

d_C_readNat :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_readNat x1 cd cs = d_C_readNumPrefix (Curry_Prelude.d_C_dropWhile
  Curry_Char.d_C_isSpace x1 cd cs) Curry_Prelude.C_Nothing (Curry_Prelude.C_Int
  (10)) Curry_Char.d_C_isDigit Curry_Char.d_C_digitToInt cd cs

d_C_readHex :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_readHex x1 cd cs = d_C_readNumPrefix (Curry_Prelude.d_C_dropWhile
  Curry_Char.d_C_isSpace x1 cd cs) Curry_Prelude.C_Nothing (Curry_Prelude.C_Int
  (16)) Curry_Char.d_C_isHexDigit Curry_Char.d_C_digitToInt cd cs

d_C_readOct :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_readOct x1 cd cs = d_C_readNumPrefix (Curry_Prelude.d_C_dropWhile
  Curry_Char.d_C_isSpace x1 cd cs) Curry_Prelude.C_Nothing (Curry_Prelude.C_Int
  (8)) Curry_Char.d_C_isOctDigit Curry_Char.d_C_digitToInt cd cs

d_C_readBin :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_readBin x1 cd cs = d_C_readNumPrefix (Curry_Prelude.d_C_dropWhile
  Curry_Char.d_C_isSpace x1 cd cs) Curry_Prelude.C_Nothing (Curry_Prelude.C_Int
  (2)) Curry_Char.d_C_isBinDigit Curry_Char.d_C_digitToInt cd cs

d_C_readNumPrefix :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Maybe Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> (Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Bool)
  -> (Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Int)
  -> Cover -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_readNumPrefix x1 x2 x3 x4 x5 cd cs = case x1 of
  Curry_Prelude.OP_List -> d_C__case_5 x2 cd cs
  Curry_Prelude.OP_Cons x7 x8 -> d_C__case_4 x7 x4 x5 x3 x8 x2 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_readNumPrefix l x2 x3
    x4 x5 cd cs) (d_C_readNumPrefix r x2 x3 x4 x5 cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_C_readNumPrefix z x2 x3 x4 x5 cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_readNumPrefix e x2 x3
    x4 x5 cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "ReadNumeric.readNumPrefix" [show x1, show x2, show x3, show x4, show x5]
    info)
  _ -> failCons cd (consFail "ReadNumeric.readNumPrefix" (showCons x1))

nd_C_readNumPrefix :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Maybe Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> Func
  Curry_Prelude.C_Char Curry_Prelude.C_Bool -> Func Curry_Prelude.C_Char
  Curry_Prelude.C_Int -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C_readNumPrefix x1 x2 x3 x4 x5 s cd cs = case x1 of
  Curry_Prelude.OP_List -> d_C__case_5 x2 cd cs
  Curry_Prelude.OP_Cons x7 x8 -> let s0 = s
    in s0 `seq` nd_C__case_4 x7 x4 x5 x3 x8 x2 s0 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C_readNumPrefix l x2 x3
    x4 x5 s cd cs) (nd_C_readNumPrefix r x2 x3 x4 x5 s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    nd_C_readNumPrefix z x2 x3 x4 x5 s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C_readNumPrefix e x2 x3
    x4 x5 s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "ReadNumeric.readNumPrefix" [show x1, show x2, show x3, show x4, show x5]
    info)
  _ -> failCons cd (consFail "ReadNumeric.readNumPrefix" (showCons x1))

d_C__case_4 :: Curry_Prelude.C_Char -> (Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool) -> (Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_Int) -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Maybe
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C__case_4 x7 x4 x5 x3 x8 x2 cd cs = case x2 of
  Curry_Prelude.C_Just x9 -> d_C__case_3 x7 x4 x8 x9 x5 x3
    (Curry_Prelude.d_C_apply x4 x7 cd cs) cd cs
  Curry_Prelude.C_Nothing -> d_C__case_1 x7 x4 x5 x3 x8 (Curry_Prelude.d_C_apply
    x4 x7 cd cs) cd cs
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (d_C__case_4 x7 x4 x5 x3 x8
    l cd cs) (d_C__case_4 x7 x4 x5 x3 x8 r cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> d_C__case_4 x7
    x4 x5 x3 x8 z cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (d_C__case_4 x7 x4 x5 x3 x8
    e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail
    "ReadNumeric._case_4" [show x7, show x4, show x5, show x3, show x8, show x2]
    info)
  _ -> failCons cd (consFail "ReadNumeric._case_4" (showCons x2))

nd_C__case_4 :: Curry_Prelude.C_Char -> Func Curry_Prelude.C_Char
  Curry_Prelude.C_Bool -> Func Curry_Prelude.C_Char Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Maybe Curry_Prelude.C_Int -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C__case_4 x7 x4 x5 x3 x8 x2 s cd cs = case x2 of
  Curry_Prelude.C_Just x9 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_C__case_3 x7 x4 x8 x9 x5 x3
    (Curry_Prelude.nd_C_apply x4 x7 s0 cd cs) s1 cd cs))
  Curry_Prelude.C_Nothing -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_C__case_1 x7 x4 x5 x3 x8 (Curry_Prelude.nd_C_apply
    x4 x7 s0 cd cs) s1 cd cs))
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (nd_C__case_4 x7 x4 x5 x3
    x8 l s cd cs) (nd_C__case_4 x7 x4 x5 x3 x8 r s cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> nd_C__case_4 x7
    x4 x5 x3 x8 z s cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (nd_C__case_4 x7 x4 x5 x3
    x8 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail
    "ReadNumeric._case_4" [show x7, show x4, show x5, show x3, show x8, show x2]
    info)
  _ -> failCons cd (consFail "ReadNumeric._case_4" (showCons x2))

d_C__case_1 :: Curry_Prelude.C_Char -> (Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool) -> (Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_Int) -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_1 x7 x4 x5 x3 x8 x9 cd cs = case x9 of
  Curry_Prelude.C_True -> d_C_readNumPrefix x8 (Curry_Prelude.C_Just
    (Curry_Prelude.d_C_apply x5 x7 cd cs)) x3 x4 x5 cd cs
  Curry_Prelude.C_False -> d_C__case_0 (Curry_Prelude.d_C_otherwise cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_1 x7 x4 x5 x3 x8
    l cd cs) (d_C__case_1 x7 x4 x5 x3 x8 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_1 x7 x4
    x5 x3 x8 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_1 x7 x4 x5 x3 x8
    e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "ReadNumeric._case_1" [show x7, show x4, show x5, show x3, show x8, show x9]
    info)
  _ -> failCons cd (consFail "ReadNumeric._case_1" (showCons x9))

nd_C__case_1 :: Curry_Prelude.C_Char -> Func Curry_Prelude.C_Char
  Curry_Prelude.C_Bool -> Func Curry_Prelude.C_Char Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C__case_1 x7 x4 x5 x3 x8 x9 s cd cs = case x9 of
  Curry_Prelude.C_True -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_C_readNumPrefix x8 (Curry_Prelude.C_Just
    (Curry_Prelude.nd_C_apply x5 x7 s0 cd cs)) x3 x4 x5 s1 cd cs))
  Curry_Prelude.C_False -> d_C__case_0 (Curry_Prelude.d_C_otherwise cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_1 x7 x4 x5 x3 x8
    l s cd cs) (nd_C__case_1 x7 x4 x5 x3 x8 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_1 x7
    x4 x5 x3 x8 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_1 x7 x4 x5 x3 x8
    e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "ReadNumeric._case_1" [show x7, show x4, show x5, show x3, show x8, show x9]
    info)
  _ -> failCons cd (consFail "ReadNumeric._case_1" (showCons x9))

d_C__case_0 :: Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_0 x1 cd cs = case x1 of
  Curry_Prelude.C_True -> Curry_Prelude.C_Nothing
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_0 l cd cs)
    (d_C__case_0 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_0 z cd
    cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_0 e cd $! addCs c
    cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "ReadNumeric._case_0" [show x1] info)
  _ -> failCons cd (consFail "ReadNumeric._case_0" (showCons x1))

d_C__case_3 :: Curry_Prelude.C_Char -> (Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Int -> (Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_Int) -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C__case_3 x7 x4 x8 x9 x5 x3 x10 cd cs = case x10 of
  Curry_Prelude.C_True -> d_C_readNumPrefix x8 (Curry_Prelude.C_Just
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    (Curry_Prelude.d_OP_uscore_impl_hash_star_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x3 x9 cd cs) (Curry_Prelude.d_C_apply x5 x7 cd cs) cd cs)) x3 x4 x5 cd cs
  Curry_Prelude.C_False -> d_C__case_2 x8 x7 x9 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_3 x7 x4 x8 x9 x5
    x3 l cd cs) (d_C__case_3 x7 x4 x8 x9 x5 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_3 x7 x4
    x8 x9 x5 x3 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_3 x7 x4 x8 x9 x5
    x3 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "ReadNumeric._case_3" [show x7, show x4, show x8, show x9, show x5, show x3
    , show x10] info)
  _ -> failCons cd (consFail "ReadNumeric._case_3" (showCons x10))

nd_C__case_3 :: Curry_Prelude.C_Char -> Func Curry_Prelude.C_Char
  Curry_Prelude.C_Bool -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Int -> Func Curry_Prelude.C_Char Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C__case_3 x7 x4 x8 x9 x5 x3 x10 s cd cs = case x10 of
  Curry_Prelude.C_True -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_C_readNumPrefix x8 (Curry_Prelude.C_Just
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    (Curry_Prelude.d_OP_uscore_impl_hash_star_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x3 x9 cd cs) (Curry_Prelude.nd_C_apply x5 x7 s0 cd cs) cd cs)) x3 x4 x5 s1
    cd cs))
  Curry_Prelude.C_False -> d_C__case_2 x8 x7 x9 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_3 x7 x4 x8 x9 x5
    x3 l s cd cs) (nd_C__case_3 x7 x4 x8 x9 x5 x3 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_3 x7
    x4 x8 x9 x5 x3 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_3 x7 x4 x8 x9 x5
    x3 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "ReadNumeric._case_3" [show x7, show x4, show x8, show x9, show x5, show x3
    , show x10] info)
  _ -> failCons cd (consFail "ReadNumeric._case_3" (showCons x10))

d_C__case_2 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Char -> Curry_Prelude.C_Int -> Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_2 x8 x7 x9 x10 cd cs = case x10 of
  Curry_Prelude.C_True -> Curry_Prelude.C_Just (Curry_Prelude.OP_Tuple2 x9
    (Curry_Prelude.OP_Cons x7 x8))
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_2 x8 x7 x9 l cd
    cs) (d_C__case_2 x8 x7 x9 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_2 x8 x7
    x9 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_2 x8 x7 x9 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "ReadNumeric._case_2" [show x8, show x7, show x9, show x10] info)
  _ -> failCons cd (consFail "ReadNumeric._case_2" (showCons x10))

d_C__case_5 :: Curry_Prelude.C_Maybe Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_5 x2 cd cs = case x2 of
  Curry_Prelude.C_Nothing -> Curry_Prelude.C_Nothing
  Curry_Prelude.C_Just x6 -> Curry_Prelude.C_Just (Curry_Prelude.OP_Tuple2 x6
    Curry_Prelude.OP_List)
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (d_C__case_5 l cd cs)
    (d_C__case_5 r cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> d_C__case_5 z cd
    cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (d_C__case_5 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail
    "ReadNumeric._case_5" [show x2] info)
  _ -> failCons cd (consFail "ReadNumeric._case_5" (showCons x2))

d_C__case_7 :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_7 x2 cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_Nothing
  Curry_Prelude.OP_Cons x3 x4 -> d_C__case_6 x3 x2 x4
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x3 (Curry_Prelude.C_Char '-'#) cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_7 l cd cs)
    (d_C__case_7 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_7 z cd
    cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_7 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "ReadNumeric._case_7" [show x2] info)
  _ -> failCons cd (consFail "ReadNumeric._case_7" (showCons x2))

d_C__case_6 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C__case_6 x3 x2 x4 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_maybe Curry_Prelude.C_Nothing
    d_OP_readInt_dot_uscore_hash_lambda2 (d_C_readNat x4 cd cs) cd cs
  Curry_Prelude.C_False -> d_C_readNat x2 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_6 x3 x2 x4 l cd
    cs) (d_C__case_6 x3 x2 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_6 x3 x2
    x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_6 x3 x2 x4 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "ReadNumeric._case_6" [show x3, show x2, show x4, show x5] info)
  _ -> failCons cd (consFail "ReadNumeric._case_6" (showCons x5))

