{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE Rank2Types #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module Curry_SetRBT
  ( C_SetRBT
  , d_C_emptySetRBT
  , nd_C_emptySetRBT
  , d_C_isEmptySetRBT
  , nd_C_isEmptySetRBT
  , d_C_elemRBT
  , nd_C_elemRBT
  , d_C_insertRBT
  , nd_C_insertRBT
  , d_C_insertMultiRBT
  , nd_C_insertMultiRBT
  , d_C_deleteRBT
  , nd_C_deleteRBT
  , d_C_setRBT2list
  , nd_C_setRBT2list
  , d_C_unionRBT
  , nd_C_unionRBT
  , d_C_intersectRBT
  , nd_C_intersectRBT
  , d_C_sortRBT
  , nd_C_sortRBT )
  where

import Basics
import qualified Curry_Maybe
import qualified Curry_Prelude
import qualified Curry_RedBlackTree


type C_SetRBT t0 = Curry_RedBlackTree.C_RedBlackTree t0

d_C_emptySetRBT :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0 -> Cover -> ConstStore -> (t0
  -> Cover -> ConstStore -> t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool)
  -> Cover -> ConstStore -> Curry_RedBlackTree.C_RedBlackTree t0
d_C_emptySetRBT x1 cd cs = Curry_RedBlackTree.d_C_empty
  (Curry_Prelude.d_OP_eq_eq x1 cd cs) (Curry_Prelude.d_OP_eq_eq x1 cd cs)

nd_C_emptySetRBT :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0 -> IDSupply -> Cover
  -> ConstStore -> Func (Func t0 (Func t0 Curry_Prelude.C_Bool))
  (Curry_RedBlackTree.C_RedBlackTree t0)
nd_C_emptySetRBT x1 s cd cs = let s2 = s
  in s2 `seq` (let s0 = leftSupply s2
                   s1 = rightSupply s2
  in s0 `seq` (s1 `seq` wrapNX id (Curry_RedBlackTree.nd_C_empty
  (Curry_Prelude.nd_OP_eq_eq x1 s0 cd cs) (Curry_Prelude.nd_OP_eq_eq x1 s1 cd
  cs))))

d_C_isEmptySetRBT :: forall t0 . (Curry_Prelude.Curry t0) => Cover -> ConstStore
  -> Curry_RedBlackTree.C_RedBlackTree t0 -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isEmptySetRBT cd cs = Curry_RedBlackTree.d_C_isEmpty

nd_C_isEmptySetRBT :: forall t0 . (Curry_Prelude.Curry t0) => IDSupply -> Cover
  -> ConstStore -> Func (Curry_RedBlackTree.C_RedBlackTree t0)
  Curry_Prelude.C_Bool
nd_C_isEmptySetRBT s cd cs = wrapNX id Curry_RedBlackTree.nd_C_isEmpty

d_C_elemRBT :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> Cover -> ConstStore
  -> Curry_RedBlackTree.C_RedBlackTree t0 -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_elemRBT x1 cd cs = Curry_Prelude.d_OP_dot Curry_Maybe.d_C_isJust
  (Curry_RedBlackTree.d_C_lookup x1) cd cs

nd_C_elemRBT :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> IDSupply -> Cover
  -> ConstStore -> Func (Curry_RedBlackTree.C_RedBlackTree t0)
  Curry_Prelude.C_Bool
nd_C_elemRBT x1 s cd cs = let s0 = s
  in s0 `seq` Curry_Prelude.nd_OP_dot (wrapDX id Curry_Maybe.d_C_isJust) (wrapNX
  id (Curry_RedBlackTree.nd_C_lookup x1)) s0 cd cs

d_C_insertRBT :: forall t0 . (Curry_Prelude.Curry t0) => Cover -> ConstStore
  -> t0 -> Cover -> ConstStore -> Curry_RedBlackTree.C_RedBlackTree t0 -> Cover
  -> ConstStore -> Curry_RedBlackTree.C_RedBlackTree t0
d_C_insertRBT cd cs = acceptCs id Curry_RedBlackTree.d_C_update

nd_C_insertRBT :: forall t0 . (Curry_Prelude.Curry t0) => IDSupply -> Cover
  -> ConstStore -> Func t0 (Func (Curry_RedBlackTree.C_RedBlackTree t0)
  (Curry_RedBlackTree.C_RedBlackTree t0))
nd_C_insertRBT s cd cs = wrapDX (wrapNX id) (acceptCs id
  Curry_RedBlackTree.nd_C_update)

d_C_insertMultiRBT :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0 -> t0 -> Cover -> ConstStore
  -> Curry_RedBlackTree.C_RedBlackTree t0 -> Cover -> ConstStore
  -> Curry_RedBlackTree.C_RedBlackTree t0
d_C_insertMultiRBT x1 x2 cd cs = Curry_Prelude.d_OP_dot
  (Curry_RedBlackTree.d_C_setInsertEquivalence (Curry_Prelude.d_OP_eq_eq x1 cd
  cs)) (Curry_Prelude.d_OP_dot (Curry_RedBlackTree.d_C_update x2)
  (Curry_RedBlackTree.d_C_setInsertEquivalence (acceptCs id
  d_OP_insertMultiRBT_dot_uscore_hash_lambda1)) cd cs) cd cs

nd_C_insertMultiRBT :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0 -> t0 -> IDSupply -> Cover
  -> ConstStore -> Func (Curry_RedBlackTree.C_RedBlackTree t0)
  (Curry_RedBlackTree.C_RedBlackTree t0)
nd_C_insertMultiRBT x1 x2 s cd cs = let s3 = s
  in s3 `seq` (let s2 = leftSupply s3
                   s4 = rightSupply s3
                   s0 = leftSupply s4
                   s1 = rightSupply s4
  in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` Curry_Prelude.nd_OP_dot (wrapNX id
  (Curry_RedBlackTree.nd_C_setInsertEquivalence (Curry_Prelude.nd_OP_eq_eq x1 s0
  cd cs))) (Curry_Prelude.nd_OP_dot (wrapNX id (Curry_RedBlackTree.nd_C_update
  x2)) (wrapNX id (Curry_RedBlackTree.nd_C_setInsertEquivalence (wrapDX (wrapDX
  id) (acceptCs id d_OP_insertMultiRBT_dot_uscore_hash_lambda1)))) s1 cd cs) s2
  cd cs))))

d_OP_insertMultiRBT_dot_uscore_hash_lambda1 :: forall t0 . (Curry_Prelude.Curry
  t0) => t0 -> t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_OP_insertMultiRBT_dot_uscore_hash_lambda1 x1 x2 cd cs = Curry_Prelude.C_False

d_C_deleteRBT :: forall t0 . (Curry_Prelude.Curry t0) => Cover -> ConstStore
  -> t0 -> Cover -> ConstStore -> Curry_RedBlackTree.C_RedBlackTree t0 -> Cover
  -> ConstStore -> Curry_RedBlackTree.C_RedBlackTree t0
d_C_deleteRBT cd cs = acceptCs id Curry_RedBlackTree.d_C_delete

nd_C_deleteRBT :: forall t0 . (Curry_Prelude.Curry t0) => IDSupply -> Cover
  -> ConstStore -> Func t0 (Func (Curry_RedBlackTree.C_RedBlackTree t0)
  (Curry_RedBlackTree.C_RedBlackTree t0))
nd_C_deleteRBT s cd cs = wrapDX (wrapNX id) (acceptCs id
  Curry_RedBlackTree.nd_C_delete)

d_C_setRBT2list :: forall t0 . (Curry_Prelude.Curry t0) => Cover -> ConstStore
  -> Curry_RedBlackTree.C_RedBlackTree t0 -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0
d_C_setRBT2list cd cs = Curry_RedBlackTree.d_C_tree2list

nd_C_setRBT2list :: forall t0 . (Curry_Prelude.Curry t0) => IDSupply -> Cover
  -> ConstStore -> Func (Curry_RedBlackTree.C_RedBlackTree t0)
  (Curry_Prelude.OP_List t0)
nd_C_setRBT2list s cd cs = wrapNX id Curry_RedBlackTree.nd_C_tree2list

d_C_unionRBT :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_RedBlackTree.C_RedBlackTree t0
  -> Curry_RedBlackTree.C_RedBlackTree t0 -> Cover -> ConstStore
  -> Curry_RedBlackTree.C_RedBlackTree t0
d_C_unionRBT x1 x2 cd cs = Curry_Prelude.d_C_foldr (d_C_insertRBT cd cs) x2
  (Curry_Prelude.d_C_apply (d_C_setRBT2list cd cs) x1 cd cs) cd cs

nd_C_unionRBT :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_RedBlackTree.C_RedBlackTree t0
  -> Curry_RedBlackTree.C_RedBlackTree t0 -> IDSupply -> Cover -> ConstStore
  -> Curry_RedBlackTree.C_RedBlackTree t0
nd_C_unionRBT x1 x2 s cd cs = let s5 = s
  in s5 `seq` (let s4 = leftSupply s5
                   s6 = rightSupply s5
                   s0 = leftSupply s6
                   s3 = rightSupply s6
  in s4 `seq` (s6 `seq` (s0 `seq` (s3 `seq` Curry_Prelude.nd_C_foldr
  (nd_C_insertRBT s0 cd cs) x2 (let s2 = leftSupply s3
                                    s1 = rightSupply s3
  in s2 `seq` (s1 `seq` Curry_Prelude.nd_C_apply (nd_C_setRBT2list s1 cd cs) x1
  s2 cd cs)) s4 cd cs))))

d_C_intersectRBT :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_RedBlackTree.C_RedBlackTree t0
  -> Curry_RedBlackTree.C_RedBlackTree t0 -> Cover -> ConstStore
  -> Curry_RedBlackTree.C_RedBlackTree t0
d_C_intersectRBT x1 x2 cd cs = Curry_Prelude.d_C_foldr (d_C_insertRBT cd cs)
  (Curry_RedBlackTree.d_C_newTreeLike x1 cd cs) (Curry_Prelude.d_C_filter
  (Curry_Prelude.d_C_flip d_C_elemRBT x2) (Curry_Prelude.d_C_apply
  (d_C_setRBT2list cd cs) x1 cd cs) cd cs) cd cs

nd_C_intersectRBT :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_RedBlackTree.C_RedBlackTree t0
  -> Curry_RedBlackTree.C_RedBlackTree t0 -> IDSupply -> Cover -> ConstStore
  -> Curry_RedBlackTree.C_RedBlackTree t0
nd_C_intersectRBT x1 x2 s cd cs = let s8 = s
  in s8 `seq` (let s9 = leftSupply s8
                   s10 = rightSupply s8
                   s7 = leftSupply s9
                   s0 = rightSupply s9
                   s1 = leftSupply s10
                   s6 = rightSupply s10
  in s9 `seq` (s10 `seq` (s7 `seq` (s0 `seq` (s1 `seq` (s6 `seq`
  Curry_Prelude.nd_C_foldr (nd_C_insertRBT s0 cd cs)
  (Curry_RedBlackTree.nd_C_newTreeLike x1 s1 cd cs) (let s5 = leftSupply s6
                                                         s4 = rightSupply s6
  in s5 `seq` (s4 `seq` Curry_Prelude.nd_C_filter (wrapNX id
  (Curry_Prelude.nd_C_flip (wrapNX id nd_C_elemRBT) x2)) (let s3 = leftSupply s4
                                                              s2 = rightSupply
                                                                s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (nd_C_setRBT2list s2 cd cs) x1
  s3 cd cs)) s5 cd cs)) s7 cd cs))))))

d_C_sortRBT :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0 -> Cover -> ConstStore -> (t0
  -> Cover -> ConstStore -> t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool)
  -> Cover -> ConstStore -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0
d_C_sortRBT x1 cd cs = acceptCs id (Curry_RedBlackTree.d_C_sortBy x1)

nd_C_sortRBT :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0 -> IDSupply -> Cover
  -> ConstStore -> Func (Func t0 (Func t0 Curry_Prelude.C_Bool)) (Func
  (Curry_Prelude.OP_List t0) (Curry_Prelude.OP_List t0))
nd_C_sortRBT x1 s cd cs = wrapDX (wrapNX id) (acceptCs id
  (Curry_RedBlackTree.nd_C_sortBy x1))

