{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE Rank2Types #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module Curry_Sort
  ( d_C_sort
  , nd_C_sort
  , d_C_sortBy
  , nd_C_sortBy
  , d_C_sorted
  , nd_C_sorted
  , d_C_sortedBy
  , nd_C_sortedBy
  , nd_C_permSort
  , nd_C_permSortBy
  , d_C_insertionSort
  , nd_C_insertionSort
  , d_C_insertionSortBy
  , nd_C_insertionSortBy
  , d_C_quickSort
  , nd_C_quickSort
  , d_C_quickSortBy
  , nd_C_quickSortBy
  , d_C_mergeSort
  , nd_C_mergeSort
  , d_C_mergeSortBy
  , nd_C_mergeSortBy
  , d_C_leqList
  , nd_C_leqList
  , d_C_cmpList
  , nd_C_cmpList
  , d_C_leqChar
  , d_C_cmpChar
  , d_C_leqCharIgnoreCase
  , d_C_leqString
  , d_C_cmpString
  , d_C_leqStringIgnoreCase
  , d_C_leqLexGerman )
  where

import Basics
import qualified Curry_Char
import qualified Curry_Prelude
import qualified Test.Curry_Prop


d_C_sort :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_C_sort x1 cd cs = Curry_Prelude.d_C_apply (d_C_sortBy cd cs)
  (Curry_Prelude.d_OP_lt_eq x1 cd cs) cd cs

nd_C_sort :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> IDSupply -> Cover
  -> ConstStore -> Func (Curry_Prelude.OP_List t0) (Curry_Prelude.OP_List t0)
nd_C_sort x1 s cd cs = let s3 = s
  in s3 `seq` (let s2 = leftSupply s3
                   s4 = rightSupply s3
                   s0 = leftSupply s4
                   s1 = rightSupply s4
  in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` Curry_Prelude.nd_C_apply
  (nd_C_sortBy s0 cd cs) (Curry_Prelude.nd_OP_lt_eq x1 s1 cd cs) s2 cd cs))))

d_C_sort'post :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_sort'post x1 x2 x3 cd cs = Curry_Prelude.d_OP_amp_amp
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
  (Curry_Prelude.d_C_length x2 cd cs) (Curry_Prelude.d_C_length x3 cd cs) cd cs)
  (Curry_Prelude.d_C_apply (d_C_sorted x1 cd cs) x3 cd cs) cd cs

nd_C_sort'post :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.OP_List t0 -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
nd_C_sort'post x1 x2 x3 s cd cs = let s2 = s
  in s2 `seq` Curry_Prelude.d_OP_amp_amp
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
  (Curry_Prelude.d_C_length x2 cd cs) (Curry_Prelude.d_C_length x3 cd cs) cd cs)
  (let s1 = leftSupply s2
       s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (nd_C_sorted x1 s0 cd cs) x3 s1
  cd cs)) cd cs

nd_C_sort'spec :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> Curry_Prelude.OP_List t0
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
nd_C_sort'spec x1 x2 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (nd_C_permSort x1 s0 cd cs) x2
  s1 cd cs))

d_C_sortBy :: forall t0 . (Curry_Prelude.Curry t0) => Cover -> ConstStore -> (t0
  -> Cover -> ConstStore -> t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool)
  -> Cover -> ConstStore -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0
d_C_sortBy cd cs = acceptCs id d_C_mergeSortBy

nd_C_sortBy :: forall t0 . (Curry_Prelude.Curry t0) => IDSupply -> Cover
  -> ConstStore -> Func (Func t0 (Func t0 Curry_Prelude.C_Bool)) (Func
  (Curry_Prelude.OP_List t0) (Curry_Prelude.OP_List t0))
nd_C_sortBy s cd cs = wrapDX (wrapNX id) (acceptCs id nd_C_mergeSortBy)

d_C_sorted :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_sorted x1 cd cs = d_C_sortedBy (Curry_Prelude.d_OP_lt_eq x1 cd cs)

nd_C_sorted :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> IDSupply -> Cover
  -> ConstStore -> Func (Curry_Prelude.OP_List t0) Curry_Prelude.C_Bool
nd_C_sorted x1 s cd cs = let s0 = s
  in s0 `seq` wrapNX id (nd_C_sortedBy (Curry_Prelude.nd_OP_lt_eq x1 s0 cd cs))

d_C_sortedBy :: forall t0 . (Curry_Prelude.Curry t0) => (t0 -> Cover
  -> ConstStore -> t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool)
  -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_sortedBy x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_True
  Curry_Prelude.OP_Cons x3 x4 -> d_C__case_33 x1 x3 x4 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_sortedBy x1 l cd cs)
    (d_C_sortedBy x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_sortedBy x1
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_sortedBy x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort.sortedBy"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Sort.sortedBy" (showCons x2))

nd_C_sortedBy :: forall t0 . (Curry_Prelude.Curry t0) => Func t0 (Func t0
  Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List t0 -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
nd_C_sortedBy x1 x2 s cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_True
  Curry_Prelude.OP_Cons x3 x4 -> let s0 = s
    in s0 `seq` nd_C__case_33 x1 x3 x4 s0 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C_sortedBy x1 l s cd
    cs) (nd_C_sortedBy x1 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C_sortedBy x1
    z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C_sortedBy x1 e s cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort.sortedBy"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Sort.sortedBy" (showCons x2))

nd_C_permSort :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> IDSupply -> Cover
  -> ConstStore -> Func (Curry_Prelude.OP_List t0) (Curry_Prelude.OP_List t0)
nd_C_permSort x1 s cd cs = let s2 = s
  in s2 `seq` (let s0 = leftSupply s2
                   s1 = rightSupply s2
  in s0 `seq` (s1 `seq` wrapNX id (nd_C_permSortBy
  (Curry_Prelude.nd_OP_uscore_super_hash_Prelude_dot_Ord_hash_Prelude_dot_Eq x1
  s0 cd cs) (Curry_Prelude.nd_OP_lt_eq x1 s1 cd cs))))

nd_C_permSortBy :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0 -> Func t0 (Func t0
  Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List t0 -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_List t0
nd_C_permSortBy x1 x2 x3 s cd cs = let s4 = s
  in s4 `seq` (let s0 = leftSupply s4
                   s3 = rightSupply s4
  in s0 `seq` (s3 `seq` (let x4 = nd_C_perm x3 s0 cd cs
  in let s2 = leftSupply s3
         s1 = rightSupply s3
  in s2 `seq` (s1 `seq` nd_C__case_32 x4 x2 (nd_C_sortedBy x2 x4 s1 cd cs) s2 cd
  cs))))

nd_C_perm :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List t0
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
nd_C_perm x1 s cd cs = case x1 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x2 x3 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_perm_dot_insert_dot_28 x2 (nd_C_perm x3 s0 cd
    cs) s1 cd cs))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C_perm l s cd cs)
    (nd_C_perm r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C_perm z s cd
    cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C_perm e s cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort.perm" [show
    x1] info)
  _ -> failCons cd (consFail "Sort.perm" (showCons x1))

nd_OP_perm_dot_insert_dot_28 :: forall t0 . (Curry_Prelude.Curry t0) => t0
  -> Curry_Prelude.OP_List t0 -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0
nd_OP_perm_dot_insert_dot_28 x1 x2 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` choice (nd_C__case_31 x1 x2 s0 cd cs)
  (Curry_Prelude.OP_Cons x1 x2) s1 cd cs))

d_C_insertionSort :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_C_insertionSort x1 cd cs = d_C_insertionSortBy (Curry_Prelude.d_OP_lt_eq x1 cd
  cs)

nd_C_insertionSort :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> IDSupply -> Cover
  -> ConstStore -> Func (Curry_Prelude.OP_List t0) (Curry_Prelude.OP_List t0)
nd_C_insertionSort x1 s cd cs = let s0 = s
  in s0 `seq` wrapNX id (nd_C_insertionSortBy (Curry_Prelude.nd_OP_lt_eq x1 s0
  cd cs))

d_C_insertionSort'post :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_insertionSort'post x1 x2 x3 cd cs = Curry_Prelude.d_OP_amp_amp
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
  (Curry_Prelude.d_C_length x2 cd cs) (Curry_Prelude.d_C_length x3 cd cs) cd cs)
  (Curry_Prelude.d_C_apply (d_C_sorted x1 cd cs) x3 cd cs) cd cs

nd_C_insertionSort'post :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.OP_List t0 -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
nd_C_insertionSort'post x1 x2 x3 s cd cs = let s2 = s
  in s2 `seq` Curry_Prelude.d_OP_amp_amp
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
  (Curry_Prelude.d_C_length x2 cd cs) (Curry_Prelude.d_C_length x3 cd cs) cd cs)
  (let s1 = leftSupply s2
       s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (nd_C_sorted x1 s0 cd cs) x3 s1
  cd cs)) cd cs

nd_C_insertionSort'spec :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> IDSupply -> Cover
  -> ConstStore -> Func (Curry_Prelude.OP_List t0) (Curry_Prelude.OP_List t0)
nd_C_insertionSort'spec x1 s cd cs = let s0 = s
  in s0 `seq` nd_C_permSort x1 s0 cd cs

d_C_insertionSortBy :: forall t0 . (Curry_Prelude.Curry t0) => (t0 -> Cover
  -> ConstStore -> t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool)
  -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_C_insertionSortBy x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x3 x4 -> d_OP_insertionSortBy_dot_insert_dot_43 x3 x1
    (d_C_insertionSortBy x1 x4 cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_insertionSortBy x1 l
    cd cs) (d_C_insertionSortBy x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_C_insertionSortBy x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_insertionSortBy x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Sort.insertionSortBy" [show x1, show x2] info)
  _ -> failCons cd (consFail "Sort.insertionSortBy" (showCons x2))

nd_C_insertionSortBy :: forall t0 . (Curry_Prelude.Curry t0) => Func t0 (Func t0
  Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List t0 -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_List t0
nd_C_insertionSortBy x1 x2 s cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x3 x4 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_insertionSortBy_dot_insert_dot_43 x3 x1
    (nd_C_insertionSortBy x1 x4 s0 cd cs) s1 cd cs))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C_insertionSortBy x1 l
    s cd cs) (nd_C_insertionSortBy x1 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    nd_C_insertionSortBy x1 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C_insertionSortBy x1 e
    s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Sort.insertionSortBy" [show x1, show x2] info)
  _ -> failCons cd (consFail "Sort.insertionSortBy" (showCons x2))

d_OP_insertionSortBy_dot_insert_dot_43 :: forall t0 . (Curry_Prelude.Curry
  t0) => t0 -> (t0 -> Cover -> ConstStore -> t0 -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0
d_OP_insertionSortBy_dot_insert_dot_43 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Cons x1 Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_30 x4 x1 x2 x5 x3
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x2 x1 cd cs) x4 cd cs) cd
    cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_insertionSortBy_dot_insert_dot_43 x1 x2 l cd cs)
    (d_OP_insertionSortBy_dot_insert_dot_43 x1 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_insertionSortBy_dot_insert_dot_43 x1 x2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_insertionSortBy_dot_insert_dot_43 x1 x2 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Sort.insertionSortBy.insert.43" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "Sort.insertionSortBy.insert.43" (showCons x3))

nd_OP_insertionSortBy_dot_insert_dot_43 :: forall t0 . (Curry_Prelude.Curry
  t0) => t0 -> Func t0 (Func t0 Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List
  t0 -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
nd_OP_insertionSortBy_dot_insert_dot_43 x1 x2 x3 s cd cs = case x3 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Cons x1 Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x4 x5 -> let s4 = s
    in s4 `seq` (let s3 = leftSupply s4
                     s2 = rightSupply s4
    in s3 `seq` (s2 `seq` nd_C__case_30 x4 x1 x2 x5 x3 (let s1 = leftSupply s2
                                                            s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x2
    x1 s0 cd cs) x4 s1 cd cs)) s3 cd cs))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (nd_OP_insertionSortBy_dot_insert_dot_43 x1 x2 l s cd cs)
    (nd_OP_insertionSortBy_dot_insert_dot_43 x1 x2 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    nd_OP_insertionSortBy_dot_insert_dot_43 x1 x2 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (nd_OP_insertionSortBy_dot_insert_dot_43 x1 x2 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Sort.insertionSortBy.insert.43" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "Sort.insertionSortBy.insert.43" (showCons x3))

d_C_quickSort :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_C_quickSort x1 cd cs = d_C_quickSortBy (Curry_Prelude.d_OP_lt_eq x1 cd cs)

nd_C_quickSort :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> IDSupply -> Cover
  -> ConstStore -> Func (Curry_Prelude.OP_List t0) (Curry_Prelude.OP_List t0)
nd_C_quickSort x1 s cd cs = let s0 = s
  in s0 `seq` wrapNX id (nd_C_quickSortBy (Curry_Prelude.nd_OP_lt_eq x1 s0 cd
  cs))

d_C_quickSort'post :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_quickSort'post x1 x2 x3 cd cs = Curry_Prelude.d_OP_amp_amp
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
  (Curry_Prelude.d_C_length x2 cd cs) (Curry_Prelude.d_C_length x3 cd cs) cd cs)
  (Curry_Prelude.d_C_apply (d_C_sorted x1 cd cs) x3 cd cs) cd cs

nd_C_quickSort'post :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.OP_List t0 -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
nd_C_quickSort'post x1 x2 x3 s cd cs = let s2 = s
  in s2 `seq` Curry_Prelude.d_OP_amp_amp
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
  (Curry_Prelude.d_C_length x2 cd cs) (Curry_Prelude.d_C_length x3 cd cs) cd cs)
  (let s1 = leftSupply s2
       s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (nd_C_sorted x1 s0 cd cs) x3 s1
  cd cs)) cd cs

nd_C_quickSort'spec :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> IDSupply -> Cover
  -> ConstStore -> Func (Curry_Prelude.OP_List t0) (Curry_Prelude.OP_List t0)
nd_C_quickSort'spec x1 s cd cs = let s0 = s
  in s0 `seq` nd_C_permSort x1 s0 cd cs

d_C_quickSortBy :: forall t0 . (Curry_Prelude.Curry t0) => (t0 -> Cover
  -> ConstStore -> t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool)
  -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_C_quickSortBy x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x3 x4 -> let x5 = d_OP_quickSortBy_dot_split_dot_58 x1
                                       x3 x4 cd cs
                                     x6 = d_OP_quickSortBy_dot_uscore_hash_selFP5_hash_l
                                       x5 cd cs
                                     x7 = d_OP_quickSortBy_dot_uscore_hash_selFP6_hash_r
                                       x5 cd cs
    in Curry_Prelude.d_OP_plus_plus (d_C_quickSortBy x1 x6 cd cs)
    (Curry_Prelude.OP_Cons x3 (d_C_quickSortBy x1 x7 cd cs)) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_quickSortBy x1 l cd
    cs) (d_C_quickSortBy x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_quickSortBy
    x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_quickSortBy x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort.quickSortBy"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Sort.quickSortBy" (showCons x2))

nd_C_quickSortBy :: forall t0 . (Curry_Prelude.Curry t0) => Func t0 (Func t0
  Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List t0 -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_List t0
nd_C_quickSortBy x1 x2 s cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x3 x4 -> let s4 = s
    in s4 `seq` (let s0 = leftSupply s4
                     s3 = rightSupply s4
    in s0 `seq` (s3 `seq` (let x5 = nd_OP_quickSortBy_dot_split_dot_58 x1 x3 x4
                                 s0 cd cs
                               x6 = d_OP_quickSortBy_dot_uscore_hash_selFP5_hash_l
                                 x5 cd cs
                               x7 = d_OP_quickSortBy_dot_uscore_hash_selFP6_hash_r
                                 x5 cd cs
    in let s1 = leftSupply s3
           s2 = rightSupply s3
    in s1 `seq` (s2 `seq` Curry_Prelude.d_OP_plus_plus (nd_C_quickSortBy x1 x6
    s1 cd cs) (Curry_Prelude.OP_Cons x3 (nd_C_quickSortBy x1 x7 s2 cd cs)) cd
    cs))))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C_quickSortBy x1 l s cd
    cs) (nd_C_quickSortBy x1 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C_quickSortBy
    x1 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C_quickSortBy x1 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort.quickSortBy"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Sort.quickSortBy" (showCons x2))

d_OP_quickSortBy_dot_split_dot_58 :: forall t0 . (Curry_Prelude.Curry t0) => (t0
  -> Cover -> ConstStore -> t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool)
  -> t0 -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List t0) (Curry_Prelude.OP_List
  t0)
d_OP_quickSortBy_dot_split_dot_58 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Tuple2 Curry_Prelude.OP_List
    Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x4 x5 -> let x6 = d_OP_quickSortBy_dot_split_dot_58 x1
                                       x2 x5 cd cs
                                     x7 = d_OP_quickSortBy_dot_split_dot_58_dot_uscore_hash_selFP2_hash_l
                                       x6 cd cs
                                     x8 = d_OP_quickSortBy_dot_split_dot_58_dot_uscore_hash_selFP3_hash_r
                                       x6 cd cs
    in d_C__case_28 x2 x4 x1 x8 x7 (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply x1 x4 cd cs) x2 cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_quickSortBy_dot_split_dot_58 x1 x2 l cd cs)
    (d_OP_quickSortBy_dot_split_dot_58 x1 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_quickSortBy_dot_split_dot_58 x1 x2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_quickSortBy_dot_split_dot_58 x1 x2 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Sort.quickSortBy.split.58" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "Sort.quickSortBy.split.58" (showCons x3))

nd_OP_quickSortBy_dot_split_dot_58 :: forall t0 . (Curry_Prelude.Curry
  t0) => Func t0 (Func t0 Curry_Prelude.C_Bool) -> t0 -> Curry_Prelude.OP_List
  t0 -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List t0) (Curry_Prelude.OP_List t0)
nd_OP_quickSortBy_dot_split_dot_58 x1 x2 x3 s cd cs = case x3 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Tuple2 Curry_Prelude.OP_List
    Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x4 x5 -> let s6 = s
    in s6 `seq` (let s0 = leftSupply s6
                     s5 = rightSupply s6
    in s0 `seq` (s5 `seq` (let x6 = nd_OP_quickSortBy_dot_split_dot_58 x1 x2 x5
                                 s0 cd cs
                               x7 = d_OP_quickSortBy_dot_split_dot_58_dot_uscore_hash_selFP2_hash_l
                                 x6 cd cs
                               x8 = d_OP_quickSortBy_dot_split_dot_58_dot_uscore_hash_selFP3_hash_r
                                 x6 cd cs
    in let s4 = leftSupply s5
           s3 = rightSupply s5
    in s4 `seq` (s3 `seq` nd_C__case_28 x2 x4 x1 x8 x7 (let s2 = leftSupply s3
                                                            s1 = rightSupply s3
    in s2 `seq` (s1 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x1
    x4 s1 cd cs) x2 s2 cd cs)) s4 cd cs))))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (nd_OP_quickSortBy_dot_split_dot_58 x1 x2 l s cd cs)
    (nd_OP_quickSortBy_dot_split_dot_58 x1 x2 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    nd_OP_quickSortBy_dot_split_dot_58 x1 x2 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (nd_OP_quickSortBy_dot_split_dot_58 x1 x2 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Sort.quickSortBy.split.58" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "Sort.quickSortBy.split.58" (showCons x3))

d_OP_quickSortBy_dot_split_dot_58_dot_uscore_hash_selFP2_hash_l :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List t0)
  (Curry_Prelude.OP_List t0) -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_OP_quickSortBy_dot_split_dot_58_dot_uscore_hash_selFP2_hash_l x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_quickSortBy_dot_split_dot_58_dot_uscore_hash_selFP2_hash_l l cd cs)
    (d_OP_quickSortBy_dot_split_dot_58_dot_uscore_hash_selFP2_hash_l r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_quickSortBy_dot_split_dot_58_dot_uscore_hash_selFP2_hash_l z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_quickSortBy_dot_split_dot_58_dot_uscore_hash_selFP2_hash_l e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Sort.quickSortBy.split.58._#selFP2#l" [show x1] info)
  _ -> failCons cd (consFail "Sort.quickSortBy.split.58._#selFP2#l" (showCons
    x1))

d_OP_quickSortBy_dot_split_dot_58_dot_uscore_hash_selFP3_hash_r :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List t0)
  (Curry_Prelude.OP_List t0) -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_OP_quickSortBy_dot_split_dot_58_dot_uscore_hash_selFP3_hash_r x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_quickSortBy_dot_split_dot_58_dot_uscore_hash_selFP3_hash_r l cd cs)
    (d_OP_quickSortBy_dot_split_dot_58_dot_uscore_hash_selFP3_hash_r r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_quickSortBy_dot_split_dot_58_dot_uscore_hash_selFP3_hash_r z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_quickSortBy_dot_split_dot_58_dot_uscore_hash_selFP3_hash_r e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Sort.quickSortBy.split.58._#selFP3#r" [show x1] info)
  _ -> failCons cd (consFail "Sort.quickSortBy.split.58._#selFP3#r" (showCons
    x1))

d_OP_quickSortBy_dot_uscore_hash_selFP5_hash_l :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List t0)
  (Curry_Prelude.OP_List t0) -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_OP_quickSortBy_dot_uscore_hash_selFP5_hash_l x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_quickSortBy_dot_uscore_hash_selFP5_hash_l l cd cs)
    (d_OP_quickSortBy_dot_uscore_hash_selFP5_hash_l r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_quickSortBy_dot_uscore_hash_selFP5_hash_l z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_quickSortBy_dot_uscore_hash_selFP5_hash_l e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Sort.quickSortBy._#selFP5#l" [show x1] info)
  _ -> failCons cd (consFail "Sort.quickSortBy._#selFP5#l" (showCons x1))

d_OP_quickSortBy_dot_uscore_hash_selFP6_hash_r :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List t0)
  (Curry_Prelude.OP_List t0) -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_OP_quickSortBy_dot_uscore_hash_selFP6_hash_r x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_quickSortBy_dot_uscore_hash_selFP6_hash_r l cd cs)
    (d_OP_quickSortBy_dot_uscore_hash_selFP6_hash_r r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_quickSortBy_dot_uscore_hash_selFP6_hash_r z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_quickSortBy_dot_uscore_hash_selFP6_hash_r e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Sort.quickSortBy._#selFP6#r" [show x1] info)
  _ -> failCons cd (consFail "Sort.quickSortBy._#selFP6#r" (showCons x1))

d_C_mergeSort :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_C_mergeSort x1 cd cs = d_C_mergeSortBy (Curry_Prelude.d_OP_lt_eq x1 cd cs)

nd_C_mergeSort :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> IDSupply -> Cover
  -> ConstStore -> Func (Curry_Prelude.OP_List t0) (Curry_Prelude.OP_List t0)
nd_C_mergeSort x1 s cd cs = let s0 = s
  in s0 `seq` wrapNX id (nd_C_mergeSortBy (Curry_Prelude.nd_OP_lt_eq x1 s0 cd
  cs))

d_C_mergeSort'post :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_mergeSort'post x1 x2 x3 cd cs = Curry_Prelude.d_OP_amp_amp
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
  (Curry_Prelude.d_C_length x2 cd cs) (Curry_Prelude.d_C_length x3 cd cs) cd cs)
  (Curry_Prelude.d_C_apply (d_C_sorted x1 cd cs) x3 cd cs) cd cs

nd_C_mergeSort'post :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.OP_List t0 -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
nd_C_mergeSort'post x1 x2 x3 s cd cs = let s2 = s
  in s2 `seq` Curry_Prelude.d_OP_amp_amp
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
  (Curry_Prelude.d_C_length x2 cd cs) (Curry_Prelude.d_C_length x3 cd cs) cd cs)
  (let s1 = leftSupply s2
       s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (nd_C_sorted x1 s0 cd cs) x3 s1
  cd cs)) cd cs

nd_C_mergeSort'spec :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> IDSupply -> Cover
  -> ConstStore -> Func (Curry_Prelude.OP_List t0) (Curry_Prelude.OP_List t0)
nd_C_mergeSort'spec x1 s cd cs = let s0 = s
  in s0 `seq` nd_C_permSort x1 s0 cd cs

d_C_mergeSortBy :: forall t0 . (Curry_Prelude.Curry t0) => (t0 -> Cover
  -> ConstStore -> t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool)
  -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_C_mergeSortBy x1 x2 cd cs = d_OP_mergeSortBy_dot_mergeLists_dot_74 x1
  (d_OP_mergeSortBy_dot_genRuns_dot_74 x1 x2 cd cs) cd cs

nd_C_mergeSortBy :: forall t0 . (Curry_Prelude.Curry t0) => Func t0 (Func t0
  Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List t0 -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_List t0
nd_C_mergeSortBy x1 x2 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_mergeSortBy_dot_mergeLists_dot_74 x1
  (nd_OP_mergeSortBy_dot_genRuns_dot_74 x1 x2 s0 cd cs) s1 cd cs))

d_OP_mergeSortBy_dot_genRuns_dot_74 :: forall t0 . (Curry_Prelude.Curry
  t0) => (t0 -> Cover -> ConstStore -> t0 -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List t0)
d_OP_mergeSortBy_dot_genRuns_dot_74 x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x3 x4 -> d_C__case_26 x3 x1 x4 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_mergeSortBy_dot_genRuns_dot_74 x1 l cd cs)
    (d_OP_mergeSortBy_dot_genRuns_dot_74 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_mergeSortBy_dot_genRuns_dot_74 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_mergeSortBy_dot_genRuns_dot_74 x1 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Sort.mergeSortBy.genRuns.74" [show x1, show x2] info)
  _ -> failCons cd (consFail "Sort.mergeSortBy.genRuns.74" (showCons x2))

nd_OP_mergeSortBy_dot_genRuns_dot_74 :: forall t0 . (Curry_Prelude.Curry
  t0) => Func t0 (Func t0 Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List t0
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List t0)
nd_OP_mergeSortBy_dot_genRuns_dot_74 x1 x2 s cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x3 x4 -> let s0 = s
    in s0 `seq` nd_C__case_26 x3 x1 x4 s0 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (nd_OP_mergeSortBy_dot_genRuns_dot_74 x1 l s cd cs)
    (nd_OP_mergeSortBy_dot_genRuns_dot_74 x1 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    nd_OP_mergeSortBy_dot_genRuns_dot_74 x1 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (nd_OP_mergeSortBy_dot_genRuns_dot_74 x1 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Sort.mergeSortBy.genRuns.74" [show x1, show x2] info)
  _ -> failCons cd (consFail "Sort.mergeSortBy.genRuns.74" (showCons x2))

d_OP_mergeSortBy_dot_mergePairs_dot_74 :: forall t0 . (Curry_Prelude.Curry
  t0) => (t0 -> Cover -> ConstStore -> t0 -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List (Curry_Prelude.OP_List t0)
  -> Cover -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List t0)
d_OP_mergeSortBy_dot_mergePairs_dot_74 x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x3 x4 -> d_C__case_23 x1 x3 x4 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_mergeSortBy_dot_mergePairs_dot_74 x1 l cd cs)
    (d_OP_mergeSortBy_dot_mergePairs_dot_74 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_mergeSortBy_dot_mergePairs_dot_74 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_mergeSortBy_dot_mergePairs_dot_74 x1 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Sort.mergeSortBy.mergePairs.74" [show x1, show x2] info)
  _ -> failCons cd (consFail "Sort.mergeSortBy.mergePairs.74" (showCons x2))

nd_OP_mergeSortBy_dot_mergePairs_dot_74 :: forall t0 . (Curry_Prelude.Curry
  t0) => Func t0 (Func t0 Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List t0) -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List t0)
nd_OP_mergeSortBy_dot_mergePairs_dot_74 x1 x2 s cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x3 x4 -> let s0 = s
    in s0 `seq` nd_C__case_23 x1 x3 x4 s0 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (nd_OP_mergeSortBy_dot_mergePairs_dot_74 x1 l s cd cs)
    (nd_OP_mergeSortBy_dot_mergePairs_dot_74 x1 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    nd_OP_mergeSortBy_dot_mergePairs_dot_74 x1 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (nd_OP_mergeSortBy_dot_mergePairs_dot_74 x1 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Sort.mergeSortBy.mergePairs.74" [show x1, show x2] info)
  _ -> failCons cd (consFail "Sort.mergeSortBy.mergePairs.74" (showCons x2))

d_OP_mergeSortBy_dot_mergeLists_dot_74 :: forall t0 . (Curry_Prelude.Curry
  t0) => (t0 -> Cover -> ConstStore -> t0 -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List (Curry_Prelude.OP_List t0)
  -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_OP_mergeSortBy_dot_mergeLists_dot_74 x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x3 x4 -> d_C__case_22 x1 x3 x4 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_mergeSortBy_dot_mergeLists_dot_74 x1 l cd cs)
    (d_OP_mergeSortBy_dot_mergeLists_dot_74 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_mergeSortBy_dot_mergeLists_dot_74 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_mergeSortBy_dot_mergeLists_dot_74 x1 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Sort.mergeSortBy.mergeLists.74" [show x1, show x2] info)
  _ -> failCons cd (consFail "Sort.mergeSortBy.mergeLists.74" (showCons x2))

nd_OP_mergeSortBy_dot_mergeLists_dot_74 :: forall t0 . (Curry_Prelude.Curry
  t0) => Func t0 (Func t0 Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List t0) -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0
nd_OP_mergeSortBy_dot_mergeLists_dot_74 x1 x2 s cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x3 x4 -> let s0 = s
    in s0 `seq` nd_C__case_22 x1 x3 x4 s0 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (nd_OP_mergeSortBy_dot_mergeLists_dot_74 x1 l s cd cs)
    (nd_OP_mergeSortBy_dot_mergeLists_dot_74 x1 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    nd_OP_mergeSortBy_dot_mergeLists_dot_74 x1 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (nd_OP_mergeSortBy_dot_mergeLists_dot_74 x1 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Sort.mergeSortBy.mergeLists.74" [show x1, show x2] info)
  _ -> failCons cd (consFail "Sort.mergeSortBy.mergeLists.74" (showCons x2))

d_C_merge :: forall t0 . (Curry_Prelude.Curry t0) => (t0 -> Cover -> ConstStore
  -> t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List
  t0 -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore -> Curry_Prelude.OP_List
  t0
d_C_merge x1 x2 x3 cd cs = case x2 of
  Curry_Prelude.OP_List -> x3
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_21 x4 x1 x5 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_merge x1 l x3 cd cs)
    (d_C_merge x1 r x3 cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_merge x1 z
    x3 cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_merge x1 e x3 cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort.merge" [show
    x1, show x2, show x3] info)
  _ -> failCons cd (consFail "Sort.merge" (showCons x2))

nd_C_merge :: forall t0 . (Curry_Prelude.Curry t0) => Func t0 (Func t0
  Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_List t0
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
nd_C_merge x1 x2 x3 s cd cs = case x2 of
  Curry_Prelude.OP_List -> x3
  Curry_Prelude.OP_Cons x4 x5 -> let s0 = s
    in s0 `seq` nd_C__case_21 x4 x1 x5 x3 s0 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C_merge x1 l x3 s cd
    cs) (nd_C_merge x1 r x3 s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C_merge x1 z
    x3 s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C_merge x1 e x3 s cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort.merge" [show
    x1, show x2, show x3] info)
  _ -> failCons cd (consFail "Sort.merge" (showCons x2))

d_C_leqList :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0 -> (t0 -> Cover -> ConstStore
  -> t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List
  t0 -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_leqList x1 x2 x3 x4 cd cs = case x3 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_True
  Curry_Prelude.OP_Cons x5 x6 -> d_C__case_18 x5 x1 x2 x6 x4 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_leqList x1 x2 l x4 cd
    cs) (d_C_leqList x1 x2 r x4 cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_leqList x1
    x2 z x4 cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_leqList x1 x2 e x4
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort.leqList"
    [show x1, show x2, show x3, show x4] info)
  _ -> failCons cd (consFail "Sort.leqList" (showCons x3))

nd_C_leqList :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0 -> Func t0 (Func t0
  Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_List t0
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.C_Bool
nd_C_leqList x1 x2 x3 x4 s cd cs = case x3 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_True
  Curry_Prelude.OP_Cons x5 x6 -> let s0 = s
    in s0 `seq` nd_C__case_18 x5 x1 x2 x6 x4 s0 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C_leqList x1 x2 l x4 s
    cd cs) (nd_C_leqList x1 x2 r x4 s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C_leqList x1
    x2 z x4 s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C_leqList x1 x2 e x4 s
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort.leqList"
    [show x1, show x2, show x3, show x4] info)
  _ -> failCons cd (consFail "Sort.leqList" (showCons x3))

d_C_cmpList :: forall t0 . (Curry_Prelude.Curry t0) => (t0 -> Cover
  -> ConstStore -> t0 -> Cover -> ConstStore -> Curry_Prelude.C_Ordering)
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore
  -> Curry_Prelude.C_Ordering
d_C_cmpList x1 x2 x3 cd cs = case x2 of
  Curry_Prelude.OP_List -> d_C__case_15 x3 cd cs
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_14 x6 x1 x7 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_cmpList x1 l x3 cd cs)
    (d_C_cmpList x1 r x3 cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_cmpList x1 z
    x3 cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_cmpList x1 e x3 cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort.cmpList"
    [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "Sort.cmpList" (showCons x2))

nd_C_cmpList :: forall t0 . (Curry_Prelude.Curry t0) => Func t0 (Func t0
  Curry_Prelude.C_Ordering) -> Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_List
  t0 -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.C_Ordering
nd_C_cmpList x1 x2 x3 s cd cs = case x2 of
  Curry_Prelude.OP_List -> d_C__case_15 x3 cd cs
  Curry_Prelude.OP_Cons x6 x7 -> let s0 = s
    in s0 `seq` nd_C__case_14 x6 x1 x7 x3 s0 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C_cmpList x1 l x3 s cd
    cs) (nd_C_cmpList x1 r x3 s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C_cmpList x1
    z x3 s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C_cmpList x1 e x3 s
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort.cmpList"
    [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "Sort.cmpList" (showCons x2))

d_C_leqChar :: Cover -> ConstStore -> Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_leqChar cd cs = acceptCs id
  Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Char

d_C_cmpChar :: Cover -> ConstStore -> Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Ordering
d_C_cmpChar cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_compare_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  cd cs

d_C_leqCharIgnoreCase :: Curry_Prelude.C_Char -> Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_C_leqCharIgnoreCase x1 x2 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  (Curry_Char.d_C_toUpper x1 cd cs) (Curry_Char.d_C_toUpper x2 cd cs) cd cs

d_C_leqString :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_leqString cd cs = acceptCs id
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char cd
  cs))

d_C_cmpString :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Ordering
d_C_cmpString cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_compare_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char cd
  cs) cd cs

d_C_leqStringIgnoreCase :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_leqStringIgnoreCase cd cs = acceptCs id (d_C_leqList
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) (acceptCs id d_C_leqCharIgnoreCase))

d_C_leqLexGerman :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_leqLexGerman x1 x2 cd cs = case x1 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_True
  Curry_Prelude.OP_Cons x3 x4 -> d_C__case_11 x3 x4 x2 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_leqLexGerman l x2 cd
    cs) (d_C_leqLexGerman r x2 cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_leqLexGerman
    z x2 cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_leqLexGerman e x2
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort.leqLexGerman"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Sort.leqLexGerman" (showCons x1))

d_OP_leqLexGerman_dot_glex_dot_147 :: Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.C_Int
d_OP_leqLexGerman_dot_glex_dot_147 x1 cd cs = d_C__case_8 x1
  (Curry_Prelude.d_OP_amp_amp (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
  cd cs) x1 cd cs) (Curry_Prelude.d_C_ord (Curry_Prelude.C_Char 'A'#) cd cs) cd
  cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
  x1 (Curry_Prelude.d_C_ord (Curry_Prelude.C_Char 'Z'#) cd cs) cd cs) cd cs) cd
  cs

d_C__case_8 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Int
d_C__case_8 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x1
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    (Curry_Prelude.d_C_ord (Curry_Prelude.C_Char 'a'#) cd cs)
    (Curry_Prelude.d_C_ord (Curry_Prelude.C_Char 'A'#) cd cs) cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_7 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
    x1 (Curry_Prelude.C_Int (228)) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_8 x1 l cd cs)
    (d_C__case_8 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_8 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_8 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_8" [show
    x1, show x2] info)
  _ -> failCons cd (consFail "Sort._case_8" (showCons x2))

d_C__case_7 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Int
d_C__case_7 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_ord (Curry_Prelude.C_Char 'a'#) cd
    cs
  Curry_Prelude.C_False -> d_C__case_6 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
    x1 (Curry_Prelude.C_Int (246)) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_7 x1 l cd cs)
    (d_C__case_7 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_7 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_7 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_7" [show
    x1, show x2] info)
  _ -> failCons cd (consFail "Sort._case_7" (showCons x2))

d_C__case_6 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Int
d_C__case_6 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_ord (Curry_Prelude.C_Char 'o'#) cd
    cs
  Curry_Prelude.C_False -> d_C__case_5 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
    x1 (Curry_Prelude.C_Int (252)) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_6 x1 l cd cs)
    (d_C__case_6 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_6 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_6 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_6" [show
    x1, show x2] info)
  _ -> failCons cd (consFail "Sort._case_6" (showCons x2))

d_C__case_5 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Int
d_C__case_5 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_ord (Curry_Prelude.C_Char 'u'#) cd
    cs
  Curry_Prelude.C_False -> d_C__case_4 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
    x1 (Curry_Prelude.C_Int (196)) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_5 x1 l cd cs)
    (d_C__case_5 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_5 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_5 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_5" [show
    x1, show x2] info)
  _ -> failCons cd (consFail "Sort._case_5" (showCons x2))

d_C__case_4 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Int
d_C__case_4 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_ord (Curry_Prelude.C_Char 'a'#) cd
    cs
  Curry_Prelude.C_False -> d_C__case_3 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
    x1 (Curry_Prelude.C_Int (214)) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_4 x1 l cd cs)
    (d_C__case_4 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_4 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_4 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_4" [show
    x1, show x2] info)
  _ -> failCons cd (consFail "Sort._case_4" (showCons x2))

d_C__case_3 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Int
d_C__case_3 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_ord (Curry_Prelude.C_Char 'o'#) cd
    cs
  Curry_Prelude.C_False -> d_C__case_2 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
    x1 (Curry_Prelude.C_Int (220)) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_3 x1 l cd cs)
    (d_C__case_3 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_3 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_3 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_3" [show
    x1, show x2] info)
  _ -> failCons cd (consFail "Sort._case_3" (showCons x2))

d_C__case_2 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Int
d_C__case_2 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_ord (Curry_Prelude.C_Char 'u'#) cd
    cs
  Curry_Prelude.C_False -> d_C__case_1 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
    x1 (Curry_Prelude.C_Int (223)) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_2 x1 l cd cs)
    (d_C__case_2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_2 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_2 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_2" [show
    x1, show x2] info)
  _ -> failCons cd (consFail "Sort._case_2" (showCons x2))

d_C__case_1 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Int
d_C__case_1 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_ord (Curry_Prelude.C_Char 's'#) cd
    cs
  Curry_Prelude.C_False -> d_C__case_0 x1 (Curry_Prelude.d_C_otherwise cd cs) cd
    cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_1 x1 l cd cs)
    (d_C__case_1 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_1 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_1 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_1" [show
    x1, show x2] info)
  _ -> failCons cd (consFail "Sort._case_1" (showCons x2))

d_C__case_0 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Int
d_C__case_0 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> x1
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_0 x1 l cd cs)
    (d_C__case_0 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_0 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_0 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_0" [show
    x1, show x2] info)
  _ -> failCons cd (consFail "Sort._case_0" (showCons x2))

d_C__case_11 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_11 x3 x4 x2 cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_False
  Curry_Prelude.OP_Cons x5 x6 -> let x7 = d_OP_leqLexGerman_dot_glex_dot_147
                                       (Curry_Prelude.d_C_ord x3 cd cs) cd cs
                                     x8 = d_OP_leqLexGerman_dot_glex_dot_147
                                       (Curry_Prelude.d_C_ord x5 cd cs) cd cs
    in d_C__case_10 x8 x7 x6 x4
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
    x7 x8 cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_11 x3 x4 l cd
    cs) (d_C__case_11 x3 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_11 x3
    x4 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_11 x3 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort._case_11"
    [show x3, show x4, show x2] info)
  _ -> failCons cd (consFail "Sort._case_11" (showCons x2))

d_C__case_10 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C__case_10 x8 x7 x6 x4 x9 cd cs = case x9 of
  Curry_Prelude.C_True -> d_C_leqLexGerman x4 x6 cd cs
  Curry_Prelude.C_False -> d_C__case_9 x8 x7 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_10 x8 x7 x6 x4 l
    cd cs) (d_C__case_10 x8 x7 x6 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_10 x8
    x7 x6 x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_10 x8 x7 x6 x4 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_10"
    [show x8, show x7, show x6, show x4, show x9] info)
  _ -> failCons cd (consFail "Sort._case_10" (showCons x9))

d_C__case_9 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_9 x8 x7 x9 cd cs = case x9 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
    cd cs) x7 cd cs) x8 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_9 x8 x7 l cd cs)
    (d_C__case_9 x8 x7 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_9 x8 x7
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_9 x8 x7 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_9" [show
    x8, show x7, show x9] info)
  _ -> failCons cd (consFail "Sort._case_9" (showCons x9))

d_C__case_14 :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> (t0 -> Cover
  -> ConstStore -> t0 -> Cover -> ConstStore -> Curry_Prelude.C_Ordering)
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore
  -> Curry_Prelude.C_Ordering
d_C__case_14 x6 x1 x7 x3 cd cs = case x3 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_GT
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_13 x8 x6 x1 x9 x7
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Ordering
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x1 x6 cd cs) x8 cd cs)
    Curry_Prelude.C_EQ cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_14 x6 x1 x7 l cd
    cs) (d_C__case_14 x6 x1 x7 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_14 x6
    x1 x7 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_14 x6 x1 x7 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort._case_14"
    [show x6, show x1, show x7, show x3] info)
  _ -> failCons cd (consFail "Sort._case_14" (showCons x3))

nd_C__case_14 :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> Func t0 (Func t0
  Curry_Prelude.C_Ordering) -> Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_List
  t0 -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.C_Ordering
nd_C__case_14 x6 x1 x7 x3 s cd cs = case x3 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_GT
  Curry_Prelude.OP_Cons x8 x9 -> let s4 = s
    in s4 `seq` (let s3 = leftSupply s4
                     s2 = rightSupply s4
    in s3 `seq` (s2 `seq` nd_C__case_13 x8 x6 x1 x9 x7
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Ordering
    (let s1 = leftSupply s2
         s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x1
    x6 s0 cd cs) x8 s1 cd cs)) Curry_Prelude.C_EQ cd cs) s3 cd cs))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_14 x6 x1 x7 l s
    cd cs) (nd_C__case_14 x6 x1 x7 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_14 x6
    x1 x7 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C__case_14 x6 x1 x7 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort._case_14"
    [show x6, show x1, show x7, show x3] info)
  _ -> failCons cd (consFail "Sort._case_14" (showCons x3))

d_C__case_13 :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> t0 -> (t0 -> Cover
  -> ConstStore -> t0 -> Cover -> ConstStore -> Curry_Prelude.C_Ordering)
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_Ordering
d_C__case_13 x8 x6 x1 x9 x7 x10 cd cs = case x10 of
  Curry_Prelude.C_True -> d_C_cmpList x1 x7 x9 cd cs
  Curry_Prelude.C_False -> d_C__case_12 x8 x6 x1 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_13 x8 x6 x1 x9 x7
    l cd cs) (d_C__case_13 x8 x6 x1 x9 x7 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_13 x8
    x6 x1 x9 x7 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_13 x8 x6 x1 x9 x7
    e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_13"
    [show x8, show x6, show x1, show x9, show x7, show x10] info)
  _ -> failCons cd (consFail "Sort._case_13" (showCons x10))

nd_C__case_13 :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> t0 -> Func t0
  (Func t0 Curry_Prelude.C_Ordering) -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.C_Ordering
nd_C__case_13 x8 x6 x1 x9 x7 x10 s cd cs = case x10 of
  Curry_Prelude.C_True -> let s0 = s in s0 `seq` nd_C_cmpList x1 x7 x9 s0 cd cs
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_12 x8 x6 x1 (Curry_Prelude.d_C_otherwise cd cs) s0 cd
    cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_13 x8 x6 x1 x9
    x7 l s cd cs) (nd_C__case_13 x8 x6 x1 x9 x7 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_13 x8
    x6 x1 x9 x7 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_13 x8 x6 x1 x9
    x7 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_13"
    [show x8, show x6, show x1, show x9, show x7, show x10] info)
  _ -> failCons cd (consFail "Sort._case_13" (showCons x10))

d_C__case_12 :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> t0 -> (t0 -> Cover
  -> ConstStore -> t0 -> Cover -> ConstStore -> Curry_Prelude.C_Ordering)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_Ordering
d_C__case_12 x8 x6 x1 x9 cd cs = case x9 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x1 x6
    cd cs) x8 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_12 x8 x6 x1 l cd
    cs) (d_C__case_12 x8 x6 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_12 x8
    x6 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_12 x8 x6 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_12"
    [show x8, show x6, show x1, show x9] info)
  _ -> failCons cd (consFail "Sort._case_12" (showCons x9))

nd_C__case_12 :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> t0 -> Func t0
  (Func t0 Curry_Prelude.C_Ordering) -> Curry_Prelude.C_Bool -> IDSupply
  -> Cover -> ConstStore -> Curry_Prelude.C_Ordering
nd_C__case_12 x8 x6 x1 x9 s cd cs = case x9 of
  Curry_Prelude.C_True -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x1
    x6 s0 cd cs) x8 s1 cd cs))
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_12 x8 x6 x1 l s
    cd cs) (nd_C__case_12 x8 x6 x1 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_12 x8
    x6 x1 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_12 x8 x6 x1 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_12"
    [show x8, show x6, show x1, show x9] info)
  _ -> failCons cd (consFail "Sort._case_12" (showCons x9))

d_C__case_15 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List t0
  -> Cover -> ConstStore -> Curry_Prelude.C_Ordering
d_C__case_15 x3 cd cs = case x3 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_EQ
  Curry_Prelude.OP_Cons x4 x5 -> Curry_Prelude.C_LT
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_15 l cd cs)
    (d_C__case_15 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_15 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_15 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort._case_15"
    [show x3] info)
  _ -> failCons cd (consFail "Sort._case_15" (showCons x3))

d_C__case_18 :: forall t0 . (Curry_Prelude.Curry t0) => t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Eq t0 -> (t0 -> Cover -> ConstStore -> t0
  -> Cover -> ConstStore -> Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_18 x5 x1 x2 x6 x4 cd cs = case x4 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_False
  Curry_Prelude.OP_Cons x7 x8 -> d_C__case_17 x7 x5 x1 x2 x8 x6
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (Curry_Prelude.d_OP_eq_eq
    x1 cd cs) x5 cd cs) x7 cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_18 x5 x1 x2 x6 l
    cd cs) (d_C__case_18 x5 x1 x2 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_18 x5
    x1 x2 x6 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_18 x5 x1 x2 x6 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort._case_18"
    [show x5, show x1, show x2, show x6, show x4] info)
  _ -> failCons cd (consFail "Sort._case_18" (showCons x4))

nd_C__case_18 :: forall t0 . (Curry_Prelude.Curry t0) => t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Eq t0 -> Func t0 (Func t0
  Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_List t0
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.C_Bool
nd_C__case_18 x5 x1 x2 x6 x4 s cd cs = case x4 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_False
  Curry_Prelude.OP_Cons x7 x8 -> let s6 = s
    in s6 `seq` (let s5 = leftSupply s6
                     s4 = rightSupply s6
    in s5 `seq` (s4 `seq` nd_C__case_17 x7 x5 x1 x2 x8 x6 (let s3 = leftSupply
                                                                 s4
                                                               s2 = rightSupply
                                                                 s4
    in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                        s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_OP_eq_eq x1
    s0 cd cs) x5 s1 cd cs)) x7 s3 cd cs)) s5 cd cs))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_18 x5 x1 x2 x6
    l s cd cs) (nd_C__case_18 x5 x1 x2 x6 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_18 x5
    x1 x2 x6 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C__case_18 x5 x1 x2 x6
    e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort._case_18"
    [show x5, show x1, show x2, show x6, show x4] info)
  _ -> failCons cd (consFail "Sort._case_18" (showCons x4))

d_C__case_17 :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Eq t0 -> (t0 -> Cover -> ConstStore -> t0
  -> Cover -> ConstStore -> Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C__case_17 x7 x5 x1 x2 x8 x6 x9 cd cs = case x9 of
  Curry_Prelude.C_True -> d_C_leqList x1 x2 x6 x8 cd cs
  Curry_Prelude.C_False -> d_C__case_16 x7 x5 x2 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_17 x7 x5 x1 x2 x8
    x6 l cd cs) (d_C__case_17 x7 x5 x1 x2 x8 x6 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_17 x7
    x5 x1 x2 x8 x6 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_17 x7 x5 x1 x2 x8
    x6 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_17"
    [show x7, show x5, show x1, show x2, show x8, show x6, show x9] info)
  _ -> failCons cd (consFail "Sort._case_17" (showCons x9))

nd_C__case_17 :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Eq t0 -> Func t0 (Func t0
  Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
nd_C__case_17 x7 x5 x1 x2 x8 x6 x9 s cd cs = case x9 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` nd_C_leqList x1 x2 x6 x8 s0 cd cs
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_16 x7 x5 x2 (Curry_Prelude.d_C_otherwise cd cs) s0 cd
    cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_17 x7 x5 x1 x2
    x8 x6 l s cd cs) (nd_C__case_17 x7 x5 x1 x2 x8 x6 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_17 x7
    x5 x1 x2 x8 x6 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_17 x7 x5 x1 x2
    x8 x6 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_17"
    [show x7, show x5, show x1, show x2, show x8, show x6, show x9] info)
  _ -> failCons cd (consFail "Sort._case_17" (showCons x9))

d_C__case_16 :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> t0 -> (t0 -> Cover
  -> ConstStore -> t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_16 x7 x5 x2 x8 cd cs = case x8 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x2 x5
    cd cs) x7 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_16 x7 x5 x2 l cd
    cs) (d_C__case_16 x7 x5 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_16 x7
    x5 x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_16 x7 x5 x2 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_16"
    [show x7, show x5, show x2, show x8] info)
  _ -> failCons cd (consFail "Sort._case_16" (showCons x8))

nd_C__case_16 :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> t0 -> Func t0
  (Func t0 Curry_Prelude.C_Bool) -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
nd_C__case_16 x7 x5 x2 x8 s cd cs = case x8 of
  Curry_Prelude.C_True -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x2
    x5 s0 cd cs) x7 s1 cd cs))
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_16 x7 x5 x2 l s
    cd cs) (nd_C__case_16 x7 x5 x2 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_16 x7
    x5 x2 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_16 x7 x5 x2 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_16"
    [show x7, show x5, show x2, show x8] info)
  _ -> failCons cd (consFail "Sort._case_16" (showCons x8))

d_C__case_21 :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> (t0 -> Cover
  -> ConstStore -> t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool)
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0
d_C__case_21 x4 x1 x5 x3 cd cs = case x3 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Cons x4 x5
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_20 x6 x4 x1 x7 x5
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x1 x4 cd cs) x6 cd cs) cd
    cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_21 x4 x1 x5 l cd
    cs) (d_C__case_21 x4 x1 x5 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_21 x4
    x1 x5 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_21 x4 x1 x5 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort._case_21"
    [show x4, show x1, show x5, show x3] info)
  _ -> failCons cd (consFail "Sort._case_21" (showCons x3))

nd_C__case_21 :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> Func t0 (Func t0
  Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_List t0
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
nd_C__case_21 x4 x1 x5 x3 s cd cs = case x3 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Cons x4 x5
  Curry_Prelude.OP_Cons x6 x7 -> let s4 = s
    in s4 `seq` (let s3 = leftSupply s4
                     s2 = rightSupply s4
    in s3 `seq` (s2 `seq` nd_C__case_20 x6 x4 x1 x7 x5 (let s1 = leftSupply s2
                                                            s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x1
    x4 s0 cd cs) x6 s1 cd cs)) s3 cd cs))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_21 x4 x1 x5 l s
    cd cs) (nd_C__case_21 x4 x1 x5 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_21 x4
    x1 x5 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C__case_21 x4 x1 x5 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort._case_21"
    [show x4, show x1, show x5, show x3] info)
  _ -> failCons cd (consFail "Sort._case_21" (showCons x3))

d_C__case_20 :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> t0 -> (t0 -> Cover
  -> ConstStore -> t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool)
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_C__case_20 x6 x4 x1 x7 x5 x8 cd cs = case x8 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons x4 (d_C_merge x1 x5
    (Curry_Prelude.OP_Cons x6 x7) cd cs)
  Curry_Prelude.C_False -> d_C__case_19 x7 x5 x4 x1 x6
    (Curry_Prelude.d_C_otherwise cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_20 x6 x4 x1 x7 x5
    l cd cs) (d_C__case_20 x6 x4 x1 x7 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_20 x6
    x4 x1 x7 x5 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_20 x6 x4 x1 x7 x5
    e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_20"
    [show x6, show x4, show x1, show x7, show x5, show x8] info)
  _ -> failCons cd (consFail "Sort._case_20" (showCons x8))

nd_C__case_20 :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> t0 -> Func t0
  (Func t0 Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_List t0
nd_C__case_20 x6 x4 x1 x7 x5 x8 s cd cs = case x8 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` Curry_Prelude.OP_Cons x4 (nd_C_merge x1 x5
    (Curry_Prelude.OP_Cons x6 x7) s0 cd cs)
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_19 x7 x5 x4 x1 x6 (Curry_Prelude.d_C_otherwise cd cs)
    s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_20 x6 x4 x1 x7
    x5 l s cd cs) (nd_C__case_20 x6 x4 x1 x7 x5 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_20 x6
    x4 x1 x7 x5 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_20 x6 x4 x1 x7
    x5 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_20"
    [show x6, show x4, show x1, show x7, show x5, show x8] info)
  _ -> failCons cd (consFail "Sort._case_20" (showCons x8))

d_C__case_19 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List t0
  -> Curry_Prelude.OP_List t0 -> t0 -> (t0 -> Cover -> ConstStore -> t0 -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool) -> t0 -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List t0
d_C__case_19 x7 x5 x4 x1 x6 x8 cd cs = case x8 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons x6 (d_C_merge x1
    (Curry_Prelude.OP_Cons x4 x5) x7 cd cs)
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_19 x7 x5 x4 x1 x6
    l cd cs) (d_C__case_19 x7 x5 x4 x1 x6 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_19 x7
    x5 x4 x1 x6 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_19 x7 x5 x4 x1 x6
    e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_19"
    [show x7, show x5, show x4, show x1, show x6, show x8] info)
  _ -> failCons cd (consFail "Sort._case_19" (showCons x8))

nd_C__case_19 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  t0 -> Curry_Prelude.OP_List t0 -> t0 -> Func t0 (Func t0 Curry_Prelude.C_Bool)
  -> t0 -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0
nd_C__case_19 x7 x5 x4 x1 x6 x8 s cd cs = case x8 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` Curry_Prelude.OP_Cons x6 (nd_C_merge x1 (Curry_Prelude.OP_Cons
    x4 x5) x7 s0 cd cs)
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_19 x7 x5 x4 x1
    x6 l s cd cs) (nd_C__case_19 x7 x5 x4 x1 x6 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_19 x7
    x5 x4 x1 x6 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_19 x7 x5 x4 x1
    x6 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_19"
    [show x7, show x5, show x4, show x1, show x6, show x8] info)
  _ -> failCons cd (consFail "Sort._case_19" (showCons x8))

d_C__case_22 :: forall t0 . (Curry_Prelude.Curry t0) => (t0 -> Cover
  -> ConstStore -> t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool)
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  t0) -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_C__case_22 x1 x3 x4 cd cs = case x4 of
  Curry_Prelude.OP_List -> x3
  Curry_Prelude.OP_Cons x5 x6 -> d_OP_mergeSortBy_dot_mergeLists_dot_74 x1
    (Curry_Prelude.OP_Cons (d_C_merge x1 x3 x5 cd cs)
    (d_OP_mergeSortBy_dot_mergePairs_dot_74 x1 x6 cd cs)) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_22 x1 x3 l cd
    cs) (d_C__case_22 x1 x3 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_22 x1
    x3 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_22 x1 x3 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort._case_22"
    [show x1, show x3, show x4] info)
  _ -> failCons cd (consFail "Sort._case_22" (showCons x4))

nd_C__case_22 :: forall t0 . (Curry_Prelude.Curry t0) => Func t0 (Func t0
  Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List t0) -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0
nd_C__case_22 x1 x3 x4 s cd cs = case x4 of
  Curry_Prelude.OP_List -> x3
  Curry_Prelude.OP_Cons x5 x6 -> let s4 = s
    in s4 `seq` (let s3 = leftSupply s4
                     s2 = rightSupply s4
    in s3 `seq` (s2 `seq` nd_OP_mergeSortBy_dot_mergeLists_dot_74 x1
    (let s0 = leftSupply s2
         s1 = rightSupply s2
    in s0 `seq` (s1 `seq` Curry_Prelude.OP_Cons (nd_C_merge x1 x3 x5 s0 cd cs)
    (nd_OP_mergeSortBy_dot_mergePairs_dot_74 x1 x6 s1 cd cs))) s3 cd cs))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_22 x1 x3 l s cd
    cs) (nd_C__case_22 x1 x3 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_22 x1
    x3 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C__case_22 x1 x3 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort._case_22"
    [show x1, show x3, show x4] info)
  _ -> failCons cd (consFail "Sort._case_22" (showCons x4))

d_C__case_23 :: forall t0 . (Curry_Prelude.Curry t0) => (t0 -> Cover
  -> ConstStore -> t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool)
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  t0) -> Cover -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List t0)
d_C__case_23 x1 x3 x4 cd cs = case x4 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Cons x3 Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x5 x6 -> Curry_Prelude.OP_Cons (d_C_merge x1 x3 x5 cd
    cs) (d_OP_mergeSortBy_dot_mergePairs_dot_74 x1 x6 cd cs)
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_23 x1 x3 l cd
    cs) (d_C__case_23 x1 x3 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_23 x1
    x3 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_23 x1 x3 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort._case_23"
    [show x1, show x3, show x4] info)
  _ -> failCons cd (consFail "Sort._case_23" (showCons x4))

nd_C__case_23 :: forall t0 . (Curry_Prelude.Curry t0) => Func t0 (Func t0
  Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List t0) -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List t0)
nd_C__case_23 x1 x3 x4 s cd cs = case x4 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Cons x3 Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x5 x6 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` Curry_Prelude.OP_Cons (nd_C_merge x1 x3 x5 s0 cd cs)
    (nd_OP_mergeSortBy_dot_mergePairs_dot_74 x1 x6 s1 cd cs)))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_23 x1 x3 l s cd
    cs) (nd_C__case_23 x1 x3 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_23 x1
    x3 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C__case_23 x1 x3 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort._case_23"
    [show x1, show x3, show x4] info)
  _ -> failCons cd (consFail "Sort._case_23" (showCons x4))

d_C__case_26 :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> (t0 -> Cover
  -> ConstStore -> t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool)
  -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List t0)
d_C__case_26 x3 x1 x4 cd cs = case x4 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Cons (Curry_Prelude.OP_Cons x3
    Curry_Prelude.OP_List) Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x5 x6 -> d_C__case_25 x5 x3 x1 x6
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x1 x3 cd cs) x5 cd cs) cd
    cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_26 x3 x1 l cd
    cs) (d_C__case_26 x3 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_26 x3
    x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_26 x3 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort._case_26"
    [show x3, show x1, show x4] info)
  _ -> failCons cd (consFail "Sort._case_26" (showCons x4))

nd_C__case_26 :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> Func t0 (Func t0
  Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List t0 -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List t0)
nd_C__case_26 x3 x1 x4 s cd cs = case x4 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Cons (Curry_Prelude.OP_Cons x3
    Curry_Prelude.OP_List) Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x5 x6 -> let s4 = s
    in s4 `seq` (let s3 = leftSupply s4
                     s2 = rightSupply s4
    in s3 `seq` (s2 `seq` nd_C__case_25 x5 x3 x1 x6 (let s1 = leftSupply s2
                                                         s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x1
    x3 s0 cd cs) x5 s1 cd cs)) s3 cd cs))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_26 x3 x1 l s cd
    cs) (nd_C__case_26 x3 x1 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_26 x3
    x1 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C__case_26 x3 x1 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort._case_26"
    [show x3, show x1, show x4] info)
  _ -> failCons cd (consFail "Sort._case_26" (showCons x4))

d_C__case_25 :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> t0 -> (t0 -> Cover
  -> ConstStore -> t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool)
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List t0)
d_C__case_25 x5 x3 x1 x6 x7 cd cs = case x7 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons (Curry_Prelude.OP_Cons x3
    (Curry_Prelude.OP_Cons x5 Curry_Prelude.OP_List))
    (d_OP_mergeSortBy_dot_genRuns_dot_74 x1 x6 cd cs)
  Curry_Prelude.C_False -> d_C__case_24 x6 x1 x3 x5 (Curry_Prelude.d_C_otherwise
    cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_25 x5 x3 x1 x6 l
    cd cs) (d_C__case_25 x5 x3 x1 x6 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_25 x5
    x3 x1 x6 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_25 x5 x3 x1 x6 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_25"
    [show x5, show x3, show x1, show x6, show x7] info)
  _ -> failCons cd (consFail "Sort._case_25" (showCons x7))

nd_C__case_25 :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> t0 -> Func t0
  (Func t0 Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List t0)
nd_C__case_25 x5 x3 x1 x6 x7 s cd cs = case x7 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` Curry_Prelude.OP_Cons (Curry_Prelude.OP_Cons x3
    (Curry_Prelude.OP_Cons x5 Curry_Prelude.OP_List))
    (nd_OP_mergeSortBy_dot_genRuns_dot_74 x1 x6 s0 cd cs)
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_24 x6 x1 x3 x5 (Curry_Prelude.d_C_otherwise cd cs) s0
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_25 x5 x3 x1 x6 l
    s cd cs) (nd_C__case_25 x5 x3 x1 x6 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_25 x5
    x3 x1 x6 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_25 x5 x3 x1 x6 e
    s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_25"
    [show x5, show x3, show x1, show x6, show x7] info)
  _ -> failCons cd (consFail "Sort._case_25" (showCons x7))

d_C__case_24 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List t0
  -> (t0 -> Cover -> ConstStore -> t0 -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool) -> t0 -> t0 -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List t0)
d_C__case_24 x6 x1 x3 x5 x7 cd cs = case x7 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons (Curry_Prelude.OP_Cons x5
    (Curry_Prelude.OP_Cons x3 Curry_Prelude.OP_List))
    (d_OP_mergeSortBy_dot_genRuns_dot_74 x1 x6 cd cs)
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_24 x6 x1 x3 x5 l
    cd cs) (d_C__case_24 x6 x1 x3 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_24 x6
    x1 x3 x5 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_24 x6 x1 x3 x5 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_24"
    [show x6, show x1, show x3, show x5, show x7] info)
  _ -> failCons cd (consFail "Sort._case_24" (showCons x7))

nd_C__case_24 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  t0 -> Func t0 (Func t0 Curry_Prelude.C_Bool) -> t0 -> t0
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List t0)
nd_C__case_24 x6 x1 x3 x5 x7 s cd cs = case x7 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` Curry_Prelude.OP_Cons (Curry_Prelude.OP_Cons x5
    (Curry_Prelude.OP_Cons x3 Curry_Prelude.OP_List))
    (nd_OP_mergeSortBy_dot_genRuns_dot_74 x1 x6 s0 cd cs)
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_24 x6 x1 x3 x5 l
    s cd cs) (nd_C__case_24 x6 x1 x3 x5 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_24 x6
    x1 x3 x5 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_24 x6 x1 x3 x5 e
    s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_24"
    [show x6, show x1, show x3, show x5, show x7] info)
  _ -> failCons cd (consFail "Sort._case_24" (showCons x7))

d_C__case_28 :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> t0 -> (t0 -> Cover
  -> ConstStore -> t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool)
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List t0) (Curry_Prelude.OP_List t0)
d_C__case_28 x2 x4 x1 x8 x7 x9 cd cs = case x9 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Cons x4 x7)
    x8
  Curry_Prelude.C_False -> d_C__case_27 x8 x4 x7 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_28 x2 x4 x1 x8 x7
    l cd cs) (d_C__case_28 x2 x4 x1 x8 x7 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_28 x2
    x4 x1 x8 x7 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_28 x2 x4 x1 x8 x7
    e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_28"
    [show x2, show x4, show x1, show x8, show x7, show x9] info)
  _ -> failCons cd (consFail "Sort._case_28" (showCons x9))

nd_C__case_28 :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> t0 -> Func t0
  (Func t0 Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List t0)
  (Curry_Prelude.OP_List t0)
nd_C__case_28 x2 x4 x1 x8 x7 x9 s cd cs = case x9 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Cons x4 x7)
    x8
  Curry_Prelude.C_False -> d_C__case_27 x8 x4 x7 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_28 x2 x4 x1 x8
    x7 l s cd cs) (nd_C__case_28 x2 x4 x1 x8 x7 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_28 x2
    x4 x1 x8 x7 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_28 x2 x4 x1 x8
    x7 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_28"
    [show x2, show x4, show x1, show x8, show x7, show x9] info)
  _ -> failCons cd (consFail "Sort._case_28" (showCons x9))

d_C__case_27 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List t0
  -> t0 -> Curry_Prelude.OP_List t0 -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List t0)
  (Curry_Prelude.OP_List t0)
d_C__case_27 x8 x4 x7 x9 cd cs = case x9 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Tuple2 x7 (Curry_Prelude.OP_Cons x4
    x8)
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_27 x8 x4 x7 l cd
    cs) (d_C__case_27 x8 x4 x7 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_27 x8
    x4 x7 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_27 x8 x4 x7 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_27"
    [show x8, show x4, show x7, show x9] info)
  _ -> failCons cd (consFail "Sort._case_27" (showCons x9))

d_C__case_30 :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> t0 -> (t0 -> Cover
  -> ConstStore -> t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool)
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_C__case_30 x4 x1 x2 x5 x3 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons x1 x3
  Curry_Prelude.C_False -> d_C__case_29 x5 x2 x1 x4 (Curry_Prelude.d_C_otherwise
    cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_30 x4 x1 x2 x5 x3
    l cd cs) (d_C__case_30 x4 x1 x2 x5 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_30 x4
    x1 x2 x5 x3 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_30 x4 x1 x2 x5 x3
    e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_30"
    [show x4, show x1, show x2, show x5, show x3, show x6] info)
  _ -> failCons cd (consFail "Sort._case_30" (showCons x6))

nd_C__case_30 :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> t0 -> Func t0
  (Func t0 Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_List t0
nd_C__case_30 x4 x1 x2 x5 x3 x6 s cd cs = case x6 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons x1 x3
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_29 x5 x2 x1 x4 (Curry_Prelude.d_C_otherwise cd cs) s0
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_30 x4 x1 x2 x5
    x3 l s cd cs) (nd_C__case_30 x4 x1 x2 x5 x3 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_30 x4
    x1 x2 x5 x3 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_30 x4 x1 x2 x5
    x3 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_30"
    [show x4, show x1, show x2, show x5, show x3, show x6] info)
  _ -> failCons cd (consFail "Sort._case_30" (showCons x6))

d_C__case_29 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List t0
  -> (t0 -> Cover -> ConstStore -> t0 -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool) -> t0 -> t0 -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List t0
d_C__case_29 x5 x2 x1 x4 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons x4
    (d_OP_insertionSortBy_dot_insert_dot_43 x1 x2 x5 cd cs)
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_29 x5 x2 x1 x4 l
    cd cs) (d_C__case_29 x5 x2 x1 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_29 x5
    x2 x1 x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_29 x5 x2 x1 x4 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_29"
    [show x5, show x2, show x1, show x4, show x6] info)
  _ -> failCons cd (consFail "Sort._case_29" (showCons x6))

nd_C__case_29 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  t0 -> Func t0 (Func t0 Curry_Prelude.C_Bool) -> t0 -> t0
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0
nd_C__case_29 x5 x2 x1 x4 x6 s cd cs = case x6 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` Curry_Prelude.OP_Cons x4
    (nd_OP_insertionSortBy_dot_insert_dot_43 x1 x2 x5 s0 cd cs)
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_29 x5 x2 x1 x4 l
    s cd cs) (nd_C__case_29 x5 x2 x1 x4 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_29 x5
    x2 x1 x4 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_29 x5 x2 x1 x4 e
    s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_29"
    [show x5, show x2, show x1, show x4, show x6] info)
  _ -> failCons cd (consFail "Sort._case_29" (showCons x6))

nd_C__case_31 :: forall t0 . (Curry_Prelude.Curry t0) => t0
  -> Curry_Prelude.OP_List t0 -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0
nd_C__case_31 x1 x2 s cd cs = case x2 of
  Curry_Prelude.OP_Cons x3 x4 -> let s0 = s
    in s0 `seq` Curry_Prelude.OP_Cons x3 (nd_OP_perm_dot_insert_dot_28 x1 x4 s0
    cd cs)
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_31 x1 l s cd
    cs) (nd_C__case_31 x1 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_31 x1
    z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C__case_31 x1 e s cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort._case_31"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Sort._case_31" (showCons x2))

d_C__case_32 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List t0
  -> (t0 -> Cover -> ConstStore -> t0 -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0
d_C__case_32 x4 x2 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> x4
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_32 x4 x2 l cd cs)
    (d_C__case_32 x4 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_32 x4
    x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_32 x4 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_32"
    [show x4, show x2, show x5] info)
  _ -> failCons cd (consFail "Sort._case_32" (showCons x5))

nd_C__case_32 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  t0 -> Func t0 (Func t0 Curry_Prelude.C_Bool) -> Curry_Prelude.C_Bool
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
nd_C__case_32 x4 x2 x5 s cd cs = case x5 of
  Curry_Prelude.C_True -> x4
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_32 x4 x2 l s cd
    cs) (nd_C__case_32 x4 x2 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_32 x4
    x2 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_32 x4 x2 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Sort._case_32"
    [show x4, show x2, show x5] info)
  _ -> failCons cd (consFail "Sort._case_32" (showCons x5))

d_C__case_33 :: forall t0 . (Curry_Prelude.Curry t0) => (t0 -> Cover
  -> ConstStore -> t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool) -> t0
  -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_33 x1 x3 x4 cd cs = case x4 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_True
  Curry_Prelude.OP_Cons x5 x6 -> Curry_Prelude.d_OP_amp_amp
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x1 x3 cd cs) x5 cd cs)
    (d_C_sortedBy x1 (Curry_Prelude.OP_Cons x5 x6) cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_33 x1 x3 l cd
    cs) (d_C__case_33 x1 x3 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_33 x1
    x3 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_33 x1 x3 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort._case_33"
    [show x1, show x3, show x4] info)
  _ -> failCons cd (consFail "Sort._case_33" (showCons x4))

nd_C__case_33 :: forall t0 . (Curry_Prelude.Curry t0) => Func t0 (Func t0
  Curry_Prelude.C_Bool) -> t0 -> Curry_Prelude.OP_List t0 -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
nd_C__case_33 x1 x3 x4 s cd cs = case x4 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_True
  Curry_Prelude.OP_Cons x5 x6 -> let s4 = s
    in s4 `seq` (let s2 = leftSupply s4
                     s3 = rightSupply s4
    in s2 `seq` (s3 `seq` Curry_Prelude.d_OP_amp_amp (let s1 = leftSupply s2
                                                          s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x1
    x3 s0 cd cs) x5 s1 cd cs)) (nd_C_sortedBy x1 (Curry_Prelude.OP_Cons x5 x6)
    s3 cd cs) cd cs))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_33 x1 x3 l s cd
    cs) (nd_C__case_33 x1 x3 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_33 x1
    x3 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C__case_33 x1 x3 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Sort._case_33"
    [show x1, show x3, show x4] info)
  _ -> failCons cd (consFail "Sort._case_33" (showCons x4))

