{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE Rank2Types #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif
{-# LANGUAGE CPP, ForeignFunctionInterface, MultiParamTypeClasses #-}

module Curry_System
  ( d_C_getEnviron
  , d_C_setEnviron
  , d_C_unsetEnviron
  , d_C_system
  , d_C_exitWith
  , d_C_sleep
  , d_C_isPosix
  , d_C_getCPUTime
  , d_C_getElapsedTime
  , d_C_getArgs
  , d_C_getHostname
  , d_C_getPID
  , d_C_getProgName
  , d_C_isWindows )
  where

import Basics
import qualified Curry_Global
import qualified Curry_Prelude

import Control.Exception as C (IOException, handle)
import Network.BSD            (getHostName)
import System.CPUTime         (getCPUTime)
import System.Environment     (getArgs, getEnv, getProgName)
import System.Exit            (ExitCode (..), exitWith)
import System.Process         (system)

#if defined(mingw32_HOST_OS) || defined(__MINGW32__)
import System.Win32.Process
#else
import System.Posix.Process (getProcessID)
#endif

d_C_getEnviron :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_getEnviron x1 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Global.d_C_readGlobal (d_C_environ cd cs) cd cs)
  (d_OP_getEnviron_dot_uscore_hash_lambda2 x1) cd cs

d_OP_getEnviron_dot_uscore_hash_lambda2 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_getEnviron_dot_uscore_hash_lambda2 x1 x2 cd cs = let x3 = x2
  in Curry_Prelude.d_C_maybe (Curry_Prelude.d_OP_dollar_hash_hash
  d_C_prim_getEnviron x1 cd cs)
  Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Prelude.d_C_lookup
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs) x1 x3 cd cs) cd cs

d_C_environ :: Cover -> ConstStore -> Curry_Global.C_Global
  (Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_C_environ cd cs = global_C_environ

global_C_environ :: Curry_Global.C_Global (Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
global_C_environ = Curry_Global.d_C_global (let cs = emptyCs
                                                cd = initCover
  in Curry_Prelude.OP_List) Curry_Global.C_Temporary initCover emptyCs

d_C_setEnviron :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_setEnviron x1 x2 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Global.d_C_readGlobal (d_C_environ cd cs) cd cs)
  (d_OP_setEnviron_dot_uscore_hash_lambda5 x1 x2) cd cs

d_OP_setEnviron_dot_uscore_hash_lambda5 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_OP_setEnviron_dot_uscore_hash_lambda5 x1 x2 x3 cd cs = let x4 = x3
  in Curry_Global.d_C_writeGlobal (d_C_environ cd cs) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 x1 x2) (Curry_Prelude.d_C_filter
  (Curry_Prelude.d_OP_dot (Curry_Prelude.d_C_flip
  (Curry_Prelude.d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs) x1) Curry_Prelude.d_C_fst cd cs) x4 cd cs)) cd cs

d_C_unsetEnviron :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_unsetEnviron x1 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Global.d_C_readGlobal (d_C_environ cd cs) cd cs)
  (d_OP_unsetEnviron_dot_uscore_hash_lambda8 x1) cd cs

d_OP_unsetEnviron_dot_uscore_hash_lambda8 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
d_OP_unsetEnviron_dot_uscore_hash_lambda8 x1 x2 cd cs = let x3 = x2
  in Curry_Global.d_C_writeGlobal (d_C_environ cd cs) (Curry_Prelude.d_C_filter
  (Curry_Prelude.d_OP_dot (Curry_Prelude.d_C_flip
  (Curry_Prelude.d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs) x1) Curry_Prelude.d_C_fst cd cs) x3 cd cs) cd cs

d_C_system :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.C_Int
d_C_system x1 cd cs = let x2 = d_C_isWindows cd cs
                          x3 = d_C__case_3 x1 x2 cd cs
  in Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Global.d_C_readGlobal (d_C_environ cd cs) cd cs)
  (d_OP_system_dot_uscore_hash_lambda11 x2 x3) cd cs

d_OP_system_dot_escapeWinSpecials_dot_13 :: Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_system_dot_escapeWinSpecials_dot_13 x1 cd cs = d_C__case_2 x1
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_elem
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) x1 cd cs) (Curry_Prelude.toCurryString "<>|&^") cd cs) cd cs

d_OP_system_dot_encodeShellSpecials_dot_13 :: Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_system_dot_encodeShellSpecials_dot_13 x1 cd cs = d_C__case_1 x1
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
  x1 (Curry_Prelude.C_Char '\''#) cd cs) cd cs

d_OP_system_dot_envToExport_dot_13 :: Curry_Prelude.C_Bool
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_system_dot_envToExport_dot_13 x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> d_C__case_0 x3 x4 x1 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_system_dot_envToExport_dot_13 x1 l cd cs)
    (d_OP_system_dot_envToExport_dot_13 x1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_system_dot_envToExport_dot_13 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_system_dot_envToExport_dot_13 x1 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.system.envToExport.13" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.system.envToExport.13" (showCons x2))

d_OP_system_dot_uscore_hash_lambda11 :: Curry_Prelude.C_Bool
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.C_Int
d_OP_system_dot_uscore_hash_lambda11 x1 x2 x3 cd cs = let x4 = x3
  in Curry_Prelude.d_OP_dollar_hash_hash d_C_prim_system
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_concatMap (d_OP_system_dot_envToExport_dot_13 x1) cd cs) x4
  cd cs) x2 cd cs) cd cs

d_C_exitWith :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_Prelude.C_IO t0
d_C_exitWith x1 cd cs = Curry_Prelude.d_OP_dollar_hash d_C_prim_exitWith x1 cd
  cs

d_C_sleep :: Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
d_C_sleep x1 cd cs = Curry_Prelude.d_OP_dollar_hash d_C_prim_sleep x1 cd cs

d_C_isPosix :: Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_isPosix cd cs = Curry_Prelude.d_C_not (d_C_isWindows cd cs) cd cs

d_C__case_0 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_0 x3 x4 x1 cd cs = case x1 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.toCurryString "set ") (Curry_Prelude.d_OP_plus_plus x3
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "=")
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_concatMap d_OP_system_dot_escapeWinSpecials_dot_13 cd cs)
    x4 cd cs) (Curry_Prelude.toCurryString " && ") cd cs) cd cs) cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_OP_plus_plus x3
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "='")
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_concatMap d_OP_system_dot_encodeShellSpecials_dot_13 cd
    cs) x4 cd cs) (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString
    "' ; export ") (Curry_Prelude.d_OP_plus_plus x3 (Curry_Prelude.toCurryString
    " ; ") cd cs) cd cs) cd cs) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_0 x3 x4 l cd cs)
    (d_C__case_0 x3 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_0 x3 x4
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_0 x3 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "System._case_0"
    [show x3, show x4, show x1] info)
  _ -> failCons cd (consFail "System._case_0" (showCons x1))

d_C__case_1 :: Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_1 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_map Curry_Prelude.d_C_chr
    (Curry_Prelude.OP_Cons (Curry_Prelude.C_Int (39)) (Curry_Prelude.OP_Cons
    (Curry_Prelude.C_Int (34)) (Curry_Prelude.OP_Cons (Curry_Prelude.C_Int (39))
    (Curry_Prelude.OP_Cons (Curry_Prelude.C_Int (34)) (Curry_Prelude.OP_Cons
    (Curry_Prelude.C_Int (39)) Curry_Prelude.OP_List))))) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.OP_Cons x1 Curry_Prelude.OP_List
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_1 x1 l cd cs)
    (d_C__case_1 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_1 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_1 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "System._case_1"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "System._case_1" (showCons x2))

d_C__case_2 :: Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_2 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons (Curry_Prelude.C_Char '^'#)
    (Curry_Prelude.OP_Cons x1 Curry_Prelude.OP_List)
  Curry_Prelude.C_False -> Curry_Prelude.OP_Cons x1 Curry_Prelude.OP_List
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_2 x1 l cd cs)
    (d_C__case_2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_2 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_2 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "System._case_2"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "System._case_2" (showCons x2))

d_C__case_3 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_3 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons (Curry_Prelude.C_Char '"'#)
    (Curry_Prelude.d_OP_plus_plus x1 (Curry_Prelude.toCurryString "\"") cd cs)
  Curry_Prelude.C_False -> x1
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_3 x1 l cd cs)
    (d_C__case_3 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_3 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_3 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "System._case_3"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "System._case_3" (showCons x2))

d_C_getCPUTime :: Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_Int
d_C_getCPUTime cd cs = external_d_C_getCPUTime cd cs

d_C_getElapsedTime :: Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.C_Int
d_C_getElapsedTime cd cs = external_d_C_getElapsedTime cd cs

d_C_getArgs :: Cover -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_getArgs cd cs = external_d_C_getArgs cd cs

d_C_prim_getEnviron :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_prim_getEnviron x1 cd cs = external_d_C_prim_getEnviron x1 cd cs

d_C_getHostname :: Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_getHostname cd cs = external_d_C_getHostname cd cs

d_C_getPID :: Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_Int
d_C_getPID cd cs = external_d_C_getPID cd cs

d_C_getProgName :: Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_getProgName cd cs = external_d_C_getProgName cd cs

d_C_prim_system :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_Int
d_C_prim_system x1 cd cs = external_d_C_prim_system x1 cd cs

d_C_prim_exitWith :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_Prelude.C_IO t0
d_C_prim_exitWith x1 cd cs = external_d_C_prim_exitWith x1 cd cs

d_C_prim_sleep :: Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_prim_sleep x1 cd cs = external_d_C_prim_sleep x1 cd cs

d_C_isWindows :: Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_isWindows cd cs = external_d_C_isWindows cd cs

-- #endimport - do not remove this line!

#if defined(mingw32_HOST_OS) || defined(__MINGW32__)
foreign import stdcall unsafe "windows.h GetCurrentProcessId"
  getProcessID :: IO ProcessId
#endif

external_d_C_getCPUTime :: Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_Int
external_d_C_getCPUTime _ _ = toCurry (getCPUTime >>= return . (`div` (10 ^ 9)))

external_d_C_getElapsedTime :: Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_Int
external_d_C_getElapsedTime _ _ = toCurry (return 0 :: IO Int)

external_d_C_getArgs :: Cover -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List Curry_Prelude.C_String)
external_d_C_getArgs _ _ = toCurry getArgs

external_d_C_prim_getEnviron :: Curry_Prelude.C_String -> Cover -> ConstStore
                             -> Curry_Prelude.C_IO Curry_Prelude.C_String
external_d_C_prim_getEnviron str _ _ =
  toCurry (handle handleIOException . getEnv) str
  where
  handleIOException :: IOException -> IO String
  handleIOException _ = return ""

external_d_C_getHostname :: Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_String
external_d_C_getHostname _ _ = toCurry getHostName

external_d_C_getPID :: Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_Int
external_d_C_getPID _ _ = toCurry $ do
  pid <- getProcessID
  return (fromIntegral pid :: Int)

external_d_C_getProgName :: Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_String
external_d_C_getProgName _ _ = toCurry getProgName

external_d_C_prim_system :: Curry_Prelude.C_String -> Cover -> ConstStore
                         -> Curry_Prelude.C_IO Curry_Prelude.C_Int
external_d_C_prim_system str _ _ = toCurry system str

instance ConvertCurryHaskell Curry_Prelude.C_Int ExitCode where
  toCurry ExitSuccess     = toCurry (0 :: Int)
  toCurry (ExitFailure i) = toCurry i

  fromCurry j = let i = fromCurry j :: Int
                in if i == 0 then ExitSuccess else ExitFailure i

external_d_C_prim_exitWith :: Curry_Prelude.Curry a
                           => Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.C_IO a
external_d_C_prim_exitWith c _ _ = fromIO (exitWith (fromCurry c))

external_d_C_prim_sleep :: Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
external_d_C_prim_sleep x _ _ =
  toCurry (\i -> system ("sleep " ++ show (i :: Int)) >> return ()) x -- TODO

external_d_C_isWindows :: Cover -> ConstStore -> Curry_Prelude.C_Bool
#if defined(mingw32_HOST_OS) || defined(__MINGW32__)
external_d_C_isWindows _ _ = Curry_Prelude.C_True
#else
external_d_C_isWindows _ _ = Curry_Prelude.C_False
#endif
