{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE Rank2Types #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module Curry_Unsafe
  ( d_C_trace, d_C_unsafePerformIO, nd_C_unsafePerformIO )
  where

import Basics
import qualified Curry_Char
import qualified Curry_IO
import qualified Curry_Prelude

import System.IO.Unsafe (unsafePerformIO)

import KiCS2Debug (internalError)

d_C_trace :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> t0 -> Cover -> ConstStore -> t0
d_C_trace x1 x2 cd cs = d_C_unsafePerformIO
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_IO.d_C_hPutStrLn (Curry_IO.d_C_stderr cd cs) x1 cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  x2 cd cs) cd cs) cd cs

d_C_unsafePerformIO :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_IO t0 -> Cover -> ConstStore -> t0
d_C_unsafePerformIO x1 cd cs = external_d_C_unsafePerformIO x1 cd cs

nd_C_unsafePerformIO :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_IO t0 -> IDSupply -> Cover -> ConstStore -> t0
nd_C_unsafePerformIO x1 s cd cs = external_nd_C_unsafePerformIO x1 s cd cs

external_d_C_unsafePerformIO :: Curry_Prelude.C_IO a -> Cover -> ConstStore -> a
external_d_C_unsafePerformIO io cd cs = unsafePerformIO (toIO errSupply cd cs io)
  where errSupply = internalError "Unsafe.unsafePerformIO: ID supply used"

external_nd_C_unsafePerformIO :: Curry_Prelude.C_IO a -> IDSupply -> Cover -> ConstStore -> a
external_nd_C_unsafePerformIO io s cd cs = unsafePerformIO (toIO s cd cs io)
