{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE Rank2Types #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module Test.Curry_Prop
  ( C_PropIO (..)
  , C_Prop (..)
  , d_C_returns
  , nd_C_returns
  , d_C_sameReturns
  , nd_C_sameReturns
  , d_C_toError
  , d_C_toIOError
  , nd_C_toIOError
  , d_OP_minus_eq_minus
  , nd_OP_minus_eq_minus
  , d_OP_lt_tilde_gt
  , nd_OP_lt_tilde_gt
  , d_OP_tilde_gt
  , nd_OP_tilde_gt
  , d_OP_lt_tilde
  , nd_OP_lt_tilde
  , d_OP_lt_tilde_tilde_gt
  , nd_OP_lt_tilde_tilde_gt
  , d_OP_eq_eq_gt
  , nd_C_solutionOf
  , d_C_is
  , nd_C_is
  , d_C_isAlways
  , nd_C_isAlways
  , d_C_isEventually
  , nd_C_isEventually
  , d_C_uniquely
  , d_C_always
  , d_C_eventually
  , d_C_failing
  , nd_C_failing
  , d_C_successful
  , nd_C_successful
  , d_C_deterministic
  , nd_C_deterministic
  , d_OP_hash
  , nd_OP_hash
  , d_OP_hash_lt
  , nd_OP_hash_lt
  , d_OP_hash_gt
  , nd_OP_hash_gt
  , d_C_for
  , nd_C_for
  , d_C_forAll
  , nd_C_forAll
  , d_OP_lt_eq_gt
  , d_C_label
  , d_C_classify
  , d_C_trivial
  , d_C_collect
  , nd_C_collect
  , d_C_collectAs
  , nd_C_collectAs
  , d_C_valuesOf )
  where

import Basics
import qualified Curry_Prelude


data C_PropIO
  = C_PropIO
  | Choice_C_PropIO Cover ID C_PropIO C_PropIO
  | Choices_C_PropIO Cover ID [C_PropIO]
  | Fail_C_PropIO Cover FailInfo
  | Guard_C_PropIO Cover Constraints C_PropIO

instance Show C_PropIO where
  showsPrec d (Choice_C_PropIO cd i x y) = showsChoice d cd i x y
  showsPrec d (Choices_C_PropIO cd i xs) = showsChoices d cd i xs
  showsPrec d (Guard_C_PropIO cd c e) = showsGuard d cd c e
  showsPrec _ (Fail_C_PropIO cd info) = showChar '!'
  showsPrec _ C_PropIO = showString "PropIO"

instance Read C_PropIO where
  readsPrec _ s = readParen False (\r -> [(C_PropIO, r0) | (_, r0) <-
    readQualified "Test.Prop" "PropIO" r]) s

instance NonDet C_PropIO where
  choiceCons = Choice_C_PropIO
  choicesCons = Choices_C_PropIO
  failCons = Fail_C_PropIO
  guardCons = Guard_C_PropIO
  try (Choice_C_PropIO cd i x y) = tryChoice cd i x y
  try (Choices_C_PropIO cd i xs) = tryChoices cd i xs
  try (Fail_C_PropIO cd info) = Fail cd info
  try (Guard_C_PropIO cd c e) = Guard cd c e
  try x = Val x
  match f _ _ _ _ _ (Choice_C_PropIO cd i x y) = f cd i x y
  match _ f _ _ _ _ (Choices_C_PropIO cd i@(NarrowedID _ _) xs) = f cd i xs
  match _ _ f _ _ _ (Choices_C_PropIO cd i@(FreeID _ _) xs) = f cd i xs
  match _ _ _ _ _ _ (Choices_C_PropIO cd i _) = error
    ("Test.Prop.PropIO.match: Choices with ChoiceID " ++ show i)
  match _ _ _ f _ _ (Fail_C_PropIO cd info) = f cd info
  match _ _ _ _ f _ (Guard_C_PropIO cd c e) = f cd c e
  match _ _ _ _ _ f x = f x

instance Generable C_PropIO where
  generate s c = Choices_C_PropIO c (freeID [0] s) [C_PropIO]

instance NormalForm C_PropIO where
  ($!!) cont C_PropIO d cs = cont C_PropIO d cs
  ($!!) cont (Choice_C_PropIO cd i x y) d cs = nfChoice cont cd i x y cd cs
  ($!!) cont (Choices_C_PropIO cd i xs) d cs = nfChoices cont cd i xs d cs
  ($!!) cont (Guard_C_PropIO cd c e) d cs = guardCons cd c (($!!) cont e d
    (addCs c cs))
  ($!!) _ (Fail_C_PropIO cd info) _ _ = failCons cd info
  ($##) cont C_PropIO d cs = cont C_PropIO d cs
  ($##) cont (Choice_C_PropIO cd i x y) d cs = gnfChoice cont cd i x y cd cs
  ($##) cont (Choices_C_PropIO cd i xs) d cs = gnfChoices cont cd i xs d cs
  ($##) cont (Guard_C_PropIO cd c e) d cs = guardCons cd c (($##) cont e d
    (addCs c cs))
  ($##) _ (Fail_C_PropIO cd info) _ _ = failCons cd info
  showCons C_PropIO = "Test.Prop.PropIO"
  showCons x = error ("Test.Prop.PropIO.showCons: no constructor: " ++ show x)
  searchNF _ cont C_PropIO = cont C_PropIO
  searchNF _ _ x = error ("Test.Prop.PropIO.searchNF: no constructor: " ++ show
    x)

instance Unifiable C_PropIO where
  (=.=) C_PropIO C_PropIO d cs = C_True
  (=.=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  (=.<=) C_PropIO C_PropIO d cs = C_True
  (=.<=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  bind cd i C_PropIO = (i :=: ChooseN 0 0) : concat []
  bind d i (Choice_C_PropIO cd j x y) = [ConstraintChoice cd j (bind d i x)
    (bind d i y)]
  bind d i (Choices_C_PropIO cd j@(FreeID _ _) xs) = bindOrNarrow d i cd j xs
  bind d i (Choices_C_PropIO cd j@(NarrowedID _ _) xs) = [ConstraintChoices cd j
    (map (bind d i) xs)]
  bind _ _ (Choices_C_PropIO cd i _) = error
    ("Test.Prop.PropIO.bind: Choices with ChoiceID: " ++ show i)
  bind _ _ (Fail_C_PropIO cd info) = [Unsolvable info]
  bind d i (Guard_C_PropIO cd c e) = getConstrList c ++ bind d i e
  lazyBind cd i C_PropIO = (i :=: ChooseN 0 0) : []
  lazyBind d i (Choice_C_PropIO cd j x y) = [ConstraintChoice cd j (lazyBind d i
    x) (lazyBind d i y)]
  lazyBind d i (Choices_C_PropIO cd j@(FreeID _ _) xs) = lazyBindOrNarrow d i cd
    j xs
  lazyBind d i (Choices_C_PropIO cd j@(NarrowedID _ _) xs) = [ConstraintChoices
    cd j (map (lazyBind d i) xs)]
  lazyBind _ _ (Choices_C_PropIO cd i _) = error
    ("Test.Prop.PropIO.lazyBind: Choices with ChoiceID: " ++ show i)
  lazyBind _ _ (Fail_C_PropIO cd info) = [Unsolvable info]
  lazyBind d i (Guard_C_PropIO cd c e) = getConstrList c ++ [i :=: LazyBind
    (lazyBind d i e)]

instance Curry C_PropIO where

data C_Prop
  = C_Prop
  | Choice_C_Prop Cover ID C_Prop C_Prop
  | Choices_C_Prop Cover ID [C_Prop]
  | Fail_C_Prop Cover FailInfo
  | Guard_C_Prop Cover Constraints C_Prop

instance Show C_Prop where
  showsPrec d (Choice_C_Prop cd i x y) = showsChoice d cd i x y
  showsPrec d (Choices_C_Prop cd i xs) = showsChoices d cd i xs
  showsPrec d (Guard_C_Prop cd c e) = showsGuard d cd c e
  showsPrec _ (Fail_C_Prop cd info) = showChar '!'
  showsPrec _ C_Prop = showString "Prop"

instance Read C_Prop where
  readsPrec _ s = readParen False (\r -> [(C_Prop, r0) | (_, r0) <-
    readQualified "Test.Prop" "Prop" r]) s

instance NonDet C_Prop where
  choiceCons = Choice_C_Prop
  choicesCons = Choices_C_Prop
  failCons = Fail_C_Prop
  guardCons = Guard_C_Prop
  try (Choice_C_Prop cd i x y) = tryChoice cd i x y
  try (Choices_C_Prop cd i xs) = tryChoices cd i xs
  try (Fail_C_Prop cd info) = Fail cd info
  try (Guard_C_Prop cd c e) = Guard cd c e
  try x = Val x
  match f _ _ _ _ _ (Choice_C_Prop cd i x y) = f cd i x y
  match _ f _ _ _ _ (Choices_C_Prop cd i@(NarrowedID _ _) xs) = f cd i xs
  match _ _ f _ _ _ (Choices_C_Prop cd i@(FreeID _ _) xs) = f cd i xs
  match _ _ _ _ _ _ (Choices_C_Prop cd i _) = error
    ("Test.Prop.Prop.match: Choices with ChoiceID " ++ show i)
  match _ _ _ f _ _ (Fail_C_Prop cd info) = f cd info
  match _ _ _ _ f _ (Guard_C_Prop cd c e) = f cd c e
  match _ _ _ _ _ f x = f x

instance Generable C_Prop where
  generate s c = Choices_C_Prop c (freeID [0] s) [C_Prop]

instance NormalForm C_Prop where
  ($!!) cont C_Prop d cs = cont C_Prop d cs
  ($!!) cont (Choice_C_Prop cd i x y) d cs = nfChoice cont cd i x y cd cs
  ($!!) cont (Choices_C_Prop cd i xs) d cs = nfChoices cont cd i xs d cs
  ($!!) cont (Guard_C_Prop cd c e) d cs = guardCons cd c (($!!) cont e d (addCs
    c cs))
  ($!!) _ (Fail_C_Prop cd info) _ _ = failCons cd info
  ($##) cont C_Prop d cs = cont C_Prop d cs
  ($##) cont (Choice_C_Prop cd i x y) d cs = gnfChoice cont cd i x y cd cs
  ($##) cont (Choices_C_Prop cd i xs) d cs = gnfChoices cont cd i xs d cs
  ($##) cont (Guard_C_Prop cd c e) d cs = guardCons cd c (($##) cont e d (addCs
    c cs))
  ($##) _ (Fail_C_Prop cd info) _ _ = failCons cd info
  showCons C_Prop = "Test.Prop.Prop"
  showCons x = error ("Test.Prop.Prop.showCons: no constructor: " ++ show x)
  searchNF _ cont C_Prop = cont C_Prop
  searchNF _ _ x = error ("Test.Prop.Prop.searchNF: no constructor: " ++ show x)

instance Unifiable C_Prop where
  (=.=) C_Prop C_Prop d cs = C_True
  (=.=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  (=.<=) C_Prop C_Prop d cs = C_True
  (=.<=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  bind cd i C_Prop = (i :=: ChooseN 0 0) : concat []
  bind d i (Choice_C_Prop cd j x y) = [ConstraintChoice cd j (bind d i x) (bind
    d i y)]
  bind d i (Choices_C_Prop cd j@(FreeID _ _) xs) = bindOrNarrow d i cd j xs
  bind d i (Choices_C_Prop cd j@(NarrowedID _ _) xs) = [ConstraintChoices cd j
    (map (bind d i) xs)]
  bind _ _ (Choices_C_Prop cd i _) = error
    ("Test.Prop.Prop.bind: Choices with ChoiceID: " ++ show i)
  bind _ _ (Fail_C_Prop cd info) = [Unsolvable info]
  bind d i (Guard_C_Prop cd c e) = getConstrList c ++ bind d i e
  lazyBind cd i C_Prop = (i :=: ChooseN 0 0) : []
  lazyBind d i (Choice_C_Prop cd j x y) = [ConstraintChoice cd j (lazyBind d i
    x) (lazyBind d i y)]
  lazyBind d i (Choices_C_Prop cd j@(FreeID _ _) xs) = lazyBindOrNarrow d i cd j
    xs
  lazyBind d i (Choices_C_Prop cd j@(NarrowedID _ _) xs) = [ConstraintChoices cd
    j (map (lazyBind d i) xs)]
  lazyBind _ _ (Choices_C_Prop cd i _) = error
    ("Test.Prop.Prop.lazyBind: Choices with ChoiceID: " ++ show i)
  lazyBind _ _ (Fail_C_Prop cd info) = [Unsolvable info]
  lazyBind d i (Guard_C_Prop cd c e) = getConstrList c ++ [i :=: LazyBind
    (lazyBind d i e)]

instance Curry C_Prop where

d_C_returns :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> Curry_Prelude.C_IO t0 -> t0
  -> Cover -> ConstStore -> C_PropIO
d_C_returns x1 x2 x3 x4 cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "returns") cd cs

nd_C_returns :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> Curry_Prelude.C_IO t0 -> t0
  -> IDSupply -> Cover -> ConstStore -> C_PropIO
nd_C_returns x1 x2 x3 x4 s cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "returns") cd cs

d_C_sameReturns :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> Curry_Prelude.C_IO t0
  -> Curry_Prelude.C_IO t0 -> Cover -> ConstStore -> C_PropIO
d_C_sameReturns x1 x2 x3 x4 cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "sameReturns") cd cs

nd_C_sameReturns :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> Curry_Prelude.C_IO t0
  -> Curry_Prelude.C_IO t0 -> IDSupply -> Cover -> ConstStore -> C_PropIO
nd_C_sameReturns x1 x2 x3 x4 s cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "sameReturns") cd cs

d_C_toError :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> Cover -> ConstStore
  -> C_PropIO
d_C_toError x1 cd cs = d_C_propUndefinedError (Curry_Prelude.toCurryString
  "toError") cd cs

d_C_toIOError :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_IO t0
  -> Cover -> ConstStore -> C_PropIO
d_C_toIOError x1 cd cs = d_C_propUndefinedError (Curry_Prelude.toCurryString
  "toIOError") cd cs

nd_C_toIOError :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_IO t0
  -> IDSupply -> Cover -> ConstStore -> C_PropIO
nd_C_toIOError x1 s cd cs = d_C_propUndefinedError (Curry_Prelude.toCurryString
  "toIOError") cd cs

d_OP_minus_eq_minus :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> t0 -> Cover
  -> ConstStore -> C_Prop
d_OP_minus_eq_minus x1 x2 x3 x4 cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "-=-") cd cs

nd_OP_minus_eq_minus :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> t0 -> IDSupply -> Cover
  -> ConstStore -> C_Prop
nd_OP_minus_eq_minus x1 x2 x3 x4 s cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "-=-") cd cs

d_OP_lt_tilde_gt :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> t0 -> Cover
  -> ConstStore -> C_Prop
d_OP_lt_tilde_gt x1 x2 x3 x4 cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "<~>") cd cs

nd_OP_lt_tilde_gt :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> t0 -> IDSupply -> Cover
  -> ConstStore -> C_Prop
nd_OP_lt_tilde_gt x1 x2 x3 x4 s cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "<~>") cd cs

d_OP_tilde_gt :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> t0 -> Cover
  -> ConstStore -> C_Prop
d_OP_tilde_gt x1 x2 x3 x4 cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "~>") cd cs

nd_OP_tilde_gt :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> t0 -> IDSupply -> Cover
  -> ConstStore -> C_Prop
nd_OP_tilde_gt x1 x2 x3 x4 s cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "~>") cd cs

d_OP_lt_tilde :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> t0 -> Cover
  -> ConstStore -> C_Prop
d_OP_lt_tilde x1 x2 x3 x4 cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "<~") cd cs

nd_OP_lt_tilde :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> t0 -> IDSupply -> Cover
  -> ConstStore -> C_Prop
nd_OP_lt_tilde x1 x2 x3 x4 s cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "<~") cd cs

d_OP_lt_tilde_tilde_gt :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> t0 -> Cover
  -> ConstStore -> C_Prop
d_OP_lt_tilde_tilde_gt x1 x2 x3 x4 cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "<~~>") cd cs

nd_OP_lt_tilde_tilde_gt :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> t0 -> IDSupply -> Cover
  -> ConstStore -> C_Prop
nd_OP_lt_tilde_tilde_gt x1 x2 x3 x4 s cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "<~~>") cd cs

d_OP_eq_eq_gt :: Curry_Prelude.C_Bool -> C_Prop -> Cover -> ConstStore -> C_Prop
d_OP_eq_eq_gt x1 x2 cd cs = d_C_propUndefinedError (Curry_Prelude.toCurryString
  "==>") cd cs

nd_C_solutionOf :: forall t0 . (Curry_Prelude.Curry t0) => Func t0
  Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore -> t0
nd_C_solutionOf x1 s cd cs = let s2 = s
  in s2 `seq` (let s0 = leftSupply s2
                   s1 = rightSupply s2
  in s0 `seq` (s1 `seq` (let x2 = generate s0 cd
  in Curry_Prelude.d_OP_amp_gt (Curry_Prelude.nd_C_apply x1 x2 s1 cd cs) x2 cd
  cs)))

d_C_is :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> (t0 -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool) -> Cover -> ConstStore -> C_Prop
d_C_is x1 x2 x3 cd cs = d_C_propUndefinedError (Curry_Prelude.toCurryString
  "is") cd cs

nd_C_is :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> Func t0
  Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore -> C_Prop
nd_C_is x1 x2 x3 s cd cs = d_C_propUndefinedError (Curry_Prelude.toCurryString
  "is") cd cs

d_C_isAlways :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> Cover -> ConstStore
  -> (t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool) -> Cover -> ConstStore
  -> C_Prop
d_C_isAlways x1 x2 cd cs = d_C_propUndefinedError (Curry_Prelude.toCurryString
  "isAlways") cd cs

nd_C_isAlways :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> IDSupply -> Cover
  -> ConstStore -> Func (Func t0 Curry_Prelude.C_Bool) C_Prop
nd_C_isAlways x1 x2 s cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "isAlways") cd cs

d_C_isEventually :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> Cover -> ConstStore
  -> (t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool) -> Cover -> ConstStore
  -> C_Prop
d_C_isEventually x1 x2 cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "isEventually") cd cs

nd_C_isEventually :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> IDSupply -> Cover
  -> ConstStore -> Func (Func t0 Curry_Prelude.C_Bool) C_Prop
nd_C_isEventually x1 x2 s cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "isEventually") cd cs

d_C_uniquely :: Curry_Prelude.C_Bool -> Cover -> ConstStore -> C_Prop
d_C_uniquely x1 cd cs = d_C_propUndefinedError (Curry_Prelude.toCurryString
  "uniquely") cd cs

d_C_always :: Curry_Prelude.C_Bool -> Cover -> ConstStore -> C_Prop
d_C_always x1 cd cs = d_C_propUndefinedError (Curry_Prelude.toCurryString
  "always") cd cs

d_C_eventually :: Curry_Prelude.C_Bool -> Cover -> ConstStore -> C_Prop
d_C_eventually x1 cd cs = d_C_propUndefinedError (Curry_Prelude.toCurryString
  "eventually") cd cs

d_C_failing :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> Cover -> ConstStore
  -> C_Prop
d_C_failing x1 x2 cd cs = d_C_propUndefinedError (Curry_Prelude.toCurryString
  "failing") cd cs

nd_C_failing :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> IDSupply -> Cover
  -> ConstStore -> C_Prop
nd_C_failing x1 x2 s cd cs = d_C_propUndefinedError (Curry_Prelude.toCurryString
  "failing") cd cs

d_C_successful :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> Cover -> ConstStore
  -> C_Prop
d_C_successful x1 x2 cd cs = d_C_propUndefinedError (Curry_Prelude.toCurryString
  "successful") cd cs

nd_C_successful :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> IDSupply -> Cover
  -> ConstStore -> C_Prop
nd_C_successful x1 x2 s cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "successful") cd cs

d_C_deterministic :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> Cover -> ConstStore
  -> C_Prop
d_C_deterministic x1 x2 cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "deterministic") cd cs

nd_C_deterministic :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> IDSupply -> Cover
  -> ConstStore -> C_Prop
nd_C_deterministic x1 x2 s cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "deterministic") cd cs

d_OP_hash :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> Curry_Prelude.C_Int
  -> Cover -> ConstStore -> C_Prop
d_OP_hash x1 x2 x3 x4 cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "#") cd cs

nd_OP_hash :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> Curry_Prelude.C_Int
  -> IDSupply -> Cover -> ConstStore -> C_Prop
nd_OP_hash x1 x2 x3 x4 s cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "#") cd cs

d_OP_hash_lt :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> Curry_Prelude.C_Int
  -> Cover -> ConstStore -> C_Prop
d_OP_hash_lt x1 x2 x3 x4 cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "#<") cd cs

nd_OP_hash_lt :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> Curry_Prelude.C_Int
  -> IDSupply -> Cover -> ConstStore -> C_Prop
nd_OP_hash_lt x1 x2 x3 x4 s cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "#<") cd cs

d_OP_hash_gt :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> Curry_Prelude.C_Int
  -> Cover -> ConstStore -> C_Prop
d_OP_hash_gt x1 x2 x3 x4 cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "#>") cd cs

nd_OP_hash_gt :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> Curry_Prelude.C_Int
  -> IDSupply -> Cover -> ConstStore -> C_Prop
nd_OP_hash_gt x1 x2 x3 x4 s cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "#>") cd cs

d_C_for :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> (t0 -> Cover
  -> ConstStore -> C_Prop) -> Cover -> ConstStore -> C_Prop
d_C_for x1 x2 x3 cd cs = d_C_propUndefinedError (Curry_Prelude.toCurryString
  "for") cd cs

nd_C_for :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> Func t0 C_Prop
  -> IDSupply -> Cover -> ConstStore -> C_Prop
nd_C_for x1 x2 x3 s cd cs = d_C_propUndefinedError (Curry_Prelude.toCurryString
  "for") cd cs

d_C_forAll :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> Curry_Prelude.OP_List t0
  -> (t0 -> Cover -> ConstStore -> C_Prop) -> Cover -> ConstStore -> C_Prop
d_C_forAll x1 x2 x3 cd cs = d_C_propUndefinedError (Curry_Prelude.toCurryString
  "forAll") cd cs

nd_C_forAll :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> Curry_Prelude.OP_List t0
  -> Func t0 C_Prop -> IDSupply -> Cover -> ConstStore -> C_Prop
nd_C_forAll x1 x2 x3 s cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "forAll") cd cs

d_OP_lt_eq_gt :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> t0 -> Cover
  -> ConstStore -> C_Prop
d_OP_lt_eq_gt x1 x2 cd cs = d_C_propUndefinedError (Curry_Prelude.toCurryString
  "#") cd cs

d_C_label :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> C_Prop -> Cover
  -> ConstStore -> C_Prop
d_C_label x1 x2 cd cs = d_C_propUndefinedError (Curry_Prelude.toCurryString
  "label") cd cs

d_C_classify :: Curry_Prelude.C_Bool -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> C_Prop -> Cover -> ConstStore -> C_Prop
d_C_classify x1 x2 x3 cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "classify") cd cs

d_C_trivial :: Curry_Prelude.C_Bool -> C_Prop -> Cover -> ConstStore -> C_Prop
d_C_trivial x1 x2 cd cs = d_C_propUndefinedError (Curry_Prelude.toCurryString
  "trivial") cd cs

d_C_collect :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> C_Prop -> Cover
  -> ConstStore -> C_Prop
d_C_collect x1 x2 x3 cd cs = d_C_propUndefinedError (Curry_Prelude.toCurryString
  "collect") cd cs

nd_C_collect :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> t0 -> C_Prop -> IDSupply
  -> Cover -> ConstStore -> C_Prop
nd_C_collect x1 x2 x3 s cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "collect") cd cs

d_C_collectAs :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> t0 -> C_Prop -> Cover -> ConstStore -> C_Prop
d_C_collectAs x1 x2 x3 x4 cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "collectAs") cd cs

nd_C_collectAs :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Show t0 -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> t0 -> C_Prop -> IDSupply -> Cover -> ConstStore
  -> C_Prop
nd_C_collectAs x1 x2 x3 x4 s cd cs = d_C_propUndefinedError
  (Curry_Prelude.toCurryString "collectAs") cd cs

d_C_valuesOf :: forall t0 . (Curry_Prelude.Curry t0) => Cover -> ConstStore
  -> t0 -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_C_valuesOf cd cs = Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
  "Test.Prop.valuesOf undefined. Use Test.EasyCheck to actually run it!") cd cs

d_C_propUndefinedError :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore -> t0
d_C_propUndefinedError x1 cd cs = Curry_Prelude.d_OP_dollar
  Curry_Prelude.d_C_error (Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.toCurryString "Test.Prop.") (Curry_Prelude.d_OP_plus_plus x1
  (Curry_Prelude.toCurryString
  " undefined. Use Test.EasyCheck to actually run it!") cd cs) cd cs) cd cs

