{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE Rank2Types #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module AbstractCurry.Curry_Select
  ( d_C_progName
  , d_C_imports
  , d_C_functions
  , d_C_constructors
  , d_C_types
  , d_C_publicFuncNames
  , d_C_publicConsNames
  , d_C_publicTypeNames
  , d_C_typeOfQualType
  , d_C_classConstraintsOfQualType
  , d_C_typeName
  , d_C_typeVis
  , d_C_typeCons
  , d_C_consName
  , d_C_consVis
  , d_C_isBaseType
  , d_C_isPolyType
  , d_C_isFunctionalType
  , d_C_isIOType
  , d_C_isIOReturnType
  , d_C_argTypes
  , d_C_resultType
  , d_C_tvarsOfType
  , d_C_tconsOfType
  , d_C_modsOfType
  , d_C_tconsArgsOfType
  , d_C_funcName
  , d_C_funcArity
  , d_C_funcComment
  , d_C_funcVis
  , d_C_funcType
  , d_C_funcRules
  , d_C_ruleRHS
  , d_C_ldeclsOfRule
  , d_C_varsOfPat
  , d_C_varsOfExp
  , d_C_varsOfRhs
  , d_C_varsOfStat
  , d_C_varsOfLDecl
  , d_C_varsOfFDecl
  , d_C_varsOfRule
  , d_C_funcNamesOfLDecl
  , d_C_funcNamesOfFDecl
  , d_C_funcNamesOfStat
  , d_C_isPrelude )
  where

import Basics
import qualified AbstractCurry.Curry_Types
import qualified Curry_List
import qualified Curry_Prelude


d_C_progName :: AbstractCurry.Curry_Types.C_CurryProg -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_progName x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CurryProg x2 x3 x4 x5 x6 x7 x8 x9 -> x2
  AbstractCurry.Curry_Types.Choice_C_CurryProg d i l r -> narrow d i
    (d_C_progName l cd cs) (d_C_progName r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CurryProg d i xs -> narrows cs d i (\z ->
    d_C_progName z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CurryProg d c e -> guardCons d c
    (d_C_progName e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CurryProg d info -> failCons d (traceFail
    "AbstractCurry.Select.progName" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.progName" (showCons x1))

d_C_imports :: AbstractCurry.Curry_Types.C_CurryProg -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_imports x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CurryProg x2 x3 x4 x5 x6 x7 x8 x9 -> x3
  AbstractCurry.Curry_Types.Choice_C_CurryProg d i l r -> narrow d i
    (d_C_imports l cd cs) (d_C_imports r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CurryProg d i xs -> narrows cs d i (\z ->
    d_C_imports z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CurryProg d c e -> guardCons d c
    (d_C_imports e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CurryProg d info -> failCons d (traceFail
    "AbstractCurry.Select.imports" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.imports" (showCons x1))

d_C_functions :: AbstractCurry.Curry_Types.C_CurryProg -> Cover -> ConstStore
  -> Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CFuncDecl
d_C_functions x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CurryProg x2 x3 x4 x5 x6 x7 x8 x9 -> x8
  AbstractCurry.Curry_Types.Choice_C_CurryProg d i l r -> narrow d i
    (d_C_functions l cd cs) (d_C_functions r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CurryProg d i xs -> narrows cs d i (\z ->
    d_C_functions z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CurryProg d c e -> guardCons d c
    (d_C_functions e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CurryProg d info -> failCons d (traceFail
    "AbstractCurry.Select.functions" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.functions" (showCons x1))

d_C_constructors :: Cover -> ConstStore -> AbstractCurry.Curry_Types.C_CurryProg
  -> Cover -> ConstStore -> Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CConsDecl
d_C_constructors cd cs = Curry_Prelude.d_OP_dot (Curry_Prelude.d_C_concatMap
  d_C_typeCons cd cs) d_C_types cd cs

d_C_types :: AbstractCurry.Curry_Types.C_CurryProg -> Cover -> ConstStore
  -> Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CTypeDecl
d_C_types x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CurryProg x2 x3 x4 x5 x6 x7 x8 x9 -> x7
  AbstractCurry.Curry_Types.Choice_C_CurryProg d i l r -> narrow d i (d_C_types
    l cd cs) (d_C_types r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CurryProg d i xs -> narrows cs d i (\z ->
    d_C_types z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CurryProg d c e -> guardCons d c (d_C_types
    e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CurryProg d info -> failCons d (traceFail
    "AbstractCurry.Select.types" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.types" (showCons x1))

d_C_publicFuncNames :: Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CurryProg -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_publicFuncNames cd cs = Curry_Prelude.d_OP_dot (Curry_Prelude.d_C_map
  d_C_funcName) (Curry_Prelude.d_OP_dot (Curry_Prelude.d_C_filter
  (Curry_Prelude.d_OP_dot (Curry_Prelude.d_C_flip (acceptCs id
  AbstractCurry.Curry_Types.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_AbstractCurry_dot_Types_dot_CVisibility)
  AbstractCurry.Curry_Types.C_Public) d_C_funcVis cd cs)) d_C_functions cd cs)
  cd cs

d_C_publicConsNames :: Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CurryProg -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_publicConsNames cd cs = Curry_Prelude.d_OP_dot (Curry_Prelude.d_C_map
  d_C_consName) (Curry_Prelude.d_OP_dot (Curry_Prelude.d_C_filter
  (Curry_Prelude.d_OP_dot (Curry_Prelude.d_C_flip (acceptCs id
  AbstractCurry.Curry_Types.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_AbstractCurry_dot_Types_dot_CVisibility)
  AbstractCurry.Curry_Types.C_Public) d_C_consVis cd cs)) (d_C_constructors cd
  cs) cd cs) cd cs

d_C_publicTypeNames :: Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CurryProg -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_publicTypeNames cd cs = Curry_Prelude.d_OP_dot (Curry_Prelude.d_C_map
  d_C_typeName) (Curry_Prelude.d_OP_dot (Curry_Prelude.d_C_filter
  (Curry_Prelude.d_OP_dot (Curry_Prelude.d_C_flip (acceptCs id
  AbstractCurry.Curry_Types.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_AbstractCurry_dot_Types_dot_CVisibility)
  AbstractCurry.Curry_Types.C_Public) d_C_typeVis cd cs)) d_C_types cd cs) cd cs

d_C_typeOfQualType :: AbstractCurry.Curry_Types.C_CQualTypeExpr -> Cover
  -> ConstStore -> AbstractCurry.Curry_Types.C_CTypeExpr
d_C_typeOfQualType x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CQualType x2 x3 -> x3
  AbstractCurry.Curry_Types.Choice_C_CQualTypeExpr d i l r -> narrow d i
    (d_C_typeOfQualType l cd cs) (d_C_typeOfQualType r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CQualTypeExpr d i xs -> narrows cs d i
    (\z -> d_C_typeOfQualType z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CQualTypeExpr d c e -> guardCons d c
    (d_C_typeOfQualType e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CQualTypeExpr d info -> failCons d (traceFail
    "AbstractCurry.Select.typeOfQualType" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.typeOfQualType" (showCons
    x1))

d_C_classConstraintsOfQualType :: AbstractCurry.Curry_Types.C_CQualTypeExpr
  -> Cover -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  AbstractCurry.Curry_Types.C_CTypeExpr)
d_C_classConstraintsOfQualType x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CQualType x2 x3 -> d_C__case_8 x2 cd cs
  AbstractCurry.Curry_Types.Choice_C_CQualTypeExpr d i l r -> narrow d i
    (d_C_classConstraintsOfQualType l cd cs) (d_C_classConstraintsOfQualType r
    cd cs)
  AbstractCurry.Curry_Types.Choices_C_CQualTypeExpr d i xs -> narrows cs d i
    (\z -> d_C_classConstraintsOfQualType z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CQualTypeExpr d c e -> guardCons d c
    (d_C_classConstraintsOfQualType e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CQualTypeExpr d info -> failCons d (traceFail
    "AbstractCurry.Select.classConstraintsOfQualType" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.classConstraintsOfQualType"
    (showCons x1))

d_C_typeName :: AbstractCurry.Curry_Types.C_CTypeDecl -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_typeName x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CType x2 x3 x4 x5 x6 -> x2
  AbstractCurry.Curry_Types.C_CTypeSyn x7 x8 x9 x10 -> x7
  AbstractCurry.Curry_Types.C_CNewType x11 x12 x13 x14 x15 -> x11
  AbstractCurry.Curry_Types.Choice_C_CTypeDecl d i l r -> narrow d i
    (d_C_typeName l cd cs) (d_C_typeName r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CTypeDecl d i xs -> narrows cs d i (\z ->
    d_C_typeName z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CTypeDecl d c e -> guardCons d c
    (d_C_typeName e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CTypeDecl d info -> failCons d (traceFail
    "AbstractCurry.Select.typeName" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.typeName" (showCons x1))

d_C_typeVis :: AbstractCurry.Curry_Types.C_CTypeDecl -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CVisibility
d_C_typeVis x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CType x2 x3 x4 x5 x6 -> x3
  AbstractCurry.Curry_Types.C_CTypeSyn x7 x8 x9 x10 -> x8
  AbstractCurry.Curry_Types.C_CNewType x11 x12 x13 x14 x15 -> x12
  AbstractCurry.Curry_Types.Choice_C_CTypeDecl d i l r -> narrow d i
    (d_C_typeVis l cd cs) (d_C_typeVis r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CTypeDecl d i xs -> narrows cs d i (\z ->
    d_C_typeVis z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CTypeDecl d c e -> guardCons d c
    (d_C_typeVis e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CTypeDecl d info -> failCons d (traceFail
    "AbstractCurry.Select.typeVis" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.typeVis" (showCons x1))

d_C_typeCons :: AbstractCurry.Curry_Types.C_CTypeDecl -> Cover -> ConstStore
  -> Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CConsDecl
d_C_typeCons x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CType x2 x3 x4 x5 x6 -> x5
  AbstractCurry.Curry_Types.C_CTypeSyn x7 x8 x9 x10 -> Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CNewType x11 x12 x13 x14 x15 -> Curry_Prelude.OP_Cons
    x14 Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.Choice_C_CTypeDecl d i l r -> narrow d i
    (d_C_typeCons l cd cs) (d_C_typeCons r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CTypeDecl d i xs -> narrows cs d i (\z ->
    d_C_typeCons z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CTypeDecl d c e -> guardCons d c
    (d_C_typeCons e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CTypeDecl d info -> failCons d (traceFail
    "AbstractCurry.Select.typeCons" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.typeCons" (showCons x1))

d_C_consName :: AbstractCurry.Curry_Types.C_CConsDecl -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_consName x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CCons x2 x3 x4 x5 x6 -> x4
  AbstractCurry.Curry_Types.C_CRecord x7 x8 x9 x10 x11 -> x9
  AbstractCurry.Curry_Types.Choice_C_CConsDecl d i l r -> narrow d i
    (d_C_consName l cd cs) (d_C_consName r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CConsDecl d i xs -> narrows cs d i (\z ->
    d_C_consName z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CConsDecl d c e -> guardCons d c
    (d_C_consName e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CConsDecl d info -> failCons d (traceFail
    "AbstractCurry.Select.consName" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.consName" (showCons x1))

d_C_consVis :: AbstractCurry.Curry_Types.C_CConsDecl -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CVisibility
d_C_consVis x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CCons x2 x3 x4 x5 x6 -> x5
  AbstractCurry.Curry_Types.C_CRecord x7 x8 x9 x10 x11 -> x10
  AbstractCurry.Curry_Types.Choice_C_CConsDecl d i l r -> narrow d i
    (d_C_consVis l cd cs) (d_C_consVis r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CConsDecl d i xs -> narrows cs d i (\z ->
    d_C_consVis z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CConsDecl d c e -> guardCons d c
    (d_C_consVis e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CConsDecl d info -> failCons d (traceFail
    "AbstractCurry.Select.consVis" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.consVis" (showCons x1))

d_C_isBaseType :: AbstractCurry.Curry_Types.C_CTypeExpr -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isBaseType x1 cd cs = let x2 = Curry_Prelude.C_False
  in d_C__case_7 x2 x1 cd cs

d_C_isPolyType :: AbstractCurry.Curry_Types.C_CTypeExpr -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isPolyType x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CTVar x2 -> Curry_Prelude.C_True
  AbstractCurry.Curry_Types.C_CFuncType x3 x4 -> Curry_Prelude.d_OP_bar_bar
    (d_C_isPolyType x3 cd cs) (d_C_isPolyType x4 cd cs) cd cs
  AbstractCurry.Curry_Types.C_CTCons x5 -> Curry_Prelude.C_False
  AbstractCurry.Curry_Types.C_CTApply x6 x7 -> Curry_Prelude.d_OP_bar_bar
    (d_C_isPolyType x6 cd cs) (d_C_isPolyType x7 cd cs) cd cs
  AbstractCurry.Curry_Types.Choice_C_CTypeExpr d i l r -> narrow d i
    (d_C_isPolyType l cd cs) (d_C_isPolyType r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CTypeExpr d i xs -> narrows cs d i (\z ->
    d_C_isPolyType z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CTypeExpr d c e -> guardCons d c
    (d_C_isPolyType e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CTypeExpr d info -> failCons d (traceFail
    "AbstractCurry.Select.isPolyType" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.isPolyType" (showCons x1))

d_C_isFunctionalType :: AbstractCurry.Curry_Types.C_CTypeExpr -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_C_isFunctionalType x1 cd cs = let x2 = Curry_Prelude.C_False
  in d_C__case_6 x2 x1 cd cs

d_C_isIOType :: AbstractCurry.Curry_Types.C_CTypeExpr -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isIOType x1 cd cs = let x2 = Curry_Prelude.C_False
  in d_C__case_5 x2 x1 cd cs

d_C_isIOReturnType :: AbstractCurry.Curry_Types.C_CTypeExpr -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_C_isIOReturnType x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CTVar x2 -> Curry_Prelude.C_False
  AbstractCurry.Curry_Types.C_CFuncType x3 x4 -> Curry_Prelude.C_False
  AbstractCurry.Curry_Types.C_CTCons x5 -> Curry_Prelude.C_False
  AbstractCurry.Curry_Types.C_CTApply x6 x7 -> Curry_Prelude.d_OP_amp_amp
    (AbstractCurry.Curry_Types.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_AbstractCurry_dot_Types_dot_CTypeExpr
    x6 (AbstractCurry.Curry_Types.C_CTCons (AbstractCurry.Curry_Types.d_C_pre
    (Curry_Prelude.toCurryString "IO") cd cs)) cd cs)
    (Curry_Prelude.d_OP_amp_amp (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply
    (AbstractCurry.Curry_Types.d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_AbstractCurry_dot_Types_dot_CTypeExpr
    cd cs) x7 cd cs) (AbstractCurry.Curry_Types.C_CTCons
    (AbstractCurry.Curry_Types.d_C_pre (Curry_Prelude.toCurryString "()") cd
    cs)) cd cs) (Curry_Prelude.d_C_not (d_C_isFunctionalType x7 cd cs) cd cs) cd
    cs) cd cs
  AbstractCurry.Curry_Types.Choice_C_CTypeExpr d i l r -> narrow d i
    (d_C_isIOReturnType l cd cs) (d_C_isIOReturnType r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CTypeExpr d i xs -> narrows cs d i (\z ->
    d_C_isIOReturnType z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CTypeExpr d c e -> guardCons d c
    (d_C_isIOReturnType e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CTypeExpr d info -> failCons d (traceFail
    "AbstractCurry.Select.isIOReturnType" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.isIOReturnType" (showCons
    x1))

d_C_argTypes :: AbstractCurry.Curry_Types.C_CTypeExpr -> Cover -> ConstStore
  -> Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CTypeExpr
d_C_argTypes x1 cd cs = let x2 = Curry_Prelude.OP_List
  in d_C__case_3 x2 x1 cd cs

d_C_resultType :: AbstractCurry.Curry_Types.C_CTypeExpr -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CTypeExpr
d_C_resultType x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CFuncType x2 x3 -> d_C_resultType x3 cd cs
  AbstractCurry.Curry_Types.C_CTVar x4 -> x1
  AbstractCurry.Curry_Types.C_CTCons x5 -> x1
  AbstractCurry.Curry_Types.C_CTApply x6 x7 -> x1
  AbstractCurry.Curry_Types.Choice_C_CTypeExpr d i l r -> narrow d i
    (d_C_resultType l cd cs) (d_C_resultType r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CTypeExpr d i xs -> narrows cs d i (\z ->
    d_C_resultType z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CTypeExpr d c e -> guardCons d c
    (d_C_resultType e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CTypeExpr d info -> failCons d (traceFail
    "AbstractCurry.Select.resultType" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.resultType" (showCons x1))

d_C_tvarsOfType :: AbstractCurry.Curry_Types.C_CTypeExpr -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_tvarsOfType x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CTVar x2 -> Curry_Prelude.OP_Cons x2
    Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CFuncType x3 x4 -> Curry_Prelude.d_OP_plus_plus
    (d_C_tvarsOfType x3 cd cs) (d_C_tvarsOfType x4 cd cs) cd cs
  AbstractCurry.Curry_Types.C_CTCons x5 -> Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CTApply x6 x7 -> Curry_Prelude.d_OP_plus_plus
    (d_C_tvarsOfType x6 cd cs) (d_C_tvarsOfType x7 cd cs) cd cs
  AbstractCurry.Curry_Types.Choice_C_CTypeExpr d i l r -> narrow d i
    (d_C_tvarsOfType l cd cs) (d_C_tvarsOfType r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CTypeExpr d i xs -> narrows cs d i (\z ->
    d_C_tvarsOfType z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CTypeExpr d c e -> guardCons d c
    (d_C_tvarsOfType e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CTypeExpr d info -> failCons d (traceFail
    "AbstractCurry.Select.tvarsOfType" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.tvarsOfType" (showCons x1))

d_C_tconsOfType :: AbstractCurry.Curry_Types.C_CTypeExpr -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_tconsOfType x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CTVar x2 -> Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CFuncType x3 x4 -> Curry_List.d_C_union
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) cd cs) (d_C_tconsOfType x3 cd cs) (d_C_tconsOfType x4 cd cs) cd
    cs
  AbstractCurry.Curry_Types.C_CTCons x5 -> Curry_Prelude.OP_Cons x5
    Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CTApply x6 x7 -> Curry_List.d_C_union
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) cd cs) (d_C_tconsOfType x6 cd cs) (d_C_tconsOfType x7 cd cs) cd
    cs
  AbstractCurry.Curry_Types.Choice_C_CTypeExpr d i l r -> narrow d i
    (d_C_tconsOfType l cd cs) (d_C_tconsOfType r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CTypeExpr d i xs -> narrows cs d i (\z ->
    d_C_tconsOfType z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CTypeExpr d c e -> guardCons d c
    (d_C_tconsOfType e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CTypeExpr d info -> failCons d (traceFail
    "AbstractCurry.Select.tconsOfType" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.tconsOfType" (showCons x1))

d_C_modsOfType :: Cover -> ConstStore -> AbstractCurry.Curry_Types.C_CTypeExpr
  -> Cover -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_modsOfType cd cs = Curry_Prelude.d_OP_dot (Curry_Prelude.d_C_map
  Curry_Prelude.d_C_fst) d_C_tconsOfType cd cs

d_C_tconsArgsOfType :: AbstractCurry.Curry_Types.C_CTypeExpr -> Cover
  -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CTypeExpr))
d_C_tconsArgsOfType x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CTVar x2 -> Curry_Prelude.C_Nothing
  AbstractCurry.Curry_Types.C_CFuncType x3 x4 -> Curry_Prelude.C_Nothing
  AbstractCurry.Curry_Types.C_CTCons x5 -> Curry_Prelude.C_Just
    (Curry_Prelude.OP_Tuple2 x5 Curry_Prelude.OP_List)
  AbstractCurry.Curry_Types.C_CTApply x6 x7 -> Curry_Prelude.d_C_maybe
    Curry_Prelude.C_Nothing (d_OP_tconsArgsOfType_dot_uscore_hash_lambda6 x7)
    (d_C_tconsArgsOfType x6 cd cs) cd cs
  AbstractCurry.Curry_Types.Choice_C_CTypeExpr d i l r -> narrow d i
    (d_C_tconsArgsOfType l cd cs) (d_C_tconsArgsOfType r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CTypeExpr d i xs -> narrows cs d i (\z ->
    d_C_tconsArgsOfType z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CTypeExpr d c e -> guardCons d c
    (d_C_tconsArgsOfType e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CTypeExpr d info -> failCons d (traceFail
    "AbstractCurry.Select.tconsArgsOfType" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.tconsArgsOfType" (showCons
    x1))

d_OP_tconsArgsOfType_dot_uscore_hash_lambda6 :: AbstractCurry.Curry_Types.C_CTypeExpr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CTypeExpr) -> Cover
  -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CTypeExpr))
d_OP_tconsArgsOfType_dot_uscore_hash_lambda6 x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> Curry_Prelude.C_Just (Curry_Prelude.OP_Tuple2
    x3 (Curry_Prelude.d_OP_plus_plus x4 (Curry_Prelude.OP_Cons x1
    Curry_Prelude.OP_List) cd cs))
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_tconsArgsOfType_dot_uscore_hash_lambda6 x1 l cd cs)
    (d_OP_tconsArgsOfType_dot_uscore_hash_lambda6 x1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_tconsArgsOfType_dot_uscore_hash_lambda6 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_tconsArgsOfType_dot_uscore_hash_lambda6 x1 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractCurry.Select.tconsArgsOfType._#lambda6" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.tconsArgsOfType._#lambda6"
    (showCons x2))

d_C_funcName :: AbstractCurry.Curry_Types.C_CFuncDecl -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_funcName x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CFunc x2 x3 x4 x5 x6 -> x2
  AbstractCurry.Curry_Types.C_CmtFunc x7 x8 x9 x10 x11 x12 -> x8
  AbstractCurry.Curry_Types.Choice_C_CFuncDecl d i l r -> narrow d i
    (d_C_funcName l cd cs) (d_C_funcName r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CFuncDecl d i xs -> narrows cs d i (\z ->
    d_C_funcName z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CFuncDecl d c e -> guardCons d c
    (d_C_funcName e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CFuncDecl d info -> failCons d (traceFail
    "AbstractCurry.Select.funcName" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.funcName" (showCons x1))

d_C_funcArity :: AbstractCurry.Curry_Types.C_CFuncDecl -> Cover -> ConstStore
  -> Curry_Prelude.C_Int
d_C_funcArity x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CFunc x2 x3 x4 x5 x6 -> x3
  AbstractCurry.Curry_Types.C_CmtFunc x7 x8 x9 x10 x11 x12 -> x9
  AbstractCurry.Curry_Types.Choice_C_CFuncDecl d i l r -> narrow d i
    (d_C_funcArity l cd cs) (d_C_funcArity r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CFuncDecl d i xs -> narrows cs d i (\z ->
    d_C_funcArity z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CFuncDecl d c e -> guardCons d c
    (d_C_funcArity e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CFuncDecl d info -> failCons d (traceFail
    "AbstractCurry.Select.funcArity" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.funcArity" (showCons x1))

d_C_funcComment :: AbstractCurry.Curry_Types.C_CFuncDecl -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_funcComment x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CFunc x2 x3 x4 x5 x6 -> Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CmtFunc x7 x8 x9 x10 x11 x12 -> x7
  AbstractCurry.Curry_Types.Choice_C_CFuncDecl d i l r -> narrow d i
    (d_C_funcComment l cd cs) (d_C_funcComment r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CFuncDecl d i xs -> narrows cs d i (\z ->
    d_C_funcComment z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CFuncDecl d c e -> guardCons d c
    (d_C_funcComment e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CFuncDecl d info -> failCons d (traceFail
    "AbstractCurry.Select.funcComment" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.funcComment" (showCons x1))

d_C_funcVis :: AbstractCurry.Curry_Types.C_CFuncDecl -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CVisibility
d_C_funcVis x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CFunc x2 x3 x4 x5 x6 -> x4
  AbstractCurry.Curry_Types.C_CmtFunc x7 x8 x9 x10 x11 x12 -> x10
  AbstractCurry.Curry_Types.Choice_C_CFuncDecl d i l r -> narrow d i
    (d_C_funcVis l cd cs) (d_C_funcVis r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CFuncDecl d i xs -> narrows cs d i (\z ->
    d_C_funcVis z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CFuncDecl d c e -> guardCons d c
    (d_C_funcVis e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CFuncDecl d info -> failCons d (traceFail
    "AbstractCurry.Select.funcVis" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.funcVis" (showCons x1))

d_C_funcType :: AbstractCurry.Curry_Types.C_CFuncDecl -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CQualTypeExpr
d_C_funcType x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CFunc x2 x3 x4 x5 x6 -> x5
  AbstractCurry.Curry_Types.C_CmtFunc x7 x8 x9 x10 x11 x12 -> x11
  AbstractCurry.Curry_Types.Choice_C_CFuncDecl d i l r -> narrow d i
    (d_C_funcType l cd cs) (d_C_funcType r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CFuncDecl d i xs -> narrows cs d i (\z ->
    d_C_funcType z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CFuncDecl d c e -> guardCons d c
    (d_C_funcType e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CFuncDecl d info -> failCons d (traceFail
    "AbstractCurry.Select.funcType" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.funcType" (showCons x1))

d_C_funcRules :: AbstractCurry.Curry_Types.C_CFuncDecl -> Cover -> ConstStore
  -> Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CRule
d_C_funcRules x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CFunc x2 x3 x4 x5 x6 -> x6
  AbstractCurry.Curry_Types.C_CmtFunc x7 x8 x9 x10 x11 x12 -> x12
  AbstractCurry.Curry_Types.Choice_C_CFuncDecl d i l r -> narrow d i
    (d_C_funcRules l cd cs) (d_C_funcRules r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CFuncDecl d i xs -> narrows cs d i (\z ->
    d_C_funcRules z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CFuncDecl d c e -> guardCons d c
    (d_C_funcRules e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CFuncDecl d info -> failCons d (traceFail
    "AbstractCurry.Select.funcRules" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.funcRules" (showCons x1))

d_C_ruleRHS :: AbstractCurry.Curry_Types.C_CRule -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CRhs
d_C_ruleRHS x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CRule x2 x3 -> x3
  AbstractCurry.Curry_Types.Choice_C_CRule d i l r -> narrow d i (d_C_ruleRHS l
    cd cs) (d_C_ruleRHS r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CRule d i xs -> narrows cs d i (\z ->
    d_C_ruleRHS z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CRule d c e -> guardCons d c (d_C_ruleRHS e
    cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CRule d info -> failCons d (traceFail
    "AbstractCurry.Select.ruleRHS" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.ruleRHS" (showCons x1))

d_C_ldeclsOfRule :: AbstractCurry.Curry_Types.C_CRule -> Cover -> ConstStore
  -> Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CLocalDecl
d_C_ldeclsOfRule x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CRule x2 x3 -> d_C__case_2 x3 cd cs
  AbstractCurry.Curry_Types.Choice_C_CRule d i l r -> narrow d i
    (d_C_ldeclsOfRule l cd cs) (d_C_ldeclsOfRule r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CRule d i xs -> narrows cs d i (\z ->
    d_C_ldeclsOfRule z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CRule d c e -> guardCons d c
    (d_C_ldeclsOfRule e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CRule d info -> failCons d (traceFail
    "AbstractCurry.Select.ldeclsOfRule" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.ldeclsOfRule" (showCons x1))

d_C_varsOfPat :: AbstractCurry.Curry_Types.C_CPattern -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_varsOfPat x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CPVar x2 -> Curry_Prelude.OP_Cons x2
    Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CPLit x3 -> Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CPComb x4 x5 -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_concatMap d_C_varsOfPat cd cs) x5 cd cs
  AbstractCurry.Curry_Types.C_CPAs x6 x7 -> Curry_Prelude.OP_Cons x6
    (d_C_varsOfPat x7 cd cs)
  AbstractCurry.Curry_Types.C_CPFuncComb x8 x9 -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_concatMap d_C_varsOfPat cd cs) x9 cd cs
  AbstractCurry.Curry_Types.C_CPLazy x10 -> d_C_varsOfPat x10 cd cs
  AbstractCurry.Curry_Types.C_CPRecord x11 x12 -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_concatMap (Curry_Prelude.d_OP_dot d_C_varsOfPat
    Curry_Prelude.d_C_snd cd cs) cd cs) x12 cd cs
  AbstractCurry.Curry_Types.Choice_C_CPattern d i l r -> narrow d i
    (d_C_varsOfPat l cd cs) (d_C_varsOfPat r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CPattern d i xs -> narrows cs d i (\z ->
    d_C_varsOfPat z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CPattern d c e -> guardCons d c
    (d_C_varsOfPat e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CPattern d info -> failCons d (traceFail
    "AbstractCurry.Select.varsOfPat" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.varsOfPat" (showCons x1))

d_C_varsOfExp :: AbstractCurry.Curry_Types.C_CExpr -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_varsOfExp x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CVar x2 -> Curry_Prelude.OP_Cons x2
    Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CLit x3 -> Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CSymbol x4 -> Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CApply x5 x6 -> Curry_Prelude.d_OP_plus_plus
    (d_C_varsOfExp x5 cd cs) (d_C_varsOfExp x6 cd cs) cd cs
  AbstractCurry.Curry_Types.C_CLambda x7 x8 -> Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_concatMap d_C_varsOfPat cd cs)
    x7 cd cs) (d_C_varsOfExp x8 cd cs) cd cs
  AbstractCurry.Curry_Types.C_CLetDecl x9 x10 -> Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_concatMap d_C_varsOfLDecl cd cs)
    x9 cd cs) (d_C_varsOfExp x10 cd cs) cd cs
  AbstractCurry.Curry_Types.C_CDoExpr x11 -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_concatMap d_C_varsOfStat cd cs) x11 cd cs
  AbstractCurry.Curry_Types.C_CListComp x12 x13 -> Curry_Prelude.d_OP_plus_plus
    (d_C_varsOfExp x12 cd cs) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_concatMap d_C_varsOfStat cd cs) x13 cd cs) cd cs
  AbstractCurry.Curry_Types.C_CCase x14 x15 x16 -> Curry_Prelude.d_OP_plus_plus
    (d_C_varsOfExp x15 cd cs) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_concatMap d_OP_varsOfExp_dot_uscore_hash_lambda7 cd cs)
    x16 cd cs) cd cs
  AbstractCurry.Curry_Types.C_CTyped x17 x18 -> d_C_varsOfExp x17 cd cs
  AbstractCurry.Curry_Types.C_CRecConstr x19 x20 -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_concatMap (Curry_Prelude.d_OP_dot d_C_varsOfExp
    Curry_Prelude.d_C_snd cd cs) cd cs) x20 cd cs
  AbstractCurry.Curry_Types.C_CRecUpdate x21 x22 -> Curry_Prelude.d_OP_plus_plus
    (d_C_varsOfExp x21 cd cs) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_concatMap (Curry_Prelude.d_OP_dot d_C_varsOfExp
    Curry_Prelude.d_C_snd cd cs) cd cs) x22 cd cs) cd cs
  AbstractCurry.Curry_Types.Choice_C_CExpr d i l r -> narrow d i (d_C_varsOfExp
    l cd cs) (d_C_varsOfExp r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CExpr d i xs -> narrows cs d i (\z ->
    d_C_varsOfExp z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CExpr d c e -> guardCons d c (d_C_varsOfExp
    e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CExpr d info -> failCons d (traceFail
    "AbstractCurry.Select.varsOfExp" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.varsOfExp" (showCons x1))

d_OP_varsOfExp_dot_uscore_hash_lambda7 :: Curry_Prelude.OP_Tuple2
  AbstractCurry.Curry_Types.C_CPattern AbstractCurry.Curry_Types.C_CRhs -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_varsOfExp_dot_uscore_hash_lambda7 x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> Curry_Prelude.d_OP_plus_plus (d_C_varsOfPat
    x2 cd cs) (d_C_varsOfRhs x3 cd cs) cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_varsOfExp_dot_uscore_hash_lambda7 l cd cs)
    (d_OP_varsOfExp_dot_uscore_hash_lambda7 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_varsOfExp_dot_uscore_hash_lambda7 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_varsOfExp_dot_uscore_hash_lambda7 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractCurry.Select.varsOfExp._#lambda7" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.varsOfExp._#lambda7"
    (showCons x1))

d_C_varsOfRhs :: AbstractCurry.Curry_Types.C_CRhs -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_varsOfRhs x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CSimpleRhs x2 x3 -> Curry_Prelude.d_OP_plus_plus
    (d_C_varsOfExp x2 cd cs) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_concatMap d_C_varsOfLDecl cd cs) x3 cd cs) cd cs
  AbstractCurry.Curry_Types.C_CGuardedRhs x4 x5 -> Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_concatMap
    d_OP_varsOfRhs_dot_uscore_hash_lambda8 cd cs) x4 cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_concatMap d_C_varsOfLDecl cd cs)
    x5 cd cs) cd cs
  AbstractCurry.Curry_Types.Choice_C_CRhs d i l r -> narrow d i (d_C_varsOfRhs l
    cd cs) (d_C_varsOfRhs r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CRhs d i xs -> narrows cs d i (\z ->
    d_C_varsOfRhs z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CRhs d c e -> guardCons d c (d_C_varsOfRhs e
    cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CRhs d info -> failCons d (traceFail
    "AbstractCurry.Select.varsOfRhs" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.varsOfRhs" (showCons x1))

d_OP_varsOfRhs_dot_uscore_hash_lambda8 :: Curry_Prelude.OP_Tuple2
  AbstractCurry.Curry_Types.C_CExpr AbstractCurry.Curry_Types.C_CExpr -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_varsOfRhs_dot_uscore_hash_lambda8 x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> Curry_Prelude.d_OP_plus_plus (d_C_varsOfExp
    x2 cd cs) (d_C_varsOfExp x3 cd cs) cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_varsOfRhs_dot_uscore_hash_lambda8 l cd cs)
    (d_OP_varsOfRhs_dot_uscore_hash_lambda8 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_varsOfRhs_dot_uscore_hash_lambda8 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_varsOfRhs_dot_uscore_hash_lambda8 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractCurry.Select.varsOfRhs._#lambda8" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.varsOfRhs._#lambda8"
    (showCons x1))

d_C_varsOfStat :: AbstractCurry.Curry_Types.C_CStatement -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_varsOfStat x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CSExpr x2 -> d_C_varsOfExp x2 cd cs
  AbstractCurry.Curry_Types.C_CSPat x3 x4 -> Curry_Prelude.d_OP_plus_plus
    (d_C_varsOfPat x3 cd cs) (d_C_varsOfExp x4 cd cs) cd cs
  AbstractCurry.Curry_Types.C_CSLet x5 -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_concatMap d_C_varsOfLDecl cd cs) x5 cd cs
  AbstractCurry.Curry_Types.Choice_C_CStatement d i l r -> narrow d i
    (d_C_varsOfStat l cd cs) (d_C_varsOfStat r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CStatement d i xs -> narrows cs d i (\z ->
    d_C_varsOfStat z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CStatement d c e -> guardCons d c
    (d_C_varsOfStat e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CStatement d info -> failCons d (traceFail
    "AbstractCurry.Select.varsOfStat" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.varsOfStat" (showCons x1))

d_C_varsOfLDecl :: AbstractCurry.Curry_Types.C_CLocalDecl -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_varsOfLDecl x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CLocalFunc x2 -> d_C_varsOfFDecl x2 cd cs
  AbstractCurry.Curry_Types.C_CLocalPat x3 x4 -> Curry_Prelude.d_OP_plus_plus
    (d_C_varsOfPat x3 cd cs) (d_C_varsOfRhs x4 cd cs) cd cs
  AbstractCurry.Curry_Types.C_CLocalVars x5 -> x5
  AbstractCurry.Curry_Types.Choice_C_CLocalDecl d i l r -> narrow d i
    (d_C_varsOfLDecl l cd cs) (d_C_varsOfLDecl r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CLocalDecl d i xs -> narrows cs d i (\z ->
    d_C_varsOfLDecl z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CLocalDecl d c e -> guardCons d c
    (d_C_varsOfLDecl e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CLocalDecl d info -> failCons d (traceFail
    "AbstractCurry.Select.varsOfLDecl" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.varsOfLDecl" (showCons x1))

d_C_varsOfFDecl :: AbstractCurry.Curry_Types.C_CFuncDecl -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_varsOfFDecl x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CFunc x2 x3 x4 x5 x6 -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_concatMap d_C_varsOfRule cd cs) x6 cd cs
  AbstractCurry.Curry_Types.C_CmtFunc x7 x8 x9 x10 x11 x12 -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_concatMap d_C_varsOfRule cd cs) x12 cd cs
  AbstractCurry.Curry_Types.Choice_C_CFuncDecl d i l r -> narrow d i
    (d_C_varsOfFDecl l cd cs) (d_C_varsOfFDecl r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CFuncDecl d i xs -> narrows cs d i (\z ->
    d_C_varsOfFDecl z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CFuncDecl d c e -> guardCons d c
    (d_C_varsOfFDecl e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CFuncDecl d info -> failCons d (traceFail
    "AbstractCurry.Select.varsOfFDecl" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.varsOfFDecl" (showCons x1))

d_C_varsOfRule :: AbstractCurry.Curry_Types.C_CRule -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_varsOfRule x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CRule x2 x3 -> Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_concatMap d_C_varsOfPat cd cs)
    x2 cd cs) (d_C_varsOfRhs x3 cd cs) cd cs
  AbstractCurry.Curry_Types.Choice_C_CRule d i l r -> narrow d i (d_C_varsOfRule
    l cd cs) (d_C_varsOfRule r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CRule d i xs -> narrows cs d i (\z ->
    d_C_varsOfRule z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CRule d c e -> guardCons d c (d_C_varsOfRule
    e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CRule d info -> failCons d (traceFail
    "AbstractCurry.Select.varsOfRule" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.varsOfRule" (showCons x1))

d_C_funcNamesOfLDecl :: AbstractCurry.Curry_Types.C_CLocalDecl -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C_funcNamesOfLDecl x1 cd cs = let x2 = Curry_Prelude.OP_List
  in d_C__case_1 x2 x1 cd cs

d_C_funcNamesOfFDecl :: AbstractCurry.Curry_Types.C_CFuncDecl -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C_funcNamesOfFDecl x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CFunc x2 x3 x4 x5 x6 -> Curry_Prelude.OP_Cons x2
    Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CmtFunc x7 x8 x9 x10 x11 x12 -> Curry_Prelude.OP_Cons
    x8 Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.Choice_C_CFuncDecl d i l r -> narrow d i
    (d_C_funcNamesOfFDecl l cd cs) (d_C_funcNamesOfFDecl r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CFuncDecl d i xs -> narrows cs d i (\z ->
    d_C_funcNamesOfFDecl z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CFuncDecl d c e -> guardCons d c
    (d_C_funcNamesOfFDecl e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CFuncDecl d info -> failCons d (traceFail
    "AbstractCurry.Select.funcNamesOfFDecl" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select.funcNamesOfFDecl" (showCons
    x1))

d_C_funcNamesOfStat :: AbstractCurry.Curry_Types.C_CStatement -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C_funcNamesOfStat x1 cd cs = let x2 = Curry_Prelude.OP_List
  in d_C__case_0 x2 x1 cd cs

d_C_isPrelude :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_C_isPrelude x1 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) x1 (Curry_Prelude.toCurryString "Prelude") cd cs

d_C__case_0 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> AbstractCurry.Curry_Types.C_CStatement -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C__case_0 x2 x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CSLet x3 -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_concatMap d_C_funcNamesOfLDecl cd cs) x3 cd cs
  AbstractCurry.Curry_Types.C_CSExpr x4 -> x2
  AbstractCurry.Curry_Types.C_CSPat x5 x6 -> x2
  AbstractCurry.Curry_Types.Choice_C_CStatement d i l r -> narrow d i
    (d_C__case_0 x2 l cd cs) (d_C__case_0 x2 r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CStatement d i xs -> narrows cs d i (\z ->
    d_C__case_0 x2 z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CStatement d c e -> guardCons d c
    (d_C__case_0 x2 e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CStatement d info -> failCons d (traceFail
    "AbstractCurry.Select._case_0" [show x2, show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select._case_0" (showCons x1))

d_C__case_1 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> AbstractCurry.Curry_Types.C_CLocalDecl -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C__case_1 x2 x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CLocalFunc x3 -> d_C_funcNamesOfFDecl x3 cd cs
  AbstractCurry.Curry_Types.C_CLocalPat x4 x5 -> x2
  AbstractCurry.Curry_Types.C_CLocalVars x6 -> x2
  AbstractCurry.Curry_Types.Choice_C_CLocalDecl d i l r -> narrow d i
    (d_C__case_1 x2 l cd cs) (d_C__case_1 x2 r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CLocalDecl d i xs -> narrows cs d i (\z ->
    d_C__case_1 x2 z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CLocalDecl d c e -> guardCons d c
    (d_C__case_1 x2 e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CLocalDecl d info -> failCons d (traceFail
    "AbstractCurry.Select._case_1" [show x2, show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select._case_1" (showCons x1))

d_C__case_2 :: AbstractCurry.Curry_Types.C_CRhs -> Cover -> ConstStore
  -> Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CLocalDecl
d_C__case_2 x3 cd cs = case x3 of
  AbstractCurry.Curry_Types.C_CSimpleRhs x4 x5 -> x5
  AbstractCurry.Curry_Types.C_CGuardedRhs x6 x7 -> x7
  AbstractCurry.Curry_Types.Choice_C_CRhs d i l r -> narrow d i (d_C__case_2 l
    cd cs) (d_C__case_2 r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CRhs d i xs -> narrows cs d i (\z ->
    d_C__case_2 z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CRhs d c e -> guardCons d c (d_C__case_2 e
    cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CRhs d info -> failCons d (traceFail
    "AbstractCurry.Select._case_2" [show x3] info)
  _ -> failCons cd (consFail "AbstractCurry.Select._case_2" (showCons x3))

d_C__case_3 :: Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CTypeExpr
  -> AbstractCurry.Curry_Types.C_CTypeExpr -> Cover -> ConstStore
  -> Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CTypeExpr
d_C__case_3 x2 x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CFuncType x3 x4 -> Curry_Prelude.OP_Cons x3
    (d_C_argTypes x4 cd cs)
  AbstractCurry.Curry_Types.C_CTVar x5 -> x2
  AbstractCurry.Curry_Types.C_CTCons x6 -> x2
  AbstractCurry.Curry_Types.C_CTApply x7 x8 -> x2
  AbstractCurry.Curry_Types.Choice_C_CTypeExpr d i l r -> narrow d i
    (d_C__case_3 x2 l cd cs) (d_C__case_3 x2 r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CTypeExpr d i xs -> narrows cs d i (\z ->
    d_C__case_3 x2 z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CTypeExpr d c e -> guardCons d c
    (d_C__case_3 x2 e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CTypeExpr d info -> failCons d (traceFail
    "AbstractCurry.Select._case_3" [show x2, show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select._case_3" (showCons x1))

d_C__case_5 :: Curry_Prelude.C_Bool -> AbstractCurry.Curry_Types.C_CTypeExpr
  -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_5 x2 x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CTApply x3 x4 -> let x5 = Curry_Prelude.C_False
    in d_C__case_4 x5 x3 cd cs
  AbstractCurry.Curry_Types.C_CTVar x12 -> x2
  AbstractCurry.Curry_Types.C_CFuncType x13 x14 -> x2
  AbstractCurry.Curry_Types.C_CTCons x15 -> x2
  AbstractCurry.Curry_Types.Choice_C_CTypeExpr d i l r -> narrow d i
    (d_C__case_5 x2 l cd cs) (d_C__case_5 x2 r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CTypeExpr d i xs -> narrows cs d i (\z ->
    d_C__case_5 x2 z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CTypeExpr d c e -> guardCons d c
    (d_C__case_5 x2 e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CTypeExpr d info -> failCons d (traceFail
    "AbstractCurry.Select._case_5" [show x2, show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select._case_5" (showCons x1))

d_C__case_4 :: Curry_Prelude.C_Bool -> AbstractCurry.Curry_Types.C_CTypeExpr
  -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_4 x5 x3 cd cs = case x3 of
  AbstractCurry.Curry_Types.C_CTCons x6 -> Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) x6 (AbstractCurry.Curry_Types.d_C_pre
    (Curry_Prelude.toCurryString "IO") cd cs) cd cs
  AbstractCurry.Curry_Types.C_CTVar x7 -> x5
  AbstractCurry.Curry_Types.C_CFuncType x8 x9 -> x5
  AbstractCurry.Curry_Types.C_CTApply x10 x11 -> x5
  AbstractCurry.Curry_Types.Choice_C_CTypeExpr d i l r -> narrow d i
    (d_C__case_4 x5 l cd cs) (d_C__case_4 x5 r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CTypeExpr d i xs -> narrows cs d i (\z ->
    d_C__case_4 x5 z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CTypeExpr d c e -> guardCons d c
    (d_C__case_4 x5 e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CTypeExpr d info -> failCons d (traceFail
    "AbstractCurry.Select._case_4" [show x5, show x3] info)
  _ -> failCons cd (consFail "AbstractCurry.Select._case_4" (showCons x3))

d_C__case_6 :: Curry_Prelude.C_Bool -> AbstractCurry.Curry_Types.C_CTypeExpr
  -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_6 x2 x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CFuncType x3 x4 -> Curry_Prelude.C_True
  AbstractCurry.Curry_Types.C_CTVar x5 -> x2
  AbstractCurry.Curry_Types.C_CTCons x6 -> x2
  AbstractCurry.Curry_Types.C_CTApply x7 x8 -> x2
  AbstractCurry.Curry_Types.Choice_C_CTypeExpr d i l r -> narrow d i
    (d_C__case_6 x2 l cd cs) (d_C__case_6 x2 r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CTypeExpr d i xs -> narrows cs d i (\z ->
    d_C__case_6 x2 z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CTypeExpr d c e -> guardCons d c
    (d_C__case_6 x2 e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CTypeExpr d info -> failCons d (traceFail
    "AbstractCurry.Select._case_6" [show x2, show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select._case_6" (showCons x1))

d_C__case_7 :: Curry_Prelude.C_Bool -> AbstractCurry.Curry_Types.C_CTypeExpr
  -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_7 x2 x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CTCons x3 -> Curry_Prelude.C_True
  AbstractCurry.Curry_Types.C_CTVar x4 -> x2
  AbstractCurry.Curry_Types.C_CFuncType x5 x6 -> x2
  AbstractCurry.Curry_Types.C_CTApply x7 x8 -> x2
  AbstractCurry.Curry_Types.Choice_C_CTypeExpr d i l r -> narrow d i
    (d_C__case_7 x2 l cd cs) (d_C__case_7 x2 r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CTypeExpr d i xs -> narrows cs d i (\z ->
    d_C__case_7 x2 z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CTypeExpr d c e -> guardCons d c
    (d_C__case_7 x2 e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CTypeExpr d info -> failCons d (traceFail
    "AbstractCurry.Select._case_7" [show x2, show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Select._case_7" (showCons x1))

d_C__case_8 :: AbstractCurry.Curry_Types.C_CContext -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) AbstractCurry.Curry_Types.C_CTypeExpr)
d_C__case_8 x2 cd cs = case x2 of
  AbstractCurry.Curry_Types.C_CContext x4 -> x4
  AbstractCurry.Curry_Types.Choice_C_CContext d i l r -> narrow d i (d_C__case_8
    l cd cs) (d_C__case_8 r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CContext d i xs -> narrows cs d i (\z ->
    d_C__case_8 z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CContext d c e -> guardCons d c (d_C__case_8
    e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CContext d info -> failCons d (traceFail
    "AbstractCurry.Select._case_8" [show x2] info)
  _ -> failCons cd (consFail "AbstractCurry.Select._case_8" (showCons x2))

