{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE Rank2Types #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module Curry_Analysis
  ( C_AnalysisResult
  , C_TypeMap
  , C_NDResult
  , C_TypeHOResult
  , C_ConsHOResult
  , C_FuncHOResult
  , C_Visibilities (..)
  , d_C_showAnalysisResult
  , nd_C_showAnalysisResult
  , d_C_readAnalysisResult
  , nd_C_readAnalysisResult
  , d_C_initTypeMap
  , nd_C_initTypeMap
  , d_C_getTypeMap
  , nd_C_getTypeMap
  , d_C_initNDResult
  , nd_C_initNDResult
  , d_C_analyseND
  , nd_C_analyseND
  , d_C_initTypeHOResult
  , nd_C_initTypeHOResult
  , d_C_analyseHOType
  , nd_C_analyseHOType
  , d_C_initHOResult
  , nd_C_initHOResult
  , d_C_analyseHOCons
  , nd_C_analyseHOCons
  , d_C_analyseHOFunc
  , nd_C_analyseHOFunc
  , d_C_getPrivateFunc
  , d_C_getPrivateType
  , d_C_getPrivateCons
  , d_C_analyzeVisibility )
  where

import Basics
import qualified Curry_Classification
import qualified Curry_FiniteMap
import qualified FlatCurry.Curry_Goodies
import qualified FlatCurry.Curry_Types
import qualified Curry_List
import qualified Curry_Maybe
import qualified Curry_Names
import qualified Curry_Prelude
import qualified Curry_RedBlackTree
import qualified Curry_SetRBT


type C_AnalysisResult = Curry_Prelude.OP_Tuple5 (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))) (Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_NDClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_FuncHOClass)

type C_Map t0 = Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) t0

type C_TypeMap = Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))

type C_Analysis t0 t1 = Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) t1 -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 t0
  (Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) t1

type C_NDResult = Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_NDClass

type C_TypeHOResult = Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_TypeHOClass

type C_ConsHOResult = Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_ConsHOClass

type C_FuncHOResult = Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_FuncHOClass

data C_Visibilities
  = C_Vis (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
    (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
    (Curry_Prelude.OP_List Curry_Prelude.C_Char))) (Curry_Prelude.OP_List
    (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
    (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Curry_Prelude.OP_Tuple2
    (Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
    Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
    (Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
    Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))))
    (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
    (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
    Curry_Prelude.C_Char))) (Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
    (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
    Curry_Prelude.C_Char))))
  | Choice_C_Visibilities Cover ID C_Visibilities C_Visibilities
  | Choices_C_Visibilities Cover ID [C_Visibilities]
  | Fail_C_Visibilities Cover FailInfo
  | Guard_C_Visibilities Cover Constraints C_Visibilities

instance Show C_Visibilities where
  showsPrec d (Choice_C_Visibilities cd i x y) = showsChoice d cd i x y
  showsPrec d (Choices_C_Visibilities cd i xs) = showsChoices d cd i xs
  showsPrec d (Guard_C_Visibilities cd c e) = showsGuard d cd c e
  showsPrec _ (Fail_C_Visibilities cd info) = showChar '!'
  showsPrec _ (C_Vis x1 x2 x3) = showString "(Vis" . (showChar ' ' . (shows x1 .
    (showChar ' ' . (shows x2 . (showChar ' ' . (shows x3 . showChar ')'))))))

instance Read C_Visibilities where
  readsPrec d s = readParen ((>) d 10) (\r -> [(C_Vis x1 x2 x3, r3) | (_, r0) <-
    readQualified "Analysis" "Vis" r, (x1, r1) <- readsPrec 11 r0, (x2, r2) <-
    readsPrec 11 r1, (x3, r3) <- readsPrec 11 r2]) s

instance NonDet C_Visibilities where
  choiceCons = Choice_C_Visibilities
  choicesCons = Choices_C_Visibilities
  failCons = Fail_C_Visibilities
  guardCons = Guard_C_Visibilities
  try (Choice_C_Visibilities cd i x y) = tryChoice cd i x y
  try (Choices_C_Visibilities cd i xs) = tryChoices cd i xs
  try (Fail_C_Visibilities cd info) = Fail cd info
  try (Guard_C_Visibilities cd c e) = Guard cd c e
  try x = Val x
  match f _ _ _ _ _ (Choice_C_Visibilities cd i x y) = f cd i x y
  match _ f _ _ _ _ (Choices_C_Visibilities cd i@(NarrowedID _ _) xs) = f cd i
    xs
  match _ _ f _ _ _ (Choices_C_Visibilities cd i@(FreeID _ _) xs) = f cd i xs
  match _ _ _ _ _ _ (Choices_C_Visibilities cd i _) = error
    ("Analysis.Visibilities.match: Choices with ChoiceID " ++ show i)
  match _ _ _ f _ _ (Fail_C_Visibilities cd info) = f cd info
  match _ _ _ _ f _ (Guard_C_Visibilities cd c e) = f cd c e
  match _ _ _ _ _ f x = f x

instance Generable C_Visibilities where
  generate s c = Choices_C_Visibilities c (freeID [3] s) [C_Vis (generate
    (leftSupply (leftSupply s)) c) (generate (rightSupply (leftSupply s)) c)
    (generate (rightSupply s) c)]

instance NormalForm C_Visibilities where
  ($!!) cont (C_Vis x1 x2 x3) d cs = ($!!) (\y1 d cs -> ($!!) (\y2 d cs -> ($!!)
    (\y3 d cs -> cont (C_Vis y1 y2 y3) d cs) x3 d cs) x2 d cs) x1 d cs
  ($!!) cont (Choice_C_Visibilities cd i x y) d cs = nfChoice cont cd i x y cd
    cs
  ($!!) cont (Choices_C_Visibilities cd i xs) d cs = nfChoices cont cd i xs d cs
  ($!!) cont (Guard_C_Visibilities cd c e) d cs = guardCons cd c (($!!) cont e d
    (addCs c cs))
  ($!!) _ (Fail_C_Visibilities cd info) _ _ = failCons cd info
  ($##) cont (C_Vis x1 x2 x3) d cs = ($##) (\y1 d cs -> ($##) (\y2 d cs -> ($##)
    (\y3 d cs -> cont (C_Vis y1 y2 y3) d cs) x3 d cs) x2 d cs) x1 d cs
  ($##) cont (Choice_C_Visibilities cd i x y) d cs = gnfChoice cont cd i x y cd
    cs
  ($##) cont (Choices_C_Visibilities cd i xs) d cs = gnfChoices cont cd i xs d
    cs
  ($##) cont (Guard_C_Visibilities cd c e) d cs = guardCons cd c (($##) cont e d
    (addCs c cs))
  ($##) _ (Fail_C_Visibilities cd info) _ _ = failCons cd info
  showCons (C_Vis _ _ _) = "Analysis.Vis _ _ _"
  showCons x = error ("Analysis.Visibilities.showCons: no constructor: " ++ show
    x)
  searchNF search cont (C_Vis x1 x2 x3) = search (\y1 -> search (\y2 -> search
    (\y3 -> cont (C_Vis y1 y2 y3)) x3) x2) x1
  searchNF _ _ x = error ("Analysis.Visibilities.searchNF: no constructor: " ++
    show x)

instance Unifiable C_Visibilities where
  (=.=) (C_Vis x1 x2 x3) (C_Vis y1 y2 y3) d cs = (&) ((=:=) x1 y1 d cs) ((&)
    ((=:=) x2 y2 d cs) ((=:=) x3 y3 d cs) d cs) d cs
  (=.=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  (=.<=) (C_Vis x1 x2 x3) (C_Vis y1 y2 y3) d cs = (&) ((=:<=) x1 y1 d cs) ((&)
    ((=:<=) x2 y2 d cs) ((=:<=) x3 y3 d cs) d cs) d cs
  (=.<=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  bind cd i (C_Vis x3 x4 x5) = (i :=: ChooseN 0 3) : concat [bind cd (leftID
    (leftID i)) x3, bind cd (rightID (leftID i)) x4, bind cd (rightID i) x5]
  bind d i (Choice_C_Visibilities cd j x y) = [ConstraintChoice cd j (bind d i
    x) (bind d i y)]
  bind d i (Choices_C_Visibilities cd j@(FreeID _ _) xs) = bindOrNarrow d i cd j
    xs
  bind d i (Choices_C_Visibilities cd j@(NarrowedID _ _) xs) =
    [ConstraintChoices cd j (map (bind d i) xs)]
  bind _ _ (Choices_C_Visibilities cd i _) = error
    ("Analysis.Visibilities.bind: Choices with ChoiceID: " ++ show i)
  bind _ _ (Fail_C_Visibilities cd info) = [Unsolvable info]
  bind d i (Guard_C_Visibilities cd c e) = getConstrList c ++ bind d i e
  lazyBind cd i (C_Vis x3 x4 x5) = (i :=: ChooseN 0 3) : [leftID (leftID i) :=:
    LazyBind (lazyBind cd (leftID (leftID i)) x3), rightID (leftID i) :=:
    LazyBind (lazyBind cd (rightID (leftID i)) x4), rightID i :=: LazyBind
    (lazyBind cd (rightID i) x5)]
  lazyBind d i (Choice_C_Visibilities cd j x y) = [ConstraintChoice cd j
    (lazyBind d i x) (lazyBind d i y)]
  lazyBind d i (Choices_C_Visibilities cd j@(FreeID _ _) xs) = lazyBindOrNarrow
    d i cd j xs
  lazyBind d i (Choices_C_Visibilities cd j@(NarrowedID _ _) xs) =
    [ConstraintChoices cd j (map (lazyBind d i) xs)]
  lazyBind _ _ (Choices_C_Visibilities cd i _) = error
    ("Analysis.Visibilities.lazyBind: Choices with ChoiceID: " ++ show i)
  lazyBind _ _ (Fail_C_Visibilities cd info) = [Unsolvable info]
  lazyBind d i (Guard_C_Visibilities cd c e) = getConstrList c ++ [i :=:
    LazyBind (lazyBind d i e)]

instance Curry C_Visibilities where

d_C_showAnalysisResult :: Curry_Prelude.OP_Tuple5 (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))) (Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_NDClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_FuncHOClass) -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple5 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_showAnalysisResult x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple5 x2 x3 x4 x5 x6 -> Curry_Prelude.OP_Tuple5
    (Curry_FiniteMap.d_C_showFM x2 cd cs) (Curry_FiniteMap.d_C_showFM x3 cd cs)
    (Curry_FiniteMap.d_C_showFM x4 cd cs) (Curry_FiniteMap.d_C_showFM x5 cd cs)
    (Curry_FiniteMap.d_C_showFM x6 cd cs)
  Curry_Prelude.Choice_OP_Tuple5 d i l r -> narrow d i (d_C_showAnalysisResult l
    cd cs) (d_C_showAnalysisResult r cd cs)
  Curry_Prelude.Choices_OP_Tuple5 d i xs -> narrows cs d i (\z ->
    d_C_showAnalysisResult z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple5 d c e -> guardCons d c (d_C_showAnalysisResult e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple5 d info -> failCons d (traceFail
    "Analysis.showAnalysisResult" [show x1] info)
  _ -> failCons cd (consFail "Analysis.showAnalysisResult" (showCons x1))

nd_C_showAnalysisResult :: Curry_Prelude.OP_Tuple5 (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))) (Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_NDClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_FuncHOClass) -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple5 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
nd_C_showAnalysisResult x1 s cd cs = case x1 of
  Curry_Prelude.OP_Tuple5 x2 x3 x4 x5 x6 -> let s5 = s
    in s5 `seq` (let s6 = leftSupply s5
                     s7 = rightSupply s5
                     s0 = leftSupply s6
                     s1 = rightSupply s6
                     s2 = leftSupply s7
                     s8 = rightSupply s7
                     s3 = leftSupply s8
                     s4 = rightSupply s8
    in s6 `seq` (s7 `seq` (s0 `seq` (s1 `seq` (s2 `seq` (s8 `seq` (s3 `seq`
    (s4 `seq` Curry_Prelude.OP_Tuple5 (Curry_FiniteMap.nd_C_showFM x2 s0 cd cs)
    (Curry_FiniteMap.nd_C_showFM x3 s1 cd cs) (Curry_FiniteMap.nd_C_showFM x4 s2
    cd cs) (Curry_FiniteMap.nd_C_showFM x5 s3 cd cs)
    (Curry_FiniteMap.nd_C_showFM x6 s4 cd cs)))))))))
  Curry_Prelude.Choice_OP_Tuple5 d i l r -> narrow d i (nd_C_showAnalysisResult
    l s cd cs) (nd_C_showAnalysisResult r s cd cs)
  Curry_Prelude.Choices_OP_Tuple5 d i xs -> narrows cs d i (\z ->
    nd_C_showAnalysisResult z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple5 d c e -> guardCons d c (nd_C_showAnalysisResult
    e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple5 d info -> failCons d (traceFail
    "Analysis.showAnalysisResult" [show x1] info)
  _ -> failCons cd (consFail "Analysis.showAnalysisResult" (showCons x1))

d_C_readAnalysisResult :: Curry_Prelude.OP_Tuple5 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple5 (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))) (Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_NDClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_FuncHOClass)
d_C_readAnalysisResult x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple5 x2 x3 x4 x5 x6 -> Curry_Prelude.OP_Tuple5
    (Curry_FiniteMap.d_C_readFM
    (Curry_Prelude.d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    cd cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    cd cs) cd cs) cd cs) x2 cd cs) (Curry_FiniteMap.d_C_readFM
    (Curry_Prelude.d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    cd cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    cd cs) cd cs) cd cs) x3 cd cs) (Curry_FiniteMap.d_C_readFM
    (Curry_Prelude.d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    cd cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    cd cs) cd cs) cd cs) x4 cd cs) (Curry_FiniteMap.d_C_readFM
    (Curry_Prelude.d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    cd cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    cd cs) cd cs) cd cs) x5 cd cs) (Curry_FiniteMap.d_C_readFM
    (Curry_Prelude.d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    cd cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    cd cs) cd cs) cd cs) x6 cd cs)
  Curry_Prelude.Choice_OP_Tuple5 d i l r -> narrow d i (d_C_readAnalysisResult l
    cd cs) (d_C_readAnalysisResult r cd cs)
  Curry_Prelude.Choices_OP_Tuple5 d i xs -> narrows cs d i (\z ->
    d_C_readAnalysisResult z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple5 d c e -> guardCons d c (d_C_readAnalysisResult e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple5 d info -> failCons d (traceFail
    "Analysis.readAnalysisResult" [show x1] info)
  _ -> failCons cd (consFail "Analysis.readAnalysisResult" (showCons x1))

nd_C_readAnalysisResult :: Curry_Prelude.OP_Tuple5 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple5 (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))) (Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_NDClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_FuncHOClass)
nd_C_readAnalysisResult x1 s cd cs = case x1 of
  Curry_Prelude.OP_Tuple5 x2 x3 x4 x5 x6 -> let s55 = s
    in s55 `seq` (let s56 = leftSupply s55
                      s57 = rightSupply s55
                      s10 = leftSupply s56
                      s21 = rightSupply s56
                      s32 = leftSupply s57
                      s58 = rightSupply s57
                      s43 = leftSupply s58
                      s54 = rightSupply s58
    in s56 `seq` (s57 `seq` (s10 `seq` (s21 `seq` (s32 `seq` (s58 `seq`
    (s43 `seq` (s54 `seq` Curry_Prelude.OP_Tuple5 (let s9 = leftSupply s10
                                                       s7 = rightSupply s10
    in s9 `seq` (s7 `seq` Curry_FiniteMap.nd_C_readFM (let s6 = leftSupply s7
                                                           s8 = rightSupply s7
                                                           s2 = leftSupply s8
                                                           s5 = rightSupply s8
    in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq`
    Curry_Prelude.nd_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
    (let s1 = leftSupply s2
         s0 = rightSupply s2
    in s1 `seq` (s0 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    s0 cd cs) s1 cd cs)) (let s4 = leftSupply s5
                              s3 = rightSupply s5
    in s4 `seq` (s3 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    s3 cd cs) s4 cd cs)) s6 cd cs)))) x2 s9 cd cs)) (let s20 = leftSupply s21
                                                         s18 = rightSupply s21
    in s20 `seq` (s18 `seq` Curry_FiniteMap.nd_C_readFM (let s17 = leftSupply
                                                               s18
                                                             s19 = rightSupply
                                                               s18
                                                             s13 = leftSupply
                                                               s19
                                                             s16 = rightSupply
                                                               s19
    in s17 `seq` (s19 `seq` (s13 `seq` (s16 `seq`
    Curry_Prelude.nd_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
    (let s12 = leftSupply s13
         s11 = rightSupply s13
    in s12 `seq` (s11 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    s11 cd cs) s12 cd cs)) (let s15 = leftSupply s16
                                s14 = rightSupply s16
    in s15 `seq` (s14 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    s14 cd cs) s15 cd cs)) s17 cd cs)))) x3 s20 cd cs)) (let s31 = leftSupply
                                                               s32
                                                             s29 = rightSupply
                                                               s32
    in s31 `seq` (s29 `seq` Curry_FiniteMap.nd_C_readFM (let s28 = leftSupply
                                                               s29
                                                             s30 = rightSupply
                                                               s29
                                                             s24 = leftSupply
                                                               s30
                                                             s27 = rightSupply
                                                               s30
    in s28 `seq` (s30 `seq` (s24 `seq` (s27 `seq`
    Curry_Prelude.nd_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
    (let s23 = leftSupply s24
         s22 = rightSupply s24
    in s23 `seq` (s22 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    s22 cd cs) s23 cd cs)) (let s26 = leftSupply s27
                                s25 = rightSupply s27
    in s26 `seq` (s25 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    s25 cd cs) s26 cd cs)) s28 cd cs)))) x4 s31 cd cs)) (let s42 = leftSupply
                                                               s43
                                                             s40 = rightSupply
                                                               s43
    in s42 `seq` (s40 `seq` Curry_FiniteMap.nd_C_readFM (let s39 = leftSupply
                                                               s40
                                                             s41 = rightSupply
                                                               s40
                                                             s35 = leftSupply
                                                               s41
                                                             s38 = rightSupply
                                                               s41
    in s39 `seq` (s41 `seq` (s35 `seq` (s38 `seq`
    Curry_Prelude.nd_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
    (let s34 = leftSupply s35
         s33 = rightSupply s35
    in s34 `seq` (s33 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    s33 cd cs) s34 cd cs)) (let s37 = leftSupply s38
                                s36 = rightSupply s38
    in s37 `seq` (s36 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    s36 cd cs) s37 cd cs)) s39 cd cs)))) x5 s42 cd cs)) (let s53 = leftSupply
                                                               s54
                                                             s51 = rightSupply
                                                               s54
    in s53 `seq` (s51 `seq` Curry_FiniteMap.nd_C_readFM (let s50 = leftSupply
                                                               s51
                                                             s52 = rightSupply
                                                               s51
                                                             s46 = leftSupply
                                                               s52
                                                             s49 = rightSupply
                                                               s52
    in s50 `seq` (s52 `seq` (s46 `seq` (s49 `seq`
    Curry_Prelude.nd_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
    (let s45 = leftSupply s46
         s44 = rightSupply s46
    in s45 `seq` (s44 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    s44 cd cs) s45 cd cs)) (let s48 = leftSupply s49
                                s47 = rightSupply s49
    in s48 `seq` (s47 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    s47 cd cs) s48 cd cs)) s50 cd cs)))) x6 s53 cd cs))))))))))
  Curry_Prelude.Choice_OP_Tuple5 d i l r -> narrow d i (nd_C_readAnalysisResult
    l s cd cs) (nd_C_readAnalysisResult r s cd cs)
  Curry_Prelude.Choices_OP_Tuple5 d i xs -> narrows cs d i (\z ->
    nd_C_readAnalysisResult z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple5 d c e -> guardCons d c (nd_C_readAnalysisResult
    e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple5 d info -> failCons d (traceFail
    "Analysis.readAnalysisResult" [show x1] info)
  _ -> failCons cd (consFail "Analysis.readAnalysisResult" (showCons x1))

d_C_initTypeMap :: Cover -> ConstStore -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C_initTypeMap cd cs = Curry_Prelude.d_C_apply (Curry_FiniteMap.d_C_listToFM
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs)
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs) cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char cd
  cs) cd cs)
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char cd
  cs) cd cs) cd cs) cd cs) (d_C_primTypes cd cs) cd cs

nd_C_initTypeMap :: IDSupply -> Cover -> ConstStore -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
nd_C_initTypeMap s cd cs = let s22 = s
  in s22 `seq` (let s21 = leftSupply s22
                    s19 = rightSupply s22
  in s21 `seq` (s19 `seq` Curry_Prelude.nd_C_apply (let s18 = leftSupply s19
                                                        s20 = rightSupply s19
                                                        s7 = leftSupply s20
                                                        s16 = rightSupply s20
  in s18 `seq` (s20 `seq` (s7 `seq` (s16 `seq` Curry_FiniteMap.nd_C_listToFM
  (let s6 = leftSupply s7
       s8 = rightSupply s7
       s2 = leftSupply s8
       s5 = rightSupply s8
  in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
  (let s1 = leftSupply s2
       s0 = rightSupply s2
  in s1 `seq` (s0 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char s0
  cd cs) s1 cd cs)) (let s4 = leftSupply s5
                         s3 = rightSupply s5
  in s4 `seq` (s3 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char s3
  cd cs) s4 cd cs)) s6 cd cs)))) (let s15 = leftSupply s16
                                      s17 = rightSupply s16
                                      s11 = leftSupply s17
                                      s14 = rightSupply s17
  in s15 `seq` (s17 `seq` (s11 `seq` (s14 `seq`
  Curry_Prelude.nd_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
  (let s10 = leftSupply s11
       s9 = rightSupply s11
  in s10 `seq` (s9 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char s9
  cd cs) s10 cd cs)) (let s13 = leftSupply s14
                          s12 = rightSupply s14
  in s13 `seq` (s12 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  s12 cd cs) s13 cd cs)) s15 cd cs)))) s18 cd cs)))) (d_C_primTypes cd cs) s21
  cd cs))

d_C_primTypes :: Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_C_primTypes cd cs = Curry_Prelude.d_OP_dollar (Curry_Prelude.d_C_map
  d_OP_primTypes_dot_uscore_hash_lambda1) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.toCurryString "True")
  (Curry_Prelude.toCurryString "Bool")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.toCurryString "False")
  (Curry_Prelude.toCurryString "Bool")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.toCurryString "Int")
  (Curry_Prelude.toCurryString "Int")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.toCurryString "Float")
  (Curry_Prelude.toCurryString "Float")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.toCurryString "Char")
  (Curry_Prelude.toCurryString "Char")) Curry_Prelude.OP_List))))) cd cs

d_OP_primTypes_dot_uscore_hash_lambda1 :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_OP_primTypes_dot_uscore_hash_lambda1 x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> Curry_Prelude.OP_Tuple2
    (Curry_Prelude.d_C_apply (Curry_Names.d_C_renameQName cd cs)
    (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_prelude cd cs) x2) cd cs)
    (Curry_Prelude.d_C_apply (Curry_Names.d_C_renameQName cd cs)
    (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_prelude cd cs) x3) cd cs)
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_primTypes_dot_uscore_hash_lambda1 l cd cs)
    (d_OP_primTypes_dot_uscore_hash_lambda1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_primTypes_dot_uscore_hash_lambda1 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_primTypes_dot_uscore_hash_lambda1 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Analysis.primTypes._#lambda1" [show x1] info)
  _ -> failCons cd (consFail "Analysis.primTypes._#lambda1" (showCons x1))

d_C_getTypeMap :: Curry_Prelude.OP_List FlatCurry.Curry_Types.C_TypeDecl
  -> Cover -> ConstStore -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_getTypeMap x1 cd cs = Curry_Prelude.d_OP_dollar
  (Curry_FiniteMap.d_C_listToFM
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs)
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs) cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char cd
  cs) cd cs)
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char cd
  cs) cd cs) cd cs) cd cs) (Curry_Prelude.d_OP_dollar
  (Curry_Prelude.d_C_concatMap d_OP_getTypeMap_dot_uscore_hash_lambda2 cd cs)
  (Curry_Prelude.d_C_filter (Curry_Prelude.d_OP_dot Curry_Prelude.d_C_not
  (FlatCurry.Curry_Goodies.d_C_isTypeSyn cd cs) cd cs) x1 cd cs) cd cs) cd cs

nd_C_getTypeMap :: Curry_Prelude.OP_List FlatCurry.Curry_Types.C_TypeDecl
  -> IDSupply -> Cover -> ConstStore -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
nd_C_getTypeMap x1 s cd cs = let s29 = s
  in s29 `seq` (let s28 = leftSupply s29
                    s30 = rightSupply s29
                    s19 = leftSupply s30
                    s26 = rightSupply s30
  in s28 `seq` (s30 `seq` (s19 `seq` (s26 `seq` Curry_Prelude.nd_OP_dollar
  (let s18 = leftSupply s19
       s20 = rightSupply s19
       s7 = leftSupply s20
       s16 = rightSupply s20
  in s18 `seq` (s20 `seq` (s7 `seq` (s16 `seq` Curry_FiniteMap.nd_C_listToFM
  (let s6 = leftSupply s7
       s8 = rightSupply s7
       s2 = leftSupply s8
       s5 = rightSupply s8
  in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
  (let s1 = leftSupply s2
       s0 = rightSupply s2
  in s1 `seq` (s0 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char s0
  cd cs) s1 cd cs)) (let s4 = leftSupply s5
                         s3 = rightSupply s5
  in s4 `seq` (s3 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char s3
  cd cs) s4 cd cs)) s6 cd cs)))) (let s15 = leftSupply s16
                                      s17 = rightSupply s16
                                      s11 = leftSupply s17
                                      s14 = rightSupply s17
  in s15 `seq` (s17 `seq` (s11 `seq` (s14 `seq`
  Curry_Prelude.nd_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
  (let s10 = leftSupply s11
       s9 = rightSupply s11
  in s10 `seq` (s9 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char s9
  cd cs) s10 cd cs)) (let s13 = leftSupply s14
                          s12 = rightSupply s14
  in s13 `seq` (s12 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  s12 cd cs) s13 cd cs)) s15 cd cs)))) s18 cd cs)))) (let s25 = leftSupply s26
                                                          s27 = rightSupply s26
                                                          s21 = leftSupply s27
                                                          s24 = rightSupply s27
  in s25 `seq` (s27 `seq` (s21 `seq` (s24 `seq` Curry_Prelude.nd_OP_dollar
  (Curry_Prelude.nd_C_concatMap (wrapDX id
  d_OP_getTypeMap_dot_uscore_hash_lambda2) s21 cd cs) (let s23 = leftSupply s24
                                                           s22 = rightSupply s24
  in s23 `seq` (s22 `seq` Curry_Prelude.nd_C_filter (Curry_Prelude.nd_OP_dot
  (wrapDX id Curry_Prelude.d_C_not) (wrapDX id
  (FlatCurry.Curry_Goodies.d_C_isTypeSyn cd cs)) s22 cd cs) x1 s23 cd cs)) s25
  cd cs)))) s28 cd cs))))

d_OP_getTypeMap_dot_uscore_hash_lambda2 :: FlatCurry.Curry_Types.C_TypeDecl
  -> Cover -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))
d_OP_getTypeMap_dot_uscore_hash_lambda2 x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_Type x2 x3 x4 x5 -> Curry_Prelude.d_C_map
    (d_OP_getTypeMap_dot_uscore_hash_lambda2_dot_uscore_hash_lambda3 x2) x5 cd
    cs
  FlatCurry.Curry_Types.Choice_C_TypeDecl d i l r -> narrow d i
    (d_OP_getTypeMap_dot_uscore_hash_lambda2 l cd cs)
    (d_OP_getTypeMap_dot_uscore_hash_lambda2 r cd cs)
  FlatCurry.Curry_Types.Choices_C_TypeDecl d i xs -> narrows cs d i (\z ->
    d_OP_getTypeMap_dot_uscore_hash_lambda2 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_TypeDecl d c e -> guardCons d c
    (d_OP_getTypeMap_dot_uscore_hash_lambda2 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_TypeDecl d info -> failCons d (traceFail
    "Analysis.getTypeMap._#lambda2" [show x1] info)
  _ -> failCons cd (consFail "Analysis.getTypeMap._#lambda2" (showCons x1))

d_OP_getTypeMap_dot_uscore_hash_lambda2_dot_uscore_hash_lambda3 :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> FlatCurry.Curry_Types.C_ConsDecl -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_getTypeMap_dot_uscore_hash_lambda2_dot_uscore_hash_lambda3 x1 x2 cd cs =
  Curry_Prelude.OP_Tuple2 (Curry_Prelude.d_C_apply
  (FlatCurry.Curry_Goodies.d_C_consName cd cs) x2 cd cs) x1

d_C_fullIteration :: forall t1 t0 . (Curry_Prelude.Curry t0, Curry_Prelude.Curry
  t1) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0 -> (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) t0 -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 t1 (Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) t0) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 t1 (Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) t0 -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) t0 -> Cover -> ConstStore -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) t0
d_C_fullIteration x1 x2 x3 x4 x5 cd cs = let x6 = Curry_Prelude.d_OP_dollar
                                               (Curry_FiniteMap.d_C_listToFM
                                               (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                                               (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                               (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                               cd cs) cd cs)
                                               (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                               (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                               cd cs) cd cs) cd cs)
                                               (Curry_Prelude.d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
                                               (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
                                               (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
                                               cd cs) cd cs)
                                               (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
                                               (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
                                               cd cs) cd cs) cd cs) cd cs)
                                               (Curry_Prelude.d_C_map
                                               (Curry_Prelude.d_C_apply x2
                                               (Curry_FiniteMap.d_C_plusFM
                                               (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                                               (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                               (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                               cd cs) cd cs)
                                               (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                               (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                               cd cs) cd cs) cd cs) x4 x5 cd cs)
                                               cd cs) x3 cd cs) cd cs
  in d_C__case_21 x6 x5 x1 x4 x3 x2 (Curry_FiniteMap.d_C_eqFM
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs)
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs) cd cs) x1 x5 x6 cd cs) cd cs

nd_C_fullIteration :: forall t1 t0 . (Curry_Prelude.Curry t0
  , Curry_Prelude.Curry t1) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0 -> Func
  (Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)) t0) (Func
  (Curry_Prelude.OP_Tuple2 t1 (Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) t0)) -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  t1 (Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))))
  -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)) t0
  -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)) t0
  -> IDSupply -> Cover -> ConstStore -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) t0
nd_C_fullIteration x1 x2 x3 x4 x5 s cd cs = let s52 = s
  in s52 `seq` (let s37 = leftSupply s52
                    s51 = rightSupply s52
  in s37 `seq` (s51 `seq` (let x6 = let s36 = leftSupply s37
                                        s38 = rightSupply s37
                                        s19 = leftSupply s38
                                        s35 = rightSupply s38
                                 in s36 `seq` (s38 `seq` (s19 `seq` (s35 `seq`
                                 Curry_Prelude.nd_OP_dollar
                                 (let s18 = leftSupply s19
                                      s20 = rightSupply s19
                                      s7 = leftSupply s20
                                      s16 = rightSupply s20
                                 in s18 `seq` (s20 `seq` (s7 `seq` (s16 `seq`
                                 Curry_FiniteMap.nd_C_listToFM
                                 (let s6 = leftSupply s7
                                      s8 = rightSupply s7
                                      s2 = leftSupply s8
                                      s5 = rightSupply s8
                                 in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq`
                                 Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                                 (let s1 = leftSupply s2
                                      s0 = rightSupply s2
                                 in s1 `seq` (s0 `seq`
                                 Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                 (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                 s0 cd cs) s1 cd cs)) (let s4 = leftSupply s5
                                                           s3 = rightSupply s5
                                 in s4 `seq` (s3 `seq`
                                 Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                 (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                 s3 cd cs) s4 cd cs)) s6 cd cs))))
                                 (let s15 = leftSupply s16
                                      s17 = rightSupply s16
                                      s11 = leftSupply s17
                                      s14 = rightSupply s17
                                 in s15 `seq` (s17 `seq` (s11 `seq` (s14 `seq`
                                 Curry_Prelude.nd_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
                                 (let s10 = leftSupply s11
                                      s9 = rightSupply s11
                                 in s10 `seq` (s9 `seq`
                                 Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
                                 (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
                                 s9 cd cs) s10 cd cs)) (let s13 = leftSupply s14
                                                            s12 = rightSupply
                                                              s14
                                 in s13 `seq` (s12 `seq`
                                 Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
                                 (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
                                 s12 cd cs) s13 cd cs)) s15 cd cs)))) s18 cd
                                 cs)))) (let s34 = leftSupply s35
                                             s33 = rightSupply s35
                                 in s34 `seq` (s33 `seq` Curry_Prelude.nd_C_map
                                 (let s32 = leftSupply s33
                                      s31 = rightSupply s33
                                 in s32 `seq` (s31 `seq`
                                 Curry_Prelude.nd_C_apply x2
                                 (let s30 = leftSupply s31
                                      s28 = rightSupply s31
                                 in s30 `seq` (s28 `seq`
                                 Curry_FiniteMap.nd_C_plusFM
                                 (let s27 = leftSupply s28
                                      s29 = rightSupply s28
                                      s23 = leftSupply s29
                                      s26 = rightSupply s29
                                 in s27 `seq` (s29 `seq` (s23 `seq` (s26 `seq`
                                 Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                                 (let s22 = leftSupply s23
                                      s21 = rightSupply s23
                                 in s22 `seq` (s21 `seq`
                                 Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                 (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                 s21 cd cs) s22 cd cs)) (let s25 = leftSupply
                                                               s26
                                                             s24 = rightSupply
                                                               s26
                                 in s25 `seq` (s24 `seq`
                                 Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                 (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                 s24 cd cs) s25 cd cs)) s27 cd cs)))) x4 x5 s30
                                 cd cs)) s32 cd cs)) x3 s34 cd cs)) s36 cd cs)))
  in let s50 = leftSupply s51
         s49 = rightSupply s51
  in s50 `seq` (s49 `seq` nd_C__case_21 x6 x5 x1 x4 x3 x2 (let s48 = leftSupply
                                                                 s49
                                                               s46 = rightSupply
                                                                 s49
  in s48 `seq` (s46 `seq` Curry_FiniteMap.nd_C_eqFM (let s45 = leftSupply s46
                                                         s47 = rightSupply s46
                                                         s41 = leftSupply s47
                                                         s44 = rightSupply s47
  in s45 `seq` (s47 `seq` (s41 `seq` (s44 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
  (let s40 = leftSupply s41
       s39 = rightSupply s41
  in s40 `seq` (s39 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char s39
  cd cs) s40 cd cs)) (let s43 = leftSupply s44
                          s42 = rightSupply s44
  in s43 `seq` (s42 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char s42
  cd cs) s43 cd cs)) s45 cd cs)))) x1 x5 x6 s48 cd cs)) s50 cd cs))))

d_C_initNDResult :: Cover -> ConstStore -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) Curry_Classification.C_NDClass
d_C_initNDResult cd cs = Curry_Prelude.d_C_apply (Curry_FiniteMap.d_C_listToFM
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs)
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs) cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char cd
  cs) cd cs)
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char cd
  cs) cd cs) cd cs) cd cs) (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple2
  (d_C_qmark cd cs) Curry_Classification.C_ND) Curry_Prelude.OP_List) cd cs

nd_C_initNDResult :: IDSupply -> Cover -> ConstStore -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) Curry_Classification.C_NDClass
nd_C_initNDResult s cd cs = let s22 = s
  in s22 `seq` (let s21 = leftSupply s22
                    s19 = rightSupply s22
  in s21 `seq` (s19 `seq` Curry_Prelude.nd_C_apply (let s18 = leftSupply s19
                                                        s20 = rightSupply s19
                                                        s7 = leftSupply s20
                                                        s16 = rightSupply s20
  in s18 `seq` (s20 `seq` (s7 `seq` (s16 `seq` Curry_FiniteMap.nd_C_listToFM
  (let s6 = leftSupply s7
       s8 = rightSupply s7
       s2 = leftSupply s8
       s5 = rightSupply s8
  in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
  (let s1 = leftSupply s2
       s0 = rightSupply s2
  in s1 `seq` (s0 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char s0
  cd cs) s1 cd cs)) (let s4 = leftSupply s5
                         s3 = rightSupply s5
  in s4 `seq` (s3 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char s3
  cd cs) s4 cd cs)) s6 cd cs)))) (let s15 = leftSupply s16
                                      s17 = rightSupply s16
                                      s11 = leftSupply s17
                                      s14 = rightSupply s17
  in s15 `seq` (s17 `seq` (s11 `seq` (s14 `seq`
  Curry_Prelude.nd_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
  (let s10 = leftSupply s11
       s9 = rightSupply s11
  in s10 `seq` (s9 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char s9
  cd cs) s10 cd cs)) (let s13 = leftSupply s14
                          s12 = rightSupply s14
  in s13 `seq` (s12 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  s12 cd cs) s13 cd cs)) s15 cd cs)))) s18 cd cs)))) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (d_C_qmark cd cs) Curry_Classification.C_ND)
  Curry_Prelude.OP_List) s21 cd cs))

d_C_analyseND :: FlatCurry.Curry_Types.C_Prog -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) Curry_Classification.C_NDClass
  -> Cover -> ConstStore -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_NDClass
d_C_analyseND x1 x2 cd cs = let x3 = Curry_Prelude.d_C_apply
                                  (FlatCurry.Curry_Goodies.d_C_progFuncs cd cs)
                                  x1 cd cs
                                x4 = Curry_Prelude.d_OP_dollar
                                  (Curry_FiniteMap.d_C_listToFM
                                  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                                  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                  cd cs) cd cs)
                                  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                  cd cs) cd cs) cd cs)
                                  (Curry_Prelude.d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
                                  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
                                  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
                                  cd cs) cd cs)
                                  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
                                  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
                                  cd cs) cd cs) cd cs) cd cs)
                                  (Curry_Prelude.d_C_map
                                  d_OP_analyseND_dot_initValue_dot_23 x3 cd cs)
                                  cd cs
  in d_C_fullIteration
  (Curry_Classification.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Classification_dot_NDClass
  cd cs) (acceptCs id d_C_ndFunc) (Curry_Prelude.d_C_map
  d_OP_analyseND_dot_getFunctionCalls_dot_23 x3 cd cs) x2 x4 cd cs

nd_C_analyseND :: FlatCurry.Curry_Types.C_Prog -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) Curry_Classification.C_NDClass
  -> IDSupply -> Cover -> ConstStore -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) Curry_Classification.C_NDClass
nd_C_analyseND x1 x2 s cd cs = let s31 = s
  in s31 `seq` (let s0 = leftSupply s31
                    s32 = rightSupply s31
                    s24 = leftSupply s32
                    s29 = rightSupply s32
  in s0 `seq` (s32 `seq` (s24 `seq` (s29 `seq`
  (let x3 = Curry_Prelude.nd_C_apply (wrapDX id
         (FlatCurry.Curry_Goodies.d_C_progFuncs cd cs)) x1 s0 cd cs
       x4 = let s23 = leftSupply s24
                s25 = rightSupply s24
                s20 = leftSupply s25
                s22 = rightSupply s25
         in s23 `seq` (s25 `seq` (s20 `seq` (s22 `seq`
         Curry_Prelude.nd_OP_dollar (let s19 = leftSupply s20
                                         s21 = rightSupply s20
                                         s8 = leftSupply s21
                                         s17 = rightSupply s21
         in s19 `seq` (s21 `seq` (s8 `seq` (s17 `seq`
         Curry_FiniteMap.nd_C_listToFM (let s7 = leftSupply s8
                                            s9 = rightSupply s8
                                            s3 = leftSupply s9
                                            s6 = rightSupply s9
         in s7 `seq` (s9 `seq` (s3 `seq` (s6 `seq`
         Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
         (let s2 = leftSupply s3
              s1 = rightSupply s3
         in s2 `seq` (s1 `seq`
         Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
         (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
         s1 cd cs) s2 cd cs)) (let s5 = leftSupply s6
                                   s4 = rightSupply s6
         in s5 `seq` (s4 `seq`
         Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
         (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
         s4 cd cs) s5 cd cs)) s7 cd cs)))) (let s16 = leftSupply s17
                                                s18 = rightSupply s17
                                                s12 = leftSupply s18
                                                s15 = rightSupply s18
         in s16 `seq` (s18 `seq` (s12 `seq` (s15 `seq`
         Curry_Prelude.nd_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
         (let s11 = leftSupply s12
              s10 = rightSupply s12
         in s11 `seq` (s10 `seq`
         Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
         (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
         s10 cd cs) s11 cd cs)) (let s14 = leftSupply s15
                                     s13 = rightSupply s15
         in s14 `seq` (s13 `seq`
         Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
         (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
         s13 cd cs) s14 cd cs)) s16 cd cs)))) s19 cd cs))))
         (Curry_Prelude.nd_C_map (wrapDX id d_OP_analyseND_dot_initValue_dot_23)
         x3 s22 cd cs) s23 cd cs)))
  in let s28 = leftSupply s29
         s30 = rightSupply s29
         s26 = leftSupply s30
         s27 = rightSupply s30
  in s28 `seq` (s30 `seq` (s26 `seq` (s27 `seq` nd_C_fullIteration
  (Curry_Classification.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Classification_dot_NDClass
  s26 cd cs) (wrapDX (wrapNX id) (acceptCs id nd_C_ndFunc))
  (Curry_Prelude.nd_C_map (wrapDX id d_OP_analyseND_dot_getFunctionCalls_dot_23)
  x3 s27 cd cs) x2 x4 s28 cd cs))))))))

d_OP_analyseND_dot_initValue_dot_23 :: FlatCurry.Curry_Types.C_FuncDecl -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_NDClass
d_OP_analyseND_dot_initValue_dot_23 x1 cd cs = let x2 = Curry_Prelude.d_C_apply
                                                     (FlatCurry.Curry_Goodies.d_C_funcName
                                                     cd cs) x1 cd cs
  in Curry_Prelude.OP_Tuple2 x2 (d_C__case_20 x2
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs)
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs) x2 (d_C_qmark cd cs) cd cs) cd cs)

d_OP_analyseND_dot_getFunctionCalls_dot_23 :: FlatCurry.Curry_Types.C_FuncDecl
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  FlatCurry.Curry_Types.C_FuncDecl (Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_OP_analyseND_dot_getFunctionCalls_dot_23 x1 cd cs = Curry_Prelude.OP_Tuple2 x1
  (d_C_funcCalls x1 cd cs)

d_C_ndFunc :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_NDClass
  -> Curry_Prelude.OP_Tuple2 FlatCurry.Curry_Types.C_FuncDecl
  (Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_NDClass
d_C_ndFunc x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> let x5 = Curry_Prelude.d_C_apply
                                         (FlatCurry.Curry_Goodies.d_C_funcName
                                         cd cs) x3 cd cs
                                       x6 = Curry_Prelude.d_C_apply
                                         (FlatCurry.Curry_Goodies.d_C_funcRule
                                         cd cs) x3 cd cs
                                       x7 = Curry_Prelude.d_OP_dollar
                                         (Curry_Prelude.d_C_any
                                         (Curry_Prelude.d_C_flip (acceptCs id
                                         (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Maybe
                                         (Curry_Classification.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Classification_dot_NDClass
                                         cd cs))) (Curry_Prelude.C_Just
                                         Curry_Classification.C_ND)) cd cs)
                                         (Curry_Prelude.d_C_map
                                         (Curry_FiniteMap.d_C_lookupFM
                                         (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                                         (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                         (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                         cd cs) cd cs)
                                         (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                         (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                         cd cs) cd cs) cd cs) x1) x4 cd cs) cd
                                         cs
                                       x8 = Curry_Prelude.OP_Tuple2 x5
                                         (Curry_Prelude.d_OP_dollar
                                         Curry_Maybe.d_C_fromJust
                                         (Curry_FiniteMap.d_C_lookupFM
                                         (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                                         (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                         (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                         cd cs) cd cs)
                                         (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                         (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                         cd cs) cd cs) cd cs) x1 x5 cd cs) cd
                                         cs)
    in d_C__case_19 x6 x7 x8 x5 (Curry_Prelude.d_C_apply
    (FlatCurry.Curry_Goodies.d_C_isRuleExternal cd cs) x6 cd cs) cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C_ndFunc x1 l cd cs)
    (d_C_ndFunc x1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C_ndFunc x1
    z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C_ndFunc x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail "Analysis.ndFunc"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Analysis.ndFunc" (showCons x2))

nd_C_ndFunc :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_NDClass
  -> Curry_Prelude.OP_Tuple2 FlatCurry.Curry_Types.C_FuncDecl
  (Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) Curry_Classification.C_NDClass
nd_C_ndFunc x1 x2 s cd cs = case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> let s33 = s
    in s33 `seq` (let s34 = leftSupply s33
                      s35 = rightSupply s33
                      s0 = leftSupply s34
                      s1 = rightSupply s34
                      s17 = leftSupply s35
                      s36 = rightSupply s35
                      s31 = leftSupply s36
                      s32 = rightSupply s36
    in s34 `seq` (s35 `seq` (s0 `seq` (s1 `seq` (s17 `seq` (s36 `seq` (s31 `seq`
    (s32 `seq` (let x5 = Curry_Prelude.nd_C_apply (wrapDX id
                      (FlatCurry.Curry_Goodies.d_C_funcName cd cs)) x3 s0 cd cs
                    x6 = Curry_Prelude.nd_C_apply (wrapDX id
                      (FlatCurry.Curry_Goodies.d_C_funcRule cd cs)) x3 s1 cd cs
                    x7 = let s16 = leftSupply s17
                             s18 = rightSupply s17
                             s4 = leftSupply s18
                             s15 = rightSupply s18
                      in s16 `seq` (s18 `seq` (s4 `seq` (s15 `seq`
                      Curry_Prelude.nd_OP_dollar (let s3 = leftSupply s4
                                                      s2 = rightSupply s4
                      in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_any (wrapNX id
                      (Curry_Prelude.nd_C_flip (wrapDX (wrapNX id) (acceptCs id
                      (Curry_Prelude.nd_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Maybe
                      (Curry_Classification.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Classification_dot_NDClass
                      s2 cd cs)))) (Curry_Prelude.C_Just
                      Curry_Classification.C_ND))) s3 cd cs))
                      (let s14 = leftSupply s15
                           s12 = rightSupply s15
                      in s14 `seq` (s12 `seq` Curry_Prelude.nd_C_map (wrapNX id
                      (Curry_FiniteMap.nd_C_lookupFM (let s11 = leftSupply s12
                                                          s13 = rightSupply s12
                                                          s7 = leftSupply s13
                                                          s10 = rightSupply s13
                      in s11 `seq` (s13 `seq` (s7 `seq` (s10 `seq`
                      Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                      (let s6 = leftSupply s7
                           s5 = rightSupply s7
                      in s6 `seq` (s5 `seq`
                      Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                      (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                      s5 cd cs) s6 cd cs)) (let s9 = leftSupply s10
                                                s8 = rightSupply s10
                      in s9 `seq` (s8 `seq`
                      Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                      (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                      s8 cd cs) s9 cd cs)) s11 cd cs)))) x1)) x4 s14 cd cs)) s16
                      cd cs)))
                    x8 = Curry_Prelude.OP_Tuple2 x5 (let s30 = leftSupply s31
                                                         s29 = rightSupply s31
                      in s30 `seq` (s29 `seq` Curry_Prelude.nd_OP_dollar (wrapDX
                      id Curry_Maybe.d_C_fromJust) (let s28 = leftSupply s29
                                                        s26 = rightSupply s29
                      in s28 `seq` (s26 `seq` Curry_FiniteMap.nd_C_lookupFM
                      (let s25 = leftSupply s26
                           s27 = rightSupply s26
                           s21 = leftSupply s27
                           s24 = rightSupply s27
                      in s25 `seq` (s27 `seq` (s21 `seq` (s24 `seq`
                      Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                      (let s20 = leftSupply s21
                           s19 = rightSupply s21
                      in s20 `seq` (s19 `seq`
                      Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                      (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                      s19 cd cs) s20 cd cs)) (let s23 = leftSupply s24
                                                  s22 = rightSupply s24
                      in s23 `seq` (s22 `seq`
                      Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                      (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                      s22 cd cs) s23 cd cs)) s25 cd cs)))) x1 x5 s28 cd cs)) s30
                      cd cs))
    in d_C__case_19 x6 x7 x8 x5 (Curry_Prelude.nd_C_apply (wrapDX id
    (FlatCurry.Curry_Goodies.d_C_isRuleExternal cd cs)) x6 s32 cd cs) cd
    cs)))))))))
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (nd_C_ndFunc x1 l s cd
    cs) (nd_C_ndFunc x1 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> nd_C_ndFunc x1
    z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (nd_C_ndFunc x1 e s cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail "Analysis.ndFunc"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Analysis.ndFunc" (showCons x2))

d_C_isNDExpr :: Cover -> ConstStore -> FlatCurry.Curry_Types.C_Expr -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_C_isNDExpr cd cs = FlatCurry.Curry_Goodies.d_C_trExpr
  d_OP_isNDExpr_dot_cf_dot_40 d_OP_isNDExpr_dot_cf_dot_40 (acceptCs (acceptCs
  id) d_OP_isNDExpr_dot_combf_dot_40) (acceptCs id
  d_OP_isNDExpr_dot_letf_dot_40) (acceptCs id d_OP_isNDExpr_dot_freef_dot_40)
  (acceptCs id d_OP_isNDExpr_dot_orf_dot_40) (acceptCs (acceptCs id)
  d_OP_isNDExpr_dot_casef_dot_40) (acceptCs id d_OP_isNDExpr_dot_branchf_dot_40)
  (acceptCs id d_OP_isNDExpr_dot_typedf_dot_40)

d_OP_isNDExpr_dot_cf_dot_40 :: forall t0 . (Curry_Prelude.Curry t0) => t0
  -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_OP_isNDExpr_dot_cf_dot_40 x1 cd cs = Curry_Prelude.d_C_const
  Curry_Prelude.C_False x1 cd cs

d_OP_isNDExpr_dot_combf_dot_40 :: forall t0 t1 . (Curry_Prelude.Curry t1
  , Curry_Prelude.Curry t0) => t0 -> t1 -> Curry_Prelude.OP_List
  Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_OP_isNDExpr_dot_combf_dot_40 x1 x2 x3 cd cs = Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_or cd cs) x3 cd cs

d_OP_isNDExpr_dot_letf_dot_40 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 t0 Curry_Prelude.C_Bool)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_OP_isNDExpr_dot_letf_dot_40 x1 x2 cd cs = Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_or cd cs) (Curry_Prelude.OP_Cons x2 (Curry_Prelude.d_C_map
  Curry_Prelude.d_C_snd x1 cd cs)) cd cs

d_OP_isNDExpr_dot_freef_dot_40 :: forall t0 t1 . (Curry_Prelude.Curry t1
  , Curry_Prelude.Curry t0) => Curry_Prelude.OP_List t0 -> t1 -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_OP_isNDExpr_dot_freef_dot_40 x1 x2 cd cs = Curry_Prelude.d_C_not
  (Curry_Prelude.d_C_null x1 cd cs) cd cs

d_OP_isNDExpr_dot_orf_dot_40 :: forall t0 t1 . (Curry_Prelude.Curry t1
  , Curry_Prelude.Curry t0) => t0 -> t1 -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_OP_isNDExpr_dot_orf_dot_40 x1 x2 cd cs = Curry_Prelude.C_True

d_OP_isNDExpr_dot_casef_dot_40 :: forall t0 . (Curry_Prelude.Curry t0) => t0
  -> Curry_Prelude.C_Bool -> Curry_Prelude.OP_List Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_OP_isNDExpr_dot_casef_dot_40 x1 x2 x3 cd cs = Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_or cd cs) (Curry_Prelude.OP_Cons x2 x3) cd cs

d_OP_isNDExpr_dot_branchf_dot_40 :: forall t0 t1 . (Curry_Prelude.Curry t1
  , Curry_Prelude.Curry t0) => t0 -> t1 -> Cover -> ConstStore -> t1
d_OP_isNDExpr_dot_branchf_dot_40 x1 x2 cd cs = x2

d_OP_isNDExpr_dot_typedf_dot_40 :: forall t1 t0 . (Curry_Prelude.Curry t0
  , Curry_Prelude.Curry t1) => t0 -> t1 -> Cover -> ConstStore -> t0
d_OP_isNDExpr_dot_typedf_dot_40 x1 x2 cd cs = x1

d_C_funcCalls :: FlatCurry.Curry_Types.C_FuncDecl -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_funcCalls x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_Func x2 x3 x4 x5 x6 -> d_C__case_15 x6 cd cs
  FlatCurry.Curry_Types.Choice_C_FuncDecl d i l r -> narrow d i (d_C_funcCalls l
    cd cs) (d_C_funcCalls r cd cs)
  FlatCurry.Curry_Types.Choices_C_FuncDecl d i xs -> narrows cs d i (\z ->
    d_C_funcCalls z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_FuncDecl d c e -> guardCons d c (d_C_funcCalls e
    cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_FuncDecl d info -> failCons d (traceFail
    "Analysis.funcCalls" [show x1] info)
  _ -> failCons cd (consFail "Analysis.funcCalls" (showCons x1))

d_C_funcsInExp :: FlatCurry.Curry_Types.C_Expr -> Cover -> ConstStore
  -> Curry_RedBlackTree.C_RedBlackTree (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C_funcsInExp x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_Var x2 -> d_C_empty
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    cd cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    cd cs) cd cs) cd cs) cd cs
  FlatCurry.Curry_Types.C_Lit x3 -> d_C_empty
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    cd cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    cd cs) cd cs) cd cs) cd cs
  FlatCurry.Curry_Types.C_Comb x4 x5 x6 -> d_C__case_14 x4 x6 x5 (d_C_isFuncCall
    x4 cd cs) cd cs
  FlatCurry.Curry_Types.C_Free x7 x8 -> d_C_funcsInExp x8 cd cs
  FlatCurry.Curry_Types.C_Let x9 x10 -> Curry_Prelude.d_C_apply (d_C_unionMap
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    cd cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    cd cs) cd cs) cd cs) d_C_funcsInExp cd cs) (Curry_Prelude.OP_Cons x10
    (Curry_Prelude.d_C_map Curry_Prelude.d_C_snd x9 cd cs)) cd cs
  FlatCurry.Curry_Types.C_Or x11 x12 -> Curry_SetRBT.d_C_unionRBT
    (d_C_funcsInExp x11 cd cs) (d_C_funcsInExp x12 cd cs) cd cs
  FlatCurry.Curry_Types.C_Case x13 x14 x15 -> Curry_Prelude.d_C_apply
    (d_C_unionMap
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    cd cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    cd cs) cd cs) cd cs) d_C_funcsInExp cd cs) (Curry_Prelude.OP_Cons x14
    (Curry_Prelude.d_C_map (FlatCurry.Curry_Goodies.d_C_branchExpr cd cs) x15 cd
    cs)) cd cs
  FlatCurry.Curry_Types.C_Typed x16 x17 -> d_C_funcsInExp x16 cd cs
  FlatCurry.Curry_Types.Choice_C_Expr d i l r -> narrow d i (d_C_funcsInExp l cd
    cs) (d_C_funcsInExp r cd cs)
  FlatCurry.Curry_Types.Choices_C_Expr d i xs -> narrows cs d i (\z ->
    d_C_funcsInExp z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Expr d c e -> guardCons d c (d_C_funcsInExp e
    cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Expr d info -> failCons d (traceFail
    "Analysis.funcsInExp" [show x1] info)
  _ -> failCons cd (consFail "Analysis.funcsInExp" (showCons x1))

nd_C_funcsInExp :: FlatCurry.Curry_Types.C_Expr -> IDSupply -> Cover
  -> ConstStore -> Curry_RedBlackTree.C_RedBlackTree (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
nd_C_funcsInExp x1 s cd cs = case x1 of
  FlatCurry.Curry_Types.C_Var x2 -> let s10 = s
    in s10 `seq` (let s9 = leftSupply s10
                      s7 = rightSupply s10
    in s9 `seq` (s7 `seq` nd_C_empty (let s6 = leftSupply s7
                                          s8 = rightSupply s7
                                          s2 = leftSupply s8
                                          s5 = rightSupply s8
    in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
    (let s1 = leftSupply s2
         s0 = rightSupply s2
    in s1 `seq` (s0 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    s0 cd cs) s1 cd cs)) (let s4 = leftSupply s5
                              s3 = rightSupply s5
    in s4 `seq` (s3 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    s3 cd cs) s4 cd cs)) s6 cd cs)))) s9 cd cs))
  FlatCurry.Curry_Types.C_Lit x3 -> let s10 = s
    in s10 `seq` (let s9 = leftSupply s10
                      s7 = rightSupply s10
    in s9 `seq` (s7 `seq` nd_C_empty (let s6 = leftSupply s7
                                          s8 = rightSupply s7
                                          s2 = leftSupply s8
                                          s5 = rightSupply s8
    in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
    (let s1 = leftSupply s2
         s0 = rightSupply s2
    in s1 `seq` (s0 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    s0 cd cs) s1 cd cs)) (let s4 = leftSupply s5
                              s3 = rightSupply s5
    in s4 `seq` (s3 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    s3 cd cs) s4 cd cs)) s6 cd cs)))) s9 cd cs))
  FlatCurry.Curry_Types.C_Comb x4 x5 x6 -> let s0 = s
    in s0 `seq` nd_C__case_14 x4 x6 x5 (d_C_isFuncCall x4 cd cs) s0 cd cs
  FlatCurry.Curry_Types.C_Free x7 x8 -> let s0 = s
    in s0 `seq` nd_C_funcsInExp x8 s0 cd cs
  FlatCurry.Curry_Types.C_Let x9 x10 -> let s13 = s
    in s13 `seq` (let s12 = leftSupply s13
                      s14 = rightSupply s13
                      s10 = leftSupply s14
                      s11 = rightSupply s14
    in s12 `seq` (s14 `seq` (s10 `seq` (s11 `seq` Curry_Prelude.nd_C_apply
    (let s9 = leftSupply s10
         s7 = rightSupply s10
    in s9 `seq` (s7 `seq` nd_C_unionMap (let s6 = leftSupply s7
                                             s8 = rightSupply s7
                                             s2 = leftSupply s8
                                             s5 = rightSupply s8
    in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
    (let s1 = leftSupply s2
         s0 = rightSupply s2
    in s1 `seq` (s0 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    s0 cd cs) s1 cd cs)) (let s4 = leftSupply s5
                              s3 = rightSupply s5
    in s4 `seq` (s3 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    s3 cd cs) s4 cd cs)) s6 cd cs)))) (wrapNX id nd_C_funcsInExp) s9 cd cs))
    (Curry_Prelude.OP_Cons x10 (Curry_Prelude.nd_C_map (wrapDX id
    Curry_Prelude.d_C_snd) x9 s11 cd cs)) s12 cd cs))))
  FlatCurry.Curry_Types.C_Or x11 x12 -> let s3 = s
    in s3 `seq` (let s2 = leftSupply s3
                     s4 = rightSupply s3
                     s0 = leftSupply s4
                     s1 = rightSupply s4
    in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` Curry_SetRBT.nd_C_unionRBT
    (nd_C_funcsInExp x11 s0 cd cs) (nd_C_funcsInExp x12 s1 cd cs) s2 cd cs))))
  FlatCurry.Curry_Types.C_Case x13 x14 x15 -> let s13 = s
    in s13 `seq` (let s12 = leftSupply s13
                      s14 = rightSupply s13
                      s10 = leftSupply s14
                      s11 = rightSupply s14
    in s12 `seq` (s14 `seq` (s10 `seq` (s11 `seq` Curry_Prelude.nd_C_apply
    (let s9 = leftSupply s10
         s7 = rightSupply s10
    in s9 `seq` (s7 `seq` nd_C_unionMap (let s6 = leftSupply s7
                                             s8 = rightSupply s7
                                             s2 = leftSupply s8
                                             s5 = rightSupply s8
    in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
    (let s1 = leftSupply s2
         s0 = rightSupply s2
    in s1 `seq` (s0 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    s0 cd cs) s1 cd cs)) (let s4 = leftSupply s5
                              s3 = rightSupply s5
    in s4 `seq` (s3 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    s3 cd cs) s4 cd cs)) s6 cd cs)))) (wrapNX id nd_C_funcsInExp) s9 cd cs))
    (Curry_Prelude.OP_Cons x14 (Curry_Prelude.nd_C_map (wrapDX id
    (FlatCurry.Curry_Goodies.d_C_branchExpr cd cs)) x15 s11 cd cs)) s12 cd
    cs))))
  FlatCurry.Curry_Types.C_Typed x16 x17 -> let s0 = s
    in s0 `seq` nd_C_funcsInExp x16 s0 cd cs
  FlatCurry.Curry_Types.Choice_C_Expr d i l r -> narrow d i (nd_C_funcsInExp l s
    cd cs) (nd_C_funcsInExp r s cd cs)
  FlatCurry.Curry_Types.Choices_C_Expr d i xs -> narrows cs d i (\z ->
    nd_C_funcsInExp z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Expr d c e -> guardCons d c (nd_C_funcsInExp e s
    cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Expr d info -> failCons d (traceFail
    "Analysis.funcsInExp" [show x1] info)
  _ -> failCons cd (consFail "Analysis.funcsInExp" (showCons x1))

d_C_isFuncCall :: FlatCurry.Curry_Types.C_CombType -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isFuncCall x1 cd cs = let x2 = Curry_Prelude.C_False
  in d_C__case_12 x2 x1 cd cs

d_C_initTypeHOResult :: Cover -> ConstStore -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass
d_C_initTypeHOResult cd cs = Curry_Prelude.d_C_apply
  (Curry_FiniteMap.d_C_listToFM
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs)
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs) cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char cd
  cs) cd cs)
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char cd
  cs) cd cs) cd cs) cd cs) (d_C_externalTypes cd cs) cd cs

nd_C_initTypeHOResult :: IDSupply -> Cover -> ConstStore -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass
nd_C_initTypeHOResult s cd cs = let s22 = s
  in s22 `seq` (let s21 = leftSupply s22
                    s19 = rightSupply s22
  in s21 `seq` (s19 `seq` Curry_Prelude.nd_C_apply (let s18 = leftSupply s19
                                                        s20 = rightSupply s19
                                                        s7 = leftSupply s20
                                                        s16 = rightSupply s20
  in s18 `seq` (s20 `seq` (s7 `seq` (s16 `seq` Curry_FiniteMap.nd_C_listToFM
  (let s6 = leftSupply s7
       s8 = rightSupply s7
       s2 = leftSupply s8
       s5 = rightSupply s8
  in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
  (let s1 = leftSupply s2
       s0 = rightSupply s2
  in s1 `seq` (s0 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char s0
  cd cs) s1 cd cs)) (let s4 = leftSupply s5
                         s3 = rightSupply s5
  in s4 `seq` (s3 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char s3
  cd cs) s4 cd cs)) s6 cd cs)))) (let s15 = leftSupply s16
                                      s17 = rightSupply s16
                                      s11 = leftSupply s17
                                      s14 = rightSupply s17
  in s15 `seq` (s17 `seq` (s11 `seq` (s14 `seq`
  Curry_Prelude.nd_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
  (let s10 = leftSupply s11
       s9 = rightSupply s11
  in s10 `seq` (s9 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char s9
  cd cs) s10 cd cs)) (let s13 = leftSupply s14
                          s12 = rightSupply s14
  in s13 `seq` (s12 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  s12 cd cs) s13 cd cs)) s15 cd cs)))) s18 cd cs)))) (d_C_externalTypes cd cs)
  s21 cd cs))

d_C_externalTypes :: Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass)
d_C_externalTypes cd cs = Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple2
  (d_C_ioType cd cs) Curry_Classification.C_TypeIO) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (d_C_successType cd cs)
  Curry_Classification.C_TypeFO) Curry_Prelude.OP_List)

d_C_getHOResult :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass -> Cover -> ConstStore
  -> Curry_Classification.C_TypeHOClass
d_C_getHOResult x1 x2 cd cs = Curry_Maybe.d_C_fromMaybe
  Curry_Classification.C_TypeFO (Curry_FiniteMap.d_C_lookupFM
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs)
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs) cd cs) x2 x1 cd cs) cd cs

nd_C_getHOResult :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass -> IDSupply -> Cover -> ConstStore
  -> Curry_Classification.C_TypeHOClass
nd_C_getHOResult x1 x2 s cd cs = let s10 = s
  in s10 `seq` Curry_Maybe.d_C_fromMaybe Curry_Classification.C_TypeFO
  (let s9 = leftSupply s10
       s7 = rightSupply s10
  in s9 `seq` (s7 `seq` Curry_FiniteMap.nd_C_lookupFM (let s6 = leftSupply s7
                                                           s8 = rightSupply s7
                                                           s2 = leftSupply s8
                                                           s5 = rightSupply s8
  in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
  (let s1 = leftSupply s2
       s0 = rightSupply s2
  in s1 `seq` (s0 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char s0
  cd cs) s1 cd cs)) (let s4 = leftSupply s5
                         s3 = rightSupply s5
  in s4 `seq` (s3 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char s3
  cd cs) s4 cd cs)) s6 cd cs)))) x2 x1 s9 cd cs)) cd cs

d_C_analyseHOType :: FlatCurry.Curry_Types.C_Prog -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass -> Cover -> ConstStore
  -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass
d_C_analyseHOType x1 x2 cd cs = let x3 = Curry_Prelude.d_C_apply
                                      (FlatCurry.Curry_Goodies.d_C_progTypes cd
                                      cs) x1 cd cs
                                    x4 = Curry_Prelude.d_OP_dollar
                                      (Curry_FiniteMap.d_C_listToFM
                                      (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                                      (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                      (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                      cd cs) cd cs)
                                      (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                      (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                      cd cs) cd cs) cd cs)
                                      (Curry_Prelude.d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
                                      (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
                                      (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
                                      cd cs) cd cs)
                                      (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
                                      (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
                                      cd cs) cd cs) cd cs) cd cs)
                                      (Curry_Prelude.d_C_map
                                      d_OP_analyseHOType_dot_initValue_dot_117
                                      x3 cd cs) cd cs
  in d_C_fullIteration
  (Curry_Classification.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Classification_dot_TypeHOClass
  cd cs) (acceptCs id d_C_hoType) (Curry_Prelude.d_C_map
  d_OP_analyseHOType_dot_getUsedTypes_dot_117 x3 cd cs) x2 x4 cd cs

nd_C_analyseHOType :: FlatCurry.Curry_Types.C_Prog -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass -> IDSupply -> Cover -> ConstStore
  -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass
nd_C_analyseHOType x1 x2 s cd cs = let s31 = s
  in s31 `seq` (let s0 = leftSupply s31
                    s32 = rightSupply s31
                    s24 = leftSupply s32
                    s29 = rightSupply s32
  in s0 `seq` (s32 `seq` (s24 `seq` (s29 `seq`
  (let x3 = Curry_Prelude.nd_C_apply (wrapDX id
         (FlatCurry.Curry_Goodies.d_C_progTypes cd cs)) x1 s0 cd cs
       x4 = let s23 = leftSupply s24
                s25 = rightSupply s24
                s20 = leftSupply s25
                s22 = rightSupply s25
         in s23 `seq` (s25 `seq` (s20 `seq` (s22 `seq`
         Curry_Prelude.nd_OP_dollar (let s19 = leftSupply s20
                                         s21 = rightSupply s20
                                         s8 = leftSupply s21
                                         s17 = rightSupply s21
         in s19 `seq` (s21 `seq` (s8 `seq` (s17 `seq`
         Curry_FiniteMap.nd_C_listToFM (let s7 = leftSupply s8
                                            s9 = rightSupply s8
                                            s3 = leftSupply s9
                                            s6 = rightSupply s9
         in s7 `seq` (s9 `seq` (s3 `seq` (s6 `seq`
         Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
         (let s2 = leftSupply s3
              s1 = rightSupply s3
         in s2 `seq` (s1 `seq`
         Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
         (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
         s1 cd cs) s2 cd cs)) (let s5 = leftSupply s6
                                   s4 = rightSupply s6
         in s5 `seq` (s4 `seq`
         Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
         (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
         s4 cd cs) s5 cd cs)) s7 cd cs)))) (let s16 = leftSupply s17
                                                s18 = rightSupply s17
                                                s12 = leftSupply s18
                                                s15 = rightSupply s18
         in s16 `seq` (s18 `seq` (s12 `seq` (s15 `seq`
         Curry_Prelude.nd_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
         (let s11 = leftSupply s12
              s10 = rightSupply s12
         in s11 `seq` (s10 `seq`
         Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
         (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
         s10 cd cs) s11 cd cs)) (let s14 = leftSupply s15
                                     s13 = rightSupply s15
         in s14 `seq` (s13 `seq`
         Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
         (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
         s13 cd cs) s14 cd cs)) s16 cd cs)))) s19 cd cs))))
         (Curry_Prelude.nd_C_map (wrapDX id
         d_OP_analyseHOType_dot_initValue_dot_117) x3 s22 cd cs) s23 cd cs)))
  in let s28 = leftSupply s29
         s30 = rightSupply s29
         s26 = leftSupply s30
         s27 = rightSupply s30
  in s28 `seq` (s30 `seq` (s26 `seq` (s27 `seq` nd_C_fullIteration
  (Curry_Classification.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Classification_dot_TypeHOClass
  s26 cd cs) (wrapDX (wrapNX id) (acceptCs id nd_C_hoType))
  (Curry_Prelude.nd_C_map (wrapDX id
  d_OP_analyseHOType_dot_getUsedTypes_dot_117) x3 s27 cd cs) x2 x4 s28 cd
  cs))))))))

d_OP_analyseHOType_dot_initValue_dot_117 :: FlatCurry.Curry_Types.C_TypeDecl
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_TypeHOClass
d_OP_analyseHOType_dot_initValue_dot_117 x1 cd cs = Curry_Prelude.OP_Tuple2
  (Curry_Prelude.d_C_apply (FlatCurry.Curry_Goodies.d_C_typeName cd cs) x1 cd
  cs) (d_C_classifyHOTypeDecl x1 cd cs)

d_OP_analyseHOType_dot_getUsedTypes_dot_117 :: FlatCurry.Curry_Types.C_TypeDecl
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  FlatCurry.Curry_Types.C_TypeDecl (Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_OP_analyseHOType_dot_getUsedTypes_dot_117 x1 cd cs = Curry_Prelude.OP_Tuple2
  x1 (d_C_usedTypes x1 cd cs)

d_C_hoType :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_TypeHOClass
  -> Curry_Prelude.OP_Tuple2 FlatCurry.Curry_Types.C_TypeDecl
  (Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_TypeHOClass
d_C_hoType x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> let x5 = Curry_Prelude.d_C_map
                                         (Curry_Prelude.d_C_flip (acceptCs id
                                         d_C_getHOResult) x1)
                                         (Curry_Prelude.OP_Cons
                                         (Curry_Prelude.d_C_apply
                                         (FlatCurry.Curry_Goodies.d_C_typeName
                                         cd cs) x3 cd cs) x4) cd cs
    in Curry_Prelude.OP_Tuple2 (Curry_Prelude.d_C_apply
    (FlatCurry.Curry_Goodies.d_C_typeName cd cs) x3 cd cs)
    (Curry_Classification.d_C_maximumTypeHOClass x5 cd cs)
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C_hoType x1 l cd cs)
    (d_C_hoType x1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C_hoType x1
    z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C_hoType x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail "Analysis.hoType"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Analysis.hoType" (showCons x2))

nd_C_hoType :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_TypeHOClass
  -> Curry_Prelude.OP_Tuple2 FlatCurry.Curry_Types.C_TypeDecl
  (Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass
nd_C_hoType x1 x2 s cd cs = case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> let s4 = s
    in s4 `seq` (let s2 = leftSupply s4
                     s3 = rightSupply s4
    in s2 `seq` (s3 `seq` (let x5 = let s1 = leftSupply s2
                                        s0 = rightSupply s2
                                 in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_map
                                 (wrapNX id (Curry_Prelude.nd_C_flip (wrapDX
                                 (wrapNX id) (acceptCs id nd_C_getHOResult))
                                 x1)) (Curry_Prelude.OP_Cons
                                 (Curry_Prelude.nd_C_apply (wrapDX id
                                 (FlatCurry.Curry_Goodies.d_C_typeName cd cs))
                                 x3 s0 cd cs) x4) s1 cd cs)
    in Curry_Prelude.OP_Tuple2 (Curry_Prelude.nd_C_apply (wrapDX id
    (FlatCurry.Curry_Goodies.d_C_typeName cd cs)) x3 s3 cd cs)
    (Curry_Classification.d_C_maximumTypeHOClass x5 cd cs))))
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (nd_C_hoType x1 l s cd
    cs) (nd_C_hoType x1 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> nd_C_hoType x1
    z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (nd_C_hoType x1 e s cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail "Analysis.hoType"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Analysis.hoType" (showCons x2))

d_C_classifyHOTypeDecl :: FlatCurry.Curry_Types.C_TypeDecl -> Cover
  -> ConstStore -> Curry_Classification.C_TypeHOClass
d_C_classifyHOTypeDecl x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_Type x2 x3 x4 x5 -> d_C__case_11 x2 x5
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) x2 (d_C_ioType cd cs) cd cs) cd cs
  FlatCurry.Curry_Types.C_TypeSyn x6 x7 x8 x9 -> d_C_classifyHOType x9 cd cs
  FlatCurry.Curry_Types.Choice_C_TypeDecl d i l r -> narrow d i
    (d_C_classifyHOTypeDecl l cd cs) (d_C_classifyHOTypeDecl r cd cs)
  FlatCurry.Curry_Types.Choices_C_TypeDecl d i xs -> narrows cs d i (\z ->
    d_C_classifyHOTypeDecl z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_TypeDecl d c e -> guardCons d c
    (d_C_classifyHOTypeDecl e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_TypeDecl d info -> failCons d (traceFail
    "Analysis.classifyHOTypeDecl" [show x1] info)
  _ -> failCons cd (consFail "Analysis.classifyHOTypeDecl" (showCons x1))

d_C_classifyHOType :: FlatCurry.Curry_Types.C_TypeExpr -> Cover -> ConstStore
  -> Curry_Classification.C_TypeHOClass
d_C_classifyHOType x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_TVar x2 -> Curry_Classification.C_TypeFO
  FlatCurry.Curry_Types.C_FuncType x3 x4 -> Curry_Classification.C_TypeHO
  FlatCurry.Curry_Types.C_TCons x5 x6 -> d_C__case_9 x5 x6
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) x5 (d_C_ioType cd cs) cd cs) cd cs
  FlatCurry.Curry_Types.C_ForallType x7 x8 -> d_C_classifyHOType x8 cd cs
  FlatCurry.Curry_Types.Choice_C_TypeExpr d i l r -> narrow d i
    (d_C_classifyHOType l cd cs) (d_C_classifyHOType r cd cs)
  FlatCurry.Curry_Types.Choices_C_TypeExpr d i xs -> narrows cs d i (\z ->
    d_C_classifyHOType z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_TypeExpr d c e -> guardCons d c
    (d_C_classifyHOType e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_TypeExpr d info -> failCons d (traceFail
    "Analysis.classifyHOType" [show x1] info)
  _ -> failCons cd (consFail "Analysis.classifyHOType" (showCons x1))

d_C_usedTypes :: FlatCurry.Curry_Types.C_TypeDecl -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_usedTypes x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_Type x2 x3 x4 x5 -> Curry_Prelude.d_OP_dollar
    (d_C_toList cd cs) (Curry_Prelude.d_OP_dollar (d_C_unionMap
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    cd cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    cd cs) cd cs) cd cs) d_C_typeCons cd cs) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_concatMap (FlatCurry.Curry_Goodies.d_C_consArgs cd cs) cd
    cs) x5 cd cs) cd cs) cd cs
  FlatCurry.Curry_Types.C_TypeSyn x6 x7 x8 x9 -> Curry_Prelude.d_OP_dollar
    (d_C_toList cd cs) (d_C_typeCons x9 cd cs) cd cs
  FlatCurry.Curry_Types.Choice_C_TypeDecl d i l r -> narrow d i (d_C_usedTypes l
    cd cs) (d_C_usedTypes r cd cs)
  FlatCurry.Curry_Types.Choices_C_TypeDecl d i xs -> narrows cs d i (\z ->
    d_C_usedTypes z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_TypeDecl d c e -> guardCons d c (d_C_usedTypes e
    cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_TypeDecl d info -> failCons d (traceFail
    "Analysis.usedTypes" [show x1] info)
  _ -> failCons cd (consFail "Analysis.usedTypes" (showCons x1))

d_C_typeCons :: FlatCurry.Curry_Types.C_TypeExpr -> Cover -> ConstStore
  -> Curry_RedBlackTree.C_RedBlackTree (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C_typeCons x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_TVar x2 -> d_C_empty
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    cd cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    cd cs) cd cs) cd cs) cd cs
  FlatCurry.Curry_Types.C_FuncType x3 x4 -> Curry_SetRBT.d_C_unionRBT
    (d_C_typeCons x3 cd cs) (d_C_typeCons x4 cd cs) cd cs
  FlatCurry.Curry_Types.C_TCons x5 x6 -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Curry_SetRBT.d_C_insertRBT cd cs) x5 cd cs)
    (Curry_Prelude.d_C_apply (d_C_unionMap
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    cd cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    cd cs) cd cs) cd cs) d_C_typeCons cd cs) x6 cd cs) cd cs
  FlatCurry.Curry_Types.C_ForallType x7 x8 -> d_C_typeCons x8 cd cs
  FlatCurry.Curry_Types.Choice_C_TypeExpr d i l r -> narrow d i (d_C_typeCons l
    cd cs) (d_C_typeCons r cd cs)
  FlatCurry.Curry_Types.Choices_C_TypeExpr d i xs -> narrows cs d i (\z ->
    d_C_typeCons z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_TypeExpr d c e -> guardCons d c (d_C_typeCons e
    cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_TypeExpr d info -> failCons d (traceFail
    "Analysis.typeCons" [show x1] info)
  _ -> failCons cd (consFail "Analysis.typeCons" (showCons x1))

nd_C_typeCons :: FlatCurry.Curry_Types.C_TypeExpr -> IDSupply -> Cover
  -> ConstStore -> Curry_RedBlackTree.C_RedBlackTree (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
nd_C_typeCons x1 s cd cs = case x1 of
  FlatCurry.Curry_Types.C_TVar x2 -> let s10 = s
    in s10 `seq` (let s9 = leftSupply s10
                      s7 = rightSupply s10
    in s9 `seq` (s7 `seq` nd_C_empty (let s6 = leftSupply s7
                                          s8 = rightSupply s7
                                          s2 = leftSupply s8
                                          s5 = rightSupply s8
    in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
    (let s1 = leftSupply s2
         s0 = rightSupply s2
    in s1 `seq` (s0 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    s0 cd cs) s1 cd cs)) (let s4 = leftSupply s5
                              s3 = rightSupply s5
    in s4 `seq` (s3 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    s3 cd cs) s4 cd cs)) s6 cd cs)))) s9 cd cs))
  FlatCurry.Curry_Types.C_FuncType x3 x4 -> let s3 = s
    in s3 `seq` (let s2 = leftSupply s3
                     s4 = rightSupply s3
                     s0 = leftSupply s4
                     s1 = rightSupply s4
    in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` Curry_SetRBT.nd_C_unionRBT
    (nd_C_typeCons x3 s0 cd cs) (nd_C_typeCons x4 s1 cd cs) s2 cd cs))))
  FlatCurry.Curry_Types.C_TCons x5 x6 -> let s17 = s
    in s17 `seq` (let s16 = leftSupply s17
                      s18 = rightSupply s17
                      s2 = leftSupply s18
                      s15 = rightSupply s18
    in s16 `seq` (s18 `seq` (s2 `seq` (s15 `seq` Curry_Prelude.nd_C_apply
    (let s1 = leftSupply s2
         s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_SetRBT.nd_C_insertRBT
    s0 cd cs) x5 s1 cd cs)) (let s14 = leftSupply s15
                                 s13 = rightSupply s15
    in s14 `seq` (s13 `seq` Curry_Prelude.nd_C_apply (let s12 = leftSupply s13
                                                          s10 = rightSupply s13
    in s12 `seq` (s10 `seq` nd_C_unionMap (let s9 = leftSupply s10
                                               s11 = rightSupply s10
                                               s5 = leftSupply s11
                                               s8 = rightSupply s11
    in s9 `seq` (s11 `seq` (s5 `seq` (s8 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
    (let s4 = leftSupply s5
         s3 = rightSupply s5
    in s4 `seq` (s3 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    s3 cd cs) s4 cd cs)) (let s7 = leftSupply s8
                              s6 = rightSupply s8
    in s7 `seq` (s6 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    s6 cd cs) s7 cd cs)) s9 cd cs)))) (wrapNX id nd_C_typeCons) s12 cd cs)) x6
    s14 cd cs)) s16 cd cs))))
  FlatCurry.Curry_Types.C_ForallType x7 x8 -> let s0 = s
    in s0 `seq` nd_C_typeCons x8 s0 cd cs
  FlatCurry.Curry_Types.Choice_C_TypeExpr d i l r -> narrow d i (nd_C_typeCons l
    s cd cs) (nd_C_typeCons r s cd cs)
  FlatCurry.Curry_Types.Choices_C_TypeExpr d i xs -> narrows cs d i (\z ->
    nd_C_typeCons z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_TypeExpr d c e -> guardCons d c (nd_C_typeCons e
    s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_TypeExpr d info -> failCons d (traceFail
    "Analysis.typeCons" [show x1] info)
  _ -> failCons cd (consFail "Analysis.typeCons" (showCons x1))

d_C_initHOResult :: forall t0 . (Curry_Prelude.Curry t0) => Cover -> ConstStore
  -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)) t0
d_C_initHOResult cd cs = Curry_FiniteMap.d_C_emptyFM
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char cd
  cs) cd cs)
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char cd
  cs) cd cs) cd cs) cd cs

nd_C_initHOResult :: forall t0 . (Curry_Prelude.Curry t0) => IDSupply -> Cover
  -> ConstStore -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) t0
nd_C_initHOResult s cd cs = let s10 = s
  in s10 `seq` (let s9 = leftSupply s10
                    s7 = rightSupply s10
  in s9 `seq` (s7 `seq` Curry_FiniteMap.nd_C_emptyFM (let s6 = leftSupply s7
                                                          s8 = rightSupply s7
                                                          s2 = leftSupply s8
                                                          s5 = rightSupply s8
  in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq`
  Curry_Prelude.nd_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
  (let s1 = leftSupply s2
       s0 = rightSupply s2
  in s1 `seq` (s0 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char s0
  cd cs) s1 cd cs)) (let s4 = leftSupply s5
                         s3 = rightSupply s5
  in s4 `seq` (s3 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char s3
  cd cs) s4 cd cs)) s6 cd cs)))) s9 cd cs))

d_C_analyseHOCons :: FlatCurry.Curry_Types.C_Prog -> Cover -> ConstStore
  -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass
d_C_analyseHOCons x1 cd cs = let x2 = Curry_Prelude.d_C_filter
                                   (Curry_Prelude.d_OP_dot
                                   (Curry_Prelude.d_C_flip (acceptCs id
                                   (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                   (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                   cd cs))) (Curry_Prelude.d_C_apply
                                   (FlatCurry.Curry_Goodies.d_C_progName cd cs)
                                   x1 cd cs)) (Curry_Prelude.d_OP_dot
                                   Curry_Prelude.d_C_fst Curry_Prelude.d_C_fst
                                   cd cs) cd cs) (d_C_externalCons cd cs) cd cs
                                 x3 = Curry_Prelude.d_OP_dollar
                                   (Curry_Prelude.d_C_map d_C_consOrder)
                                   (Curry_Prelude.d_OP_dollar
                                   (Curry_Prelude.d_C_concatMap
                                   (FlatCurry.Curry_Goodies.d_C_typeConsDecls cd
                                   cs) cd cs) (Curry_Prelude.d_OP_dollar
                                   (Curry_Prelude.d_C_filter
                                   (Curry_Prelude.d_OP_dot Curry_Prelude.d_C_not
                                   (FlatCurry.Curry_Goodies.d_C_isTypeSyn cd cs)
                                   cd cs)) (Curry_Prelude.d_C_apply
                                   (FlatCurry.Curry_Goodies.d_C_progTypes cd cs)
                                   x1 cd cs) cd cs) cd cs) cd cs
  in Curry_Prelude.d_OP_dollar (Curry_FiniteMap.d_C_listToFM
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs)
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs) cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char cd
  cs) cd cs)
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char cd
  cs) cd cs) cd cs) cd cs) (Curry_Prelude.d_OP_plus_plus x2 x3 cd cs) cd cs

nd_C_analyseHOCons :: FlatCurry.Curry_Types.C_Prog -> IDSupply -> Cover
  -> ConstStore -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_ConsHOClass
nd_C_analyseHOCons x1 s cd cs = let s43 = s
  in s43 `seq` (let s8 = leftSupply s43
                    s44 = rightSupply s43
                    s19 = leftSupply s44
                    s42 = rightSupply s44
  in s8 `seq` (s44 `seq` (s19 `seq` (s42 `seq` (let x2 = let s7 = leftSupply s8
                                                             s5 = rightSupply s8
                                                      in s7 `seq` (s5 `seq`
                                                      Curry_Prelude.nd_C_filter
                                                      (let s4 = leftSupply s5
                                                           s6 = rightSupply s5
                                                           s2 = leftSupply s6
                                                           s3 = rightSupply s6
                                                      in s4 `seq` (s6 `seq`
                                                      (s2 `seq` (s3 `seq`
                                                      Curry_Prelude.nd_OP_dot
                                                      (let s0 = leftSupply s2
                                                           s1 = rightSupply s2
                                                      in s0 `seq` (s1 `seq`
                                                      wrapNX id
                                                      (Curry_Prelude.nd_C_flip
                                                      (wrapDX (wrapNX id)
                                                      (acceptCs id
                                                      (Curry_Prelude.nd_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                                      (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                                      s0 cd cs))))
                                                      (Curry_Prelude.nd_C_apply
                                                      (wrapDX id
                                                      (FlatCurry.Curry_Goodies.d_C_progName
                                                      cd cs)) x1 s1 cd cs))))
                                                      (Curry_Prelude.nd_OP_dot
                                                      (wrapDX id
                                                      Curry_Prelude.d_C_fst)
                                                      (wrapDX id
                                                      Curry_Prelude.d_C_fst) s3
                                                      cd cs) s4 cd cs))))
                                                      (d_C_externalCons cd cs)
                                                      s7 cd cs)
                                                    x3 = let s18 = leftSupply
                                                               s19
                                                             s16 = rightSupply
                                                               s19
                                                      in s18 `seq` (s16 `seq`
                                                      Curry_Prelude.nd_OP_dollar
                                                      (wrapNX id
                                                      (Curry_Prelude.nd_C_map
                                                      (wrapDX id
                                                      d_C_consOrder)))
                                                      (let s15 = leftSupply s16
                                                           s17 = rightSupply s16
                                                           s9 = leftSupply s17
                                                           s13 = rightSupply s17
                                                      in s15 `seq` (s17 `seq`
                                                      (s9 `seq` (s13 `seq`
                                                      Curry_Prelude.nd_OP_dollar
                                                      (Curry_Prelude.nd_C_concatMap
                                                      (wrapDX id
                                                      (FlatCurry.Curry_Goodies.d_C_typeConsDecls
                                                      cd cs)) s9 cd cs)
                                                      (let s12 = leftSupply s13
                                                           s14 = rightSupply s13
                                                           s10 = leftSupply s14
                                                           s11 = rightSupply s14
                                                      in s12 `seq` (s14 `seq`
                                                      (s10 `seq` (s11 `seq`
                                                      Curry_Prelude.nd_OP_dollar
                                                      (wrapNX id
                                                      (Curry_Prelude.nd_C_filter
                                                      (Curry_Prelude.nd_OP_dot
                                                      (wrapDX id
                                                      Curry_Prelude.d_C_not)
                                                      (wrapDX id
                                                      (FlatCurry.Curry_Goodies.d_C_isTypeSyn
                                                      cd cs)) s10 cd cs)))
                                                      (Curry_Prelude.nd_C_apply
                                                      (wrapDX id
                                                      (FlatCurry.Curry_Goodies.d_C_progTypes
                                                      cd cs)) x1 s11 cd cs) s12
                                                      cd cs)))) s15 cd cs))))
                                                      s18 cd cs)
  in let s41 = leftSupply s42
         s39 = rightSupply s42
  in s41 `seq` (s39 `seq` Curry_Prelude.nd_OP_dollar (let s38 = leftSupply s39
                                                          s40 = rightSupply s39
                                                          s27 = leftSupply s40
                                                          s36 = rightSupply s40
  in s38 `seq` (s40 `seq` (s27 `seq` (s36 `seq` Curry_FiniteMap.nd_C_listToFM
  (let s26 = leftSupply s27
       s28 = rightSupply s27
       s22 = leftSupply s28
       s25 = rightSupply s28
  in s26 `seq` (s28 `seq` (s22 `seq` (s25 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
  (let s21 = leftSupply s22
       s20 = rightSupply s22
  in s21 `seq` (s20 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char s20
  cd cs) s21 cd cs)) (let s24 = leftSupply s25
                          s23 = rightSupply s25
  in s24 `seq` (s23 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char s23
  cd cs) s24 cd cs)) s26 cd cs)))) (let s35 = leftSupply s36
                                        s37 = rightSupply s36
                                        s31 = leftSupply s37
                                        s34 = rightSupply s37
  in s35 `seq` (s37 `seq` (s31 `seq` (s34 `seq`
  Curry_Prelude.nd_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
  (let s30 = leftSupply s31
       s29 = rightSupply s31
  in s30 `seq` (s29 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  s29 cd cs) s30 cd cs)) (let s33 = leftSupply s34
                              s32 = rightSupply s34
  in s33 `seq` (s32 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  s32 cd cs) s33 cd cs)) s35 cd cs)))) s38 cd cs))))
  (Curry_Prelude.d_OP_plus_plus x2 x3 cd cs) s41 cd cs))))))

d_C_externalCons :: Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass)
d_C_externalCons cd cs = Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple2
  (d_C_successType cd cs) Curry_Classification.C_ConsFO) Curry_Prelude.OP_List

d_C_consOrder :: FlatCurry.Curry_Types.C_ConsDecl -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass
d_C_consOrder x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_Cons x2 x3 x4 x5 -> let x6 = Curry_Prelude.d_OP_dollar
                                                    Curry_Classification.d_C_typeToConsHOClass
                                                    (Curry_Classification.d_C_maximumTypeHOClass
                                                    (Curry_Prelude.d_C_map
                                                    d_C_classifyHOType x5 cd cs)
                                                    cd cs) cd cs
    in Curry_Prelude.OP_Tuple2 x2 x6
  FlatCurry.Curry_Types.Choice_C_ConsDecl d i l r -> narrow d i (d_C_consOrder l
    cd cs) (d_C_consOrder r cd cs)
  FlatCurry.Curry_Types.Choices_C_ConsDecl d i xs -> narrows cs d i (\z ->
    d_C_consOrder z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_ConsDecl d c e -> guardCons d c (d_C_consOrder e
    cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_ConsDecl d info -> failCons d (traceFail
    "Analysis.consOrder" [show x1] info)
  _ -> failCons cd (consFail "Analysis.consOrder" (showCons x1))

d_C_analyseHOFunc :: FlatCurry.Curry_Types.C_Prog -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass -> Cover -> ConstStore
  -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_FuncHOClass
d_C_analyseHOFunc x1 x2 cd cs = Curry_Prelude.d_OP_dollar
  (Curry_FiniteMap.d_C_listToFM
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs)
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs) cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char cd
  cs) cd cs)
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char cd
  cs) cd cs) cd cs) cd cs) (Curry_Prelude.d_C_map
  (d_OP_analyseHOFunc_dot_analyse_dot_183 x2) (Curry_Prelude.d_C_apply
  (FlatCurry.Curry_Goodies.d_C_progFuncs cd cs) x1 cd cs) cd cs) cd cs

nd_C_analyseHOFunc :: FlatCurry.Curry_Types.C_Prog -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass -> IDSupply -> Cover -> ConstStore
  -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_FuncHOClass
nd_C_analyseHOFunc x1 x2 s cd cs = let s25 = s
  in s25 `seq` (let s24 = leftSupply s25
                    s26 = rightSupply s25
                    s19 = leftSupply s26
                    s23 = rightSupply s26
  in s24 `seq` (s26 `seq` (s19 `seq` (s23 `seq` Curry_Prelude.nd_OP_dollar
  (let s18 = leftSupply s19
       s20 = rightSupply s19
       s7 = leftSupply s20
       s16 = rightSupply s20
  in s18 `seq` (s20 `seq` (s7 `seq` (s16 `seq` Curry_FiniteMap.nd_C_listToFM
  (let s6 = leftSupply s7
       s8 = rightSupply s7
       s2 = leftSupply s8
       s5 = rightSupply s8
  in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
  (let s1 = leftSupply s2
       s0 = rightSupply s2
  in s1 `seq` (s0 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char s0
  cd cs) s1 cd cs)) (let s4 = leftSupply s5
                         s3 = rightSupply s5
  in s4 `seq` (s3 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char s3
  cd cs) s4 cd cs)) s6 cd cs)))) (let s15 = leftSupply s16
                                      s17 = rightSupply s16
                                      s11 = leftSupply s17
                                      s14 = rightSupply s17
  in s15 `seq` (s17 `seq` (s11 `seq` (s14 `seq`
  Curry_Prelude.nd_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
  (let s10 = leftSupply s11
       s9 = rightSupply s11
  in s10 `seq` (s9 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char s9
  cd cs) s10 cd cs)) (let s13 = leftSupply s14
                          s12 = rightSupply s14
  in s13 `seq` (s12 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
  s12 cd cs) s13 cd cs)) s15 cd cs)))) s18 cd cs)))) (let s22 = leftSupply s23
                                                          s21 = rightSupply s23
  in s22 `seq` (s21 `seq` Curry_Prelude.nd_C_map (wrapNX id
  (nd_OP_analyseHOFunc_dot_analyse_dot_183 x2)) (Curry_Prelude.nd_C_apply
  (wrapDX id (FlatCurry.Curry_Goodies.d_C_progFuncs cd cs)) x1 s21 cd cs) s22 cd
  cs)) s24 cd cs))))

d_OP_analyseHOFunc_dot_analyse_dot_183 :: Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass -> FlatCurry.Curry_Types.C_FuncDecl
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_FuncHOClass
d_OP_analyseHOFunc_dot_analyse_dot_183 x1 x2 cd cs = Curry_Prelude.OP_Tuple2
  (Curry_Prelude.d_C_apply (FlatCurry.Curry_Goodies.d_C_funcName cd cs) x2 cd
  cs) (d_C_isHOFunc x1 (Curry_Prelude.d_C_apply
  (FlatCurry.Curry_Goodies.d_C_funcArity cd cs) x2 cd cs)
  (Curry_Prelude.d_C_apply (FlatCurry.Curry_Goodies.d_C_funcType cd cs) x2 cd
  cs) cd cs)

nd_OP_analyseHOFunc_dot_analyse_dot_183 :: Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass -> FlatCurry.Curry_Types.C_FuncDecl
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_FuncHOClass
nd_OP_analyseHOFunc_dot_analyse_dot_183 x1 x2 s cd cs = let s6 = s
  in s6 `seq` (let s0 = leftSupply s6
                   s4 = rightSupply s6
  in s0 `seq` (s4 `seq` Curry_Prelude.OP_Tuple2 (Curry_Prelude.nd_C_apply
  (wrapDX id (FlatCurry.Curry_Goodies.d_C_funcName cd cs)) x2 s0 cd cs)
  (let s3 = leftSupply s4
       s5 = rightSupply s4
       s1 = leftSupply s5
       s2 = rightSupply s5
  in s3 `seq` (s5 `seq` (s1 `seq` (s2 `seq` nd_C_isHOFunc x1
  (Curry_Prelude.nd_C_apply (wrapDX id (FlatCurry.Curry_Goodies.d_C_funcArity cd
  cs)) x2 s1 cd cs) (Curry_Prelude.nd_C_apply (wrapDX id
  (FlatCurry.Curry_Goodies.d_C_funcType cd cs)) x2 s2 cd cs) s3 cd cs))))))

d_C_isHOFunc :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_TypeHOClass
  -> Curry_Prelude.C_Int -> FlatCurry.Curry_Types.C_TypeExpr -> Cover
  -> ConstStore -> Curry_Classification.C_FuncHOClass
d_C_isHOFunc x1 x2 x3 cd cs = d_C__case_7 x2 x3 x1
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
  x2 (Curry_Prelude.C_Int (0)) cd cs) cd cs

nd_C_isHOFunc :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_TypeHOClass
  -> Curry_Prelude.C_Int -> FlatCurry.Curry_Types.C_TypeExpr -> IDSupply
  -> Cover -> ConstStore -> Curry_Classification.C_FuncHOClass
nd_C_isHOFunc x1 x2 x3 s cd cs = let s0 = s
  in s0 `seq` nd_C__case_7 x2 x3 x1
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
  x2 (Curry_Prelude.C_Int (0)) cd cs) s0 cd cs

d_C_isHOType :: Curry_Prelude.C_Bool -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass -> FlatCurry.Curry_Types.C_TypeExpr
  -> Cover -> ConstStore -> Curry_Classification.C_FuncHOClass
d_C_isHOType x1 x2 x3 cd cs = case x3 of
  FlatCurry.Curry_Types.C_TVar x4 -> Curry_Classification.C_FuncFO
  FlatCurry.Curry_Types.C_FuncType x5 x6 -> Curry_Classification.C_FuncHO
  FlatCurry.Curry_Types.C_TCons x7 x8 -> Curry_Prelude.d_OP_dollar
    Curry_Classification.d_C_maximumFuncHOClass (Curry_Prelude.OP_Cons
    (Curry_Classification.d_C_typeToFuncHOClass x1 (d_C_getHOResult x7 x2 cd cs)
    cd cs) (Curry_Prelude.d_C_map (d_C_isHOType x1 x2) x8 cd cs)) cd cs
  FlatCurry.Curry_Types.C_ForallType x9 x10 -> d_C_isHOType x1 x2 x10 cd cs
  FlatCurry.Curry_Types.Choice_C_TypeExpr d i l r -> narrow d i (d_C_isHOType x1
    x2 l cd cs) (d_C_isHOType x1 x2 r cd cs)
  FlatCurry.Curry_Types.Choices_C_TypeExpr d i xs -> narrows cs d i (\z ->
    d_C_isHOType x1 x2 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_TypeExpr d c e -> guardCons d c (d_C_isHOType x1
    x2 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_TypeExpr d info -> failCons d (traceFail
    "Analysis.isHOType" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "Analysis.isHOType" (showCons x3))

nd_C_isHOType :: Curry_Prelude.C_Bool -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass -> FlatCurry.Curry_Types.C_TypeExpr
  -> IDSupply -> Cover -> ConstStore -> Curry_Classification.C_FuncHOClass
nd_C_isHOType x1 x2 x3 s cd cs = case x3 of
  FlatCurry.Curry_Types.C_TVar x4 -> Curry_Classification.C_FuncFO
  FlatCurry.Curry_Types.C_FuncType x5 x6 -> Curry_Classification.C_FuncHO
  FlatCurry.Curry_Types.C_TCons x7 x8 -> let s4 = s
    in s4 `seq` (let s3 = leftSupply s4
                     s2 = rightSupply s4
    in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dollar (wrapDX id
    Curry_Classification.d_C_maximumFuncHOClass) (let s0 = leftSupply s2
                                                      s1 = rightSupply s2
    in s0 `seq` (s1 `seq` Curry_Prelude.OP_Cons
    (Curry_Classification.d_C_typeToFuncHOClass x1 (nd_C_getHOResult x7 x2 s0 cd
    cs) cd cs) (Curry_Prelude.nd_C_map (wrapNX id (nd_C_isHOType x1 x2)) x8 s1
    cd cs))) s3 cd cs))
  FlatCurry.Curry_Types.C_ForallType x9 x10 -> let s0 = s
    in s0 `seq` nd_C_isHOType x1 x2 x10 s0 cd cs
  FlatCurry.Curry_Types.Choice_C_TypeExpr d i l r -> narrow d i (nd_C_isHOType
    x1 x2 l s cd cs) (nd_C_isHOType x1 x2 r s cd cs)
  FlatCurry.Curry_Types.Choices_C_TypeExpr d i xs -> narrows cs d i (\z ->
    nd_C_isHOType x1 x2 z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_TypeExpr d c e -> guardCons d c (nd_C_isHOType
    x1 x2 e s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_TypeExpr d info -> failCons d (traceFail
    "Analysis.isHOType" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "Analysis.isHOType" (showCons x3))

d_C_splitFuncType :: FlatCurry.Curry_Types.C_TypeExpr -> Cover -> ConstStore
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_TypeExpr
d_C_splitFuncType x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_TVar x2 -> Curry_Prelude.OP_Cons x1
    Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_FuncType x3 x4 -> Curry_Prelude.OP_Cons x3
    (d_C_splitFuncType x4 cd cs)
  FlatCurry.Curry_Types.C_TCons x5 x6 -> Curry_Prelude.OP_Cons x1
    Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_ForallType x7 x8 -> Curry_Prelude.OP_Cons x1
    Curry_Prelude.OP_List
  FlatCurry.Curry_Types.Choice_C_TypeExpr d i l r -> narrow d i
    (d_C_splitFuncType l cd cs) (d_C_splitFuncType r cd cs)
  FlatCurry.Curry_Types.Choices_C_TypeExpr d i xs -> narrows cs d i (\z ->
    d_C_splitFuncType z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_TypeExpr d c e -> guardCons d c
    (d_C_splitFuncType e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_TypeExpr d info -> failCons d (traceFail
    "Analysis.splitFuncType" [show x1] info)
  _ -> failCons cd (consFail "Analysis.splitFuncType" (showCons x1))

d_C_getPrivateFunc :: C_Visibilities -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_getPrivateFunc x1 cd cs = case x1 of
  C_Vis x2 x3 x4 -> d_C__case_2 x2 cd cs
  Choice_C_Visibilities d i l r -> narrow d i (d_C_getPrivateFunc l cd cs)
    (d_C_getPrivateFunc r cd cs)
  Choices_C_Visibilities d i xs -> narrows cs d i (\z -> d_C_getPrivateFunc z cd
    cs) xs
  Guard_C_Visibilities d c e -> guardCons d c (d_C_getPrivateFunc e cd $! addCs
    c cs)
  Fail_C_Visibilities d info -> failCons d (traceFail "Analysis.getPrivateFunc"
    [show x1] info)
  _ -> failCons cd (consFail "Analysis.getPrivateFunc" (showCons x1))

d_C_getPrivateType :: C_Visibilities -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_getPrivateType x1 cd cs = case x1 of
  C_Vis x2 x3 x4 -> d_C__case_1 x3 cd cs
  Choice_C_Visibilities d i l r -> narrow d i (d_C_getPrivateType l cd cs)
    (d_C_getPrivateType r cd cs)
  Choices_C_Visibilities d i xs -> narrows cs d i (\z -> d_C_getPrivateType z cd
    cs) xs
  Guard_C_Visibilities d c e -> guardCons d c (d_C_getPrivateType e cd $! addCs
    c cs)
  Fail_C_Visibilities d info -> failCons d (traceFail "Analysis.getPrivateType"
    [show x1] info)
  _ -> failCons cd (consFail "Analysis.getPrivateType" (showCons x1))

d_C_getPrivateCons :: C_Visibilities -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_getPrivateCons x1 cd cs = case x1 of
  C_Vis x2 x3 x4 -> d_C__case_0 x4 cd cs
  Choice_C_Visibilities d i l r -> narrow d i (d_C_getPrivateCons l cd cs)
    (d_C_getPrivateCons r cd cs)
  Choices_C_Visibilities d i xs -> narrows cs d i (\z -> d_C_getPrivateCons z cd
    cs) xs
  Guard_C_Visibilities d c e -> guardCons d c (d_C_getPrivateCons e cd $! addCs
    c cs)
  Fail_C_Visibilities d info -> failCons d (traceFail "Analysis.getPrivateCons"
    [show x1] info)
  _ -> failCons cd (consFail "Analysis.getPrivateCons" (showCons x1))

d_C_analyzeVisibility :: FlatCurry.Curry_Types.C_Prog -> Cover -> ConstStore
  -> C_Visibilities
d_C_analyzeVisibility x1 cd cs = let x2 = Curry_Prelude.d_C_apply
                                       (FlatCurry.Curry_Goodies.d_C_progTypes cd
                                       cs) x1 cd cs
  in C_Vis (d_C_splitVisibleFuncs (Curry_Prelude.d_C_apply
  (FlatCurry.Curry_Goodies.d_C_progFuncs cd cs) x1 cd cs) cd cs)
  (d_C_splitVisibleTypes x2 cd cs) (d_C_splitVisibleCons
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_concatMap
  (FlatCurry.Curry_Goodies.d_C_typeConsDecls cd cs) cd cs)
  (Curry_Prelude.d_C_filter (Curry_Prelude.d_OP_dot Curry_Prelude.d_C_not
  (FlatCurry.Curry_Goodies.d_C_isTypeSyn cd cs) cd cs) x2 cd cs) cd cs) cd cs)

d_C_splitVisibleFuncs :: Curry_Prelude.OP_List FlatCurry.Curry_Types.C_FuncDecl
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_C_splitVisibleFuncs x1 cd cs = let x2 = Curry_List.d_C_partition
                                       d_OP_splitVisibleFuncs_dot_uscore_hash_lambda8
                                       x1 cd cs
                                     x3 = d_OP_splitVisibleFuncs_dot_uscore_hash_selFP2_hash_pubs
                                       x2 cd cs
                                     x4 = d_OP_splitVisibleFuncs_dot_uscore_hash_selFP3_hash_privs
                                       x2 cd cs
  in Curry_Prelude.OP_Tuple2 (Curry_Prelude.d_C_map
  (FlatCurry.Curry_Goodies.d_C_funcName cd cs) x3 cd cs) (Curry_Prelude.d_C_map
  (FlatCurry.Curry_Goodies.d_C_funcName cd cs) x4 cd cs)

d_OP_splitVisibleFuncs_dot_uscore_hash_lambda8 :: FlatCurry.Curry_Types.C_FuncDecl
  -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_OP_splitVisibleFuncs_dot_uscore_hash_lambda8 x1 cd cs =
  FlatCurry.Curry_Types.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_FlatCurry_dot_Types_dot_Visibility
  (Curry_Prelude.d_C_apply (FlatCurry.Curry_Goodies.d_C_funcVisibility cd cs) x1
  cd cs) FlatCurry.Curry_Types.C_Public cd cs

d_OP_splitVisibleFuncs_dot_uscore_hash_selFP2_hash_pubs :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List FlatCurry.Curry_Types.C_FuncDecl)
  (Curry_Prelude.OP_List FlatCurry.Curry_Types.C_FuncDecl) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_FuncDecl
d_OP_splitVisibleFuncs_dot_uscore_hash_selFP2_hash_pubs x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitVisibleFuncs_dot_uscore_hash_selFP2_hash_pubs l cd cs)
    (d_OP_splitVisibleFuncs_dot_uscore_hash_selFP2_hash_pubs r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitVisibleFuncs_dot_uscore_hash_selFP2_hash_pubs z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_splitVisibleFuncs_dot_uscore_hash_selFP2_hash_pubs e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Analysis.splitVisibleFuncs._#selFP2#pubs" [show x1] info)
  _ -> failCons cd (consFail "Analysis.splitVisibleFuncs._#selFP2#pubs"
    (showCons x1))

d_OP_splitVisibleFuncs_dot_uscore_hash_selFP3_hash_privs :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List FlatCurry.Curry_Types.C_FuncDecl)
  (Curry_Prelude.OP_List FlatCurry.Curry_Types.C_FuncDecl) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_FuncDecl
d_OP_splitVisibleFuncs_dot_uscore_hash_selFP3_hash_privs x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitVisibleFuncs_dot_uscore_hash_selFP3_hash_privs l cd cs)
    (d_OP_splitVisibleFuncs_dot_uscore_hash_selFP3_hash_privs r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitVisibleFuncs_dot_uscore_hash_selFP3_hash_privs z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_splitVisibleFuncs_dot_uscore_hash_selFP3_hash_privs e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Analysis.splitVisibleFuncs._#selFP3#privs" [show x1] info)
  _ -> failCons cd (consFail "Analysis.splitVisibleFuncs._#selFP3#privs"
    (showCons x1))

d_C_splitVisibleTypes :: Curry_Prelude.OP_List FlatCurry.Curry_Types.C_TypeDecl
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_C_splitVisibleTypes x1 cd cs = let x2 = Curry_List.d_C_partition
                                       d_OP_splitVisibleTypes_dot_uscore_hash_lambda9
                                       x1 cd cs
                                     x3 = d_OP_splitVisibleTypes_dot_uscore_hash_selFP5_hash_pubs
                                       x2 cd cs
                                     x4 = d_OP_splitVisibleTypes_dot_uscore_hash_selFP6_hash_privs
                                       x2 cd cs
  in Curry_Prelude.OP_Tuple2 (Curry_Prelude.d_C_map
  (FlatCurry.Curry_Goodies.d_C_typeName cd cs) x3 cd cs) (Curry_Prelude.d_C_map
  (FlatCurry.Curry_Goodies.d_C_typeName cd cs) x4 cd cs)

d_OP_splitVisibleTypes_dot_uscore_hash_lambda9 :: FlatCurry.Curry_Types.C_TypeDecl
  -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_OP_splitVisibleTypes_dot_uscore_hash_lambda9 x1 cd cs =
  FlatCurry.Curry_Types.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_FlatCurry_dot_Types_dot_Visibility
  (Curry_Prelude.d_C_apply (FlatCurry.Curry_Goodies.d_C_typeVisibility cd cs) x1
  cd cs) FlatCurry.Curry_Types.C_Public cd cs

d_OP_splitVisibleTypes_dot_uscore_hash_selFP5_hash_pubs :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List FlatCurry.Curry_Types.C_TypeDecl)
  (Curry_Prelude.OP_List FlatCurry.Curry_Types.C_TypeDecl) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_TypeDecl
d_OP_splitVisibleTypes_dot_uscore_hash_selFP5_hash_pubs x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitVisibleTypes_dot_uscore_hash_selFP5_hash_pubs l cd cs)
    (d_OP_splitVisibleTypes_dot_uscore_hash_selFP5_hash_pubs r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitVisibleTypes_dot_uscore_hash_selFP5_hash_pubs z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_splitVisibleTypes_dot_uscore_hash_selFP5_hash_pubs e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Analysis.splitVisibleTypes._#selFP5#pubs" [show x1] info)
  _ -> failCons cd (consFail "Analysis.splitVisibleTypes._#selFP5#pubs"
    (showCons x1))

d_OP_splitVisibleTypes_dot_uscore_hash_selFP6_hash_privs :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List FlatCurry.Curry_Types.C_TypeDecl)
  (Curry_Prelude.OP_List FlatCurry.Curry_Types.C_TypeDecl) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_TypeDecl
d_OP_splitVisibleTypes_dot_uscore_hash_selFP6_hash_privs x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitVisibleTypes_dot_uscore_hash_selFP6_hash_privs l cd cs)
    (d_OP_splitVisibleTypes_dot_uscore_hash_selFP6_hash_privs r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitVisibleTypes_dot_uscore_hash_selFP6_hash_privs z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_splitVisibleTypes_dot_uscore_hash_selFP6_hash_privs e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Analysis.splitVisibleTypes._#selFP6#privs" [show x1] info)
  _ -> failCons cd (consFail "Analysis.splitVisibleTypes._#selFP6#privs"
    (showCons x1))

d_C_splitVisibleCons :: Curry_Prelude.OP_List FlatCurry.Curry_Types.C_ConsDecl
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_C_splitVisibleCons x1 cd cs = let x2 = Curry_List.d_C_partition
                                      d_OP_splitVisibleCons_dot_uscore_hash_lambda10
                                      x1 cd cs
                                    x3 = d_OP_splitVisibleCons_dot_uscore_hash_selFP8_hash_pubs
                                      x2 cd cs
                                    x4 = d_OP_splitVisibleCons_dot_uscore_hash_selFP9_hash_privs
                                      x2 cd cs
  in Curry_Prelude.OP_Tuple2 (Curry_Prelude.d_C_map
  (FlatCurry.Curry_Goodies.d_C_consName cd cs) x3 cd cs) (Curry_Prelude.d_C_map
  (FlatCurry.Curry_Goodies.d_C_consName cd cs) x4 cd cs)

d_OP_splitVisibleCons_dot_uscore_hash_lambda10 :: FlatCurry.Curry_Types.C_ConsDecl
  -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_OP_splitVisibleCons_dot_uscore_hash_lambda10 x1 cd cs =
  FlatCurry.Curry_Types.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_FlatCurry_dot_Types_dot_Visibility
  (Curry_Prelude.d_C_apply (FlatCurry.Curry_Goodies.d_C_consVisibility cd cs) x1
  cd cs) FlatCurry.Curry_Types.C_Public cd cs

d_OP_splitVisibleCons_dot_uscore_hash_selFP8_hash_pubs :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List FlatCurry.Curry_Types.C_ConsDecl)
  (Curry_Prelude.OP_List FlatCurry.Curry_Types.C_ConsDecl) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_ConsDecl
d_OP_splitVisibleCons_dot_uscore_hash_selFP8_hash_pubs x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitVisibleCons_dot_uscore_hash_selFP8_hash_pubs l cd cs)
    (d_OP_splitVisibleCons_dot_uscore_hash_selFP8_hash_pubs r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitVisibleCons_dot_uscore_hash_selFP8_hash_pubs z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_splitVisibleCons_dot_uscore_hash_selFP8_hash_pubs e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Analysis.splitVisibleCons._#selFP8#pubs" [show x1] info)
  _ -> failCons cd (consFail "Analysis.splitVisibleCons._#selFP8#pubs" (showCons
    x1))

d_OP_splitVisibleCons_dot_uscore_hash_selFP9_hash_privs :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List FlatCurry.Curry_Types.C_ConsDecl)
  (Curry_Prelude.OP_List FlatCurry.Curry_Types.C_ConsDecl) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_ConsDecl
d_OP_splitVisibleCons_dot_uscore_hash_selFP9_hash_privs x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitVisibleCons_dot_uscore_hash_selFP9_hash_privs l cd cs)
    (d_OP_splitVisibleCons_dot_uscore_hash_selFP9_hash_privs r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitVisibleCons_dot_uscore_hash_selFP9_hash_privs z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_splitVisibleCons_dot_uscore_hash_selFP9_hash_privs e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Analysis.splitVisibleCons._#selFP9#privs" [show x1] info)
  _ -> failCons cd (consFail "Analysis.splitVisibleCons._#selFP9#privs"
    (showCons x1))

d_C_qmark :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_qmark cd cs = Curry_Prelude.d_C_apply (Curry_Names.d_C_renameQName cd cs)
  (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_prelude cd cs)
  (Curry_Prelude.toCurryString "?")) cd cs

d_C_successType :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_successType cd cs = Curry_Prelude.d_C_apply (Curry_Names.d_C_renameQName cd
  cs) (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_prelude cd cs)
  (Curry_Prelude.toCurryString "Success")) cd cs

d_C_ioType :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_ioType cd cs = Curry_Prelude.d_C_apply (Curry_Names.d_C_renameQName cd cs)
  (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_prelude cd cs)
  (Curry_Prelude.toCurryString "IO")) cd cs

d_C_empty :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> Cover -> ConstStore
  -> Curry_RedBlackTree.C_RedBlackTree t0
d_C_empty x1 cd cs = Curry_Prelude.d_C_apply (Curry_SetRBT.d_C_emptySetRBT
  (Curry_Prelude.d_OP_uscore_super_hash_Prelude_dot_Ord_hash_Prelude_dot_Eq x1
  cd cs) cd cs) (Curry_Prelude.d_OP_lt_eq x1 cd cs) cd cs

nd_C_empty :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> IDSupply -> Cover
  -> ConstStore -> Curry_RedBlackTree.C_RedBlackTree t0
nd_C_empty x1 s cd cs = let s5 = s
  in s5 `seq` (let s4 = leftSupply s5
                   s6 = rightSupply s5
                   s2 = leftSupply s6
                   s3 = rightSupply s6
  in s4 `seq` (s6 `seq` (s2 `seq` (s3 `seq` Curry_Prelude.nd_C_apply
  (let s1 = leftSupply s2
       s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_SetRBT.nd_C_emptySetRBT
  (Curry_Prelude.nd_OP_uscore_super_hash_Prelude_dot_Ord_hash_Prelude_dot_Eq x1
  s0 cd cs) s1 cd cs)) (Curry_Prelude.nd_OP_lt_eq x1 s3 cd cs) s4 cd cs))))

d_C_unionMap :: forall t1 t0 . (Curry_Prelude.Curry t0, Curry_Prelude.Curry
  t1) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> (t1 -> Cover -> ConstStore
  -> Curry_RedBlackTree.C_RedBlackTree t0) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t1 -> Cover -> ConstStore
  -> Curry_RedBlackTree.C_RedBlackTree t0
d_C_unionMap x1 x2 cd cs = Curry_Prelude.d_OP_dot (Curry_Prelude.d_C_foldr
  (acceptCs id Curry_SetRBT.d_C_unionRBT) (d_C_empty x1 cd cs))
  (Curry_Prelude.d_C_map x2) cd cs

nd_C_unionMap :: forall t1 t0 . (Curry_Prelude.Curry t0, Curry_Prelude.Curry
  t1) => Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> Func t1
  (Curry_RedBlackTree.C_RedBlackTree t0) -> IDSupply -> Cover -> ConstStore
  -> Func (Curry_Prelude.OP_List t1) (Curry_RedBlackTree.C_RedBlackTree t0)
nd_C_unionMap x1 x2 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (wrapNX id
  (Curry_Prelude.nd_C_foldr (wrapDX (wrapNX id) (acceptCs id
  Curry_SetRBT.nd_C_unionRBT)) (nd_C_empty x1 s0 cd cs))) (wrapNX id
  (Curry_Prelude.nd_C_map x2)) s1 cd cs))

d_C_toList :: forall t0 . (Curry_Prelude.Curry t0) => Cover -> ConstStore
  -> Curry_RedBlackTree.C_RedBlackTree t0 -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0
d_C_toList cd cs = Curry_SetRBT.d_C_setRBT2list cd cs

nd_C_toList :: forall t0 . (Curry_Prelude.Curry t0) => IDSupply -> Cover
  -> ConstStore -> Func (Curry_RedBlackTree.C_RedBlackTree t0)
  (Curry_Prelude.OP_List t0)
nd_C_toList s cd cs = let s0 = s
  in s0 `seq` Curry_SetRBT.nd_C_setRBT2list s0 cd cs

d_C__case_0 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_0 x4 cd cs = case x4 of
  Curry_Prelude.OP_Tuple2 x5 x6 -> x6
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C__case_0 l cd cs)
    (d_C__case_0 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C__case_0 z
    cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C__case_0 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Analysis._case_0" [show x4] info)
  _ -> failCons cd (consFail "Analysis._case_0" (showCons x4))

d_C__case_1 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_1 x3 cd cs = case x3 of
  Curry_Prelude.OP_Tuple2 x5 x6 -> x6
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C__case_1 l cd cs)
    (d_C__case_1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C__case_1 z
    cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C__case_1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Analysis._case_1" [show x3] info)
  _ -> failCons cd (consFail "Analysis._case_1" (showCons x3))

d_C__case_2 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_2 x2 cd cs = case x2 of
  Curry_Prelude.OP_Tuple2 x5 x6 -> x6
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C__case_2 l cd cs)
    (d_C__case_2 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C__case_2 z
    cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C__case_2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Analysis._case_2" [show x2] info)
  _ -> failCons cd (consFail "Analysis._case_2" (showCons x2))

d_C__case_7 :: Curry_Prelude.C_Int -> FlatCurry.Curry_Types.C_TypeExpr
  -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Classification.C_FuncHOClass
d_C__case_7 x2 x3 x1 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> d_C__case_6 x3 x1 (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_reverse cd cs) (d_C_splitFuncType x3 cd cs) cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_4 x3 x2 x1 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_7 x2 x3 x1 l cd
    cs) (d_C__case_7 x2 x3 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_7 x2 x3
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_7 x2 x3 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Analysis._case_7"
    [show x2, show x3, show x1, show x4] info)
  _ -> failCons cd (consFail "Analysis._case_7" (showCons x4))

nd_C__case_7 :: Curry_Prelude.C_Int -> FlatCurry.Curry_Types.C_TypeExpr
  -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass -> Curry_Prelude.C_Bool -> IDSupply
  -> Cover -> ConstStore -> Curry_Classification.C_FuncHOClass
nd_C__case_7 x2 x3 x1 x4 s cd cs = case x4 of
  Curry_Prelude.C_True -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_C__case_6 x3 x1 (Curry_Prelude.nd_C_apply (wrapDX
    id (Curry_Prelude.d_C_reverse cd cs)) (d_C_splitFuncType x3 cd cs) s0 cd cs)
    s1 cd cs))
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_4 x3 x2 x1 (Curry_Prelude.d_C_otherwise cd cs) s0 cd
    cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_7 x2 x3 x1 l s
    cd cs) (nd_C__case_7 x2 x3 x1 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_7 x2
    x3 x1 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_7 x2 x3 x1 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Analysis._case_7"
    [show x2, show x3, show x1, show x4] info)
  _ -> failCons cd (consFail "Analysis._case_7" (showCons x4))

d_C__case_4 :: FlatCurry.Curry_Types.C_TypeExpr -> Curry_Prelude.C_Int
  -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Classification.C_FuncHOClass
d_C__case_4 x3 x2 x1 x8 cd cs = case x8 of
  Curry_Prelude.C_True -> let x7 = Curry_Prelude.d_C_error
                                (Curry_Prelude.toCurryString
                                "Analysis.isHOFunc") cd cs
    in d_C__case_3 x7 x2 x1 x3 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_4 x3 x2 x1 l cd
    cs) (d_C__case_4 x3 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_4 x3 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_4 x3 x2 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Analysis._case_4"
    [show x3, show x2, show x1, show x8] info)
  _ -> failCons cd (consFail "Analysis._case_4" (showCons x8))

nd_C__case_4 :: FlatCurry.Curry_Types.C_TypeExpr -> Curry_Prelude.C_Int
  -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass -> Curry_Prelude.C_Bool -> IDSupply
  -> Cover -> ConstStore -> Curry_Classification.C_FuncHOClass
nd_C__case_4 x3 x2 x1 x8 s cd cs = case x8 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` (let x7 = Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
                       "Analysis.isHOFunc") cd cs
    in nd_C__case_3 x7 x2 x1 x3 s0 cd cs)
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_4 x3 x2 x1 l s
    cd cs) (nd_C__case_4 x3 x2 x1 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_4 x3
    x2 x1 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_4 x3 x2 x1 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Analysis._case_4"
    [show x3, show x2, show x1, show x8] info)
  _ -> failCons cd (consFail "Analysis._case_4" (showCons x8))

d_C__case_3 :: Curry_Classification.C_FuncHOClass -> Curry_Prelude.C_Int
  -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass -> FlatCurry.Curry_Types.C_TypeExpr
  -> Cover -> ConstStore -> Curry_Classification.C_FuncHOClass
d_C__case_3 x7 x2 x1 x3 cd cs = case x3 of
  FlatCurry.Curry_Types.C_FuncType x8 x9 -> Curry_Classification.d_C_maxFuncHOClass
    (d_C_isHOType Curry_Prelude.C_True x1 x8 cd cs) (d_C_isHOFunc x1
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x2 (Curry_Prelude.C_Int (1)) cd cs) x9 cd cs) cd cs
  FlatCurry.Curry_Types.C_TVar x10 -> x7
  FlatCurry.Curry_Types.C_TCons x11 x12 -> x7
  FlatCurry.Curry_Types.C_ForallType x13 x14 -> x7
  FlatCurry.Curry_Types.Choice_C_TypeExpr d i l r -> narrow d i (d_C__case_3 x7
    x2 x1 l cd cs) (d_C__case_3 x7 x2 x1 r cd cs)
  FlatCurry.Curry_Types.Choices_C_TypeExpr d i xs -> narrows cs d i (\z ->
    d_C__case_3 x7 x2 x1 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_TypeExpr d c e -> guardCons d c (d_C__case_3 x7
    x2 x1 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_TypeExpr d info -> failCons d (traceFail
    "Analysis._case_3" [show x7, show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "Analysis._case_3" (showCons x3))

nd_C__case_3 :: Curry_Classification.C_FuncHOClass -> Curry_Prelude.C_Int
  -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass -> FlatCurry.Curry_Types.C_TypeExpr
  -> IDSupply -> Cover -> ConstStore -> Curry_Classification.C_FuncHOClass
nd_C__case_3 x7 x2 x1 x3 s cd cs = case x3 of
  FlatCurry.Curry_Types.C_FuncType x8 x9 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` Curry_Classification.d_C_maxFuncHOClass (nd_C_isHOType
    Curry_Prelude.C_True x1 x8 s0 cd cs) (nd_C_isHOFunc x1
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x2 (Curry_Prelude.C_Int (1)) cd cs) x9 s1 cd cs) cd cs))
  FlatCurry.Curry_Types.C_TVar x10 -> x7
  FlatCurry.Curry_Types.C_TCons x11 x12 -> x7
  FlatCurry.Curry_Types.C_ForallType x13 x14 -> x7
  FlatCurry.Curry_Types.Choice_C_TypeExpr d i l r -> narrow d i (nd_C__case_3 x7
    x2 x1 l s cd cs) (nd_C__case_3 x7 x2 x1 r s cd cs)
  FlatCurry.Curry_Types.Choices_C_TypeExpr d i xs -> narrows cs d i (\z ->
    nd_C__case_3 x7 x2 x1 z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_TypeExpr d c e -> guardCons d c (nd_C__case_3 x7
    x2 x1 e s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_TypeExpr d info -> failCons d (traceFail
    "Analysis._case_3" [show x7, show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "Analysis._case_3" (showCons x3))

d_C__case_6 :: FlatCurry.Curry_Types.C_TypeExpr -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass -> Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_TypeExpr -> Cover -> ConstStore
  -> Curry_Classification.C_FuncHOClass
d_C__case_6 x3 x1 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "Analysis.isHOFunc: no type") cd cs
  Curry_Prelude.OP_Cons x4 x5 -> let x6 = Curry_Classification.d_C_maxFuncHOClass
                                       (d_C__case_5 x5 (Curry_Prelude.d_C_null
                                       x5 cd cs) cd cs) (d_C_isHOType
                                       Curry_Prelude.C_False x1 x4 cd cs) cd cs
    in Curry_Classification.d_C_maximumFuncHOClass (Curry_Prelude.OP_Cons x6
    (Curry_Prelude.d_C_map (d_C_isHOType Curry_Prelude.C_True x1) x5 cd cs)) cd
    cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_6 x3 x1 l cd cs)
    (d_C__case_6 x3 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_6 x3
    x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_6 x3 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Analysis._case_6"
    [show x3, show x1, show x7] info)
  _ -> failCons cd (consFail "Analysis._case_6" (showCons x7))

nd_C__case_6 :: FlatCurry.Curry_Types.C_TypeExpr -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass -> Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_TypeExpr -> IDSupply -> Cover -> ConstStore
  -> Curry_Classification.C_FuncHOClass
nd_C__case_6 x3 x1 x7 s cd cs = case x7 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "Analysis.isHOFunc: no type") cd cs
  Curry_Prelude.OP_Cons x4 x5 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` (let x6 = Curry_Classification.d_C_maxFuncHOClass
                                 (d_C__case_5 x5 (Curry_Prelude.d_C_null x5 cd
                                 cs) cd cs) (nd_C_isHOType Curry_Prelude.C_False
                                 x1 x4 s0 cd cs) cd cs
    in Curry_Classification.d_C_maximumFuncHOClass (Curry_Prelude.OP_Cons x6
    (Curry_Prelude.nd_C_map (wrapNX id (nd_C_isHOType Curry_Prelude.C_True x1))
    x5 s1 cd cs)) cd cs)))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_6 x3 x1 l s cd
    cs) (nd_C__case_6 x3 x1 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_6 x3
    x1 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C__case_6 x3 x1 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Analysis._case_6"
    [show x3, show x1, show x7] info)
  _ -> failCons cd (consFail "Analysis._case_6" (showCons x7))

d_C__case_5 :: Curry_Prelude.OP_List FlatCurry.Curry_Types.C_TypeExpr
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Classification.C_FuncHOClass
d_C__case_5 x5 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> Curry_Classification.C_FuncFO
  Curry_Prelude.C_False -> Curry_Classification.C_FuncHORes
    (Curry_Prelude.d_C_length x5 cd cs)
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_5 x5 l cd cs)
    (d_C__case_5 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_5 x5 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_5 x5 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Analysis._case_5"
    [show x5, show x6] info)
  _ -> failCons cd (consFail "Analysis._case_5" (showCons x6))

d_C__case_9 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_TypeExpr
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Classification.C_TypeHOClass
d_C__case_9 x5 x6 x7 cd cs = case x7 of
  Curry_Prelude.C_True -> Curry_Classification.d_C_maximumTypeHOClass
    (Curry_Prelude.OP_Cons Curry_Classification.C_TypeIO (Curry_Prelude.d_C_map
    d_C_classifyHOType x6 cd cs)) cd cs
  Curry_Prelude.C_False -> d_C__case_8 x6 (Curry_Prelude.d_C_otherwise cd cs) cd
    cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_9 x5 x6 l cd cs)
    (d_C__case_9 x5 x6 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_9 x5 x6
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_9 x5 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Analysis._case_9"
    [show x5, show x6, show x7] info)
  _ -> failCons cd (consFail "Analysis._case_9" (showCons x7))

d_C__case_8 :: Curry_Prelude.OP_List FlatCurry.Curry_Types.C_TypeExpr
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Classification.C_TypeHOClass
d_C__case_8 x6 x7 cd cs = case x7 of
  Curry_Prelude.C_True -> Curry_Classification.d_C_maximumTypeHOClass
    (Curry_Prelude.d_C_map d_C_classifyHOType x6 cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_8 x6 l cd cs)
    (d_C__case_8 x6 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_8 x6 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_8 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Analysis._case_8"
    [show x6, show x7] info)
  _ -> failCons cd (consFail "Analysis._case_8" (showCons x7))

d_C__case_11 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_ConsDecl
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Classification.C_TypeHOClass
d_C__case_11 x2 x5 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> Curry_Classification.C_TypeIO
  Curry_Prelude.C_False -> d_C__case_10 x5 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_11 x2 x5 l cd cs)
    (d_C__case_11 x2 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_11 x2
    x5 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_11 x2 x5 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Analysis._case_11"
    [show x2, show x5, show x6] info)
  _ -> failCons cd (consFail "Analysis._case_11" (showCons x6))

d_C__case_10 :: Curry_Prelude.OP_List FlatCurry.Curry_Types.C_ConsDecl
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Classification.C_TypeHOClass
d_C__case_10 x5 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_dollar
    Curry_Classification.d_C_maximumTypeHOClass (Curry_Prelude.d_OP_dollar
    (Curry_Prelude.d_C_map d_C_classifyHOType) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_concatMap (FlatCurry.Curry_Goodies.d_C_consArgs cd cs) cd
    cs) x5 cd cs) cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_10 x5 l cd cs)
    (d_C__case_10 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_10 x5 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_10 x5 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Analysis._case_10"
    [show x5, show x6] info)
  _ -> failCons cd (consFail "Analysis._case_10" (showCons x6))

d_C__case_12 :: Curry_Prelude.C_Bool -> FlatCurry.Curry_Types.C_CombType
  -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_12 x2 x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_FuncCall -> Curry_Prelude.C_True
  FlatCurry.Curry_Types.C_FuncPartCall x3 -> Curry_Prelude.C_True
  FlatCurry.Curry_Types.C_ConsCall -> x2
  FlatCurry.Curry_Types.C_ConsPartCall x4 -> x2
  FlatCurry.Curry_Types.Choice_C_CombType d i l r -> narrow d i (d_C__case_12 x2
    l cd cs) (d_C__case_12 x2 r cd cs)
  FlatCurry.Curry_Types.Choices_C_CombType d i xs -> narrows cs d i (\z ->
    d_C__case_12 x2 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_CombType d c e -> guardCons d c (d_C__case_12 x2
    e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_CombType d info -> failCons d (traceFail
    "Analysis._case_12" [show x2, show x1] info)
  _ -> failCons cd (consFail "Analysis._case_12" (showCons x1))

d_C__case_14 :: FlatCurry.Curry_Types.C_CombType -> Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_Expr -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_RedBlackTree.C_RedBlackTree (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C__case_14 x4 x6 x5 x7 cd cs = case x7 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_SetRBT.d_C_insertRBT cd cs) x5 cd cs) (Curry_Prelude.d_C_apply
    (d_C_unionMap
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    cd cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    cd cs) cd cs) cd cs) d_C_funcsInExp cd cs) x6 cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_13 x6 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_14 x4 x6 x5 l cd
    cs) (d_C__case_14 x4 x6 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_14 x4
    x6 x5 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_14 x4 x6 x5 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Analysis._case_14"
    [show x4, show x6, show x5, show x7] info)
  _ -> failCons cd (consFail "Analysis._case_14" (showCons x7))

nd_C__case_14 :: FlatCurry.Curry_Types.C_CombType -> Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_Expr -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Curry_RedBlackTree.C_RedBlackTree (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
nd_C__case_14 x4 x6 x5 x7 s cd cs = case x7 of
  Curry_Prelude.C_True -> let s17 = s
    in s17 `seq` (let s16 = leftSupply s17
                      s18 = rightSupply s17
                      s2 = leftSupply s18
                      s15 = rightSupply s18
    in s16 `seq` (s18 `seq` (s2 `seq` (s15 `seq` Curry_Prelude.nd_C_apply
    (let s1 = leftSupply s2
         s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_SetRBT.nd_C_insertRBT
    s0 cd cs) x5 s1 cd cs)) (let s14 = leftSupply s15
                                 s13 = rightSupply s15
    in s14 `seq` (s13 `seq` Curry_Prelude.nd_C_apply (let s12 = leftSupply s13
                                                          s10 = rightSupply s13
    in s12 `seq` (s10 `seq` nd_C_unionMap (let s9 = leftSupply s10
                                               s11 = rightSupply s10
                                               s5 = leftSupply s11
                                               s8 = rightSupply s11
    in s9 `seq` (s11 `seq` (s5 `seq` (s8 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
    (let s4 = leftSupply s5
         s3 = rightSupply s5
    in s4 `seq` (s3 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    s3 cd cs) s4 cd cs)) (let s7 = leftSupply s8
                              s6 = rightSupply s8
    in s7 `seq` (s6 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    s6 cd cs) s7 cd cs)) s9 cd cs)))) (wrapNX id nd_C_funcsInExp) s12 cd cs)) x6
    s14 cd cs)) s16 cd cs))))
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_13 x6 (Curry_Prelude.d_C_otherwise cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_14 x4 x6 x5 l s
    cd cs) (nd_C__case_14 x4 x6 x5 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_14 x4
    x6 x5 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_14 x4 x6 x5 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Analysis._case_14"
    [show x4, show x6, show x5, show x7] info)
  _ -> failCons cd (consFail "Analysis._case_14" (showCons x7))

d_C__case_13 :: Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_RedBlackTree.C_RedBlackTree (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C__case_13 x6 x7 cd cs = case x7 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (d_C_unionMap
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    cd cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    cd cs) cd cs) cd cs) d_C_funcsInExp cd cs) x6 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_13 x6 l cd cs)
    (d_C__case_13 x6 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_13 x6 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_13 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Analysis._case_13"
    [show x6, show x7] info)
  _ -> failCons cd (consFail "Analysis._case_13" (showCons x7))

nd_C__case_13 :: Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Curry_RedBlackTree.C_RedBlackTree (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
nd_C__case_13 x6 x7 s cd cs = case x7 of
  Curry_Prelude.C_True -> let s12 = s
    in s12 `seq` (let s11 = leftSupply s12
                      s10 = rightSupply s12
    in s11 `seq` (s10 `seq` Curry_Prelude.nd_C_apply (let s9 = leftSupply s10
                                                          s7 = rightSupply s10
    in s9 `seq` (s7 `seq` nd_C_unionMap (let s6 = leftSupply s7
                                             s8 = rightSupply s7
                                             s2 = leftSupply s8
                                             s5 = rightSupply s8
    in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lparen_comma_rparen
    (let s1 = leftSupply s2
         s0 = rightSupply s2
    in s1 `seq` (s0 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    s0 cd cs) s1 cd cs)) (let s4 = leftSupply s5
                              s3 = rightSupply s5
    in s4 `seq` (s3 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char
    s3 cd cs) s4 cd cs)) s6 cd cs)))) (wrapNX id nd_C_funcsInExp) s9 cd cs)) x6
    s11 cd cs))
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_13 x6 l s cd cs)
    (nd_C__case_13 x6 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_13 x6
    z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_13 x6 e s cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Analysis._case_13"
    [show x6, show x7] info)
  _ -> failCons cd (consFail "Analysis._case_13" (showCons x7))

d_C__case_15 :: FlatCurry.Curry_Types.C_Rule -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_15 x6 cd cs = case x6 of
  FlatCurry.Curry_Types.C_Rule x7 x8 -> Curry_Prelude.d_OP_dollar (d_C_toList cd
    cs) (d_C_funcsInExp x8 cd cs) cd cs
  FlatCurry.Curry_Types.C_External x9 -> Curry_Prelude.OP_List
  FlatCurry.Curry_Types.Choice_C_Rule d i l r -> narrow d i (d_C__case_15 l cd
    cs) (d_C__case_15 r cd cs)
  FlatCurry.Curry_Types.Choices_C_Rule d i xs -> narrows cs d i (\z ->
    d_C__case_15 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Rule d c e -> guardCons d c (d_C__case_15 e
    cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Rule d info -> failCons d (traceFail
    "Analysis._case_15" [show x6] info)
  _ -> failCons cd (consFail "Analysis._case_15" (showCons x6))

d_C__case_19 :: FlatCurry.Curry_Types.C_Rule -> Curry_Prelude.C_Bool
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_NDClass -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_NDClass
d_C__case_19 x6 x7 x8 x5 x9 cd cs = case x9 of
  Curry_Prelude.C_True -> x8
  Curry_Prelude.C_False -> d_C__case_18 x6 x7 x8 x5 (Curry_Prelude.d_C_apply
    (d_C_isNDExpr cd cs) (Curry_Prelude.d_C_apply
    (FlatCurry.Curry_Goodies.d_C_ruleBody cd cs) x6 cd cs) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_19 x6 x7 x8 x5 l
    cd cs) (d_C__case_19 x6 x7 x8 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_19 x6
    x7 x8 x5 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_19 x6 x7 x8 x5 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Analysis._case_19"
    [show x6, show x7, show x8, show x5, show x9] info)
  _ -> failCons cd (consFail "Analysis._case_19" (showCons x9))

d_C__case_18 :: FlatCurry.Curry_Types.C_Rule -> Curry_Prelude.C_Bool
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_NDClass -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_NDClass
d_C__case_18 x6 x7 x8 x5 x9 cd cs = case x9 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Tuple2 x5 Curry_Classification.C_ND
  Curry_Prelude.C_False -> d_C__case_17 x8 x5 x7 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_18 x6 x7 x8 x5 l
    cd cs) (d_C__case_18 x6 x7 x8 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_18 x6
    x7 x8 x5 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_18 x6 x7 x8 x5 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Analysis._case_18"
    [show x6, show x7, show x8, show x5, show x9] info)
  _ -> failCons cd (consFail "Analysis._case_18" (showCons x9))

d_C__case_17 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_NDClass
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_NDClass
d_C__case_17 x8 x5 x7 cd cs = case x7 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Tuple2 x5 Curry_Classification.C_ND
  Curry_Prelude.C_False -> d_C__case_16 x8 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_17 x8 x5 l cd cs)
    (d_C__case_17 x8 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_17 x8
    x5 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_17 x8 x5 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Analysis._case_17"
    [show x8, show x5, show x7] info)
  _ -> failCons cd (consFail "Analysis._case_17" (showCons x7))

d_C__case_16 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_NDClass -> Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_NDClass
d_C__case_16 x8 x9 cd cs = case x9 of
  Curry_Prelude.C_True -> x8
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_16 x8 l cd cs)
    (d_C__case_16 x8 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_16 x8 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_16 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Analysis._case_16"
    [show x8, show x9] info)
  _ -> failCons cd (consFail "Analysis._case_16" (showCons x9))

d_C__case_20 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Classification.C_NDClass
d_C__case_20 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Classification.C_ND
  Curry_Prelude.C_False -> Curry_Classification.C_D
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_20 x2 l cd cs)
    (d_C__case_20 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_20 x2 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_20 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Analysis._case_20"
    [show x2, show x3] info)
  _ -> failCons cd (consFail "Analysis._case_20" (showCons x3))

d_C__case_21 :: forall t1 t0 . (Curry_Prelude.Curry t0, Curry_Prelude.Curry
  t1) => Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)) t0
  -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)) t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Eq t0 -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) t0 -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 t1 (Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) -> (Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) t0 -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 t1
  (Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) t0) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)) t0
d_C__case_21 x6 x5 x1 x4 x3 x2 x7 cd cs = case x7 of
  Curry_Prelude.C_True -> x5
  Curry_Prelude.C_False -> d_C_fullIteration x1 x2 x3 x4 x6 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_21 x6 x5 x1 x4 x3
    x2 l cd cs) (d_C__case_21 x6 x5 x1 x4 x3 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_21 x6
    x5 x1 x4 x3 x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_21 x6 x5 x1 x4 x3
    x2 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Analysis._case_21"
    [show x6, show x5, show x1, show x4, show x3, show x2, show x7] info)
  _ -> failCons cd (consFail "Analysis._case_21" (showCons x7))

nd_C__case_21 :: forall t1 t0 . (Curry_Prelude.Curry t0, Curry_Prelude.Curry
  t1) => Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)) t0
  -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)) t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Eq t0 -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) t0 -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 t1 (Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) -> Func (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) t0) (Func
  (Curry_Prelude.OP_Tuple2 t1 (Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) t0)) -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) t0
nd_C__case_21 x6 x5 x1 x4 x3 x2 x7 s cd cs = case x7 of
  Curry_Prelude.C_True -> x5
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C_fullIteration x1 x2 x3 x4 x6 s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_21 x6 x5 x1 x4
    x3 x2 l s cd cs) (nd_C__case_21 x6 x5 x1 x4 x3 x2 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_21 x6
    x5 x1 x4 x3 x2 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_21 x6 x5 x1 x4
    x3 x2 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Analysis._case_21"
    [show x6, show x5, show x1, show x4, show x3, show x2, show x7] info)
  _ -> failCons cd (consFail "Analysis._case_21" (showCons x7))

