{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE Rank2Types #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module Curry_CompilerOpts
  ( C_Options (..)
  , C_Verbosity (..)
  , C_OptimLevel (..)
  , C_Extension (..)
  , C_DumpFormat (..)
  , d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Verbosity
  , nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Verbosity
  , d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Verbosity
  , d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Verbosity
  , d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity
  , nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity
  , d_OP_uscore_impl_hash_compare_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity
  , d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity
  , d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity
  , d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity
  , d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity
  , d_OP_uscore_impl_hash_min_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity
  , d_OP_uscore_impl_hash_max_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity
  , d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_OptimLevel
  , nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_OptimLevel
  , d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_OptimLevel
  , d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_OptimLevel
  , d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
  , nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
  , d_OP_uscore_impl_hash_compare_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
  , d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
  , d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
  , d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
  , d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
  , d_OP_uscore_impl_hash_min_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
  , d_OP_uscore_impl_hash_max_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
  , d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Extension
  , nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Extension
  , d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Extension
  , d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Extension
  , d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_DumpFormat
  , nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_DumpFormat
  , d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_DumpFormat
  , d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_DumpFormat
  , d_C_optHelp
  , d_C_optVersion
  , d_C_optVerbosity
  , d_C_optMainVerbosity
  , d_C_optForce
  , d_C_optImportPaths
  , d_C_optOutputSubdir
  , d_C_optOptimization
  , d_C_optExtensions
  , d_C_optDump
  , d_C_optParser
  , d_C_optTraceFailure
  , d_C_rcVars
  , d_C_defaultOptions
  , d_C_getCompilerOpts )
  where

import Basics
import qualified Curry_FilePath
import qualified Curry_GetOpt
import qualified Curry_IO
import qualified Curry_Installation
import qualified Curry_List
import qualified Curry_Prelude
import qualified Curry_System


type C_OptErr = Curry_Prelude.OP_Tuple2 C_Options (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))

type C_OptErrTable = Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple3
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (C_Options -> Cover -> ConstStore -> C_Options))

data C_Options
  = C_Opts Curry_Prelude.C_Bool Curry_Prelude.C_Bool C_Verbosity C_Verbosity
    Curry_Prelude.C_Bool (Curry_Prelude.OP_List (Curry_Prelude.OP_List
    Curry_Prelude.C_Char)) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
    C_OptimLevel (Curry_Prelude.OP_List C_Extension) (Curry_Prelude.OP_List
    C_DumpFormat) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
    Curry_Prelude.C_Bool (Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
    (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
    Curry_Prelude.C_Char)))
  | Choice_C_Options Cover ID C_Options C_Options
  | Choices_C_Options Cover ID [C_Options]
  | Fail_C_Options Cover FailInfo
  | Guard_C_Options Cover Constraints C_Options

instance Show C_Options where
  showsPrec d (Choice_C_Options cd i x y) = showsChoice d cd i x y
  showsPrec d (Choices_C_Options cd i xs) = showsChoices d cd i xs
  showsPrec d (Guard_C_Options cd c e) = showsGuard d cd c e
  showsPrec _ (Fail_C_Options cd info) = showChar '!'
  showsPrec _ (C_Opts x1 x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13) = showString
    "(Opts" . (showChar ' ' . (shows x1 . (showChar ' ' . (shows x2 . (showChar
    ' ' . (shows x3 . (showChar ' ' . (shows x4 . (showChar ' ' . (shows x5 .
    (showChar ' ' . (shows x6 . (showChar ' ' . (shows x7 . (showChar ' ' .
    (shows x8 . (showChar ' ' . (shows x9 . (showChar ' ' . (shows x10 .
    (showChar ' ' . (shows x11 . (showChar ' ' . (shows x12 . (showChar ' ' .
    (shows x13 . showChar ')'))))))))))))))))))))))))))

instance Read C_Options where
  readsPrec d s = readParen ((>) d 10) (\r -> [(C_Opts x1 x2 x3 x4 x5 x6 x7 x8
    x9 x10 x11 x12 x13, r13) | (_, r0) <- readQualified "CompilerOpts" "Opts" r,
    (x1, r1) <- readsPrec 11 r0, (x2, r2) <- readsPrec 11 r1, (x3, r3) <-
    readsPrec 11 r2, (x4, r4) <- readsPrec 11 r3, (x5, r5) <- readsPrec 11 r4,
    (x6, r6) <- readsPrec 11 r5, (x7, r7) <- readsPrec 11 r6, (x8, r8) <-
    readsPrec 11 r7, (x9, r9) <- readsPrec 11 r8, (x10, r10) <- readsPrec 11 r9,
    (x11, r11) <- readsPrec 11 r10, (x12, r12) <- readsPrec 11 r11, (x13, r13)
    <- readsPrec 11 r12]) s

instance NonDet C_Options where
  choiceCons = Choice_C_Options
  choicesCons = Choices_C_Options
  failCons = Fail_C_Options
  guardCons = Guard_C_Options
  try (Choice_C_Options cd i x y) = tryChoice cd i x y
  try (Choices_C_Options cd i xs) = tryChoices cd i xs
  try (Fail_C_Options cd info) = Fail cd info
  try (Guard_C_Options cd c e) = Guard cd c e
  try x = Val x
  match f _ _ _ _ _ (Choice_C_Options cd i x y) = f cd i x y
  match _ f _ _ _ _ (Choices_C_Options cd i@(NarrowedID _ _) xs) = f cd i xs
  match _ _ f _ _ _ (Choices_C_Options cd i@(FreeID _ _) xs) = f cd i xs
  match _ _ _ _ _ _ (Choices_C_Options cd i _) = error
    ("CompilerOpts.Options.match: Choices with ChoiceID " ++ show i)
  match _ _ _ f _ _ (Fail_C_Options cd info) = f cd info
  match _ _ _ _ f _ (Guard_C_Options cd c e) = f cd c e
  match _ _ _ _ _ f x = f x

instance Generable C_Options where
  generate s c = Choices_C_Options c (freeID [13] s) [C_Opts (generate
    (leftSupply (leftSupply (leftSupply (leftSupply s)))) c) (generate
    (rightSupply (leftSupply (leftSupply (leftSupply s)))) c) (generate
    (leftSupply (rightSupply (leftSupply (leftSupply s)))) c) (generate
    (rightSupply (rightSupply (leftSupply (leftSupply s)))) c) (generate
    (leftSupply (leftSupply (rightSupply (leftSupply s)))) c) (generate
    (rightSupply (leftSupply (rightSupply (leftSupply s)))) c) (generate
    (rightSupply (rightSupply (leftSupply s))) c) (generate (leftSupply
    (leftSupply (leftSupply (rightSupply s)))) c) (generate (rightSupply
    (leftSupply (leftSupply (rightSupply s)))) c) (generate (rightSupply
    (leftSupply (rightSupply s))) c) (generate (leftSupply (leftSupply
    (rightSupply (rightSupply s)))) c) (generate (rightSupply (leftSupply
    (rightSupply (rightSupply s)))) c) (generate (rightSupply (rightSupply
    (rightSupply s))) c)]

instance NormalForm C_Options where
  ($!!) cont (C_Opts x1 x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13) d cs = ($!!)
    (\y1 d cs -> ($!!) (\y2 d cs -> ($!!) (\y3 d cs -> ($!!) (\y4 d cs -> ($!!)
    (\y5 d cs -> ($!!) (\y6 d cs -> ($!!) (\y7 d cs -> ($!!) (\y8 d cs -> ($!!)
    (\y9 d cs -> ($!!) (\y10 d cs -> ($!!) (\y11 d cs -> ($!!) (\y12 d cs ->
    ($!!) (\y13 d cs -> cont (C_Opts y1 y2 y3 y4 y5 y6 y7 y8 y9 y10 y11 y12 y13)
    d cs) x13 d cs) x12 d cs) x11 d cs) x10 d cs) x9 d cs) x8 d cs) x7 d cs) x6
    d cs) x5 d cs) x4 d cs) x3 d cs) x2 d cs) x1 d cs
  ($!!) cont (Choice_C_Options cd i x y) d cs = nfChoice cont cd i x y cd cs
  ($!!) cont (Choices_C_Options cd i xs) d cs = nfChoices cont cd i xs d cs
  ($!!) cont (Guard_C_Options cd c e) d cs = guardCons cd c (($!!) cont e d
    (addCs c cs))
  ($!!) _ (Fail_C_Options cd info) _ _ = failCons cd info
  ($##) cont (C_Opts x1 x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13) d cs = ($##)
    (\y1 d cs -> ($##) (\y2 d cs -> ($##) (\y3 d cs -> ($##) (\y4 d cs -> ($##)
    (\y5 d cs -> ($##) (\y6 d cs -> ($##) (\y7 d cs -> ($##) (\y8 d cs -> ($##)
    (\y9 d cs -> ($##) (\y10 d cs -> ($##) (\y11 d cs -> ($##) (\y12 d cs ->
    ($##) (\y13 d cs -> cont (C_Opts y1 y2 y3 y4 y5 y6 y7 y8 y9 y10 y11 y12 y13)
    d cs) x13 d cs) x12 d cs) x11 d cs) x10 d cs) x9 d cs) x8 d cs) x7 d cs) x6
    d cs) x5 d cs) x4 d cs) x3 d cs) x2 d cs) x1 d cs
  ($##) cont (Choice_C_Options cd i x y) d cs = gnfChoice cont cd i x y cd cs
  ($##) cont (Choices_C_Options cd i xs) d cs = gnfChoices cont cd i xs d cs
  ($##) cont (Guard_C_Options cd c e) d cs = guardCons cd c (($##) cont e d
    (addCs c cs))
  ($##) _ (Fail_C_Options cd info) _ _ = failCons cd info
  showCons (C_Opts _ _ _ _ _ _ _ _ _ _ _ _ _) =
    "CompilerOpts.Opts _ _ _ _ _ _ _ _ _ _ _ _ _"
  showCons x = error ("CompilerOpts.Options.showCons: no constructor: " ++ show
    x)
  searchNF search cont (C_Opts x1 x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13) =
    search (\y1 -> search (\y2 -> search (\y3 -> search (\y4 -> search (\y5 ->
    search (\y6 -> search (\y7 -> search (\y8 -> search (\y9 -> search (\y10 ->
    search (\y11 -> search (\y12 -> search (\y13 -> cont (C_Opts y1 y2 y3 y4 y5
    y6 y7 y8 y9 y10 y11 y12 y13)) x13) x12) x11) x10) x9) x8) x7) x6) x5) x4)
    x3) x2) x1
  searchNF _ _ x = error ("CompilerOpts.Options.searchNF: no constructor: " ++
    show x)

instance Unifiable C_Options where
  (=.=) (C_Opts x1 x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13) (C_Opts y1 y2 y3 y4 y5 y6 y7 y8 y9 y10 y11 y12 y13) d cs =
    (&) ((=:=) x1 y1 d cs) ((&) ((=:=) x2 y2 d cs) ((&) ((=:=) x3 y3 d cs) ((&)
    ((=:=) x4 y4 d cs) ((&) ((=:=) x5 y5 d cs) ((&) ((=:=) x6 y6 d cs) ((&)
    ((=:=) x7 y7 d cs) ((&) ((=:=) x8 y8 d cs) ((&) ((=:=) x9 y9 d cs) ((&)
    ((=:=) x10 y10 d cs) ((&) ((=:=) x11 y11 d cs) ((&) ((=:=) x12 y12 d cs)
    ((=:=) x13 y13 d cs) d cs) d cs) d cs) d cs) d cs) d cs) d cs) d cs) d cs) d
    cs) d cs) d cs
  (=.=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  (=.<=) (C_Opts x1 x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13) (C_Opts y1 y2 y3 y4 y5 y6 y7 y8 y9 y10 y11 y12 y13) d cs =
    (&) ((=:<=) x1 y1 d cs) ((&) ((=:<=) x2 y2 d cs) ((&) ((=:<=) x3 y3 d cs)
    ((&) ((=:<=) x4 y4 d cs) ((&) ((=:<=) x5 y5 d cs) ((&) ((=:<=) x6 y6 d cs)
    ((&) ((=:<=) x7 y7 d cs) ((&) ((=:<=) x8 y8 d cs) ((&) ((=:<=) x9 y9 d cs)
    ((&) ((=:<=) x10 y10 d cs) ((&) ((=:<=) x11 y11 d cs) ((&) ((=:<=) x12 y12 d
    cs) ((=:<=) x13 y13 d cs) d cs) d cs) d cs) d cs) d cs) d cs) d cs) d cs) d
    cs) d cs) d cs) d cs
  (=.<=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  bind cd i (C_Opts x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 x15) = (i :=:
    ChooseN 0 13) : concat [bind cd (leftID (leftID (leftID (leftID i)))) x3
    , bind cd (rightID (leftID (leftID (leftID i)))) x4, bind cd (leftID
    (rightID (leftID (leftID i)))) x5, bind cd (rightID (rightID (leftID (leftID
    i)))) x6, bind cd (leftID (leftID (rightID (leftID i)))) x7, bind cd
    (rightID (leftID (rightID (leftID i)))) x8, bind cd (rightID (rightID
    (leftID i))) x9, bind cd (leftID (leftID (leftID (rightID i)))) x10, bind cd
    (rightID (leftID (leftID (rightID i)))) x11, bind cd (rightID (leftID
    (rightID i))) x12, bind cd (leftID (leftID (rightID (rightID i)))) x13, bind
    cd (rightID (leftID (rightID (rightID i)))) x14, bind cd (rightID (rightID
    (rightID i))) x15]
  bind d i (Choice_C_Options cd j x y) = [ConstraintChoice cd j (bind d i x)
    (bind d i y)]
  bind d i (Choices_C_Options cd j@(FreeID _ _) xs) = bindOrNarrow d i cd j xs
  bind d i (Choices_C_Options cd j@(NarrowedID _ _) xs) = [ConstraintChoices cd
    j (map (bind d i) xs)]
  bind _ _ (Choices_C_Options cd i _) = error
    ("CompilerOpts.Options.bind: Choices with ChoiceID: " ++ show i)
  bind _ _ (Fail_C_Options cd info) = [Unsolvable info]
  bind d i (Guard_C_Options cd c e) = getConstrList c ++ bind d i e
  lazyBind cd i (C_Opts x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 x15) = (i :=:
    ChooseN 0 13) : [leftID (leftID (leftID (leftID i))) :=: LazyBind (lazyBind
    cd (leftID (leftID (leftID (leftID i)))) x3), rightID (leftID (leftID
    (leftID i))) :=: LazyBind (lazyBind cd (rightID (leftID (leftID (leftID
    i)))) x4), leftID (rightID (leftID (leftID i))) :=: LazyBind (lazyBind cd
    (leftID (rightID (leftID (leftID i)))) x5), rightID (rightID (leftID (leftID
    i))) :=: LazyBind (lazyBind cd (rightID (rightID (leftID (leftID i)))) x6)
    , leftID (leftID (rightID (leftID i))) :=: LazyBind (lazyBind cd (leftID
    (leftID (rightID (leftID i)))) x7), rightID (leftID (rightID (leftID
    i))) :=: LazyBind (lazyBind cd (rightID (leftID (rightID (leftID i)))) x8)
    , rightID (rightID (leftID i)) :=: LazyBind (lazyBind cd (rightID (rightID
    (leftID i))) x9), leftID (leftID (leftID (rightID i))) :=: LazyBind
    (lazyBind cd (leftID (leftID (leftID (rightID i)))) x10), rightID (leftID
    (leftID (rightID i))) :=: LazyBind (lazyBind cd (rightID (leftID (leftID
    (rightID i)))) x11), rightID (leftID (rightID i)) :=: LazyBind (lazyBind cd
    (rightID (leftID (rightID i))) x12), leftID (leftID (rightID (rightID
    i))) :=: LazyBind (lazyBind cd (leftID (leftID (rightID (rightID i)))) x13)
    , rightID (leftID (rightID (rightID i))) :=: LazyBind (lazyBind cd (rightID
    (leftID (rightID (rightID i)))) x14), rightID (rightID (rightID i)) :=:
    LazyBind (lazyBind cd (rightID (rightID (rightID i))) x15)]
  lazyBind d i (Choice_C_Options cd j x y) = [ConstraintChoice cd j (lazyBind d
    i x) (lazyBind d i y)]
  lazyBind d i (Choices_C_Options cd j@(FreeID _ _) xs) = lazyBindOrNarrow d i
    cd j xs
  lazyBind d i (Choices_C_Options cd j@(NarrowedID _ _) xs) = [ConstraintChoices
    cd j (map (lazyBind d i) xs)]
  lazyBind _ _ (Choices_C_Options cd i _) = error
    ("CompilerOpts.Options.lazyBind: Choices with ChoiceID: " ++ show i)
  lazyBind _ _ (Fail_C_Options cd info) = [Unsolvable info]
  lazyBind d i (Guard_C_Options cd c e) = getConstrList c ++ [i :=: LazyBind
    (lazyBind d i e)]

instance Curry C_Options where

data C_Verbosity
  = C_VerbQuiet
  | C_VerbFrontend
  | C_VerbStatus
  | C_VerbAnalysis
  | C_VerbDetails
  | Choice_C_Verbosity Cover ID C_Verbosity C_Verbosity
  | Choices_C_Verbosity Cover ID [C_Verbosity]
  | Fail_C_Verbosity Cover FailInfo
  | Guard_C_Verbosity Cover Constraints C_Verbosity

instance Show C_Verbosity where
  showsPrec d (Choice_C_Verbosity cd i x y) = showsChoice d cd i x y
  showsPrec d (Choices_C_Verbosity cd i xs) = showsChoices d cd i xs
  showsPrec d (Guard_C_Verbosity cd c e) = showsGuard d cd c e
  showsPrec _ (Fail_C_Verbosity cd info) = showChar '!'
  showsPrec _ C_VerbQuiet = showString "VerbQuiet"
  showsPrec _ C_VerbFrontend = showString "VerbFrontend"
  showsPrec _ C_VerbStatus = showString "VerbStatus"
  showsPrec _ C_VerbAnalysis = showString "VerbAnalysis"
  showsPrec _ C_VerbDetails = showString "VerbDetails"

instance Read C_Verbosity where
  readsPrec _ s = readParen False (\r -> [(C_VerbQuiet, r0) | (_, r0) <-
    readQualified "CompilerOpts" "VerbQuiet" r]) s ++ (readParen False (\r ->
    [(C_VerbFrontend, r0) | (_, r0) <- readQualified "CompilerOpts"
    "VerbFrontend" r]) s ++ (readParen False (\r -> [(C_VerbStatus, r0) | (_
    , r0) <- readQualified "CompilerOpts" "VerbStatus" r]) s ++ (readParen False
    (\r -> [(C_VerbAnalysis, r0) | (_, r0) <- readQualified "CompilerOpts"
    "VerbAnalysis" r]) s ++ readParen False (\r -> [(C_VerbDetails, r0) | (_
    , r0) <- readQualified "CompilerOpts" "VerbDetails" r]) s)))

instance NonDet C_Verbosity where
  choiceCons = Choice_C_Verbosity
  choicesCons = Choices_C_Verbosity
  failCons = Fail_C_Verbosity
  guardCons = Guard_C_Verbosity
  try (Choice_C_Verbosity cd i x y) = tryChoice cd i x y
  try (Choices_C_Verbosity cd i xs) = tryChoices cd i xs
  try (Fail_C_Verbosity cd info) = Fail cd info
  try (Guard_C_Verbosity cd c e) = Guard cd c e
  try x = Val x
  match f _ _ _ _ _ (Choice_C_Verbosity cd i x y) = f cd i x y
  match _ f _ _ _ _ (Choices_C_Verbosity cd i@(NarrowedID _ _) xs) = f cd i xs
  match _ _ f _ _ _ (Choices_C_Verbosity cd i@(FreeID _ _) xs) = f cd i xs
  match _ _ _ _ _ _ (Choices_C_Verbosity cd i _) = error
    ("CompilerOpts.Verbosity.match: Choices with ChoiceID " ++ show i)
  match _ _ _ f _ _ (Fail_C_Verbosity cd info) = f cd info
  match _ _ _ _ f _ (Guard_C_Verbosity cd c e) = f cd c e
  match _ _ _ _ _ f x = f x

instance Generable C_Verbosity where
  generate s c = Choices_C_Verbosity c (freeID [0, 0, 0, 0, 0] s) [C_VerbQuiet
    , C_VerbFrontend, C_VerbStatus, C_VerbAnalysis, C_VerbDetails]

instance NormalForm C_Verbosity where
  ($!!) cont C_VerbQuiet d cs = cont C_VerbQuiet d cs
  ($!!) cont C_VerbFrontend d cs = cont C_VerbFrontend d cs
  ($!!) cont C_VerbStatus d cs = cont C_VerbStatus d cs
  ($!!) cont C_VerbAnalysis d cs = cont C_VerbAnalysis d cs
  ($!!) cont C_VerbDetails d cs = cont C_VerbDetails d cs
  ($!!) cont (Choice_C_Verbosity cd i x y) d cs = nfChoice cont cd i x y cd cs
  ($!!) cont (Choices_C_Verbosity cd i xs) d cs = nfChoices cont cd i xs d cs
  ($!!) cont (Guard_C_Verbosity cd c e) d cs = guardCons cd c (($!!) cont e d
    (addCs c cs))
  ($!!) _ (Fail_C_Verbosity cd info) _ _ = failCons cd info
  ($##) cont C_VerbQuiet d cs = cont C_VerbQuiet d cs
  ($##) cont C_VerbFrontend d cs = cont C_VerbFrontend d cs
  ($##) cont C_VerbStatus d cs = cont C_VerbStatus d cs
  ($##) cont C_VerbAnalysis d cs = cont C_VerbAnalysis d cs
  ($##) cont C_VerbDetails d cs = cont C_VerbDetails d cs
  ($##) cont (Choice_C_Verbosity cd i x y) d cs = gnfChoice cont cd i x y cd cs
  ($##) cont (Choices_C_Verbosity cd i xs) d cs = gnfChoices cont cd i xs d cs
  ($##) cont (Guard_C_Verbosity cd c e) d cs = guardCons cd c (($##) cont e d
    (addCs c cs))
  ($##) _ (Fail_C_Verbosity cd info) _ _ = failCons cd info
  showCons C_VerbQuiet = "CompilerOpts.VerbQuiet"
  showCons C_VerbFrontend = "CompilerOpts.VerbFrontend"
  showCons C_VerbStatus = "CompilerOpts.VerbStatus"
  showCons C_VerbAnalysis = "CompilerOpts.VerbAnalysis"
  showCons C_VerbDetails = "CompilerOpts.VerbDetails"
  showCons x = error ("CompilerOpts.Verbosity.showCons: no constructor: " ++
    show x)
  searchNF _ cont C_VerbQuiet = cont C_VerbQuiet
  searchNF _ cont C_VerbFrontend = cont C_VerbFrontend
  searchNF _ cont C_VerbStatus = cont C_VerbStatus
  searchNF _ cont C_VerbAnalysis = cont C_VerbAnalysis
  searchNF _ cont C_VerbDetails = cont C_VerbDetails
  searchNF _ _ x = error ("CompilerOpts.Verbosity.searchNF: no constructor: " ++
    show x)

instance Unifiable C_Verbosity where
  (=.=) C_VerbQuiet C_VerbQuiet d cs = C_True
  (=.=) C_VerbFrontend C_VerbFrontend d cs = C_True
  (=.=) C_VerbStatus C_VerbStatus d cs = C_True
  (=.=) C_VerbAnalysis C_VerbAnalysis d cs = C_True
  (=.=) C_VerbDetails C_VerbDetails d cs = C_True
  (=.=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  (=.<=) C_VerbQuiet C_VerbQuiet d cs = C_True
  (=.<=) C_VerbFrontend C_VerbFrontend d cs = C_True
  (=.<=) C_VerbStatus C_VerbStatus d cs = C_True
  (=.<=) C_VerbAnalysis C_VerbAnalysis d cs = C_True
  (=.<=) C_VerbDetails C_VerbDetails d cs = C_True
  (=.<=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  bind cd i C_VerbQuiet = (i :=: ChooseN 0 0) : concat []
  bind cd i C_VerbFrontend = (i :=: ChooseN 1 0) : concat []
  bind cd i C_VerbStatus = (i :=: ChooseN 2 0) : concat []
  bind cd i C_VerbAnalysis = (i :=: ChooseN 3 0) : concat []
  bind cd i C_VerbDetails = (i :=: ChooseN 4 0) : concat []
  bind d i (Choice_C_Verbosity cd j x y) = [ConstraintChoice cd j (bind d i x)
    (bind d i y)]
  bind d i (Choices_C_Verbosity cd j@(FreeID _ _) xs) = bindOrNarrow d i cd j xs
  bind d i (Choices_C_Verbosity cd j@(NarrowedID _ _) xs) = [ConstraintChoices
    cd j (map (bind d i) xs)]
  bind _ _ (Choices_C_Verbosity cd i _) = error
    ("CompilerOpts.Verbosity.bind: Choices with ChoiceID: " ++ show i)
  bind _ _ (Fail_C_Verbosity cd info) = [Unsolvable info]
  bind d i (Guard_C_Verbosity cd c e) = getConstrList c ++ bind d i e
  lazyBind cd i C_VerbQuiet = (i :=: ChooseN 0 0) : []
  lazyBind cd i C_VerbFrontend = (i :=: ChooseN 1 0) : []
  lazyBind cd i C_VerbStatus = (i :=: ChooseN 2 0) : []
  lazyBind cd i C_VerbAnalysis = (i :=: ChooseN 3 0) : []
  lazyBind cd i C_VerbDetails = (i :=: ChooseN 4 0) : []
  lazyBind d i (Choice_C_Verbosity cd j x y) = [ConstraintChoice cd j (lazyBind
    d i x) (lazyBind d i y)]
  lazyBind d i (Choices_C_Verbosity cd j@(FreeID _ _) xs) = lazyBindOrNarrow d i
    cd j xs
  lazyBind d i (Choices_C_Verbosity cd j@(NarrowedID _ _) xs) =
    [ConstraintChoices cd j (map (lazyBind d i) xs)]
  lazyBind _ _ (Choices_C_Verbosity cd i _) = error
    ("CompilerOpts.Verbosity.lazyBind: Choices with ChoiceID: " ++ show i)
  lazyBind _ _ (Fail_C_Verbosity cd info) = [Unsolvable info]
  lazyBind d i (Guard_C_Verbosity cd c e) = getConstrList c ++ [i :=: LazyBind
    (lazyBind d i e)]

instance Curry C_Verbosity where

data C_OptimLevel
  = C_OptimNone
  | C_OptimHigherOrder
  | C_OptimStrictSupply
  | Choice_C_OptimLevel Cover ID C_OptimLevel C_OptimLevel
  | Choices_C_OptimLevel Cover ID [C_OptimLevel]
  | Fail_C_OptimLevel Cover FailInfo
  | Guard_C_OptimLevel Cover Constraints C_OptimLevel

instance Show C_OptimLevel where
  showsPrec d (Choice_C_OptimLevel cd i x y) = showsChoice d cd i x y
  showsPrec d (Choices_C_OptimLevel cd i xs) = showsChoices d cd i xs
  showsPrec d (Guard_C_OptimLevel cd c e) = showsGuard d cd c e
  showsPrec _ (Fail_C_OptimLevel cd info) = showChar '!'
  showsPrec _ C_OptimNone = showString "OptimNone"
  showsPrec _ C_OptimHigherOrder = showString "OptimHigherOrder"
  showsPrec _ C_OptimStrictSupply = showString "OptimStrictSupply"

instance Read C_OptimLevel where
  readsPrec _ s = readParen False (\r -> [(C_OptimNone, r0) | (_, r0) <-
    readQualified "CompilerOpts" "OptimNone" r]) s ++ (readParen False (\r ->
    [(C_OptimHigherOrder, r0) | (_, r0) <- readQualified "CompilerOpts"
    "OptimHigherOrder" r]) s ++ readParen False (\r -> [(C_OptimStrictSupply
    , r0) | (_, r0) <- readQualified "CompilerOpts" "OptimStrictSupply" r]) s)

instance NonDet C_OptimLevel where
  choiceCons = Choice_C_OptimLevel
  choicesCons = Choices_C_OptimLevel
  failCons = Fail_C_OptimLevel
  guardCons = Guard_C_OptimLevel
  try (Choice_C_OptimLevel cd i x y) = tryChoice cd i x y
  try (Choices_C_OptimLevel cd i xs) = tryChoices cd i xs
  try (Fail_C_OptimLevel cd info) = Fail cd info
  try (Guard_C_OptimLevel cd c e) = Guard cd c e
  try x = Val x
  match f _ _ _ _ _ (Choice_C_OptimLevel cd i x y) = f cd i x y
  match _ f _ _ _ _ (Choices_C_OptimLevel cd i@(NarrowedID _ _) xs) = f cd i xs
  match _ _ f _ _ _ (Choices_C_OptimLevel cd i@(FreeID _ _) xs) = f cd i xs
  match _ _ _ _ _ _ (Choices_C_OptimLevel cd i _) = error
    ("CompilerOpts.OptimLevel.match: Choices with ChoiceID " ++ show i)
  match _ _ _ f _ _ (Fail_C_OptimLevel cd info) = f cd info
  match _ _ _ _ f _ (Guard_C_OptimLevel cd c e) = f cd c e
  match _ _ _ _ _ f x = f x

instance Generable C_OptimLevel where
  generate s c = Choices_C_OptimLevel c (freeID [0, 0, 0] s) [C_OptimNone
    , C_OptimHigherOrder, C_OptimStrictSupply]

instance NormalForm C_OptimLevel where
  ($!!) cont C_OptimNone d cs = cont C_OptimNone d cs
  ($!!) cont C_OptimHigherOrder d cs = cont C_OptimHigherOrder d cs
  ($!!) cont C_OptimStrictSupply d cs = cont C_OptimStrictSupply d cs
  ($!!) cont (Choice_C_OptimLevel cd i x y) d cs = nfChoice cont cd i x y cd cs
  ($!!) cont (Choices_C_OptimLevel cd i xs) d cs = nfChoices cont cd i xs d cs
  ($!!) cont (Guard_C_OptimLevel cd c e) d cs = guardCons cd c (($!!) cont e d
    (addCs c cs))
  ($!!) _ (Fail_C_OptimLevel cd info) _ _ = failCons cd info
  ($##) cont C_OptimNone d cs = cont C_OptimNone d cs
  ($##) cont C_OptimHigherOrder d cs = cont C_OptimHigherOrder d cs
  ($##) cont C_OptimStrictSupply d cs = cont C_OptimStrictSupply d cs
  ($##) cont (Choice_C_OptimLevel cd i x y) d cs = gnfChoice cont cd i x y cd cs
  ($##) cont (Choices_C_OptimLevel cd i xs) d cs = gnfChoices cont cd i xs d cs
  ($##) cont (Guard_C_OptimLevel cd c e) d cs = guardCons cd c (($##) cont e d
    (addCs c cs))
  ($##) _ (Fail_C_OptimLevel cd info) _ _ = failCons cd info
  showCons C_OptimNone = "CompilerOpts.OptimNone"
  showCons C_OptimHigherOrder = "CompilerOpts.OptimHigherOrder"
  showCons C_OptimStrictSupply = "CompilerOpts.OptimStrictSupply"
  showCons x = error ("CompilerOpts.OptimLevel.showCons: no constructor: " ++
    show x)
  searchNF _ cont C_OptimNone = cont C_OptimNone
  searchNF _ cont C_OptimHigherOrder = cont C_OptimHigherOrder
  searchNF _ cont C_OptimStrictSupply = cont C_OptimStrictSupply
  searchNF _ _ x = error
    ("CompilerOpts.OptimLevel.searchNF: no constructor: " ++ show x)

instance Unifiable C_OptimLevel where
  (=.=) C_OptimNone C_OptimNone d cs = C_True
  (=.=) C_OptimHigherOrder C_OptimHigherOrder d cs = C_True
  (=.=) C_OptimStrictSupply C_OptimStrictSupply d cs = C_True
  (=.=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  (=.<=) C_OptimNone C_OptimNone d cs = C_True
  (=.<=) C_OptimHigherOrder C_OptimHigherOrder d cs = C_True
  (=.<=) C_OptimStrictSupply C_OptimStrictSupply d cs = C_True
  (=.<=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  bind cd i C_OptimNone = (i :=: ChooseN 0 0) : concat []
  bind cd i C_OptimHigherOrder = (i :=: ChooseN 1 0) : concat []
  bind cd i C_OptimStrictSupply = (i :=: ChooseN 2 0) : concat []
  bind d i (Choice_C_OptimLevel cd j x y) = [ConstraintChoice cd j (bind d i x)
    (bind d i y)]
  bind d i (Choices_C_OptimLevel cd j@(FreeID _ _) xs) = bindOrNarrow d i cd j
    xs
  bind d i (Choices_C_OptimLevel cd j@(NarrowedID _ _) xs) = [ConstraintChoices
    cd j (map (bind d i) xs)]
  bind _ _ (Choices_C_OptimLevel cd i _) = error
    ("CompilerOpts.OptimLevel.bind: Choices with ChoiceID: " ++ show i)
  bind _ _ (Fail_C_OptimLevel cd info) = [Unsolvable info]
  bind d i (Guard_C_OptimLevel cd c e) = getConstrList c ++ bind d i e
  lazyBind cd i C_OptimNone = (i :=: ChooseN 0 0) : []
  lazyBind cd i C_OptimHigherOrder = (i :=: ChooseN 1 0) : []
  lazyBind cd i C_OptimStrictSupply = (i :=: ChooseN 2 0) : []
  lazyBind d i (Choice_C_OptimLevel cd j x y) = [ConstraintChoice cd j (lazyBind
    d i x) (lazyBind d i y)]
  lazyBind d i (Choices_C_OptimLevel cd j@(FreeID _ _) xs) = lazyBindOrNarrow d
    i cd j xs
  lazyBind d i (Choices_C_OptimLevel cd j@(NarrowedID _ _) xs) =
    [ConstraintChoices cd j (map (lazyBind d i) xs)]
  lazyBind _ _ (Choices_C_OptimLevel cd i _) = error
    ("CompilerOpts.OptimLevel.lazyBind: Choices with ChoiceID: " ++ show i)
  lazyBind _ _ (Fail_C_OptimLevel cd info) = [Unsolvable info]
  lazyBind d i (Guard_C_OptimLevel cd c e) = getConstrList c ++ [i :=: LazyBind
    (lazyBind d i e)]

instance Curry C_OptimLevel where

data C_Extension
  = C_AnonFreeVars
  | C_FunctionalPatterns
  | C_NoImplicitPrelude
  | Choice_C_Extension Cover ID C_Extension C_Extension
  | Choices_C_Extension Cover ID [C_Extension]
  | Fail_C_Extension Cover FailInfo
  | Guard_C_Extension Cover Constraints C_Extension

instance Show C_Extension where
  showsPrec d (Choice_C_Extension cd i x y) = showsChoice d cd i x y
  showsPrec d (Choices_C_Extension cd i xs) = showsChoices d cd i xs
  showsPrec d (Guard_C_Extension cd c e) = showsGuard d cd c e
  showsPrec _ (Fail_C_Extension cd info) = showChar '!'
  showsPrec _ C_AnonFreeVars = showString "AnonFreeVars"
  showsPrec _ C_FunctionalPatterns = showString "FunctionalPatterns"
  showsPrec _ C_NoImplicitPrelude = showString "NoImplicitPrelude"

instance Read C_Extension where
  readsPrec _ s = readParen False (\r -> [(C_AnonFreeVars, r0) | (_, r0) <-
    readQualified "CompilerOpts" "AnonFreeVars" r]) s ++ (readParen False (\r ->
    [(C_FunctionalPatterns, r0) | (_, r0) <- readQualified "CompilerOpts"
    "FunctionalPatterns" r]) s ++ readParen False (\r -> [(C_NoImplicitPrelude
    , r0) | (_, r0) <- readQualified "CompilerOpts" "NoImplicitPrelude" r]) s)

instance NonDet C_Extension where
  choiceCons = Choice_C_Extension
  choicesCons = Choices_C_Extension
  failCons = Fail_C_Extension
  guardCons = Guard_C_Extension
  try (Choice_C_Extension cd i x y) = tryChoice cd i x y
  try (Choices_C_Extension cd i xs) = tryChoices cd i xs
  try (Fail_C_Extension cd info) = Fail cd info
  try (Guard_C_Extension cd c e) = Guard cd c e
  try x = Val x
  match f _ _ _ _ _ (Choice_C_Extension cd i x y) = f cd i x y
  match _ f _ _ _ _ (Choices_C_Extension cd i@(NarrowedID _ _) xs) = f cd i xs
  match _ _ f _ _ _ (Choices_C_Extension cd i@(FreeID _ _) xs) = f cd i xs
  match _ _ _ _ _ _ (Choices_C_Extension cd i _) = error
    ("CompilerOpts.Extension.match: Choices with ChoiceID " ++ show i)
  match _ _ _ f _ _ (Fail_C_Extension cd info) = f cd info
  match _ _ _ _ f _ (Guard_C_Extension cd c e) = f cd c e
  match _ _ _ _ _ f x = f x

instance Generable C_Extension where
  generate s c = Choices_C_Extension c (freeID [0, 0, 0] s) [C_AnonFreeVars
    , C_FunctionalPatterns, C_NoImplicitPrelude]

instance NormalForm C_Extension where
  ($!!) cont C_AnonFreeVars d cs = cont C_AnonFreeVars d cs
  ($!!) cont C_FunctionalPatterns d cs = cont C_FunctionalPatterns d cs
  ($!!) cont C_NoImplicitPrelude d cs = cont C_NoImplicitPrelude d cs
  ($!!) cont (Choice_C_Extension cd i x y) d cs = nfChoice cont cd i x y cd cs
  ($!!) cont (Choices_C_Extension cd i xs) d cs = nfChoices cont cd i xs d cs
  ($!!) cont (Guard_C_Extension cd c e) d cs = guardCons cd c (($!!) cont e d
    (addCs c cs))
  ($!!) _ (Fail_C_Extension cd info) _ _ = failCons cd info
  ($##) cont C_AnonFreeVars d cs = cont C_AnonFreeVars d cs
  ($##) cont C_FunctionalPatterns d cs = cont C_FunctionalPatterns d cs
  ($##) cont C_NoImplicitPrelude d cs = cont C_NoImplicitPrelude d cs
  ($##) cont (Choice_C_Extension cd i x y) d cs = gnfChoice cont cd i x y cd cs
  ($##) cont (Choices_C_Extension cd i xs) d cs = gnfChoices cont cd i xs d cs
  ($##) cont (Guard_C_Extension cd c e) d cs = guardCons cd c (($##) cont e d
    (addCs c cs))
  ($##) _ (Fail_C_Extension cd info) _ _ = failCons cd info
  showCons C_AnonFreeVars = "CompilerOpts.AnonFreeVars"
  showCons C_FunctionalPatterns = "CompilerOpts.FunctionalPatterns"
  showCons C_NoImplicitPrelude = "CompilerOpts.NoImplicitPrelude"
  showCons x = error ("CompilerOpts.Extension.showCons: no constructor: " ++
    show x)
  searchNF _ cont C_AnonFreeVars = cont C_AnonFreeVars
  searchNF _ cont C_FunctionalPatterns = cont C_FunctionalPatterns
  searchNF _ cont C_NoImplicitPrelude = cont C_NoImplicitPrelude
  searchNF _ _ x = error ("CompilerOpts.Extension.searchNF: no constructor: " ++
    show x)

instance Unifiable C_Extension where
  (=.=) C_AnonFreeVars C_AnonFreeVars d cs = C_True
  (=.=) C_FunctionalPatterns C_FunctionalPatterns d cs = C_True
  (=.=) C_NoImplicitPrelude C_NoImplicitPrelude d cs = C_True
  (=.=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  (=.<=) C_AnonFreeVars C_AnonFreeVars d cs = C_True
  (=.<=) C_FunctionalPatterns C_FunctionalPatterns d cs = C_True
  (=.<=) C_NoImplicitPrelude C_NoImplicitPrelude d cs = C_True
  (=.<=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  bind cd i C_AnonFreeVars = (i :=: ChooseN 0 0) : concat []
  bind cd i C_FunctionalPatterns = (i :=: ChooseN 1 0) : concat []
  bind cd i C_NoImplicitPrelude = (i :=: ChooseN 2 0) : concat []
  bind d i (Choice_C_Extension cd j x y) = [ConstraintChoice cd j (bind d i x)
    (bind d i y)]
  bind d i (Choices_C_Extension cd j@(FreeID _ _) xs) = bindOrNarrow d i cd j xs
  bind d i (Choices_C_Extension cd j@(NarrowedID _ _) xs) = [ConstraintChoices
    cd j (map (bind d i) xs)]
  bind _ _ (Choices_C_Extension cd i _) = error
    ("CompilerOpts.Extension.bind: Choices with ChoiceID: " ++ show i)
  bind _ _ (Fail_C_Extension cd info) = [Unsolvable info]
  bind d i (Guard_C_Extension cd c e) = getConstrList c ++ bind d i e
  lazyBind cd i C_AnonFreeVars = (i :=: ChooseN 0 0) : []
  lazyBind cd i C_FunctionalPatterns = (i :=: ChooseN 1 0) : []
  lazyBind cd i C_NoImplicitPrelude = (i :=: ChooseN 2 0) : []
  lazyBind d i (Choice_C_Extension cd j x y) = [ConstraintChoice cd j (lazyBind
    d i x) (lazyBind d i y)]
  lazyBind d i (Choices_C_Extension cd j@(FreeID _ _) xs) = lazyBindOrNarrow d i
    cd j xs
  lazyBind d i (Choices_C_Extension cd j@(NarrowedID _ _) xs) =
    [ConstraintChoices cd j (map (lazyBind d i) xs)]
  lazyBind _ _ (Choices_C_Extension cd i _) = error
    ("CompilerOpts.Extension.lazyBind: Choices with ChoiceID: " ++ show i)
  lazyBind _ _ (Fail_C_Extension cd info) = [Unsolvable info]
  lazyBind d i (Guard_C_Extension cd c e) = getConstrList c ++ [i :=: LazyBind
    (lazyBind d i e)]

instance Curry C_Extension where

data C_DumpFormat
  = C_DumpTypedFlat
  | C_DumpExtImports
  | C_DumpLifted
  | C_DumpEliminated
  | C_DumpDefaulted
  | C_DumpRenamed
  | C_DumpFunDecls
  | C_DumpTypeDecls
  | C_DumpTranslated
  | Choice_C_DumpFormat Cover ID C_DumpFormat C_DumpFormat
  | Choices_C_DumpFormat Cover ID [C_DumpFormat]
  | Fail_C_DumpFormat Cover FailInfo
  | Guard_C_DumpFormat Cover Constraints C_DumpFormat

instance Show C_DumpFormat where
  showsPrec d (Choice_C_DumpFormat cd i x y) = showsChoice d cd i x y
  showsPrec d (Choices_C_DumpFormat cd i xs) = showsChoices d cd i xs
  showsPrec d (Guard_C_DumpFormat cd c e) = showsGuard d cd c e
  showsPrec _ (Fail_C_DumpFormat cd info) = showChar '!'
  showsPrec _ C_DumpTypedFlat = showString "DumpTypedFlat"
  showsPrec _ C_DumpExtImports = showString "DumpExtImports"
  showsPrec _ C_DumpLifted = showString "DumpLifted"
  showsPrec _ C_DumpEliminated = showString "DumpEliminated"
  showsPrec _ C_DumpDefaulted = showString "DumpDefaulted"
  showsPrec _ C_DumpRenamed = showString "DumpRenamed"
  showsPrec _ C_DumpFunDecls = showString "DumpFunDecls"
  showsPrec _ C_DumpTypeDecls = showString "DumpTypeDecls"
  showsPrec _ C_DumpTranslated = showString "DumpTranslated"

instance Read C_DumpFormat where
  readsPrec _ s = readParen False (\r -> [(C_DumpTypedFlat, r0) | (_, r0) <-
    readQualified "CompilerOpts" "DumpTypedFlat" r]) s ++ (readParen False
    (\r -> [(C_DumpExtImports, r0) | (_, r0) <- readQualified "CompilerOpts"
    "DumpExtImports" r]) s ++ (readParen False (\r -> [(C_DumpLifted, r0) | (_
    , r0) <- readQualified "CompilerOpts" "DumpLifted" r]) s ++ (readParen False
    (\r -> [(C_DumpEliminated, r0) | (_, r0) <- readQualified "CompilerOpts"
    "DumpEliminated" r]) s ++ (readParen False (\r -> [(C_DumpDefaulted
    , r0) | (_, r0) <- readQualified "CompilerOpts" "DumpDefaulted" r]) s ++
    (readParen False (\r -> [(C_DumpRenamed, r0) | (_, r0) <- readQualified
    "CompilerOpts" "DumpRenamed" r]) s ++ (readParen False (\r ->
    [(C_DumpFunDecls, r0) | (_, r0) <- readQualified "CompilerOpts"
    "DumpFunDecls" r]) s ++ (readParen False (\r -> [(C_DumpTypeDecls, r0) | (_
    , r0) <- readQualified "CompilerOpts" "DumpTypeDecls" r]) s ++ readParen
    False (\r -> [(C_DumpTranslated, r0) | (_, r0) <- readQualified
    "CompilerOpts" "DumpTranslated" r]) s)))))))

instance NonDet C_DumpFormat where
  choiceCons = Choice_C_DumpFormat
  choicesCons = Choices_C_DumpFormat
  failCons = Fail_C_DumpFormat
  guardCons = Guard_C_DumpFormat
  try (Choice_C_DumpFormat cd i x y) = tryChoice cd i x y
  try (Choices_C_DumpFormat cd i xs) = tryChoices cd i xs
  try (Fail_C_DumpFormat cd info) = Fail cd info
  try (Guard_C_DumpFormat cd c e) = Guard cd c e
  try x = Val x
  match f _ _ _ _ _ (Choice_C_DumpFormat cd i x y) = f cd i x y
  match _ f _ _ _ _ (Choices_C_DumpFormat cd i@(NarrowedID _ _) xs) = f cd i xs
  match _ _ f _ _ _ (Choices_C_DumpFormat cd i@(FreeID _ _) xs) = f cd i xs
  match _ _ _ _ _ _ (Choices_C_DumpFormat cd i _) = error
    ("CompilerOpts.DumpFormat.match: Choices with ChoiceID " ++ show i)
  match _ _ _ f _ _ (Fail_C_DumpFormat cd info) = f cd info
  match _ _ _ _ f _ (Guard_C_DumpFormat cd c e) = f cd c e
  match _ _ _ _ _ f x = f x

instance Generable C_DumpFormat where
  generate s c = Choices_C_DumpFormat c (freeID [0, 0, 0, 0, 0, 0, 0, 0, 0] s)
    [C_DumpTypedFlat, C_DumpExtImports, C_DumpLifted, C_DumpEliminated
    , C_DumpDefaulted, C_DumpRenamed, C_DumpFunDecls, C_DumpTypeDecls
    , C_DumpTranslated]

instance NormalForm C_DumpFormat where
  ($!!) cont C_DumpTypedFlat d cs = cont C_DumpTypedFlat d cs
  ($!!) cont C_DumpExtImports d cs = cont C_DumpExtImports d cs
  ($!!) cont C_DumpLifted d cs = cont C_DumpLifted d cs
  ($!!) cont C_DumpEliminated d cs = cont C_DumpEliminated d cs
  ($!!) cont C_DumpDefaulted d cs = cont C_DumpDefaulted d cs
  ($!!) cont C_DumpRenamed d cs = cont C_DumpRenamed d cs
  ($!!) cont C_DumpFunDecls d cs = cont C_DumpFunDecls d cs
  ($!!) cont C_DumpTypeDecls d cs = cont C_DumpTypeDecls d cs
  ($!!) cont C_DumpTranslated d cs = cont C_DumpTranslated d cs
  ($!!) cont (Choice_C_DumpFormat cd i x y) d cs = nfChoice cont cd i x y cd cs
  ($!!) cont (Choices_C_DumpFormat cd i xs) d cs = nfChoices cont cd i xs d cs
  ($!!) cont (Guard_C_DumpFormat cd c e) d cs = guardCons cd c (($!!) cont e d
    (addCs c cs))
  ($!!) _ (Fail_C_DumpFormat cd info) _ _ = failCons cd info
  ($##) cont C_DumpTypedFlat d cs = cont C_DumpTypedFlat d cs
  ($##) cont C_DumpExtImports d cs = cont C_DumpExtImports d cs
  ($##) cont C_DumpLifted d cs = cont C_DumpLifted d cs
  ($##) cont C_DumpEliminated d cs = cont C_DumpEliminated d cs
  ($##) cont C_DumpDefaulted d cs = cont C_DumpDefaulted d cs
  ($##) cont C_DumpRenamed d cs = cont C_DumpRenamed d cs
  ($##) cont C_DumpFunDecls d cs = cont C_DumpFunDecls d cs
  ($##) cont C_DumpTypeDecls d cs = cont C_DumpTypeDecls d cs
  ($##) cont C_DumpTranslated d cs = cont C_DumpTranslated d cs
  ($##) cont (Choice_C_DumpFormat cd i x y) d cs = gnfChoice cont cd i x y cd cs
  ($##) cont (Choices_C_DumpFormat cd i xs) d cs = gnfChoices cont cd i xs d cs
  ($##) cont (Guard_C_DumpFormat cd c e) d cs = guardCons cd c (($##) cont e d
    (addCs c cs))
  ($##) _ (Fail_C_DumpFormat cd info) _ _ = failCons cd info
  showCons C_DumpTypedFlat = "CompilerOpts.DumpTypedFlat"
  showCons C_DumpExtImports = "CompilerOpts.DumpExtImports"
  showCons C_DumpLifted = "CompilerOpts.DumpLifted"
  showCons C_DumpEliminated = "CompilerOpts.DumpEliminated"
  showCons C_DumpDefaulted = "CompilerOpts.DumpDefaulted"
  showCons C_DumpRenamed = "CompilerOpts.DumpRenamed"
  showCons C_DumpFunDecls = "CompilerOpts.DumpFunDecls"
  showCons C_DumpTypeDecls = "CompilerOpts.DumpTypeDecls"
  showCons C_DumpTranslated = "CompilerOpts.DumpTranslated"
  showCons x = error ("CompilerOpts.DumpFormat.showCons: no constructor: " ++
    show x)
  searchNF _ cont C_DumpTypedFlat = cont C_DumpTypedFlat
  searchNF _ cont C_DumpExtImports = cont C_DumpExtImports
  searchNF _ cont C_DumpLifted = cont C_DumpLifted
  searchNF _ cont C_DumpEliminated = cont C_DumpEliminated
  searchNF _ cont C_DumpDefaulted = cont C_DumpDefaulted
  searchNF _ cont C_DumpRenamed = cont C_DumpRenamed
  searchNF _ cont C_DumpFunDecls = cont C_DumpFunDecls
  searchNF _ cont C_DumpTypeDecls = cont C_DumpTypeDecls
  searchNF _ cont C_DumpTranslated = cont C_DumpTranslated
  searchNF _ _ x = error
    ("CompilerOpts.DumpFormat.searchNF: no constructor: " ++ show x)

instance Unifiable C_DumpFormat where
  (=.=) C_DumpTypedFlat C_DumpTypedFlat d cs = C_True
  (=.=) C_DumpExtImports C_DumpExtImports d cs = C_True
  (=.=) C_DumpLifted C_DumpLifted d cs = C_True
  (=.=) C_DumpEliminated C_DumpEliminated d cs = C_True
  (=.=) C_DumpDefaulted C_DumpDefaulted d cs = C_True
  (=.=) C_DumpRenamed C_DumpRenamed d cs = C_True
  (=.=) C_DumpFunDecls C_DumpFunDecls d cs = C_True
  (=.=) C_DumpTypeDecls C_DumpTypeDecls d cs = C_True
  (=.=) C_DumpTranslated C_DumpTranslated d cs = C_True
  (=.=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  (=.<=) C_DumpTypedFlat C_DumpTypedFlat d cs = C_True
  (=.<=) C_DumpExtImports C_DumpExtImports d cs = C_True
  (=.<=) C_DumpLifted C_DumpLifted d cs = C_True
  (=.<=) C_DumpEliminated C_DumpEliminated d cs = C_True
  (=.<=) C_DumpDefaulted C_DumpDefaulted d cs = C_True
  (=.<=) C_DumpRenamed C_DumpRenamed d cs = C_True
  (=.<=) C_DumpFunDecls C_DumpFunDecls d cs = C_True
  (=.<=) C_DumpTypeDecls C_DumpTypeDecls d cs = C_True
  (=.<=) C_DumpTranslated C_DumpTranslated d cs = C_True
  (=.<=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  bind cd i C_DumpTypedFlat = (i :=: ChooseN 0 0) : concat []
  bind cd i C_DumpExtImports = (i :=: ChooseN 1 0) : concat []
  bind cd i C_DumpLifted = (i :=: ChooseN 2 0) : concat []
  bind cd i C_DumpEliminated = (i :=: ChooseN 3 0) : concat []
  bind cd i C_DumpDefaulted = (i :=: ChooseN 4 0) : concat []
  bind cd i C_DumpRenamed = (i :=: ChooseN 5 0) : concat []
  bind cd i C_DumpFunDecls = (i :=: ChooseN 6 0) : concat []
  bind cd i C_DumpTypeDecls = (i :=: ChooseN 7 0) : concat []
  bind cd i C_DumpTranslated = (i :=: ChooseN 8 0) : concat []
  bind d i (Choice_C_DumpFormat cd j x y) = [ConstraintChoice cd j (bind d i x)
    (bind d i y)]
  bind d i (Choices_C_DumpFormat cd j@(FreeID _ _) xs) = bindOrNarrow d i cd j
    xs
  bind d i (Choices_C_DumpFormat cd j@(NarrowedID _ _) xs) = [ConstraintChoices
    cd j (map (bind d i) xs)]
  bind _ _ (Choices_C_DumpFormat cd i _) = error
    ("CompilerOpts.DumpFormat.bind: Choices with ChoiceID: " ++ show i)
  bind _ _ (Fail_C_DumpFormat cd info) = [Unsolvable info]
  bind d i (Guard_C_DumpFormat cd c e) = getConstrList c ++ bind d i e
  lazyBind cd i C_DumpTypedFlat = (i :=: ChooseN 0 0) : []
  lazyBind cd i C_DumpExtImports = (i :=: ChooseN 1 0) : []
  lazyBind cd i C_DumpLifted = (i :=: ChooseN 2 0) : []
  lazyBind cd i C_DumpEliminated = (i :=: ChooseN 3 0) : []
  lazyBind cd i C_DumpDefaulted = (i :=: ChooseN 4 0) : []
  lazyBind cd i C_DumpRenamed = (i :=: ChooseN 5 0) : []
  lazyBind cd i C_DumpFunDecls = (i :=: ChooseN 6 0) : []
  lazyBind cd i C_DumpTypeDecls = (i :=: ChooseN 7 0) : []
  lazyBind cd i C_DumpTranslated = (i :=: ChooseN 8 0) : []
  lazyBind d i (Choice_C_DumpFormat cd j x y) = [ConstraintChoice cd j (lazyBind
    d i x) (lazyBind d i y)]
  lazyBind d i (Choices_C_DumpFormat cd j@(FreeID _ _) xs) = lazyBindOrNarrow d
    i cd j xs
  lazyBind d i (Choices_C_DumpFormat cd j@(NarrowedID _ _) xs) =
    [ConstraintChoices cd j (map (lazyBind d i) xs)]
  lazyBind _ _ (Choices_C_DumpFormat cd i _) = error
    ("CompilerOpts.DumpFormat.lazyBind: Choices with ChoiceID: " ++ show i)
  lazyBind _ _ (Fail_C_DumpFormat cd info) = [Unsolvable info]
  lazyBind d i (Guard_C_DumpFormat cd c e) = getConstrList c ++ [i :=: LazyBind
    (lazyBind d i e)]

instance Curry C_DumpFormat where

d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Verbosity :: Cover
  -> ConstStore -> Curry_Prelude.OP_uscore_Dict_hash_Eq C_Verbosity
d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Verbosity cd cs =
  Curry_Prelude.OP_uscore_Dict_hash_Eq (acceptCs id
  d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Verbosity)
  (d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Verbosity
  cd cs)

nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Verbosity :: IDSupply
  -> Cover -> ConstStore -> Curry_Prelude.OP_uscore_Dict_hash_Eq C_Verbosity
nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Verbosity s cd cs =
  Curry_Prelude.HO_OP_uscore_Dict_hash_Eq (wrapDX (wrapDX id) (acceptCs id
  d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Verbosity))
  (wrapDX (wrapDX id)
  (d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Verbosity
  cd cs))

d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Verbosity :: C_Verbosity
  -> C_Verbosity -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Verbosity x1 x2 cd cs =
  case x1 of
  C_VerbQuiet -> d_C__case_35 x2 cd cs
  C_VerbFrontend -> d_C__case_34 x2 cd cs
  C_VerbStatus -> d_C__case_33 x2 cd cs
  C_VerbAnalysis -> d_C__case_32 x2 cd cs
  C_VerbDetails -> d_C__case_31 x2 cd cs
  Choice_C_Verbosity d i l r -> narrow d i
    (d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Verbosity
    l x2 cd cs)
    (d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Verbosity
    r x2 cd cs)
  Choices_C_Verbosity d i xs -> narrows cs d i (\z ->
    d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Verbosity
    z x2 cd cs) xs
  Guard_C_Verbosity d c e -> guardCons d c
    (d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Verbosity
    e x2 cd $! addCs c cs)
  Fail_C_Verbosity d info -> failCons d (traceFail
    "CompilerOpts._impl#==#Prelude.Eq#CompilerOpts.Verbosity" [show x1, show x2]
    info)
  _ -> failCons cd (consFail
    "CompilerOpts._impl#==#Prelude.Eq#CompilerOpts.Verbosity" (showCons x1))

d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Verbosity :: Cover
  -> ConstStore -> C_Verbosity -> Cover -> ConstStore -> C_Verbosity -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Verbosity cd cs =
  acceptCs id (Curry_Prelude.d_OP_uscore_def_hash_slash_eq_hash_Prelude_dot_Eq
  (d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Verbosity cd cs))

d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity :: Cover
  -> ConstStore -> Curry_Prelude.OP_uscore_Dict_hash_Ord C_Verbosity
d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity cd cs =
  Curry_Prelude.OP_uscore_Dict_hash_Ord
  (d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Verbosity cd cs)
  (d_OP_uscore_impl_hash_compare_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity
  cd cs) (acceptCs id
  d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity)
  (d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity
  cd cs)
  (d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity
  cd cs)
  (d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity
  cd cs)
  (d_OP_uscore_impl_hash_min_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity
  cd cs)
  (d_OP_uscore_impl_hash_max_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity
  cd cs)

nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity :: IDSupply
  -> Cover -> ConstStore -> Curry_Prelude.OP_uscore_Dict_hash_Ord C_Verbosity
nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity s cd cs =
  let s0 = s
  in s0 `seq` Curry_Prelude.HO_OP_uscore_Dict_hash_Ord
  (nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Verbosity s0 cd
  cs) (wrapDX (wrapDX id)
  (d_OP_uscore_impl_hash_compare_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity
  cd cs)) (wrapDX (wrapDX id) (acceptCs id
  d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity))
  (wrapDX (wrapDX id)
  (d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity
  cd cs)) (wrapDX (wrapDX id)
  (d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity
  cd cs)) (wrapDX (wrapDX id)
  (d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity
  cd cs)) (wrapDX (wrapDX id)
  (d_OP_uscore_impl_hash_min_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity
  cd cs)) (wrapDX (wrapDX id)
  (d_OP_uscore_impl_hash_max_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity
  cd cs))

d_OP_uscore_impl_hash_compare_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity :: Cover
  -> ConstStore -> C_Verbosity -> Cover -> ConstStore -> C_Verbosity -> Cover
  -> ConstStore -> Curry_Prelude.C_Ordering
d_OP_uscore_impl_hash_compare_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity cd cs =
  acceptCs id (Curry_Prelude.d_OP_uscore_def_hash_compare_hash_Prelude_dot_Ord
  (d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity cd cs))

d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity :: C_Verbosity
  -> C_Verbosity -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity x1 x2 cd cs =
  case x1 of
  C_VerbQuiet -> d_C__case_30 x2 cd cs
  C_VerbFrontend -> d_C__case_29 x2 cd cs
  C_VerbStatus -> d_C__case_28 x2 cd cs
  C_VerbAnalysis -> d_C__case_27 x2 cd cs
  C_VerbDetails -> d_C__case_26 x2 cd cs
  Choice_C_Verbosity d i l r -> narrow d i
    (d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity
    l x2 cd cs)
    (d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity
    r x2 cd cs)
  Choices_C_Verbosity d i xs -> narrows cs d i (\z ->
    d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity
    z x2 cd cs) xs
  Guard_C_Verbosity d c e -> guardCons d c
    (d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity
    e x2 cd $! addCs c cs)
  Fail_C_Verbosity d info -> failCons d (traceFail
    "CompilerOpts._impl#<=#Prelude.Ord#CompilerOpts.Verbosity" [show x1, show
    x2] info)
  _ -> failCons cd (consFail
    "CompilerOpts._impl#<=#Prelude.Ord#CompilerOpts.Verbosity" (showCons x1))

d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity :: Cover
  -> ConstStore -> C_Verbosity -> Cover -> ConstStore -> C_Verbosity -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity cd cs =
  acceptCs id (Curry_Prelude.d_OP_uscore_def_hash_gt_eq_hash_Prelude_dot_Ord
  (d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity cd cs))

d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity :: Cover
  -> ConstStore -> C_Verbosity -> Cover -> ConstStore -> C_Verbosity -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity cd cs =
  acceptCs id (Curry_Prelude.d_OP_uscore_def_hash_lt_hash_Prelude_dot_Ord
  (d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity cd cs))

d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity :: Cover
  -> ConstStore -> C_Verbosity -> Cover -> ConstStore -> C_Verbosity -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity cd cs =
  acceptCs id (Curry_Prelude.d_OP_uscore_def_hash_gt_hash_Prelude_dot_Ord
  (d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity cd cs))

d_OP_uscore_impl_hash_min_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity :: Cover
  -> ConstStore -> C_Verbosity -> Cover -> ConstStore -> C_Verbosity -> Cover
  -> ConstStore -> C_Verbosity
d_OP_uscore_impl_hash_min_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity cd cs =
  acceptCs id (Curry_Prelude.d_OP_uscore_def_hash_min_hash_Prelude_dot_Ord
  (d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity cd cs))

d_OP_uscore_impl_hash_max_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity :: Cover
  -> ConstStore -> C_Verbosity -> Cover -> ConstStore -> C_Verbosity -> Cover
  -> ConstStore -> C_Verbosity
d_OP_uscore_impl_hash_max_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity cd cs =
  acceptCs id (Curry_Prelude.d_OP_uscore_def_hash_max_hash_Prelude_dot_Ord
  (d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity cd cs))

d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_OptimLevel :: Cover
  -> ConstStore -> Curry_Prelude.OP_uscore_Dict_hash_Eq C_OptimLevel
d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_OptimLevel cd cs =
  Curry_Prelude.OP_uscore_Dict_hash_Eq (acceptCs id
  d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_OptimLevel)
  (d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_OptimLevel
  cd cs)

nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_OptimLevel :: IDSupply
  -> Cover -> ConstStore -> Curry_Prelude.OP_uscore_Dict_hash_Eq C_OptimLevel
nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_OptimLevel s cd cs =
  Curry_Prelude.HO_OP_uscore_Dict_hash_Eq (wrapDX (wrapDX id) (acceptCs id
  d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_OptimLevel))
  (wrapDX (wrapDX id)
  (d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_OptimLevel
  cd cs))

d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_OptimLevel :: C_OptimLevel
  -> C_OptimLevel -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_OptimLevel x1 x2 cd cs =
  case x1 of
  C_OptimNone -> d_C__case_25 x2 cd cs
  C_OptimHigherOrder -> d_C__case_24 x2 cd cs
  C_OptimStrictSupply -> d_C__case_23 x2 cd cs
  Choice_C_OptimLevel d i l r -> narrow d i
    (d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_OptimLevel
    l x2 cd cs)
    (d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_OptimLevel
    r x2 cd cs)
  Choices_C_OptimLevel d i xs -> narrows cs d i (\z ->
    d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_OptimLevel
    z x2 cd cs) xs
  Guard_C_OptimLevel d c e -> guardCons d c
    (d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_OptimLevel
    e x2 cd $! addCs c cs)
  Fail_C_OptimLevel d info -> failCons d (traceFail
    "CompilerOpts._impl#==#Prelude.Eq#CompilerOpts.OptimLevel" [show x1, show
    x2] info)
  _ -> failCons cd (consFail
    "CompilerOpts._impl#==#Prelude.Eq#CompilerOpts.OptimLevel" (showCons x1))

d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_OptimLevel :: Cover
  -> ConstStore -> C_OptimLevel -> Cover -> ConstStore -> C_OptimLevel -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_OptimLevel cd cs =
  acceptCs id (Curry_Prelude.d_OP_uscore_def_hash_slash_eq_hash_Prelude_dot_Eq
  (d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_OptimLevel cd cs))

d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel :: Cover
  -> ConstStore -> Curry_Prelude.OP_uscore_Dict_hash_Ord C_OptimLevel
d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel cd cs =
  Curry_Prelude.OP_uscore_Dict_hash_Ord
  (d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_OptimLevel cd cs)
  (d_OP_uscore_impl_hash_compare_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
  cd cs) (acceptCs id
  d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel)
  (d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
  cd cs)
  (d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
  cd cs)
  (d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
  cd cs)
  (d_OP_uscore_impl_hash_min_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
  cd cs)
  (d_OP_uscore_impl_hash_max_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
  cd cs)

nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel :: IDSupply
  -> Cover -> ConstStore -> Curry_Prelude.OP_uscore_Dict_hash_Ord C_OptimLevel
nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel s cd cs =
  let s0 = s
  in s0 `seq` Curry_Prelude.HO_OP_uscore_Dict_hash_Ord
  (nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_OptimLevel s0 cd
  cs) (wrapDX (wrapDX id)
  (d_OP_uscore_impl_hash_compare_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
  cd cs)) (wrapDX (wrapDX id) (acceptCs id
  d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel))
  (wrapDX (wrapDX id)
  (d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
  cd cs)) (wrapDX (wrapDX id)
  (d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
  cd cs)) (wrapDX (wrapDX id)
  (d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
  cd cs)) (wrapDX (wrapDX id)
  (d_OP_uscore_impl_hash_min_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
  cd cs)) (wrapDX (wrapDX id)
  (d_OP_uscore_impl_hash_max_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
  cd cs))

d_OP_uscore_impl_hash_compare_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel :: Cover
  -> ConstStore -> C_OptimLevel -> Cover -> ConstStore -> C_OptimLevel -> Cover
  -> ConstStore -> Curry_Prelude.C_Ordering
d_OP_uscore_impl_hash_compare_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel cd cs =
  acceptCs id (Curry_Prelude.d_OP_uscore_def_hash_compare_hash_Prelude_dot_Ord
  (d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel cd
  cs))

d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel :: C_OptimLevel
  -> C_OptimLevel -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel x1 x2 cd cs =
  case x1 of
  C_OptimNone -> d_C__case_22 x2 cd cs
  C_OptimHigherOrder -> d_C__case_21 x2 cd cs
  C_OptimStrictSupply -> d_C__case_20 x2 cd cs
  Choice_C_OptimLevel d i l r -> narrow d i
    (d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
    l x2 cd cs)
    (d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
    r x2 cd cs)
  Choices_C_OptimLevel d i xs -> narrows cs d i (\z ->
    d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
    z x2 cd cs) xs
  Guard_C_OptimLevel d c e -> guardCons d c
    (d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
    e x2 cd $! addCs c cs)
  Fail_C_OptimLevel d info -> failCons d (traceFail
    "CompilerOpts._impl#<=#Prelude.Ord#CompilerOpts.OptimLevel" [show x1, show
    x2] info)
  _ -> failCons cd (consFail
    "CompilerOpts._impl#<=#Prelude.Ord#CompilerOpts.OptimLevel" (showCons x1))

d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel :: Cover
  -> ConstStore -> C_OptimLevel -> Cover -> ConstStore -> C_OptimLevel -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel cd cs =
  acceptCs id (Curry_Prelude.d_OP_uscore_def_hash_gt_eq_hash_Prelude_dot_Ord
  (d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel cd
  cs))

d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel :: Cover
  -> ConstStore -> C_OptimLevel -> Cover -> ConstStore -> C_OptimLevel -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel cd cs =
  acceptCs id (Curry_Prelude.d_OP_uscore_def_hash_lt_hash_Prelude_dot_Ord
  (d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel cd
  cs))

d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel :: Cover
  -> ConstStore -> C_OptimLevel -> Cover -> ConstStore -> C_OptimLevel -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel cd cs =
  acceptCs id (Curry_Prelude.d_OP_uscore_def_hash_gt_hash_Prelude_dot_Ord
  (d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel cd
  cs))

d_OP_uscore_impl_hash_min_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel :: Cover
  -> ConstStore -> C_OptimLevel -> Cover -> ConstStore -> C_OptimLevel -> Cover
  -> ConstStore -> C_OptimLevel
d_OP_uscore_impl_hash_min_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel cd cs =
  acceptCs id (Curry_Prelude.d_OP_uscore_def_hash_min_hash_Prelude_dot_Ord
  (d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel cd
  cs))

d_OP_uscore_impl_hash_max_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel :: Cover
  -> ConstStore -> C_OptimLevel -> Cover -> ConstStore -> C_OptimLevel -> Cover
  -> ConstStore -> C_OptimLevel
d_OP_uscore_impl_hash_max_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel cd cs =
  acceptCs id (Curry_Prelude.d_OP_uscore_def_hash_max_hash_Prelude_dot_Ord
  (d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel cd
  cs))

d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Extension :: Cover
  -> ConstStore -> Curry_Prelude.OP_uscore_Dict_hash_Eq C_Extension
d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Extension cd cs =
  Curry_Prelude.OP_uscore_Dict_hash_Eq (acceptCs id
  d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Extension)
  (d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Extension
  cd cs)

nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Extension :: IDSupply
  -> Cover -> ConstStore -> Curry_Prelude.OP_uscore_Dict_hash_Eq C_Extension
nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Extension s cd cs =
  Curry_Prelude.HO_OP_uscore_Dict_hash_Eq (wrapDX (wrapDX id) (acceptCs id
  d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Extension))
  (wrapDX (wrapDX id)
  (d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Extension
  cd cs))

d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Extension :: C_Extension
  -> C_Extension -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Extension x1 x2 cd cs =
  case x1 of
  C_AnonFreeVars -> d_C__case_19 x2 cd cs
  C_FunctionalPatterns -> d_C__case_18 x2 cd cs
  C_NoImplicitPrelude -> d_C__case_17 x2 cd cs
  Choice_C_Extension d i l r -> narrow d i
    (d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Extension
    l x2 cd cs)
    (d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Extension
    r x2 cd cs)
  Choices_C_Extension d i xs -> narrows cs d i (\z ->
    d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Extension
    z x2 cd cs) xs
  Guard_C_Extension d c e -> guardCons d c
    (d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Extension
    e x2 cd $! addCs c cs)
  Fail_C_Extension d info -> failCons d (traceFail
    "CompilerOpts._impl#==#Prelude.Eq#CompilerOpts.Extension" [show x1, show x2]
    info)
  _ -> failCons cd (consFail
    "CompilerOpts._impl#==#Prelude.Eq#CompilerOpts.Extension" (showCons x1))

d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Extension :: Cover
  -> ConstStore -> C_Extension -> Cover -> ConstStore -> C_Extension -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Extension cd cs =
  acceptCs id (Curry_Prelude.d_OP_uscore_def_hash_slash_eq_hash_Prelude_dot_Eq
  (d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Extension cd cs))

d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_DumpFormat :: Cover
  -> ConstStore -> Curry_Prelude.OP_uscore_Dict_hash_Eq C_DumpFormat
d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_DumpFormat cd cs =
  Curry_Prelude.OP_uscore_Dict_hash_Eq (acceptCs id
  d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_DumpFormat)
  (d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_DumpFormat
  cd cs)

nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_DumpFormat :: IDSupply
  -> Cover -> ConstStore -> Curry_Prelude.OP_uscore_Dict_hash_Eq C_DumpFormat
nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_DumpFormat s cd cs =
  Curry_Prelude.HO_OP_uscore_Dict_hash_Eq (wrapDX (wrapDX id) (acceptCs id
  d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_DumpFormat))
  (wrapDX (wrapDX id)
  (d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_DumpFormat
  cd cs))

d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_DumpFormat :: C_DumpFormat
  -> C_DumpFormat -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_DumpFormat x1 x2 cd cs =
  case x1 of
  C_DumpTypedFlat -> d_C__case_16 x2 cd cs
  C_DumpExtImports -> d_C__case_15 x2 cd cs
  C_DumpLifted -> d_C__case_14 x2 cd cs
  C_DumpEliminated -> d_C__case_13 x2 cd cs
  C_DumpDefaulted -> d_C__case_12 x2 cd cs
  C_DumpRenamed -> d_C__case_11 x2 cd cs
  C_DumpFunDecls -> d_C__case_10 x2 cd cs
  C_DumpTypeDecls -> d_C__case_9 x2 cd cs
  C_DumpTranslated -> d_C__case_8 x2 cd cs
  Choice_C_DumpFormat d i l r -> narrow d i
    (d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_DumpFormat
    l x2 cd cs)
    (d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_DumpFormat
    r x2 cd cs)
  Choices_C_DumpFormat d i xs -> narrows cs d i (\z ->
    d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_DumpFormat
    z x2 cd cs) xs
  Guard_C_DumpFormat d c e -> guardCons d c
    (d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_DumpFormat
    e x2 cd $! addCs c cs)
  Fail_C_DumpFormat d info -> failCons d (traceFail
    "CompilerOpts._impl#==#Prelude.Eq#CompilerOpts.DumpFormat" [show x1, show
    x2] info)
  _ -> failCons cd (consFail
    "CompilerOpts._impl#==#Prelude.Eq#CompilerOpts.DumpFormat" (showCons x1))

d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_DumpFormat :: Cover
  -> ConstStore -> C_DumpFormat -> Cover -> ConstStore -> C_DumpFormat -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_DumpFormat cd cs =
  acceptCs id (Curry_Prelude.d_OP_uscore_def_hash_slash_eq_hash_Prelude_dot_Eq
  (d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_DumpFormat cd cs))

d_C_version :: Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_version cd cs = Curry_Prelude.d_C_concat (Curry_Prelude.OP_Cons
  (Curry_Installation.d_C_compilerName cd cs) (Curry_Prelude.OP_Cons
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString " (Version ")
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Int
  cd cs) (Curry_Installation.d_C_majorVersion cd cs) cd cs)
  (Curry_Prelude.OP_Cons (Curry_Prelude.C_Char '.'#) (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Int
  cd cs) (Curry_Installation.d_C_minorVersion cd cs) cd cs)) cd cs) cd cs)
  (Curry_Prelude.OP_Cons (Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.toCurryString " of ") (Curry_Prelude.d_OP_plus_plus
  (Curry_Installation.d_C_compilerDate cd cs) (Curry_Prelude.toCurryString ")")
  cd cs) cd cs) Curry_Prelude.OP_List))) cd cs

d_C_optHelp :: C_Options -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_optHelp x1 cd cs = case x1 of
  C_Opts x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 -> x2
  Choice_C_Options d i l r -> narrow d i (d_C_optHelp l cd cs) (d_C_optHelp r cd
    cs)
  Choices_C_Options d i xs -> narrows cs d i (\z -> d_C_optHelp z cd cs) xs
  Guard_C_Options d c e -> guardCons d c (d_C_optHelp e cd $! addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail "CompilerOpts.optHelp" [show
    x1] info)
  _ -> failCons cd (consFail "CompilerOpts.optHelp" (showCons x1))

d_C_optVersion :: C_Options -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_optVersion x1 cd cs = case x1 of
  C_Opts x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 -> x3
  Choice_C_Options d i l r -> narrow d i (d_C_optVersion l cd cs)
    (d_C_optVersion r cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z -> d_C_optVersion z cd cs) xs
  Guard_C_Options d c e -> guardCons d c (d_C_optVersion e cd $! addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail "CompilerOpts.optVersion" [show
    x1] info)
  _ -> failCons cd (consFail "CompilerOpts.optVersion" (showCons x1))

d_C_optVerbosity :: C_Options -> Cover -> ConstStore -> C_Verbosity
d_C_optVerbosity x1 cd cs = case x1 of
  C_Opts x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 -> x4
  Choice_C_Options d i l r -> narrow d i (d_C_optVerbosity l cd cs)
    (d_C_optVerbosity r cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z -> d_C_optVerbosity z cd cs) xs
  Guard_C_Options d c e -> guardCons d c (d_C_optVerbosity e cd $! addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail "CompilerOpts.optVerbosity"
    [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.optVerbosity" (showCons x1))

d_C_optMainVerbosity :: C_Options -> Cover -> ConstStore -> C_Verbosity
d_C_optMainVerbosity x1 cd cs = case x1 of
  C_Opts x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 -> x5
  Choice_C_Options d i l r -> narrow d i (d_C_optMainVerbosity l cd cs)
    (d_C_optMainVerbosity r cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z -> d_C_optMainVerbosity z cd
    cs) xs
  Guard_C_Options d c e -> guardCons d c (d_C_optMainVerbosity e cd $! addCs c
    cs)
  Fail_C_Options d info -> failCons d (traceFail "CompilerOpts.optMainVerbosity"
    [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.optMainVerbosity" (showCons x1))

d_C_optForce :: C_Options -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_optForce x1 cd cs = case x1 of
  C_Opts x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 -> x6
  Choice_C_Options d i l r -> narrow d i (d_C_optForce l cd cs) (d_C_optForce r
    cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z -> d_C_optForce z cd cs) xs
  Guard_C_Options d c e -> guardCons d c (d_C_optForce e cd $! addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail "CompilerOpts.optForce" [show
    x1] info)
  _ -> failCons cd (consFail "CompilerOpts.optForce" (showCons x1))

d_C_optImportPaths :: C_Options -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_optImportPaths x1 cd cs = case x1 of
  C_Opts x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 -> x7
  Choice_C_Options d i l r -> narrow d i (d_C_optImportPaths l cd cs)
    (d_C_optImportPaths r cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z -> d_C_optImportPaths z cd cs)
    xs
  Guard_C_Options d c e -> guardCons d c (d_C_optImportPaths e cd $! addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail "CompilerOpts.optImportPaths"
    [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.optImportPaths" (showCons x1))

d_C_optOutputSubdir :: C_Options -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_optOutputSubdir x1 cd cs = case x1 of
  C_Opts x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 -> x8
  Choice_C_Options d i l r -> narrow d i (d_C_optOutputSubdir l cd cs)
    (d_C_optOutputSubdir r cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z -> d_C_optOutputSubdir z cd cs)
    xs
  Guard_C_Options d c e -> guardCons d c (d_C_optOutputSubdir e cd $! addCs c
    cs)
  Fail_C_Options d info -> failCons d (traceFail "CompilerOpts.optOutputSubdir"
    [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.optOutputSubdir" (showCons x1))

d_C_optOptimization :: C_Options -> Cover -> ConstStore -> C_OptimLevel
d_C_optOptimization x1 cd cs = case x1 of
  C_Opts x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 -> x9
  Choice_C_Options d i l r -> narrow d i (d_C_optOptimization l cd cs)
    (d_C_optOptimization r cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z -> d_C_optOptimization z cd cs)
    xs
  Guard_C_Options d c e -> guardCons d c (d_C_optOptimization e cd $! addCs c
    cs)
  Fail_C_Options d info -> failCons d (traceFail "CompilerOpts.optOptimization"
    [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.optOptimization" (showCons x1))

d_C_optExtensions :: C_Options -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_Extension
d_C_optExtensions x1 cd cs = case x1 of
  C_Opts x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 -> x10
  Choice_C_Options d i l r -> narrow d i (d_C_optExtensions l cd cs)
    (d_C_optExtensions r cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z -> d_C_optExtensions z cd cs)
    xs
  Guard_C_Options d c e -> guardCons d c (d_C_optExtensions e cd $! addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail "CompilerOpts.optExtensions"
    [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.optExtensions" (showCons x1))

d_C_optDump :: C_Options -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_DumpFormat
d_C_optDump x1 cd cs = case x1 of
  C_Opts x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 -> x11
  Choice_C_Options d i l r -> narrow d i (d_C_optDump l cd cs) (d_C_optDump r cd
    cs)
  Choices_C_Options d i xs -> narrows cs d i (\z -> d_C_optDump z cd cs) xs
  Guard_C_Options d c e -> guardCons d c (d_C_optDump e cd $! addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail "CompilerOpts.optDump" [show
    x1] info)
  _ -> failCons cd (consFail "CompilerOpts.optDump" (showCons x1))

d_C_optParser :: C_Options -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_optParser x1 cd cs = case x1 of
  C_Opts x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 -> x12
  Choice_C_Options d i l r -> narrow d i (d_C_optParser l cd cs) (d_C_optParser
    r cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z -> d_C_optParser z cd cs) xs
  Guard_C_Options d c e -> guardCons d c (d_C_optParser e cd $! addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail "CompilerOpts.optParser" [show
    x1] info)
  _ -> failCons cd (consFail "CompilerOpts.optParser" (showCons x1))

d_C_optTraceFailure :: C_Options -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_optTraceFailure x1 cd cs = case x1 of
  C_Opts x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 -> x13
  Choice_C_Options d i l r -> narrow d i (d_C_optTraceFailure l cd cs)
    (d_C_optTraceFailure r cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z -> d_C_optTraceFailure z cd cs)
    xs
  Guard_C_Options d c e -> guardCons d c (d_C_optTraceFailure e cd $! addCs c
    cs)
  Fail_C_Options d info -> failCons d (traceFail "CompilerOpts.optTraceFailure"
    [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.optTraceFailure" (showCons x1))

d_C_rcVars :: C_Options -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_rcVars x1 cd cs = case x1 of
  C_Opts x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 -> x14
  Choice_C_Options d i l r -> narrow d i (d_C_rcVars l cd cs) (d_C_rcVars r cd
    cs)
  Choices_C_Options d i xs -> narrows cs d i (\z -> d_C_rcVars z cd cs) xs
  Guard_C_Options d c e -> guardCons d c (d_C_rcVars e cd $! addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail "CompilerOpts.rcVars" [show x1]
    info)
  _ -> failCons cd (consFail "CompilerOpts.rcVars" (showCons x1))

d_C_defaultOptions :: Cover -> ConstStore -> C_Options
d_C_defaultOptions cd cs = C_Opts Curry_Prelude.C_False Curry_Prelude.C_False
  C_VerbStatus C_VerbStatus Curry_Prelude.C_False Curry_Prelude.OP_List
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_FilePath.d_OP_lt_slash_gt cd cs) (Curry_Prelude.toCurryString ".curry")
  cd cs) (Curry_Prelude.toCurryString "kics2") cd cs) C_OptimStrictSupply
  Curry_Prelude.OP_List Curry_Prelude.OP_List Curry_Prelude.OP_List
  Curry_Prelude.C_False Curry_Prelude.OP_List

d_C_verbosities :: Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple3 C_Verbosity (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_verbosities cd cs = Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple3
  C_VerbQuiet (Curry_Prelude.toCurryString "0") (Curry_Prelude.toCurryString
  "quiet")) (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple3 C_VerbFrontend
  (Curry_Prelude.toCurryString "1") (Curry_Prelude.toCurryString
  "frontend status")) (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple3
  C_VerbStatus (Curry_Prelude.toCurryString "2") (Curry_Prelude.toCurryString
  "own status")) (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple3 C_VerbAnalysis
  (Curry_Prelude.toCurryString "3") (Curry_Prelude.toCurryString "analysis"))
  (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple3 C_VerbDetails
  (Curry_Prelude.toCurryString "4") (Curry_Prelude.toCurryString "details"))
  Curry_Prelude.OP_List))))

d_C_optimizations :: Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple3 C_OptimLevel (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_optimizations cd cs = Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple3
  C_OptimNone (Curry_Prelude.toCurryString "0") (Curry_Prelude.toCurryString
  "no optimization")) (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple3
  C_OptimHigherOrder (Curry_Prelude.toCurryString "1")
  (Curry_Prelude.toCurryString "higher order")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple3 C_OptimStrictSupply (Curry_Prelude.toCurryString "2")
  (Curry_Prelude.toCurryString "strict supply evaluation (default)"))
  Curry_Prelude.OP_List))

d_C_extensions :: Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple3 C_Extension (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_extensions cd cs = Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple3
  C_AnonFreeVars (Curry_Prelude.toCurryString "AnonFreeVars")
  (Curry_Prelude.toCurryString "enable anonymous free variables"))
  (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple3 C_FunctionalPatterns
  (Curry_Prelude.toCurryString "FunctionalPatterns")
  (Curry_Prelude.toCurryString "enable functional patterns"))
  (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple3 C_NoImplicitPrelude
  (Curry_Prelude.toCurryString "NoImplicitPrelude") (Curry_Prelude.toCurryString
  "do not implicitly import the Prelude")) Curry_Prelude.OP_List))

d_C_dumpLevel :: Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple3 C_DumpFormat (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_dumpLevel cd cs = Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple3
  C_DumpTypedFlat (Curry_Prelude.toCurryString "dump-typed")
  (Curry_Prelude.toCurryString "typed FlatCurry")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple3 C_DumpExtImports (Curry_Prelude.toCurryString
  "dump-imports") (Curry_Prelude.toCurryString "result of completing imports"))
  (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple3 C_DumpLifted
  (Curry_Prelude.toCurryString "dump-lifted") (Curry_Prelude.toCurryString
  "result of case lifting")) (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple3
  C_DumpEliminated (Curry_Prelude.toCurryString "dump-condelim")
  (Curry_Prelude.toCurryString "result of cond elimination"))
  (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple3 C_DumpDefaulted
  (Curry_Prelude.toCurryString "dump-defaulted") (Curry_Prelude.toCurryString
  "result of type defaulting")) (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple3
  C_DumpRenamed (Curry_Prelude.toCurryString "dump-renamed")
  (Curry_Prelude.toCurryString "result of renaming")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple3 C_DumpFunDecls (Curry_Prelude.toCurryString
  "dump-fun-decls") (Curry_Prelude.toCurryString
  "result of function translation")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple3 C_DumpTypeDecls (Curry_Prelude.toCurryString
  "dump-type-decls") (Curry_Prelude.toCurryString "result of type translation"))
  (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple3 C_DumpTranslated
  (Curry_Prelude.toCurryString "dump-trans") (Curry_Prelude.toCurryString
  "result of entire translation")) Curry_Prelude.OP_List))))))))

d_C_onOpts :: (C_Options -> Cover -> ConstStore -> C_Options)
  -> Curry_Prelude.OP_Tuple2 C_Options (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 C_Options (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_onOpts x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> Curry_Prelude.OP_Tuple2
    (Curry_Prelude.d_C_apply x1 x3 cd cs) x4
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C_onOpts x1 l cd cs)
    (d_C_onOpts x1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C_onOpts x1
    z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C_onOpts x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "CompilerOpts.onOpts" [show x1, show x2] info)
  _ -> failCons cd (consFail "CompilerOpts.onOpts" (showCons x2))

nd_C_onOpts :: Func C_Options C_Options -> Curry_Prelude.OP_Tuple2 C_Options
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 C_Options
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C_onOpts x1 x2 s cd cs = case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> let s0 = s
    in s0 `seq` Curry_Prelude.OP_Tuple2 (Curry_Prelude.nd_C_apply x1 x3 s0 cd
    cs) x4
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (nd_C_onOpts x1 l s cd
    cs) (nd_C_onOpts x1 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> nd_C_onOpts x1
    z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (nd_C_onOpts x1 e s cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "CompilerOpts.onOpts" [show x1, show x2] info)
  _ -> failCons cd (consFail "CompilerOpts.onOpts" (showCons x2))

d_C_onOptsArg :: (Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> C_Options -> Cover -> ConstStore -> C_Options)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_Tuple2
  C_Options (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 C_Options
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_onOptsArg x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Tuple2 x4 x5 -> Curry_Prelude.OP_Tuple2
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x1 x2 cd cs) x4 cd cs) x5
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C_onOptsArg x1 x2 l cd
    cs) (d_C_onOptsArg x1 x2 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C_onOptsArg
    x1 x2 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C_onOptsArg x1 x2 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "CompilerOpts.onOptsArg" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "CompilerOpts.onOptsArg" (showCons x3))

nd_C_onOptsArg :: Func (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Func
  C_Options C_Options) -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_Tuple2 C_Options (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 C_Options (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C_onOptsArg x1 x2 x3 s cd cs = case x3 of
  Curry_Prelude.OP_Tuple2 x4 x5 -> let s2 = s
    in s2 `seq` Curry_Prelude.OP_Tuple2 (let s1 = leftSupply s2
                                             s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x1
    x2 s0 cd cs) x4 s1 cd cs)) x5
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (nd_C_onOptsArg x1 x2 l s
    cd cs) (nd_C_onOptsArg x1 x2 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> nd_C_onOptsArg
    x1 x2 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (nd_C_onOptsArg x1 x2 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "CompilerOpts.onOptsArg" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "CompilerOpts.onOptsArg" (showCons x3))

d_C_addErr :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_Tuple2 C_Options (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 C_Options (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_addErr x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> Curry_Prelude.OP_Tuple2 x3
    (Curry_Prelude.d_OP_plus_plus x4 (Curry_Prelude.OP_Cons x1
    Curry_Prelude.OP_List) cd cs)
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C_addErr x1 l cd cs)
    (d_C_addErr x1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C_addErr x1
    z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C_addErr x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "CompilerOpts.addErr" [show x1, show x2] info)
  _ -> failCons cd (consFail "CompilerOpts.addErr" (showCons x2))

d_C_mkOptErrOption :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple3
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (C_Options -> Cover -> ConstStore -> C_Options))
  -> Cover -> ConstStore -> Curry_GetOpt.C_OptDescr (Curry_Prelude.OP_Tuple2
  C_Options (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 C_Options
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_C_mkOptErrOption x1 x2 x3 x4 x5 cd cs = Curry_GetOpt.C_Option x1 x2
  (Curry_GetOpt.C_ReqArg (d_C_parseOptErr x4 x5) x3)
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "set ")
  (Curry_Prelude.d_OP_plus_plus x4 (Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.toCurryString " `") (Curry_Prelude.d_OP_plus_plus x3
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "', where `")
  (Curry_Prelude.d_OP_plus_plus x3 (Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.toCurryString "' is one of\n") (d_C_renderOptErrTable x5 cd cs)
  cd cs) cd cs) cd cs) cd cs) cd cs) cd cs) cd cs)

nd_C_mkOptErrOption :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple3
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Func C_Options C_Options)) -> IDSupply -> Cover
  -> ConstStore -> Curry_GetOpt.C_OptDescr (Func (Curry_Prelude.OP_Tuple2
  C_Options (Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))) (Curry_Prelude.OP_Tuple2 C_Options
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))))
nd_C_mkOptErrOption x1 x2 x3 x4 x5 s cd cs = let s0 = s
  in s0 `seq` Curry_GetOpt.C_Option x1 x2 (Curry_GetOpt.HO_C_ReqArg (wrapNX id
  (nd_C_parseOptErr x4 x5)) x3) (Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.toCurryString "set ") (Curry_Prelude.d_OP_plus_plus x4
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString " `")
  (Curry_Prelude.d_OP_plus_plus x3 (Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.toCurryString "', where `") (Curry_Prelude.d_OP_plus_plus x3
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "' is one of\n")
  (nd_C_renderOptErrTable x5 s0 cd cs) cd cs) cd cs) cd cs) cd cs) cd cs) cd cs)
  cd cs)

d_C_parseOptErr :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple3 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) (C_Options
  -> Cover -> ConstStore -> C_Options)) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  C_Options (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 C_Options
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_parseOptErr x1 x2 x3 cd cs = d_C__case_7 x2 x3 x1
  (d_OP_parseOptErr_dot_lookup3_dot_22
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs) x3 x2 cd cs) cd cs

nd_C_parseOptErr :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple3 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Func
  C_Options C_Options)) -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> IDSupply -> Cover -> ConstStore -> Func (Curry_Prelude.OP_Tuple2 C_Options
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
  (Curry_Prelude.OP_Tuple2 C_Options (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
nd_C_parseOptErr x1 x2 x3 s cd cs = let s6 = s
  in s6 `seq` (let s5 = leftSupply s6
                   s4 = rightSupply s6
  in s5 `seq` (s4 `seq` nd_C__case_7 x2 x3 x1 (let s3 = leftSupply s4
                                                   s2 = rightSupply s4
  in s3 `seq` (s2 `seq` nd_OP_parseOptErr_dot_lookup3_dot_22
  (let s1 = leftSupply s2
       s0 = rightSupply s2
  in s1 `seq` (s0 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char s0
  cd cs) s1 cd cs)) x3 x2 s3 cd cs)) s5 cd cs))

d_OP_parseOptErr_dot_lookup3_dot_22 :: forall t0 t1 t2 . (Curry_Prelude.Curry t2
  , Curry_Prelude.Curry t1, Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0 -> t0 -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple3 t0 t1 t2) -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe t2
d_OP_parseOptErr_dot_lookup3_dot_22 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_Nothing
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_6 x2 x1 x5 x4 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_parseOptErr_dot_lookup3_dot_22 x1 x2 l cd cs)
    (d_OP_parseOptErr_dot_lookup3_dot_22 x1 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_parseOptErr_dot_lookup3_dot_22 x1 x2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_parseOptErr_dot_lookup3_dot_22 x1 x2 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "CompilerOpts.parseOptErr.lookup3.22" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "CompilerOpts.parseOptErr.lookup3.22" (showCons
    x3))

nd_OP_parseOptErr_dot_lookup3_dot_22 :: forall t0 t1 t2 . (Curry_Prelude.Curry
  t2, Curry_Prelude.Curry t1, Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0 -> t0 -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple3 t0 t1 t2) -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe t2
nd_OP_parseOptErr_dot_lookup3_dot_22 x1 x2 x3 s cd cs = case x3 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_Nothing
  Curry_Prelude.OP_Cons x4 x5 -> let s0 = s
    in s0 `seq` nd_C__case_6 x2 x1 x5 x4 s0 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (nd_OP_parseOptErr_dot_lookup3_dot_22 x1 x2 l s cd cs)
    (nd_OP_parseOptErr_dot_lookup3_dot_22 x1 x2 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    nd_OP_parseOptErr_dot_lookup3_dot_22 x1 x2 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (nd_OP_parseOptErr_dot_lookup3_dot_22 x1 x2 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "CompilerOpts.parseOptErr.lookup3.22" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "CompilerOpts.parseOptErr.lookup3.22" (showCons
    x3))

d_C_renderOptErrTable :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple3
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (C_Options -> Cover -> ConstStore -> C_Options))
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_renderOptErrTable x1 cd cs = let x2 = Curry_Prelude.d_OP_dollar
                                       (Curry_List.d_C_maximum
                                       (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
                                       cd cs)) (Curry_Prelude.d_C_map
                                       d_OP_renderOptErrTable_dot_uscore_hash_lambda171
                                       x1 cd cs) cd cs
  in Curry_Prelude.d_OP_dollar (Curry_List.d_C_intercalate
  (Curry_Prelude.toCurryString "\n")) (Curry_Prelude.d_C_map
  (d_OP_renderOptErrTable_dot_uscore_hash_lambda172 x2) x1 cd cs) cd cs

nd_C_renderOptErrTable :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple3
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Func C_Options C_Options)) -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
nd_C_renderOptErrTable x1 s cd cs = let s8 = s
  in s8 `seq` (let s3 = leftSupply s8
                   s7 = rightSupply s8
  in s3 `seq` (s7 `seq` (let x2 = let s2 = leftSupply s3
                                      s4 = rightSupply s3
                                      s0 = leftSupply s4
                                      s1 = rightSupply s4
                               in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq`
                               Curry_Prelude.nd_OP_dollar (wrapNX id
                               (Curry_List.nd_C_maximum
                               (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
                               s0 cd cs))) (Curry_Prelude.nd_C_map (wrapNX id
                               nd_OP_renderOptErrTable_dot_uscore_hash_lambda171)
                               x1 s1 cd cs) s2 cd cs)))
  in let s6 = leftSupply s7
         s5 = rightSupply s7
  in s6 `seq` (s5 `seq` Curry_Prelude.nd_OP_dollar (wrapDX id
  (Curry_List.d_C_intercalate (Curry_Prelude.toCurryString "\n")))
  (Curry_Prelude.nd_C_map (wrapNX id
  (nd_OP_renderOptErrTable_dot_uscore_hash_lambda172 x2)) x1 s5 cd cs) s6 cd
  cs))))

d_OP_renderOptErrTable_dot_uscore_hash_lambda171 :: Curry_Prelude.OP_Tuple3
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (C_Options -> Cover -> ConstStore -> C_Options) -> Cover
  -> ConstStore -> Curry_Prelude.C_Int
d_OP_renderOptErrTable_dot_uscore_hash_lambda171 x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> Curry_Prelude.d_C_length x2 cd cs
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (d_OP_renderOptErrTable_dot_uscore_hash_lambda171 l cd cs)
    (d_OP_renderOptErrTable_dot_uscore_hash_lambda171 r cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    d_OP_renderOptErrTable_dot_uscore_hash_lambda171 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (d_OP_renderOptErrTable_dot_uscore_hash_lambda171 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "CompilerOpts.renderOptErrTable._#lambda171" [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.renderOptErrTable._#lambda171"
    (showCons x1))

nd_OP_renderOptErrTable_dot_uscore_hash_lambda171 :: Curry_Prelude.OP_Tuple3
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Func C_Options C_Options) -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.C_Int
nd_OP_renderOptErrTable_dot_uscore_hash_lambda171 x1 s cd cs = case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> Curry_Prelude.d_C_length x2 cd cs
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (nd_OP_renderOptErrTable_dot_uscore_hash_lambda171 l s cd cs)
    (nd_OP_renderOptErrTable_dot_uscore_hash_lambda171 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    nd_OP_renderOptErrTable_dot_uscore_hash_lambda171 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (nd_OP_renderOptErrTable_dot_uscore_hash_lambda171 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "CompilerOpts.renderOptErrTable._#lambda171" [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.renderOptErrTable._#lambda171"
    (showCons x1))

d_OP_renderOptErrTable_dot_rpad_dot_34 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_renderOptErrTable_dot_rpad_dot_34 x1 x2 cd cs =
  Curry_Prelude.d_OP_plus_plus x2 (Curry_Prelude.d_C_replicate
  (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
  x1 (Curry_Prelude.d_C_length x2 cd cs) cd cs) (Curry_Prelude.C_Char ' '#) cd
  cs) cd cs

d_OP_renderOptErrTable_dot_uscore_hash_lambda172 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple3 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (C_Options -> Cover -> ConstStore
  -> C_Options) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_renderOptErrTable_dot_uscore_hash_lambda172 x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_Tuple3 x3 x4 x5 -> Curry_Prelude.d_OP_plus_plus
    (d_OP_renderOptErrTable_dot_rpad_dot_34 x1 x3 cd cs)
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString ": ") x4 cd cs)
    cd cs
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (d_OP_renderOptErrTable_dot_uscore_hash_lambda172 x1 l cd cs)
    (d_OP_renderOptErrTable_dot_uscore_hash_lambda172 x1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    d_OP_renderOptErrTable_dot_uscore_hash_lambda172 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (d_OP_renderOptErrTable_dot_uscore_hash_lambda172 x1 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "CompilerOpts.renderOptErrTable._#lambda172" [show x1, show x2] info)
  _ -> failCons cd (consFail "CompilerOpts.renderOptErrTable._#lambda172"
    (showCons x2))

nd_OP_renderOptErrTable_dot_uscore_hash_lambda172 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple3 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Func C_Options C_Options)
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
nd_OP_renderOptErrTable_dot_uscore_hash_lambda172 x1 x2 s cd cs = case x2 of
  Curry_Prelude.OP_Tuple3 x3 x4 x5 -> Curry_Prelude.d_OP_plus_plus
    (d_OP_renderOptErrTable_dot_rpad_dot_34 x1 x3 cd cs)
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString ": ") x4 cd cs)
    cd cs
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (nd_OP_renderOptErrTable_dot_uscore_hash_lambda172 x1 l s cd cs)
    (nd_OP_renderOptErrTable_dot_uscore_hash_lambda172 x1 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    nd_OP_renderOptErrTable_dot_uscore_hash_lambda172 x1 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (nd_OP_renderOptErrTable_dot_uscore_hash_lambda172 x1 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "CompilerOpts.renderOptErrTable._#lambda172" [show x1, show x2] info)
  _ -> failCons cd (consFail "CompilerOpts.renderOptErrTable._#lambda172"
    (showCons x2))

d_C_options :: Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_GetOpt.C_OptDescr (Curry_Prelude.OP_Tuple2 C_Options
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 C_Options (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))))
d_C_options cd cs = Curry_Prelude.OP_Cons (Curry_GetOpt.C_Option
  (Curry_Prelude.toCurryString "h?") (Curry_Prelude.OP_Cons
  (Curry_Prelude.toCurryString "help") Curry_Prelude.OP_List)
  (Curry_GetOpt.C_NoArg (Curry_Prelude.d_OP_dollar (acceptCs id d_C_onOpts)
  d_OP_options_dot_uscore_hash_lambda173 cd cs)) (Curry_Prelude.toCurryString
  "display this help and exit")) (Curry_Prelude.OP_Cons (Curry_GetOpt.C_Option
  (Curry_Prelude.toCurryString "V") (Curry_Prelude.OP_Cons
  (Curry_Prelude.toCurryString "version") Curry_Prelude.OP_List)
  (Curry_GetOpt.C_NoArg (Curry_Prelude.d_OP_dollar (acceptCs id d_C_onOpts)
  d_OP_options_dot_uscore_hash_lambda188 cd cs)) (Curry_Prelude.toCurryString
  "show the version number and exit")) (Curry_Prelude.OP_Cons
  (d_C_mkOptErrOption (Curry_Prelude.toCurryString "v") (Curry_Prelude.OP_Cons
  (Curry_Prelude.toCurryString "verbosity") Curry_Prelude.OP_List)
  (Curry_Prelude.toCurryString "n") (Curry_Prelude.toCurryString
  "verbosity level") (d_C_verbDescriptions cd cs) cd cs) (Curry_Prelude.OP_Cons
  (Curry_GetOpt.C_Option (Curry_Prelude.toCurryString "f")
  (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "force")
  Curry_Prelude.OP_List) (Curry_GetOpt.C_NoArg (Curry_Prelude.d_OP_dollar
  (acceptCs id d_C_onOpts) d_OP_options_dot_uscore_hash_lambda203 cd cs))
  (Curry_Prelude.toCurryString "force recompilation of target files"))
  (Curry_Prelude.OP_Cons (Curry_GetOpt.C_Option (Curry_Prelude.toCurryString
  "i") (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "import-dir")
  Curry_Prelude.OP_List) (Curry_GetOpt.C_ReqArg (Curry_Prelude.d_OP_dollar
  (acceptCs (acceptCs id) d_C_onOptsArg) (acceptCs id
  d_OP_options_dot_uscore_hash_lambda218) cd cs) (Curry_Prelude.toCurryString
  "dir[:dir]")) (Curry_Prelude.toCurryString
  "search for imports in `dir[:dir]'")) (Curry_Prelude.OP_Cons
  (Curry_GetOpt.C_Option (Curry_Prelude.toCurryString "o")
  (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "output-subdir")
  Curry_Prelude.OP_List) (Curry_GetOpt.C_ReqArg (Curry_Prelude.d_OP_dollar
  (acceptCs (acceptCs id) d_C_onOptsArg) (acceptCs id
  d_OP_options_dot_uscore_hash_lambda233) cd cs) (Curry_Prelude.toCurryString
  "dir")) (Curry_Prelude.toCurryString "output compiled modules to `dir'"))
  (Curry_Prelude.OP_Cons (d_C_mkOptErrOption (Curry_Prelude.toCurryString "X")
  Curry_Prelude.OP_List (Curry_Prelude.toCurryString "ext")
  (Curry_Prelude.toCurryString "language extension") (d_C_extDescriptions cd cs)
  cd cs) (Curry_Prelude.OP_Cons (d_C_mkOptErrOption (Curry_Prelude.toCurryString
  "O") Curry_Prelude.OP_List (Curry_Prelude.toCurryString "n")
  (Curry_Prelude.toCurryString "optimization level") (d_C_optimDescriptions cd
  cs) cd cs) (Curry_Prelude.OP_Cons (d_C_mkOptErrOption
  (Curry_Prelude.toCurryString "d") Curry_Prelude.OP_List
  (Curry_Prelude.toCurryString "opt") (Curry_Prelude.toCurryString
  "debug option") (d_C_dumpDescriptions cd cs) cd cs) (Curry_Prelude.OP_Cons
  (Curry_GetOpt.C_Option Curry_Prelude.OP_List (Curry_Prelude.OP_Cons
  (Curry_Prelude.toCurryString "parse-options") Curry_Prelude.OP_List)
  (Curry_GetOpt.C_ReqArg (Curry_Prelude.d_OP_dollar (acceptCs (acceptCs id)
  d_C_onOptsArg) (acceptCs id d_OP_options_dot_uscore_hash_lambda248) cd cs)
  (Curry_Prelude.toCurryString "options")) (Curry_Prelude.toCurryString
  "additional options for the parser")) (Curry_Prelude.OP_Cons
  (Curry_GetOpt.C_Option Curry_Prelude.OP_List (Curry_Prelude.OP_Cons
  (Curry_Prelude.toCurryString "trace-failure") Curry_Prelude.OP_List)
  (Curry_GetOpt.C_NoArg (Curry_Prelude.d_OP_dollar (acceptCs id d_C_onOpts)
  d_OP_options_dot_uscore_hash_lambda263 cd cs)) (Curry_Prelude.toCurryString
  "Trace failures in deterministic program")) Curry_Prelude.OP_List))))))))))

nd_C_options :: IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_GetOpt.C_OptDescr (Func (Curry_Prelude.OP_Tuple2 C_Options
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
  (Curry_Prelude.OP_Tuple2 C_Options (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))))
nd_C_options s cd cs = let s28 = s
  in s28 `seq` (let s0 = leftSupply s28
                    s27 = rightSupply s28
  in s0 `seq` (s27 `seq` Curry_Prelude.OP_Cons (Curry_GetOpt.C_Option
  (Curry_Prelude.toCurryString "h?") (Curry_Prelude.OP_Cons
  (Curry_Prelude.toCurryString "help") Curry_Prelude.OP_List)
  (Curry_GetOpt.C_NoArg (Curry_Prelude.nd_OP_dollar (wrapDX (wrapNX id)
  (acceptCs id nd_C_onOpts)) (wrapDX id d_OP_options_dot_uscore_hash_lambda173)
  s0 cd cs)) (Curry_Prelude.toCurryString "display this help and exit"))
  (let s1 = leftSupply s27
       s26 = rightSupply s27
  in s1 `seq` (s26 `seq` Curry_Prelude.OP_Cons (Curry_GetOpt.C_Option
  (Curry_Prelude.toCurryString "V") (Curry_Prelude.OP_Cons
  (Curry_Prelude.toCurryString "version") Curry_Prelude.OP_List)
  (Curry_GetOpt.C_NoArg (Curry_Prelude.nd_OP_dollar (wrapDX (wrapNX id)
  (acceptCs id nd_C_onOpts)) (wrapDX id d_OP_options_dot_uscore_hash_lambda188)
  s1 cd cs)) (Curry_Prelude.toCurryString "show the version number and exit"))
  (let s4 = leftSupply s26
       s25 = rightSupply s26
  in s4 `seq` (s25 `seq` Curry_Prelude.OP_Cons (let s3 = leftSupply s4
                                                    s2 = rightSupply s4
  in s3 `seq` (s2 `seq` nd_C_mkOptErrOption (Curry_Prelude.toCurryString "v")
  (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "verbosity")
  Curry_Prelude.OP_List) (Curry_Prelude.toCurryString "n")
  (Curry_Prelude.toCurryString "verbosity level") (nd_C_verbDescriptions s2 cd
  cs) s3 cd cs)) (let s5 = leftSupply s25
                      s24 = rightSupply s25
  in s5 `seq` (s24 `seq` Curry_Prelude.OP_Cons (Curry_GetOpt.C_Option
  (Curry_Prelude.toCurryString "f") (Curry_Prelude.OP_Cons
  (Curry_Prelude.toCurryString "force") Curry_Prelude.OP_List)
  (Curry_GetOpt.C_NoArg (Curry_Prelude.nd_OP_dollar (wrapDX (wrapNX id)
  (acceptCs id nd_C_onOpts)) (wrapDX id d_OP_options_dot_uscore_hash_lambda203)
  s5 cd cs)) (Curry_Prelude.toCurryString
  "force recompilation of target files")) (let s6 = leftSupply s24
                                               s23 = rightSupply s24
  in s6 `seq` (s23 `seq` Curry_Prelude.OP_Cons (Curry_GetOpt.C_Option
  (Curry_Prelude.toCurryString "i") (Curry_Prelude.OP_Cons
  (Curry_Prelude.toCurryString "import-dir") Curry_Prelude.OP_List)
  (Curry_GetOpt.HO_C_ReqArg (Curry_Prelude.nd_OP_dollar (wrapDX (wrapDX (wrapNX
  id)) (acceptCs (acceptCs id) nd_C_onOptsArg)) (wrapDX (wrapDX id) (acceptCs id
  d_OP_options_dot_uscore_hash_lambda218)) s6 cd cs)
  (Curry_Prelude.toCurryString "dir[:dir]")) (Curry_Prelude.toCurryString
  "search for imports in `dir[:dir]'")) (let s7 = leftSupply s23
                                             s22 = rightSupply s23
  in s7 `seq` (s22 `seq` Curry_Prelude.OP_Cons (Curry_GetOpt.C_Option
  (Curry_Prelude.toCurryString "o") (Curry_Prelude.OP_Cons
  (Curry_Prelude.toCurryString "output-subdir") Curry_Prelude.OP_List)
  (Curry_GetOpt.HO_C_ReqArg (Curry_Prelude.nd_OP_dollar (wrapDX (wrapDX (wrapNX
  id)) (acceptCs (acceptCs id) nd_C_onOptsArg)) (wrapDX (wrapDX id) (acceptCs id
  d_OP_options_dot_uscore_hash_lambda233)) s7 cd cs)
  (Curry_Prelude.toCurryString "dir")) (Curry_Prelude.toCurryString
  "output compiled modules to `dir'")) (let s10 = leftSupply s22
                                            s21 = rightSupply s22
  in s10 `seq` (s21 `seq` Curry_Prelude.OP_Cons (let s9 = leftSupply s10
                                                     s8 = rightSupply s10
  in s9 `seq` (s8 `seq` nd_C_mkOptErrOption (Curry_Prelude.toCurryString "X")
  Curry_Prelude.OP_List (Curry_Prelude.toCurryString "ext")
  (Curry_Prelude.toCurryString "language extension") (nd_C_extDescriptions s8 cd
  cs) s9 cd cs)) (let s13 = leftSupply s21
                      s20 = rightSupply s21
  in s13 `seq` (s20 `seq` Curry_Prelude.OP_Cons (let s12 = leftSupply s13
                                                     s11 = rightSupply s13
  in s12 `seq` (s11 `seq` nd_C_mkOptErrOption (Curry_Prelude.toCurryString "O")
  Curry_Prelude.OP_List (Curry_Prelude.toCurryString "n")
  (Curry_Prelude.toCurryString "optimization level") (nd_C_optimDescriptions s11
  cd cs) s12 cd cs)) (let s16 = leftSupply s20
                          s19 = rightSupply s20
  in s16 `seq` (s19 `seq` Curry_Prelude.OP_Cons (let s15 = leftSupply s16
                                                     s14 = rightSupply s16
  in s15 `seq` (s14 `seq` nd_C_mkOptErrOption (Curry_Prelude.toCurryString "d")
  Curry_Prelude.OP_List (Curry_Prelude.toCurryString "opt")
  (Curry_Prelude.toCurryString "debug option") (nd_C_dumpDescriptions s14 cd cs)
  s15 cd cs)) (let s17 = leftSupply s19
                   s18 = rightSupply s19
  in s17 `seq` (s18 `seq` Curry_Prelude.OP_Cons (Curry_GetOpt.C_Option
  Curry_Prelude.OP_List (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString
  "parse-options") Curry_Prelude.OP_List) (Curry_GetOpt.HO_C_ReqArg
  (Curry_Prelude.nd_OP_dollar (wrapDX (wrapDX (wrapNX id)) (acceptCs (acceptCs
  id) nd_C_onOptsArg)) (wrapDX (wrapDX id) (acceptCs id
  d_OP_options_dot_uscore_hash_lambda248)) s17 cd cs)
  (Curry_Prelude.toCurryString "options")) (Curry_Prelude.toCurryString
  "additional options for the parser")) (Curry_Prelude.OP_Cons
  (Curry_GetOpt.C_Option Curry_Prelude.OP_List (Curry_Prelude.OP_Cons
  (Curry_Prelude.toCurryString "trace-failure") Curry_Prelude.OP_List)
  (Curry_GetOpt.C_NoArg (Curry_Prelude.nd_OP_dollar (wrapDX (wrapNX id)
  (acceptCs id nd_C_onOpts)) (wrapDX id d_OP_options_dot_uscore_hash_lambda263)
  s18 cd cs)) (Curry_Prelude.toCurryString
  "Trace failures in deterministic program"))
  Curry_Prelude.OP_List)))))))))))))))))))))

d_OP_options_dot_uscore_hash_lambda173 :: C_Options -> Cover -> ConstStore
  -> C_Options
d_OP_options_dot_uscore_hash_lambda173 x1 cd cs = case x1 of
  C_Opts x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 -> C_Opts
    Curry_Prelude.C_True x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14
  Choice_C_Options d i l r -> narrow d i (d_OP_options_dot_uscore_hash_lambda173
    l cd cs) (d_OP_options_dot_uscore_hash_lambda173 r cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z ->
    d_OP_options_dot_uscore_hash_lambda173 z cd cs) xs
  Guard_C_Options d c e -> guardCons d c (d_OP_options_dot_uscore_hash_lambda173
    e cd $! addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail
    "CompilerOpts.options._#lambda173" [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.options._#lambda173" (showCons x1))

d_OP_options_dot_uscore_hash_lambda188 :: C_Options -> Cover -> ConstStore
  -> C_Options
d_OP_options_dot_uscore_hash_lambda188 x1 cd cs = case x1 of
  C_Opts x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 -> C_Opts x2
    Curry_Prelude.C_True x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14
  Choice_C_Options d i l r -> narrow d i (d_OP_options_dot_uscore_hash_lambda188
    l cd cs) (d_OP_options_dot_uscore_hash_lambda188 r cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z ->
    d_OP_options_dot_uscore_hash_lambda188 z cd cs) xs
  Guard_C_Options d c e -> guardCons d c (d_OP_options_dot_uscore_hash_lambda188
    e cd $! addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail
    "CompilerOpts.options._#lambda188" [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.options._#lambda188" (showCons x1))

d_OP_options_dot_uscore_hash_lambda203 :: C_Options -> Cover -> ConstStore
  -> C_Options
d_OP_options_dot_uscore_hash_lambda203 x1 cd cs = case x1 of
  C_Opts x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 -> C_Opts x2 x3 x4 x5
    Curry_Prelude.C_True x7 x8 x9 x10 x11 x12 x13 x14
  Choice_C_Options d i l r -> narrow d i (d_OP_options_dot_uscore_hash_lambda203
    l cd cs) (d_OP_options_dot_uscore_hash_lambda203 r cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z ->
    d_OP_options_dot_uscore_hash_lambda203 z cd cs) xs
  Guard_C_Options d c e -> guardCons d c (d_OP_options_dot_uscore_hash_lambda203
    e cd $! addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail
    "CompilerOpts.options._#lambda203" [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.options._#lambda203" (showCons x1))

d_OP_options_dot_uscore_hash_lambda218 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> C_Options -> Cover -> ConstStore -> C_Options
d_OP_options_dot_uscore_hash_lambda218 x1 x2 cd cs = case x2 of
  C_Opts x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 x15 -> C_Opts x3 x4 x5 x6 x7
    (Curry_List.d_C_nub
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) (Curry_Prelude.d_OP_plus_plus (d_C_optImportPaths x2 cd cs)
    (Curry_Prelude.d_C_apply (Curry_FilePath.d_C_splitSearchPath cd cs) x1 cd
    cs) cd cs) cd cs) x9 x10 x11 x12 x13 x14 x15
  Choice_C_Options d i l r -> narrow d i (d_OP_options_dot_uscore_hash_lambda218
    x1 l cd cs) (d_OP_options_dot_uscore_hash_lambda218 x1 r cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z ->
    d_OP_options_dot_uscore_hash_lambda218 x1 z cd cs) xs
  Guard_C_Options d c e -> guardCons d c (d_OP_options_dot_uscore_hash_lambda218
    x1 e cd $! addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail
    "CompilerOpts.options._#lambda218" [show x1, show x2] info)
  _ -> failCons cd (consFail "CompilerOpts.options._#lambda218" (showCons x2))

d_OP_options_dot_uscore_hash_lambda233 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> C_Options -> Cover -> ConstStore -> C_Options
d_OP_options_dot_uscore_hash_lambda233 x1 x2 cd cs = case x2 of
  C_Opts x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 x15 -> C_Opts x3 x4 x5 x6 x7
    x8 x1 x10 x11 x12 x13 x14 x15
  Choice_C_Options d i l r -> narrow d i (d_OP_options_dot_uscore_hash_lambda233
    x1 l cd cs) (d_OP_options_dot_uscore_hash_lambda233 x1 r cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z ->
    d_OP_options_dot_uscore_hash_lambda233 x1 z cd cs) xs
  Guard_C_Options d c e -> guardCons d c (d_OP_options_dot_uscore_hash_lambda233
    x1 e cd $! addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail
    "CompilerOpts.options._#lambda233" [show x1, show x2] info)
  _ -> failCons cd (consFail "CompilerOpts.options._#lambda233" (showCons x2))

d_OP_options_dot_uscore_hash_lambda248 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> C_Options -> Cover -> ConstStore -> C_Options
d_OP_options_dot_uscore_hash_lambda248 x1 x2 cd cs = case x2 of
  C_Opts x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 x15 -> C_Opts x3 x4 x5 x6 x7
    x8 x9 x10 x11 x12 x1 x14 x15
  Choice_C_Options d i l r -> narrow d i (d_OP_options_dot_uscore_hash_lambda248
    x1 l cd cs) (d_OP_options_dot_uscore_hash_lambda248 x1 r cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z ->
    d_OP_options_dot_uscore_hash_lambda248 x1 z cd cs) xs
  Guard_C_Options d c e -> guardCons d c (d_OP_options_dot_uscore_hash_lambda248
    x1 e cd $! addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail
    "CompilerOpts.options._#lambda248" [show x1, show x2] info)
  _ -> failCons cd (consFail "CompilerOpts.options._#lambda248" (showCons x2))

d_OP_options_dot_uscore_hash_lambda263 :: C_Options -> Cover -> ConstStore
  -> C_Options
d_OP_options_dot_uscore_hash_lambda263 x1 cd cs = case x1 of
  C_Opts x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 -> C_Opts x2 x3 x4 x5 x6 x7
    x8 x9 x10 x11 x12 Curry_Prelude.C_True x14
  Choice_C_Options d i l r -> narrow d i (d_OP_options_dot_uscore_hash_lambda263
    l cd cs) (d_OP_options_dot_uscore_hash_lambda263 r cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z ->
    d_OP_options_dot_uscore_hash_lambda263 z cd cs) xs
  Guard_C_Options d c e -> guardCons d c (d_OP_options_dot_uscore_hash_lambda263
    e cd $! addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail
    "CompilerOpts.options._#lambda263" [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.options._#lambda263" (showCons x1))

d_C_verbDescriptions :: Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple3 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (C_Options -> Cover -> ConstStore
  -> C_Options))
d_C_verbDescriptions cd cs = Curry_Prelude.d_C_map
  d_OP_verbDescriptions_dot_toDescr_dot_53 (d_C_verbosities cd cs) cd cs

nd_C_verbDescriptions :: IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple3 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Func
  C_Options C_Options))
nd_C_verbDescriptions s cd cs = let s0 = s
  in s0 `seq` Curry_Prelude.nd_C_map (wrapNX id
  nd_OP_verbDescriptions_dot_toDescr_dot_53) (d_C_verbosities cd cs) s0 cd cs

d_OP_verbDescriptions_dot_set_dot_53 :: C_Verbosity -> C_Options -> Cover
  -> ConstStore -> C_Options
d_OP_verbDescriptions_dot_set_dot_53 x1 x2 cd cs = case x2 of
  C_Opts x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 x15 -> C_Opts x3 x4 x1 x6 x7
    x8 x9 x10 x11 x12 x13 x14 x15
  Choice_C_Options d i l r -> narrow d i (d_OP_verbDescriptions_dot_set_dot_53
    x1 l cd cs) (d_OP_verbDescriptions_dot_set_dot_53 x1 r cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z ->
    d_OP_verbDescriptions_dot_set_dot_53 x1 z cd cs) xs
  Guard_C_Options d c e -> guardCons d c (d_OP_verbDescriptions_dot_set_dot_53
    x1 e cd $! addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail
    "CompilerOpts.verbDescriptions.set.53" [show x1, show x2] info)
  _ -> failCons cd (consFail "CompilerOpts.verbDescriptions.set.53" (showCons
    x2))

d_OP_verbDescriptions_dot_toDescr_dot_53 :: forall t0 t1 . (Curry_Prelude.Curry
  t1, Curry_Prelude.Curry t0) => Curry_Prelude.OP_Tuple3 C_Verbosity t0 t1
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple3 t0 t1 (C_Options -> Cover
  -> ConstStore -> C_Options)
d_OP_verbDescriptions_dot_toDescr_dot_53 x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> Curry_Prelude.OP_Tuple3 x3 x4
    (d_OP_verbDescriptions_dot_set_dot_53 x2)
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (d_OP_verbDescriptions_dot_toDescr_dot_53 l cd cs)
    (d_OP_verbDescriptions_dot_toDescr_dot_53 r cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    d_OP_verbDescriptions_dot_toDescr_dot_53 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (d_OP_verbDescriptions_dot_toDescr_dot_53 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "CompilerOpts.verbDescriptions.toDescr.53" [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.verbDescriptions.toDescr.53"
    (showCons x1))

nd_OP_verbDescriptions_dot_toDescr_dot_53 :: forall t0 t1 . (Curry_Prelude.Curry
  t1, Curry_Prelude.Curry t0) => Curry_Prelude.OP_Tuple3 C_Verbosity t0 t1
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple3 t0 t1 (Func
  C_Options C_Options)
nd_OP_verbDescriptions_dot_toDescr_dot_53 x1 s cd cs = case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> Curry_Prelude.OP_Tuple3 x3 x4 (wrapDX id
    (d_OP_verbDescriptions_dot_set_dot_53 x2))
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (nd_OP_verbDescriptions_dot_toDescr_dot_53 l s cd cs)
    (nd_OP_verbDescriptions_dot_toDescr_dot_53 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    nd_OP_verbDescriptions_dot_toDescr_dot_53 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (nd_OP_verbDescriptions_dot_toDescr_dot_53 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "CompilerOpts.verbDescriptions.toDescr.53" [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.verbDescriptions.toDescr.53"
    (showCons x1))

d_C_optimDescriptions :: Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple3 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (C_Options -> Cover -> ConstStore
  -> C_Options))
d_C_optimDescriptions cd cs = Curry_Prelude.d_C_map
  d_OP_optimDescriptions_dot_toDescr_dot_59 (d_C_optimizations cd cs) cd cs

nd_C_optimDescriptions :: IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple3 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Func
  C_Options C_Options))
nd_C_optimDescriptions s cd cs = let s0 = s
  in s0 `seq` Curry_Prelude.nd_C_map (wrapNX id
  nd_OP_optimDescriptions_dot_toDescr_dot_59) (d_C_optimizations cd cs) s0 cd cs

d_OP_optimDescriptions_dot_set_dot_59 :: C_OptimLevel -> C_Options -> Cover
  -> ConstStore -> C_Options
d_OP_optimDescriptions_dot_set_dot_59 x1 x2 cd cs = case x2 of
  C_Opts x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 x15 -> C_Opts x3 x4 x5 x6 x7
    x8 x9 x1 x11 x12 x13 x14 x15
  Choice_C_Options d i l r -> narrow d i (d_OP_optimDescriptions_dot_set_dot_59
    x1 l cd cs) (d_OP_optimDescriptions_dot_set_dot_59 x1 r cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z ->
    d_OP_optimDescriptions_dot_set_dot_59 x1 z cd cs) xs
  Guard_C_Options d c e -> guardCons d c (d_OP_optimDescriptions_dot_set_dot_59
    x1 e cd $! addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail
    "CompilerOpts.optimDescriptions.set.59" [show x1, show x2] info)
  _ -> failCons cd (consFail "CompilerOpts.optimDescriptions.set.59" (showCons
    x2))

d_OP_optimDescriptions_dot_toDescr_dot_59 :: forall t0 t1 . (Curry_Prelude.Curry
  t1, Curry_Prelude.Curry t0) => Curry_Prelude.OP_Tuple3 C_OptimLevel t0 t1
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple3 t0 t1 (C_Options -> Cover
  -> ConstStore -> C_Options)
d_OP_optimDescriptions_dot_toDescr_dot_59 x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> Curry_Prelude.OP_Tuple3 x3 x4
    (d_OP_optimDescriptions_dot_set_dot_59 x2)
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (d_OP_optimDescriptions_dot_toDescr_dot_59 l cd cs)
    (d_OP_optimDescriptions_dot_toDescr_dot_59 r cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    d_OP_optimDescriptions_dot_toDescr_dot_59 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (d_OP_optimDescriptions_dot_toDescr_dot_59 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "CompilerOpts.optimDescriptions.toDescr.59" [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.optimDescriptions.toDescr.59"
    (showCons x1))

nd_OP_optimDescriptions_dot_toDescr_dot_59 :: forall t0
  t1 . (Curry_Prelude.Curry t1, Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_Tuple3 C_OptimLevel t0 t1 -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple3 t0 t1 (Func C_Options C_Options)
nd_OP_optimDescriptions_dot_toDescr_dot_59 x1 s cd cs = case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> Curry_Prelude.OP_Tuple3 x3 x4 (wrapDX id
    (d_OP_optimDescriptions_dot_set_dot_59 x2))
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (nd_OP_optimDescriptions_dot_toDescr_dot_59 l s cd cs)
    (nd_OP_optimDescriptions_dot_toDescr_dot_59 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    nd_OP_optimDescriptions_dot_toDescr_dot_59 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (nd_OP_optimDescriptions_dot_toDescr_dot_59 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "CompilerOpts.optimDescriptions.toDescr.59" [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.optimDescriptions.toDescr.59"
    (showCons x1))

d_C_extDescriptions :: Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple3 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (C_Options -> Cover -> ConstStore
  -> C_Options))
d_C_extDescriptions cd cs = Curry_Prelude.d_C_map
  d_OP_extDescriptions_dot_toDescr_dot_65 (d_C_extensions cd cs) cd cs

nd_C_extDescriptions :: IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple3 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Func C_Options C_Options))
nd_C_extDescriptions s cd cs = let s0 = s
  in s0 `seq` Curry_Prelude.nd_C_map (wrapNX id
  nd_OP_extDescriptions_dot_toDescr_dot_65) (d_C_extensions cd cs) s0 cd cs

d_OP_extDescriptions_dot_set_dot_65 :: C_Extension -> C_Options -> Cover
  -> ConstStore -> C_Options
d_OP_extDescriptions_dot_set_dot_65 x1 x2 cd cs = case x2 of
  C_Opts x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 x15 -> C_Opts x3 x4 x5 x6 x7
    x8 x9 x10 (d_C_addFlag
    (d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_Extension cd cs)
    x1 (d_C_optExtensions x2 cd cs) cd cs) x12 x13 x14 x15
  Choice_C_Options d i l r -> narrow d i (d_OP_extDescriptions_dot_set_dot_65 x1
    l cd cs) (d_OP_extDescriptions_dot_set_dot_65 x1 r cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z ->
    d_OP_extDescriptions_dot_set_dot_65 x1 z cd cs) xs
  Guard_C_Options d c e -> guardCons d c (d_OP_extDescriptions_dot_set_dot_65 x1
    e cd $! addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail
    "CompilerOpts.extDescriptions.set.65" [show x1, show x2] info)
  _ -> failCons cd (consFail "CompilerOpts.extDescriptions.set.65" (showCons
    x2))

d_OP_extDescriptions_dot_toDescr_dot_65 :: forall t0 t1 . (Curry_Prelude.Curry
  t1, Curry_Prelude.Curry t0) => Curry_Prelude.OP_Tuple3 C_Extension t0 t1
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple3 t0 t1 (C_Options -> Cover
  -> ConstStore -> C_Options)
d_OP_extDescriptions_dot_toDescr_dot_65 x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> Curry_Prelude.OP_Tuple3 x3 x4
    (d_OP_extDescriptions_dot_set_dot_65 x2)
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (d_OP_extDescriptions_dot_toDescr_dot_65 l cd cs)
    (d_OP_extDescriptions_dot_toDescr_dot_65 r cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    d_OP_extDescriptions_dot_toDescr_dot_65 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (d_OP_extDescriptions_dot_toDescr_dot_65 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "CompilerOpts.extDescriptions.toDescr.65" [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.extDescriptions.toDescr.65" (showCons
    x1))

nd_OP_extDescriptions_dot_toDescr_dot_65 :: forall t0 t1 . (Curry_Prelude.Curry
  t1, Curry_Prelude.Curry t0) => Curry_Prelude.OP_Tuple3 C_Extension t0 t1
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple3 t0 t1 (Func
  C_Options C_Options)
nd_OP_extDescriptions_dot_toDescr_dot_65 x1 s cd cs = case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> Curry_Prelude.OP_Tuple3 x3 x4 (wrapDX id
    (d_OP_extDescriptions_dot_set_dot_65 x2))
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (nd_OP_extDescriptions_dot_toDescr_dot_65 l s cd cs)
    (nd_OP_extDescriptions_dot_toDescr_dot_65 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    nd_OP_extDescriptions_dot_toDescr_dot_65 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (nd_OP_extDescriptions_dot_toDescr_dot_65 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "CompilerOpts.extDescriptions.toDescr.65" [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.extDescriptions.toDescr.65" (showCons
    x1))

d_C_dumpDescriptions :: Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple3 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (C_Options -> Cover -> ConstStore
  -> C_Options))
d_C_dumpDescriptions cd cs = Curry_Prelude.d_OP_plus_plus (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple3 (Curry_Prelude.toCurryString "dump-all")
  (Curry_Prelude.toCurryString "dump everything")
  d_OP_dumpDescriptions_dot_uscore_hash_lambda334) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple3 (Curry_Prelude.toCurryString "dump-none")
  (Curry_Prelude.toCurryString "dump nothing")
  d_OP_dumpDescriptions_dot_uscore_hash_lambda350) Curry_Prelude.OP_List))
  (Curry_Prelude.d_C_map d_OP_dumpDescriptions_dot_toDescr_dot_71 (d_C_dumpLevel
  cd cs) cd cs) cd cs

nd_C_dumpDescriptions :: IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple3 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Func
  C_Options C_Options))
nd_C_dumpDescriptions s cd cs = let s0 = s
  in s0 `seq` Curry_Prelude.d_OP_plus_plus (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple3 (Curry_Prelude.toCurryString "dump-all")
  (Curry_Prelude.toCurryString "dump everything") (wrapDX id
  d_OP_dumpDescriptions_dot_uscore_hash_lambda334)) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple3 (Curry_Prelude.toCurryString "dump-none")
  (Curry_Prelude.toCurryString "dump nothing") (wrapDX id
  d_OP_dumpDescriptions_dot_uscore_hash_lambda350)) Curry_Prelude.OP_List))
  (Curry_Prelude.nd_C_map (wrapNX id nd_OP_dumpDescriptions_dot_toDescr_dot_71)
  (d_C_dumpLevel cd cs) s0 cd cs) cd cs

d_OP_dumpDescriptions_dot_set_dot_71 :: C_DumpFormat -> C_Options -> Cover
  -> ConstStore -> C_Options
d_OP_dumpDescriptions_dot_set_dot_71 x1 x2 cd cs = case x2 of
  C_Opts x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 x15 -> C_Opts x3 x4 x5 x6 x7
    x8 x9 x10 x11 (d_C_addFlag
    (d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_CompilerOpts_dot_DumpFormat cd
    cs) x1 (d_C_optDump x2 cd cs) cd cs) x13 x14 x15
  Choice_C_Options d i l r -> narrow d i (d_OP_dumpDescriptions_dot_set_dot_71
    x1 l cd cs) (d_OP_dumpDescriptions_dot_set_dot_71 x1 r cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z ->
    d_OP_dumpDescriptions_dot_set_dot_71 x1 z cd cs) xs
  Guard_C_Options d c e -> guardCons d c (d_OP_dumpDescriptions_dot_set_dot_71
    x1 e cd $! addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail
    "CompilerOpts.dumpDescriptions.set.71" [show x1, show x2] info)
  _ -> failCons cd (consFail "CompilerOpts.dumpDescriptions.set.71" (showCons
    x2))

d_OP_dumpDescriptions_dot_toDescr_dot_71 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_Tuple3 C_DumpFormat t0 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple3 t0
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (C_Options -> Cover -> ConstStore
  -> C_Options)
d_OP_dumpDescriptions_dot_toDescr_dot_71 x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> Curry_Prelude.OP_Tuple3 x3
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "dump ") x4 cd
    cs) (d_OP_dumpDescriptions_dot_set_dot_71 x2)
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (d_OP_dumpDescriptions_dot_toDescr_dot_71 l cd cs)
    (d_OP_dumpDescriptions_dot_toDescr_dot_71 r cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    d_OP_dumpDescriptions_dot_toDescr_dot_71 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (d_OP_dumpDescriptions_dot_toDescr_dot_71 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "CompilerOpts.dumpDescriptions.toDescr.71" [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.dumpDescriptions.toDescr.71"
    (showCons x1))

nd_OP_dumpDescriptions_dot_toDescr_dot_71 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_Tuple3 C_DumpFormat t0 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple3 t0 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Func C_Options C_Options)
nd_OP_dumpDescriptions_dot_toDescr_dot_71 x1 s cd cs = case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> Curry_Prelude.OP_Tuple3 x3
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "dump ") x4 cd
    cs) (wrapDX id (d_OP_dumpDescriptions_dot_set_dot_71 x2))
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (nd_OP_dumpDescriptions_dot_toDescr_dot_71 l s cd cs)
    (nd_OP_dumpDescriptions_dot_toDescr_dot_71 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    nd_OP_dumpDescriptions_dot_toDescr_dot_71 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (nd_OP_dumpDescriptions_dot_toDescr_dot_71 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "CompilerOpts.dumpDescriptions.toDescr.71" [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.dumpDescriptions.toDescr.71"
    (showCons x1))

d_OP_dumpDescriptions_dot_uscore_hash_lambda334 :: C_Options -> Cover
  -> ConstStore -> C_Options
d_OP_dumpDescriptions_dot_uscore_hash_lambda334 x1 cd cs = case x1 of
  C_Opts x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 -> C_Opts x2 x3 x4 x5 x6 x7
    x8 x9 x10 (Curry_Prelude.d_C_map
    d_OP_dumpDescriptions_dot_uscore_hash_lambda334_dot_uscore_hash_lambda349
    (d_C_dumpLevel cd cs) cd cs) x12 x13 x14
  Choice_C_Options d i l r -> narrow d i
    (d_OP_dumpDescriptions_dot_uscore_hash_lambda334 l cd cs)
    (d_OP_dumpDescriptions_dot_uscore_hash_lambda334 r cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z ->
    d_OP_dumpDescriptions_dot_uscore_hash_lambda334 z cd cs) xs
  Guard_C_Options d c e -> guardCons d c
    (d_OP_dumpDescriptions_dot_uscore_hash_lambda334 e cd $! addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail
    "CompilerOpts.dumpDescriptions._#lambda334" [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.dumpDescriptions._#lambda334"
    (showCons x1))

d_OP_dumpDescriptions_dot_uscore_hash_lambda334_dot_uscore_hash_lambda349 :: Curry_Prelude.OP_Tuple3
  C_DumpFormat (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> C_DumpFormat
d_OP_dumpDescriptions_dot_uscore_hash_lambda334_dot_uscore_hash_lambda349 x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> x2
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (d_OP_dumpDescriptions_dot_uscore_hash_lambda334_dot_uscore_hash_lambda349 l
    cd cs)
    (d_OP_dumpDescriptions_dot_uscore_hash_lambda334_dot_uscore_hash_lambda349 r
    cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    d_OP_dumpDescriptions_dot_uscore_hash_lambda334_dot_uscore_hash_lambda349 z
    cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (d_OP_dumpDescriptions_dot_uscore_hash_lambda334_dot_uscore_hash_lambda349 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "CompilerOpts.dumpDescriptions._#lambda334._#lambda349" [show x1] info)
  _ -> failCons cd (consFail
    "CompilerOpts.dumpDescriptions._#lambda334._#lambda349" (showCons x1))

d_OP_dumpDescriptions_dot_uscore_hash_lambda350 :: C_Options -> Cover
  -> ConstStore -> C_Options
d_OP_dumpDescriptions_dot_uscore_hash_lambda350 x1 cd cs = case x1 of
  C_Opts x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 -> C_Opts x2 x3 x4 x5 x6 x7
    x8 x9 x10 Curry_Prelude.OP_List x12 x13 x14
  Choice_C_Options d i l r -> narrow d i
    (d_OP_dumpDescriptions_dot_uscore_hash_lambda350 l cd cs)
    (d_OP_dumpDescriptions_dot_uscore_hash_lambda350 r cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z ->
    d_OP_dumpDescriptions_dot_uscore_hash_lambda350 z cd cs) xs
  Guard_C_Options d c e -> guardCons d c
    (d_OP_dumpDescriptions_dot_uscore_hash_lambda350 e cd $! addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail
    "CompilerOpts.dumpDescriptions._#lambda350" [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.dumpDescriptions._#lambda350"
    (showCons x1))

d_C_addFlag :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0 -> t0 -> Curry_Prelude.OP_List
  t0 -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_C_addFlag x1 x2 x3 cd cs = Curry_Prelude.d_OP_dollar (Curry_List.d_C_nub x1)
  (Curry_Prelude.OP_Cons x2 x3) cd cs

nd_C_addFlag :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0 -> t0 -> Curry_Prelude.OP_List
  t0 -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
nd_C_addFlag x1 x2 x3 s cd cs = let s0 = s
  in s0 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id (Curry_List.nd_C_nub x1))
  (Curry_Prelude.OP_Cons x2 x3) s0 cd cs

d_C_removeFlag :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0 -> t0 -> Curry_Prelude.OP_List
  t0 -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_C_removeFlag x1 x2 x3 cd cs = Curry_Prelude.d_C_filter (Curry_Prelude.d_C_flip
  (Curry_Prelude.d_OP_slash_eq x1 cd cs) x2) x3 cd cs

nd_C_removeFlag :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0 -> t0 -> Curry_Prelude.OP_List
  t0 -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
nd_C_removeFlag x1 x2 x3 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_filter (wrapNX id
  (Curry_Prelude.nd_C_flip (Curry_Prelude.nd_OP_slash_eq x1 s0 cd cs) x2)) x3 s1
  cd cs))

d_C_getCompilerOpts :: Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_Tuple2 C_Options (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_C_getCompilerOpts cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_System.d_C_getArgs cd cs) (Curry_Prelude.d_OP_dot
  Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Prelude.d_C_filter d_OP_getCompilerOpts_dot_uscore_hash_lambda367) cd
  cs) cd cs) d_OP_getCompilerOpts_dot_uscore_hash_lambda368 cd cs

d_OP_getCompilerOpts_dot_uscore_hash_lambda367 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_OP_getCompilerOpts_dot_uscore_hash_lambda367 x1 cd cs =
  Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs) (Curry_Prelude.d_C_take (Curry_Prelude.C_Int (2)) x1 cd cs) cd cs)
  (Curry_Prelude.toCurryString "-D") cd cs

d_OP_getCompilerOpts_dot_uscore_hash_lambda368 :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_IO (Curry_Prelude.OP_Tuple2 C_Options
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_OP_getCompilerOpts_dot_uscore_hash_lambda368 x1 cd cs = let x2 = x1
  in Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_System.d_C_getProgName cd cs)
  (d_OP_getCompilerOpts_dot_uscore_hash_lambda368_dot_uscore_hash_lambda370 x2)
  cd cs

d_OP_getCompilerOpts_dot_uscore_hash_lambda368_dot_uscore_hash_lambda370 :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_Tuple2 C_Options (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_OP_getCompilerOpts_dot_uscore_hash_lambda368_dot_uscore_hash_lambda370 x1 x2 cd cs =
  let x3 = x2
  in Curry_Prelude.d_OP_dollar (d_C_processOpts x3) (d_C_parseOpts x1 cd cs) cd
  cs

d_C_parseOpts :: Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple3
  C_Options (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_parseOpts x1 cd cs = let x2 = Curry_GetOpt.d_C_getOpt Curry_GetOpt.C_Permute
                               (d_C_options cd cs) x1 cd cs
                             x3 = d_OP_parseOpts_dot_uscore_hash_selFP5_hash_optErrs
                               x2 cd cs
                             x4 = d_OP_parseOpts_dot_uscore_hash_selFP6_hash_files
                               x2 cd cs
                             x5 = d_OP_parseOpts_dot_uscore_hash_selFP7_hash_errs
                               x2 cd cs
                             x6 = Curry_Prelude.d_C_foldl (acceptCs id
                               (Curry_Prelude.d_C_flip (acceptCs id
                               Curry_Prelude.d_OP_dollar)))
                               (Curry_Prelude.OP_Tuple2 (d_C_defaultOptions cd
                               cs) Curry_Prelude.OP_List) x3 cd cs
                             x7 = d_OP_parseOpts_dot_uscore_hash_selFP3_hash_opts
                               x6 cd cs
                             x8 = d_OP_parseOpts_dot_uscore_hash_selFP4_hash_errs2
                               x6 cd cs
  in Curry_Prelude.OP_Tuple3 x7 x4 (Curry_Prelude.d_OP_plus_plus x5 x8 cd cs)

d_OP_parseOpts_dot_uscore_hash_selFP5_hash_optErrs :: Curry_Prelude.OP_Tuple3
  (Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 C_Options
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 C_Options (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 C_Options
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 C_Options (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_OP_parseOpts_dot_uscore_hash_selFP5_hash_optErrs x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> x2
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (d_OP_parseOpts_dot_uscore_hash_selFP5_hash_optErrs l cd cs)
    (d_OP_parseOpts_dot_uscore_hash_selFP5_hash_optErrs r cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    d_OP_parseOpts_dot_uscore_hash_selFP5_hash_optErrs z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (d_OP_parseOpts_dot_uscore_hash_selFP5_hash_optErrs e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "CompilerOpts.parseOpts._#selFP5#optErrs" [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.parseOpts._#selFP5#optErrs" (showCons
    x1))

nd_OP_parseOpts_dot_uscore_hash_selFP5_hash_optErrs :: Curry_Prelude.OP_Tuple3
  (Curry_Prelude.OP_List (Func (Curry_Prelude.OP_Tuple2 C_Options
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
  (Curry_Prelude.OP_Tuple2 C_Options (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))))) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Func (Curry_Prelude.OP_Tuple2
  C_Options (Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))) (Curry_Prelude.OP_Tuple2 C_Options
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))))
nd_OP_parseOpts_dot_uscore_hash_selFP5_hash_optErrs x1 s cd cs = case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> x2
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (nd_OP_parseOpts_dot_uscore_hash_selFP5_hash_optErrs l s cd cs)
    (nd_OP_parseOpts_dot_uscore_hash_selFP5_hash_optErrs r s cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    nd_OP_parseOpts_dot_uscore_hash_selFP5_hash_optErrs z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (nd_OP_parseOpts_dot_uscore_hash_selFP5_hash_optErrs e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "CompilerOpts.parseOpts._#selFP5#optErrs" [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.parseOpts._#selFP5#optErrs" (showCons
    x1))

d_OP_parseOpts_dot_uscore_hash_selFP6_hash_files :: Curry_Prelude.OP_Tuple3
  (Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 C_Options
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 C_Options (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_parseOpts_dot_uscore_hash_selFP6_hash_files x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> x3
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (d_OP_parseOpts_dot_uscore_hash_selFP6_hash_files l cd cs)
    (d_OP_parseOpts_dot_uscore_hash_selFP6_hash_files r cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    d_OP_parseOpts_dot_uscore_hash_selFP6_hash_files z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (d_OP_parseOpts_dot_uscore_hash_selFP6_hash_files e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "CompilerOpts.parseOpts._#selFP6#files" [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.parseOpts._#selFP6#files" (showCons
    x1))

nd_OP_parseOpts_dot_uscore_hash_selFP6_hash_files :: Curry_Prelude.OP_Tuple3
  (Curry_Prelude.OP_List (Func (Curry_Prelude.OP_Tuple2 C_Options
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
  (Curry_Prelude.OP_Tuple2 C_Options (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))))) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
nd_OP_parseOpts_dot_uscore_hash_selFP6_hash_files x1 s cd cs = case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> x3
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (nd_OP_parseOpts_dot_uscore_hash_selFP6_hash_files l s cd cs)
    (nd_OP_parseOpts_dot_uscore_hash_selFP6_hash_files r s cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    nd_OP_parseOpts_dot_uscore_hash_selFP6_hash_files z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (nd_OP_parseOpts_dot_uscore_hash_selFP6_hash_files e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "CompilerOpts.parseOpts._#selFP6#files" [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.parseOpts._#selFP6#files" (showCons
    x1))

d_OP_parseOpts_dot_uscore_hash_selFP7_hash_errs :: Curry_Prelude.OP_Tuple3
  (Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 C_Options
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 C_Options (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_parseOpts_dot_uscore_hash_selFP7_hash_errs x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> x4
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (d_OP_parseOpts_dot_uscore_hash_selFP7_hash_errs l cd cs)
    (d_OP_parseOpts_dot_uscore_hash_selFP7_hash_errs r cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    d_OP_parseOpts_dot_uscore_hash_selFP7_hash_errs z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (d_OP_parseOpts_dot_uscore_hash_selFP7_hash_errs e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "CompilerOpts.parseOpts._#selFP7#errs" [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.parseOpts._#selFP7#errs" (showCons
    x1))

nd_OP_parseOpts_dot_uscore_hash_selFP7_hash_errs :: Curry_Prelude.OP_Tuple3
  (Curry_Prelude.OP_List (Func (Curry_Prelude.OP_Tuple2 C_Options
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
  (Curry_Prelude.OP_Tuple2 C_Options (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))))) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
nd_OP_parseOpts_dot_uscore_hash_selFP7_hash_errs x1 s cd cs = case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> x4
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (nd_OP_parseOpts_dot_uscore_hash_selFP7_hash_errs l s cd cs)
    (nd_OP_parseOpts_dot_uscore_hash_selFP7_hash_errs r s cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    nd_OP_parseOpts_dot_uscore_hash_selFP7_hash_errs z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (nd_OP_parseOpts_dot_uscore_hash_selFP7_hash_errs e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "CompilerOpts.parseOpts._#selFP7#errs" [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.parseOpts._#selFP7#errs" (showCons
    x1))

d_OP_parseOpts_dot_uscore_hash_selFP3_hash_opts :: Curry_Prelude.OP_Tuple2
  C_Options (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Cover -> ConstStore -> C_Options
d_OP_parseOpts_dot_uscore_hash_selFP3_hash_opts x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_parseOpts_dot_uscore_hash_selFP3_hash_opts l cd cs)
    (d_OP_parseOpts_dot_uscore_hash_selFP3_hash_opts r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_parseOpts_dot_uscore_hash_selFP3_hash_opts z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_parseOpts_dot_uscore_hash_selFP3_hash_opts e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "CompilerOpts.parseOpts._#selFP3#opts" [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.parseOpts._#selFP3#opts" (showCons
    x1))

d_OP_parseOpts_dot_uscore_hash_selFP4_hash_errs2 :: Curry_Prelude.OP_Tuple2
  C_Options (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Cover -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_parseOpts_dot_uscore_hash_selFP4_hash_errs2 x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_parseOpts_dot_uscore_hash_selFP4_hash_errs2 l cd cs)
    (d_OP_parseOpts_dot_uscore_hash_selFP4_hash_errs2 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_parseOpts_dot_uscore_hash_selFP4_hash_errs2 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_parseOpts_dot_uscore_hash_selFP4_hash_errs2 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "CompilerOpts.parseOpts._#selFP4#errs2" [show x1] info)
  _ -> failCons cd (consFail "CompilerOpts.parseOpts._#selFP4#errs2" (showCons
    x1))

d_C_processOpts :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_Tuple3 C_Options (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover -> ConstStore
  -> Curry_Prelude.C_IO (Curry_Prelude.OP_Tuple2 C_Options
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_C_processOpts x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_Tuple3 x3 x4 x5 -> let x6 = Curry_Prelude.d_OP_plus_plus x5
                                            (d_C_checkOpts x3 x4 cd cs) cd cs
    in d_C__case_3 x3 x6 x4 x1 (d_C_optHelp x3 cd cs) cd cs
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i (d_C_processOpts x1 l cd
    cs) (d_C_processOpts x1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    d_C_processOpts x1 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c (d_C_processOpts x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "CompilerOpts.processOpts" [show x1, show x2] info)
  _ -> failCons cd (consFail "CompilerOpts.processOpts" (showCons x2))

d_C_checkOpts :: C_Options -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_checkOpts x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString
    "no files") Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x3 x4 -> Curry_Prelude.OP_List
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_checkOpts x1 l cd cs)
    (d_C_checkOpts x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_checkOpts x1
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_checkOpts x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "CompilerOpts.checkOpts" [show x1, show x2] info)
  _ -> failCons cd (consFail "CompilerOpts.checkOpts" (showCons x2))

d_C_printUsage :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_IO t0
d_C_printUsage x1 cd cs = let x2 = Curry_Prelude.d_OP_plus_plus
                                (Curry_Prelude.toCurryString "usage: ")
                                (Curry_Prelude.d_OP_plus_plus x1
                                (Curry_Prelude.toCurryString
                                " [OPTION] ... MODULE ...") cd cs) cd cs
  in Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Prelude.d_OP_dollar Curry_Prelude.d_C_putStrLn
  (Curry_GetOpt.d_C_usageInfo x2 (d_C_options cd cs) cd cs) cd cs)
  (Curry_System.d_C_exitWith (Curry_Prelude.C_Int (0)) cd cs) cd cs

d_C_badUsage :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_IO t0
d_C_badUsage x1 x2 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_mapIO_ (Curry_IO.d_C_hPutStrLn
  (Curry_IO.d_C_stderr cd cs)) cd cs) x2 cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Prelude.d_OP_dollar (Curry_IO.d_C_hPutStrLn (Curry_IO.d_C_stderr cd
  cs)) (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "Try '")
  (Curry_Prelude.d_OP_plus_plus x1 (Curry_Prelude.toCurryString
  " --help' for more information") cd cs) cd cs) cd cs)
  (Curry_System.d_C_exitWith (Curry_Prelude.C_Int (1)) cd cs) cd cs) cd cs

d_C_printVersion :: forall t0 . (Curry_Prelude.Curry t0) => Cover -> ConstStore
  -> Curry_Prelude.C_IO t0
d_C_printVersion cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Prelude.d_C_putStrLn (d_C_version cd cs) cd cs)
  (Curry_System.d_C_exitWith (Curry_Prelude.C_Int (0)) cd cs) cd cs

d_C__case_3 :: C_Options -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_Tuple2 C_Options (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_C__case_3 x3 x6 x4 x1 x7 cd cs = case x7 of
  Curry_Prelude.C_True -> d_C_printUsage x1 cd cs
  Curry_Prelude.C_False -> d_C__case_2 x3 x6 x4 x1 (d_C_optVersion x3 cd cs) cd
    cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_3 x3 x6 x4 x1 l
    cd cs) (d_C__case_3 x3 x6 x4 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_3 x3 x6
    x4 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_3 x3 x6 x4 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "CompilerOpts._case_3" [show x3, show x6, show x4, show x1, show x7] info)
  _ -> failCons cd (consFail "CompilerOpts._case_3" (showCons x7))

d_C__case_2 :: C_Options -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_Tuple2 C_Options (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_C__case_2 x3 x6 x4 x1 x7 cd cs = case x7 of
  Curry_Prelude.C_True -> d_C_printVersion cd cs
  Curry_Prelude.C_False -> d_C__case_1 x6 x4 x3 x1 (Curry_Prelude.d_C_not
    (Curry_Prelude.d_C_null x6 cd cs) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_2 x3 x6 x4 x1 l
    cd cs) (d_C__case_2 x3 x6 x4 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_2 x3 x6
    x4 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_2 x3 x6 x4 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "CompilerOpts._case_2" [show x3, show x6, show x4, show x1, show x7] info)
  _ -> failCons cd (consFail "CompilerOpts._case_2" (showCons x7))

d_C__case_1 :: Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> C_Options -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_IO (Curry_Prelude.OP_Tuple2 C_Options
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_C__case_1 x6 x4 x3 x1 x7 cd cs = case x7 of
  Curry_Prelude.C_True -> d_C_badUsage x1 x6 cd cs
  Curry_Prelude.C_False -> d_C__case_0 x4 x3 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_1 x6 x4 x3 x1 l
    cd cs) (d_C__case_1 x6 x4 x3 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_1 x6 x4
    x3 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_1 x6 x4 x3 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "CompilerOpts._case_1" [show x6, show x4, show x3, show x1, show x7] info)
  _ -> failCons cd (consFail "CompilerOpts._case_1" (showCons x7))

d_C__case_0 :: Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> C_Options -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_Tuple2 C_Options
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_C__case_0 x4 x3 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (Curry_Prelude.OP_Tuple2 x3 x4) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_0 x4 x3 l cd cs)
    (d_C__case_0 x4 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_0 x4 x3
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_0 x4 x3 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "CompilerOpts._case_0" [show x4, show x3, show x5] info)
  _ -> failCons cd (consFail "CompilerOpts._case_0" (showCons x5))

d_C__case_6 :: forall t0 t1 t2 . (Curry_Prelude.Curry t2, Curry_Prelude.Curry t1
  , Curry_Prelude.Curry t0) => t0 -> Curry_Prelude.OP_uscore_Dict_hash_Eq t0
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple3 t0 t1 t2)
  -> Curry_Prelude.OP_Tuple3 t0 t1 t2 -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe t2
d_C__case_6 x2 x1 x5 x4 cd cs = case x4 of
  Curry_Prelude.OP_Tuple3 x6 x7 x8 -> d_C__case_5 x6 x2 x1 x5 x8
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (Curry_Prelude.d_OP_eq_eq
    x1 cd cs) x2 cd cs) x6 cd cs) cd cs
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i (d_C__case_6 x2 x1 x5 l
    cd cs) (d_C__case_6 x2 x1 x5 r cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z -> d_C__case_6 x2
    x1 x5 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c (d_C__case_6 x2 x1 x5 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "CompilerOpts._case_6" [show x2, show x1, show x5, show x4] info)
  _ -> failCons cd (consFail "CompilerOpts._case_6" (showCons x4))

nd_C__case_6 :: forall t0 t1 t2 . (Curry_Prelude.Curry t2, Curry_Prelude.Curry
  t1, Curry_Prelude.Curry t0) => t0 -> Curry_Prelude.OP_uscore_Dict_hash_Eq t0
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple3 t0 t1 t2)
  -> Curry_Prelude.OP_Tuple3 t0 t1 t2 -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe t2
nd_C__case_6 x2 x1 x5 x4 s cd cs = case x4 of
  Curry_Prelude.OP_Tuple3 x6 x7 x8 -> let s6 = s
    in s6 `seq` (let s5 = leftSupply s6
                     s4 = rightSupply s6
    in s5 `seq` (s4 `seq` nd_C__case_5 x6 x2 x1 x5 x8 (let s3 = leftSupply s4
                                                           s2 = rightSupply s4
    in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                        s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_OP_eq_eq x1
    s0 cd cs) x2 s1 cd cs)) x6 s3 cd cs)) s5 cd cs))
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i (nd_C__case_6 x2 x1 x5 l
    s cd cs) (nd_C__case_6 x2 x1 x5 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z -> nd_C__case_6
    x2 x1 x5 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c (nd_C__case_6 x2 x1 x5 e
    s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "CompilerOpts._case_6" [show x2, show x1, show x5, show x4] info)
  _ -> failCons cd (consFail "CompilerOpts._case_6" (showCons x4))

d_C__case_5 :: forall t0 t1 t2 . (Curry_Prelude.Curry t2, Curry_Prelude.Curry t1
  , Curry_Prelude.Curry t0) => t0 -> t0 -> Curry_Prelude.OP_uscore_Dict_hash_Eq
  t0 -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple3 t0 t1 t2) -> t2
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_Maybe t2
d_C__case_5 x6 x2 x1 x5 x8 x9 cd cs = case x9 of
  Curry_Prelude.C_True -> Curry_Prelude.C_Just x8
  Curry_Prelude.C_False -> d_C__case_4 x5 x2 x1 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_5 x6 x2 x1 x5 x8
    l cd cs) (d_C__case_5 x6 x2 x1 x5 x8 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_5 x6 x2
    x1 x5 x8 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_5 x6 x2 x1 x5 x8
    e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "CompilerOpts._case_5" [show x6, show x2, show x1, show x5, show x8, show
    x9] info)
  _ -> failCons cd (consFail "CompilerOpts._case_5" (showCons x9))

nd_C__case_5 :: forall t0 t1 t2 . (Curry_Prelude.Curry t2, Curry_Prelude.Curry
  t1, Curry_Prelude.Curry t0) => t0 -> t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Eq t0 -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple3 t0 t1 t2) -> t2 -> Curry_Prelude.C_Bool -> IDSupply
  -> Cover -> ConstStore -> Curry_Prelude.C_Maybe t2
nd_C__case_5 x6 x2 x1 x5 x8 x9 s cd cs = case x9 of
  Curry_Prelude.C_True -> Curry_Prelude.C_Just x8
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_4 x5 x2 x1 (Curry_Prelude.d_C_otherwise cd cs) s0 cd
    cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_5 x6 x2 x1 x5 x8
    l s cd cs) (nd_C__case_5 x6 x2 x1 x5 x8 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_5 x6
    x2 x1 x5 x8 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_5 x6 x2 x1 x5 x8
    e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "CompilerOpts._case_5" [show x6, show x2, show x1, show x5, show x8, show
    x9] info)
  _ -> failCons cd (consFail "CompilerOpts._case_5" (showCons x9))

d_C__case_4 :: forall t1 t0 t2 . (Curry_Prelude.Curry t2, Curry_Prelude.Curry t0
  , Curry_Prelude.Curry t1) => Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple3 t0
  t1 t2) -> t0 -> Curry_Prelude.OP_uscore_Dict_hash_Eq t0
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_Maybe t2
d_C__case_4 x5 x2 x1 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> d_OP_parseOptErr_dot_lookup3_dot_22 x1 x2 x5 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_4 x5 x2 x1 l cd
    cs) (d_C__case_4 x5 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_4 x5 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_4 x5 x2 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "CompilerOpts._case_4" [show x5, show x2, show x1, show x6] info)
  _ -> failCons cd (consFail "CompilerOpts._case_4" (showCons x6))

nd_C__case_4 :: forall t1 t0 t2 . (Curry_Prelude.Curry t2, Curry_Prelude.Curry
  t0, Curry_Prelude.Curry t1) => Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple3
  t0 t1 t2) -> t0 -> Curry_Prelude.OP_uscore_Dict_hash_Eq t0
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe t2
nd_C__case_4 x5 x2 x1 x6 s cd cs = case x6 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` nd_OP_parseOptErr_dot_lookup3_dot_22 x1 x2 x5 s0 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_4 x5 x2 x1 l s
    cd cs) (nd_C__case_4 x5 x2 x1 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_4 x5
    x2 x1 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_4 x5 x2 x1 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "CompilerOpts._case_4" [show x5, show x2, show x1, show x6] info)
  _ -> failCons cd (consFail "CompilerOpts._case_4" (showCons x6))

d_C__case_7 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple3
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (C_Options -> Cover -> ConstStore -> C_Options))
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Maybe (C_Options -> Cover
  -> ConstStore -> C_Options) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  C_Options (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 C_Options
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_7 x2 x3 x1 x5 cd cs = case x5 of
  Curry_Prelude.C_Just x4 -> d_C_onOpts x4
  Curry_Prelude.C_Nothing -> Curry_Prelude.d_OP_dollar (acceptCs id d_C_addErr)
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "unrecognized ")
    (Curry_Prelude.d_OP_plus_plus x1 (Curry_Prelude.OP_Cons
    (Curry_Prelude.C_Char '`'#) (Curry_Prelude.d_OP_plus_plus x3
    (Curry_Prelude.toCurryString "'\n") cd cs)) cd cs) cd cs) cd cs
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (d_C__case_7 x2 x3 x1 l cd
    cs) (d_C__case_7 x2 x3 x1 r cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> d_C__case_7 x2
    x3 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (d_C__case_7 x2 x3 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail
    "CompilerOpts._case_7" [show x2, show x3, show x1, show x5] info)
  _ -> failCons cd (consFail "CompilerOpts._case_7" (showCons x5))

nd_C__case_7 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple3
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Func C_Options C_Options)) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Maybe (Func C_Options C_Options) -> IDSupply -> Cover
  -> ConstStore -> Func (Curry_Prelude.OP_Tuple2 C_Options
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
  (Curry_Prelude.OP_Tuple2 C_Options (Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
nd_C__case_7 x2 x3 x1 x5 s cd cs = case x5 of
  Curry_Prelude.C_Just x4 -> wrapNX id (nd_C_onOpts x4)
  Curry_Prelude.C_Nothing -> let s0 = s
    in s0 `seq` Curry_Prelude.nd_OP_dollar (wrapDX (wrapDX id) (acceptCs id
    d_C_addErr)) (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString
    "unrecognized ") (Curry_Prelude.d_OP_plus_plus x1 (Curry_Prelude.OP_Cons
    (Curry_Prelude.C_Char '`'#) (Curry_Prelude.d_OP_plus_plus x3
    (Curry_Prelude.toCurryString "'\n") cd cs)) cd cs) cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (nd_C__case_7 x2 x3 x1 l s
    cd cs) (nd_C__case_7 x2 x3 x1 r s cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> nd_C__case_7 x2
    x3 x1 z s cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (nd_C__case_7 x2 x3 x1 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail
    "CompilerOpts._case_7" [show x2, show x3, show x1, show x5] info)
  _ -> failCons cd (consFail "CompilerOpts._case_7" (showCons x5))

d_C__case_8 :: C_DumpFormat -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_8 x2 cd cs = case x2 of
  C_DumpTypedFlat -> Curry_Prelude.C_False
  C_DumpExtImports -> Curry_Prelude.C_False
  C_DumpLifted -> Curry_Prelude.C_False
  C_DumpEliminated -> Curry_Prelude.C_False
  C_DumpDefaulted -> Curry_Prelude.C_False
  C_DumpRenamed -> Curry_Prelude.C_False
  C_DumpFunDecls -> Curry_Prelude.C_False
  C_DumpTypeDecls -> Curry_Prelude.C_False
  C_DumpTranslated -> Curry_Prelude.C_True
  Choice_C_DumpFormat d i l r -> narrow d i (d_C__case_8 l cd cs) (d_C__case_8 r
    cd cs)
  Choices_C_DumpFormat d i xs -> narrows cs d i (\z -> d_C__case_8 z cd cs) xs
  Guard_C_DumpFormat d c e -> guardCons d c (d_C__case_8 e cd $! addCs c cs)
  Fail_C_DumpFormat d info -> failCons d (traceFail "CompilerOpts._case_8" [show
    x2] info)
  _ -> failCons cd (consFail "CompilerOpts._case_8" (showCons x2))

d_C__case_9 :: C_DumpFormat -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_9 x2 cd cs = case x2 of
  C_DumpTypedFlat -> Curry_Prelude.C_False
  C_DumpExtImports -> Curry_Prelude.C_False
  C_DumpLifted -> Curry_Prelude.C_False
  C_DumpEliminated -> Curry_Prelude.C_False
  C_DumpDefaulted -> Curry_Prelude.C_False
  C_DumpRenamed -> Curry_Prelude.C_False
  C_DumpFunDecls -> Curry_Prelude.C_False
  C_DumpTypeDecls -> Curry_Prelude.C_True
  C_DumpTranslated -> Curry_Prelude.C_False
  Choice_C_DumpFormat d i l r -> narrow d i (d_C__case_9 l cd cs) (d_C__case_9 r
    cd cs)
  Choices_C_DumpFormat d i xs -> narrows cs d i (\z -> d_C__case_9 z cd cs) xs
  Guard_C_DumpFormat d c e -> guardCons d c (d_C__case_9 e cd $! addCs c cs)
  Fail_C_DumpFormat d info -> failCons d (traceFail "CompilerOpts._case_9" [show
    x2] info)
  _ -> failCons cd (consFail "CompilerOpts._case_9" (showCons x2))

d_C__case_10 :: C_DumpFormat -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_10 x2 cd cs = case x2 of
  C_DumpTypedFlat -> Curry_Prelude.C_False
  C_DumpExtImports -> Curry_Prelude.C_False
  C_DumpLifted -> Curry_Prelude.C_False
  C_DumpEliminated -> Curry_Prelude.C_False
  C_DumpDefaulted -> Curry_Prelude.C_False
  C_DumpRenamed -> Curry_Prelude.C_False
  C_DumpFunDecls -> Curry_Prelude.C_True
  C_DumpTypeDecls -> Curry_Prelude.C_False
  C_DumpTranslated -> Curry_Prelude.C_False
  Choice_C_DumpFormat d i l r -> narrow d i (d_C__case_10 l cd cs) (d_C__case_10
    r cd cs)
  Choices_C_DumpFormat d i xs -> narrows cs d i (\z -> d_C__case_10 z cd cs) xs
  Guard_C_DumpFormat d c e -> guardCons d c (d_C__case_10 e cd $! addCs c cs)
  Fail_C_DumpFormat d info -> failCons d (traceFail "CompilerOpts._case_10"
    [show x2] info)
  _ -> failCons cd (consFail "CompilerOpts._case_10" (showCons x2))

d_C__case_11 :: C_DumpFormat -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_11 x2 cd cs = case x2 of
  C_DumpTypedFlat -> Curry_Prelude.C_False
  C_DumpExtImports -> Curry_Prelude.C_False
  C_DumpLifted -> Curry_Prelude.C_False
  C_DumpEliminated -> Curry_Prelude.C_False
  C_DumpDefaulted -> Curry_Prelude.C_False
  C_DumpRenamed -> Curry_Prelude.C_True
  C_DumpFunDecls -> Curry_Prelude.C_False
  C_DumpTypeDecls -> Curry_Prelude.C_False
  C_DumpTranslated -> Curry_Prelude.C_False
  Choice_C_DumpFormat d i l r -> narrow d i (d_C__case_11 l cd cs) (d_C__case_11
    r cd cs)
  Choices_C_DumpFormat d i xs -> narrows cs d i (\z -> d_C__case_11 z cd cs) xs
  Guard_C_DumpFormat d c e -> guardCons d c (d_C__case_11 e cd $! addCs c cs)
  Fail_C_DumpFormat d info -> failCons d (traceFail "CompilerOpts._case_11"
    [show x2] info)
  _ -> failCons cd (consFail "CompilerOpts._case_11" (showCons x2))

d_C__case_12 :: C_DumpFormat -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_12 x2 cd cs = case x2 of
  C_DumpTypedFlat -> Curry_Prelude.C_False
  C_DumpExtImports -> Curry_Prelude.C_False
  C_DumpLifted -> Curry_Prelude.C_False
  C_DumpEliminated -> Curry_Prelude.C_False
  C_DumpDefaulted -> Curry_Prelude.C_True
  C_DumpRenamed -> Curry_Prelude.C_False
  C_DumpFunDecls -> Curry_Prelude.C_False
  C_DumpTypeDecls -> Curry_Prelude.C_False
  C_DumpTranslated -> Curry_Prelude.C_False
  Choice_C_DumpFormat d i l r -> narrow d i (d_C__case_12 l cd cs) (d_C__case_12
    r cd cs)
  Choices_C_DumpFormat d i xs -> narrows cs d i (\z -> d_C__case_12 z cd cs) xs
  Guard_C_DumpFormat d c e -> guardCons d c (d_C__case_12 e cd $! addCs c cs)
  Fail_C_DumpFormat d info -> failCons d (traceFail "CompilerOpts._case_12"
    [show x2] info)
  _ -> failCons cd (consFail "CompilerOpts._case_12" (showCons x2))

d_C__case_13 :: C_DumpFormat -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_13 x2 cd cs = case x2 of
  C_DumpTypedFlat -> Curry_Prelude.C_False
  C_DumpExtImports -> Curry_Prelude.C_False
  C_DumpLifted -> Curry_Prelude.C_False
  C_DumpEliminated -> Curry_Prelude.C_True
  C_DumpDefaulted -> Curry_Prelude.C_False
  C_DumpRenamed -> Curry_Prelude.C_False
  C_DumpFunDecls -> Curry_Prelude.C_False
  C_DumpTypeDecls -> Curry_Prelude.C_False
  C_DumpTranslated -> Curry_Prelude.C_False
  Choice_C_DumpFormat d i l r -> narrow d i (d_C__case_13 l cd cs) (d_C__case_13
    r cd cs)
  Choices_C_DumpFormat d i xs -> narrows cs d i (\z -> d_C__case_13 z cd cs) xs
  Guard_C_DumpFormat d c e -> guardCons d c (d_C__case_13 e cd $! addCs c cs)
  Fail_C_DumpFormat d info -> failCons d (traceFail "CompilerOpts._case_13"
    [show x2] info)
  _ -> failCons cd (consFail "CompilerOpts._case_13" (showCons x2))

d_C__case_14 :: C_DumpFormat -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_14 x2 cd cs = case x2 of
  C_DumpTypedFlat -> Curry_Prelude.C_False
  C_DumpExtImports -> Curry_Prelude.C_False
  C_DumpLifted -> Curry_Prelude.C_True
  C_DumpEliminated -> Curry_Prelude.C_False
  C_DumpDefaulted -> Curry_Prelude.C_False
  C_DumpRenamed -> Curry_Prelude.C_False
  C_DumpFunDecls -> Curry_Prelude.C_False
  C_DumpTypeDecls -> Curry_Prelude.C_False
  C_DumpTranslated -> Curry_Prelude.C_False
  Choice_C_DumpFormat d i l r -> narrow d i (d_C__case_14 l cd cs) (d_C__case_14
    r cd cs)
  Choices_C_DumpFormat d i xs -> narrows cs d i (\z -> d_C__case_14 z cd cs) xs
  Guard_C_DumpFormat d c e -> guardCons d c (d_C__case_14 e cd $! addCs c cs)
  Fail_C_DumpFormat d info -> failCons d (traceFail "CompilerOpts._case_14"
    [show x2] info)
  _ -> failCons cd (consFail "CompilerOpts._case_14" (showCons x2))

d_C__case_15 :: C_DumpFormat -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_15 x2 cd cs = case x2 of
  C_DumpTypedFlat -> Curry_Prelude.C_False
  C_DumpExtImports -> Curry_Prelude.C_True
  C_DumpLifted -> Curry_Prelude.C_False
  C_DumpEliminated -> Curry_Prelude.C_False
  C_DumpDefaulted -> Curry_Prelude.C_False
  C_DumpRenamed -> Curry_Prelude.C_False
  C_DumpFunDecls -> Curry_Prelude.C_False
  C_DumpTypeDecls -> Curry_Prelude.C_False
  C_DumpTranslated -> Curry_Prelude.C_False
  Choice_C_DumpFormat d i l r -> narrow d i (d_C__case_15 l cd cs) (d_C__case_15
    r cd cs)
  Choices_C_DumpFormat d i xs -> narrows cs d i (\z -> d_C__case_15 z cd cs) xs
  Guard_C_DumpFormat d c e -> guardCons d c (d_C__case_15 e cd $! addCs c cs)
  Fail_C_DumpFormat d info -> failCons d (traceFail "CompilerOpts._case_15"
    [show x2] info)
  _ -> failCons cd (consFail "CompilerOpts._case_15" (showCons x2))

d_C__case_16 :: C_DumpFormat -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_16 x2 cd cs = case x2 of
  C_DumpTypedFlat -> Curry_Prelude.C_True
  C_DumpExtImports -> Curry_Prelude.C_False
  C_DumpLifted -> Curry_Prelude.C_False
  C_DumpEliminated -> Curry_Prelude.C_False
  C_DumpDefaulted -> Curry_Prelude.C_False
  C_DumpRenamed -> Curry_Prelude.C_False
  C_DumpFunDecls -> Curry_Prelude.C_False
  C_DumpTypeDecls -> Curry_Prelude.C_False
  C_DumpTranslated -> Curry_Prelude.C_False
  Choice_C_DumpFormat d i l r -> narrow d i (d_C__case_16 l cd cs) (d_C__case_16
    r cd cs)
  Choices_C_DumpFormat d i xs -> narrows cs d i (\z -> d_C__case_16 z cd cs) xs
  Guard_C_DumpFormat d c e -> guardCons d c (d_C__case_16 e cd $! addCs c cs)
  Fail_C_DumpFormat d info -> failCons d (traceFail "CompilerOpts._case_16"
    [show x2] info)
  _ -> failCons cd (consFail "CompilerOpts._case_16" (showCons x2))

d_C__case_17 :: C_Extension -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_17 x2 cd cs = case x2 of
  C_AnonFreeVars -> Curry_Prelude.C_False
  C_FunctionalPatterns -> Curry_Prelude.C_False
  C_NoImplicitPrelude -> Curry_Prelude.C_True
  Choice_C_Extension d i l r -> narrow d i (d_C__case_17 l cd cs) (d_C__case_17
    r cd cs)
  Choices_C_Extension d i xs -> narrows cs d i (\z -> d_C__case_17 z cd cs) xs
  Guard_C_Extension d c e -> guardCons d c (d_C__case_17 e cd $! addCs c cs)
  Fail_C_Extension d info -> failCons d (traceFail "CompilerOpts._case_17" [show
    x2] info)
  _ -> failCons cd (consFail "CompilerOpts._case_17" (showCons x2))

d_C__case_18 :: C_Extension -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_18 x2 cd cs = case x2 of
  C_AnonFreeVars -> Curry_Prelude.C_False
  C_FunctionalPatterns -> Curry_Prelude.C_True
  C_NoImplicitPrelude -> Curry_Prelude.C_False
  Choice_C_Extension d i l r -> narrow d i (d_C__case_18 l cd cs) (d_C__case_18
    r cd cs)
  Choices_C_Extension d i xs -> narrows cs d i (\z -> d_C__case_18 z cd cs) xs
  Guard_C_Extension d c e -> guardCons d c (d_C__case_18 e cd $! addCs c cs)
  Fail_C_Extension d info -> failCons d (traceFail "CompilerOpts._case_18" [show
    x2] info)
  _ -> failCons cd (consFail "CompilerOpts._case_18" (showCons x2))

d_C__case_19 :: C_Extension -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_19 x2 cd cs = case x2 of
  C_AnonFreeVars -> Curry_Prelude.C_True
  C_FunctionalPatterns -> Curry_Prelude.C_False
  C_NoImplicitPrelude -> Curry_Prelude.C_False
  Choice_C_Extension d i l r -> narrow d i (d_C__case_19 l cd cs) (d_C__case_19
    r cd cs)
  Choices_C_Extension d i xs -> narrows cs d i (\z -> d_C__case_19 z cd cs) xs
  Guard_C_Extension d c e -> guardCons d c (d_C__case_19 e cd $! addCs c cs)
  Fail_C_Extension d info -> failCons d (traceFail "CompilerOpts._case_19" [show
    x2] info)
  _ -> failCons cd (consFail "CompilerOpts._case_19" (showCons x2))

d_C__case_20 :: C_OptimLevel -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_20 x2 cd cs = case x2 of
  C_OptimNone -> Curry_Prelude.C_False
  C_OptimHigherOrder -> Curry_Prelude.C_False
  C_OptimStrictSupply -> Curry_Prelude.C_True
  Choice_C_OptimLevel d i l r -> narrow d i (d_C__case_20 l cd cs) (d_C__case_20
    r cd cs)
  Choices_C_OptimLevel d i xs -> narrows cs d i (\z -> d_C__case_20 z cd cs) xs
  Guard_C_OptimLevel d c e -> guardCons d c (d_C__case_20 e cd $! addCs c cs)
  Fail_C_OptimLevel d info -> failCons d (traceFail "CompilerOpts._case_20"
    [show x2] info)
  _ -> failCons cd (consFail "CompilerOpts._case_20" (showCons x2))

d_C__case_21 :: C_OptimLevel -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_21 x2 cd cs = case x2 of
  C_OptimNone -> Curry_Prelude.C_False
  C_OptimHigherOrder -> Curry_Prelude.C_True
  C_OptimStrictSupply -> Curry_Prelude.C_True
  Choice_C_OptimLevel d i l r -> narrow d i (d_C__case_21 l cd cs) (d_C__case_21
    r cd cs)
  Choices_C_OptimLevel d i xs -> narrows cs d i (\z -> d_C__case_21 z cd cs) xs
  Guard_C_OptimLevel d c e -> guardCons d c (d_C__case_21 e cd $! addCs c cs)
  Fail_C_OptimLevel d info -> failCons d (traceFail "CompilerOpts._case_21"
    [show x2] info)
  _ -> failCons cd (consFail "CompilerOpts._case_21" (showCons x2))

d_C__case_22 :: C_OptimLevel -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_22 x2 cd cs = case x2 of
  C_OptimNone -> Curry_Prelude.C_True
  C_OptimHigherOrder -> Curry_Prelude.C_True
  C_OptimStrictSupply -> Curry_Prelude.C_True
  Choice_C_OptimLevel d i l r -> narrow d i (d_C__case_22 l cd cs) (d_C__case_22
    r cd cs)
  Choices_C_OptimLevel d i xs -> narrows cs d i (\z -> d_C__case_22 z cd cs) xs
  Guard_C_OptimLevel d c e -> guardCons d c (d_C__case_22 e cd $! addCs c cs)
  Fail_C_OptimLevel d info -> failCons d (traceFail "CompilerOpts._case_22"
    [show x2] info)
  _ -> failCons cd (consFail "CompilerOpts._case_22" (showCons x2))

d_C__case_23 :: C_OptimLevel -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_23 x2 cd cs = case x2 of
  C_OptimNone -> Curry_Prelude.C_False
  C_OptimHigherOrder -> Curry_Prelude.C_False
  C_OptimStrictSupply -> Curry_Prelude.C_True
  Choice_C_OptimLevel d i l r -> narrow d i (d_C__case_23 l cd cs) (d_C__case_23
    r cd cs)
  Choices_C_OptimLevel d i xs -> narrows cs d i (\z -> d_C__case_23 z cd cs) xs
  Guard_C_OptimLevel d c e -> guardCons d c (d_C__case_23 e cd $! addCs c cs)
  Fail_C_OptimLevel d info -> failCons d (traceFail "CompilerOpts._case_23"
    [show x2] info)
  _ -> failCons cd (consFail "CompilerOpts._case_23" (showCons x2))

d_C__case_24 :: C_OptimLevel -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_24 x2 cd cs = case x2 of
  C_OptimNone -> Curry_Prelude.C_False
  C_OptimHigherOrder -> Curry_Prelude.C_True
  C_OptimStrictSupply -> Curry_Prelude.C_False
  Choice_C_OptimLevel d i l r -> narrow d i (d_C__case_24 l cd cs) (d_C__case_24
    r cd cs)
  Choices_C_OptimLevel d i xs -> narrows cs d i (\z -> d_C__case_24 z cd cs) xs
  Guard_C_OptimLevel d c e -> guardCons d c (d_C__case_24 e cd $! addCs c cs)
  Fail_C_OptimLevel d info -> failCons d (traceFail "CompilerOpts._case_24"
    [show x2] info)
  _ -> failCons cd (consFail "CompilerOpts._case_24" (showCons x2))

d_C__case_25 :: C_OptimLevel -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_25 x2 cd cs = case x2 of
  C_OptimNone -> Curry_Prelude.C_True
  C_OptimHigherOrder -> Curry_Prelude.C_False
  C_OptimStrictSupply -> Curry_Prelude.C_False
  Choice_C_OptimLevel d i l r -> narrow d i (d_C__case_25 l cd cs) (d_C__case_25
    r cd cs)
  Choices_C_OptimLevel d i xs -> narrows cs d i (\z -> d_C__case_25 z cd cs) xs
  Guard_C_OptimLevel d c e -> guardCons d c (d_C__case_25 e cd $! addCs c cs)
  Fail_C_OptimLevel d info -> failCons d (traceFail "CompilerOpts._case_25"
    [show x2] info)
  _ -> failCons cd (consFail "CompilerOpts._case_25" (showCons x2))

d_C__case_26 :: C_Verbosity -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_26 x2 cd cs = case x2 of
  C_VerbQuiet -> Curry_Prelude.C_False
  C_VerbFrontend -> Curry_Prelude.C_False
  C_VerbStatus -> Curry_Prelude.C_False
  C_VerbAnalysis -> Curry_Prelude.C_False
  C_VerbDetails -> Curry_Prelude.C_True
  Choice_C_Verbosity d i l r -> narrow d i (d_C__case_26 l cd cs) (d_C__case_26
    r cd cs)
  Choices_C_Verbosity d i xs -> narrows cs d i (\z -> d_C__case_26 z cd cs) xs
  Guard_C_Verbosity d c e -> guardCons d c (d_C__case_26 e cd $! addCs c cs)
  Fail_C_Verbosity d info -> failCons d (traceFail "CompilerOpts._case_26" [show
    x2] info)
  _ -> failCons cd (consFail "CompilerOpts._case_26" (showCons x2))

d_C__case_27 :: C_Verbosity -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_27 x2 cd cs = case x2 of
  C_VerbQuiet -> Curry_Prelude.C_False
  C_VerbFrontend -> Curry_Prelude.C_False
  C_VerbStatus -> Curry_Prelude.C_False
  C_VerbAnalysis -> Curry_Prelude.C_True
  C_VerbDetails -> Curry_Prelude.C_True
  Choice_C_Verbosity d i l r -> narrow d i (d_C__case_27 l cd cs) (d_C__case_27
    r cd cs)
  Choices_C_Verbosity d i xs -> narrows cs d i (\z -> d_C__case_27 z cd cs) xs
  Guard_C_Verbosity d c e -> guardCons d c (d_C__case_27 e cd $! addCs c cs)
  Fail_C_Verbosity d info -> failCons d (traceFail "CompilerOpts._case_27" [show
    x2] info)
  _ -> failCons cd (consFail "CompilerOpts._case_27" (showCons x2))

d_C__case_28 :: C_Verbosity -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_28 x2 cd cs = case x2 of
  C_VerbQuiet -> Curry_Prelude.C_False
  C_VerbFrontend -> Curry_Prelude.C_False
  C_VerbStatus -> Curry_Prelude.C_True
  C_VerbAnalysis -> Curry_Prelude.C_True
  C_VerbDetails -> Curry_Prelude.C_True
  Choice_C_Verbosity d i l r -> narrow d i (d_C__case_28 l cd cs) (d_C__case_28
    r cd cs)
  Choices_C_Verbosity d i xs -> narrows cs d i (\z -> d_C__case_28 z cd cs) xs
  Guard_C_Verbosity d c e -> guardCons d c (d_C__case_28 e cd $! addCs c cs)
  Fail_C_Verbosity d info -> failCons d (traceFail "CompilerOpts._case_28" [show
    x2] info)
  _ -> failCons cd (consFail "CompilerOpts._case_28" (showCons x2))

d_C__case_29 :: C_Verbosity -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_29 x2 cd cs = case x2 of
  C_VerbQuiet -> Curry_Prelude.C_False
  C_VerbFrontend -> Curry_Prelude.C_True
  C_VerbStatus -> Curry_Prelude.C_True
  C_VerbAnalysis -> Curry_Prelude.C_True
  C_VerbDetails -> Curry_Prelude.C_True
  Choice_C_Verbosity d i l r -> narrow d i (d_C__case_29 l cd cs) (d_C__case_29
    r cd cs)
  Choices_C_Verbosity d i xs -> narrows cs d i (\z -> d_C__case_29 z cd cs) xs
  Guard_C_Verbosity d c e -> guardCons d c (d_C__case_29 e cd $! addCs c cs)
  Fail_C_Verbosity d info -> failCons d (traceFail "CompilerOpts._case_29" [show
    x2] info)
  _ -> failCons cd (consFail "CompilerOpts._case_29" (showCons x2))

d_C__case_30 :: C_Verbosity -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_30 x2 cd cs = case x2 of
  C_VerbQuiet -> Curry_Prelude.C_True
  C_VerbFrontend -> Curry_Prelude.C_True
  C_VerbStatus -> Curry_Prelude.C_True
  C_VerbAnalysis -> Curry_Prelude.C_True
  C_VerbDetails -> Curry_Prelude.C_True
  Choice_C_Verbosity d i l r -> narrow d i (d_C__case_30 l cd cs) (d_C__case_30
    r cd cs)
  Choices_C_Verbosity d i xs -> narrows cs d i (\z -> d_C__case_30 z cd cs) xs
  Guard_C_Verbosity d c e -> guardCons d c (d_C__case_30 e cd $! addCs c cs)
  Fail_C_Verbosity d info -> failCons d (traceFail "CompilerOpts._case_30" [show
    x2] info)
  _ -> failCons cd (consFail "CompilerOpts._case_30" (showCons x2))

d_C__case_31 :: C_Verbosity -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_31 x2 cd cs = case x2 of
  C_VerbQuiet -> Curry_Prelude.C_False
  C_VerbFrontend -> Curry_Prelude.C_False
  C_VerbStatus -> Curry_Prelude.C_False
  C_VerbAnalysis -> Curry_Prelude.C_False
  C_VerbDetails -> Curry_Prelude.C_True
  Choice_C_Verbosity d i l r -> narrow d i (d_C__case_31 l cd cs) (d_C__case_31
    r cd cs)
  Choices_C_Verbosity d i xs -> narrows cs d i (\z -> d_C__case_31 z cd cs) xs
  Guard_C_Verbosity d c e -> guardCons d c (d_C__case_31 e cd $! addCs c cs)
  Fail_C_Verbosity d info -> failCons d (traceFail "CompilerOpts._case_31" [show
    x2] info)
  _ -> failCons cd (consFail "CompilerOpts._case_31" (showCons x2))

d_C__case_32 :: C_Verbosity -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_32 x2 cd cs = case x2 of
  C_VerbQuiet -> Curry_Prelude.C_False
  C_VerbFrontend -> Curry_Prelude.C_False
  C_VerbStatus -> Curry_Prelude.C_False
  C_VerbAnalysis -> Curry_Prelude.C_True
  C_VerbDetails -> Curry_Prelude.C_False
  Choice_C_Verbosity d i l r -> narrow d i (d_C__case_32 l cd cs) (d_C__case_32
    r cd cs)
  Choices_C_Verbosity d i xs -> narrows cs d i (\z -> d_C__case_32 z cd cs) xs
  Guard_C_Verbosity d c e -> guardCons d c (d_C__case_32 e cd $! addCs c cs)
  Fail_C_Verbosity d info -> failCons d (traceFail "CompilerOpts._case_32" [show
    x2] info)
  _ -> failCons cd (consFail "CompilerOpts._case_32" (showCons x2))

d_C__case_33 :: C_Verbosity -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_33 x2 cd cs = case x2 of
  C_VerbQuiet -> Curry_Prelude.C_False
  C_VerbFrontend -> Curry_Prelude.C_False
  C_VerbStatus -> Curry_Prelude.C_True
  C_VerbAnalysis -> Curry_Prelude.C_False
  C_VerbDetails -> Curry_Prelude.C_False
  Choice_C_Verbosity d i l r -> narrow d i (d_C__case_33 l cd cs) (d_C__case_33
    r cd cs)
  Choices_C_Verbosity d i xs -> narrows cs d i (\z -> d_C__case_33 z cd cs) xs
  Guard_C_Verbosity d c e -> guardCons d c (d_C__case_33 e cd $! addCs c cs)
  Fail_C_Verbosity d info -> failCons d (traceFail "CompilerOpts._case_33" [show
    x2] info)
  _ -> failCons cd (consFail "CompilerOpts._case_33" (showCons x2))

d_C__case_34 :: C_Verbosity -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_34 x2 cd cs = case x2 of
  C_VerbQuiet -> Curry_Prelude.C_False
  C_VerbFrontend -> Curry_Prelude.C_True
  C_VerbStatus -> Curry_Prelude.C_False
  C_VerbAnalysis -> Curry_Prelude.C_False
  C_VerbDetails -> Curry_Prelude.C_False
  Choice_C_Verbosity d i l r -> narrow d i (d_C__case_34 l cd cs) (d_C__case_34
    r cd cs)
  Choices_C_Verbosity d i xs -> narrows cs d i (\z -> d_C__case_34 z cd cs) xs
  Guard_C_Verbosity d c e -> guardCons d c (d_C__case_34 e cd $! addCs c cs)
  Fail_C_Verbosity d info -> failCons d (traceFail "CompilerOpts._case_34" [show
    x2] info)
  _ -> failCons cd (consFail "CompilerOpts._case_34" (showCons x2))

d_C__case_35 :: C_Verbosity -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_35 x2 cd cs = case x2 of
  C_VerbQuiet -> Curry_Prelude.C_True
  C_VerbFrontend -> Curry_Prelude.C_False
  C_VerbStatus -> Curry_Prelude.C_False
  C_VerbAnalysis -> Curry_Prelude.C_False
  C_VerbDetails -> Curry_Prelude.C_False
  Choice_C_Verbosity d i l r -> narrow d i (d_C__case_35 l cd cs) (d_C__case_35
    r cd cs)
  Choices_C_Verbosity d i xs -> narrows cs d i (\z -> d_C__case_35 z cd cs) xs
  Guard_C_Verbosity d c e -> guardCons d c (d_C__case_35 e cd $! addCs c cs)
  Fail_C_Verbosity d info -> failCons d (traceFail "CompilerOpts._case_35" [show
    x2] info)
  _ -> failCons cd (consFail "CompilerOpts._case_35" (showCons x2))

