{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE Rank2Types #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module Curry_Files
  ( d_C_withComponents
  , nd_C_withComponents
  , d_C_withDirectory
  , nd_C_withDirectory
  , d_C_withBaseName
  , nd_C_withBaseName
  , d_C_withExtension
  , nd_C_withExtension
  , d_C_writeFileInDir
  , d_C_writeQTermFileInDir
  , d_C_removeFileIfExists
  , d_OP_lt_slash_qmark_gt
  , d_C_lookupFileInPath
  , d_C_getFileInPath )
  where

import Basics
import qualified Curry_Directory
import qualified Curry_FilePath
import qualified Curry_List
import qualified Curry_Prelude
import qualified Curry_ReadShowTerm


d_C_withComponents :: (Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> (Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> (Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_withComponents x1 x2 x3 x4 cd cs = let x5 = Curry_FilePath.d_C_splitFileName
                                             x4 cd cs
                                           x6 = d_OP_withComponents_dot_uscore_hash_selFP5_hash_path
                                             x5 cd cs
                                           x7 = d_OP_withComponents_dot_uscore_hash_selFP6_hash_bassfx
                                             x5 cd cs
                                           x8 = Curry_FilePath.d_C_splitExtension
                                             x7 cd cs
                                           x9 = d_OP_withComponents_dot_uscore_hash_selFP3_hash_base
                                             x8 cd cs
                                           x10 = d_OP_withComponents_dot_uscore_hash_selFP4_hash_suffix
                                             x8 cd cs
  in Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_FilePath.d_OP_lt_slash_gt cd cs) (Curry_Prelude.d_C_apply x1 x6 cd cs)
  cd cs) (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_FilePath.d_OP_lt_dot_gt cd cs) (Curry_Prelude.d_C_apply x2 x9 cd cs) cd
  cs) (Curry_Prelude.d_C_apply x3 x10 cd cs) cd cs) cd cs

nd_C_withComponents :: Func (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Func (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
nd_C_withComponents x1 x2 x3 x4 s cd cs = let s11 = s
  in s11 `seq` (let x5 = Curry_FilePath.d_C_splitFileName x4 cd cs
                    x6 = d_OP_withComponents_dot_uscore_hash_selFP5_hash_path x5
                      cd cs
                    x7 = d_OP_withComponents_dot_uscore_hash_selFP6_hash_bassfx
                      x5 cd cs
                    x8 = Curry_FilePath.d_C_splitExtension x7 cd cs
                    x9 = d_OP_withComponents_dot_uscore_hash_selFP3_hash_base x8
                      cd cs
                    x10 = d_OP_withComponents_dot_uscore_hash_selFP4_hash_suffix
                      x8 cd cs
  in let s10 = leftSupply s11
         s12 = rightSupply s11
         s2 = leftSupply s12
         s8 = rightSupply s12
  in s10 `seq` (s12 `seq` (s2 `seq` (s8 `seq` Curry_Prelude.nd_C_apply
  (let s1 = leftSupply s2
       s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (wrapDX (wrapDX id)
  (Curry_FilePath.d_OP_lt_slash_gt cd cs)) (Curry_Prelude.nd_C_apply x1 x6 s0 cd
  cs) s1 cd cs)) (let s7 = leftSupply s8
                      s9 = rightSupply s8
                      s5 = leftSupply s9
                      s6 = rightSupply s9
  in s7 `seq` (s9 `seq` (s5 `seq` (s6 `seq` Curry_Prelude.nd_C_apply
  (let s4 = leftSupply s5
       s3 = rightSupply s5
  in s4 `seq` (s3 `seq` Curry_Prelude.nd_C_apply (wrapDX (wrapDX id)
  (Curry_FilePath.d_OP_lt_dot_gt cd cs)) (Curry_Prelude.nd_C_apply x2 x9 s3 cd
  cs) s4 cd cs)) (Curry_Prelude.nd_C_apply x3 x10 s6 cd cs) s7 cd cs)))) s10 cd
  cs))))

d_OP_withComponents_dot_uscore_hash_selFP5_hash_path :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_withComponents_dot_uscore_hash_selFP5_hash_path x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_withComponents_dot_uscore_hash_selFP5_hash_path l cd cs)
    (d_OP_withComponents_dot_uscore_hash_selFP5_hash_path r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_withComponents_dot_uscore_hash_selFP5_hash_path z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_withComponents_dot_uscore_hash_selFP5_hash_path e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Files.withComponents._#selFP5#path" [show x1] info)
  _ -> failCons cd (consFail "Files.withComponents._#selFP5#path" (showCons x1))

d_OP_withComponents_dot_uscore_hash_selFP6_hash_bassfx :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_withComponents_dot_uscore_hash_selFP6_hash_bassfx x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_withComponents_dot_uscore_hash_selFP6_hash_bassfx l cd cs)
    (d_OP_withComponents_dot_uscore_hash_selFP6_hash_bassfx r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_withComponents_dot_uscore_hash_selFP6_hash_bassfx z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_withComponents_dot_uscore_hash_selFP6_hash_bassfx e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Files.withComponents._#selFP6#bassfx" [show x1] info)
  _ -> failCons cd (consFail "Files.withComponents._#selFP6#bassfx" (showCons
    x1))

d_OP_withComponents_dot_uscore_hash_selFP3_hash_base :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_withComponents_dot_uscore_hash_selFP3_hash_base x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_withComponents_dot_uscore_hash_selFP3_hash_base l cd cs)
    (d_OP_withComponents_dot_uscore_hash_selFP3_hash_base r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_withComponents_dot_uscore_hash_selFP3_hash_base z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_withComponents_dot_uscore_hash_selFP3_hash_base e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Files.withComponents._#selFP3#base" [show x1] info)
  _ -> failCons cd (consFail "Files.withComponents._#selFP3#base" (showCons x1))

d_OP_withComponents_dot_uscore_hash_selFP4_hash_suffix :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_withComponents_dot_uscore_hash_selFP4_hash_suffix x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_withComponents_dot_uscore_hash_selFP4_hash_suffix l cd cs)
    (d_OP_withComponents_dot_uscore_hash_selFP4_hash_suffix r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_withComponents_dot_uscore_hash_selFP4_hash_suffix z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_withComponents_dot_uscore_hash_selFP4_hash_suffix e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Files.withComponents._#selFP4#suffix" [show x1] info)
  _ -> failCons cd (consFail "Files.withComponents._#selFP4#suffix" (showCons
    x1))

d_C_withDirectory :: (Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_withDirectory x1 x2 cd cs = d_C_withComponents x1 Curry_Prelude.d_C_id
  Curry_Prelude.d_C_id x2 cd cs

nd_C_withDirectory :: Func (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
nd_C_withDirectory x1 x2 s cd cs = let s0 = s
  in s0 `seq` nd_C_withComponents x1 (wrapDX id Curry_Prelude.d_C_id) (wrapDX id
  Curry_Prelude.d_C_id) x2 s0 cd cs

d_C_withBaseName :: (Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_withBaseName x1 x2 cd cs = d_C_withComponents Curry_Prelude.d_C_id x1
  Curry_Prelude.d_C_id x2 cd cs

nd_C_withBaseName :: Func (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
nd_C_withBaseName x1 x2 s cd cs = let s0 = s
  in s0 `seq` nd_C_withComponents (wrapDX id Curry_Prelude.d_C_id) x1 (wrapDX id
  Curry_Prelude.d_C_id) x2 s0 cd cs

d_C_withExtension :: (Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_withExtension x1 x2 cd cs = d_C_withComponents Curry_Prelude.d_C_id
  Curry_Prelude.d_C_id x1 x2 cd cs

nd_C_withExtension :: Func (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
nd_C_withExtension x1 x2 s cd cs = let s0 = s
  in s0 `seq` nd_C_withComponents (wrapDX id Curry_Prelude.d_C_id) (wrapDX id
  Curry_Prelude.d_C_id) x1 x2 s0 cd cs

d_C_writeFileInDir :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_writeFileInDir x1 x2 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Prelude.d_OP_dollar (Curry_Directory.d_C_createDirectoryIfMissing
  Curry_Prelude.C_True) (Curry_FilePath.d_C_takeDirectory x1 cd cs) cd cs)
  (Curry_Prelude.d_C_writeFile x1 x2 cd cs) cd cs

d_C_writeQTermFileInDir :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_List Curry_Prelude.C_Char -> t0 -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_writeQTermFileInDir x1 x2 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Prelude.d_OP_dollar (Curry_Directory.d_C_createDirectoryIfMissing
  Curry_Prelude.C_True) (Curry_FilePath.d_C_takeDirectory x1 cd cs) cd cs)
  (Curry_ReadShowTerm.d_C_writeQTermFile x1 x2 cd cs) cd cs

d_C_removeFileIfExists :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_removeFileIfExists x1 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Directory.d_C_doesFileExist x1 cd cs)
  (d_OP_removeFileIfExists_dot_uscore_hash_lambda2 x1) cd cs

d_OP_removeFileIfExists_dot_uscore_hash_lambda2 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_OP_removeFileIfExists_dot_uscore_hash_lambda2 x1 x2 cd cs = let x3 = x2
  in Curry_Prelude.d_OP_dollar (Curry_Prelude.d_C_when x3)
  (Curry_Directory.d_C_removeFile x1 cd cs) cd cs

d_OP_lt_slash_qmark_gt :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_lt_slash_qmark_gt x1 x2 cd cs = Curry_Prelude.d_OP_dollar
  Curry_FilePath.d_C_joinPath (Curry_Prelude.d_OP_dollar
  (Curry_Prelude.d_C_reverse cd cs) (d_OP_lt_slash_qmark_gt_dot_add_dot_19
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs) (Curry_Prelude.d_OP_dollar (Curry_Prelude.d_C_reverse cd cs)
  (Curry_FilePath.d_C_splitDirectories x2 cd cs) cd cs)
  (Curry_Prelude.d_OP_dollar (Curry_Prelude.d_C_reverse cd cs)
  (Curry_FilePath.d_C_splitDirectories x1 cd cs) cd cs) cd cs) cd cs) cd cs

d_OP_lt_slash_qmark_gt_dot_add_dot_19 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0 -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_OP_lt_slash_qmark_gt_dot_add_dot_19 x1 x2 x3 cd cs = case x2 of
  Curry_Prelude.OP_List -> x3
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_3 x3 x2 x1 x5 x4
    (Curry_List.d_C_isPrefixOf x1 x2 x3 cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_lt_slash_qmark_gt_dot_add_dot_19 x1 l x3 cd cs)
    (d_OP_lt_slash_qmark_gt_dot_add_dot_19 x1 r x3 cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_lt_slash_qmark_gt_dot_add_dot_19 x1 z x3 cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_lt_slash_qmark_gt_dot_add_dot_19 x1 e x3 cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Files.</?>.add.19"
    [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "Files.</?>.add.19" (showCons x2))

nd_OP_lt_slash_qmark_gt_dot_add_dot_19 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Eq t0 -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.OP_List t0 -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0
nd_OP_lt_slash_qmark_gt_dot_add_dot_19 x1 x2 x3 s cd cs = case x2 of
  Curry_Prelude.OP_List -> x3
  Curry_Prelude.OP_Cons x4 x5 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_C__case_3 x3 x2 x1 x5 x4
    (Curry_List.nd_C_isPrefixOf x1 x2 x3 s0 cd cs) s1 cd cs))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (nd_OP_lt_slash_qmark_gt_dot_add_dot_19 x1 l x3 s cd cs)
    (nd_OP_lt_slash_qmark_gt_dot_add_dot_19 x1 r x3 s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    nd_OP_lt_slash_qmark_gt_dot_add_dot_19 x1 z x3 s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (nd_OP_lt_slash_qmark_gt_dot_add_dot_19 x1 e x3 s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Files.</?>.add.19"
    [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "Files.</?>.add.19" (showCons x2))

d_C_lookupFileInPath :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_lookupFileInPath x1 x2 x3 cd cs = d_C__case_1 x1 x3 x2
  (Curry_Prelude.d_C_apply (Curry_FilePath.d_C_isAbsolute cd cs) x1 cd cs) cd cs

d_OP_lookupFileInPath_dot_lookupExtFile_dot_25 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_lookupFileInPath_dot_lookupExtFile_dot_25 x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    Curry_Prelude.C_Nothing cd cs
  Curry_Prelude.OP_Cons x3 x4 -> let x5 = Curry_Prelude.d_C_apply
                                       (Curry_Prelude.d_C_apply
                                       (Curry_FilePath.d_OP_lt_dot_gt cd cs) x1
                                       cd cs) x3 cd cs
    in Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (Curry_Directory.d_C_doesFileExist x5 cd cs)
    (d_OP_lookupFileInPath_dot_lookupExtFile_dot_25_dot_uscore_hash_lambda8 x1
    x5 x4) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_lookupFileInPath_dot_lookupExtFile_dot_25 x1 l cd cs)
    (d_OP_lookupFileInPath_dot_lookupExtFile_dot_25 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_lookupFileInPath_dot_lookupExtFile_dot_25 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_lookupFileInPath_dot_lookupExtFile_dot_25 x1 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Files.lookupFileInPath.lookupExtFile.25" [show x1, show x2] info)
  _ -> failCons cd (consFail "Files.lookupFileInPath.lookupExtFile.25" (showCons
    x2))

d_OP_lookupFileInPath_dot_lookupExtFile_dot_25_dot_uscore_hash_lambda8 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_lookupFileInPath_dot_lookupExtFile_dot_25_dot_uscore_hash_lambda8 x1 x2 x3 x4 cd cs =
  case x4 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (Curry_Prelude.C_Just x2) cd cs
  Curry_Prelude.C_False -> d_OP_lookupFileInPath_dot_lookupExtFile_dot_25 x1 x3
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i
    (d_OP_lookupFileInPath_dot_lookupExtFile_dot_25_dot_uscore_hash_lambda8 x1
    x2 x3 l cd cs)
    (d_OP_lookupFileInPath_dot_lookupExtFile_dot_25_dot_uscore_hash_lambda8 x1
    x2 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z ->
    d_OP_lookupFileInPath_dot_lookupExtFile_dot_25_dot_uscore_hash_lambda8 x1 x2
    x3 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c
    (d_OP_lookupFileInPath_dot_lookupExtFile_dot_25_dot_uscore_hash_lambda8 x1
    x2 x3 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "Files.lookupFileInPath.lookupExtFile.25._#lambda8" [show x1, show x2, show
    x3, show x4] info)
  _ -> failCons cd (consFail "Files.lookupFileInPath.lookupExtFile.25._#lambda8"
    (showCons x4))

d_OP_lookupFileInPath_dot_lookupFile_dot_25 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_lookupFileInPath_dot_lookupFile_dot_25 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    Curry_Prelude.C_Nothing cd cs
  Curry_Prelude.OP_Cons x4 x5 -> Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (d_OP_lookupFileInPath_dot_lookupExtFile_dot_25 (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Curry_FilePath.d_OP_lt_slash_gt cd cs) x4 cd cs)
    x1 cd cs) x2 cd cs)
    (d_OP_lookupFileInPath_dot_lookupFile_dot_25_dot_uscore_hash_lambda5 x1 x5
    x2) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_lookupFileInPath_dot_lookupFile_dot_25 x1 x2 l cd cs)
    (d_OP_lookupFileInPath_dot_lookupFile_dot_25 x1 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_lookupFileInPath_dot_lookupFile_dot_25 x1 x2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_lookupFileInPath_dot_lookupFile_dot_25 x1 x2 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Files.lookupFileInPath.lookupFile.25" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "Files.lookupFileInPath.lookupFile.25" (showCons
    x3))

d_OP_lookupFileInPath_dot_lookupFile_dot_25_dot_uscore_hash_lambda5 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_lookupFileInPath_dot_lookupFile_dot_25_dot_uscore_hash_lambda5 x1 x2 x3 x4 cd cs =
  let x5 = x4
  in Curry_Prelude.d_C_maybe (d_OP_lookupFileInPath_dot_lookupFile_dot_25 x1 x3
  x2 cd cs) (Curry_Prelude.d_OP_dot
  Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (acceptCs id Curry_Prelude.C_Just) cd cs) x5 cd cs

d_C_getFileInPath :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_getFileInPath x1 x2 x3 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (d_C_lookupFileInPath x1 x2 x3 cd cs)
  (d_OP_getFileInPath_dot_uscore_hash_lambda11 x1 x3) cd cs

d_OP_getFileInPath_dot_uscore_hash_lambda11 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_getFileInPath_dot_uscore_hash_lambda11 x1 x2 x3 cd cs = let x4 = x3
  in Curry_Prelude.d_C_maybe (Curry_Prelude.d_OP_dollar Curry_Prelude.d_C_error
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "File ")
  (Curry_Prelude.d_OP_plus_plus x1 (Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.toCurryString " not found in path ") (Curry_Prelude.d_C_concat
  (Curry_List.d_C_intersperse (Curry_Prelude.OP_Cons
  (Curry_FilePath.d_C_searchPathSeparator cd cs) Curry_Prelude.OP_List) x2 cd
  cs) cd cs) cd cs) cd cs) cd cs) cd cs)
  Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  x4 cd cs

d_C__case_1 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_1 x1 x3 x2 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> d_OP_lookupFileInPath_dot_lookupExtFile_dot_25 x1 x2
    cd cs
  Curry_Prelude.C_False -> d_C__case_0 x3 x2 x1 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_1 x1 x3 x2 l cd
    cs) (d_C__case_1 x1 x3 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_1 x1 x3
    x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_1 x1 x3 x2 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Files._case_1"
    [show x1, show x3, show x2, show x4] info)
  _ -> failCons cd (consFail "Files._case_1" (showCons x4))

d_C__case_0 :: Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_0 x3 x2 x1 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> d_OP_lookupFileInPath_dot_lookupFile_dot_25 x1 x2 x3
    cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_0 x3 x2 x1 l cd
    cs) (d_C__case_0 x3 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_0 x3 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_0 x3 x2 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Files._case_0"
    [show x3, show x2, show x1, show x4] info)
  _ -> failCons cd (consFail "Files._case_0" (showCons x4))

d_C__case_3 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List t0
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_uscore_Dict_hash_Eq t0
  -> Curry_Prelude.OP_List t0 -> t0 -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List t0
d_C__case_3 x3 x2 x1 x5 x4 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> x3
  Curry_Prelude.C_False -> d_C__case_2 x3 x5 x1 x4 (Curry_Prelude.d_C_otherwise
    cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_3 x3 x2 x1 x5 x4
    l cd cs) (d_C__case_3 x3 x2 x1 x5 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_3 x3 x2
    x1 x5 x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_3 x3 x2 x1 x5 x4
    e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Files._case_3"
    [show x3, show x2, show x1, show x5, show x4, show x6] info)
  _ -> failCons cd (consFail "Files._case_3" (showCons x6))

nd_C__case_3 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List t0
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_uscore_Dict_hash_Eq t0
  -> Curry_Prelude.OP_List t0 -> t0 -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_List t0
nd_C__case_3 x3 x2 x1 x5 x4 x6 s cd cs = case x6 of
  Curry_Prelude.C_True -> x3
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_2 x3 x5 x1 x4 (Curry_Prelude.d_C_otherwise cd cs) s0
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_3 x3 x2 x1 x5 x4
    l s cd cs) (nd_C__case_3 x3 x2 x1 x5 x4 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_3 x3
    x2 x1 x5 x4 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_3 x3 x2 x1 x5 x4
    e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Files._case_3"
    [show x3, show x2, show x1, show x5, show x4, show x6] info)
  _ -> failCons cd (consFail "Files._case_3" (showCons x6))

d_C__case_2 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List t0
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_uscore_Dict_hash_Eq t0 -> t0
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_C__case_2 x3 x5 x1 x4 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons x4
    (d_OP_lt_slash_qmark_gt_dot_add_dot_19 x1 x5 x3 cd cs)
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_2 x3 x5 x1 x4 l
    cd cs) (d_C__case_2 x3 x5 x1 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_2 x3 x5
    x1 x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_2 x3 x5 x1 x4 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Files._case_2"
    [show x3, show x5, show x1, show x4, show x6] info)
  _ -> failCons cd (consFail "Files._case_2" (showCons x6))

nd_C__case_2 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List t0
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_uscore_Dict_hash_Eq t0 -> t0
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0
nd_C__case_2 x3 x5 x1 x4 x6 s cd cs = case x6 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` Curry_Prelude.OP_Cons x4 (nd_OP_lt_slash_qmark_gt_dot_add_dot_19
    x1 x5 x3 s0 cd cs)
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_2 x3 x5 x1 x4 l
    s cd cs) (nd_C__case_2 x3 x5 x1 x4 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_2 x3
    x5 x1 x4 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_2 x3 x5 x1 x4 e
    s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Files._case_2"
    [show x3, show x5, show x1, show x4, show x6] info)
  _ -> failCons cd (consFail "Files._case_2" (showCons x6))

