{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE Rank2Types #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module Curry_GhciComm
  ( C_GhciComm (..)
  , d_C_initGhciComm
  , d_C_stopGhciComm
  , d_C_restartGhciComm
  , d_C_evalMainCmd
  , d_C_evalCustomCmd )
  where

import Basics
import qualified Curry_IO
import qualified Curry_IOExts
import qualified Curry_Prelude
import qualified Curry_Time


data C_GhciComm
  = C_GhciComm (Curry_Prelude.OP_List Curry_Prelude.C_Char) Curry_IO.C_Handle
    Curry_Prelude.C_Bool
  | Choice_C_GhciComm Cover ID C_GhciComm C_GhciComm
  | Choices_C_GhciComm Cover ID [C_GhciComm]
  | Fail_C_GhciComm Cover FailInfo
  | Guard_C_GhciComm Cover Constraints C_GhciComm

instance Show C_GhciComm where
  showsPrec d (Choice_C_GhciComm cd i x y) = showsChoice d cd i x y
  showsPrec d (Choices_C_GhciComm cd i xs) = showsChoices d cd i xs
  showsPrec d (Guard_C_GhciComm cd c e) = showsGuard d cd c e
  showsPrec _ (Fail_C_GhciComm cd info) = showChar '!'
  showsPrec _ (C_GhciComm x1 x2 x3) = showString "(GhciComm" . (showChar ' ' .
    (shows x1 . (showChar ' ' . (shows x2 . (showChar ' ' . (shows x3 . showChar
    ')'))))))

instance Read C_GhciComm where
  readsPrec d s = readParen ((>) d 10) (\r -> [(C_GhciComm x1 x2 x3, r3) | (_
    , r0) <- readQualified "GhciComm" "GhciComm" r, (x1, r1) <- readsPrec 11 r0,
    (x2, r2) <- readsPrec 11 r1, (x3, r3) <- readsPrec 11 r2]) s

instance NonDet C_GhciComm where
  choiceCons = Choice_C_GhciComm
  choicesCons = Choices_C_GhciComm
  failCons = Fail_C_GhciComm
  guardCons = Guard_C_GhciComm
  try (Choice_C_GhciComm cd i x y) = tryChoice cd i x y
  try (Choices_C_GhciComm cd i xs) = tryChoices cd i xs
  try (Fail_C_GhciComm cd info) = Fail cd info
  try (Guard_C_GhciComm cd c e) = Guard cd c e
  try x = Val x
  match f _ _ _ _ _ (Choice_C_GhciComm cd i x y) = f cd i x y
  match _ f _ _ _ _ (Choices_C_GhciComm cd i@(NarrowedID _ _) xs) = f cd i xs
  match _ _ f _ _ _ (Choices_C_GhciComm cd i@(FreeID _ _) xs) = f cd i xs
  match _ _ _ _ _ _ (Choices_C_GhciComm cd i _) = error
    ("GhciComm.GhciComm.match: Choices with ChoiceID " ++ show i)
  match _ _ _ f _ _ (Fail_C_GhciComm cd info) = f cd info
  match _ _ _ _ f _ (Guard_C_GhciComm cd c e) = f cd c e
  match _ _ _ _ _ f x = f x

instance Generable C_GhciComm where
  generate s c = Choices_C_GhciComm c (freeID [3] s) [C_GhciComm (generate
    (leftSupply (leftSupply s)) c) (generate (rightSupply (leftSupply s)) c)
    (generate (rightSupply s) c)]

instance NormalForm C_GhciComm where
  ($!!) cont (C_GhciComm x1 x2 x3) d cs = ($!!) (\y1 d cs -> ($!!) (\y2 d cs ->
    ($!!) (\y3 d cs -> cont (C_GhciComm y1 y2 y3) d cs) x3 d cs) x2 d cs) x1 d
    cs
  ($!!) cont (Choice_C_GhciComm cd i x y) d cs = nfChoice cont cd i x y cd cs
  ($!!) cont (Choices_C_GhciComm cd i xs) d cs = nfChoices cont cd i xs d cs
  ($!!) cont (Guard_C_GhciComm cd c e) d cs = guardCons cd c (($!!) cont e d
    (addCs c cs))
  ($!!) _ (Fail_C_GhciComm cd info) _ _ = failCons cd info
  ($##) cont (C_GhciComm x1 x2 x3) d cs = ($##) (\y1 d cs -> ($##) (\y2 d cs ->
    ($##) (\y3 d cs -> cont (C_GhciComm y1 y2 y3) d cs) x3 d cs) x2 d cs) x1 d
    cs
  ($##) cont (Choice_C_GhciComm cd i x y) d cs = gnfChoice cont cd i x y cd cs
  ($##) cont (Choices_C_GhciComm cd i xs) d cs = gnfChoices cont cd i xs d cs
  ($##) cont (Guard_C_GhciComm cd c e) d cs = guardCons cd c (($##) cont e d
    (addCs c cs))
  ($##) _ (Fail_C_GhciComm cd info) _ _ = failCons cd info
  showCons (C_GhciComm _ _ _) = "GhciComm.GhciComm _ _ _"
  showCons x = error ("GhciComm.GhciComm.showCons: no constructor: " ++ show x)
  searchNF search cont (C_GhciComm x1 x2 x3) = search (\y1 -> search (\y2 ->
    search (\y3 -> cont (C_GhciComm y1 y2 y3)) x3) x2) x1
  searchNF _ _ x = error ("GhciComm.GhciComm.searchNF: no constructor: " ++ show
    x)

instance Unifiable C_GhciComm where
  (=.=) (C_GhciComm x1 x2 x3) (C_GhciComm y1 y2 y3) d cs = (&) ((=:=) x1 y1 d
    cs) ((&) ((=:=) x2 y2 d cs) ((=:=) x3 y3 d cs) d cs) d cs
  (=.=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  (=.<=) (C_GhciComm x1 x2 x3) (C_GhciComm y1 y2 y3) d cs = (&) ((=:<=) x1 y1 d
    cs) ((&) ((=:<=) x2 y2 d cs) ((=:<=) x3 y3 d cs) d cs) d cs
  (=.<=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  bind cd i (C_GhciComm x3 x4 x5) = (i :=: ChooseN 0 3) : concat [bind cd
    (leftID (leftID i)) x3, bind cd (rightID (leftID i)) x4, bind cd (rightID i)
    x5]
  bind d i (Choice_C_GhciComm cd j x y) = [ConstraintChoice cd j (bind d i x)
    (bind d i y)]
  bind d i (Choices_C_GhciComm cd j@(FreeID _ _) xs) = bindOrNarrow d i cd j xs
  bind d i (Choices_C_GhciComm cd j@(NarrowedID _ _) xs) = [ConstraintChoices cd
    j (map (bind d i) xs)]
  bind _ _ (Choices_C_GhciComm cd i _) = error
    ("GhciComm.GhciComm.bind: Choices with ChoiceID: " ++ show i)
  bind _ _ (Fail_C_GhciComm cd info) = [Unsolvable info]
  bind d i (Guard_C_GhciComm cd c e) = getConstrList c ++ bind d i e
  lazyBind cd i (C_GhciComm x3 x4 x5) = (i :=: ChooseN 0 3) : [leftID (leftID
    i) :=: LazyBind (lazyBind cd (leftID (leftID i)) x3), rightID (leftID i) :=:
    LazyBind (lazyBind cd (rightID (leftID i)) x4), rightID i :=: LazyBind
    (lazyBind cd (rightID i) x5)]
  lazyBind d i (Choice_C_GhciComm cd j x y) = [ConstraintChoice cd j (lazyBind d
    i x) (lazyBind d i y)]
  lazyBind d i (Choices_C_GhciComm cd j@(FreeID _ _) xs) = lazyBindOrNarrow d i
    cd j xs
  lazyBind d i (Choices_C_GhciComm cd j@(NarrowedID _ _) xs) =
    [ConstraintChoices cd j (map (lazyBind d i) xs)]
  lazyBind _ _ (Choices_C_GhciComm cd i _) = error
    ("GhciComm.GhciComm.lazyBind: Choices with ChoiceID: " ++ show i)
  lazyBind _ _ (Fail_C_GhciComm cd info) = [Unsolvable info]
  lazyBind d i (Guard_C_GhciComm cd c e) = getConstrList c ++ [i :=: LazyBind
    (lazyBind d i e)]

instance Curry C_GhciComm where

d_C_initGhciComm :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  C_GhciComm
d_C_initGhciComm x1 x2 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_IOExts.d_C_connectToCommand x1 cd cs)
  (d_OP_initGhciComm_dot_uscore_hash_lambda2 x2 x1) cd cs

d_OP_initGhciComm_dot_uscore_hash_lambda2 :: Curry_Prelude.C_Bool
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_IO.C_Handle -> Cover
  -> ConstStore -> Curry_Prelude.C_IO C_GhciComm
d_OP_initGhciComm_dot_uscore_hash_lambda2 x1 x2 x3 cd cs = let x4 = x3
                                                               x5 = C_GhciComm
                                                                 x2 x4 x1
  in Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (d_C_evalCustomCmd x5 (Curry_Prelude.toCurryString "putStrLn \"\"") cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  x5 cd cs) cd cs

d_C_stopGhciComm :: C_GhciComm -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
d_C_stopGhciComm x1 cd cs = case x1 of
  C_GhciComm x2 x3 x4 -> Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (d_C_hPutStrLnGhci x1 (Curry_Prelude.toCurryString ":quit") cd cs)
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (Curry_Prelude.d_C_when x4
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (Curry_IO.d_C_hGetLine x3 cd cs) Curry_Prelude.d_C_putStrLn cd cs) cd cs)
    (Curry_IO.d_C_hClose x3 cd cs) cd cs) cd cs
  Choice_C_GhciComm d i l r -> narrow d i (d_C_stopGhciComm l cd cs)
    (d_C_stopGhciComm r cd cs)
  Choices_C_GhciComm d i xs -> narrows cs d i (\z -> d_C_stopGhciComm z cd cs)
    xs
  Guard_C_GhciComm d c e -> guardCons d c (d_C_stopGhciComm e cd $! addCs c cs)
  Fail_C_GhciComm d info -> failCons d (traceFail "GhciComm.stopGhciComm" [show
    x1] info)
  _ -> failCons cd (consFail "GhciComm.stopGhciComm" (showCons x1))

d_C_restartGhciComm :: C_GhciComm -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  C_GhciComm
d_C_restartGhciComm x1 x2 x3 cd cs = case x1 of
  C_GhciComm x4 x5 x6 -> d_C__case_2 x4 x2 x3 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) x2 x4 cd cs) cd cs
  Choice_C_GhciComm d i l r -> narrow d i (d_C_restartGhciComm l x2 x3 cd cs)
    (d_C_restartGhciComm r x2 x3 cd cs)
  Choices_C_GhciComm d i xs -> narrows cs d i (\z -> d_C_restartGhciComm z x2 x3
    cd cs) xs
  Guard_C_GhciComm d c e -> guardCons d c (d_C_restartGhciComm e x2 x3 cd $!
    addCs c cs)
  Fail_C_GhciComm d info -> failCons d (traceFail "GhciComm.restartGhciComm"
    [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "GhciComm.restartGhciComm" (showCons x1))

d_C_evalMainCmd :: C_GhciComm -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_evalMainCmd x1 x2 cd cs = case x1 of
  C_GhciComm x3 x4 x5 -> Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (d_C_hPutStrLnGhci x1 (d_C__case_0 x2 cd cs) cd cs)
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (d_C_evalCustomCmd x1 (Curry_Prelude.toCurryString "safeExec main") cd cs)
    (Curry_Prelude.d_C_when x2
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (Curry_IO.d_C_hGetLine x4 cd cs) Curry_Prelude.d_C_putStrLn cd cs) cd cs) cd
    cs) cd cs
  Choice_C_GhciComm d i l r -> narrow d i (d_C_evalMainCmd l x2 cd cs)
    (d_C_evalMainCmd r x2 cd cs)
  Choices_C_GhciComm d i xs -> narrows cs d i (\z -> d_C_evalMainCmd z x2 cd cs)
    xs
  Guard_C_GhciComm d c e -> guardCons d c (d_C_evalMainCmd e x2 cd $! addCs c
    cs)
  Fail_C_GhciComm d info -> failCons d (traceFail "GhciComm.evalMainCmd" [show
    x1, show x2] info)
  _ -> failCons cd (consFail "GhciComm.evalMainCmd" (showCons x1))

d_C_evalCustomCmd :: C_GhciComm -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_evalCustomCmd x1 x2 cd cs = case x1 of
  C_GhciComm x3 x4 x5 -> Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (Curry_Time.d_C_getLocalTime cd cs)
    (d_OP_evalCustomCmd_dot_uscore_hash_lambda8 x1 x4 x2) cd cs
  Choice_C_GhciComm d i l r -> narrow d i (d_C_evalCustomCmd l x2 cd cs)
    (d_C_evalCustomCmd r x2 cd cs)
  Choices_C_GhciComm d i xs -> narrows cs d i (\z -> d_C_evalCustomCmd z x2 cd
    cs) xs
  Guard_C_GhciComm d c e -> guardCons d c (d_C_evalCustomCmd e x2 cd $! addCs c
    cs)
  Fail_C_GhciComm d info -> failCons d (traceFail "GhciComm.evalCustomCmd" [show
    x1, show x2] info)
  _ -> failCons cd (consFail "GhciComm.evalCustomCmd" (showCons x1))

d_OP_evalCustomCmd_dot_hPrintLinesBefore_dot_20 :: Curry_IO.C_Handle
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_OP_evalCustomCmd_dot_hPrintLinesBefore_dot_20 x1 x2 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_IO.d_C_hGetLine x1 cd cs)
  (d_OP_evalCustomCmd_dot_hPrintLinesBefore_dot_20_dot_uscore_hash_lambda5 x1
  x2) cd cs

d_OP_evalCustomCmd_dot_hPrintLinesBefore_dot_20_dot_uscore_hash_lambda5 :: Curry_IO.C_Handle
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
d_OP_evalCustomCmd_dot_hPrintLinesBefore_dot_20_dot_uscore_hash_lambda5 x1 x2 x3 cd cs =
  let x4 = x3
  in Curry_Prelude.d_OP_dollar (Curry_Prelude.d_C_unless
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) x4 x2 cd cs))
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Prelude.d_C_putStrLn x4 cd cs)
  (d_OP_evalCustomCmd_dot_hPrintLinesBefore_dot_20 x1 x2 cd cs) cd cs) cd cs

d_OP_evalCustomCmd_dot_uscore_hash_lambda8 :: C_GhciComm -> Curry_IO.C_Handle
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Time.C_CalendarTime
  -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_OP_evalCustomCmd_dot_uscore_hash_lambda8 x1 x2 x3 x4 cd cs = let x5 = x4
                                                                   x6 = Curry_Prelude.d_OP_plus_plus
                                                                     (Curry_Prelude.toCurryString
                                                                     "???")
                                                                     (Curry_Prelude.d_OP_plus_plus
                                                                     (Curry_Prelude.d_C_apply
                                                                     (Curry_Prelude.d_C_reverse
                                                                     cd cs)
                                                                     (Curry_Time.d_C_calendarTimeToString
                                                                     x5 cd cs)
                                                                     cd cs)
                                                                     (Curry_Prelude.toCurryString
                                                                     "===") cd
                                                                     cs) cd cs
  in Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Prelude.d_OP_dollar (d_C_hPutStrLnGhci x1)
  (Curry_Prelude.d_OP_plus_plus x3 (Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.toCurryString " >> putStrLn \"") (Curry_Prelude.d_OP_plus_plus
  x6 (Curry_Prelude.toCurryString "\"") cd cs) cd cs) cd cs) cd cs)
  (d_OP_evalCustomCmd_dot_hPrintLinesBefore_dot_20 x2 x6 cd cs) cd cs

d_C_hPutStrLnGhci :: C_GhciComm -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_hPutStrLnGhci x1 x2 cd cs = case x1 of
  C_GhciComm x3 x4 x5 -> Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (Curry_Prelude.d_OP_dollar (Curry_Prelude.d_C_when x5)
    (Curry_Prelude.d_OP_dollar Curry_Prelude.d_C_putStrLn
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "SEND TO GHCI> ")
    x2 cd cs) cd cs) cd cs)
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (Curry_IO.d_C_hPutStrLn x4 x2 cd cs) (Curry_IO.d_C_hFlush x4 cd cs) cd cs)
    cd cs
  Choice_C_GhciComm d i l r -> narrow d i (d_C_hPutStrLnGhci l x2 cd cs)
    (d_C_hPutStrLnGhci r x2 cd cs)
  Choices_C_GhciComm d i xs -> narrows cs d i (\z -> d_C_hPutStrLnGhci z x2 cd
    cs) xs
  Guard_C_GhciComm d c e -> guardCons d c (d_C_hPutStrLnGhci e x2 cd $! addCs c
    cs)
  Fail_C_GhciComm d info -> failCons d (traceFail "GhciComm.hPutStrLnGhci" [show
    x1, show x2] info)
  _ -> failCons cd (consFail "GhciComm.hPutStrLnGhci" (showCons x1))

d_C__case_0 :: Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_0 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.toCurryString ":set +s"
  Curry_Prelude.C_False -> Curry_Prelude.toCurryString ":unset +s"
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_0 l cd cs)
    (d_C__case_0 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_0 z cd
    cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_0 e cd $! addCs c
    cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "GhciComm._case_0"
    [show x2] info)
  _ -> failCons cd (consFail "GhciComm._case_0" (showCons x2))

d_C__case_2 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool
  -> C_GhciComm -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_IO C_GhciComm
d_C__case_2 x4 x2 x3 x1 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (d_C_hPutStrLnGhci x1 (Curry_Prelude.toCurryString ":reload") cd cs)
    (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    x1 cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_1 x3 x2 x1 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_2 x4 x2 x3 x1 l
    cd cs) (d_C__case_2 x4 x2 x3 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_2 x4 x2
    x3 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_2 x4 x2 x3 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "GhciComm._case_2"
    [show x4, show x2, show x3, show x1, show x5] info)
  _ -> failCons cd (consFail "GhciComm._case_2" (showCons x5))

d_C__case_1 :: Curry_Prelude.C_Bool -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> C_GhciComm -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_IO C_GhciComm
d_C__case_1 x3 x2 x1 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (d_C_stopGhciComm x1 cd cs) (d_C_initGhciComm x2 x3 cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_1 x3 x2 x1 l cd
    cs) (d_C__case_1 x3 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_1 x3 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_1 x3 x2 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "GhciComm._case_1"
    [show x3, show x2, show x1, show x4] info)
  _ -> failCons cd (consFail "GhciComm._case_1" (showCons x4))

