{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE Rank2Types #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module Curry_Installation
  ( d_C_compilerName
  , d_C_installDir
  , d_C_buildDir
  , d_C_pkgInstallDir
  , d_C_majorVersion
  , d_C_minorVersion
  , d_C_revisionVersion
  , d_C_buildVersion
  , d_C_compilerDate
  , d_C_installDate
  , d_C_runtime
  , d_C_runtimeMajor
  , d_C_runtimeMinor
  , d_C_baseVersion
  , d_C_ghcExec
  , d_C_ghcLocalOptions
  , d_C_ghcOptions
  , d_C_ghcOptimizations
  , d_C_withProfiling )
  where

import Basics
import qualified Curry_Directory
import qualified Curry_Prelude
import qualified Curry_Unsafe


d_C_compilerName :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_compilerName cd cs = Curry_Prelude.toCurryString "kics2"

d_C_installDir :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_installDir cd cs = d_C__case_1 (Curry_Prelude.d_C_null (d_C_pkgInstallDir cd
  cs) cd cs) cd cs

d_C_buildDir :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_buildDir cd cs = Curry_Prelude.toCurryString
  "/net/medoc/home/kics2/amd64/kics2/kics2-2.0.0"

d_C_pkgInstallDir :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_pkgInstallDir cd cs = Curry_Prelude.OP_List

d_C_majorVersion :: Cover -> ConstStore -> Curry_Prelude.C_Int
d_C_majorVersion cd cs = Curry_Prelude.C_Int (2)

d_C_minorVersion :: Cover -> ConstStore -> Curry_Prelude.C_Int
d_C_minorVersion cd cs = Curry_Prelude.C_Int (0)

d_C_revisionVersion :: Cover -> ConstStore -> Curry_Prelude.C_Int
d_C_revisionVersion cd cs = Curry_Prelude.C_Int (0)

d_C_buildVersion :: Cover -> ConstStore -> Curry_Prelude.C_Int
d_C_buildVersion cd cs = Curry_Prelude.C_Int (0)

d_C_compilerDate :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_compilerDate cd cs = Curry_Prelude.toCurryString "2018-11-23"

d_C_installDate :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_installDate cd cs = Curry_Prelude.toCurryString
  "Fri Nov 23 12:07:03 CET 2018"

d_C_runtime :: Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_runtime cd cs = Curry_Prelude.toCurryString "ghc"

d_C_runtimeMajor :: Cover -> ConstStore -> Curry_Prelude.C_Int
d_C_runtimeMajor cd cs = Curry_Prelude.C_Int (7)

d_C_runtimeMinor :: Cover -> ConstStore -> Curry_Prelude.C_Int
d_C_runtimeMinor cd cs = Curry_Prelude.C_Int (10)

d_C_baseVersion :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_baseVersion cd cs = Curry_Prelude.OP_List

d_C_ghcExec :: Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_ghcExec cd cs = Curry_Prelude.toCurryString "\"/opt/ghc/7.10.3/bin/ghc\""

d_C_ghcLocalOptions :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_ghcLocalOptions cd cs = Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.toCurryString "-no-user-package-db -package-db \"")
  (Curry_Prelude.d_OP_plus_plus (d_C_installDir cd cs)
  (Curry_Prelude.toCurryString
  "/pkg/kics2.conf.d\" -hide-all-packages -package base -package containers -package directory -package ghc -package mtl -package network -package old-time -package parallel-tree-search -package process -package time -package tree-monad -package unix")
  cd cs) cd cs

d_C_ghcOptions :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_ghcOptions cd cs = Curry_Prelude.d_OP_plus_plus (d_C_ghcLocalOptions cd cs)
  (Curry_Prelude.toCurryString
  " -package kics2-runtime -package kics2-libraries -package kics2-libraries-trace")
  cd cs

d_C_ghcOptimizations :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_ghcOptimizations cd cs = Curry_Prelude.toCurryString "-O2"

d_C_withProfiling :: Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_withProfiling cd cs = Curry_Prelude.C_True

d_C__case_1 :: Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_1 x1 cd cs = case x1 of
  Curry_Prelude.C_True -> d_C_buildDir cd cs
  Curry_Prelude.C_False -> d_C__case_0 (Curry_Unsafe.d_C_unsafePerformIO
    (Curry_Directory.d_C_doesDirectoryExist (d_C_pkgInstallDir cd cs) cd cs) cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_1 l cd cs)
    (d_C__case_1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_1 z cd
    cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_1 e cd $! addCs c
    cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "Installation._case_1" [show x1] info)
  _ -> failCons cd (consFail "Installation._case_1" (showCons x1))

d_C__case_0 :: Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_0 x1 cd cs = case x1 of
  Curry_Prelude.C_True -> d_C_pkgInstallDir cd cs
  Curry_Prelude.C_False -> d_C_buildDir cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_0 l cd cs)
    (d_C__case_0 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_0 z cd
    cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_0 e cd $! addCs c
    cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "Installation._case_0" [show x1] info)
  _ -> failCons cd (consFail "Installation._case_0" (showCons x1))

