{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE Rank2Types #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module Curry_Message
  ( d_C_putErrLn
  , d_C_showStatus
  , d_C_showAnalysis
  , d_C_showDetail
  , d_C_showLevel )
  where

import Basics
import qualified Curry_CompilerOpts
import qualified Curry_IO
import qualified Curry_Prelude


d_C_putErrLn :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_putErrLn x1 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_IO.d_C_hPutStrLn (Curry_IO.d_C_stderr cd cs)
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString
  "Compilation Error: ") x1 cd cs) cd cs) (Curry_IO.d_C_hFlush
  (Curry_IO.d_C_stderr cd cs) cd cs) cd cs

d_C_showStatus :: Curry_CompilerOpts.C_Options -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
d_C_showStatus x1 x2 cd cs = d_C_showLevel Curry_CompilerOpts.C_VerbStatus x1 x2
  cd cs

d_C_showAnalysis :: Curry_CompilerOpts.C_Options -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
d_C_showAnalysis x1 x2 cd cs = d_C_showLevel Curry_CompilerOpts.C_VerbAnalysis
  x1 x2 cd cs

d_C_showDetail :: Curry_CompilerOpts.C_Options -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
d_C_showDetail x1 x2 cd cs = d_C_showLevel Curry_CompilerOpts.C_VerbDetails x1
  x2 cd cs

d_C_showLevel :: Curry_CompilerOpts.C_Verbosity -> Curry_CompilerOpts.C_Options
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_showLevel x1 x2 x3 cd cs = Curry_Prelude.d_C_unless (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply
  (Curry_CompilerOpts.d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_Verbosity
  cd cs) (Curry_CompilerOpts.d_C_optVerbosity x2 cd cs) cd cs) x1 cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Prelude.d_C_putStrLn x3 cd cs) (Curry_IO.d_C_hFlush
  (Curry_IO.d_C_stdout cd cs) cd cs) cd cs) cd cs

