{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE Rank2Types #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module Curry_Names
  ( d_C_renameFile
  , d_C_externalFile
  , d_C_destFile
  , d_C_analysisFile
  , d_C_funcInfoFile
  , d_C_prelude
  , d_C_basics
  , d_C_curryPrelude
  , d_C_renameModule
  , d_C_unRenameModule
  , d_C_addTrace
  , d_C_removeTrace
  , d_C_onLastIdentifier
  , nd_C_onLastIdentifier
  , d_C_onLast
  , nd_C_onLast
  , d_C_isCurryModule
  , d_C_isHaskellModule
  , d_C_mkChoiceName
  , d_C_mkChoicesName
  , d_C_mkFailName
  , d_C_mkGuardName
  , d_C_mkFoConsName
  , d_C_mkHoConsName
  , d_C_unRenamePrefixedFunc
  , d_C_dropFuncPrefix
  , d_C_funcPrefix
  , d_C_consPrefix
  , d_C_renameQNameTrace
  , d_C_renameQName
  , d_C_unRenameQName
  , d_C_externalFunc
  , d_C_fromExternalFunc
  , d_C_mkGlobalName
  , d_C_fromGlobalName
  , d_C_genRename
  , d_C_unGenRename
  , d_C_mkTuple
  , d_C_parseNat
  , d_C_withQName
  , nd_C_withQName
  , d_C_dropPrefix
  , d_C_isInfixName
  , d_C_opRenaming
  , d_C_unRenameOp
  , d_C_splitAll
  , nd_C_splitAll
  , d_C_replaceNonIdChars
  , d_C_spanAll
  , nd_C_spanAll
  , d_C_splitModuleFileName
  , d_C_moduleNameToPath
  , d_C_splitModuleIdentifiers
  , d_C_joinModuleIdentifiers
  , d_C_moduleToFileName
  , d_C_joinModuleIdentifiersToFileName )
  where

import Basics
import qualified Curry_AbstractHaskell
import qualified Curry_Char
import qualified Curry_Classification
import qualified Curry_FilePath
import qualified Curry_Files
import qualified Curry_List
import qualified Curry_Prelude


d_C_renameFile :: Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_renameFile x1 cd cs = case x1 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_dot (d_C_addTrace cd cs)
    (d_C_renameModule cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_42 (Curry_Prelude.d_C_otherwise cd cs) cd
    cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C_renameFile l cd cs)
    (d_C_renameFile r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C_renameFile z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C_renameFile e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names.renameFile"
    [show x1] info)
  _ -> failCons cd (consFail "Names.renameFile" (showCons x1))

d_C_externalFile :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_externalFile cd cs = Curry_Files.d_C_withComponents Curry_Prelude.d_C_id
  Curry_Prelude.d_C_id (Curry_Prelude.d_C_const (Curry_Prelude.toCurryString
  "kics2"))

d_C_destFile :: Curry_Prelude.C_Bool -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_destFile x1 x2 x3 x4 cd cs = let x5 = d_C_splitModuleFileName x3 x4 cd cs
                                     x6 = d_OP_destFile_dot_uscore_hash_selFP2_hash_pre
                                       x5 cd cs
                                     x7 = d_OP_destFile_dot_uscore_hash_selFP3_hash_file
                                       x5 cd cs
                                     x8 = Curry_Prelude.d_OP_dollar
                                       Curry_FilePath.d_C_normalise
                                       (Curry_Files.d_OP_lt_slash_qmark_gt x6 x2
                                       cd cs) cd cs
  in Curry_Files.d_C_withComponents (Curry_Files.d_OP_lt_slash_qmark_gt x8)
  (d_C_renameFile x1 cd cs) (Curry_Prelude.d_C_const
  (Curry_Prelude.toCurryString "hs")) x7 cd cs

d_OP_destFile_dot_uscore_hash_selFP2_hash_pre :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_destFile_dot_uscore_hash_selFP2_hash_pre x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_destFile_dot_uscore_hash_selFP2_hash_pre l cd cs)
    (d_OP_destFile_dot_uscore_hash_selFP2_hash_pre r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_destFile_dot_uscore_hash_selFP2_hash_pre z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_destFile_dot_uscore_hash_selFP2_hash_pre e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Names.destFile._#selFP2#pre" [show x1] info)
  _ -> failCons cd (consFail "Names.destFile._#selFP2#pre" (showCons x1))

d_OP_destFile_dot_uscore_hash_selFP3_hash_file :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_destFile_dot_uscore_hash_selFP3_hash_file x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_destFile_dot_uscore_hash_selFP3_hash_file l cd cs)
    (d_OP_destFile_dot_uscore_hash_selFP3_hash_file r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_destFile_dot_uscore_hash_selFP3_hash_file z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_destFile_dot_uscore_hash_selFP3_hash_file e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Names.destFile._#selFP3#file" [show x1] info)
  _ -> failCons cd (consFail "Names.destFile._#selFP3#file" (showCons x1))

d_C_analysisFile :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_analysisFile x1 x2 x3 cd cs = let x4 = d_C_splitModuleFileName x2 x3 cd cs
                                      x5 = d_OP_analysisFile_dot_uscore_hash_selFP5_hash_pre
                                        x4 cd cs
                                      x6 = d_OP_analysisFile_dot_uscore_hash_selFP6_hash_file
                                        x4 cd cs
                                      x7 = Curry_Prelude.d_OP_dollar
                                        Curry_FilePath.d_C_normalise
                                        (Curry_Files.d_OP_lt_slash_qmark_gt x5
                                        x1 cd cs) cd cs
  in Curry_Files.d_C_withComponents (Curry_Files.d_OP_lt_slash_qmark_gt x7)
  (d_C_renameFile Curry_Prelude.C_False cd cs) (Curry_Prelude.d_C_const
  (Curry_Prelude.toCurryString "nda")) x6 cd cs

d_OP_analysisFile_dot_uscore_hash_selFP5_hash_pre :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_analysisFile_dot_uscore_hash_selFP5_hash_pre x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_analysisFile_dot_uscore_hash_selFP5_hash_pre l cd cs)
    (d_OP_analysisFile_dot_uscore_hash_selFP5_hash_pre r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_analysisFile_dot_uscore_hash_selFP5_hash_pre z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_analysisFile_dot_uscore_hash_selFP5_hash_pre e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Names.analysisFile._#selFP5#pre" [show x1] info)
  _ -> failCons cd (consFail "Names.analysisFile._#selFP5#pre" (showCons x1))

d_OP_analysisFile_dot_uscore_hash_selFP6_hash_file :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_analysisFile_dot_uscore_hash_selFP6_hash_file x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_analysisFile_dot_uscore_hash_selFP6_hash_file l cd cs)
    (d_OP_analysisFile_dot_uscore_hash_selFP6_hash_file r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_analysisFile_dot_uscore_hash_selFP6_hash_file z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_analysisFile_dot_uscore_hash_selFP6_hash_file e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Names.analysisFile._#selFP6#file" [show x1] info)
  _ -> failCons cd (consFail "Names.analysisFile._#selFP6#file" (showCons x1))

d_C_funcInfoFile :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_funcInfoFile x1 x2 x3 cd cs = let x4 = d_C_splitModuleFileName x2 x3 cd cs
                                      x5 = d_OP_funcInfoFile_dot_uscore_hash_selFP8_hash_pre
                                        x4 cd cs
                                      x6 = d_OP_funcInfoFile_dot_uscore_hash_selFP9_hash_file
                                        x4 cd cs
                                      x7 = Curry_Prelude.d_OP_dollar
                                        Curry_FilePath.d_C_normalise
                                        (Curry_Files.d_OP_lt_slash_qmark_gt x5
                                        x1 cd cs) cd cs
  in Curry_Files.d_C_withComponents (Curry_Files.d_OP_lt_slash_qmark_gt x7)
  (d_C_renameFile Curry_Prelude.C_False cd cs) (Curry_Prelude.d_C_const
  (Curry_Prelude.toCurryString "info")) x6 cd cs

d_OP_funcInfoFile_dot_uscore_hash_selFP8_hash_pre :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_funcInfoFile_dot_uscore_hash_selFP8_hash_pre x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_funcInfoFile_dot_uscore_hash_selFP8_hash_pre l cd cs)
    (d_OP_funcInfoFile_dot_uscore_hash_selFP8_hash_pre r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_funcInfoFile_dot_uscore_hash_selFP8_hash_pre z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_funcInfoFile_dot_uscore_hash_selFP8_hash_pre e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Names.funcInfoFile._#selFP8#pre" [show x1] info)
  _ -> failCons cd (consFail "Names.funcInfoFile._#selFP8#pre" (showCons x1))

d_OP_funcInfoFile_dot_uscore_hash_selFP9_hash_file :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_funcInfoFile_dot_uscore_hash_selFP9_hash_file x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_funcInfoFile_dot_uscore_hash_selFP9_hash_file l cd cs)
    (d_OP_funcInfoFile_dot_uscore_hash_selFP9_hash_file r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_funcInfoFile_dot_uscore_hash_selFP9_hash_file z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_funcInfoFile_dot_uscore_hash_selFP9_hash_file e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Names.funcInfoFile._#selFP9#file" [show x1] info)
  _ -> failCons cd (consFail "Names.funcInfoFile._#selFP9#file" (showCons x1))

d_C_prelude :: Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_prelude cd cs = Curry_Prelude.toCurryString "Prelude"

d_C_basics :: Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_basics cd cs = Curry_Prelude.toCurryString "Basics"

d_C_curryPrelude :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_curryPrelude cd cs = Curry_Prelude.d_C_apply (d_C_renameModule cd cs)
  (d_C_prelude cd cs) cd cs

d_C_renameModule :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_renameModule cd cs = d_C_onLastIdentifier (Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.toCurryString "Curry_")) cd cs

d_C_unRenameModule :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_unRenameModule cd cs = d_C_onLastIdentifier (d_C_dropPrefix
  (Curry_Prelude.toCurryString "Curry_")) cd cs

d_C_addTrace :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_addTrace cd cs = Curry_Prelude.d_OP_dot (d_C_renameModule cd cs)
  (Curry_Prelude.d_OP_dot (d_C_onLastIdentifier (Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.toCurryString "Trace_")) cd cs) (d_C_unRenameModule cd cs) cd
  cs) cd cs

d_C_removeTrace :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_removeTrace cd cs = Curry_Prelude.d_OP_dot (d_C_renameModule cd cs)
  (Curry_Prelude.d_OP_dot (d_C_onLastIdentifier (d_C_dropPrefix
  (Curry_Prelude.toCurryString "Trace_")) cd cs) (d_C_unRenameModule cd cs) cd
  cs) cd cs

d_C_onLastIdentifier :: (Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_onLastIdentifier x1 cd cs = Curry_Prelude.d_OP_dot
  (d_C_joinModuleIdentifiers cd cs) (Curry_Prelude.d_OP_dot (d_C_onLast x1)
  d_C_splitModuleIdentifiers cd cs) cd cs

nd_C_onLastIdentifier :: Func (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply -> Cover
  -> ConstStore -> Func (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
nd_C_onLastIdentifier x1 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (wrapDX id
  (d_C_joinModuleIdentifiers cd cs)) (Curry_Prelude.nd_OP_dot (wrapNX id
  (nd_C_onLast x1)) (wrapDX id d_C_splitModuleIdentifiers) s0 cd cs) s1 cd cs))

d_C_onLast :: forall t0 . (Curry_Prelude.Curry t0) => (t0 -> Cover -> ConstStore
  -> t0) -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0
d_C_onLast x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "Names.onLast: empty list") cd cs
  Curry_Prelude.OP_Cons x3 x4 -> d_C__case_41 x1 x3 x4 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_onLast x1 l cd cs)
    (d_C_onLast x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_onLast x1 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_onLast x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Names.onLast"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Names.onLast" (showCons x2))

nd_C_onLast :: forall t0 . (Curry_Prelude.Curry t0) => Func t0 t0
  -> Curry_Prelude.OP_List t0 -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0
nd_C_onLast x1 x2 s cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "Names.onLast: empty list") cd cs
  Curry_Prelude.OP_Cons x3 x4 -> let s0 = s
    in s0 `seq` nd_C__case_41 x1 x3 x4 s0 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C_onLast x1 l s cd cs)
    (nd_C_onLast x1 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C_onLast x1 z
    s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C_onLast x1 e s cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Names.onLast"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Names.onLast" (showCons x2))

d_C_isCurryModule :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_isCurryModule cd cs = Curry_Prelude.d_OP_dot (Curry_List.d_C_isPrefixOf
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) (Curry_Prelude.toCurryString "Curry_")) (Curry_Prelude.d_OP_dot
  Curry_List.d_C_last d_C_splitModuleIdentifiers cd cs) cd cs

d_C_isHaskellModule :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_isHaskellModule cd cs = Curry_Prelude.d_OP_dot Curry_Prelude.d_C_not
  (d_C_isCurryModule cd cs) cd cs

d_C_mkChoiceName :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_mkChoiceName cd cs = d_C_withQName Curry_Prelude.d_C_id
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "Choice_"))

d_C_mkChoicesName :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_mkChoicesName cd cs = d_C_withQName Curry_Prelude.d_C_id
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "Choices_"))

d_C_mkFailName :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_mkFailName cd cs = d_C_withQName Curry_Prelude.d_C_id
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "Fail_"))

d_C_mkGuardName :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_mkGuardName cd cs = d_C_withQName Curry_Prelude.d_C_id
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "Guard_"))

d_C_mkFoConsName :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_mkFoConsName cd cs = Curry_Prelude.d_C_id

d_C_mkHoConsName :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_mkHoConsName cd cs = d_C_withQName Curry_Prelude.d_C_id
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "HO_"))

d_C_unRenamePrefixedFunc :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_unRenamePrefixedFunc cd cs = Curry_Prelude.d_OP_dot (d_C_unRenameQName cd
  cs) d_C_dropFuncPrefix cd cs

d_C_dropFuncPrefix :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_dropFuncPrefix x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> d_C__case_40 x2 x3 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C_dropFuncPrefix l cd
    cs) (d_C_dropFuncPrefix r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_C_dropFuncPrefix z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C_dropFuncPrefix e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Names.dropFuncPrefix" [show x1] info)
  _ -> failCons cd (consFail "Names.dropFuncPrefix" (showCons x1))

d_C_funcPrefix :: Curry_Prelude.C_Bool -> Curry_Classification.C_NDClass
  -> Curry_Classification.C_FuncHOClass -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_funcPrefix x1 x2 x3 cd cs = case x2 of
  Curry_Classification.C_D -> d_C__case_31 x1 x3 cd cs
  Curry_Classification.C_ND -> Curry_Prelude.toCurryString "nd_"
  Curry_Classification.Choice_C_NDClass d i l r -> narrow d i (d_C_funcPrefix x1
    l x3 cd cs) (d_C_funcPrefix x1 r x3 cd cs)
  Curry_Classification.Choices_C_NDClass d i xs -> narrows cs d i (\z ->
    d_C_funcPrefix x1 z x3 cd cs) xs
  Curry_Classification.Guard_C_NDClass d c e -> guardCons d c (d_C_funcPrefix x1
    e x3 cd $! addCs c cs)
  Curry_Classification.Fail_C_NDClass d info -> failCons d (traceFail
    "Names.funcPrefix" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "Names.funcPrefix" (showCons x2))

d_C_consPrefix :: Curry_Prelude.C_Bool -> Curry_Classification.C_ConsHOClass
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_consPrefix x1 x2 cd cs = case x2 of
  Curry_Classification.C_ConsFO -> Curry_Prelude.OP_List
  Curry_Classification.C_ConsHO -> d_C__case_29 x1 cd cs
  Curry_Classification.Choice_C_ConsHOClass d i l r -> narrow d i
    (d_C_consPrefix x1 l cd cs) (d_C_consPrefix x1 r cd cs)
  Curry_Classification.Choices_C_ConsHOClass d i xs -> narrows cs d i (\z ->
    d_C_consPrefix x1 z cd cs) xs
  Curry_Classification.Guard_C_ConsHOClass d c e -> guardCons d c
    (d_C_consPrefix x1 e cd $! addCs c cs)
  Curry_Classification.Fail_C_ConsHOClass d info -> failCons d (traceFail
    "Names.consPrefix" [show x1, show x2] info)
  _ -> failCons cd (consFail "Names.consPrefix" (showCons x2))

d_C_renameQNameTrace :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_renameQNameTrace x1 cd cs = d_C__case_28 x1 (Curry_Prelude.d_C_apply
  (d_C_isCurryModule cd cs) (Curry_Prelude.d_C_fst x1 cd cs) cd cs) cd cs

d_C_renameQName :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_renameQName cd cs = d_C_withQName (d_C_renameModule cd cs) d_C_genRename

d_C_unRenameQName :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_unRenameQName cd cs = d_C_withQName (d_C_unRenameModule cd cs)
  d_C_unGenRename

d_C_externalFunc :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_externalFunc cd cs = d_C_withQName Curry_Prelude.d_C_id
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "external_"))

d_C_fromExternalFunc :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_fromExternalFunc cd cs = d_C_withQName Curry_Prelude.d_C_id (d_C_dropPrefix
  (Curry_Prelude.toCurryString "external_"))

d_C_mkGlobalName :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_mkGlobalName cd cs = d_C_withQName Curry_Prelude.d_C_id
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "global_"))

d_C_fromGlobalName :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_fromGlobalName cd cs = d_C_withQName Curry_Prelude.d_C_id (d_C_dropPrefix
  (Curry_Prelude.toCurryString "global_"))

d_C_genRename :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_genRename x1 cd cs = d_C__case_27 x1
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) x1 (Curry_Prelude.toCurryString "[]") cd cs) cd cs

d_C_unGenRename :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_unGenRename x1 cd cs = d_C__case_22 x1
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) x1 (Curry_Prelude.toCurryString "OP_List") cd cs) cd cs

d_C_mkTuple :: Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_mkTuple x1 cd cs = Curry_Prelude.OP_Cons (Curry_Prelude.C_Char '('#)
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.d_C_replicate
  (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
  x1 (Curry_Prelude.C_Int (1)) cd cs) (Curry_Prelude.C_Char ','#) cd cs)
  (Curry_Prelude.toCurryString ")") cd cs)

d_C_parseNat :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_Int
d_C_parseNat x1 cd cs = d_OP_parseNat_dot_parse_tick_dot_112
  (Curry_Prelude.C_Int (0)) x1 cd cs

d_OP_parseNat_dot_parse_tick_dot_112 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Int
d_OP_parseNat_dot_parse_tick_dot_112 x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_List -> x1
  Curry_Prelude.OP_Cons x3 x4 -> d_OP_parseNat_dot_parse_tick_dot_112
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    (Curry_Prelude.d_OP_uscore_impl_hash_star_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    (Curry_Prelude.C_Int (10)) x1 cd cs) (Curry_Prelude.d_C_ord x3 cd cs) cd cs)
    (Curry_Prelude.d_C_ord (Curry_Prelude.C_Char '0'#) cd cs) cd cs) x4 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_parseNat_dot_parse_tick_dot_112 x1 l cd cs)
    (d_OP_parseNat_dot_parse_tick_dot_112 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_parseNat_dot_parse_tick_dot_112 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_parseNat_dot_parse_tick_dot_112 x1 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Names.parseNat.parse'.112" [show x1, show x2] info)
  _ -> failCons cd (consFail "Names.parseNat.parse'.112" (showCons x2))

d_C_withQName :: (Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> (Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_withQName x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Tuple2 x4 x5 -> Curry_Prelude.OP_Tuple2
    (Curry_Prelude.d_C_apply x1 x4 cd cs) (Curry_Prelude.d_C_apply x2 x5 cd cs)
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C_withQName x1 x2 l cd
    cs) (d_C_withQName x1 x2 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C_withQName
    x1 x2 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C_withQName x1 x2 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail "Names.withQName"
    [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "Names.withQName" (showCons x3))

nd_C_withQName :: Func (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Func (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
nd_C_withQName x1 x2 x3 s cd cs = case x3 of
  Curry_Prelude.OP_Tuple2 x4 x5 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` Curry_Prelude.OP_Tuple2 (Curry_Prelude.nd_C_apply x1
    x4 s0 cd cs) (Curry_Prelude.nd_C_apply x2 x5 s1 cd cs)))
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (nd_C_withQName x1 x2 l s
    cd cs) (nd_C_withQName x1 x2 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> nd_C_withQName
    x1 x2 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (nd_C_withQName x1 x2 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail "Names.withQName"
    [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "Names.withQName" (showCons x3))

d_C_dropPrefix :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_dropPrefix x1 x2 cd cs = let x3 = Curry_Prelude.d_C_length x1 cd cs
  in d_C__case_14 x1 x2 x3
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) (Curry_Prelude.d_C_take x3 x2 cd cs) x1 cd cs) cd cs

d_C_isInfixName :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_isInfixName cd cs = Curry_Prelude.d_C_all (Curry_Prelude.d_C_flip
  (Curry_Prelude.d_C_elem
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs)) (Curry_Prelude.toCurryString "?!#$%^&*+=-<>.:/\\|")) cd cs

d_C_opRenaming :: Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Char (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C_opRenaming cd cs = Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.C_Char '_'#) (Curry_Prelude.toCurryString "uscore"))
  (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Char '~'#)
  (Curry_Prelude.toCurryString "tilde")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Char '!'#)
  (Curry_Prelude.toCurryString "bang")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Char '@'#)
  (Curry_Prelude.toCurryString "at")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Char '#'#)
  (Curry_Prelude.toCurryString "hash")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Char '$'#)
  (Curry_Prelude.toCurryString "dollar")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Char '%'#)
  (Curry_Prelude.toCurryString "percent")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Char '^'#)
  (Curry_Prelude.toCurryString "caret")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Char '&'#)
  (Curry_Prelude.toCurryString "amp")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Char '*'#)
  (Curry_Prelude.toCurryString "star")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Char '+'#)
  (Curry_Prelude.toCurryString "plus")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Char '-'#)
  (Curry_Prelude.toCurryString "minus")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Char '='#)
  (Curry_Prelude.toCurryString "eq")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Char '<'#)
  (Curry_Prelude.toCurryString "lt")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Char '>'#)
  (Curry_Prelude.toCurryString "gt")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Char '?'#)
  (Curry_Prelude.toCurryString "qmark")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Char '.'#)
  (Curry_Prelude.toCurryString "dot")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Char '/'#)
  (Curry_Prelude.toCurryString "slash")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Char '|'#)
  (Curry_Prelude.toCurryString "bar")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Char '\\'#)
  (Curry_Prelude.toCurryString "backslash")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Char ':'#)
  (Curry_Prelude.toCurryString "colon")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Char '('#)
  (Curry_Prelude.toCurryString "lparen")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Char ')'#)
  (Curry_Prelude.toCurryString "rparen")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Char '['#)
  (Curry_Prelude.toCurryString "lbracket")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Char ']'#)
  (Curry_Prelude.toCurryString "rbracket")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Char ','#)
  (Curry_Prelude.toCurryString "comma")) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Char '\''#)
  (Curry_Prelude.toCurryString "tick"))
  Curry_Prelude.OP_List))))))))))))))))))))))))))

d_C_unRenameOp :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_unRenameOp cd cs = Curry_Prelude.d_OP_dot (Curry_Prelude.d_C_concatMap
  d_OP_unRenameOp_dot_toOpChar_dot_127 cd cs) (d_C_splitAll
  (Curry_Prelude.d_C_flip (acceptCs id
  Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char)
  (Curry_Prelude.C_Char '_'#))) cd cs

d_OP_unRenameOp_dot_swap_dot_127 :: forall t1 t0 . (Curry_Prelude.Curry t0
  , Curry_Prelude.Curry t1) => Curry_Prelude.OP_Tuple2 t0 t1 -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 t1 t0
d_OP_unRenameOp_dot_swap_dot_127 x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> Curry_Prelude.OP_Tuple2 x3 x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_unRenameOp_dot_swap_dot_127 l cd cs) (d_OP_unRenameOp_dot_swap_dot_127
    r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_unRenameOp_dot_swap_dot_127 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_unRenameOp_dot_swap_dot_127 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Names.unRenameOp.swap.127" [show x1] info)
  _ -> failCons cd (consFail "Names.unRenameOp.swap.127" (showCons x1))

d_OP_unRenameOp_dot_toOpChar_dot_127 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_unRenameOp_dot_toOpChar_dot_127 x1 cd cs = d_C__case_12 x1
  (Curry_Prelude.d_C_lookup
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs) x1 (Curry_Prelude.d_C_map d_OP_unRenameOp_dot_swap_dot_127
  (d_C_opRenaming cd cs) cd cs) cd cs) cd cs

d_C_splitAll :: forall t0 . (Curry_Prelude.Curry t0) => (t0 -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List t0 -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List t0)
d_C_splitAll x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x3 x4 -> let x5 = Curry_Prelude.d_C_apply
                                       (Curry_Prelude.d_C_break x1 cd cs) x2 cd
                                       cs
                                     x6 = d_OP_splitAll_dot_uscore_hash_selFP11_hash_f
                                       x5 cd cs
                                     x7 = d_OP_splitAll_dot_uscore_hash_selFP12_hash_s
                                       x5 cd cs
    in Curry_Prelude.OP_Cons x6 (d_C_splitAll x1 (Curry_Prelude.d_C_drop
    (Curry_Prelude.C_Int (1)) x7 cd cs) cd cs)
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_splitAll x1 l cd cs)
    (d_C_splitAll x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_splitAll x1
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_splitAll x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Names.splitAll"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Names.splitAll" (showCons x2))

nd_C_splitAll :: forall t0 . (Curry_Prelude.Curry t0) => Func t0
  Curry_Prelude.C_Bool -> Curry_Prelude.OP_List t0 -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List t0)
nd_C_splitAll x1 x2 s cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x3 x4 -> let s4 = s
    in s4 `seq` (let s2 = leftSupply s4
                     s3 = rightSupply s4
    in s2 `seq` (s3 `seq` (let x5 = let s1 = leftSupply s2
                                        s0 = rightSupply s2
                                 in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply
                                 (Curry_Prelude.nd_C_break x1 s0 cd cs) x2 s1 cd
                                 cs)
                               x6 = d_OP_splitAll_dot_uscore_hash_selFP11_hash_f
                                 x5 cd cs
                               x7 = d_OP_splitAll_dot_uscore_hash_selFP12_hash_s
                                 x5 cd cs
    in Curry_Prelude.OP_Cons x6 (nd_C_splitAll x1 (Curry_Prelude.d_C_drop
    (Curry_Prelude.C_Int (1)) x7 cd cs) s3 cd cs))))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C_splitAll x1 l s cd
    cs) (nd_C_splitAll x1 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C_splitAll x1
    z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C_splitAll x1 e s cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Names.splitAll"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Names.splitAll" (showCons x2))

d_OP_splitAll_dot_uscore_hash_selFP11_hash_f :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List t0)
  (Curry_Prelude.OP_List t0) -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_OP_splitAll_dot_uscore_hash_selFP11_hash_f x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitAll_dot_uscore_hash_selFP11_hash_f l cd cs)
    (d_OP_splitAll_dot_uscore_hash_selFP11_hash_f r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitAll_dot_uscore_hash_selFP11_hash_f z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_splitAll_dot_uscore_hash_selFP11_hash_f e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Names.splitAll._#selFP11#f" [show x1] info)
  _ -> failCons cd (consFail "Names.splitAll._#selFP11#f" (showCons x1))

d_OP_splitAll_dot_uscore_hash_selFP12_hash_s :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List t0)
  (Curry_Prelude.OP_List t0) -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_OP_splitAll_dot_uscore_hash_selFP12_hash_s x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitAll_dot_uscore_hash_selFP12_hash_s l cd cs)
    (d_OP_splitAll_dot_uscore_hash_selFP12_hash_s r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitAll_dot_uscore_hash_selFP12_hash_s z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_splitAll_dot_uscore_hash_selFP12_hash_s e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Names.splitAll._#selFP12#s" [show x1] info)
  _ -> failCons cd (consFail "Names.splitAll._#selFP12#s" (showCons x1))

d_C_replaceNonIdChars :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_replaceNonIdChars x1 x2 x3 cd cs = let x4 = d_C_spanAll
                                             Curry_Char.d_C_isAlphaNum x3 cd cs
  in d_C__case_11 x2 x1 x4 cd cs

d_OP_replaceNonIdChars_dot_showOpChar_dot_145 :: Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_replaceNonIdChars_dot_showOpChar_dot_145 x1 cd cs = d_C__case_9 x1
  (Curry_Prelude.d_C_lookup
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) x1 (d_C_opRenaming cd cs) cd cs) cd cs

d_OP_replaceNonIdChars_dot_isIdentChar_dot_145 :: Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_OP_replaceNonIdChars_dot_isIdentChar_dot_145 x1 cd cs =
  Curry_Prelude.d_OP_bar_bar (Curry_Char.d_C_isAlphaNum x1 cd cs)
  (Curry_Prelude.d_OP_bar_bar
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
  x1 (Curry_Prelude.C_Char '_'#) cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
  x1 (Curry_Prelude.C_Char '\''#) cd cs) cd cs) cd cs

d_C_spanAll :: forall t0 . (Curry_Prelude.Curry t0) => (t0 -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List t0 -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List t0)
d_C_spanAll x1 x2 cd cs = let x3 = Curry_Prelude.d_C_span x1 x2 cd cs
                              x4 = d_OP_spanAll_dot_uscore_hash_selFP14_hash_pfx
                                x3 cd cs
                              x5 = d_OP_spanAll_dot_uscore_hash_selFP15_hash_rest
                                x3 cd cs
  in Curry_Prelude.d_OP_dollar (d_C__case_8 x4 (Curry_Prelude.d_C_null x4 cd cs)
  cd cs) (d_C__case_7 x1 x5 cd cs) cd cs

nd_C_spanAll :: forall t0 . (Curry_Prelude.Curry t0) => Func t0
  Curry_Prelude.C_Bool -> Curry_Prelude.OP_List t0 -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List t0)
nd_C_spanAll x1 x2 s cd cs = let s4 = s
  in s4 `seq` (let s0 = leftSupply s4
                   s3 = rightSupply s4
  in s0 `seq` (s3 `seq` (let x3 = Curry_Prelude.nd_C_span x1 x2 s0 cd cs
                             x4 = d_OP_spanAll_dot_uscore_hash_selFP14_hash_pfx
                               x3 cd cs
                             x5 = d_OP_spanAll_dot_uscore_hash_selFP15_hash_rest
                               x3 cd cs
  in let s2 = leftSupply s3
         s1 = rightSupply s3
  in s2 `seq` (s1 `seq` Curry_Prelude.nd_OP_dollar (wrapDX id (d_C__case_8 x4
  (Curry_Prelude.d_C_null x4 cd cs) cd cs)) (nd_C__case_7 x1 x5 s1 cd cs) s2 cd
  cs))))

d_OP_spanAll_dot_uscore_hash_selFP14_hash_pfx :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List t0)
  (Curry_Prelude.OP_List t0) -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_OP_spanAll_dot_uscore_hash_selFP14_hash_pfx x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_spanAll_dot_uscore_hash_selFP14_hash_pfx l cd cs)
    (d_OP_spanAll_dot_uscore_hash_selFP14_hash_pfx r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_spanAll_dot_uscore_hash_selFP14_hash_pfx z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_spanAll_dot_uscore_hash_selFP14_hash_pfx e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Names.spanAll._#selFP14#pfx" [show x1] info)
  _ -> failCons cd (consFail "Names.spanAll._#selFP14#pfx" (showCons x1))

d_OP_spanAll_dot_uscore_hash_selFP15_hash_rest :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List t0)
  (Curry_Prelude.OP_List t0) -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_OP_spanAll_dot_uscore_hash_selFP15_hash_rest x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_spanAll_dot_uscore_hash_selFP15_hash_rest l cd cs)
    (d_OP_spanAll_dot_uscore_hash_selFP15_hash_rest r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_spanAll_dot_uscore_hash_selFP15_hash_rest z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_spanAll_dot_uscore_hash_selFP15_hash_rest e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Names.spanAll._#selFP15#rest" [show x1] info)
  _ -> failCons cd (consFail "Names.spanAll._#selFP15#rest" (showCons x1))

d_C_splitModuleFileName :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_splitModuleFileName x1 x2 cd cs = let x3 = d_C_splitModuleIdentifiers x1 cd
                                            cs
  in d_C__case_6 x2 x3 cd cs

d_OP_splitModuleFileName_dot_uscore_hash_selFP20_hash_base :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitModuleFileName_dot_uscore_hash_selFP20_hash_base x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitModuleFileName_dot_uscore_hash_selFP20_hash_base l cd cs)
    (d_OP_splitModuleFileName_dot_uscore_hash_selFP20_hash_base r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitModuleFileName_dot_uscore_hash_selFP20_hash_base z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_splitModuleFileName_dot_uscore_hash_selFP20_hash_base e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Names.splitModuleFileName._#selFP20#base" [show x1] info)
  _ -> failCons cd (consFail "Names.splitModuleFileName._#selFP20#base"
    (showCons x1))

d_OP_splitModuleFileName_dot_uscore_hash_selFP21_hash_ext :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitModuleFileName_dot_uscore_hash_selFP21_hash_ext x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitModuleFileName_dot_uscore_hash_selFP21_hash_ext l cd cs)
    (d_OP_splitModuleFileName_dot_uscore_hash_selFP21_hash_ext r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitModuleFileName_dot_uscore_hash_selFP21_hash_ext z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_splitModuleFileName_dot_uscore_hash_selFP21_hash_ext e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Names.splitModuleFileName._#selFP21#ext" [show x1] info)
  _ -> failCons cd (consFail "Names.splitModuleFileName._#selFP21#ext" (showCons
    x1))

d_OP_splitModuleFileName_dot_uscore_hash_selFP18_hash_pre :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_splitModuleFileName_dot_uscore_hash_selFP18_hash_pre x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitModuleFileName_dot_uscore_hash_selFP18_hash_pre l cd cs)
    (d_OP_splitModuleFileName_dot_uscore_hash_selFP18_hash_pre r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitModuleFileName_dot_uscore_hash_selFP18_hash_pre z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_splitModuleFileName_dot_uscore_hash_selFP18_hash_pre e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Names.splitModuleFileName._#selFP18#pre" [show x1] info)
  _ -> failCons cd (consFail "Names.splitModuleFileName._#selFP18#pre" (showCons
    x1))

d_OP_splitModuleFileName_dot_uscore_hash_selFP19_hash_suf :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_splitModuleFileName_dot_uscore_hash_selFP19_hash_suf x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitModuleFileName_dot_uscore_hash_selFP19_hash_suf l cd cs)
    (d_OP_splitModuleFileName_dot_uscore_hash_selFP19_hash_suf r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitModuleFileName_dot_uscore_hash_selFP19_hash_suf z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_splitModuleFileName_dot_uscore_hash_selFP19_hash_suf e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Names.splitModuleFileName._#selFP19#suf" [show x1] info)
  _ -> failCons cd (consFail "Names.splitModuleFileName._#selFP19#suf" (showCons
    x1))

d_C_moduleNameToPath :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_moduleNameToPath cd cs = Curry_Prelude.d_OP_dot (Curry_Prelude.d_C_foldr1
  (Curry_FilePath.d_OP_lt_slash_gt cd cs)) d_C_splitModuleIdentifiers cd cs

d_C_splitModuleIdentifiers :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_splitModuleIdentifiers x1 cd cs = let x2 = Curry_Prelude.d_C_apply
                                            (Curry_Prelude.d_C_break
                                            (Curry_Prelude.d_C_flip (acceptCs id
                                            Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char)
                                            (Curry_Prelude.C_Char '.'#)) cd cs)
                                            x1 cd cs
                                          x3 = d_OP_splitModuleIdentifiers_dot_uscore_hash_selFP23_hash_pref
                                            x2 cd cs
                                          x4 = d_OP_splitModuleIdentifiers_dot_uscore_hash_selFP24_hash_rest
                                            x2 cd cs
  in Curry_Prelude.OP_Cons x3 (d_C__case_0 x4 cd cs)

d_OP_splitModuleIdentifiers_dot_uscore_hash_selFP23_hash_pref :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitModuleIdentifiers_dot_uscore_hash_selFP23_hash_pref x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitModuleIdentifiers_dot_uscore_hash_selFP23_hash_pref l cd cs)
    (d_OP_splitModuleIdentifiers_dot_uscore_hash_selFP23_hash_pref r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitModuleIdentifiers_dot_uscore_hash_selFP23_hash_pref z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_splitModuleIdentifiers_dot_uscore_hash_selFP23_hash_pref e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Names.splitModuleIdentifiers._#selFP23#pref" [show x1] info)
  _ -> failCons cd (consFail "Names.splitModuleIdentifiers._#selFP23#pref"
    (showCons x1))

d_OP_splitModuleIdentifiers_dot_uscore_hash_selFP24_hash_rest :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitModuleIdentifiers_dot_uscore_hash_selFP24_hash_rest x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitModuleIdentifiers_dot_uscore_hash_selFP24_hash_rest l cd cs)
    (d_OP_splitModuleIdentifiers_dot_uscore_hash_selFP24_hash_rest r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitModuleIdentifiers_dot_uscore_hash_selFP24_hash_rest z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_splitModuleIdentifiers_dot_uscore_hash_selFP24_hash_rest e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Names.splitModuleIdentifiers._#selFP24#rest" [show x1] info)
  _ -> failCons cd (consFail "Names.splitModuleIdentifiers._#selFP24#rest"
    (showCons x1))

d_C_joinModuleIdentifiers :: Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_joinModuleIdentifiers cd cs = Curry_Prelude.d_C_foldr1 (acceptCs id
  d_OP_joinModuleIdentifiers_dot_combine_dot_191)

d_OP_joinModuleIdentifiers_dot_combine_dot_191 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_joinModuleIdentifiers_dot_combine_dot_191 x1 x2 cd cs =
  Curry_Prelude.d_OP_plus_plus x1 (Curry_Prelude.OP_Cons (Curry_Prelude.C_Char
  '.'#) x2) cd cs

d_C_moduleToFileName :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_moduleToFileName cd cs = Curry_Prelude.d_OP_dot
  (d_C_joinModuleIdentifiersToFileName cd cs) d_C_splitModuleIdentifiers cd cs

d_C_joinModuleIdentifiersToFileName :: Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_joinModuleIdentifiersToFileName cd cs = Curry_Prelude.d_C_foldr1 (acceptCs
  id d_OP_joinModuleIdentifiersToFileName_dot_combine_dot_197)

d_OP_joinModuleIdentifiersToFileName_dot_combine_dot_197 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_joinModuleIdentifiersToFileName_dot_combine_dot_197 x1 x2 cd cs =
  Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_FilePath.d_OP_lt_slash_gt cd cs) x1 cd cs) x2 cd cs

d_C__case_0 :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_0 x4 cd cs = case x4 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x5 x6 -> d_C_splitModuleIdentifiers x6 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_0 l cd cs)
    (d_C__case_0 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_0 z cd
    cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_0 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Names._case_0"
    [show x4] info)
  _ -> failCons cd (consFail "Names._case_0" (showCons x4))

d_C__case_6 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_6 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_5 x3 x2 x5 cd cs
  Curry_Prelude.OP_List -> let x16 = Curry_FilePath.d_C_splitExtension x2 cd cs
                               x17 = d_OP_splitModuleFileName_dot_uscore_hash_selFP20_hash_base
                                 x16 cd cs
                               x18 = d_OP_splitModuleFileName_dot_uscore_hash_selFP21_hash_ext
                                 x16 cd cs
                               x19 = Curry_FilePath.d_C_splitDirectories x17 cd
                                 cs
                               x20 = Curry_Prelude.d_C_splitAt
                                 (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
                                 (Curry_Prelude.d_C_length x19 cd cs)
                                 (Curry_Prelude.d_C_length x3 cd cs) cd cs) x19
                                 cd cs
                               x21 = d_OP_splitModuleFileName_dot_uscore_hash_selFP18_hash_pre
                                 x20 cd cs
                               x22 = d_OP_splitModuleFileName_dot_uscore_hash_selFP19_hash_suf
                                 x20 cd cs
                               x23 = d_C__case_2 x21 (Curry_Prelude.d_C_null x21
                                 cd cs) cd cs
    in Curry_Prelude.OP_Tuple2 x23 (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Curry_FilePath.d_OP_lt_dot_gt cd cs)
    (Curry_FilePath.d_C_joinPath x22 cd cs) cd cs) x18 cd cs)
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_6 x2 l cd cs)
    (d_C__case_6 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_6 x2 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_6 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Names._case_6"
    [show x2, show x3] info)
  _ -> failCons cd (consFail "Names._case_6" (showCons x3))

d_C__case_2 :: Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_2 x21 x22 cd cs = case x22 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_List
  Curry_Prelude.C_False -> d_C__case_1 x21 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_2 x21 l cd cs)
    (d_C__case_2 x21 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_2 x21 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_2 x21 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_2"
    [show x21, show x22] info)
  _ -> failCons cd (consFail "Names._case_2" (showCons x22))

d_C__case_1 :: Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_1 x21 x22 cd cs = case x22 of
  Curry_Prelude.C_True -> Curry_FilePath.d_C_addTrailingPathSeparator
    (Curry_FilePath.d_C_joinPath x21 cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_1 x21 l cd cs)
    (d_C__case_1 x21 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_1 x21 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_1 x21 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_1"
    [show x21, show x22] info)
  _ -> failCons cd (consFail "Names._case_1" (showCons x22))

d_C__case_5 :: Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_5 x3 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_List -> Curry_FilePath.d_C_splitFileName x2 cd cs
  Curry_Prelude.OP_Cons x6 x7 -> let x8 = Curry_FilePath.d_C_splitExtension x2
                                       cd cs
                                     x9 = d_OP_splitModuleFileName_dot_uscore_hash_selFP20_hash_base
                                       x8 cd cs
                                     x10 = d_OP_splitModuleFileName_dot_uscore_hash_selFP21_hash_ext
                                       x8 cd cs
                                     x11 = Curry_FilePath.d_C_splitDirectories
                                       x9 cd cs
                                     x12 = Curry_Prelude.d_C_splitAt
                                       (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
                                       (Curry_Prelude.d_C_length x11 cd cs)
                                       (Curry_Prelude.d_C_length x3 cd cs) cd
                                       cs) x11 cd cs
                                     x13 = d_OP_splitModuleFileName_dot_uscore_hash_selFP18_hash_pre
                                       x12 cd cs
                                     x14 = d_OP_splitModuleFileName_dot_uscore_hash_selFP19_hash_suf
                                       x12 cd cs
                                     x15 = d_C__case_4 x13
                                       (Curry_Prelude.d_C_null x13 cd cs) cd cs
    in Curry_Prelude.OP_Tuple2 x15 (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Curry_FilePath.d_OP_lt_dot_gt cd cs)
    (Curry_FilePath.d_C_joinPath x14 cd cs) cd cs) x10 cd cs)
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_5 x3 x2 l cd cs)
    (d_C__case_5 x3 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_5 x3
    x2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_5 x3 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Names._case_5"
    [show x3, show x2, show x5] info)
  _ -> failCons cd (consFail "Names._case_5" (showCons x5))

d_C__case_4 :: Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_4 x13 x14 cd cs = case x14 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_List
  Curry_Prelude.C_False -> d_C__case_3 x13 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_4 x13 l cd cs)
    (d_C__case_4 x13 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_4 x13 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_4 x13 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_4"
    [show x13, show x14] info)
  _ -> failCons cd (consFail "Names._case_4" (showCons x14))

d_C__case_3 :: Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_3 x13 x14 cd cs = case x14 of
  Curry_Prelude.C_True -> Curry_FilePath.d_C_addTrailingPathSeparator
    (Curry_FilePath.d_C_joinPath x13 cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_3 x13 l cd cs)
    (d_C__case_3 x13 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_3 x13 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_3 x13 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_3"
    [show x13, show x14] info)
  _ -> failCons cd (consFail "Names._case_3" (showCons x14))

d_C__case_7 :: forall t0 . (Curry_Prelude.Curry t0) => (t0 -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool) -> Curry_Prelude.OP_List t0 -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List t0)
d_C__case_7 x1 x5 cd cs = case x5 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x6 x7 -> Curry_Prelude.OP_Cons (Curry_Prelude.OP_Cons x6
    Curry_Prelude.OP_List) (d_C_spanAll x1 x7 cd cs)
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_7 x1 l cd cs)
    (d_C__case_7 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_7 x1 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_7 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Names._case_7"
    [show x1, show x5] info)
  _ -> failCons cd (consFail "Names._case_7" (showCons x5))

nd_C__case_7 :: forall t0 . (Curry_Prelude.Curry t0) => Func t0
  Curry_Prelude.C_Bool -> Curry_Prelude.OP_List t0 -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List t0)
nd_C__case_7 x1 x5 s cd cs = case x5 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x6 x7 -> let s0 = s
    in s0 `seq` Curry_Prelude.OP_Cons (Curry_Prelude.OP_Cons x6
    Curry_Prelude.OP_List) (nd_C_spanAll x1 x7 s0 cd cs)
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_7 x1 l s cd cs)
    (nd_C__case_7 x1 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_7 x1
    z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C__case_7 x1 e s cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Names._case_7"
    [show x1, show x5] info)
  _ -> failCons cd (consFail "Names._case_7" (showCons x5))

d_C__case_8 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List t0
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List t0) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List t0)
d_C__case_8 x4 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_id
  Curry_Prelude.C_False -> acceptCs id (Curry_Prelude.OP_Cons x4)
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_8 x4 l cd cs)
    (d_C__case_8 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_8 x4 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_8 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_8"
    [show x4, show x5] info)
  _ -> failCons cd (consFail "Names._case_8" (showCons x5))

d_C__case_9 :: Curry_Prelude.C_Char -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_9 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_Just x2 -> x2
  Curry_Prelude.C_Nothing -> Curry_Prelude.OP_Cons x1 Curry_Prelude.OP_List
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (d_C__case_9 x1 l cd cs)
    (d_C__case_9 x1 r cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> d_C__case_9 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (d_C__case_9 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail "Names._case_9"
    [show x1, show x3] info)
  _ -> failCons cd (consFail "Names._case_9" (showCons x3))

d_C__case_11 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_11 x2 x1 x4 cd cs = case x4 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "Names.replaceNonIdChars: empty identifier") cd cs
  Curry_Prelude.OP_Cons x5 x6 -> d_C__case_10 x4 x2 x1 (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_and cd cs) (Curry_Prelude.d_C_map (Curry_Prelude.d_C_all
    d_OP_replaceNonIdChars_dot_isIdentChar_dot_145 cd cs) x4 cd cs) cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_11 x2 x1 l cd
    cs) (d_C__case_11 x2 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_11 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_11 x2 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Names._case_11"
    [show x2, show x1, show x4] info)
  _ -> failCons cd (consFail "Names._case_11" (showCons x4))

d_C__case_10 :: Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_10 x4 x2 x1 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_plus_plus x1
    (Curry_Prelude.d_C_concat x4 cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_OP_plus_plus x2
    (Curry_List.d_C_intercalate (Curry_Prelude.toCurryString "_")
    (Curry_Prelude.d_C_map (Curry_Prelude.d_C_concatMap
    d_OP_replaceNonIdChars_dot_showOpChar_dot_145 cd cs) x4 cd cs) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_10 x4 x2 x1 l cd
    cs) (d_C__case_10 x4 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_10 x4
    x2 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_10 x4 x2 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_10"
    [show x4, show x2, show x1, show x5] info)
  _ -> failCons cd (consFail "Names._case_10" (showCons x5))

d_C__case_12 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Maybe Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_12 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_Just x2 -> Curry_Prelude.OP_Cons x2 Curry_Prelude.OP_List
  Curry_Prelude.C_Nothing -> x1
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (d_C__case_12 x1 l cd cs)
    (d_C__case_12 x1 r cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> d_C__case_12 x1
    z cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (d_C__case_12 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail "Names._case_12"
    [show x1, show x3] info)
  _ -> failCons cd (consFail "Names._case_12" (showCons x3))

d_C__case_14 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_14 x1 x2 x3 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_drop x3 x2 cd cs
  Curry_Prelude.C_False -> d_C__case_13 x2 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_14 x1 x2 x3 l cd
    cs) (d_C__case_14 x1 x2 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_14 x1
    x2 x3 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_14 x1 x2 x3 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_14"
    [show x1, show x2, show x3, show x4] info)
  _ -> failCons cd (consFail "Names._case_14" (showCons x4))

d_C__case_13 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_13 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> x2
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_13 x2 l cd cs)
    (d_C__case_13 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_13 x2 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_13 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_13"
    [show x2, show x3] info)
  _ -> failCons cd (consFail "Names._case_13" (showCons x3))

d_C__case_22 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_22 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.toCurryString "[]"
  Curry_Prelude.C_False -> d_C__case_21 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) x1 (Curry_Prelude.toCurryString "OP_Cons") cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_22 x1 l cd cs)
    (d_C__case_22 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_22 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_22 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_22"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Names._case_22" (showCons x2))

d_C__case_21 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_21 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.toCurryString ":"
  Curry_Prelude.C_False -> d_C__case_20 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) x1 (Curry_Prelude.toCurryString "OP_Unit") cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_21 x1 l cd cs)
    (d_C__case_21 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_21 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_21 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_21"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Names._case_21" (showCons x2))

d_C__case_20 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_20 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.toCurryString "()"
  Curry_Prelude.C_False -> d_C__case_19 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) (Curry_Prelude.d_C_take (Curry_Prelude.C_Int (8)) x1 cd cs)
    (Curry_Prelude.toCurryString "OP_Tuple") cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_20 x1 l cd cs)
    (d_C__case_20 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_20 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_20 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_20"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Names._case_20" (showCons x2))

d_C__case_19 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_19 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_dollar d_C_mkTuple
    (Curry_Prelude.d_OP_dollar d_C_parseNat (Curry_Prelude.d_C_drop
    (Curry_Prelude.C_Int (8)) x1 cd cs) cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_18 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) (Curry_Prelude.d_C_take (Curry_Prelude.C_Int (2)) x1 cd cs)
    (Curry_Prelude.toCurryString "C_") cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_19 x1 l cd cs)
    (d_C__case_19 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_19 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_19 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_19"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Names._case_19" (showCons x2))

d_C__case_18 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_18 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_drop (Curry_Prelude.C_Int (2)) x1 cd
    cs
  Curry_Prelude.C_False -> d_C__case_17 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) (Curry_Prelude.d_C_take (Curry_Prelude.C_Int (3)) x1 cd cs)
    (Curry_Prelude.toCurryString "OP_") cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_18 x1 l cd cs)
    (d_C__case_18 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_18 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_18 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_18"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Names._case_18" (showCons x2))

d_C__case_17 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_17 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (d_C_unRenameOp cd cs)
    (Curry_Prelude.d_C_drop (Curry_Prelude.C_Int (3)) x1 cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_16 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) (Curry_Prelude.d_C_take (Curry_Prelude.C_Int (3)) x1 cd cs)
    (Curry_Prelude.toCurryString "HO_") cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_17 x1 l cd cs)
    (d_C__case_17 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_17 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_17 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_17"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Names._case_17" (showCons x2))

d_C__case_16 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_16 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> d_C_unGenRename (Curry_Prelude.d_C_drop
    (Curry_Prelude.C_Int (3)) x1 cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_15 x1 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_16 x1 l cd cs)
    (d_C__case_16 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_16 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_16 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_16"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Names._case_16" (showCons x2))

d_C__case_15 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_15 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> x1
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_15 x1 l cd cs)
    (d_C__case_15 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_15 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_15 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_15"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Names._case_15" (showCons x2))

d_C__case_27 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_27 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.toCurryString "OP_List"
  Curry_Prelude.C_False -> d_C__case_26 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) x1 (Curry_Prelude.toCurryString ":") cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_27 x1 l cd cs)
    (d_C__case_27 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_27 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_27 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_27"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Names._case_27" (showCons x2))

d_C__case_26 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_26 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.toCurryString "OP_Cons"
  Curry_Prelude.C_False -> d_C__case_25 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) x1 (Curry_Prelude.toCurryString "()") cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_26 x1 l cd cs)
    (d_C__case_26 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_26 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_26 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_26"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Names._case_26" (showCons x2))

d_C__case_25 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_25 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.toCurryString "OP_Unit"
  Curry_Prelude.C_False -> d_C__case_24 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    (Curry_Prelude.d_C_head x1 cd cs) (Curry_Prelude.C_Char '('#) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_25 x1 l cd cs)
    (d_C__case_25 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_25 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_25 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_25"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Names._case_25" (showCons x2))

d_C__case_24 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_24 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.toCurryString "OP_Tuple") (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Int
    cd cs)
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    (Curry_Prelude.d_C_length x1 cd cs) (Curry_Prelude.C_Int (1)) cd cs) cd cs)
    cd cs
  Curry_Prelude.C_False -> d_C__case_23 x1 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_24 x1 l cd cs)
    (d_C__case_24 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_24 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_24 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_24"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Names._case_24" (showCons x2))

d_C__case_23 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_23 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> d_C_replaceNonIdChars (Curry_Prelude.toCurryString
    "C_") (Curry_Prelude.toCurryString "OP_") x1 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_23 x1 l cd cs)
    (d_C__case_23 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_23 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_23 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_23"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Names._case_23" (showCons x2))

d_C__case_28 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C__case_28 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> d_C_withQName (d_C_addTrace cd cs)
    Curry_Prelude.d_C_id x1 cd cs
  Curry_Prelude.C_False -> x1
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_28 x1 l cd cs)
    (d_C__case_28 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_28 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_28 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_28"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Names._case_28" (showCons x2))

d_C__case_29 :: Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_29 x1 cd cs = case x1 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_List
  Curry_Prelude.C_False -> Curry_Prelude.toCurryString "HO_"
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_29 l cd cs)
    (d_C__case_29 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_29 z cd
    cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_29 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_29"
    [show x1] info)
  _ -> failCons cd (consFail "Names._case_29" (showCons x1))

d_C__case_31 :: Curry_Prelude.C_Bool -> Curry_Classification.C_FuncHOClass
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_31 x1 x3 cd cs = case x3 of
  Curry_Classification.C_FuncFO -> Curry_Prelude.toCurryString "d_"
  Curry_Classification.C_FuncHORes x4 -> Curry_Prelude.toCurryString "d_"
  Curry_Classification.C_FuncHO -> d_C__case_30 x1 cd cs
  Curry_Classification.Choice_C_FuncHOClass d i l r -> narrow d i (d_C__case_31
    x1 l cd cs) (d_C__case_31 x1 r cd cs)
  Curry_Classification.Choices_C_FuncHOClass d i xs -> narrows cs d i (\z ->
    d_C__case_31 x1 z cd cs) xs
  Curry_Classification.Guard_C_FuncHOClass d c e -> guardCons d c (d_C__case_31
    x1 e cd $! addCs c cs)
  Curry_Classification.Fail_C_FuncHOClass d info -> failCons d (traceFail
    "Names._case_31" [show x1, show x3] info)
  _ -> failCons cd (consFail "Names._case_31" (showCons x3))

d_C__case_30 :: Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_30 x1 cd cs = case x1 of
  Curry_Prelude.C_True -> Curry_Prelude.toCurryString "d_"
  Curry_Prelude.C_False -> Curry_Prelude.toCurryString "nd_"
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_30 l cd cs)
    (d_C__case_30 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_30 z cd
    cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_30 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_30"
    [show x1] info)
  _ -> failCons cd (consFail "Names._case_30" (showCons x1))

d_C__case_40 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_40 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_39 x4 x3 x2 x5
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x4 (Curry_Prelude.C_Char 'd'#) cd cs) cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Tuple2 x2 x3
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_40 x2 l cd cs)
    (d_C__case_40 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_40 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_40 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Names._case_40"
    [show x2, show x3] info)
  _ -> failCons cd (consFail "Names._case_40" (showCons x3))

d_C__case_39 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_39 x4 x3 x2 x5 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> d_C__case_38 x3 x2 x5 cd cs
  Curry_Prelude.C_False -> d_C__case_36 x4 x3 x2 x5
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x4 (Curry_Prelude.C_Char 'n'#) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_39 x4 x3 x2 x5 l
    cd cs) (d_C__case_39 x4 x3 x2 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_39 x4
    x3 x2 x5 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_39 x4 x3 x2 x5 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_39"
    [show x4, show x3, show x2, show x5, show x6] info)
  _ -> failCons cd (consFail "Names._case_39" (showCons x6))

d_C__case_36 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_36 x4 x3 x2 x5 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> d_C__case_35 x3 x2 x5 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.OP_Tuple2 x2 x3
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_36 x4 x3 x2 x5 l
    cd cs) (d_C__case_36 x4 x3 x2 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_36 x4
    x3 x2 x5 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_36 x4 x3 x2 x5 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_36"
    [show x4, show x3, show x2, show x5, show x6] info)
  _ -> failCons cd (consFail "Names._case_36" (showCons x6))

d_C__case_35 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C__case_35 x3 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_34 x8 x3 x2 x9
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x8 (Curry_Prelude.C_Char 'd'#) cd cs) cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Tuple2 x2 x3
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_35 x3 x2 l cd
    cs) (d_C__case_35 x3 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_35 x3
    x2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_35 x3 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Names._case_35"
    [show x3, show x2, show x5] info)
  _ -> failCons cd (consFail "Names._case_35" (showCons x5))

d_C__case_34 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_34 x8 x3 x2 x9 x10 cd cs = case x10 of
  Curry_Prelude.C_True -> d_C__case_33 x3 x2 x9 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.OP_Tuple2 x2 x3
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_34 x8 x3 x2 x9 l
    cd cs) (d_C__case_34 x8 x3 x2 x9 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_34 x8
    x3 x2 x9 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_34 x8 x3 x2 x9 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_34"
    [show x8, show x3, show x2, show x9, show x10] info)
  _ -> failCons cd (consFail "Names._case_34" (showCons x10))

d_C__case_33 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C__case_33 x3 x2 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_32 x10 x3 x2 x11
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x10 (Curry_Prelude.C_Char '_'#) cd cs) cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Tuple2 x2 x3
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_33 x3 x2 l cd
    cs) (d_C__case_33 x3 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_33 x3
    x2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_33 x3 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Names._case_33"
    [show x3, show x2, show x9] info)
  _ -> failCons cd (consFail "Names._case_33" (showCons x9))

d_C__case_32 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_32 x10 x3 x2 x11 x12 cd cs = case x12 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Tuple2 x2 x11
  Curry_Prelude.C_False -> Curry_Prelude.OP_Tuple2 x2 x3
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_32 x10 x3 x2 x11
    l cd cs) (d_C__case_32 x10 x3 x2 x11 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_32 x10
    x3 x2 x11 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_32 x10 x3 x2 x11
    e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_32"
    [show x10, show x3, show x2, show x11, show x12] info)
  _ -> failCons cd (consFail "Names._case_32" (showCons x12))

d_C__case_38 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C__case_38 x3 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_37 x6 x3 x2 x7
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x6 (Curry_Prelude.C_Char '_'#) cd cs) cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Tuple2 x2 x3
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_38 x3 x2 l cd
    cs) (d_C__case_38 x3 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_38 x3
    x2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_38 x3 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Names._case_38"
    [show x3, show x2, show x5] info)
  _ -> failCons cd (consFail "Names._case_38" (showCons x5))

d_C__case_37 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_37 x6 x3 x2 x7 x8 cd cs = case x8 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Tuple2 x2 x7
  Curry_Prelude.C_False -> Curry_Prelude.OP_Tuple2 x2 x3
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_37 x6 x3 x2 x7 l
    cd cs) (d_C__case_37 x6 x3 x2 x7 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_37 x6
    x3 x2 x7 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_37 x6 x3 x2 x7 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_37"
    [show x6, show x3, show x2, show x7, show x8] info)
  _ -> failCons cd (consFail "Names._case_37" (showCons x8))

d_C__case_41 :: forall t0 . (Curry_Prelude.Curry t0) => (t0 -> Cover
  -> ConstStore -> t0) -> t0 -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0
d_C__case_41 x1 x3 x4 cd cs = case x4 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply x1 x3
    cd cs) Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x5 x6 -> Curry_Prelude.OP_Cons x3 (d_C_onLast x1 x4 cd
    cs)
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_41 x1 x3 l cd
    cs) (d_C__case_41 x1 x3 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_41 x1
    x3 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_41 x1 x3 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Names._case_41"
    [show x1, show x3, show x4] info)
  _ -> failCons cd (consFail "Names._case_41" (showCons x4))

nd_C__case_41 :: forall t0 . (Curry_Prelude.Curry t0) => Func t0 t0 -> t0
  -> Curry_Prelude.OP_List t0 -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0
nd_C__case_41 x1 x3 x4 s cd cs = case x4 of
  Curry_Prelude.OP_List -> let s0 = s
    in s0 `seq` Curry_Prelude.OP_Cons (Curry_Prelude.nd_C_apply x1 x3 s0 cd cs)
    Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x5 x6 -> let s0 = s
    in s0 `seq` Curry_Prelude.OP_Cons x3 (nd_C_onLast x1 x4 s0 cd cs)
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_41 x1 x3 l s cd
    cs) (nd_C__case_41 x1 x3 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_41 x1
    x3 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C__case_41 x1 x3 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Names._case_41"
    [show x1, show x3, show x4] info)
  _ -> failCons cd (consFail "Names._case_41" (showCons x4))

d_C__case_42 :: Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_42 x1 cd cs = case x1 of
  Curry_Prelude.C_True -> d_C_renameModule cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_42 l cd cs)
    (d_C__case_42 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_42 z cd
    cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_42 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Names._case_42"
    [show x1] info)
  _ -> failCons cd (consFail "Names._case_42" (showCons x1))

