{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE Rank2Types #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module Curry_Pretty
  ( C_Doc (..)
  , C_Nesting (..)
  , C_Color (..)
  , C_Intensity (..)
  , C_BlinkMode (..)
  , C_FormatStm (..)
  , C_Tokens (..)
  , d_C_pPrint
  , nd_C_pPrint
  , d_C_empty
  , nd_C_empty
  , d_C_isEmpty
  , nd_C_isEmpty
  , d_C_text
  , nd_C_text
  , d_C_linesep
  , nd_C_linesep
  , d_C_hardline
  , nd_C_hardline
  , d_C_line
  , nd_C_line
  , d_C_linebreak
  , nd_C_linebreak
  , d_C_softline
  , nd_C_softline
  , d_C_softbreak
  , nd_C_softbreak
  , d_C_group
  , nd_C_group
  , d_C_nest
  , nd_C_nest
  , d_C_hang
  , nd_C_hang
  , d_C_align
  , nd_C_align
  , d_C_indent
  , nd_C_indent
  , d_C_combine
  , nd_C_combine
  , d_OP_lt_gt
  , nd_OP_lt_gt
  , d_OP_lt_plus_gt
  , nd_OP_lt_plus_gt
  , d_OP_dollar_dollar
  , nd_OP_dollar_dollar
  , d_OP_lt_dollar_plus_dollar_gt
  , nd_OP_lt_dollar_plus_dollar_gt
  , d_OP_lt_slash_gt
  , nd_OP_lt_slash_gt
  , d_OP_lt_dollar_dollar_gt
  , nd_OP_lt_dollar_dollar_gt
  , d_OP_lt_slash_slash_gt
  , nd_OP_lt_slash_slash_gt
  , d_OP_lt_dollar_bang_dollar_gt
  , nd_OP_lt_dollar_bang_dollar_gt
  , d_C_compose
  , nd_C_compose
  , d_C_hsep
  , nd_C_hsep
  , d_C_vsep
  , nd_C_vsep
  , d_C_vsepBlank
  , nd_C_vsepBlank
  , d_C_fillSep
  , nd_C_fillSep
  , d_C_sep
  , nd_C_sep
  , d_C_hcat
  , nd_C_hcat
  , d_C_vcat
  , nd_C_vcat
  , d_C_fillCat
  , nd_C_fillCat
  , d_C_cat
  , nd_C_cat
  , d_C_punctuate
  , nd_C_punctuate
  , d_C_encloseSep
  , nd_C_encloseSep
  , d_C_encloseSepSpaced
  , nd_C_encloseSepSpaced
  , d_C_hEncloseSep
  , nd_C_hEncloseSep
  , d_C_fillEncloseSep
  , nd_C_fillEncloseSep
  , d_C_fillEncloseSepSpaced
  , nd_C_fillEncloseSepSpaced
  , d_C_list
  , nd_C_list
  , d_C_listSpaced
  , nd_C_listSpaced
  , d_C_set
  , nd_C_set
  , d_C_setSpaced
  , nd_C_setSpaced
  , d_C_tupled
  , nd_C_tupled
  , d_C_tupledSpaced
  , nd_C_tupledSpaced
  , d_C_semiBraces
  , nd_C_semiBraces
  , d_C_semiBracesSpaced
  , nd_C_semiBracesSpaced
  , d_C_enclose
  , nd_C_enclose
  , d_C_squotes
  , nd_C_squotes
  , d_C_dquotes
  , nd_C_dquotes
  , d_C_bquotes
  , nd_C_bquotes
  , d_C_parens
  , nd_C_parens
  , d_C_parensIf
  , nd_C_parensIf
  , d_C_angles
  , nd_C_angles
  , d_C_braces
  , nd_C_braces
  , d_C_brackets
  , nd_C_brackets
  , d_C_char
  , nd_C_char
  , d_C_string
  , nd_C_string
  , d_C_int
  , nd_C_int
  , d_C_float
  , nd_C_float
  , d_C_lparen
  , nd_C_lparen
  , d_C_rparen
  , nd_C_rparen
  , d_C_langle
  , nd_C_langle
  , d_C_rangle
  , nd_C_rangle
  , d_C_lbrace
  , nd_C_lbrace
  , d_C_rbrace
  , nd_C_rbrace
  , d_C_lbracket
  , nd_C_lbracket
  , d_C_rbracket
  , nd_C_rbracket
  , d_C_squote
  , nd_C_squote
  , d_C_dquote
  , nd_C_dquote
  , d_C_semi
  , nd_C_semi
  , d_C_colon
  , nd_C_colon
  , d_C_comma
  , nd_C_comma
  , d_C_space
  , nd_C_space
  , d_C_dot
  , nd_C_dot
  , d_C_backslash
  , nd_C_backslash
  , d_C_equals
  , nd_C_equals
  , d_C_larrow
  , nd_C_larrow
  , d_C_rarrow
  , nd_C_rarrow
  , d_C_doubleArrow
  , nd_C_doubleArrow
  , d_C_doubleColon
  , nd_C_doubleColon
  , d_C_bar
  , nd_C_bar
  , d_C_at
  , nd_C_at
  , d_C_tilde
  , nd_C_tilde
  , d_C_fill
  , nd_C_fill
  , d_C_fillBreak
  , nd_C_fillBreak
  , d_C_bold
  , nd_C_bold
  , d_C_faint
  , nd_C_faint
  , d_C_blinkSlow
  , nd_C_blinkSlow
  , d_C_blinkRapid
  , nd_C_blinkRapid
  , d_C_italic
  , nd_C_italic
  , d_C_underline
  , nd_C_underline
  , d_C_crossout
  , nd_C_crossout
  , d_C_inverse
  , nd_C_inverse
  , d_C_black
  , nd_C_black
  , d_C_red
  , nd_C_red
  , d_C_green
  , nd_C_green
  , d_C_yellow
  , nd_C_yellow
  , d_C_blue
  , nd_C_blue
  , d_C_magenta
  , nd_C_magenta
  , d_C_cyan
  , nd_C_cyan
  , d_C_white
  , nd_C_white
  , d_C_bgBlack
  , nd_C_bgBlack
  , d_C_bgRed
  , nd_C_bgRed
  , d_C_bgGreen
  , nd_C_bgGreen
  , d_C_bgYellow
  , nd_C_bgYellow
  , d_C_bgBlue
  , nd_C_bgBlue
  , d_C_bgMagenta
  , nd_C_bgMagenta
  , d_C_bgCyan
  , nd_C_bgCyan
  , d_C_bgWhite
  , nd_C_bgWhite
  , d_C_pretty
  , nd_C_pretty )
  where

import Basics
import qualified Curry_Dequeue
import qualified Curry_Prelude


type C_Horizontal = Curry_Prelude.C_Bool

type C_Remaining = Curry_Prelude.C_Int

type C_Width = Curry_Prelude.C_Int

type C_Position = Curry_Prelude.C_Int

type C_StartPosition = Curry_Prelude.C_Int

type C_EndPosition = Curry_Prelude.C_Int

type C_Out = Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char

type C_OutGroupPrefix = Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char

type C_Margins = Curry_Prelude.OP_List Curry_Prelude.C_Int

type C_FormatHistory = Curry_Prelude.OP_List C_FormatStm

data C_Doc
  = C_Doc (C_Tokens -> Cover -> ConstStore -> C_Tokens)
  | HO_C_Doc (Func C_Tokens C_Tokens)
  | Choice_C_Doc Cover ID C_Doc C_Doc
  | Choices_C_Doc Cover ID [C_Doc]
  | Fail_C_Doc Cover FailInfo
  | Guard_C_Doc Cover Constraints C_Doc

instance Show C_Doc where
  showsPrec d (Choice_C_Doc cd i x y) = showsChoice d cd i x y
  showsPrec d (Choices_C_Doc cd i xs) = showsChoices d cd i xs
  showsPrec d (Guard_C_Doc cd c e) = showsGuard d cd c e
  showsPrec _ (Fail_C_Doc cd info) = showChar '!'
  showsPrec _ (C_Doc x1) = showString "(Doc" . (showChar ' ' . (shows x1 .
    showChar ')'))
  showsPrec _ (HO_C_Doc x1) = showString "(Doc" . (showChar ' ' . (shows x1 .
    showChar ')'))

instance Read C_Doc where
  readsPrec d s = readParen ((>) d 10) (\r -> [(C_Doc x1, r1) | (_, r0) <-
    readQualified "Pretty" "Doc" r, (x1, r1) <- readsPrec 11 r0]) s

instance NonDet C_Doc where
  choiceCons = Choice_C_Doc
  choicesCons = Choices_C_Doc
  failCons = Fail_C_Doc
  guardCons = Guard_C_Doc
  try (Choice_C_Doc cd i x y) = tryChoice cd i x y
  try (Choices_C_Doc cd i xs) = tryChoices cd i xs
  try (Fail_C_Doc cd info) = Fail cd info
  try (Guard_C_Doc cd c e) = Guard cd c e
  try x = Val x
  match f _ _ _ _ _ (Choice_C_Doc cd i x y) = f cd i x y
  match _ f _ _ _ _ (Choices_C_Doc cd i@(NarrowedID _ _) xs) = f cd i xs
  match _ _ f _ _ _ (Choices_C_Doc cd i@(FreeID _ _) xs) = f cd i xs
  match _ _ _ _ _ _ (Choices_C_Doc cd i _) = error
    ("Pretty.Doc.match: Choices with ChoiceID " ++ show i)
  match _ _ _ f _ _ (Fail_C_Doc cd info) = f cd info
  match _ _ _ _ f _ (Guard_C_Doc cd c e) = f cd c e
  match _ _ _ _ _ f x = f x

instance Generable C_Doc where
  generate s c = Choices_C_Doc c (freeID [1] s) [HO_C_Doc (generate (leftSupply
    s) c)]

instance NormalForm C_Doc where
  ($!!) cont (C_Doc x1) d cs = ($!!) (\y1 d cs -> cont (C_Doc y1) d cs) x1 d cs
  ($!!) cont (HO_C_Doc x1) d cs = ($!!) (\y1 d cs -> cont (HO_C_Doc y1) d cs) x1
    d cs
  ($!!) cont (Choice_C_Doc cd i x y) d cs = nfChoice cont cd i x y cd cs
  ($!!) cont (Choices_C_Doc cd i xs) d cs = nfChoices cont cd i xs d cs
  ($!!) cont (Guard_C_Doc cd c e) d cs = guardCons cd c (($!!) cont e d (addCs c
    cs))
  ($!!) _ (Fail_C_Doc cd info) _ _ = failCons cd info
  ($##) cont (C_Doc x1) d cs = ($##) (\y1 d cs -> cont (C_Doc y1) d cs) x1 d cs
  ($##) cont (HO_C_Doc x1) d cs = ($##) (\y1 d cs -> cont (HO_C_Doc y1) d cs) x1
    d cs
  ($##) cont (Choice_C_Doc cd i x y) d cs = gnfChoice cont cd i x y cd cs
  ($##) cont (Choices_C_Doc cd i xs) d cs = gnfChoices cont cd i xs d cs
  ($##) cont (Guard_C_Doc cd c e) d cs = guardCons cd c (($##) cont e d (addCs c
    cs))
  ($##) _ (Fail_C_Doc cd info) _ _ = failCons cd info
  showCons (C_Doc _) = "Pretty.Doc _"
  showCons (HO_C_Doc _) = "Pretty.Doc _"
  showCons x = error ("Pretty.Doc.showCons: no constructor: " ++ show x)
  searchNF search cont (C_Doc x1) = search (\y1 -> cont (C_Doc y1)) x1
  searchNF search cont (HO_C_Doc x1) = search (\y1 -> cont (HO_C_Doc y1)) x1
  searchNF _ _ x = error ("Pretty.Doc.searchNF: no constructor: " ++ show x)

instance Unifiable C_Doc where
  (=.=) (C_Doc x1) (C_Doc y1) d cs = (=:=) x1 y1 d cs
  (=.=) (HO_C_Doc x1) (HO_C_Doc y1) d cs = (=:=) x1 y1 d cs
  (=.=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  (=.<=) (C_Doc x1) (C_Doc y1) d cs = (=:<=) x1 y1 d cs
  (=.<=) (HO_C_Doc x1) (HO_C_Doc y1) d cs = (=:<=) x1 y1 d cs
  (=.<=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  bind cd i (C_Doc x3) = (i :=: ChooseN 0 1) : concat [bind cd (leftID i) x3]
  bind cd i (HO_C_Doc x3) = (i :=: ChooseN 0 1) : concat [bind cd (leftID i) x3]
  bind d i (Choice_C_Doc cd j x y) = [ConstraintChoice cd j (bind d i x) (bind d
    i y)]
  bind d i (Choices_C_Doc cd j@(FreeID _ _) xs) = bindOrNarrow d i cd j xs
  bind d i (Choices_C_Doc cd j@(NarrowedID _ _) xs) = [ConstraintChoices cd j
    (map (bind d i) xs)]
  bind _ _ (Choices_C_Doc cd i _) = error
    ("Pretty.Doc.bind: Choices with ChoiceID: " ++ show i)
  bind _ _ (Fail_C_Doc cd info) = [Unsolvable info]
  bind d i (Guard_C_Doc cd c e) = getConstrList c ++ bind d i e
  lazyBind cd i (C_Doc x3) = (i :=: ChooseN 0 1) : [leftID i :=: LazyBind
    (lazyBind cd (leftID i) x3)]
  lazyBind cd i (HO_C_Doc x3) = (i :=: ChooseN 0 1) : [leftID i :=: LazyBind
    (lazyBind cd (leftID i) x3)]
  lazyBind d i (Choice_C_Doc cd j x y) = [ConstraintChoice cd j (lazyBind d i x)
    (lazyBind d i y)]
  lazyBind d i (Choices_C_Doc cd j@(FreeID _ _) xs) = lazyBindOrNarrow d i cd j
    xs
  lazyBind d i (Choices_C_Doc cd j@(NarrowedID _ _) xs) = [ConstraintChoices cd
    j (map (lazyBind d i) xs)]
  lazyBind _ _ (Choices_C_Doc cd i _) = error
    ("Pretty.Doc.lazyBind: Choices with ChoiceID: " ++ show i)
  lazyBind _ _ (Fail_C_Doc cd info) = [Unsolvable info]
  lazyBind d i (Guard_C_Doc cd c e) = getConstrList c ++ [i :=: LazyBind
    (lazyBind d i e)]

instance Curry C_Doc where

data C_Nesting
  = C_Align
  | C_Inc Curry_Prelude.C_Int
  | Choice_C_Nesting Cover ID C_Nesting C_Nesting
  | Choices_C_Nesting Cover ID [C_Nesting]
  | Fail_C_Nesting Cover FailInfo
  | Guard_C_Nesting Cover Constraints C_Nesting

instance Show C_Nesting where
  showsPrec d (Choice_C_Nesting cd i x y) = showsChoice d cd i x y
  showsPrec d (Choices_C_Nesting cd i xs) = showsChoices d cd i xs
  showsPrec d (Guard_C_Nesting cd c e) = showsGuard d cd c e
  showsPrec _ (Fail_C_Nesting cd info) = showChar '!'
  showsPrec _ C_Align = showString "Align"
  showsPrec _ (C_Inc x1) = showString "(Inc" . (showChar ' ' . (shows x1 .
    showChar ')'))

instance Read C_Nesting where
  readsPrec d s = readParen False (\r -> [(C_Align, r0) | (_, r0) <-
    readQualified "Pretty" "Align" r]) s ++ readParen ((>) d 10) (\r -> [(C_Inc
    x1, r1) | (_, r0) <- readQualified "Pretty" "Inc" r, (x1, r1) <- readsPrec
    11 r0]) s

instance NonDet C_Nesting where
  choiceCons = Choice_C_Nesting
  choicesCons = Choices_C_Nesting
  failCons = Fail_C_Nesting
  guardCons = Guard_C_Nesting
  try (Choice_C_Nesting cd i x y) = tryChoice cd i x y
  try (Choices_C_Nesting cd i xs) = tryChoices cd i xs
  try (Fail_C_Nesting cd info) = Fail cd info
  try (Guard_C_Nesting cd c e) = Guard cd c e
  try x = Val x
  match f _ _ _ _ _ (Choice_C_Nesting cd i x y) = f cd i x y
  match _ f _ _ _ _ (Choices_C_Nesting cd i@(NarrowedID _ _) xs) = f cd i xs
  match _ _ f _ _ _ (Choices_C_Nesting cd i@(FreeID _ _) xs) = f cd i xs
  match _ _ _ _ _ _ (Choices_C_Nesting cd i _) = error
    ("Pretty.Nesting.match: Choices with ChoiceID " ++ show i)
  match _ _ _ f _ _ (Fail_C_Nesting cd info) = f cd info
  match _ _ _ _ f _ (Guard_C_Nesting cd c e) = f cd c e
  match _ _ _ _ _ f x = f x

instance Generable C_Nesting where
  generate s c = Choices_C_Nesting c (freeID [0, 1] s) [C_Align, C_Inc (generate
    (leftSupply s) c)]

instance NormalForm C_Nesting where
  ($!!) cont C_Align d cs = cont C_Align d cs
  ($!!) cont (C_Inc x1) d cs = ($!!) (\y1 d cs -> cont (C_Inc y1) d cs) x1 d cs
  ($!!) cont (Choice_C_Nesting cd i x y) d cs = nfChoice cont cd i x y cd cs
  ($!!) cont (Choices_C_Nesting cd i xs) d cs = nfChoices cont cd i xs d cs
  ($!!) cont (Guard_C_Nesting cd c e) d cs = guardCons cd c (($!!) cont e d
    (addCs c cs))
  ($!!) _ (Fail_C_Nesting cd info) _ _ = failCons cd info
  ($##) cont C_Align d cs = cont C_Align d cs
  ($##) cont (C_Inc x1) d cs = ($##) (\y1 d cs -> cont (C_Inc y1) d cs) x1 d cs
  ($##) cont (Choice_C_Nesting cd i x y) d cs = gnfChoice cont cd i x y cd cs
  ($##) cont (Choices_C_Nesting cd i xs) d cs = gnfChoices cont cd i xs d cs
  ($##) cont (Guard_C_Nesting cd c e) d cs = guardCons cd c (($##) cont e d
    (addCs c cs))
  ($##) _ (Fail_C_Nesting cd info) _ _ = failCons cd info
  showCons C_Align = "Pretty.Align"
  showCons (C_Inc _) = "Pretty.Inc _"
  showCons x = error ("Pretty.Nesting.showCons: no constructor: " ++ show x)
  searchNF _ cont C_Align = cont C_Align
  searchNF search cont (C_Inc x1) = search (\y1 -> cont (C_Inc y1)) x1
  searchNF _ _ x = error ("Pretty.Nesting.searchNF: no constructor: " ++ show x)

instance Unifiable C_Nesting where
  (=.=) C_Align C_Align d cs = C_True
  (=.=) (C_Inc x1) (C_Inc y1) d cs = (=:=) x1 y1 d cs
  (=.=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  (=.<=) C_Align C_Align d cs = C_True
  (=.<=) (C_Inc x1) (C_Inc y1) d cs = (=:<=) x1 y1 d cs
  (=.<=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  bind cd i C_Align = (i :=: ChooseN 0 0) : concat []
  bind cd i (C_Inc x3) = (i :=: ChooseN 1 1) : concat [bind cd (leftID i) x3]
  bind d i (Choice_C_Nesting cd j x y) = [ConstraintChoice cd j (bind d i x)
    (bind d i y)]
  bind d i (Choices_C_Nesting cd j@(FreeID _ _) xs) = bindOrNarrow d i cd j xs
  bind d i (Choices_C_Nesting cd j@(NarrowedID _ _) xs) = [ConstraintChoices cd
    j (map (bind d i) xs)]
  bind _ _ (Choices_C_Nesting cd i _) = error
    ("Pretty.Nesting.bind: Choices with ChoiceID: " ++ show i)
  bind _ _ (Fail_C_Nesting cd info) = [Unsolvable info]
  bind d i (Guard_C_Nesting cd c e) = getConstrList c ++ bind d i e
  lazyBind cd i C_Align = (i :=: ChooseN 0 0) : []
  lazyBind cd i (C_Inc x3) = (i :=: ChooseN 1 1) : [leftID i :=: LazyBind
    (lazyBind cd (leftID i) x3)]
  lazyBind d i (Choice_C_Nesting cd j x y) = [ConstraintChoice cd j (lazyBind d
    i x) (lazyBind d i y)]
  lazyBind d i (Choices_C_Nesting cd j@(FreeID _ _) xs) = lazyBindOrNarrow d i
    cd j xs
  lazyBind d i (Choices_C_Nesting cd j@(NarrowedID _ _) xs) = [ConstraintChoices
    cd j (map (lazyBind d i) xs)]
  lazyBind _ _ (Choices_C_Nesting cd i _) = error
    ("Pretty.Nesting.lazyBind: Choices with ChoiceID: " ++ show i)
  lazyBind _ _ (Fail_C_Nesting cd info) = [Unsolvable info]
  lazyBind d i (Guard_C_Nesting cd c e) = getConstrList c ++ [i :=: LazyBind
    (lazyBind d i e)]

instance Curry C_Nesting where

data C_Color
  = C_Black
  | C_Red
  | C_Green
  | C_Yellow
  | C_Blue
  | C_Magenta
  | C_Cyan
  | C_White
  | C_Default
  | Choice_C_Color Cover ID C_Color C_Color
  | Choices_C_Color Cover ID [C_Color]
  | Fail_C_Color Cover FailInfo
  | Guard_C_Color Cover Constraints C_Color

instance Show C_Color where
  showsPrec d (Choice_C_Color cd i x y) = showsChoice d cd i x y
  showsPrec d (Choices_C_Color cd i xs) = showsChoices d cd i xs
  showsPrec d (Guard_C_Color cd c e) = showsGuard d cd c e
  showsPrec _ (Fail_C_Color cd info) = showChar '!'
  showsPrec _ C_Black = showString "Black"
  showsPrec _ C_Red = showString "Red"
  showsPrec _ C_Green = showString "Green"
  showsPrec _ C_Yellow = showString "Yellow"
  showsPrec _ C_Blue = showString "Blue"
  showsPrec _ C_Magenta = showString "Magenta"
  showsPrec _ C_Cyan = showString "Cyan"
  showsPrec _ C_White = showString "White"
  showsPrec _ C_Default = showString "Default"

instance Read C_Color where
  readsPrec _ s = readParen False (\r -> [(C_Black, r0) | (_, r0) <-
    readQualified "Pretty" "Black" r]) s ++ (readParen False (\r -> [(C_Red
    , r0) | (_, r0) <- readQualified "Pretty" "Red" r]) s ++ (readParen False
    (\r -> [(C_Green, r0) | (_, r0) <- readQualified "Pretty" "Green" r]) s ++
    (readParen False (\r -> [(C_Yellow, r0) | (_, r0) <- readQualified "Pretty"
    "Yellow" r]) s ++ (readParen False (\r -> [(C_Blue, r0) | (_, r0) <-
    readQualified "Pretty" "Blue" r]) s ++ (readParen False (\r -> [(C_Magenta
    , r0) | (_, r0) <- readQualified "Pretty" "Magenta" r]) s ++ (readParen
    False (\r -> [(C_Cyan, r0) | (_, r0) <- readQualified "Pretty" "Cyan" r])
    s ++ (readParen False (\r -> [(C_White, r0) | (_, r0) <- readQualified
    "Pretty" "White" r]) s ++ readParen False (\r -> [(C_Default, r0) | (_, r0)
    <- readQualified "Pretty" "Default" r]) s)))))))

instance NonDet C_Color where
  choiceCons = Choice_C_Color
  choicesCons = Choices_C_Color
  failCons = Fail_C_Color
  guardCons = Guard_C_Color
  try (Choice_C_Color cd i x y) = tryChoice cd i x y
  try (Choices_C_Color cd i xs) = tryChoices cd i xs
  try (Fail_C_Color cd info) = Fail cd info
  try (Guard_C_Color cd c e) = Guard cd c e
  try x = Val x
  match f _ _ _ _ _ (Choice_C_Color cd i x y) = f cd i x y
  match _ f _ _ _ _ (Choices_C_Color cd i@(NarrowedID _ _) xs) = f cd i xs
  match _ _ f _ _ _ (Choices_C_Color cd i@(FreeID _ _) xs) = f cd i xs
  match _ _ _ _ _ _ (Choices_C_Color cd i _) = error
    ("Pretty.Color.match: Choices with ChoiceID " ++ show i)
  match _ _ _ f _ _ (Fail_C_Color cd info) = f cd info
  match _ _ _ _ f _ (Guard_C_Color cd c e) = f cd c e
  match _ _ _ _ _ f x = f x

instance Generable C_Color where
  generate s c = Choices_C_Color c (freeID [0, 0, 0, 0, 0, 0, 0, 0, 0] s)
    [C_Black, C_Red, C_Green, C_Yellow, C_Blue, C_Magenta, C_Cyan, C_White
    , C_Default]

instance NormalForm C_Color where
  ($!!) cont C_Black d cs = cont C_Black d cs
  ($!!) cont C_Red d cs = cont C_Red d cs
  ($!!) cont C_Green d cs = cont C_Green d cs
  ($!!) cont C_Yellow d cs = cont C_Yellow d cs
  ($!!) cont C_Blue d cs = cont C_Blue d cs
  ($!!) cont C_Magenta d cs = cont C_Magenta d cs
  ($!!) cont C_Cyan d cs = cont C_Cyan d cs
  ($!!) cont C_White d cs = cont C_White d cs
  ($!!) cont C_Default d cs = cont C_Default d cs
  ($!!) cont (Choice_C_Color cd i x y) d cs = nfChoice cont cd i x y cd cs
  ($!!) cont (Choices_C_Color cd i xs) d cs = nfChoices cont cd i xs d cs
  ($!!) cont (Guard_C_Color cd c e) d cs = guardCons cd c (($!!) cont e d (addCs
    c cs))
  ($!!) _ (Fail_C_Color cd info) _ _ = failCons cd info
  ($##) cont C_Black d cs = cont C_Black d cs
  ($##) cont C_Red d cs = cont C_Red d cs
  ($##) cont C_Green d cs = cont C_Green d cs
  ($##) cont C_Yellow d cs = cont C_Yellow d cs
  ($##) cont C_Blue d cs = cont C_Blue d cs
  ($##) cont C_Magenta d cs = cont C_Magenta d cs
  ($##) cont C_Cyan d cs = cont C_Cyan d cs
  ($##) cont C_White d cs = cont C_White d cs
  ($##) cont C_Default d cs = cont C_Default d cs
  ($##) cont (Choice_C_Color cd i x y) d cs = gnfChoice cont cd i x y cd cs
  ($##) cont (Choices_C_Color cd i xs) d cs = gnfChoices cont cd i xs d cs
  ($##) cont (Guard_C_Color cd c e) d cs = guardCons cd c (($##) cont e d (addCs
    c cs))
  ($##) _ (Fail_C_Color cd info) _ _ = failCons cd info
  showCons C_Black = "Pretty.Black"
  showCons C_Red = "Pretty.Red"
  showCons C_Green = "Pretty.Green"
  showCons C_Yellow = "Pretty.Yellow"
  showCons C_Blue = "Pretty.Blue"
  showCons C_Magenta = "Pretty.Magenta"
  showCons C_Cyan = "Pretty.Cyan"
  showCons C_White = "Pretty.White"
  showCons C_Default = "Pretty.Default"
  showCons x = error ("Pretty.Color.showCons: no constructor: " ++ show x)
  searchNF _ cont C_Black = cont C_Black
  searchNF _ cont C_Red = cont C_Red
  searchNF _ cont C_Green = cont C_Green
  searchNF _ cont C_Yellow = cont C_Yellow
  searchNF _ cont C_Blue = cont C_Blue
  searchNF _ cont C_Magenta = cont C_Magenta
  searchNF _ cont C_Cyan = cont C_Cyan
  searchNF _ cont C_White = cont C_White
  searchNF _ cont C_Default = cont C_Default
  searchNF _ _ x = error ("Pretty.Color.searchNF: no constructor: " ++ show x)

instance Unifiable C_Color where
  (=.=) C_Black C_Black d cs = C_True
  (=.=) C_Red C_Red d cs = C_True
  (=.=) C_Green C_Green d cs = C_True
  (=.=) C_Yellow C_Yellow d cs = C_True
  (=.=) C_Blue C_Blue d cs = C_True
  (=.=) C_Magenta C_Magenta d cs = C_True
  (=.=) C_Cyan C_Cyan d cs = C_True
  (=.=) C_White C_White d cs = C_True
  (=.=) C_Default C_Default d cs = C_True
  (=.=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  (=.<=) C_Black C_Black d cs = C_True
  (=.<=) C_Red C_Red d cs = C_True
  (=.<=) C_Green C_Green d cs = C_True
  (=.<=) C_Yellow C_Yellow d cs = C_True
  (=.<=) C_Blue C_Blue d cs = C_True
  (=.<=) C_Magenta C_Magenta d cs = C_True
  (=.<=) C_Cyan C_Cyan d cs = C_True
  (=.<=) C_White C_White d cs = C_True
  (=.<=) C_Default C_Default d cs = C_True
  (=.<=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  bind cd i C_Black = (i :=: ChooseN 0 0) : concat []
  bind cd i C_Red = (i :=: ChooseN 1 0) : concat []
  bind cd i C_Green = (i :=: ChooseN 2 0) : concat []
  bind cd i C_Yellow = (i :=: ChooseN 3 0) : concat []
  bind cd i C_Blue = (i :=: ChooseN 4 0) : concat []
  bind cd i C_Magenta = (i :=: ChooseN 5 0) : concat []
  bind cd i C_Cyan = (i :=: ChooseN 6 0) : concat []
  bind cd i C_White = (i :=: ChooseN 7 0) : concat []
  bind cd i C_Default = (i :=: ChooseN 8 0) : concat []
  bind d i (Choice_C_Color cd j x y) = [ConstraintChoice cd j (bind d i x) (bind
    d i y)]
  bind d i (Choices_C_Color cd j@(FreeID _ _) xs) = bindOrNarrow d i cd j xs
  bind d i (Choices_C_Color cd j@(NarrowedID _ _) xs) = [ConstraintChoices cd j
    (map (bind d i) xs)]
  bind _ _ (Choices_C_Color cd i _) = error
    ("Pretty.Color.bind: Choices with ChoiceID: " ++ show i)
  bind _ _ (Fail_C_Color cd info) = [Unsolvable info]
  bind d i (Guard_C_Color cd c e) = getConstrList c ++ bind d i e
  lazyBind cd i C_Black = (i :=: ChooseN 0 0) : []
  lazyBind cd i C_Red = (i :=: ChooseN 1 0) : []
  lazyBind cd i C_Green = (i :=: ChooseN 2 0) : []
  lazyBind cd i C_Yellow = (i :=: ChooseN 3 0) : []
  lazyBind cd i C_Blue = (i :=: ChooseN 4 0) : []
  lazyBind cd i C_Magenta = (i :=: ChooseN 5 0) : []
  lazyBind cd i C_Cyan = (i :=: ChooseN 6 0) : []
  lazyBind cd i C_White = (i :=: ChooseN 7 0) : []
  lazyBind cd i C_Default = (i :=: ChooseN 8 0) : []
  lazyBind d i (Choice_C_Color cd j x y) = [ConstraintChoice cd j (lazyBind d i
    x) (lazyBind d i y)]
  lazyBind d i (Choices_C_Color cd j@(FreeID _ _) xs) = lazyBindOrNarrow d i cd
    j xs
  lazyBind d i (Choices_C_Color cd j@(NarrowedID _ _) xs) = [ConstraintChoices
    cd j (map (lazyBind d i) xs)]
  lazyBind _ _ (Choices_C_Color cd i _) = error
    ("Pretty.Color.lazyBind: Choices with ChoiceID: " ++ show i)
  lazyBind _ _ (Fail_C_Color cd info) = [Unsolvable info]
  lazyBind d i (Guard_C_Color cd c e) = getConstrList c ++ [i :=: LazyBind
    (lazyBind d i e)]

instance Curry C_Color where

data C_Intensity
  = C_Faint
  | C_Normal
  | C_Bold
  | Choice_C_Intensity Cover ID C_Intensity C_Intensity
  | Choices_C_Intensity Cover ID [C_Intensity]
  | Fail_C_Intensity Cover FailInfo
  | Guard_C_Intensity Cover Constraints C_Intensity

instance Show C_Intensity where
  showsPrec d (Choice_C_Intensity cd i x y) = showsChoice d cd i x y
  showsPrec d (Choices_C_Intensity cd i xs) = showsChoices d cd i xs
  showsPrec d (Guard_C_Intensity cd c e) = showsGuard d cd c e
  showsPrec _ (Fail_C_Intensity cd info) = showChar '!'
  showsPrec _ C_Faint = showString "Faint"
  showsPrec _ C_Normal = showString "Normal"
  showsPrec _ C_Bold = showString "Bold"

instance Read C_Intensity where
  readsPrec _ s = readParen False (\r -> [(C_Faint, r0) | (_, r0) <-
    readQualified "Pretty" "Faint" r]) s ++ (readParen False (\r -> [(C_Normal
    , r0) | (_, r0) <- readQualified "Pretty" "Normal" r]) s ++ readParen False
    (\r -> [(C_Bold, r0) | (_, r0) <- readQualified "Pretty" "Bold" r]) s)

instance NonDet C_Intensity where
  choiceCons = Choice_C_Intensity
  choicesCons = Choices_C_Intensity
  failCons = Fail_C_Intensity
  guardCons = Guard_C_Intensity
  try (Choice_C_Intensity cd i x y) = tryChoice cd i x y
  try (Choices_C_Intensity cd i xs) = tryChoices cd i xs
  try (Fail_C_Intensity cd info) = Fail cd info
  try (Guard_C_Intensity cd c e) = Guard cd c e
  try x = Val x
  match f _ _ _ _ _ (Choice_C_Intensity cd i x y) = f cd i x y
  match _ f _ _ _ _ (Choices_C_Intensity cd i@(NarrowedID _ _) xs) = f cd i xs
  match _ _ f _ _ _ (Choices_C_Intensity cd i@(FreeID _ _) xs) = f cd i xs
  match _ _ _ _ _ _ (Choices_C_Intensity cd i _) = error
    ("Pretty.Intensity.match: Choices with ChoiceID " ++ show i)
  match _ _ _ f _ _ (Fail_C_Intensity cd info) = f cd info
  match _ _ _ _ f _ (Guard_C_Intensity cd c e) = f cd c e
  match _ _ _ _ _ f x = f x

instance Generable C_Intensity where
  generate s c = Choices_C_Intensity c (freeID [0, 0, 0] s) [C_Faint, C_Normal
    , C_Bold]

instance NormalForm C_Intensity where
  ($!!) cont C_Faint d cs = cont C_Faint d cs
  ($!!) cont C_Normal d cs = cont C_Normal d cs
  ($!!) cont C_Bold d cs = cont C_Bold d cs
  ($!!) cont (Choice_C_Intensity cd i x y) d cs = nfChoice cont cd i x y cd cs
  ($!!) cont (Choices_C_Intensity cd i xs) d cs = nfChoices cont cd i xs d cs
  ($!!) cont (Guard_C_Intensity cd c e) d cs = guardCons cd c (($!!) cont e d
    (addCs c cs))
  ($!!) _ (Fail_C_Intensity cd info) _ _ = failCons cd info
  ($##) cont C_Faint d cs = cont C_Faint d cs
  ($##) cont C_Normal d cs = cont C_Normal d cs
  ($##) cont C_Bold d cs = cont C_Bold d cs
  ($##) cont (Choice_C_Intensity cd i x y) d cs = gnfChoice cont cd i x y cd cs
  ($##) cont (Choices_C_Intensity cd i xs) d cs = gnfChoices cont cd i xs d cs
  ($##) cont (Guard_C_Intensity cd c e) d cs = guardCons cd c (($##) cont e d
    (addCs c cs))
  ($##) _ (Fail_C_Intensity cd info) _ _ = failCons cd info
  showCons C_Faint = "Pretty.Faint"
  showCons C_Normal = "Pretty.Normal"
  showCons C_Bold = "Pretty.Bold"
  showCons x = error ("Pretty.Intensity.showCons: no constructor: " ++ show x)
  searchNF _ cont C_Faint = cont C_Faint
  searchNF _ cont C_Normal = cont C_Normal
  searchNF _ cont C_Bold = cont C_Bold
  searchNF _ _ x = error ("Pretty.Intensity.searchNF: no constructor: " ++ show
    x)

instance Unifiable C_Intensity where
  (=.=) C_Faint C_Faint d cs = C_True
  (=.=) C_Normal C_Normal d cs = C_True
  (=.=) C_Bold C_Bold d cs = C_True
  (=.=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  (=.<=) C_Faint C_Faint d cs = C_True
  (=.<=) C_Normal C_Normal d cs = C_True
  (=.<=) C_Bold C_Bold d cs = C_True
  (=.<=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  bind cd i C_Faint = (i :=: ChooseN 0 0) : concat []
  bind cd i C_Normal = (i :=: ChooseN 1 0) : concat []
  bind cd i C_Bold = (i :=: ChooseN 2 0) : concat []
  bind d i (Choice_C_Intensity cd j x y) = [ConstraintChoice cd j (bind d i x)
    (bind d i y)]
  bind d i (Choices_C_Intensity cd j@(FreeID _ _) xs) = bindOrNarrow d i cd j xs
  bind d i (Choices_C_Intensity cd j@(NarrowedID _ _) xs) = [ConstraintChoices
    cd j (map (bind d i) xs)]
  bind _ _ (Choices_C_Intensity cd i _) = error
    ("Pretty.Intensity.bind: Choices with ChoiceID: " ++ show i)
  bind _ _ (Fail_C_Intensity cd info) = [Unsolvable info]
  bind d i (Guard_C_Intensity cd c e) = getConstrList c ++ bind d i e
  lazyBind cd i C_Faint = (i :=: ChooseN 0 0) : []
  lazyBind cd i C_Normal = (i :=: ChooseN 1 0) : []
  lazyBind cd i C_Bold = (i :=: ChooseN 2 0) : []
  lazyBind d i (Choice_C_Intensity cd j x y) = [ConstraintChoice cd j (lazyBind
    d i x) (lazyBind d i y)]
  lazyBind d i (Choices_C_Intensity cd j@(FreeID _ _) xs) = lazyBindOrNarrow d i
    cd j xs
  lazyBind d i (Choices_C_Intensity cd j@(NarrowedID _ _) xs) =
    [ConstraintChoices cd j (map (lazyBind d i) xs)]
  lazyBind _ _ (Choices_C_Intensity cd i _) = error
    ("Pretty.Intensity.lazyBind: Choices with ChoiceID: " ++ show i)
  lazyBind _ _ (Fail_C_Intensity cd info) = [Unsolvable info]
  lazyBind d i (Guard_C_Intensity cd c e) = getConstrList c ++ [i :=: LazyBind
    (lazyBind d i e)]

instance Curry C_Intensity where

data C_BlinkMode
  = C_Off
  | C_Slow
  | C_Rapid
  | Choice_C_BlinkMode Cover ID C_BlinkMode C_BlinkMode
  | Choices_C_BlinkMode Cover ID [C_BlinkMode]
  | Fail_C_BlinkMode Cover FailInfo
  | Guard_C_BlinkMode Cover Constraints C_BlinkMode

instance Show C_BlinkMode where
  showsPrec d (Choice_C_BlinkMode cd i x y) = showsChoice d cd i x y
  showsPrec d (Choices_C_BlinkMode cd i xs) = showsChoices d cd i xs
  showsPrec d (Guard_C_BlinkMode cd c e) = showsGuard d cd c e
  showsPrec _ (Fail_C_BlinkMode cd info) = showChar '!'
  showsPrec _ C_Off = showString "Off"
  showsPrec _ C_Slow = showString "Slow"
  showsPrec _ C_Rapid = showString "Rapid"

instance Read C_BlinkMode where
  readsPrec _ s = readParen False (\r -> [(C_Off, r0) | (_, r0) <- readQualified
    "Pretty" "Off" r]) s ++ (readParen False (\r -> [(C_Slow, r0) | (_, r0) <-
    readQualified "Pretty" "Slow" r]) s ++ readParen False (\r -> [(C_Rapid
    , r0) | (_, r0) <- readQualified "Pretty" "Rapid" r]) s)

instance NonDet C_BlinkMode where
  choiceCons = Choice_C_BlinkMode
  choicesCons = Choices_C_BlinkMode
  failCons = Fail_C_BlinkMode
  guardCons = Guard_C_BlinkMode
  try (Choice_C_BlinkMode cd i x y) = tryChoice cd i x y
  try (Choices_C_BlinkMode cd i xs) = tryChoices cd i xs
  try (Fail_C_BlinkMode cd info) = Fail cd info
  try (Guard_C_BlinkMode cd c e) = Guard cd c e
  try x = Val x
  match f _ _ _ _ _ (Choice_C_BlinkMode cd i x y) = f cd i x y
  match _ f _ _ _ _ (Choices_C_BlinkMode cd i@(NarrowedID _ _) xs) = f cd i xs
  match _ _ f _ _ _ (Choices_C_BlinkMode cd i@(FreeID _ _) xs) = f cd i xs
  match _ _ _ _ _ _ (Choices_C_BlinkMode cd i _) = error
    ("Pretty.BlinkMode.match: Choices with ChoiceID " ++ show i)
  match _ _ _ f _ _ (Fail_C_BlinkMode cd info) = f cd info
  match _ _ _ _ f _ (Guard_C_BlinkMode cd c e) = f cd c e
  match _ _ _ _ _ f x = f x

instance Generable C_BlinkMode where
  generate s c = Choices_C_BlinkMode c (freeID [0, 0, 0] s) [C_Off, C_Slow
    , C_Rapid]

instance NormalForm C_BlinkMode where
  ($!!) cont C_Off d cs = cont C_Off d cs
  ($!!) cont C_Slow d cs = cont C_Slow d cs
  ($!!) cont C_Rapid d cs = cont C_Rapid d cs
  ($!!) cont (Choice_C_BlinkMode cd i x y) d cs = nfChoice cont cd i x y cd cs
  ($!!) cont (Choices_C_BlinkMode cd i xs) d cs = nfChoices cont cd i xs d cs
  ($!!) cont (Guard_C_BlinkMode cd c e) d cs = guardCons cd c (($!!) cont e d
    (addCs c cs))
  ($!!) _ (Fail_C_BlinkMode cd info) _ _ = failCons cd info
  ($##) cont C_Off d cs = cont C_Off d cs
  ($##) cont C_Slow d cs = cont C_Slow d cs
  ($##) cont C_Rapid d cs = cont C_Rapid d cs
  ($##) cont (Choice_C_BlinkMode cd i x y) d cs = gnfChoice cont cd i x y cd cs
  ($##) cont (Choices_C_BlinkMode cd i xs) d cs = gnfChoices cont cd i xs d cs
  ($##) cont (Guard_C_BlinkMode cd c e) d cs = guardCons cd c (($##) cont e d
    (addCs c cs))
  ($##) _ (Fail_C_BlinkMode cd info) _ _ = failCons cd info
  showCons C_Off = "Pretty.Off"
  showCons C_Slow = "Pretty.Slow"
  showCons C_Rapid = "Pretty.Rapid"
  showCons x = error ("Pretty.BlinkMode.showCons: no constructor: " ++ show x)
  searchNF _ cont C_Off = cont C_Off
  searchNF _ cont C_Slow = cont C_Slow
  searchNF _ cont C_Rapid = cont C_Rapid
  searchNF _ _ x = error ("Pretty.BlinkMode.searchNF: no constructor: " ++ show
    x)

instance Unifiable C_BlinkMode where
  (=.=) C_Off C_Off d cs = C_True
  (=.=) C_Slow C_Slow d cs = C_True
  (=.=) C_Rapid C_Rapid d cs = C_True
  (=.=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  (=.<=) C_Off C_Off d cs = C_True
  (=.<=) C_Slow C_Slow d cs = C_True
  (=.<=) C_Rapid C_Rapid d cs = C_True
  (=.<=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  bind cd i C_Off = (i :=: ChooseN 0 0) : concat []
  bind cd i C_Slow = (i :=: ChooseN 1 0) : concat []
  bind cd i C_Rapid = (i :=: ChooseN 2 0) : concat []
  bind d i (Choice_C_BlinkMode cd j x y) = [ConstraintChoice cd j (bind d i x)
    (bind d i y)]
  bind d i (Choices_C_BlinkMode cd j@(FreeID _ _) xs) = bindOrNarrow d i cd j xs
  bind d i (Choices_C_BlinkMode cd j@(NarrowedID _ _) xs) = [ConstraintChoices
    cd j (map (bind d i) xs)]
  bind _ _ (Choices_C_BlinkMode cd i _) = error
    ("Pretty.BlinkMode.bind: Choices with ChoiceID: " ++ show i)
  bind _ _ (Fail_C_BlinkMode cd info) = [Unsolvable info]
  bind d i (Guard_C_BlinkMode cd c e) = getConstrList c ++ bind d i e
  lazyBind cd i C_Off = (i :=: ChooseN 0 0) : []
  lazyBind cd i C_Slow = (i :=: ChooseN 1 0) : []
  lazyBind cd i C_Rapid = (i :=: ChooseN 2 0) : []
  lazyBind d i (Choice_C_BlinkMode cd j x y) = [ConstraintChoice cd j (lazyBind
    d i x) (lazyBind d i y)]
  lazyBind d i (Choices_C_BlinkMode cd j@(FreeID _ _) xs) = lazyBindOrNarrow d i
    cd j xs
  lazyBind d i (Choices_C_BlinkMode cd j@(NarrowedID _ _) xs) =
    [ConstraintChoices cd j (map (lazyBind d i) xs)]
  lazyBind _ _ (Choices_C_BlinkMode cd i _) = error
    ("Pretty.BlinkMode.lazyBind: Choices with ChoiceID: " ++ show i)
  lazyBind _ _ (Fail_C_BlinkMode cd info) = [Unsolvable info]
  lazyBind d i (Guard_C_BlinkMode cd c e) = getConstrList c ++ [i :=: LazyBind
    (lazyBind d i e)]

instance Curry C_BlinkMode where

data C_FormatStm
  = C_SetForeground C_Color
  | C_SetBackground C_Color
  | C_SetIntensity C_Intensity
  | C_SetBlinkMode C_BlinkMode
  | C_SetItalicized Curry_Prelude.C_Bool
  | C_SetUnderlined Curry_Prelude.C_Bool
  | C_SetCrossedout Curry_Prelude.C_Bool
  | C_InverseColoring Curry_Prelude.C_Bool
  | Choice_C_FormatStm Cover ID C_FormatStm C_FormatStm
  | Choices_C_FormatStm Cover ID [C_FormatStm]
  | Fail_C_FormatStm Cover FailInfo
  | Guard_C_FormatStm Cover Constraints C_FormatStm

instance Show C_FormatStm where
  showsPrec d (Choice_C_FormatStm cd i x y) = showsChoice d cd i x y
  showsPrec d (Choices_C_FormatStm cd i xs) = showsChoices d cd i xs
  showsPrec d (Guard_C_FormatStm cd c e) = showsGuard d cd c e
  showsPrec _ (Fail_C_FormatStm cd info) = showChar '!'
  showsPrec _ (C_SetForeground x1) = showString "(SetForeground" . (showChar
    ' ' . (shows x1 . showChar ')'))
  showsPrec _ (C_SetBackground x1) = showString "(SetBackground" . (showChar
    ' ' . (shows x1 . showChar ')'))
  showsPrec _ (C_SetIntensity x1) = showString "(SetIntensity" . (showChar ' ' .
    (shows x1 . showChar ')'))
  showsPrec _ (C_SetBlinkMode x1) = showString "(SetBlinkMode" . (showChar ' ' .
    (shows x1 . showChar ')'))
  showsPrec _ (C_SetItalicized x1) = showString "(SetItalicized" . (showChar
    ' ' . (shows x1 . showChar ')'))
  showsPrec _ (C_SetUnderlined x1) = showString "(SetUnderlined" . (showChar
    ' ' . (shows x1 . showChar ')'))
  showsPrec _ (C_SetCrossedout x1) = showString "(SetCrossedout" . (showChar
    ' ' . (shows x1 . showChar ')'))
  showsPrec _ (C_InverseColoring x1) = showString "(InverseColoring" . (showChar
    ' ' . (shows x1 . showChar ')'))

instance Read C_FormatStm where
  readsPrec d s = readParen ((>) d 10) (\r -> [(C_SetForeground x1, r1) | (_
    , r0) <- readQualified "Pretty" "SetForeground" r, (x1, r1) <- readsPrec 11
    r0]) s ++ (readParen ((>) d 10) (\r -> [(C_SetBackground x1, r1) | (_, r0)
    <- readQualified "Pretty" "SetBackground" r, (x1, r1) <- readsPrec 11 r0])
    s ++ (readParen ((>) d 10) (\r -> [(C_SetIntensity x1, r1) | (_, r0) <-
    readQualified "Pretty" "SetIntensity" r, (x1, r1) <- readsPrec 11 r0]) s ++
    (readParen ((>) d 10) (\r -> [(C_SetBlinkMode x1, r1) | (_, r0) <-
    readQualified "Pretty" "SetBlinkMode" r, (x1, r1) <- readsPrec 11 r0]) s ++
    (readParen ((>) d 10) (\r -> [(C_SetItalicized x1, r1) | (_, r0) <-
    readQualified "Pretty" "SetItalicized" r, (x1, r1) <- readsPrec 11 r0]) s ++
    (readParen ((>) d 10) (\r -> [(C_SetUnderlined x1, r1) | (_, r0) <-
    readQualified "Pretty" "SetUnderlined" r, (x1, r1) <- readsPrec 11 r0]) s ++
    (readParen ((>) d 10) (\r -> [(C_SetCrossedout x1, r1) | (_, r0) <-
    readQualified "Pretty" "SetCrossedout" r, (x1, r1) <- readsPrec 11 r0]) s ++
    readParen ((>) d 10) (\r -> [(C_InverseColoring x1, r1) | (_, r0) <-
    readQualified "Pretty" "InverseColoring" r, (x1, r1) <- readsPrec 11 r0])
    s))))))

instance NonDet C_FormatStm where
  choiceCons = Choice_C_FormatStm
  choicesCons = Choices_C_FormatStm
  failCons = Fail_C_FormatStm
  guardCons = Guard_C_FormatStm
  try (Choice_C_FormatStm cd i x y) = tryChoice cd i x y
  try (Choices_C_FormatStm cd i xs) = tryChoices cd i xs
  try (Fail_C_FormatStm cd info) = Fail cd info
  try (Guard_C_FormatStm cd c e) = Guard cd c e
  try x = Val x
  match f _ _ _ _ _ (Choice_C_FormatStm cd i x y) = f cd i x y
  match _ f _ _ _ _ (Choices_C_FormatStm cd i@(NarrowedID _ _) xs) = f cd i xs
  match _ _ f _ _ _ (Choices_C_FormatStm cd i@(FreeID _ _) xs) = f cd i xs
  match _ _ _ _ _ _ (Choices_C_FormatStm cd i _) = error
    ("Pretty.FormatStm.match: Choices with ChoiceID " ++ show i)
  match _ _ _ f _ _ (Fail_C_FormatStm cd info) = f cd info
  match _ _ _ _ f _ (Guard_C_FormatStm cd c e) = f cd c e
  match _ _ _ _ _ f x = f x

instance Generable C_FormatStm where
  generate s c = Choices_C_FormatStm c (freeID [1, 1, 1, 1, 1, 1, 1, 1] s)
    [C_SetForeground (generate (leftSupply s) c), C_SetBackground (generate
    (leftSupply s) c), C_SetIntensity (generate (leftSupply s) c)
    , C_SetBlinkMode (generate (leftSupply s) c), C_SetItalicized (generate
    (leftSupply s) c), C_SetUnderlined (generate (leftSupply s) c)
    , C_SetCrossedout (generate (leftSupply s) c), C_InverseColoring (generate
    (leftSupply s) c)]

instance NormalForm C_FormatStm where
  ($!!) cont (C_SetForeground x1) d cs = ($!!) (\y1 d cs -> cont
    (C_SetForeground y1) d cs) x1 d cs
  ($!!) cont (C_SetBackground x1) d cs = ($!!) (\y1 d cs -> cont
    (C_SetBackground y1) d cs) x1 d cs
  ($!!) cont (C_SetIntensity x1) d cs = ($!!) (\y1 d cs -> cont (C_SetIntensity
    y1) d cs) x1 d cs
  ($!!) cont (C_SetBlinkMode x1) d cs = ($!!) (\y1 d cs -> cont (C_SetBlinkMode
    y1) d cs) x1 d cs
  ($!!) cont (C_SetItalicized x1) d cs = ($!!) (\y1 d cs -> cont
    (C_SetItalicized y1) d cs) x1 d cs
  ($!!) cont (C_SetUnderlined x1) d cs = ($!!) (\y1 d cs -> cont
    (C_SetUnderlined y1) d cs) x1 d cs
  ($!!) cont (C_SetCrossedout x1) d cs = ($!!) (\y1 d cs -> cont
    (C_SetCrossedout y1) d cs) x1 d cs
  ($!!) cont (C_InverseColoring x1) d cs = ($!!) (\y1 d cs -> cont
    (C_InverseColoring y1) d cs) x1 d cs
  ($!!) cont (Choice_C_FormatStm cd i x y) d cs = nfChoice cont cd i x y cd cs
  ($!!) cont (Choices_C_FormatStm cd i xs) d cs = nfChoices cont cd i xs d cs
  ($!!) cont (Guard_C_FormatStm cd c e) d cs = guardCons cd c (($!!) cont e d
    (addCs c cs))
  ($!!) _ (Fail_C_FormatStm cd info) _ _ = failCons cd info
  ($##) cont (C_SetForeground x1) d cs = ($##) (\y1 d cs -> cont
    (C_SetForeground y1) d cs) x1 d cs
  ($##) cont (C_SetBackground x1) d cs = ($##) (\y1 d cs -> cont
    (C_SetBackground y1) d cs) x1 d cs
  ($##) cont (C_SetIntensity x1) d cs = ($##) (\y1 d cs -> cont (C_SetIntensity
    y1) d cs) x1 d cs
  ($##) cont (C_SetBlinkMode x1) d cs = ($##) (\y1 d cs -> cont (C_SetBlinkMode
    y1) d cs) x1 d cs
  ($##) cont (C_SetItalicized x1) d cs = ($##) (\y1 d cs -> cont
    (C_SetItalicized y1) d cs) x1 d cs
  ($##) cont (C_SetUnderlined x1) d cs = ($##) (\y1 d cs -> cont
    (C_SetUnderlined y1) d cs) x1 d cs
  ($##) cont (C_SetCrossedout x1) d cs = ($##) (\y1 d cs -> cont
    (C_SetCrossedout y1) d cs) x1 d cs
  ($##) cont (C_InverseColoring x1) d cs = ($##) (\y1 d cs -> cont
    (C_InverseColoring y1) d cs) x1 d cs
  ($##) cont (Choice_C_FormatStm cd i x y) d cs = gnfChoice cont cd i x y cd cs
  ($##) cont (Choices_C_FormatStm cd i xs) d cs = gnfChoices cont cd i xs d cs
  ($##) cont (Guard_C_FormatStm cd c e) d cs = guardCons cd c (($##) cont e d
    (addCs c cs))
  ($##) _ (Fail_C_FormatStm cd info) _ _ = failCons cd info
  showCons (C_SetForeground _) = "Pretty.SetForeground _"
  showCons (C_SetBackground _) = "Pretty.SetBackground _"
  showCons (C_SetIntensity _) = "Pretty.SetIntensity _"
  showCons (C_SetBlinkMode _) = "Pretty.SetBlinkMode _"
  showCons (C_SetItalicized _) = "Pretty.SetItalicized _"
  showCons (C_SetUnderlined _) = "Pretty.SetUnderlined _"
  showCons (C_SetCrossedout _) = "Pretty.SetCrossedout _"
  showCons (C_InverseColoring _) = "Pretty.InverseColoring _"
  showCons x = error ("Pretty.FormatStm.showCons: no constructor: " ++ show x)
  searchNF search cont (C_SetForeground x1) = search (\y1 -> cont
    (C_SetForeground y1)) x1
  searchNF search cont (C_SetBackground x1) = search (\y1 -> cont
    (C_SetBackground y1)) x1
  searchNF search cont (C_SetIntensity x1) = search (\y1 -> cont (C_SetIntensity
    y1)) x1
  searchNF search cont (C_SetBlinkMode x1) = search (\y1 -> cont (C_SetBlinkMode
    y1)) x1
  searchNF search cont (C_SetItalicized x1) = search (\y1 -> cont
    (C_SetItalicized y1)) x1
  searchNF search cont (C_SetUnderlined x1) = search (\y1 -> cont
    (C_SetUnderlined y1)) x1
  searchNF search cont (C_SetCrossedout x1) = search (\y1 -> cont
    (C_SetCrossedout y1)) x1
  searchNF search cont (C_InverseColoring x1) = search (\y1 -> cont
    (C_InverseColoring y1)) x1
  searchNF _ _ x = error ("Pretty.FormatStm.searchNF: no constructor: " ++ show
    x)

instance Unifiable C_FormatStm where
  (=.=) (C_SetForeground x1) (C_SetForeground y1) d cs = (=:=) x1 y1 d cs
  (=.=) (C_SetBackground x1) (C_SetBackground y1) d cs = (=:=) x1 y1 d cs
  (=.=) (C_SetIntensity x1) (C_SetIntensity y1) d cs = (=:=) x1 y1 d cs
  (=.=) (C_SetBlinkMode x1) (C_SetBlinkMode y1) d cs = (=:=) x1 y1 d cs
  (=.=) (C_SetItalicized x1) (C_SetItalicized y1) d cs = (=:=) x1 y1 d cs
  (=.=) (C_SetUnderlined x1) (C_SetUnderlined y1) d cs = (=:=) x1 y1 d cs
  (=.=) (C_SetCrossedout x1) (C_SetCrossedout y1) d cs = (=:=) x1 y1 d cs
  (=.=) (C_InverseColoring x1) (C_InverseColoring y1) d cs = (=:=) x1 y1 d cs
  (=.=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  (=.<=) (C_SetForeground x1) (C_SetForeground y1) d cs = (=:<=) x1 y1 d cs
  (=.<=) (C_SetBackground x1) (C_SetBackground y1) d cs = (=:<=) x1 y1 d cs
  (=.<=) (C_SetIntensity x1) (C_SetIntensity y1) d cs = (=:<=) x1 y1 d cs
  (=.<=) (C_SetBlinkMode x1) (C_SetBlinkMode y1) d cs = (=:<=) x1 y1 d cs
  (=.<=) (C_SetItalicized x1) (C_SetItalicized y1) d cs = (=:<=) x1 y1 d cs
  (=.<=) (C_SetUnderlined x1) (C_SetUnderlined y1) d cs = (=:<=) x1 y1 d cs
  (=.<=) (C_SetCrossedout x1) (C_SetCrossedout y1) d cs = (=:<=) x1 y1 d cs
  (=.<=) (C_InverseColoring x1) (C_InverseColoring y1) d cs = (=:<=) x1 y1 d cs
  (=.<=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  bind cd i (C_SetForeground x3) = (i :=: ChooseN 0 1) : concat [bind cd (leftID
    i) x3]
  bind cd i (C_SetBackground x3) = (i :=: ChooseN 1 1) : concat [bind cd (leftID
    i) x3]
  bind cd i (C_SetIntensity x3) = (i :=: ChooseN 2 1) : concat [bind cd (leftID
    i) x3]
  bind cd i (C_SetBlinkMode x3) = (i :=: ChooseN 3 1) : concat [bind cd (leftID
    i) x3]
  bind cd i (C_SetItalicized x3) = (i :=: ChooseN 4 1) : concat [bind cd (leftID
    i) x3]
  bind cd i (C_SetUnderlined x3) = (i :=: ChooseN 5 1) : concat [bind cd (leftID
    i) x3]
  bind cd i (C_SetCrossedout x3) = (i :=: ChooseN 6 1) : concat [bind cd (leftID
    i) x3]
  bind cd i (C_InverseColoring x3) = (i :=: ChooseN 7 1) : concat [bind cd
    (leftID i) x3]
  bind d i (Choice_C_FormatStm cd j x y) = [ConstraintChoice cd j (bind d i x)
    (bind d i y)]
  bind d i (Choices_C_FormatStm cd j@(FreeID _ _) xs) = bindOrNarrow d i cd j xs
  bind d i (Choices_C_FormatStm cd j@(NarrowedID _ _) xs) = [ConstraintChoices
    cd j (map (bind d i) xs)]
  bind _ _ (Choices_C_FormatStm cd i _) = error
    ("Pretty.FormatStm.bind: Choices with ChoiceID: " ++ show i)
  bind _ _ (Fail_C_FormatStm cd info) = [Unsolvable info]
  bind d i (Guard_C_FormatStm cd c e) = getConstrList c ++ bind d i e
  lazyBind cd i (C_SetForeground x3) = (i :=: ChooseN 0 1) : [leftID i :=:
    LazyBind (lazyBind cd (leftID i) x3)]
  lazyBind cd i (C_SetBackground x3) = (i :=: ChooseN 1 1) : [leftID i :=:
    LazyBind (lazyBind cd (leftID i) x3)]
  lazyBind cd i (C_SetIntensity x3) = (i :=: ChooseN 2 1) : [leftID i :=:
    LazyBind (lazyBind cd (leftID i) x3)]
  lazyBind cd i (C_SetBlinkMode x3) = (i :=: ChooseN 3 1) : [leftID i :=:
    LazyBind (lazyBind cd (leftID i) x3)]
  lazyBind cd i (C_SetItalicized x3) = (i :=: ChooseN 4 1) : [leftID i :=:
    LazyBind (lazyBind cd (leftID i) x3)]
  lazyBind cd i (C_SetUnderlined x3) = (i :=: ChooseN 5 1) : [leftID i :=:
    LazyBind (lazyBind cd (leftID i) x3)]
  lazyBind cd i (C_SetCrossedout x3) = (i :=: ChooseN 6 1) : [leftID i :=:
    LazyBind (lazyBind cd (leftID i) x3)]
  lazyBind cd i (C_InverseColoring x3) = (i :=: ChooseN 7 1) : [leftID i :=:
    LazyBind (lazyBind cd (leftID i) x3)]
  lazyBind d i (Choice_C_FormatStm cd j x y) = [ConstraintChoice cd j (lazyBind
    d i x) (lazyBind d i y)]
  lazyBind d i (Choices_C_FormatStm cd j@(FreeID _ _) xs) = lazyBindOrNarrow d i
    cd j xs
  lazyBind d i (Choices_C_FormatStm cd j@(NarrowedID _ _) xs) =
    [ConstraintChoices cd j (map (lazyBind d i) xs)]
  lazyBind _ _ (Choices_C_FormatStm cd i _) = error
    ("Pretty.FormatStm.lazyBind: Choices with ChoiceID: " ++ show i)
  lazyBind _ _ (Fail_C_FormatStm cd info) = [Unsolvable info]
  lazyBind d i (Guard_C_FormatStm cd c e) = getConstrList c ++ [i :=: LazyBind
    (lazyBind d i e)]

instance Curry C_FormatStm where

data C_Tokens
  = C_EOD
  | C_Empty C_Tokens
  | C_Text (Curry_Prelude.OP_List Curry_Prelude.C_Char) C_Tokens
  | C_LineBreak (Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
    Curry_Prelude.C_Char)) C_Tokens
  | C_OpenGroup C_Tokens
  | C_CloseGroup C_Tokens
  | C_OpenNest C_Nesting C_Tokens
  | C_CloseNest C_Tokens
  | C_OpenFormat C_FormatStm C_Tokens
  | C_CloseFormat C_Tokens
  | Choice_C_Tokens Cover ID C_Tokens C_Tokens
  | Choices_C_Tokens Cover ID [C_Tokens]
  | Fail_C_Tokens Cover FailInfo
  | Guard_C_Tokens Cover Constraints C_Tokens

instance Show C_Tokens where
  showsPrec d (Choice_C_Tokens cd i x y) = showsChoice d cd i x y
  showsPrec d (Choices_C_Tokens cd i xs) = showsChoices d cd i xs
  showsPrec d (Guard_C_Tokens cd c e) = showsGuard d cd c e
  showsPrec _ (Fail_C_Tokens cd info) = showChar '!'
  showsPrec _ C_EOD = showString "EOD"
  showsPrec _ (C_Empty x1) = showString "(Empty" . (showChar ' ' . (shows x1 .
    showChar ')'))
  showsPrec _ (C_Text x1 x2) = showString "(Text" . (showChar ' ' . (shows x1 .
    (showChar ' ' . (shows x2 . showChar ')'))))
  showsPrec _ (C_LineBreak x1 x2) = showString "(LineBreak" . (showChar ' ' .
    (shows x1 . (showChar ' ' . (shows x2 . showChar ')'))))
  showsPrec _ (C_OpenGroup x1) = showString "(OpenGroup" . (showChar ' ' .
    (shows x1 . showChar ')'))
  showsPrec _ (C_CloseGroup x1) = showString "(CloseGroup" . (showChar ' ' .
    (shows x1 . showChar ')'))
  showsPrec _ (C_OpenNest x1 x2) = showString "(OpenNest" . (showChar ' ' .
    (shows x1 . (showChar ' ' . (shows x2 . showChar ')'))))
  showsPrec _ (C_CloseNest x1) = showString "(CloseNest" . (showChar ' ' .
    (shows x1 . showChar ')'))
  showsPrec _ (C_OpenFormat x1 x2) = showString "(OpenFormat" . (showChar ' ' .
    (shows x1 . (showChar ' ' . (shows x2 . showChar ')'))))
  showsPrec _ (C_CloseFormat x1) = showString "(CloseFormat" . (showChar ' ' .
    (shows x1 . showChar ')'))

instance Read C_Tokens where
  readsPrec d s = readParen False (\r -> [(C_EOD, r0) | (_, r0) <- readQualified
    "Pretty" "EOD" r]) s ++ (readParen ((>) d 10) (\r -> [(C_Empty x1, r1) | (_
    , r0) <- readQualified "Pretty" "Empty" r, (x1, r1) <- readsPrec 11 r0])
    s ++ (readParen ((>) d 10) (\r -> [(C_Text x1 x2, r2) | (_, r0) <-
    readQualified "Pretty" "Text" r, (x1, r1) <- readsPrec 11 r0, (x2, r2) <-
    readsPrec 11 r1]) s ++ (readParen ((>) d 10) (\r -> [(C_LineBreak x1 x2
    , r2) | (_, r0) <- readQualified "Pretty" "LineBreak" r, (x1, r1) <-
    readsPrec 11 r0, (x2, r2) <- readsPrec 11 r1]) s ++ (readParen ((>) d 10)
    (\r -> [(C_OpenGroup x1, r1) | (_, r0) <- readQualified "Pretty" "OpenGroup"
    r, (x1, r1) <- readsPrec 11 r0]) s ++ (readParen ((>) d 10) (\r ->
    [(C_CloseGroup x1, r1) | (_, r0) <- readQualified "Pretty" "CloseGroup" r,
    (x1, r1) <- readsPrec 11 r0]) s ++ (readParen ((>) d 10) (\r -> [(C_OpenNest
    x1 x2, r2) | (_, r0) <- readQualified "Pretty" "OpenNest" r, (x1, r1) <-
    readsPrec 11 r0, (x2, r2) <- readsPrec 11 r1]) s ++ (readParen ((>) d 10)
    (\r -> [(C_CloseNest x1, r1) | (_, r0) <- readQualified "Pretty" "CloseNest"
    r, (x1, r1) <- readsPrec 11 r0]) s ++ (readParen ((>) d 10) (\r ->
    [(C_OpenFormat x1 x2, r2) | (_, r0) <- readQualified "Pretty" "OpenFormat"
    r, (x1, r1) <- readsPrec 11 r0, (x2, r2) <- readsPrec 11 r1]) s ++ readParen
    ((>) d 10) (\r -> [(C_CloseFormat x1, r1) | (_, r0) <- readQualified
    "Pretty" "CloseFormat" r, (x1, r1) <- readsPrec 11 r0]) s))))))))

instance NonDet C_Tokens where
  choiceCons = Choice_C_Tokens
  choicesCons = Choices_C_Tokens
  failCons = Fail_C_Tokens
  guardCons = Guard_C_Tokens
  try (Choice_C_Tokens cd i x y) = tryChoice cd i x y
  try (Choices_C_Tokens cd i xs) = tryChoices cd i xs
  try (Fail_C_Tokens cd info) = Fail cd info
  try (Guard_C_Tokens cd c e) = Guard cd c e
  try x = Val x
  match f _ _ _ _ _ (Choice_C_Tokens cd i x y) = f cd i x y
  match _ f _ _ _ _ (Choices_C_Tokens cd i@(NarrowedID _ _) xs) = f cd i xs
  match _ _ f _ _ _ (Choices_C_Tokens cd i@(FreeID _ _) xs) = f cd i xs
  match _ _ _ _ _ _ (Choices_C_Tokens cd i _) = error
    ("Pretty.Tokens.match: Choices with ChoiceID " ++ show i)
  match _ _ _ f _ _ (Fail_C_Tokens cd info) = f cd info
  match _ _ _ _ f _ (Guard_C_Tokens cd c e) = f cd c e
  match _ _ _ _ _ f x = f x

instance Generable C_Tokens where
  generate s c = Choices_C_Tokens c (freeID [0, 1, 2, 2, 1, 1, 2, 1, 2, 1] s)
    [C_EOD, C_Empty (generate (leftSupply s) c), C_Text (generate (leftSupply s)
    c) (generate (rightSupply s) c), C_LineBreak (generate (leftSupply s) c)
    (generate (rightSupply s) c), C_OpenGroup (generate (leftSupply s) c)
    , C_CloseGroup (generate (leftSupply s) c), C_OpenNest (generate (leftSupply
    s) c) (generate (rightSupply s) c), C_CloseNest (generate (leftSupply s) c)
    , C_OpenFormat (generate (leftSupply s) c) (generate (rightSupply s) c)
    , C_CloseFormat (generate (leftSupply s) c)]

instance NormalForm C_Tokens where
  ($!!) cont C_EOD d cs = cont C_EOD d cs
  ($!!) cont (C_Empty x1) d cs = ($!!) (\y1 d cs -> cont (C_Empty y1) d cs) x1 d
    cs
  ($!!) cont (C_Text x1 x2) d cs = ($!!) (\y1 d cs -> ($!!) (\y2 d cs -> cont
    (C_Text y1 y2) d cs) x2 d cs) x1 d cs
  ($!!) cont (C_LineBreak x1 x2) d cs = ($!!) (\y1 d cs -> ($!!) (\y2 d cs ->
    cont (C_LineBreak y1 y2) d cs) x2 d cs) x1 d cs
  ($!!) cont (C_OpenGroup x1) d cs = ($!!) (\y1 d cs -> cont (C_OpenGroup y1) d
    cs) x1 d cs
  ($!!) cont (C_CloseGroup x1) d cs = ($!!) (\y1 d cs -> cont (C_CloseGroup y1)
    d cs) x1 d cs
  ($!!) cont (C_OpenNest x1 x2) d cs = ($!!) (\y1 d cs -> ($!!) (\y2 d cs ->
    cont (C_OpenNest y1 y2) d cs) x2 d cs) x1 d cs
  ($!!) cont (C_CloseNest x1) d cs = ($!!) (\y1 d cs -> cont (C_CloseNest y1) d
    cs) x1 d cs
  ($!!) cont (C_OpenFormat x1 x2) d cs = ($!!) (\y1 d cs -> ($!!) (\y2 d cs ->
    cont (C_OpenFormat y1 y2) d cs) x2 d cs) x1 d cs
  ($!!) cont (C_CloseFormat x1) d cs = ($!!) (\y1 d cs -> cont (C_CloseFormat
    y1) d cs) x1 d cs
  ($!!) cont (Choice_C_Tokens cd i x y) d cs = nfChoice cont cd i x y cd cs
  ($!!) cont (Choices_C_Tokens cd i xs) d cs = nfChoices cont cd i xs d cs
  ($!!) cont (Guard_C_Tokens cd c e) d cs = guardCons cd c (($!!) cont e d
    (addCs c cs))
  ($!!) _ (Fail_C_Tokens cd info) _ _ = failCons cd info
  ($##) cont C_EOD d cs = cont C_EOD d cs
  ($##) cont (C_Empty x1) d cs = ($##) (\y1 d cs -> cont (C_Empty y1) d cs) x1 d
    cs
  ($##) cont (C_Text x1 x2) d cs = ($##) (\y1 d cs -> ($##) (\y2 d cs -> cont
    (C_Text y1 y2) d cs) x2 d cs) x1 d cs
  ($##) cont (C_LineBreak x1 x2) d cs = ($##) (\y1 d cs -> ($##) (\y2 d cs ->
    cont (C_LineBreak y1 y2) d cs) x2 d cs) x1 d cs
  ($##) cont (C_OpenGroup x1) d cs = ($##) (\y1 d cs -> cont (C_OpenGroup y1) d
    cs) x1 d cs
  ($##) cont (C_CloseGroup x1) d cs = ($##) (\y1 d cs -> cont (C_CloseGroup y1)
    d cs) x1 d cs
  ($##) cont (C_OpenNest x1 x2) d cs = ($##) (\y1 d cs -> ($##) (\y2 d cs ->
    cont (C_OpenNest y1 y2) d cs) x2 d cs) x1 d cs
  ($##) cont (C_CloseNest x1) d cs = ($##) (\y1 d cs -> cont (C_CloseNest y1) d
    cs) x1 d cs
  ($##) cont (C_OpenFormat x1 x2) d cs = ($##) (\y1 d cs -> ($##) (\y2 d cs ->
    cont (C_OpenFormat y1 y2) d cs) x2 d cs) x1 d cs
  ($##) cont (C_CloseFormat x1) d cs = ($##) (\y1 d cs -> cont (C_CloseFormat
    y1) d cs) x1 d cs
  ($##) cont (Choice_C_Tokens cd i x y) d cs = gnfChoice cont cd i x y cd cs
  ($##) cont (Choices_C_Tokens cd i xs) d cs = gnfChoices cont cd i xs d cs
  ($##) cont (Guard_C_Tokens cd c e) d cs = guardCons cd c (($##) cont e d
    (addCs c cs))
  ($##) _ (Fail_C_Tokens cd info) _ _ = failCons cd info
  showCons C_EOD = "Pretty.EOD"
  showCons (C_Empty _) = "Pretty.Empty _"
  showCons (C_Text _ _) = "Pretty.Text _ _"
  showCons (C_LineBreak _ _) = "Pretty.LineBreak _ _"
  showCons (C_OpenGroup _) = "Pretty.OpenGroup _"
  showCons (C_CloseGroup _) = "Pretty.CloseGroup _"
  showCons (C_OpenNest _ _) = "Pretty.OpenNest _ _"
  showCons (C_CloseNest _) = "Pretty.CloseNest _"
  showCons (C_OpenFormat _ _) = "Pretty.OpenFormat _ _"
  showCons (C_CloseFormat _) = "Pretty.CloseFormat _"
  showCons x = error ("Pretty.Tokens.showCons: no constructor: " ++ show x)
  searchNF _ cont C_EOD = cont C_EOD
  searchNF search cont (C_Empty x1) = search (\y1 -> cont (C_Empty y1)) x1
  searchNF search cont (C_Text x1 x2) = search (\y1 -> search (\y2 -> cont
    (C_Text y1 y2)) x2) x1
  searchNF search cont (C_LineBreak x1 x2) = search (\y1 -> search (\y2 -> cont
    (C_LineBreak y1 y2)) x2) x1
  searchNF search cont (C_OpenGroup x1) = search (\y1 -> cont (C_OpenGroup y1))
    x1
  searchNF search cont (C_CloseGroup x1) = search (\y1 -> cont (C_CloseGroup
    y1)) x1
  searchNF search cont (C_OpenNest x1 x2) = search (\y1 -> search (\y2 -> cont
    (C_OpenNest y1 y2)) x2) x1
  searchNF search cont (C_CloseNest x1) = search (\y1 -> cont (C_CloseNest y1))
    x1
  searchNF search cont (C_OpenFormat x1 x2) = search (\y1 -> search (\y2 -> cont
    (C_OpenFormat y1 y2)) x2) x1
  searchNF search cont (C_CloseFormat x1) = search (\y1 -> cont (C_CloseFormat
    y1)) x1
  searchNF _ _ x = error ("Pretty.Tokens.searchNF: no constructor: " ++ show x)

instance Unifiable C_Tokens where
  (=.=) C_EOD C_EOD d cs = C_True
  (=.=) (C_Empty x1) (C_Empty y1) d cs = (=:=) x1 y1 d cs
  (=.=) (C_Text x1 x2) (C_Text y1 y2) d cs = (&) ((=:=) x1 y1 d cs) ((=:=) x2 y2
    d cs) d cs
  (=.=) (C_LineBreak x1 x2) (C_LineBreak y1 y2) d cs = (&) ((=:=) x1 y1 d cs)
    ((=:=) x2 y2 d cs) d cs
  (=.=) (C_OpenGroup x1) (C_OpenGroup y1) d cs = (=:=) x1 y1 d cs
  (=.=) (C_CloseGroup x1) (C_CloseGroup y1) d cs = (=:=) x1 y1 d cs
  (=.=) (C_OpenNest x1 x2) (C_OpenNest y1 y2) d cs = (&) ((=:=) x1 y1 d cs)
    ((=:=) x2 y2 d cs) d cs
  (=.=) (C_CloseNest x1) (C_CloseNest y1) d cs = (=:=) x1 y1 d cs
  (=.=) (C_OpenFormat x1 x2) (C_OpenFormat y1 y2) d cs = (&) ((=:=) x1 y1 d cs)
    ((=:=) x2 y2 d cs) d cs
  (=.=) (C_CloseFormat x1) (C_CloseFormat y1) d cs = (=:=) x1 y1 d cs
  (=.=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  (=.<=) C_EOD C_EOD d cs = C_True
  (=.<=) (C_Empty x1) (C_Empty y1) d cs = (=:<=) x1 y1 d cs
  (=.<=) (C_Text x1 x2) (C_Text y1 y2) d cs = (&) ((=:<=) x1 y1 d cs) ((=:<=) x2
    y2 d cs) d cs
  (=.<=) (C_LineBreak x1 x2) (C_LineBreak y1 y2) d cs = (&) ((=:<=) x1 y1 d cs)
    ((=:<=) x2 y2 d cs) d cs
  (=.<=) (C_OpenGroup x1) (C_OpenGroup y1) d cs = (=:<=) x1 y1 d cs
  (=.<=) (C_CloseGroup x1) (C_CloseGroup y1) d cs = (=:<=) x1 y1 d cs
  (=.<=) (C_OpenNest x1 x2) (C_OpenNest y1 y2) d cs = (&) ((=:<=) x1 y1 d cs)
    ((=:<=) x2 y2 d cs) d cs
  (=.<=) (C_CloseNest x1) (C_CloseNest y1) d cs = (=:<=) x1 y1 d cs
  (=.<=) (C_OpenFormat x1 x2) (C_OpenFormat y1 y2) d cs = (&) ((=:<=) x1 y1 d
    cs) ((=:<=) x2 y2 d cs) d cs
  (=.<=) (C_CloseFormat x1) (C_CloseFormat y1) d cs = (=:<=) x1 y1 d cs
  (=.<=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  bind cd i C_EOD = (i :=: ChooseN 0 0) : concat []
  bind cd i (C_Empty x3) = (i :=: ChooseN 1 1) : concat [bind cd (leftID i) x3]
  bind cd i (C_Text x3 x4) = (i :=: ChooseN 2 2) : concat [bind cd (leftID i) x3
    , bind cd (rightID i) x4]
  bind cd i (C_LineBreak x3 x4) = (i :=: ChooseN 3 2) : concat [bind cd (leftID
    i) x3, bind cd (rightID i) x4]
  bind cd i (C_OpenGroup x3) = (i :=: ChooseN 4 1) : concat [bind cd (leftID i)
    x3]
  bind cd i (C_CloseGroup x3) = (i :=: ChooseN 5 1) : concat [bind cd (leftID i)
    x3]
  bind cd i (C_OpenNest x3 x4) = (i :=: ChooseN 6 2) : concat [bind cd (leftID
    i) x3, bind cd (rightID i) x4]
  bind cd i (C_CloseNest x3) = (i :=: ChooseN 7 1) : concat [bind cd (leftID i)
    x3]
  bind cd i (C_OpenFormat x3 x4) = (i :=: ChooseN 8 2) : concat [bind cd (leftID
    i) x3, bind cd (rightID i) x4]
  bind cd i (C_CloseFormat x3) = (i :=: ChooseN 9 1) : concat [bind cd (leftID
    i) x3]
  bind d i (Choice_C_Tokens cd j x y) = [ConstraintChoice cd j (bind d i x)
    (bind d i y)]
  bind d i (Choices_C_Tokens cd j@(FreeID _ _) xs) = bindOrNarrow d i cd j xs
  bind d i (Choices_C_Tokens cd j@(NarrowedID _ _) xs) = [ConstraintChoices cd j
    (map (bind d i) xs)]
  bind _ _ (Choices_C_Tokens cd i _) = error
    ("Pretty.Tokens.bind: Choices with ChoiceID: " ++ show i)
  bind _ _ (Fail_C_Tokens cd info) = [Unsolvable info]
  bind d i (Guard_C_Tokens cd c e) = getConstrList c ++ bind d i e
  lazyBind cd i C_EOD = (i :=: ChooseN 0 0) : []
  lazyBind cd i (C_Empty x3) = (i :=: ChooseN 1 1) : [leftID i :=: LazyBind
    (lazyBind cd (leftID i) x3)]
  lazyBind cd i (C_Text x3 x4) = (i :=: ChooseN 2 2) : [leftID i :=: LazyBind
    (lazyBind cd (leftID i) x3), rightID i :=: LazyBind (lazyBind cd (rightID i)
    x4)]
  lazyBind cd i (C_LineBreak x3 x4) = (i :=: ChooseN 3 2) : [leftID i :=:
    LazyBind (lazyBind cd (leftID i) x3), rightID i :=: LazyBind (lazyBind cd
    (rightID i) x4)]
  lazyBind cd i (C_OpenGroup x3) = (i :=: ChooseN 4 1) : [leftID i :=: LazyBind
    (lazyBind cd (leftID i) x3)]
  lazyBind cd i (C_CloseGroup x3) = (i :=: ChooseN 5 1) : [leftID i :=: LazyBind
    (lazyBind cd (leftID i) x3)]
  lazyBind cd i (C_OpenNest x3 x4) = (i :=: ChooseN 6 2) : [leftID i :=:
    LazyBind (lazyBind cd (leftID i) x3), rightID i :=: LazyBind (lazyBind cd
    (rightID i) x4)]
  lazyBind cd i (C_CloseNest x3) = (i :=: ChooseN 7 1) : [leftID i :=: LazyBind
    (lazyBind cd (leftID i) x3)]
  lazyBind cd i (C_OpenFormat x3 x4) = (i :=: ChooseN 8 2) : [leftID i :=:
    LazyBind (lazyBind cd (leftID i) x3), rightID i :=: LazyBind (lazyBind cd
    (rightID i) x4)]
  lazyBind cd i (C_CloseFormat x3) = (i :=: ChooseN 9 1) : [leftID i :=:
    LazyBind (lazyBind cd (leftID i) x3)]
  lazyBind d i (Choice_C_Tokens cd j x y) = [ConstraintChoice cd j (lazyBind d i
    x) (lazyBind d i y)]
  lazyBind d i (Choices_C_Tokens cd j@(FreeID _ _) xs) = lazyBindOrNarrow d i cd
    j xs
  lazyBind d i (Choices_C_Tokens cd j@(NarrowedID _ _) xs) = [ConstraintChoices
    cd j (map (lazyBind d i) xs)]
  lazyBind _ _ (Choices_C_Tokens cd i _) = error
    ("Pretty.Tokens.lazyBind: Choices with ChoiceID: " ++ show i)
  lazyBind _ _ (Fail_C_Tokens cd info) = [Unsolvable info]
  lazyBind d i (Guard_C_Tokens cd c e) = getConstrList c ++ [i :=: LazyBind
    (lazyBind d i e)]

instance Curry C_Tokens where

d_C_pPrint :: Cover -> ConstStore -> C_Doc -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_pPrint cd cs = d_C_pretty (Curry_Prelude.C_Int (80))

nd_C_pPrint :: IDSupply -> Cover -> ConstStore -> Func C_Doc
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
nd_C_pPrint s cd cs = wrapNX id (nd_C_pretty (Curry_Prelude.C_Int (80)))

d_C_deDoc :: C_Doc -> Cover -> ConstStore -> C_Tokens -> Cover -> ConstStore
  -> C_Tokens
d_C_deDoc x1 cd cs = case x1 of
  C_Doc x2 -> x2
  Choice_C_Doc d i l r -> narrow d i (d_C_deDoc l cd cs) (d_C_deDoc r cd cs)
  Choices_C_Doc d i xs -> narrows cs d i (\z -> d_C_deDoc z cd cs) xs
  Guard_C_Doc d c e -> guardCons d c (d_C_deDoc e cd $! addCs c cs)
  Fail_C_Doc d info -> failCons d (traceFail "Pretty.deDoc" [show x1] info)
  _ -> failCons cd (consFail "Pretty.deDoc" (showCons x1))

nd_C_deDoc :: C_Doc -> IDSupply -> Cover -> ConstStore -> Func C_Tokens C_Tokens
nd_C_deDoc x1 s cd cs = case x1 of
  HO_C_Doc x2 -> x2
  Choice_C_Doc d i l r -> narrow d i (nd_C_deDoc l s cd cs) (nd_C_deDoc r s cd
    cs)
  Choices_C_Doc d i xs -> narrows cs d i (\z -> nd_C_deDoc z s cd cs) xs
  Guard_C_Doc d c e -> guardCons d c (nd_C_deDoc e s cd $! addCs c cs)
  Fail_C_Doc d info -> failCons d (traceFail "Pretty.deDoc" [show x1] info)
  _ -> failCons cd (consFail "Pretty.deDoc" (showCons x1))

d_C_empty :: Cover -> ConstStore -> C_Doc
d_C_empty cd cs = C_Doc (acceptCs id C_Empty)

nd_C_empty :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_empty s cd cs = HO_C_Doc (wrapDX id (acceptCs id C_Empty))

d_C_isEmpty :: C_Doc -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_isEmpty x1 cd cs = case x1 of
  C_Doc x2 -> d_OP_isEmpty_dot_isEmptyText_dot_8 (Curry_Prelude.d_C_apply x2
    C_EOD cd cs) cd cs
  Choice_C_Doc d i l r -> narrow d i (d_C_isEmpty l cd cs) (d_C_isEmpty r cd cs)
  Choices_C_Doc d i xs -> narrows cs d i (\z -> d_C_isEmpty z cd cs) xs
  Guard_C_Doc d c e -> guardCons d c (d_C_isEmpty e cd $! addCs c cs)
  Fail_C_Doc d info -> failCons d (traceFail "Pretty.isEmpty" [show x1] info)
  _ -> failCons cd (consFail "Pretty.isEmpty" (showCons x1))

nd_C_isEmpty :: C_Doc -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.C_Bool
nd_C_isEmpty x1 s cd cs = case x1 of
  HO_C_Doc x2 -> let s0 = s
    in s0 `seq` d_OP_isEmpty_dot_isEmptyText_dot_8 (Curry_Prelude.nd_C_apply x2
    C_EOD s0 cd cs) cd cs
  Choice_C_Doc d i l r -> narrow d i (nd_C_isEmpty l s cd cs) (nd_C_isEmpty r s
    cd cs)
  Choices_C_Doc d i xs -> narrows cs d i (\z -> nd_C_isEmpty z s cd cs) xs
  Guard_C_Doc d c e -> guardCons d c (nd_C_isEmpty e s cd $! addCs c cs)
  Fail_C_Doc d info -> failCons d (traceFail "Pretty.isEmpty" [show x1] info)
  _ -> failCons cd (consFail "Pretty.isEmpty" (showCons x1))

d_OP_isEmpty_dot_isEmptyText_dot_8 :: C_Tokens -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_OP_isEmpty_dot_isEmptyText_dot_8 x1 cd cs = let x2 = Curry_Prelude.C_False
  in d_C__case_43 x2 x1 cd cs

d_C_text :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> C_Doc
d_C_text x1 cd cs = C_Doc (acceptCs id (C_Text x1))

nd_C_text :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> IDSupply -> Cover
  -> ConstStore -> C_Doc
nd_C_text x1 s cd cs = HO_C_Doc (wrapDX id (acceptCs id (C_Text x1)))

d_C_linesep :: Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> C_Doc
d_C_linesep cd cs = Curry_Prelude.d_OP_dot (acceptCs id C_Doc)
  (Curry_Prelude.d_OP_dot (acceptCs (acceptCs id) C_LineBreak) (acceptCs id
  Curry_Prelude.C_Just) cd cs) cd cs

nd_C_linesep :: IDSupply -> Cover -> ConstStore -> Func (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) C_Doc
nd_C_linesep s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  HO_C_Doc)) (Curry_Prelude.nd_OP_dot (wrapDX (wrapDX id) (acceptCs (acceptCs
  id) C_LineBreak)) (wrapDX id (acceptCs id Curry_Prelude.C_Just)) s0 cd cs) s1
  cd cs))

d_C_hardline :: Cover -> ConstStore -> C_Doc
d_C_hardline cd cs = C_Doc (acceptCs id (C_LineBreak Curry_Prelude.C_Nothing))

nd_C_hardline :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_hardline s cd cs = HO_C_Doc (wrapDX id (acceptCs id (C_LineBreak
  Curry_Prelude.C_Nothing)))

d_C_line :: Cover -> ConstStore -> C_Doc
d_C_line cd cs = Curry_Prelude.d_C_apply (d_C_linesep cd cs)
  (Curry_Prelude.toCurryString " ") cd cs

nd_C_line :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_line s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (nd_C_linesep s0 cd cs)
  (Curry_Prelude.toCurryString " ") s1 cd cs))

d_C_linebreak :: Cover -> ConstStore -> C_Doc
d_C_linebreak cd cs = Curry_Prelude.d_C_apply (d_C_linesep cd cs)
  Curry_Prelude.OP_List cd cs

nd_C_linebreak :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_linebreak s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (nd_C_linesep s0 cd cs)
  Curry_Prelude.OP_List s1 cd cs))

d_C_softline :: Cover -> ConstStore -> C_Doc
d_C_softline cd cs = d_C_group (d_C_line cd cs) cd cs

nd_C_softline :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_softline s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_C_group (nd_C_line s0 cd cs) s1 cd cs))

d_C_softbreak :: Cover -> ConstStore -> C_Doc
d_C_softbreak cd cs = d_C_group (d_C_linebreak cd cs) cd cs

nd_C_softbreak :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_softbreak s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_C_group (nd_C_linebreak s0 cd cs) s1 cd cs))

d_C_group :: C_Doc -> Cover -> ConstStore -> C_Doc
d_C_group x1 cd cs = C_Doc (Curry_Prelude.d_OP_dot (acceptCs id C_OpenGroup)
  (Curry_Prelude.d_OP_dot (d_C_deDoc x1 cd cs) (acceptCs id C_CloseGroup) cd cs)
  cd cs)

nd_C_group :: C_Doc -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_group x1 s cd cs = let s4 = s
  in s4 `seq` HO_C_Doc (let s3 = leftSupply s4
                            s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  C_OpenGroup)) (let s1 = leftSupply s2
                     s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (nd_C_deDoc x1 s0 cd cs) (wrapDX
  id (acceptCs id C_CloseGroup)) s1 cd cs)) s3 cd cs))

d_C_nest :: Curry_Prelude.C_Int -> C_Doc -> Cover -> ConstStore -> C_Doc
d_C_nest x1 x2 cd cs = C_Doc (Curry_Prelude.d_OP_dot (acceptCs id (C_OpenNest
  (C_Inc x1))) (Curry_Prelude.d_OP_dot (d_C_deDoc x2 cd cs) (acceptCs id
  C_CloseNest) cd cs) cd cs)

nd_C_nest :: Curry_Prelude.C_Int -> C_Doc -> IDSupply -> Cover -> ConstStore
  -> C_Doc
nd_C_nest x1 x2 s cd cs = let s4 = s
  in s4 `seq` HO_C_Doc (let s3 = leftSupply s4
                            s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  (C_OpenNest (C_Inc x1)))) (let s1 = leftSupply s2
                                 s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (nd_C_deDoc x2 s0 cd cs) (wrapDX
  id (acceptCs id C_CloseNest)) s1 cd cs)) s3 cd cs))

d_C_hang :: Curry_Prelude.C_Int -> C_Doc -> Cover -> ConstStore -> C_Doc
d_C_hang x1 x2 cd cs = d_C_align (d_C_nest x1 x2 cd cs) cd cs

nd_C_hang :: Curry_Prelude.C_Int -> C_Doc -> IDSupply -> Cover -> ConstStore
  -> C_Doc
nd_C_hang x1 x2 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_C_align (nd_C_nest x1 x2 s0 cd cs) s1 cd cs))

d_C_align :: C_Doc -> Cover -> ConstStore -> C_Doc
d_C_align x1 cd cs = C_Doc (Curry_Prelude.d_OP_dot (acceptCs id (C_OpenNest
  C_Align)) (Curry_Prelude.d_OP_dot (d_C_deDoc x1 cd cs) (acceptCs id
  C_CloseNest) cd cs) cd cs)

nd_C_align :: C_Doc -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_align x1 s cd cs = let s4 = s
  in s4 `seq` HO_C_Doc (let s3 = leftSupply s4
                            s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  (C_OpenNest C_Align))) (let s1 = leftSupply s2
                              s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (nd_C_deDoc x1 s0 cd cs) (wrapDX
  id (acceptCs id C_CloseNest)) s1 cd cs)) s3 cd cs))

d_C_indent :: Curry_Prelude.C_Int -> C_Doc -> Cover -> ConstStore -> C_Doc
d_C_indent x1 x2 cd cs = d_C_hang x1 (d_OP_lt_gt (d_C_spaces x1 cd cs) x2 cd cs)
  cd cs

nd_C_indent :: Curry_Prelude.C_Int -> C_Doc -> IDSupply -> Cover -> ConstStore
  -> C_Doc
nd_C_indent x1 x2 s cd cs = let s4 = s
  in s4 `seq` (let s3 = leftSupply s4
                   s2 = rightSupply s4
  in s3 `seq` (s2 `seq` nd_C_hang x1 (let s1 = leftSupply s2
                                          s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_lt_gt (nd_C_spaces x1 s0 cd cs) x2 s1 cd cs)) s3
  cd cs))

d_C_combine :: C_Doc -> C_Doc -> C_Doc -> Cover -> ConstStore -> C_Doc
d_C_combine x1 x2 x3 cd cs = d_C__case_41 x2 x3 x1 (d_C_isEmpty x2 cd cs) cd cs

nd_C_combine :: C_Doc -> C_Doc -> C_Doc -> IDSupply -> Cover -> ConstStore
  -> C_Doc
nd_C_combine x1 x2 x3 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_C__case_41 x2 x3 x1 (nd_C_isEmpty x2 s0 cd cs) s1 cd
  cs))

d_OP_lt_gt :: C_Doc -> C_Doc -> Cover -> ConstStore -> C_Doc
d_OP_lt_gt x1 x2 cd cs = d_C__case_38 x1 x2 (d_C_isEmpty x1 cd cs) cd cs

nd_OP_lt_gt :: C_Doc -> C_Doc -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_OP_lt_gt x1 x2 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_C__case_38 x1 x2 (nd_C_isEmpty x1 s0 cd cs) s1 cd
  cs))

d_OP_lt_plus_gt :: Cover -> ConstStore -> C_Doc -> Cover -> ConstStore -> C_Doc
  -> Cover -> ConstStore -> C_Doc
d_OP_lt_plus_gt cd cs = acceptCs id (d_C_combine (d_C_space cd cs))

nd_OP_lt_plus_gt :: IDSupply -> Cover -> ConstStore -> Func C_Doc (Func C_Doc
  C_Doc)
nd_OP_lt_plus_gt s cd cs = let s0 = s
  in s0 `seq` wrapDX (wrapNX id) (acceptCs id (nd_C_combine (nd_C_space s0 cd
  cs)))

d_OP_dollar_dollar :: Cover -> ConstStore -> C_Doc -> Cover -> ConstStore
  -> C_Doc -> Cover -> ConstStore -> C_Doc
d_OP_dollar_dollar cd cs = acceptCs id (d_C_combine (d_C_line cd cs))

nd_OP_dollar_dollar :: IDSupply -> Cover -> ConstStore -> Func C_Doc (Func C_Doc
  C_Doc)
nd_OP_dollar_dollar s cd cs = let s0 = s
  in s0 `seq` wrapDX (wrapNX id) (acceptCs id (nd_C_combine (nd_C_line s0 cd
  cs)))

d_OP_lt_dollar_plus_dollar_gt :: Cover -> ConstStore -> C_Doc -> Cover
  -> ConstStore -> C_Doc -> Cover -> ConstStore -> C_Doc
d_OP_lt_dollar_plus_dollar_gt cd cs = acceptCs id (d_C_combine (d_OP_lt_gt
  (d_C_line cd cs) (d_C_linebreak cd cs) cd cs))

nd_OP_lt_dollar_plus_dollar_gt :: IDSupply -> Cover -> ConstStore -> Func C_Doc
  (Func C_Doc C_Doc)
nd_OP_lt_dollar_plus_dollar_gt s cd cs = let s3 = s
  in s3 `seq` wrapDX (wrapNX id) (acceptCs id (nd_C_combine (let s2 = leftSupply
                                                                   s3
                                                                 s4 = rightSupply
                                                                   s3
                                                                 s0 = leftSupply
                                                                   s4
                                                                 s1 = rightSupply
                                                                   s4
  in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` nd_OP_lt_gt (nd_C_line s0 cd cs)
  (nd_C_linebreak s1 cd cs) s2 cd cs))))))

d_OP_lt_slash_gt :: Cover -> ConstStore -> C_Doc -> Cover -> ConstStore -> C_Doc
  -> Cover -> ConstStore -> C_Doc
d_OP_lt_slash_gt cd cs = acceptCs id (d_C_combine (d_C_softline cd cs))

nd_OP_lt_slash_gt :: IDSupply -> Cover -> ConstStore -> Func C_Doc (Func C_Doc
  C_Doc)
nd_OP_lt_slash_gt s cd cs = let s0 = s
  in s0 `seq` wrapDX (wrapNX id) (acceptCs id (nd_C_combine (nd_C_softline s0 cd
  cs)))

d_OP_lt_dollar_dollar_gt :: Cover -> ConstStore -> C_Doc -> Cover -> ConstStore
  -> C_Doc -> Cover -> ConstStore -> C_Doc
d_OP_lt_dollar_dollar_gt cd cs = acceptCs id (d_C_combine (d_C_linebreak cd cs))

nd_OP_lt_dollar_dollar_gt :: IDSupply -> Cover -> ConstStore -> Func C_Doc (Func
  C_Doc C_Doc)
nd_OP_lt_dollar_dollar_gt s cd cs = let s0 = s
  in s0 `seq` wrapDX (wrapNX id) (acceptCs id (nd_C_combine (nd_C_linebreak s0
  cd cs)))

d_OP_lt_slash_slash_gt :: Cover -> ConstStore -> C_Doc -> Cover -> ConstStore
  -> C_Doc -> Cover -> ConstStore -> C_Doc
d_OP_lt_slash_slash_gt cd cs = acceptCs id (d_C_combine (d_C_softbreak cd cs))

nd_OP_lt_slash_slash_gt :: IDSupply -> Cover -> ConstStore -> Func C_Doc (Func
  C_Doc C_Doc)
nd_OP_lt_slash_slash_gt s cd cs = let s0 = s
  in s0 `seq` wrapDX (wrapNX id) (acceptCs id (nd_C_combine (nd_C_softbreak s0
  cd cs)))

d_OP_lt_dollar_bang_dollar_gt :: Cover -> ConstStore -> C_Doc -> Cover
  -> ConstStore -> C_Doc -> Cover -> ConstStore -> C_Doc
d_OP_lt_dollar_bang_dollar_gt cd cs = acceptCs id (d_C_combine (d_C_hardline cd
  cs))

nd_OP_lt_dollar_bang_dollar_gt :: IDSupply -> Cover -> ConstStore -> Func C_Doc
  (Func C_Doc C_Doc)
nd_OP_lt_dollar_bang_dollar_gt s cd cs = let s0 = s
  in s0 `seq` wrapDX (wrapNX id) (acceptCs id (nd_C_combine (nd_C_hardline s0 cd
  cs)))

d_C_compose :: (C_Doc -> Cover -> ConstStore -> C_Doc -> Cover -> ConstStore
  -> C_Doc) -> Curry_Prelude.OP_List C_Doc -> Cover -> ConstStore -> C_Doc
d_C_compose x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_List -> d_C_empty cd cs
  Curry_Prelude.OP_Cons x3 x4 -> Curry_Prelude.d_C_foldr1 x1 x2 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_compose x1 l cd cs)
    (d_C_compose x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_compose x1 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_compose x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Pretty.compose"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Pretty.compose" (showCons x2))

nd_C_compose :: Func C_Doc (Func C_Doc C_Doc) -> Curry_Prelude.OP_List C_Doc
  -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_compose x1 x2 s cd cs = case x2 of
  Curry_Prelude.OP_List -> let s0 = s in s0 `seq` nd_C_empty s0 cd cs
  Curry_Prelude.OP_Cons x3 x4 -> let s0 = s
    in s0 `seq` Curry_Prelude.nd_C_foldr1 x1 x2 s0 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C_compose x1 l s cd cs)
    (nd_C_compose x1 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C_compose x1
    z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C_compose x1 e s cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Pretty.compose"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Pretty.compose" (showCons x2))

d_C_hsep :: Cover -> ConstStore -> Curry_Prelude.OP_List C_Doc -> Cover
  -> ConstStore -> C_Doc
d_C_hsep cd cs = d_C_compose (d_OP_lt_plus_gt cd cs)

nd_C_hsep :: IDSupply -> Cover -> ConstStore -> Func (Curry_Prelude.OP_List
  C_Doc) C_Doc
nd_C_hsep s cd cs = let s0 = s
  in s0 `seq` wrapNX id (nd_C_compose (nd_OP_lt_plus_gt s0 cd cs))

d_C_vsep :: Cover -> ConstStore -> Curry_Prelude.OP_List C_Doc -> Cover
  -> ConstStore -> C_Doc
d_C_vsep cd cs = d_C_compose (d_OP_dollar_dollar cd cs)

nd_C_vsep :: IDSupply -> Cover -> ConstStore -> Func (Curry_Prelude.OP_List
  C_Doc) C_Doc
nd_C_vsep s cd cs = let s0 = s
  in s0 `seq` wrapNX id (nd_C_compose (nd_OP_dollar_dollar s0 cd cs))

d_C_vsepBlank :: Cover -> ConstStore -> Curry_Prelude.OP_List C_Doc -> Cover
  -> ConstStore -> C_Doc
d_C_vsepBlank cd cs = d_C_compose (d_OP_lt_dollar_plus_dollar_gt cd cs)

nd_C_vsepBlank :: IDSupply -> Cover -> ConstStore -> Func (Curry_Prelude.OP_List
  C_Doc) C_Doc
nd_C_vsepBlank s cd cs = let s0 = s
  in s0 `seq` wrapNX id (nd_C_compose (nd_OP_lt_dollar_plus_dollar_gt s0 cd cs))

d_C_fillSep :: Cover -> ConstStore -> Curry_Prelude.OP_List C_Doc -> Cover
  -> ConstStore -> C_Doc
d_C_fillSep cd cs = d_C_compose (d_OP_lt_slash_gt cd cs)

nd_C_fillSep :: IDSupply -> Cover -> ConstStore -> Func (Curry_Prelude.OP_List
  C_Doc) C_Doc
nd_C_fillSep s cd cs = let s0 = s
  in s0 `seq` wrapNX id (nd_C_compose (nd_OP_lt_slash_gt s0 cd cs))

d_C_sep :: Cover -> ConstStore -> Curry_Prelude.OP_List C_Doc -> Cover
  -> ConstStore -> C_Doc
d_C_sep cd cs = Curry_Prelude.d_OP_dot d_C_group (d_C_vsep cd cs) cd cs

nd_C_sep :: IDSupply -> Cover -> ConstStore -> Func (Curry_Prelude.OP_List
  C_Doc) C_Doc
nd_C_sep s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (wrapNX id nd_C_group)
  (nd_C_vsep s0 cd cs) s1 cd cs))

d_C_hcat :: Cover -> ConstStore -> Curry_Prelude.OP_List C_Doc -> Cover
  -> ConstStore -> C_Doc
d_C_hcat cd cs = d_C_compose (acceptCs id d_OP_lt_gt)

nd_C_hcat :: IDSupply -> Cover -> ConstStore -> Func (Curry_Prelude.OP_List
  C_Doc) C_Doc
nd_C_hcat s cd cs = wrapNX id (nd_C_compose (wrapDX (wrapNX id) (acceptCs id
  nd_OP_lt_gt)))

d_C_vcat :: Cover -> ConstStore -> Curry_Prelude.OP_List C_Doc -> Cover
  -> ConstStore -> C_Doc
d_C_vcat cd cs = d_C_compose (d_OP_lt_dollar_dollar_gt cd cs)

nd_C_vcat :: IDSupply -> Cover -> ConstStore -> Func (Curry_Prelude.OP_List
  C_Doc) C_Doc
nd_C_vcat s cd cs = let s0 = s
  in s0 `seq` wrapNX id (nd_C_compose (nd_OP_lt_dollar_dollar_gt s0 cd cs))

d_C_fillCat :: Cover -> ConstStore -> Curry_Prelude.OP_List C_Doc -> Cover
  -> ConstStore -> C_Doc
d_C_fillCat cd cs = d_C_compose (d_OP_lt_slash_slash_gt cd cs)

nd_C_fillCat :: IDSupply -> Cover -> ConstStore -> Func (Curry_Prelude.OP_List
  C_Doc) C_Doc
nd_C_fillCat s cd cs = let s0 = s
  in s0 `seq` wrapNX id (nd_C_compose (nd_OP_lt_slash_slash_gt s0 cd cs))

d_C_cat :: Cover -> ConstStore -> Curry_Prelude.OP_List C_Doc -> Cover
  -> ConstStore -> C_Doc
d_C_cat cd cs = Curry_Prelude.d_OP_dot d_C_group (d_C_vcat cd cs) cd cs

nd_C_cat :: IDSupply -> Cover -> ConstStore -> Func (Curry_Prelude.OP_List
  C_Doc) C_Doc
nd_C_cat s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (wrapNX id nd_C_group)
  (nd_C_vcat s0 cd cs) s1 cd cs))

d_C_punctuate :: C_Doc -> Curry_Prelude.OP_List C_Doc -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_Doc
d_C_punctuate x1 x2 cd cs = d_OP_punctuate_dot_go_dot_84 x1 x2 cd cs

nd_C_punctuate :: C_Doc -> Curry_Prelude.OP_List C_Doc -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_Doc
nd_C_punctuate x1 x2 s cd cs = let s0 = s
  in s0 `seq` nd_OP_punctuate_dot_go_dot_84 x1 x2 s0 cd cs

d_OP_punctuate_dot_go_dot_84 :: C_Doc -> Curry_Prelude.OP_List C_Doc -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_Doc
d_OP_punctuate_dot_go_dot_84 x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x3 x4 -> d_C__case_35 x1 x3 x4 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_punctuate_dot_go_dot_84 x1 l cd cs) (d_OP_punctuate_dot_go_dot_84 x1 r
    cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_punctuate_dot_go_dot_84 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_punctuate_dot_go_dot_84 x1 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Pretty.punctuate.go.84" [show x1, show x2] info)
  _ -> failCons cd (consFail "Pretty.punctuate.go.84" (showCons x2))

nd_OP_punctuate_dot_go_dot_84 :: C_Doc -> Curry_Prelude.OP_List C_Doc
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_List C_Doc
nd_OP_punctuate_dot_go_dot_84 x1 x2 s cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x3 x4 -> let s0 = s
    in s0 `seq` nd_C__case_35 x1 x3 x4 s0 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (nd_OP_punctuate_dot_go_dot_84 x1 l s cd cs) (nd_OP_punctuate_dot_go_dot_84
    x1 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    nd_OP_punctuate_dot_go_dot_84 x1 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (nd_OP_punctuate_dot_go_dot_84 x1 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Pretty.punctuate.go.84" [show x1, show x2] info)
  _ -> failCons cd (consFail "Pretty.punctuate.go.84" (showCons x2))

d_C_encloseSep :: C_Doc -> C_Doc -> C_Doc -> Curry_Prelude.OP_List C_Doc
  -> Cover -> ConstStore -> C_Doc
d_C_encloseSep x1 x2 x3 x4 cd cs = case x4 of
  Curry_Prelude.OP_List -> d_OP_lt_gt x1 x2 cd cs
  Curry_Prelude.OP_Cons x5 x6 -> d_C_align (d_C_enclose x1 x2
    (Curry_Prelude.d_C_apply (d_C_cat cd cs) (Curry_Prelude.OP_Cons x5
    (Curry_Prelude.d_C_map (d_OP_lt_gt x3) x6 cd cs)) cd cs) cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_encloseSep x1 x2 x3 l
    cd cs) (d_C_encloseSep x1 x2 x3 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_encloseSep
    x1 x2 x3 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_encloseSep x1 x2 x3 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Pretty.encloseSep"
    [show x1, show x2, show x3, show x4] info)
  _ -> failCons cd (consFail "Pretty.encloseSep" (showCons x4))

nd_C_encloseSep :: C_Doc -> C_Doc -> C_Doc -> Curry_Prelude.OP_List C_Doc
  -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_encloseSep x1 x2 x3 x4 s cd cs = case x4 of
  Curry_Prelude.OP_List -> let s0 = s in s0 `seq` nd_OP_lt_gt x1 x2 s0 cd cs
  Curry_Prelude.OP_Cons x5 x6 -> let s8 = s
    in s8 `seq` (let s7 = leftSupply s8
                     s6 = rightSupply s8
    in s7 `seq` (s6 `seq` nd_C_align (let s5 = leftSupply s6
                                          s3 = rightSupply s6
    in s5 `seq` (s3 `seq` nd_C_enclose x1 x2 (let s2 = leftSupply s3
                                                  s4 = rightSupply s3
                                                  s0 = leftSupply s4
                                                  s1 = rightSupply s4
    in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` Curry_Prelude.nd_C_apply (nd_C_cat
    s0 cd cs) (Curry_Prelude.OP_Cons x5 (Curry_Prelude.nd_C_map (wrapNX id
    (nd_OP_lt_gt x3)) x6 s1 cd cs)) s2 cd cs)))) s5 cd cs)) s7 cd cs))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C_encloseSep x1 x2 x3 l
    s cd cs) (nd_C_encloseSep x1 x2 x3 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C_encloseSep
    x1 x2 x3 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C_encloseSep x1 x2 x3 e
    s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Pretty.encloseSep"
    [show x1, show x2, show x3, show x4] info)
  _ -> failCons cd (consFail "Pretty.encloseSep" (showCons x4))

d_C_encloseSepSpaced :: C_Doc -> C_Doc -> C_Doc -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_Doc -> Cover -> ConstStore -> C_Doc
d_C_encloseSepSpaced x1 x2 x3 cd cs = d_C_encloseSep (d_OP_lt_gt x1 (d_C_space
  cd cs) cd cs) (d_OP_lt_gt (d_C_space cd cs) x2 cd cs) (d_OP_lt_gt x3
  (d_C_space cd cs) cd cs)

nd_C_encloseSepSpaced :: C_Doc -> C_Doc -> C_Doc -> IDSupply -> Cover
  -> ConstStore -> Func (Curry_Prelude.OP_List C_Doc) C_Doc
nd_C_encloseSepSpaced x1 x2 x3 s cd cs = let s9 = s
  in s9 `seq` (let s2 = leftSupply s9
                   s10 = rightSupply s9
                   s5 = leftSupply s10
                   s8 = rightSupply s10
  in s2 `seq` (s10 `seq` (s5 `seq` (s8 `seq` wrapNX id (nd_C_encloseSep
  (let s1 = leftSupply s2
       s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_lt_gt x1 (nd_C_space s0 cd cs) s1 cd cs))
  (let s4 = leftSupply s5
       s3 = rightSupply s5
  in s4 `seq` (s3 `seq` nd_OP_lt_gt (nd_C_space s3 cd cs) x2 s4 cd cs))
  (let s7 = leftSupply s8
       s6 = rightSupply s8
  in s7 `seq` (s6 `seq` nd_OP_lt_gt x3 (nd_C_space s6 cd cs) s7 cd cs)))))))

d_C_hEncloseSep :: C_Doc -> C_Doc -> C_Doc -> Curry_Prelude.OP_List C_Doc
  -> Cover -> ConstStore -> C_Doc
d_C_hEncloseSep x1 x2 x3 x4 cd cs = case x4 of
  Curry_Prelude.OP_List -> d_OP_lt_gt x1 x2 cd cs
  Curry_Prelude.OP_Cons x5 x6 -> d_C_align (d_C_enclose x1 x2
    (Curry_Prelude.d_C_apply (d_C_hcat cd cs) (Curry_Prelude.OP_Cons x5
    (Curry_Prelude.d_C_map (d_OP_lt_gt x3) x6 cd cs)) cd cs) cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_hEncloseSep x1 x2 x3 l
    cd cs) (d_C_hEncloseSep x1 x2 x3 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_hEncloseSep
    x1 x2 x3 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_hEncloseSep x1 x2 x3 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Pretty.hEncloseSep" [show x1, show x2, show x3, show x4] info)
  _ -> failCons cd (consFail "Pretty.hEncloseSep" (showCons x4))

nd_C_hEncloseSep :: C_Doc -> C_Doc -> C_Doc -> Curry_Prelude.OP_List C_Doc
  -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_hEncloseSep x1 x2 x3 x4 s cd cs = case x4 of
  Curry_Prelude.OP_List -> let s0 = s in s0 `seq` nd_OP_lt_gt x1 x2 s0 cd cs
  Curry_Prelude.OP_Cons x5 x6 -> let s8 = s
    in s8 `seq` (let s7 = leftSupply s8
                     s6 = rightSupply s8
    in s7 `seq` (s6 `seq` nd_C_align (let s5 = leftSupply s6
                                          s3 = rightSupply s6
    in s5 `seq` (s3 `seq` nd_C_enclose x1 x2 (let s2 = leftSupply s3
                                                  s4 = rightSupply s3
                                                  s0 = leftSupply s4
                                                  s1 = rightSupply s4
    in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` Curry_Prelude.nd_C_apply
    (nd_C_hcat s0 cd cs) (Curry_Prelude.OP_Cons x5 (Curry_Prelude.nd_C_map
    (wrapNX id (nd_OP_lt_gt x3)) x6 s1 cd cs)) s2 cd cs)))) s5 cd cs)) s7 cd
    cs))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C_hEncloseSep x1 x2 x3
    l s cd cs) (nd_C_hEncloseSep x1 x2 x3 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C_hEncloseSep
    x1 x2 x3 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C_hEncloseSep x1 x2 x3
    e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Pretty.hEncloseSep" [show x1, show x2, show x3, show x4] info)
  _ -> failCons cd (consFail "Pretty.hEncloseSep" (showCons x4))

d_C_fillEncloseSep :: C_Doc -> C_Doc -> C_Doc -> Curry_Prelude.OP_List C_Doc
  -> Cover -> ConstStore -> C_Doc
d_C_fillEncloseSep x1 x2 x3 x4 cd cs = case x4 of
  Curry_Prelude.OP_List -> d_OP_lt_gt x1 x2 cd cs
  Curry_Prelude.OP_Cons x5 x6 -> d_C_align (d_C_enclose x1 x2
    (Curry_Prelude.d_C_apply (d_C_fillCat cd cs) (Curry_Prelude.OP_Cons x5
    (Curry_Prelude.d_C_map (d_OP_lt_gt x3) x6 cd cs)) cd cs) cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_fillEncloseSep x1 x2
    x3 l cd cs) (d_C_fillEncloseSep x1 x2 x3 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_C_fillEncloseSep x1 x2 x3 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_fillEncloseSep x1 x2
    x3 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Pretty.fillEncloseSep" [show x1, show x2, show x3, show x4] info)
  _ -> failCons cd (consFail "Pretty.fillEncloseSep" (showCons x4))

nd_C_fillEncloseSep :: C_Doc -> C_Doc -> C_Doc -> Curry_Prelude.OP_List C_Doc
  -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_fillEncloseSep x1 x2 x3 x4 s cd cs = case x4 of
  Curry_Prelude.OP_List -> let s0 = s in s0 `seq` nd_OP_lt_gt x1 x2 s0 cd cs
  Curry_Prelude.OP_Cons x5 x6 -> let s8 = s
    in s8 `seq` (let s7 = leftSupply s8
                     s6 = rightSupply s8
    in s7 `seq` (s6 `seq` nd_C_align (let s5 = leftSupply s6
                                          s3 = rightSupply s6
    in s5 `seq` (s3 `seq` nd_C_enclose x1 x2 (let s2 = leftSupply s3
                                                  s4 = rightSupply s3
                                                  s0 = leftSupply s4
                                                  s1 = rightSupply s4
    in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` Curry_Prelude.nd_C_apply
    (nd_C_fillCat s0 cd cs) (Curry_Prelude.OP_Cons x5 (Curry_Prelude.nd_C_map
    (wrapNX id (nd_OP_lt_gt x3)) x6 s1 cd cs)) s2 cd cs)))) s5 cd cs)) s7 cd
    cs))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C_fillEncloseSep x1 x2
    x3 l s cd cs) (nd_C_fillEncloseSep x1 x2 x3 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    nd_C_fillEncloseSep x1 x2 x3 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C_fillEncloseSep x1 x2
    x3 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Pretty.fillEncloseSep" [show x1, show x2, show x3, show x4] info)
  _ -> failCons cd (consFail "Pretty.fillEncloseSep" (showCons x4))

d_C_fillEncloseSepSpaced :: C_Doc -> C_Doc -> C_Doc -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_Doc -> Cover -> ConstStore -> C_Doc
d_C_fillEncloseSepSpaced x1 x2 x3 cd cs = d_C_fillEncloseSep (d_OP_lt_gt x1
  (d_C_space cd cs) cd cs) (d_OP_lt_gt (d_C_space cd cs) x2 cd cs) (d_OP_lt_gt
  x3 (d_C_space cd cs) cd cs)

nd_C_fillEncloseSepSpaced :: C_Doc -> C_Doc -> C_Doc -> IDSupply -> Cover
  -> ConstStore -> Func (Curry_Prelude.OP_List C_Doc) C_Doc
nd_C_fillEncloseSepSpaced x1 x2 x3 s cd cs = let s9 = s
  in s9 `seq` (let s2 = leftSupply s9
                   s10 = rightSupply s9
                   s5 = leftSupply s10
                   s8 = rightSupply s10
  in s2 `seq` (s10 `seq` (s5 `seq` (s8 `seq` wrapNX id (nd_C_fillEncloseSep
  (let s1 = leftSupply s2
       s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_lt_gt x1 (nd_C_space s0 cd cs) s1 cd cs))
  (let s4 = leftSupply s5
       s3 = rightSupply s5
  in s4 `seq` (s3 `seq` nd_OP_lt_gt (nd_C_space s3 cd cs) x2 s4 cd cs))
  (let s7 = leftSupply s8
       s6 = rightSupply s8
  in s7 `seq` (s6 `seq` nd_OP_lt_gt x3 (nd_C_space s6 cd cs) s7 cd cs)))))))

d_C_list :: Cover -> ConstStore -> Curry_Prelude.OP_List C_Doc -> Cover
  -> ConstStore -> C_Doc
d_C_list cd cs = d_C_encloseSep (d_C_lbracket cd cs) (d_C_rbracket cd cs)
  (d_C_comma cd cs)

nd_C_list :: IDSupply -> Cover -> ConstStore -> Func (Curry_Prelude.OP_List
  C_Doc) C_Doc
nd_C_list s cd cs = let s3 = s
  in s3 `seq` (let s0 = leftSupply s3
                   s4 = rightSupply s3
                   s1 = leftSupply s4
                   s2 = rightSupply s4
  in s0 `seq` (s4 `seq` (s1 `seq` (s2 `seq` wrapNX id (nd_C_encloseSep
  (nd_C_lbracket s0 cd cs) (nd_C_rbracket s1 cd cs) (nd_C_comma s2 cd cs))))))

d_C_listSpaced :: Cover -> ConstStore -> Curry_Prelude.OP_List C_Doc -> Cover
  -> ConstStore -> C_Doc
d_C_listSpaced cd cs = d_C_encloseSepSpaced (d_C_lbracket cd cs) (d_C_rbracket
  cd cs) (d_C_comma cd cs) cd cs

nd_C_listSpaced :: IDSupply -> Cover -> ConstStore -> Func
  (Curry_Prelude.OP_List C_Doc) C_Doc
nd_C_listSpaced s cd cs = let s4 = s
  in s4 `seq` (let s5 = leftSupply s4
                   s6 = rightSupply s4
                   s3 = leftSupply s5
                   s0 = rightSupply s5
                   s1 = leftSupply s6
                   s2 = rightSupply s6
  in s5 `seq` (s6 `seq` (s3 `seq` (s0 `seq` (s1 `seq` (s2 `seq`
  nd_C_encloseSepSpaced (nd_C_lbracket s0 cd cs) (nd_C_rbracket s1 cd cs)
  (nd_C_comma s2 cd cs) s3 cd cs))))))

d_C_set :: Cover -> ConstStore -> Curry_Prelude.OP_List C_Doc -> Cover
  -> ConstStore -> C_Doc
d_C_set cd cs = d_C_encloseSep (d_C_lbrace cd cs) (d_C_rbrace cd cs) (d_C_comma
  cd cs)

nd_C_set :: IDSupply -> Cover -> ConstStore -> Func (Curry_Prelude.OP_List
  C_Doc) C_Doc
nd_C_set s cd cs = let s3 = s
  in s3 `seq` (let s0 = leftSupply s3
                   s4 = rightSupply s3
                   s1 = leftSupply s4
                   s2 = rightSupply s4
  in s0 `seq` (s4 `seq` (s1 `seq` (s2 `seq` wrapNX id (nd_C_encloseSep
  (nd_C_lbrace s0 cd cs) (nd_C_rbrace s1 cd cs) (nd_C_comma s2 cd cs))))))

d_C_setSpaced :: Cover -> ConstStore -> Curry_Prelude.OP_List C_Doc -> Cover
  -> ConstStore -> C_Doc
d_C_setSpaced cd cs = d_C_encloseSepSpaced (d_C_lbrace cd cs) (d_C_rbrace cd cs)
  (d_C_comma cd cs) cd cs

nd_C_setSpaced :: IDSupply -> Cover -> ConstStore -> Func (Curry_Prelude.OP_List
  C_Doc) C_Doc
nd_C_setSpaced s cd cs = let s4 = s
  in s4 `seq` (let s5 = leftSupply s4
                   s6 = rightSupply s4
                   s3 = leftSupply s5
                   s0 = rightSupply s5
                   s1 = leftSupply s6
                   s2 = rightSupply s6
  in s5 `seq` (s6 `seq` (s3 `seq` (s0 `seq` (s1 `seq` (s2 `seq`
  nd_C_encloseSepSpaced (nd_C_lbrace s0 cd cs) (nd_C_rbrace s1 cd cs)
  (nd_C_comma s2 cd cs) s3 cd cs))))))

d_C_tupled :: Cover -> ConstStore -> Curry_Prelude.OP_List C_Doc -> Cover
  -> ConstStore -> C_Doc
d_C_tupled cd cs = d_C_encloseSep (d_C_lparen cd cs) (d_C_rparen cd cs)
  (d_C_comma cd cs)

nd_C_tupled :: IDSupply -> Cover -> ConstStore -> Func (Curry_Prelude.OP_List
  C_Doc) C_Doc
nd_C_tupled s cd cs = let s3 = s
  in s3 `seq` (let s0 = leftSupply s3
                   s4 = rightSupply s3
                   s1 = leftSupply s4
                   s2 = rightSupply s4
  in s0 `seq` (s4 `seq` (s1 `seq` (s2 `seq` wrapNX id (nd_C_encloseSep
  (nd_C_lparen s0 cd cs) (nd_C_rparen s1 cd cs) (nd_C_comma s2 cd cs))))))

d_C_tupledSpaced :: Cover -> ConstStore -> Curry_Prelude.OP_List C_Doc -> Cover
  -> ConstStore -> C_Doc
d_C_tupledSpaced cd cs = d_C_encloseSepSpaced (d_C_lparen cd cs) (d_C_rparen cd
  cs) (d_C_comma cd cs) cd cs

nd_C_tupledSpaced :: IDSupply -> Cover -> ConstStore -> Func
  (Curry_Prelude.OP_List C_Doc) C_Doc
nd_C_tupledSpaced s cd cs = let s4 = s
  in s4 `seq` (let s5 = leftSupply s4
                   s6 = rightSupply s4
                   s3 = leftSupply s5
                   s0 = rightSupply s5
                   s1 = leftSupply s6
                   s2 = rightSupply s6
  in s5 `seq` (s6 `seq` (s3 `seq` (s0 `seq` (s1 `seq` (s2 `seq`
  nd_C_encloseSepSpaced (nd_C_lparen s0 cd cs) (nd_C_rparen s1 cd cs)
  (nd_C_comma s2 cd cs) s3 cd cs))))))

d_C_semiBraces :: Cover -> ConstStore -> Curry_Prelude.OP_List C_Doc -> Cover
  -> ConstStore -> C_Doc
d_C_semiBraces cd cs = d_C_encloseSep (d_C_lbrace cd cs) (d_C_rbrace cd cs)
  (d_C_semi cd cs)

nd_C_semiBraces :: IDSupply -> Cover -> ConstStore -> Func
  (Curry_Prelude.OP_List C_Doc) C_Doc
nd_C_semiBraces s cd cs = let s3 = s
  in s3 `seq` (let s0 = leftSupply s3
                   s4 = rightSupply s3
                   s1 = leftSupply s4
                   s2 = rightSupply s4
  in s0 `seq` (s4 `seq` (s1 `seq` (s2 `seq` wrapNX id (nd_C_encloseSep
  (nd_C_lbrace s0 cd cs) (nd_C_rbrace s1 cd cs) (nd_C_semi s2 cd cs))))))

d_C_semiBracesSpaced :: Cover -> ConstStore -> Curry_Prelude.OP_List C_Doc
  -> Cover -> ConstStore -> C_Doc
d_C_semiBracesSpaced cd cs = d_C_encloseSepSpaced (d_C_lbrace cd cs) (d_C_rbrace
  cd cs) (d_C_semi cd cs) cd cs

nd_C_semiBracesSpaced :: IDSupply -> Cover -> ConstStore -> Func
  (Curry_Prelude.OP_List C_Doc) C_Doc
nd_C_semiBracesSpaced s cd cs = let s4 = s
  in s4 `seq` (let s5 = leftSupply s4
                   s6 = rightSupply s4
                   s3 = leftSupply s5
                   s0 = rightSupply s5
                   s1 = leftSupply s6
                   s2 = rightSupply s6
  in s5 `seq` (s6 `seq` (s3 `seq` (s0 `seq` (s1 `seq` (s2 `seq`
  nd_C_encloseSepSpaced (nd_C_lbrace s0 cd cs) (nd_C_rbrace s1 cd cs) (nd_C_semi
  s2 cd cs) s3 cd cs))))))

d_C_enclose :: C_Doc -> C_Doc -> C_Doc -> Cover -> ConstStore -> C_Doc
d_C_enclose x1 x2 x3 cd cs = d_OP_lt_gt (d_OP_lt_gt x1 x3 cd cs) x2 cd cs

nd_C_enclose :: C_Doc -> C_Doc -> C_Doc -> IDSupply -> Cover -> ConstStore
  -> C_Doc
nd_C_enclose x1 x2 x3 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_lt_gt (nd_OP_lt_gt x1 x3 s0 cd cs) x2 s1 cd cs))

d_C_squotes :: Cover -> ConstStore -> C_Doc -> Cover -> ConstStore -> C_Doc
d_C_squotes cd cs = d_C_enclose (d_C_squote cd cs) (d_C_squote cd cs)

nd_C_squotes :: IDSupply -> Cover -> ConstStore -> Func C_Doc C_Doc
nd_C_squotes s cd cs = let s2 = s
  in s2 `seq` (let s0 = leftSupply s2
                   s1 = rightSupply s2
  in s0 `seq` (s1 `seq` wrapNX id (nd_C_enclose (nd_C_squote s0 cd cs)
  (nd_C_squote s1 cd cs))))

d_C_dquotes :: Cover -> ConstStore -> C_Doc -> Cover -> ConstStore -> C_Doc
d_C_dquotes cd cs = d_C_enclose (d_C_dquote cd cs) (d_C_dquote cd cs)

nd_C_dquotes :: IDSupply -> Cover -> ConstStore -> Func C_Doc C_Doc
nd_C_dquotes s cd cs = let s2 = s
  in s2 `seq` (let s0 = leftSupply s2
                   s1 = rightSupply s2
  in s0 `seq` (s1 `seq` wrapNX id (nd_C_enclose (nd_C_dquote s0 cd cs)
  (nd_C_dquote s1 cd cs))))

d_C_bquotes :: Cover -> ConstStore -> C_Doc -> Cover -> ConstStore -> C_Doc
d_C_bquotes cd cs = d_C_enclose (d_C_bquote cd cs) (d_C_bquote cd cs)

nd_C_bquotes :: IDSupply -> Cover -> ConstStore -> Func C_Doc C_Doc
nd_C_bquotes s cd cs = let s2 = s
  in s2 `seq` (let s0 = leftSupply s2
                   s1 = rightSupply s2
  in s0 `seq` (s1 `seq` wrapNX id (nd_C_enclose (nd_C_bquote s0 cd cs)
  (nd_C_bquote s1 cd cs))))

d_C_parens :: Cover -> ConstStore -> C_Doc -> Cover -> ConstStore -> C_Doc
d_C_parens cd cs = d_C_enclose (d_C_lparen cd cs) (d_C_rparen cd cs)

nd_C_parens :: IDSupply -> Cover -> ConstStore -> Func C_Doc C_Doc
nd_C_parens s cd cs = let s2 = s
  in s2 `seq` (let s0 = leftSupply s2
                   s1 = rightSupply s2
  in s0 `seq` (s1 `seq` wrapNX id (nd_C_enclose (nd_C_lparen s0 cd cs)
  (nd_C_rparen s1 cd cs))))

d_C_parensIf :: Curry_Prelude.C_Bool -> C_Doc -> Cover -> ConstStore -> C_Doc
d_C_parensIf x1 x2 cd cs = case x1 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (d_C_parens cd cs) x2 cd cs
  Curry_Prelude.C_False -> x2
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C_parensIf l x2 cd cs)
    (d_C_parensIf r x2 cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C_parensIf z x2
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C_parensIf e x2 cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty.parensIf"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Pretty.parensIf" (showCons x1))

nd_C_parensIf :: Curry_Prelude.C_Bool -> C_Doc -> IDSupply -> Cover
  -> ConstStore -> C_Doc
nd_C_parensIf x1 x2 s cd cs = case x1 of
  Curry_Prelude.C_True -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (nd_C_parens s0 cd cs) x2 s1
    cd cs))
  Curry_Prelude.C_False -> x2
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C_parensIf l x2 s cd cs)
    (nd_C_parensIf r x2 s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C_parensIf z
    x2 s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C_parensIf e x2 s cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty.parensIf"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Pretty.parensIf" (showCons x1))

d_C_angles :: Cover -> ConstStore -> C_Doc -> Cover -> ConstStore -> C_Doc
d_C_angles cd cs = d_C_enclose (d_C_langle cd cs) (d_C_rangle cd cs)

nd_C_angles :: IDSupply -> Cover -> ConstStore -> Func C_Doc C_Doc
nd_C_angles s cd cs = let s2 = s
  in s2 `seq` (let s0 = leftSupply s2
                   s1 = rightSupply s2
  in s0 `seq` (s1 `seq` wrapNX id (nd_C_enclose (nd_C_langle s0 cd cs)
  (nd_C_rangle s1 cd cs))))

d_C_braces :: Cover -> ConstStore -> C_Doc -> Cover -> ConstStore -> C_Doc
d_C_braces cd cs = d_C_enclose (d_C_lbrace cd cs) (d_C_rbrace cd cs)

nd_C_braces :: IDSupply -> Cover -> ConstStore -> Func C_Doc C_Doc
nd_C_braces s cd cs = let s2 = s
  in s2 `seq` (let s0 = leftSupply s2
                   s1 = rightSupply s2
  in s0 `seq` (s1 `seq` wrapNX id (nd_C_enclose (nd_C_lbrace s0 cd cs)
  (nd_C_rbrace s1 cd cs))))

d_C_brackets :: Cover -> ConstStore -> C_Doc -> Cover -> ConstStore -> C_Doc
d_C_brackets cd cs = d_C_enclose (d_C_lbracket cd cs) (d_C_rbracket cd cs)

nd_C_brackets :: IDSupply -> Cover -> ConstStore -> Func C_Doc C_Doc
nd_C_brackets s cd cs = let s2 = s
  in s2 `seq` (let s0 = leftSupply s2
                   s1 = rightSupply s2
  in s0 `seq` (s1 `seq` wrapNX id (nd_C_enclose (nd_C_lbracket s0 cd cs)
  (nd_C_rbracket s1 cd cs))))

d_C_char :: Curry_Prelude.C_Char -> Cover -> ConstStore -> C_Doc
d_C_char x1 cd cs = d_C_text (Curry_Prelude.OP_Cons x1 Curry_Prelude.OP_List) cd
  cs

nd_C_char :: Curry_Prelude.C_Char -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_char x1 s cd cs = let s0 = s
  in s0 `seq` nd_C_text (Curry_Prelude.OP_Cons x1 Curry_Prelude.OP_List) s0 cd
  cs

d_C_string :: Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> C_Doc
d_C_string cd cs = Curry_Prelude.d_OP_dot (d_C_hcat cd cs)
  (Curry_Prelude.d_C_map d_OP_string_dot_uscore_hash_lambda2) cd cs

nd_C_string :: IDSupply -> Cover -> ConstStore -> Func (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) C_Doc
nd_C_string s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (nd_C_hcat s0 cd cs) (wrapNX id
  (Curry_Prelude.nd_C_map (wrapNX id nd_OP_string_dot_uscore_hash_lambda2))) s1
  cd cs))

d_OP_string_dot_uscore_hash_lambda2 :: Curry_Prelude.C_Char -> Cover
  -> ConstStore -> C_Doc
d_OP_string_dot_uscore_hash_lambda2 x1 cd cs = d_C__case_34 x1
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_elem
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) x1 cd cs) (Curry_Prelude.toCurryString "\n\r") cd cs) cd cs

nd_OP_string_dot_uscore_hash_lambda2 :: Curry_Prelude.C_Char -> IDSupply
  -> Cover -> ConstStore -> C_Doc
nd_OP_string_dot_uscore_hash_lambda2 x1 s cd cs = let s6 = s
  in s6 `seq` (let s5 = leftSupply s6
                   s4 = rightSupply s6
  in s5 `seq` (s4 `seq` nd_C__case_34 x1 (let s3 = leftSupply s4
                                              s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                      s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_elem
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char s0
  cd cs) x1 s1 cd cs)) (Curry_Prelude.toCurryString "\n\r") s3 cd cs)) s5 cd
  cs))

d_C_int :: Curry_Prelude.C_Int -> Cover -> ConstStore -> C_Doc
d_C_int x1 cd cs = d_C_text (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Int
  cd cs) x1 cd cs) cd cs

nd_C_int :: Curry_Prelude.C_Int -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_int x1 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_C_text (Curry_Prelude.nd_C_apply (wrapDX id
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Int
  cd cs)) x1 s0 cd cs) s1 cd cs))

d_C_float :: Curry_Prelude.C_Float -> Cover -> ConstStore -> C_Doc
d_C_float x1 cd cs = d_C_text (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Float
  cd cs) x1 cd cs) cd cs

nd_C_float :: Curry_Prelude.C_Float -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_float x1 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_C_text (Curry_Prelude.nd_C_apply (wrapDX id
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Float
  cd cs)) x1 s0 cd cs) s1 cd cs))

d_C_lparen :: Cover -> ConstStore -> C_Doc
d_C_lparen cd cs = d_C_char (Curry_Prelude.C_Char '('#) cd cs

nd_C_lparen :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_lparen s cd cs = let s0 = s
  in s0 `seq` nd_C_char (Curry_Prelude.C_Char '('#) s0 cd cs

d_C_rparen :: Cover -> ConstStore -> C_Doc
d_C_rparen cd cs = d_C_char (Curry_Prelude.C_Char ')'#) cd cs

nd_C_rparen :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_rparen s cd cs = let s0 = s
  in s0 `seq` nd_C_char (Curry_Prelude.C_Char ')'#) s0 cd cs

d_C_langle :: Cover -> ConstStore -> C_Doc
d_C_langle cd cs = d_C_char (Curry_Prelude.C_Char '<'#) cd cs

nd_C_langle :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_langle s cd cs = let s0 = s
  in s0 `seq` nd_C_char (Curry_Prelude.C_Char '<'#) s0 cd cs

d_C_rangle :: Cover -> ConstStore -> C_Doc
d_C_rangle cd cs = d_C_char (Curry_Prelude.C_Char '>'#) cd cs

nd_C_rangle :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_rangle s cd cs = let s0 = s
  in s0 `seq` nd_C_char (Curry_Prelude.C_Char '>'#) s0 cd cs

d_C_lbrace :: Cover -> ConstStore -> C_Doc
d_C_lbrace cd cs = d_C_char (Curry_Prelude.C_Char '{'#) cd cs

nd_C_lbrace :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_lbrace s cd cs = let s0 = s
  in s0 `seq` nd_C_char (Curry_Prelude.C_Char '{'#) s0 cd cs

d_C_rbrace :: Cover -> ConstStore -> C_Doc
d_C_rbrace cd cs = d_C_char (Curry_Prelude.C_Char '}'#) cd cs

nd_C_rbrace :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_rbrace s cd cs = let s0 = s
  in s0 `seq` nd_C_char (Curry_Prelude.C_Char '}'#) s0 cd cs

d_C_lbracket :: Cover -> ConstStore -> C_Doc
d_C_lbracket cd cs = d_C_char (Curry_Prelude.C_Char '['#) cd cs

nd_C_lbracket :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_lbracket s cd cs = let s0 = s
  in s0 `seq` nd_C_char (Curry_Prelude.C_Char '['#) s0 cd cs

d_C_rbracket :: Cover -> ConstStore -> C_Doc
d_C_rbracket cd cs = d_C_char (Curry_Prelude.C_Char ']'#) cd cs

nd_C_rbracket :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_rbracket s cd cs = let s0 = s
  in s0 `seq` nd_C_char (Curry_Prelude.C_Char ']'#) s0 cd cs

d_C_squote :: Cover -> ConstStore -> C_Doc
d_C_squote cd cs = d_C_char (Curry_Prelude.C_Char '\''#) cd cs

nd_C_squote :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_squote s cd cs = let s0 = s
  in s0 `seq` nd_C_char (Curry_Prelude.C_Char '\''#) s0 cd cs

d_C_dquote :: Cover -> ConstStore -> C_Doc
d_C_dquote cd cs = d_C_char (Curry_Prelude.C_Char '"'#) cd cs

nd_C_dquote :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_dquote s cd cs = let s0 = s
  in s0 `seq` nd_C_char (Curry_Prelude.C_Char '"'#) s0 cd cs

d_C_bquote :: Cover -> ConstStore -> C_Doc
d_C_bquote cd cs = d_C_char (Curry_Prelude.C_Char '`'#) cd cs

nd_C_bquote :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_bquote s cd cs = let s0 = s
  in s0 `seq` nd_C_char (Curry_Prelude.C_Char '`'#) s0 cd cs

d_C_semi :: Cover -> ConstStore -> C_Doc
d_C_semi cd cs = d_C_char (Curry_Prelude.C_Char ';'#) cd cs

nd_C_semi :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_semi s cd cs = let s0 = s
  in s0 `seq` nd_C_char (Curry_Prelude.C_Char ';'#) s0 cd cs

d_C_colon :: Cover -> ConstStore -> C_Doc
d_C_colon cd cs = d_C_char (Curry_Prelude.C_Char ':'#) cd cs

nd_C_colon :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_colon s cd cs = let s0 = s
  in s0 `seq` nd_C_char (Curry_Prelude.C_Char ':'#) s0 cd cs

d_C_comma :: Cover -> ConstStore -> C_Doc
d_C_comma cd cs = d_C_char (Curry_Prelude.C_Char ','#) cd cs

nd_C_comma :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_comma s cd cs = let s0 = s
  in s0 `seq` nd_C_char (Curry_Prelude.C_Char ','#) s0 cd cs

d_C_space :: Cover -> ConstStore -> C_Doc
d_C_space cd cs = d_C_char (Curry_Prelude.C_Char ' '#) cd cs

nd_C_space :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_space s cd cs = let s0 = s
  in s0 `seq` nd_C_char (Curry_Prelude.C_Char ' '#) s0 cd cs

d_C_spaces :: Curry_Prelude.C_Int -> Cover -> ConstStore -> C_Doc
d_C_spaces x1 cd cs = d_C__case_33 x1
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
  x1 (Curry_Prelude.C_Int (0)) cd cs) cd cs

nd_C_spaces :: Curry_Prelude.C_Int -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_spaces x1 s cd cs = let s0 = s
  in s0 `seq` nd_C__case_33 x1
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
  x1 (Curry_Prelude.C_Int (0)) cd cs) s0 cd cs

d_C_dot :: Cover -> ConstStore -> C_Doc
d_C_dot cd cs = d_C_char (Curry_Prelude.C_Char '.'#) cd cs

nd_C_dot :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_dot s cd cs = let s0 = s
  in s0 `seq` nd_C_char (Curry_Prelude.C_Char '.'#) s0 cd cs

d_C_backslash :: Cover -> ConstStore -> C_Doc
d_C_backslash cd cs = d_C_char (Curry_Prelude.C_Char '\\'#) cd cs

nd_C_backslash :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_backslash s cd cs = let s0 = s
  in s0 `seq` nd_C_char (Curry_Prelude.C_Char '\\'#) s0 cd cs

d_C_equals :: Cover -> ConstStore -> C_Doc
d_C_equals cd cs = d_C_char (Curry_Prelude.C_Char '='#) cd cs

nd_C_equals :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_equals s cd cs = let s0 = s
  in s0 `seq` nd_C_char (Curry_Prelude.C_Char '='#) s0 cd cs

d_C_larrow :: Cover -> ConstStore -> C_Doc
d_C_larrow cd cs = d_C_text (Curry_Prelude.toCurryString "<-") cd cs

nd_C_larrow :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_larrow s cd cs = let s0 = s
  in s0 `seq` nd_C_text (Curry_Prelude.toCurryString "<-") s0 cd cs

d_C_rarrow :: Cover -> ConstStore -> C_Doc
d_C_rarrow cd cs = d_C_text (Curry_Prelude.toCurryString "->") cd cs

nd_C_rarrow :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_rarrow s cd cs = let s0 = s
  in s0 `seq` nd_C_text (Curry_Prelude.toCurryString "->") s0 cd cs

d_C_doubleArrow :: Cover -> ConstStore -> C_Doc
d_C_doubleArrow cd cs = d_C_text (Curry_Prelude.toCurryString "=>") cd cs

nd_C_doubleArrow :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_doubleArrow s cd cs = let s0 = s
  in s0 `seq` nd_C_text (Curry_Prelude.toCurryString "=>") s0 cd cs

d_C_doubleColon :: Cover -> ConstStore -> C_Doc
d_C_doubleColon cd cs = d_C_text (Curry_Prelude.toCurryString "::") cd cs

nd_C_doubleColon :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_doubleColon s cd cs = let s0 = s
  in s0 `seq` nd_C_text (Curry_Prelude.toCurryString "::") s0 cd cs

d_C_bar :: Cover -> ConstStore -> C_Doc
d_C_bar cd cs = d_C_char (Curry_Prelude.C_Char '|'#) cd cs

nd_C_bar :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_bar s cd cs = let s0 = s
  in s0 `seq` nd_C_char (Curry_Prelude.C_Char '|'#) s0 cd cs

d_C_at :: Cover -> ConstStore -> C_Doc
d_C_at cd cs = d_C_char (Curry_Prelude.C_Char '@'#) cd cs

nd_C_at :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_at s cd cs = let s0 = s
  in s0 `seq` nd_C_char (Curry_Prelude.C_Char '@'#) s0 cd cs

d_C_tilde :: Cover -> ConstStore -> C_Doc
d_C_tilde cd cs = d_C_char (Curry_Prelude.C_Char '~'#) cd cs

nd_C_tilde :: IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_tilde s cd cs = let s0 = s
  in s0 `seq` nd_C_char (Curry_Prelude.C_Char '~'#) s0 cd cs

d_C_fill :: Curry_Prelude.C_Int -> C_Doc -> Cover -> ConstStore -> C_Doc
d_C_fill x1 x2 cd cs = let x3 = d_C_width x2 cd cs
                           x4 = d_C__case_31 x1 x3 (Curry_Prelude.d_C_apply
                             (Curry_Prelude.d_C_apply
                             (Curry_Prelude.d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
                             cd cs) x3 cd cs) x1 cd cs) cd cs
  in d_OP_lt_gt x2 x4 cd cs

nd_C_fill :: Curry_Prelude.C_Int -> C_Doc -> IDSupply -> Cover -> ConstStore
  -> C_Doc
nd_C_fill x1 x2 s cd cs = let s7 = s
  in s7 `seq` (let s0 = leftSupply s7
                   s8 = rightSupply s7
                   s5 = leftSupply s8
                   s6 = rightSupply s8
  in s0 `seq` (s8 `seq` (s5 `seq` (s6 `seq` (let x3 = nd_C_width x2 s0 cd cs
                                                 x4 = let s4 = leftSupply s5
                                                          s3 = rightSupply s5
                                                   in s4 `seq` (s3 `seq`
                                                   nd_C__case_31 x1 x3
                                                   (let s2 = leftSupply s3
                                                        s1 = rightSupply s3
                                                   in s2 `seq` (s1 `seq`
                                                   Curry_Prelude.nd_C_apply
                                                   (Curry_Prelude.nd_C_apply
                                                   (wrapDX (wrapDX id)
                                                   (Curry_Prelude.d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
                                                   cd cs)) x3 s1 cd cs) x1 s2 cd
                                                   cs)) s4 cd cs)
  in nd_OP_lt_gt x2 x4 s6 cd cs)))))

d_C_fillBreak :: Curry_Prelude.C_Int -> C_Doc -> Cover -> ConstStore -> C_Doc
d_C_fillBreak x1 x2 cd cs = let x3 = d_C_width x2 cd cs
                                x4 = d_C__case_30 x1 x3 (Curry_Prelude.d_C_apply
                                  (Curry_Prelude.d_C_apply
                                  (Curry_Prelude.d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
                                  cd cs) x3 cd cs) x1 cd cs) cd cs
  in d_OP_lt_gt x2 x4 cd cs

nd_C_fillBreak :: Curry_Prelude.C_Int -> C_Doc -> IDSupply -> Cover
  -> ConstStore -> C_Doc
nd_C_fillBreak x1 x2 s cd cs = let s7 = s
  in s7 `seq` (let s0 = leftSupply s7
                   s8 = rightSupply s7
                   s5 = leftSupply s8
                   s6 = rightSupply s8
  in s0 `seq` (s8 `seq` (s5 `seq` (s6 `seq` (let x3 = nd_C_width x2 s0 cd cs
                                                 x4 = let s4 = leftSupply s5
                                                          s3 = rightSupply s5
                                                   in s4 `seq` (s3 `seq`
                                                   nd_C__case_30 x1 x3
                                                   (let s2 = leftSupply s3
                                                        s1 = rightSupply s3
                                                   in s2 `seq` (s1 `seq`
                                                   Curry_Prelude.nd_C_apply
                                                   (Curry_Prelude.nd_C_apply
                                                   (wrapDX (wrapDX id)
                                                   (Curry_Prelude.d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
                                                   cd cs)) x3 s1 cd cs) x1 s2 cd
                                                   cs)) s4 cd cs)
  in nd_OP_lt_gt x2 x4 s6 cd cs)))))

d_C_width :: C_Doc -> Cover -> ConstStore -> Curry_Prelude.C_Int
d_C_width x1 cd cs = case x1 of
  C_Doc x2 -> d_OP_width_dot_width_tick_dot_216 (Curry_Prelude.C_Int (0))
    (Curry_Prelude.d_C_apply x2 C_EOD cd cs) cd cs
  Choice_C_Doc d i l r -> narrow d i (d_C_width l cd cs) (d_C_width r cd cs)
  Choices_C_Doc d i xs -> narrows cs d i (\z -> d_C_width z cd cs) xs
  Guard_C_Doc d c e -> guardCons d c (d_C_width e cd $! addCs c cs)
  Fail_C_Doc d info -> failCons d (traceFail "Pretty.width" [show x1] info)
  _ -> failCons cd (consFail "Pretty.width" (showCons x1))

nd_C_width :: C_Doc -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.C_Int
nd_C_width x1 s cd cs = case x1 of
  HO_C_Doc x2 -> let s0 = s
    in s0 `seq` d_OP_width_dot_width_tick_dot_216 (Curry_Prelude.C_Int (0))
    (Curry_Prelude.nd_C_apply x2 C_EOD s0 cd cs) cd cs
  Choice_C_Doc d i l r -> narrow d i (nd_C_width l s cd cs) (nd_C_width r s cd
    cs)
  Choices_C_Doc d i xs -> narrows cs d i (\z -> nd_C_width z s cd cs) xs
  Guard_C_Doc d c e -> guardCons d c (nd_C_width e s cd $! addCs c cs)
  Fail_C_Doc d info -> failCons d (traceFail "Pretty.width" [show x1] info)
  _ -> failCons cd (consFail "Pretty.width" (showCons x1))

d_OP_width_dot_width_tick_dot_216 :: Curry_Prelude.C_Int -> C_Tokens -> Cover
  -> ConstStore -> Curry_Prelude.C_Int
d_OP_width_dot_width_tick_dot_216 x1 x2 cd cs = case x2 of
  C_EOD -> x1
  C_Empty x3 -> d_OP_width_dot_width_tick_dot_216 x1 x3 cd cs
  C_Text x4 x5 -> d_OP_width_dot_width_tick_dot_216
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x1 (Curry_Prelude.d_C_apply (d_C_length cd cs) x4 cd cs) cd cs) x5 cd cs
  C_LineBreak x6 x7 -> d_C__case_29 x7 x1 x6 cd cs
  C_OpenGroup x9 -> d_OP_width_dot_width_tick_dot_216 x1 x9 cd cs
  C_CloseGroup x10 -> d_OP_width_dot_width_tick_dot_216 x1 x10 cd cs
  C_OpenNest x11 x12 -> d_OP_width_dot_width_tick_dot_216 x1 x12 cd cs
  C_CloseNest x13 -> d_OP_width_dot_width_tick_dot_216 x1 x13 cd cs
  C_OpenFormat x14 x15 -> d_OP_width_dot_width_tick_dot_216 x1 x15 cd cs
  C_CloseFormat x16 -> d_OP_width_dot_width_tick_dot_216 x1 x16 cd cs
  Choice_C_Tokens d i l r -> narrow d i (d_OP_width_dot_width_tick_dot_216 x1 l
    cd cs) (d_OP_width_dot_width_tick_dot_216 x1 r cd cs)
  Choices_C_Tokens d i xs -> narrows cs d i (\z ->
    d_OP_width_dot_width_tick_dot_216 x1 z cd cs) xs
  Guard_C_Tokens d c e -> guardCons d c (d_OP_width_dot_width_tick_dot_216 x1 e
    cd $! addCs c cs)
  Fail_C_Tokens d info -> failCons d (traceFail "Pretty.width.width'.216" [show
    x1, show x2] info)
  _ -> failCons cd (consFail "Pretty.width.width'.216" (showCons x2))

d_C_bold :: C_Doc -> Cover -> ConstStore -> C_Doc
d_C_bold x1 cd cs = C_Doc (Curry_Prelude.d_OP_dot (acceptCs id (C_OpenFormat
  (C_SetIntensity C_Bold))) (Curry_Prelude.d_OP_dot (d_C_deDoc x1 cd cs)
  (acceptCs id C_CloseFormat) cd cs) cd cs)

nd_C_bold :: C_Doc -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_bold x1 s cd cs = let s4 = s
  in s4 `seq` HO_C_Doc (let s3 = leftSupply s4
                            s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  (C_OpenFormat (C_SetIntensity C_Bold)))) (let s1 = leftSupply s2
                                                s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (nd_C_deDoc x1 s0 cd cs) (wrapDX
  id (acceptCs id C_CloseFormat)) s1 cd cs)) s3 cd cs))

d_C_faint :: C_Doc -> Cover -> ConstStore -> C_Doc
d_C_faint x1 cd cs = C_Doc (Curry_Prelude.d_OP_dot (acceptCs id (C_OpenFormat
  (C_SetIntensity C_Faint))) (Curry_Prelude.d_OP_dot (d_C_deDoc x1 cd cs)
  (acceptCs id C_CloseFormat) cd cs) cd cs)

nd_C_faint :: C_Doc -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_faint x1 s cd cs = let s4 = s
  in s4 `seq` HO_C_Doc (let s3 = leftSupply s4
                            s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  (C_OpenFormat (C_SetIntensity C_Faint)))) (let s1 = leftSupply s2
                                                 s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (nd_C_deDoc x1 s0 cd cs) (wrapDX
  id (acceptCs id C_CloseFormat)) s1 cd cs)) s3 cd cs))

d_C_blinkSlow :: C_Doc -> Cover -> ConstStore -> C_Doc
d_C_blinkSlow x1 cd cs = C_Doc (Curry_Prelude.d_OP_dot (acceptCs id
  (C_OpenFormat (C_SetBlinkMode C_Slow))) (Curry_Prelude.d_OP_dot (d_C_deDoc x1
  cd cs) (acceptCs id C_CloseFormat) cd cs) cd cs)

nd_C_blinkSlow :: C_Doc -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_blinkSlow x1 s cd cs = let s4 = s
  in s4 `seq` HO_C_Doc (let s3 = leftSupply s4
                            s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  (C_OpenFormat (C_SetBlinkMode C_Slow)))) (let s1 = leftSupply s2
                                                s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (nd_C_deDoc x1 s0 cd cs) (wrapDX
  id (acceptCs id C_CloseFormat)) s1 cd cs)) s3 cd cs))

d_C_blinkRapid :: C_Doc -> Cover -> ConstStore -> C_Doc
d_C_blinkRapid x1 cd cs = C_Doc (Curry_Prelude.d_OP_dot (acceptCs id
  (C_OpenFormat (C_SetBlinkMode C_Rapid))) (Curry_Prelude.d_OP_dot (d_C_deDoc x1
  cd cs) (acceptCs id C_CloseFormat) cd cs) cd cs)

nd_C_blinkRapid :: C_Doc -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_blinkRapid x1 s cd cs = let s4 = s
  in s4 `seq` HO_C_Doc (let s3 = leftSupply s4
                            s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  (C_OpenFormat (C_SetBlinkMode C_Rapid)))) (let s1 = leftSupply s2
                                                 s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (nd_C_deDoc x1 s0 cd cs) (wrapDX
  id (acceptCs id C_CloseFormat)) s1 cd cs)) s3 cd cs))

d_C_italic :: C_Doc -> Cover -> ConstStore -> C_Doc
d_C_italic x1 cd cs = C_Doc (Curry_Prelude.d_OP_dot (acceptCs id (C_OpenFormat
  (C_SetItalicized Curry_Prelude.C_True))) (Curry_Prelude.d_OP_dot (d_C_deDoc x1
  cd cs) (acceptCs id C_CloseFormat) cd cs) cd cs)

nd_C_italic :: C_Doc -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_italic x1 s cd cs = let s4 = s
  in s4 `seq` HO_C_Doc (let s3 = leftSupply s4
                            s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  (C_OpenFormat (C_SetItalicized Curry_Prelude.C_True)))) (let s1 = leftSupply
                                                                 s2
                                                               s0 = rightSupply
                                                                 s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (nd_C_deDoc x1 s0 cd cs) (wrapDX
  id (acceptCs id C_CloseFormat)) s1 cd cs)) s3 cd cs))

d_C_underline :: C_Doc -> Cover -> ConstStore -> C_Doc
d_C_underline x1 cd cs = C_Doc (Curry_Prelude.d_OP_dot (acceptCs id
  (C_OpenFormat (C_SetUnderlined Curry_Prelude.C_True))) (Curry_Prelude.d_OP_dot
  (d_C_deDoc x1 cd cs) (acceptCs id C_CloseFormat) cd cs) cd cs)

nd_C_underline :: C_Doc -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_underline x1 s cd cs = let s4 = s
  in s4 `seq` HO_C_Doc (let s3 = leftSupply s4
                            s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  (C_OpenFormat (C_SetUnderlined Curry_Prelude.C_True)))) (let s1 = leftSupply
                                                                 s2
                                                               s0 = rightSupply
                                                                 s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (nd_C_deDoc x1 s0 cd cs) (wrapDX
  id (acceptCs id C_CloseFormat)) s1 cd cs)) s3 cd cs))

d_C_crossout :: C_Doc -> Cover -> ConstStore -> C_Doc
d_C_crossout x1 cd cs = C_Doc (Curry_Prelude.d_OP_dot (acceptCs id (C_OpenFormat
  (C_SetCrossedout Curry_Prelude.C_True))) (Curry_Prelude.d_OP_dot (d_C_deDoc x1
  cd cs) (acceptCs id C_CloseFormat) cd cs) cd cs)

nd_C_crossout :: C_Doc -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_crossout x1 s cd cs = let s4 = s
  in s4 `seq` HO_C_Doc (let s3 = leftSupply s4
                            s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  (C_OpenFormat (C_SetCrossedout Curry_Prelude.C_True)))) (let s1 = leftSupply
                                                                 s2
                                                               s0 = rightSupply
                                                                 s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (nd_C_deDoc x1 s0 cd cs) (wrapDX
  id (acceptCs id C_CloseFormat)) s1 cd cs)) s3 cd cs))

d_C_inverse :: C_Doc -> Cover -> ConstStore -> C_Doc
d_C_inverse x1 cd cs = C_Doc (Curry_Prelude.d_OP_dot (acceptCs id (C_OpenFormat
  (C_InverseColoring Curry_Prelude.C_True))) (Curry_Prelude.d_OP_dot (d_C_deDoc
  x1 cd cs) (acceptCs id C_CloseFormat) cd cs) cd cs)

nd_C_inverse :: C_Doc -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_inverse x1 s cd cs = let s4 = s
  in s4 `seq` HO_C_Doc (let s3 = leftSupply s4
                            s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  (C_OpenFormat (C_InverseColoring Curry_Prelude.C_True)))) (let s1 = leftSupply
                                                                   s2
                                                                 s0 = rightSupply
                                                                   s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (nd_C_deDoc x1 s0 cd cs) (wrapDX
  id (acceptCs id C_CloseFormat)) s1 cd cs)) s3 cd cs))

d_C_black :: C_Doc -> Cover -> ConstStore -> C_Doc
d_C_black x1 cd cs = C_Doc (Curry_Prelude.d_OP_dot (acceptCs id (C_OpenFormat
  (C_SetForeground C_Black))) (Curry_Prelude.d_OP_dot (d_C_deDoc x1 cd cs)
  (acceptCs id C_CloseFormat) cd cs) cd cs)

nd_C_black :: C_Doc -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_black x1 s cd cs = let s4 = s
  in s4 `seq` HO_C_Doc (let s3 = leftSupply s4
                            s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  (C_OpenFormat (C_SetForeground C_Black)))) (let s1 = leftSupply s2
                                                  s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (nd_C_deDoc x1 s0 cd cs) (wrapDX
  id (acceptCs id C_CloseFormat)) s1 cd cs)) s3 cd cs))

d_C_red :: C_Doc -> Cover -> ConstStore -> C_Doc
d_C_red x1 cd cs = C_Doc (Curry_Prelude.d_OP_dot (acceptCs id (C_OpenFormat
  (C_SetForeground C_Red))) (Curry_Prelude.d_OP_dot (d_C_deDoc x1 cd cs)
  (acceptCs id C_CloseFormat) cd cs) cd cs)

nd_C_red :: C_Doc -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_red x1 s cd cs = let s4 = s
  in s4 `seq` HO_C_Doc (let s3 = leftSupply s4
                            s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  (C_OpenFormat (C_SetForeground C_Red)))) (let s1 = leftSupply s2
                                                s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (nd_C_deDoc x1 s0 cd cs) (wrapDX
  id (acceptCs id C_CloseFormat)) s1 cd cs)) s3 cd cs))

d_C_green :: C_Doc -> Cover -> ConstStore -> C_Doc
d_C_green x1 cd cs = C_Doc (Curry_Prelude.d_OP_dot (acceptCs id (C_OpenFormat
  (C_SetForeground C_Green))) (Curry_Prelude.d_OP_dot (d_C_deDoc x1 cd cs)
  (acceptCs id C_CloseFormat) cd cs) cd cs)

nd_C_green :: C_Doc -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_green x1 s cd cs = let s4 = s
  in s4 `seq` HO_C_Doc (let s3 = leftSupply s4
                            s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  (C_OpenFormat (C_SetForeground C_Green)))) (let s1 = leftSupply s2
                                                  s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (nd_C_deDoc x1 s0 cd cs) (wrapDX
  id (acceptCs id C_CloseFormat)) s1 cd cs)) s3 cd cs))

d_C_yellow :: C_Doc -> Cover -> ConstStore -> C_Doc
d_C_yellow x1 cd cs = C_Doc (Curry_Prelude.d_OP_dot (acceptCs id (C_OpenFormat
  (C_SetForeground C_Yellow))) (Curry_Prelude.d_OP_dot (d_C_deDoc x1 cd cs)
  (acceptCs id C_CloseFormat) cd cs) cd cs)

nd_C_yellow :: C_Doc -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_yellow x1 s cd cs = let s4 = s
  in s4 `seq` HO_C_Doc (let s3 = leftSupply s4
                            s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  (C_OpenFormat (C_SetForeground C_Yellow)))) (let s1 = leftSupply s2
                                                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (nd_C_deDoc x1 s0 cd cs) (wrapDX
  id (acceptCs id C_CloseFormat)) s1 cd cs)) s3 cd cs))

d_C_blue :: C_Doc -> Cover -> ConstStore -> C_Doc
d_C_blue x1 cd cs = C_Doc (Curry_Prelude.d_OP_dot (acceptCs id (C_OpenFormat
  (C_SetForeground C_Blue))) (Curry_Prelude.d_OP_dot (d_C_deDoc x1 cd cs)
  (acceptCs id C_CloseFormat) cd cs) cd cs)

nd_C_blue :: C_Doc -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_blue x1 s cd cs = let s4 = s
  in s4 `seq` HO_C_Doc (let s3 = leftSupply s4
                            s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  (C_OpenFormat (C_SetForeground C_Blue)))) (let s1 = leftSupply s2
                                                 s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (nd_C_deDoc x1 s0 cd cs) (wrapDX
  id (acceptCs id C_CloseFormat)) s1 cd cs)) s3 cd cs))

d_C_magenta :: C_Doc -> Cover -> ConstStore -> C_Doc
d_C_magenta x1 cd cs = C_Doc (Curry_Prelude.d_OP_dot (acceptCs id (C_OpenFormat
  (C_SetForeground C_Magenta))) (Curry_Prelude.d_OP_dot (d_C_deDoc x1 cd cs)
  (acceptCs id C_CloseFormat) cd cs) cd cs)

nd_C_magenta :: C_Doc -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_magenta x1 s cd cs = let s4 = s
  in s4 `seq` HO_C_Doc (let s3 = leftSupply s4
                            s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  (C_OpenFormat (C_SetForeground C_Magenta)))) (let s1 = leftSupply s2
                                                    s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (nd_C_deDoc x1 s0 cd cs) (wrapDX
  id (acceptCs id C_CloseFormat)) s1 cd cs)) s3 cd cs))

d_C_cyan :: C_Doc -> Cover -> ConstStore -> C_Doc
d_C_cyan x1 cd cs = C_Doc (Curry_Prelude.d_OP_dot (acceptCs id (C_OpenFormat
  (C_SetForeground C_Cyan))) (Curry_Prelude.d_OP_dot (d_C_deDoc x1 cd cs)
  (acceptCs id C_CloseFormat) cd cs) cd cs)

nd_C_cyan :: C_Doc -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_cyan x1 s cd cs = let s4 = s
  in s4 `seq` HO_C_Doc (let s3 = leftSupply s4
                            s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  (C_OpenFormat (C_SetForeground C_Cyan)))) (let s1 = leftSupply s2
                                                 s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (nd_C_deDoc x1 s0 cd cs) (wrapDX
  id (acceptCs id C_CloseFormat)) s1 cd cs)) s3 cd cs))

d_C_white :: C_Doc -> Cover -> ConstStore -> C_Doc
d_C_white x1 cd cs = C_Doc (Curry_Prelude.d_OP_dot (acceptCs id (C_OpenFormat
  (C_SetForeground C_White))) (Curry_Prelude.d_OP_dot (d_C_deDoc x1 cd cs)
  (acceptCs id C_CloseFormat) cd cs) cd cs)

nd_C_white :: C_Doc -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_white x1 s cd cs = let s4 = s
  in s4 `seq` HO_C_Doc (let s3 = leftSupply s4
                            s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  (C_OpenFormat (C_SetForeground C_White)))) (let s1 = leftSupply s2
                                                  s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (nd_C_deDoc x1 s0 cd cs) (wrapDX
  id (acceptCs id C_CloseFormat)) s1 cd cs)) s3 cd cs))

d_C_bgBlack :: C_Doc -> Cover -> ConstStore -> C_Doc
d_C_bgBlack x1 cd cs = C_Doc (Curry_Prelude.d_OP_dot (acceptCs id (C_OpenFormat
  (C_SetBackground C_Black))) (Curry_Prelude.d_OP_dot (d_C_deDoc x1 cd cs)
  (acceptCs id C_CloseFormat) cd cs) cd cs)

nd_C_bgBlack :: C_Doc -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_bgBlack x1 s cd cs = let s4 = s
  in s4 `seq` HO_C_Doc (let s3 = leftSupply s4
                            s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  (C_OpenFormat (C_SetBackground C_Black)))) (let s1 = leftSupply s2
                                                  s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (nd_C_deDoc x1 s0 cd cs) (wrapDX
  id (acceptCs id C_CloseFormat)) s1 cd cs)) s3 cd cs))

d_C_bgRed :: C_Doc -> Cover -> ConstStore -> C_Doc
d_C_bgRed x1 cd cs = C_Doc (Curry_Prelude.d_OP_dot (acceptCs id (C_OpenFormat
  (C_SetBackground C_Red))) (Curry_Prelude.d_OP_dot (d_C_deDoc x1 cd cs)
  (acceptCs id C_CloseFormat) cd cs) cd cs)

nd_C_bgRed :: C_Doc -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_bgRed x1 s cd cs = let s4 = s
  in s4 `seq` HO_C_Doc (let s3 = leftSupply s4
                            s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  (C_OpenFormat (C_SetBackground C_Red)))) (let s1 = leftSupply s2
                                                s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (nd_C_deDoc x1 s0 cd cs) (wrapDX
  id (acceptCs id C_CloseFormat)) s1 cd cs)) s3 cd cs))

d_C_bgGreen :: C_Doc -> Cover -> ConstStore -> C_Doc
d_C_bgGreen x1 cd cs = C_Doc (Curry_Prelude.d_OP_dot (acceptCs id (C_OpenFormat
  (C_SetBackground C_Green))) (Curry_Prelude.d_OP_dot (d_C_deDoc x1 cd cs)
  (acceptCs id C_CloseFormat) cd cs) cd cs)

nd_C_bgGreen :: C_Doc -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_bgGreen x1 s cd cs = let s4 = s
  in s4 `seq` HO_C_Doc (let s3 = leftSupply s4
                            s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  (C_OpenFormat (C_SetBackground C_Green)))) (let s1 = leftSupply s2
                                                  s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (nd_C_deDoc x1 s0 cd cs) (wrapDX
  id (acceptCs id C_CloseFormat)) s1 cd cs)) s3 cd cs))

d_C_bgYellow :: C_Doc -> Cover -> ConstStore -> C_Doc
d_C_bgYellow x1 cd cs = C_Doc (Curry_Prelude.d_OP_dot (acceptCs id (C_OpenFormat
  (C_SetBackground C_Yellow))) (Curry_Prelude.d_OP_dot (d_C_deDoc x1 cd cs)
  (acceptCs id C_CloseFormat) cd cs) cd cs)

nd_C_bgYellow :: C_Doc -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_bgYellow x1 s cd cs = let s4 = s
  in s4 `seq` HO_C_Doc (let s3 = leftSupply s4
                            s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  (C_OpenFormat (C_SetBackground C_Yellow)))) (let s1 = leftSupply s2
                                                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (nd_C_deDoc x1 s0 cd cs) (wrapDX
  id (acceptCs id C_CloseFormat)) s1 cd cs)) s3 cd cs))

d_C_bgBlue :: C_Doc -> Cover -> ConstStore -> C_Doc
d_C_bgBlue x1 cd cs = C_Doc (Curry_Prelude.d_OP_dot (acceptCs id (C_OpenFormat
  (C_SetBackground C_Blue))) (Curry_Prelude.d_OP_dot (d_C_deDoc x1 cd cs)
  (acceptCs id C_CloseFormat) cd cs) cd cs)

nd_C_bgBlue :: C_Doc -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_bgBlue x1 s cd cs = let s4 = s
  in s4 `seq` HO_C_Doc (let s3 = leftSupply s4
                            s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  (C_OpenFormat (C_SetBackground C_Blue)))) (let s1 = leftSupply s2
                                                 s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (nd_C_deDoc x1 s0 cd cs) (wrapDX
  id (acceptCs id C_CloseFormat)) s1 cd cs)) s3 cd cs))

d_C_bgMagenta :: C_Doc -> Cover -> ConstStore -> C_Doc
d_C_bgMagenta x1 cd cs = C_Doc (Curry_Prelude.d_OP_dot (acceptCs id
  (C_OpenFormat (C_SetBackground C_Magenta))) (Curry_Prelude.d_OP_dot (d_C_deDoc
  x1 cd cs) (acceptCs id C_CloseFormat) cd cs) cd cs)

nd_C_bgMagenta :: C_Doc -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_bgMagenta x1 s cd cs = let s4 = s
  in s4 `seq` HO_C_Doc (let s3 = leftSupply s4
                            s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  (C_OpenFormat (C_SetBackground C_Magenta)))) (let s1 = leftSupply s2
                                                    s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (nd_C_deDoc x1 s0 cd cs) (wrapDX
  id (acceptCs id C_CloseFormat)) s1 cd cs)) s3 cd cs))

d_C_bgCyan :: C_Doc -> Cover -> ConstStore -> C_Doc
d_C_bgCyan x1 cd cs = C_Doc (Curry_Prelude.d_OP_dot (acceptCs id (C_OpenFormat
  (C_SetBackground C_Cyan))) (Curry_Prelude.d_OP_dot (d_C_deDoc x1 cd cs)
  (acceptCs id C_CloseFormat) cd cs) cd cs)

nd_C_bgCyan :: C_Doc -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_bgCyan x1 s cd cs = let s4 = s
  in s4 `seq` HO_C_Doc (let s3 = leftSupply s4
                            s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  (C_OpenFormat (C_SetBackground C_Cyan)))) (let s1 = leftSupply s2
                                                 s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (nd_C_deDoc x1 s0 cd cs) (wrapDX
  id (acceptCs id C_CloseFormat)) s1 cd cs)) s3 cd cs))

d_C_bgWhite :: C_Doc -> Cover -> ConstStore -> C_Doc
d_C_bgWhite x1 cd cs = C_Doc (Curry_Prelude.d_OP_dot (acceptCs id (C_OpenFormat
  (C_SetBackground C_White))) (Curry_Prelude.d_OP_dot (d_C_deDoc x1 cd cs)
  (acceptCs id C_CloseFormat) cd cs) cd cs)

nd_C_bgWhite :: C_Doc -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C_bgWhite x1 s cd cs = let s4 = s
  in s4 `seq` HO_C_Doc (let s3 = leftSupply s4
                            s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  (C_OpenFormat (C_SetBackground C_White)))) (let s1 = leftSupply s2
                                                  s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (nd_C_deDoc x1 s0 cd cs) (wrapDX
  id (acceptCs id C_CloseFormat)) s1 cd cs)) s3 cd cs))

d_C_resetFormat :: Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 C_FormatStm (Curry_Prelude.OP_List C_FormatStm)
d_C_resetFormat x1 cd cs = case x1 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "Pretty.resetFormat2: illegal format history") cd cs
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_28 x3 x2 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_resetFormat l cd cs)
    (d_C_resetFormat r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_resetFormat
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_resetFormat e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Pretty.resetFormat" [show x1] info)
  _ -> failCons cd (consFail "Pretty.resetFormat" (showCons x1))

d_C_prevFGColor :: Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> C_Color
d_C_prevFGColor x1 cd cs = case x1 of
  Curry_Prelude.OP_List -> C_Default
  Curry_Prelude.OP_Cons x2 x3 -> let x4 = d_C_prevFGColor x3 cd cs
    in d_C__case_27 x4 x2 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_prevFGColor l cd cs)
    (d_C_prevFGColor r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_prevFGColor
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_prevFGColor e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Pretty.prevFGColor" [show x1] info)
  _ -> failCons cd (consFail "Pretty.prevFGColor" (showCons x1))

d_C_prevBGColor :: Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> C_Color
d_C_prevBGColor x1 cd cs = case x1 of
  Curry_Prelude.OP_List -> C_Default
  Curry_Prelude.OP_Cons x2 x3 -> let x4 = d_C_prevBGColor x3 cd cs
    in d_C__case_26 x4 x2 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_prevBGColor l cd cs)
    (d_C_prevBGColor r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_prevBGColor
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_prevBGColor e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Pretty.prevBGColor" [show x1] info)
  _ -> failCons cd (consFail "Pretty.prevBGColor" (showCons x1))

d_C_prevIntensity :: Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> C_Intensity
d_C_prevIntensity x1 cd cs = case x1 of
  Curry_Prelude.OP_List -> C_Normal
  Curry_Prelude.OP_Cons x2 x3 -> let x4 = d_C_prevIntensity x3 cd cs
    in d_C__case_25 x4 x2 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_prevIntensity l cd cs)
    (d_C_prevIntensity r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_C_prevIntensity z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_prevIntensity e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Pretty.prevIntensity" [show x1] info)
  _ -> failCons cd (consFail "Pretty.prevIntensity" (showCons x1))

d_C_prevBlinkMode :: Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> C_BlinkMode
d_C_prevBlinkMode x1 cd cs = case x1 of
  Curry_Prelude.OP_List -> C_Off
  Curry_Prelude.OP_Cons x2 x3 -> let x4 = d_C_prevBlinkMode x3 cd cs
    in d_C__case_24 x4 x2 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_prevBlinkMode l cd cs)
    (d_C_prevBlinkMode r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_C_prevBlinkMode z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_prevBlinkMode e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Pretty.prevBlinkMode" [show x1] info)
  _ -> failCons cd (consFail "Pretty.prevBlinkMode" (showCons x1))

d_C_applyFormat :: C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_applyFormat x1 cd cs = case x1 of
  C_SetForeground x2 -> d_C_txtMode (d_C_colorMode x2 cd cs) cd cs
  C_SetBackground x3 -> d_C_txtMode
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    (d_C_colorMode x3 cd cs) (Curry_Prelude.C_Int (10)) cd cs) cd cs
  C_SetIntensity x4 -> d_C_txtMode (d_C_intensityMode x4 cd cs) cd cs
  C_SetBlinkMode x5 -> d_C_txtMode (d_C_blinkMode x5 cd cs) cd cs
  C_SetItalicized x6 -> d_C_txtMode (d_C__case_23 x6 cd cs) cd cs
  C_SetUnderlined x7 -> d_C_txtMode (d_C__case_22 x7 cd cs) cd cs
  C_SetCrossedout x8 -> d_C_txtMode (d_C__case_21 x8 cd cs) cd cs
  C_InverseColoring x9 -> d_C_txtMode (d_C__case_20 x9 cd cs) cd cs
  Choice_C_FormatStm d i l r -> narrow d i (d_C_applyFormat l cd cs)
    (d_C_applyFormat r cd cs)
  Choices_C_FormatStm d i xs -> narrows cs d i (\z -> d_C_applyFormat z cd cs)
    xs
  Guard_C_FormatStm d c e -> guardCons d c (d_C_applyFormat e cd $! addCs c cs)
  Fail_C_FormatStm d info -> failCons d (traceFail "Pretty.applyFormat" [show
    x1] info)
  _ -> failCons cd (consFail "Pretty.applyFormat" (showCons x1))

d_C_txtMode :: Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_txtMode x1 cd cs = let x2 = Curry_Prelude.toCurryString "\ESC["
  in Curry_Prelude.d_OP_plus_plus x2 (Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Int
  cd cs) x1 cd cs) (Curry_Prelude.toCurryString "m") cd cs) cd cs

d_C_colorMode :: C_Color -> Cover -> ConstStore -> Curry_Prelude.C_Int
d_C_colorMode x1 cd cs = case x1 of
  C_Black -> Curry_Prelude.C_Int (30)
  C_Red -> Curry_Prelude.C_Int (31)
  C_Green -> Curry_Prelude.C_Int (32)
  C_Yellow -> Curry_Prelude.C_Int (33)
  C_Blue -> Curry_Prelude.C_Int (34)
  C_Magenta -> Curry_Prelude.C_Int (35)
  C_Cyan -> Curry_Prelude.C_Int (36)
  C_White -> Curry_Prelude.C_Int (37)
  C_Default -> Curry_Prelude.C_Int (39)
  Choice_C_Color d i l r -> narrow d i (d_C_colorMode l cd cs) (d_C_colorMode r
    cd cs)
  Choices_C_Color d i xs -> narrows cs d i (\z -> d_C_colorMode z cd cs) xs
  Guard_C_Color d c e -> guardCons d c (d_C_colorMode e cd $! addCs c cs)
  Fail_C_Color d info -> failCons d (traceFail "Pretty.colorMode" [show x1]
    info)
  _ -> failCons cd (consFail "Pretty.colorMode" (showCons x1))

d_C_intensityMode :: C_Intensity -> Cover -> ConstStore -> Curry_Prelude.C_Int
d_C_intensityMode x1 cd cs = case x1 of
  C_Faint -> Curry_Prelude.C_Int (2)
  C_Normal -> Curry_Prelude.C_Int (22)
  C_Bold -> Curry_Prelude.C_Int (1)
  Choice_C_Intensity d i l r -> narrow d i (d_C_intensityMode l cd cs)
    (d_C_intensityMode r cd cs)
  Choices_C_Intensity d i xs -> narrows cs d i (\z -> d_C_intensityMode z cd cs)
    xs
  Guard_C_Intensity d c e -> guardCons d c (d_C_intensityMode e cd $! addCs c
    cs)
  Fail_C_Intensity d info -> failCons d (traceFail "Pretty.intensityMode" [show
    x1] info)
  _ -> failCons cd (consFail "Pretty.intensityMode" (showCons x1))

d_C_blinkMode :: C_BlinkMode -> Cover -> ConstStore -> Curry_Prelude.C_Int
d_C_blinkMode x1 cd cs = case x1 of
  C_Off -> Curry_Prelude.C_Int (25)
  C_Slow -> Curry_Prelude.C_Int (5)
  C_Rapid -> Curry_Prelude.C_Int (6)
  Choice_C_BlinkMode d i l r -> narrow d i (d_C_blinkMode l cd cs)
    (d_C_blinkMode r cd cs)
  Choices_C_BlinkMode d i xs -> narrows cs d i (\z -> d_C_blinkMode z cd cs) xs
  Guard_C_BlinkMode d c e -> guardCons d c (d_C_blinkMode e cd $! addCs c cs)
  Fail_C_BlinkMode d info -> failCons d (traceFail "Pretty.blinkMode" [show x1]
    info)
  _ -> failCons cd (consFail "Pretty.blinkMode" (showCons x1))

d_C_applyNesting :: C_Nesting -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int
d_C_applyNesting x1 x2 x3 x4 cd cs = case x1 of
  C_Align -> Curry_Prelude.OP_Cons
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x2 x3 cd cs) x4
  C_Inc x5 -> d_C__case_19 x5 x4 cd cs
  Choice_C_Nesting d i l r -> narrow d i (d_C_applyNesting l x2 x3 x4 cd cs)
    (d_C_applyNesting r x2 x3 x4 cd cs)
  Choices_C_Nesting d i xs -> narrows cs d i (\z -> d_C_applyNesting z x2 x3 x4
    cd cs) xs
  Guard_C_Nesting d c e -> guardCons d c (d_C_applyNesting e x2 x3 x4 cd $!
    addCs c cs)
  Fail_C_Nesting d info -> failCons d (traceFail "Pretty.applyNesting" [show x1
    , show x2, show x3, show x4] info)
  _ -> failCons cd (consFail "Pretty.applyNesting" (showCons x1))

d_C_unApplyNesting :: Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int
d_C_unApplyNesting x1 cd cs = case x1 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "Pretty.unApplyNesting: empty margin list") cd cs
  Curry_Prelude.OP_Cons x2 x3 -> x3
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_unApplyNesting l cd
    cs) (d_C_unApplyNesting r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_C_unApplyNesting z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_unApplyNesting e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Pretty.unApplyNesting" [show x1] info)
  _ -> failCons cd (consFail "Pretty.unApplyNesting" (showCons x1))

d_C_addSpaces :: Curry_Prelude.C_Int -> C_Tokens -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_addSpaces x1 x2 cd cs = case x2 of
  C_LineBreak x3 x4 -> Curry_Prelude.OP_List
  C_EOD -> Curry_Prelude.OP_List
  C_Empty x5 -> d_C_addSpaces x1 x5 cd cs
  C_OpenGroup x6 -> d_C_addSpaces x1 x6 cd cs
  C_CloseGroup x7 -> d_C_addSpaces x1 x7 cd cs
  C_OpenNest x8 x9 -> d_C_addSpaces x1 x9 cd cs
  C_CloseNest x10 -> d_C_addSpaces x1 x10 cd cs
  C_OpenFormat x11 x12 -> d_C_addSpaces x1 x12 cd cs
  C_CloseFormat x13 -> d_C_addSpaces x1 x13 cd cs
  C_Text x14 x15 -> Curry_Prelude.d_C_replicate x1 (Curry_Prelude.C_Char ' '#)
    cd cs
  Choice_C_Tokens d i l r -> narrow d i (d_C_addSpaces x1 l cd cs)
    (d_C_addSpaces x1 r cd cs)
  Choices_C_Tokens d i xs -> narrows cs d i (\z -> d_C_addSpaces x1 z cd cs) xs
  Guard_C_Tokens d c e -> guardCons d c (d_C_addSpaces x1 e cd $! addCs c cs)
  Fail_C_Tokens d info -> failCons d (traceFail "Pretty.addSpaces" [show x1
    , show x2] info)
  _ -> failCons cd (consFail "Pretty.addSpaces" (showCons x2))

d_C_normalise :: Cover -> ConstStore -> C_Tokens -> Cover -> ConstStore
  -> C_Tokens
d_C_normalise cd cs = d_OP_normalise_dot_go_dot_454 Curry_Prelude.d_C_id

d_OP_normalise_dot_open_dot_454 :: C_Tokens -> Cover -> ConstStore -> C_Tokens
d_OP_normalise_dot_open_dot_454 x1 cd cs = let x2 = C_OpenGroup x1
  in d_C__case_18 x2 x1 cd cs

d_OP_normalise_dot_go_dot_454 :: (C_Tokens -> Cover -> ConstStore -> C_Tokens)
  -> C_Tokens -> Cover -> ConstStore -> C_Tokens
d_OP_normalise_dot_go_dot_454 x1 x2 cd cs = case x2 of
  C_EOD -> Curry_Prelude.d_C_apply x1 C_EOD cd cs
  C_Empty x3 -> d_OP_normalise_dot_go_dot_454 x1 x3 cd cs
  C_OpenGroup x4 -> d_OP_normalise_dot_go_dot_454 (Curry_Prelude.d_OP_dot x1
    d_OP_normalise_dot_open_dot_454 cd cs) x4 cd cs
  C_CloseGroup x5 -> d_OP_normalise_dot_go_dot_454 (Curry_Prelude.d_OP_dot x1
    (acceptCs id C_CloseGroup) cd cs) x5 cd cs
  C_LineBreak x6 x7 -> Curry_Prelude.d_C_apply (Curry_Prelude.d_OP_dot x1
    (Curry_Prelude.d_OP_dot (acceptCs id (C_LineBreak x6))
    (d_OP_normalise_dot_go_dot_454 Curry_Prelude.d_C_id) cd cs) cd cs) x7 cd cs
  C_Text x8 x9 -> C_Text x8 (d_OP_normalise_dot_go_dot_454 x1 x9 cd cs)
  C_OpenNest x10 x11 -> C_OpenNest x10 (d_OP_normalise_dot_go_dot_454 x1 x11 cd
    cs)
  C_CloseNest x12 -> C_CloseNest (d_OP_normalise_dot_go_dot_454 x1 x12 cd cs)
  C_OpenFormat x13 x14 -> C_OpenFormat x13 (d_OP_normalise_dot_go_dot_454 x1 x14
    cd cs)
  C_CloseFormat x15 -> C_CloseFormat (d_OP_normalise_dot_go_dot_454 x1 x15 cd
    cs)
  Choice_C_Tokens d i l r -> narrow d i (d_OP_normalise_dot_go_dot_454 x1 l cd
    cs) (d_OP_normalise_dot_go_dot_454 x1 r cd cs)
  Choices_C_Tokens d i xs -> narrows cs d i (\z -> d_OP_normalise_dot_go_dot_454
    x1 z cd cs) xs
  Guard_C_Tokens d c e -> guardCons d c (d_OP_normalise_dot_go_dot_454 x1 e
    cd $! addCs c cs)
  Fail_C_Tokens d info -> failCons d (traceFail "Pretty.normalise.go.454" [show
    x1, show x2] info)
  _ -> failCons cd (consFail "Pretty.normalise.go.454" (showCons x2))

nd_OP_normalise_dot_go_dot_454 :: Func C_Tokens C_Tokens -> C_Tokens -> IDSupply
  -> Cover -> ConstStore -> C_Tokens
nd_OP_normalise_dot_go_dot_454 x1 x2 s cd cs = case x2 of
  C_EOD -> let s0 = s in s0 `seq` Curry_Prelude.nd_C_apply x1 C_EOD s0 cd cs
  C_Empty x3 -> let s0 = s
    in s0 `seq` nd_OP_normalise_dot_go_dot_454 x1 x3 s0 cd cs
  C_OpenGroup x4 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_normalise_dot_go_dot_454
    (Curry_Prelude.nd_OP_dot x1 (wrapDX id d_OP_normalise_dot_open_dot_454) s0
    cd cs) x4 s1 cd cs))
  C_CloseGroup x5 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_normalise_dot_go_dot_454
    (Curry_Prelude.nd_OP_dot x1 (wrapDX id (acceptCs id C_CloseGroup)) s0 cd cs)
    x5 s1 cd cs))
  C_LineBreak x6 x7 -> let s4 = s
    in s4 `seq` (let s3 = leftSupply s4
                     s2 = rightSupply s4
    in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                        s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot x1 (Curry_Prelude.nd_OP_dot
    (wrapDX id (acceptCs id (C_LineBreak x6))) (wrapNX id
    (nd_OP_normalise_dot_go_dot_454 (wrapDX id Curry_Prelude.d_C_id))) s0 cd cs)
    s1 cd cs)) x7 s3 cd cs))
  C_Text x8 x9 -> let s0 = s
    in s0 `seq` C_Text x8 (nd_OP_normalise_dot_go_dot_454 x1 x9 s0 cd cs)
  C_OpenNest x10 x11 -> let s0 = s
    in s0 `seq` C_OpenNest x10 (nd_OP_normalise_dot_go_dot_454 x1 x11 s0 cd cs)
  C_CloseNest x12 -> let s0 = s
    in s0 `seq` C_CloseNest (nd_OP_normalise_dot_go_dot_454 x1 x12 s0 cd cs)
  C_OpenFormat x13 x14 -> let s0 = s
    in s0 `seq` C_OpenFormat x13 (nd_OP_normalise_dot_go_dot_454 x1 x14 s0 cd
    cs)
  C_CloseFormat x15 -> let s0 = s
    in s0 `seq` C_CloseFormat (nd_OP_normalise_dot_go_dot_454 x1 x15 s0 cd cs)
  Choice_C_Tokens d i l r -> narrow d i (nd_OP_normalise_dot_go_dot_454 x1 l s
    cd cs) (nd_OP_normalise_dot_go_dot_454 x1 r s cd cs)
  Choices_C_Tokens d i xs -> narrows cs d i (\z ->
    nd_OP_normalise_dot_go_dot_454 x1 z s cd cs) xs
  Guard_C_Tokens d c e -> guardCons d c (nd_OP_normalise_dot_go_dot_454 x1 e s
    cd $! addCs c cs)
  Fail_C_Tokens d info -> failCons d (traceFail "Pretty.normalise.go.454" [show
    x1, show x2] info)
  _ -> failCons cd (consFail "Pretty.normalise.go.454" (showCons x2))

d_C_doc2Tokens :: C_Doc -> Cover -> ConstStore -> C_Tokens
d_C_doc2Tokens x1 cd cs = case x1 of
  C_Doc x2 -> Curry_Prelude.d_C_apply (d_C_normalise cd cs)
    (Curry_Prelude.d_C_apply x2 C_EOD cd cs) cd cs
  Choice_C_Doc d i l r -> narrow d i (d_C_doc2Tokens l cd cs) (d_C_doc2Tokens r
    cd cs)
  Choices_C_Doc d i xs -> narrows cs d i (\z -> d_C_doc2Tokens z cd cs) xs
  Guard_C_Doc d c e -> guardCons d c (d_C_doc2Tokens e cd $! addCs c cs)
  Fail_C_Doc d info -> failCons d (traceFail "Pretty.doc2Tokens" [show x1] info)
  _ -> failCons cd (consFail "Pretty.doc2Tokens" (showCons x1))

nd_C_doc2Tokens :: C_Doc -> IDSupply -> Cover -> ConstStore -> C_Tokens
nd_C_doc2Tokens x1 s cd cs = case x1 of
  HO_C_Doc x2 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (wrapDX id (d_C_normalise cd
    cs)) (Curry_Prelude.nd_C_apply x2 C_EOD s0 cd cs) s1 cd cs))
  Choice_C_Doc d i l r -> narrow d i (nd_C_doc2Tokens l s cd cs)
    (nd_C_doc2Tokens r s cd cs)
  Choices_C_Doc d i xs -> narrows cs d i (\z -> nd_C_doc2Tokens z s cd cs) xs
  Guard_C_Doc d c e -> guardCons d c (nd_C_doc2Tokens e s cd $! addCs c cs)
  Fail_C_Doc d info -> failCons d (traceFail "Pretty.doc2Tokens" [show x1] info)
  _ -> failCons cd (consFail "Pretty.doc2Tokens" (showCons x1))

d_C_pretty :: Curry_Prelude.C_Int -> C_Doc -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_pretty x1 x2 cd cs = d_C_noGroup (d_C_doc2Tokens x2 cd cs) x1
  (Curry_Prelude.C_Int (1)) x1 (Curry_Prelude.OP_Cons (Curry_Prelude.C_Int (0))
  Curry_Prelude.OP_List) Curry_Prelude.OP_List cd cs

nd_C_pretty :: Curry_Prelude.C_Int -> C_Doc -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
nd_C_pretty x1 x2 s cd cs = let s0 = s
  in s0 `seq` d_C_noGroup (nd_C_doc2Tokens x2 s0 cd cs) x1 (Curry_Prelude.C_Int
  (1)) x1 (Curry_Prelude.OP_Cons (Curry_Prelude.C_Int (0))
  Curry_Prelude.OP_List) Curry_Prelude.OP_List cd cs

d_C_length :: Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.C_Int
d_C_length cd cs = Curry_Prelude.d_OP_dot Curry_Prelude.d_C_length
  (Curry_Prelude.d_C_filter d_OP_length_dot_isVisible_dot_487) cd cs

d_OP_length_dot_isVisible_dot_487 :: Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_OP_length_dot_isVisible_dot_487 x1 cd cs = Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_notElem
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Int cd
  cs) (Curry_Prelude.d_C_ord x1 cd cs) cd cs) (Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.OP_Cons (Curry_Prelude.C_Int (5)) (Curry_Prelude.OP_Cons
  (Curry_Prelude.C_Int (6)) (Curry_Prelude.OP_Cons (Curry_Prelude.C_Int (7))
  Curry_Prelude.OP_List))) (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_enumFromTo_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
  cd cs) (Curry_Prelude.C_Int (16)) cd cs) (Curry_Prelude.C_Int (31)) cd cs) cd
  cs) cd cs

d_C_noGroup :: C_Tokens -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_noGroup x1 x2 x3 x4 x5 x6 cd cs = case x1 of
  C_EOD -> Curry_Prelude.OP_List
  C_Empty x7 -> d_C_noGroup x7 x2 x3 x4 x5 x6 cd cs
  C_Text x8 x9 -> let x10 = Curry_Prelude.d_C_apply (d_C_length cd cs) x8 cd cs
    in Curry_Prelude.d_OP_plus_plus x8 (d_C_noGroup x9 x2
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x3 x10 cd cs)
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x4 x10 cd cs) x5 x6 cd cs) cd cs
  C_LineBreak x11 x12 -> d_C__case_17 x6 x2 x3 x12 x5 cd cs
  C_OpenGroup x15 -> Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (d_C_oneGroup x15 x2 x3
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x3 x4 cd cs) (acceptCs id d_OP_noGroup_dot_uscore_hash_lambda15) cd cs) x4
    cd cs) x5 cd cs) x6 cd cs
  C_CloseGroup x16 -> d_C_noGroup x16 x2 x3 x4 x5 x6 cd cs
  C_OpenNest x17 x18 -> d_C_noGroup x18 x2 x3 x4 (d_C_applyNesting x17 x2 x4 x5
    cd cs) x6 cd cs
  C_CloseNest x19 -> d_C_noGroup x19 x2 x3 x4 (d_C_unApplyNesting x5 cd cs) x6
    cd cs
  C_OpenFormat x20 x21 -> Curry_Prelude.d_OP_plus_plus (d_C_applyFormat x20 cd
    cs) (d_C_noGroup x21 x2 x3 x4 x5 (Curry_Prelude.OP_Cons x20 x6) cd cs) cd cs
  C_CloseFormat x22 -> let x23 = d_C_resetFormat x6 cd cs
                           x24 = d_OP_noGroup_dot_uscore_hash_selFP2_hash_f x23
                             cd cs
                           x25 = d_OP_noGroup_dot_uscore_hash_selFP3_hash_ofs
                             x23 cd cs
    in Curry_Prelude.d_OP_plus_plus (d_C_applyFormat x24 cd cs) (d_C_noGroup x22
    x2 x3 x4 x5 x25 cd cs) cd cs
  Choice_C_Tokens d i l r -> narrow d i (d_C_noGroup l x2 x3 x4 x5 x6 cd cs)
    (d_C_noGroup r x2 x3 x4 x5 x6 cd cs)
  Choices_C_Tokens d i xs -> narrows cs d i (\z -> d_C_noGroup z x2 x3 x4 x5 x6
    cd cs) xs
  Guard_C_Tokens d c e -> guardCons d c (d_C_noGroup e x2 x3 x4 x5 x6 cd $!
    addCs c cs)
  Fail_C_Tokens d info -> failCons d (traceFail "Pretty.noGroup" [show x1, show
    x2, show x3, show x4, show x5, show x6] info)
  _ -> failCons cd (consFail "Pretty.noGroup" (showCons x1))

d_OP_noGroup_dot_uscore_hash_lambda15 :: Curry_Prelude.C_Bool
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_noGroup_dot_uscore_hash_lambda15 x1 x2 cd cs = x2

nd_OP_noGroup_dot_uscore_hash_lambda15 :: Curry_Prelude.C_Bool -> Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))) -> IDSupply -> Cover -> ConstStore -> Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))
nd_OP_noGroup_dot_uscore_hash_lambda15 x1 x2 s cd cs = x2

d_OP_noGroup_dot_uscore_hash_selFP2_hash_f :: Curry_Prelude.OP_Tuple2
  C_FormatStm (Curry_Prelude.OP_List C_FormatStm) -> Cover -> ConstStore
  -> C_FormatStm
d_OP_noGroup_dot_uscore_hash_selFP2_hash_f x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_noGroup_dot_uscore_hash_selFP2_hash_f l cd cs)
    (d_OP_noGroup_dot_uscore_hash_selFP2_hash_f r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_noGroup_dot_uscore_hash_selFP2_hash_f z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_noGroup_dot_uscore_hash_selFP2_hash_f e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Pretty.noGroup._#selFP2#f" [show x1] info)
  _ -> failCons cd (consFail "Pretty.noGroup._#selFP2#f" (showCons x1))

d_OP_noGroup_dot_uscore_hash_selFP3_hash_ofs :: Curry_Prelude.OP_Tuple2
  C_FormatStm (Curry_Prelude.OP_List C_FormatStm) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm
d_OP_noGroup_dot_uscore_hash_selFP3_hash_ofs x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_noGroup_dot_uscore_hash_selFP3_hash_ofs l cd cs)
    (d_OP_noGroup_dot_uscore_hash_selFP3_hash_ofs r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_noGroup_dot_uscore_hash_selFP3_hash_ofs z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_noGroup_dot_uscore_hash_selFP3_hash_ofs e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Pretty.noGroup._#selFP3#ofs" [show x1] info)
  _ -> failCons cd (consFail "Pretty.noGroup._#selFP3#ofs" (showCons x1))

d_C_oneGroup :: C_Tokens -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_oneGroup x1 x2 x3 x4 x5 cd cs = case x1 of
  C_EOD -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "Pretty.oneGroup: EOD") cd cs
  C_Empty x6 -> d_C_oneGroup x6 x2 x3 x4 x5 cd cs
  C_Text x7 x8 -> let x9 = Curry_Prelude.d_C_apply (d_C_length cd cs) x7 cd cs
    in d_C_pruneOne x8 x2
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x3 x9 cd cs) x4 (acceptCs id (d_OP_oneGroup_dot_uscore_hash_lambda16 x9 x7
    x5)) cd cs
  C_LineBreak x10 x11 -> d_C__case_16 x5 x11 x2 x4 x3 x10 cd cs
  C_OpenGroup x14 -> d_C_multiGroup x14 x2 x3 x4 x5 (Curry_Dequeue.d_C_empty cd
    cs) x3 (acceptCs id d_OP_oneGroup_dot_uscore_hash_lambda18) cd cs
  C_CloseGroup x15 -> Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x5
    (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
    x3 x4 cd cs) cd cs) (acceptCs (acceptCs id) (d_C_noGroup x15 x2 x3)) cd cs
  C_OpenNest x16 x17 -> d_C_oneGroup x17 x2 x3 x4 (acceptCs id
    (d_OP_oneGroup_dot_uscore_hash_lambda19 x2 x16 x5)) cd cs
  C_CloseNest x18 -> d_C_oneGroup x18 x2 x3 x4 (acceptCs id
    (d_OP_oneGroup_dot_uscore_hash_lambda21 x5)) cd cs
  C_OpenFormat x19 x20 -> d_C_oneGroup x20 x2 x3 x4 (acceptCs id
    (d_OP_oneGroup_dot_uscore_hash_lambda23 x19 x5)) cd cs
  C_CloseFormat x21 -> d_C_oneGroup x21 x2 x3 x4 (acceptCs id
    (d_OP_oneGroup_dot_uscore_hash_lambda24 x5)) cd cs
  Choice_C_Tokens d i l r -> narrow d i (d_C_oneGroup l x2 x3 x4 x5 cd cs)
    (d_C_oneGroup r x2 x3 x4 x5 cd cs)
  Choices_C_Tokens d i xs -> narrows cs d i (\z -> d_C_oneGroup z x2 x3 x4 x5 cd
    cs) xs
  Guard_C_Tokens d c e -> guardCons d c (d_C_oneGroup e x2 x3 x4 x5 cd $! addCs
    c cs)
  Fail_C_Tokens d info -> failCons d (traceFail "Pretty.oneGroup" [show x1, show
    x2, show x3, show x4, show x5] info)
  _ -> failCons cd (consFail "Pretty.oneGroup" (showCons x1))

nd_C_oneGroup :: C_Tokens -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Func Curry_Prelude.C_Bool (Func (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))))) -> IDSupply
  -> Cover -> ConstStore -> Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
nd_C_oneGroup x1 x2 x3 x4 x5 s cd cs = case x1 of
  C_EOD -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "Pretty.oneGroup: EOD") cd cs
  C_Empty x6 -> let s0 = s in s0 `seq` nd_C_oneGroup x6 x2 x3 x4 x5 s0 cd cs
  C_Text x7 x8 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` (let x9 = Curry_Prelude.nd_C_apply (wrapDX id
                                 (d_C_length cd cs)) x7 s0 cd cs
    in nd_C_pruneOne x8 x2
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x3 x9 cd cs) x4 (wrapDX (wrapNX id) (acceptCs id
    (nd_OP_oneGroup_dot_uscore_hash_lambda16 x9 x7 x5))) s1 cd cs)))
  C_LineBreak x10 x11 -> let s0 = s
    in s0 `seq` nd_C__case_16 x5 x11 x2 x4 x3 x10 s0 cd cs
  C_OpenGroup x14 -> let s0 = s
    in s0 `seq` nd_C_multiGroup x14 x2 x3 x4 x5 (Curry_Dequeue.d_C_empty cd cs)
    x3 (wrapDX (wrapNX id) (acceptCs id
    nd_OP_oneGroup_dot_uscore_hash_lambda18)) s0 cd cs
  C_CloseGroup x15 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x5
    (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
    x3 x4 cd cs) s0 cd cs) (wrapDX (wrapDX (wrapDX id)) (acceptCs (acceptCs id)
    (d_C_noGroup x15 x2 x3))) s1 cd cs))
  C_OpenNest x16 x17 -> let s0 = s
    in s0 `seq` nd_C_oneGroup x17 x2 x3 x4 (wrapDX (wrapNX id) (acceptCs id
    (nd_OP_oneGroup_dot_uscore_hash_lambda19 x2 x16 x5))) s0 cd cs
  C_CloseNest x18 -> let s0 = s
    in s0 `seq` nd_C_oneGroup x18 x2 x3 x4 (wrapDX (wrapNX id) (acceptCs id
    (nd_OP_oneGroup_dot_uscore_hash_lambda21 x5))) s0 cd cs
  C_OpenFormat x19 x20 -> let s0 = s
    in s0 `seq` nd_C_oneGroup x20 x2 x3 x4 (wrapDX (wrapNX id) (acceptCs id
    (nd_OP_oneGroup_dot_uscore_hash_lambda23 x19 x5))) s0 cd cs
  C_CloseFormat x21 -> let s0 = s
    in s0 `seq` nd_C_oneGroup x21 x2 x3 x4 (wrapDX (wrapNX id) (acceptCs id
    (nd_OP_oneGroup_dot_uscore_hash_lambda24 x5))) s0 cd cs
  Choice_C_Tokens d i l r -> narrow d i (nd_C_oneGroup l x2 x3 x4 x5 s cd cs)
    (nd_C_oneGroup r x2 x3 x4 x5 s cd cs)
  Choices_C_Tokens d i xs -> narrows cs d i (\z -> nd_C_oneGroup z x2 x3 x4 x5 s
    cd cs) xs
  Guard_C_Tokens d c e -> guardCons d c (nd_C_oneGroup e x2 x3 x4 x5 s cd $!
    addCs c cs)
  Fail_C_Tokens d info -> failCons d (traceFail "Pretty.oneGroup" [show x1, show
    x2, show x3, show x4, show x5] info)
  _ -> failCons cd (consFail "Pretty.oneGroup" (showCons x1))

d_OP_oneGroup_dot_outText_dot_535 :: forall t0 t1 . (Curry_Prelude.Curry t1
  , Curry_Prelude.Curry t0) => Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> t0
  -> Cover -> ConstStore -> t1 -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Int -> t0 -> t1 -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_oneGroup_dot_outText_dot_535 x1 x2 x3 x4 x5 x6 cd cs =
  Curry_Prelude.d_OP_plus_plus x2 (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x3
  (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
  x4 x1 cd cs) cd cs) x5 cd cs) x6 cd cs) cd cs

nd_OP_oneGroup_dot_outText_dot_535 :: forall t0 t1 . (Curry_Prelude.Curry t1
  , Curry_Prelude.Curry t0) => Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Func Curry_Prelude.C_Int (Func t0 (Func t1
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> Curry_Prelude.C_Int -> t0
  -> t1 -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
nd_OP_oneGroup_dot_outText_dot_535 x1 x2 x3 x4 x5 x6 s cd cs = let s4 = s
  in s4 `seq` Curry_Prelude.d_OP_plus_plus x2 (let s3 = leftSupply s4
                                                   s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                      s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x3
  (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
  x4 x1 cd cs) s0 cd cs) x5 s1 cd cs)) x6 s3 cd cs)) cd cs

d_OP_oneGroup_dot_uscore_hash_lambda16 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> (Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> (Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_oneGroup_dot_uscore_hash_lambda16 x1 x2 x3 x4 x5 cd cs =
  Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x3 x4 cd cs) (acceptCs
  (acceptCs id) (d_OP_oneGroup_dot_outText_dot_535 x1 x2 x5)) cd cs

nd_OP_oneGroup_dot_uscore_hash_lambda16 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Func Curry_Prelude.C_Bool
  (Func (Func Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List
  Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List C_FormatStm)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int
  (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))))
  -> Curry_Prelude.C_Bool -> Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> IDSupply
  -> Cover -> ConstStore -> Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
nd_OP_oneGroup_dot_uscore_hash_lambda16 x1 x2 x3 x4 x5 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x3 x4
  s0 cd cs) (wrapDX (wrapDX (wrapNX id)) (acceptCs (acceptCs id)
  (nd_OP_oneGroup_dot_outText_dot_535 x1 x2 x5))) s1 cd cs))

d_OP_oneGroup_dot_outLine_dot_542 :: forall t1 t0 . (Curry_Prelude.Curry t0
  , Curry_Prelude.Curry t1) => Curry_Prelude.C_Int -> C_Tokens
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> t0 -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> t1 -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> t0 -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_oneGroup_dot_outLine_dot_542 x1 x2 x3 x4 x5 x6 cd cs = case x5 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "Pretty.oneGroup.outLine: empty margins") cd cs
  Curry_Prelude.OP_Cons x7 x8 -> Curry_Prelude.OP_Cons (Curry_Prelude.C_Char
    '\n'#) (Curry_Prelude.d_OP_plus_plus (d_C_addSpaces x7 x2 cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    x3
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x1 x7 cd cs) cd cs) x5 cd cs) x6 cd cs) cd cs)
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_oneGroup_dot_outLine_dot_542 x1 x2 x3 x4 l x6 cd cs)
    (d_OP_oneGroup_dot_outLine_dot_542 x1 x2 x3 x4 r x6 cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_oneGroup_dot_outLine_dot_542 x1 x2 x3 x4 z x6 cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_oneGroup_dot_outLine_dot_542 x1 x2 x3 x4 e x6 cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Pretty.oneGroup.outLine.542" [show x1, show x2, show x3, show x4, show x5
    , show x6] info)
  _ -> failCons cd (consFail "Pretty.oneGroup.outLine.542" (showCons x5))

nd_OP_oneGroup_dot_outLine_dot_542 :: forall t1 t0 . (Curry_Prelude.Curry t0
  , Curry_Prelude.Curry t1) => Curry_Prelude.C_Int -> C_Tokens -> Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func t0
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> t1 -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> t0 -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
nd_OP_oneGroup_dot_outLine_dot_542 x1 x2 x3 x4 x5 x6 s cd cs = case x5 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "Pretty.oneGroup.outLine: empty margins") cd cs
  Curry_Prelude.OP_Cons x7 x8 -> let s4 = s
    in s4 `seq` Curry_Prelude.OP_Cons (Curry_Prelude.C_Char '\n'#)
    (Curry_Prelude.d_OP_plus_plus (d_C_addSpaces x7 x2 cd cs)
    (let s3 = leftSupply s4
         s2 = rightSupply s4
    in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                        s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x3
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x1 x7 cd cs) s0 cd cs) x5 s1 cd cs)) x6 s3 cd cs)) cd cs)
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (nd_OP_oneGroup_dot_outLine_dot_542 x1 x2 x3 x4 l x6 s cd cs)
    (nd_OP_oneGroup_dot_outLine_dot_542 x1 x2 x3 x4 r x6 s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    nd_OP_oneGroup_dot_outLine_dot_542 x1 x2 x3 x4 z x6 s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (nd_OP_oneGroup_dot_outLine_dot_542 x1 x2 x3 x4 e x6 s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Pretty.oneGroup.outLine.542" [show x1, show x2, show x3, show x4, show x5
    , show x6] info)
  _ -> failCons cd (consFail "Pretty.oneGroup.outLine.542" (showCons x5))

d_OP_oneGroup_dot_outLine_dot_553 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> C_Tokens
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> t0 -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> t0 -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_oneGroup_dot_outLine_dot_553 x1 x2 x3 x4 x5 x6 x7 x8 x9 cd cs = case x8 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "Pretty.oneGroup.outLine: empty margins") cd cs
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_15 x9 x8 x10 x2 x6 x3 x1 x7 x4 x5
    cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_oneGroup_dot_outLine_dot_553 x1 x2 x3 x4 x5 x6 x7 l x9 cd cs)
    (d_OP_oneGroup_dot_outLine_dot_553 x1 x2 x3 x4 x5 x6 x7 r x9 cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_oneGroup_dot_outLine_dot_553 x1 x2 x3 x4 x5 x6 x7 z x9 cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_oneGroup_dot_outLine_dot_553 x1 x2 x3 x4 x5 x6 x7 e x9 cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Pretty.oneGroup.outLine.553" [show x1, show x2, show x3, show x4, show x5
    , show x6, show x7, show x8, show x9] info)
  _ -> failCons cd (consFail "Pretty.oneGroup.outLine.553" (showCons x8))

nd_OP_oneGroup_dot_outLine_dot_553 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> C_Tokens
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func t0
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> t0 -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
nd_OP_oneGroup_dot_outLine_dot_553 x1 x2 x3 x4 x5 x6 x7 x8 x9 s cd cs =
  case x8 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "Pretty.oneGroup.outLine: empty margins") cd cs
  Curry_Prelude.OP_Cons x10 x11 -> let s0 = s
    in s0 `seq` nd_C__case_15 x9 x8 x10 x2 x6 x3 x1 x7 x4 x5 s0 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (nd_OP_oneGroup_dot_outLine_dot_553 x1 x2 x3 x4 x5 x6 x7 l x9 s cd cs)
    (nd_OP_oneGroup_dot_outLine_dot_553 x1 x2 x3 x4 x5 x6 x7 r x9 s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    nd_OP_oneGroup_dot_outLine_dot_553 x1 x2 x3 x4 x5 x6 x7 z x9 s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (nd_OP_oneGroup_dot_outLine_dot_553 x1 x2 x3 x4 x5 x6 x7 e x9 s cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Pretty.oneGroup.outLine.553" [show x1, show x2, show x3, show x4, show x5
    , show x6, show x7, show x8, show x9] info)
  _ -> failCons cd (consFail "Pretty.oneGroup.outLine.553" (showCons x8))

d_OP_oneGroup_dot_uscore_hash_lambda17 :: Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> C_Tokens -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_oneGroup_dot_uscore_hash_lambda17 x1 x2 x3 x4 x5 x6 x7 cd cs =
  Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x5 x6 cd cs) (acceptCs
  (acceptCs id) (d_OP_oneGroup_dot_outLine_dot_553 x1 x2 x3 x4 x6 x7)) cd cs

nd_OP_oneGroup_dot_uscore_hash_lambda17 :: Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> C_Tokens -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Func Curry_Prelude.C_Bool (Func (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))))
  -> Curry_Prelude.C_Bool -> Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> IDSupply
  -> Cover -> ConstStore -> Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
nd_OP_oneGroup_dot_uscore_hash_lambda17 x1 x2 x3 x4 x5 x6 x7 s cd cs =
  let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x5 x6
  s0 cd cs) (wrapDX (wrapDX (wrapNX id)) (acceptCs (acceptCs id)
  (nd_OP_oneGroup_dot_outLine_dot_553 x1 x2 x3 x4 x6 x7))) s1 cd cs))

d_OP_oneGroup_dot_uscore_hash_lambda18 :: Curry_Prelude.C_Bool
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_oneGroup_dot_uscore_hash_lambda18 x1 x2 cd cs = x2

nd_OP_oneGroup_dot_uscore_hash_lambda18 :: Curry_Prelude.C_Bool -> Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))) -> IDSupply -> Cover -> ConstStore -> Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))
nd_OP_oneGroup_dot_uscore_hash_lambda18 x1 x2 s cd cs = x2

d_OP_oneGroup_dot_uscore_hash_lambda19 :: Curry_Prelude.C_Int -> C_Nesting
  -> (Curry_Prelude.C_Bool -> Cover -> ConstStore -> (Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> (Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_oneGroup_dot_uscore_hash_lambda19 x1 x2 x3 x4 x5 cd cs =
  Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x3 x4 cd cs) (acceptCs
  (acceptCs id) (d_OP_oneGroup_dot_uscore_hash_lambda19_dot_uscore_hash_lambda20
  x1 x2 x5)) cd cs

nd_OP_oneGroup_dot_uscore_hash_lambda19 :: Curry_Prelude.C_Int -> C_Nesting
  -> Func Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))) -> Curry_Prelude.C_Bool -> Func Curry_Prelude.C_Int
  (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> IDSupply
  -> Cover -> ConstStore -> Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
nd_OP_oneGroup_dot_uscore_hash_lambda19 x1 x2 x3 x4 x5 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x3 x4
  s0 cd cs) (wrapDX (wrapDX (wrapNX id)) (acceptCs (acceptCs id)
  (nd_OP_oneGroup_dot_uscore_hash_lambda19_dot_uscore_hash_lambda20 x1 x2 x5)))
  s1 cd cs))

d_OP_oneGroup_dot_uscore_hash_lambda19_dot_uscore_hash_lambda20 :: Curry_Prelude.C_Int
  -> C_Nesting -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_oneGroup_dot_uscore_hash_lambda19_dot_uscore_hash_lambda20 x1 x2 x3 x4 x5 x6 cd cs =
  Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x3
  x4 cd cs) (d_C_applyNesting x2 x1 x4 x5 cd cs) cd cs) x6 cd cs

nd_OP_oneGroup_dot_uscore_hash_lambda19_dot_uscore_hash_lambda20 :: Curry_Prelude.C_Int
  -> C_Nesting -> Func Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List
  Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List C_FormatStm)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  C_FormatStm -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
nd_OP_oneGroup_dot_uscore_hash_lambda19_dot_uscore_hash_lambda20 x1 x2 x3 x4 x5 x6 s cd cs =
  let s4 = s
  in s4 `seq` (let s3 = leftSupply s4
                   s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                      s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x3 x4
  s0 cd cs) (d_C_applyNesting x2 x1 x4 x5 cd cs) s1 cd cs)) x6 s3 cd cs))

d_OP_oneGroup_dot_uscore_hash_lambda21 :: (Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> (Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_oneGroup_dot_uscore_hash_lambda21 x1 x2 x3 cd cs = Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply x1 x2 cd cs) (acceptCs (acceptCs id)
  (d_OP_oneGroup_dot_uscore_hash_lambda21_dot_uscore_hash_lambda22 x3)) cd cs

nd_OP_oneGroup_dot_uscore_hash_lambda21 :: Func Curry_Prelude.C_Bool (Func (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))))
  -> Curry_Prelude.C_Bool -> Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> IDSupply
  -> Cover -> ConstStore -> Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
nd_OP_oneGroup_dot_uscore_hash_lambda21 x1 x2 x3 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x1 x2
  s0 cd cs) (wrapDX (wrapDX (wrapNX id)) (acceptCs (acceptCs id)
  (nd_OP_oneGroup_dot_uscore_hash_lambda21_dot_uscore_hash_lambda22 x3))) s1 cd
  cs))

d_OP_oneGroup_dot_uscore_hash_lambda21_dot_uscore_hash_lambda22 :: (Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_oneGroup_dot_uscore_hash_lambda21_dot_uscore_hash_lambda22 x1 x2 x3 x4 cd cs =
  Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x1
  x2 cd cs) (d_C_unApplyNesting x3 cd cs) cd cs) x4 cd cs

nd_OP_oneGroup_dot_uscore_hash_lambda21_dot_uscore_hash_lambda22 :: Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))) -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Curry_Prelude.OP_List C_FormatStm -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
nd_OP_oneGroup_dot_uscore_hash_lambda21_dot_uscore_hash_lambda22 x1 x2 x3 x4 s cd cs =
  let s4 = s
  in s4 `seq` (let s3 = leftSupply s4
                   s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                      s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x1 x2
  s0 cd cs) (d_C_unApplyNesting x3 cd cs) s1 cd cs)) x4 s3 cd cs))

d_OP_oneGroup_dot_outFormat_dot_580 :: forall t0 t1 . (Curry_Prelude.Curry t1
  , Curry_Prelude.Curry t0) => C_FormatStm -> (t0 -> Cover -> ConstStore -> t1
  -> Cover -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> t0 -> t1
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_oneGroup_dot_outFormat_dot_580 x1 x2 x3 x4 x5 cd cs =
  Curry_Prelude.d_OP_plus_plus (d_C_applyFormat x1 cd cs)
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x2
  x3 cd cs) x4 cd cs) (Curry_Prelude.OP_Cons x1 x5) cd cs) cd cs

nd_OP_oneGroup_dot_outFormat_dot_580 :: forall t0 t1 . (Curry_Prelude.Curry t1
  , Curry_Prelude.Curry t0) => C_FormatStm -> Func t0 (Func t1 (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))) -> t0 -> t1 -> Curry_Prelude.OP_List C_FormatStm
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
nd_OP_oneGroup_dot_outFormat_dot_580 x1 x2 x3 x4 x5 s cd cs = let s4 = s
  in s4 `seq` Curry_Prelude.d_OP_plus_plus (d_C_applyFormat x1 cd cs)
  (let s3 = leftSupply s4
       s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                      s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x2 x3
  s0 cd cs) x4 s1 cd cs)) (Curry_Prelude.OP_Cons x1 x5) s3 cd cs)) cd cs

d_OP_oneGroup_dot_uscore_hash_lambda23 :: C_FormatStm -> (Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> (Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_oneGroup_dot_uscore_hash_lambda23 x1 x2 x3 x4 cd cs =
  Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x2 x3 cd cs) (acceptCs
  (acceptCs id) (d_OP_oneGroup_dot_outFormat_dot_580 x1 x4)) cd cs

nd_OP_oneGroup_dot_uscore_hash_lambda23 :: C_FormatStm -> Func
  Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))) -> Curry_Prelude.C_Bool -> Func Curry_Prelude.C_Int
  (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> IDSupply
  -> Cover -> ConstStore -> Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
nd_OP_oneGroup_dot_uscore_hash_lambda23 x1 x2 x3 x4 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x2 x3
  s0 cd cs) (wrapDX (wrapDX (wrapNX id)) (acceptCs (acceptCs id)
  (nd_OP_oneGroup_dot_outFormat_dot_580 x1 x4))) s1 cd cs))

d_OP_oneGroup_dot_outUnformat_dot_585 :: forall t0 t1 . (Curry_Prelude.Curry t1
  , Curry_Prelude.Curry t0) => (t0 -> Cover -> ConstStore -> t1 -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> t0 -> t1
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_oneGroup_dot_outUnformat_dot_585 x1 x2 x3 x4 cd cs =
  let x5 = d_C_resetFormat x4 cd cs
      x6 = d_OP_oneGroup_dot_outUnformat_dot_585_dot_uscore_hash_selFP5_hash_f
        x5 cd cs
      x7 = d_OP_oneGroup_dot_outUnformat_dot_585_dot_uscore_hash_selFP6_hash_ofs
        x5 cd cs
  in Curry_Prelude.d_OP_plus_plus (d_C_applyFormat x6 cd cs)
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x1
  x2 cd cs) x3 cd cs) x7 cd cs) cd cs

nd_OP_oneGroup_dot_outUnformat_dot_585 :: forall t0 t1 . (Curry_Prelude.Curry t1
  , Curry_Prelude.Curry t0) => Func t0 (Func t1 (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> t0 -> t1
  -> Curry_Prelude.OP_List C_FormatStm -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
nd_OP_oneGroup_dot_outUnformat_dot_585 x1 x2 x3 x4 s cd cs = let s4 = s
  in s4 `seq` (let x5 = d_C_resetFormat x4 cd cs
                   x6 = d_OP_oneGroup_dot_outUnformat_dot_585_dot_uscore_hash_selFP5_hash_f
                     x5 cd cs
                   x7 = d_OP_oneGroup_dot_outUnformat_dot_585_dot_uscore_hash_selFP6_hash_ofs
                     x5 cd cs
  in Curry_Prelude.d_OP_plus_plus (d_C_applyFormat x6 cd cs)
  (let s3 = leftSupply s4
       s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                      s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x1 x2
  s0 cd cs) x3 s1 cd cs)) x7 s3 cd cs)) cd cs)

d_OP_oneGroup_dot_outUnformat_dot_585_dot_uscore_hash_selFP5_hash_f :: Curry_Prelude.OP_Tuple2
  C_FormatStm (Curry_Prelude.OP_List C_FormatStm) -> Cover -> ConstStore
  -> C_FormatStm
d_OP_oneGroup_dot_outUnformat_dot_585_dot_uscore_hash_selFP5_hash_f x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_oneGroup_dot_outUnformat_dot_585_dot_uscore_hash_selFP5_hash_f l cd
    cs) (d_OP_oneGroup_dot_outUnformat_dot_585_dot_uscore_hash_selFP5_hash_f r
    cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_oneGroup_dot_outUnformat_dot_585_dot_uscore_hash_selFP5_hash_f z cd cs)
    xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_oneGroup_dot_outUnformat_dot_585_dot_uscore_hash_selFP5_hash_f e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Pretty.oneGroup.outUnformat.585._#selFP5#f" [show x1] info)
  _ -> failCons cd (consFail "Pretty.oneGroup.outUnformat.585._#selFP5#f"
    (showCons x1))

d_OP_oneGroup_dot_outUnformat_dot_585_dot_uscore_hash_selFP6_hash_ofs :: Curry_Prelude.OP_Tuple2
  C_FormatStm (Curry_Prelude.OP_List C_FormatStm) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm
d_OP_oneGroup_dot_outUnformat_dot_585_dot_uscore_hash_selFP6_hash_ofs x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_oneGroup_dot_outUnformat_dot_585_dot_uscore_hash_selFP6_hash_ofs l cd
    cs) (d_OP_oneGroup_dot_outUnformat_dot_585_dot_uscore_hash_selFP6_hash_ofs r
    cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_oneGroup_dot_outUnformat_dot_585_dot_uscore_hash_selFP6_hash_ofs z cd
    cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_oneGroup_dot_outUnformat_dot_585_dot_uscore_hash_selFP6_hash_ofs e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Pretty.oneGroup.outUnformat.585._#selFP6#ofs" [show x1] info)
  _ -> failCons cd (consFail "Pretty.oneGroup.outUnformat.585._#selFP6#ofs"
    (showCons x1))

d_OP_oneGroup_dot_uscore_hash_lambda24 :: (Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> (Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_oneGroup_dot_uscore_hash_lambda24 x1 x2 x3 cd cs = Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply x1 x2 cd cs) (acceptCs (acceptCs id)
  (d_OP_oneGroup_dot_outUnformat_dot_585 x3)) cd cs

nd_OP_oneGroup_dot_uscore_hash_lambda24 :: Func Curry_Prelude.C_Bool (Func (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))))
  -> Curry_Prelude.C_Bool -> Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> IDSupply
  -> Cover -> ConstStore -> Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
nd_OP_oneGroup_dot_uscore_hash_lambda24 x1 x2 x3 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x1 x2
  s0 cd cs) (wrapDX (wrapDX (wrapNX id)) (acceptCs (acceptCs id)
  (nd_OP_oneGroup_dot_outUnformat_dot_585 x3))) s1 cd cs))

d_C_multiGroup :: C_Tokens -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Dequeue.C_Queue
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.C_Int -> (Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_multiGroup x1 x2 x3 x4 x5 x6 x7 x8 cd cs = case x1 of
  C_EOD -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "Pretty.multiGroup: EOD") cd cs
  C_Empty x9 -> d_C_multiGroup x9 x2 x3 x4 x5 x6 x7 x8 cd cs
  C_Text x10 x11 -> let x12 = Curry_Prelude.d_C_apply (d_C_length cd cs) x10 cd
                          cs
    in d_C_pruneMulti x11 x2
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x3 x12 cd cs) x4 x5 x6 x7 (acceptCs id
    (d_OP_multiGroup_dot_uscore_hash_lambda25 x12 x10 x8)) cd cs
  C_LineBreak x13 x14 -> d_C__case_14 x8 x14 x2 x7 x6 x5 x4 x3 x13 cd cs
  C_OpenGroup x17 -> d_C_multiGroup x17 x2 x3 x4 x5 (Curry_Dequeue.d_C_cons
    (Curry_Prelude.OP_Tuple2 x7 x8) x6 cd cs) x3 (acceptCs id
    d_OP_multiGroup_dot_uscore_hash_lambda29) cd cs
  C_CloseGroup x18 -> d_C__case_13 x6 x8 x7 x3 x5 x4 x2 x18
    (Curry_Dequeue.d_C_matchHead x6 cd cs) cd cs
  C_OpenNest x24 x25 -> d_C_multiGroup x25 x2 x3 x4 x5 x6 x7 (acceptCs id
    (d_OP_multiGroup_dot_uscore_hash_lambda35 x2 x24 x8)) cd cs
  C_CloseNest x26 -> d_C_multiGroup x26 x2 x3 x4 x5 x6 x7 (acceptCs id
    (d_OP_multiGroup_dot_uscore_hash_lambda37 x8)) cd cs
  C_OpenFormat x27 x28 -> d_C_multiGroup x28 x2 x3 x4 x5 x6 x7 (acceptCs id
    (d_OP_multiGroup_dot_uscore_hash_lambda39 x27 x8)) cd cs
  C_CloseFormat x29 -> d_C_multiGroup x29 x2 x3 x4 x5 x6 x7 (acceptCs id
    (d_OP_multiGroup_dot_uscore_hash_lambda40 x8)) cd cs
  Choice_C_Tokens d i l r -> narrow d i (d_C_multiGroup l x2 x3 x4 x5 x6 x7 x8
    cd cs) (d_C_multiGroup r x2 x3 x4 x5 x6 x7 x8 cd cs)
  Choices_C_Tokens d i xs -> narrows cs d i (\z -> d_C_multiGroup z x2 x3 x4 x5
    x6 x7 x8 cd cs) xs
  Guard_C_Tokens d c e -> guardCons d c (d_C_multiGroup e x2 x3 x4 x5 x6 x7 x8
    cd $! addCs c cs)
  Fail_C_Tokens d info -> failCons d (traceFail "Pretty.multiGroup" [show x1
    , show x2, show x3, show x4, show x5, show x6, show x7, show x8] info)
  _ -> failCons cd (consFail "Pretty.multiGroup" (showCons x1))

nd_C_multiGroup :: C_Tokens -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Func Curry_Prelude.C_Bool (Func (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))))
  -> Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Func
  Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))))) -> Curry_Prelude.C_Int -> Func
  Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))) -> IDSupply -> Cover -> ConstStore -> Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))
nd_C_multiGroup x1 x2 x3 x4 x5 x6 x7 x8 s cd cs = case x1 of
  C_EOD -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "Pretty.multiGroup: EOD") cd cs
  C_Empty x9 -> let s0 = s
    in s0 `seq` nd_C_multiGroup x9 x2 x3 x4 x5 x6 x7 x8 s0 cd cs
  C_Text x10 x11 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` (let x12 = Curry_Prelude.nd_C_apply (wrapDX id
                                 (d_C_length cd cs)) x10 s0 cd cs
    in nd_C_pruneMulti x11 x2
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x3 x12 cd cs) x4 x5 x6 x7 (wrapDX (wrapNX id) (acceptCs id
    (nd_OP_multiGroup_dot_uscore_hash_lambda25 x12 x10 x8))) s1 cd cs)))
  C_LineBreak x13 x14 -> let s0 = s
    in s0 `seq` nd_C__case_14 x8 x14 x2 x7 x6 x5 x4 x3 x13 s0 cd cs
  C_OpenGroup x17 -> let s0 = s
    in s0 `seq` nd_C_multiGroup x17 x2 x3 x4 x5 (Curry_Dequeue.d_C_cons
    (Curry_Prelude.OP_Tuple2 x7 x8) x6 cd cs) x3 (wrapDX (wrapNX id) (acceptCs
    id nd_OP_multiGroup_dot_uscore_hash_lambda29)) s0 cd cs
  C_CloseGroup x18 -> let s0 = s
    in s0 `seq` nd_C__case_13 x6 x8 x7 x3 x5 x4 x2 x18
    (Curry_Dequeue.d_C_matchHead x6 cd cs) s0 cd cs
  C_OpenNest x24 x25 -> let s0 = s
    in s0 `seq` nd_C_multiGroup x25 x2 x3 x4 x5 x6 x7 (wrapDX (wrapNX id)
    (acceptCs id (nd_OP_multiGroup_dot_uscore_hash_lambda35 x2 x24 x8))) s0 cd
    cs
  C_CloseNest x26 -> let s0 = s
    in s0 `seq` nd_C_multiGroup x26 x2 x3 x4 x5 x6 x7 (wrapDX (wrapNX id)
    (acceptCs id (nd_OP_multiGroup_dot_uscore_hash_lambda37 x8))) s0 cd cs
  C_OpenFormat x27 x28 -> let s0 = s
    in s0 `seq` nd_C_multiGroup x28 x2 x3 x4 x5 x6 x7 (wrapDX (wrapNX id)
    (acceptCs id (nd_OP_multiGroup_dot_uscore_hash_lambda39 x27 x8))) s0 cd cs
  C_CloseFormat x29 -> let s0 = s
    in s0 `seq` nd_C_multiGroup x29 x2 x3 x4 x5 x6 x7 (wrapDX (wrapNX id)
    (acceptCs id (nd_OP_multiGroup_dot_uscore_hash_lambda40 x8))) s0 cd cs
  Choice_C_Tokens d i l r -> narrow d i (nd_C_multiGroup l x2 x3 x4 x5 x6 x7 x8
    s cd cs) (nd_C_multiGroup r x2 x3 x4 x5 x6 x7 x8 s cd cs)
  Choices_C_Tokens d i xs -> narrows cs d i (\z -> nd_C_multiGroup z x2 x3 x4 x5
    x6 x7 x8 s cd cs) xs
  Guard_C_Tokens d c e -> guardCons d c (nd_C_multiGroup e x2 x3 x4 x5 x6 x7 x8
    s cd $! addCs c cs)
  Fail_C_Tokens d info -> failCons d (traceFail "Pretty.multiGroup" [show x1
    , show x2, show x3, show x4, show x5, show x6, show x7, show x8] info)
  _ -> failCons cd (consFail "Pretty.multiGroup" (showCons x1))

d_OP_multiGroup_dot_outText_dot_602 :: forall t0 t1 . (Curry_Prelude.Curry t1
  , Curry_Prelude.Curry t0) => Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> t0
  -> Cover -> ConstStore -> t1 -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Int -> t0 -> t1 -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_multiGroup_dot_outText_dot_602 x1 x2 x3 x4 x5 x6 cd cs =
  Curry_Prelude.d_OP_plus_plus x2 (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x3
  (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
  x4 x1 cd cs) cd cs) x5 cd cs) x6 cd cs) cd cs

nd_OP_multiGroup_dot_outText_dot_602 :: forall t0 t1 . (Curry_Prelude.Curry t1
  , Curry_Prelude.Curry t0) => Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Func Curry_Prelude.C_Int (Func t0 (Func t1
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> Curry_Prelude.C_Int -> t0
  -> t1 -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
nd_OP_multiGroup_dot_outText_dot_602 x1 x2 x3 x4 x5 x6 s cd cs = let s4 = s
  in s4 `seq` Curry_Prelude.d_OP_plus_plus x2 (let s3 = leftSupply s4
                                                   s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                      s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x3
  (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
  x4 x1 cd cs) s0 cd cs) x5 s1 cd cs)) x6 s3 cd cs)) cd cs

d_OP_multiGroup_dot_uscore_hash_lambda25 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> (Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> (Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_multiGroup_dot_uscore_hash_lambda25 x1 x2 x3 x4 x5 cd cs =
  Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x3 x4 cd cs) (acceptCs
  (acceptCs id) (d_OP_multiGroup_dot_outText_dot_602 x1 x2 x5)) cd cs

nd_OP_multiGroup_dot_uscore_hash_lambda25 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Func Curry_Prelude.C_Bool
  (Func (Func Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List
  Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List C_FormatStm)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int
  (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))))
  -> Curry_Prelude.C_Bool -> Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> IDSupply
  -> Cover -> ConstStore -> Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
nd_OP_multiGroup_dot_uscore_hash_lambda25 x1 x2 x3 x4 x5 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x3 x4
  s0 cd cs) (wrapDX (wrapDX (wrapNX id)) (acceptCs (acceptCs id)
  (nd_OP_multiGroup_dot_outText_dot_602 x1 x2 x5))) s1 cd cs))

d_OP_multiGroup_dot_outLine_dot_610 :: forall t1 t0 . (Curry_Prelude.Curry t0
  , Curry_Prelude.Curry t1) => Curry_Prelude.C_Int -> C_Tokens
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> t0 -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> t1 -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> t0 -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_multiGroup_dot_outLine_dot_610 x1 x2 x3 x4 x5 x6 cd cs = case x5 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "Pretty.oneGroup.outLine: empty margins") cd cs
  Curry_Prelude.OP_Cons x7 x8 -> Curry_Prelude.OP_Cons (Curry_Prelude.C_Char
    '\n'#) (Curry_Prelude.d_OP_plus_plus (d_C_addSpaces x7 x2 cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    x3
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x1 x7 cd cs) cd cs) x5 cd cs) x6 cd cs) cd cs)
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_multiGroup_dot_outLine_dot_610 x1 x2 x3 x4 l x6 cd cs)
    (d_OP_multiGroup_dot_outLine_dot_610 x1 x2 x3 x4 r x6 cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_multiGroup_dot_outLine_dot_610 x1 x2 x3 x4 z x6 cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_multiGroup_dot_outLine_dot_610 x1 x2 x3 x4 e x6 cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Pretty.multiGroup.outLine.610" [show x1, show x2, show x3, show x4, show x5
    , show x6] info)
  _ -> failCons cd (consFail "Pretty.multiGroup.outLine.610" (showCons x5))

nd_OP_multiGroup_dot_outLine_dot_610 :: forall t1 t0 . (Curry_Prelude.Curry t0
  , Curry_Prelude.Curry t1) => Curry_Prelude.C_Int -> C_Tokens -> Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func t0
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> t1 -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> t0 -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
nd_OP_multiGroup_dot_outLine_dot_610 x1 x2 x3 x4 x5 x6 s cd cs = case x5 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "Pretty.oneGroup.outLine: empty margins") cd cs
  Curry_Prelude.OP_Cons x7 x8 -> let s4 = s
    in s4 `seq` Curry_Prelude.OP_Cons (Curry_Prelude.C_Char '\n'#)
    (Curry_Prelude.d_OP_plus_plus (d_C_addSpaces x7 x2 cd cs)
    (let s3 = leftSupply s4
         s2 = rightSupply s4
    in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                        s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x3
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x1 x7 cd cs) s0 cd cs) x5 s1 cd cs)) x6 s3 cd cs)) cd cs)
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (nd_OP_multiGroup_dot_outLine_dot_610 x1 x2 x3 x4 l x6 s cd cs)
    (nd_OP_multiGroup_dot_outLine_dot_610 x1 x2 x3 x4 r x6 s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    nd_OP_multiGroup_dot_outLine_dot_610 x1 x2 x3 x4 z x6 s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (nd_OP_multiGroup_dot_outLine_dot_610 x1 x2 x3 x4 e x6 s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Pretty.multiGroup.outLine.610" [show x1, show x2, show x3, show x4, show x5
    , show x6] info)
  _ -> failCons cd (consFail "Pretty.multiGroup.outLine.610" (showCons x5))

d_OP_multiGroup_dot_pruneAll_dot_610 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> C_Tokens
  -> (Curry_Prelude.C_Bool -> Cover -> ConstStore -> (Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Dequeue.C_Queue
  (Curry_Prelude.OP_Tuple2 t0 (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_multiGroup_dot_pruneAll_dot_610 x1 x2 x3 x4 x5 x6 cd cs =
  Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x5 Curry_Prelude.C_False cd
  cs) (d_OP_multiGroup_dot_pruneAll_dot_610_dot_uscore_hash_lambda26 x1 x2 x3 x6
  x4) cd cs

nd_OP_multiGroup_dot_pruneAll_dot_610 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> C_Tokens -> Func
  Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))) -> Func Curry_Prelude.C_Bool (Func (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))))
  -> Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2 t0 (Func
  Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))))) -> IDSupply -> Cover -> ConstStore -> Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))
nd_OP_multiGroup_dot_pruneAll_dot_610 x1 x2 x3 x4 x5 x6 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x5
  Curry_Prelude.C_False s0 cd cs) (wrapNX id
  (nd_OP_multiGroup_dot_pruneAll_dot_610_dot_uscore_hash_lambda26 x1 x2 x3 x6
  x4)) s1 cd cs))

d_OP_multiGroup_dot_pruneAll_dot_610_dot_uscore_hash_lambda26 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> C_Tokens
  -> Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2 t0 (Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_multiGroup_dot_pruneAll_dot_610_dot_uscore_hash_lambda26 x1 x2 x3 x4 x5 x6 cd cs =
  d_C__case_10 x4 x6 x5 x3 x2 x1 (Curry_Dequeue.d_C_matchLast x4 cd cs) cd cs

nd_OP_multiGroup_dot_pruneAll_dot_610_dot_uscore_hash_lambda26 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> C_Tokens
  -> Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2 t0 (Func
  Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))))) -> Func Curry_Prelude.C_Bool (Func (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))))
  -> Curry_Prelude.C_Int -> IDSupply -> Cover -> ConstStore -> Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_OP_multiGroup_dot_pruneAll_dot_610_dot_uscore_hash_lambda26 x1 x2 x3 x4 x5 x6 s cd cs =
  let s0 = s
  in s0 `seq` nd_C__case_10 x4 x6 x5 x3 x2 x1 (Curry_Dequeue.d_C_matchLast x4 cd
  cs) s0 cd cs

d_OP_multiGroup_dot_outLine_dot_629 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> C_Tokens
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> t0 -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> t0 -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_multiGroup_dot_outLine_dot_629 x1 x2 x3 x4 x5 x6 x7 x8 x9 cd cs =
  case x8 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "Pretty.multiGroup.outLine: empty margins") cd cs
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_7 x9 x8 x10 x2 x6 x3 x1 x7 x4 x5 cd
    cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_multiGroup_dot_outLine_dot_629 x1 x2 x3 x4 x5 x6 x7 l x9 cd cs)
    (d_OP_multiGroup_dot_outLine_dot_629 x1 x2 x3 x4 x5 x6 x7 r x9 cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_multiGroup_dot_outLine_dot_629 x1 x2 x3 x4 x5 x6 x7 z x9 cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_multiGroup_dot_outLine_dot_629 x1 x2 x3 x4 x5 x6 x7 e x9 cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Pretty.multiGroup.outLine.629" [show x1, show x2, show x3, show x4, show x5
    , show x6, show x7, show x8, show x9] info)
  _ -> failCons cd (consFail "Pretty.multiGroup.outLine.629" (showCons x8))

nd_OP_multiGroup_dot_outLine_dot_629 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> C_Tokens
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func t0
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> t0 -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
nd_OP_multiGroup_dot_outLine_dot_629 x1 x2 x3 x4 x5 x6 x7 x8 x9 s cd cs =
  case x8 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "Pretty.multiGroup.outLine: empty margins") cd cs
  Curry_Prelude.OP_Cons x10 x11 -> let s0 = s
    in s0 `seq` nd_C__case_7 x9 x8 x10 x2 x6 x3 x1 x7 x4 x5 s0 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (nd_OP_multiGroup_dot_outLine_dot_629 x1 x2 x3 x4 x5 x6 x7 l x9 s cd cs)
    (nd_OP_multiGroup_dot_outLine_dot_629 x1 x2 x3 x4 x5 x6 x7 r x9 s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    nd_OP_multiGroup_dot_outLine_dot_629 x1 x2 x3 x4 x5 x6 x7 z x9 s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (nd_OP_multiGroup_dot_outLine_dot_629 x1 x2 x3 x4 x5 x6 x7 e x9 s cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Pretty.multiGroup.outLine.629" [show x1, show x2, show x3, show x4, show x5
    , show x6, show x7, show x8, show x9] info)
  _ -> failCons cd (consFail "Pretty.multiGroup.outLine.629" (showCons x8))

d_OP_multiGroup_dot_uscore_hash_lambda28 :: Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> C_Tokens -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_multiGroup_dot_uscore_hash_lambda28 x1 x2 x3 x4 x5 x6 x7 cd cs =
  Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x5 x6 cd cs) (acceptCs
  (acceptCs id) (d_OP_multiGroup_dot_outLine_dot_629 x1 x2 x3 x4 x6 x7)) cd cs

nd_OP_multiGroup_dot_uscore_hash_lambda28 :: Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> C_Tokens -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Func Curry_Prelude.C_Bool (Func (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))))
  -> Curry_Prelude.C_Bool -> Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> IDSupply
  -> Cover -> ConstStore -> Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
nd_OP_multiGroup_dot_uscore_hash_lambda28 x1 x2 x3 x4 x5 x6 x7 s cd cs =
  let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x5 x6
  s0 cd cs) (wrapDX (wrapDX (wrapNX id)) (acceptCs (acceptCs id)
  (nd_OP_multiGroup_dot_outLine_dot_629 x1 x2 x3 x4 x6 x7))) s1 cd cs))

d_OP_multiGroup_dot_uscore_hash_lambda29 :: Curry_Prelude.C_Bool
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_multiGroup_dot_uscore_hash_lambda29 x1 x2 cd cs = x2

nd_OP_multiGroup_dot_uscore_hash_lambda29 :: Curry_Prelude.C_Bool -> Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))) -> IDSupply -> Cover -> ConstStore -> Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))
nd_OP_multiGroup_dot_uscore_hash_lambda29 x1 x2 s cd cs = x2

d_OP_multiGroup_dot_uscore_hash_lambda31 :: Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> (Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> (Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_multiGroup_dot_uscore_hash_lambda31 x1 x2 x3 x4 x5 x6 cd cs =
  Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x4 x5 cd cs)
  (d_OP_multiGroup_dot_uscore_hash_lambda31_dot_uscore_hash_lambda32 x1 x2 x3
  x6) cd cs

nd_OP_multiGroup_dot_uscore_hash_lambda31 :: Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Func Curry_Prelude.C_Bool (Func (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))))) -> Func
  Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))) -> Curry_Prelude.C_Bool -> Func Curry_Prelude.C_Int
  (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> IDSupply
  -> Cover -> ConstStore -> Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
nd_OP_multiGroup_dot_uscore_hash_lambda31 x1 x2 x3 x4 x5 x6 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x4 x5
  s0 cd cs) (wrapNX id
  (nd_OP_multiGroup_dot_uscore_hash_lambda31_dot_uscore_hash_lambda32 x1 x2 x3
  x6)) s1 cd cs))

d_OP_multiGroup_dot_uscore_hash_lambda31_dot_uscore_hash_lambda32 :: Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> (Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_multiGroup_dot_uscore_hash_lambda31_dot_uscore_hash_lambda32 x1 x2 x3 x4 x5 cd cs =
  Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x3
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
  x1
  (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
  x2 x5 cd cs) cd cs) cd cs) x4 cd cs) x5 cd cs

nd_OP_multiGroup_dot_uscore_hash_lambda31_dot_uscore_hash_lambda32 :: Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Func Curry_Prelude.C_Bool (Func (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))))) -> Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))) -> Curry_Prelude.C_Int -> IDSupply -> Cover
  -> ConstStore -> Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
nd_OP_multiGroup_dot_uscore_hash_lambda31_dot_uscore_hash_lambda32 x1 x2 x3 x4 x5 s cd cs =
  let s4 = s
  in s4 `seq` (let s3 = leftSupply s4
                   s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                      s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x3
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
  x1
  (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
  x2 x5 cd cs) cd cs) s0 cd cs) x4 s1 cd cs)) x5 s3 cd cs))

d_OP_multiGroup_dot_uscore_hash_lambda33 :: Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> (Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> (Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_multiGroup_dot_uscore_hash_lambda33 x1 x2 x3 x4 x5 x6 cd cs =
  Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x3 x5 cd cs)
  (d_OP_multiGroup_dot_uscore_hash_lambda33_dot_uscore_hash_lambda34 x1 x2 x4
  x6) cd cs

nd_OP_multiGroup_dot_uscore_hash_lambda33 :: Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Func Curry_Prelude.C_Bool (Func (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))))) -> Func
  Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))) -> Curry_Prelude.C_Bool -> Func Curry_Prelude.C_Int
  (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> IDSupply
  -> Cover -> ConstStore -> Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
nd_OP_multiGroup_dot_uscore_hash_lambda33 x1 x2 x3 x4 x5 x6 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x3 x5
  s0 cd cs) (wrapNX id
  (nd_OP_multiGroup_dot_uscore_hash_lambda33_dot_uscore_hash_lambda34 x1 x2 x4
  x6)) s1 cd cs))

d_OP_multiGroup_dot_uscore_hash_lambda33_dot_uscore_hash_lambda34 :: Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> (Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_multiGroup_dot_uscore_hash_lambda33_dot_uscore_hash_lambda34 x1 x2 x3 x4 x5 cd cs =
  Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x3
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
  x1
  (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
  x2 x5 cd cs) cd cs) cd cs) x4 cd cs) x5 cd cs

nd_OP_multiGroup_dot_uscore_hash_lambda33_dot_uscore_hash_lambda34 :: Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Func Curry_Prelude.C_Bool (Func (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))))) -> Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))) -> Curry_Prelude.C_Int -> IDSupply -> Cover
  -> ConstStore -> Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
nd_OP_multiGroup_dot_uscore_hash_lambda33_dot_uscore_hash_lambda34 x1 x2 x3 x4 x5 s cd cs =
  let s4 = s
  in s4 `seq` (let s3 = leftSupply s4
                   s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                      s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x3
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
  x1
  (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
  x2 x5 cd cs) cd cs) s0 cd cs) x4 s1 cd cs)) x5 s3 cd cs))

d_OP_multiGroup_dot_uscore_hash_lambda35 :: Curry_Prelude.C_Int -> C_Nesting
  -> (Curry_Prelude.C_Bool -> Cover -> ConstStore -> (Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> (Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_multiGroup_dot_uscore_hash_lambda35 x1 x2 x3 x4 x5 cd cs =
  Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x3 x4 cd cs) (acceptCs
  (acceptCs id)
  (d_OP_multiGroup_dot_uscore_hash_lambda35_dot_uscore_hash_lambda36 x1 x2 x5))
  cd cs

nd_OP_multiGroup_dot_uscore_hash_lambda35 :: Curry_Prelude.C_Int -> C_Nesting
  -> Func Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))) -> Curry_Prelude.C_Bool -> Func Curry_Prelude.C_Int
  (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> IDSupply
  -> Cover -> ConstStore -> Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
nd_OP_multiGroup_dot_uscore_hash_lambda35 x1 x2 x3 x4 x5 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x3 x4
  s0 cd cs) (wrapDX (wrapDX (wrapNX id)) (acceptCs (acceptCs id)
  (nd_OP_multiGroup_dot_uscore_hash_lambda35_dot_uscore_hash_lambda36 x1 x2
  x5))) s1 cd cs))

d_OP_multiGroup_dot_uscore_hash_lambda35_dot_uscore_hash_lambda36 :: Curry_Prelude.C_Int
  -> C_Nesting -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_multiGroup_dot_uscore_hash_lambda35_dot_uscore_hash_lambda36 x1 x2 x3 x4 x5 x6 cd cs =
  Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x3
  x4 cd cs) (d_C_applyNesting x2 x1 x4 x5 cd cs) cd cs) x6 cd cs

nd_OP_multiGroup_dot_uscore_hash_lambda35_dot_uscore_hash_lambda36 :: Curry_Prelude.C_Int
  -> C_Nesting -> Func Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List
  Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List C_FormatStm)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  C_FormatStm -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
nd_OP_multiGroup_dot_uscore_hash_lambda35_dot_uscore_hash_lambda36 x1 x2 x3 x4 x5 x6 s cd cs =
  let s4 = s
  in s4 `seq` (let s3 = leftSupply s4
                   s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                      s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x3 x4
  s0 cd cs) (d_C_applyNesting x2 x1 x4 x5 cd cs) s1 cd cs)) x6 s3 cd cs))

d_OP_multiGroup_dot_uscore_hash_lambda37 :: (Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> (Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_multiGroup_dot_uscore_hash_lambda37 x1 x2 x3 cd cs =
  Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x1 x2 cd cs) (acceptCs
  (acceptCs id)
  (d_OP_multiGroup_dot_uscore_hash_lambda37_dot_uscore_hash_lambda38 x3)) cd cs

nd_OP_multiGroup_dot_uscore_hash_lambda37 :: Func Curry_Prelude.C_Bool (Func
  (Func Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  (Func (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))))
  -> Curry_Prelude.C_Bool -> Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> IDSupply
  -> Cover -> ConstStore -> Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
nd_OP_multiGroup_dot_uscore_hash_lambda37 x1 x2 x3 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x1 x2
  s0 cd cs) (wrapDX (wrapDX (wrapNX id)) (acceptCs (acceptCs id)
  (nd_OP_multiGroup_dot_uscore_hash_lambda37_dot_uscore_hash_lambda38 x3))) s1
  cd cs))

d_OP_multiGroup_dot_uscore_hash_lambda37_dot_uscore_hash_lambda38 :: (Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_multiGroup_dot_uscore_hash_lambda37_dot_uscore_hash_lambda38 x1 x2 x3 x4 cd cs =
  Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x1
  x2 cd cs) (d_C_unApplyNesting x3 cd cs) cd cs) x4 cd cs

nd_OP_multiGroup_dot_uscore_hash_lambda37_dot_uscore_hash_lambda38 :: Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))) -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Curry_Prelude.OP_List C_FormatStm -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
nd_OP_multiGroup_dot_uscore_hash_lambda37_dot_uscore_hash_lambda38 x1 x2 x3 x4 s cd cs =
  let s4 = s
  in s4 `seq` (let s3 = leftSupply s4
                   s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                      s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x1 x2
  s0 cd cs) (d_C_unApplyNesting x3 cd cs) s1 cd cs)) x4 s3 cd cs))

d_OP_multiGroup_dot_outFormat_dot_664 :: forall t0 t1 . (Curry_Prelude.Curry t1
  , Curry_Prelude.Curry t0) => C_FormatStm -> (t0 -> Cover -> ConstStore -> t1
  -> Cover -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> t0 -> t1
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_multiGroup_dot_outFormat_dot_664 x1 x2 x3 x4 x5 cd cs =
  Curry_Prelude.d_OP_plus_plus (d_C_applyFormat x1 cd cs)
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x2
  x3 cd cs) x4 cd cs) (Curry_Prelude.OP_Cons x1 x5) cd cs) cd cs

nd_OP_multiGroup_dot_outFormat_dot_664 :: forall t0 t1 . (Curry_Prelude.Curry t1
  , Curry_Prelude.Curry t0) => C_FormatStm -> Func t0 (Func t1 (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))) -> t0 -> t1 -> Curry_Prelude.OP_List C_FormatStm
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
nd_OP_multiGroup_dot_outFormat_dot_664 x1 x2 x3 x4 x5 s cd cs = let s4 = s
  in s4 `seq` Curry_Prelude.d_OP_plus_plus (d_C_applyFormat x1 cd cs)
  (let s3 = leftSupply s4
       s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                      s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x2 x3
  s0 cd cs) x4 s1 cd cs)) (Curry_Prelude.OP_Cons x1 x5) s3 cd cs)) cd cs

d_OP_multiGroup_dot_uscore_hash_lambda39 :: C_FormatStm -> (Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> (Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_multiGroup_dot_uscore_hash_lambda39 x1 x2 x3 x4 cd cs =
  Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x2 x3 cd cs) (acceptCs
  (acceptCs id) (d_OP_multiGroup_dot_outFormat_dot_664 x1 x4)) cd cs

nd_OP_multiGroup_dot_uscore_hash_lambda39 :: C_FormatStm -> Func
  Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))) -> Curry_Prelude.C_Bool -> Func Curry_Prelude.C_Int
  (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> IDSupply
  -> Cover -> ConstStore -> Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
nd_OP_multiGroup_dot_uscore_hash_lambda39 x1 x2 x3 x4 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x2 x3
  s0 cd cs) (wrapDX (wrapDX (wrapNX id)) (acceptCs (acceptCs id)
  (nd_OP_multiGroup_dot_outFormat_dot_664 x1 x4))) s1 cd cs))

d_OP_multiGroup_dot_outUnformat_dot_669 :: forall t0 t1 . (Curry_Prelude.Curry
  t1, Curry_Prelude.Curry t0) => (t0 -> Cover -> ConstStore -> t1 -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> t0 -> t1
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_multiGroup_dot_outUnformat_dot_669 x1 x2 x3 x4 cd cs =
  let x5 = d_C_resetFormat x4 cd cs
      x6 = d_OP_multiGroup_dot_outUnformat_dot_669_dot_uscore_hash_selFP8_hash_f
        x5 cd cs
      x7 = d_OP_multiGroup_dot_outUnformat_dot_669_dot_uscore_hash_selFP9_hash_ofs
        x5 cd cs
  in Curry_Prelude.d_OP_plus_plus (d_C_applyFormat x6 cd cs)
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x1
  x2 cd cs) x3 cd cs) x7 cd cs) cd cs

nd_OP_multiGroup_dot_outUnformat_dot_669 :: forall t0 t1 . (Curry_Prelude.Curry
  t1, Curry_Prelude.Curry t0) => Func t0 (Func t1 (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> t0 -> t1
  -> Curry_Prelude.OP_List C_FormatStm -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
nd_OP_multiGroup_dot_outUnformat_dot_669 x1 x2 x3 x4 s cd cs = let s4 = s
  in s4 `seq` (let x5 = d_C_resetFormat x4 cd cs
                   x6 = d_OP_multiGroup_dot_outUnformat_dot_669_dot_uscore_hash_selFP8_hash_f
                     x5 cd cs
                   x7 = d_OP_multiGroup_dot_outUnformat_dot_669_dot_uscore_hash_selFP9_hash_ofs
                     x5 cd cs
  in Curry_Prelude.d_OP_plus_plus (d_C_applyFormat x6 cd cs)
  (let s3 = leftSupply s4
       s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                      s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x1 x2
  s0 cd cs) x3 s1 cd cs)) x7 s3 cd cs)) cd cs)

d_OP_multiGroup_dot_outUnformat_dot_669_dot_uscore_hash_selFP8_hash_f :: Curry_Prelude.OP_Tuple2
  C_FormatStm (Curry_Prelude.OP_List C_FormatStm) -> Cover -> ConstStore
  -> C_FormatStm
d_OP_multiGroup_dot_outUnformat_dot_669_dot_uscore_hash_selFP8_hash_f x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_multiGroup_dot_outUnformat_dot_669_dot_uscore_hash_selFP8_hash_f l cd
    cs) (d_OP_multiGroup_dot_outUnformat_dot_669_dot_uscore_hash_selFP8_hash_f r
    cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_multiGroup_dot_outUnformat_dot_669_dot_uscore_hash_selFP8_hash_f z cd
    cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_multiGroup_dot_outUnformat_dot_669_dot_uscore_hash_selFP8_hash_f e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Pretty.multiGroup.outUnformat.669._#selFP8#f" [show x1] info)
  _ -> failCons cd (consFail "Pretty.multiGroup.outUnformat.669._#selFP8#f"
    (showCons x1))

d_OP_multiGroup_dot_outUnformat_dot_669_dot_uscore_hash_selFP9_hash_ofs :: Curry_Prelude.OP_Tuple2
  C_FormatStm (Curry_Prelude.OP_List C_FormatStm) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm
d_OP_multiGroup_dot_outUnformat_dot_669_dot_uscore_hash_selFP9_hash_ofs x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_multiGroup_dot_outUnformat_dot_669_dot_uscore_hash_selFP9_hash_ofs l
    cd cs)
    (d_OP_multiGroup_dot_outUnformat_dot_669_dot_uscore_hash_selFP9_hash_ofs r
    cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_multiGroup_dot_outUnformat_dot_669_dot_uscore_hash_selFP9_hash_ofs z cd
    cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_multiGroup_dot_outUnformat_dot_669_dot_uscore_hash_selFP9_hash_ofs e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Pretty.multiGroup.outUnformat.669._#selFP9#ofs" [show x1] info)
  _ -> failCons cd (consFail "Pretty.multiGroup.outUnformat.669._#selFP9#ofs"
    (showCons x1))

d_OP_multiGroup_dot_uscore_hash_lambda40 :: (Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> (Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_multiGroup_dot_uscore_hash_lambda40 x1 x2 x3 cd cs =
  Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x1 x2 cd cs) (acceptCs
  (acceptCs id) (d_OP_multiGroup_dot_outUnformat_dot_669 x3)) cd cs

nd_OP_multiGroup_dot_uscore_hash_lambda40 :: Func Curry_Prelude.C_Bool (Func
  (Func Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  (Func (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))))
  -> Curry_Prelude.C_Bool -> Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> IDSupply
  -> Cover -> ConstStore -> Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
nd_OP_multiGroup_dot_uscore_hash_lambda40 x1 x2 x3 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x1 x2
  s0 cd cs) (wrapDX (wrapDX (wrapNX id)) (acceptCs (acceptCs id)
  (nd_OP_multiGroup_dot_outUnformat_dot_669 x3))) s1 cd cs))

d_C_pruneOne :: C_Tokens -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_pruneOne x1 x2 x3 x4 x5 cd cs = d_C__case_6 x4 x3 x2 x1 x5
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
  x3 x4 cd cs) cd cs

nd_C_pruneOne :: C_Tokens -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Func Curry_Prelude.C_Bool (Func (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))))) -> IDSupply
  -> Cover -> ConstStore -> Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
nd_C_pruneOne x1 x2 x3 x4 x5 s cd cs = let s0 = s
  in s0 `seq` nd_C__case_6 x4 x3 x2 x1 x5
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
  x3 x4 cd cs) s0 cd cs

d_C_pruneMulti :: C_Tokens -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Dequeue.C_Queue
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.C_Int -> (Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_pruneMulti x1 x2 x3 x4 x5 x6 x7 x8 cd cs = d_C__case_4 x4 x3 x8 x6 x1 x2 x7
  x5
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
  x3 x4 cd cs) cd cs

nd_C_pruneMulti :: C_Tokens -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Func Curry_Prelude.C_Bool (Func (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))))
  -> Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Func
  Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))))) -> Curry_Prelude.C_Int -> Func
  Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))) -> IDSupply -> Cover -> ConstStore -> Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))
nd_C_pruneMulti x1 x2 x3 x4 x5 x6 x7 x8 s cd cs = let s0 = s
  in s0 `seq` nd_C__case_4 x4 x3 x8 x6 x1 x2 x7 x5
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
  x3 x4 cd cs) s0 cd cs

d_OP_pruneMulti_dot_uscore_hash_lambda41 :: Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> C_Tokens
  -> Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.C_Bool -> Cover -> ConstStore -> (Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_pruneMulti_dot_uscore_hash_lambda41 x1 x2 x3 x4 x5 x6 x7 cd cs =
  d_C__case_2 x5 x7 x6 x2 x1 x3 x4 (Curry_Dequeue.d_C_matchLast x5 cd cs) cd cs

nd_OP_pruneMulti_dot_uscore_hash_lambda41 :: Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> C_Tokens
  -> Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Func
  Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))))) -> Func Curry_Prelude.C_Bool (Func (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))))
  -> Curry_Prelude.C_Int -> IDSupply -> Cover -> ConstStore -> Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_OP_pruneMulti_dot_uscore_hash_lambda41 x1 x2 x3 x4 x5 x6 x7 s cd cs =
  let s0 = s
  in s0 `seq` nd_C__case_2 x5 x7 x6 x2 x1 x3 x4 (Curry_Dequeue.d_C_matchLast x5
  cd cs) s0 cd cs

d_C_inspect :: C_Doc -> Cover -> ConstStore -> C_Tokens
d_C_inspect x1 cd cs = case x1 of
  C_Doc x2 -> Curry_Prelude.d_C_apply (d_C_normalise cd cs)
    (Curry_Prelude.d_C_apply x2 C_EOD cd cs) cd cs
  Choice_C_Doc d i l r -> narrow d i (d_C_inspect l cd cs) (d_C_inspect r cd cs)
  Choices_C_Doc d i xs -> narrows cs d i (\z -> d_C_inspect z cd cs) xs
  Guard_C_Doc d c e -> guardCons d c (d_C_inspect e cd $! addCs c cs)
  Fail_C_Doc d info -> failCons d (traceFail "Pretty.inspect" [show x1] info)
  _ -> failCons cd (consFail "Pretty.inspect" (showCons x1))

nd_C_inspect :: C_Doc -> IDSupply -> Cover -> ConstStore -> C_Tokens
nd_C_inspect x1 s cd cs = case x1 of
  HO_C_Doc x2 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (wrapDX id (d_C_normalise cd
    cs)) (Curry_Prelude.nd_C_apply x2 C_EOD s0 cd cs) s1 cd cs))
  Choice_C_Doc d i l r -> narrow d i (nd_C_inspect l s cd cs) (nd_C_inspect r s
    cd cs)
  Choices_C_Doc d i xs -> narrows cs d i (\z -> nd_C_inspect z s cd cs) xs
  Guard_C_Doc d c e -> guardCons d c (nd_C_inspect e s cd $! addCs c cs)
  Fail_C_Doc d info -> failCons d (traceFail "Pretty.inspect" [show x1] info)
  _ -> failCons cd (consFail "Pretty.inspect" (showCons x1))

d_C__case_2 :: Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Curry_Prelude.C_Int
  -> (Curry_Prelude.C_Bool -> Cover -> ConstStore -> (Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> C_Tokens -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.C_Bool -> Cover -> ConstStore -> (Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) (Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char)))) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_2 x5 x7 x6 x2 x1 x3 x4 x9 cd cs = case x9 of
  Curry_Prelude.C_Nothing -> Curry_Prelude.d_C_apply (d_C_pruneOne x4 x3 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x2 x7 cd cs) x6 cd cs) x7 cd cs
  Curry_Prelude.C_Just x8 -> d_C__case_1 x7 x6 x2 x1 x3 x4 x8 cd cs
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (d_C__case_2 x5 x7 x6 x2 x1
    x3 x4 l cd cs) (d_C__case_2 x5 x7 x6 x2 x1 x3 x4 r cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> d_C__case_2 x5
    x7 x6 x2 x1 x3 x4 z cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (d_C__case_2 x5 x7 x6 x2 x1
    x3 x4 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail "Pretty._case_2"
    [show x5, show x7, show x6, show x2, show x1, show x3, show x4, show x9]
    info)
  _ -> failCons cd (consFail "Pretty._case_2" (showCons x9))

nd_C__case_2 :: Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Func Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int
  (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))))) -> Curry_Prelude.C_Int -> Func
  Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))) -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> C_Tokens -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Func
  Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))))) (Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Func Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int
  (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))))))) -> IDSupply -> Cover -> ConstStore -> Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C__case_2 x5 x7 x6 x2 x1 x3 x4 x9 s cd cs = case x9 of
  Curry_Prelude.C_Nothing -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (nd_C_pruneOne x4 x3 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x2 x7 cd cs) x6 s0 cd cs) x7 s1 cd cs))
  Curry_Prelude.C_Just x8 -> let s0 = s
    in s0 `seq` nd_C__case_1 x7 x6 x2 x1 x3 x4 x8 s0 cd cs
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (nd_C__case_2 x5 x7 x6 x2
    x1 x3 x4 l s cd cs) (nd_C__case_2 x5 x7 x6 x2 x1 x3 x4 r s cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> nd_C__case_2 x5
    x7 x6 x2 x1 x3 x4 z s cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (nd_C__case_2 x5 x7 x6 x2
    x1 x3 x4 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail "Pretty._case_2"
    [show x5, show x7, show x6, show x2, show x1, show x3, show x4, show x9]
    info)
  _ -> failCons cd (consFail "Pretty._case_2" (showCons x9))

d_C__case_1 :: Curry_Prelude.C_Int -> (Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> C_Tokens -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) (Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_1 x7 x6 x2 x1 x3 x4 x8 cd cs = case x8 of
  Curry_Prelude.OP_Tuple2 x9 x10 -> d_C__case_0 x7 x6 x2 x10 x1 x3 x4 x9 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C__case_1 x7 x6 x2 x1
    x3 x4 l cd cs) (d_C__case_1 x7 x6 x2 x1 x3 x4 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C__case_1 x7
    x6 x2 x1 x3 x4 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C__case_1 x7 x6 x2 x1
    x3 x4 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail "Pretty._case_1"
    [show x7, show x6, show x2, show x1, show x3, show x4, show x8] info)
  _ -> failCons cd (consFail "Pretty._case_1" (showCons x8))

nd_C__case_1 :: Curry_Prelude.C_Int -> Func Curry_Prelude.C_Bool (Func (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))))
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> C_Tokens -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Func Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int
  (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))))) (Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Func Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int
  (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))))))) -> IDSupply -> Cover -> ConstStore -> Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C__case_1 x7 x6 x2 x1 x3 x4 x8 s cd cs = case x8 of
  Curry_Prelude.OP_Tuple2 x9 x10 -> let s0 = s
    in s0 `seq` nd_C__case_0 x7 x6 x2 x10 x1 x3 x4 x9 s0 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (nd_C__case_1 x7 x6 x2 x1
    x3 x4 l s cd cs) (nd_C__case_1 x7 x6 x2 x1 x3 x4 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> nd_C__case_1
    x7 x6 x2 x1 x3 x4 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (nd_C__case_1 x7 x6 x2 x1
    x3 x4 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail "Pretty._case_1"
    [show x7, show x6, show x2, show x1, show x3, show x4, show x8] info)
  _ -> failCons cd (consFail "Pretty._case_1" (showCons x8))

d_C__case_0 :: Curry_Prelude.C_Int -> (Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Int -> Curry_Dequeue.C_Queue
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> C_Tokens -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.C_Bool -> Cover -> ConstStore -> (Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_0 x7 x6 x2 x10 x1 x3 x4 x9 cd cs = case x9 of
  Curry_Prelude.OP_Tuple2 x11 x12 -> Curry_Prelude.d_C_apply (d_C_pruneMulti x4
    x3 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x11 x7 cd cs) x12 x10 x2 x6 cd cs) x7 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C__case_0 x7 x6 x2 x10
    x1 x3 x4 l cd cs) (d_C__case_0 x7 x6 x2 x10 x1 x3 x4 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C__case_0 x7
    x6 x2 x10 x1 x3 x4 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C__case_0 x7 x6 x2 x10
    x1 x3 x4 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail "Pretty._case_0"
    [show x7, show x6, show x2, show x10, show x1, show x3, show x4, show x9]
    info)
  _ -> failCons cd (consFail "Pretty._case_0" (showCons x9))

nd_C__case_0 :: Curry_Prelude.C_Int -> Func Curry_Prelude.C_Bool (Func (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))))
  -> Curry_Prelude.C_Int -> Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Func Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int
  (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))))) -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> C_Tokens -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Func
  Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))))) -> IDSupply -> Cover -> ConstStore -> Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C__case_0 x7 x6 x2 x10 x1 x3 x4 x9 s cd cs = case x9 of
  Curry_Prelude.OP_Tuple2 x11 x12 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (nd_C_pruneMulti x4 x3 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x11 x7 cd cs) x12 x10 x2 x6 s0 cd cs) x7 s1 cd cs))
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (nd_C__case_0 x7 x6 x2
    x10 x1 x3 x4 l s cd cs) (nd_C__case_0 x7 x6 x2 x10 x1 x3 x4 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> nd_C__case_0
    x7 x6 x2 x10 x1 x3 x4 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (nd_C__case_0 x7 x6 x2
    x10 x1 x3 x4 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail "Pretty._case_0"
    [show x7, show x6, show x2, show x10, show x1, show x3, show x4, show x9]
    info)
  _ -> failCons cd (consFail "Pretty._case_0" (showCons x9))

d_C__case_4 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> (Curry_Prelude.C_Bool -> Cover -> ConstStore -> (Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> C_Tokens
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> (Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_4 x4 x3 x8 x6 x1 x2 x7 x5 x9 cd cs = case x9 of
  Curry_Prelude.C_True -> d_C_multiGroup x1 x2 x3 x4 x5 x6 x7 x8 cd cs
  Curry_Prelude.C_False -> d_C__case_3 x8 x6 x1 x2 x7 x3 x5
    (Curry_Prelude.d_C_otherwise cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_4 x4 x3 x8 x6 x1
    x2 x7 x5 l cd cs) (d_C__case_4 x4 x3 x8 x6 x1 x2 x7 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_4 x4 x3
    x8 x6 x1 x2 x7 x5 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_4 x4 x3 x8 x6 x1
    x2 x7 x5 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_4"
    [show x4, show x3, show x8, show x6, show x1, show x2, show x7, show x5
    , show x9] info)
  _ -> failCons cd (consFail "Pretty._case_4" (showCons x9))

nd_C__case_4 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> Func
  Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))) -> Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Func Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int
  (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))))) -> C_Tokens -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Func Curry_Prelude.C_Bool (Func (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))))
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore -> Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))
nd_C__case_4 x4 x3 x8 x6 x1 x2 x7 x5 x9 s cd cs = case x9 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` nd_C_multiGroup x1 x2 x3 x4 x5 x6 x7 x8 s0 cd cs
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_3 x8 x6 x1 x2 x7 x3 x5 (Curry_Prelude.d_C_otherwise
    cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_4 x4 x3 x8 x6 x1
    x2 x7 x5 l s cd cs) (nd_C__case_4 x4 x3 x8 x6 x1 x2 x7 x5 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_4 x4
    x3 x8 x6 x1 x2 x7 x5 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_4 x4 x3 x8 x6 x1
    x2 x7 x5 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_4"
    [show x4, show x3, show x8, show x6, show x1, show x2, show x7, show x5
    , show x9] info)
  _ -> failCons cd (consFail "Pretty._case_4" (showCons x9))

d_C__case_3 :: (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Dequeue.C_Queue
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> C_Tokens -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> (Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_3 x8 x6 x1 x2 x7 x3 x5 x9 cd cs = case x9 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x5
    Curry_Prelude.C_False cd cs) (d_OP_pruneMulti_dot_uscore_hash_lambda41 x3 x7
    x2 x1 x6 x8) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_3 x8 x6 x1 x2 x7
    x3 x5 l cd cs) (d_C__case_3 x8 x6 x1 x2 x7 x3 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_3 x8 x6
    x1 x2 x7 x3 x5 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_3 x8 x6 x1 x2 x7
    x3 x5 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_3"
    [show x8, show x6, show x1, show x2, show x7, show x3, show x5, show x9]
    info)
  _ -> failCons cd (consFail "Pretty._case_3" (showCons x9))

nd_C__case_3 :: Func Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))) -> Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Func Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int
  (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))))) -> C_Tokens -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> Func Curry_Prelude.C_Bool
  (Func (Func Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List
  Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List C_FormatStm)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int
  (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))))
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore -> Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))
nd_C__case_3 x8 x6 x1 x2 x7 x3 x5 x9 s cd cs = case x9 of
  Curry_Prelude.C_True -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x5
    Curry_Prelude.C_False s0 cd cs) (wrapNX id
    (nd_OP_pruneMulti_dot_uscore_hash_lambda41 x3 x7 x2 x1 x6 x8)) s1 cd cs))
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_3 x8 x6 x1 x2 x7
    x3 x5 l s cd cs) (nd_C__case_3 x8 x6 x1 x2 x7 x3 x5 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_3 x8
    x6 x1 x2 x7 x3 x5 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_3 x8 x6 x1 x2 x7
    x3 x5 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_3"
    [show x8, show x6, show x1, show x2, show x7, show x3, show x5, show x9]
    info)
  _ -> failCons cd (consFail "Pretty._case_3" (showCons x9))

d_C__case_6 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> C_Tokens -> (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_6 x4 x3 x2 x1 x5 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> d_C_oneGroup x1 x2 x3 x4 x5 cd cs
  Curry_Prelude.C_False -> d_C__case_5 x3 x2 x1 x5 (Curry_Prelude.d_C_otherwise
    cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_6 x4 x3 x2 x1 x5
    l cd cs) (d_C__case_6 x4 x3 x2 x1 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_6 x4 x3
    x2 x1 x5 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_6 x4 x3 x2 x1 x5
    e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_6"
    [show x4, show x3, show x2, show x1, show x5, show x6] info)
  _ -> failCons cd (consFail "Pretty._case_6" (showCons x6))

nd_C__case_6 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> C_Tokens -> Func Curry_Prelude.C_Bool (Func (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))))
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore -> Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))
nd_C__case_6 x4 x3 x2 x1 x5 x6 s cd cs = case x6 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` nd_C_oneGroup x1 x2 x3 x4 x5 s0 cd cs
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_5 x3 x2 x1 x5 (Curry_Prelude.d_C_otherwise cd cs) s0
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_6 x4 x3 x2 x1 x5
    l s cd cs) (nd_C__case_6 x4 x3 x2 x1 x5 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_6 x4
    x3 x2 x1 x5 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_6 x4 x3 x2 x1 x5
    e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_6"
    [show x4, show x3, show x2, show x1, show x5, show x6] info)
  _ -> failCons cd (consFail "Pretty._case_6" (showCons x6))

d_C__case_5 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> C_Tokens
  -> (Curry_Prelude.C_Bool -> Cover -> ConstStore -> (Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_5 x3 x2 x1 x5 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x5
    Curry_Prelude.C_False cd cs) (acceptCs (acceptCs id) (d_C_noGroup x1 x2 x3))
    cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_5 x3 x2 x1 x5 l
    cd cs) (d_C__case_5 x3 x2 x1 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_5 x3 x2
    x1 x5 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_5 x3 x2 x1 x5 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_5"
    [show x3, show x2, show x1, show x5, show x6] info)
  _ -> failCons cd (consFail "Pretty._case_5" (showCons x6))

nd_C__case_5 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> C_Tokens -> Func
  Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))) -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> Func Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List
  Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List C_FormatStm)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
nd_C__case_5 x3 x2 x1 x5 x6 s cd cs = case x6 of
  Curry_Prelude.C_True -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x5
    Curry_Prelude.C_False s0 cd cs) (wrapDX (wrapDX (wrapDX id)) (acceptCs
    (acceptCs id) (d_C_noGroup x1 x2 x3))) s1 cd cs))
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_5 x3 x2 x1 x5 l
    s cd cs) (nd_C__case_5 x3 x2 x1 x5 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_5 x3
    x2 x1 x5 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_5 x3 x2 x1 x5 e
    s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_5"
    [show x3, show x2, show x1, show x5, show x6] info)
  _ -> failCons cd (consFail "Pretty._case_5" (showCons x6))

d_C__case_7 :: forall t0 . (Curry_Prelude.Curry t0) => t0
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore -> t0
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> C_Tokens -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_7 x9 x8 x10 x2 x6 x3 x1 x7 x4 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_plus_plus x4
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    x6
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x7 x1 cd cs) cd cs) x8 cd cs) x9 cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.OP_Cons (Curry_Prelude.C_Char '\n'#)
    (Curry_Prelude.d_OP_plus_plus (d_C_addSpaces x10 x3 cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    x6
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x2 x10 cd cs) cd cs) x8 cd cs) x9 cd cs) cd cs)
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_7 x9 x8 x10 x2 x6
    x3 x1 x7 x4 l cd cs) (d_C__case_7 x9 x8 x10 x2 x6 x3 x1 x7 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_7 x9 x8
    x10 x2 x6 x3 x1 x7 x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_7 x9 x8 x10 x2 x6
    x3 x1 x7 x4 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_7"
    [show x9, show x8, show x10, show x2, show x6, show x3, show x1, show x7
    , show x4, show x5] info)
  _ -> failCons cd (consFail "Pretty._case_7" (showCons x5))

nd_C__case_7 :: forall t0 . (Curry_Prelude.Curry t0) => t0
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func t0 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))) -> C_Tokens -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
nd_C__case_7 x9 x8 x10 x2 x6 x3 x1 x7 x4 x5 s cd cs = case x5 of
  Curry_Prelude.C_True -> let s4 = s
    in s4 `seq` Curry_Prelude.d_OP_plus_plus x4 (let s3 = leftSupply s4
                                                     s2 = rightSupply s4
    in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                        s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x6
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x7 x1 cd cs) s0 cd cs) x8 s1 cd cs)) x9 s3 cd cs)) cd cs
  Curry_Prelude.C_False -> let s4 = s
    in s4 `seq` Curry_Prelude.OP_Cons (Curry_Prelude.C_Char '\n'#)
    (Curry_Prelude.d_OP_plus_plus (d_C_addSpaces x10 x3 cd cs)
    (let s3 = leftSupply s4
         s2 = rightSupply s4
    in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                        s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x6
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x2 x10 cd cs) s0 cd cs) x8 s1 cd cs)) x9 s3 cd cs)) cd cs)
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_7 x9 x8 x10 x2
    x6 x3 x1 x7 x4 l s cd cs) (nd_C__case_7 x9 x8 x10 x2 x6 x3 x1 x7 x4 r s cd
    cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_7 x9
    x8 x10 x2 x6 x3 x1 x7 x4 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_7 x9 x8 x10 x2
    x6 x3 x1 x7 x4 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_7"
    [show x9, show x8, show x10, show x2, show x6, show x3, show x1, show x7
    , show x4, show x5] info)
  _ -> failCons cd (consFail "Pretty._case_7" (showCons x5))

d_C__case_10 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Dequeue.C_Queue
  (Curry_Prelude.OP_Tuple2 t0 (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Curry_Prelude.C_Int
  -> (Curry_Prelude.C_Bool -> Cover -> ConstStore -> (Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> C_Tokens -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 t0 (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Dequeue.C_Queue
  (Curry_Prelude.OP_Tuple2 t0 (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char)))) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_10 x4 x6 x5 x3 x2 x1 x8 cd cs = case x8 of
  Curry_Prelude.C_Nothing -> Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply x5 Curry_Prelude.C_False cd cs) (acceptCs (acceptCs
    id) (d_OP_multiGroup_dot_outLine_dot_610 x2 x3 (acceptCs (acceptCs id)
    (d_C_noGroup x3 x2 x1)))) cd cs) x6 cd cs
  Curry_Prelude.C_Just x7 -> d_C__case_9 x6 x5 x3 x2 x1 x7 cd cs
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (d_C__case_10 x4 x6 x5 x3
    x2 x1 l cd cs) (d_C__case_10 x4 x6 x5 x3 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> d_C__case_10 x4
    x6 x5 x3 x2 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (d_C__case_10 x4 x6 x5 x3
    x2 x1 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail "Pretty._case_10"
    [show x4, show x6, show x5, show x3, show x2, show x1, show x8] info)
  _ -> failCons cd (consFail "Pretty._case_10" (showCons x8))

nd_C__case_10 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Dequeue.C_Queue
  (Curry_Prelude.OP_Tuple2 t0 (Func Curry_Prelude.C_Bool (Func (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))))))
  -> Curry_Prelude.C_Int -> Func Curry_Prelude.C_Bool (Func (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))))) -> C_Tokens
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 t0 (Func
  Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))))) (Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2 t0
  (Func Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))))))) -> IDSupply -> Cover -> ConstStore -> Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C__case_10 x4 x6 x5 x3 x2 x1 x8 s cd cs = case x8 of
  Curry_Prelude.C_Nothing -> let s4 = s
    in s4 `seq` (let s3 = leftSupply s4
                     s2 = rightSupply s4
    in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                        s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x5
    Curry_Prelude.C_False s0 cd cs) (wrapDX (wrapDX (wrapNX id)) (acceptCs
    (acceptCs id) (nd_OP_multiGroup_dot_outLine_dot_610 x2 x3 (wrapDX (wrapDX
    (wrapDX id)) (acceptCs (acceptCs id) (d_C_noGroup x3 x2 x1)))))) s1 cd cs))
    x6 s3 cd cs))
  Curry_Prelude.C_Just x7 -> let s0 = s
    in s0 `seq` nd_C__case_9 x6 x5 x3 x2 x1 x7 s0 cd cs
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (nd_C__case_10 x4 x6 x5 x3
    x2 x1 l s cd cs) (nd_C__case_10 x4 x6 x5 x3 x2 x1 r s cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> nd_C__case_10 x4
    x6 x5 x3 x2 x1 z s cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (nd_C__case_10 x4 x6 x5 x3
    x2 x1 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail "Pretty._case_10"
    [show x4, show x6, show x5, show x3, show x2, show x1, show x8] info)
  _ -> failCons cd (consFail "Pretty._case_10" (showCons x8))

d_C__case_9 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Int
  -> (Curry_Prelude.C_Bool -> Cover -> ConstStore -> (Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> C_Tokens -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 t0
  (Curry_Prelude.C_Bool -> Cover -> ConstStore -> (Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) (Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2 t0
  (Curry_Prelude.C_Bool -> Cover -> ConstStore -> (Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char))) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_9 x6 x5 x3 x2 x1 x7 cd cs = case x7 of
  Curry_Prelude.OP_Tuple2 x8 x9 -> d_C__case_8 x6 x9 x5 x3 x2 x1 x8 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C__case_9 x6 x5 x3 x2
    x1 l cd cs) (d_C__case_9 x6 x5 x3 x2 x1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C__case_9 x6
    x5 x3 x2 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C__case_9 x6 x5 x3 x2
    x1 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail "Pretty._case_9"
    [show x6, show x5, show x3, show x2, show x1, show x7] info)
  _ -> failCons cd (consFail "Pretty._case_9" (showCons x7))

nd_C__case_9 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Int
  -> Func Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))) -> C_Tokens -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 t0
  (Func Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))))) (Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2 t0
  (Func Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))))))) -> IDSupply -> Cover -> ConstStore -> Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C__case_9 x6 x5 x3 x2 x1 x7 s cd cs = case x7 of
  Curry_Prelude.OP_Tuple2 x8 x9 -> let s0 = s
    in s0 `seq` nd_C__case_8 x6 x9 x5 x3 x2 x1 x8 s0 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (nd_C__case_9 x6 x5 x3 x2
    x1 l s cd cs) (nd_C__case_9 x6 x5 x3 x2 x1 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> nd_C__case_9
    x6 x5 x3 x2 x1 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (nd_C__case_9 x6 x5 x3 x2
    x1 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail "Pretty._case_9"
    [show x6, show x5, show x3, show x2, show x1, show x7] info)
  _ -> failCons cd (consFail "Pretty._case_9" (showCons x7))

d_C__case_8 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Int
  -> Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2 t0 (Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> C_Tokens
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2 t0
  (Curry_Prelude.C_Bool -> Cover -> ConstStore -> (Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_8 x6 x9 x5 x3 x2 x1 x8 cd cs = case x8 of
  Curry_Prelude.OP_Tuple2 x10 x11 -> Curry_Prelude.d_C_apply
    (d_OP_multiGroup_dot_pruneAll_dot_610 x1 x2 x3 x5 x11 x9 cd cs) x6 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C__case_8 x6 x9 x5 x3
    x2 x1 l cd cs) (d_C__case_8 x6 x9 x5 x3 x2 x1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C__case_8 x6
    x9 x5 x3 x2 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C__case_8 x6 x9 x5 x3
    x2 x1 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail "Pretty._case_8"
    [show x6, show x9, show x5, show x3, show x2, show x1, show x8] info)
  _ -> failCons cd (consFail "Pretty._case_8" (showCons x8))

nd_C__case_8 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Int
  -> Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2 t0 (Func
  Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))))) -> Func Curry_Prelude.C_Bool (Func (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))))) -> C_Tokens
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2 t0
  (Func Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))))) -> IDSupply -> Cover -> ConstStore -> Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C__case_8 x6 x9 x5 x3 x2 x1 x8 s cd cs = case x8 of
  Curry_Prelude.OP_Tuple2 x10 x11 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply
    (nd_OP_multiGroup_dot_pruneAll_dot_610 x1 x2 x3 x5 x11 x9 s0 cd cs) x6 s1 cd
    cs))
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (nd_C__case_8 x6 x9 x5 x3
    x2 x1 l s cd cs) (nd_C__case_8 x6 x9 x5 x3 x2 x1 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> nd_C__case_8
    x6 x9 x5 x3 x2 x1 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (nd_C__case_8 x6 x9 x5 x3
    x2 x1 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail "Pretty._case_8"
    [show x6, show x9, show x5, show x3, show x2, show x1, show x8] info)
  _ -> failCons cd (consFail "Pretty._case_8" (showCons x8))

d_C__case_13 :: Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> (Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> (Curry_Prelude.C_Bool -> Cover -> ConstStore -> (Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> C_Tokens -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) (Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char)))) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_13 x6 x8 x7 x3 x5 x4 x2 x18 x20 cd cs = case x20 of
  Curry_Prelude.C_Nothing -> d_C_oneGroup x18 x2 x3 x4 (acceptCs id
    (d_OP_multiGroup_dot_uscore_hash_lambda31 x3 x7 x8 x5)) cd cs
  Curry_Prelude.C_Just x19 -> d_C__case_12 x8 x7 x3 x5 x4 x2 x18 x19 cd cs
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (d_C__case_13 x6 x8 x7 x3
    x5 x4 x2 x18 l cd cs) (d_C__case_13 x6 x8 x7 x3 x5 x4 x2 x18 r cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> d_C__case_13 x6
    x8 x7 x3 x5 x4 x2 x18 z cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (d_C__case_13 x6 x8 x7 x3
    x5 x4 x2 x18 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail "Pretty._case_13"
    [show x6, show x8, show x7, show x3, show x5, show x4, show x2, show x18
    , show x20] info)
  _ -> failCons cd (consFail "Pretty._case_13" (showCons x20))

nd_C__case_13 :: Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Func Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int
  (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))))) -> Func Curry_Prelude.C_Bool (Func (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))))
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> Func Curry_Prelude.C_Bool
  (Func (Func Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List
  Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List C_FormatStm)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int
  (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))))
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> C_Tokens
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Func Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int
  (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))))) (Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Func Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int
  (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))))))) -> IDSupply -> Cover -> ConstStore -> Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))
nd_C__case_13 x6 x8 x7 x3 x5 x4 x2 x18 x20 s cd cs = case x20 of
  Curry_Prelude.C_Nothing -> let s0 = s
    in s0 `seq` nd_C_oneGroup x18 x2 x3 x4 (wrapDX (wrapNX id) (acceptCs id
    (nd_OP_multiGroup_dot_uscore_hash_lambda31 x3 x7 x8 x5))) s0 cd cs
  Curry_Prelude.C_Just x19 -> let s0 = s
    in s0 `seq` nd_C__case_12 x8 x7 x3 x5 x4 x2 x18 x19 s0 cd cs
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (nd_C__case_13 x6 x8 x7 x3
    x5 x4 x2 x18 l s cd cs) (nd_C__case_13 x6 x8 x7 x3 x5 x4 x2 x18 r s cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> nd_C__case_13 x6
    x8 x7 x3 x5 x4 x2 x18 z s cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (nd_C__case_13 x6 x8 x7 x3
    x5 x4 x2 x18 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail "Pretty._case_13"
    [show x6, show x8, show x7, show x3, show x5, show x4, show x2, show x18
    , show x20] info)
  _ -> failCons cd (consFail "Pretty._case_13" (showCons x20))

d_C__case_12 :: (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> C_Tokens -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) (Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char))) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_12 x8 x7 x3 x5 x4 x2 x18 x19 cd cs = case x19 of
  Curry_Prelude.OP_Tuple2 x20 x21 -> d_C__case_11 x8 x7 x3 x21 x5 x4 x2 x18 x20
    cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C__case_12 x8 x7 x3 x5
    x4 x2 x18 l cd cs) (d_C__case_12 x8 x7 x3 x5 x4 x2 x18 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C__case_12
    x8 x7 x3 x5 x4 x2 x18 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C__case_12 x8 x7 x3 x5
    x4 x2 x18 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail "Pretty._case_12"
    [show x8, show x7, show x3, show x5, show x4, show x2, show x18, show x19]
    info)
  _ -> failCons cd (consFail "Pretty._case_12" (showCons x19))

nd_C__case_12 :: Func Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))) -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Func Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))) -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> C_Tokens -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Func Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int
  (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))))) (Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Func Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int
  (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))))))) -> IDSupply -> Cover -> ConstStore -> Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))
nd_C__case_12 x8 x7 x3 x5 x4 x2 x18 x19 s cd cs = case x19 of
  Curry_Prelude.OP_Tuple2 x20 x21 -> let s0 = s
    in s0 `seq` nd_C__case_11 x8 x7 x3 x21 x5 x4 x2 x18 x20 s0 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (nd_C__case_12 x8 x7 x3
    x5 x4 x2 x18 l s cd cs) (nd_C__case_12 x8 x7 x3 x5 x4 x2 x18 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> nd_C__case_12
    x8 x7 x3 x5 x4 x2 x18 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (nd_C__case_12 x8 x7 x3
    x5 x4 x2 x18 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail "Pretty._case_12"
    [show x8, show x7, show x3, show x5, show x4, show x2, show x18, show x19]
    info)
  _ -> failCons cd (consFail "Pretty._case_12" (showCons x19))

d_C__case_11 :: (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> (Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> C_Tokens -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.C_Bool -> Cover -> ConstStore -> (Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_11 x8 x7 x3 x21 x5 x4 x2 x18 x20 cd cs = case x20 of
  Curry_Prelude.OP_Tuple2 x22 x23 -> d_C_multiGroup x18 x2 x3 x4 x5 x21 x22
    (acceptCs id (d_OP_multiGroup_dot_uscore_hash_lambda33 x3 x7 x23 x8)) cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C__case_11 x8 x7 x3
    x21 x5 x4 x2 x18 l cd cs) (d_C__case_11 x8 x7 x3 x21 x5 x4 x2 x18 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C__case_11
    x8 x7 x3 x21 x5 x4 x2 x18 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C__case_11 x8 x7 x3
    x21 x5 x4 x2 x18 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail "Pretty._case_11"
    [show x8, show x7, show x3, show x21, show x5, show x4, show x2, show x18
    , show x20] info)
  _ -> failCons cd (consFail "Pretty._case_11" (showCons x20))

nd_C__case_11 :: Func Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))) -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Func
  Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))))) -> Func Curry_Prelude.C_Bool (Func (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))))
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> C_Tokens
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Func Curry_Prelude.C_Bool
  (Func (Func Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List
  Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List C_FormatStm)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int
  (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))))) -> IDSupply
  -> Cover -> ConstStore -> Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
nd_C__case_11 x8 x7 x3 x21 x5 x4 x2 x18 x20 s cd cs = case x20 of
  Curry_Prelude.OP_Tuple2 x22 x23 -> let s0 = s
    in s0 `seq` nd_C_multiGroup x18 x2 x3 x4 x5 x21 x22 (wrapDX (wrapNX id)
    (acceptCs id (nd_OP_multiGroup_dot_uscore_hash_lambda33 x3 x7 x23 x8))) s0
    cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (nd_C__case_11 x8 x7 x3
    x21 x5 x4 x2 x18 l s cd cs) (nd_C__case_11 x8 x7 x3 x21 x5 x4 x2 x18 r s cd
    cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> nd_C__case_11
    x8 x7 x3 x21 x5 x4 x2 x18 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (nd_C__case_11 x8 x7 x3
    x21 x5 x4 x2 x18 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail "Pretty._case_11"
    [show x8, show x7, show x3, show x21, show x5, show x4, show x2, show x18
    , show x20] info)
  _ -> failCons cd (consFail "Pretty._case_11" (showCons x20))

d_C__case_14 :: (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> C_Tokens
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> Curry_Dequeue.C_Queue
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_14 x8 x14 x2 x7 x6 x5 x4 x3 x13 cd cs = case x13 of
  Curry_Prelude.C_Nothing -> d_OP_multiGroup_dot_pruneAll_dot_610 x3 x2 x14 x8
    x5 x6 cd cs
  Curry_Prelude.C_Just x15 -> let x16 = Curry_Prelude.d_C_apply (d_C_length cd
                                    cs) x15 cd cs
    in d_C_pruneMulti x14 x2
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x3 x16 cd cs) x4 x5 x6 x7 (acceptCs id
    (d_OP_multiGroup_dot_uscore_hash_lambda28 x16 x2 x14 x15 x8)) cd cs
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (d_C__case_14 x8 x14 x2 x7
    x6 x5 x4 x3 l cd cs) (d_C__case_14 x8 x14 x2 x7 x6 x5 x4 x3 r cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> d_C__case_14 x8
    x14 x2 x7 x6 x5 x4 x3 z cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (d_C__case_14 x8 x14 x2 x7
    x6 x5 x4 x3 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail "Pretty._case_14"
    [show x8, show x14, show x2, show x7, show x6, show x5, show x4, show x3
    , show x13] info)
  _ -> failCons cd (consFail "Pretty._case_14" (showCons x13))

nd_C__case_14 :: Func Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))) -> C_Tokens -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Curry_Dequeue.C_Queue (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Func Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int
  (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))))) -> Func Curry_Prelude.C_Bool (Func (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))) (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))))
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply -> Cover
  -> ConstStore -> Func Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List
  Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List C_FormatStm)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
nd_C__case_14 x8 x14 x2 x7 x6 x5 x4 x3 x13 s cd cs = case x13 of
  Curry_Prelude.C_Nothing -> let s0 = s
    in s0 `seq` nd_OP_multiGroup_dot_pruneAll_dot_610 x3 x2 x14 x8 x5 x6 s0 cd
    cs
  Curry_Prelude.C_Just x15 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` (let x16 = Curry_Prelude.nd_C_apply (wrapDX id
                                 (d_C_length cd cs)) x15 s0 cd cs
    in nd_C_pruneMulti x14 x2
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x3 x16 cd cs) x4 x5 x6 x7 (wrapDX (wrapNX id) (acceptCs id
    (nd_OP_multiGroup_dot_uscore_hash_lambda28 x16 x2 x14 x15 x8))) s1 cd cs)))
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (nd_C__case_14 x8 x14 x2 x7
    x6 x5 x4 x3 l s cd cs) (nd_C__case_14 x8 x14 x2 x7 x6 x5 x4 x3 r s cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> nd_C__case_14 x8
    x14 x2 x7 x6 x5 x4 x3 z s cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (nd_C__case_14 x8 x14 x2 x7
    x6 x5 x4 x3 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail "Pretty._case_14"
    [show x8, show x14, show x2, show x7, show x6, show x5, show x4, show x3
    , show x13] info)
  _ -> failCons cd (consFail "Pretty._case_14" (showCons x13))

d_C__case_15 :: forall t0 . (Curry_Prelude.Curry t0) => t0
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> (Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore -> t0
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> C_Tokens -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_15 x9 x8 x10 x2 x6 x3 x1 x7 x4 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_plus_plus x4
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    x6
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x7 x1 cd cs) cd cs) x8 cd cs) x9 cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.OP_Cons (Curry_Prelude.C_Char '\n'#)
    (Curry_Prelude.d_OP_plus_plus (d_C_addSpaces x10 x3 cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    x6
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x2 x10 cd cs) cd cs) x8 cd cs) x9 cd cs) cd cs)
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_15 x9 x8 x10 x2
    x6 x3 x1 x7 x4 l cd cs) (d_C__case_15 x9 x8 x10 x2 x6 x3 x1 x7 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_15 x9
    x8 x10 x2 x6 x3 x1 x7 x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_15 x9 x8 x10 x2
    x6 x3 x1 x7 x4 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_15"
    [show x9, show x8, show x10, show x2, show x6, show x3, show x1, show x7
    , show x4, show x5] info)
  _ -> failCons cd (consFail "Pretty._case_15" (showCons x5))

nd_C__case_15 :: forall t0 . (Curry_Prelude.Curry t0) => t0
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func t0 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))) -> C_Tokens -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
nd_C__case_15 x9 x8 x10 x2 x6 x3 x1 x7 x4 x5 s cd cs = case x5 of
  Curry_Prelude.C_True -> let s4 = s
    in s4 `seq` Curry_Prelude.d_OP_plus_plus x4 (let s3 = leftSupply s4
                                                     s2 = rightSupply s4
    in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                        s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x6
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x7 x1 cd cs) s0 cd cs) x8 s1 cd cs)) x9 s3 cd cs)) cd cs
  Curry_Prelude.C_False -> let s4 = s
    in s4 `seq` Curry_Prelude.OP_Cons (Curry_Prelude.C_Char '\n'#)
    (Curry_Prelude.d_OP_plus_plus (d_C_addSpaces x10 x3 cd cs)
    (let s3 = leftSupply s4
         s2 = rightSupply s4
    in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                        s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x6
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x2 x10 cd cs) s0 cd cs) x8 s1 cd cs)) x9 s3 cd cs)) cd cs)
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_15 x9 x8 x10 x2
    x6 x3 x1 x7 x4 l s cd cs) (nd_C__case_15 x9 x8 x10 x2 x6 x3 x1 x7 x4 r s cd
    cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_15 x9
    x8 x10 x2 x6 x3 x1 x7 x4 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_15 x9 x8 x10 x2
    x6 x3 x1 x7 x4 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_15"
    [show x9, show x8, show x10, show x2, show x6, show x3, show x1, show x7
    , show x4, show x5] info)
  _ -> failCons cd (consFail "Pretty._case_15" (showCons x5))

d_C__case_16 :: (Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> (Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  C_FormatStm -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> C_Tokens
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List C_FormatStm -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_16 x5 x11 x2 x4 x3 x10 cd cs = case x10 of
  Curry_Prelude.C_Nothing -> Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x5
    Curry_Prelude.C_False cd cs) (acceptCs (acceptCs id)
    (d_OP_oneGroup_dot_outLine_dot_542 x2 x11 (acceptCs (acceptCs id)
    (d_C_noGroup x11 x2 x3)))) cd cs
  Curry_Prelude.C_Just x12 -> let x13 = Curry_Prelude.d_C_apply (d_C_length cd
                                    cs) x12 cd cs
    in d_C_pruneOne x11 x2
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x3 x13 cd cs) x4 (acceptCs id (d_OP_oneGroup_dot_uscore_hash_lambda17 x13 x2
    x11 x12 x5)) cd cs
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (d_C__case_16 x5 x11 x2 x4
    x3 l cd cs) (d_C__case_16 x5 x11 x2 x4 x3 r cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> d_C__case_16 x5
    x11 x2 x4 x3 z cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (d_C__case_16 x5 x11 x2 x4
    x3 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail "Pretty._case_16"
    [show x5, show x11, show x2, show x4, show x3, show x10] info)
  _ -> failCons cd (consFail "Pretty._case_16" (showCons x10))

nd_C__case_16 :: Func Curry_Prelude.C_Bool (Func (Func Curry_Prelude.C_Int (Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List
  C_FormatStm) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))) (Func
  Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Func
  (Curry_Prelude.OP_List C_FormatStm) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))))) -> C_Tokens -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply -> Cover
  -> ConstStore -> Func Curry_Prelude.C_Int (Func (Curry_Prelude.OP_List
  Curry_Prelude.C_Int) (Func (Curry_Prelude.OP_List C_FormatStm)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
nd_C__case_16 x5 x11 x2 x4 x3 x10 s cd cs = case x10 of
  Curry_Prelude.C_Nothing -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x5
    Curry_Prelude.C_False s0 cd cs) (wrapDX (wrapDX (wrapNX id)) (acceptCs
    (acceptCs id) (nd_OP_oneGroup_dot_outLine_dot_542 x2 x11 (wrapDX (wrapDX
    (wrapDX id)) (acceptCs (acceptCs id) (d_C_noGroup x11 x2 x3)))))) s1 cd cs))
  Curry_Prelude.C_Just x12 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` (let x13 = Curry_Prelude.nd_C_apply (wrapDX id
                                 (d_C_length cd cs)) x12 s0 cd cs
    in nd_C_pruneOne x11 x2
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x3 x13 cd cs) x4 (wrapDX (wrapNX id) (acceptCs id
    (nd_OP_oneGroup_dot_uscore_hash_lambda17 x13 x2 x11 x12 x5))) s1 cd cs)))
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (nd_C__case_16 x5 x11 x2 x4
    x3 l s cd cs) (nd_C__case_16 x5 x11 x2 x4 x3 r s cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> nd_C__case_16 x5
    x11 x2 x4 x3 z s cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (nd_C__case_16 x5 x11 x2 x4
    x3 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail "Pretty._case_16"
    [show x5, show x11, show x2, show x4, show x3, show x10] info)
  _ -> failCons cd (consFail "Pretty._case_16" (showCons x10))

d_C__case_17 :: Curry_Prelude.OP_List C_FormatStm -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> C_Tokens -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_17 x6 x2 x3 x12 x5 cd cs = case x5 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "Pretty.noGroup: illegal line") cd cs
  Curry_Prelude.OP_Cons x13 x14 -> Curry_Prelude.OP_Cons (Curry_Prelude.C_Char
    '\n'#) (Curry_Prelude.d_OP_plus_plus (d_C_addSpaces x13 x12 cd cs)
    (d_C_noGroup x12 x2
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x3 (Curry_Prelude.C_Int (1)) cd cs)
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x2 x13 cd cs) x5 x6 cd cs) cd cs)
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_17 x6 x2 x3 x12
    l cd cs) (d_C__case_17 x6 x2 x3 x12 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_17 x6
    x2 x3 x12 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_17 x6 x2 x3 x12
    e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Pretty._case_17"
    [show x6, show x2, show x3, show x12, show x5] info)
  _ -> failCons cd (consFail "Pretty._case_17" (showCons x5))

d_C__case_18 :: C_Tokens -> C_Tokens -> Cover -> ConstStore -> C_Tokens
d_C__case_18 x2 x1 cd cs = case x1 of
  C_CloseGroup x3 -> x3
  C_EOD -> x2
  C_Empty x4 -> x2
  C_Text x5 x6 -> x2
  C_LineBreak x7 x8 -> x2
  C_OpenGroup x9 -> x2
  C_OpenNest x10 x11 -> x2
  C_CloseNest x12 -> x2
  C_OpenFormat x13 x14 -> x2
  C_CloseFormat x15 -> x2
  Choice_C_Tokens d i l r -> narrow d i (d_C__case_18 x2 l cd cs) (d_C__case_18
    x2 r cd cs)
  Choices_C_Tokens d i xs -> narrows cs d i (\z -> d_C__case_18 x2 z cd cs) xs
  Guard_C_Tokens d c e -> guardCons d c (d_C__case_18 x2 e cd $! addCs c cs)
  Fail_C_Tokens d info -> failCons d (traceFail "Pretty._case_18" [show x2, show
    x1] info)
  _ -> failCons cd (consFail "Pretty._case_18" (showCons x1))

d_C__case_19 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_List Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Int
d_C__case_19 x5 x4 cd cs = case x4 of
  Curry_Prelude.OP_Cons x6 x7 -> Curry_Prelude.OP_Cons
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x6 x5 cd cs) x4
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "Pretty.applyNesting: empty margin list") cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_19 x5 l cd cs)
    (d_C__case_19 x5 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_19 x5
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_19 x5 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Pretty._case_19"
    [show x5, show x4] info)
  _ -> failCons cd (consFail "Pretty._case_19" (showCons x4))

d_C__case_20 :: Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_Int
d_C__case_20 x9 cd cs = case x9 of
  Curry_Prelude.C_True -> Curry_Prelude.C_Int (7)
  Curry_Prelude.C_False -> Curry_Prelude.C_Int (27)
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_20 l cd cs)
    (d_C__case_20 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_20 z cd
    cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_20 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_20"
    [show x9] info)
  _ -> failCons cd (consFail "Pretty._case_20" (showCons x9))

d_C__case_21 :: Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_Int
d_C__case_21 x8 cd cs = case x8 of
  Curry_Prelude.C_True -> Curry_Prelude.C_Int (9)
  Curry_Prelude.C_False -> Curry_Prelude.C_Int (29)
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_21 l cd cs)
    (d_C__case_21 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_21 z cd
    cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_21 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_21"
    [show x8] info)
  _ -> failCons cd (consFail "Pretty._case_21" (showCons x8))

d_C__case_22 :: Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_Int
d_C__case_22 x7 cd cs = case x7 of
  Curry_Prelude.C_True -> Curry_Prelude.C_Int (4)
  Curry_Prelude.C_False -> Curry_Prelude.C_Int (24)
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_22 l cd cs)
    (d_C__case_22 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_22 z cd
    cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_22 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_22"
    [show x7] info)
  _ -> failCons cd (consFail "Pretty._case_22" (showCons x7))

d_C__case_23 :: Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_Int
d_C__case_23 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> Curry_Prelude.C_Int (3)
  Curry_Prelude.C_False -> Curry_Prelude.C_Int (23)
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_23 l cd cs)
    (d_C__case_23 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_23 z cd
    cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_23 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_23"
    [show x6] info)
  _ -> failCons cd (consFail "Pretty._case_23" (showCons x6))

d_C__case_24 :: C_BlinkMode -> C_FormatStm -> Cover -> ConstStore -> C_BlinkMode
d_C__case_24 x4 x2 cd cs = case x2 of
  C_SetBlinkMode x5 -> x5
  C_SetForeground x6 -> x4
  C_SetBackground x7 -> x4
  C_SetIntensity x8 -> x4
  C_SetItalicized x9 -> x4
  C_SetUnderlined x10 -> x4
  C_SetCrossedout x11 -> x4
  C_InverseColoring x12 -> x4
  Choice_C_FormatStm d i l r -> narrow d i (d_C__case_24 x4 l cd cs)
    (d_C__case_24 x4 r cd cs)
  Choices_C_FormatStm d i xs -> narrows cs d i (\z -> d_C__case_24 x4 z cd cs)
    xs
  Guard_C_FormatStm d c e -> guardCons d c (d_C__case_24 x4 e cd $! addCs c cs)
  Fail_C_FormatStm d info -> failCons d (traceFail "Pretty._case_24" [show x4
    , show x2] info)
  _ -> failCons cd (consFail "Pretty._case_24" (showCons x2))

d_C__case_25 :: C_Intensity -> C_FormatStm -> Cover -> ConstStore -> C_Intensity
d_C__case_25 x4 x2 cd cs = case x2 of
  C_SetIntensity x5 -> x5
  C_SetForeground x6 -> x4
  C_SetBackground x7 -> x4
  C_SetBlinkMode x8 -> x4
  C_SetItalicized x9 -> x4
  C_SetUnderlined x10 -> x4
  C_SetCrossedout x11 -> x4
  C_InverseColoring x12 -> x4
  Choice_C_FormatStm d i l r -> narrow d i (d_C__case_25 x4 l cd cs)
    (d_C__case_25 x4 r cd cs)
  Choices_C_FormatStm d i xs -> narrows cs d i (\z -> d_C__case_25 x4 z cd cs)
    xs
  Guard_C_FormatStm d c e -> guardCons d c (d_C__case_25 x4 e cd $! addCs c cs)
  Fail_C_FormatStm d info -> failCons d (traceFail "Pretty._case_25" [show x4
    , show x2] info)
  _ -> failCons cd (consFail "Pretty._case_25" (showCons x2))

d_C__case_26 :: C_Color -> C_FormatStm -> Cover -> ConstStore -> C_Color
d_C__case_26 x4 x2 cd cs = case x2 of
  C_SetBackground x5 -> x5
  C_SetForeground x6 -> x4
  C_SetIntensity x7 -> x4
  C_SetBlinkMode x8 -> x4
  C_SetItalicized x9 -> x4
  C_SetUnderlined x10 -> x4
  C_SetCrossedout x11 -> x4
  C_InverseColoring x12 -> x4
  Choice_C_FormatStm d i l r -> narrow d i (d_C__case_26 x4 l cd cs)
    (d_C__case_26 x4 r cd cs)
  Choices_C_FormatStm d i xs -> narrows cs d i (\z -> d_C__case_26 x4 z cd cs)
    xs
  Guard_C_FormatStm d c e -> guardCons d c (d_C__case_26 x4 e cd $! addCs c cs)
  Fail_C_FormatStm d info -> failCons d (traceFail "Pretty._case_26" [show x4
    , show x2] info)
  _ -> failCons cd (consFail "Pretty._case_26" (showCons x2))

d_C__case_27 :: C_Color -> C_FormatStm -> Cover -> ConstStore -> C_Color
d_C__case_27 x4 x2 cd cs = case x2 of
  C_SetForeground x5 -> x5
  C_SetBackground x6 -> x4
  C_SetIntensity x7 -> x4
  C_SetBlinkMode x8 -> x4
  C_SetItalicized x9 -> x4
  C_SetUnderlined x10 -> x4
  C_SetCrossedout x11 -> x4
  C_InverseColoring x12 -> x4
  Choice_C_FormatStm d i l r -> narrow d i (d_C__case_27 x4 l cd cs)
    (d_C__case_27 x4 r cd cs)
  Choices_C_FormatStm d i xs -> narrows cs d i (\z -> d_C__case_27 x4 z cd cs)
    xs
  Guard_C_FormatStm d c e -> guardCons d c (d_C__case_27 x4 e cd $! addCs c cs)
  Fail_C_FormatStm d info -> failCons d (traceFail "Pretty._case_27" [show x4
    , show x2] info)
  _ -> failCons cd (consFail "Pretty._case_27" (showCons x2))

d_C__case_28 :: Curry_Prelude.OP_List C_FormatStm -> C_FormatStm -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 C_FormatStm (Curry_Prelude.OP_List
  C_FormatStm)
d_C__case_28 x3 x2 cd cs = case x2 of
  C_SetForeground x4 -> Curry_Prelude.OP_Tuple2 (C_SetForeground
    (d_C_prevFGColor x3 cd cs)) x3
  C_SetBackground x5 -> Curry_Prelude.OP_Tuple2 (C_SetBackground
    (d_C_prevBGColor x3 cd cs)) x3
  C_SetIntensity x6 -> Curry_Prelude.OP_Tuple2 (C_SetIntensity
    (d_C_prevIntensity x3 cd cs)) x3
  C_SetBlinkMode x7 -> Curry_Prelude.OP_Tuple2 (C_SetBlinkMode
    (d_C_prevBlinkMode x3 cd cs)) x3
  C_SetItalicized x8 -> Curry_Prelude.OP_Tuple2 (C_SetItalicized
    (Curry_Prelude.d_C_not x8 cd cs)) x3
  C_SetUnderlined x9 -> Curry_Prelude.OP_Tuple2 (C_SetUnderlined
    (Curry_Prelude.d_C_not x9 cd cs)) x3
  C_SetCrossedout x10 -> Curry_Prelude.OP_Tuple2 (C_SetCrossedout
    (Curry_Prelude.d_C_not x10 cd cs)) x3
  C_InverseColoring x11 -> Curry_Prelude.OP_Tuple2 (C_InverseColoring
    (Curry_Prelude.d_C_not x11 cd cs)) x3
  Choice_C_FormatStm d i l r -> narrow d i (d_C__case_28 x3 l cd cs)
    (d_C__case_28 x3 r cd cs)
  Choices_C_FormatStm d i xs -> narrows cs d i (\z -> d_C__case_28 x3 z cd cs)
    xs
  Guard_C_FormatStm d c e -> guardCons d c (d_C__case_28 x3 e cd $! addCs c cs)
  Fail_C_FormatStm d info -> failCons d (traceFail "Pretty._case_28" [show x3
    , show x2] info)
  _ -> failCons cd (consFail "Pretty._case_28" (showCons x2))

d_C__case_29 :: C_Tokens -> Curry_Prelude.C_Int -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.C_Int
d_C__case_29 x7 x1 x6 cd cs = case x6 of
  Curry_Prelude.C_Nothing -> d_OP_width_dot_width_tick_dot_216 x1 x7 cd cs
  Curry_Prelude.C_Just x8 -> d_OP_width_dot_width_tick_dot_216
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x1 (Curry_Prelude.d_C_apply (d_C_length cd cs) x8 cd cs) cd cs) x7 cd cs
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (d_C__case_29 x7 x1 l cd
    cs) (d_C__case_29 x7 x1 r cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> d_C__case_29 x7
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (d_C__case_29 x7 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail "Pretty._case_29"
    [show x7, show x1, show x6] info)
  _ -> failCons cd (consFail "Pretty._case_29" (showCons x6))

d_C__case_30 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> C_Doc
d_C__case_30 x1 x3 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> d_C_nest x1 (d_C_linebreak cd cs) cd cs
  Curry_Prelude.C_False -> d_C_spaces
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x1 x3 cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_30 x1 x3 l cd cs)
    (d_C__case_30 x1 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_30 x1
    x3 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_30 x1 x3 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_30"
    [show x1, show x3, show x4] info)
  _ -> failCons cd (consFail "Pretty._case_30" (showCons x4))

nd_C__case_30 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C__case_30 x1 x3 x4 s cd cs = case x4 of
  Curry_Prelude.C_True -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_C_nest x1 (nd_C_linebreak s0 cd cs) s1 cd cs))
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C_spaces
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x1 x3 cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_30 x1 x3 l s cd
    cs) (nd_C__case_30 x1 x3 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_30 x1
    x3 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_30 x1 x3 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_30"
    [show x1, show x3, show x4] info)
  _ -> failCons cd (consFail "Pretty._case_30" (showCons x4))

d_C__case_31 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> C_Doc
d_C__case_31 x1 x3 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> d_C_empty cd cs
  Curry_Prelude.C_False -> d_C_spaces
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x1 x3 cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_31 x1 x3 l cd cs)
    (d_C__case_31 x1 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_31 x1
    x3 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_31 x1 x3 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_31"
    [show x1, show x3, show x4] info)
  _ -> failCons cd (consFail "Pretty._case_31" (showCons x4))

nd_C__case_31 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore -> C_Doc
nd_C__case_31 x1 x3 x4 s cd cs = case x4 of
  Curry_Prelude.C_True -> let s0 = s in s0 `seq` nd_C_empty s0 cd cs
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C_spaces
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x1 x3 cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_31 x1 x3 l s cd
    cs) (nd_C__case_31 x1 x3 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_31 x1
    x3 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_31 x1 x3 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_31"
    [show x1, show x3, show x4] info)
  _ -> failCons cd (consFail "Pretty._case_31" (showCons x4))

d_C__case_33 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> C_Doc
d_C__case_33 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> d_C_empty cd cs
  Curry_Prelude.C_False -> d_C__case_32 x1 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_33 x1 l cd cs)
    (d_C__case_33 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_33 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_33 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_33"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Pretty._case_33" (showCons x2))

nd_C__case_33 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> IDSupply
  -> Cover -> ConstStore -> C_Doc
nd_C__case_33 x1 x2 s cd cs = case x2 of
  Curry_Prelude.C_True -> let s0 = s in s0 `seq` nd_C_empty s0 cd cs
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_32 x1 (Curry_Prelude.d_C_otherwise cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_33 x1 l s cd cs)
    (nd_C__case_33 x1 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_33 x1
    z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_33 x1 e s cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_33"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Pretty._case_33" (showCons x2))

d_C__case_32 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> C_Doc
d_C__case_32 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_dollar d_C_text
    (Curry_Prelude.d_C_replicate x1 (Curry_Prelude.C_Char ' '#) cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_32 x1 l cd cs)
    (d_C__case_32 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_32 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_32 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_32"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Pretty._case_32" (showCons x2))

nd_C__case_32 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> IDSupply
  -> Cover -> ConstStore -> C_Doc
nd_C__case_32 x1 x2 s cd cs = case x2 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id nd_C_text)
    (Curry_Prelude.d_C_replicate x1 (Curry_Prelude.C_Char ' '#) cd cs) s0 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_32 x1 l s cd cs)
    (nd_C__case_32 x1 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_32 x1
    z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_32 x1 e s cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_32"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Pretty._case_32" (showCons x2))

d_C__case_34 :: Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> C_Doc
d_C__case_34 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> d_C_line cd cs
  Curry_Prelude.C_False -> d_C_char x1 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_34 x1 l cd cs)
    (d_C__case_34 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_34 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_34 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_34"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Pretty._case_34" (showCons x2))

nd_C__case_34 :: Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> IDSupply
  -> Cover -> ConstStore -> C_Doc
nd_C__case_34 x1 x2 s cd cs = case x2 of
  Curry_Prelude.C_True -> let s0 = s in s0 `seq` nd_C_line s0 cd cs
  Curry_Prelude.C_False -> let s0 = s in s0 `seq` nd_C_char x1 s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_34 x1 l s cd cs)
    (nd_C__case_34 x1 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_34 x1
    z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_34 x1 e s cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_34"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Pretty._case_34" (showCons x2))

d_C__case_35 :: C_Doc -> C_Doc -> Curry_Prelude.OP_List C_Doc -> Cover
  -> ConstStore -> Curry_Prelude.OP_List C_Doc
d_C__case_35 x1 x3 x4 cd cs = case x4 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Cons x3 Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x5 x6 -> Curry_Prelude.OP_Cons (d_OP_lt_gt x3 x1 cd cs)
    (d_OP_punctuate_dot_go_dot_84 x1 x4 cd cs)
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_35 x1 x3 l cd
    cs) (d_C__case_35 x1 x3 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_35 x1
    x3 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_35 x1 x3 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Pretty._case_35"
    [show x1, show x3, show x4] info)
  _ -> failCons cd (consFail "Pretty._case_35" (showCons x4))

nd_C__case_35 :: C_Doc -> C_Doc -> Curry_Prelude.OP_List C_Doc -> IDSupply
  -> Cover -> ConstStore -> Curry_Prelude.OP_List C_Doc
nd_C__case_35 x1 x3 x4 s cd cs = case x4 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Cons x3 Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x5 x6 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` Curry_Prelude.OP_Cons (nd_OP_lt_gt x3 x1 s0 cd cs)
    (nd_OP_punctuate_dot_go_dot_84 x1 x4 s1 cd cs)))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_35 x1 x3 l s cd
    cs) (nd_C__case_35 x1 x3 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_35 x1
    x3 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C__case_35 x1 x3 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Pretty._case_35"
    [show x1, show x3, show x4] info)
  _ -> failCons cd (consFail "Pretty._case_35" (showCons x4))

d_C__case_38 :: C_Doc -> C_Doc -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> C_Doc
d_C__case_38 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> x2
  Curry_Prelude.C_False -> d_C__case_37 x2 x1 (d_C_isEmpty x2 cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_38 x1 x2 l cd cs)
    (d_C__case_38 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_38 x1
    x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_38 x1 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_38"
    [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "Pretty._case_38" (showCons x3))

nd_C__case_38 :: C_Doc -> C_Doc -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> C_Doc
nd_C__case_38 x1 x2 x3 s cd cs = case x3 of
  Curry_Prelude.C_True -> x2
  Curry_Prelude.C_False -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_C__case_37 x2 x1 (nd_C_isEmpty x2 s0 cd cs) s1 cd
    cs))
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_38 x1 x2 l s cd
    cs) (nd_C__case_38 x1 x2 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_38 x1
    x2 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_38 x1 x2 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_38"
    [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "Pretty._case_38" (showCons x3))

d_C__case_37 :: C_Doc -> C_Doc -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> C_Doc
d_C__case_37 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> x1
  Curry_Prelude.C_False -> d_C__case_36 x2 x1 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_37 x2 x1 l cd cs)
    (d_C__case_37 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_37 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_37 x2 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_37"
    [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "Pretty._case_37" (showCons x3))

nd_C__case_37 :: C_Doc -> C_Doc -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> C_Doc
nd_C__case_37 x2 x1 x3 s cd cs = case x3 of
  Curry_Prelude.C_True -> x1
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_36 x2 x1 (Curry_Prelude.d_C_otherwise cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_37 x2 x1 l s cd
    cs) (nd_C__case_37 x2 x1 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_37 x2
    x1 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_37 x2 x1 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_37"
    [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "Pretty._case_37" (showCons x3))

d_C__case_36 :: C_Doc -> C_Doc -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> C_Doc
d_C__case_36 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> C_Doc (Curry_Prelude.d_OP_dot (d_C_deDoc x1 cd cs)
    (d_C_deDoc x2 cd cs) cd cs)
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_36 x2 x1 l cd cs)
    (d_C__case_36 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_36 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_36 x2 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_36"
    [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "Pretty._case_36" (showCons x3))

nd_C__case_36 :: C_Doc -> C_Doc -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> C_Doc
nd_C__case_36 x2 x1 x3 s cd cs = case x3 of
  Curry_Prelude.C_True -> let s3 = s
    in s3 `seq` HO_C_Doc (let s2 = leftSupply s3
                              s4 = rightSupply s3
                              s0 = leftSupply s4
                              s1 = rightSupply s4
    in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` Curry_Prelude.nd_OP_dot
    (nd_C_deDoc x1 s0 cd cs) (nd_C_deDoc x2 s1 cd cs) s2 cd cs))))
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_36 x2 x1 l s cd
    cs) (nd_C__case_36 x2 x1 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_36 x2
    x1 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_36 x2 x1 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_36"
    [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "Pretty._case_36" (showCons x3))

d_C__case_41 :: C_Doc -> C_Doc -> C_Doc -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> C_Doc
d_C__case_41 x2 x3 x1 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> x3
  Curry_Prelude.C_False -> d_C__case_40 x3 x1 x2 (d_C_isEmpty x3 cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_41 x2 x3 x1 l cd
    cs) (d_C__case_41 x2 x3 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_41 x2
    x3 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_41 x2 x3 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_41"
    [show x2, show x3, show x1, show x4] info)
  _ -> failCons cd (consFail "Pretty._case_41" (showCons x4))

nd_C__case_41 :: C_Doc -> C_Doc -> C_Doc -> Curry_Prelude.C_Bool -> IDSupply
  -> Cover -> ConstStore -> C_Doc
nd_C__case_41 x2 x3 x1 x4 s cd cs = case x4 of
  Curry_Prelude.C_True -> x3
  Curry_Prelude.C_False -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_C__case_40 x3 x1 x2 (nd_C_isEmpty x3 s0 cd cs) s1
    cd cs))
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_41 x2 x3 x1 l s
    cd cs) (nd_C__case_41 x2 x3 x1 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_41 x2
    x3 x1 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_41 x2 x3 x1 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_41"
    [show x2, show x3, show x1, show x4] info)
  _ -> failCons cd (consFail "Pretty._case_41" (showCons x4))

d_C__case_40 :: C_Doc -> C_Doc -> C_Doc -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> C_Doc
d_C__case_40 x3 x1 x2 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> x2
  Curry_Prelude.C_False -> d_C__case_39 x1 x3 x2 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_40 x3 x1 x2 l cd
    cs) (d_C__case_40 x3 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_40 x3
    x1 x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_40 x3 x1 x2 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_40"
    [show x3, show x1, show x2, show x4] info)
  _ -> failCons cd (consFail "Pretty._case_40" (showCons x4))

nd_C__case_40 :: C_Doc -> C_Doc -> C_Doc -> Curry_Prelude.C_Bool -> IDSupply
  -> Cover -> ConstStore -> C_Doc
nd_C__case_40 x3 x1 x2 x4 s cd cs = case x4 of
  Curry_Prelude.C_True -> x2
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_39 x1 x3 x2 (Curry_Prelude.d_C_otherwise cd cs) s0 cd
    cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_40 x3 x1 x2 l s
    cd cs) (nd_C__case_40 x3 x1 x2 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_40 x3
    x1 x2 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_40 x3 x1 x2 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_40"
    [show x3, show x1, show x2, show x4] info)
  _ -> failCons cd (consFail "Pretty._case_40" (showCons x4))

d_C__case_39 :: C_Doc -> C_Doc -> C_Doc -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> C_Doc
d_C__case_39 x1 x3 x2 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> d_C_enclose x2 x3 x1 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_39 x1 x3 x2 l cd
    cs) (d_C__case_39 x1 x3 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_39 x1
    x3 x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_39 x1 x3 x2 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_39"
    [show x1, show x3, show x2, show x4] info)
  _ -> failCons cd (consFail "Pretty._case_39" (showCons x4))

nd_C__case_39 :: C_Doc -> C_Doc -> C_Doc -> Curry_Prelude.C_Bool -> IDSupply
  -> Cover -> ConstStore -> C_Doc
nd_C__case_39 x1 x3 x2 x4 s cd cs = case x4 of
  Curry_Prelude.C_True -> let s0 = s in s0 `seq` nd_C_enclose x2 x3 x1 s0 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_39 x1 x3 x2 l s
    cd cs) (nd_C__case_39 x1 x3 x2 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_39 x1
    x3 x2 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_39 x1 x3 x2 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Pretty._case_39"
    [show x1, show x3, show x2, show x4] info)
  _ -> failCons cd (consFail "Pretty._case_39" (showCons x4))

d_C__case_43 :: Curry_Prelude.C_Bool -> C_Tokens -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C__case_43 x2 x1 cd cs = case x1 of
  C_Empty x3 -> let x4 = Curry_Prelude.C_False in d_C__case_42 x4 x3 cd cs
  C_EOD -> x2
  C_Text x18 x19 -> x2
  C_LineBreak x20 x21 -> x2
  C_OpenGroup x22 -> x2
  C_CloseGroup x23 -> x2
  C_OpenNest x24 x25 -> x2
  C_CloseNest x26 -> x2
  C_OpenFormat x27 x28 -> x2
  C_CloseFormat x29 -> x2
  Choice_C_Tokens d i l r -> narrow d i (d_C__case_43 x2 l cd cs) (d_C__case_43
    x2 r cd cs)
  Choices_C_Tokens d i xs -> narrows cs d i (\z -> d_C__case_43 x2 z cd cs) xs
  Guard_C_Tokens d c e -> guardCons d c (d_C__case_43 x2 e cd $! addCs c cs)
  Fail_C_Tokens d info -> failCons d (traceFail "Pretty._case_43" [show x2, show
    x1] info)
  _ -> failCons cd (consFail "Pretty._case_43" (showCons x1))

d_C__case_42 :: Curry_Prelude.C_Bool -> C_Tokens -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C__case_42 x4 x3 cd cs = case x3 of
  C_EOD -> Curry_Prelude.C_True
  C_Empty x5 -> x4
  C_Text x6 x7 -> x4
  C_LineBreak x8 x9 -> x4
  C_OpenGroup x10 -> x4
  C_CloseGroup x11 -> x4
  C_OpenNest x12 x13 -> x4
  C_CloseNest x14 -> x4
  C_OpenFormat x15 x16 -> x4
  C_CloseFormat x17 -> x4
  Choice_C_Tokens d i l r -> narrow d i (d_C__case_42 x4 l cd cs) (d_C__case_42
    x4 r cd cs)
  Choices_C_Tokens d i xs -> narrows cs d i (\z -> d_C__case_42 x4 z cd cs) xs
  Guard_C_Tokens d c e -> guardCons d c (d_C__case_42 x4 e cd $! addCs c cs)
  Fail_C_Tokens d info -> failCons d (traceFail "Pretty._case_42" [show x4, show
    x3] info)
  _ -> failCons cd (consFail "Pretty._case_42" (showCons x3))

