{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE Rank2Types #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module Curry_RCFile
  ( d_C_readRC
  , d_C_setRCProperty
  , d_C_rcValue
  , d_C_extractRCArgs
  , d_C_updateRCDefs )
  where

import Basics
import qualified Curry_Char
import qualified Curry_Directory
import qualified Curry_FilePath
import qualified Curry_Function
import qualified Curry_Installation
import qualified Curry_List
import qualified Curry_Prelude
import qualified Curry_PropertyFile
import qualified Curry_Sort
import qualified Curry_Utils


d_C_defaultRC :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_defaultRC cd cs = Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_FilePath.d_OP_lt_slash_gt cd cs) (Curry_Installation.d_C_installDir cd
  cs) cd cs) (Curry_Prelude.toCurryString "kics2rc.default") cd cs

d_C_rcFileName :: Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_rcFileName cd cs = Curry_Prelude.d_C_liftIO (Curry_Prelude.d_C_flip
  (Curry_FilePath.d_OP_lt_slash_gt cd cs) (Curry_Prelude.toCurryString
  ".kics2rc")) (Curry_Directory.d_C_getHomeDirectory cd cs) cd cs

d_C_readRC :: Cover -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_C_readRC cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (d_C_rcFileName cd cs) d_OP_readRC_dot_uscore_hash_lambda4 cd cs

d_OP_readRC_dot_uscore_hash_lambda4 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_OP_readRC_dot_uscore_hash_lambda4 x1 cd cs = let x2 = x1
  in Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Directory.d_C_doesFileExist x2 cd cs)
  (d_OP_readRC_dot_uscore_hash_lambda4_dot_uscore_hash_lambda6 x2) cd cs

d_OP_readRC_dot_uscore_hash_lambda4_dot_uscore_hash_lambda6 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_IO (Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))
d_OP_readRC_dot_uscore_hash_lambda4_dot_uscore_hash_lambda6 x1 x2 cd cs =
  let x3 = x2
  in Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Prelude.d_C_catch (d_C__case_3 x1 x3 cd cs) (Curry_Prelude.d_C_const
  (Curry_Prelude.d_C_done cd cs)) cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Directory.d_C_doesFileExist x1 cd cs)
  (d_OP_readRC_dot_uscore_hash_lambda4_dot_uscore_hash_lambda6_dot_uscore_hash_lambda8
  x1) cd cs) cd cs

d_OP_readRC_dot_uscore_hash_lambda4_dot_uscore_hash_lambda6_dot_uscore_hash_lambda8 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_IO (Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)))
d_OP_readRC_dot_uscore_hash_lambda4_dot_uscore_hash_lambda6_dot_uscore_hash_lambda8 x1 x2 cd cs =
  let x3 = x2
  in Curry_PropertyFile.d_C_readPropertyFile (d_C__case_2 x1 x3 cd cs) cd cs

d_C_rcKeys :: Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_rcKeys cd cs = Curry_Prelude.d_OP_dot (Curry_Sort.d_C_mergeSort
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Char cd
  cs) cd cs) cd cs) (Curry_Prelude.d_C_map Curry_Prelude.d_C_fst) cd cs

d_C_updateRC :: Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_updateRC cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (d_C_rcFileName cd cs) d_OP_updateRC_dot_uscore_hash_lambda13 cd cs

d_OP_updateRC_dot_uscore_hash_lambda13 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
d_OP_updateRC_dot_uscore_hash_lambda13 x1 cd cs = let x2 = x1
  in Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_PropertyFile.d_C_readPropertyFile x2 cd cs)
  (d_OP_updateRC_dot_uscore_hash_lambda13_dot_uscore_hash_lambda15 x2) cd cs

d_OP_updateRC_dot_uscore_hash_lambda13_dot_uscore_hash_lambda15 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
d_OP_updateRC_dot_uscore_hash_lambda13_dot_uscore_hash_lambda15 x1 x2 cd cs =
  let x3 = x2
  in Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_PropertyFile.d_C_readPropertyFile (d_C_defaultRC cd cs) cd cs)
  (d_OP_updateRC_dot_uscore_hash_lambda13_dot_uscore_hash_lambda15_dot_uscore_hash_lambda17
  x1 x3) cd cs

d_OP_updateRC_dot_uscore_hash_lambda13_dot_uscore_hash_lambda15_dot_uscore_hash_lambda17 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
d_OP_updateRC_dot_uscore_hash_lambda13_dot_uscore_hash_lambda15_dot_uscore_hash_lambda17 x1 x2 x3 cd cs =
  let x4 = x3
  in Curry_Prelude.d_OP_dollar (Curry_Prelude.d_C_unless
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs) (Curry_Prelude.d_C_apply (d_C_rcKeys cd cs) x2 cd cs)
  (Curry_Prelude.d_C_apply (d_C_rcKeys cd cs) x4 cd cs) cd cs))
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Prelude.d_OP_dollar Curry_Prelude.d_C_putStrLn
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "Updating \"")
  (Curry_Prelude.d_OP_plus_plus x1 (Curry_Prelude.toCurryString "\"...") cd cs)
  cd cs) cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Prelude.d_OP_dollar (Curry_Directory.d_C_renameFile x1)
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_FilePath.d_OP_lt_dot_gt cd cs) x1 cd cs) (Curry_Prelude.toCurryString
  "bak") cd cs) cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Directory.d_C_copyFile (d_C_defaultRC cd cs) x1 cd cs)
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_mapIO_
  (d_OP_updateRC_dot_uscore_hash_lambda13_dot_uscore_hash_lambda15_dot_uscore_hash_lambda17_dot_uscore_hash_lambda19
  x1 x2) cd cs) x4 cd cs) cd cs) cd cs) cd cs) cd cs

d_OP_updateRC_dot_uscore_hash_lambda13_dot_uscore_hash_lambda15_dot_uscore_hash_lambda17_dot_uscore_hash_lambda19 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_OP_updateRC_dot_uscore_hash_lambda13_dot_uscore_hash_lambda15_dot_uscore_hash_lambda17_dot_uscore_hash_lambda19 x1 x2 x3 cd cs =
  case x3 of
  Curry_Prelude.OP_Tuple2 x4 x5 -> Curry_Prelude.d_C_maybe
    (Curry_Prelude.d_C_done cd cs)
    (d_OP_updateRC_dot_uscore_hash_lambda13_dot_uscore_hash_lambda15_dot_uscore_hash_lambda17_dot_uscore_hash_lambda19_dot_uscore_hash_lambda20
    x4 x1 x5) (Curry_Prelude.d_C_lookup
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) x4 x2 cd cs) cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_updateRC_dot_uscore_hash_lambda13_dot_uscore_hash_lambda15_dot_uscore_hash_lambda17_dot_uscore_hash_lambda19
    x1 x2 l cd cs)
    (d_OP_updateRC_dot_uscore_hash_lambda13_dot_uscore_hash_lambda15_dot_uscore_hash_lambda17_dot_uscore_hash_lambda19
    x1 x2 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_updateRC_dot_uscore_hash_lambda13_dot_uscore_hash_lambda15_dot_uscore_hash_lambda17_dot_uscore_hash_lambda19
    x1 x2 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_updateRC_dot_uscore_hash_lambda13_dot_uscore_hash_lambda15_dot_uscore_hash_lambda17_dot_uscore_hash_lambda19
    x1 x2 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "RCFile.updateRC._#lambda13._#lambda15._#lambda17._#lambda19" [show x1, show
    x2, show x3] info)
  _ -> failCons cd (consFail
    "RCFile.updateRC._#lambda13._#lambda15._#lambda17._#lambda19" (showCons x3))

d_OP_updateRC_dot_uscore_hash_lambda13_dot_uscore_hash_lambda15_dot_uscore_hash_lambda17_dot_uscore_hash_lambda19_dot_uscore_hash_lambda20 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
d_OP_updateRC_dot_uscore_hash_lambda13_dot_uscore_hash_lambda15_dot_uscore_hash_lambda17_dot_uscore_hash_lambda19_dot_uscore_hash_lambda20 x1 x2 x3 x4 cd cs =
  Curry_Prelude.d_OP_dollar (Curry_Prelude.d_C_unless
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) x4 x3 cd cs)) (Curry_PropertyFile.d_C_updatePropertyFile x2 x1 x4 cd cs)
  cd cs

d_C_setRCProperty :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_setRCProperty x1 x2 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (d_C_readRC cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (d_C_rcFileName cd cs) (d_OP_setRCProperty_dot_uscore_hash_lambda22 x1 x2) cd
  cs) cd cs

d_OP_setRCProperty_dot_uscore_hash_lambda22 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_OP_setRCProperty_dot_uscore_hash_lambda22 x1 x2 x3 cd cs = let x4 = x3
  in Curry_PropertyFile.d_C_updatePropertyFile x4 x1 x2 cd cs

d_C_rcValue :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_rcValue x1 x2 cd cs = Curry_Prelude.d_OP_dollar (Curry_Utils.d_C_strip cd
  cs) (Curry_Prelude.d_OP_dollar (Curry_Prelude.d_C_maybe Curry_Prelude.OP_List
  Curry_Prelude.d_C_id) (Curry_Prelude.d_C_lookup
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs) (Curry_Prelude.d_C_map Curry_Char.d_C_toLower x2 cd cs)
  (Curry_Prelude.d_C_map (Curry_Function.d_C_first (Curry_Prelude.d_C_map
  Curry_Char.d_C_toLower)) x1 cd cs) cd cs) cd cs) cd cs

d_C_extractRCArgs :: Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
d_C_extractRCArgs x1 cd cs = let x2 = Curry_Prelude.d_C_apply
                                   (Curry_Prelude.d_C_break
                                   d_OP_extractRCArgs_dot_uscore_hash_lambda25
                                   cd cs) x1 cd cs
                                 x3 = d_OP_extractRCArgs_dot_uscore_hash_selFP2_hash_dargs
                                   x2 cd cs
                                 x4 = d_OP_extractRCArgs_dot_uscore_hash_selFP3_hash_otherargs
                                   x2 cd cs
  in Curry_Prelude.OP_Tuple2 x4 (Curry_Prelude.d_C_map
  d_OP_extractRCArgs_dot_splitDefs_dot_25 (Curry_Prelude.d_C_map
  (Curry_Prelude.d_C_drop (Curry_Prelude.C_Int (2))) x3 cd cs) cd cs)

d_OP_extractRCArgs_dot_splitDefs_dot_25 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_extractRCArgs_dot_splitDefs_dot_25 x1 cd cs = d_C__case_1 x1
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_break (Curry_Prelude.d_C_flip
  (acceptCs id
  Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char)
  (Curry_Prelude.C_Char '='#)) cd cs) x1 cd cs) cd cs

d_OP_extractRCArgs_dot_uscore_hash_lambda25 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_OP_extractRCArgs_dot_uscore_hash_lambda25 x1 cd cs = Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs) (Curry_Prelude.d_C_take (Curry_Prelude.C_Int (2)) x1 cd cs) cd cs)
  (Curry_Prelude.toCurryString "-D") cd cs

d_OP_extractRCArgs_dot_uscore_hash_selFP2_hash_dargs :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_extractRCArgs_dot_uscore_hash_selFP2_hash_dargs x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_extractRCArgs_dot_uscore_hash_selFP2_hash_dargs l cd cs)
    (d_OP_extractRCArgs_dot_uscore_hash_selFP2_hash_dargs r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_extractRCArgs_dot_uscore_hash_selFP2_hash_dargs z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_extractRCArgs_dot_uscore_hash_selFP2_hash_dargs e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "RCFile.extractRCArgs._#selFP2#dargs" [show x1] info)
  _ -> failCons cd (consFail "RCFile.extractRCArgs._#selFP2#dargs" (showCons
    x1))

d_OP_extractRCArgs_dot_uscore_hash_selFP3_hash_otherargs :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_extractRCArgs_dot_uscore_hash_selFP3_hash_otherargs x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_extractRCArgs_dot_uscore_hash_selFP3_hash_otherargs l cd cs)
    (d_OP_extractRCArgs_dot_uscore_hash_selFP3_hash_otherargs r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_extractRCArgs_dot_uscore_hash_selFP3_hash_otherargs z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_extractRCArgs_dot_uscore_hash_selFP3_hash_otherargs e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "RCFile.extractRCArgs._#selFP3#otherargs" [show x1] info)
  _ -> failCons cd (consFail "RCFile.extractRCArgs._#selFP3#otherargs" (showCons
    x1))

d_C_updateRCDefs :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_updateRCDefs x1 x2 cd cs = Curry_Prelude.d_C_map
  (d_OP_updateRCDefs_dot_uscore_hash_lambda26 x2) x1 cd cs

d_OP_updateRCDefs_dot_uscore_hash_lambda26 :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_updateRCDefs_dot_uscore_hash_lambda26 x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> Curry_Prelude.OP_Tuple2 x3
    (Curry_Prelude.d_C_maybe x4 Curry_Prelude.d_C_id (Curry_Prelude.d_C_lookup
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) x3 x1 cd cs) cd cs)
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_updateRCDefs_dot_uscore_hash_lambda26 x1 l cd cs)
    (d_OP_updateRCDefs_dot_uscore_hash_lambda26 x1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_updateRCDefs_dot_uscore_hash_lambda26 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_updateRCDefs_dot_uscore_hash_lambda26 x1 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "RCFile.updateRCDefs._#lambda26" [show x1, show x2] info)
  _ -> failCons cd (consFail "RCFile.updateRCDefs._#lambda26" (showCons x2))

d_C__case_1 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_1 x1 x4 cd cs = case x4 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> d_C__case_0 x1 x2 x3 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C__case_1 x1 l cd cs)
    (d_C__case_1 x1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C__case_1 x1
    z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C__case_1 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail "RCFile._case_1"
    [show x1, show x4] info)
  _ -> failCons cd (consFail "RCFile._case_1" (showCons x4))

d_C__case_0 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C__case_0 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> Curry_Prelude.OP_Tuple2 x2 x5
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Tuple2 x1 Curry_Prelude.OP_List
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_0 x1 x2 l cd cs)
    (d_C__case_0 x1 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_0 x1
    x2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_0 x1 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "RCFile._case_0"
    [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "RCFile._case_0" (showCons x3))

d_C__case_2 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> x1
  Curry_Prelude.C_False -> d_C_defaultRC cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_2 x1 l cd cs)
    (d_C__case_2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_2 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_2 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "RCFile._case_2"
    [show x1, show x3] info)
  _ -> failCons cd (consFail "RCFile._case_2" (showCons x3))

d_C__case_3 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
d_C__case_3 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> d_C_updateRC cd cs
  Curry_Prelude.C_False -> Curry_Directory.d_C_copyFile (d_C_defaultRC cd cs) x1
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_3 x1 l cd cs)
    (d_C__case_3 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_3 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_3 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "RCFile._case_3"
    [show x1, show x3] info)
  _ -> failCons cd (consFail "RCFile._case_3" (showCons x3))

