{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE Rank2Types #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module Curry_TransFunctions
  ( C_IOES (..)
  , C_State (..)
  , d_C_runIOES
  , nd_C_runIOES
  , d_C_typeMap
  , nd_C_typeMap
  , d_C_ndResult
  , nd_C_ndResult
  , d_C_hoResultType
  , nd_C_hoResultType
  , d_C_hoResultCons
  , nd_C_hoResultCons
  , d_C_hoResultFunc
  , nd_C_hoResultFunc
  , d_C_nextID
  , nd_C_nextID
  , d_C_detMode
  , nd_C_detMode
  , d_C_compOptions
  , nd_C_compOptions
  , d_C_defaultState
  , nd_C_defaultState
  , d_C_trProg
  , nd_C_trProg )
  where

import Basics
import qualified Curry_AbstractHaskell
import qualified Curry_AbstractHaskellGoodies
import qualified Curry_Analysis
import qualified Curry_Classification
import qualified Curry_CompilerOpts
import qualified Curry_FiniteMap
import qualified FlatCurry.Curry_Types
import qualified Curry_Function
import qualified Curry_LiftCase
import qualified Curry_List
import qualified Curry_Message
import qualified Curry_Names
import qualified Curry_Prelude


type C_M t0 = C_IOES C_State t0

data C_IOES t0 t1
  = C_M (t0 -> Cover -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_Either
    (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_Tuple2 t1
    t0)))
  | HO_C_M (Func t0 (Curry_Prelude.C_IO (Curry_Prelude.C_Either
    (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_Tuple2 t1
    t0))))
  | Choice_C_IOES Cover ID (C_IOES t0 t1) (C_IOES t0 t1)
  | Choices_C_IOES Cover ID [C_IOES t0 t1]
  | Fail_C_IOES Cover FailInfo
  | Guard_C_IOES Cover Constraints (C_IOES t0 t1)

instance (Show t0, Show t1) => Show (C_IOES t0 t1) where
  showsPrec d (Choice_C_IOES cd i x y) = showsChoice d cd i x y
  showsPrec d (Choices_C_IOES cd i xs) = showsChoices d cd i xs
  showsPrec d (Guard_C_IOES cd c e) = showsGuard d cd c e
  showsPrec _ (Fail_C_IOES cd info) = showChar '!'
  showsPrec _ (C_M x1) = showString "(M" . (showChar ' ' . (shows x1 . showChar
    ')'))
  showsPrec _ (HO_C_M x1) = showString "(M" . (showChar ' ' . (shows x1 .
    showChar ')'))

instance (Read t0, Read t1) => Read (C_IOES t0 t1) where
  readsPrec d s = readParen ((>) d 10) (\r -> [(C_M x1, r1) | (_, r0) <-
    readQualified "TransFunctions" "M" r, (x1, r1) <- readsPrec 11 r0]) s

instance NonDet (C_IOES t0 t1) where
  choiceCons = Choice_C_IOES
  choicesCons = Choices_C_IOES
  failCons = Fail_C_IOES
  guardCons = Guard_C_IOES
  try (Choice_C_IOES cd i x y) = tryChoice cd i x y
  try (Choices_C_IOES cd i xs) = tryChoices cd i xs
  try (Fail_C_IOES cd info) = Fail cd info
  try (Guard_C_IOES cd c e) = Guard cd c e
  try x = Val x
  match f _ _ _ _ _ (Choice_C_IOES cd i x y) = f cd i x y
  match _ f _ _ _ _ (Choices_C_IOES cd i@(NarrowedID _ _) xs) = f cd i xs
  match _ _ f _ _ _ (Choices_C_IOES cd i@(FreeID _ _) xs) = f cd i xs
  match _ _ _ _ _ _ (Choices_C_IOES cd i _) = error
    ("TransFunctions.IOES.match: Choices with ChoiceID " ++ show i)
  match _ _ _ f _ _ (Fail_C_IOES cd info) = f cd info
  match _ _ _ _ f _ (Guard_C_IOES cd c e) = f cd c e
  match _ _ _ _ _ f x = f x

instance (Generable t0, Generable t1) => Generable (C_IOES t0 t1) where
  generate s c = Choices_C_IOES c (freeID [1] s) [HO_C_M (generate (leftSupply
    s) c)]

instance (NormalForm t0, NormalForm t1) => NormalForm (C_IOES t0 t1) where
  ($!!) cont (C_M x1) d cs = ($!!) (\y1 d cs -> cont (C_M y1) d cs) x1 d cs
  ($!!) cont (HO_C_M x1) d cs = ($!!) (\y1 d cs -> cont (HO_C_M y1) d cs) x1 d
    cs
  ($!!) cont (Choice_C_IOES cd i x y) d cs = nfChoice cont cd i x y cd cs
  ($!!) cont (Choices_C_IOES cd i xs) d cs = nfChoices cont cd i xs d cs
  ($!!) cont (Guard_C_IOES cd c e) d cs = guardCons cd c (($!!) cont e d (addCs
    c cs))
  ($!!) _ (Fail_C_IOES cd info) _ _ = failCons cd info
  ($##) cont (C_M x1) d cs = ($##) (\y1 d cs -> cont (C_M y1) d cs) x1 d cs
  ($##) cont (HO_C_M x1) d cs = ($##) (\y1 d cs -> cont (HO_C_M y1) d cs) x1 d
    cs
  ($##) cont (Choice_C_IOES cd i x y) d cs = gnfChoice cont cd i x y cd cs
  ($##) cont (Choices_C_IOES cd i xs) d cs = gnfChoices cont cd i xs d cs
  ($##) cont (Guard_C_IOES cd c e) d cs = guardCons cd c (($##) cont e d (addCs
    c cs))
  ($##) _ (Fail_C_IOES cd info) _ _ = failCons cd info
  showCons (C_M _) = "TransFunctions.M _"
  showCons (HO_C_M _) = "TransFunctions.M _"
  showCons x = error ("TransFunctions.IOES.showCons: no constructor: " ++ show
    x)
  searchNF search cont (C_M x1) = search (\y1 -> cont (C_M y1)) x1
  searchNF search cont (HO_C_M x1) = search (\y1 -> cont (HO_C_M y1)) x1
  searchNF _ _ x = error ("TransFunctions.IOES.searchNF: no constructor: " ++
    show x)

instance (Unifiable t0, Unifiable t1) => Unifiable (C_IOES t0 t1) where
  (=.=) (C_M x1) (C_M y1) d cs = (=:=) x1 y1 d cs
  (=.=) (HO_C_M x1) (HO_C_M y1) d cs = (=:=) x1 y1 d cs
  (=.=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  (=.<=) (C_M x1) (C_M y1) d cs = (=:<=) x1 y1 d cs
  (=.<=) (HO_C_M x1) (HO_C_M y1) d cs = (=:<=) x1 y1 d cs
  (=.<=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  bind cd i (C_M x3) = (i :=: ChooseN 0 1) : concat [bind cd (leftID i) x3]
  bind cd i (HO_C_M x3) = (i :=: ChooseN 0 1) : concat [bind cd (leftID i) x3]
  bind d i (Choice_C_IOES cd j x y) = [ConstraintChoice cd j (bind d i x) (bind
    d i y)]
  bind d i (Choices_C_IOES cd j@(FreeID _ _) xs) = bindOrNarrow d i cd j xs
  bind d i (Choices_C_IOES cd j@(NarrowedID _ _) xs) = [ConstraintChoices cd j
    (map (bind d i) xs)]
  bind _ _ (Choices_C_IOES cd i _) = error
    ("TransFunctions.IOES.bind: Choices with ChoiceID: " ++ show i)
  bind _ _ (Fail_C_IOES cd info) = [Unsolvable info]
  bind d i (Guard_C_IOES cd c e) = getConstrList c ++ bind d i e
  lazyBind cd i (C_M x3) = (i :=: ChooseN 0 1) : [leftID i :=: LazyBind
    (lazyBind cd (leftID i) x3)]
  lazyBind cd i (HO_C_M x3) = (i :=: ChooseN 0 1) : [leftID i :=: LazyBind
    (lazyBind cd (leftID i) x3)]
  lazyBind d i (Choice_C_IOES cd j x y) = [ConstraintChoice cd j (lazyBind d i
    x) (lazyBind d i y)]
  lazyBind d i (Choices_C_IOES cd j@(FreeID _ _) xs) = lazyBindOrNarrow d i cd j
    xs
  lazyBind d i (Choices_C_IOES cd j@(NarrowedID _ _) xs) = [ConstraintChoices cd
    j (map (lazyBind d i) xs)]
  lazyBind _ _ (Choices_C_IOES cd i _) = error
    ("TransFunctions.IOES.lazyBind: Choices with ChoiceID: " ++ show i)
  lazyBind _ _ (Fail_C_IOES cd info) = [Unsolvable info]
  lazyBind d i (Guard_C_IOES cd c e) = getConstrList c ++ [i :=: LazyBind
    (lazyBind d i e)]

instance (Curry t0, Curry t1) => Curry (C_IOES t0 t1) where

data C_State
  = C_State (Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
    (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
    Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
    Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
    (Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
    Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
    Curry_Classification.C_NDClass) (Curry_FiniteMap.C_FM
    (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
    (Curry_Prelude.OP_List Curry_Prelude.C_Char))
    Curry_Classification.C_TypeHOClass) (Curry_FiniteMap.C_FM
    (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
    (Curry_Prelude.OP_List Curry_Prelude.C_Char))
    Curry_Classification.C_ConsHOClass) (Curry_FiniteMap.C_FM
    (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
    (Curry_Prelude.OP_List Curry_Prelude.C_Char))
    Curry_Classification.C_FuncHOClass) Curry_Prelude.C_Int Curry_Prelude.C_Bool
    Curry_CompilerOpts.C_Options
  | Choice_C_State Cover ID C_State C_State
  | Choices_C_State Cover ID [C_State]
  | Fail_C_State Cover FailInfo
  | Guard_C_State Cover Constraints C_State

instance Show C_State where
  showsPrec d (Choice_C_State cd i x y) = showsChoice d cd i x y
  showsPrec d (Choices_C_State cd i xs) = showsChoices d cd i xs
  showsPrec d (Guard_C_State cd c e) = showsGuard d cd c e
  showsPrec _ (Fail_C_State cd info) = showChar '!'
  showsPrec _ (C_State x1 x2 x3 x4 x5 x6 x7 x8) = showString "(State" .
    (showChar ' ' . (shows x1 . (showChar ' ' . (shows x2 . (showChar ' ' .
    (shows x3 . (showChar ' ' . (shows x4 . (showChar ' ' . (shows x5 .
    (showChar ' ' . (shows x6 . (showChar ' ' . (shows x7 . (showChar ' ' .
    (shows x8 . showChar ')'))))))))))))))))

instance Read C_State where
  readsPrec d s = readParen ((>) d 10) (\r -> [(C_State x1 x2 x3 x4 x5 x6 x7 x8
    , r8) | (_, r0) <- readQualified "TransFunctions" "State" r, (x1, r1) <-
    readsPrec 11 r0, (x2, r2) <- readsPrec 11 r1, (x3, r3) <- readsPrec 11 r2,
    (x4, r4) <- readsPrec 11 r3, (x5, r5) <- readsPrec 11 r4, (x6, r6) <-
    readsPrec 11 r5, (x7, r7) <- readsPrec 11 r6, (x8, r8) <- readsPrec 11 r7])
    s

instance NonDet C_State where
  choiceCons = Choice_C_State
  choicesCons = Choices_C_State
  failCons = Fail_C_State
  guardCons = Guard_C_State
  try (Choice_C_State cd i x y) = tryChoice cd i x y
  try (Choices_C_State cd i xs) = tryChoices cd i xs
  try (Fail_C_State cd info) = Fail cd info
  try (Guard_C_State cd c e) = Guard cd c e
  try x = Val x
  match f _ _ _ _ _ (Choice_C_State cd i x y) = f cd i x y
  match _ f _ _ _ _ (Choices_C_State cd i@(NarrowedID _ _) xs) = f cd i xs
  match _ _ f _ _ _ (Choices_C_State cd i@(FreeID _ _) xs) = f cd i xs
  match _ _ _ _ _ _ (Choices_C_State cd i _) = error
    ("TransFunctions.State.match: Choices with ChoiceID " ++ show i)
  match _ _ _ f _ _ (Fail_C_State cd info) = f cd info
  match _ _ _ _ f _ (Guard_C_State cd c e) = f cd c e
  match _ _ _ _ _ f x = f x

instance Generable C_State where
  generate s c = Choices_C_State c (freeID [8] s) [C_State (generate (leftSupply
    (leftSupply (leftSupply s))) c) (generate (rightSupply (leftSupply
    (leftSupply s))) c) (generate (leftSupply (rightSupply (leftSupply s))) c)
    (generate (rightSupply (rightSupply (leftSupply s))) c) (generate
    (leftSupply (leftSupply (rightSupply s))) c) (generate (rightSupply
    (leftSupply (rightSupply s))) c) (generate (leftSupply (rightSupply
    (rightSupply s))) c) (generate (rightSupply (rightSupply (rightSupply s)))
    c)]

instance NormalForm C_State where
  ($!!) cont (C_State x1 x2 x3 x4 x5 x6 x7 x8) d cs = ($!!) (\y1 d cs -> ($!!)
    (\y2 d cs -> ($!!) (\y3 d cs -> ($!!) (\y4 d cs -> ($!!) (\y5 d cs -> ($!!)
    (\y6 d cs -> ($!!) (\y7 d cs -> ($!!) (\y8 d cs -> cont (C_State y1 y2 y3 y4
    y5 y6 y7 y8) d cs) x8 d cs) x7 d cs) x6 d cs) x5 d cs) x4 d cs) x3 d cs) x2
    d cs) x1 d cs
  ($!!) cont (Choice_C_State cd i x y) d cs = nfChoice cont cd i x y cd cs
  ($!!) cont (Choices_C_State cd i xs) d cs = nfChoices cont cd i xs d cs
  ($!!) cont (Guard_C_State cd c e) d cs = guardCons cd c (($!!) cont e d (addCs
    c cs))
  ($!!) _ (Fail_C_State cd info) _ _ = failCons cd info
  ($##) cont (C_State x1 x2 x3 x4 x5 x6 x7 x8) d cs = ($##) (\y1 d cs -> ($##)
    (\y2 d cs -> ($##) (\y3 d cs -> ($##) (\y4 d cs -> ($##) (\y5 d cs -> ($##)
    (\y6 d cs -> ($##) (\y7 d cs -> ($##) (\y8 d cs -> cont (C_State y1 y2 y3 y4
    y5 y6 y7 y8) d cs) x8 d cs) x7 d cs) x6 d cs) x5 d cs) x4 d cs) x3 d cs) x2
    d cs) x1 d cs
  ($##) cont (Choice_C_State cd i x y) d cs = gnfChoice cont cd i x y cd cs
  ($##) cont (Choices_C_State cd i xs) d cs = gnfChoices cont cd i xs d cs
  ($##) cont (Guard_C_State cd c e) d cs = guardCons cd c (($##) cont e d (addCs
    c cs))
  ($##) _ (Fail_C_State cd info) _ _ = failCons cd info
  showCons (C_State _ _ _ _ _ _ _ _) = "TransFunctions.State _ _ _ _ _ _ _ _"
  showCons x = error ("TransFunctions.State.showCons: no constructor: " ++ show
    x)
  searchNF search cont (C_State x1 x2 x3 x4 x5 x6 x7 x8) = search (\y1 -> search
    (\y2 -> search (\y3 -> search (\y4 -> search (\y5 -> search (\y6 -> search
    (\y7 -> search (\y8 -> cont (C_State y1 y2 y3 y4 y5 y6 y7 y8)) x8) x7) x6)
    x5) x4) x3) x2) x1
  searchNF _ _ x = error ("TransFunctions.State.searchNF: no constructor: " ++
    show x)

instance Unifiable C_State where
  (=.=) (C_State x1 x2 x3 x4 x5 x6 x7 x8) (C_State y1 y2 y3 y4 y5 y6 y7 y8) d cs =
    (&) ((=:=) x1 y1 d cs) ((&) ((=:=) x2 y2 d cs) ((&) ((=:=) x3 y3 d cs) ((&)
    ((=:=) x4 y4 d cs) ((&) ((=:=) x5 y5 d cs) ((&) ((=:=) x6 y6 d cs) ((&)
    ((=:=) x7 y7 d cs) ((=:=) x8 y8 d cs) d cs) d cs) d cs) d cs) d cs) d cs) d
    cs
  (=.=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  (=.<=) (C_State x1 x2 x3 x4 x5 x6 x7 x8) (C_State y1 y2 y3 y4 y5 y6 y7 y8) d cs =
    (&) ((=:<=) x1 y1 d cs) ((&) ((=:<=) x2 y2 d cs) ((&) ((=:<=) x3 y3 d cs)
    ((&) ((=:<=) x4 y4 d cs) ((&) ((=:<=) x5 y5 d cs) ((&) ((=:<=) x6 y6 d cs)
    ((&) ((=:<=) x7 y7 d cs) ((=:<=) x8 y8 d cs) d cs) d cs) d cs) d cs) d cs) d
    cs) d cs
  (=.<=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  bind cd i (C_State x3 x4 x5 x6 x7 x8 x9 x10) = (i :=: ChooseN 0 8) : concat
    [bind cd (leftID (leftID (leftID i))) x3, bind cd (rightID (leftID (leftID
    i))) x4, bind cd (leftID (rightID (leftID i))) x5, bind cd (rightID (rightID
    (leftID i))) x6, bind cd (leftID (leftID (rightID i))) x7, bind cd (rightID
    (leftID (rightID i))) x8, bind cd (leftID (rightID (rightID i))) x9, bind cd
    (rightID (rightID (rightID i))) x10]
  bind d i (Choice_C_State cd j x y) = [ConstraintChoice cd j (bind d i x) (bind
    d i y)]
  bind d i (Choices_C_State cd j@(FreeID _ _) xs) = bindOrNarrow d i cd j xs
  bind d i (Choices_C_State cd j@(NarrowedID _ _) xs) = [ConstraintChoices cd j
    (map (bind d i) xs)]
  bind _ _ (Choices_C_State cd i _) = error
    ("TransFunctions.State.bind: Choices with ChoiceID: " ++ show i)
  bind _ _ (Fail_C_State cd info) = [Unsolvable info]
  bind d i (Guard_C_State cd c e) = getConstrList c ++ bind d i e
  lazyBind cd i (C_State x3 x4 x5 x6 x7 x8 x9 x10) = (i :=: ChooseN 0 8) :
    [leftID (leftID (leftID i)) :=: LazyBind (lazyBind cd (leftID (leftID
    (leftID i))) x3), rightID (leftID (leftID i)) :=: LazyBind (lazyBind cd
    (rightID (leftID (leftID i))) x4), leftID (rightID (leftID i)) :=: LazyBind
    (lazyBind cd (leftID (rightID (leftID i))) x5), rightID (rightID (leftID
    i)) :=: LazyBind (lazyBind cd (rightID (rightID (leftID i))) x6), leftID
    (leftID (rightID i)) :=: LazyBind (lazyBind cd (leftID (leftID (rightID i)))
    x7), rightID (leftID (rightID i)) :=: LazyBind (lazyBind cd (rightID (leftID
    (rightID i))) x8), leftID (rightID (rightID i)) :=: LazyBind (lazyBind cd
    (leftID (rightID (rightID i))) x9), rightID (rightID (rightID i)) :=:
    LazyBind (lazyBind cd (rightID (rightID (rightID i))) x10)]
  lazyBind d i (Choice_C_State cd j x y) = [ConstraintChoice cd j (lazyBind d i
    x) (lazyBind d i y)]
  lazyBind d i (Choices_C_State cd j@(FreeID _ _) xs) = lazyBindOrNarrow d i cd
    j xs
  lazyBind d i (Choices_C_State cd j@(NarrowedID _ _) xs) = [ConstraintChoices
    cd j (map (lazyBind d i) xs)]
  lazyBind _ _ (Choices_C_State cd i _) = error
    ("TransFunctions.State.lazyBind: Choices with ChoiceID: " ++ show i)
  lazyBind _ _ (Fail_C_State cd info) = [Unsolvable info]
  lazyBind d i (Guard_C_State cd c e) = getConstrList c ++ [i :=: LazyBind
    (lazyBind d i e)]

instance Curry C_State where

d_C_runIOES :: forall t1 t0 . (Curry_Prelude.Curry t0, Curry_Prelude.Curry
  t1) => C_IOES t0 t1 -> Cover -> ConstStore -> t0 -> Cover -> ConstStore
  -> Curry_Prelude.C_IO (Curry_Prelude.C_Either (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_Tuple2 t1 t0))
d_C_runIOES x1 cd cs = case x1 of
  C_M x2 -> x2
  Choice_C_IOES d i l r -> narrow d i (d_C_runIOES l cd cs) (d_C_runIOES r cd
    cs)
  Choices_C_IOES d i xs -> narrows cs d i (\z -> d_C_runIOES z cd cs) xs
  Guard_C_IOES d c e -> guardCons d c (d_C_runIOES e cd $! addCs c cs)
  Fail_C_IOES d info -> failCons d (traceFail "TransFunctions.runIOES" [show x1]
    info)
  _ -> failCons cd (consFail "TransFunctions.runIOES" (showCons x1))

nd_C_runIOES :: forall t1 t0 . (Curry_Prelude.Curry t0, Curry_Prelude.Curry
  t1) => C_IOES t0 t1 -> IDSupply -> Cover -> ConstStore -> Func t0
  (Curry_Prelude.C_IO (Curry_Prelude.C_Either (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_Tuple2 t1 t0)))
nd_C_runIOES x1 s cd cs = case x1 of
  HO_C_M x2 -> x2
  Choice_C_IOES d i l r -> narrow d i (nd_C_runIOES l s cd cs) (nd_C_runIOES r s
    cd cs)
  Choices_C_IOES d i xs -> narrows cs d i (\z -> nd_C_runIOES z s cd cs) xs
  Guard_C_IOES d c e -> guardCons d c (nd_C_runIOES e s cd $! addCs c cs)
  Fail_C_IOES d info -> failCons d (traceFail "TransFunctions.runIOES" [show x1]
    info)
  _ -> failCons cd (consFail "TransFunctions.runIOES" (showCons x1))

d_C_returnM :: forall t1 t0 . (Curry_Prelude.Curry t0, Curry_Prelude.Curry
  t1) => t0 -> Cover -> ConstStore -> C_IOES t1 t0
d_C_returnM x1 cd cs = Curry_Prelude.d_OP_dollar (acceptCs id C_M)
  (d_OP_returnM_dot_uscore_hash_lambda65 x1) cd cs

nd_C_returnM :: forall t1 t0 . (Curry_Prelude.Curry t0, Curry_Prelude.Curry
  t1) => t0 -> IDSupply -> Cover -> ConstStore -> C_IOES t1 t0
nd_C_returnM x1 s cd cs = let s0 = s
  in s0 `seq` Curry_Prelude.nd_OP_dollar (wrapDX id (acceptCs id HO_C_M))
  (wrapDX id (d_OP_returnM_dot_uscore_hash_lambda65 x1)) s0 cd cs

d_OP_returnM_dot_uscore_hash_lambda65 :: forall t0 t1 . (Curry_Prelude.Curry t1
  , Curry_Prelude.Curry t0) => t0 -> t1 -> Cover -> ConstStore
  -> Curry_Prelude.C_IO (Curry_Prelude.C_Either (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_Tuple2 t0 t1))
d_OP_returnM_dot_uscore_hash_lambda65 x1 x2 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Prelude.C_Right (Curry_Prelude.OP_Tuple2 x1 x2)) cd cs

d_OP_gt_plus_eq :: forall t1 t0 t2 . (Curry_Prelude.Curry t2
  , Curry_Prelude.Curry t0, Curry_Prelude.Curry t1) => C_IOES t0 t1 -> (t1
  -> Cover -> ConstStore -> C_IOES t0 t2) -> Cover -> ConstStore -> C_IOES t0 t2
d_OP_gt_plus_eq x1 x2 cd cs = Curry_Prelude.d_OP_dollar (acceptCs id C_M)
  (d_OP_gt_plus_eq_dot_uscore_hash_lambda66 x1 x2) cd cs

nd_OP_gt_plus_eq :: forall t1 t0 t2 . (Curry_Prelude.Curry t2
  , Curry_Prelude.Curry t0, Curry_Prelude.Curry t1) => C_IOES t0 t1 -> Func t1
  (C_IOES t0 t2) -> IDSupply -> Cover -> ConstStore -> C_IOES t0 t2
nd_OP_gt_plus_eq x1 x2 s cd cs = let s0 = s
  in s0 `seq` Curry_Prelude.nd_OP_dollar (wrapDX id (acceptCs id HO_C_M))
  (wrapNX id (nd_OP_gt_plus_eq_dot_uscore_hash_lambda66 x1 x2)) s0 cd cs

d_OP_gt_plus_eq_dot_uscore_hash_lambda66 :: forall t1 t2
  t0 . (Curry_Prelude.Curry t0, Curry_Prelude.Curry t2, Curry_Prelude.Curry
  t1) => C_IOES t0 t1 -> (t1 -> Cover -> ConstStore -> C_IOES t0 t2) -> t0
  -> Cover -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_Either
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_Tuple2 t2 t0))
d_OP_gt_plus_eq_dot_uscore_hash_lambda66 x1 x2 x3 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Prelude.d_C_apply (d_C_runIOES x1 cd cs) x3 cd cs)
  (d_OP_gt_plus_eq_dot_uscore_hash_lambda66_dot_uscore_hash_lambda68 x2) cd cs

nd_OP_gt_plus_eq_dot_uscore_hash_lambda66 :: forall t1 t2
  t0 . (Curry_Prelude.Curry t0, Curry_Prelude.Curry t2, Curry_Prelude.Curry
  t1) => C_IOES t0 t1 -> Func t1 (C_IOES t0 t2) -> t0 -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_Either
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_Tuple2 t2 t0))
nd_OP_gt_plus_eq_dot_uscore_hash_lambda66 x1 x2 x3 s cd cs = let s4 = s
  in s4 `seq` (let s3 = leftSupply s4
                   s2 = rightSupply s4
  in s3 `seq` (s2 `seq`
  Curry_Prelude.nd_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (let s1 = leftSupply s2
       s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (nd_C_runIOES x1 s0 cd cs) x3
  s1 cd cs)) (wrapNX id
  (nd_OP_gt_plus_eq_dot_uscore_hash_lambda66_dot_uscore_hash_lambda68 x2)) s3 cd
  cs))

d_OP_gt_plus_eq_dot_uscore_hash_lambda66_dot_uscore_hash_lambda68 :: forall t0
  t2 t1 . (Curry_Prelude.Curry t1, Curry_Prelude.Curry t2, Curry_Prelude.Curry
  t0) => (t0 -> Cover -> ConstStore -> C_IOES t1 t2) -> Curry_Prelude.C_Either
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_Tuple2 t0 t1)
  -> Cover -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_Either
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_Tuple2 t2 t1))
d_OP_gt_plus_eq_dot_uscore_hash_lambda66_dot_uscore_hash_lambda68 x1 x2 cd cs =
  case x2 of
  Curry_Prelude.C_Left x3 -> Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (Curry_Prelude.C_Left x3) cd cs
  Curry_Prelude.C_Right x4 -> d_C__case_201 x1 x4 cd cs
  Curry_Prelude.Choice_C_Either d i l r -> narrow d i
    (d_OP_gt_plus_eq_dot_uscore_hash_lambda66_dot_uscore_hash_lambda68 x1 l cd
    cs) (d_OP_gt_plus_eq_dot_uscore_hash_lambda66_dot_uscore_hash_lambda68 x1 r
    cd cs)
  Curry_Prelude.Choices_C_Either d i xs -> narrows cs d i (\z ->
    d_OP_gt_plus_eq_dot_uscore_hash_lambda66_dot_uscore_hash_lambda68 x1 z cd
    cs) xs
  Curry_Prelude.Guard_C_Either d c e -> guardCons d c
    (d_OP_gt_plus_eq_dot_uscore_hash_lambda66_dot_uscore_hash_lambda68 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Either d info -> failCons d (traceFail
    "TransFunctions.>+=._#lambda66._#lambda68" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.>+=._#lambda66._#lambda68"
    (showCons x2))

nd_OP_gt_plus_eq_dot_uscore_hash_lambda66_dot_uscore_hash_lambda68 :: forall t0
  t2 t1 . (Curry_Prelude.Curry t1, Curry_Prelude.Curry t2, Curry_Prelude.Curry
  t0) => Func t0 (C_IOES t1 t2) -> Curry_Prelude.C_Either (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_Tuple2 t0 t1) -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_Either
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_Tuple2 t2 t1))
nd_OP_gt_plus_eq_dot_uscore_hash_lambda66_dot_uscore_hash_lambda68 x1 x2 s cd cs =
  case x2 of
  Curry_Prelude.C_Left x3 -> Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
    (Curry_Prelude.C_Left x3) cd cs
  Curry_Prelude.C_Right x4 -> let s0 = s
    in s0 `seq` nd_C__case_201 x1 x4 s0 cd cs
  Curry_Prelude.Choice_C_Either d i l r -> narrow d i
    (nd_OP_gt_plus_eq_dot_uscore_hash_lambda66_dot_uscore_hash_lambda68 x1 l s
    cd cs) (nd_OP_gt_plus_eq_dot_uscore_hash_lambda66_dot_uscore_hash_lambda68
    x1 r s cd cs)
  Curry_Prelude.Choices_C_Either d i xs -> narrows cs d i (\z ->
    nd_OP_gt_plus_eq_dot_uscore_hash_lambda66_dot_uscore_hash_lambda68 x1 z s cd
    cs) xs
  Curry_Prelude.Guard_C_Either d c e -> guardCons d c
    (nd_OP_gt_plus_eq_dot_uscore_hash_lambda66_dot_uscore_hash_lambda68 x1 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Either d info -> failCons d (traceFail
    "TransFunctions.>+=._#lambda66._#lambda68" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.>+=._#lambda66._#lambda68"
    (showCons x2))

d_OP_gt_plus :: forall t1 t0 t2 . (Curry_Prelude.Curry t2, Curry_Prelude.Curry
  t0, Curry_Prelude.Curry t1) => C_IOES t0 t1 -> C_IOES t0 t2 -> Cover
  -> ConstStore -> C_IOES t0 t2
d_OP_gt_plus x1 x2 cd cs = d_OP_gt_plus_eq x1
  (d_OP_gt_plus_dot_uscore_hash_lambda71 x2) cd cs

nd_OP_gt_plus :: forall t1 t0 t2 . (Curry_Prelude.Curry t2, Curry_Prelude.Curry
  t0, Curry_Prelude.Curry t1) => C_IOES t0 t1 -> C_IOES t0 t2 -> IDSupply
  -> Cover -> ConstStore -> C_IOES t0 t2
nd_OP_gt_plus x1 x2 s cd cs = let s0 = s
  in s0 `seq` nd_OP_gt_plus_eq x1 (wrapNX id
  (nd_OP_gt_plus_dot_uscore_hash_lambda71 x2)) s0 cd cs

d_OP_gt_plus_dot_uscore_hash_lambda71 :: forall t2 t0 t1 . (Curry_Prelude.Curry
  t1, Curry_Prelude.Curry t0, Curry_Prelude.Curry t2) => C_IOES t0 t1 -> t2
  -> Cover -> ConstStore -> C_IOES t0 t1
d_OP_gt_plus_dot_uscore_hash_lambda71 x1 x2 cd cs = x1

nd_OP_gt_plus_dot_uscore_hash_lambda71 :: forall t2 t0 t1 . (Curry_Prelude.Curry
  t1, Curry_Prelude.Curry t0, Curry_Prelude.Curry t2) => C_IOES t0 t1 -> t2
  -> IDSupply -> Cover -> ConstStore -> C_IOES t0 t1
nd_OP_gt_plus_dot_uscore_hash_lambda71 x1 x2 s cd cs = x1

d_C_failM :: forall t0 t1 . (Curry_Prelude.Curry t1, Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> C_IOES t0 t1
d_C_failM x1 cd cs = Curry_Prelude.d_OP_dollar (acceptCs id C_M)
  (d_OP_failM_dot_uscore_hash_lambda72 x1) cd cs

nd_C_failM :: forall t0 t1 . (Curry_Prelude.Curry t1, Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_List Curry_Prelude.C_Char -> IDSupply -> Cover
  -> ConstStore -> C_IOES t0 t1
nd_C_failM x1 s cd cs = let s0 = s
  in s0 `seq` Curry_Prelude.nd_OP_dollar (wrapDX id (acceptCs id HO_C_M))
  (wrapDX id (d_OP_failM_dot_uscore_hash_lambda72 x1)) s0 cd cs

d_OP_failM_dot_uscore_hash_lambda72 :: forall t1 t0 . (Curry_Prelude.Curry t0
  , Curry_Prelude.Curry t1) => Curry_Prelude.OP_List Curry_Prelude.C_Char -> t0
  -> Cover -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_Either
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_Tuple2 t1 t0))
d_OP_failM_dot_uscore_hash_lambda72 x1 x2 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Prelude.C_Left x1) cd cs

d_C_getState :: forall t0 . (Curry_Prelude.Curry t0) => Cover -> ConstStore
  -> C_IOES t0 t0
d_C_getState cd cs = Curry_Prelude.d_OP_dollar (acceptCs id C_M)
  d_OP_getState_dot_uscore_hash_lambda73 cd cs

nd_C_getState :: forall t0 . (Curry_Prelude.Curry t0) => IDSupply -> Cover
  -> ConstStore -> C_IOES t0 t0
nd_C_getState s cd cs = let s0 = s
  in s0 `seq` Curry_Prelude.nd_OP_dollar (wrapDX id (acceptCs id HO_C_M))
  (wrapDX id d_OP_getState_dot_uscore_hash_lambda73) s0 cd cs

d_OP_getState_dot_uscore_hash_lambda73 :: forall t0 . (Curry_Prelude.Curry
  t0) => t0 -> Cover -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_Either
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_Tuple2 t0 t0))
d_OP_getState_dot_uscore_hash_lambda73 x1 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Prelude.C_Right (Curry_Prelude.OP_Tuple2 x1 x1)) cd cs

d_C_putState :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> Cover
  -> ConstStore -> C_IOES t0 Curry_Prelude.OP_Unit
d_C_putState x1 cd cs = Curry_Prelude.d_OP_dollar (acceptCs id C_M)
  (d_OP_putState_dot_uscore_hash_lambda74 x1) cd cs

nd_C_putState :: forall t0 . (Curry_Prelude.Curry t0) => t0 -> IDSupply -> Cover
  -> ConstStore -> C_IOES t0 Curry_Prelude.OP_Unit
nd_C_putState x1 s cd cs = let s0 = s
  in s0 `seq` Curry_Prelude.nd_OP_dollar (wrapDX id (acceptCs id HO_C_M))
  (wrapDX id (d_OP_putState_dot_uscore_hash_lambda74 x1)) s0 cd cs

d_OP_putState_dot_uscore_hash_lambda74 :: forall t0 . (Curry_Prelude.Curry
  t0) => t0 -> t0 -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.C_Either (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.OP_Unit t0))
d_OP_putState_dot_uscore_hash_lambda74 x1 x2 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Prelude.C_Right (Curry_Prelude.OP_Tuple2 Curry_Prelude.OP_Unit x1)) cd
  cs

d_C_updState :: forall t0 . (Curry_Prelude.Curry t0) => (t0 -> Cover
  -> ConstStore -> t0) -> Cover -> ConstStore -> C_IOES t0 Curry_Prelude.OP_Unit
d_C_updState x1 cd cs = d_OP_gt_plus_eq (d_C_getState cd cs)
  (d_OP_updState_dot_uscore_hash_lambda75 x1) cd cs

nd_C_updState :: forall t0 . (Curry_Prelude.Curry t0) => Func t0 t0 -> IDSupply
  -> Cover -> ConstStore -> C_IOES t0 Curry_Prelude.OP_Unit
nd_C_updState x1 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getState s0 cd cs) (wrapNX id
  (nd_OP_updState_dot_uscore_hash_lambda75 x1)) s1 cd cs))

d_OP_updState_dot_uscore_hash_lambda75 :: forall t0 . (Curry_Prelude.Curry
  t0) => (t0 -> Cover -> ConstStore -> t0) -> t0 -> Cover -> ConstStore
  -> C_IOES t0 Curry_Prelude.OP_Unit
d_OP_updState_dot_uscore_hash_lambda75 x1 x2 cd cs = d_C_putState
  (Curry_Prelude.d_C_apply x1 x2 cd cs) cd cs

nd_OP_updState_dot_uscore_hash_lambda75 :: forall t0 . (Curry_Prelude.Curry
  t0) => Func t0 t0 -> t0 -> IDSupply -> Cover -> ConstStore -> C_IOES t0
  Curry_Prelude.OP_Unit
nd_OP_updState_dot_uscore_hash_lambda75 x1 x2 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_C_putState (Curry_Prelude.nd_C_apply x1 x2 s0 cd cs)
  s1 cd cs))

d_C_liftIO :: forall t1 t0 . (Curry_Prelude.Curry t0, Curry_Prelude.Curry
  t1) => Curry_Prelude.C_IO t0 -> Cover -> ConstStore -> C_IOES t1 t0
d_C_liftIO x1 cd cs = Curry_Prelude.d_OP_dollar (acceptCs id C_M)
  (d_OP_liftIO_dot_uscore_hash_lambda76 x1) cd cs

nd_C_liftIO :: forall t1 t0 . (Curry_Prelude.Curry t0, Curry_Prelude.Curry
  t1) => Curry_Prelude.C_IO t0 -> IDSupply -> Cover -> ConstStore -> C_IOES t1
  t0
nd_C_liftIO x1 s cd cs = let s0 = s
  in s0 `seq` Curry_Prelude.nd_OP_dollar (wrapDX id (acceptCs id HO_C_M))
  (wrapNX id (nd_OP_liftIO_dot_uscore_hash_lambda76 x1)) s0 cd cs

d_OP_liftIO_dot_uscore_hash_lambda76 :: forall t0 t1 . (Curry_Prelude.Curry t1
  , Curry_Prelude.Curry t0) => Curry_Prelude.C_IO t0 -> t1 -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_Either
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_Tuple2 t0 t1))
d_OP_liftIO_dot_uscore_hash_lambda76 x1 x2 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  x1 (d_OP_liftIO_dot_uscore_hash_lambda76_dot_uscore_hash_lambda78 x2) cd cs

nd_OP_liftIO_dot_uscore_hash_lambda76 :: forall t0 t1 . (Curry_Prelude.Curry t1
  , Curry_Prelude.Curry t0) => Curry_Prelude.C_IO t0 -> t1 -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_Either
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_Tuple2 t0 t1))
nd_OP_liftIO_dot_uscore_hash_lambda76 x1 x2 s cd cs = let s0 = s
  in s0 `seq`
  Curry_Prelude.nd_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  x1 (wrapDX id (d_OP_liftIO_dot_uscore_hash_lambda76_dot_uscore_hash_lambda78
  x2)) s0 cd cs

d_OP_liftIO_dot_uscore_hash_lambda76_dot_uscore_hash_lambda78 :: forall t1
  t0 . (Curry_Prelude.Curry t0, Curry_Prelude.Curry t1) => t0 -> t1 -> Cover
  -> ConstStore -> Curry_Prelude.C_IO (Curry_Prelude.C_Either
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_Tuple2 t1 t0))
d_OP_liftIO_dot_uscore_hash_lambda76_dot_uscore_hash_lambda78 x1 x2 cd cs =
  let x3 = x2
  in Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO
  (Curry_Prelude.C_Right (Curry_Prelude.OP_Tuple2 x3 x1)) cd cs

d_C_liftM :: forall t0 t2 t1 . (Curry_Prelude.Curry t1, Curry_Prelude.Curry t2
  , Curry_Prelude.Curry t0) => (t0 -> Cover -> ConstStore -> t1) -> C_IOES t2 t0
  -> Cover -> ConstStore -> C_IOES t2 t1
d_C_liftM x1 x2 cd cs = d_OP_gt_plus_eq x2 (d_OP_liftM_dot_uscore_hash_lambda80
  x1) cd cs

nd_C_liftM :: forall t0 t2 t1 . (Curry_Prelude.Curry t1, Curry_Prelude.Curry t2
  , Curry_Prelude.Curry t0) => Func t0 t1 -> C_IOES t2 t0 -> IDSupply -> Cover
  -> ConstStore -> C_IOES t2 t1
nd_C_liftM x1 x2 s cd cs = let s0 = s
  in s0 `seq` nd_OP_gt_plus_eq x2 (wrapNX id
  (nd_OP_liftM_dot_uscore_hash_lambda80 x1)) s0 cd cs

d_OP_liftM_dot_uscore_hash_lambda80 :: forall t0 t2 t1 . (Curry_Prelude.Curry t1
  , Curry_Prelude.Curry t2, Curry_Prelude.Curry t0) => (t0 -> Cover
  -> ConstStore -> t1) -> t0 -> Cover -> ConstStore -> C_IOES t2 t1
d_OP_liftM_dot_uscore_hash_lambda80 x1 x2 cd cs = d_C_returnM
  (Curry_Prelude.d_C_apply x1 x2 cd cs) cd cs

nd_OP_liftM_dot_uscore_hash_lambda80 :: forall t0 t2 t1 . (Curry_Prelude.Curry
  t1, Curry_Prelude.Curry t2, Curry_Prelude.Curry t0) => Func t0 t1 -> t0
  -> IDSupply -> Cover -> ConstStore -> C_IOES t2 t1
nd_OP_liftM_dot_uscore_hash_lambda80 x1 x2 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_C_returnM (Curry_Prelude.nd_C_apply x1 x2 s0 cd cs)
  s1 cd cs))

d_C_liftM2 :: forall t0 t1 t3 t2 . (Curry_Prelude.Curry t2, Curry_Prelude.Curry
  t3, Curry_Prelude.Curry t1, Curry_Prelude.Curry t0) => (t0 -> Cover
  -> ConstStore -> t1 -> Cover -> ConstStore -> t2) -> C_IOES t3 t0 -> C_IOES t3
  t1 -> Cover -> ConstStore -> C_IOES t3 t2
d_C_liftM2 x1 x2 x3 cd cs = d_OP_gt_plus_eq x2
  (d_OP_liftM2_dot_uscore_hash_lambda81 x3 x1) cd cs

nd_C_liftM2 :: forall t0 t1 t3 t2 . (Curry_Prelude.Curry t2, Curry_Prelude.Curry
  t3, Curry_Prelude.Curry t1, Curry_Prelude.Curry t0) => Func t0 (Func t1 t2)
  -> C_IOES t3 t0 -> C_IOES t3 t1 -> IDSupply -> Cover -> ConstStore -> C_IOES
  t3 t2
nd_C_liftM2 x1 x2 x3 s cd cs = let s0 = s
  in s0 `seq` nd_OP_gt_plus_eq x2 (wrapNX id
  (nd_OP_liftM2_dot_uscore_hash_lambda81 x3 x1)) s0 cd cs

d_OP_liftM2_dot_uscore_hash_lambda81 :: forall t1 t2 t0
  t3 . (Curry_Prelude.Curry t3, Curry_Prelude.Curry t0, Curry_Prelude.Curry t2
  , Curry_Prelude.Curry t1) => C_IOES t0 t1 -> (t2 -> Cover -> ConstStore -> t1
  -> Cover -> ConstStore -> t3) -> t2 -> Cover -> ConstStore -> C_IOES t0 t3
d_OP_liftM2_dot_uscore_hash_lambda81 x1 x2 x3 cd cs = d_OP_gt_plus_eq x1
  (d_OP_liftM2_dot_uscore_hash_lambda81_dot_uscore_hash_lambda82 x3 x2) cd cs

nd_OP_liftM2_dot_uscore_hash_lambda81 :: forall t1 t2 t0
  t3 . (Curry_Prelude.Curry t3, Curry_Prelude.Curry t0, Curry_Prelude.Curry t2
  , Curry_Prelude.Curry t1) => C_IOES t0 t1 -> Func t2 (Func t1 t3) -> t2
  -> IDSupply -> Cover -> ConstStore -> C_IOES t0 t3
nd_OP_liftM2_dot_uscore_hash_lambda81 x1 x2 x3 s cd cs = let s0 = s
  in s0 `seq` nd_OP_gt_plus_eq x1 (wrapNX id
  (nd_OP_liftM2_dot_uscore_hash_lambda81_dot_uscore_hash_lambda82 x3 x2)) s0 cd
  cs

d_OP_liftM2_dot_uscore_hash_lambda81_dot_uscore_hash_lambda82 :: forall t0 t1 t3
  t2 . (Curry_Prelude.Curry t2, Curry_Prelude.Curry t3, Curry_Prelude.Curry t1
  , Curry_Prelude.Curry t0) => t0 -> (t0 -> Cover -> ConstStore -> t1 -> Cover
  -> ConstStore -> t2) -> t1 -> Cover -> ConstStore -> C_IOES t3 t2
d_OP_liftM2_dot_uscore_hash_lambda81_dot_uscore_hash_lambda82 x1 x2 x3 cd cs =
  d_C_returnM (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply x2 x1 cd cs) x3
  cd cs) cd cs

nd_OP_liftM2_dot_uscore_hash_lambda81_dot_uscore_hash_lambda82 :: forall t0 t1
  t3 t2 . (Curry_Prelude.Curry t2, Curry_Prelude.Curry t3, Curry_Prelude.Curry
  t1, Curry_Prelude.Curry t0) => t0 -> Func t0 (Func t1 t2) -> t1 -> IDSupply
  -> Cover -> ConstStore -> C_IOES t3 t2
nd_OP_liftM2_dot_uscore_hash_lambda81_dot_uscore_hash_lambda82 x1 x2 x3 s cd cs =
  let s4 = s
  in s4 `seq` (let s3 = leftSupply s4
                   s2 = rightSupply s4
  in s3 `seq` (s2 `seq` nd_C_returnM (let s1 = leftSupply s2
                                          s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x2 x1
  s0 cd cs) x3 s1 cd cs)) s3 cd cs))

d_C_mapM :: forall t0 t1 t2 . (Curry_Prelude.Curry t2, Curry_Prelude.Curry t1
  , Curry_Prelude.Curry t0) => (t0 -> Cover -> ConstStore -> C_IOES t1 t2)
  -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore -> C_IOES t1
  (Curry_Prelude.OP_List t2)
d_C_mapM x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_List -> d_C_returnM Curry_Prelude.OP_List cd cs
  Curry_Prelude.OP_Cons x3 x4 -> d_OP_gt_plus_eq (Curry_Prelude.d_C_apply x1 x3
    cd cs) (d_OP_mapM_dot_uscore_hash_lambda83 x4 x1) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_mapM x1 l cd cs)
    (d_C_mapM x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_mapM x1 z cd
    cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_mapM x1 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions.mapM" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.mapM" (showCons x2))

nd_C_mapM :: forall t0 t1 t2 . (Curry_Prelude.Curry t2, Curry_Prelude.Curry t1
  , Curry_Prelude.Curry t0) => Func t0 (C_IOES t1 t2) -> Curry_Prelude.OP_List
  t0 -> IDSupply -> Cover -> ConstStore -> C_IOES t1 (Curry_Prelude.OP_List t2)
nd_C_mapM x1 x2 s cd cs = case x2 of
  Curry_Prelude.OP_List -> let s0 = s
    in s0 `seq` nd_C_returnM Curry_Prelude.OP_List s0 cd cs
  Curry_Prelude.OP_Cons x3 x4 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (Curry_Prelude.nd_C_apply x1 x3 s0 cd
    cs) (wrapNX id (nd_OP_mapM_dot_uscore_hash_lambda83 x4 x1)) s1 cd cs))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C_mapM x1 l s cd cs)
    (nd_C_mapM x1 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C_mapM x1 z s
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C_mapM x1 e s cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions.mapM" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.mapM" (showCons x2))

d_OP_mapM_dot_uscore_hash_lambda83 :: forall t0 t1 t2 . (Curry_Prelude.Curry t2
  , Curry_Prelude.Curry t1, Curry_Prelude.Curry t0) => Curry_Prelude.OP_List t0
  -> (t0 -> Cover -> ConstStore -> C_IOES t1 t2) -> t2 -> Cover -> ConstStore
  -> C_IOES t1 (Curry_Prelude.OP_List t2)
d_OP_mapM_dot_uscore_hash_lambda83 x1 x2 x3 cd cs = d_OP_gt_plus_eq (d_C_mapM x2
  x1 cd cs) (d_OP_mapM_dot_uscore_hash_lambda83_dot_uscore_hash_lambda84 x3) cd
  cs

nd_OP_mapM_dot_uscore_hash_lambda83 :: forall t0 t1 t2 . (Curry_Prelude.Curry t2
  , Curry_Prelude.Curry t1, Curry_Prelude.Curry t0) => Curry_Prelude.OP_List t0
  -> Func t0 (C_IOES t1 t2) -> t2 -> IDSupply -> Cover -> ConstStore -> C_IOES
  t1 (Curry_Prelude.OP_List t2)
nd_OP_mapM_dot_uscore_hash_lambda83 x1 x2 x3 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_mapM x2 x1 s0 cd cs) (wrapNX id
  (nd_OP_mapM_dot_uscore_hash_lambda83_dot_uscore_hash_lambda84 x3)) s1 cd cs))

d_OP_mapM_dot_uscore_hash_lambda83_dot_uscore_hash_lambda84 :: forall t1
  t0 . (Curry_Prelude.Curry t0, Curry_Prelude.Curry t1) => t0
  -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore -> C_IOES t1
  (Curry_Prelude.OP_List t0)
d_OP_mapM_dot_uscore_hash_lambda83_dot_uscore_hash_lambda84 x1 x2 cd cs =
  d_C_returnM (Curry_Prelude.OP_Cons x1 x2) cd cs

nd_OP_mapM_dot_uscore_hash_lambda83_dot_uscore_hash_lambda84 :: forall t1
  t0 . (Curry_Prelude.Curry t0, Curry_Prelude.Curry t1) => t0
  -> Curry_Prelude.OP_List t0 -> IDSupply -> Cover -> ConstStore -> C_IOES t1
  (Curry_Prelude.OP_List t0)
nd_OP_mapM_dot_uscore_hash_lambda83_dot_uscore_hash_lambda84 x1 x2 s cd cs =
  let s0 = s in s0 `seq` nd_C_returnM (Curry_Prelude.OP_Cons x1 x2) s0 cd cs

d_C_foldM :: forall t1 t2 t0 . (Curry_Prelude.Curry t0, Curry_Prelude.Curry t2
  , Curry_Prelude.Curry t1) => (t0 -> Cover -> ConstStore -> t1 -> Cover
  -> ConstStore -> C_IOES t2 t0) -> t0 -> Curry_Prelude.OP_List t1 -> Cover
  -> ConstStore -> C_IOES t2 t0
d_C_foldM x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_List -> d_C_returnM x2 cd cs
  Curry_Prelude.OP_Cons x4 x5 -> d_OP_gt_plus_eq (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply x1 x2 cd cs) x4 cd cs)
    (d_OP_foldM_dot_uscore_hash_lambda85 x5 x1) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_foldM x1 x2 l cd cs)
    (d_C_foldM x1 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_foldM x1 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_foldM x1 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions.foldM" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransFunctions.foldM" (showCons x3))

nd_C_foldM :: forall t1 t2 t0 . (Curry_Prelude.Curry t0, Curry_Prelude.Curry t2
  , Curry_Prelude.Curry t1) => Func t0 (Func t1 (C_IOES t2 t0)) -> t0
  -> Curry_Prelude.OP_List t1 -> IDSupply -> Cover -> ConstStore -> C_IOES t2 t0
nd_C_foldM x1 x2 x3 s cd cs = case x3 of
  Curry_Prelude.OP_List -> let s0 = s in s0 `seq` nd_C_returnM x2 s0 cd cs
  Curry_Prelude.OP_Cons x4 x5 -> let s4 = s
    in s4 `seq` (let s3 = leftSupply s4
                     s2 = rightSupply s4
    in s3 `seq` (s2 `seq` nd_OP_gt_plus_eq (let s1 = leftSupply s2
                                                s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply x1
    x2 s0 cd cs) x4 s1 cd cs)) (wrapNX id (nd_OP_foldM_dot_uscore_hash_lambda85
    x5 x1)) s3 cd cs))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C_foldM x1 x2 l s cd
    cs) (nd_C_foldM x1 x2 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C_foldM x1 x2
    z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C_foldM x1 x2 e s cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions.foldM" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransFunctions.foldM" (showCons x3))

d_OP_foldM_dot_uscore_hash_lambda85 :: forall t0 t2 t1 . (Curry_Prelude.Curry t1
  , Curry_Prelude.Curry t2, Curry_Prelude.Curry t0) => Curry_Prelude.OP_List t0
  -> (t1 -> Cover -> ConstStore -> t0 -> Cover -> ConstStore -> C_IOES t2 t1)
  -> t1 -> Cover -> ConstStore -> C_IOES t2 t1
d_OP_foldM_dot_uscore_hash_lambda85 x1 x2 x3 cd cs = d_C_foldM x2 x3 x1 cd cs

nd_OP_foldM_dot_uscore_hash_lambda85 :: forall t0 t2 t1 . (Curry_Prelude.Curry
  t1, Curry_Prelude.Curry t2, Curry_Prelude.Curry t0) => Curry_Prelude.OP_List
  t0 -> Func t1 (Func t0 (C_IOES t2 t1)) -> t1 -> IDSupply -> Cover
  -> ConstStore -> C_IOES t2 t1
nd_OP_foldM_dot_uscore_hash_lambda85 x1 x2 x3 s cd cs = let s0 = s
  in s0 `seq` nd_C_foldM x2 x3 x1 s0 cd cs

d_C_typeMap :: C_State -> Cover -> ConstStore -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C_typeMap x1 cd cs = case x1 of
  C_State x2 x3 x4 x5 x6 x7 x8 x9 -> x2
  Choice_C_State d i l r -> narrow d i (d_C_typeMap l cd cs) (d_C_typeMap r cd
    cs)
  Choices_C_State d i xs -> narrows cs d i (\z -> d_C_typeMap z cd cs) xs
  Guard_C_State d c e -> guardCons d c (d_C_typeMap e cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail "TransFunctions.typeMap" [show
    x1] info)
  _ -> failCons cd (consFail "TransFunctions.typeMap" (showCons x1))

nd_C_typeMap :: C_State -> IDSupply -> Cover -> ConstStore
  -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_C_typeMap x1 s cd cs = case x1 of
  C_State x2 x3 x4 x5 x6 x7 x8 x9 -> x2
  Choice_C_State d i l r -> narrow d i (nd_C_typeMap l s cd cs) (nd_C_typeMap r
    s cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z -> nd_C_typeMap z s cd cs) xs
  Guard_C_State d c e -> guardCons d c (nd_C_typeMap e s cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail "TransFunctions.typeMap" [show
    x1] info)
  _ -> failCons cd (consFail "TransFunctions.typeMap" (showCons x1))

d_C_ndResult :: C_State -> Cover -> ConstStore -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) Curry_Classification.C_NDClass
d_C_ndResult x1 cd cs = case x1 of
  C_State x2 x3 x4 x5 x6 x7 x8 x9 -> x3
  Choice_C_State d i l r -> narrow d i (d_C_ndResult l cd cs) (d_C_ndResult r cd
    cs)
  Choices_C_State d i xs -> narrows cs d i (\z -> d_C_ndResult z cd cs) xs
  Guard_C_State d c e -> guardCons d c (d_C_ndResult e cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail "TransFunctions.ndResult" [show
    x1] info)
  _ -> failCons cd (consFail "TransFunctions.ndResult" (showCons x1))

nd_C_ndResult :: C_State -> IDSupply -> Cover -> ConstStore
  -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_NDClass
nd_C_ndResult x1 s cd cs = case x1 of
  C_State x2 x3 x4 x5 x6 x7 x8 x9 -> x3
  Choice_C_State d i l r -> narrow d i (nd_C_ndResult l s cd cs) (nd_C_ndResult
    r s cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z -> nd_C_ndResult z s cd cs) xs
  Guard_C_State d c e -> guardCons d c (nd_C_ndResult e s cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail "TransFunctions.ndResult" [show
    x1] info)
  _ -> failCons cd (consFail "TransFunctions.ndResult" (showCons x1))

d_C_hoResultType :: C_State -> Cover -> ConstStore -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass
d_C_hoResultType x1 cd cs = case x1 of
  C_State x2 x3 x4 x5 x6 x7 x8 x9 -> x4
  Choice_C_State d i l r -> narrow d i (d_C_hoResultType l cd cs)
    (d_C_hoResultType r cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z -> d_C_hoResultType z cd cs) xs
  Guard_C_State d c e -> guardCons d c (d_C_hoResultType e cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail "TransFunctions.hoResultType"
    [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.hoResultType" (showCons x1))

nd_C_hoResultType :: C_State -> IDSupply -> Cover -> ConstStore
  -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass
nd_C_hoResultType x1 s cd cs = case x1 of
  C_State x2 x3 x4 x5 x6 x7 x8 x9 -> x4
  Choice_C_State d i l r -> narrow d i (nd_C_hoResultType l s cd cs)
    (nd_C_hoResultType r s cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z -> nd_C_hoResultType z s cd cs)
    xs
  Guard_C_State d c e -> guardCons d c (nd_C_hoResultType e s cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail "TransFunctions.hoResultType"
    [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.hoResultType" (showCons x1))

d_C_hoResultCons :: C_State -> Cover -> ConstStore -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass
d_C_hoResultCons x1 cd cs = case x1 of
  C_State x2 x3 x4 x5 x6 x7 x8 x9 -> x5
  Choice_C_State d i l r -> narrow d i (d_C_hoResultCons l cd cs)
    (d_C_hoResultCons r cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z -> d_C_hoResultCons z cd cs) xs
  Guard_C_State d c e -> guardCons d c (d_C_hoResultCons e cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail "TransFunctions.hoResultCons"
    [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.hoResultCons" (showCons x1))

nd_C_hoResultCons :: C_State -> IDSupply -> Cover -> ConstStore
  -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass
nd_C_hoResultCons x1 s cd cs = case x1 of
  C_State x2 x3 x4 x5 x6 x7 x8 x9 -> x5
  Choice_C_State d i l r -> narrow d i (nd_C_hoResultCons l s cd cs)
    (nd_C_hoResultCons r s cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z -> nd_C_hoResultCons z s cd cs)
    xs
  Guard_C_State d c e -> guardCons d c (nd_C_hoResultCons e s cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail "TransFunctions.hoResultCons"
    [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.hoResultCons" (showCons x1))

d_C_hoResultFunc :: C_State -> Cover -> ConstStore -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_FuncHOClass
d_C_hoResultFunc x1 cd cs = case x1 of
  C_State x2 x3 x4 x5 x6 x7 x8 x9 -> x6
  Choice_C_State d i l r -> narrow d i (d_C_hoResultFunc l cd cs)
    (d_C_hoResultFunc r cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z -> d_C_hoResultFunc z cd cs) xs
  Guard_C_State d c e -> guardCons d c (d_C_hoResultFunc e cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail "TransFunctions.hoResultFunc"
    [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.hoResultFunc" (showCons x1))

nd_C_hoResultFunc :: C_State -> IDSupply -> Cover -> ConstStore
  -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_FuncHOClass
nd_C_hoResultFunc x1 s cd cs = case x1 of
  C_State x2 x3 x4 x5 x6 x7 x8 x9 -> x6
  Choice_C_State d i l r -> narrow d i (nd_C_hoResultFunc l s cd cs)
    (nd_C_hoResultFunc r s cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z -> nd_C_hoResultFunc z s cd cs)
    xs
  Guard_C_State d c e -> guardCons d c (nd_C_hoResultFunc e s cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail "TransFunctions.hoResultFunc"
    [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.hoResultFunc" (showCons x1))

d_C_nextID :: C_State -> Cover -> ConstStore -> Curry_Prelude.C_Int
d_C_nextID x1 cd cs = case x1 of
  C_State x2 x3 x4 x5 x6 x7 x8 x9 -> x7
  Choice_C_State d i l r -> narrow d i (d_C_nextID l cd cs) (d_C_nextID r cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z -> d_C_nextID z cd cs) xs
  Guard_C_State d c e -> guardCons d c (d_C_nextID e cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail "TransFunctions.nextID" [show x1]
    info)
  _ -> failCons cd (consFail "TransFunctions.nextID" (showCons x1))

nd_C_nextID :: C_State -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.C_Int
nd_C_nextID x1 s cd cs = case x1 of
  C_State x2 x3 x4 x5 x6 x7 x8 x9 -> x7
  Choice_C_State d i l r -> narrow d i (nd_C_nextID l s cd cs) (nd_C_nextID r s
    cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z -> nd_C_nextID z s cd cs) xs
  Guard_C_State d c e -> guardCons d c (nd_C_nextID e s cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail "TransFunctions.nextID" [show x1]
    info)
  _ -> failCons cd (consFail "TransFunctions.nextID" (showCons x1))

d_C_detMode :: C_State -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_detMode x1 cd cs = case x1 of
  C_State x2 x3 x4 x5 x6 x7 x8 x9 -> x8
  Choice_C_State d i l r -> narrow d i (d_C_detMode l cd cs) (d_C_detMode r cd
    cs)
  Choices_C_State d i xs -> narrows cs d i (\z -> d_C_detMode z cd cs) xs
  Guard_C_State d c e -> guardCons d c (d_C_detMode e cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail "TransFunctions.detMode" [show
    x1] info)
  _ -> failCons cd (consFail "TransFunctions.detMode" (showCons x1))

nd_C_detMode :: C_State -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
nd_C_detMode x1 s cd cs = case x1 of
  C_State x2 x3 x4 x5 x6 x7 x8 x9 -> x8
  Choice_C_State d i l r -> narrow d i (nd_C_detMode l s cd cs) (nd_C_detMode r
    s cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z -> nd_C_detMode z s cd cs) xs
  Guard_C_State d c e -> guardCons d c (nd_C_detMode e s cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail "TransFunctions.detMode" [show
    x1] info)
  _ -> failCons cd (consFail "TransFunctions.detMode" (showCons x1))

d_C_compOptions :: C_State -> Cover -> ConstStore
  -> Curry_CompilerOpts.C_Options
d_C_compOptions x1 cd cs = case x1 of
  C_State x2 x3 x4 x5 x6 x7 x8 x9 -> x9
  Choice_C_State d i l r -> narrow d i (d_C_compOptions l cd cs)
    (d_C_compOptions r cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z -> d_C_compOptions z cd cs) xs
  Guard_C_State d c e -> guardCons d c (d_C_compOptions e cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail "TransFunctions.compOptions"
    [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.compOptions" (showCons x1))

nd_C_compOptions :: C_State -> IDSupply -> Cover -> ConstStore
  -> Curry_CompilerOpts.C_Options
nd_C_compOptions x1 s cd cs = case x1 of
  C_State x2 x3 x4 x5 x6 x7 x8 x9 -> x9
  Choice_C_State d i l r -> narrow d i (nd_C_compOptions l s cd cs)
    (nd_C_compOptions r s cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z -> nd_C_compOptions z s cd cs) xs
  Guard_C_State d c e -> guardCons d c (nd_C_compOptions e s cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail "TransFunctions.compOptions"
    [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.compOptions" (showCons x1))

d_C_defaultState :: Cover -> ConstStore -> C_State
d_C_defaultState cd cs = C_State (Curry_Analysis.d_C_initTypeMap cd cs)
  (Curry_Analysis.d_C_initNDResult cd cs) (Curry_Analysis.d_C_initTypeHOResult
  cd cs) (Curry_Analysis.d_C_initHOResult cd cs)
  (Curry_Analysis.d_C_initHOResult cd cs) (Curry_Prelude.C_Int (0))
  Curry_Prelude.C_False (Curry_CompilerOpts.d_C_defaultOptions cd cs)

nd_C_defaultState :: IDSupply -> Cover -> ConstStore -> C_State
nd_C_defaultState s cd cs = let s5 = s
  in s5 `seq` (let s6 = leftSupply s5
                   s7 = rightSupply s5
                   s0 = leftSupply s6
                   s1 = rightSupply s6
                   s2 = leftSupply s7
                   s8 = rightSupply s7
                   s3 = leftSupply s8
                   s4 = rightSupply s8
  in s6 `seq` (s7 `seq` (s0 `seq` (s1 `seq` (s2 `seq` (s8 `seq` (s3 `seq`
  (s4 `seq` C_State (Curry_Analysis.nd_C_initTypeMap s0 cd cs)
  (Curry_Analysis.nd_C_initNDResult s1 cd cs)
  (Curry_Analysis.nd_C_initTypeHOResult s2 cd cs)
  (Curry_Analysis.nd_C_initHOResult s3 cd cs) (Curry_Analysis.nd_C_initHOResult
  s4 cd cs) (Curry_Prelude.C_Int (0)) Curry_Prelude.C_False
  (Curry_CompilerOpts.d_C_defaultOptions cd cs)))))))))

d_C_addTypeMap :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> C_IOES C_State Curry_Prelude.OP_Unit
d_C_addTypeMap x1 cd cs = d_C_updState (d_OP_addTypeMap_dot_uscore_hash_lambda86
  x1) cd cs

nd_C_addTypeMap :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State Curry_Prelude.OP_Unit
nd_C_addTypeMap x1 s cd cs = let s0 = s
  in s0 `seq` nd_C_updState (wrapNX id
  (nd_OP_addTypeMap_dot_uscore_hash_lambda86 x1)) s0 cd cs

d_OP_addTypeMap_dot_uscore_hash_lambda86 :: Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> C_State -> Cover -> ConstStore -> C_State
d_OP_addTypeMap_dot_uscore_hash_lambda86 x1 x2 cd cs = case x2 of
  C_State x3 x4 x5 x6 x7 x8 x9 x10 -> C_State (Curry_FiniteMap.d_C_plusFM
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) cd cs) (d_C_typeMap x2 cd cs) x1 cd cs) x4 x5 x6 x7 x8 x9 x10
  Choice_C_State d i l r -> narrow d i (d_OP_addTypeMap_dot_uscore_hash_lambda86
    x1 l cd cs) (d_OP_addTypeMap_dot_uscore_hash_lambda86 x1 r cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z ->
    d_OP_addTypeMap_dot_uscore_hash_lambda86 x1 z cd cs) xs
  Guard_C_State d c e -> guardCons d c (d_OP_addTypeMap_dot_uscore_hash_lambda86
    x1 e cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail
    "TransFunctions.addTypeMap._#lambda86" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.addTypeMap._#lambda86" (showCons
    x2))

nd_OP_addTypeMap_dot_uscore_hash_lambda86 :: Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> C_State -> IDSupply -> Cover -> ConstStore
  -> C_State
nd_OP_addTypeMap_dot_uscore_hash_lambda86 x1 x2 s cd cs = case x2 of
  C_State x3 x4 x5 x6 x7 x8 x9 x10 -> let s11 = s
    in s11 `seq` C_State (let s10 = leftSupply s11
                              s12 = rightSupply s11
                              s7 = leftSupply s12
                              s9 = rightSupply s12
    in s10 `seq` (s12 `seq` (s7 `seq` (s9 `seq` Curry_FiniteMap.nd_C_plusFM
    (let s6 = leftSupply s7
         s8 = rightSupply s7
         s2 = leftSupply s8
         s5 = rightSupply s8
    in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (let s1 = leftSupply s2
         s0 = rightSupply s2
    in s1 `seq` (s0 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    s0 cd cs) s1 cd cs)) (let s4 = leftSupply s5
                              s3 = rightSupply s5
    in s4 `seq` (s3 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    s3 cd cs) s4 cd cs)) s6 cd cs)))) (nd_C_typeMap x2 s9 cd cs) x1 s10 cd
    cs)))) x4 x5 x6 x7 x8 x9 x10
  Choice_C_State d i l r -> narrow d i
    (nd_OP_addTypeMap_dot_uscore_hash_lambda86 x1 l s cd cs)
    (nd_OP_addTypeMap_dot_uscore_hash_lambda86 x1 r s cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z ->
    nd_OP_addTypeMap_dot_uscore_hash_lambda86 x1 z s cd cs) xs
  Guard_C_State d c e -> guardCons d c
    (nd_OP_addTypeMap_dot_uscore_hash_lambda86 x1 e s cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail
    "TransFunctions.addTypeMap._#lambda86" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.addTypeMap._#lambda86" (showCons
    x2))

d_C_getType :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C_getType x1 cd cs = d_OP_gt_plus_eq (d_C_getState cd cs)
  (d_OP_getType_dot_uscore_hash_lambda96 x1) cd cs

nd_C_getType :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply
  -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
nd_C_getType x1 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getState s0 cd cs) (wrapNX id
  (nd_OP_getType_dot_uscore_hash_lambda96 x1)) s1 cd cs))

d_OP_getType_dot_uscore_hash_lambda96 :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> C_State -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_getType_dot_uscore_hash_lambda96 x1 x2 cd cs = Curry_Prelude.d_OP_dollar
  (Curry_Prelude.d_C_maybe (Curry_Prelude.d_OP_dollar d_C_failM
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_lparen_comma_rparen
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char cd
  cs) cd cs)
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char cd
  cs) cd cs) cd cs) x1 cd cs) (Curry_Prelude.toCurryString " not in type map")
  cd cs) cd cs) d_C_returnM) (Curry_Prelude.d_C_flip (acceptCs id
  (Curry_FiniteMap.d_C_lookupFM
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs)
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs) cd cs))) x1 (d_C_typeMap x2 cd cs) cd cs) cd cs

nd_OP_getType_dot_uscore_hash_lambda96 :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> C_State -> IDSupply -> Cover -> ConstStore -> C_IOES
  C_State (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_OP_getType_dot_uscore_hash_lambda96 x1 x2 s cd cs = let s27 = s
  in s27 `seq` (let s26 = leftSupply s27
                    s28 = rightSupply s27
                    s12 = leftSupply s28
                    s24 = rightSupply s28
  in s26 `seq` (s28 `seq` (s12 `seq` (s24 `seq` Curry_Prelude.nd_OP_dollar
  (wrapNX id (Curry_Prelude.nd_C_maybe (let s11 = leftSupply s12
                                            s10 = rightSupply s12
  in s11 `seq` (s10 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id nd_C_failM)
  (Curry_Prelude.d_OP_plus_plus (let s9 = leftSupply s10
                                     s7 = rightSupply s10
  in s9 `seq` (s7 `seq` Curry_Prelude.nd_C_apply (let s6 = leftSupply s7
                                                      s8 = rightSupply s7
                                                      s2 = leftSupply s8
                                                      s5 = rightSupply s8
  in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq`
  Curry_Prelude.nd_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_lparen_comma_rparen
  (let s1 = leftSupply s2
       s0 = rightSupply s2
  in s1 `seq` (s0 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char
  s0 cd cs) s1 cd cs)) (let s4 = leftSupply s5
                            s3 = rightSupply s5
  in s4 `seq` (s3 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char
  s3 cd cs) s4 cd cs)) s6 cd cs)))) x1 s9 cd cs)) (Curry_Prelude.toCurryString
  " not in type map") cd cs) s11 cd cs)) (wrapNX id nd_C_returnM)))
  (let s23 = leftSupply s24
       s25 = rightSupply s24
       s20 = leftSupply s25
       s22 = rightSupply s25
  in s23 `seq` (s25 `seq` (s20 `seq` (s22 `seq` Curry_Prelude.nd_C_flip (wrapDX
  (wrapNX id) (acceptCs id (Curry_FiniteMap.nd_C_lookupFM (let s19 = leftSupply
                                                                 s20
                                                               s21 = rightSupply
                                                                 s20
                                                               s15 = leftSupply
                                                                 s21
                                                               s18 = rightSupply
                                                                 s21
  in s19 `seq` (s21 `seq` (s15 `seq` (s18 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
  (let s14 = leftSupply s15
       s13 = rightSupply s15
  in s14 `seq` (s13 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char s13
  cd cs) s14 cd cs)) (let s17 = leftSupply s18
                          s16 = rightSupply s18
  in s17 `seq` (s16 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char s16
  cd cs) s17 cd cs)) s19 cd cs))))))) x1 (nd_C_typeMap x2 s22 cd cs) s23 cd
  cs)))) s26 cd cs))))

d_C_addNDAnalysis :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_NDClass -> Cover -> ConstStore
  -> C_IOES C_State Curry_Prelude.OP_Unit
d_C_addNDAnalysis x1 cd cs = Curry_Prelude.d_OP_dollar d_C_updState
  (d_OP_addNDAnalysis_dot_uscore_hash_lambda97 x1) cd cs

nd_C_addNDAnalysis :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_NDClass -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State Curry_Prelude.OP_Unit
nd_C_addNDAnalysis x1 s cd cs = let s0 = s
  in s0 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id nd_C_updState) (wrapNX id
  (nd_OP_addNDAnalysis_dot_uscore_hash_lambda97 x1)) s0 cd cs

d_OP_addNDAnalysis_dot_uscore_hash_lambda97 :: Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) Curry_Classification.C_NDClass
  -> C_State -> Cover -> ConstStore -> C_State
d_OP_addNDAnalysis_dot_uscore_hash_lambda97 x1 x2 cd cs = case x2 of
  C_State x3 x4 x5 x6 x7 x8 x9 x10 -> C_State x3 (Curry_FiniteMap.d_C_plusFM
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) cd cs) x1 (d_C_ndResult x2 cd cs) cd cs) x5 x6 x7 x8 x9 x10
  Choice_C_State d i l r -> narrow d i
    (d_OP_addNDAnalysis_dot_uscore_hash_lambda97 x1 l cd cs)
    (d_OP_addNDAnalysis_dot_uscore_hash_lambda97 x1 r cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z ->
    d_OP_addNDAnalysis_dot_uscore_hash_lambda97 x1 z cd cs) xs
  Guard_C_State d c e -> guardCons d c
    (d_OP_addNDAnalysis_dot_uscore_hash_lambda97 x1 e cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail
    "TransFunctions.addNDAnalysis._#lambda97" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.addNDAnalysis._#lambda97" (showCons
    x2))

nd_OP_addNDAnalysis_dot_uscore_hash_lambda97 :: Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) Curry_Classification.C_NDClass
  -> C_State -> IDSupply -> Cover -> ConstStore -> C_State
nd_OP_addNDAnalysis_dot_uscore_hash_lambda97 x1 x2 s cd cs = case x2 of
  C_State x3 x4 x5 x6 x7 x8 x9 x10 -> let s11 = s
    in s11 `seq` C_State x3 (let s10 = leftSupply s11
                                 s12 = rightSupply s11
                                 s7 = leftSupply s12
                                 s9 = rightSupply s12
    in s10 `seq` (s12 `seq` (s7 `seq` (s9 `seq` Curry_FiniteMap.nd_C_plusFM
    (let s6 = leftSupply s7
         s8 = rightSupply s7
         s2 = leftSupply s8
         s5 = rightSupply s8
    in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (let s1 = leftSupply s2
         s0 = rightSupply s2
    in s1 `seq` (s0 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    s0 cd cs) s1 cd cs)) (let s4 = leftSupply s5
                              s3 = rightSupply s5
    in s4 `seq` (s3 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    s3 cd cs) s4 cd cs)) s6 cd cs)))) x1 (nd_C_ndResult x2 s9 cd cs) s10 cd
    cs)))) x5 x6 x7 x8 x9 x10
  Choice_C_State d i l r -> narrow d i
    (nd_OP_addNDAnalysis_dot_uscore_hash_lambda97 x1 l s cd cs)
    (nd_OP_addNDAnalysis_dot_uscore_hash_lambda97 x1 r s cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z ->
    nd_OP_addNDAnalysis_dot_uscore_hash_lambda97 x1 z s cd cs) xs
  Guard_C_State d c e -> guardCons d c
    (nd_OP_addNDAnalysis_dot_uscore_hash_lambda97 x1 e s cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail
    "TransFunctions.addNDAnalysis._#lambda97" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.addNDAnalysis._#lambda97" (showCons
    x2))

d_C_getNDClass :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> C_IOES C_State Curry_Classification.C_NDClass
d_C_getNDClass x1 cd cs = d_OP_gt_plus_eq (d_C_getState cd cs)
  (d_OP_getNDClass_dot_uscore_hash_lambda107 x1) cd cs

nd_C_getNDClass :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply
  -> Cover -> ConstStore -> C_IOES C_State Curry_Classification.C_NDClass
nd_C_getNDClass x1 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getState s0 cd cs) (wrapNX id
  (nd_OP_getNDClass_dot_uscore_hash_lambda107 x1)) s1 cd cs))

d_OP_getNDClass_dot_uscore_hash_lambda107 :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> C_State -> Cover -> ConstStore -> C_IOES C_State
  Curry_Classification.C_NDClass
d_OP_getNDClass_dot_uscore_hash_lambda107 x1 x2 cd cs =
  Curry_Prelude.d_OP_dollar (Curry_Prelude.d_C_maybe (Curry_Prelude.d_OP_dollar
  d_C_failM (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_lparen_comma_rparen
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char cd
  cs) cd cs)
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char cd
  cs) cd cs) cd cs) x1 cd cs) (Curry_Prelude.toCurryString " not analysed") cd
  cs) cd cs) d_C_returnM) (Curry_Prelude.d_C_flip (acceptCs id
  (Curry_FiniteMap.d_C_lookupFM
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs)
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs) cd cs))) x1 (d_C_ndResult x2 cd cs) cd cs) cd cs

nd_OP_getNDClass_dot_uscore_hash_lambda107 :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> C_State -> IDSupply -> Cover -> ConstStore -> C_IOES
  C_State Curry_Classification.C_NDClass
nd_OP_getNDClass_dot_uscore_hash_lambda107 x1 x2 s cd cs = let s27 = s
  in s27 `seq` (let s26 = leftSupply s27
                    s28 = rightSupply s27
                    s12 = leftSupply s28
                    s24 = rightSupply s28
  in s26 `seq` (s28 `seq` (s12 `seq` (s24 `seq` Curry_Prelude.nd_OP_dollar
  (wrapNX id (Curry_Prelude.nd_C_maybe (let s11 = leftSupply s12
                                            s10 = rightSupply s12
  in s11 `seq` (s10 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id nd_C_failM)
  (Curry_Prelude.d_OP_plus_plus (let s9 = leftSupply s10
                                     s7 = rightSupply s10
  in s9 `seq` (s7 `seq` Curry_Prelude.nd_C_apply (let s6 = leftSupply s7
                                                      s8 = rightSupply s7
                                                      s2 = leftSupply s8
                                                      s5 = rightSupply s8
  in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq`
  Curry_Prelude.nd_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_lparen_comma_rparen
  (let s1 = leftSupply s2
       s0 = rightSupply s2
  in s1 `seq` (s0 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char
  s0 cd cs) s1 cd cs)) (let s4 = leftSupply s5
                            s3 = rightSupply s5
  in s4 `seq` (s3 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char
  s3 cd cs) s4 cd cs)) s6 cd cs)))) x1 s9 cd cs)) (Curry_Prelude.toCurryString
  " not analysed") cd cs) s11 cd cs)) (wrapNX id nd_C_returnM)))
  (let s23 = leftSupply s24
       s25 = rightSupply s24
       s20 = leftSupply s25
       s22 = rightSupply s25
  in s23 `seq` (s25 `seq` (s20 `seq` (s22 `seq` Curry_Prelude.nd_C_flip (wrapDX
  (wrapNX id) (acceptCs id (Curry_FiniteMap.nd_C_lookupFM (let s19 = leftSupply
                                                                 s20
                                                               s21 = rightSupply
                                                                 s20
                                                               s15 = leftSupply
                                                                 s21
                                                               s18 = rightSupply
                                                                 s21
  in s19 `seq` (s21 `seq` (s15 `seq` (s18 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
  (let s14 = leftSupply s15
       s13 = rightSupply s15
  in s14 `seq` (s13 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char s13
  cd cs) s14 cd cs)) (let s17 = leftSupply s18
                          s16 = rightSupply s18
  in s17 `seq` (s16 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char s16
  cd cs) s17 cd cs)) s19 cd cs))))))) x1 (nd_C_ndResult x2 s22 cd cs) s23 cd
  cs)))) s26 cd cs))))

d_C_addHOTypeAnalysis :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_TypeHOClass -> Cover
  -> ConstStore -> C_IOES C_State Curry_Prelude.OP_Unit
d_C_addHOTypeAnalysis x1 cd cs = Curry_Prelude.d_OP_dollar d_C_updState
  (d_OP_addHOTypeAnalysis_dot_uscore_hash_lambda108 x1) cd cs

nd_C_addHOTypeAnalysis :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_TypeHOClass -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State Curry_Prelude.OP_Unit
nd_C_addHOTypeAnalysis x1 s cd cs = let s0 = s
  in s0 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id nd_C_updState) (wrapNX id
  (nd_OP_addHOTypeAnalysis_dot_uscore_hash_lambda108 x1)) s0 cd cs

d_OP_addHOTypeAnalysis_dot_uscore_hash_lambda108 :: Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass -> C_State -> Cover -> ConstStore
  -> C_State
d_OP_addHOTypeAnalysis_dot_uscore_hash_lambda108 x1 x2 cd cs = case x2 of
  C_State x3 x4 x5 x6 x7 x8 x9 x10 -> C_State x3 x4 (Curry_FiniteMap.d_C_plusFM
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) cd cs) x1 (d_C_hoResultType x2 cd cs) cd cs) x6 x7 x8 x9 x10
  Choice_C_State d i l r -> narrow d i
    (d_OP_addHOTypeAnalysis_dot_uscore_hash_lambda108 x1 l cd cs)
    (d_OP_addHOTypeAnalysis_dot_uscore_hash_lambda108 x1 r cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z ->
    d_OP_addHOTypeAnalysis_dot_uscore_hash_lambda108 x1 z cd cs) xs
  Guard_C_State d c e -> guardCons d c
    (d_OP_addHOTypeAnalysis_dot_uscore_hash_lambda108 x1 e cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail
    "TransFunctions.addHOTypeAnalysis._#lambda108" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.addHOTypeAnalysis._#lambda108"
    (showCons x2))

nd_OP_addHOTypeAnalysis_dot_uscore_hash_lambda108 :: Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass -> C_State -> IDSupply -> Cover
  -> ConstStore -> C_State
nd_OP_addHOTypeAnalysis_dot_uscore_hash_lambda108 x1 x2 s cd cs = case x2 of
  C_State x3 x4 x5 x6 x7 x8 x9 x10 -> let s11 = s
    in s11 `seq` C_State x3 x4 (let s10 = leftSupply s11
                                    s12 = rightSupply s11
                                    s7 = leftSupply s12
                                    s9 = rightSupply s12
    in s10 `seq` (s12 `seq` (s7 `seq` (s9 `seq` Curry_FiniteMap.nd_C_plusFM
    (let s6 = leftSupply s7
         s8 = rightSupply s7
         s2 = leftSupply s8
         s5 = rightSupply s8
    in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (let s1 = leftSupply s2
         s0 = rightSupply s2
    in s1 `seq` (s0 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    s0 cd cs) s1 cd cs)) (let s4 = leftSupply s5
                              s3 = rightSupply s5
    in s4 `seq` (s3 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    s3 cd cs) s4 cd cs)) s6 cd cs)))) x1 (nd_C_hoResultType x2 s9 cd cs) s10 cd
    cs)))) x6 x7 x8 x9 x10
  Choice_C_State d i l r -> narrow d i
    (nd_OP_addHOTypeAnalysis_dot_uscore_hash_lambda108 x1 l s cd cs)
    (nd_OP_addHOTypeAnalysis_dot_uscore_hash_lambda108 x1 r s cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z ->
    nd_OP_addHOTypeAnalysis_dot_uscore_hash_lambda108 x1 z s cd cs) xs
  Guard_C_State d c e -> guardCons d c
    (nd_OP_addHOTypeAnalysis_dot_uscore_hash_lambda108 x1 e s cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail
    "TransFunctions.addHOTypeAnalysis._#lambda108" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.addHOTypeAnalysis._#lambda108"
    (showCons x2))

d_C_getTypeHOClass :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> C_IOES C_State Curry_Classification.C_TypeHOClass
d_C_getTypeHOClass x1 cd cs = d_OP_gt_plus_eq (d_C_getState cd cs)
  (d_OP_getTypeHOClass_dot_uscore_hash_lambda118 x1) cd cs

nd_C_getTypeHOClass :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply
  -> Cover -> ConstStore -> C_IOES C_State Curry_Classification.C_TypeHOClass
nd_C_getTypeHOClass x1 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getState s0 cd cs) (wrapNX id
  (nd_OP_getTypeHOClass_dot_uscore_hash_lambda118 x1)) s1 cd cs))

d_OP_getTypeHOClass_dot_uscore_hash_lambda118 :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> C_State -> Cover -> ConstStore -> C_IOES C_State
  Curry_Classification.C_TypeHOClass
d_OP_getTypeHOClass_dot_uscore_hash_lambda118 x1 x2 cd cs =
  Curry_Prelude.d_OP_dollar (Curry_Prelude.d_C_maybe (Curry_Prelude.d_OP_dollar
  d_C_failM (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_lparen_comma_rparen
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char cd
  cs) cd cs)
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char cd
  cs) cd cs) cd cs) x1 cd cs) (Curry_Prelude.toCurryString " not analysed") cd
  cs) cd cs) d_C_returnM) (Curry_Prelude.d_C_flip (acceptCs id
  (Curry_FiniteMap.d_C_lookupFM
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs)
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs) cd cs))) x1 (d_C_hoResultType x2 cd cs) cd cs) cd cs

nd_OP_getTypeHOClass_dot_uscore_hash_lambda118 :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> C_State -> IDSupply -> Cover -> ConstStore -> C_IOES
  C_State Curry_Classification.C_TypeHOClass
nd_OP_getTypeHOClass_dot_uscore_hash_lambda118 x1 x2 s cd cs = let s27 = s
  in s27 `seq` (let s26 = leftSupply s27
                    s28 = rightSupply s27
                    s12 = leftSupply s28
                    s24 = rightSupply s28
  in s26 `seq` (s28 `seq` (s12 `seq` (s24 `seq` Curry_Prelude.nd_OP_dollar
  (wrapNX id (Curry_Prelude.nd_C_maybe (let s11 = leftSupply s12
                                            s10 = rightSupply s12
  in s11 `seq` (s10 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id nd_C_failM)
  (Curry_Prelude.d_OP_plus_plus (let s9 = leftSupply s10
                                     s7 = rightSupply s10
  in s9 `seq` (s7 `seq` Curry_Prelude.nd_C_apply (let s6 = leftSupply s7
                                                      s8 = rightSupply s7
                                                      s2 = leftSupply s8
                                                      s5 = rightSupply s8
  in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq`
  Curry_Prelude.nd_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_lparen_comma_rparen
  (let s1 = leftSupply s2
       s0 = rightSupply s2
  in s1 `seq` (s0 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char
  s0 cd cs) s1 cd cs)) (let s4 = leftSupply s5
                            s3 = rightSupply s5
  in s4 `seq` (s3 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char
  s3 cd cs) s4 cd cs)) s6 cd cs)))) x1 s9 cd cs)) (Curry_Prelude.toCurryString
  " not analysed") cd cs) s11 cd cs)) (wrapNX id nd_C_returnM)))
  (let s23 = leftSupply s24
       s25 = rightSupply s24
       s20 = leftSupply s25
       s22 = rightSupply s25
  in s23 `seq` (s25 `seq` (s20 `seq` (s22 `seq` Curry_Prelude.nd_C_flip (wrapDX
  (wrapNX id) (acceptCs id (Curry_FiniteMap.nd_C_lookupFM (let s19 = leftSupply
                                                                 s20
                                                               s21 = rightSupply
                                                                 s20
                                                               s15 = leftSupply
                                                                 s21
                                                               s18 = rightSupply
                                                                 s21
  in s19 `seq` (s21 `seq` (s15 `seq` (s18 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
  (let s14 = leftSupply s15
       s13 = rightSupply s15
  in s14 `seq` (s13 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char s13
  cd cs) s14 cd cs)) (let s17 = leftSupply s18
                          s16 = rightSupply s18
  in s17 `seq` (s16 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char s16
  cd cs) s17 cd cs)) s19 cd cs))))))) x1 (nd_C_hoResultType x2 s22 cd cs) s23 cd
  cs)))) s26 cd cs))))

d_C_addHOConsAnalysis :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_ConsHOClass -> Cover
  -> ConstStore -> C_IOES C_State Curry_Prelude.OP_Unit
d_C_addHOConsAnalysis x1 cd cs = Curry_Prelude.d_OP_dollar d_C_updState
  (d_OP_addHOConsAnalysis_dot_uscore_hash_lambda119 x1) cd cs

nd_C_addHOConsAnalysis :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_ConsHOClass -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State Curry_Prelude.OP_Unit
nd_C_addHOConsAnalysis x1 s cd cs = let s0 = s
  in s0 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id nd_C_updState) (wrapNX id
  (nd_OP_addHOConsAnalysis_dot_uscore_hash_lambda119 x1)) s0 cd cs

d_OP_addHOConsAnalysis_dot_uscore_hash_lambda119 :: Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass -> C_State -> Cover -> ConstStore
  -> C_State
d_OP_addHOConsAnalysis_dot_uscore_hash_lambda119 x1 x2 cd cs = case x2 of
  C_State x3 x4 x5 x6 x7 x8 x9 x10 -> C_State x3 x4 x5
    (Curry_FiniteMap.d_C_plusFM
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) cd cs) x1 (d_C_hoResultCons x2 cd cs) cd cs) x7 x8 x9 x10
  Choice_C_State d i l r -> narrow d i
    (d_OP_addHOConsAnalysis_dot_uscore_hash_lambda119 x1 l cd cs)
    (d_OP_addHOConsAnalysis_dot_uscore_hash_lambda119 x1 r cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z ->
    d_OP_addHOConsAnalysis_dot_uscore_hash_lambda119 x1 z cd cs) xs
  Guard_C_State d c e -> guardCons d c
    (d_OP_addHOConsAnalysis_dot_uscore_hash_lambda119 x1 e cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail
    "TransFunctions.addHOConsAnalysis._#lambda119" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.addHOConsAnalysis._#lambda119"
    (showCons x2))

nd_OP_addHOConsAnalysis_dot_uscore_hash_lambda119 :: Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass -> C_State -> IDSupply -> Cover
  -> ConstStore -> C_State
nd_OP_addHOConsAnalysis_dot_uscore_hash_lambda119 x1 x2 s cd cs = case x2 of
  C_State x3 x4 x5 x6 x7 x8 x9 x10 -> let s11 = s
    in s11 `seq` C_State x3 x4 x5 (let s10 = leftSupply s11
                                       s12 = rightSupply s11
                                       s7 = leftSupply s12
                                       s9 = rightSupply s12
    in s10 `seq` (s12 `seq` (s7 `seq` (s9 `seq` Curry_FiniteMap.nd_C_plusFM
    (let s6 = leftSupply s7
         s8 = rightSupply s7
         s2 = leftSupply s8
         s5 = rightSupply s8
    in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (let s1 = leftSupply s2
         s0 = rightSupply s2
    in s1 `seq` (s0 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    s0 cd cs) s1 cd cs)) (let s4 = leftSupply s5
                              s3 = rightSupply s5
    in s4 `seq` (s3 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    s3 cd cs) s4 cd cs)) s6 cd cs)))) x1 (nd_C_hoResultCons x2 s9 cd cs) s10 cd
    cs)))) x7 x8 x9 x10
  Choice_C_State d i l r -> narrow d i
    (nd_OP_addHOConsAnalysis_dot_uscore_hash_lambda119 x1 l s cd cs)
    (nd_OP_addHOConsAnalysis_dot_uscore_hash_lambda119 x1 r s cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z ->
    nd_OP_addHOConsAnalysis_dot_uscore_hash_lambda119 x1 z s cd cs) xs
  Guard_C_State d c e -> guardCons d c
    (nd_OP_addHOConsAnalysis_dot_uscore_hash_lambda119 x1 e s cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail
    "TransFunctions.addHOConsAnalysis._#lambda119" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.addHOConsAnalysis._#lambda119"
    (showCons x2))

d_C_getConsHOClass :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> C_IOES C_State Curry_Classification.C_ConsHOClass
d_C_getConsHOClass x1 cd cs = d_OP_gt_plus_eq (d_C_getState cd cs)
  (d_OP_getConsHOClass_dot_uscore_hash_lambda129 x1) cd cs

nd_C_getConsHOClass :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply
  -> Cover -> ConstStore -> C_IOES C_State Curry_Classification.C_ConsHOClass
nd_C_getConsHOClass x1 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getState s0 cd cs) (wrapNX id
  (nd_OP_getConsHOClass_dot_uscore_hash_lambda129 x1)) s1 cd cs))

d_OP_getConsHOClass_dot_uscore_hash_lambda129 :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> C_State -> Cover -> ConstStore -> C_IOES C_State
  Curry_Classification.C_ConsHOClass
d_OP_getConsHOClass_dot_uscore_hash_lambda129 x1 x2 cd cs =
  Curry_Prelude.d_OP_dollar (Curry_Prelude.d_C_maybe (Curry_Prelude.d_OP_dollar
  d_C_failM (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_lparen_comma_rparen
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char cd
  cs) cd cs)
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char cd
  cs) cd cs) cd cs) x1 cd cs) (Curry_Prelude.toCurryString " not analysed") cd
  cs) cd cs) d_C_returnM) (Curry_Prelude.d_OP_dollar (Curry_Prelude.d_C_flip
  (acceptCs id (Curry_FiniteMap.d_C_lookupFM
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs)
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs) cd cs))) x1) (d_C_hoResultCons x2 cd cs) cd cs) cd cs

nd_OP_getConsHOClass_dot_uscore_hash_lambda129 :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> C_State -> IDSupply -> Cover -> ConstStore -> C_IOES
  C_State Curry_Classification.C_ConsHOClass
nd_OP_getConsHOClass_dot_uscore_hash_lambda129 x1 x2 s cd cs = let s27 = s
  in s27 `seq` (let s26 = leftSupply s27
                    s28 = rightSupply s27
                    s12 = leftSupply s28
                    s24 = rightSupply s28
  in s26 `seq` (s28 `seq` (s12 `seq` (s24 `seq` Curry_Prelude.nd_OP_dollar
  (wrapNX id (Curry_Prelude.nd_C_maybe (let s11 = leftSupply s12
                                            s10 = rightSupply s12
  in s11 `seq` (s10 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id nd_C_failM)
  (Curry_Prelude.d_OP_plus_plus (let s9 = leftSupply s10
                                     s7 = rightSupply s10
  in s9 `seq` (s7 `seq` Curry_Prelude.nd_C_apply (let s6 = leftSupply s7
                                                      s8 = rightSupply s7
                                                      s2 = leftSupply s8
                                                      s5 = rightSupply s8
  in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq`
  Curry_Prelude.nd_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_lparen_comma_rparen
  (let s1 = leftSupply s2
       s0 = rightSupply s2
  in s1 `seq` (s0 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char
  s0 cd cs) s1 cd cs)) (let s4 = leftSupply s5
                            s3 = rightSupply s5
  in s4 `seq` (s3 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char
  s3 cd cs) s4 cd cs)) s6 cd cs)))) x1 s9 cd cs)) (Curry_Prelude.toCurryString
  " not analysed") cd cs) s11 cd cs)) (wrapNX id nd_C_returnM)))
  (let s23 = leftSupply s24
       s25 = rightSupply s24
       s20 = leftSupply s25
       s22 = rightSupply s25
  in s23 `seq` (s25 `seq` (s20 `seq` (s22 `seq` Curry_Prelude.nd_OP_dollar
  (wrapNX id (Curry_Prelude.nd_C_flip (wrapDX (wrapNX id) (acceptCs id
  (Curry_FiniteMap.nd_C_lookupFM (let s19 = leftSupply s20
                                      s21 = rightSupply s20
                                      s15 = leftSupply s21
                                      s18 = rightSupply s21
  in s19 `seq` (s21 `seq` (s15 `seq` (s18 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
  (let s14 = leftSupply s15
       s13 = rightSupply s15
  in s14 `seq` (s13 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char s13
  cd cs) s14 cd cs)) (let s17 = leftSupply s18
                          s16 = rightSupply s18
  in s17 `seq` (s16 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char s16
  cd cs) s17 cd cs)) s19 cd cs))))))) x1)) (nd_C_hoResultCons x2 s22 cd cs) s23
  cd cs)))) s26 cd cs))))

d_C_addHOFuncAnalysis :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_FuncHOClass -> Cover
  -> ConstStore -> C_IOES C_State Curry_Prelude.OP_Unit
d_C_addHOFuncAnalysis x1 cd cs = Curry_Prelude.d_OP_dollar d_C_updState
  (d_OP_addHOFuncAnalysis_dot_uscore_hash_lambda130 x1) cd cs

nd_C_addHOFuncAnalysis :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_FuncHOClass -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State Curry_Prelude.OP_Unit
nd_C_addHOFuncAnalysis x1 s cd cs = let s0 = s
  in s0 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id nd_C_updState) (wrapNX id
  (nd_OP_addHOFuncAnalysis_dot_uscore_hash_lambda130 x1)) s0 cd cs

d_OP_addHOFuncAnalysis_dot_uscore_hash_lambda130 :: Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_FuncHOClass -> C_State -> Cover -> ConstStore
  -> C_State
d_OP_addHOFuncAnalysis_dot_uscore_hash_lambda130 x1 x2 cd cs = case x2 of
  C_State x3 x4 x5 x6 x7 x8 x9 x10 -> C_State x3 x4 x5 x6
    (Curry_FiniteMap.d_C_plusFM
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) cd cs) x1 (d_C_hoResultFunc x2 cd cs) cd cs) x8 x9 x10
  Choice_C_State d i l r -> narrow d i
    (d_OP_addHOFuncAnalysis_dot_uscore_hash_lambda130 x1 l cd cs)
    (d_OP_addHOFuncAnalysis_dot_uscore_hash_lambda130 x1 r cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z ->
    d_OP_addHOFuncAnalysis_dot_uscore_hash_lambda130 x1 z cd cs) xs
  Guard_C_State d c e -> guardCons d c
    (d_OP_addHOFuncAnalysis_dot_uscore_hash_lambda130 x1 e cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail
    "TransFunctions.addHOFuncAnalysis._#lambda130" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.addHOFuncAnalysis._#lambda130"
    (showCons x2))

nd_OP_addHOFuncAnalysis_dot_uscore_hash_lambda130 :: Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_FuncHOClass -> C_State -> IDSupply -> Cover
  -> ConstStore -> C_State
nd_OP_addHOFuncAnalysis_dot_uscore_hash_lambda130 x1 x2 s cd cs = case x2 of
  C_State x3 x4 x5 x6 x7 x8 x9 x10 -> let s11 = s
    in s11 `seq` C_State x3 x4 x5 x6 (let s10 = leftSupply s11
                                          s12 = rightSupply s11
                                          s7 = leftSupply s12
                                          s9 = rightSupply s12
    in s10 `seq` (s12 `seq` (s7 `seq` (s9 `seq` Curry_FiniteMap.nd_C_plusFM
    (let s6 = leftSupply s7
         s8 = rightSupply s7
         s2 = leftSupply s8
         s5 = rightSupply s8
    in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (let s1 = leftSupply s2
         s0 = rightSupply s2
    in s1 `seq` (s0 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    s0 cd cs) s1 cd cs)) (let s4 = leftSupply s5
                              s3 = rightSupply s5
    in s4 `seq` (s3 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    s3 cd cs) s4 cd cs)) s6 cd cs)))) x1 (nd_C_hoResultFunc x2 s9 cd cs) s10 cd
    cs)))) x8 x9 x10
  Choice_C_State d i l r -> narrow d i
    (nd_OP_addHOFuncAnalysis_dot_uscore_hash_lambda130 x1 l s cd cs)
    (nd_OP_addHOFuncAnalysis_dot_uscore_hash_lambda130 x1 r s cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z ->
    nd_OP_addHOFuncAnalysis_dot_uscore_hash_lambda130 x1 z s cd cs) xs
  Guard_C_State d c e -> guardCons d c
    (nd_OP_addHOFuncAnalysis_dot_uscore_hash_lambda130 x1 e s cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail
    "TransFunctions.addHOFuncAnalysis._#lambda130" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.addHOFuncAnalysis._#lambda130"
    (showCons x2))

d_C_getFuncHOClass :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> C_IOES C_State Curry_Classification.C_FuncHOClass
d_C_getFuncHOClass x1 cd cs = d_OP_gt_plus_eq (d_C_getState cd cs)
  (d_OP_getFuncHOClass_dot_uscore_hash_lambda140 x1) cd cs

nd_C_getFuncHOClass :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply
  -> Cover -> ConstStore -> C_IOES C_State Curry_Classification.C_FuncHOClass
nd_C_getFuncHOClass x1 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getState s0 cd cs) (wrapNX id
  (nd_OP_getFuncHOClass_dot_uscore_hash_lambda140 x1)) s1 cd cs))

d_OP_getFuncHOClass_dot_uscore_hash_lambda140 :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> C_State -> Cover -> ConstStore -> C_IOES C_State
  Curry_Classification.C_FuncHOClass
d_OP_getFuncHOClass_dot_uscore_hash_lambda140 x1 x2 cd cs =
  Curry_Prelude.d_OP_dollar (Curry_Prelude.d_C_maybe (Curry_Prelude.d_OP_dollar
  d_C_failM (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_lparen_comma_rparen
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char cd
  cs) cd cs)
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char cd
  cs) cd cs) cd cs) x1 cd cs) (Curry_Prelude.toCurryString " not analysed") cd
  cs) cd cs) d_C_returnM) (Curry_Prelude.d_OP_dollar (Curry_Prelude.d_C_flip
  (acceptCs id (Curry_FiniteMap.d_C_lookupFM
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs)
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs) cd cs))) x1) (d_C_hoResultFunc x2 cd cs) cd cs) cd cs

nd_OP_getFuncHOClass_dot_uscore_hash_lambda140 :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> C_State -> IDSupply -> Cover -> ConstStore -> C_IOES
  C_State Curry_Classification.C_FuncHOClass
nd_OP_getFuncHOClass_dot_uscore_hash_lambda140 x1 x2 s cd cs = let s27 = s
  in s27 `seq` (let s26 = leftSupply s27
                    s28 = rightSupply s27
                    s12 = leftSupply s28
                    s24 = rightSupply s28
  in s26 `seq` (s28 `seq` (s12 `seq` (s24 `seq` Curry_Prelude.nd_OP_dollar
  (wrapNX id (Curry_Prelude.nd_C_maybe (let s11 = leftSupply s12
                                            s10 = rightSupply s12
  in s11 `seq` (s10 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id nd_C_failM)
  (Curry_Prelude.d_OP_plus_plus (let s9 = leftSupply s10
                                     s7 = rightSupply s10
  in s9 `seq` (s7 `seq` Curry_Prelude.nd_C_apply (let s6 = leftSupply s7
                                                      s8 = rightSupply s7
                                                      s2 = leftSupply s8
                                                      s5 = rightSupply s8
  in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq`
  Curry_Prelude.nd_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_lparen_comma_rparen
  (let s1 = leftSupply s2
       s0 = rightSupply s2
  in s1 `seq` (s0 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char
  s0 cd cs) s1 cd cs)) (let s4 = leftSupply s5
                            s3 = rightSupply s5
  in s4 `seq` (s3 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char
  s3 cd cs) s4 cd cs)) s6 cd cs)))) x1 s9 cd cs)) (Curry_Prelude.toCurryString
  " not analysed") cd cs) s11 cd cs)) (wrapNX id nd_C_returnM)))
  (let s23 = leftSupply s24
       s25 = rightSupply s24
       s20 = leftSupply s25
       s22 = rightSupply s25
  in s23 `seq` (s25 `seq` (s20 `seq` (s22 `seq` Curry_Prelude.nd_OP_dollar
  (wrapNX id (Curry_Prelude.nd_C_flip (wrapDX (wrapNX id) (acceptCs id
  (Curry_FiniteMap.nd_C_lookupFM (let s19 = leftSupply s20
                                      s21 = rightSupply s20
                                      s15 = leftSupply s21
                                      s18 = rightSupply s21
  in s19 `seq` (s21 `seq` (s15 `seq` (s18 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
  (let s14 = leftSupply s15
       s13 = rightSupply s15
  in s14 `seq` (s13 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char s13
  cd cs) s14 cd cs)) (let s17 = leftSupply s18
                          s16 = rightSupply s18
  in s17 `seq` (s16 `seq`
  Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char s16
  cd cs) s17 cd cs)) s19 cd cs))))))) x1)) (nd_C_hoResultFunc x2 s22 cd cs) s23
  cd cs)))) s26 cd cs))))

d_C_getNextID :: Cover -> ConstStore -> C_IOES C_State Curry_Prelude.C_Int
d_C_getNextID cd cs = d_OP_gt_plus_eq (d_C_getState cd cs)
  d_OP_getNextID_dot_uscore_hash_lambda141 cd cs

nd_C_getNextID :: IDSupply -> Cover -> ConstStore -> C_IOES C_State
  Curry_Prelude.C_Int
nd_C_getNextID s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getState s0 cd cs) (wrapNX id
  nd_OP_getNextID_dot_uscore_hash_lambda141) s1 cd cs))

d_OP_getNextID_dot_uscore_hash_lambda141 :: C_State -> Cover -> ConstStore
  -> C_IOES C_State Curry_Prelude.C_Int
d_OP_getNextID_dot_uscore_hash_lambda141 x1 cd cs = d_C_returnM (d_C_nextID x1
  cd cs) cd cs

nd_OP_getNextID_dot_uscore_hash_lambda141 :: C_State -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State Curry_Prelude.C_Int
nd_OP_getNextID_dot_uscore_hash_lambda141 x1 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_C_returnM (nd_C_nextID x1 s0 cd cs) s1 cd cs))

d_C_setNextID :: Curry_Prelude.C_Int -> Cover -> ConstStore -> C_IOES C_State
  Curry_Prelude.OP_Unit
d_C_setNextID x1 cd cs = d_C_updState (d_OP_setNextID_dot_uscore_hash_lambda142
  x1) cd cs

nd_C_setNextID :: Curry_Prelude.C_Int -> IDSupply -> Cover -> ConstStore
  -> C_IOES C_State Curry_Prelude.OP_Unit
nd_C_setNextID x1 s cd cs = let s0 = s
  in s0 `seq` nd_C_updState (wrapNX id
  (nd_OP_setNextID_dot_uscore_hash_lambda142 x1)) s0 cd cs

d_OP_setNextID_dot_uscore_hash_lambda142 :: Curry_Prelude.C_Int -> C_State
  -> Cover -> ConstStore -> C_State
d_OP_setNextID_dot_uscore_hash_lambda142 x1 x2 cd cs = case x2 of
  C_State x3 x4 x5 x6 x7 x8 x9 x10 -> C_State x3 x4 x5 x6 x7 x1 x9 x10
  Choice_C_State d i l r -> narrow d i (d_OP_setNextID_dot_uscore_hash_lambda142
    x1 l cd cs) (d_OP_setNextID_dot_uscore_hash_lambda142 x1 r cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z ->
    d_OP_setNextID_dot_uscore_hash_lambda142 x1 z cd cs) xs
  Guard_C_State d c e -> guardCons d c (d_OP_setNextID_dot_uscore_hash_lambda142
    x1 e cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail
    "TransFunctions.setNextID._#lambda142" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.setNextID._#lambda142" (showCons
    x2))

nd_OP_setNextID_dot_uscore_hash_lambda142 :: Curry_Prelude.C_Int -> C_State
  -> IDSupply -> Cover -> ConstStore -> C_State
nd_OP_setNextID_dot_uscore_hash_lambda142 x1 x2 s cd cs = case x2 of
  C_State x3 x4 x5 x6 x7 x8 x9 x10 -> C_State x3 x4 x5 x6 x7 x1 x9 x10
  Choice_C_State d i l r -> narrow d i
    (nd_OP_setNextID_dot_uscore_hash_lambda142 x1 l s cd cs)
    (nd_OP_setNextID_dot_uscore_hash_lambda142 x1 r s cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z ->
    nd_OP_setNextID_dot_uscore_hash_lambda142 x1 z s cd cs) xs
  Guard_C_State d c e -> guardCons d c
    (nd_OP_setNextID_dot_uscore_hash_lambda142 x1 e s cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail
    "TransFunctions.setNextID._#lambda142" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.setNextID._#lambda142" (showCons
    x2))

d_C_takeNextID :: Cover -> ConstStore -> C_IOES C_State Curry_Prelude.C_Int
d_C_takeNextID cd cs = d_OP_gt_plus_eq (d_C_getState cd cs)
  d_OP_takeNextID_dot_uscore_hash_lambda152 cd cs

nd_C_takeNextID :: IDSupply -> Cover -> ConstStore -> C_IOES C_State
  Curry_Prelude.C_Int
nd_C_takeNextID s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getState s0 cd cs) (wrapNX id
  nd_OP_takeNextID_dot_uscore_hash_lambda152) s1 cd cs))

d_OP_takeNextID_dot_uscore_hash_lambda152 :: C_State -> Cover -> ConstStore
  -> C_IOES C_State Curry_Prelude.C_Int
d_OP_takeNextID_dot_uscore_hash_lambda152 x1 cd cs = let x2 = d_C_nextID x1 cd
                                                           cs
  in d_OP_gt_plus (d_C_putState (d_C__case_200 x2 x1 cd cs) cd cs) (d_C_returnM
  x2 cd cs) cd cs

nd_OP_takeNextID_dot_uscore_hash_lambda152 :: C_State -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State Curry_Prelude.C_Int
nd_OP_takeNextID_dot_uscore_hash_lambda152 x1 s cd cs = let s8 = s
  in s8 `seq` (let s0 = leftSupply s8
                   s6 = rightSupply s8
  in s0 `seq` (s6 `seq` (let x2 = nd_C_nextID x1 s0 cd cs
  in let s5 = leftSupply s6
         s7 = rightSupply s6
         s3 = leftSupply s7
         s4 = rightSupply s7
  in s5 `seq` (s7 `seq` (s3 `seq` (s4 `seq` nd_OP_gt_plus (let s2 = leftSupply
                                                                 s3
                                                               s1 = rightSupply
                                                                 s3
  in s2 `seq` (s1 `seq` nd_C_putState (nd_C__case_200 x2 x1 s1 cd cs) s2 cd cs))
  (nd_C_returnM x2 s4 cd cs) s5 cd cs))))))

d_C_takeNextIDs :: Curry_Prelude.C_Int -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_List Curry_Prelude.C_Int)
d_C_takeNextIDs x1 cd cs = d_OP_gt_plus_eq (d_C_getState cd cs)
  (d_OP_takeNextIDs_dot_uscore_hash_lambda162 x1) cd cs

nd_C_takeNextIDs :: Curry_Prelude.C_Int -> IDSupply -> Cover -> ConstStore
  -> C_IOES C_State (Curry_Prelude.OP_List Curry_Prelude.C_Int)
nd_C_takeNextIDs x1 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getState s0 cd cs) (wrapNX id
  (nd_OP_takeNextIDs_dot_uscore_hash_lambda162 x1)) s1 cd cs))

d_OP_takeNextIDs_dot_uscore_hash_lambda162 :: Curry_Prelude.C_Int -> C_State
  -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_Prelude.C_Int)
d_OP_takeNextIDs_dot_uscore_hash_lambda162 x1 x2 cd cs = let x3 = d_C_nextID x2
                                                               cd cs
  in d_OP_gt_plus (d_C_putState (d_C__case_199 x1 x3 x2 cd cs) cd cs)
  (d_C_returnM (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_enumFromTo_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
  cd cs) x3 cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
  (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
  x3 x1 cd cs) (Curry_Prelude.C_Int (1)) cd cs) cd cs) cd cs) cd cs

nd_OP_takeNextIDs_dot_uscore_hash_lambda162 :: Curry_Prelude.C_Int -> C_State
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_Prelude.C_Int)
nd_OP_takeNextIDs_dot_uscore_hash_lambda162 x1 x2 s cd cs = let s12 = s
  in s12 `seq` (let s0 = leftSupply s12
                    s10 = rightSupply s12
  in s0 `seq` (s10 `seq` (let x3 = nd_C_nextID x2 s0 cd cs
  in let s9 = leftSupply s10
         s11 = rightSupply s10
         s3 = leftSupply s11
         s8 = rightSupply s11
  in s9 `seq` (s11 `seq` (s3 `seq` (s8 `seq` nd_OP_gt_plus (let s2 = leftSupply
                                                                  s3
                                                                s1 = rightSupply
                                                                  s3
  in s2 `seq` (s1 `seq` nd_C_putState (nd_C__case_199 x1 x3 x2 s1 cd cs) s2 cd
  cs)) (let s7 = leftSupply s8
            s6 = rightSupply s8
  in s7 `seq` (s6 `seq` nd_C_returnM (let s5 = leftSupply s6
                                          s4 = rightSupply s6
  in s5 `seq` (s4 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply
  (wrapDX (wrapDX id)
  (Curry_Prelude.d_OP_uscore_impl_hash_enumFromTo_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
  cd cs)) x3 s4 cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
  (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
  x3 x1 cd cs) (Curry_Prelude.C_Int (1)) cd cs) s5 cd cs)) s7 cd cs)) s9 cd
  cs))))))

d_C_isDetMode :: Cover -> ConstStore -> C_IOES C_State Curry_Prelude.C_Bool
d_C_isDetMode cd cs = d_OP_gt_plus_eq (d_C_getState cd cs)
  d_OP_isDetMode_dot_uscore_hash_lambda172 cd cs

nd_C_isDetMode :: IDSupply -> Cover -> ConstStore -> C_IOES C_State
  Curry_Prelude.C_Bool
nd_C_isDetMode s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getState s0 cd cs) (wrapNX id
  nd_OP_isDetMode_dot_uscore_hash_lambda172) s1 cd cs))

d_OP_isDetMode_dot_uscore_hash_lambda172 :: C_State -> Cover -> ConstStore
  -> C_IOES C_State Curry_Prelude.C_Bool
d_OP_isDetMode_dot_uscore_hash_lambda172 x1 cd cs = d_C_returnM (d_C_detMode x1
  cd cs) cd cs

nd_OP_isDetMode_dot_uscore_hash_lambda172 :: C_State -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State Curry_Prelude.C_Bool
nd_OP_isDetMode_dot_uscore_hash_lambda172 x1 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_C_returnM (nd_C_detMode x1 s0 cd cs) s1 cd cs))

d_C_setDetMode :: Curry_Prelude.C_Bool -> Cover -> ConstStore -> C_IOES C_State
  Curry_Prelude.OP_Unit
d_C_setDetMode x1 cd cs = d_C_updState
  (d_OP_setDetMode_dot_uscore_hash_lambda173 x1) cd cs

nd_C_setDetMode :: Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> C_IOES C_State Curry_Prelude.OP_Unit
nd_C_setDetMode x1 s cd cs = let s0 = s
  in s0 `seq` nd_C_updState (wrapNX id
  (nd_OP_setDetMode_dot_uscore_hash_lambda173 x1)) s0 cd cs

d_OP_setDetMode_dot_uscore_hash_lambda173 :: Curry_Prelude.C_Bool -> C_State
  -> Cover -> ConstStore -> C_State
d_OP_setDetMode_dot_uscore_hash_lambda173 x1 x2 cd cs = case x2 of
  C_State x3 x4 x5 x6 x7 x8 x9 x10 -> C_State x3 x4 x5 x6 x7 x8 x1 x10
  Choice_C_State d i l r -> narrow d i
    (d_OP_setDetMode_dot_uscore_hash_lambda173 x1 l cd cs)
    (d_OP_setDetMode_dot_uscore_hash_lambda173 x1 r cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z ->
    d_OP_setDetMode_dot_uscore_hash_lambda173 x1 z cd cs) xs
  Guard_C_State d c e -> guardCons d c
    (d_OP_setDetMode_dot_uscore_hash_lambda173 x1 e cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail
    "TransFunctions.setDetMode._#lambda173" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.setDetMode._#lambda173" (showCons
    x2))

nd_OP_setDetMode_dot_uscore_hash_lambda173 :: Curry_Prelude.C_Bool -> C_State
  -> IDSupply -> Cover -> ConstStore -> C_State
nd_OP_setDetMode_dot_uscore_hash_lambda173 x1 x2 s cd cs = case x2 of
  C_State x3 x4 x5 x6 x7 x8 x9 x10 -> C_State x3 x4 x5 x6 x7 x8 x1 x10
  Choice_C_State d i l r -> narrow d i
    (nd_OP_setDetMode_dot_uscore_hash_lambda173 x1 l s cd cs)
    (nd_OP_setDetMode_dot_uscore_hash_lambda173 x1 r s cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z ->
    nd_OP_setDetMode_dot_uscore_hash_lambda173 x1 z s cd cs) xs
  Guard_C_State d c e -> guardCons d c
    (nd_OP_setDetMode_dot_uscore_hash_lambda173 x1 e s cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail
    "TransFunctions.setDetMode._#lambda173" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.setDetMode._#lambda173" (showCons
    x2))

d_C_doInDetMode :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Bool
  -> C_IOES C_State t0 -> Cover -> ConstStore -> C_IOES C_State t0
d_C_doInDetMode x1 x2 cd cs = d_OP_gt_plus_eq (d_C_isDetMode cd cs)
  (d_OP_doInDetMode_dot_uscore_hash_lambda183 x1 x2) cd cs

nd_C_doInDetMode :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Bool
  -> C_IOES C_State t0 -> IDSupply -> Cover -> ConstStore -> C_IOES C_State t0
nd_C_doInDetMode x1 x2 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_isDetMode s0 cd cs) (wrapNX id
  (nd_OP_doInDetMode_dot_uscore_hash_lambda183 x1 x2)) s1 cd cs))

d_OP_doInDetMode_dot_uscore_hash_lambda183 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_Bool -> C_IOES C_State t0 -> Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> C_IOES C_State t0
d_OP_doInDetMode_dot_uscore_hash_lambda183 x1 x2 x3 cd cs = d_OP_gt_plus_eq
  (d_OP_gt_plus (d_C_setDetMode x1 cd cs) x2 cd cs)
  (d_OP_doInDetMode_dot_uscore_hash_lambda183_dot_uscore_hash_lambda184 x3) cd
  cs

nd_OP_doInDetMode_dot_uscore_hash_lambda183 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_Bool -> C_IOES C_State t0 -> Curry_Prelude.C_Bool
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State t0
nd_OP_doInDetMode_dot_uscore_hash_lambda183 x1 x2 x3 s cd cs = let s4 = s
  in s4 `seq` (let s3 = leftSupply s4
                   s2 = rightSupply s4
  in s3 `seq` (s2 `seq` nd_OP_gt_plus_eq (let s1 = leftSupply s2
                                              s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus (nd_C_setDetMode x1 s0 cd cs) x2 s1 cd
  cs)) (wrapNX id
  (nd_OP_doInDetMode_dot_uscore_hash_lambda183_dot_uscore_hash_lambda184 x3)) s3
  cd cs))

d_OP_doInDetMode_dot_uscore_hash_lambda183_dot_uscore_hash_lambda184 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_Bool -> t0 -> Cover -> ConstStore -> C_IOES C_State t0
d_OP_doInDetMode_dot_uscore_hash_lambda183_dot_uscore_hash_lambda184 x1 x2 cd cs =
  d_OP_gt_plus (d_C_setDetMode x1 cd cs) (d_C_returnM x2 cd cs) cd cs

nd_OP_doInDetMode_dot_uscore_hash_lambda183_dot_uscore_hash_lambda184 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.C_Bool -> t0 -> IDSupply -> Cover -> ConstStore -> C_IOES
  C_State t0
nd_OP_doInDetMode_dot_uscore_hash_lambda183_dot_uscore_hash_lambda184 x1 x2 s cd cs =
  let s3 = s
  in s3 `seq` (let s2 = leftSupply s3
                   s4 = rightSupply s3
                   s0 = leftSupply s4
                   s1 = rightSupply s4
  in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` nd_OP_gt_plus (nd_C_setDetMode x1 s0
  cd cs) (nd_C_returnM x2 s1 cd cs) s2 cd cs))))

d_C_isTraceFailure :: Cover -> ConstStore -> C_IOES C_State Curry_Prelude.C_Bool
d_C_isTraceFailure cd cs = d_OP_gt_plus_eq (d_C_getState cd cs)
  d_OP_isTraceFailure_dot_uscore_hash_lambda185 cd cs

nd_C_isTraceFailure :: IDSupply -> Cover -> ConstStore -> C_IOES C_State
  Curry_Prelude.C_Bool
nd_C_isTraceFailure s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getState s0 cd cs) (wrapNX id
  nd_OP_isTraceFailure_dot_uscore_hash_lambda185) s1 cd cs))

d_OP_isTraceFailure_dot_uscore_hash_lambda185 :: C_State -> Cover -> ConstStore
  -> C_IOES C_State Curry_Prelude.C_Bool
d_OP_isTraceFailure_dot_uscore_hash_lambda185 x1 cd cs = d_C_returnM
  (Curry_CompilerOpts.d_C_optTraceFailure (d_C_compOptions x1 cd cs) cd cs) cd
  cs

nd_OP_isTraceFailure_dot_uscore_hash_lambda185 :: C_State -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State Curry_Prelude.C_Bool
nd_OP_isTraceFailure_dot_uscore_hash_lambda185 x1 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_C_returnM (Curry_CompilerOpts.d_C_optTraceFailure
  (nd_C_compOptions x1 s0 cd cs) cd cs) s1 cd cs))

d_C_getCompOptions :: Cover -> ConstStore -> C_IOES C_State
  Curry_CompilerOpts.C_Options
d_C_getCompOptions cd cs = d_OP_gt_plus_eq (d_C_getState cd cs)
  d_OP_getCompOptions_dot_uscore_hash_lambda186 cd cs

nd_C_getCompOptions :: IDSupply -> Cover -> ConstStore -> C_IOES C_State
  Curry_CompilerOpts.C_Options
nd_C_getCompOptions s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getState s0 cd cs) (wrapNX id
  nd_OP_getCompOptions_dot_uscore_hash_lambda186) s1 cd cs))

d_OP_getCompOptions_dot_uscore_hash_lambda186 :: C_State -> Cover -> ConstStore
  -> C_IOES C_State Curry_CompilerOpts.C_Options
d_OP_getCompOptions_dot_uscore_hash_lambda186 x1 cd cs = d_C_returnM
  (d_C_compOptions x1 cd cs) cd cs

nd_OP_getCompOptions_dot_uscore_hash_lambda186 :: C_State -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State Curry_CompilerOpts.C_Options
nd_OP_getCompOptions_dot_uscore_hash_lambda186 x1 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_C_returnM (nd_C_compOptions x1 s0 cd cs) s1 cd cs))

d_C_getCompOption :: forall t0 . (Curry_Prelude.Curry
  t0) => (Curry_CompilerOpts.C_Options -> Cover -> ConstStore -> t0) -> Cover
  -> ConstStore -> C_IOES C_State t0
d_C_getCompOption x1 cd cs = d_OP_gt_plus_eq (d_C_getCompOptions cd cs)
  (Curry_Prelude.d_OP_dot d_C_returnM x1 cd cs) cd cs

nd_C_getCompOption :: forall t0 . (Curry_Prelude.Curry t0) => Func
  Curry_CompilerOpts.C_Options t0 -> IDSupply -> Cover -> ConstStore -> C_IOES
  C_State t0
nd_C_getCompOption x1 s cd cs = let s3 = s
  in s3 `seq` (let s2 = leftSupply s3
                   s4 = rightSupply s3
                   s0 = leftSupply s4
                   s1 = rightSupply s4
  in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` nd_OP_gt_plus_eq
  (nd_C_getCompOptions s0 cd cs) (Curry_Prelude.nd_OP_dot (wrapNX id
  nd_C_returnM) x1 s1 cd cs) s2 cd cs))))

d_C_strictSupply :: Cover -> ConstStore -> C_IOES C_State Curry_Prelude.C_Bool
d_C_strictSupply cd cs = Curry_Prelude.d_OP_dollar d_C_getCompOption
  d_OP_strictSupply_dot_uscore_hash_lambda187 cd cs

nd_C_strictSupply :: IDSupply -> Cover -> ConstStore -> C_IOES C_State
  Curry_Prelude.C_Bool
nd_C_strictSupply s cd cs = let s0 = s
  in s0 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id nd_C_getCompOption) (wrapDX
  id d_OP_strictSupply_dot_uscore_hash_lambda187) s0 cd cs

d_OP_strictSupply_dot_uscore_hash_lambda187 :: Curry_CompilerOpts.C_Options
  -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_OP_strictSupply_dot_uscore_hash_lambda187 x1 cd cs = Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply
  (Curry_CompilerOpts.d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
  cd cs) (Curry_CompilerOpts.d_C_optOptimization x1 cd cs) cd cs)
  Curry_CompilerOpts.C_OptimStrictSupply cd cs

d_C_trProg :: FlatCurry.Curry_Types.C_Prog -> Cover -> ConstStore -> C_IOES
  C_State (Curry_Prelude.OP_Tuple2 Curry_AbstractHaskell.C_Prog
  (Curry_Prelude.OP_Tuple5 (Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
  (Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_NDClass) (Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_TypeHOClass)
  (Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_FuncHOClass)))
d_C_trProg x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_Prog x2 x3 x4 x5 x6 -> d_OP_gt_plus_eq (d_C_getState
    cd cs) (d_OP_trProg_dot_uscore_hash_lambda188 x1 x5 x4 x2 x3) cd cs
  FlatCurry.Curry_Types.Choice_C_Prog d i l r -> narrow d i (d_C_trProg l cd cs)
    (d_C_trProg r cd cs)
  FlatCurry.Curry_Types.Choices_C_Prog d i xs -> narrows cs d i (\z ->
    d_C_trProg z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Prog d c e -> guardCons d c (d_C_trProg e cd $!
    addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Prog d info -> failCons d (traceFail
    "TransFunctions.trProg" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.trProg" (showCons x1))

nd_C_trProg :: FlatCurry.Curry_Types.C_Prog -> IDSupply -> Cover -> ConstStore
  -> C_IOES C_State (Curry_Prelude.OP_Tuple2 Curry_AbstractHaskell.C_Prog
  (Curry_Prelude.OP_Tuple5 (Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
  (Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_NDClass) (Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_TypeHOClass)
  (Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_FuncHOClass)))
nd_C_trProg x1 s cd cs = case x1 of
  FlatCurry.Curry_Types.C_Prog x2 x3 x4 x5 x6 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getState s0 cd cs) (wrapNX id
    (nd_OP_trProg_dot_uscore_hash_lambda188 x1 x5 x4 x2 x3)) s1 cd cs))
  FlatCurry.Curry_Types.Choice_C_Prog d i l r -> narrow d i (nd_C_trProg l s cd
    cs) (nd_C_trProg r s cd cs)
  FlatCurry.Curry_Types.Choices_C_Prog d i xs -> narrows cs d i (\z ->
    nd_C_trProg z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Prog d c e -> guardCons d c (nd_C_trProg e s
    cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Prog d info -> failCons d (traceFail
    "TransFunctions.trProg" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.trProg" (showCons x1))

d_OP_trProg_dot_uscore_hash_lambda188 :: FlatCurry.Curry_Types.C_Prog
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_FuncDecl
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_TypeDecl
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> C_State -> Cover -> ConstStore
  -> C_IOES C_State (Curry_Prelude.OP_Tuple2 Curry_AbstractHaskell.C_Prog
  (Curry_Prelude.OP_Tuple5 (Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)))
  (Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_NDClass) (Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_TypeHOClass)
  (Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_FuncHOClass)))
d_OP_trProg_dot_uscore_hash_lambda188 x1 x2 x3 x4 x5 x6 cd cs =
  let x7 = Curry_Analysis.d_C_analyseND x1 (d_C_ndResult x6 cd cs) cd cs
      x8 = Curry_Analysis.d_C_analyseHOType x1 (d_C_hoResultType x6 cd cs) cd cs
      x9 = Curry_Analysis.d_C_analyseHOCons x1 cd cs
      x10 = Curry_Analysis.d_C_analyseHOFunc x1 (Curry_FiniteMap.d_C_plusFM
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
        cd cs) cd cs)
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
        cd cs) cd cs) cd cs) (d_C_hoResultType x6 cd cs) x8 cd cs) cd cs
      x11 = Curry_Analysis.d_C_getTypeMap x3 cd cs
      x12 = Curry_Analysis.d_C_analyzeVisibility x1 cd cs
      x13 = Curry_FiniteMap.d_C_delListFromFM
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
        cd cs) cd cs)
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
        cd cs) cd cs) cd cs) x7 (Curry_Analysis.d_C_getPrivateFunc x12 cd cs) cd
        cs
      x14 = Curry_FiniteMap.d_C_delListFromFM
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
        cd cs) cd cs)
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
        cd cs) cd cs) cd cs) x8 (Curry_Analysis.d_C_getPrivateType x12 cd cs) cd
        cs
      x15 = Curry_FiniteMap.d_C_delListFromFM
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
        cd cs) cd cs)
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
        cd cs) cd cs) cd cs) x9 (Curry_Analysis.d_C_getPrivateCons x12 cd cs) cd
        cs
      x16 = Curry_FiniteMap.d_C_delListFromFM
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
        cd cs) cd cs)
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
        cd cs) cd cs) cd cs) x10 (Curry_Analysis.d_C_getPrivateFunc x12 cd cs)
        cd cs
      x17 = Curry_FiniteMap.d_C_delListFromFM
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
        cd cs) cd cs)
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
        (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
        cd cs) cd cs) cd cs) x11 (Curry_Analysis.d_C_getPrivateCons x12 cd cs)
        cd cs
      x18 = Curry_Prelude.OP_Tuple5 x17 x13 x14 x15 x16
  in d_OP_gt_plus_eq (d_OP_gt_plus (d_OP_gt_plus (d_OP_gt_plus (d_OP_gt_plus
  (d_OP_gt_plus (d_C_addNDAnalysis x7 cd cs) (d_C_addHOTypeAnalysis x8 cd cs) cd
  cs) (d_C_addHOConsAnalysis x9 cd cs) cd cs) (d_C_addHOFuncAnalysis x10 cd cs)
  cd cs) (d_C_addTypeMap x11 cd cs) cd cs) (d_C_mapM d_C_trFunc x2 cd cs) cd cs)
  (d_OP_trProg_dot_uscore_hash_lambda188_dot_uscore_hash_lambda189 x4 x5 x18) cd
  cs

nd_OP_trProg_dot_uscore_hash_lambda188 :: FlatCurry.Curry_Types.C_Prog
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_FuncDecl
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_TypeDecl
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> C_State -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  Curry_AbstractHaskell.C_Prog (Curry_Prelude.OP_Tuple5 (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))) (Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_NDClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_FuncHOClass)))
nd_OP_trProg_dot_uscore_hash_lambda188 x1 x2 x3 x4 x5 x6 s cd cs = let s101 = s
  in s101 `seq` (let s102 = leftSupply s101
                     s106 = rightSupply s101
                     s103 = leftSupply s102
                     s104 = rightSupply s102
                     s2 = leftSupply s103
                     s5 = rightSupply s103
                     s6 = leftSupply s104
                     s105 = rightSupply s104
                     s21 = leftSupply s105
                     s22 = rightSupply s105
                     s107 = leftSupply s106
                     s109 = rightSupply s106
                     s33 = leftSupply s107
                     s108 = rightSupply s107
                     s44 = leftSupply s108
                     s55 = rightSupply s108
                     s66 = leftSupply s109
                     s110 = rightSupply s109
                     s77 = leftSupply s110
                     s100 = rightSupply s110
  in s102 `seq` (s106 `seq` (s103 `seq` (s104 `seq` (s2 `seq` (s5 `seq`
  (s6 `seq` (s105 `seq` (s21 `seq` (s22 `seq` (s107 `seq` (s109 `seq` (s33 `seq`
  (s108 `seq` (s44 `seq` (s55 `seq` (s66 `seq` (s110 `seq` (s77 `seq`
  (s100 `seq` (let x7 = let s1 = leftSupply s2
                            s0 = rightSupply s2
                     in s1 `seq` (s0 `seq` Curry_Analysis.nd_C_analyseND x1
                     (nd_C_ndResult x6 s0 cd cs) s1 cd cs)
                   x8 = let s4 = leftSupply s5
                            s3 = rightSupply s5
                     in s4 `seq` (s3 `seq` Curry_Analysis.nd_C_analyseHOType x1
                     (nd_C_hoResultType x6 s3 cd cs) s4 cd cs)
                   x9 = Curry_Analysis.nd_C_analyseHOCons x1 s6 cd cs
                   x10 = let s20 = leftSupply s21
                             s18 = rightSupply s21
                     in s20 `seq` (s18 `seq` Curry_Analysis.nd_C_analyseHOFunc
                     x1 (let s17 = leftSupply s18
                             s19 = rightSupply s18
                             s14 = leftSupply s19
                             s16 = rightSupply s19
                     in s17 `seq` (s19 `seq` (s14 `seq` (s16 `seq`
                     Curry_FiniteMap.nd_C_plusFM (let s13 = leftSupply s14
                                                      s15 = rightSupply s14
                                                      s9 = leftSupply s15
                                                      s12 = rightSupply s15
                     in s13 `seq` (s15 `seq` (s9 `seq` (s12 `seq`
                     Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                     (let s8 = leftSupply s9
                          s7 = rightSupply s9
                     in s8 `seq` (s7 `seq`
                     Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                     (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                     s7 cd cs) s8 cd cs)) (let s11 = leftSupply s12
                                               s10 = rightSupply s12
                     in s11 `seq` (s10 `seq`
                     Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                     (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                     s10 cd cs) s11 cd cs)) s13 cd cs)))) (nd_C_hoResultType x6
                     s16 cd cs) x8 s17 cd cs)))) s20 cd cs)
                   x11 = Curry_Analysis.nd_C_getTypeMap x3 s22 cd cs
                   x12 = Curry_Analysis.d_C_analyzeVisibility x1 cd cs
                   x13 = let s32 = leftSupply s33
                             s30 = rightSupply s33
                     in s32 `seq` (s30 `seq` Curry_FiniteMap.nd_C_delListFromFM
                     (let s29 = leftSupply s30
                          s31 = rightSupply s30
                          s25 = leftSupply s31
                          s28 = rightSupply s31
                     in s29 `seq` (s31 `seq` (s25 `seq` (s28 `seq`
                     Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                     (let s24 = leftSupply s25
                          s23 = rightSupply s25
                     in s24 `seq` (s23 `seq`
                     Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                     (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                     s23 cd cs) s24 cd cs)) (let s27 = leftSupply s28
                                                 s26 = rightSupply s28
                     in s27 `seq` (s26 `seq`
                     Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                     (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                     s26 cd cs) s27 cd cs)) s29 cd cs)))) x7
                     (Curry_Analysis.d_C_getPrivateFunc x12 cd cs) s32 cd cs)
                   x14 = let s43 = leftSupply s44
                             s41 = rightSupply s44
                     in s43 `seq` (s41 `seq` Curry_FiniteMap.nd_C_delListFromFM
                     (let s40 = leftSupply s41
                          s42 = rightSupply s41
                          s36 = leftSupply s42
                          s39 = rightSupply s42
                     in s40 `seq` (s42 `seq` (s36 `seq` (s39 `seq`
                     Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                     (let s35 = leftSupply s36
                          s34 = rightSupply s36
                     in s35 `seq` (s34 `seq`
                     Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                     (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                     s34 cd cs) s35 cd cs)) (let s38 = leftSupply s39
                                                 s37 = rightSupply s39
                     in s38 `seq` (s37 `seq`
                     Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                     (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                     s37 cd cs) s38 cd cs)) s40 cd cs)))) x8
                     (Curry_Analysis.d_C_getPrivateType x12 cd cs) s43 cd cs)
                   x15 = let s54 = leftSupply s55
                             s52 = rightSupply s55
                     in s54 `seq` (s52 `seq` Curry_FiniteMap.nd_C_delListFromFM
                     (let s51 = leftSupply s52
                          s53 = rightSupply s52
                          s47 = leftSupply s53
                          s50 = rightSupply s53
                     in s51 `seq` (s53 `seq` (s47 `seq` (s50 `seq`
                     Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                     (let s46 = leftSupply s47
                          s45 = rightSupply s47
                     in s46 `seq` (s45 `seq`
                     Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                     (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                     s45 cd cs) s46 cd cs)) (let s49 = leftSupply s50
                                                 s48 = rightSupply s50
                     in s49 `seq` (s48 `seq`
                     Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                     (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                     s48 cd cs) s49 cd cs)) s51 cd cs)))) x9
                     (Curry_Analysis.d_C_getPrivateCons x12 cd cs) s54 cd cs)
                   x16 = let s65 = leftSupply s66
                             s63 = rightSupply s66
                     in s65 `seq` (s63 `seq` Curry_FiniteMap.nd_C_delListFromFM
                     (let s62 = leftSupply s63
                          s64 = rightSupply s63
                          s58 = leftSupply s64
                          s61 = rightSupply s64
                     in s62 `seq` (s64 `seq` (s58 `seq` (s61 `seq`
                     Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                     (let s57 = leftSupply s58
                          s56 = rightSupply s58
                     in s57 `seq` (s56 `seq`
                     Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                     (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                     s56 cd cs) s57 cd cs)) (let s60 = leftSupply s61
                                                 s59 = rightSupply s61
                     in s60 `seq` (s59 `seq`
                     Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                     (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                     s59 cd cs) s60 cd cs)) s62 cd cs)))) x10
                     (Curry_Analysis.d_C_getPrivateFunc x12 cd cs) s65 cd cs)
                   x17 = let s76 = leftSupply s77
                             s74 = rightSupply s77
                     in s76 `seq` (s74 `seq` Curry_FiniteMap.nd_C_delListFromFM
                     (let s73 = leftSupply s74
                          s75 = rightSupply s74
                          s69 = leftSupply s75
                          s72 = rightSupply s75
                     in s73 `seq` (s75 `seq` (s69 `seq` (s72 `seq`
                     Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                     (let s68 = leftSupply s69
                          s67 = rightSupply s69
                     in s68 `seq` (s67 `seq`
                     Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                     (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                     s67 cd cs) s68 cd cs)) (let s71 = leftSupply s72
                                                 s70 = rightSupply s72
                     in s71 `seq` (s70 `seq`
                     Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                     (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                     s70 cd cs) s71 cd cs)) s73 cd cs)))) x11
                     (Curry_Analysis.d_C_getPrivateCons x12 cd cs) s76 cd cs)
                   x18 = Curry_Prelude.OP_Tuple5 x17 x13 x14 x15 x16
  in let s99 = leftSupply s100
         s97 = rightSupply s100
  in s99 `seq` (s97 `seq` nd_OP_gt_plus_eq (let s96 = leftSupply s97
                                                s98 = rightSupply s97
                                                s93 = leftSupply s98
                                                s95 = rightSupply s98
  in s96 `seq` (s98 `seq` (s93 `seq` (s95 `seq` nd_OP_gt_plus
  (let s92 = leftSupply s93
       s94 = rightSupply s93
       s89 = leftSupply s94
       s91 = rightSupply s94
  in s92 `seq` (s94 `seq` (s89 `seq` (s91 `seq` nd_OP_gt_plus
  (let s88 = leftSupply s89
       s90 = rightSupply s89
       s85 = leftSupply s90
       s87 = rightSupply s90
  in s88 `seq` (s90 `seq` (s85 `seq` (s87 `seq` nd_OP_gt_plus
  (let s84 = leftSupply s85
       s86 = rightSupply s85
       s81 = leftSupply s86
       s83 = rightSupply s86
  in s84 `seq` (s86 `seq` (s81 `seq` (s83 `seq` nd_OP_gt_plus
  (let s80 = leftSupply s81
       s82 = rightSupply s81
       s78 = leftSupply s82
       s79 = rightSupply s82
  in s80 `seq` (s82 `seq` (s78 `seq` (s79 `seq` nd_OP_gt_plus
  (nd_C_addNDAnalysis x7 s78 cd cs) (nd_C_addHOTypeAnalysis x8 s79 cd cs) s80 cd
  cs)))) (nd_C_addHOConsAnalysis x9 s83 cd cs) s84 cd cs))))
  (nd_C_addHOFuncAnalysis x10 s87 cd cs) s88 cd cs)))) (nd_C_addTypeMap x11 s91
  cd cs) s92 cd cs)))) (nd_C_mapM (wrapNX id nd_C_trFunc) x2 s95 cd cs) s96 cd
  cs)))) (wrapNX id
  (nd_OP_trProg_dot_uscore_hash_lambda188_dot_uscore_hash_lambda189 x4 x5 x18))
  s99 cd cs))))))))))))))))))))))

d_OP_trProg_dot_uscore_hash_lambda188_dot_uscore_hash_lambda189 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple5 (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))) (Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_NDClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_FuncHOClass) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_FuncDecl) -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  Curry_AbstractHaskell.C_Prog (Curry_Prelude.OP_Tuple5 (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))) (Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_NDClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_FuncHOClass)))
d_OP_trProg_dot_uscore_hash_lambda188_dot_uscore_hash_lambda189 x1 x2 x3 x4 cd cs =
  Curry_Prelude.d_OP_dollar d_C_returnM (Curry_Prelude.OP_Tuple2
  (Curry_AbstractHaskell.C_Prog x1 x2 Curry_Prelude.OP_List
  (Curry_Prelude.d_C_concat x4 cd cs) Curry_Prelude.OP_List) x3) cd cs

nd_OP_trProg_dot_uscore_hash_lambda188_dot_uscore_hash_lambda189 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple5 (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))) (Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_NDClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_FuncHOClass) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_FuncDecl) -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  Curry_AbstractHaskell.C_Prog (Curry_Prelude.OP_Tuple5 (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))) (Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_NDClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_TypeHOClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass) (Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_FuncHOClass)))
nd_OP_trProg_dot_uscore_hash_lambda188_dot_uscore_hash_lambda189 x1 x2 x3 x4 s cd cs =
  let s0 = s
  in s0 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id nd_C_returnM)
  (Curry_Prelude.OP_Tuple2 (Curry_AbstractHaskell.C_Prog x1 x2
  Curry_Prelude.OP_List (Curry_Prelude.d_C_concat x4 cd cs)
  Curry_Prelude.OP_List) x3) s0 cd cs

d_C_trFunc :: FlatCurry.Curry_Types.C_FuncDecl -> Cover -> ConstStore -> C_IOES
  C_State (Curry_Prelude.OP_List Curry_AbstractHaskell.C_FuncDecl)
d_C_trFunc x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_Func x2 x3 x4 x5 x6 -> d_OP_gt_plus_eq (d_OP_gt_plus
    (d_C_checkGlobal x1 cd cs) (d_C_getCompOptions cd cs) cd cs)
    (d_OP_trFunc_dot_uscore_hash_lambda190 x1 x2) cd cs
  FlatCurry.Curry_Types.Choice_C_FuncDecl d i l r -> narrow d i (d_C_trFunc l cd
    cs) (d_C_trFunc r cd cs)
  FlatCurry.Curry_Types.Choices_C_FuncDecl d i xs -> narrows cs d i (\z ->
    d_C_trFunc z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_FuncDecl d c e -> guardCons d c (d_C_trFunc e
    cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_FuncDecl d info -> failCons d (traceFail
    "TransFunctions.trFunc" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.trFunc" (showCons x1))

nd_C_trFunc :: FlatCurry.Curry_Types.C_FuncDecl -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_FuncDecl)
nd_C_trFunc x1 s cd cs = case x1 of
  FlatCurry.Curry_Types.C_Func x2 x3 x4 x5 x6 -> let s6 = s
    in s6 `seq` (let s5 = leftSupply s6
                     s3 = rightSupply s6
    in s5 `seq` (s3 `seq` nd_OP_gt_plus_eq (let s2 = leftSupply s3
                                                s4 = rightSupply s3
                                                s0 = leftSupply s4
                                                s1 = rightSupply s4
    in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` nd_OP_gt_plus (nd_C_checkGlobal x1
    s0 cd cs) (nd_C_getCompOptions s1 cd cs) s2 cd cs)))) (wrapNX id
    (nd_OP_trFunc_dot_uscore_hash_lambda190 x1 x2)) s5 cd cs))
  FlatCurry.Curry_Types.Choice_C_FuncDecl d i l r -> narrow d i (nd_C_trFunc l s
    cd cs) (nd_C_trFunc r s cd cs)
  FlatCurry.Curry_Types.Choices_C_FuncDecl d i xs -> narrows cs d i (\z ->
    nd_C_trFunc z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_FuncDecl d c e -> guardCons d c (nd_C_trFunc e s
    cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_FuncDecl d info -> failCons d (traceFail
    "TransFunctions.trFunc" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.trFunc" (showCons x1))

d_OP_trFunc_dot_uscore_hash_lambda190 :: FlatCurry.Curry_Types.C_FuncDecl
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_CompilerOpts.C_Options
  -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_FuncDecl)
d_OP_trFunc_dot_uscore_hash_lambda190 x1 x2 x3 cd cs = d_C__case_198 x3 x2 x1
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_CompilerOpts.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
  cd cs) (Curry_CompilerOpts.d_C_optOptimization x3 cd cs) cd cs)
  Curry_CompilerOpts.C_OptimNone cd cs) cd cs

nd_OP_trFunc_dot_uscore_hash_lambda190 :: FlatCurry.Curry_Types.C_FuncDecl
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_CompilerOpts.C_Options
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_FuncDecl)
nd_OP_trFunc_dot_uscore_hash_lambda190 x1 x2 x3 s cd cs = let s4 = s
  in s4 `seq` (let s3 = leftSupply s4
                   s2 = rightSupply s4
  in s3 `seq` (s2 `seq` nd_C__case_198 x3 x2 x1 (let s1 = leftSupply s2
                                                     s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply
  (wrapDX (wrapDX id)
  (Curry_CompilerOpts.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
  cd cs)) (Curry_CompilerOpts.d_C_optOptimization x3 cd cs) s0 cd cs)
  Curry_CompilerOpts.C_OptimNone s1 cd cs)) s3 cd cs))

d_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda192 :: Curry_AbstractHaskell.C_FuncDecl
  -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_FuncDecl)
d_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda192 x1 cd cs =
  d_C_returnM (Curry_Prelude.OP_Cons x1 Curry_Prelude.OP_List) cd cs

nd_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda192 :: Curry_AbstractHaskell.C_FuncDecl
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_FuncDecl)
nd_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda192 x1 s cd cs =
  let s0 = s
  in s0 `seq` nd_C_returnM (Curry_Prelude.OP_Cons x1 Curry_Prelude.OP_List) s0
  cd cs

d_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193 :: Curry_CompilerOpts.C_Options
  -> FlatCurry.Curry_Types.C_FuncDecl -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Classification.C_NDClass -> Cover -> ConstStore
  -> C_IOES C_State (Curry_Prelude.OP_List Curry_AbstractHaskell.C_FuncDecl)
d_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193 x1 x2 x3 x4 cd cs =
  d_OP_gt_plus_eq (d_C_getFuncHOClass x3 cd cs)
  (d_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194
  x4 x1 x2 x3) cd cs

nd_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193 :: Curry_CompilerOpts.C_Options
  -> FlatCurry.Curry_Types.C_FuncDecl -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Classification.C_NDClass -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_FuncDecl)
nd_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193 x1 x2 x3 x4 s cd cs =
  let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getFuncHOClass x3 s0 cd cs)
  (wrapNX id
  (nd_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194
  x4 x1 x2 x3)) s1 cd cs))

d_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194 :: Curry_Classification.C_NDClass
  -> Curry_CompilerOpts.C_Options -> FlatCurry.Curry_Types.C_FuncDecl
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Classification.C_FuncHOClass -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_FuncDecl)
d_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194 x1 x2 x3 x4 x5 cd cs =
  d_OP_gt_plus (d_C_liftIO (Curry_Message.d_C_showAnalysis x2
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.d_C_snd x4 cd cs)
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString " is ")
  (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_lparen_comma_rparen
  (Curry_Classification.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_Classification_dot_NDClass
  cd cs)
  (Curry_Classification.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_Classification_dot_FuncHOClass
  cd cs) cd cs) (Curry_Prelude.OP_Tuple2 x1 x5) cd cs) cd cs) cd cs) cd cs) cd
  cs) (d_C__case_197 x5 x3 x1 cd cs) cd cs

nd_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194 :: Curry_Classification.C_NDClass
  -> Curry_CompilerOpts.C_Options -> FlatCurry.Curry_Types.C_FuncDecl
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Classification.C_FuncHOClass -> IDSupply -> Cover -> ConstStore
  -> C_IOES C_State (Curry_Prelude.OP_List Curry_AbstractHaskell.C_FuncDecl)
nd_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194 x1 x2 x3 x4 x5 s cd cs =
  let s11 = s
  in s11 `seq` (let s10 = leftSupply s11
                    s12 = rightSupply s11
                    s8 = leftSupply s12
                    s9 = rightSupply s12
  in s10 `seq` (s12 `seq` (s8 `seq` (s9 `seq` nd_OP_gt_plus (let s7 = leftSupply
                                                                   s8
                                                                 s6 = rightSupply
                                                                   s8
  in s7 `seq` (s6 `seq` nd_C_liftIO (Curry_Message.d_C_showAnalysis x2
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.d_C_snd x4 cd cs)
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString " is ")
  (let s5 = leftSupply s6
       s3 = rightSupply s6
  in s5 `seq` (s3 `seq` Curry_Prelude.nd_C_apply (let s2 = leftSupply s3
                                                      s4 = rightSupply s3
                                                      s0 = leftSupply s4
                                                      s1 = rightSupply s4
  in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq`
  Curry_Prelude.nd_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_lparen_comma_rparen
  (Curry_Classification.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_Classification_dot_NDClass
  s0 cd cs)
  (Curry_Classification.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_Classification_dot_FuncHOClass
  s1 cd cs) s2 cd cs)))) (Curry_Prelude.OP_Tuple2 x1 x5) s5 cd cs)) cd cs) cd
  cs) cd cs) s7 cd cs)) (nd_C__case_197 x5 x3 x1 s9 cd cs) s10 cd cs))))

d_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda196 :: Curry_AbstractHaskell.C_FuncDecl
  -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_FuncDecl)
d_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda196 x1 cd cs =
  d_C_returnM (Curry_Prelude.OP_Cons x1 Curry_Prelude.OP_List) cd cs

nd_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda196 :: Curry_AbstractHaskell.C_FuncDecl
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_FuncDecl)
nd_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda196 x1 s cd cs =
  let s0 = s
  in s0 `seq` nd_C_returnM (Curry_Prelude.OP_Cons x1 Curry_Prelude.OP_List) s0
  cd cs

d_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda198 :: FlatCurry.Curry_Types.C_FuncDecl
  -> Curry_AbstractHaskell.C_FuncDecl -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_FuncDecl)
d_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda198 x1 x2 cd cs =
  d_OP_gt_plus_eq (d_C_trNDFunc x1 cd cs)
  (d_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda198_dot_uscore_hash_lambda199
  x2) cd cs

nd_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda198 :: FlatCurry.Curry_Types.C_FuncDecl
  -> Curry_AbstractHaskell.C_FuncDecl -> IDSupply -> Cover -> ConstStore
  -> C_IOES C_State (Curry_Prelude.OP_List Curry_AbstractHaskell.C_FuncDecl)
nd_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda198 x1 x2 s cd cs =
  let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_trNDFunc x1 s0 cd cs) (wrapNX id
  (nd_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda198_dot_uscore_hash_lambda199
  x2)) s1 cd cs))

d_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda198_dot_uscore_hash_lambda199 :: Curry_AbstractHaskell.C_FuncDecl
  -> Curry_AbstractHaskell.C_FuncDecl -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_FuncDecl)
d_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda198_dot_uscore_hash_lambda199 x1 x2 cd cs =
  d_C_returnM (Curry_Prelude.OP_Cons x1 (Curry_Prelude.OP_Cons x2
  Curry_Prelude.OP_List)) cd cs

nd_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda198_dot_uscore_hash_lambda199 :: Curry_AbstractHaskell.C_FuncDecl
  -> Curry_AbstractHaskell.C_FuncDecl -> IDSupply -> Cover -> ConstStore
  -> C_IOES C_State (Curry_Prelude.OP_List Curry_AbstractHaskell.C_FuncDecl)
nd_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda198_dot_uscore_hash_lambda199 x1 x2 s cd cs =
  let s0 = s
  in s0 `seq` nd_C_returnM (Curry_Prelude.OP_Cons x1 (Curry_Prelude.OP_Cons x2
  Curry_Prelude.OP_List)) s0 cd cs

d_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda200 :: Curry_AbstractHaskell.C_FuncDecl
  -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_FuncDecl)
d_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda200 x1 cd cs =
  d_C_returnM (Curry_Prelude.OP_Cons x1 Curry_Prelude.OP_List) cd cs

nd_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda200 :: Curry_AbstractHaskell.C_FuncDecl
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_FuncDecl)
nd_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda200 x1 s cd cs =
  let s0 = s
  in s0 `seq` nd_C_returnM (Curry_Prelude.OP_Cons x1 Curry_Prelude.OP_List) s0
  cd cs

d_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda201 :: Curry_AbstractHaskell.C_FuncDecl
  -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_FuncDecl)
d_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda201 x1 cd cs =
  d_C_returnM (Curry_Prelude.OP_Cons x1 Curry_Prelude.OP_List) cd cs

nd_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda201 :: Curry_AbstractHaskell.C_FuncDecl
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_FuncDecl)
nd_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda201 x1 s cd cs =
  let s0 = s
  in s0 `seq` nd_C_returnM (Curry_Prelude.OP_Cons x1 Curry_Prelude.OP_List) s0
  cd cs

d_C_checkGlobal :: FlatCurry.Curry_Types.C_FuncDecl -> Cover -> ConstStore
  -> C_IOES C_State Curry_Prelude.OP_Unit
d_C_checkGlobal x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_Func x2 x3 x4 x5 x6 -> d_C__case_193 x1 x2
    (d_C_isGlobalDecl x1 cd cs) cd cs
  FlatCurry.Curry_Types.Choice_C_FuncDecl d i l r -> narrow d i (d_C_checkGlobal
    l cd cs) (d_C_checkGlobal r cd cs)
  FlatCurry.Curry_Types.Choices_C_FuncDecl d i xs -> narrows cs d i (\z ->
    d_C_checkGlobal z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_FuncDecl d c e -> guardCons d c (d_C_checkGlobal
    e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_FuncDecl d info -> failCons d (traceFail
    "TransFunctions.checkGlobal" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.checkGlobal" (showCons x1))

nd_C_checkGlobal :: FlatCurry.Curry_Types.C_FuncDecl -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State Curry_Prelude.OP_Unit
nd_C_checkGlobal x1 s cd cs = case x1 of
  FlatCurry.Curry_Types.C_Func x2 x3 x4 x5 x6 -> let s0 = s
    in s0 `seq` nd_C__case_193 x1 x2 (d_C_isGlobalDecl x1 cd cs) s0 cd cs
  FlatCurry.Curry_Types.Choice_C_FuncDecl d i l r -> narrow d i
    (nd_C_checkGlobal l s cd cs) (nd_C_checkGlobal r s cd cs)
  FlatCurry.Curry_Types.Choices_C_FuncDecl d i xs -> narrows cs d i (\z ->
    nd_C_checkGlobal z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_FuncDecl d c e -> guardCons d c
    (nd_C_checkGlobal e s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_FuncDecl d info -> failCons d (traceFail
    "TransFunctions.checkGlobal" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.checkGlobal" (showCons x1))

d_OP_checkGlobal_dot_uscore_hash_lambda202 :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Classification.C_NDClass -> Cover -> ConstStore
  -> C_IOES C_State Curry_Prelude.OP_Unit
d_OP_checkGlobal_dot_uscore_hash_lambda202 x1 x2 cd cs = d_OP_gt_plus_eq
  (d_C_getFuncHOClass x1 cd cs)
  (d_OP_checkGlobal_dot_uscore_hash_lambda202_dot_uscore_hash_lambda203 x2 x1)
  cd cs

nd_OP_checkGlobal_dot_uscore_hash_lambda202 :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Classification.C_NDClass -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State Curry_Prelude.OP_Unit
nd_OP_checkGlobal_dot_uscore_hash_lambda202 x1 x2 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getFuncHOClass x1 s0 cd cs)
  (wrapNX id
  (nd_OP_checkGlobal_dot_uscore_hash_lambda202_dot_uscore_hash_lambda203 x2 x1))
  s1 cd cs))

d_OP_checkGlobal_dot_uscore_hash_lambda202_dot_uscore_hash_lambda203 :: Curry_Classification.C_NDClass
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Classification.C_FuncHOClass -> Cover -> ConstStore -> C_IOES C_State
  Curry_Prelude.OP_Unit
d_OP_checkGlobal_dot_uscore_hash_lambda202_dot_uscore_hash_lambda203 x1 x2 x3 cd cs =
  d_C__case_191 x3 x1 x2 (Curry_Prelude.OP_Tuple2 x1 x3) cd cs

nd_OP_checkGlobal_dot_uscore_hash_lambda202_dot_uscore_hash_lambda203 :: Curry_Classification.C_NDClass
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Classification.C_FuncHOClass -> IDSupply -> Cover -> ConstStore
  -> C_IOES C_State Curry_Prelude.OP_Unit
nd_OP_checkGlobal_dot_uscore_hash_lambda202_dot_uscore_hash_lambda203 x1 x2 x3 s cd cs =
  let s0 = s
  in s0 `seq` nd_C__case_191 x3 x1 x2 (Curry_Prelude.OP_Tuple2 x1 x3) s0 cd cs

d_C_isGlobalDecl :: FlatCurry.Curry_Types.C_FuncDecl -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isGlobalDecl x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_Func x2 x3 x4 x5 x6 -> d_C__case_188 x3 x6 cd cs
  FlatCurry.Curry_Types.Choice_C_FuncDecl d i l r -> narrow d i
    (d_C_isGlobalDecl l cd cs) (d_C_isGlobalDecl r cd cs)
  FlatCurry.Curry_Types.Choices_C_FuncDecl d i xs -> narrows cs d i (\z ->
    d_C_isGlobalDecl z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_FuncDecl d c e -> guardCons d c
    (d_C_isGlobalDecl e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_FuncDecl d info -> failCons d (traceFail
    "TransFunctions.isGlobalDecl" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.isGlobalDecl" (showCons x1))

d_C_isGlobalCall :: FlatCurry.Curry_Types.C_Expr -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isGlobalCall x1 cd cs = let x2 = Curry_Prelude.C_False
  in d_C__case_186 x2 x1 cd cs

d_C_globalGlobal :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_globalGlobal cd cs = Curry_Prelude.d_C_apply (Curry_Names.d_C_renameQName cd
  cs) (Curry_Prelude.OP_Tuple2 (Curry_Prelude.toCurryString "Global")
  (Curry_Prelude.toCurryString "global")) cd cs

d_C_globalTemporary :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_globalTemporary cd cs = Curry_Prelude.d_C_apply (Curry_Names.d_C_renameQName
  cd cs) (Curry_Prelude.OP_Tuple2 (Curry_Prelude.toCurryString "Global")
  (Curry_Prelude.toCurryString "Temporary")) cd cs

d_C_trGlobalDecl :: FlatCurry.Curry_Types.C_FuncDecl -> Cover -> ConstStore
  -> C_IOES C_State (Curry_Prelude.OP_List Curry_AbstractHaskell.C_FuncDecl)
d_C_trGlobalDecl x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_Func x2 x3 x4 x5 x6 -> Curry_Prelude.d_OP_dollar
    (d_C_doInDetMode Curry_Prelude.C_True) (d_C__case_181 x3 x2 x4 x5 x6 cd cs)
    cd cs
  FlatCurry.Curry_Types.Choice_C_FuncDecl d i l r -> narrow d i
    (d_C_trGlobalDecl l cd cs) (d_C_trGlobalDecl r cd cs)
  FlatCurry.Curry_Types.Choices_C_FuncDecl d i xs -> narrows cs d i (\z ->
    d_C_trGlobalDecl z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_FuncDecl d c e -> guardCons d c
    (d_C_trGlobalDecl e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_FuncDecl d info -> failCons d (traceFail
    "TransFunctions.trGlobalDecl" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.trGlobalDecl" (showCons x1))

nd_C_trGlobalDecl :: FlatCurry.Curry_Types.C_FuncDecl -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_FuncDecl)
nd_C_trGlobalDecl x1 s cd cs = case x1 of
  FlatCurry.Curry_Types.C_Func x2 x3 x4 x5 x6 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id
    (nd_C_doInDetMode Curry_Prelude.C_True)) (nd_C__case_181 x3 x2 x4 x5 x6 s0
    cd cs) s1 cd cs))
  FlatCurry.Curry_Types.Choice_C_FuncDecl d i l r -> narrow d i
    (nd_C_trGlobalDecl l s cd cs) (nd_C_trGlobalDecl r s cd cs)
  FlatCurry.Curry_Types.Choices_C_FuncDecl d i xs -> narrows cs d i (\z ->
    nd_C_trGlobalDecl z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_FuncDecl d c e -> guardCons d c
    (nd_C_trGlobalDecl e s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_FuncDecl d info -> failCons d (traceFail
    "TransFunctions.trGlobalDecl" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.trGlobalDecl" (showCons x1))

d_OP_trGlobalDecl_dot_uscore_hash_lambda208 :: FlatCurry.Curry_Types.C_TypeExpr
  -> FlatCurry.Curry_Types.C_Visibility -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> C_IOES C_State (Curry_Prelude.OP_List Curry_AbstractHaskell.C_FuncDecl)
d_OP_trGlobalDecl_dot_uscore_hash_lambda208 x1 x2 x3 x4 cd cs = d_OP_gt_plus_eq
  (d_C_renameFun x3 cd cs)
  (d_OP_trGlobalDecl_dot_uscore_hash_lambda208_dot_uscore_hash_lambda209 x4 x1
  x2 x3) cd cs

nd_OP_trGlobalDecl_dot_uscore_hash_lambda208 :: FlatCurry.Curry_Types.C_TypeExpr
  -> FlatCurry.Curry_Types.C_Visibility -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_AbstractHaskell.C_Expr -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_FuncDecl)
nd_OP_trGlobalDecl_dot_uscore_hash_lambda208 x1 x2 x3 x4 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_renameFun x3 s0 cd cs) (wrapNX id
  (nd_OP_trGlobalDecl_dot_uscore_hash_lambda208_dot_uscore_hash_lambda209 x4 x1
  x2 x3)) s1 cd cs))

d_OP_trGlobalDecl_dot_uscore_hash_lambda208_dot_uscore_hash_lambda209 :: Curry_AbstractHaskell.C_Expr
  -> FlatCurry.Curry_Types.C_TypeExpr -> FlatCurry.Curry_Types.C_Visibility
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_FuncDecl)
d_OP_trGlobalDecl_dot_uscore_hash_lambda208_dot_uscore_hash_lambda209 x1 x2 x3 x4 x5 cd cs =
  d_OP_gt_plus_eq (d_C_renameFun (d_C_globalGlobal cd cs) cd cs)
  (d_OP_trGlobalDecl_dot_uscore_hash_lambda208_dot_uscore_hash_lambda209_dot_uscore_hash_lambda210
  x1 x2 x3 x4 x5) cd cs

nd_OP_trGlobalDecl_dot_uscore_hash_lambda208_dot_uscore_hash_lambda209 :: Curry_AbstractHaskell.C_Expr
  -> FlatCurry.Curry_Types.C_TypeExpr -> FlatCurry.Curry_Types.C_Visibility
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> IDSupply -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_FuncDecl)
nd_OP_trGlobalDecl_dot_uscore_hash_lambda208_dot_uscore_hash_lambda209 x1 x2 x3 x4 x5 s cd cs =
  let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_renameFun (d_C_globalGlobal cd
  cs) s0 cd cs) (wrapNX id
  (nd_OP_trGlobalDecl_dot_uscore_hash_lambda208_dot_uscore_hash_lambda209_dot_uscore_hash_lambda210
  x1 x2 x3 x4 x5)) s1 cd cs))

d_OP_trGlobalDecl_dot_uscore_hash_lambda208_dot_uscore_hash_lambda209_dot_uscore_hash_lambda210 :: Curry_AbstractHaskell.C_Expr
  -> FlatCurry.Curry_Types.C_TypeExpr -> FlatCurry.Curry_Types.C_Visibility
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_FuncDecl)
d_OP_trGlobalDecl_dot_uscore_hash_lambda208_dot_uscore_hash_lambda209_dot_uscore_hash_lambda210 x1 x2 x3 x4 x5 x6 cd cs =
  d_OP_gt_plus_eq (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (d_C_trDetType cd cs) (Curry_Prelude.C_Int (0)) cd cs) x2 cd cs)
  (d_OP_trGlobalDecl_dot_uscore_hash_lambda208_dot_uscore_hash_lambda209_dot_uscore_hash_lambda210_dot_uscore_hash_lambda211
  x1 x2 x3 x6 x4 x5) cd cs

nd_OP_trGlobalDecl_dot_uscore_hash_lambda208_dot_uscore_hash_lambda209_dot_uscore_hash_lambda210 :: Curry_AbstractHaskell.C_Expr
  -> FlatCurry.Curry_Types.C_TypeExpr -> FlatCurry.Curry_Types.C_Visibility
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply
  -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_FuncDecl)
nd_OP_trGlobalDecl_dot_uscore_hash_lambda208_dot_uscore_hash_lambda209_dot_uscore_hash_lambda210 x1 x2 x3 x4 x5 x6 s cd cs =
  let s6 = s
  in s6 `seq` (let s5 = leftSupply s6
                   s4 = rightSupply s6
  in s5 `seq` (s4 `seq` nd_OP_gt_plus_eq (let s3 = leftSupply s4
                                              s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                      s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (nd_C_trDetType s0 cd cs)
  (Curry_Prelude.C_Int (0)) s1 cd cs)) x2 s3 cd cs)) (wrapNX id
  (nd_OP_trGlobalDecl_dot_uscore_hash_lambda208_dot_uscore_hash_lambda209_dot_uscore_hash_lambda210_dot_uscore_hash_lambda211
  x1 x2 x3 x6 x4 x5)) s5 cd cs))

d_OP_trGlobalDecl_dot_uscore_hash_lambda208_dot_uscore_hash_lambda209_dot_uscore_hash_lambda210_dot_uscore_hash_lambda211 :: Curry_AbstractHaskell.C_Expr
  -> FlatCurry.Curry_Types.C_TypeExpr -> FlatCurry.Curry_Types.C_Visibility
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_FuncDecl)
d_OP_trGlobalDecl_dot_uscore_hash_lambda208_dot_uscore_hash_lambda209_dot_uscore_hash_lambda210_dot_uscore_hash_lambda211 x1 x2 x3 x4 x5 x6 x7 cd cs =
  Curry_Prelude.d_OP_dollar d_C_returnM (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Func Curry_Prelude.OP_List x6 (Curry_Prelude.C_Int
  (2)) (d_C_cvVisibility x3 cd cs) (d_C_toTypeSig x7 cd cs)
  (Curry_AbstractHaskellGoodies.d_C_simpleRule (Curry_Prelude.d_C_map (acceptCs
  id Curry_AbstractHaskell.C_PVar) (Curry_Prelude.OP_Cons (d_C_coverName cd cs)
  (Curry_Prelude.OP_Cons (d_C_constStoreName cd cs) Curry_Prelude.OP_List)) cd
  cs) (Curry_Prelude.d_OP_dollar (acceptCs id Curry_AbstractHaskell.C_Symbol)
  (Curry_Prelude.d_C_apply (Curry_Names.d_C_mkGlobalName cd cs) x5 cd cs) cd cs)
  cd cs)) (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Func
  Curry_Prelude.OP_List (Curry_Prelude.d_C_apply (Curry_Names.d_C_mkGlobalName
  cd cs) x5 cd cs) (Curry_Prelude.C_Int (0)) Curry_AbstractHaskell.C_Private
  (Curry_Prelude.d_OP_dollar d_C_toTypeSig (d_C_trHOTypeExpr (acceptCs (acceptCs
  id) Curry_AbstractHaskell.C_FuncType) x2 cd cs) cd cs)
  (Curry_AbstractHaskellGoodies.d_C_simpleRule Curry_Prelude.OP_List
  (Curry_AbstractHaskellGoodies.d_C_applyF x4 (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskellGoodies.d_C_clet (Curry_Prelude.d_C_map
  (Curry_Prelude.d_C_uncurry (acceptCs id
  Curry_AbstractHaskellGoodies.d_C_declVar)) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (d_C_constStoreName cd cs) (d_C_emptyCs cd cs))
  (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple2 (d_C_coverName cd cs)
  (d_C_initCover cd cs)) Curry_Prelude.OP_List)) cd cs) x1 cd cs)
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Symbol (d_C_globalTemporary cd
  cs)) (Curry_Prelude.OP_Cons (d_C_initCover cd cs) (Curry_Prelude.OP_Cons
  (d_C_emptyCs cd cs) Curry_Prelude.OP_List)))) cd cs) cd cs))
  Curry_Prelude.OP_List)) cd cs

nd_OP_trGlobalDecl_dot_uscore_hash_lambda208_dot_uscore_hash_lambda209_dot_uscore_hash_lambda210_dot_uscore_hash_lambda211 :: Curry_AbstractHaskell.C_Expr
  -> FlatCurry.Curry_Types.C_TypeExpr -> FlatCurry.Curry_Types.C_Visibility
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_AbstractHaskell.C_TypeExpr -> IDSupply -> Cover -> ConstStore
  -> C_IOES C_State (Curry_Prelude.OP_List Curry_AbstractHaskell.C_FuncDecl)
nd_OP_trGlobalDecl_dot_uscore_hash_lambda208_dot_uscore_hash_lambda209_dot_uscore_hash_lambda210_dot_uscore_hash_lambda211 x1 x2 x3 x4 x5 x6 x7 s cd cs =
  let s14 = s
  in s14 `seq` (let s13 = leftSupply s14
                    s12 = rightSupply s14
  in s13 `seq` (s12 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id nd_C_returnM)
  (let s4 = leftSupply s12
       s10 = rightSupply s12
  in s4 `seq` (s10 `seq` Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Func
  Curry_Prelude.OP_List x6 (Curry_Prelude.C_Int (2)) (d_C_cvVisibility x3 cd cs)
  (d_C_toTypeSig x7 cd cs) (let s0 = leftSupply s4
                                s3 = rightSupply s4
  in s0 `seq` (s3 `seq` Curry_AbstractHaskellGoodies.d_C_simpleRule
  (Curry_Prelude.nd_C_map (wrapDX id (acceptCs id Curry_AbstractHaskell.C_PVar))
  (Curry_Prelude.OP_Cons (d_C_coverName cd cs) (Curry_Prelude.OP_Cons
  (d_C_constStoreName cd cs) Curry_Prelude.OP_List)) s0 cd cs)
  (let s2 = leftSupply s3
       s1 = rightSupply s3
  in s2 `seq` (s1 `seq` Curry_Prelude.nd_OP_dollar (wrapDX id (acceptCs id
  Curry_AbstractHaskell.C_Symbol)) (Curry_Prelude.nd_C_apply (wrapDX id
  (Curry_Names.d_C_mkGlobalName cd cs)) x5 s1 cd cs) s2 cd cs)) cd cs)))
  (Curry_Prelude.OP_Cons (let s5 = leftSupply s10
                              s11 = rightSupply s10
                              s8 = leftSupply s11
                              s9 = rightSupply s11
  in s5 `seq` (s11 `seq` (s8 `seq` (s9 `seq` Curry_AbstractHaskell.C_Func
  Curry_Prelude.OP_List (Curry_Prelude.nd_C_apply (wrapDX id
  (Curry_Names.d_C_mkGlobalName cd cs)) x5 s5 cd cs) (Curry_Prelude.C_Int (0))
  Curry_AbstractHaskell.C_Private (let s7 = leftSupply s8
                                       s6 = rightSupply s8
  in s7 `seq` (s6 `seq` Curry_Prelude.nd_OP_dollar (wrapDX id d_C_toTypeSig)
  (nd_C_trHOTypeExpr (wrapDX (wrapDX id) (acceptCs (acceptCs id)
  Curry_AbstractHaskell.C_FuncType)) x2 s6 cd cs) s7 cd cs))
  (Curry_AbstractHaskellGoodies.d_C_simpleRule Curry_Prelude.OP_List
  (Curry_AbstractHaskellGoodies.d_C_applyF x4 (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskellGoodies.d_C_clet (Curry_Prelude.nd_C_map (wrapNX id
  (Curry_Prelude.nd_C_uncurry (wrapDX (wrapDX id) (acceptCs id
  Curry_AbstractHaskellGoodies.d_C_declVar)))) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (d_C_constStoreName cd cs) (d_C_emptyCs cd cs))
  (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple2 (d_C_coverName cd cs)
  (d_C_initCover cd cs)) Curry_Prelude.OP_List)) s9 cd cs) x1 cd cs)
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Symbol (d_C_globalTemporary cd
  cs)) (Curry_Prelude.OP_Cons (d_C_initCover cd cs) (Curry_Prelude.OP_Cons
  (d_C_emptyCs cd cs) Curry_Prelude.OP_List)))) cd cs) cd cs)))))
  Curry_Prelude.OP_List))) s13 cd cs))

d_C_cvVisibility :: FlatCurry.Curry_Types.C_Visibility -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Visibility
d_C_cvVisibility x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_Public -> Curry_AbstractHaskell.C_Public
  FlatCurry.Curry_Types.C_Private -> Curry_AbstractHaskell.C_Private
  FlatCurry.Curry_Types.Choice_C_Visibility d i l r -> narrow d i
    (d_C_cvVisibility l cd cs) (d_C_cvVisibility r cd cs)
  FlatCurry.Curry_Types.Choices_C_Visibility d i xs -> narrows cs d i (\z ->
    d_C_cvVisibility z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Visibility d c e -> guardCons d c
    (d_C_cvVisibility e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Visibility d info -> failCons d (traceFail
    "TransFunctions.cvVisibility" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.cvVisibility" (showCons x1))

d_C_trDetFunc :: FlatCurry.Curry_Types.C_FuncDecl -> Cover -> ConstStore
  -> C_IOES C_State Curry_AbstractHaskell.C_FuncDecl
d_C_trDetFunc x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_Func x2 x3 x4 x5 x6 -> Curry_Prelude.d_OP_dollar
    (d_C_doInDetMode Curry_Prelude.C_True) (d_OP_gt_plus_eq (d_C_renameFun x2 cd
    cs) (d_OP_trDetFunc_dot_uscore_hash_lambda213 x6 x5 x4 x3) cd cs) cd cs
  FlatCurry.Curry_Types.Choice_C_FuncDecl d i l r -> narrow d i (d_C_trDetFunc l
    cd cs) (d_C_trDetFunc r cd cs)
  FlatCurry.Curry_Types.Choices_C_FuncDecl d i xs -> narrows cs d i (\z ->
    d_C_trDetFunc z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_FuncDecl d c e -> guardCons d c (d_C_trDetFunc e
    cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_FuncDecl d info -> failCons d (traceFail
    "TransFunctions.trDetFunc" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.trDetFunc" (showCons x1))

nd_C_trDetFunc :: FlatCurry.Curry_Types.C_FuncDecl -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_FuncDecl
nd_C_trDetFunc x1 s cd cs = case x1 of
  FlatCurry.Curry_Types.C_Func x2 x3 x4 x5 x6 -> let s4 = s
    in s4 `seq` (let s3 = leftSupply s4
                     s2 = rightSupply s4
    in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id
    (nd_C_doInDetMode Curry_Prelude.C_True)) (let s1 = leftSupply s2
                                                  s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_renameFun x2 s0 cd cs) (wrapNX
    id (nd_OP_trDetFunc_dot_uscore_hash_lambda213 x6 x5 x4 x3)) s1 cd cs)) s3 cd
    cs))
  FlatCurry.Curry_Types.Choice_C_FuncDecl d i l r -> narrow d i (nd_C_trDetFunc
    l s cd cs) (nd_C_trDetFunc r s cd cs)
  FlatCurry.Curry_Types.Choices_C_FuncDecl d i xs -> narrows cs d i (\z ->
    nd_C_trDetFunc z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_FuncDecl d c e -> guardCons d c (nd_C_trDetFunc
    e s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_FuncDecl d info -> failCons d (traceFail
    "TransFunctions.trDetFunc" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.trDetFunc" (showCons x1))

d_OP_trDetFunc_dot_uscore_hash_lambda213 :: FlatCurry.Curry_Types.C_Rule
  -> FlatCurry.Curry_Types.C_TypeExpr -> FlatCurry.Curry_Types.C_Visibility
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_FuncDecl
d_OP_trDetFunc_dot_uscore_hash_lambda213 x1 x2 x3 x4 x5 cd cs = d_OP_gt_plus_eq
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (d_C_trDetType cd cs) x4 cd
  cs) x2 cd cs)
  (d_OP_trDetFunc_dot_uscore_hash_lambda213_dot_uscore_hash_lambda214 x1 x3 x4
  x5) cd cs

nd_OP_trDetFunc_dot_uscore_hash_lambda213 :: FlatCurry.Curry_Types.C_Rule
  -> FlatCurry.Curry_Types.C_TypeExpr -> FlatCurry.Curry_Types.C_Visibility
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply
  -> Cover -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_FuncDecl
nd_OP_trDetFunc_dot_uscore_hash_lambda213 x1 x2 x3 x4 x5 s cd cs = let s6 = s
  in s6 `seq` (let s5 = leftSupply s6
                   s4 = rightSupply s6
  in s5 `seq` (s4 `seq` nd_OP_gt_plus_eq (let s3 = leftSupply s4
                                              s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                      s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (nd_C_trDetType s0 cd cs) x4 s1
  cd cs)) x2 s3 cd cs)) (wrapNX id
  (nd_OP_trDetFunc_dot_uscore_hash_lambda213_dot_uscore_hash_lambda214 x1 x3 x4
  x5)) s5 cd cs))

d_OP_trDetFunc_dot_uscore_hash_lambda213_dot_uscore_hash_lambda214 :: FlatCurry.Curry_Types.C_Rule
  -> FlatCurry.Curry_Types.C_Visibility -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore -> C_IOES C_State
  Curry_AbstractHaskell.C_FuncDecl
d_OP_trDetFunc_dot_uscore_hash_lambda213_dot_uscore_hash_lambda214 x1 x2 x3 x4 x5 cd cs =
  d_OP_gt_plus_eq (d_C_trRule x4 x3 x1 cd cs)
  (d_OP_trDetFunc_dot_uscore_hash_lambda213_dot_uscore_hash_lambda214_dot_uscore_hash_lambda215
  x5 x2 x3 x4) cd cs

nd_OP_trDetFunc_dot_uscore_hash_lambda213_dot_uscore_hash_lambda214 :: FlatCurry.Curry_Types.C_Rule
  -> FlatCurry.Curry_Types.C_Visibility -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_AbstractHaskell.C_TypeExpr -> IDSupply -> Cover -> ConstStore
  -> C_IOES C_State Curry_AbstractHaskell.C_FuncDecl
nd_OP_trDetFunc_dot_uscore_hash_lambda213_dot_uscore_hash_lambda214 x1 x2 x3 x4 x5 s cd cs =
  let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_trRule x4 x3 x1 s0 cd cs) (wrapNX
  id
  (nd_OP_trDetFunc_dot_uscore_hash_lambda213_dot_uscore_hash_lambda214_dot_uscore_hash_lambda215
  x5 x2 x3 x4)) s1 cd cs))

d_OP_trDetFunc_dot_uscore_hash_lambda213_dot_uscore_hash_lambda214_dot_uscore_hash_lambda215 :: Curry_AbstractHaskell.C_TypeExpr
  -> FlatCurry.Curry_Types.C_Visibility -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_AbstractHaskell.C_Rules
  -> Cover -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_FuncDecl
d_OP_trDetFunc_dot_uscore_hash_lambda213_dot_uscore_hash_lambda214_dot_uscore_hash_lambda215 x1 x2 x3 x4 x5 cd cs =
  d_C_returnM (Curry_AbstractHaskell.C_Func Curry_Prelude.OP_List x4
  (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
  x3 (Curry_Prelude.C_Int (1)) cd cs) (d_C_cvVisibility x2 cd cs) (d_C_toTypeSig
  x1 cd cs) x5) cd cs

nd_OP_trDetFunc_dot_uscore_hash_lambda213_dot_uscore_hash_lambda214_dot_uscore_hash_lambda215 :: Curry_AbstractHaskell.C_TypeExpr
  -> FlatCurry.Curry_Types.C_Visibility -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_AbstractHaskell.C_Rules
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State
  Curry_AbstractHaskell.C_FuncDecl
nd_OP_trDetFunc_dot_uscore_hash_lambda213_dot_uscore_hash_lambda214_dot_uscore_hash_lambda215 x1 x2 x3 x4 x5 s cd cs =
  let s0 = s
  in s0 `seq` nd_C_returnM (Curry_AbstractHaskell.C_Func Curry_Prelude.OP_List
  x4
  (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
  x3 (Curry_Prelude.C_Int (1)) cd cs) (d_C_cvVisibility x2 cd cs) (d_C_toTypeSig
  x1 cd cs) x5) s0 cd cs

d_C_trNDFunc :: FlatCurry.Curry_Types.C_FuncDecl -> Cover -> ConstStore
  -> C_IOES C_State Curry_AbstractHaskell.C_FuncDecl
d_C_trNDFunc x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_Func x2 x3 x4 x5 x6 -> Curry_Prelude.d_OP_dollar
    (d_C_doInDetMode Curry_Prelude.C_False) (d_OP_gt_plus_eq (d_C_renameFun x2
    cd cs) (d_OP_trNDFunc_dot_uscore_hash_lambda216 x6 x5 x4 x3) cd cs) cd cs
  FlatCurry.Curry_Types.Choice_C_FuncDecl d i l r -> narrow d i (d_C_trNDFunc l
    cd cs) (d_C_trNDFunc r cd cs)
  FlatCurry.Curry_Types.Choices_C_FuncDecl d i xs -> narrows cs d i (\z ->
    d_C_trNDFunc z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_FuncDecl d c e -> guardCons d c (d_C_trNDFunc e
    cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_FuncDecl d info -> failCons d (traceFail
    "TransFunctions.trNDFunc" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.trNDFunc" (showCons x1))

nd_C_trNDFunc :: FlatCurry.Curry_Types.C_FuncDecl -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_FuncDecl
nd_C_trNDFunc x1 s cd cs = case x1 of
  FlatCurry.Curry_Types.C_Func x2 x3 x4 x5 x6 -> let s4 = s
    in s4 `seq` (let s3 = leftSupply s4
                     s2 = rightSupply s4
    in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id
    (nd_C_doInDetMode Curry_Prelude.C_False)) (let s1 = leftSupply s2
                                                   s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_renameFun x2 s0 cd cs) (wrapNX
    id (nd_OP_trNDFunc_dot_uscore_hash_lambda216 x6 x5 x4 x3)) s1 cd cs)) s3 cd
    cs))
  FlatCurry.Curry_Types.Choice_C_FuncDecl d i l r -> narrow d i (nd_C_trNDFunc l
    s cd cs) (nd_C_trNDFunc r s cd cs)
  FlatCurry.Curry_Types.Choices_C_FuncDecl d i xs -> narrows cs d i (\z ->
    nd_C_trNDFunc z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_FuncDecl d c e -> guardCons d c (nd_C_trNDFunc e
    s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_FuncDecl d info -> failCons d (traceFail
    "TransFunctions.trNDFunc" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.trNDFunc" (showCons x1))

d_OP_trNDFunc_dot_uscore_hash_lambda216 :: FlatCurry.Curry_Types.C_Rule
  -> FlatCurry.Curry_Types.C_TypeExpr -> FlatCurry.Curry_Types.C_Visibility
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_FuncDecl
d_OP_trNDFunc_dot_uscore_hash_lambda216 x1 x2 x3 x4 x5 cd cs = d_OP_gt_plus_eq
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (d_C_trNonDetType cd cs) x4
  cd cs) x2 cd cs)
  (d_OP_trNDFunc_dot_uscore_hash_lambda216_dot_uscore_hash_lambda217 x1 x3 x4
  x5) cd cs

nd_OP_trNDFunc_dot_uscore_hash_lambda216 :: FlatCurry.Curry_Types.C_Rule
  -> FlatCurry.Curry_Types.C_TypeExpr -> FlatCurry.Curry_Types.C_Visibility
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply
  -> Cover -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_FuncDecl
nd_OP_trNDFunc_dot_uscore_hash_lambda216 x1 x2 x3 x4 x5 s cd cs = let s6 = s
  in s6 `seq` (let s5 = leftSupply s6
                   s4 = rightSupply s6
  in s5 `seq` (s4 `seq` nd_OP_gt_plus_eq (let s3 = leftSupply s4
                                              s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                      s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (nd_C_trNonDetType s0 cd cs) x4
  s1 cd cs)) x2 s3 cd cs)) (wrapNX id
  (nd_OP_trNDFunc_dot_uscore_hash_lambda216_dot_uscore_hash_lambda217 x1 x3 x4
  x5)) s5 cd cs))

d_OP_trNDFunc_dot_uscore_hash_lambda216_dot_uscore_hash_lambda217 :: FlatCurry.Curry_Types.C_Rule
  -> FlatCurry.Curry_Types.C_Visibility -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore -> C_IOES C_State
  Curry_AbstractHaskell.C_FuncDecl
d_OP_trNDFunc_dot_uscore_hash_lambda216_dot_uscore_hash_lambda217 x1 x2 x3 x4 x5 cd cs =
  d_OP_gt_plus_eq (d_C_trRule x4 x3 x1 cd cs)
  (d_OP_trNDFunc_dot_uscore_hash_lambda216_dot_uscore_hash_lambda217_dot_uscore_hash_lambda218
  x5 x2 x3 x4) cd cs

nd_OP_trNDFunc_dot_uscore_hash_lambda216_dot_uscore_hash_lambda217 :: FlatCurry.Curry_Types.C_Rule
  -> FlatCurry.Curry_Types.C_Visibility -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_AbstractHaskell.C_TypeExpr -> IDSupply -> Cover -> ConstStore
  -> C_IOES C_State Curry_AbstractHaskell.C_FuncDecl
nd_OP_trNDFunc_dot_uscore_hash_lambda216_dot_uscore_hash_lambda217 x1 x2 x3 x4 x5 s cd cs =
  let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_trRule x4 x3 x1 s0 cd cs) (wrapNX
  id
  (nd_OP_trNDFunc_dot_uscore_hash_lambda216_dot_uscore_hash_lambda217_dot_uscore_hash_lambda218
  x5 x2 x3 x4)) s1 cd cs))

d_OP_trNDFunc_dot_uscore_hash_lambda216_dot_uscore_hash_lambda217_dot_uscore_hash_lambda218 :: Curry_AbstractHaskell.C_TypeExpr
  -> FlatCurry.Curry_Types.C_Visibility -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_AbstractHaskell.C_Rules
  -> Cover -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_FuncDecl
d_OP_trNDFunc_dot_uscore_hash_lambda216_dot_uscore_hash_lambda217_dot_uscore_hash_lambda218 x1 x2 x3 x4 x5 cd cs =
  d_C_returnM (Curry_AbstractHaskell.C_Func Curry_Prelude.OP_List x4
  (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
  x3 (Curry_Prelude.C_Int (2)) cd cs) (d_C_cvVisibility x2 cd cs) (d_C_toTypeSig
  x1 cd cs) x5) cd cs

nd_OP_trNDFunc_dot_uscore_hash_lambda216_dot_uscore_hash_lambda217_dot_uscore_hash_lambda218 :: Curry_AbstractHaskell.C_TypeExpr
  -> FlatCurry.Curry_Types.C_Visibility -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_AbstractHaskell.C_Rules
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State
  Curry_AbstractHaskell.C_FuncDecl
nd_OP_trNDFunc_dot_uscore_hash_lambda216_dot_uscore_hash_lambda217_dot_uscore_hash_lambda218 x1 x2 x3 x4 x5 s cd cs =
  let s0 = s
  in s0 `seq` nd_C_returnM (Curry_AbstractHaskell.C_Func Curry_Prelude.OP_List
  x4
  (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
  x3 (Curry_Prelude.C_Int (2)) cd cs) (d_C_cvVisibility x2 cd cs) (d_C_toTypeSig
  x1 cd cs) x5) s0 cd cs

d_C_renameFun :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C_renameFun x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> d_OP_gt_plus_eq (d_C_isDetMode cd cs)
    (d_OP_renameFun_dot_uscore_hash_lambda219 x3 x2 x1) cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C_renameFun l cd cs)
    (d_C_renameFun r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C_renameFun
    z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C_renameFun e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.renameFun" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.renameFun" (showCons x1))

nd_C_renameFun :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply
  -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
nd_C_renameFun x1 s cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_isDetMode s0 cd cs) (wrapNX id
    (nd_OP_renameFun_dot_uscore_hash_lambda219 x3 x2 x1)) s1 cd cs))
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (nd_C_renameFun l s cd
    cs) (nd_C_renameFun r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> nd_C_renameFun
    z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (nd_C_renameFun e s cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.renameFun" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.renameFun" (showCons x1))

d_OP_renameFun_dot_uscore_hash_lambda219 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_OP_renameFun_dot_uscore_hash_lambda219 x1 x2 x3 x4 cd cs = d_OP_gt_plus_eq
  (d_C_getNDClass x3 cd cs)
  (d_OP_renameFun_dot_uscore_hash_lambda219_dot_uscore_hash_lambda220 x4 x1 x2
  x3) cd cs

nd_OP_renameFun_dot_uscore_hash_lambda219 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
nd_OP_renameFun_dot_uscore_hash_lambda219 x1 x2 x3 x4 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getNDClass x3 s0 cd cs) (wrapNX
  id (nd_OP_renameFun_dot_uscore_hash_lambda219_dot_uscore_hash_lambda220 x4 x1
  x2 x3)) s1 cd cs))

d_OP_renameFun_dot_uscore_hash_lambda219_dot_uscore_hash_lambda220 :: Curry_Prelude.C_Bool
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Classification.C_NDClass -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_renameFun_dot_uscore_hash_lambda219_dot_uscore_hash_lambda220 x1 x2 x3 x4 x5 cd cs =
  d_OP_gt_plus_eq (d_C_getFuncHOClass x4 cd cs)
  (d_OP_renameFun_dot_uscore_hash_lambda219_dot_uscore_hash_lambda220_dot_uscore_hash_lambda221
  x5 x1 x2 x3) cd cs

nd_OP_renameFun_dot_uscore_hash_lambda219_dot_uscore_hash_lambda220 :: Curry_Prelude.C_Bool
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Classification.C_NDClass -> IDSupply -> Cover -> ConstStore -> C_IOES
  C_State (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_OP_renameFun_dot_uscore_hash_lambda219_dot_uscore_hash_lambda220 x1 x2 x3 x4 x5 s cd cs =
  let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getFuncHOClass x4 s0 cd cs)
  (wrapNX id
  (nd_OP_renameFun_dot_uscore_hash_lambda219_dot_uscore_hash_lambda220_dot_uscore_hash_lambda221
  x5 x1 x2 x3)) s1 cd cs))

d_OP_renameFun_dot_uscore_hash_lambda219_dot_uscore_hash_lambda220_dot_uscore_hash_lambda221 :: Curry_Classification.C_NDClass
  -> Curry_Prelude.C_Bool -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Classification.C_FuncHOClass -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_OP_renameFun_dot_uscore_hash_lambda219_dot_uscore_hash_lambda220_dot_uscore_hash_lambda221 x1 x2 x3 x4 x5 cd cs =
  d_C_returnM (Curry_Prelude.OP_Tuple2 x4 (Curry_Prelude.d_OP_plus_plus
  (Curry_Names.d_C_funcPrefix x2 x1 x5 cd cs) x3 cd cs)) cd cs

nd_OP_renameFun_dot_uscore_hash_lambda219_dot_uscore_hash_lambda220_dot_uscore_hash_lambda221 :: Curry_Classification.C_NDClass
  -> Curry_Prelude.C_Bool -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Classification.C_FuncHOClass -> IDSupply -> Cover -> ConstStore
  -> C_IOES C_State (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
nd_OP_renameFun_dot_uscore_hash_lambda219_dot_uscore_hash_lambda220_dot_uscore_hash_lambda221 x1 x2 x3 x4 x5 s cd cs =
  let s0 = s
  in s0 `seq` nd_C_returnM (Curry_Prelude.OP_Tuple2 x4
  (Curry_Prelude.d_OP_plus_plus (Curry_Names.d_C_funcPrefix x2 x1 x5 cd cs) x3
  cd cs)) s0 cd cs

d_C_renameCons :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C_renameCons x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> d_OP_gt_plus_eq (d_C_isDetMode cd cs)
    (d_OP_renameCons_dot_uscore_hash_lambda222 x3 x2 x1) cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C_renameCons l cd cs)
    (d_C_renameCons r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C_renameCons
    z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C_renameCons e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.renameCons" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.renameCons" (showCons x1))

nd_C_renameCons :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply
  -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
nd_C_renameCons x1 s cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_isDetMode s0 cd cs) (wrapNX id
    (nd_OP_renameCons_dot_uscore_hash_lambda222 x3 x2 x1)) s1 cd cs))
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (nd_C_renameCons l s cd
    cs) (nd_C_renameCons r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    nd_C_renameCons z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (nd_C_renameCons e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.renameCons" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.renameCons" (showCons x1))

d_OP_renameCons_dot_uscore_hash_lambda222 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_OP_renameCons_dot_uscore_hash_lambda222 x1 x2 x3 x4 cd cs = d_OP_gt_plus_eq
  (d_C_getConsHOClass x3 cd cs)
  (d_OP_renameCons_dot_uscore_hash_lambda222_dot_uscore_hash_lambda223 x4 x1 x2)
  cd cs

nd_OP_renameCons_dot_uscore_hash_lambda222 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
nd_OP_renameCons_dot_uscore_hash_lambda222 x1 x2 x3 x4 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getConsHOClass x3 s0 cd cs)
  (wrapNX id
  (nd_OP_renameCons_dot_uscore_hash_lambda222_dot_uscore_hash_lambda223 x4 x1
  x2)) s1 cd cs))

d_OP_renameCons_dot_uscore_hash_lambda222_dot_uscore_hash_lambda223 :: Curry_Prelude.C_Bool
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Classification.C_ConsHOClass -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_OP_renameCons_dot_uscore_hash_lambda222_dot_uscore_hash_lambda223 x1 x2 x3 x4 cd cs =
  d_C_returnM (Curry_Prelude.OP_Tuple2 x3 (Curry_Prelude.d_OP_plus_plus
  (Curry_Names.d_C_consPrefix x1 x4 cd cs) x2 cd cs)) cd cs

nd_OP_renameCons_dot_uscore_hash_lambda222_dot_uscore_hash_lambda223 :: Curry_Prelude.C_Bool
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Classification.C_ConsHOClass -> IDSupply
  -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
nd_OP_renameCons_dot_uscore_hash_lambda222_dot_uscore_hash_lambda223 x1 x2 x3 x4 s cd cs =
  let s0 = s
  in s0 `seq` nd_C_returnM (Curry_Prelude.OP_Tuple2 x3
  (Curry_Prelude.d_OP_plus_plus (Curry_Names.d_C_consPrefix x1 x4 cd cs) x2 cd
  cs)) s0 cd cs

d_C_toTypeSig :: Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeSig
d_C_toTypeSig x1 cd cs = Curry_AbstractHaskell.C_CType (Curry_Prelude.d_C_apply
  (d_C_genContext Curry_Prelude.OP_List cd cs) x1 cd cs) (d_C_toLocalTypeSig
  (Curry_AbstractHaskellGoodies.d_C_tyVarsOf x1 cd cs) x1 cd cs)

d_C_toLocalTypeSig :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeExpr
d_C_toLocalTypeSig x1 x2 cd cs = case x2 of
  Curry_AbstractHaskell.C_TVar x3 -> Curry_AbstractHaskell.C_TVar x3
  Curry_AbstractHaskell.C_TCons x4 x5 -> Curry_Prelude.d_OP_dollar (acceptCs id
    (Curry_AbstractHaskell.C_TCons x4)) (Curry_Prelude.d_C_map
    (d_C_toLocalTypeSig x1) x5 cd cs) cd cs
  Curry_AbstractHaskell.C_FuncType x6 x7 -> Curry_AbstractHaskell.C_FuncType
    (d_C_toLocalTypeSig x1 x6 cd cs) (d_C_toLocalTypeSig x1 x7 cd cs)
  Curry_AbstractHaskell.C_ForallType x8 x9 x10 -> Curry_Prelude.d_OP_dollar
    (acceptCs id (Curry_AbstractHaskell.C_ForallType x8
    (Curry_Prelude.d_OP_plus_plus x9 (Curry_Prelude.d_C_apply (d_C_genContext x1
    cd cs) x10 cd cs) cd cs))) (d_C_toLocalTypeSig (Curry_Prelude.d_OP_plus_plus
    x1 x8 cd cs) x10 cd cs) cd cs
  Curry_AbstractHaskell.Choice_C_TypeExpr d i l r -> narrow d i
    (d_C_toLocalTypeSig x1 l cd cs) (d_C_toLocalTypeSig x1 r cd cs)
  Curry_AbstractHaskell.Choices_C_TypeExpr d i xs -> narrows cs d i (\z ->
    d_C_toLocalTypeSig x1 z cd cs) xs
  Curry_AbstractHaskell.Guard_C_TypeExpr d c e -> guardCons d c
    (d_C_toLocalTypeSig x1 e cd $! addCs c cs)
  Curry_AbstractHaskell.Fail_C_TypeExpr d info -> failCons d (traceFail
    "TransFunctions.toLocalTypeSig" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.toLocalTypeSig" (showCons x2))

d_C_genContext :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_Context
d_C_genContext x1 cd cs = Curry_Prelude.d_OP_dot (Curry_Prelude.d_C_map
  d_C_mkContext) (d_C_gatherContextTypeExprs x1) cd cs

d_C_mkContext :: Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Context
d_C_mkContext x1 cd cs = Curry_AbstractHaskell.C_Context
  (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_curryPrelude cd cs)
  (Curry_Prelude.toCurryString "Curry")) (Curry_Prelude.OP_Cons x1
  Curry_Prelude.OP_List)

d_C_gatherContextTypeExprs :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_TypeExpr
d_C_gatherContextTypeExprs x1 x2 cd cs = Curry_Prelude.d_OP_dollar
  (Curry_List.d_C_nub
  (Curry_AbstractHaskell.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_AbstractHaskell_dot_TypeExpr
  cd cs)) (d_OP_gatherContextTypeExprs_dot_gatherContextTypeExprs_tick_dot_265
  x2 x1 Curry_Prelude.OP_List x2 cd cs) cd cs

d_OP_gatherContextTypeExprs_dot_gatherContextTypeExprs_tick_dot_265 :: Curry_AbstractHaskell.C_TypeExpr
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_TypeExpr -> Curry_AbstractHaskell.C_TypeExpr -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_TypeExpr
d_OP_gatherContextTypeExprs_dot_gatherContextTypeExprs_tick_dot_265 x1 x2 x3 x4 cd cs =
  case x4 of
  Curry_AbstractHaskell.C_TVar x5 -> d_C__case_175 x2 x5 x1 x3 x4
    (Curry_Prelude.d_OP_bar_bar (d_C_isHigherKinded x5 x1 cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_elem
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Int cd
    cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) cd cs) x5 cd cs) x2 cd cs) cd cs) cd cs
  Curry_AbstractHaskell.C_FuncType x6 x7 -> d_OP_gatherContextTypeExprs_dot_gatherContextTypeExprs_tick_dot_265
    x1 x2 (d_OP_gatherContextTypeExprs_dot_gatherContextTypeExprs_tick_dot_265
    x1 x2 x3 x6 cd cs) x7 cd cs
  Curry_AbstractHaskell.C_TCons x8 x9 -> d_C__case_173 x4 x2 x9 x8 x3 x1
    (Curry_Prelude.d_OP_amp_amp
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) x8 (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_curryPrelude cd cs)
    (Curry_Prelude.toCurryString "C_Apply")) cd cs) (Curry_Prelude.d_OP_amp_amp
    (d_C_isTypeVar (Curry_Prelude.d_C_head x9 cd cs) cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_any (Curry_Prelude.d_C_flip
    (Curry_Prelude.d_C_notElem
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Int cd
    cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) cd cs)) x2) cd cs) (Curry_AbstractHaskellGoodies.d_C_tyVarsOf x4
    cd cs) cd cs) cd cs) cd cs) cd cs
  Curry_AbstractHaskell.C_ForallType x10 x11 x12 -> Curry_Prelude.d_OP_plus_plus
    x3 (Curry_Prelude.d_OP_dollar (Curry_Prelude.d_C_filter
    (Curry_Prelude.d_OP_dot (Curry_Prelude.d_C_all (Curry_Prelude.d_C_flip
    (Curry_Prelude.d_C_notElem
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Int cd
    cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) cd cs)) x10) cd cs) Curry_AbstractHaskellGoodies.d_C_tyVarsOf cd
    cs)) (d_C_gatherContextTypeExprs (Curry_Prelude.d_OP_plus_plus x2
    (Curry_AbstractHaskellGoodies.d_C_tyVarsOf x1 cd cs) cd cs) x12 cd cs) cd
    cs) cd cs
  Curry_AbstractHaskell.Choice_C_TypeExpr d i l r -> narrow d i
    (d_OP_gatherContextTypeExprs_dot_gatherContextTypeExprs_tick_dot_265 x1 x2
    x3 l cd cs)
    (d_OP_gatherContextTypeExprs_dot_gatherContextTypeExprs_tick_dot_265 x1 x2
    x3 r cd cs)
  Curry_AbstractHaskell.Choices_C_TypeExpr d i xs -> narrows cs d i (\z ->
    d_OP_gatherContextTypeExprs_dot_gatherContextTypeExprs_tick_dot_265 x1 x2 x3
    z cd cs) xs
  Curry_AbstractHaskell.Guard_C_TypeExpr d c e -> guardCons d c
    (d_OP_gatherContextTypeExprs_dot_gatherContextTypeExprs_tick_dot_265 x1 x2
    x3 e cd $! addCs c cs)
  Curry_AbstractHaskell.Fail_C_TypeExpr d info -> failCons d (traceFail
    "TransFunctions.gatherContextTypeExprs.gatherContextTypeExprs'.265" [show x1
    , show x2, show x3, show x4] info)
  _ -> failCons cd (consFail
    "TransFunctions.gatherContextTypeExprs.gatherContextTypeExprs'.265"
    (showCons x4))

d_C_isTypeVar :: Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isTypeVar x1 cd cs = case x1 of
  Curry_AbstractHaskell.C_TVar x2 -> Curry_Prelude.C_True
  Curry_AbstractHaskell.C_FuncType x3 x4 -> Curry_Prelude.C_False
  Curry_AbstractHaskell.C_TCons x5 x6 -> Curry_Prelude.C_False
  Curry_AbstractHaskell.C_ForallType x7 x8 x9 -> Curry_Prelude.C_False
  Curry_AbstractHaskell.Choice_C_TypeExpr d i l r -> narrow d i (d_C_isTypeVar l
    cd cs) (d_C_isTypeVar r cd cs)
  Curry_AbstractHaskell.Choices_C_TypeExpr d i xs -> narrows cs d i (\z ->
    d_C_isTypeVar z cd cs) xs
  Curry_AbstractHaskell.Guard_C_TypeExpr d c e -> guardCons d c (d_C_isTypeVar e
    cd $! addCs c cs)
  Curry_AbstractHaskell.Fail_C_TypeExpr d info -> failCons d (traceFail
    "TransFunctions.isTypeVar" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.isTypeVar" (showCons x1))

d_C_isHigherKinded :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isHigherKinded x1 x2 cd cs = case x2 of
  Curry_AbstractHaskell.C_TVar x3 -> Curry_Prelude.C_False
  Curry_AbstractHaskell.C_FuncType x4 x5 -> Curry_Prelude.d_OP_bar_bar
    (d_C_isHigherKinded x1 x4 cd cs) (d_C_isHigherKinded x1 x5 cd cs) cd cs
  Curry_AbstractHaskell.C_ForallType x6 x7 x8 -> Curry_Prelude.d_OP_amp_amp
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_notElem
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Int cd
    cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) cd cs) x1 cd cs) x6 cd cs) (d_C_isHigherKinded x1 x8 cd cs) cd cs
  Curry_AbstractHaskell.C_TCons x9 x10 -> d_C__case_171 x9 x10 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) x9 (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_curryPrelude cd cs)
    (Curry_Prelude.toCurryString "C_Apply")) cd cs) cd cs
  Curry_AbstractHaskell.Choice_C_TypeExpr d i l r -> narrow d i
    (d_C_isHigherKinded x1 l cd cs) (d_C_isHigherKinded x1 r cd cs)
  Curry_AbstractHaskell.Choices_C_TypeExpr d i xs -> narrows cs d i (\z ->
    d_C_isHigherKinded x1 z cd cs) xs
  Curry_AbstractHaskell.Guard_C_TypeExpr d c e -> guardCons d c
    (d_C_isHigherKinded x1 e cd $! addCs c cs)
  Curry_AbstractHaskell.Fail_C_TypeExpr d info -> failCons d (traceFail
    "TransFunctions.isHigherKinded" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.isHigherKinded" (showCons x2))

d_C_trDetType :: Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> FlatCurry.Curry_Types.C_TypeExpr -> Cover -> ConstStore
  -> C_IOES C_State Curry_AbstractHaskell.C_TypeExpr
d_C_trDetType cd cs = acceptCs id (d_C_trTypeExpr (acceptCs id d_C_detFuncType)
  d_OP_trDetType_dot_uscore_hash_lambda224)

nd_C_trDetType :: IDSupply -> Cover -> ConstStore -> Func Curry_Prelude.C_Int
  (Func FlatCurry.Curry_Types.C_TypeExpr (C_IOES C_State
  Curry_AbstractHaskell.C_TypeExpr))
nd_C_trDetType s cd cs = wrapDX (wrapNX id) (acceptCs id (nd_C_trTypeExpr
  (wrapDX (wrapDX id) (acceptCs id d_C_detFuncType)) (wrapDX id
  d_OP_trDetType_dot_uscore_hash_lambda224)))

d_OP_trDetType_dot_uscore_hash_lambda224 :: Curry_AbstractHaskell.C_TypeExpr
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeExpr
d_OP_trDetType_dot_uscore_hash_lambda224 x1 cd cs = Curry_Prelude.d_C_foldr1
  (acceptCs (acceptCs id) Curry_AbstractHaskell.C_FuncType)
  (Curry_Prelude.OP_Cons (d_C_coverType cd cs) (Curry_Prelude.OP_Cons
  (d_C_storeType cd cs) (Curry_Prelude.OP_Cons x1 Curry_Prelude.OP_List))) cd cs

d_C_trNonDetType :: Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> FlatCurry.Curry_Types.C_TypeExpr -> Cover -> ConstStore
  -> C_IOES C_State Curry_AbstractHaskell.C_TypeExpr
d_C_trNonDetType cd cs = acceptCs id (d_C_trTypeExpr (acceptCs id
  d_C_nondetFuncType) (Curry_Prelude.d_OP_dot (acceptCs id
  (Curry_AbstractHaskell.C_FuncType (d_C_supplyType cd cs)))
  (Curry_Prelude.d_OP_dot (acceptCs id (Curry_AbstractHaskell.C_FuncType
  (d_C_coverType cd cs))) (acceptCs id (Curry_AbstractHaskell.C_FuncType
  (d_C_storeType cd cs))) cd cs) cd cs))

nd_C_trNonDetType :: IDSupply -> Cover -> ConstStore -> Func Curry_Prelude.C_Int
  (Func FlatCurry.Curry_Types.C_TypeExpr (C_IOES C_State
  Curry_AbstractHaskell.C_TypeExpr))
nd_C_trNonDetType s cd cs = let s2 = s
  in s2 `seq` wrapDX (wrapNX id) (acceptCs id (nd_C_trTypeExpr (wrapDX (wrapDX
  id) (acceptCs id d_C_nondetFuncType)) (let s1 = leftSupply s2
                                             s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  (Curry_AbstractHaskell.C_FuncType (d_C_supplyType cd cs))))
  (Curry_Prelude.nd_OP_dot (wrapDX id (acceptCs id
  (Curry_AbstractHaskell.C_FuncType (d_C_coverType cd cs)))) (wrapDX id
  (acceptCs id (Curry_AbstractHaskell.C_FuncType (d_C_storeType cd cs)))) s0 cd
  cs) s1 cd cs))))

d_C_trExprType :: FlatCurry.Curry_Types.C_TypeExpr -> Cover -> ConstStore
  -> C_IOES C_State Curry_AbstractHaskell.C_TypeExpr
d_C_trExprType x1 cd cs = d_OP_gt_plus_eq (d_C_isDetMode cd cs)
  (d_OP_trExprType_dot_uscore_hash_lambda225 x1) cd cs

nd_C_trExprType :: FlatCurry.Curry_Types.C_TypeExpr -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_TypeExpr
nd_C_trExprType x1 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_isDetMode s0 cd cs) (wrapNX id
  (nd_OP_trExprType_dot_uscore_hash_lambda225 x1)) s1 cd cs))

d_OP_trExprType_dot_uscore_hash_lambda225 :: FlatCurry.Curry_Types.C_TypeExpr
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> C_IOES C_State
  Curry_AbstractHaskell.C_TypeExpr
d_OP_trExprType_dot_uscore_hash_lambda225 x1 x2 cd cs =
  Curry_Prelude.d_OP_dollar d_C_returnM (d_C_trHOTypeExpr (d_C__case_169 x2 cd
  cs) x1 cd cs) cd cs

nd_OP_trExprType_dot_uscore_hash_lambda225 :: FlatCurry.Curry_Types.C_TypeExpr
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore -> C_IOES C_State
  Curry_AbstractHaskell.C_TypeExpr
nd_OP_trExprType_dot_uscore_hash_lambda225 x1 x2 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id nd_C_returnM)
  (nd_C_trHOTypeExpr (wrapDX (wrapDX id) (d_C__case_169 x2 cd cs)) x1 s0 cd cs)
  s1 cd cs))

d_C_trTypeExpr :: (Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeExpr) -> (Curry_AbstractHaskell.C_TypeExpr
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeExpr)
  -> Curry_Prelude.C_Int -> FlatCurry.Curry_Types.C_TypeExpr -> Cover
  -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_TypeExpr
d_C_trTypeExpr x1 x2 x3 x4 cd cs = d_C__case_168 x3 x4 x1 x2
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
  x3 (Curry_Prelude.C_Int (0)) cd cs) cd cs

nd_C_trTypeExpr :: Func Curry_AbstractHaskell.C_TypeExpr (Func
  Curry_AbstractHaskell.C_TypeExpr Curry_AbstractHaskell.C_TypeExpr) -> Func
  Curry_AbstractHaskell.C_TypeExpr Curry_AbstractHaskell.C_TypeExpr
  -> Curry_Prelude.C_Int -> FlatCurry.Curry_Types.C_TypeExpr -> IDSupply
  -> Cover -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_TypeExpr
nd_C_trTypeExpr x1 x2 x3 x4 s cd cs = let s0 = s
  in s0 `seq` nd_C__case_168 x3 x4 x1 x2
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
  x3 (Curry_Prelude.C_Int (0)) cd cs) s0 cd cs

d_OP_trTypeExpr_dot_uscore_hash_lambda227 :: FlatCurry.Curry_Types.C_TypeExpr
  -> (Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeExpr) -> Curry_AbstractHaskell.C_TypeExpr
  -> Cover -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_TypeExpr
d_OP_trTypeExpr_dot_uscore_hash_lambda227 x1 x2 x3 cd cs =
  Curry_Prelude.d_OP_dollar d_C_returnM (Curry_AbstractHaskell.C_FuncType
  (d_C_trHOTypeExpr x2 x1 cd cs) x3) cd cs

nd_OP_trTypeExpr_dot_uscore_hash_lambda227 :: FlatCurry.Curry_Types.C_TypeExpr
  -> Func Curry_AbstractHaskell.C_TypeExpr (Func
  Curry_AbstractHaskell.C_TypeExpr Curry_AbstractHaskell.C_TypeExpr)
  -> Curry_AbstractHaskell.C_TypeExpr -> IDSupply -> Cover -> ConstStore
  -> C_IOES C_State Curry_AbstractHaskell.C_TypeExpr
nd_OP_trTypeExpr_dot_uscore_hash_lambda227 x1 x2 x3 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id nd_C_returnM)
  (Curry_AbstractHaskell.C_FuncType (nd_C_trHOTypeExpr x2 x1 s0 cd cs) x3) s1 cd
  cs))

d_C_trHOTypeExpr :: (Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeExpr) -> FlatCurry.Curry_Types.C_TypeExpr
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeExpr
d_C_trHOTypeExpr x1 x2 cd cs = case x2 of
  FlatCurry.Curry_Types.C_TVar x3 -> Curry_AbstractHaskell.C_TVar
    (d_C_cvTVarIndex x3 cd cs)
  FlatCurry.Curry_Types.C_FuncType x4 x5 -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply x1 (d_C_trHOTypeExpr x1 x4 cd cs) cd cs)
    (d_C_trHOTypeExpr x1 x5 cd cs) cd cs
  FlatCurry.Curry_Types.C_TCons x6 x7 -> Curry_AbstractHaskell.C_TCons x6
    (Curry_Prelude.d_C_map (d_C_trHOTypeExpr x1) x7 cd cs)
  FlatCurry.Curry_Types.C_ForallType x8 x9 -> let x10 = d_C_trHOTypeExpr x1 x9
                                                    cd cs
    in Curry_AbstractHaskell.C_ForallType (Curry_Prelude.d_C_map d_C_cvTVarIndex
    x8 cd cs) (Curry_Prelude.d_C_apply (d_C_genContext Curry_Prelude.OP_List cd
    cs) x10 cd cs) x10
  FlatCurry.Curry_Types.Choice_C_TypeExpr d i l r -> narrow d i
    (d_C_trHOTypeExpr x1 l cd cs) (d_C_trHOTypeExpr x1 r cd cs)
  FlatCurry.Curry_Types.Choices_C_TypeExpr d i xs -> narrows cs d i (\z ->
    d_C_trHOTypeExpr x1 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_TypeExpr d c e -> guardCons d c
    (d_C_trHOTypeExpr x1 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_TypeExpr d info -> failCons d (traceFail
    "TransFunctions.trHOTypeExpr" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.trHOTypeExpr" (showCons x2))

nd_C_trHOTypeExpr :: Func Curry_AbstractHaskell.C_TypeExpr (Func
  Curry_AbstractHaskell.C_TypeExpr Curry_AbstractHaskell.C_TypeExpr)
  -> FlatCurry.Curry_Types.C_TypeExpr -> IDSupply -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeExpr
nd_C_trHOTypeExpr x1 x2 s cd cs = case x2 of
  FlatCurry.Curry_Types.C_TVar x3 -> Curry_AbstractHaskell.C_TVar
    (d_C_cvTVarIndex x3 cd cs)
  FlatCurry.Curry_Types.C_FuncType x4 x5 -> let s5 = s
    in s5 `seq` (let s4 = leftSupply s5
                     s6 = rightSupply s5
                     s2 = leftSupply s6
                     s3 = rightSupply s6
    in s4 `seq` (s6 `seq` (s2 `seq` (s3 `seq` Curry_Prelude.nd_C_apply
    (let s1 = leftSupply s2
         s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply x1 (nd_C_trHOTypeExpr x1 x4
    s0 cd cs) s1 cd cs)) (nd_C_trHOTypeExpr x1 x5 s3 cd cs) s4 cd cs))))
  FlatCurry.Curry_Types.C_TCons x6 x7 -> let s0 = s
    in s0 `seq` Curry_AbstractHaskell.C_TCons x6 (Curry_Prelude.nd_C_map (wrapNX
    id (nd_C_trHOTypeExpr x1)) x7 s0 cd cs)
  FlatCurry.Curry_Types.C_ForallType x8 x9 -> let s4 = s
    in s4 `seq` (let s0 = leftSupply s4
                     s3 = rightSupply s4
    in s0 `seq` (s3 `seq` (let x10 = nd_C_trHOTypeExpr x1 x9 s0 cd cs
    in let s1 = leftSupply s3
           s2 = rightSupply s3
    in s1 `seq` (s2 `seq` Curry_AbstractHaskell.C_ForallType
    (Curry_Prelude.nd_C_map (wrapDX id d_C_cvTVarIndex) x8 s1 cd cs)
    (Curry_Prelude.nd_C_apply (wrapDX id (d_C_genContext Curry_Prelude.OP_List
    cd cs)) x10 s2 cd cs) x10))))
  FlatCurry.Curry_Types.Choice_C_TypeExpr d i l r -> narrow d i
    (nd_C_trHOTypeExpr x1 l s cd cs) (nd_C_trHOTypeExpr x1 r s cd cs)
  FlatCurry.Curry_Types.Choices_C_TypeExpr d i xs -> narrows cs d i (\z ->
    nd_C_trHOTypeExpr x1 z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_TypeExpr d c e -> guardCons d c
    (nd_C_trHOTypeExpr x1 e s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_TypeExpr d info -> failCons d (traceFail
    "TransFunctions.trHOTypeExpr" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.trHOTypeExpr" (showCons x2))

d_C_cvTVarIndex :: Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_cvTVarIndex x1 cd cs = Curry_Prelude.OP_Tuple2 x1 (Curry_Prelude.OP_Cons
  (Curry_Prelude.C_Char 't'#) (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Int
  cd cs) x1 cd cs))

d_C_supplyType :: Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeExpr
d_C_supplyType cd cs = Curry_AbstractHaskell.C_TCons (Curry_Prelude.OP_Tuple2
  (Curry_Names.d_C_basics cd cs) (Curry_Prelude.toCurryString "IDSupply"))
  Curry_Prelude.OP_List

d_C_coverType :: Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeExpr
d_C_coverType cd cs = Curry_AbstractHaskell.C_TCons (Curry_Prelude.OP_Tuple2
  (Curry_Names.d_C_basics cd cs) (Curry_Prelude.toCurryString "Cover"))
  Curry_Prelude.OP_List

d_C_storeType :: Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeExpr
d_C_storeType cd cs = Curry_AbstractHaskell.C_TCons (Curry_Prelude.OP_Tuple2
  (Curry_Names.d_C_basics cd cs) (Curry_Prelude.toCurryString "ConstStore"))
  Curry_Prelude.OP_List

d_C_detFuncType :: Curry_AbstractHaskell.C_TypeExpr
  -> Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeExpr
d_C_detFuncType x1 x2 cd cs = Curry_Prelude.d_C_foldr1 (acceptCs (acceptCs id)
  Curry_AbstractHaskell.C_FuncType) (Curry_Prelude.OP_Cons x1
  (Curry_Prelude.OP_Cons (d_C_coverType cd cs) (Curry_Prelude.OP_Cons
  (d_C_storeType cd cs) (Curry_Prelude.OP_Cons x2 Curry_Prelude.OP_List)))) cd
  cs

d_C_nondetFuncType :: Curry_AbstractHaskell.C_TypeExpr
  -> Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeExpr
d_C_nondetFuncType x1 x2 cd cs = Curry_AbstractHaskell.C_TCons
  (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_basics cd cs)
  (Curry_Prelude.toCurryString "Func")) (Curry_Prelude.OP_Cons x1
  (Curry_Prelude.OP_Cons x2 Curry_Prelude.OP_List))

d_C_trRule :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> FlatCurry.Curry_Types.C_Rule -> Cover -> ConstStore
  -> C_IOES C_State Curry_AbstractHaskell.C_Rules
d_C_trRule x1 x2 x3 cd cs = case x3 of
  FlatCurry.Curry_Types.C_Rule x4 x5 -> d_OP_gt_plus_eq (d_C_isDetMode cd cs)
    (d_OP_trRule_dot_uscore_hash_lambda228 x5 x4 x1) cd cs
  FlatCurry.Curry_Types.C_External x6 -> d_OP_gt_plus_eq (d_C_isDetMode cd cs)
    (d_OP_trRule_dot_uscore_hash_lambda231 x2 x1) cd cs
  FlatCurry.Curry_Types.Choice_C_Rule d i l r -> narrow d i (d_C_trRule x1 x2 l
    cd cs) (d_C_trRule x1 x2 r cd cs)
  FlatCurry.Curry_Types.Choices_C_Rule d i xs -> narrows cs d i (\z ->
    d_C_trRule x1 x2 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Rule d c e -> guardCons d c (d_C_trRule x1 x2 e
    cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Rule d info -> failCons d (traceFail
    "TransFunctions.trRule" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransFunctions.trRule" (showCons x3))

nd_C_trRule :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> FlatCurry.Curry_Types.C_Rule -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_Rules
nd_C_trRule x1 x2 x3 s cd cs = case x3 of
  FlatCurry.Curry_Types.C_Rule x4 x5 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_isDetMode s0 cd cs) (wrapNX id
    (nd_OP_trRule_dot_uscore_hash_lambda228 x5 x4 x1)) s1 cd cs))
  FlatCurry.Curry_Types.C_External x6 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_isDetMode s0 cd cs) (wrapNX id
    (nd_OP_trRule_dot_uscore_hash_lambda231 x2 x1)) s1 cd cs))
  FlatCurry.Curry_Types.Choice_C_Rule d i l r -> narrow d i (nd_C_trRule x1 x2 l
    s cd cs) (nd_C_trRule x1 x2 r s cd cs)
  FlatCurry.Curry_Types.Choices_C_Rule d i xs -> narrows cs d i (\z ->
    nd_C_trRule x1 x2 z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Rule d c e -> guardCons d c (nd_C_trRule x1 x2 e
    s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Rule d info -> failCons d (traceFail
    "TransFunctions.trRule" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransFunctions.trRule" (showCons x3))

d_OP_trRule_dot_uscore_hash_lambda228 :: FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> C_IOES
  C_State Curry_AbstractHaskell.C_Rules
d_OP_trRule_dot_uscore_hash_lambda228 x1 x2 x3 x4 cd cs = d_OP_gt_plus_eq
  (d_C_isTraceFailure cd cs)
  (d_OP_trRule_dot_uscore_hash_lambda228_dot_uscore_hash_lambda229 x1 x4 x2 x3)
  cd cs

nd_OP_trRule_dot_uscore_hash_lambda228 :: FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_Rules
nd_OP_trRule_dot_uscore_hash_lambda228 x1 x2 x3 x4 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_isTraceFailure s0 cd cs) (wrapNX
  id (nd_OP_trRule_dot_uscore_hash_lambda228_dot_uscore_hash_lambda229 x1 x4 x2
  x3)) s1 cd cs))

d_OP_trRule_dot_uscore_hash_lambda228_dot_uscore_hash_lambda229 :: FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.C_Bool -> Curry_Prelude.OP_List Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_Rules
d_OP_trRule_dot_uscore_hash_lambda228_dot_uscore_hash_lambda229 x1 x2 x3 x4 x5 cd cs =
  d_OP_gt_plus_eq (d_C_trBody x4 x3 x1 cd cs)
  (d_OP_trRule_dot_uscore_hash_lambda228_dot_uscore_hash_lambda229_dot_uscore_hash_lambda230
  x2 x5 x3 x4) cd cs

nd_OP_trRule_dot_uscore_hash_lambda228_dot_uscore_hash_lambda229 :: FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.C_Bool -> Curry_Prelude.OP_List Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State
  Curry_AbstractHaskell.C_Rules
nd_OP_trRule_dot_uscore_hash_lambda228_dot_uscore_hash_lambda229 x1 x2 x3 x4 x5 s cd cs =
  let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_trBody x4 x3 x1 s0 cd cs) (wrapNX
  id
  (nd_OP_trRule_dot_uscore_hash_lambda228_dot_uscore_hash_lambda229_dot_uscore_hash_lambda230
  x2 x5 x3 x4)) s1 cd cs))

d_OP_trRule_dot_uscore_hash_lambda228_dot_uscore_hash_lambda229_dot_uscore_hash_lambda230 :: Curry_Prelude.C_Bool
  -> Curry_Prelude.C_Bool -> Curry_Prelude.OP_List Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_AbstractHaskell.C_Expr
  -> Cover -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_Rules
d_OP_trRule_dot_uscore_hash_lambda228_dot_uscore_hash_lambda229_dot_uscore_hash_lambda230 x1 x2 x3 x4 x5 cd cs =
  let x6 = Curry_Prelude.d_OP_plus_plus (Curry_Prelude.d_C_map d_C_cvVarIndex x3
        cd cs) (Curry_Prelude.d_OP_plus_plus (d_C__case_164 x1
        (Curry_Prelude.d_C_not x1 cd cs) cd cs) (Curry_Prelude.OP_Cons
        (d_C_coverName cd cs) (Curry_Prelude.OP_Cons (d_C_constStoreName cd cs)
        Curry_Prelude.OP_List)) cd cs) cd cs
      x7 = d_C__case_163 x5 x3 x4 x2 cd cs
  in Curry_Prelude.d_OP_dollar d_C_returnM
  (Curry_AbstractHaskellGoodies.d_C_simpleRule (Curry_Prelude.d_C_map (acceptCs
  id Curry_AbstractHaskell.C_PVar) x6 cd cs) x7 cd cs) cd cs

nd_OP_trRule_dot_uscore_hash_lambda228_dot_uscore_hash_lambda229_dot_uscore_hash_lambda230 :: Curry_Prelude.C_Bool
  -> Curry_Prelude.C_Bool -> Curry_Prelude.OP_List Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_AbstractHaskell.C_Expr
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State
  Curry_AbstractHaskell.C_Rules
nd_OP_trRule_dot_uscore_hash_lambda228_dot_uscore_hash_lambda229_dot_uscore_hash_lambda230 x1 x2 x3 x4 x5 s cd cs =
  let s4 = s
  in s4 `seq` (let s0 = leftSupply s4
                   s3 = rightSupply s4
  in s0 `seq` (s3 `seq` (let x6 = Curry_Prelude.d_OP_plus_plus
                               (Curry_Prelude.nd_C_map (wrapDX id
                               d_C_cvVarIndex) x3 s0 cd cs)
                               (Curry_Prelude.d_OP_plus_plus (d_C__case_164 x1
                               (Curry_Prelude.d_C_not x1 cd cs) cd cs)
                               (Curry_Prelude.OP_Cons (d_C_coverName cd cs)
                               (Curry_Prelude.OP_Cons (d_C_constStoreName cd cs)
                               Curry_Prelude.OP_List)) cd cs) cd cs
                             x7 = d_C__case_163 x5 x3 x4 x2 cd cs
  in let s2 = leftSupply s3
         s1 = rightSupply s3
  in s2 `seq` (s1 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id nd_C_returnM)
  (Curry_AbstractHaskellGoodies.d_C_simpleRule (Curry_Prelude.nd_C_map (wrapDX
  id (acceptCs id Curry_AbstractHaskell.C_PVar)) x6 s1 cd cs) x7 cd cs) s2 cd
  cs))))

d_OP_trRule_dot_uscore_hash_lambda231 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_Rules
d_OP_trRule_dot_uscore_hash_lambda231 x1 x2 x3 cd cs = d_OP_gt_plus_eq
  (d_C_isTraceFailure cd cs)
  (d_OP_trRule_dot_uscore_hash_lambda231_dot_uscore_hash_lambda232 x3 x1 x2) cd
  cs

nd_OP_trRule_dot_uscore_hash_lambda231 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State
  Curry_AbstractHaskell.C_Rules
nd_OP_trRule_dot_uscore_hash_lambda231 x1 x2 x3 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_isTraceFailure s0 cd cs) (wrapNX
  id (nd_OP_trRule_dot_uscore_hash_lambda231_dot_uscore_hash_lambda232 x3 x1
  x2)) s1 cd cs))

d_OP_trRule_dot_uscore_hash_lambda231_dot_uscore_hash_lambda232 :: Curry_Prelude.C_Bool
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> C_IOES C_State
  Curry_AbstractHaskell.C_Rules
d_OP_trRule_dot_uscore_hash_lambda231_dot_uscore_hash_lambda232 x1 x2 x3 x4 cd cs =
  let x5 = Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
        (Curry_Prelude.d_OP_uscore_impl_hash_enumFromTo_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
        cd cs) (Curry_Prelude.C_Int (1)) cd cs) x2 cd cs
      x6 = Curry_Prelude.d_OP_plus_plus (Curry_Prelude.d_C_map d_C_cvVarIndex x5
        cd cs) (Curry_Prelude.d_OP_plus_plus (d_C__case_162 x1
        (Curry_Prelude.d_C_not x1 cd cs) cd cs) (Curry_Prelude.OP_Cons
        (d_C_coverName cd cs) (Curry_Prelude.OP_Cons (d_C_constStoreName cd cs)
        Curry_Prelude.OP_List)) cd cs) cd cs
      x7 = Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (d_C_funcCall cd cs)
        (Curry_Prelude.d_C_apply (Curry_Names.d_C_externalFunc cd cs) x3 cd cs)
        cd cs) (Curry_Prelude.d_C_map (acceptCs id Curry_AbstractHaskell.C_Var)
        x6 cd cs) cd cs
      x8 = d_C__case_161 x7 x5 x3 x4 cd cs
  in Curry_Prelude.d_OP_dollar d_C_returnM
  (Curry_AbstractHaskellGoodies.d_C_simpleRule (Curry_Prelude.d_C_map (acceptCs
  id Curry_AbstractHaskell.C_PVar) x6 cd cs) x8 cd cs) cd cs

nd_OP_trRule_dot_uscore_hash_lambda231_dot_uscore_hash_lambda232 :: Curry_Prelude.C_Bool
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore -> C_IOES C_State
  Curry_AbstractHaskell.C_Rules
nd_OP_trRule_dot_uscore_hash_lambda231_dot_uscore_hash_lambda232 x1 x2 x3 x4 s cd cs =
  let s14 = s
  in s14 `seq` (let s15 = leftSupply s14
                    s16 = rightSupply s14
                    s2 = leftSupply s15
                    s3 = rightSupply s15
                    s9 = leftSupply s16
                    s13 = rightSupply s16
  in s15 `seq` (s16 `seq` (s2 `seq` (s3 `seq` (s9 `seq` (s13 `seq`
  (let x5 = let s1 = leftSupply s2
                s0 = rightSupply s2
         in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply
         (Curry_Prelude.nd_C_apply (wrapDX (wrapDX id)
         (Curry_Prelude.d_OP_uscore_impl_hash_enumFromTo_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
         cd cs)) (Curry_Prelude.C_Int (1)) s0 cd cs) x2 s1 cd cs)
       x6 = Curry_Prelude.d_OP_plus_plus (Curry_Prelude.nd_C_map (wrapDX id
         d_C_cvVarIndex) x5 s3 cd cs) (Curry_Prelude.d_OP_plus_plus
         (d_C__case_162 x1 (Curry_Prelude.d_C_not x1 cd cs) cd cs)
         (Curry_Prelude.OP_Cons (d_C_coverName cd cs) (Curry_Prelude.OP_Cons
         (d_C_constStoreName cd cs) Curry_Prelude.OP_List)) cd cs) cd cs
       x7 = let s8 = leftSupply s9
                s10 = rightSupply s9
                s6 = leftSupply s10
                s7 = rightSupply s10
         in s8 `seq` (s10 `seq` (s6 `seq` (s7 `seq` Curry_Prelude.nd_C_apply
         (let s5 = leftSupply s6
              s4 = rightSupply s6
         in s5 `seq` (s4 `seq` Curry_Prelude.nd_C_apply (wrapDX (wrapDX id)
         (d_C_funcCall cd cs)) (Curry_Prelude.nd_C_apply (wrapDX id
         (Curry_Names.d_C_externalFunc cd cs)) x3 s4 cd cs) s5 cd cs))
         (Curry_Prelude.nd_C_map (wrapDX id (acceptCs id
         Curry_AbstractHaskell.C_Var)) x6 s7 cd cs) s8 cd cs)))
       x8 = d_C__case_161 x7 x5 x3 x4 cd cs
  in let s12 = leftSupply s13
         s11 = rightSupply s13
  in s12 `seq` (s11 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id nd_C_returnM)
  (Curry_AbstractHaskellGoodies.d_C_simpleRule (Curry_Prelude.nd_C_map (wrapDX
  id (acceptCs id Curry_AbstractHaskell.C_PVar)) x6 s11 cd cs) x8 cd cs) s12 cd
  cs))))))))

d_C_trBody :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> FlatCurry.Curry_Types.C_Expr
  -> Cover -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_Expr
d_C_trBody x1 x2 x3 cd cs = let x4 = d_C_trCompleteExpr x3 cd cs
  in d_C__case_160 x4 x1 x2 x3 cd cs

nd_C_trBody :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> FlatCurry.Curry_Types.C_Expr
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State
  Curry_AbstractHaskell.C_Expr
nd_C_trBody x1 x2 x3 s cd cs = let s2 = s
  in s2 `seq` (let s0 = leftSupply s2
                   s1 = rightSupply s2
  in s0 `seq` (s1 `seq` (let x4 = nd_C_trCompleteExpr x3 s0 cd cs
  in nd_C__case_160 x4 x1 x2 x3 s1 cd cs)))

d_OP_trBody_dot_uscore_hash_lambda234 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_BranchExpr
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_Expr
d_OP_trBody_dot_uscore_hash_lambda234 x1 x2 x3 x4 x5 cd cs = d_OP_gt_plus_eq
  (d_C_mapM d_C_trBranch x2 cd cs)
  (d_OP_trBody_dot_uscore_hash_lambda234_dot_uscore_hash_lambda235 x1 x3 x4 x5)
  cd cs

nd_OP_trBody_dot_uscore_hash_lambda234 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_BranchExpr
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply
  -> Cover -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_Expr
nd_OP_trBody_dot_uscore_hash_lambda234 x1 x2 x3 x4 x5 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_mapM (wrapNX id nd_C_trBranch) x2
  s0 cd cs) (wrapNX id
  (nd_OP_trBody_dot_uscore_hash_lambda234_dot_uscore_hash_lambda235 x1 x3 x4
  x5)) s1 cd cs))

d_OP_trBody_dot_uscore_hash_lambda234_dot_uscore_hash_lambda235 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_BranchExpr -> Cover
  -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_Expr
d_OP_trBody_dot_uscore_hash_lambda234_dot_uscore_hash_lambda235 x1 x2 x3 x4 x5 cd cs =
  let x6 = d_C_litBranches x5 cd cs
  in d_OP_gt_plus_eq (d_C_consBranches x3 x2 x1 x4 cd cs)
  (d_OP_trBody_dot_uscore_hash_lambda234_dot_uscore_hash_lambda235_dot_uscore_hash_lambda236
  x1 x5 x6) cd cs

nd_OP_trBody_dot_uscore_hash_lambda234_dot_uscore_hash_lambda235 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_BranchExpr -> IDSupply
  -> Cover -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_Expr
nd_OP_trBody_dot_uscore_hash_lambda234_dot_uscore_hash_lambda235 x1 x2 x3 x4 x5 s cd cs =
  let s2 = s
  in s2 `seq` (let x6 = d_C_litBranches x5 cd cs
  in let s1 = leftSupply s2
         s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_consBranches x3 x2 x1 x4 s0 cd
  cs) (wrapNX id
  (nd_OP_trBody_dot_uscore_hash_lambda234_dot_uscore_hash_lambda235_dot_uscore_hash_lambda236
  x1 x5 x6)) s1 cd cs))

d_OP_trBody_dot_uscore_hash_lambda234_dot_uscore_hash_lambda235_dot_uscore_hash_lambda236 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_BranchExpr
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_BranchExpr
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_BranchExpr -> Cover
  -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_Expr
d_OP_trBody_dot_uscore_hash_lambda234_dot_uscore_hash_lambda235_dot_uscore_hash_lambda236 x1 x2 x3 x4 cd cs =
  Curry_Prelude.d_OP_dollar d_C_returnM (Curry_AbstractHaskell.C_Case
  (Curry_Prelude.d_C_apply (d_C_cvVar cd cs) x1 cd cs)
  (Curry_Prelude.d_OP_plus_plus x2 (Curry_Prelude.d_OP_plus_plus x3 x4 cd cs) cd
  cs)) cd cs

nd_OP_trBody_dot_uscore_hash_lambda234_dot_uscore_hash_lambda235_dot_uscore_hash_lambda236 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_BranchExpr
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_BranchExpr
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_BranchExpr -> IDSupply
  -> Cover -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_Expr
nd_OP_trBody_dot_uscore_hash_lambda234_dot_uscore_hash_lambda235_dot_uscore_hash_lambda236 x1 x2 x3 x4 s cd cs =
  let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id nd_C_returnM)
  (Curry_AbstractHaskell.C_Case (Curry_Prelude.nd_C_apply (wrapDX id (d_C_cvVar
  cd cs)) x1 s0 cd cs) (Curry_Prelude.d_OP_plus_plus x2
  (Curry_Prelude.d_OP_plus_plus x3 x4 cd cs) cd cs)) s1 cd cs))

d_C_getMatchedType :: FlatCurry.Curry_Types.C_BranchExpr -> Cover -> ConstStore
  -> C_IOES C_State (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_getMatchedType x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_Branch x2 x3 -> d_C__case_158 x2 cd cs
  FlatCurry.Curry_Types.Choice_C_BranchExpr d i l r -> narrow d i
    (d_C_getMatchedType l cd cs) (d_C_getMatchedType r cd cs)
  FlatCurry.Curry_Types.Choices_C_BranchExpr d i xs -> narrows cs d i (\z ->
    d_C_getMatchedType z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_BranchExpr d c e -> guardCons d c
    (d_C_getMatchedType e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_BranchExpr d info -> failCons d (traceFail
    "TransFunctions.getMatchedType" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.getMatchedType" (showCons x1))

nd_C_getMatchedType :: FlatCurry.Curry_Types.C_BranchExpr -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
nd_C_getMatchedType x1 s cd cs = case x1 of
  FlatCurry.Curry_Types.C_Branch x2 x3 -> let s0 = s
    in s0 `seq` nd_C__case_158 x2 s0 cd cs
  FlatCurry.Curry_Types.Choice_C_BranchExpr d i l r -> narrow d i
    (nd_C_getMatchedType l s cd cs) (nd_C_getMatchedType r s cd cs)
  FlatCurry.Curry_Types.Choices_C_BranchExpr d i xs -> narrows cs d i (\z ->
    nd_C_getMatchedType z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_BranchExpr d c e -> guardCons d c
    (nd_C_getMatchedType e s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_BranchExpr d info -> failCons d (traceFail
    "TransFunctions.getMatchedType" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.getMatchedType" (showCons x1))

d_C_trBranch :: FlatCurry.Curry_Types.C_BranchExpr -> Cover -> ConstStore
  -> C_IOES C_State Curry_AbstractHaskell.C_BranchExpr
d_C_trBranch x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_Branch x2 x3 -> d_C_liftM2 (acceptCs (acceptCs id)
    Curry_AbstractHaskell.C_Branch) (d_C_trPattern x2 cd cs) (d_C_trCompleteExpr
    x3 cd cs) cd cs
  FlatCurry.Curry_Types.Choice_C_BranchExpr d i l r -> narrow d i (d_C_trBranch
    l cd cs) (d_C_trBranch r cd cs)
  FlatCurry.Curry_Types.Choices_C_BranchExpr d i xs -> narrows cs d i (\z ->
    d_C_trBranch z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_BranchExpr d c e -> guardCons d c (d_C_trBranch
    e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_BranchExpr d info -> failCons d (traceFail
    "TransFunctions.trBranch" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.trBranch" (showCons x1))

nd_C_trBranch :: FlatCurry.Curry_Types.C_BranchExpr -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_BranchExpr
nd_C_trBranch x1 s cd cs = case x1 of
  FlatCurry.Curry_Types.C_Branch x2 x3 -> let s3 = s
    in s3 `seq` (let s2 = leftSupply s3
                     s4 = rightSupply s3
                     s0 = leftSupply s4
                     s1 = rightSupply s4
    in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` nd_C_liftM2 (wrapDX (wrapDX id)
    (acceptCs (acceptCs id) Curry_AbstractHaskell.C_Branch)) (nd_C_trPattern x2
    s0 cd cs) (nd_C_trCompleteExpr x3 s1 cd cs) s2 cd cs))))
  FlatCurry.Curry_Types.Choice_C_BranchExpr d i l r -> narrow d i (nd_C_trBranch
    l s cd cs) (nd_C_trBranch r s cd cs)
  FlatCurry.Curry_Types.Choices_C_BranchExpr d i xs -> narrows cs d i (\z ->
    nd_C_trBranch z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_BranchExpr d c e -> guardCons d c (nd_C_trBranch
    e s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_BranchExpr d info -> failCons d (traceFail
    "TransFunctions.trBranch" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.trBranch" (showCons x1))

d_C_trPattern :: FlatCurry.Curry_Types.C_Pattern -> Cover -> ConstStore
  -> C_IOES C_State Curry_AbstractHaskell.C_Pattern
d_C_trPattern x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_Pattern x2 x3 -> d_OP_gt_plus_eq (d_C_renameCons x2 cd
    cs) (d_OP_trPattern_dot_uscore_hash_lambda238 x3) cd cs
  FlatCurry.Curry_Types.C_LPattern x4 -> Curry_Prelude.d_OP_dollar d_C_returnM
    (Curry_Prelude.d_OP_dollar (acceptCs id Curry_AbstractHaskell.C_PLit)
    (d_C_cvLit x4 cd cs) cd cs) cd cs
  FlatCurry.Curry_Types.Choice_C_Pattern d i l r -> narrow d i (d_C_trPattern l
    cd cs) (d_C_trPattern r cd cs)
  FlatCurry.Curry_Types.Choices_C_Pattern d i xs -> narrows cs d i (\z ->
    d_C_trPattern z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Pattern d c e -> guardCons d c (d_C_trPattern e
    cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Pattern d info -> failCons d (traceFail
    "TransFunctions.trPattern" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.trPattern" (showCons x1))

nd_C_trPattern :: FlatCurry.Curry_Types.C_Pattern -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_Pattern
nd_C_trPattern x1 s cd cs = case x1 of
  FlatCurry.Curry_Types.C_Pattern x2 x3 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_renameCons x2 s0 cd cs) (wrapNX
    id (nd_OP_trPattern_dot_uscore_hash_lambda238 x3)) s1 cd cs))
  FlatCurry.Curry_Types.C_LPattern x4 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id nd_C_returnM)
    (Curry_Prelude.nd_OP_dollar (wrapDX id (acceptCs id
    Curry_AbstractHaskell.C_PLit)) (d_C_cvLit x4 cd cs) s0 cd cs) s1 cd cs))
  FlatCurry.Curry_Types.Choice_C_Pattern d i l r -> narrow d i (nd_C_trPattern l
    s cd cs) (nd_C_trPattern r s cd cs)
  FlatCurry.Curry_Types.Choices_C_Pattern d i xs -> narrows cs d i (\z ->
    nd_C_trPattern z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Pattern d c e -> guardCons d c (nd_C_trPattern e
    s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Pattern d info -> failCons d (traceFail
    "TransFunctions.trPattern" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.trPattern" (showCons x1))

d_OP_trPattern_dot_uscore_hash_lambda238 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_Pattern
d_OP_trPattern_dot_uscore_hash_lambda238 x1 x2 cd cs = Curry_Prelude.d_OP_dollar
  d_C_returnM (Curry_Prelude.d_OP_dollar (acceptCs id
  (Curry_AbstractHaskell.C_PComb x2)) (Curry_Prelude.d_C_map
  (Curry_Prelude.d_OP_dot (acceptCs id Curry_AbstractHaskell.C_PVar)
  d_C_cvVarIndex cd cs) x1 cd cs) cd cs) cd cs

nd_OP_trPattern_dot_uscore_hash_lambda238 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply
  -> Cover -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_Pattern
nd_OP_trPattern_dot_uscore_hash_lambda238 x1 x2 s cd cs = let s6 = s
  in s6 `seq` (let s5 = leftSupply s6
                   s4 = rightSupply s6
  in s5 `seq` (s4 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id nd_C_returnM)
  (let s3 = leftSupply s4
       s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dollar (wrapDX id (acceptCs id
  (Curry_AbstractHaskell.C_PComb x2))) (let s1 = leftSupply s2
                                            s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_map (Curry_Prelude.nd_OP_dot (wrapDX
  id (acceptCs id Curry_AbstractHaskell.C_PVar)) (wrapDX id d_C_cvVarIndex) s0
  cd cs) x1 s1 cd cs)) s3 cd cs)) s5 cd cs))

d_C_litBranches :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_BranchExpr
  -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_BranchExpr
d_C_litBranches x1 cd cs = let x2 = Curry_Prelude.d_C_foldr (acceptCs id
                                 d_OP_litBranches_dot_uscore_hash_lambda241)
                                 Curry_Prelude.OP_List x1 cd cs
                               x3 = Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int
                                 (5000)) (Curry_Prelude.toCurryString "l")
  in d_C__case_156 x3 x2 cd cs

d_OP_litBranches_dot_uscore_hash_lambda241 :: Curry_AbstractHaskell.C_BranchExpr
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_AbstractHaskell.C_Literal Curry_AbstractHaskell.C_Expr) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_AbstractHaskell.C_Literal Curry_AbstractHaskell.C_Expr)
d_OP_litBranches_dot_uscore_hash_lambda241 x1 x2 cd cs = case x1 of
  Curry_AbstractHaskell.C_Branch x3 x4 -> d_C__case_153 x2 x4 x3 cd cs
  Curry_AbstractHaskell.Choice_C_BranchExpr d i l r -> narrow d i
    (d_OP_litBranches_dot_uscore_hash_lambda241 l x2 cd cs)
    (d_OP_litBranches_dot_uscore_hash_lambda241 r x2 cd cs)
  Curry_AbstractHaskell.Choices_C_BranchExpr d i xs -> narrows cs d i (\z ->
    d_OP_litBranches_dot_uscore_hash_lambda241 z x2 cd cs) xs
  Curry_AbstractHaskell.Guard_C_BranchExpr d c e -> guardCons d c
    (d_OP_litBranches_dot_uscore_hash_lambda241 e x2 cd $! addCs c cs)
  Curry_AbstractHaskell.Fail_C_BranchExpr d info -> failCons d (traceFail
    "TransFunctions.litBranches._#lambda241" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.litBranches._#lambda241" (showCons
    x1))

d_OP_litBranches_dot_mkBranch_dot_397 :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_AbstractHaskell.C_Literal
  Curry_AbstractHaskell.C_Expr) -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_BranchExpr
d_OP_litBranches_dot_mkBranch_dot_397 x1 x2 x3 x4 cd cs =
  Curry_Prelude.d_OP_dollar (acceptCs id (Curry_AbstractHaskell.C_Branch
  (Curry_AbstractHaskell.C_PComb x3 (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x2) Curry_Prelude.OP_List))))
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (d_C_funcCall cd cs) x4 cd
  cs) (Curry_Prelude.OP_Cons (Curry_Prelude.d_OP_dollar
  Curry_AbstractHaskellGoodies.d_C_list2ac (Curry_Prelude.d_OP_dollar
  (Curry_Prelude.d_C_map d_C_pair2ac) (Curry_Prelude.d_C_map
  (Curry_Function.d_C_first (acceptCs id Curry_AbstractHaskell.C_Lit)) x1 cd cs)
  cd cs) cd cs) (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x2)
  (Curry_Prelude.OP_Cons (d_C_coverVar cd cs) (Curry_Prelude.OP_Cons
  (d_C_constStoreVar cd cs) Curry_Prelude.OP_List)))) cd cs) cd cs

d_C_consBranches :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore -> C_IOES
  C_State (Curry_Prelude.OP_List Curry_AbstractHaskell.C_BranchExpr)
d_C_consBranches x1 x2 x3 x4 cd cs = let x5 = Curry_Prelude.d_C_apply
                                           (d_C_newVars cd cs)
                                           (Curry_Prelude.OP_Cons
                                           (Curry_Prelude.toCurryString "d")
                                           (Curry_Prelude.OP_Cons
                                           (Curry_Prelude.toCurryString "i")
                                           (Curry_Prelude.OP_Cons
                                           (Curry_Prelude.toCurryString "l")
                                           (Curry_Prelude.OP_Cons
                                           (Curry_Prelude.toCurryString "r")
                                           (Curry_Prelude.OP_Cons
                                           (Curry_Prelude.toCurryString "xs")
                                           (Curry_Prelude.OP_Cons
                                           (Curry_Prelude.toCurryString "z")
                                           (Curry_Prelude.OP_Cons
                                           (Curry_Prelude.toCurryString "c")
                                           (Curry_Prelude.OP_Cons
                                           (Curry_Prelude.toCurryString "e")
                                           (Curry_Prelude.OP_Cons
                                           (Curry_Prelude.toCurryString "info")
                                           (Curry_Prelude.OP_Cons
                                           (Curry_Prelude.toCurryString "_")
                                           Curry_Prelude.OP_List)))))))))) cd cs
                                         x6 = d_OP_consBranches_dot_uscore_hash_selFP5_hash_d
                                           x5 cd cs
                                         x7 = d_OP_consBranches_dot_uscore_hash_selFP6_hash_i
                                           x5 cd cs
                                         x8 = d_OP_consBranches_dot_uscore_hash_selFP7_hash_l
                                           x5 cd cs
                                         x9 = d_OP_consBranches_dot_uscore_hash_selFP8_hash_r
                                           x5 cd cs
                                         x10 = d_OP_consBranches_dot_uscore_hash_selFP9_hash_xs
                                           x5 cd cs
                                         x11 = d_OP_consBranches_dot_uscore_hash_selFP10_hash_z
                                           x5 cd cs
                                         x12 = d_OP_consBranches_dot_uscore_hash_selFP11_hash_c
                                           x5 cd cs
                                         x13 = d_OP_consBranches_dot_uscore_hash_selFP12_hash_e
                                           x5 cd cs
                                         x14 = d_OP_consBranches_dot_uscore_hash_selFP13_hash_info
                                           x5 cd cs
                                         x15 = d_OP_consBranches_dot_uscore_hash_selFP14_hash_us
                                           x5 cd cs
  in d_OP_gt_plus_eq (d_C_isDetMode cd cs)
  (d_OP_consBranches_dot_uscore_hash_lambda244 x3 x2 x12 x6 x13 x7 x14 x8 x9 x15
  x10 x11 x1 x4) cd cs

nd_C_consBranches :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_BranchExpr)
nd_C_consBranches x1 x2 x3 x4 s cd cs = let s4 = s
  in s4 `seq` (let s0 = leftSupply s4
                   s3 = rightSupply s4
  in s0 `seq` (s3 `seq` (let x5 = Curry_Prelude.nd_C_apply (wrapDX id
                               (d_C_newVars cd cs)) (Curry_Prelude.OP_Cons
                               (Curry_Prelude.toCurryString "d")
                               (Curry_Prelude.OP_Cons
                               (Curry_Prelude.toCurryString "i")
                               (Curry_Prelude.OP_Cons
                               (Curry_Prelude.toCurryString "l")
                               (Curry_Prelude.OP_Cons
                               (Curry_Prelude.toCurryString "r")
                               (Curry_Prelude.OP_Cons
                               (Curry_Prelude.toCurryString "xs")
                               (Curry_Prelude.OP_Cons
                               (Curry_Prelude.toCurryString "z")
                               (Curry_Prelude.OP_Cons
                               (Curry_Prelude.toCurryString "c")
                               (Curry_Prelude.OP_Cons
                               (Curry_Prelude.toCurryString "e")
                               (Curry_Prelude.OP_Cons
                               (Curry_Prelude.toCurryString "info")
                               (Curry_Prelude.OP_Cons
                               (Curry_Prelude.toCurryString "_")
                               Curry_Prelude.OP_List)))))))))) s0 cd cs
                             x6 = d_OP_consBranches_dot_uscore_hash_selFP5_hash_d
                               x5 cd cs
                             x7 = d_OP_consBranches_dot_uscore_hash_selFP6_hash_i
                               x5 cd cs
                             x8 = d_OP_consBranches_dot_uscore_hash_selFP7_hash_l
                               x5 cd cs
                             x9 = d_OP_consBranches_dot_uscore_hash_selFP8_hash_r
                               x5 cd cs
                             x10 = d_OP_consBranches_dot_uscore_hash_selFP9_hash_xs
                               x5 cd cs
                             x11 = d_OP_consBranches_dot_uscore_hash_selFP10_hash_z
                               x5 cd cs
                             x12 = d_OP_consBranches_dot_uscore_hash_selFP11_hash_c
                               x5 cd cs
                             x13 = d_OP_consBranches_dot_uscore_hash_selFP12_hash_e
                               x5 cd cs
                             x14 = d_OP_consBranches_dot_uscore_hash_selFP13_hash_info
                               x5 cd cs
                             x15 = d_OP_consBranches_dot_uscore_hash_selFP14_hash_us
                               x5 cd cs
  in let s2 = leftSupply s3
         s1 = rightSupply s3
  in s2 `seq` (s1 `seq` nd_OP_gt_plus_eq (nd_C_isDetMode s1 cd cs) (wrapNX id
  (nd_OP_consBranches_dot_uscore_hash_lambda244 x3 x2 x12 x6 x13 x7 x14 x8 x9
  x15 x10 x11 x1 x4)) s2 cd cs))))

d_OP_consBranches_dot_uscore_hash_selFP5_hash_d :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_consBranches_dot_uscore_hash_selFP5_hash_d x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_152 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_consBranches_dot_uscore_hash_selFP5_hash_d l cd cs)
    (d_OP_consBranches_dot_uscore_hash_selFP5_hash_d r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_consBranches_dot_uscore_hash_selFP5_hash_d z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_consBranches_dot_uscore_hash_selFP5_hash_d e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions.consBranches._#selFP5#d" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.consBranches._#selFP5#d" (showCons
    x1))

d_OP_consBranches_dot_uscore_hash_selFP6_hash_i :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_consBranches_dot_uscore_hash_selFP6_hash_i x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_142 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_consBranches_dot_uscore_hash_selFP6_hash_i l cd cs)
    (d_OP_consBranches_dot_uscore_hash_selFP6_hash_i r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_consBranches_dot_uscore_hash_selFP6_hash_i z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_consBranches_dot_uscore_hash_selFP6_hash_i e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions.consBranches._#selFP6#i" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.consBranches._#selFP6#i" (showCons
    x1))

d_OP_consBranches_dot_uscore_hash_selFP7_hash_l :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_consBranches_dot_uscore_hash_selFP7_hash_l x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_132 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_consBranches_dot_uscore_hash_selFP7_hash_l l cd cs)
    (d_OP_consBranches_dot_uscore_hash_selFP7_hash_l r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_consBranches_dot_uscore_hash_selFP7_hash_l z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_consBranches_dot_uscore_hash_selFP7_hash_l e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions.consBranches._#selFP7#l" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.consBranches._#selFP7#l" (showCons
    x1))

d_OP_consBranches_dot_uscore_hash_selFP8_hash_r :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_consBranches_dot_uscore_hash_selFP8_hash_r x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_122 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_consBranches_dot_uscore_hash_selFP8_hash_r l cd cs)
    (d_OP_consBranches_dot_uscore_hash_selFP8_hash_r r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_consBranches_dot_uscore_hash_selFP8_hash_r z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_consBranches_dot_uscore_hash_selFP8_hash_r e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions.consBranches._#selFP8#r" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.consBranches._#selFP8#r" (showCons
    x1))

d_OP_consBranches_dot_uscore_hash_selFP9_hash_xs :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_consBranches_dot_uscore_hash_selFP9_hash_xs x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_112 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_consBranches_dot_uscore_hash_selFP9_hash_xs l cd cs)
    (d_OP_consBranches_dot_uscore_hash_selFP9_hash_xs r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_consBranches_dot_uscore_hash_selFP9_hash_xs z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_consBranches_dot_uscore_hash_selFP9_hash_xs e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions.consBranches._#selFP9#xs" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.consBranches._#selFP9#xs" (showCons
    x1))

d_OP_consBranches_dot_uscore_hash_selFP10_hash_z :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_consBranches_dot_uscore_hash_selFP10_hash_z x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_102 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_consBranches_dot_uscore_hash_selFP10_hash_z l cd cs)
    (d_OP_consBranches_dot_uscore_hash_selFP10_hash_z r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_consBranches_dot_uscore_hash_selFP10_hash_z z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_consBranches_dot_uscore_hash_selFP10_hash_z e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions.consBranches._#selFP10#z" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.consBranches._#selFP10#z" (showCons
    x1))

d_OP_consBranches_dot_uscore_hash_selFP11_hash_c :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_consBranches_dot_uscore_hash_selFP11_hash_c x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_92 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_consBranches_dot_uscore_hash_selFP11_hash_c l cd cs)
    (d_OP_consBranches_dot_uscore_hash_selFP11_hash_c r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_consBranches_dot_uscore_hash_selFP11_hash_c z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_consBranches_dot_uscore_hash_selFP11_hash_c e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions.consBranches._#selFP11#c" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.consBranches._#selFP11#c" (showCons
    x1))

d_OP_consBranches_dot_uscore_hash_selFP12_hash_e :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_consBranches_dot_uscore_hash_selFP12_hash_e x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_82 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_consBranches_dot_uscore_hash_selFP12_hash_e l cd cs)
    (d_OP_consBranches_dot_uscore_hash_selFP12_hash_e r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_consBranches_dot_uscore_hash_selFP12_hash_e z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_consBranches_dot_uscore_hash_selFP12_hash_e e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions.consBranches._#selFP12#e" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.consBranches._#selFP12#e" (showCons
    x1))

d_OP_consBranches_dot_uscore_hash_selFP13_hash_info :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_consBranches_dot_uscore_hash_selFP13_hash_info x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_72 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_consBranches_dot_uscore_hash_selFP13_hash_info l cd cs)
    (d_OP_consBranches_dot_uscore_hash_selFP13_hash_info r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_consBranches_dot_uscore_hash_selFP13_hash_info z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_consBranches_dot_uscore_hash_selFP13_hash_info e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions.consBranches._#selFP13#info" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.consBranches._#selFP13#info"
    (showCons x1))

d_OP_consBranches_dot_uscore_hash_selFP14_hash_us :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_consBranches_dot_uscore_hash_selFP14_hash_us x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_62 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_consBranches_dot_uscore_hash_selFP14_hash_us l cd cs)
    (d_OP_consBranches_dot_uscore_hash_selFP14_hash_us r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_consBranches_dot_uscore_hash_selFP14_hash_us z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_consBranches_dot_uscore_hash_selFP14_hash_us e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions.consBranches._#selFP14#us" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.consBranches._#selFP14#us"
    (showCons x1))

d_OP_consBranches_dot_uscore_hash_lambda244 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> C_IOES
  C_State (Curry_Prelude.OP_List Curry_AbstractHaskell.C_BranchExpr)
d_OP_consBranches_dot_uscore_hash_lambda244 x1 x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 x15 cd cs =
  d_OP_gt_plus_eq (d_C_isTraceFailure cd cs)
  (d_OP_consBranches_dot_uscore_hash_lambda244_dot_uscore_hash_lambda245 x15 x1
  x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14) cd cs

nd_OP_consBranches_dot_uscore_hash_lambda244 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_BranchExpr)
nd_OP_consBranches_dot_uscore_hash_lambda244 x1 x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 x15 s cd cs =
  let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_isTraceFailure s0 cd cs) (wrapNX
  id (nd_OP_consBranches_dot_uscore_hash_lambda244_dot_uscore_hash_lambda245 x15
  x1 x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14)) s1 cd cs))

d_OP_consBranches_dot_uscore_hash_lambda244_dot_uscore_hash_lambda245 :: Curry_Prelude.C_Bool
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_BranchExpr)
d_OP_consBranches_dot_uscore_hash_lambda244_dot_uscore_hash_lambda245 x1 x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 x15 x16 cd cs =
  let x17 = Curry_Prelude.d_C_apply (Curry_Prelude.d_C_break
        (Curry_Prelude.d_C_flip (acceptCs id
        Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int)
        x2) cd cs) x3 cd cs
      x18 = d_OP_consBranches_dot_uscore_hash_lambda244_dot_uscore_hash_lambda245_dot_uscore_hash_selFP3_hash_vs1
        x17 cd cs
      x19 = d_OP_consBranches_dot_uscore_hash_lambda244_dot_uscore_hash_lambda245_dot_uscore_hash_selFP4_hash_vs2
        x17 cd cs
      x20 = Curry_Prelude.d_C_map (d_C_cvVar cd cs) x18 cd cs
      x21 = Curry_Prelude.d_C_map (d_C_cvVar cd cs) x19 cd cs
      x22 = d_C__case_51 x1 (Curry_Prelude.d_C_not x1 cd cs) cd cs
      x23 = d_C_strictCall (Curry_Prelude.d_OP_dollar (Curry_Prelude.d_C_apply
        (d_C_funcCall cd cs) x14 cd cs) (Curry_Prelude.d_C_concat
        (Curry_Prelude.OP_Cons x20 (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Cons
        (Curry_AbstractHaskell.C_Var x6) x21) (Curry_Prelude.OP_Cons x22
        (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Cons (d_C_coverVar cd cs)
        Curry_Prelude.OP_List) Curry_Prelude.OP_List)))) cd cs) cd cs)
        (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (d_C_funcCall cd cs)
        (d_C_addCs cd cs) cd cs) (Curry_Prelude.OP_Cons
        (Curry_AbstractHaskell.C_Var x4) (Curry_Prelude.OP_Cons
        (d_C_constStoreVar cd cs) Curry_Prelude.OP_List)) cd cs) cd cs
      x24 = Curry_Prelude.d_OP_dollar (acceptCs id
        (Curry_AbstractHaskell.C_Lambda (Curry_Prelude.OP_Cons
        (Curry_AbstractHaskell.C_PVar x13) Curry_Prelude.OP_List)))
        (Curry_Prelude.d_OP_dollar (Curry_AbstractHaskellGoodies.d_C_applyF x14)
        (Curry_Prelude.d_C_concat (Curry_Prelude.OP_Cons x20
        (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Cons
        (Curry_AbstractHaskell.C_Var x13) x21) (Curry_Prelude.OP_Cons x22
        (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Cons (d_C_coverVar cd cs)
        (Curry_Prelude.OP_Cons (d_C_constStoreVar cd cs) Curry_Prelude.OP_List))
        Curry_Prelude.OP_List)))) cd cs) cd cs) cd cs
  in Curry_Prelude.d_OP_dollar d_C_returnM (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Branch (Curry_AbstractHaskell.C_PComb
  (Curry_Prelude.d_C_apply (Curry_Names.d_C_mkChoiceName cd cs) x15 cd cs)
  (Curry_Prelude.d_C_map (acceptCs id Curry_AbstractHaskell.C_PVar)
  (Curry_Prelude.OP_Cons x5 (Curry_Prelude.OP_Cons x7 (Curry_Prelude.OP_Cons x9
  (Curry_Prelude.OP_Cons x10 Curry_Prelude.OP_List)))) cd cs))
  (Curry_Prelude.d_C_apply (d_C_narrow cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x5) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x7) (Curry_Prelude.OP_Cons
  (d_OP_consBranches_dot_uscore_hash_lambda244_dot_uscore_hash_lambda245_dot_recCall_dot_421
  x22 x20 x21 x14 (Curry_AbstractHaskell.C_Var x9) cd cs) (Curry_Prelude.OP_Cons
  (d_OP_consBranches_dot_uscore_hash_lambda244_dot_uscore_hash_lambda245_dot_recCall_dot_421
  x22 x20 x21 x14 (Curry_AbstractHaskell.C_Var x10) cd cs)
  Curry_Prelude.OP_List)))) cd cs)) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Branch (Curry_AbstractHaskell.C_PComb
  (Curry_Prelude.d_C_apply (Curry_Names.d_C_mkChoicesName cd cs) x15 cd cs)
  (Curry_Prelude.d_C_map (acceptCs id Curry_AbstractHaskell.C_PVar)
  (Curry_Prelude.OP_Cons x5 (Curry_Prelude.OP_Cons x7 (Curry_Prelude.OP_Cons x12
  Curry_Prelude.OP_List))) cd cs)) (Curry_Prelude.d_C_apply (d_C_narrows cd cs)
  (Curry_Prelude.OP_Cons (d_C_constStoreVar cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x5) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x7) (Curry_Prelude.OP_Cons x24
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x12)
  Curry_Prelude.OP_List))))) cd cs)) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Branch (Curry_AbstractHaskell.C_PComb
  (Curry_Prelude.d_C_apply (Curry_Names.d_C_mkGuardName cd cs) x15 cd cs)
  (Curry_Prelude.d_C_map (acceptCs id Curry_AbstractHaskell.C_PVar)
  (Curry_Prelude.OP_Cons x5 (Curry_Prelude.OP_Cons x4 (Curry_Prelude.OP_Cons x6
  Curry_Prelude.OP_List))) cd cs)) (Curry_Prelude.d_C_apply (d_C_liftGuard cd
  cs) (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x5)
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x4) (Curry_Prelude.OP_Cons
  x23 Curry_Prelude.OP_List))) cd cs)) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Branch (Curry_AbstractHaskell.C_PComb
  (Curry_Prelude.d_C_apply (Curry_Names.d_C_mkFailName cd cs) x15 cd cs)
  (Curry_Prelude.d_C_map (acceptCs id Curry_AbstractHaskell.C_PVar)
  (Curry_Prelude.OP_Cons x5 (Curry_Prelude.OP_Cons x8 Curry_Prelude.OP_List)) cd
  cs)) (d_C__case_52 x8 x3 x14 x5 x16 cd cs)) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Branch (Curry_AbstractHaskell.C_PVar x11)
  (d_C_consFail x14 (Curry_Prelude.d_C_apply (d_C_cvVar cd cs) x2 cd cs) cd cs))
  Curry_Prelude.OP_List))))) cd cs

nd_OP_consBranches_dot_uscore_hash_lambda244_dot_uscore_hash_lambda245 :: Curry_Prelude.C_Bool
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_BranchExpr)
nd_OP_consBranches_dot_uscore_hash_lambda244_dot_uscore_hash_lambda245 x1 x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 x15 x16 s cd cs =
  let s40 = s
  in s40 `seq` (let s41 = leftSupply s40
                    s43 = rightSupply s40
                    s2 = leftSupply s41
                    s42 = rightSupply s41
                    s3 = leftSupply s42
                    s4 = rightSupply s42
                    s11 = leftSupply s43
                    s44 = rightSupply s43
                    s14 = leftSupply s44
                    s39 = rightSupply s44
  in s41 `seq` (s43 `seq` (s2 `seq` (s42 `seq` (s3 `seq` (s4 `seq` (s11 `seq`
  (s44 `seq` (s14 `seq` (s39 `seq` (let x17 = let s1 = leftSupply s2
                                                  s0 = rightSupply s2
                                          in s1 `seq` (s0 `seq`
                                          Curry_Prelude.nd_C_apply
                                          (Curry_Prelude.nd_C_break (wrapNX id
                                          (Curry_Prelude.nd_C_flip (wrapDX
                                          (wrapDX id) (acceptCs id
                                          Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int))
                                          x2)) s0 cd cs) x3 s1 cd cs)
                                        x18 = d_OP_consBranches_dot_uscore_hash_lambda244_dot_uscore_hash_lambda245_dot_uscore_hash_selFP3_hash_vs1
                                          x17 cd cs
                                        x19 = d_OP_consBranches_dot_uscore_hash_lambda244_dot_uscore_hash_lambda245_dot_uscore_hash_selFP4_hash_vs2
                                          x17 cd cs
                                        x20 = Curry_Prelude.nd_C_map (wrapDX id
                                          (d_C_cvVar cd cs)) x18 s3 cd cs
                                        x21 = Curry_Prelude.nd_C_map (wrapDX id
                                          (d_C_cvVar cd cs)) x19 s4 cd cs
                                        x22 = d_C__case_51 x1
                                          (Curry_Prelude.d_C_not x1 cd cs) cd cs
                                        x23 = let s7 = leftSupply s11
                                                  s10 = rightSupply s11
                                          in s7 `seq` (s10 `seq` d_C_strictCall
                                          (let s6 = leftSupply s7
                                               s5 = rightSupply s7
                                          in s6 `seq` (s5 `seq`
                                          Curry_Prelude.nd_OP_dollar
                                          (Curry_Prelude.nd_C_apply (wrapDX
                                          (wrapDX id) (d_C_funcCall cd cs)) x14
                                          s5 cd cs) (Curry_Prelude.d_C_concat
                                          (Curry_Prelude.OP_Cons x20
                                          (Curry_Prelude.OP_Cons
                                          (Curry_Prelude.OP_Cons
                                          (Curry_AbstractHaskell.C_Var x6) x21)
                                          (Curry_Prelude.OP_Cons x22
                                          (Curry_Prelude.OP_Cons
                                          (Curry_Prelude.OP_Cons (d_C_coverVar
                                          cd cs) Curry_Prelude.OP_List)
                                          Curry_Prelude.OP_List)))) cd cs) s6 cd
                                          cs)) (let s9 = leftSupply s10
                                                    s8 = rightSupply s10
                                          in s9 `seq` (s8 `seq`
                                          Curry_Prelude.nd_C_apply
                                          (Curry_Prelude.nd_C_apply (wrapDX
                                          (wrapDX id) (d_C_funcCall cd cs))
                                          (d_C_addCs cd cs) s8 cd cs)
                                          (Curry_Prelude.OP_Cons
                                          (Curry_AbstractHaskell.C_Var x4)
                                          (Curry_Prelude.OP_Cons
                                          (d_C_constStoreVar cd cs)
                                          Curry_Prelude.OP_List)) s9 cd cs)) cd
                                          cs)
                                        x24 = let s13 = leftSupply s14
                                                  s12 = rightSupply s14
                                          in s13 `seq` (s12 `seq`
                                          Curry_Prelude.nd_OP_dollar (wrapDX id
                                          (acceptCs id
                                          (Curry_AbstractHaskell.C_Lambda
                                          (Curry_Prelude.OP_Cons
                                          (Curry_AbstractHaskell.C_PVar x13)
                                          Curry_Prelude.OP_List))))
                                          (Curry_Prelude.nd_OP_dollar (wrapDX id
                                          (Curry_AbstractHaskellGoodies.d_C_applyF
                                          x14)) (Curry_Prelude.d_C_concat
                                          (Curry_Prelude.OP_Cons x20
                                          (Curry_Prelude.OP_Cons
                                          (Curry_Prelude.OP_Cons
                                          (Curry_AbstractHaskell.C_Var x13) x21)
                                          (Curry_Prelude.OP_Cons x22
                                          (Curry_Prelude.OP_Cons
                                          (Curry_Prelude.OP_Cons (d_C_coverVar
                                          cd cs) (Curry_Prelude.OP_Cons
                                          (d_C_constStoreVar cd cs)
                                          Curry_Prelude.OP_List))
                                          Curry_Prelude.OP_List)))) cd cs) s12
                                          cd cs) s13 cd cs)
  in let s38 = leftSupply s39
         s37 = rightSupply s39
  in s38 `seq` (s37 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id nd_C_returnM)
  (let s19 = leftSupply s37
       s36 = rightSupply s37
  in s19 `seq` (s36 `seq` Curry_Prelude.OP_Cons (let s17 = leftSupply s19
                                                     s18 = rightSupply s19
  in s17 `seq` (s18 `seq` Curry_AbstractHaskell.C_Branch (let s15 = leftSupply
                                                                s17
                                                              s16 = rightSupply
                                                                s17
  in s15 `seq` (s16 `seq` Curry_AbstractHaskell.C_PComb
  (Curry_Prelude.nd_C_apply (wrapDX id (Curry_Names.d_C_mkChoiceName cd cs)) x15
  s15 cd cs) (Curry_Prelude.nd_C_map (wrapDX id (acceptCs id
  Curry_AbstractHaskell.C_PVar)) (Curry_Prelude.OP_Cons x5
  (Curry_Prelude.OP_Cons x7 (Curry_Prelude.OP_Cons x9 (Curry_Prelude.OP_Cons x10
  Curry_Prelude.OP_List)))) s16 cd cs))) (Curry_Prelude.nd_C_apply (wrapDX id
  (d_C_narrow cd cs)) (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x5)
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x7) (Curry_Prelude.OP_Cons
  (d_OP_consBranches_dot_uscore_hash_lambda244_dot_uscore_hash_lambda245_dot_recCall_dot_421
  x22 x20 x21 x14 (Curry_AbstractHaskell.C_Var x9) cd cs) (Curry_Prelude.OP_Cons
  (d_OP_consBranches_dot_uscore_hash_lambda244_dot_uscore_hash_lambda245_dot_recCall_dot_421
  x22 x20 x21 x14 (Curry_AbstractHaskell.C_Var x10) cd cs)
  Curry_Prelude.OP_List)))) s18 cd cs))) (let s24 = leftSupply s36
                                              s35 = rightSupply s36
  in s24 `seq` (s35 `seq` Curry_Prelude.OP_Cons (let s22 = leftSupply s24
                                                     s23 = rightSupply s24
  in s22 `seq` (s23 `seq` Curry_AbstractHaskell.C_Branch (let s20 = leftSupply
                                                                s22
                                                              s21 = rightSupply
                                                                s22
  in s20 `seq` (s21 `seq` Curry_AbstractHaskell.C_PComb
  (Curry_Prelude.nd_C_apply (wrapDX id (Curry_Names.d_C_mkChoicesName cd cs))
  x15 s20 cd cs) (Curry_Prelude.nd_C_map (wrapDX id (acceptCs id
  Curry_AbstractHaskell.C_PVar)) (Curry_Prelude.OP_Cons x5
  (Curry_Prelude.OP_Cons x7 (Curry_Prelude.OP_Cons x12 Curry_Prelude.OP_List)))
  s21 cd cs))) (Curry_Prelude.nd_C_apply (wrapDX id (d_C_narrows cd cs))
  (Curry_Prelude.OP_Cons (d_C_constStoreVar cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x5) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x7) (Curry_Prelude.OP_Cons x24
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x12)
  Curry_Prelude.OP_List))))) s23 cd cs))) (let s29 = leftSupply s35
                                               s34 = rightSupply s35
  in s29 `seq` (s34 `seq` Curry_Prelude.OP_Cons (let s27 = leftSupply s29
                                                     s28 = rightSupply s29
  in s27 `seq` (s28 `seq` Curry_AbstractHaskell.C_Branch (let s25 = leftSupply
                                                                s27
                                                              s26 = rightSupply
                                                                s27
  in s25 `seq` (s26 `seq` Curry_AbstractHaskell.C_PComb
  (Curry_Prelude.nd_C_apply (wrapDX id (Curry_Names.d_C_mkGuardName cd cs)) x15
  s25 cd cs) (Curry_Prelude.nd_C_map (wrapDX id (acceptCs id
  Curry_AbstractHaskell.C_PVar)) (Curry_Prelude.OP_Cons x5
  (Curry_Prelude.OP_Cons x4 (Curry_Prelude.OP_Cons x6 Curry_Prelude.OP_List)))
  s26 cd cs))) (Curry_Prelude.nd_C_apply (wrapDX id (d_C_liftGuard cd cs))
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x5) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x4) (Curry_Prelude.OP_Cons x23
  Curry_Prelude.OP_List))) s28 cd cs))) (let s32 = leftSupply s34
                                             s33 = rightSupply s34
  in s32 `seq` (s33 `seq` Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Branch
  (let s30 = leftSupply s32
       s31 = rightSupply s32
  in s30 `seq` (s31 `seq` Curry_AbstractHaskell.C_PComb
  (Curry_Prelude.nd_C_apply (wrapDX id (Curry_Names.d_C_mkFailName cd cs)) x15
  s30 cd cs) (Curry_Prelude.nd_C_map (wrapDX id (acceptCs id
  Curry_AbstractHaskell.C_PVar)) (Curry_Prelude.OP_Cons x5
  (Curry_Prelude.OP_Cons x8 Curry_Prelude.OP_List)) s31 cd cs))) (d_C__case_52
  x8 x3 x14 x5 x16 cd cs)) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Branch (Curry_AbstractHaskell.C_PVar x11)
  (d_C_consFail x14 (Curry_Prelude.nd_C_apply (wrapDX id (d_C_cvVar cd cs)) x2
  s33 cd cs) cd cs)) Curry_Prelude.OP_List))))))))) s38 cd cs))))))))))))

d_OP_consBranches_dot_uscore_hash_lambda244_dot_uscore_hash_lambda245_dot_uscore_hash_selFP3_hash_vs1 :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Curry_Prelude.OP_List
  Curry_Prelude.C_Int) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int
d_OP_consBranches_dot_uscore_hash_lambda244_dot_uscore_hash_lambda245_dot_uscore_hash_selFP3_hash_vs1 x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> d_C__case_50 x2 x3 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_consBranches_dot_uscore_hash_lambda244_dot_uscore_hash_lambda245_dot_uscore_hash_selFP3_hash_vs1
    l cd cs)
    (d_OP_consBranches_dot_uscore_hash_lambda244_dot_uscore_hash_lambda245_dot_uscore_hash_selFP3_hash_vs1
    r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_consBranches_dot_uscore_hash_lambda244_dot_uscore_hash_lambda245_dot_uscore_hash_selFP3_hash_vs1
    z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_consBranches_dot_uscore_hash_lambda244_dot_uscore_hash_lambda245_dot_uscore_hash_selFP3_hash_vs1
    e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.consBranches._#lambda244._#lambda245._#selFP3#vs1" [show x1]
    info)
  _ -> failCons cd (consFail
    "TransFunctions.consBranches._#lambda244._#lambda245._#selFP3#vs1" (showCons
    x1))

d_OP_consBranches_dot_uscore_hash_lambda244_dot_uscore_hash_lambda245_dot_uscore_hash_selFP4_hash_vs2 :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Curry_Prelude.OP_List
  Curry_Prelude.C_Int) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int
d_OP_consBranches_dot_uscore_hash_lambda244_dot_uscore_hash_lambda245_dot_uscore_hash_selFP4_hash_vs2 x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> d_C__case_49 x3 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_consBranches_dot_uscore_hash_lambda244_dot_uscore_hash_lambda245_dot_uscore_hash_selFP4_hash_vs2
    l cd cs)
    (d_OP_consBranches_dot_uscore_hash_lambda244_dot_uscore_hash_lambda245_dot_uscore_hash_selFP4_hash_vs2
    r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_consBranches_dot_uscore_hash_lambda244_dot_uscore_hash_lambda245_dot_uscore_hash_selFP4_hash_vs2
    z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_consBranches_dot_uscore_hash_lambda244_dot_uscore_hash_lambda245_dot_uscore_hash_selFP4_hash_vs2
    e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.consBranches._#lambda244._#lambda245._#selFP4#vs2" [show x1]
    info)
  _ -> failCons cd (consFail
    "TransFunctions.consBranches._#lambda244._#lambda245._#selFP4#vs2" (showCons
    x1))

d_OP_consBranches_dot_uscore_hash_lambda244_dot_uscore_hash_lambda245_dot_recCall_dot_421 :: Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_OP_consBranches_dot_uscore_hash_lambda244_dot_uscore_hash_lambda245_dot_recCall_dot_421 x1 x2 x3 x4 x5 cd cs =
  Curry_Prelude.d_OP_dollar (Curry_Prelude.d_C_apply (d_C_funcCall cd cs) x4 cd
  cs) (Curry_Prelude.d_C_concat (Curry_Prelude.OP_Cons x2 (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Cons x5 x3) (Curry_Prelude.OP_Cons x1 (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Cons (d_C_coverVar cd cs) (Curry_Prelude.OP_Cons
  (d_C_constStoreVar cd cs) Curry_Prelude.OP_List)) Curry_Prelude.OP_List)))) cd
  cs) cd cs

d_C_trCompleteExpr :: FlatCurry.Curry_Types.C_Expr -> Cover -> ConstStore
  -> C_IOES C_State Curry_AbstractHaskell.C_Expr
d_C_trCompleteExpr x1 cd cs = d_OP_gt_plus_eq (d_C_getNextID cd cs)
  (d_OP_trCompleteExpr_dot_uscore_hash_lambda246 x1) cd cs

nd_C_trCompleteExpr :: FlatCurry.Curry_Types.C_Expr -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_Expr
nd_C_trCompleteExpr x1 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getNextID s0 cd cs) (wrapNX id
  (nd_OP_trCompleteExpr_dot_uscore_hash_lambda246 x1)) s1 cd cs))

d_OP_trCompleteExpr_dot_uscore_hash_lambda246 :: FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> C_IOES C_State
  Curry_AbstractHaskell.C_Expr
d_OP_trCompleteExpr_dot_uscore_hash_lambda246 x1 x2 cd cs = d_OP_gt_plus_eq
  (d_C_trExpr x1 cd cs)
  (d_OP_trCompleteExpr_dot_uscore_hash_lambda246_dot_uscore_hash_lambda247 x2)
  cd cs

nd_OP_trCompleteExpr_dot_uscore_hash_lambda246 :: FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.C_Int -> IDSupply -> Cover -> ConstStore -> C_IOES C_State
  Curry_AbstractHaskell.C_Expr
nd_OP_trCompleteExpr_dot_uscore_hash_lambda246 x1 x2 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_trExpr x1 s0 cd cs) (wrapNX id
  (nd_OP_trCompleteExpr_dot_uscore_hash_lambda246_dot_uscore_hash_lambda247 x2))
  s1 cd cs))

d_OP_trCompleteExpr_dot_uscore_hash_lambda246_dot_uscore_hash_lambda247 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore -> C_IOES C_State
  Curry_AbstractHaskell.C_Expr
d_OP_trCompleteExpr_dot_uscore_hash_lambda246_dot_uscore_hash_lambda247 x1 x2 cd cs =
  case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> d_OP_gt_plus (d_C_setNextID x1 cd cs)
    (d_C__case_48 x4 x3 cd cs) cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_trCompleteExpr_dot_uscore_hash_lambda246_dot_uscore_hash_lambda247 x1
    l cd cs)
    (d_OP_trCompleteExpr_dot_uscore_hash_lambda246_dot_uscore_hash_lambda247 x1
    r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_trCompleteExpr_dot_uscore_hash_lambda246_dot_uscore_hash_lambda247 x1 z
    cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_trCompleteExpr_dot_uscore_hash_lambda246_dot_uscore_hash_lambda247 x1
    e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.trCompleteExpr._#lambda246._#lambda247" [show x1, show x2]
    info)
  _ -> failCons cd (consFail
    "TransFunctions.trCompleteExpr._#lambda246._#lambda247" (showCons x2))

nd_OP_trCompleteExpr_dot_uscore_hash_lambda246_dot_uscore_hash_lambda247 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr -> IDSupply -> Cover -> ConstStore -> C_IOES
  C_State Curry_AbstractHaskell.C_Expr
nd_OP_trCompleteExpr_dot_uscore_hash_lambda246_dot_uscore_hash_lambda247 x1 x2 s cd cs =
  case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> let s3 = s
    in s3 `seq` (let s2 = leftSupply s3
                     s4 = rightSupply s3
                     s0 = leftSupply s4
                     s1 = rightSupply s4
    in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` nd_OP_gt_plus (nd_C_setNextID x1
    s0 cd cs) (nd_C__case_48 x4 x3 s1 cd cs) s2 cd cs))))
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (nd_OP_trCompleteExpr_dot_uscore_hash_lambda246_dot_uscore_hash_lambda247 x1
    l s cd cs)
    (nd_OP_trCompleteExpr_dot_uscore_hash_lambda246_dot_uscore_hash_lambda247 x1
    r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    nd_OP_trCompleteExpr_dot_uscore_hash_lambda246_dot_uscore_hash_lambda247 x1
    z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (nd_OP_trCompleteExpr_dot_uscore_hash_lambda246_dot_uscore_hash_lambda247 x1
    e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.trCompleteExpr._#lambda246._#lambda247" [show x1, show x2]
    info)
  _ -> failCons cd (consFail
    "TransFunctions.trCompleteExpr._#lambda246._#lambda247" (showCons x2))

d_C_trExpr :: FlatCurry.Curry_Types.C_Expr -> Cover -> ConstStore -> C_IOES
  C_State (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr)
d_C_trExpr x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_Var x2 -> d_C_returnM (Curry_Prelude.OP_Tuple2
    Curry_Prelude.OP_List (Curry_Prelude.d_C_apply (d_C_cvVar cd cs) x2 cd cs))
    cd cs
  FlatCurry.Curry_Types.C_Lit x3 -> d_C_returnM (Curry_Prelude.OP_Tuple2
    Curry_Prelude.OP_List (d_C_cvLitExpr x3 cd cs)) cd cs
  FlatCurry.Curry_Types.C_Comb x4 x5 x6 -> d_C__case_46 x5 x6 x1 x4 cd cs
  FlatCurry.Curry_Types.C_Let x10 x11 -> let x12 = Curry_Prelude.d_C_unzip x10
                                               cd cs
                                             x13 = d_OP_trExpr_dot_uscore_hash_selFP16_hash_vs
                                               x12 cd cs
                                             x14 = d_OP_trExpr_dot_uscore_hash_selFP17_hash_es
                                               x12 cd cs
    in d_OP_gt_plus_eq (d_OP_gt_plus_eq (d_C_mapM d_C_trExpr x14 cd cs)
    d_C_unzipArgs cd cs) (d_OP_trExpr_dot_uscore_hash_lambda272 x11 x13) cd cs
  FlatCurry.Curry_Types.C_Or x15 x16 -> d_OP_gt_plus_eq (d_C_trExpr x15 cd cs)
    (d_OP_trExpr_dot_uscore_hash_lambda274 x16) cd cs
  FlatCurry.Curry_Types.C_Free x17 x18 -> d_OP_gt_plus_eq (d_C_takeNextIDs
    (Curry_Prelude.d_C_length x17 cd cs) cd cs)
    (d_OP_trExpr_dot_uscore_hash_lambda277 x18 x17) cd cs
  FlatCurry.Curry_Types.C_Case x19 x20 x21 -> d_C_failM
    (Curry_Prelude.toCurryString "TransFunctions.trExpr: case expression") cd cs
  FlatCurry.Curry_Types.C_Typed x22 x23 -> d_OP_gt_plus_eq (d_C_trExpr x22 cd
    cs) (d_OP_trExpr_dot_uscore_hash_lambda279 x23) cd cs
  FlatCurry.Curry_Types.Choice_C_Expr d i l r -> narrow d i (d_C_trExpr l cd cs)
    (d_C_trExpr r cd cs)
  FlatCurry.Curry_Types.Choices_C_Expr d i xs -> narrows cs d i (\z ->
    d_C_trExpr z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Expr d c e -> guardCons d c (d_C_trExpr e cd $!
    addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Expr d info -> failCons d (traceFail
    "TransFunctions.trExpr" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.trExpr" (showCons x1))

nd_C_trExpr :: FlatCurry.Curry_Types.C_Expr -> IDSupply -> Cover -> ConstStore
  -> C_IOES C_State (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
nd_C_trExpr x1 s cd cs = case x1 of
  FlatCurry.Curry_Types.C_Var x2 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_C_returnM (Curry_Prelude.OP_Tuple2
    Curry_Prelude.OP_List (Curry_Prelude.nd_C_apply (wrapDX id (d_C_cvVar cd
    cs)) x2 s0 cd cs)) s1 cd cs))
  FlatCurry.Curry_Types.C_Lit x3 -> let s0 = s
    in s0 `seq` nd_C_returnM (Curry_Prelude.OP_Tuple2 Curry_Prelude.OP_List
    (d_C_cvLitExpr x3 cd cs)) s0 cd cs
  FlatCurry.Curry_Types.C_Comb x4 x5 x6 -> let s0 = s
    in s0 `seq` nd_C__case_46 x5 x6 x1 x4 s0 cd cs
  FlatCurry.Curry_Types.C_Let x10 x11 -> let s4 = s
    in s4 `seq` (let x12 = Curry_Prelude.d_C_unzip x10 cd cs
                     x13 = d_OP_trExpr_dot_uscore_hash_selFP16_hash_vs x12 cd cs
                     x14 = d_OP_trExpr_dot_uscore_hash_selFP17_hash_es x12 cd cs
    in let s3 = leftSupply s4
           s2 = rightSupply s4
    in s3 `seq` (s2 `seq` nd_OP_gt_plus_eq (let s1 = leftSupply s2
                                                s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_mapM (wrapNX id nd_C_trExpr)
    x14 s0 cd cs) (wrapNX id nd_C_unzipArgs) s1 cd cs)) (wrapNX id
    (nd_OP_trExpr_dot_uscore_hash_lambda272 x11 x13)) s3 cd cs))
  FlatCurry.Curry_Types.C_Or x15 x16 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_trExpr x15 s0 cd cs) (wrapNX id
    (nd_OP_trExpr_dot_uscore_hash_lambda274 x16)) s1 cd cs))
  FlatCurry.Curry_Types.C_Free x17 x18 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_takeNextIDs
    (Curry_Prelude.d_C_length x17 cd cs) s0 cd cs) (wrapNX id
    (nd_OP_trExpr_dot_uscore_hash_lambda277 x18 x17)) s1 cd cs))
  FlatCurry.Curry_Types.C_Case x19 x20 x21 -> let s0 = s
    in s0 `seq` nd_C_failM (Curry_Prelude.toCurryString
    "TransFunctions.trExpr: case expression") s0 cd cs
  FlatCurry.Curry_Types.C_Typed x22 x23 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_trExpr x22 s0 cd cs) (wrapNX id
    (nd_OP_trExpr_dot_uscore_hash_lambda279 x23)) s1 cd cs))
  FlatCurry.Curry_Types.Choice_C_Expr d i l r -> narrow d i (nd_C_trExpr l s cd
    cs) (nd_C_trExpr r s cd cs)
  FlatCurry.Curry_Types.Choices_C_Expr d i xs -> narrows cs d i (\z ->
    nd_C_trExpr z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Expr d c e -> guardCons d c (nd_C_trExpr e s
    cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Expr d info -> failCons d (traceFail
    "TransFunctions.trExpr" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.trExpr" (showCons x1))

d_OP_trExpr_dot_uscore_hash_lambda250 :: Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_Expr -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
d_OP_trExpr_dot_uscore_hash_lambda250 x1 x2 cd cs = d_OP_gt_plus_eq
  (d_OP_gt_plus_eq (d_C_mapM d_C_trExpr x1 cd cs) d_C_unzipArgs cd cs)
  (d_OP_trExpr_dot_uscore_hash_lambda250_dot_uscore_hash_lambda251 x2) cd cs

nd_OP_trExpr_dot_uscore_hash_lambda250 :: Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_Expr -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply
  -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
nd_OP_trExpr_dot_uscore_hash_lambda250 x1 x2 s cd cs = let s4 = s
  in s4 `seq` (let s3 = leftSupply s4
                   s2 = rightSupply s4
  in s3 `seq` (s2 `seq` nd_OP_gt_plus_eq (let s1 = leftSupply s2
                                              s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_mapM (wrapNX id nd_C_trExpr) x1
  s0 cd cs) (wrapNX id nd_C_unzipArgs) s1 cd cs)) (wrapNX id
  (nd_OP_trExpr_dot_uscore_hash_lambda250_dot_uscore_hash_lambda251 x2)) s3 cd
  cs))

d_OP_trExpr_dot_uscore_hash_lambda250_dot_uscore_hash_lambda251 :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Int) (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr)
  -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
d_OP_trExpr_dot_uscore_hash_lambda250_dot_uscore_hash_lambda251 x1 x2 cd cs =
  case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> d_C_genIds x3
    (Curry_AbstractHaskellGoodies.d_C_applyF x1 x4 cd cs) cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_trExpr_dot_uscore_hash_lambda250_dot_uscore_hash_lambda251 x1 l cd cs)
    (d_OP_trExpr_dot_uscore_hash_lambda250_dot_uscore_hash_lambda251 x1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_trExpr_dot_uscore_hash_lambda250_dot_uscore_hash_lambda251 x1 z cd cs)
    xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_trExpr_dot_uscore_hash_lambda250_dot_uscore_hash_lambda251 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.trExpr._#lambda250._#lambda251" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.trExpr._#lambda250._#lambda251"
    (showCons x2))

nd_OP_trExpr_dot_uscore_hash_lambda250_dot_uscore_hash_lambda251 :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Int) (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr)
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
nd_OP_trExpr_dot_uscore_hash_lambda250_dot_uscore_hash_lambda251 x1 x2 s cd cs =
  case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> let s0 = s
    in s0 `seq` nd_C_genIds x3 (Curry_AbstractHaskellGoodies.d_C_applyF x1 x4 cd
    cs) s0 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (nd_OP_trExpr_dot_uscore_hash_lambda250_dot_uscore_hash_lambda251 x1 l s cd
    cs) (nd_OP_trExpr_dot_uscore_hash_lambda250_dot_uscore_hash_lambda251 x1 r s
    cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    nd_OP_trExpr_dot_uscore_hash_lambda250_dot_uscore_hash_lambda251 x1 z s cd
    cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (nd_OP_trExpr_dot_uscore_hash_lambda250_dot_uscore_hash_lambda251 x1 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.trExpr._#lambda250._#lambda251" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.trExpr._#lambda250._#lambda251"
    (showCons x2))

d_OP_trExpr_dot_uscore_hash_lambda252 :: Curry_CompilerOpts.C_Options -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_OP_trExpr_dot_uscore_hash_lambda252 x1 cd cs = Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply
  (Curry_CompilerOpts.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
  cd cs) (Curry_CompilerOpts.d_C_optOptimization x1 cd cs) cd cs)
  Curry_CompilerOpts.C_OptimNone cd cs

d_OP_trExpr_dot_uscore_hash_lambda253 :: Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_Expr -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr)
d_OP_trExpr_dot_uscore_hash_lambda253 x1 x2 x3 cd cs = d_OP_gt_plus_eq
  (d_C_getNDClass x2 cd cs)
  (d_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254 x3 x1 x2) cd
  cs

nd_OP_trExpr_dot_uscore_hash_lambda253 :: Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_Expr -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr)
nd_OP_trExpr_dot_uscore_hash_lambda253 x1 x2 x3 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getNDClass x2 s0 cd cs) (wrapNX
  id (nd_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254 x3 x1
  x2)) s1 cd cs))

d_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254 :: Curry_Prelude.C_Bool
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Classification.C_NDClass
  -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
d_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254 x1 x2 x3 x4 cd cs =
  d_OP_gt_plus_eq (d_C_getFuncHOClass x3 cd cs)
  (d_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255
  x4 x1 x2 x3) cd cs

nd_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254 :: Curry_Prelude.C_Bool
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Classification.C_NDClass
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
nd_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254 x1 x2 x3 x4 s cd cs =
  let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getFuncHOClass x3 s0 cd cs)
  (wrapNX id
  (nd_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255
  x4 x1 x2 x3)) s1 cd cs))

d_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255 :: Curry_Classification.C_NDClass
  -> Curry_Prelude.C_Bool -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Classification.C_FuncHOClass -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr)
d_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255 x1 x2 x3 x4 x5 cd cs =
  d_OP_gt_plus_eq (d_C_isDetMode cd cs)
  (d_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256
  x5 x1 x2 x3 x4) cd cs

nd_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255 :: Curry_Classification.C_NDClass
  -> Curry_Prelude.C_Bool -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Classification.C_FuncHOClass -> IDSupply -> Cover -> ConstStore
  -> C_IOES C_State (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
nd_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255 x1 x2 x3 x4 x5 s cd cs =
  let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_isDetMode s0 cd cs) (wrapNX id
  (nd_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256
  x5 x1 x2 x3 x4)) s1 cd cs))

d_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256 :: Curry_Classification.C_FuncHOClass
  -> Curry_Classification.C_NDClass -> Curry_Prelude.C_Bool
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
d_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256 x1 x2 x3 x4 x5 x6 cd cs =
  d_OP_gt_plus_eq (d_C_renameFun x5 cd cs)
  (d_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256_dot_uscore_hash_lambda257
  x1 x2 x6 x3 x4) cd cs

nd_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256 :: Curry_Classification.C_FuncHOClass
  -> Curry_Classification.C_NDClass -> Curry_Prelude.C_Bool
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
nd_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256 x1 x2 x3 x4 x5 x6 s cd cs =
  let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_renameFun x5 s0 cd cs) (wrapNX id
  (nd_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256_dot_uscore_hash_lambda257
  x1 x2 x6 x3 x4)) s1 cd cs))

d_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256_dot_uscore_hash_lambda257 :: Curry_Classification.C_FuncHOClass
  -> Curry_Classification.C_NDClass -> Curry_Prelude.C_Bool
  -> Curry_Prelude.C_Bool -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore -> C_IOES
  C_State (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr)
d_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256_dot_uscore_hash_lambda257 x1 x2 x3 x4 x5 x6 cd cs =
  d_OP_gt_plus_eq (d_OP_gt_plus_eq (d_C_mapM d_C_trExpr x5 cd cs) d_C_unzipArgs
  cd cs)
  (d_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256_dot_uscore_hash_lambda257_dot_uscore_hash_lambda258
  x1 x2 x3 x4 x6) cd cs

nd_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256_dot_uscore_hash_lambda257 :: Curry_Classification.C_FuncHOClass
  -> Curry_Classification.C_NDClass -> Curry_Prelude.C_Bool
  -> Curry_Prelude.C_Bool -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
nd_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256_dot_uscore_hash_lambda257 x1 x2 x3 x4 x5 x6 s cd cs =
  let s4 = s
  in s4 `seq` (let s3 = leftSupply s4
                   s2 = rightSupply s4
  in s3 `seq` (s2 `seq` nd_OP_gt_plus_eq (let s1 = leftSupply s2
                                              s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_mapM (wrapNX id nd_C_trExpr) x5
  s0 cd cs) (wrapNX id nd_C_unzipArgs) s1 cd cs)) (wrapNX id
  (nd_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256_dot_uscore_hash_lambda257_dot_uscore_hash_lambda258
  x1 x2 x3 x4 x6)) s3 cd cs))

d_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256_dot_uscore_hash_lambda257_dot_uscore_hash_lambda258 :: Curry_Classification.C_FuncHOClass
  -> Curry_Classification.C_NDClass -> Curry_Prelude.C_Bool
  -> Curry_Prelude.C_Bool -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr) -> Cover -> ConstStore
  -> C_IOES C_State (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
d_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256_dot_uscore_hash_lambda257_dot_uscore_hash_lambda258 x1 x2 x3 x4 x5 x6 cd cs =
  case x6 of
  Curry_Prelude.OP_Tuple2 x7 x8 -> d_C__case_44 x3 x1 x4 x2 x8 x5 x7
    (Curry_Prelude.d_OP_bar_bar
    (Curry_Classification.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Classification_dot_NDClass
    x2 Curry_Classification.C_ND cd cs) (Curry_Prelude.d_OP_bar_bar
    (Curry_Prelude.d_C_not x4 cd cs) (Curry_Prelude.d_OP_amp_amp
    (Curry_Classification.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Classification_dot_FuncHOClass
    x1 Curry_Classification.C_FuncHO cd cs) (Curry_Prelude.d_C_not x3 cd cs) cd
    cs) cd cs) cd cs) cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256_dot_uscore_hash_lambda257_dot_uscore_hash_lambda258
    x1 x2 x3 x4 x5 l cd cs)
    (d_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256_dot_uscore_hash_lambda257_dot_uscore_hash_lambda258
    x1 x2 x3 x4 x5 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256_dot_uscore_hash_lambda257_dot_uscore_hash_lambda258
    x1 x2 x3 x4 x5 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256_dot_uscore_hash_lambda257_dot_uscore_hash_lambda258
    x1 x2 x3 x4 x5 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.trExpr._#lambda253._#lambda254._#lambda255._#lambda256._#lambda257._#lambda258"
    [show x1, show x2, show x3, show x4, show x5, show x6] info)
  _ -> failCons cd (consFail
    "TransFunctions.trExpr._#lambda253._#lambda254._#lambda255._#lambda256._#lambda257._#lambda258"
    (showCons x6))

nd_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256_dot_uscore_hash_lambda257_dot_uscore_hash_lambda258 :: Curry_Classification.C_FuncHOClass
  -> Curry_Classification.C_NDClass -> Curry_Prelude.C_Bool
  -> Curry_Prelude.C_Bool -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr) -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
nd_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256_dot_uscore_hash_lambda257_dot_uscore_hash_lambda258 x1 x2 x3 x4 x5 x6 s cd cs =
  case x6 of
  Curry_Prelude.OP_Tuple2 x7 x8 -> let s0 = s
    in s0 `seq` nd_C__case_44 x3 x1 x4 x2 x8 x5 x7 (Curry_Prelude.d_OP_bar_bar
    (Curry_Classification.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Classification_dot_NDClass
    x2 Curry_Classification.C_ND cd cs) (Curry_Prelude.d_OP_bar_bar
    (Curry_Prelude.d_C_not x4 cd cs) (Curry_Prelude.d_OP_amp_amp
    (Curry_Classification.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Classification_dot_FuncHOClass
    x1 Curry_Classification.C_FuncHO cd cs) (Curry_Prelude.d_C_not x3 cd cs) cd
    cs) cd cs) cd cs) s0 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (nd_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256_dot_uscore_hash_lambda257_dot_uscore_hash_lambda258
    x1 x2 x3 x4 x5 l s cd cs)
    (nd_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256_dot_uscore_hash_lambda257_dot_uscore_hash_lambda258
    x1 x2 x3 x4 x5 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    nd_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256_dot_uscore_hash_lambda257_dot_uscore_hash_lambda258
    x1 x2 x3 x4 x5 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (nd_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256_dot_uscore_hash_lambda257_dot_uscore_hash_lambda258
    x1 x2 x3 x4 x5 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.trExpr._#lambda253._#lambda254._#lambda255._#lambda256._#lambda257._#lambda258"
    [show x1, show x2, show x3, show x4, show x5, show x6] info)
  _ -> failCons cd (consFail
    "TransFunctions.trExpr._#lambda253._#lambda254._#lambda255._#lambda256._#lambda257._#lambda258"
    (showCons x6))

d_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256_dot_uscore_hash_lambda257_dot_uscore_hash_lambda258_dot_uscore_hash_lambda259 :: Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
d_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256_dot_uscore_hash_lambda257_dot_uscore_hash_lambda258_dot_uscore_hash_lambda259 x1 x2 x3 x4 cd cs =
  d_C_genIds (Curry_Prelude.OP_Cons x4 x2)
  (Curry_AbstractHaskellGoodies.d_C_applyF x3 (Curry_Prelude.d_OP_plus_plus x1
  (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply (d_C_supplyVar cd cs) x4 cd
  cs) (Curry_Prelude.OP_Cons (d_C_coverVar cd cs) (Curry_Prelude.OP_Cons
  (d_C_constStoreVar cd cs) Curry_Prelude.OP_List))) cd cs) cd cs) cd cs

nd_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256_dot_uscore_hash_lambda257_dot_uscore_hash_lambda258_dot_uscore_hash_lambda259 :: Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
nd_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256_dot_uscore_hash_lambda257_dot_uscore_hash_lambda258_dot_uscore_hash_lambda259 x1 x2 x3 x4 s cd cs =
  let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_C_genIds (Curry_Prelude.OP_Cons x4 x2)
  (Curry_AbstractHaskellGoodies.d_C_applyF x3 (Curry_Prelude.d_OP_plus_plus x1
  (Curry_Prelude.OP_Cons (Curry_Prelude.nd_C_apply (wrapDX id (d_C_supplyVar cd
  cs)) x4 s0 cd cs) (Curry_Prelude.OP_Cons (d_C_coverVar cd cs)
  (Curry_Prelude.OP_Cons (d_C_constStoreVar cd cs) Curry_Prelude.OP_List))) cd
  cs) cd cs) s1 cd cs))

d_OP_trExpr_dot_uscore_hash_lambda262 :: Curry_CompilerOpts.C_Options -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_OP_trExpr_dot_uscore_hash_lambda262 x1 cd cs = Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply
  (Curry_CompilerOpts.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_CompilerOpts_dot_OptimLevel
  cd cs) (Curry_CompilerOpts.d_C_optOptimization x1 cd cs) cd cs)
  Curry_CompilerOpts.C_OptimNone cd cs

d_OP_trExpr_dot_uscore_hash_lambda263 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
d_OP_trExpr_dot_uscore_hash_lambda263 x1 x2 x3 x4 cd cs = d_OP_gt_plus_eq
  (d_C_getNDClass x3 cd cs)
  (d_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264 x4 x1 x2 x3)
  cd cs

nd_OP_trExpr_dot_uscore_hash_lambda263 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
nd_OP_trExpr_dot_uscore_hash_lambda263 x1 x2 x3 x4 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getNDClass x3 s0 cd cs) (wrapNX
  id (nd_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264 x4 x1 x2
  x3)) s1 cd cs))

d_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264 :: Curry_Prelude.C_Bool
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Classification.C_NDClass
  -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
d_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264 x1 x2 x3 x4 x5 cd cs =
  d_OP_gt_plus_eq (d_C_getFuncHOClass x4 cd cs)
  (d_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265
  x5 x1 x2 x3 x4) cd cs

nd_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264 :: Curry_Prelude.C_Bool
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Classification.C_NDClass
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
nd_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264 x1 x2 x3 x4 x5 s cd cs =
  let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getFuncHOClass x4 s0 cd cs)
  (wrapNX id
  (nd_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265
  x5 x1 x2 x3 x4)) s1 cd cs))

d_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265 :: Curry_Classification.C_NDClass
  -> Curry_Prelude.C_Bool -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_Expr -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Classification.C_FuncHOClass -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr)
d_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265 x1 x2 x3 x4 x5 x6 cd cs =
  d_OP_gt_plus_eq (d_C_isDetMode cd cs)
  (d_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265_dot_uscore_hash_lambda266
  x6 x1 x2 x3 x4 x5) cd cs

nd_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265 :: Curry_Classification.C_NDClass
  -> Curry_Prelude.C_Bool -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_Expr -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Classification.C_FuncHOClass -> IDSupply -> Cover -> ConstStore
  -> C_IOES C_State (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
nd_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265 x1 x2 x3 x4 x5 x6 s cd cs =
  let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_isDetMode s0 cd cs) (wrapNX id
  (nd_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265_dot_uscore_hash_lambda266
  x6 x1 x2 x3 x4 x5)) s1 cd cs))

d_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265_dot_uscore_hash_lambda266 :: Curry_Classification.C_FuncHOClass
  -> Curry_Classification.C_NDClass -> Curry_Prelude.C_Bool
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
d_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265_dot_uscore_hash_lambda266 x1 x2 x3 x4 x5 x6 x7 cd cs =
  d_OP_gt_plus_eq (d_C_renameFun x6 cd cs)
  (d_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265_dot_uscore_hash_lambda266_dot_uscore_hash_lambda267
  x1 x2 x7 x3 x4 x5) cd cs

nd_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265_dot_uscore_hash_lambda266 :: Curry_Classification.C_FuncHOClass
  -> Curry_Classification.C_NDClass -> Curry_Prelude.C_Bool
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
nd_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265_dot_uscore_hash_lambda266 x1 x2 x3 x4 x5 x6 x7 s cd cs =
  let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_renameFun x6 s0 cd cs) (wrapNX id
  (nd_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265_dot_uscore_hash_lambda266_dot_uscore_hash_lambda267
  x1 x2 x7 x3 x4 x5)) s1 cd cs))

d_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265_dot_uscore_hash_lambda266_dot_uscore_hash_lambda267 :: Curry_Classification.C_FuncHOClass
  -> Curry_Classification.C_NDClass -> Curry_Prelude.C_Bool
  -> Curry_Prelude.C_Bool -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_Expr -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
d_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265_dot_uscore_hash_lambda266_dot_uscore_hash_lambda267 x1 x2 x3 x4 x5 x6 x7 cd cs =
  d_OP_gt_plus_eq (d_OP_gt_plus_eq (d_C_mapM d_C_trExpr x6 cd cs) d_C_unzipArgs
  cd cs)
  (d_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265_dot_uscore_hash_lambda266_dot_uscore_hash_lambda267_dot_uscore_hash_lambda268
  x1 x2 x3 x4 x5 x7) cd cs

nd_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265_dot_uscore_hash_lambda266_dot_uscore_hash_lambda267 :: Curry_Classification.C_FuncHOClass
  -> Curry_Classification.C_NDClass -> Curry_Prelude.C_Bool
  -> Curry_Prelude.C_Bool -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_Expr -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply
  -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
nd_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265_dot_uscore_hash_lambda266_dot_uscore_hash_lambda267 x1 x2 x3 x4 x5 x6 x7 s cd cs =
  let s4 = s
  in s4 `seq` (let s3 = leftSupply s4
                   s2 = rightSupply s4
  in s3 `seq` (s2 `seq` nd_OP_gt_plus_eq (let s1 = leftSupply s2
                                              s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_mapM (wrapNX id nd_C_trExpr) x6
  s0 cd cs) (wrapNX id nd_C_unzipArgs) s1 cd cs)) (wrapNX id
  (nd_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265_dot_uscore_hash_lambda266_dot_uscore_hash_lambda267_dot_uscore_hash_lambda268
  x1 x2 x3 x4 x5 x7)) s3 cd cs))

d_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265_dot_uscore_hash_lambda266_dot_uscore_hash_lambda267_dot_uscore_hash_lambda268 :: Curry_Classification.C_FuncHOClass
  -> Curry_Classification.C_NDClass -> Curry_Prelude.C_Bool
  -> Curry_Prelude.C_Bool -> Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Int) (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr)
  -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
d_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265_dot_uscore_hash_lambda266_dot_uscore_hash_lambda267_dot_uscore_hash_lambda268 x1 x2 x3 x4 x5 x6 x7 cd cs =
  case x7 of
  Curry_Prelude.OP_Tuple2 x8 x9 -> d_C_genIds x8 (d_C_wrapPartCall
    Curry_Prelude.C_False x3 x4 x2 x1 x5
    (Curry_AbstractHaskellGoodies.d_C_applyF x6 x9 cd cs) cd cs) cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265_dot_uscore_hash_lambda266_dot_uscore_hash_lambda267_dot_uscore_hash_lambda268
    x1 x2 x3 x4 x5 x6 l cd cs)
    (d_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265_dot_uscore_hash_lambda266_dot_uscore_hash_lambda267_dot_uscore_hash_lambda268
    x1 x2 x3 x4 x5 x6 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265_dot_uscore_hash_lambda266_dot_uscore_hash_lambda267_dot_uscore_hash_lambda268
    x1 x2 x3 x4 x5 x6 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265_dot_uscore_hash_lambda266_dot_uscore_hash_lambda267_dot_uscore_hash_lambda268
    x1 x2 x3 x4 x5 x6 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.trExpr._#lambda263._#lambda264._#lambda265._#lambda266._#lambda267._#lambda268"
    [show x1, show x2, show x3, show x4, show x5, show x6, show x7] info)
  _ -> failCons cd (consFail
    "TransFunctions.trExpr._#lambda263._#lambda264._#lambda265._#lambda266._#lambda267._#lambda268"
    (showCons x7))

nd_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265_dot_uscore_hash_lambda266_dot_uscore_hash_lambda267_dot_uscore_hash_lambda268 :: Curry_Classification.C_FuncHOClass
  -> Curry_Classification.C_NDClass -> Curry_Prelude.C_Bool
  -> Curry_Prelude.C_Bool -> Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Int) (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr)
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
nd_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265_dot_uscore_hash_lambda266_dot_uscore_hash_lambda267_dot_uscore_hash_lambda268 x1 x2 x3 x4 x5 x6 x7 s cd cs =
  case x7 of
  Curry_Prelude.OP_Tuple2 x8 x9 -> let s0 = s
    in s0 `seq` nd_C_genIds x8 (d_C_wrapPartCall Curry_Prelude.C_False x3 x4 x2
    x1 x5 (Curry_AbstractHaskellGoodies.d_C_applyF x6 x9 cd cs) cd cs) s0 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (nd_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265_dot_uscore_hash_lambda266_dot_uscore_hash_lambda267_dot_uscore_hash_lambda268
    x1 x2 x3 x4 x5 x6 l s cd cs)
    (nd_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265_dot_uscore_hash_lambda266_dot_uscore_hash_lambda267_dot_uscore_hash_lambda268
    x1 x2 x3 x4 x5 x6 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    nd_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265_dot_uscore_hash_lambda266_dot_uscore_hash_lambda267_dot_uscore_hash_lambda268
    x1 x2 x3 x4 x5 x6 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (nd_OP_trExpr_dot_uscore_hash_lambda263_dot_uscore_hash_lambda264_dot_uscore_hash_lambda265_dot_uscore_hash_lambda266_dot_uscore_hash_lambda267_dot_uscore_hash_lambda268
    x1 x2 x3 x4 x5 x6 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.trExpr._#lambda263._#lambda264._#lambda265._#lambda266._#lambda267._#lambda268"
    [show x1, show x2, show x3, show x4, show x5, show x6, show x7] info)
  _ -> failCons cd (consFail
    "TransFunctions.trExpr._#lambda263._#lambda264._#lambda265._#lambda266._#lambda267._#lambda268"
    (showCons x7))

d_OP_trExpr_dot_uscore_hash_lambda269 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
d_OP_trExpr_dot_uscore_hash_lambda269 x1 x2 x3 x4 cd cs = d_OP_gt_plus_eq
  (d_C_renameCons x3 cd cs)
  (d_OP_trExpr_dot_uscore_hash_lambda269_dot_uscore_hash_lambda270 x4 x1 x2) cd
  cs

nd_OP_trExpr_dot_uscore_hash_lambda269 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
nd_OP_trExpr_dot_uscore_hash_lambda269 x1 x2 x3 x4 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_renameCons x3 s0 cd cs) (wrapNX
  id (nd_OP_trExpr_dot_uscore_hash_lambda269_dot_uscore_hash_lambda270 x4 x1
  x2)) s1 cd cs))

d_OP_trExpr_dot_uscore_hash_lambda269_dot_uscore_hash_lambda270 :: Curry_Prelude.C_Bool
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore -> C_IOES
  C_State (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr)
d_OP_trExpr_dot_uscore_hash_lambda269_dot_uscore_hash_lambda270 x1 x2 x3 x4 cd cs =
  d_OP_gt_plus_eq (d_OP_gt_plus_eq (d_C_mapM d_C_trExpr x3 cd cs) d_C_unzipArgs
  cd cs)
  (d_OP_trExpr_dot_uscore_hash_lambda269_dot_uscore_hash_lambda270_dot_uscore_hash_lambda271
  x1 x2 x4) cd cs

nd_OP_trExpr_dot_uscore_hash_lambda269_dot_uscore_hash_lambda270 :: Curry_Prelude.C_Bool
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
nd_OP_trExpr_dot_uscore_hash_lambda269_dot_uscore_hash_lambda270 x1 x2 x3 x4 s cd cs =
  let s4 = s
  in s4 `seq` (let s3 = leftSupply s4
                   s2 = rightSupply s4
  in s3 `seq` (s2 `seq` nd_OP_gt_plus_eq (let s1 = leftSupply s2
                                              s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_mapM (wrapNX id nd_C_trExpr) x3
  s0 cd cs) (wrapNX id nd_C_unzipArgs) s1 cd cs)) (wrapNX id
  (nd_OP_trExpr_dot_uscore_hash_lambda269_dot_uscore_hash_lambda270_dot_uscore_hash_lambda271
  x1 x2 x4)) s3 cd cs))

d_OP_trExpr_dot_uscore_hash_lambda269_dot_uscore_hash_lambda270_dot_uscore_hash_lambda271 :: Curry_Prelude.C_Bool
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr) -> Cover -> ConstStore
  -> C_IOES C_State (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
d_OP_trExpr_dot_uscore_hash_lambda269_dot_uscore_hash_lambda270_dot_uscore_hash_lambda271 x1 x2 x3 x4 cd cs =
  case x4 of
  Curry_Prelude.OP_Tuple2 x5 x6 -> d_C_genIds x5 (d_C_wrapPartCall
    Curry_Prelude.C_True x1 Curry_Prelude.C_True Curry_Classification.C_D
    Curry_Classification.C_FuncFO x2 (Curry_AbstractHaskellGoodies.d_C_applyF x3
    x6 cd cs) cd cs) cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_trExpr_dot_uscore_hash_lambda269_dot_uscore_hash_lambda270_dot_uscore_hash_lambda271
    x1 x2 x3 l cd cs)
    (d_OP_trExpr_dot_uscore_hash_lambda269_dot_uscore_hash_lambda270_dot_uscore_hash_lambda271
    x1 x2 x3 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_trExpr_dot_uscore_hash_lambda269_dot_uscore_hash_lambda270_dot_uscore_hash_lambda271
    x1 x2 x3 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_trExpr_dot_uscore_hash_lambda269_dot_uscore_hash_lambda270_dot_uscore_hash_lambda271
    x1 x2 x3 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.trExpr._#lambda269._#lambda270._#lambda271" [show x1, show
    x2, show x3, show x4] info)
  _ -> failCons cd (consFail
    "TransFunctions.trExpr._#lambda269._#lambda270._#lambda271" (showCons x4))

nd_OP_trExpr_dot_uscore_hash_lambda269_dot_uscore_hash_lambda270_dot_uscore_hash_lambda271 :: Curry_Prelude.C_Bool
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr) -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
nd_OP_trExpr_dot_uscore_hash_lambda269_dot_uscore_hash_lambda270_dot_uscore_hash_lambda271 x1 x2 x3 x4 s cd cs =
  case x4 of
  Curry_Prelude.OP_Tuple2 x5 x6 -> let s0 = s
    in s0 `seq` nd_C_genIds x5 (d_C_wrapPartCall Curry_Prelude.C_True x1
    Curry_Prelude.C_True Curry_Classification.C_D Curry_Classification.C_FuncFO
    x2 (Curry_AbstractHaskellGoodies.d_C_applyF x3 x6 cd cs) cd cs) s0 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (nd_OP_trExpr_dot_uscore_hash_lambda269_dot_uscore_hash_lambda270_dot_uscore_hash_lambda271
    x1 x2 x3 l s cd cs)
    (nd_OP_trExpr_dot_uscore_hash_lambda269_dot_uscore_hash_lambda270_dot_uscore_hash_lambda271
    x1 x2 x3 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    nd_OP_trExpr_dot_uscore_hash_lambda269_dot_uscore_hash_lambda270_dot_uscore_hash_lambda271
    x1 x2 x3 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (nd_OP_trExpr_dot_uscore_hash_lambda269_dot_uscore_hash_lambda270_dot_uscore_hash_lambda271
    x1 x2 x3 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.trExpr._#lambda269._#lambda270._#lambda271" [show x1, show
    x2, show x3, show x4] info)
  _ -> failCons cd (consFail
    "TransFunctions.trExpr._#lambda269._#lambda270._#lambda271" (showCons x4))

d_OP_trExpr_dot_uscore_hash_selFP16_hash_vs :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_Expr) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int
d_OP_trExpr_dot_uscore_hash_selFP16_hash_vs x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_trExpr_dot_uscore_hash_selFP16_hash_vs l cd cs)
    (d_OP_trExpr_dot_uscore_hash_selFP16_hash_vs r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_trExpr_dot_uscore_hash_selFP16_hash_vs z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_trExpr_dot_uscore_hash_selFP16_hash_vs e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.trExpr._#selFP16#vs" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.trExpr._#selFP16#vs" (showCons x1))

d_OP_trExpr_dot_uscore_hash_selFP17_hash_es :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_Expr) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_Expr
d_OP_trExpr_dot_uscore_hash_selFP17_hash_es x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_trExpr_dot_uscore_hash_selFP17_hash_es l cd cs)
    (d_OP_trExpr_dot_uscore_hash_selFP17_hash_es r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_trExpr_dot_uscore_hash_selFP17_hash_es z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_trExpr_dot_uscore_hash_selFP17_hash_es e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.trExpr._#selFP17#es" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.trExpr._#selFP17#es" (showCons x1))

d_OP_trExpr_dot_uscore_hash_lambda272 :: FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr) -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr)
d_OP_trExpr_dot_uscore_hash_lambda272 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Tuple2 x4 x5 -> d_OP_gt_plus_eq (d_C_trExpr x1 cd cs)
    (d_OP_trExpr_dot_uscore_hash_lambda272_dot_uscore_hash_lambda273 x5 x4 x2)
    cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_trExpr_dot_uscore_hash_lambda272 x1 x2 l cd cs)
    (d_OP_trExpr_dot_uscore_hash_lambda272 x1 x2 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_trExpr_dot_uscore_hash_lambda272 x1 x2 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_trExpr_dot_uscore_hash_lambda272 x1 x2 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.trExpr._#lambda272" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransFunctions.trExpr._#lambda272" (showCons x3))

nd_OP_trExpr_dot_uscore_hash_lambda272 :: FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr) -> IDSupply -> Cover -> ConstStore -> C_IOES
  C_State (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr)
nd_OP_trExpr_dot_uscore_hash_lambda272 x1 x2 x3 s cd cs = case x3 of
  Curry_Prelude.OP_Tuple2 x4 x5 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_trExpr x1 s0 cd cs) (wrapNX id
    (nd_OP_trExpr_dot_uscore_hash_lambda272_dot_uscore_hash_lambda273 x5 x4 x2))
    s1 cd cs))
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (nd_OP_trExpr_dot_uscore_hash_lambda272 x1 x2 l s cd cs)
    (nd_OP_trExpr_dot_uscore_hash_lambda272 x1 x2 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    nd_OP_trExpr_dot_uscore_hash_lambda272 x1 x2 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (nd_OP_trExpr_dot_uscore_hash_lambda272 x1 x2 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.trExpr._#lambda272" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransFunctions.trExpr._#lambda272" (showCons x3))

d_OP_trExpr_dot_uscore_hash_lambda272_dot_uscore_hash_lambda273 :: Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr
  -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
d_OP_trExpr_dot_uscore_hash_lambda272_dot_uscore_hash_lambda273 x1 x2 x3 x4 cd cs =
  case x4 of
  Curry_Prelude.OP_Tuple2 x5 x6 -> d_C_genIds (Curry_Prelude.d_OP_plus_plus x2
    x5 cd cs) (Curry_AbstractHaskellGoodies.d_C_clet (Curry_Prelude.d_C_zipWith
    (acceptCs id Curry_AbstractHaskellGoodies.d_C_declVar)
    (Curry_Prelude.d_C_map d_C_cvVarIndex x3 cd cs) x1 cd cs) x6 cd cs) cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_trExpr_dot_uscore_hash_lambda272_dot_uscore_hash_lambda273 x1 x2 x3 l
    cd cs) (d_OP_trExpr_dot_uscore_hash_lambda272_dot_uscore_hash_lambda273 x1
    x2 x3 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_trExpr_dot_uscore_hash_lambda272_dot_uscore_hash_lambda273 x1 x2 x3 z
    cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_trExpr_dot_uscore_hash_lambda272_dot_uscore_hash_lambda273 x1 x2 x3 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.trExpr._#lambda272._#lambda273" [show x1, show x2, show x3
    , show x4] info)
  _ -> failCons cd (consFail "TransFunctions.trExpr._#lambda272._#lambda273"
    (showCons x4))

nd_OP_trExpr_dot_uscore_hash_lambda272_dot_uscore_hash_lambda273 :: Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
nd_OP_trExpr_dot_uscore_hash_lambda272_dot_uscore_hash_lambda273 x1 x2 x3 x4 s cd cs =
  case x4 of
  Curry_Prelude.OP_Tuple2 x5 x6 -> let s4 = s
    in s4 `seq` (let s3 = leftSupply s4
                     s2 = rightSupply s4
    in s3 `seq` (s2 `seq` nd_C_genIds (Curry_Prelude.d_OP_plus_plus x2 x5 cd cs)
    (Curry_AbstractHaskellGoodies.d_C_clet (let s1 = leftSupply s2
                                                s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_zipWith (wrapDX (wrapDX id)
    (acceptCs id Curry_AbstractHaskellGoodies.d_C_declVar))
    (Curry_Prelude.nd_C_map (wrapDX id d_C_cvVarIndex) x3 s0 cd cs) x1 s1 cd
    cs)) x6 cd cs) s3 cd cs))
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (nd_OP_trExpr_dot_uscore_hash_lambda272_dot_uscore_hash_lambda273 x1 x2 x3 l
    s cd cs) (nd_OP_trExpr_dot_uscore_hash_lambda272_dot_uscore_hash_lambda273
    x1 x2 x3 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    nd_OP_trExpr_dot_uscore_hash_lambda272_dot_uscore_hash_lambda273 x1 x2 x3 z
    s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (nd_OP_trExpr_dot_uscore_hash_lambda272_dot_uscore_hash_lambda273 x1 x2 x3 e
    s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.trExpr._#lambda272._#lambda273" [show x1, show x2, show x3
    , show x4] info)
  _ -> failCons cd (consFail "TransFunctions.trExpr._#lambda272._#lambda273"
    (showCons x4))

d_OP_trExpr_dot_uscore_hash_lambda274 :: FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr)
d_OP_trExpr_dot_uscore_hash_lambda274 x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> d_OP_gt_plus_eq (d_C_trExpr x1 cd cs)
    (d_OP_trExpr_dot_uscore_hash_lambda274_dot_uscore_hash_lambda275 x4 x3) cd
    cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_trExpr_dot_uscore_hash_lambda274 x1 l cd cs)
    (d_OP_trExpr_dot_uscore_hash_lambda274 x1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_trExpr_dot_uscore_hash_lambda274 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_trExpr_dot_uscore_hash_lambda274 x1 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.trExpr._#lambda274" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.trExpr._#lambda274" (showCons x2))

nd_OP_trExpr_dot_uscore_hash_lambda274 :: FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr -> IDSupply -> Cover -> ConstStore -> C_IOES
  C_State (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr)
nd_OP_trExpr_dot_uscore_hash_lambda274 x1 x2 s cd cs = case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_trExpr x1 s0 cd cs) (wrapNX id
    (nd_OP_trExpr_dot_uscore_hash_lambda274_dot_uscore_hash_lambda275 x4 x3)) s1
    cd cs))
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (nd_OP_trExpr_dot_uscore_hash_lambda274 x1 l s cd cs)
    (nd_OP_trExpr_dot_uscore_hash_lambda274 x1 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    nd_OP_trExpr_dot_uscore_hash_lambda274 x1 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (nd_OP_trExpr_dot_uscore_hash_lambda274 x1 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.trExpr._#lambda274" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.trExpr._#lambda274" (showCons x2))

d_OP_trExpr_dot_uscore_hash_lambda274_dot_uscore_hash_lambda275 :: Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr
  -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
d_OP_trExpr_dot_uscore_hash_lambda274_dot_uscore_hash_lambda275 x1 x2 x3 cd cs =
  case x3 of
  Curry_Prelude.OP_Tuple2 x4 x5 -> d_OP_gt_plus_eq (d_C_takeNextID cd cs)
    (d_OP_trExpr_dot_uscore_hash_lambda274_dot_uscore_hash_lambda275_dot_uscore_hash_lambda276
    x1 x5 x2 x4) cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_trExpr_dot_uscore_hash_lambda274_dot_uscore_hash_lambda275 x1 x2 l cd
    cs) (d_OP_trExpr_dot_uscore_hash_lambda274_dot_uscore_hash_lambda275 x1 x2 r
    cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_trExpr_dot_uscore_hash_lambda274_dot_uscore_hash_lambda275 x1 x2 z cd
    cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_trExpr_dot_uscore_hash_lambda274_dot_uscore_hash_lambda275 x1 x2 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.trExpr._#lambda274._#lambda275" [show x1, show x2, show x3]
    info)
  _ -> failCons cd (consFail "TransFunctions.trExpr._#lambda274._#lambda275"
    (showCons x3))

nd_OP_trExpr_dot_uscore_hash_lambda274_dot_uscore_hash_lambda275 :: Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
nd_OP_trExpr_dot_uscore_hash_lambda274_dot_uscore_hash_lambda275 x1 x2 x3 s cd cs =
  case x3 of
  Curry_Prelude.OP_Tuple2 x4 x5 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_takeNextID s0 cd cs) (wrapNX id
    (nd_OP_trExpr_dot_uscore_hash_lambda274_dot_uscore_hash_lambda275_dot_uscore_hash_lambda276
    x1 x5 x2 x4)) s1 cd cs))
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (nd_OP_trExpr_dot_uscore_hash_lambda274_dot_uscore_hash_lambda275 x1 x2 l s
    cd cs) (nd_OP_trExpr_dot_uscore_hash_lambda274_dot_uscore_hash_lambda275 x1
    x2 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    nd_OP_trExpr_dot_uscore_hash_lambda274_dot_uscore_hash_lambda275 x1 x2 z s
    cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (nd_OP_trExpr_dot_uscore_hash_lambda274_dot_uscore_hash_lambda275 x1 x2 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.trExpr._#lambda274._#lambda275" [show x1, show x2, show x3]
    info)
  _ -> failCons cd (consFail "TransFunctions.trExpr._#lambda274._#lambda275"
    (showCons x3))

d_OP_trExpr_dot_uscore_hash_lambda274_dot_uscore_hash_lambda275_dot_uscore_hash_lambda276 :: Curry_AbstractHaskell.C_Expr
  -> Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
d_OP_trExpr_dot_uscore_hash_lambda274_dot_uscore_hash_lambda275_dot_uscore_hash_lambda276 x1 x2 x3 x4 x5 cd cs =
  d_C_genIds (Curry_Prelude.OP_Cons x5 (Curry_Prelude.d_OP_plus_plus x3 x4 cd
  cs)) (Curry_Prelude.d_C_apply (d_C_choice cd cs) (Curry_Prelude.OP_Cons x1
  (Curry_Prelude.OP_Cons x2 (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply
  (d_C_supplyVar cd cs) x5 cd cs) (Curry_Prelude.OP_Cons (d_C_coverVar cd cs)
  (Curry_Prelude.OP_Cons (d_C_constStoreVar cd cs) Curry_Prelude.OP_List))))) cd
  cs) cd cs

nd_OP_trExpr_dot_uscore_hash_lambda274_dot_uscore_hash_lambda275_dot_uscore_hash_lambda276 :: Curry_AbstractHaskell.C_Expr
  -> Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
nd_OP_trExpr_dot_uscore_hash_lambda274_dot_uscore_hash_lambda275_dot_uscore_hash_lambda276 x1 x2 x3 x4 x5 s cd cs =
  let s4 = s
  in s4 `seq` (let s3 = leftSupply s4
                   s2 = rightSupply s4
  in s3 `seq` (s2 `seq` nd_C_genIds (Curry_Prelude.OP_Cons x5
  (Curry_Prelude.d_OP_plus_plus x3 x4 cd cs)) (let s1 = leftSupply s2
                                                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (wrapDX id (d_C_choice cd cs))
  (Curry_Prelude.OP_Cons x1 (Curry_Prelude.OP_Cons x2 (Curry_Prelude.OP_Cons
  (Curry_Prelude.nd_C_apply (wrapDX id (d_C_supplyVar cd cs)) x5 s0 cd cs)
  (Curry_Prelude.OP_Cons (d_C_coverVar cd cs) (Curry_Prelude.OP_Cons
  (d_C_constStoreVar cd cs) Curry_Prelude.OP_List))))) s1 cd cs)) s3 cd cs))

d_OP_trExpr_dot_mkFree_dot_496 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_LocalDecl
d_OP_trExpr_dot_mkFree_dot_496 x1 x2 cd cs =
  Curry_AbstractHaskellGoodies.d_C_declVar (d_C_cvVarIndex x1 cd cs)
  (Curry_Prelude.d_OP_dollar d_C_generate (Curry_Prelude.d_C_apply
  (d_C_supplyVar cd cs) x2 cd cs) cd cs) cd cs

d_OP_trExpr_dot_uscore_hash_lambda277 :: FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr)
d_OP_trExpr_dot_uscore_hash_lambda277 x1 x2 x3 cd cs = d_OP_gt_plus_eq
  (d_C_trExpr x1 cd cs)
  (d_OP_trExpr_dot_uscore_hash_lambda277_dot_uscore_hash_lambda278 x3 x2) cd cs

nd_OP_trExpr_dot_uscore_hash_lambda277 :: FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> IDSupply -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr)
nd_OP_trExpr_dot_uscore_hash_lambda277 x1 x2 x3 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_trExpr x1 s0 cd cs) (wrapNX id
  (nd_OP_trExpr_dot_uscore_hash_lambda277_dot_uscore_hash_lambda278 x3 x2)) s1
  cd cs))

d_OP_trExpr_dot_uscore_hash_lambda277_dot_uscore_hash_lambda278 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Curry_Prelude.OP_List Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr)
d_OP_trExpr_dot_uscore_hash_lambda277_dot_uscore_hash_lambda278 x1 x2 x3 cd cs =
  case x3 of
  Curry_Prelude.OP_Tuple2 x4 x5 -> d_C_genIds (Curry_Prelude.d_OP_plus_plus x1
    x4 cd cs) (Curry_AbstractHaskellGoodies.d_C_clet (Curry_Prelude.d_C_zipWith
    (acceptCs id d_OP_trExpr_dot_mkFree_dot_496) x2 x1 cd cs) x5 cd cs) cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_trExpr_dot_uscore_hash_lambda277_dot_uscore_hash_lambda278 x1 x2 l cd
    cs) (d_OP_trExpr_dot_uscore_hash_lambda277_dot_uscore_hash_lambda278 x1 x2 r
    cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_trExpr_dot_uscore_hash_lambda277_dot_uscore_hash_lambda278 x1 x2 z cd
    cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_trExpr_dot_uscore_hash_lambda277_dot_uscore_hash_lambda278 x1 x2 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.trExpr._#lambda277._#lambda278" [show x1, show x2, show x3]
    info)
  _ -> failCons cd (consFail "TransFunctions.trExpr._#lambda277._#lambda278"
    (showCons x3))

nd_OP_trExpr_dot_uscore_hash_lambda277_dot_uscore_hash_lambda278 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Curry_Prelude.OP_List Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr -> IDSupply -> Cover -> ConstStore -> C_IOES
  C_State (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr)
nd_OP_trExpr_dot_uscore_hash_lambda277_dot_uscore_hash_lambda278 x1 x2 x3 s cd cs =
  case x3 of
  Curry_Prelude.OP_Tuple2 x4 x5 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_C_genIds (Curry_Prelude.d_OP_plus_plus x1 x4 cd cs)
    (Curry_AbstractHaskellGoodies.d_C_clet (Curry_Prelude.nd_C_zipWith (wrapDX
    (wrapDX id) (acceptCs id d_OP_trExpr_dot_mkFree_dot_496)) x2 x1 s0 cd cs) x5
    cd cs) s1 cd cs))
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (nd_OP_trExpr_dot_uscore_hash_lambda277_dot_uscore_hash_lambda278 x1 x2 l s
    cd cs) (nd_OP_trExpr_dot_uscore_hash_lambda277_dot_uscore_hash_lambda278 x1
    x2 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    nd_OP_trExpr_dot_uscore_hash_lambda277_dot_uscore_hash_lambda278 x1 x2 z s
    cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (nd_OP_trExpr_dot_uscore_hash_lambda277_dot_uscore_hash_lambda278 x1 x2 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.trExpr._#lambda277._#lambda278" [show x1, show x2, show x3]
    info)
  _ -> failCons cd (consFail "TransFunctions.trExpr._#lambda277._#lambda278"
    (showCons x3))

d_OP_trExpr_dot_uscore_hash_lambda279 :: FlatCurry.Curry_Types.C_TypeExpr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr)
d_OP_trExpr_dot_uscore_hash_lambda279 x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> d_OP_gt_plus_eq (d_C_trExprType x1 cd cs)
    (d_OP_trExpr_dot_uscore_hash_lambda279_dot_uscore_hash_lambda280 x4 x3) cd
    cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_trExpr_dot_uscore_hash_lambda279 x1 l cd cs)
    (d_OP_trExpr_dot_uscore_hash_lambda279 x1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_trExpr_dot_uscore_hash_lambda279 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_trExpr_dot_uscore_hash_lambda279 x1 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.trExpr._#lambda279" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.trExpr._#lambda279" (showCons x2))

nd_OP_trExpr_dot_uscore_hash_lambda279 :: FlatCurry.Curry_Types.C_TypeExpr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr -> IDSupply -> Cover -> ConstStore -> C_IOES
  C_State (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr)
nd_OP_trExpr_dot_uscore_hash_lambda279 x1 x2 s cd cs = case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_trExprType x1 s0 cd cs) (wrapNX
    id (nd_OP_trExpr_dot_uscore_hash_lambda279_dot_uscore_hash_lambda280 x4 x3))
    s1 cd cs))
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (nd_OP_trExpr_dot_uscore_hash_lambda279 x1 l s cd cs)
    (nd_OP_trExpr_dot_uscore_hash_lambda279 x1 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    nd_OP_trExpr_dot_uscore_hash_lambda279 x1 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (nd_OP_trExpr_dot_uscore_hash_lambda279 x1 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.trExpr._#lambda279" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.trExpr._#lambda279" (showCons x2))

d_OP_trExpr_dot_uscore_hash_lambda279_dot_uscore_hash_lambda280 :: Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int
  -> Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr)
d_OP_trExpr_dot_uscore_hash_lambda279_dot_uscore_hash_lambda280 x1 x2 x3 cd cs =
  d_C_genIds x2 (Curry_AbstractHaskell.C_Typed x1 x3) cd cs

nd_OP_trExpr_dot_uscore_hash_lambda279_dot_uscore_hash_lambda280 :: Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int
  -> Curry_AbstractHaskell.C_TypeExpr -> IDSupply -> Cover -> ConstStore
  -> C_IOES C_State (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
nd_OP_trExpr_dot_uscore_hash_lambda279_dot_uscore_hash_lambda280 x1 x2 x3 s cd cs =
  let s0 = s
  in s0 `seq` nd_C_genIds x2 (Curry_AbstractHaskell.C_Typed x1 x3) s0 cd cs

d_C_getString :: FlatCurry.Curry_Types.C_Expr -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_getString x1 cd cs = let x2 = Curry_Prelude.C_Nothing
  in d_C__case_41 x2 x1 cd cs

d_OP_getString_dot_getString_tick_dot_511 :: FlatCurry.Curry_Types.C_Expr
  -> Cover -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_getString_dot_getString_tick_dot_511 x1 cd cs =
  let x2 = Curry_Prelude.C_Nothing in d_C__case_32 x2 x1 cd cs

d_C_unzipArgs :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
  -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr))
d_C_unzipArgs x1 cd cs = let x2 = Curry_Prelude.d_C_unzip x1 cd cs
                             x3 = d_OP_unzipArgs_dot_uscore_hash_selFP19_hash_is
                               x2 cd cs
                             x4 = d_OP_unzipArgs_dot_uscore_hash_selFP20_hash_es
                               x2 cd cs
  in d_C_returnM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.d_C_concat x3 cd cs)
  x4) cd cs

nd_C_unzipArgs :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr))
nd_C_unzipArgs x1 s cd cs = let s0 = s
  in s0 `seq` (let x2 = Curry_Prelude.d_C_unzip x1 cd cs
                   x3 = d_OP_unzipArgs_dot_uscore_hash_selFP19_hash_is x2 cd cs
                   x4 = d_OP_unzipArgs_dot_uscore_hash_selFP20_hash_es x2 cd cs
  in nd_C_returnM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.d_C_concat x3 cd cs)
  x4) s0 cd cs)

d_OP_unzipArgs_dot_uscore_hash_selFP19_hash_is :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Int))
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Int)
d_OP_unzipArgs_dot_uscore_hash_selFP19_hash_is x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_unzipArgs_dot_uscore_hash_selFP19_hash_is l cd cs)
    (d_OP_unzipArgs_dot_uscore_hash_selFP19_hash_is r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_unzipArgs_dot_uscore_hash_selFP19_hash_is z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_unzipArgs_dot_uscore_hash_selFP19_hash_is e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.unzipArgs._#selFP19#is" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.unzipArgs._#selFP19#is" (showCons
    x1))

d_OP_unzipArgs_dot_uscore_hash_selFP20_hash_es :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Int))
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr
d_OP_unzipArgs_dot_uscore_hash_selFP20_hash_es x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_unzipArgs_dot_uscore_hash_selFP20_hash_es l cd cs)
    (d_OP_unzipArgs_dot_uscore_hash_selFP20_hash_es r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_unzipArgs_dot_uscore_hash_selFP20_hash_es z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_unzipArgs_dot_uscore_hash_selFP20_hash_es e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.unzipArgs._#selFP20#es" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.unzipArgs._#selFP20#es" (showCons
    x1))

d_C_genIds :: Curry_Prelude.OP_List Curry_Prelude.C_Int
  -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr)
d_C_genIds x1 x2 cd cs = case x1 of
  Curry_Prelude.OP_List -> d_C_returnM (Curry_Prelude.OP_Tuple2
    Curry_Prelude.OP_List x2) cd cs
  Curry_Prelude.OP_Cons x3 x4 -> d_OP_gt_plus_eq (d_C_getNextID cd cs)
    (d_OP_genIds_dot_uscore_hash_lambda288 x2 x1) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_genIds l x2 cd cs)
    (d_C_genIds r x2 cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_genIds z x2
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_genIds e x2 cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions.genIds" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.genIds" (showCons x1))

nd_C_genIds :: Curry_Prelude.OP_List Curry_Prelude.C_Int
  -> Curry_AbstractHaskell.C_Expr -> IDSupply -> Cover -> ConstStore -> C_IOES
  C_State (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr)
nd_C_genIds x1 x2 s cd cs = case x1 of
  Curry_Prelude.OP_List -> let s0 = s
    in s0 `seq` nd_C_returnM (Curry_Prelude.OP_Tuple2 Curry_Prelude.OP_List x2)
    s0 cd cs
  Curry_Prelude.OP_Cons x3 x4 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getNextID s0 cd cs) (wrapNX id
    (nd_OP_genIds_dot_uscore_hash_lambda288 x2 x1)) s1 cd cs))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C_genIds l x2 s cd cs)
    (nd_C_genIds r x2 s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C_genIds z x2
    s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C_genIds e x2 s cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions.genIds" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.genIds" (showCons x1))

d_OP_genIds_dot_uscore_hash_lambda288 :: Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
d_OP_genIds_dot_uscore_hash_lambda288 x1 x2 x3 cd cs = let x4 = d_C_splitSupply
                                                             x3 x2 cd cs
                                                           x5 = d_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_selFP22_hash_vroot
                                                             x4 cd cs
                                                           x6 = d_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_selFP23_hash_v_tick
                                                             x4 cd cs
                                                           x7 = d_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_selFP24_hash_vs
                                                             x4 cd cs
  in d_OP_gt_plus_eq (d_C_letIdVar (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_concatMap
  d_OP_genIds_dot_uscore_hash_lambda288_dot_supply_dot_546 cd cs) x7 cd cs) x1
  cd cs) (d_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_lambda289 x6 x5)
  cd cs

nd_OP_genIds_dot_uscore_hash_lambda288 :: Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Curry_Prelude.C_Int
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
nd_OP_genIds_dot_uscore_hash_lambda288 x1 x2 x3 s cd cs = let s6 = s
  in s6 `seq` (let x4 = d_C_splitSupply x3 x2 cd cs
                   x5 = d_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_selFP22_hash_vroot
                     x4 cd cs
                   x6 = d_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_selFP23_hash_v_tick
                     x4 cd cs
                   x7 = d_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_selFP24_hash_vs
                     x4 cd cs
  in let s5 = leftSupply s6
         s4 = rightSupply s6
  in s5 `seq` (s4 `seq` nd_OP_gt_plus_eq (let s3 = leftSupply s4
                                              s2 = rightSupply s4
  in s3 `seq` (s2 `seq` nd_C_letIdVar (let s1 = leftSupply s2
                                           s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_concatMap
  (wrapDX id d_OP_genIds_dot_uscore_hash_lambda288_dot_supply_dot_546) s0 cd cs)
  x7 s1 cd cs)) x1 s3 cd cs)) (wrapNX id
  (nd_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_lambda289 x6 x5)) s5
  cd cs))

d_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_selFP22_hash_vroot :: Curry_Prelude.OP_Tuple3
  Curry_Prelude.C_Int Curry_Prelude.C_Int (Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple3 Curry_Prelude.C_Int Curry_Prelude.C_Int
  Curry_Prelude.C_Int)) -> Cover -> ConstStore -> Curry_Prelude.C_Int
d_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_selFP22_hash_vroot x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> x2
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (d_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_selFP22_hash_vroot l
    cd cs)
    (d_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_selFP22_hash_vroot r
    cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    d_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_selFP22_hash_vroot z
    cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (d_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_selFP22_hash_vroot e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "TransFunctions.genIds._#lambda288._#selFP22#vroot" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.genIds._#lambda288._#selFP22#vroot"
    (showCons x1))

d_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_selFP23_hash_v_tick :: Curry_Prelude.OP_Tuple3
  Curry_Prelude.C_Int Curry_Prelude.C_Int (Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple3 Curry_Prelude.C_Int Curry_Prelude.C_Int
  Curry_Prelude.C_Int)) -> Cover -> ConstStore -> Curry_Prelude.C_Int
d_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_selFP23_hash_v_tick x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> x3
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (d_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_selFP23_hash_v_tick l
    cd cs)
    (d_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_selFP23_hash_v_tick r
    cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    d_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_selFP23_hash_v_tick z
    cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (d_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_selFP23_hash_v_tick e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "TransFunctions.genIds._#lambda288._#selFP23#v'" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.genIds._#lambda288._#selFP23#v'"
    (showCons x1))

d_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_selFP24_hash_vs :: Curry_Prelude.OP_Tuple3
  Curry_Prelude.C_Int Curry_Prelude.C_Int (Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple3 Curry_Prelude.C_Int Curry_Prelude.C_Int
  Curry_Prelude.C_Int)) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple3 Curry_Prelude.C_Int Curry_Prelude.C_Int
  Curry_Prelude.C_Int)
d_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_selFP24_hash_vs x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> x4
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (d_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_selFP24_hash_vs l cd
    cs) (d_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_selFP24_hash_vs r
    cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    d_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_selFP24_hash_vs z cd
    cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (d_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_selFP24_hash_vs e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "TransFunctions.genIds._#lambda288._#selFP24#vs" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.genIds._#lambda288._#selFP24#vs"
    (showCons x1))

d_OP_genIds_dot_uscore_hash_lambda288_dot_supply_dot_546 :: Curry_Prelude.OP_Tuple3
  Curry_Prelude.C_Int Curry_Prelude.C_Int Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Expr)
d_OP_genIds_dot_uscore_hash_lambda288_dot_supply_dot_546 x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> Curry_Prelude.OP_Cons
    (Curry_Prelude.OP_Tuple2 (d_C_supplyName x3 cd cs) (Curry_Prelude.d_C_apply
    (d_C_leftSupply cd cs) (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply
    (d_C_supplyVar cd cs) x2 cd cs) Curry_Prelude.OP_List) cd cs))
    (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple2 (d_C_supplyName x4 cd cs)
    (Curry_Prelude.d_C_apply (d_C_rightSupply cd cs) (Curry_Prelude.OP_Cons
    (Curry_Prelude.d_C_apply (d_C_supplyVar cd cs) x2 cd cs)
    Curry_Prelude.OP_List) cd cs)) Curry_Prelude.OP_List)
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (d_OP_genIds_dot_uscore_hash_lambda288_dot_supply_dot_546 l cd cs)
    (d_OP_genIds_dot_uscore_hash_lambda288_dot_supply_dot_546 r cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    d_OP_genIds_dot_uscore_hash_lambda288_dot_supply_dot_546 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (d_OP_genIds_dot_uscore_hash_lambda288_dot_supply_dot_546 e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "TransFunctions.genIds._#lambda288.supply.546" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.genIds._#lambda288.supply.546"
    (showCons x1))

d_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_lambda289 :: Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> C_IOES C_State (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
d_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_lambda289 x1 x2 x3 cd cs =
  d_OP_gt_plus (d_C_setNextID x1 cd cs) (d_C_returnM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Cons x2 Curry_Prelude.OP_List) x3) cd cs) cd cs

nd_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_lambda289 :: Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Curry_AbstractHaskell.C_Expr -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
nd_OP_genIds_dot_uscore_hash_lambda288_dot_uscore_hash_lambda289 x1 x2 x3 s cd cs =
  let s3 = s
  in s3 `seq` (let s2 = leftSupply s3
                   s4 = rightSupply s3
                   s0 = leftSupply s4
                   s1 = rightSupply s4
  in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` nd_OP_gt_plus (nd_C_setNextID x1 s0
  cd cs) (nd_C_returnM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Cons x2
  Curry_Prelude.OP_List) x3) s1 cd cs) s2 cd cs))))

d_C_splitSupply :: Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple3
  Curry_Prelude.C_Int Curry_Prelude.C_Int (Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple3 Curry_Prelude.C_Int Curry_Prelude.C_Int
  Curry_Prelude.C_Int))
d_C_splitSupply x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "splitSupply with empty list") cd cs
  Curry_Prelude.OP_Cons x3 x4 -> d_C__case_22 x1 x2 x3 x4 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_splitSupply x1 l cd
    cs) (d_C_splitSupply x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_splitSupply
    x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_splitSupply x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions.splitSupply" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions.splitSupply" (showCons x2))

d_OP_splitSupply_dot_uscore_hash_selFP34_hash_ys :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Curry_Prelude.OP_List
  Curry_Prelude.C_Int) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int
d_OP_splitSupply_dot_uscore_hash_selFP34_hash_ys x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitSupply_dot_uscore_hash_selFP34_hash_ys l cd cs)
    (d_OP_splitSupply_dot_uscore_hash_selFP34_hash_ys r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitSupply_dot_uscore_hash_selFP34_hash_ys z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_splitSupply_dot_uscore_hash_selFP34_hash_ys e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.splitSupply._#selFP34#ys" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.splitSupply._#selFP34#ys" (showCons
    x1))

d_OP_splitSupply_dot_uscore_hash_selFP35_hash_zs :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) (Curry_Prelude.OP_List
  Curry_Prelude.C_Int) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int
d_OP_splitSupply_dot_uscore_hash_selFP35_hash_zs x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitSupply_dot_uscore_hash_selFP35_hash_zs l cd cs)
    (d_OP_splitSupply_dot_uscore_hash_selFP35_hash_zs r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitSupply_dot_uscore_hash_selFP35_hash_zs z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_splitSupply_dot_uscore_hash_selFP35_hash_zs e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.splitSupply._#selFP35#zs" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.splitSupply._#selFP35#zs" (showCons
    x1))

d_OP_splitSupply_dot_uscore_hash_selFP31_hash_sl :: Curry_Prelude.OP_Tuple3
  Curry_Prelude.C_Int Curry_Prelude.C_Int (Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple3 Curry_Prelude.C_Int Curry_Prelude.C_Int
  Curry_Prelude.C_Int)) -> Cover -> ConstStore -> Curry_Prelude.C_Int
d_OP_splitSupply_dot_uscore_hash_selFP31_hash_sl x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> x2
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (d_OP_splitSupply_dot_uscore_hash_selFP31_hash_sl l cd cs)
    (d_OP_splitSupply_dot_uscore_hash_selFP31_hash_sl r cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    d_OP_splitSupply_dot_uscore_hash_selFP31_hash_sl z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (d_OP_splitSupply_dot_uscore_hash_selFP31_hash_sl e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "TransFunctions.splitSupply._#selFP31#sl" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.splitSupply._#selFP31#sl" (showCons
    x1))

d_OP_splitSupply_dot_uscore_hash_selFP32_hash_nextl :: Curry_Prelude.OP_Tuple3
  Curry_Prelude.C_Int Curry_Prelude.C_Int (Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple3 Curry_Prelude.C_Int Curry_Prelude.C_Int
  Curry_Prelude.C_Int)) -> Cover -> ConstStore -> Curry_Prelude.C_Int
d_OP_splitSupply_dot_uscore_hash_selFP32_hash_nextl x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> x3
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (d_OP_splitSupply_dot_uscore_hash_selFP32_hash_nextl l cd cs)
    (d_OP_splitSupply_dot_uscore_hash_selFP32_hash_nextl r cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    d_OP_splitSupply_dot_uscore_hash_selFP32_hash_nextl z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (d_OP_splitSupply_dot_uscore_hash_selFP32_hash_nextl e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "TransFunctions.splitSupply._#selFP32#nextl" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.splitSupply._#selFP32#nextl"
    (showCons x1))

d_OP_splitSupply_dot_uscore_hash_selFP33_hash_spsl :: Curry_Prelude.OP_Tuple3
  Curry_Prelude.C_Int Curry_Prelude.C_Int (Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple3 Curry_Prelude.C_Int Curry_Prelude.C_Int
  Curry_Prelude.C_Int)) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple3 Curry_Prelude.C_Int Curry_Prelude.C_Int
  Curry_Prelude.C_Int)
d_OP_splitSupply_dot_uscore_hash_selFP33_hash_spsl x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> x4
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (d_OP_splitSupply_dot_uscore_hash_selFP33_hash_spsl l cd cs)
    (d_OP_splitSupply_dot_uscore_hash_selFP33_hash_spsl r cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    d_OP_splitSupply_dot_uscore_hash_selFP33_hash_spsl z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (d_OP_splitSupply_dot_uscore_hash_selFP33_hash_spsl e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "TransFunctions.splitSupply._#selFP33#spsl" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.splitSupply._#selFP33#spsl"
    (showCons x1))

d_OP_splitSupply_dot_uscore_hash_selFP28_hash_sr :: Curry_Prelude.OP_Tuple3
  Curry_Prelude.C_Int Curry_Prelude.C_Int (Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple3 Curry_Prelude.C_Int Curry_Prelude.C_Int
  Curry_Prelude.C_Int)) -> Cover -> ConstStore -> Curry_Prelude.C_Int
d_OP_splitSupply_dot_uscore_hash_selFP28_hash_sr x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> x2
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (d_OP_splitSupply_dot_uscore_hash_selFP28_hash_sr l cd cs)
    (d_OP_splitSupply_dot_uscore_hash_selFP28_hash_sr r cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    d_OP_splitSupply_dot_uscore_hash_selFP28_hash_sr z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (d_OP_splitSupply_dot_uscore_hash_selFP28_hash_sr e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "TransFunctions.splitSupply._#selFP28#sr" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.splitSupply._#selFP28#sr" (showCons
    x1))

d_OP_splitSupply_dot_uscore_hash_selFP29_hash_nextr :: Curry_Prelude.OP_Tuple3
  Curry_Prelude.C_Int Curry_Prelude.C_Int (Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple3 Curry_Prelude.C_Int Curry_Prelude.C_Int
  Curry_Prelude.C_Int)) -> Cover -> ConstStore -> Curry_Prelude.C_Int
d_OP_splitSupply_dot_uscore_hash_selFP29_hash_nextr x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> x3
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (d_OP_splitSupply_dot_uscore_hash_selFP29_hash_nextr l cd cs)
    (d_OP_splitSupply_dot_uscore_hash_selFP29_hash_nextr r cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    d_OP_splitSupply_dot_uscore_hash_selFP29_hash_nextr z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (d_OP_splitSupply_dot_uscore_hash_selFP29_hash_nextr e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "TransFunctions.splitSupply._#selFP29#nextr" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.splitSupply._#selFP29#nextr"
    (showCons x1))

d_OP_splitSupply_dot_uscore_hash_selFP30_hash_spsr :: Curry_Prelude.OP_Tuple3
  Curry_Prelude.C_Int Curry_Prelude.C_Int (Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple3 Curry_Prelude.C_Int Curry_Prelude.C_Int
  Curry_Prelude.C_Int)) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple3 Curry_Prelude.C_Int Curry_Prelude.C_Int
  Curry_Prelude.C_Int)
d_OP_splitSupply_dot_uscore_hash_selFP30_hash_spsr x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple3 x2 x3 x4 -> x4
  Curry_Prelude.Choice_OP_Tuple3 d i l r -> narrow d i
    (d_OP_splitSupply_dot_uscore_hash_selFP30_hash_spsr l cd cs)
    (d_OP_splitSupply_dot_uscore_hash_selFP30_hash_spsr r cd cs)
  Curry_Prelude.Choices_OP_Tuple3 d i xs -> narrows cs d i (\z ->
    d_OP_splitSupply_dot_uscore_hash_selFP30_hash_spsr z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple3 d c e -> guardCons d c
    (d_OP_splitSupply_dot_uscore_hash_selFP30_hash_spsr e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple3 d info -> failCons d (traceFail
    "TransFunctions.splitSupply._#selFP30#spsr" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.splitSupply._#selFP30#spsr"
    (showCons x1))

d_C_cvVar :: Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C_cvVar cd cs = Curry_Prelude.d_OP_dot (acceptCs id
  Curry_AbstractHaskell.C_Var) d_C_cvVarIndex cd cs

d_C_cvVarIndex :: Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_cvVarIndex x1 cd cs = Curry_Prelude.OP_Tuple2 x1 (Curry_Prelude.OP_Cons
  (Curry_Prelude.C_Char 'x'#) (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Int
  cd cs) x1 cd cs))

d_C_cvLit :: FlatCurry.Curry_Types.C_Literal -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Literal
d_C_cvLit x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_Intc x2 -> Curry_AbstractHaskell.C_Intc x2
  FlatCurry.Curry_Types.C_Floatc x3 -> Curry_AbstractHaskell.C_Floatc x3
  FlatCurry.Curry_Types.C_Charc x4 -> Curry_AbstractHaskell.C_Charc x4
  FlatCurry.Curry_Types.Choice_C_Literal d i l r -> narrow d i (d_C_cvLit l cd
    cs) (d_C_cvLit r cd cs)
  FlatCurry.Curry_Types.Choices_C_Literal d i xs -> narrows cs d i (\z ->
    d_C_cvLit z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Literal d c e -> guardCons d c (d_C_cvLit e
    cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Literal d info -> failCons d (traceFail
    "TransFunctions.cvLit" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.cvLit" (showCons x1))

d_C_cvLitExpr :: FlatCurry.Curry_Types.C_Literal -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C_cvLitExpr x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_Intc x2 -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (d_C_funcCall cd cs) (d_C_curryInt cd cs) cd cs)
    (Curry_Prelude.OP_Cons (d_C_constant (Curry_Prelude.OP_Tuple2
    (Curry_Names.d_C_prelude cd cs) (Curry_Prelude.OP_Cons (Curry_Prelude.C_Char
    '('#) (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Int
    cd cs) x2 cd cs) (Curry_Prelude.toCurryString ")") cd cs))) cd cs)
    Curry_Prelude.OP_List) cd cs
  FlatCurry.Curry_Types.C_Floatc x3 -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (d_C_funcCall cd cs) (d_C_curryFloat cd cs) cd cs)
    (Curry_Prelude.OP_Cons (d_C_constant (Curry_Prelude.OP_Tuple2
    (Curry_Names.d_C_prelude cd cs) (Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Float
    cd cs) x3 cd cs) (Curry_Prelude.toCurryString "##") cd cs)) cd cs)
    Curry_Prelude.OP_List) cd cs
  FlatCurry.Curry_Types.C_Charc x4 -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (d_C_funcCall cd cs) (d_C_curryChar cd cs) cd cs)
    (Curry_Prelude.OP_Cons (d_C_constant (Curry_Prelude.OP_Tuple2
    (Curry_Names.d_C_prelude cd cs) (Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Char
    cd cs) x4 cd cs) (Curry_Prelude.toCurryString "#") cd cs)) cd cs)
    Curry_Prelude.OP_List) cd cs
  FlatCurry.Curry_Types.Choice_C_Literal d i l r -> narrow d i (d_C_cvLitExpr l
    cd cs) (d_C_cvLitExpr r cd cs)
  FlatCurry.Curry_Types.Choices_C_Literal d i xs -> narrows cs d i (\z ->
    d_C_cvLitExpr z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Literal d c e -> guardCons d c (d_C_cvLitExpr e
    cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Literal d info -> failCons d (traceFail
    "TransFunctions.cvLitExpr" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.cvLitExpr" (showCons x1))

d_C_topSupplyVar :: Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C_topSupplyVar cd cs = Curry_AbstractHaskell.C_Var (d_C_topSupplyName cd cs)

d_C_topSupplyName :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_topSupplyName cd cs = Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int (3000))
  (Curry_Prelude.toCurryString "s")

d_C_supplyVar :: Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C_supplyVar cd cs = Curry_Prelude.d_OP_dot (acceptCs id
  Curry_AbstractHaskell.C_Var) d_C_supplyName cd cs

d_C_supplyName :: Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_supplyName x1 cd cs = Curry_Prelude.OP_Tuple2 x1 (Curry_Prelude.OP_Cons
  (Curry_Prelude.C_Char 's'#) (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Int
  cd cs) x1 cd cs))

d_C_coverVar :: Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C_coverVar cd cs = Curry_AbstractHaskell.C_Var (d_C_coverName cd cs)

d_C_coverName :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_coverName cd cs = Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int (3250))
  (Curry_Prelude.toCurryString "cd")

d_C_constStoreVar :: Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C_constStoreVar cd cs = Curry_AbstractHaskell.C_Var (d_C_constStoreName cd cs)

d_C_constStoreName :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_constStoreName cd cs = Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int (3500))
  (Curry_Prelude.toCurryString "cs")

d_C_wrapDHO :: Curry_Prelude.C_Int -> Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C_wrapDHO x1 x2 cd cs = d_C_newWrap Curry_Prelude.C_True x1 x2 cd cs

d_C_wrapPartCall :: Curry_Prelude.C_Bool -> Curry_Prelude.C_Bool
  -> Curry_Prelude.C_Bool -> Curry_Classification.C_NDClass
  -> Curry_Classification.C_FuncHOClass -> Curry_Prelude.C_Int
  -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C_wrapPartCall x1 x2 x3 x4 x5 x6 x7 cd cs =
  let x8 = let x9 = Curry_Prelude.C_False in d_C__case_18 x9 x5 cd cs
      x11 = Curry_Prelude.d_OP_amp_amp x3 (Curry_Prelude.d_OP_amp_amp
        (Curry_Classification.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Classification_dot_NDClass
        x4 Curry_Classification.C_D cd cs) (Curry_Prelude.d_C_not x8 cd cs) cd
        cs) cd cs
      x12 = let x13 = Curry_Prelude.C_Int (0) in d_C__case_17 x13 x5 cd cs
  in d_C__case_21 x4 x7 x6 x1 x12 x11 x2 cd cs

d_C_wrapCs :: Curry_Prelude.C_Bool -> Curry_Prelude.C_Int
  -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C_wrapCs x1 x2 x3 cd cs = let x4 = Curry_AbstractHaskellGoodies.d_C_applyF
                                  (Curry_Prelude.OP_Tuple2
                                  (Curry_Names.d_C_basics cd cs)
                                  (Curry_Prelude.toCurryString "acceptCs"))
  in d_C__case_16 x2 x3 x1 x4
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
  x2 (Curry_Prelude.C_Int (1)) cd cs) cd cs

d_OP_wrapCs_dot_mkWraps_dot_614 :: forall t0 . (Curry_Prelude.Curry
  t0) => (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr)
  -> Curry_Prelude.OP_uscore_Dict_hash_Num t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> t0
  -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_OP_wrapCs_dot_mkWraps_dot_614 x1 x2 x3 x4 x5 cd cs = d_C__case_12 x2 x4 x3 x5
  x1 (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (Curry_Prelude.d_OP_lt x3
  cd cs) x4 cd cs) (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_fromInt x2 cd cs)
  (Curry_Prelude.C_Int (2)) cd cs) cd cs) cd cs

nd_OP_wrapCs_dot_mkWraps_dot_614 :: forall t0 . (Curry_Prelude.Curry t0) => Func
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr)
  Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_uscore_Dict_hash_Num t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> t0
  -> Curry_AbstractHaskell.C_Expr -> IDSupply -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
nd_OP_wrapCs_dot_mkWraps_dot_614 x1 x2 x3 x4 x5 s cd cs = let s10 = s
  in s10 `seq` (let s9 = leftSupply s10
                    s7 = rightSupply s10
  in s9 `seq` (s7 `seq` nd_C__case_12 x2 x4 x3 x5 x1 (let s6 = leftSupply s7
                                                          s8 = rightSupply s7
                                                          s2 = leftSupply s8
                                                          s5 = rightSupply s8
  in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq` Curry_Prelude.nd_C_apply
  (let s1 = leftSupply s2
       s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_OP_lt x3 s0
  cd cs) x4 s1 cd cs)) (let s4 = leftSupply s5
                            s3 = rightSupply s5
  in s4 `seq` (s3 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_fromInt x2
  s3 cd cs) (Curry_Prelude.C_Int (2)) s4 cd cs)) s6 cd cs)))) s9 cd cs))

d_C_newWrap :: Curry_Prelude.C_Bool -> Curry_Prelude.C_Int
  -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C_newWrap x1 x2 x3 cd cs = let x4 = d_C__case_4 x1 cd cs
  in d_C__case_10 x2 x3 x4
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
  x2 (Curry_Prelude.C_Int (0)) cd cs) cd cs

d_OP_newWrap_dot_wraps_dot_619 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Num t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> t0
  -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_OP_newWrap_dot_wraps_dot_619 x1 x2 x3 x4 cd cs = d_C__case_3 x1 x3 x2 x4
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (Curry_Prelude.d_OP_lt_eq x2
  cd cs) x3 cd cs) (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_fromInt x1 cd cs)
  (Curry_Prelude.C_Int (1)) cd cs) cd cs) cd cs

nd_OP_newWrap_dot_wraps_dot_619 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Num t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> t0
  -> Curry_AbstractHaskell.C_Expr -> IDSupply -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
nd_OP_newWrap_dot_wraps_dot_619 x1 x2 x3 x4 s cd cs = let s10 = s
  in s10 `seq` (let s9 = leftSupply s10
                    s7 = rightSupply s10
  in s9 `seq` (s7 `seq` nd_C__case_3 x1 x3 x2 x4 (let s6 = leftSupply s7
                                                      s8 = rightSupply s7
                                                      s2 = leftSupply s8
                                                      s5 = rightSupply s8
  in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq` Curry_Prelude.nd_C_apply
  (let s1 = leftSupply s2
       s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_OP_lt_eq x2
  s0 cd cs) x3 s1 cd cs)) (let s4 = leftSupply s5
                               s3 = rightSupply s5
  in s4 `seq` (s3 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_fromInt x1
  s3 cd cs) (Curry_Prelude.C_Int (1)) s4 cd cs)) s6 cd cs)))) s9 cd cs))

d_C_wrapDX :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C_wrapDX cd cs = Curry_AbstractHaskellGoodies.d_C_applyF
  (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_basics cd cs)
  (Curry_Prelude.toCurryString "wrapDX"))

d_C_wrapNX :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C_wrapNX cd cs = Curry_AbstractHaskellGoodies.d_C_applyF
  (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_basics cd cs)
  (Curry_Prelude.toCurryString "wrapNX"))

d_C_funId :: Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C_funId cd cs = Curry_AbstractHaskellGoodies.d_C_applyF
  (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_prelude cd cs)
  (Curry_Prelude.toCurryString "id")) Curry_Prelude.OP_List cd cs

d_C_letIdVar :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Expr)
  -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore -> C_IOES C_State
  Curry_AbstractHaskell.C_Expr
d_C_letIdVar x1 x2 cd cs = d_OP_gt_plus_eq (d_C_strictSupply cd cs)
  (d_OP_letIdVar_dot_uscore_hash_lambda292 x2 x1) cd cs

nd_C_letIdVar :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Expr)
  -> Curry_AbstractHaskell.C_Expr -> IDSupply -> Cover -> ConstStore -> C_IOES
  C_State Curry_AbstractHaskell.C_Expr
nd_C_letIdVar x1 x2 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_strictSupply s0 cd cs) (wrapNX id
  (nd_OP_letIdVar_dot_uscore_hash_lambda292 x2 x1)) s1 cd cs))

d_OP_letIdVar_dot_uscore_hash_lambda292 :: Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_AbstractHaskell.C_Expr) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> C_IOES C_State Curry_AbstractHaskell.C_Expr
d_OP_letIdVar_dot_uscore_hash_lambda292 x1 x2 x3 cd cs =
  Curry_Prelude.d_OP_dollar d_C_returnM (Curry_Prelude.d_OP_dollar
  (Curry_AbstractHaskellGoodies.d_C_clet (Curry_Prelude.d_C_map
  (Curry_Prelude.d_C_uncurry (acceptCs id
  Curry_AbstractHaskellGoodies.d_C_declVar)) x2 cd cs)) (d_C__case_2 x1 x2 x3 cd
  cs) cd cs) cd cs

nd_OP_letIdVar_dot_uscore_hash_lambda292 :: Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_AbstractHaskell.C_Expr) -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_Expr
nd_OP_letIdVar_dot_uscore_hash_lambda292 x1 x2 x3 s cd cs = let s4 = s
  in s4 `seq` (let s3 = leftSupply s4
                   s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id nd_C_returnM)
  (let s1 = leftSupply s2
       s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dollar (wrapDX id
  (Curry_AbstractHaskellGoodies.d_C_clet (Curry_Prelude.nd_C_map (wrapNX id
  (Curry_Prelude.nd_C_uncurry (wrapDX (wrapDX id) (acceptCs id
  Curry_AbstractHaskellGoodies.d_C_declVar)))) x2 s0 cd cs))) (d_C__case_2 x1 x2
  x3 cd cs) s1 cd cs)) s3 cd cs))

d_C_curryInt :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_curryInt cd cs = Curry_Prelude.d_C_apply (Curry_Names.d_C_renameQName cd cs)
  (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_prelude cd cs)
  (Curry_Prelude.toCurryString "Int")) cd cs

d_C_curryFloat :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_curryFloat cd cs = Curry_Prelude.d_C_apply (Curry_Names.d_C_renameQName cd
  cs) (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_prelude cd cs)
  (Curry_Prelude.toCurryString "Float")) cd cs

d_C_curryChar :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_curryChar cd cs = Curry_Prelude.d_C_apply (Curry_Names.d_C_renameQName cd
  cs) (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_prelude cd cs)
  (Curry_Prelude.toCurryString "Char")) cd cs

d_C_addCs :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_addCs cd cs = Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_basics cd cs)
  (Curry_Prelude.toCurryString "addCs")

d_C_pair2ac :: Curry_Prelude.OP_Tuple2 Curry_AbstractHaskell.C_Expr
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C_pair2ac x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> Curry_AbstractHaskell.C_Tuple
    (Curry_Prelude.OP_Cons x2 (Curry_Prelude.OP_Cons x3 Curry_Prelude.OP_List))
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C_pair2ac l cd cs)
    (d_C_pair2ac r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C_pair2ac z
    cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C_pair2ac e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.pair2ac" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.pair2ac" (showCons x1))

d_C_seqCall :: Curry_AbstractHaskell.C_Expr -> Curry_AbstractHaskell.C_Expr
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C_seqCall x1 x2 cd cs = Curry_AbstractHaskell.C_InfixApply x1
  (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_prelude cd cs)
  (Curry_Prelude.toCurryString "seq")) x2

d_C_strictCall :: Curry_AbstractHaskell.C_Expr -> Curry_AbstractHaskell.C_Expr
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C_strictCall x1 x2 cd cs = Curry_AbstractHaskell.C_InfixApply x1
  (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_prelude cd cs)
  (Curry_Prelude.toCurryString "$!")) x2

d_C_funcCall :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C_funcCall cd cs = acceptCs id Curry_AbstractHaskellGoodies.d_C_applyF

d_C_constant :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C_constant x1 cd cs = Curry_AbstractHaskellGoodies.d_C_applyF x1
  Curry_Prelude.OP_List cd cs

d_C_failCheck :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr
  -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C_failCheck x1 x2 x3 cd cs = d_C__case_1 x1 x3 x2
  (Curry_LiftCase.d_C_isCaseAuxFuncName (Curry_Prelude.d_OP_dollar
  Curry_Prelude.d_C_snd (Curry_Prelude.d_C_apply
  (Curry_Names.d_C_unRenamePrefixedFunc cd cs) x1 cd cs) cd cs) cd cs) cd cs

d_OP_failCheck_dot_uscore_hash_lambda293 :: Curry_AbstractHaskell.C_Expr
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_OP_failCheck_dot_uscore_hash_lambda293 x1 cd cs = Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply (d_C_funcCall cd cs) (Curry_Prelude.OP_Tuple2
  (Curry_Names.d_C_prelude cd cs) (Curry_Prelude.toCurryString "show")) cd cs)
  (Curry_Prelude.OP_Cons x1 Curry_Prelude.OP_List) cd cs

d_C_traceFail :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr
  -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C_traceFail x1 x2 x3 x4 cd cs = Curry_Prelude.d_C_apply (d_C_liftFail cd cs)
  (Curry_Prelude.OP_Cons x1 (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply (d_C_funcCall cd cs) (Curry_Prelude.OP_Tuple2
  (Curry_Names.d_C_basics cd cs) (Curry_Prelude.toCurryString "traceFail")) cd
  cs) (Curry_Prelude.OP_Cons (d_C_showQName x2 cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskellGoodies.d_C_list2ac (Curry_Prelude.d_C_map
  d_OP_traceFail_dot_uscore_hash_lambda294 x3 cd cs) cd cs)
  (Curry_Prelude.OP_Cons x4 Curry_Prelude.OP_List))) cd cs)
  Curry_Prelude.OP_List)) cd cs

d_OP_traceFail_dot_uscore_hash_lambda294 :: Curry_AbstractHaskell.C_Expr
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_OP_traceFail_dot_uscore_hash_lambda294 x1 cd cs = Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply (d_C_funcCall cd cs) (Curry_Prelude.OP_Tuple2
  (Curry_Names.d_C_prelude cd cs) (Curry_Prelude.toCurryString "show")) cd cs)
  (Curry_Prelude.OP_Cons x1 Curry_Prelude.OP_List) cd cs

d_C_consFail :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C_consFail x1 x2 cd cs = Curry_Prelude.d_C_apply (d_C_liftFail cd cs)
  (Curry_Prelude.OP_Cons (d_C_coverVar cd cs) (Curry_Prelude.OP_Cons
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (d_C_funcCall cd cs)
  (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_basics cd cs)
  (Curry_Prelude.toCurryString "consFail")) cd cs) (Curry_Prelude.OP_Cons
  (Curry_Prelude.d_OP_dollar d_C_showQName (Curry_Prelude.d_C_apply
  (Curry_Names.d_C_unRenameQName cd cs) x1 cd cs) cd cs) (Curry_Prelude.OP_Cons
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (d_C_funcCall cd cs)
  (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_basics cd cs)
  (Curry_Prelude.toCurryString "showCons")) cd cs) (Curry_Prelude.OP_Cons x2
  Curry_Prelude.OP_List) cd cs) Curry_Prelude.OP_List)) cd cs)
  Curry_Prelude.OP_List)) cd cs

d_C_showQName :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C_showQName x1 cd cs = let x2 = Curry_Prelude.d_C_apply
                               (Curry_Names.d_C_unRenamePrefixedFunc cd cs) x1
                               cd cs
                             x3 = d_OP_showQName_dot_uscore_hash_selFP37_hash_q
                               x2 cd cs
                             x4 = d_OP_showQName_dot_uscore_hash_selFP38_hash_n
                               x2 cd cs
  in Curry_Prelude.d_C_apply (Curry_AbstractHaskellGoodies.d_C_string2ac cd cs)
  (Curry_Prelude.d_OP_plus_plus x3 (Curry_Prelude.OP_Cons (Curry_Prelude.C_Char
  '.'#) x4) cd cs) cd cs

d_OP_showQName_dot_uscore_hash_selFP37_hash_q :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_showQName_dot_uscore_hash_selFP37_hash_q x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_showQName_dot_uscore_hash_selFP37_hash_q l cd cs)
    (d_OP_showQName_dot_uscore_hash_selFP37_hash_q r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_showQName_dot_uscore_hash_selFP37_hash_q z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_showQName_dot_uscore_hash_selFP37_hash_q e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.showQName._#selFP37#q" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.showQName._#selFP37#q" (showCons
    x1))

d_OP_showQName_dot_uscore_hash_selFP38_hash_n :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_showQName_dot_uscore_hash_selFP38_hash_n x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_showQName_dot_uscore_hash_selFP38_hash_n l cd cs)
    (d_OP_showQName_dot_uscore_hash_selFP38_hash_n r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_showQName_dot_uscore_hash_selFP38_hash_n z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_showQName_dot_uscore_hash_selFP38_hash_n e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions.showQName._#selFP38#n" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions.showQName._#selFP38#n" (showCons
    x1))

d_C_emptyCs :: Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C_emptyCs cd cs = Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (d_C_funcCall cd cs) (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_basics cd cs)
  (Curry_Prelude.toCurryString "emptyCs")) cd cs) Curry_Prelude.OP_List cd cs

d_C_initCover :: Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C_initCover cd cs = Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (d_C_funcCall cd cs) (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_basics cd cs)
  (Curry_Prelude.toCurryString "initCover")) cd cs) Curry_Prelude.OP_List cd cs

d_C_choice :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C_choice cd cs = Curry_Prelude.d_C_apply (d_C_funcCall cd cs)
  (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_basics cd cs)
  (Curry_Prelude.toCurryString "choice")) cd cs

d_C_narrow :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C_narrow cd cs = Curry_Prelude.d_C_apply (d_C_funcCall cd cs)
  (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_basics cd cs)
  (Curry_Prelude.toCurryString "narrow")) cd cs

d_C_narrows :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C_narrows cd cs = Curry_Prelude.d_C_apply (d_C_funcCall cd cs)
  (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_basics cd cs)
  (Curry_Prelude.toCurryString "narrows")) cd cs

d_C_liftGuard :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C_liftGuard cd cs = Curry_Prelude.d_C_apply (d_C_funcCall cd cs)
  (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_basics cd cs)
  (Curry_Prelude.toCurryString "guardCons")) cd cs

d_C_liftFail :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C_liftFail cd cs = Curry_Prelude.d_C_apply (d_C_funcCall cd cs)
  (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_basics cd cs)
  (Curry_Prelude.toCurryString "failCons")) cd cs

d_C_leftSupply :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C_leftSupply cd cs = Curry_Prelude.d_C_apply (d_C_funcCall cd cs)
  (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_basics cd cs)
  (Curry_Prelude.toCurryString "leftSupply")) cd cs

d_C_rightSupply :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C_rightSupply cd cs = Curry_Prelude.d_C_apply (d_C_funcCall cd cs)
  (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_basics cd cs)
  (Curry_Prelude.toCurryString "rightSupply")) cd cs

d_C_generate :: Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C_generate x1 cd cs = Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (d_C_funcCall cd cs) (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_basics cd cs)
  (Curry_Prelude.toCurryString "generate")) cd cs) (Curry_Prelude.OP_Cons x1
  (Curry_Prelude.OP_Cons (d_C_coverVar cd cs) Curry_Prelude.OP_List)) cd cs

d_C_toCurryString :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C_toCurryString x1 cd cs = Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (d_C_funcCall cd cs) (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_curryPrelude cd
  cs) (Curry_Prelude.toCurryString "toCurryString")) cd cs)
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Lit
  (Curry_AbstractHaskell.C_Stringc x1)) Curry_Prelude.OP_List) cd cs

d_C_newVars :: Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_newVars cd cs = Curry_Prelude.d_C_zip (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_enumFrom_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
  cd cs) (Curry_Prelude.C_Int (1)) cd cs)

d_C__case_1 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_1 x1 x3 x2 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> x3
  Curry_Prelude.C_False -> d_C__case_0 x3 x2 x1 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_1 x1 x3 x2 l cd
    cs) (d_C__case_1 x1 x3 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_1 x1 x3
    x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_1 x1 x3 x2 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_1" [show x1, show x3, show x2, show x4] info)
  _ -> failCons cd (consFail "TransFunctions._case_1" (showCons x4))

d_C__case_0 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_0 x3 x2 x1 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (d_C_funcCall cd cs) (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_basics cd cs)
    (Curry_Prelude.toCurryString "failCheck")) cd cs) (Curry_Prelude.OP_Cons
    (Curry_Prelude.d_OP_dollar d_C_showQName (Curry_Prelude.d_C_apply
    (Curry_Names.d_C_unRenameQName cd cs) x1 cd cs) cd cs)
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskellGoodies.d_C_list2ac
    (Curry_Prelude.d_C_map d_OP_failCheck_dot_uscore_hash_lambda293 x2 cd cs) cd
    cs) (Curry_Prelude.OP_Cons x3 Curry_Prelude.OP_List))) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_0 x3 x2 x1 l cd
    cs) (d_C__case_0 x3 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_0 x3 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_0 x3 x2 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_0" [show x3, show x2, show x1, show x4] info)
  _ -> failCons cd (consFail "TransFunctions._case_0" (showCons x4))

d_C__case_2 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Expr)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_2 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_foldr (acceptCs id d_C_seqCall) x1
    (Curry_Prelude.d_C_map (Curry_Prelude.d_OP_dot (acceptCs id
    Curry_AbstractHaskell.C_Var) Curry_Prelude.d_C_fst cd cs) x2 cd cs) cd cs
  Curry_Prelude.C_False -> x1
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_2 x1 x2 l cd cs)
    (d_C__case_2 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_2 x1 x2
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_2 x1 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_2" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransFunctions._case_2" (showCons x3))

d_C__case_3 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Num t0 -> t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_3 x1 x3 x2 x4 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> x4
  Curry_Prelude.C_False -> Curry_Prelude.d_C_apply (d_C_wrapDX cd cs)
    (Curry_Prelude.OP_Cons (d_OP_newWrap_dot_wraps_dot_619 x1 x2
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (Curry_Prelude.d_OP_minus
    x1 cd cs) x3 cd cs) (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_fromInt x1
    cd cs) (Curry_Prelude.C_Int (1)) cd cs) cd cs) x4 cd cs)
    Curry_Prelude.OP_List) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_3 x1 x3 x2 x4 l
    cd cs) (d_C__case_3 x1 x3 x2 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_3 x1 x3
    x2 x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_3 x1 x3 x2 x4 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_3" [show x1, show x3, show x2, show x4, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_3" (showCons x5))

nd_C__case_3 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Num t0 -> t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
nd_C__case_3 x1 x3 x2 x4 x5 s cd cs = case x5 of
  Curry_Prelude.C_True -> x4
  Curry_Prelude.C_False -> let s12 = s
    in s12 `seq` (let s11 = leftSupply s12
                      s10 = rightSupply s12
    in s11 `seq` (s10 `seq` Curry_Prelude.nd_C_apply (wrapDX id (d_C_wrapDX cd
    cs)) (Curry_Prelude.OP_Cons (let s9 = leftSupply s10
                                     s7 = rightSupply s10
    in s9 `seq` (s7 `seq` nd_OP_newWrap_dot_wraps_dot_619 x1 x2
    (let s6 = leftSupply s7
         s8 = rightSupply s7
         s2 = leftSupply s8
         s5 = rightSupply s8
    in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq` Curry_Prelude.nd_C_apply
    (let s1 = leftSupply s2
         s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_OP_minus x1
    s0 cd cs) x3 s1 cd cs)) (let s4 = leftSupply s5
                                 s3 = rightSupply s5
    in s4 `seq` (s3 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_fromInt
    x1 s3 cd cs) (Curry_Prelude.C_Int (1)) s4 cd cs)) s6 cd cs)))) x4 s9 cd cs))
    Curry_Prelude.OP_List) s11 cd cs))
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_3 x1 x3 x2 x4 l
    s cd cs) (nd_C__case_3 x1 x3 x2 x4 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_3 x1
    x3 x2 x4 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_3 x1 x3 x2 x4 e
    s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_3" [show x1, show x3, show x2, show x4, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_3" (showCons x5))

d_C__case_4 :: Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_4 x1 cd cs = case x1 of
  Curry_Prelude.C_True -> d_C_wrapDX cd cs
  Curry_Prelude.C_False -> d_C_wrapNX cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_4 l cd cs)
    (d_C__case_4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_4 z cd
    cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_4 e cd $! addCs c
    cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_4" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions._case_4" (showCons x1))

d_C__case_10 :: Curry_Prelude.C_Int -> Curry_AbstractHaskell.C_Expr
  -> (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_10 x2 x3 x4 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> x3
  Curry_Prelude.C_False -> d_C__case_9 x2 x3 x4
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
    x2 (Curry_Prelude.C_Int (1)) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_10 x2 x3 x4 l cd
    cs) (d_C__case_10 x2 x3 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_10 x2
    x3 x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_10 x2 x3 x4 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_10" [show x2, show x3, show x4, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_10" (showCons x5))

nd_C__case_10 :: Curry_Prelude.C_Int -> Curry_AbstractHaskell.C_Expr -> Func
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr)
  Curry_AbstractHaskell.C_Expr -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
nd_C__case_10 x2 x3 x4 x5 s cd cs = case x5 of
  Curry_Prelude.C_True -> x3
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_9 x2 x3 x4
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
    x2 (Curry_Prelude.C_Int (1)) cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_10 x2 x3 x4 l s
    cd cs) (nd_C__case_10 x2 x3 x4 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_10 x2
    x3 x4 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_10 x2 x3 x4 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_10" [show x2, show x3, show x4, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_10" (showCons x5))

d_C__case_9 :: Curry_Prelude.C_Int -> Curry_AbstractHaskell.C_Expr
  -> (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_9 x2 x3 x4 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply x4 (Curry_Prelude.OP_Cons
    (d_C_funId cd cs) (Curry_Prelude.OP_Cons x3 Curry_Prelude.OP_List)) cd cs
  Curry_Prelude.C_False -> d_C__case_8 x2 x3 x4
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
    x2 (Curry_Prelude.C_Int (2)) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_9 x2 x3 x4 l cd
    cs) (d_C__case_9 x2 x3 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_9 x2 x3
    x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_9 x2 x3 x4 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_9" [show x2, show x3, show x4, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_9" (showCons x5))

nd_C__case_9 :: Curry_Prelude.C_Int -> Curry_AbstractHaskell.C_Expr -> Func
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr)
  Curry_AbstractHaskell.C_Expr -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
nd_C__case_9 x2 x3 x4 x5 s cd cs = case x5 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` Curry_Prelude.nd_C_apply x4 (Curry_Prelude.OP_Cons (d_C_funId cd
    cs) (Curry_Prelude.OP_Cons x3 Curry_Prelude.OP_List)) s0 cd cs
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_8 x2 x3 x4
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
    x2 (Curry_Prelude.C_Int (2)) cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_9 x2 x3 x4 l s
    cd cs) (nd_C__case_9 x2 x3 x4 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_9 x2
    x3 x4 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_9 x2 x3 x4 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_9" [show x2, show x3, show x4, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_9" (showCons x5))

d_C__case_8 :: Curry_Prelude.C_Int -> Curry_AbstractHaskell.C_Expr
  -> (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_8 x2 x3 x4 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (d_C_wrapDX cd cs)
    (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply x4 (Curry_Prelude.OP_Cons
    (d_C_funId cd cs) Curry_Prelude.OP_List) cd cs) (Curry_Prelude.OP_Cons x3
    Curry_Prelude.OP_List)) cd cs
  Curry_Prelude.C_False -> d_C__case_7 x2 x3 x4
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
    x2 (Curry_Prelude.C_Int (3)) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_8 x2 x3 x4 l cd
    cs) (d_C__case_8 x2 x3 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_8 x2 x3
    x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_8 x2 x3 x4 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_8" [show x2, show x3, show x4, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_8" (showCons x5))

nd_C__case_8 :: Curry_Prelude.C_Int -> Curry_AbstractHaskell.C_Expr -> Func
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr)
  Curry_AbstractHaskell.C_Expr -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
nd_C__case_8 x2 x3 x4 x5 s cd cs = case x5 of
  Curry_Prelude.C_True -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (wrapDX id (d_C_wrapDX cd
    cs)) (Curry_Prelude.OP_Cons (Curry_Prelude.nd_C_apply x4
    (Curry_Prelude.OP_Cons (d_C_funId cd cs) Curry_Prelude.OP_List) s0 cd cs)
    (Curry_Prelude.OP_Cons x3 Curry_Prelude.OP_List)) s1 cd cs))
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_7 x2 x3 x4
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
    x2 (Curry_Prelude.C_Int (3)) cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_8 x2 x3 x4 l s
    cd cs) (nd_C__case_8 x2 x3 x4 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_8 x2
    x3 x4 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_8 x2 x3 x4 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_8" [show x2, show x3, show x4, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_8" (showCons x5))

d_C__case_7 :: Curry_Prelude.C_Int -> Curry_AbstractHaskell.C_Expr
  -> (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_7 x2 x3 x4 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (d_C_wrapDX cd cs)
    (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply (d_C_wrapDX cd cs)
    (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply x4 (Curry_Prelude.OP_Cons
    (d_C_funId cd cs) Curry_Prelude.OP_List) cd cs) Curry_Prelude.OP_List) cd
    cs) (Curry_Prelude.OP_Cons x3 Curry_Prelude.OP_List)) cd cs
  Curry_Prelude.C_False -> d_C__case_6 x2 x3 x4
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
    x2 (Curry_Prelude.C_Int (4)) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_7 x2 x3 x4 l cd
    cs) (d_C__case_7 x2 x3 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_7 x2 x3
    x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_7 x2 x3 x4 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_7" [show x2, show x3, show x4, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_7" (showCons x5))

nd_C__case_7 :: Curry_Prelude.C_Int -> Curry_AbstractHaskell.C_Expr -> Func
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr)
  Curry_AbstractHaskell.C_Expr -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
nd_C__case_7 x2 x3 x4 x5 s cd cs = case x5 of
  Curry_Prelude.C_True -> let s4 = s
    in s4 `seq` (let s3 = leftSupply s4
                     s2 = rightSupply s4
    in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (wrapDX id (d_C_wrapDX cd
    cs)) (Curry_Prelude.OP_Cons (let s1 = leftSupply s2
                                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (wrapDX id (d_C_wrapDX cd
    cs)) (Curry_Prelude.OP_Cons (Curry_Prelude.nd_C_apply x4
    (Curry_Prelude.OP_Cons (d_C_funId cd cs) Curry_Prelude.OP_List) s0 cd cs)
    Curry_Prelude.OP_List) s1 cd cs)) (Curry_Prelude.OP_Cons x3
    Curry_Prelude.OP_List)) s3 cd cs))
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_6 x2 x3 x4
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
    x2 (Curry_Prelude.C_Int (4)) cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_7 x2 x3 x4 l s
    cd cs) (nd_C__case_7 x2 x3 x4 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_7 x2
    x3 x4 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_7 x2 x3 x4 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_7" [show x2, show x3, show x4, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_7" (showCons x5))

d_C__case_6 :: Curry_Prelude.C_Int -> Curry_AbstractHaskell.C_Expr
  -> (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_6 x2 x3 x4 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (d_C_wrapDX cd cs)
    (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply (d_C_wrapDX cd cs)
    (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply (d_C_wrapDX cd cs)
    (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply x4 (Curry_Prelude.OP_Cons
    (d_C_funId cd cs) Curry_Prelude.OP_List) cd cs) Curry_Prelude.OP_List) cd
    cs) Curry_Prelude.OP_List) cd cs) (Curry_Prelude.OP_Cons x3
    Curry_Prelude.OP_List)) cd cs
  Curry_Prelude.C_False -> d_C__case_5 x2 x3 x4 (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
    cd cs) x2 cd cs) (Curry_Prelude.C_Int (4)) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_6 x2 x3 x4 l cd
    cs) (d_C__case_6 x2 x3 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_6 x2 x3
    x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_6 x2 x3 x4 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_6" [show x2, show x3, show x4, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_6" (showCons x5))

nd_C__case_6 :: Curry_Prelude.C_Int -> Curry_AbstractHaskell.C_Expr -> Func
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr)
  Curry_AbstractHaskell.C_Expr -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
nd_C__case_6 x2 x3 x4 x5 s cd cs = case x5 of
  Curry_Prelude.C_True -> let s6 = s
    in s6 `seq` (let s5 = leftSupply s6
                     s4 = rightSupply s6
    in s5 `seq` (s4 `seq` Curry_Prelude.nd_C_apply (wrapDX id (d_C_wrapDX cd
    cs)) (Curry_Prelude.OP_Cons (let s3 = leftSupply s4
                                     s2 = rightSupply s4
    in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (wrapDX id (d_C_wrapDX cd
    cs)) (Curry_Prelude.OP_Cons (let s1 = leftSupply s2
                                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (wrapDX id (d_C_wrapDX cd
    cs)) (Curry_Prelude.OP_Cons (Curry_Prelude.nd_C_apply x4
    (Curry_Prelude.OP_Cons (d_C_funId cd cs) Curry_Prelude.OP_List) s0 cd cs)
    Curry_Prelude.OP_List) s1 cd cs)) Curry_Prelude.OP_List) s3 cd cs))
    (Curry_Prelude.OP_Cons x3 Curry_Prelude.OP_List)) s5 cd cs))
  Curry_Prelude.C_False -> let s4 = s
    in s4 `seq` (let s3 = leftSupply s4
                     s2 = rightSupply s4
    in s3 `seq` (s2 `seq` nd_C__case_5 x2 x3 x4 (let s1 = leftSupply s2
                                                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply
    (wrapDX (wrapDX id)
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
    cd cs)) x2 s0 cd cs) (Curry_Prelude.C_Int (4)) s1 cd cs)) s3 cd cs))
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_6 x2 x3 x4 l s
    cd cs) (nd_C__case_6 x2 x3 x4 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_6 x2
    x3 x4 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_6 x2 x3 x4 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_6" [show x2, show x3, show x4, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_6" (showCons x5))

d_C__case_5 :: Curry_Prelude.C_Int -> Curry_AbstractHaskell.C_Expr
  -> (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_5 x2 x3 x4 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (d_C_wrapDX cd cs)
    (Curry_Prelude.OP_Cons (d_OP_newWrap_dot_wraps_dot_619
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Num_hash_Prelude_dot_Int cd
    cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Int cd
    cs)
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x2 (Curry_Prelude.C_Int (1)) cd cs) (Curry_Prelude.d_C_apply x4
    (Curry_Prelude.OP_Cons (d_C_funId cd cs) Curry_Prelude.OP_List) cd cs) cd
    cs) (Curry_Prelude.OP_Cons x3 Curry_Prelude.OP_List)) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_5 x2 x3 x4 l cd
    cs) (d_C__case_5 x2 x3 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_5 x2 x3
    x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_5 x2 x3 x4 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_5" [show x2, show x3, show x4, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_5" (showCons x5))

nd_C__case_5 :: Curry_Prelude.C_Int -> Curry_AbstractHaskell.C_Expr -> Func
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr)
  Curry_AbstractHaskell.C_Expr -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
nd_C__case_5 x2 x3 x4 x5 s cd cs = case x5 of
  Curry_Prelude.C_True -> let s8 = s
    in s8 `seq` (let s7 = leftSupply s8
                     s4 = rightSupply s8
    in s7 `seq` (s4 `seq` Curry_Prelude.nd_C_apply (wrapDX id (d_C_wrapDX cd
    cs)) (Curry_Prelude.OP_Cons (let s5 = leftSupply s4
                                     s6 = rightSupply s4
                                     s3 = leftSupply s5
                                     s0 = rightSupply s5
                                     s1 = leftSupply s6
                                     s2 = rightSupply s6
    in s5 `seq` (s6 `seq` (s3 `seq` (s0 `seq` (s1 `seq` (s2 `seq`
    nd_OP_newWrap_dot_wraps_dot_619
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    s0 cd cs)
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
    s1 cd cs)
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x2 (Curry_Prelude.C_Int (1)) cd cs) (Curry_Prelude.nd_C_apply x4
    (Curry_Prelude.OP_Cons (d_C_funId cd cs) Curry_Prelude.OP_List) s2 cd cs) s3
    cd cs)))))) (Curry_Prelude.OP_Cons x3 Curry_Prelude.OP_List)) s7 cd cs))
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_5 x2 x3 x4 l s
    cd cs) (nd_C__case_5 x2 x3 x4 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_5 x2
    x3 x4 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_5 x2 x3 x4 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_5" [show x2, show x3, show x4, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_5" (showCons x5))

d_C__case_12 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Num t0 -> t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> Curry_AbstractHaskell.C_Expr
  -> (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_12 x2 x4 x3 x5 x1 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> x5
  Curry_Prelude.C_False -> d_C__case_11 x5 x1 x2 x4 x3
    (Curry_Prelude.d_C_otherwise cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_12 x2 x4 x3 x5 x1
    l cd cs) (d_C__case_12 x2 x4 x3 x5 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_12 x2
    x4 x3 x5 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_12 x2 x4 x3 x5 x1
    e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_12" [show x2, show x4, show x3, show x5, show x1, show
    x6] info)
  _ -> failCons cd (consFail "TransFunctions._case_12" (showCons x6))

nd_C__case_12 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Num t0 -> t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> Curry_AbstractHaskell.C_Expr
  -> Func (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr)
  Curry_AbstractHaskell.C_Expr -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
nd_C__case_12 x2 x4 x3 x5 x1 x6 s cd cs = case x6 of
  Curry_Prelude.C_True -> x5
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_11 x5 x1 x2 x4 x3 (Curry_Prelude.d_C_otherwise cd cs)
    s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_12 x2 x4 x3 x5
    x1 l s cd cs) (nd_C__case_12 x2 x4 x3 x5 x1 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_12 x2
    x4 x3 x5 x1 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_12 x2 x4 x3 x5
    x1 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_12" [show x2, show x4, show x3, show x5, show x1, show
    x6] info)
  _ -> failCons cd (consFail "TransFunctions._case_12" (showCons x6))

d_C__case_11 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_AbstractHaskell.C_Expr -> (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr) -> Curry_Prelude.OP_uscore_Dict_hash_Num t0
  -> t0 -> Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_11 x5 x1 x2 x4 x3 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> d_OP_wrapCs_dot_mkWraps_dot_614 x1 x2 x3
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (Curry_Prelude.d_OP_minus
    x2 cd cs) x4 cd cs) (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_fromInt x2
    cd cs) (Curry_Prelude.C_Int (1)) cd cs) cd cs) (Curry_Prelude.d_C_apply x1
    (Curry_Prelude.OP_Cons x5 Curry_Prelude.OP_List) cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_11 x5 x1 x2 x4 x3
    l cd cs) (d_C__case_11 x5 x1 x2 x4 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_11 x5
    x1 x2 x4 x3 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_11 x5 x1 x2 x4 x3
    e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_11" [show x5, show x1, show x2, show x4, show x3, show
    x6] info)
  _ -> failCons cd (consFail "TransFunctions._case_11" (showCons x6))

nd_C__case_11 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_AbstractHaskell.C_Expr -> Func (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr) Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.OP_uscore_Dict_hash_Num t0 -> t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Ord t0 -> Curry_Prelude.C_Bool
  -> IDSupply -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
nd_C__case_11 x5 x1 x2 x4 x3 x6 s cd cs = case x6 of
  Curry_Prelude.C_True -> let s11 = s
    in s11 `seq` (let s10 = leftSupply s11
                      s12 = rightSupply s11
                      s7 = leftSupply s12
                      s9 = rightSupply s12
    in s10 `seq` (s12 `seq` (s7 `seq` (s9 `seq` nd_OP_wrapCs_dot_mkWraps_dot_614
    x1 x2 x3 (let s6 = leftSupply s7
                  s8 = rightSupply s7
                  s2 = leftSupply s8
                  s5 = rightSupply s8
    in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq` Curry_Prelude.nd_C_apply
    (let s1 = leftSupply s2
         s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_OP_minus x2
    s0 cd cs) x4 s1 cd cs)) (let s4 = leftSupply s5
                                 s3 = rightSupply s5
    in s4 `seq` (s3 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_fromInt
    x2 s3 cd cs) (Curry_Prelude.C_Int (1)) s4 cd cs)) s6 cd cs))))
    (Curry_Prelude.nd_C_apply x1 (Curry_Prelude.OP_Cons x5
    Curry_Prelude.OP_List) s9 cd cs) s10 cd cs))))
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_11 x5 x1 x2 x4
    x3 l s cd cs) (nd_C__case_11 x5 x1 x2 x4 x3 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_11 x5
    x1 x2 x4 x3 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_11 x5 x1 x2 x4
    x3 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_11" [show x5, show x1, show x2, show x4, show x3, show
    x6] info)
  _ -> failCons cd (consFail "TransFunctions._case_11" (showCons x6))

d_C__case_16 :: Curry_Prelude.C_Int -> Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.C_Bool -> (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_16 x2 x3 x1 x4 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> d_C__case_15 x3 x4 x1 cd cs
  Curry_Prelude.C_False -> d_C__case_14 x2 x3 x1 x4 (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
    cd cs) x2 cd cs) (Curry_Prelude.C_Int (1)) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_16 x2 x3 x1 x4 l
    cd cs) (d_C__case_16 x2 x3 x1 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_16 x2
    x3 x1 x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_16 x2 x3 x1 x4 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_16" [show x2, show x3, show x1, show x4, show x5]
    info)
  _ -> failCons cd (consFail "TransFunctions._case_16" (showCons x5))

nd_C__case_16 :: Curry_Prelude.C_Int -> Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.C_Bool -> Func (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr) Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
nd_C__case_16 x2 x3 x1 x4 x5 s cd cs = case x5 of
  Curry_Prelude.C_True -> let s0 = s in s0 `seq` nd_C__case_15 x3 x4 x1 s0 cd cs
  Curry_Prelude.C_False -> let s4 = s
    in s4 `seq` (let s3 = leftSupply s4
                     s2 = rightSupply s4
    in s3 `seq` (s2 `seq` nd_C__case_14 x2 x3 x1 x4 (let s1 = leftSupply s2
                                                         s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply
    (wrapDX (wrapDX id)
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
    cd cs)) x2 s0 cd cs) (Curry_Prelude.C_Int (1)) s1 cd cs)) s3 cd cs))
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_16 x2 x3 x1 x4 l
    s cd cs) (nd_C__case_16 x2 x3 x1 x4 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_16 x2
    x3 x1 x4 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_16 x2 x3 x1 x4 e
    s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_16" [show x2, show x3, show x1, show x4, show x5]
    info)
  _ -> failCons cd (consFail "TransFunctions._case_16" (showCons x5))

d_C__case_14 :: Curry_Prelude.C_Int -> Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.C_Bool -> (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_14 x2 x3 x1 x4 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply x4 (Curry_Prelude.OP_Cons
    (d_OP_wrapCs_dot_mkWraps_dot_614 x4
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Num_hash_Prelude_dot_Int cd
    cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Int cd
    cs)
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x2 (Curry_Prelude.C_Int (1)) cd cs) (d_C__case_13 x4 x1 cd cs) cd cs)
    (Curry_Prelude.OP_Cons x3 Curry_Prelude.OP_List)) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_14 x2 x3 x1 x4 l
    cd cs) (d_C__case_14 x2 x3 x1 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_14 x2
    x3 x1 x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_14 x2 x3 x1 x4 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_14" [show x2, show x3, show x1, show x4, show x5]
    info)
  _ -> failCons cd (consFail "TransFunctions._case_14" (showCons x5))

nd_C__case_14 :: Curry_Prelude.C_Int -> Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.C_Bool -> Func (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr) Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
nd_C__case_14 x2 x3 x1 x4 x5 s cd cs = case x5 of
  Curry_Prelude.C_True -> let s8 = s
    in s8 `seq` (let s7 = leftSupply s8
                     s4 = rightSupply s8
    in s7 `seq` (s4 `seq` Curry_Prelude.nd_C_apply x4 (Curry_Prelude.OP_Cons
    (let s5 = leftSupply s4
         s6 = rightSupply s4
         s3 = leftSupply s5
         s0 = rightSupply s5
         s1 = leftSupply s6
         s2 = rightSupply s6
    in s5 `seq` (s6 `seq` (s3 `seq` (s0 `seq` (s1 `seq` (s2 `seq`
    nd_OP_wrapCs_dot_mkWraps_dot_614 x4
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    s0 cd cs)
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
    s1 cd cs)
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x2 (Curry_Prelude.C_Int (1)) cd cs) (nd_C__case_13 x4 x1 s2 cd cs) s3 cd
    cs)))))) (Curry_Prelude.OP_Cons x3 Curry_Prelude.OP_List)) s7 cd cs))
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_14 x2 x3 x1 x4 l
    s cd cs) (nd_C__case_14 x2 x3 x1 x4 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_14 x2
    x3 x1 x4 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_14 x2 x3 x1 x4 e
    s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_14" [show x2, show x3, show x1, show x4, show x5]
    info)
  _ -> failCons cd (consFail "TransFunctions._case_14" (showCons x5))

d_C__case_13 :: (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr) -> Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_13 x4 x1 cd cs = case x1 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply x4 (Curry_Prelude.OP_Cons
    (d_C_funId cd cs) Curry_Prelude.OP_List) cd cs
  Curry_Prelude.C_False -> d_C_funId cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_13 x4 l cd cs)
    (d_C__case_13 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_13 x4 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_13 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_13" [show x4, show x1] info)
  _ -> failCons cd (consFail "TransFunctions._case_13" (showCons x1))

nd_C__case_13 :: Func (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr)
  Curry_AbstractHaskell.C_Expr -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
nd_C__case_13 x4 x1 s cd cs = case x1 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` Curry_Prelude.nd_C_apply x4 (Curry_Prelude.OP_Cons (d_C_funId cd
    cs) Curry_Prelude.OP_List) s0 cd cs
  Curry_Prelude.C_False -> d_C_funId cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_13 x4 l s cd cs)
    (nd_C__case_13 x4 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_13 x4
    z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_13 x4 e s cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_13" [show x4, show x1] info)
  _ -> failCons cd (consFail "TransFunctions._case_13" (showCons x1))

d_C__case_15 :: Curry_AbstractHaskell.C_Expr -> (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_15 x3 x4 x1 cd cs = case x1 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply x4 (Curry_Prelude.OP_Cons
    (d_C_funId cd cs) (Curry_Prelude.OP_Cons x3 Curry_Prelude.OP_List)) cd cs
  Curry_Prelude.C_False -> x3
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_15 x3 x4 l cd cs)
    (d_C__case_15 x3 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_15 x3
    x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_15 x3 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_15" [show x3, show x4, show x1] info)
  _ -> failCons cd (consFail "TransFunctions._case_15" (showCons x1))

nd_C__case_15 :: Curry_AbstractHaskell.C_Expr -> Func (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr) Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
nd_C__case_15 x3 x4 x1 s cd cs = case x1 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` Curry_Prelude.nd_C_apply x4 (Curry_Prelude.OP_Cons (d_C_funId cd
    cs) (Curry_Prelude.OP_Cons x3 Curry_Prelude.OP_List)) s0 cd cs
  Curry_Prelude.C_False -> x3
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_15 x3 x4 l s cd
    cs) (nd_C__case_15 x3 x4 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_15 x3
    x4 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_15 x3 x4 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_15" [show x3, show x4, show x1] info)
  _ -> failCons cd (consFail "TransFunctions._case_15" (showCons x1))

d_C__case_17 :: Curry_Prelude.C_Int -> Curry_Classification.C_FuncHOClass
  -> Cover -> ConstStore -> Curry_Prelude.C_Int
d_C__case_17 x13 x5 cd cs = case x5 of
  Curry_Classification.C_FuncHORes x14 -> x14
  Curry_Classification.C_FuncFO -> x13
  Curry_Classification.C_FuncHO -> x13
  Curry_Classification.Choice_C_FuncHOClass d i l r -> narrow d i (d_C__case_17
    x13 l cd cs) (d_C__case_17 x13 r cd cs)
  Curry_Classification.Choices_C_FuncHOClass d i xs -> narrows cs d i (\z ->
    d_C__case_17 x13 z cd cs) xs
  Curry_Classification.Guard_C_FuncHOClass d c e -> guardCons d c (d_C__case_17
    x13 e cd $! addCs c cs)
  Curry_Classification.Fail_C_FuncHOClass d info -> failCons d (traceFail
    "TransFunctions._case_17" [show x13, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_17" (showCons x5))

d_C__case_18 :: Curry_Prelude.C_Bool -> Curry_Classification.C_FuncHOClass
  -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_18 x9 x5 cd cs = case x5 of
  Curry_Classification.C_FuncHO -> Curry_Prelude.C_True
  Curry_Classification.C_FuncFO -> x9
  Curry_Classification.C_FuncHORes x10 -> x9
  Curry_Classification.Choice_C_FuncHOClass d i l r -> narrow d i (d_C__case_18
    x9 l cd cs) (d_C__case_18 x9 r cd cs)
  Curry_Classification.Choices_C_FuncHOClass d i xs -> narrows cs d i (\z ->
    d_C__case_18 x9 z cd cs) xs
  Curry_Classification.Guard_C_FuncHOClass d c e -> guardCons d c (d_C__case_18
    x9 e cd $! addCs c cs)
  Curry_Classification.Fail_C_FuncHOClass d info -> failCons d (traceFail
    "TransFunctions._case_18" [show x9, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_18" (showCons x5))

d_C__case_21 :: Curry_Classification.C_NDClass -> Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Bool -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_21 x4 x7 x6 x1 x12 x11 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> d_C_wrapCs x1 x6 x7 cd cs
  Curry_Prelude.C_False -> d_C__case_20 x4 x7 x6 x1 x12 x11
    (Curry_Classification.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Classification_dot_NDClass
    x4 Curry_Classification.C_ND cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_21 x4 x7 x6 x1
    x12 x11 l cd cs) (d_C__case_21 x4 x7 x6 x1 x12 x11 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_21 x4
    x7 x6 x1 x12 x11 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_21 x4 x7 x6 x1
    x12 x11 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_21" [show x4, show x7, show x6, show x1, show x12
    , show x11, show x2] info)
  _ -> failCons cd (consFail "TransFunctions._case_21" (showCons x2))

d_C__case_20 :: Curry_Classification.C_NDClass -> Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Bool -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_20 x4 x7 x6 x1 x12 x11 x13 cd cs = case x13 of
  Curry_Prelude.C_True -> d_C_newWrap Curry_Prelude.C_False x6 (d_C_wrapCs x1 x6
    x7 cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_19 x7 x6 x1 x12 x11
    (Curry_Prelude.d_C_otherwise cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_20 x4 x7 x6 x1
    x12 x11 l cd cs) (d_C__case_20 x4 x7 x6 x1 x12 x11 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_20 x4
    x7 x6 x1 x12 x11 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_20 x4 x7 x6 x1
    x12 x11 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_20" [show x4, show x7, show x6, show x1, show x12
    , show x11, show x13] info)
  _ -> failCons cd (consFail "TransFunctions._case_20" (showCons x13))

d_C__case_19 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Bool -> Curry_Prelude.C_Int -> Curry_Prelude.C_Bool
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_19 x7 x6 x1 x12 x11 x13 cd cs = case x13 of
  Curry_Prelude.C_True -> d_C_newWrap x11
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x6 x12 cd cs) (d_C_wrapCs x1 x6 x7 cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_19 x7 x6 x1 x12
    x11 l cd cs) (d_C__case_19 x7 x6 x1 x12 x11 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_19 x7
    x6 x1 x12 x11 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_19 x7 x6 x1 x12
    x11 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_19" [show x7, show x6, show x1, show x12, show x11
    , show x13] info)
  _ -> failCons cd (consFail "TransFunctions._case_19" (showCons x13))

d_C__case_22 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_List Curry_Prelude.C_Int
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple3 Curry_Prelude.C_Int
  Curry_Prelude.C_Int (Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple3
  Curry_Prelude.C_Int Curry_Prelude.C_Int Curry_Prelude.C_Int))
d_C__case_22 x1 x2 x3 x4 cd cs = case x4 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Tuple3 x3 x1 Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x5 x6 -> let x7 = Curry_Prelude.d_C_splitAt
                                       (Curry_Prelude.d_C_apply
                                       (Curry_Prelude.d_C_apply
                                       (Curry_Prelude.d_OP_uscore_impl_hash_div_hash_Prelude_dot_Integral_hash_Prelude_dot_Int
                                       cd cs) (Curry_Prelude.d_C_length x2 cd
                                       cs) cd cs) (Curry_Prelude.C_Int (2)) cd
                                       cs) x2 cd cs
                                     x8 = d_OP_splitSupply_dot_uscore_hash_selFP34_hash_ys
                                       x7 cd cs
                                     x9 = d_OP_splitSupply_dot_uscore_hash_selFP35_hash_zs
                                       x7 cd cs
                                     x10 = d_C_splitSupply
                                       (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
                                       x1 (Curry_Prelude.C_Int (1)) cd cs) x8 cd
                                       cs
                                     x11 = d_OP_splitSupply_dot_uscore_hash_selFP31_hash_sl
                                       x10 cd cs
                                     x12 = d_OP_splitSupply_dot_uscore_hash_selFP32_hash_nextl
                                       x10 cd cs
                                     x13 = d_OP_splitSupply_dot_uscore_hash_selFP33_hash_spsl
                                       x10 cd cs
                                     x14 = d_C_splitSupply x12 x9 cd cs
                                     x15 = d_OP_splitSupply_dot_uscore_hash_selFP28_hash_sr
                                       x14 cd cs
                                     x16 = d_OP_splitSupply_dot_uscore_hash_selFP29_hash_nextr
                                       x14 cd cs
                                     x17 = d_OP_splitSupply_dot_uscore_hash_selFP30_hash_spsr
                                       x14 cd cs
    in Curry_Prelude.OP_Tuple3 x1 x16 (Curry_Prelude.OP_Cons
    (Curry_Prelude.OP_Tuple3 x1 x11 x15) (Curry_Prelude.d_OP_plus_plus x13 x17
    cd cs))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_22 x1 x2 x3 l cd
    cs) (d_C__case_22 x1 x2 x3 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_22 x1
    x2 x3 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_22 x1 x2 x3 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_22" [show x1, show x2, show x3, show x4] info)
  _ -> failCons cd (consFail "TransFunctions._case_22" (showCons x4))

d_C__case_32 :: Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> FlatCurry.Curry_Types.C_Expr -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_32 x2 x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_Comb x3 x4 x5 -> let x6 = Curry_Prelude.C_Nothing
    in d_C__case_31 x6 x5 x4 x3 cd cs
  FlatCurry.Curry_Types.C_Var x37 -> x2
  FlatCurry.Curry_Types.C_Lit x38 -> x2
  FlatCurry.Curry_Types.C_Let x39 x40 -> x2
  FlatCurry.Curry_Types.C_Free x41 x42 -> x2
  FlatCurry.Curry_Types.C_Or x43 x44 -> x2
  FlatCurry.Curry_Types.C_Case x45 x46 x47 -> x2
  FlatCurry.Curry_Types.C_Typed x48 x49 -> x2
  FlatCurry.Curry_Types.Choice_C_Expr d i l r -> narrow d i (d_C__case_32 x2 l
    cd cs) (d_C__case_32 x2 r cd cs)
  FlatCurry.Curry_Types.Choices_C_Expr d i xs -> narrows cs d i (\z ->
    d_C__case_32 x2 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Expr d c e -> guardCons d c (d_C__case_32 x2 e
    cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Expr d info -> failCons d (traceFail
    "TransFunctions._case_32" [show x2, show x1] info)
  _ -> failCons cd (consFail "TransFunctions._case_32" (showCons x1))

d_C__case_31 :: Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> FlatCurry.Curry_Types.C_CombType -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_31 x6 x5 x4 x3 cd cs = case x3 of
  FlatCurry.Curry_Types.C_ConsCall -> d_C__case_30 x4 x5 cd cs
  FlatCurry.Curry_Types.C_FuncCall -> x6
  FlatCurry.Curry_Types.C_FuncPartCall x35 -> x6
  FlatCurry.Curry_Types.C_ConsPartCall x36 -> x6
  FlatCurry.Curry_Types.Choice_C_CombType d i l r -> narrow d i (d_C__case_31 x6
    x5 x4 l cd cs) (d_C__case_31 x6 x5 x4 r cd cs)
  FlatCurry.Curry_Types.Choices_C_CombType d i xs -> narrows cs d i (\z ->
    d_C__case_31 x6 x5 x4 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_CombType d c e -> guardCons d c (d_C__case_31 x6
    x5 x4 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_CombType d info -> failCons d (traceFail
    "TransFunctions._case_31" [show x6, show x5, show x4, show x3] info)
  _ -> failCons cd (consFail "TransFunctions._case_31" (showCons x3))

d_C__case_30 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_30 x4 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x7 x8 -> let x9 = Curry_Prelude.C_Nothing
    in d_C__case_29 x9 x8 x4 x7 cd cs
  Curry_Prelude.OP_List -> d_C__case_23 x4
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) x4 (Curry_Prelude.d_C_apply (Curry_Names.d_C_renameQName cd cs)
    (Curry_Prelude.OP_Tuple2 (Curry_Prelude.toCurryString "Prelude")
    (Curry_Prelude.toCurryString "[]")) cd cs) cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_30 x4 l cd cs)
    (d_C__case_30 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_30 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_30 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_30" [show x4, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_30" (showCons x5))

d_C__case_23 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_23 x4 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.C_Just Curry_Prelude.OP_List
  Curry_Prelude.C_False -> Curry_Prelude.C_Nothing
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_23 x4 l cd cs)
    (d_C__case_23 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_23 x4 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_23 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_23" [show x4, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_23" (showCons x5))

d_C__case_29 :: Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> FlatCurry.Curry_Types.C_Expr
  -> Cover -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C__case_29 x9 x8 x4 x7 cd cs = case x7 of
  FlatCurry.Curry_Types.C_Lit x10 -> let x11 = Curry_Prelude.C_Nothing
    in d_C__case_28 x11 x8 x4 x10 cd cs
  FlatCurry.Curry_Types.C_Var x20 -> x9
  FlatCurry.Curry_Types.C_Comb x21 x22 x23 -> x9
  FlatCurry.Curry_Types.C_Let x24 x25 -> x9
  FlatCurry.Curry_Types.C_Free x26 x27 -> x9
  FlatCurry.Curry_Types.C_Or x28 x29 -> x9
  FlatCurry.Curry_Types.C_Case x30 x31 x32 -> x9
  FlatCurry.Curry_Types.C_Typed x33 x34 -> x9
  FlatCurry.Curry_Types.Choice_C_Expr d i l r -> narrow d i (d_C__case_29 x9 x8
    x4 l cd cs) (d_C__case_29 x9 x8 x4 r cd cs)
  FlatCurry.Curry_Types.Choices_C_Expr d i xs -> narrows cs d i (\z ->
    d_C__case_29 x9 x8 x4 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Expr d c e -> guardCons d c (d_C__case_29 x9 x8
    x4 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Expr d info -> failCons d (traceFail
    "TransFunctions._case_29" [show x9, show x8, show x4, show x7] info)
  _ -> failCons cd (consFail "TransFunctions._case_29" (showCons x7))

d_C__case_28 :: Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> FlatCurry.Curry_Types.C_Literal -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_28 x11 x8 x4 x10 cd cs = case x10 of
  FlatCurry.Curry_Types.C_Charc x12 -> d_C__case_27 x4 x12 x8 cd cs
  FlatCurry.Curry_Types.C_Intc x18 -> x11
  FlatCurry.Curry_Types.C_Floatc x19 -> x11
  FlatCurry.Curry_Types.Choice_C_Literal d i l r -> narrow d i (d_C__case_28 x11
    x8 x4 l cd cs) (d_C__case_28 x11 x8 x4 r cd cs)
  FlatCurry.Curry_Types.Choices_C_Literal d i xs -> narrows cs d i (\z ->
    d_C__case_28 x11 x8 x4 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Literal d c e -> guardCons d c (d_C__case_28 x11
    x8 x4 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Literal d info -> failCons d (traceFail
    "TransFunctions._case_28" [show x11, show x8, show x4, show x10] info)
  _ -> failCons cd (consFail "TransFunctions._case_28" (showCons x10))

d_C__case_27 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Char -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Cover -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C__case_27 x4 x12 x8 cd cs = case x8 of
  Curry_Prelude.OP_Cons x13 x14 -> d_C__case_26 x4 x13 x12 x14 cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.C_Nothing
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_27 x4 x12 l cd
    cs) (d_C__case_27 x4 x12 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_27 x4
    x12 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_27 x4 x12 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_27" [show x4, show x12, show x8] info)
  _ -> failCons cd (consFail "TransFunctions._case_27" (showCons x8))

d_C__case_26 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> FlatCurry.Curry_Types.C_Expr -> Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_26 x4 x13 x12 x14 cd cs = case x14 of
  Curry_Prelude.OP_List -> d_C__case_25 x4 x13 x12
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) x4 (Curry_Prelude.d_C_apply (Curry_Names.d_C_renameQName cd cs)
    (Curry_Prelude.OP_Tuple2 (Curry_Prelude.toCurryString "Prelude")
    (Curry_Prelude.toCurryString ":")) cd cs) cd cs) cd cs
  Curry_Prelude.OP_Cons x16 x17 -> Curry_Prelude.C_Nothing
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_26 x4 x13 x12 l
    cd cs) (d_C__case_26 x4 x13 x12 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_26 x4
    x13 x12 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_26 x4 x13 x12 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_26" [show x4, show x13, show x12, show x14] info)
  _ -> failCons cd (consFail "TransFunctions._case_26" (showCons x14))

d_C__case_25 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> FlatCurry.Curry_Types.C_Expr -> Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_25 x4 x13 x12 x14 cd cs = case x14 of
  Curry_Prelude.C_True -> d_C__case_24 x13 x12
    (d_OP_getString_dot_getString_tick_dot_511 x13 cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.C_Nothing
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_25 x4 x13 x12 l
    cd cs) (d_C__case_25 x4 x13 x12 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_25 x4
    x13 x12 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_25 x4 x13 x12 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_25" [show x4, show x13, show x12, show x14] info)
  _ -> failCons cd (consFail "TransFunctions._case_25" (showCons x14))

d_C__case_24 :: FlatCurry.Curry_Types.C_Expr -> Curry_Prelude.C_Char
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C__case_24 x13 x12 x16 cd cs = case x16 of
  Curry_Prelude.C_Just x15 -> Curry_Prelude.C_Just (Curry_Prelude.OP_Cons x12
    x15)
  Curry_Prelude.C_Nothing -> Curry_Prelude.C_Nothing
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (d_C__case_24 x13 x12 l cd
    cs) (d_C__case_24 x13 x12 r cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> d_C__case_24 x13
    x12 z cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (d_C__case_24 x13 x12 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail
    "TransFunctions._case_24" [show x13, show x12, show x16] info)
  _ -> failCons cd (consFail "TransFunctions._case_24" (showCons x16))

d_C__case_41 :: Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> FlatCurry.Curry_Types.C_Expr -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_41 x2 x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_Comb x3 x4 x5 -> let x6 = Curry_Prelude.C_Nothing
    in d_C__case_40 x6 x5 x4 x3 cd cs
  FlatCurry.Curry_Types.C_Var x37 -> x2
  FlatCurry.Curry_Types.C_Lit x38 -> x2
  FlatCurry.Curry_Types.C_Let x39 x40 -> x2
  FlatCurry.Curry_Types.C_Free x41 x42 -> x2
  FlatCurry.Curry_Types.C_Or x43 x44 -> x2
  FlatCurry.Curry_Types.C_Case x45 x46 x47 -> x2
  FlatCurry.Curry_Types.C_Typed x48 x49 -> x2
  FlatCurry.Curry_Types.Choice_C_Expr d i l r -> narrow d i (d_C__case_41 x2 l
    cd cs) (d_C__case_41 x2 r cd cs)
  FlatCurry.Curry_Types.Choices_C_Expr d i xs -> narrows cs d i (\z ->
    d_C__case_41 x2 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Expr d c e -> guardCons d c (d_C__case_41 x2 e
    cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Expr d info -> failCons d (traceFail
    "TransFunctions._case_41" [show x2, show x1] info)
  _ -> failCons cd (consFail "TransFunctions._case_41" (showCons x1))

d_C__case_40 :: Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> FlatCurry.Curry_Types.C_CombType -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_40 x6 x5 x4 x3 cd cs = case x3 of
  FlatCurry.Curry_Types.C_ConsCall -> d_C__case_39 x4 x5 cd cs
  FlatCurry.Curry_Types.C_FuncCall -> x6
  FlatCurry.Curry_Types.C_FuncPartCall x35 -> x6
  FlatCurry.Curry_Types.C_ConsPartCall x36 -> x6
  FlatCurry.Curry_Types.Choice_C_CombType d i l r -> narrow d i (d_C__case_40 x6
    x5 x4 l cd cs) (d_C__case_40 x6 x5 x4 r cd cs)
  FlatCurry.Curry_Types.Choices_C_CombType d i xs -> narrows cs d i (\z ->
    d_C__case_40 x6 x5 x4 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_CombType d c e -> guardCons d c (d_C__case_40 x6
    x5 x4 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_CombType d info -> failCons d (traceFail
    "TransFunctions._case_40" [show x6, show x5, show x4, show x3] info)
  _ -> failCons cd (consFail "TransFunctions._case_40" (showCons x3))

d_C__case_39 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_39 x4 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x7 x8 -> let x9 = Curry_Prelude.C_Nothing
    in d_C__case_38 x9 x8 x4 x7 cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.C_Nothing
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_39 x4 l cd cs)
    (d_C__case_39 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_39 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_39 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_39" [show x4, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_39" (showCons x5))

d_C__case_38 :: Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> FlatCurry.Curry_Types.C_Expr
  -> Cover -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C__case_38 x9 x8 x4 x7 cd cs = case x7 of
  FlatCurry.Curry_Types.C_Lit x10 -> let x11 = Curry_Prelude.C_Nothing
    in d_C__case_37 x11 x8 x4 x10 cd cs
  FlatCurry.Curry_Types.C_Var x20 -> x9
  FlatCurry.Curry_Types.C_Comb x21 x22 x23 -> x9
  FlatCurry.Curry_Types.C_Let x24 x25 -> x9
  FlatCurry.Curry_Types.C_Free x26 x27 -> x9
  FlatCurry.Curry_Types.C_Or x28 x29 -> x9
  FlatCurry.Curry_Types.C_Case x30 x31 x32 -> x9
  FlatCurry.Curry_Types.C_Typed x33 x34 -> x9
  FlatCurry.Curry_Types.Choice_C_Expr d i l r -> narrow d i (d_C__case_38 x9 x8
    x4 l cd cs) (d_C__case_38 x9 x8 x4 r cd cs)
  FlatCurry.Curry_Types.Choices_C_Expr d i xs -> narrows cs d i (\z ->
    d_C__case_38 x9 x8 x4 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Expr d c e -> guardCons d c (d_C__case_38 x9 x8
    x4 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Expr d info -> failCons d (traceFail
    "TransFunctions._case_38" [show x9, show x8, show x4, show x7] info)
  _ -> failCons cd (consFail "TransFunctions._case_38" (showCons x7))

d_C__case_37 :: Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> FlatCurry.Curry_Types.C_Literal -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_37 x11 x8 x4 x10 cd cs = case x10 of
  FlatCurry.Curry_Types.C_Charc x12 -> d_C__case_36 x4 x12 x8 cd cs
  FlatCurry.Curry_Types.C_Intc x18 -> x11
  FlatCurry.Curry_Types.C_Floatc x19 -> x11
  FlatCurry.Curry_Types.Choice_C_Literal d i l r -> narrow d i (d_C__case_37 x11
    x8 x4 l cd cs) (d_C__case_37 x11 x8 x4 r cd cs)
  FlatCurry.Curry_Types.Choices_C_Literal d i xs -> narrows cs d i (\z ->
    d_C__case_37 x11 x8 x4 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Literal d c e -> guardCons d c (d_C__case_37 x11
    x8 x4 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Literal d info -> failCons d (traceFail
    "TransFunctions._case_37" [show x11, show x8, show x4, show x10] info)
  _ -> failCons cd (consFail "TransFunctions._case_37" (showCons x10))

d_C__case_36 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Char -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Cover -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C__case_36 x4 x12 x8 cd cs = case x8 of
  Curry_Prelude.OP_Cons x13 x14 -> d_C__case_35 x4 x13 x12 x14 cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.C_Nothing
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_36 x4 x12 l cd
    cs) (d_C__case_36 x4 x12 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_36 x4
    x12 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_36 x4 x12 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_36" [show x4, show x12, show x8] info)
  _ -> failCons cd (consFail "TransFunctions._case_36" (showCons x8))

d_C__case_35 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> FlatCurry.Curry_Types.C_Expr -> Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_35 x4 x13 x12 x14 cd cs = case x14 of
  Curry_Prelude.OP_List -> d_C__case_34 x4 x13 x12
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) x4 (Curry_Prelude.d_C_apply (Curry_Names.d_C_renameQName cd cs)
    (Curry_Prelude.OP_Tuple2 (Curry_Prelude.toCurryString "Prelude")
    (Curry_Prelude.toCurryString ":")) cd cs) cd cs) cd cs
  Curry_Prelude.OP_Cons x16 x17 -> Curry_Prelude.C_Nothing
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_35 x4 x13 x12 l
    cd cs) (d_C__case_35 x4 x13 x12 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_35 x4
    x13 x12 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_35 x4 x13 x12 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_35" [show x4, show x13, show x12, show x14] info)
  _ -> failCons cd (consFail "TransFunctions._case_35" (showCons x14))

d_C__case_34 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> FlatCurry.Curry_Types.C_Expr -> Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_34 x4 x13 x12 x14 cd cs = case x14 of
  Curry_Prelude.C_True -> d_C__case_33 x13 x12
    (d_OP_getString_dot_getString_tick_dot_511 x13 cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.C_Nothing
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_34 x4 x13 x12 l
    cd cs) (d_C__case_34 x4 x13 x12 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_34 x4
    x13 x12 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_34 x4 x13 x12 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_34" [show x4, show x13, show x12, show x14] info)
  _ -> failCons cd (consFail "TransFunctions._case_34" (showCons x14))

d_C__case_33 :: FlatCurry.Curry_Types.C_Expr -> Curry_Prelude.C_Char
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C__case_33 x13 x12 x16 cd cs = case x16 of
  Curry_Prelude.C_Just x15 -> Curry_Prelude.C_Just (Curry_Prelude.OP_Cons x12
    x15)
  Curry_Prelude.C_Nothing -> Curry_Prelude.C_Nothing
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (d_C__case_33 x13 x12 l cd
    cs) (d_C__case_33 x13 x12 r cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> d_C__case_33 x13
    x12 z cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (d_C__case_33 x13 x12 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail
    "TransFunctions._case_33" [show x13, show x12, show x16] info)
  _ -> failCons cd (consFail "TransFunctions._case_33" (showCons x16))

d_C__case_44 :: Curry_Prelude.C_Bool -> Curry_Classification.C_FuncHOClass
  -> Curry_Prelude.C_Bool -> Curry_Classification.C_NDClass
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> C_IOES
  C_State (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Int)
  Curry_AbstractHaskell.C_Expr)
d_C__case_44 x3 x1 x4 x2 x8 x5 x7 x10 cd cs = case x10 of
  Curry_Prelude.C_True -> d_OP_gt_plus_eq (d_C_takeNextID cd cs)
    (d_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256_dot_uscore_hash_lambda257_dot_uscore_hash_lambda258_dot_uscore_hash_lambda259
    x8 x7 x5) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_OP_dollar (d_C_genIds x7)
    (let x9 = Curry_AbstractHaskellGoodies.d_C_applyF x5
           (Curry_Prelude.d_OP_plus_plus x8 (Curry_Prelude.OP_Cons (d_C_coverVar
           cd cs) (Curry_Prelude.OP_Cons (d_C_constStoreVar cd cs)
           Curry_Prelude.OP_List)) cd cs) cd cs
    in d_C__case_43 x9 x3 x8 x5 x1 cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_44 x3 x1 x4 x2 x8
    x5 x7 l cd cs) (d_C__case_44 x3 x1 x4 x2 x8 x5 x7 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_44 x3
    x1 x4 x2 x8 x5 x7 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_44 x3 x1 x4 x2 x8
    x5 x7 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_44" [show x3, show x1, show x4, show x2, show x8, show
    x5, show x7, show x10] info)
  _ -> failCons cd (consFail "TransFunctions._case_44" (showCons x10))

nd_C__case_44 :: Curry_Prelude.C_Bool -> Curry_Classification.C_FuncHOClass
  -> Curry_Prelude.C_Bool -> Curry_Classification.C_NDClass
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> C_IOES C_State (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
nd_C__case_44 x3 x1 x4 x2 x8 x5 x7 x10 s cd cs = case x10 of
  Curry_Prelude.C_True -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_takeNextID s0 cd cs) (wrapNX id
    (nd_OP_trExpr_dot_uscore_hash_lambda253_dot_uscore_hash_lambda254_dot_uscore_hash_lambda255_dot_uscore_hash_lambda256_dot_uscore_hash_lambda257_dot_uscore_hash_lambda258_dot_uscore_hash_lambda259
    x8 x7 x5)) s1 cd cs))
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id (nd_C_genIds x7))
    (let x9 = Curry_AbstractHaskellGoodies.d_C_applyF x5
           (Curry_Prelude.d_OP_plus_plus x8 (Curry_Prelude.OP_Cons (d_C_coverVar
           cd cs) (Curry_Prelude.OP_Cons (d_C_constStoreVar cd cs)
           Curry_Prelude.OP_List)) cd cs) cd cs
    in d_C__case_43 x9 x3 x8 x5 x1 cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_44 x3 x1 x4 x2
    x8 x5 x7 l s cd cs) (nd_C__case_44 x3 x1 x4 x2 x8 x5 x7 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_44 x3
    x1 x4 x2 x8 x5 x7 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_44 x3 x1 x4 x2
    x8 x5 x7 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_44" [show x3, show x1, show x4, show x2, show x8, show
    x5, show x7, show x10] info)
  _ -> failCons cd (consFail "TransFunctions._case_44" (showCons x10))

d_C__case_43 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.C_Bool
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Classification.C_FuncHOClass -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_43 x9 x3 x8 x5 x1 cd cs = case x1 of
  Curry_Classification.C_FuncHORes x10 -> d_C__case_42 x3 x8 x5 x10
    (Curry_Prelude.d_C_not x3 cd cs) cd cs
  Curry_Classification.C_FuncFO -> x9
  Curry_Classification.C_FuncHO -> x9
  Curry_Classification.Choice_C_FuncHOClass d i l r -> narrow d i (d_C__case_43
    x9 x3 x8 x5 l cd cs) (d_C__case_43 x9 x3 x8 x5 r cd cs)
  Curry_Classification.Choices_C_FuncHOClass d i xs -> narrows cs d i (\z ->
    d_C__case_43 x9 x3 x8 x5 z cd cs) xs
  Curry_Classification.Guard_C_FuncHOClass d c e -> guardCons d c (d_C__case_43
    x9 x3 x8 x5 e cd $! addCs c cs)
  Curry_Classification.Fail_C_FuncHOClass d info -> failCons d (traceFail
    "TransFunctions._case_43" [show x9, show x3, show x8, show x5, show x1]
    info)
  _ -> failCons cd (consFail "TransFunctions._case_43" (showCons x1))

d_C__case_42 :: Curry_Prelude.C_Bool -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_42 x3 x8 x5 x10 x11 cd cs = case x11 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_dollar (d_C_wrapDHO x10)
    (Curry_AbstractHaskellGoodies.d_C_applyF x5 (Curry_Prelude.d_OP_plus_plus x8
    (Curry_Prelude.OP_Cons (d_C_coverVar cd cs) (Curry_Prelude.OP_Cons
    (d_C_constStoreVar cd cs) Curry_Prelude.OP_List)) cd cs) cd cs) cd cs
  Curry_Prelude.C_False -> Curry_AbstractHaskellGoodies.d_C_applyF x5
    (Curry_Prelude.d_OP_plus_plus x8 (Curry_Prelude.OP_Cons (d_C_coverVar cd cs)
    (Curry_Prelude.OP_Cons (d_C_constStoreVar cd cs) Curry_Prelude.OP_List)) cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_42 x3 x8 x5 x10 l
    cd cs) (d_C__case_42 x3 x8 x5 x10 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_42 x3
    x8 x5 x10 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_42 x3 x8 x5 x10 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_42" [show x3, show x8, show x5, show x10, show x11]
    info)
  _ -> failCons cd (consFail "TransFunctions._case_42" (showCons x11))

d_C__case_46 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> FlatCurry.Curry_Types.C_Expr -> FlatCurry.Curry_Types.C_CombType -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
d_C__case_46 x5 x6 x1 x4 cd cs = case x4 of
  FlatCurry.Curry_Types.C_ConsCall -> d_C__case_45 x1 x6 x5 (d_C_getString x1 cd
    cs) cd cs
  FlatCurry.Curry_Types.C_FuncCall -> d_OP_gt_plus_eq (d_C_getCompOption
    d_OP_trExpr_dot_uscore_hash_lambda252 cd cs)
    (d_OP_trExpr_dot_uscore_hash_lambda253 x6 x5) cd cs
  FlatCurry.Curry_Types.C_FuncPartCall x8 -> d_OP_gt_plus_eq (d_C_getCompOption
    d_OP_trExpr_dot_uscore_hash_lambda262 cd cs)
    (d_OP_trExpr_dot_uscore_hash_lambda263 x8 x6 x5) cd cs
  FlatCurry.Curry_Types.C_ConsPartCall x9 -> d_OP_gt_plus_eq (d_C_isDetMode cd
    cs) (d_OP_trExpr_dot_uscore_hash_lambda269 x9 x6 x5) cd cs
  FlatCurry.Curry_Types.Choice_C_CombType d i l r -> narrow d i (d_C__case_46 x5
    x6 x1 l cd cs) (d_C__case_46 x5 x6 x1 r cd cs)
  FlatCurry.Curry_Types.Choices_C_CombType d i xs -> narrows cs d i (\z ->
    d_C__case_46 x5 x6 x1 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_CombType d c e -> guardCons d c (d_C__case_46 x5
    x6 x1 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_CombType d info -> failCons d (traceFail
    "TransFunctions._case_46" [show x5, show x6, show x1, show x4] info)
  _ -> failCons cd (consFail "TransFunctions._case_46" (showCons x4))

nd_C__case_46 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> FlatCurry.Curry_Types.C_Expr -> FlatCurry.Curry_Types.C_CombType
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
nd_C__case_46 x5 x6 x1 x4 s cd cs = case x4 of
  FlatCurry.Curry_Types.C_ConsCall -> let s0 = s
    in s0 `seq` nd_C__case_45 x1 x6 x5 (d_C_getString x1 cd cs) s0 cd cs
  FlatCurry.Curry_Types.C_FuncCall -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getCompOption (wrapDX id
    d_OP_trExpr_dot_uscore_hash_lambda252) s0 cd cs) (wrapNX id
    (nd_OP_trExpr_dot_uscore_hash_lambda253 x6 x5)) s1 cd cs))
  FlatCurry.Curry_Types.C_FuncPartCall x8 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getCompOption (wrapDX id
    d_OP_trExpr_dot_uscore_hash_lambda262) s0 cd cs) (wrapNX id
    (nd_OP_trExpr_dot_uscore_hash_lambda263 x8 x6 x5)) s1 cd cs))
  FlatCurry.Curry_Types.C_ConsPartCall x9 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_isDetMode s0 cd cs) (wrapNX id
    (nd_OP_trExpr_dot_uscore_hash_lambda269 x9 x6 x5)) s1 cd cs))
  FlatCurry.Curry_Types.Choice_C_CombType d i l r -> narrow d i (nd_C__case_46
    x5 x6 x1 l s cd cs) (nd_C__case_46 x5 x6 x1 r s cd cs)
  FlatCurry.Curry_Types.Choices_C_CombType d i xs -> narrows cs d i (\z ->
    nd_C__case_46 x5 x6 x1 z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_CombType d c e -> guardCons d c (nd_C__case_46
    x5 x6 x1 e s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_CombType d info -> failCons d (traceFail
    "TransFunctions._case_46" [show x5, show x6, show x1, show x4] info)
  _ -> failCons cd (consFail "TransFunctions._case_46" (showCons x4))

d_C__case_45 :: FlatCurry.Curry_Types.C_Expr -> Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_Expr -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
d_C__case_45 x1 x6 x5 x8 cd cs = case x8 of
  Curry_Prelude.C_Just x7 -> d_C_returnM (Curry_Prelude.OP_Tuple2
    Curry_Prelude.OP_List (d_C_toCurryString x7 cd cs)) cd cs
  Curry_Prelude.C_Nothing -> d_OP_gt_plus_eq (d_C_renameCons x5 cd cs)
    (d_OP_trExpr_dot_uscore_hash_lambda250 x6) cd cs
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (d_C__case_45 x1 x6 x5 l cd
    cs) (d_C__case_45 x1 x6 x5 r cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> d_C__case_45 x1
    x6 x5 z cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (d_C__case_45 x1 x6 x5 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail
    "TransFunctions._case_45" [show x1, show x6, show x5, show x8] info)
  _ -> failCons cd (consFail "TransFunctions._case_45" (showCons x8))

nd_C__case_45 :: FlatCurry.Curry_Types.C_Expr -> Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_Expr -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Int) Curry_AbstractHaskell.C_Expr)
nd_C__case_45 x1 x6 x5 x8 s cd cs = case x8 of
  Curry_Prelude.C_Just x7 -> let s0 = s
    in s0 `seq` nd_C_returnM (Curry_Prelude.OP_Tuple2 Curry_Prelude.OP_List
    (d_C_toCurryString x7 cd cs)) s0 cd cs
  Curry_Prelude.C_Nothing -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_renameCons x5 s0 cd cs) (wrapNX
    id (nd_OP_trExpr_dot_uscore_hash_lambda250 x6)) s1 cd cs))
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (nd_C__case_45 x1 x6 x5 l s
    cd cs) (nd_C__case_45 x1 x6 x5 r s cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> nd_C__case_45 x1
    x6 x5 z s cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c (nd_C__case_45 x1 x6 x5 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail
    "TransFunctions._case_45" [show x1, show x6, show x5, show x8] info)
  _ -> failCons cd (consFail "TransFunctions._case_45" (showCons x8))

d_C__case_48 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Cover -> ConstStore -> C_IOES C_State
  Curry_AbstractHaskell.C_Expr
d_C__case_48 x4 x3 cd cs = case x3 of
  Curry_Prelude.OP_List -> d_C_returnM x4 cd cs
  Curry_Prelude.OP_Cons x5 x6 -> d_C__case_47 x4 x5 x6 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_48 x4 l cd cs)
    (d_C__case_48 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_48 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_48 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_48" [show x4, show x3] info)
  _ -> failCons cd (consFail "TransFunctions._case_48" (showCons x3))

nd_C__case_48 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> IDSupply -> Cover -> ConstStore -> C_IOES C_State
  Curry_AbstractHaskell.C_Expr
nd_C__case_48 x4 x3 s cd cs = case x3 of
  Curry_Prelude.OP_List -> let s0 = s in s0 `seq` nd_C_returnM x4 s0 cd cs
  Curry_Prelude.OP_Cons x5 x6 -> let s0 = s
    in s0 `seq` nd_C__case_47 x4 x5 x6 s0 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_48 x4 l s cd
    cs) (nd_C__case_48 x4 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_48 x4
    z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C__case_48 x4 e s cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_48" [show x4, show x3] info)
  _ -> failCons cd (consFail "TransFunctions._case_48" (showCons x3))

d_C__case_47 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore -> C_IOES
  C_State Curry_AbstractHaskell.C_Expr
d_C__case_47 x4 x5 x6 cd cs = case x6 of
  Curry_Prelude.OP_List -> d_C_letIdVar (Curry_Prelude.OP_Cons
    (Curry_Prelude.OP_Tuple2 (d_C_supplyName x5 cd cs) (d_C_topSupplyVar cd cs))
    Curry_Prelude.OP_List) x4 cd cs
  Curry_Prelude.OP_Cons x7 x8 -> d_C_failM (Curry_Prelude.toCurryString
    "TransFunctions.trCompleteExpr") cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_47 x4 x5 l cd
    cs) (d_C__case_47 x4 x5 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_47 x4
    x5 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_47 x4 x5 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_47" [show x4, show x5, show x6] info)
  _ -> failCons cd (consFail "TransFunctions._case_47" (showCons x6))

nd_C__case_47 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_Expr
nd_C__case_47 x4 x5 x6 s cd cs = case x6 of
  Curry_Prelude.OP_List -> let s0 = s
    in s0 `seq` nd_C_letIdVar (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple2
    (d_C_supplyName x5 cd cs) (d_C_topSupplyVar cd cs)) Curry_Prelude.OP_List)
    x4 s0 cd cs
  Curry_Prelude.OP_Cons x7 x8 -> let s0 = s
    in s0 `seq` nd_C_failM (Curry_Prelude.toCurryString
    "TransFunctions.trCompleteExpr") s0 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_47 x4 x5 l s cd
    cs) (nd_C__case_47 x4 x5 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_47 x4
    x5 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C__case_47 x4 x5 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_47" [show x4, show x5, show x6] info)
  _ -> failCons cd (consFail "TransFunctions._case_47" (showCons x6))

d_C__case_49 :: Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int
d_C__case_49 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> x5
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_49 l cd cs)
    (d_C__case_49 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_49 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_49 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_49" [show x3] info)
  _ -> failCons cd (consFail "TransFunctions._case_49" (showCons x3))

d_C__case_50 :: Curry_Prelude.OP_List Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int
d_C__case_50 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_50 x2 l cd cs)
    (d_C__case_50 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_50 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_50 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_50" [show x2, show x3] info)
  _ -> failCons cd (consFail "TransFunctions._case_50" (showCons x3))

d_C__case_51 :: Curry_Prelude.C_Bool -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr
d_C__case_51 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons (d_C_topSupplyVar cd cs)
    Curry_Prelude.OP_List
  Curry_Prelude.C_False -> Curry_Prelude.OP_List
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_51 x1 l cd cs)
    (d_C__case_51 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_51 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_51 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_51" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions._case_51" (showCons x2))

d_C__case_52 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_52 x8 x3 x14 x5 x16 cd cs = case x16 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (d_C_liftFail cd cs)
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x5)
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x8)
    Curry_Prelude.OP_List)) cd cs
  Curry_Prelude.C_False -> d_C_traceFail (Curry_AbstractHaskell.C_Var x5) x14
    (Curry_Prelude.d_C_map (d_C_cvVar cd cs) x3 cd cs)
    (Curry_AbstractHaskell.C_Var x8) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_52 x8 x3 x14 x5 l
    cd cs) (d_C__case_52 x8 x3 x14 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_52 x8
    x3 x14 x5 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_52 x8 x3 x14 x5 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_52" [show x8, show x3, show x14, show x5, show x16]
    info)
  _ -> failCons cd (consFail "TransFunctions._case_52" (showCons x16))

d_C__case_62 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_62 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_61 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_62 l cd cs)
    (d_C__case_62 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_62 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_62 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_62" [show x3] info)
  _ -> failCons cd (consFail "TransFunctions._case_62" (showCons x3))

d_C__case_61 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_61 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_60 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_61 l cd cs)
    (d_C__case_61 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_61 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_61 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_61" [show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_61" (showCons x5))

d_C__case_60 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_60 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_59 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_60 l cd cs)
    (d_C__case_60 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_60 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_60 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_60" [show x7] info)
  _ -> failCons cd (consFail "TransFunctions._case_60" (showCons x7))

d_C__case_59 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_59 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_58 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_59 l cd cs)
    (d_C__case_59 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_59 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_59 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_59" [show x9] info)
  _ -> failCons cd (consFail "TransFunctions._case_59" (showCons x9))

d_C__case_58 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_58 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_57 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_58 l cd cs)
    (d_C__case_58 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_58 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_58 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_58" [show x11] info)
  _ -> failCons cd (consFail "TransFunctions._case_58" (showCons x11))

d_C__case_57 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_57 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_56 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_57 l cd cs)
    (d_C__case_57 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_57 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_57 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_57" [show x13] info)
  _ -> failCons cd (consFail "TransFunctions._case_57" (showCons x13))

d_C__case_56 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_56 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_55 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_56 l cd cs)
    (d_C__case_56 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_56 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_56 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_56" [show x15] info)
  _ -> failCons cd (consFail "TransFunctions._case_56" (showCons x15))

d_C__case_55 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_55 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_54 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_55 l cd cs)
    (d_C__case_55 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_55 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_55 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_55" [show x17] info)
  _ -> failCons cd (consFail "TransFunctions._case_55" (showCons x17))

d_C__case_54 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_54 x19 cd cs = case x19 of
  Curry_Prelude.OP_Cons x20 x21 -> d_C__case_53 x20 x21 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_54 l cd cs)
    (d_C__case_54 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_54 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_54 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_54" [show x19] info)
  _ -> failCons cd (consFail "TransFunctions._case_54" (showCons x19))

d_C__case_53 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_53 x20 x21 cd cs = case x21 of
  Curry_Prelude.OP_List -> x20
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_53 x20 l cd cs)
    (d_C__case_53 x20 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_53 x20
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_53 x20 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_53" [show x20, show x21] info)
  _ -> failCons cd (consFail "TransFunctions._case_53" (showCons x21))

d_C__case_72 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_72 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_71 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_72 l cd cs)
    (d_C__case_72 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_72 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_72 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_72" [show x3] info)
  _ -> failCons cd (consFail "TransFunctions._case_72" (showCons x3))

d_C__case_71 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_71 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_70 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_71 l cd cs)
    (d_C__case_71 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_71 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_71 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_71" [show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_71" (showCons x5))

d_C__case_70 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_70 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_69 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_70 l cd cs)
    (d_C__case_70 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_70 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_70 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_70" [show x7] info)
  _ -> failCons cd (consFail "TransFunctions._case_70" (showCons x7))

d_C__case_69 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_69 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_68 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_69 l cd cs)
    (d_C__case_69 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_69 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_69 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_69" [show x9] info)
  _ -> failCons cd (consFail "TransFunctions._case_69" (showCons x9))

d_C__case_68 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_68 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_67 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_68 l cd cs)
    (d_C__case_68 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_68 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_68 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_68" [show x11] info)
  _ -> failCons cd (consFail "TransFunctions._case_68" (showCons x11))

d_C__case_67 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_67 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_66 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_67 l cd cs)
    (d_C__case_67 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_67 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_67 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_67" [show x13] info)
  _ -> failCons cd (consFail "TransFunctions._case_67" (showCons x13))

d_C__case_66 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_66 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_65 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_66 l cd cs)
    (d_C__case_66 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_66 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_66 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_66" [show x15] info)
  _ -> failCons cd (consFail "TransFunctions._case_66" (showCons x15))

d_C__case_65 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_65 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_64 x18 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_65 l cd cs)
    (d_C__case_65 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_65 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_65 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_65" [show x17] info)
  _ -> failCons cd (consFail "TransFunctions._case_65" (showCons x17))

d_C__case_64 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_64 x18 x19 cd cs = case x19 of
  Curry_Prelude.OP_Cons x20 x21 -> d_C__case_63 x18 x21 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_64 x18 l cd cs)
    (d_C__case_64 x18 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_64 x18
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_64 x18 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_64" [show x18, show x19] info)
  _ -> failCons cd (consFail "TransFunctions._case_64" (showCons x19))

d_C__case_63 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_63 x18 x21 cd cs = case x21 of
  Curry_Prelude.OP_List -> x18
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_63 x18 l cd cs)
    (d_C__case_63 x18 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_63 x18
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_63 x18 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_63" [show x18, show x21] info)
  _ -> failCons cd (consFail "TransFunctions._case_63" (showCons x21))

d_C__case_82 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_82 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_81 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_82 l cd cs)
    (d_C__case_82 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_82 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_82 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_82" [show x3] info)
  _ -> failCons cd (consFail "TransFunctions._case_82" (showCons x3))

d_C__case_81 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_81 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_80 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_81 l cd cs)
    (d_C__case_81 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_81 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_81 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_81" [show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_81" (showCons x5))

d_C__case_80 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_80 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_79 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_80 l cd cs)
    (d_C__case_80 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_80 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_80 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_80" [show x7] info)
  _ -> failCons cd (consFail "TransFunctions._case_80" (showCons x7))

d_C__case_79 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_79 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_78 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_79 l cd cs)
    (d_C__case_79 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_79 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_79 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_79" [show x9] info)
  _ -> failCons cd (consFail "TransFunctions._case_79" (showCons x9))

d_C__case_78 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_78 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_77 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_78 l cd cs)
    (d_C__case_78 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_78 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_78 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_78" [show x11] info)
  _ -> failCons cd (consFail "TransFunctions._case_78" (showCons x11))

d_C__case_77 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_77 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_76 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_77 l cd cs)
    (d_C__case_77 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_77 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_77 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_77" [show x13] info)
  _ -> failCons cd (consFail "TransFunctions._case_77" (showCons x13))

d_C__case_76 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_76 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_75 x16 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_76 l cd cs)
    (d_C__case_76 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_76 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_76 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_76" [show x15] info)
  _ -> failCons cd (consFail "TransFunctions._case_76" (showCons x15))

d_C__case_75 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_75 x16 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_74 x16 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_75 x16 l cd cs)
    (d_C__case_75 x16 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_75 x16
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_75 x16 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_75" [show x16, show x17] info)
  _ -> failCons cd (consFail "TransFunctions._case_75" (showCons x17))

d_C__case_74 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_74 x16 x19 cd cs = case x19 of
  Curry_Prelude.OP_Cons x20 x21 -> d_C__case_73 x16 x21 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_74 x16 l cd cs)
    (d_C__case_74 x16 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_74 x16
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_74 x16 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_74" [show x16, show x19] info)
  _ -> failCons cd (consFail "TransFunctions._case_74" (showCons x19))

d_C__case_73 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_73 x16 x21 cd cs = case x21 of
  Curry_Prelude.OP_List -> x16
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_73 x16 l cd cs)
    (d_C__case_73 x16 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_73 x16
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_73 x16 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_73" [show x16, show x21] info)
  _ -> failCons cd (consFail "TransFunctions._case_73" (showCons x21))

d_C__case_92 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_92 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_91 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_92 l cd cs)
    (d_C__case_92 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_92 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_92 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_92" [show x3] info)
  _ -> failCons cd (consFail "TransFunctions._case_92" (showCons x3))

d_C__case_91 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_91 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_90 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_91 l cd cs)
    (d_C__case_91 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_91 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_91 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_91" [show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_91" (showCons x5))

d_C__case_90 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_90 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_89 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_90 l cd cs)
    (d_C__case_90 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_90 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_90 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_90" [show x7] info)
  _ -> failCons cd (consFail "TransFunctions._case_90" (showCons x7))

d_C__case_89 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_89 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_88 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_89 l cd cs)
    (d_C__case_89 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_89 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_89 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_89" [show x9] info)
  _ -> failCons cd (consFail "TransFunctions._case_89" (showCons x9))

d_C__case_88 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_88 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_87 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_88 l cd cs)
    (d_C__case_88 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_88 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_88 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_88" [show x11] info)
  _ -> failCons cd (consFail "TransFunctions._case_88" (showCons x11))

d_C__case_87 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_87 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_86 x14 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_87 l cd cs)
    (d_C__case_87 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_87 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_87 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_87" [show x13] info)
  _ -> failCons cd (consFail "TransFunctions._case_87" (showCons x13))

d_C__case_86 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_86 x14 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_85 x14 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_86 x14 l cd cs)
    (d_C__case_86 x14 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_86 x14
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_86 x14 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_86" [show x14, show x15] info)
  _ -> failCons cd (consFail "TransFunctions._case_86" (showCons x15))

d_C__case_85 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_85 x14 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_84 x14 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_85 x14 l cd cs)
    (d_C__case_85 x14 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_85 x14
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_85 x14 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_85" [show x14, show x17] info)
  _ -> failCons cd (consFail "TransFunctions._case_85" (showCons x17))

d_C__case_84 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_84 x14 x19 cd cs = case x19 of
  Curry_Prelude.OP_Cons x20 x21 -> d_C__case_83 x14 x21 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_84 x14 l cd cs)
    (d_C__case_84 x14 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_84 x14
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_84 x14 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_84" [show x14, show x19] info)
  _ -> failCons cd (consFail "TransFunctions._case_84" (showCons x19))

d_C__case_83 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_83 x14 x21 cd cs = case x21 of
  Curry_Prelude.OP_List -> x14
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_83 x14 l cd cs)
    (d_C__case_83 x14 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_83 x14
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_83 x14 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_83" [show x14, show x21] info)
  _ -> failCons cd (consFail "TransFunctions._case_83" (showCons x21))

d_C__case_102 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_102 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_101 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_102 l cd cs)
    (d_C__case_102 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_102 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_102 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_102" [show x3] info)
  _ -> failCons cd (consFail "TransFunctions._case_102" (showCons x3))

d_C__case_101 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_101 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_100 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_101 l cd cs)
    (d_C__case_101 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_101 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_101 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_101" [show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_101" (showCons x5))

d_C__case_100 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_100 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_99 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_100 l cd cs)
    (d_C__case_100 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_100 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_100 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_100" [show x7] info)
  _ -> failCons cd (consFail "TransFunctions._case_100" (showCons x7))

d_C__case_99 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_99 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_98 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_99 l cd cs)
    (d_C__case_99 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_99 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_99 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_99" [show x9] info)
  _ -> failCons cd (consFail "TransFunctions._case_99" (showCons x9))

d_C__case_98 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_98 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_97 x12 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_98 l cd cs)
    (d_C__case_98 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_98 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_98 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_98" [show x11] info)
  _ -> failCons cd (consFail "TransFunctions._case_98" (showCons x11))

d_C__case_97 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_97 x12 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_96 x12 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_97 x12 l cd cs)
    (d_C__case_97 x12 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_97 x12
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_97 x12 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_97" [show x12, show x13] info)
  _ -> failCons cd (consFail "TransFunctions._case_97" (showCons x13))

d_C__case_96 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_96 x12 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_95 x12 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_96 x12 l cd cs)
    (d_C__case_96 x12 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_96 x12
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_96 x12 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_96" [show x12, show x15] info)
  _ -> failCons cd (consFail "TransFunctions._case_96" (showCons x15))

d_C__case_95 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_95 x12 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_94 x12 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_95 x12 l cd cs)
    (d_C__case_95 x12 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_95 x12
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_95 x12 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_95" [show x12, show x17] info)
  _ -> failCons cd (consFail "TransFunctions._case_95" (showCons x17))

d_C__case_94 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_94 x12 x19 cd cs = case x19 of
  Curry_Prelude.OP_Cons x20 x21 -> d_C__case_93 x12 x21 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_94 x12 l cd cs)
    (d_C__case_94 x12 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_94 x12
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_94 x12 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_94" [show x12, show x19] info)
  _ -> failCons cd (consFail "TransFunctions._case_94" (showCons x19))

d_C__case_93 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_93 x12 x21 cd cs = case x21 of
  Curry_Prelude.OP_List -> x12
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_93 x12 l cd cs)
    (d_C__case_93 x12 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_93 x12
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_93 x12 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_93" [show x12, show x21] info)
  _ -> failCons cd (consFail "TransFunctions._case_93" (showCons x21))

d_C__case_112 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_112 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_111 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_112 l cd cs)
    (d_C__case_112 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_112 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_112 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_112" [show x3] info)
  _ -> failCons cd (consFail "TransFunctions._case_112" (showCons x3))

d_C__case_111 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_111 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_110 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_111 l cd cs)
    (d_C__case_111 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_111 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_111 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_111" [show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_111" (showCons x5))

d_C__case_110 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_110 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_109 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_110 l cd cs)
    (d_C__case_110 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_110 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_110 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_110" [show x7] info)
  _ -> failCons cd (consFail "TransFunctions._case_110" (showCons x7))

d_C__case_109 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_109 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_108 x10 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_109 l cd cs)
    (d_C__case_109 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_109 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_109 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_109" [show x9] info)
  _ -> failCons cd (consFail "TransFunctions._case_109" (showCons x9))

d_C__case_108 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_108 x10 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_107 x10 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_108 x10 l cd cs)
    (d_C__case_108 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_108
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_108 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_108" [show x10, show x11] info)
  _ -> failCons cd (consFail "TransFunctions._case_108" (showCons x11))

d_C__case_107 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_107 x10 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_106 x10 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_107 x10 l cd cs)
    (d_C__case_107 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_107
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_107 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_107" [show x10, show x13] info)
  _ -> failCons cd (consFail "TransFunctions._case_107" (showCons x13))

d_C__case_106 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_106 x10 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_105 x10 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_106 x10 l cd cs)
    (d_C__case_106 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_106
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_106 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_106" [show x10, show x15] info)
  _ -> failCons cd (consFail "TransFunctions._case_106" (showCons x15))

d_C__case_105 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_105 x10 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_104 x10 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_105 x10 l cd cs)
    (d_C__case_105 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_105
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_105 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_105" [show x10, show x17] info)
  _ -> failCons cd (consFail "TransFunctions._case_105" (showCons x17))

d_C__case_104 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_104 x10 x19 cd cs = case x19 of
  Curry_Prelude.OP_Cons x20 x21 -> d_C__case_103 x10 x21 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_104 x10 l cd cs)
    (d_C__case_104 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_104
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_104 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_104" [show x10, show x19] info)
  _ -> failCons cd (consFail "TransFunctions._case_104" (showCons x19))

d_C__case_103 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_103 x10 x21 cd cs = case x21 of
  Curry_Prelude.OP_List -> x10
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_103 x10 l cd cs)
    (d_C__case_103 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_103
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_103 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_103" [show x10, show x21] info)
  _ -> failCons cd (consFail "TransFunctions._case_103" (showCons x21))

d_C__case_122 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_122 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_121 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_122 l cd cs)
    (d_C__case_122 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_122 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_122 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_122" [show x3] info)
  _ -> failCons cd (consFail "TransFunctions._case_122" (showCons x3))

d_C__case_121 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_121 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_120 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_121 l cd cs)
    (d_C__case_121 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_121 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_121 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_121" [show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_121" (showCons x5))

d_C__case_120 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_120 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_119 x8 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_120 l cd cs)
    (d_C__case_120 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_120 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_120 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_120" [show x7] info)
  _ -> failCons cd (consFail "TransFunctions._case_120" (showCons x7))

d_C__case_119 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_119 x8 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_118 x8 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_119 x8 l cd cs)
    (d_C__case_119 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_119 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_119 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_119" [show x8, show x9] info)
  _ -> failCons cd (consFail "TransFunctions._case_119" (showCons x9))

d_C__case_118 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_118 x8 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_117 x8 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_118 x8 l cd cs)
    (d_C__case_118 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_118 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_118 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_118" [show x8, show x11] info)
  _ -> failCons cd (consFail "TransFunctions._case_118" (showCons x11))

d_C__case_117 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_117 x8 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_116 x8 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_117 x8 l cd cs)
    (d_C__case_117 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_117 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_117 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_117" [show x8, show x13] info)
  _ -> failCons cd (consFail "TransFunctions._case_117" (showCons x13))

d_C__case_116 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_116 x8 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_115 x8 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_116 x8 l cd cs)
    (d_C__case_116 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_116 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_116 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_116" [show x8, show x15] info)
  _ -> failCons cd (consFail "TransFunctions._case_116" (showCons x15))

d_C__case_115 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_115 x8 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_114 x8 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_115 x8 l cd cs)
    (d_C__case_115 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_115 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_115 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_115" [show x8, show x17] info)
  _ -> failCons cd (consFail "TransFunctions._case_115" (showCons x17))

d_C__case_114 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_114 x8 x19 cd cs = case x19 of
  Curry_Prelude.OP_Cons x20 x21 -> d_C__case_113 x8 x21 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_114 x8 l cd cs)
    (d_C__case_114 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_114 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_114 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_114" [show x8, show x19] info)
  _ -> failCons cd (consFail "TransFunctions._case_114" (showCons x19))

d_C__case_113 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_113 x8 x21 cd cs = case x21 of
  Curry_Prelude.OP_List -> x8
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_113 x8 l cd cs)
    (d_C__case_113 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_113 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_113 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_113" [show x8, show x21] info)
  _ -> failCons cd (consFail "TransFunctions._case_113" (showCons x21))

d_C__case_132 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_132 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_131 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_132 l cd cs)
    (d_C__case_132 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_132 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_132 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_132" [show x3] info)
  _ -> failCons cd (consFail "TransFunctions._case_132" (showCons x3))

d_C__case_131 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_131 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_130 x6 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_131 l cd cs)
    (d_C__case_131 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_131 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_131 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_131" [show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_131" (showCons x5))

d_C__case_130 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_130 x6 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_129 x6 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_130 x6 l cd cs)
    (d_C__case_130 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_130 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_130 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_130" [show x6, show x7] info)
  _ -> failCons cd (consFail "TransFunctions._case_130" (showCons x7))

d_C__case_129 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_129 x6 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_128 x6 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_129 x6 l cd cs)
    (d_C__case_129 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_129 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_129 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_129" [show x6, show x9] info)
  _ -> failCons cd (consFail "TransFunctions._case_129" (showCons x9))

d_C__case_128 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_128 x6 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_127 x6 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_128 x6 l cd cs)
    (d_C__case_128 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_128 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_128 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_128" [show x6, show x11] info)
  _ -> failCons cd (consFail "TransFunctions._case_128" (showCons x11))

d_C__case_127 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_127 x6 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_126 x6 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_127 x6 l cd cs)
    (d_C__case_127 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_127 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_127 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_127" [show x6, show x13] info)
  _ -> failCons cd (consFail "TransFunctions._case_127" (showCons x13))

d_C__case_126 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_126 x6 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_125 x6 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_126 x6 l cd cs)
    (d_C__case_126 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_126 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_126 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_126" [show x6, show x15] info)
  _ -> failCons cd (consFail "TransFunctions._case_126" (showCons x15))

d_C__case_125 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_125 x6 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_124 x6 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_125 x6 l cd cs)
    (d_C__case_125 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_125 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_125 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_125" [show x6, show x17] info)
  _ -> failCons cd (consFail "TransFunctions._case_125" (showCons x17))

d_C__case_124 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_124 x6 x19 cd cs = case x19 of
  Curry_Prelude.OP_Cons x20 x21 -> d_C__case_123 x6 x21 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_124 x6 l cd cs)
    (d_C__case_124 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_124 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_124 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_124" [show x6, show x19] info)
  _ -> failCons cd (consFail "TransFunctions._case_124" (showCons x19))

d_C__case_123 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_123 x6 x21 cd cs = case x21 of
  Curry_Prelude.OP_List -> x6
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_123 x6 l cd cs)
    (d_C__case_123 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_123 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_123 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_123" [show x6, show x21] info)
  _ -> failCons cd (consFail "TransFunctions._case_123" (showCons x21))

d_C__case_142 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_142 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_141 x4 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_142 l cd cs)
    (d_C__case_142 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_142 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_142 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_142" [show x3] info)
  _ -> failCons cd (consFail "TransFunctions._case_142" (showCons x3))

d_C__case_141 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_141 x4 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_140 x4 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_141 x4 l cd cs)
    (d_C__case_141 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_141 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_141 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_141" [show x4, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_141" (showCons x5))

d_C__case_140 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_140 x4 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_139 x4 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_140 x4 l cd cs)
    (d_C__case_140 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_140 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_140 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_140" [show x4, show x7] info)
  _ -> failCons cd (consFail "TransFunctions._case_140" (showCons x7))

d_C__case_139 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_139 x4 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_138 x4 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_139 x4 l cd cs)
    (d_C__case_139 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_139 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_139 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_139" [show x4, show x9] info)
  _ -> failCons cd (consFail "TransFunctions._case_139" (showCons x9))

d_C__case_138 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_138 x4 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_137 x4 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_138 x4 l cd cs)
    (d_C__case_138 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_138 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_138 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_138" [show x4, show x11] info)
  _ -> failCons cd (consFail "TransFunctions._case_138" (showCons x11))

d_C__case_137 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_137 x4 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_136 x4 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_137 x4 l cd cs)
    (d_C__case_137 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_137 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_137 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_137" [show x4, show x13] info)
  _ -> failCons cd (consFail "TransFunctions._case_137" (showCons x13))

d_C__case_136 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_136 x4 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_135 x4 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_136 x4 l cd cs)
    (d_C__case_136 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_136 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_136 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_136" [show x4, show x15] info)
  _ -> failCons cd (consFail "TransFunctions._case_136" (showCons x15))

d_C__case_135 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_135 x4 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_134 x4 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_135 x4 l cd cs)
    (d_C__case_135 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_135 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_135 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_135" [show x4, show x17] info)
  _ -> failCons cd (consFail "TransFunctions._case_135" (showCons x17))

d_C__case_134 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_134 x4 x19 cd cs = case x19 of
  Curry_Prelude.OP_Cons x20 x21 -> d_C__case_133 x4 x21 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_134 x4 l cd cs)
    (d_C__case_134 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_134 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_134 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_134" [show x4, show x19] info)
  _ -> failCons cd (consFail "TransFunctions._case_134" (showCons x19))

d_C__case_133 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_133 x4 x21 cd cs = case x21 of
  Curry_Prelude.OP_List -> x4
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_133 x4 l cd cs)
    (d_C__case_133 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_133 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_133 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_133" [show x4, show x21] info)
  _ -> failCons cd (consFail "TransFunctions._case_133" (showCons x21))

d_C__case_152 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_152 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_151 x2 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_152 x2 l cd cs)
    (d_C__case_152 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_152 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_152 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_152" [show x2, show x3] info)
  _ -> failCons cd (consFail "TransFunctions._case_152" (showCons x3))

d_C__case_151 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_151 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_150 x2 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_151 x2 l cd cs)
    (d_C__case_151 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_151 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_151 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_151" [show x2, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_151" (showCons x5))

d_C__case_150 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_150 x2 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_149 x2 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_150 x2 l cd cs)
    (d_C__case_150 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_150 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_150 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_150" [show x2, show x7] info)
  _ -> failCons cd (consFail "TransFunctions._case_150" (showCons x7))

d_C__case_149 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_149 x2 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_148 x2 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_149 x2 l cd cs)
    (d_C__case_149 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_149 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_149 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_149" [show x2, show x9] info)
  _ -> failCons cd (consFail "TransFunctions._case_149" (showCons x9))

d_C__case_148 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_148 x2 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_147 x2 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_148 x2 l cd cs)
    (d_C__case_148 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_148 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_148 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_148" [show x2, show x11] info)
  _ -> failCons cd (consFail "TransFunctions._case_148" (showCons x11))

d_C__case_147 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_147 x2 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_146 x2 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_147 x2 l cd cs)
    (d_C__case_147 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_147 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_147 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_147" [show x2, show x13] info)
  _ -> failCons cd (consFail "TransFunctions._case_147" (showCons x13))

d_C__case_146 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_146 x2 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_145 x2 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_146 x2 l cd cs)
    (d_C__case_146 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_146 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_146 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_146" [show x2, show x15] info)
  _ -> failCons cd (consFail "TransFunctions._case_146" (showCons x15))

d_C__case_145 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_145 x2 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_144 x2 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_145 x2 l cd cs)
    (d_C__case_145 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_145 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_145 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_145" [show x2, show x17] info)
  _ -> failCons cd (consFail "TransFunctions._case_145" (showCons x17))

d_C__case_144 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_144 x2 x19 cd cs = case x19 of
  Curry_Prelude.OP_Cons x20 x21 -> d_C__case_143 x2 x21 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_144 x2 l cd cs)
    (d_C__case_144 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_144 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_144 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_144" [show x2, show x19] info)
  _ -> failCons cd (consFail "TransFunctions._case_144" (showCons x19))

d_C__case_143 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_143 x2 x21 cd cs = case x21 of
  Curry_Prelude.OP_List -> x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_143 x2 l cd cs)
    (d_C__case_143 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_143 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_143 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_143" [show x2, show x21] info)
  _ -> failCons cd (consFail "TransFunctions._case_143" (showCons x21))

d_C__case_153 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_AbstractHaskell.C_Literal Curry_AbstractHaskell.C_Expr)
  -> Curry_AbstractHaskell.C_Expr -> Curry_AbstractHaskell.C_Pattern -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_AbstractHaskell.C_Literal Curry_AbstractHaskell.C_Expr)
d_C__case_153 x2 x4 x3 cd cs = case x3 of
  Curry_AbstractHaskell.C_PLit x5 -> Curry_Prelude.OP_Cons
    (Curry_Prelude.OP_Tuple2 x5 x4) x2
  Curry_AbstractHaskell.C_PVar x6 -> x2
  Curry_AbstractHaskell.C_PComb x7 x8 -> x2
  Curry_AbstractHaskell.C_PAs x9 x10 -> x2
  Curry_AbstractHaskell.C_PTuple x11 -> x2
  Curry_AbstractHaskell.C_PList x12 -> x2
  Curry_AbstractHaskell.Choice_C_Pattern d i l r -> narrow d i (d_C__case_153 x2
    x4 l cd cs) (d_C__case_153 x2 x4 r cd cs)
  Curry_AbstractHaskell.Choices_C_Pattern d i xs -> narrows cs d i (\z ->
    d_C__case_153 x2 x4 z cd cs) xs
  Curry_AbstractHaskell.Guard_C_Pattern d c e -> guardCons d c (d_C__case_153 x2
    x4 e cd $! addCs c cs)
  Curry_AbstractHaskell.Fail_C_Pattern d info -> failCons d (traceFail
    "TransFunctions._case_153" [show x2, show x4, show x3] info)
  _ -> failCons cd (consFail "TransFunctions._case_153" (showCons x3))

d_C__case_156 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_AbstractHaskell.C_Literal
  Curry_AbstractHaskell.C_Expr) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_BranchExpr
d_C__case_156 x3 x2 cd cs = case x2 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_155 x3 x2 x4 cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.OP_List
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_156 x3 l cd cs)
    (d_C__case_156 x3 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_156 x3
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_156 x3 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_156" [show x3, show x2] info)
  _ -> failCons cd (consFail "TransFunctions._case_156" (showCons x2))

d_C__case_155 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_AbstractHaskell.C_Literal
  Curry_AbstractHaskell.C_Expr) -> Curry_Prelude.OP_Tuple2
  Curry_AbstractHaskell.C_Literal Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_BranchExpr
d_C__case_155 x3 x2 x4 cd cs = case x4 of
  Curry_Prelude.OP_Tuple2 x6 x7 -> let x8 = Curry_Prelude.OP_List
    in d_C__case_154 x8 x3 x2 x6 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C__case_155 x3 x2 l cd
    cs) (d_C__case_155 x3 x2 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C__case_155
    x3 x2 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C__case_155 x3 x2 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions._case_155" [show x3, show x2, show x4] info)
  _ -> failCons cd (consFail "TransFunctions._case_155" (showCons x4))

d_C__case_154 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_BranchExpr
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_AbstractHaskell.C_Literal Curry_AbstractHaskell.C_Expr)
  -> Curry_AbstractHaskell.C_Literal -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_BranchExpr
d_C__case_154 x8 x3 x2 x6 cd cs = case x6 of
  Curry_AbstractHaskell.C_Intc x9 -> Curry_Prelude.OP_Cons
    (d_OP_litBranches_dot_mkBranch_dot_397 x2 x3 (Curry_Prelude.d_C_apply
    (Curry_Names.d_C_renameQName cd cs) (Curry_Prelude.OP_Tuple2
    (Curry_Names.d_C_prelude cd cs) (Curry_Prelude.toCurryString "CurryInt")) cd
    cs) (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_basics cd cs)
    (Curry_Prelude.toCurryString "matchInteger")) cd cs) Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Charc x10 -> Curry_Prelude.OP_Cons
    (d_OP_litBranches_dot_mkBranch_dot_397 x2 x3 (Curry_Prelude.OP_Tuple2
    (Curry_Names.d_C_curryPrelude cd cs) (Curry_Prelude.toCurryString
    "CurryChar")) (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_basics cd cs)
    (Curry_Prelude.toCurryString "matchChar")) cd cs) Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Floatc x11 -> x8
  Curry_AbstractHaskell.C_Stringc x12 -> x8
  Curry_AbstractHaskell.Choice_C_Literal d i l r -> narrow d i (d_C__case_154 x8
    x3 x2 l cd cs) (d_C__case_154 x8 x3 x2 r cd cs)
  Curry_AbstractHaskell.Choices_C_Literal d i xs -> narrows cs d i (\z ->
    d_C__case_154 x8 x3 x2 z cd cs) xs
  Curry_AbstractHaskell.Guard_C_Literal d c e -> guardCons d c (d_C__case_154 x8
    x3 x2 e cd $! addCs c cs)
  Curry_AbstractHaskell.Fail_C_Literal d info -> failCons d (traceFail
    "TransFunctions._case_154" [show x8, show x3, show x2, show x6] info)
  _ -> failCons cd (consFail "TransFunctions._case_154" (showCons x6))

d_C__case_158 :: FlatCurry.Curry_Types.C_Pattern -> Cover -> ConstStore
  -> C_IOES C_State (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_158 x2 cd cs = case x2 of
  FlatCurry.Curry_Types.C_Pattern x4 x5 -> d_C_getType x4 cd cs
  FlatCurry.Curry_Types.C_LPattern x6 -> Curry_Prelude.d_OP_dollar d_C_returnM
    (d_C__case_157 x6 cd cs) cd cs
  FlatCurry.Curry_Types.Choice_C_Pattern d i l r -> narrow d i (d_C__case_158 l
    cd cs) (d_C__case_158 r cd cs)
  FlatCurry.Curry_Types.Choices_C_Pattern d i xs -> narrows cs d i (\z ->
    d_C__case_158 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Pattern d c e -> guardCons d c (d_C__case_158 e
    cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Pattern d info -> failCons d (traceFail
    "TransFunctions._case_158" [show x2] info)
  _ -> failCons cd (consFail "TransFunctions._case_158" (showCons x2))

nd_C__case_158 :: FlatCurry.Curry_Types.C_Pattern -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
nd_C__case_158 x2 s cd cs = case x2 of
  FlatCurry.Curry_Types.C_Pattern x4 x5 -> let s0 = s
    in s0 `seq` nd_C_getType x4 s0 cd cs
  FlatCurry.Curry_Types.C_LPattern x6 -> let s0 = s
    in s0 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id nd_C_returnM)
    (d_C__case_157 x6 cd cs) s0 cd cs
  FlatCurry.Curry_Types.Choice_C_Pattern d i l r -> narrow d i (nd_C__case_158 l
    s cd cs) (nd_C__case_158 r s cd cs)
  FlatCurry.Curry_Types.Choices_C_Pattern d i xs -> narrows cs d i (\z ->
    nd_C__case_158 z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Pattern d c e -> guardCons d c (nd_C__case_158 e
    s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Pattern d info -> failCons d (traceFail
    "TransFunctions._case_158" [show x2] info)
  _ -> failCons cd (consFail "TransFunctions._case_158" (showCons x2))

d_C__case_157 :: FlatCurry.Curry_Types.C_Literal -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_157 x6 cd cs = case x6 of
  FlatCurry.Curry_Types.C_Intc x7 -> d_C_curryInt cd cs
  FlatCurry.Curry_Types.C_Floatc x8 -> d_C_curryFloat cd cs
  FlatCurry.Curry_Types.C_Charc x9 -> d_C_curryChar cd cs
  FlatCurry.Curry_Types.Choice_C_Literal d i l r -> narrow d i (d_C__case_157 l
    cd cs) (d_C__case_157 r cd cs)
  FlatCurry.Curry_Types.Choices_C_Literal d i xs -> narrows cs d i (\z ->
    d_C__case_157 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Literal d c e -> guardCons d c (d_C__case_157 e
    cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Literal d info -> failCons d (traceFail
    "TransFunctions._case_157" [show x6] info)
  _ -> failCons cd (consFail "TransFunctions._case_157" (showCons x6))

d_C__case_160 :: C_IOES C_State Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> FlatCurry.Curry_Types.C_Expr -> Cover -> ConstStore
  -> C_IOES C_State Curry_AbstractHaskell.C_Expr
d_C__case_160 x4 x1 x2 x3 cd cs = case x3 of
  FlatCurry.Curry_Types.C_Case x5 x6 x7 -> let x8 = d_C_trCompleteExpr x3 cd cs
    in d_C__case_159 x8 x1 x2 x7 x6 cd cs
  FlatCurry.Curry_Types.C_Var x25 -> x4
  FlatCurry.Curry_Types.C_Lit x26 -> x4
  FlatCurry.Curry_Types.C_Comb x27 x28 x29 -> x4
  FlatCurry.Curry_Types.C_Let x30 x31 -> x4
  FlatCurry.Curry_Types.C_Free x32 x33 -> x4
  FlatCurry.Curry_Types.C_Or x34 x35 -> x4
  FlatCurry.Curry_Types.C_Typed x36 x37 -> x4
  FlatCurry.Curry_Types.Choice_C_Expr d i l r -> narrow d i (d_C__case_160 x4 x1
    x2 l cd cs) (d_C__case_160 x4 x1 x2 r cd cs)
  FlatCurry.Curry_Types.Choices_C_Expr d i xs -> narrows cs d i (\z ->
    d_C__case_160 x4 x1 x2 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Expr d c e -> guardCons d c (d_C__case_160 x4 x1
    x2 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Expr d info -> failCons d (traceFail
    "TransFunctions._case_160" [show x4, show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransFunctions._case_160" (showCons x3))

nd_C__case_160 :: C_IOES C_State Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> FlatCurry.Curry_Types.C_Expr -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_Expr
nd_C__case_160 x4 x1 x2 x3 s cd cs = case x3 of
  FlatCurry.Curry_Types.C_Case x5 x6 x7 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` (let x8 = nd_C_trCompleteExpr x3 s0 cd cs
    in nd_C__case_159 x8 x1 x2 x7 x6 s1 cd cs)))
  FlatCurry.Curry_Types.C_Var x25 -> x4
  FlatCurry.Curry_Types.C_Lit x26 -> x4
  FlatCurry.Curry_Types.C_Comb x27 x28 x29 -> x4
  FlatCurry.Curry_Types.C_Let x30 x31 -> x4
  FlatCurry.Curry_Types.C_Free x32 x33 -> x4
  FlatCurry.Curry_Types.C_Or x34 x35 -> x4
  FlatCurry.Curry_Types.C_Typed x36 x37 -> x4
  FlatCurry.Curry_Types.Choice_C_Expr d i l r -> narrow d i (nd_C__case_160 x4
    x1 x2 l s cd cs) (nd_C__case_160 x4 x1 x2 r s cd cs)
  FlatCurry.Curry_Types.Choices_C_Expr d i xs -> narrows cs d i (\z ->
    nd_C__case_160 x4 x1 x2 z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Expr d c e -> guardCons d c (nd_C__case_160 x4
    x1 x2 e s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Expr d info -> failCons d (traceFail
    "TransFunctions._case_160" [show x4, show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransFunctions._case_160" (showCons x3))

d_C__case_159 :: C_IOES C_State Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_BranchExpr -> FlatCurry.Curry_Types.C_Expr -> Cover
  -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_Expr
d_C__case_159 x8 x1 x2 x7 x6 cd cs = case x6 of
  FlatCurry.Curry_Types.C_Var x9 -> d_OP_gt_plus_eq (d_C_getMatchedType
    (Curry_Prelude.d_C_head x7 cd cs) cd cs)
    (d_OP_trBody_dot_uscore_hash_lambda234 x9 x7 x2 x1) cd cs
  FlatCurry.Curry_Types.C_Lit x10 -> x8
  FlatCurry.Curry_Types.C_Comb x11 x12 x13 -> x8
  FlatCurry.Curry_Types.C_Let x14 x15 -> x8
  FlatCurry.Curry_Types.C_Free x16 x17 -> x8
  FlatCurry.Curry_Types.C_Or x18 x19 -> x8
  FlatCurry.Curry_Types.C_Case x20 x21 x22 -> x8
  FlatCurry.Curry_Types.C_Typed x23 x24 -> x8
  FlatCurry.Curry_Types.Choice_C_Expr d i l r -> narrow d i (d_C__case_159 x8 x1
    x2 x7 l cd cs) (d_C__case_159 x8 x1 x2 x7 r cd cs)
  FlatCurry.Curry_Types.Choices_C_Expr d i xs -> narrows cs d i (\z ->
    d_C__case_159 x8 x1 x2 x7 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Expr d c e -> guardCons d c (d_C__case_159 x8 x1
    x2 x7 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Expr d info -> failCons d (traceFail
    "TransFunctions._case_159" [show x8, show x1, show x2, show x7, show x6]
    info)
  _ -> failCons cd (consFail "TransFunctions._case_159" (showCons x6))

nd_C__case_159 :: C_IOES C_State Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_BranchExpr -> FlatCurry.Curry_Types.C_Expr -> IDSupply
  -> Cover -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_Expr
nd_C__case_159 x8 x1 x2 x7 x6 s cd cs = case x6 of
  FlatCurry.Curry_Types.C_Var x9 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getMatchedType
    (Curry_Prelude.d_C_head x7 cd cs) s0 cd cs) (wrapNX id
    (nd_OP_trBody_dot_uscore_hash_lambda234 x9 x7 x2 x1)) s1 cd cs))
  FlatCurry.Curry_Types.C_Lit x10 -> x8
  FlatCurry.Curry_Types.C_Comb x11 x12 x13 -> x8
  FlatCurry.Curry_Types.C_Let x14 x15 -> x8
  FlatCurry.Curry_Types.C_Free x16 x17 -> x8
  FlatCurry.Curry_Types.C_Or x18 x19 -> x8
  FlatCurry.Curry_Types.C_Case x20 x21 x22 -> x8
  FlatCurry.Curry_Types.C_Typed x23 x24 -> x8
  FlatCurry.Curry_Types.Choice_C_Expr d i l r -> narrow d i (nd_C__case_159 x8
    x1 x2 x7 l s cd cs) (nd_C__case_159 x8 x1 x2 x7 r s cd cs)
  FlatCurry.Curry_Types.Choices_C_Expr d i xs -> narrows cs d i (\z ->
    nd_C__case_159 x8 x1 x2 x7 z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Expr d c e -> guardCons d c (nd_C__case_159 x8
    x1 x2 x7 e s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Expr d info -> failCons d (traceFail
    "TransFunctions._case_159" [show x8, show x1, show x2, show x7, show x6]
    info)
  _ -> failCons cd (consFail "TransFunctions._case_159" (showCons x6))

d_C__case_161 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_161 x7 x5 x3 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> d_C_failCheck x3 (Curry_Prelude.d_C_map (d_C_cvVar cd
    cs) x5 cd cs) x7 cd cs
  Curry_Prelude.C_False -> x7
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_161 x7 x5 x3 l cd
    cs) (d_C__case_161 x7 x5 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_161 x7
    x5 x3 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_161 x7 x5 x3 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_161" [show x7, show x5, show x3, show x4] info)
  _ -> failCons cd (consFail "TransFunctions._case_161" (showCons x4))

d_C__case_162 :: Curry_Prelude.C_Bool -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_162 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons (d_C_topSupplyName cd cs)
    Curry_Prelude.OP_List
  Curry_Prelude.C_False -> Curry_Prelude.OP_List
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_162 x1 l cd cs)
    (d_C__case_162 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_162 x1
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_162 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_162" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions._case_162" (showCons x2))

d_C__case_163 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_163 x5 x3 x4 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> d_C_failCheck x4 (Curry_Prelude.d_C_map (d_C_cvVar cd
    cs) x3 cd cs) x5 cd cs
  Curry_Prelude.C_False -> x5
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_163 x5 x3 x4 l cd
    cs) (d_C__case_163 x5 x3 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_163 x5
    x3 x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_163 x5 x3 x4 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_163" [show x5, show x3, show x4, show x2] info)
  _ -> failCons cd (consFail "TransFunctions._case_163" (showCons x2))

d_C__case_164 :: Curry_Prelude.C_Bool -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_164 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons (d_C_topSupplyName cd cs)
    Curry_Prelude.OP_List
  Curry_Prelude.C_False -> Curry_Prelude.OP_List
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_164 x1 l cd cs)
    (d_C__case_164 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_164 x1
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_164 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_164" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransFunctions._case_164" (showCons x2))

d_C__case_168 :: Curry_Prelude.C_Int -> FlatCurry.Curry_Types.C_TypeExpr
  -> (Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeExpr) -> (Curry_AbstractHaskell.C_TypeExpr
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeExpr)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> C_IOES C_State
  Curry_AbstractHaskell.C_TypeExpr
d_C__case_168 x3 x4 x1 x2 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_dollar d_C_returnM
    (Curry_Prelude.d_C_apply x2 (d_C_trHOTypeExpr x1 x4 cd cs) cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_167 x3 x4 x1 x2 (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
    cd cs) x3 cd cs) (Curry_Prelude.C_Int (0)) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_168 x3 x4 x1 x2 l
    cd cs) (d_C__case_168 x3 x4 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_168 x3
    x4 x1 x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_168 x3 x4 x1 x2 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_168" [show x3, show x4, show x1, show x2, show x5]
    info)
  _ -> failCons cd (consFail "TransFunctions._case_168" (showCons x5))

nd_C__case_168 :: Curry_Prelude.C_Int -> FlatCurry.Curry_Types.C_TypeExpr
  -> Func Curry_AbstractHaskell.C_TypeExpr (Func
  Curry_AbstractHaskell.C_TypeExpr Curry_AbstractHaskell.C_TypeExpr) -> Func
  Curry_AbstractHaskell.C_TypeExpr Curry_AbstractHaskell.C_TypeExpr
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore -> C_IOES C_State
  Curry_AbstractHaskell.C_TypeExpr
nd_C__case_168 x3 x4 x1 x2 x5 s cd cs = case x5 of
  Curry_Prelude.C_True -> let s4 = s
    in s4 `seq` (let s3 = leftSupply s4
                     s2 = rightSupply s4
    in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id nd_C_returnM)
    (let s1 = leftSupply s2
         s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply x2 (nd_C_trHOTypeExpr x1 x4
    s0 cd cs) s1 cd cs)) s3 cd cs))
  Curry_Prelude.C_False -> let s4 = s
    in s4 `seq` (let s3 = leftSupply s4
                     s2 = rightSupply s4
    in s3 `seq` (s2 `seq` nd_C__case_167 x3 x4 x1 x2 (let s1 = leftSupply s2
                                                          s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply
    (wrapDX (wrapDX id)
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
    cd cs)) x3 s0 cd cs) (Curry_Prelude.C_Int (0)) s1 cd cs)) s3 cd cs))
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_168 x3 x4 x1 x2
    l s cd cs) (nd_C__case_168 x3 x4 x1 x2 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_168 x3
    x4 x1 x2 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_168 x3 x4 x1 x2
    e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_168" [show x3, show x4, show x1, show x2, show x5]
    info)
  _ -> failCons cd (consFail "TransFunctions._case_168" (showCons x5))

d_C__case_167 :: Curry_Prelude.C_Int -> FlatCurry.Curry_Types.C_TypeExpr
  -> (Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeExpr) -> (Curry_AbstractHaskell.C_TypeExpr
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeExpr)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> C_IOES C_State
  Curry_AbstractHaskell.C_TypeExpr
d_C__case_167 x3 x4 x1 x2 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> let x5 = Curry_Prelude.d_OP_dollar d_C_failM
                                (Curry_Prelude.d_OP_plus_plus
                                (Curry_Prelude.toCurryString "trTypeExpr: ")
                                (Curry_Prelude.d_C_apply
                                (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_lparen_comma_rparen
                                (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Int
                                cd cs)
                                (FlatCurry.Curry_Types.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_FlatCurry_dot_Types_dot_TypeExpr
                                cd cs) cd cs) (Curry_Prelude.OP_Tuple2 x3 x4) cd
                                cs) cd cs) cd cs
    in d_C__case_166 x5 x1 x3 x2 x4 cd cs
  Curry_Prelude.C_False -> d_C__case_165 x3 x4 (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
    cd cs) x3 cd cs) (Curry_Prelude.C_Int (0)) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_167 x3 x4 x1 x2 l
    cd cs) (d_C__case_167 x3 x4 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_167 x3
    x4 x1 x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_167 x3 x4 x1 x2 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_167" [show x3, show x4, show x1, show x2, show x6]
    info)
  _ -> failCons cd (consFail "TransFunctions._case_167" (showCons x6))

nd_C__case_167 :: Curry_Prelude.C_Int -> FlatCurry.Curry_Types.C_TypeExpr
  -> Func Curry_AbstractHaskell.C_TypeExpr (Func
  Curry_AbstractHaskell.C_TypeExpr Curry_AbstractHaskell.C_TypeExpr) -> Func
  Curry_AbstractHaskell.C_TypeExpr Curry_AbstractHaskell.C_TypeExpr
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore -> C_IOES C_State
  Curry_AbstractHaskell.C_TypeExpr
nd_C__case_167 x3 x4 x1 x2 x6 s cd cs = case x6 of
  Curry_Prelude.C_True -> let s10 = s
    in s10 `seq` (let s8 = leftSupply s10
                      s9 = rightSupply s10
    in s8 `seq` (s9 `seq` (let x5 = let s7 = leftSupply s8
                                        s6 = rightSupply s8
                                 in s7 `seq` (s6 `seq`
                                 Curry_Prelude.nd_OP_dollar (wrapNX id
                                 nd_C_failM) (Curry_Prelude.d_OP_plus_plus
                                 (Curry_Prelude.toCurryString "trTypeExpr: ")
                                 (let s5 = leftSupply s6
                                      s3 = rightSupply s6
                                 in s5 `seq` (s3 `seq` Curry_Prelude.nd_C_apply
                                 (let s2 = leftSupply s3
                                      s4 = rightSupply s3
                                      s0 = leftSupply s4
                                      s1 = rightSupply s4
                                 in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq`
                                 Curry_Prelude.nd_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_lparen_comma_rparen
                                 (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Int
                                 s0 cd cs)
                                 (FlatCurry.Curry_Types.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_FlatCurry_dot_Types_dot_TypeExpr
                                 s1 cd cs) s2 cd cs)))) (Curry_Prelude.OP_Tuple2
                                 x3 x4) s5 cd cs)) cd cs) s7 cd cs)
    in nd_C__case_166 x5 x1 x3 x2 x4 s9 cd cs)))
  Curry_Prelude.C_False -> let s4 = s
    in s4 `seq` (let s3 = leftSupply s4
                     s2 = rightSupply s4
    in s3 `seq` (s2 `seq` nd_C__case_165 x3 x4 (let s1 = leftSupply s2
                                                    s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply
    (wrapDX (wrapDX id)
    (Curry_Prelude.d_OP_uscore_impl_hash_lt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
    cd cs)) x3 s0 cd cs) (Curry_Prelude.C_Int (0)) s1 cd cs)) s3 cd cs))
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_167 x3 x4 x1 x2
    l s cd cs) (nd_C__case_167 x3 x4 x1 x2 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_167 x3
    x4 x1 x2 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_167 x3 x4 x1 x2
    e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_167" [show x3, show x4, show x1, show x2, show x6]
    info)
  _ -> failCons cd (consFail "TransFunctions._case_167" (showCons x6))

d_C__case_165 :: Curry_Prelude.C_Int -> FlatCurry.Curry_Types.C_TypeExpr
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> C_IOES C_State
  Curry_AbstractHaskell.C_TypeExpr
d_C__case_165 x3 x4 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_dollar d_C_failM
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "trTypeExpr: ")
    (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Int
    cd cs)
    (FlatCurry.Curry_Types.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_FlatCurry_dot_Types_dot_TypeExpr
    cd cs) cd cs) (Curry_Prelude.OP_Tuple2 x3 x4) cd cs) cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_165 x3 x4 l cd
    cs) (d_C__case_165 x3 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_165 x3
    x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_165 x3 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_165" [show x3, show x4, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_165" (showCons x5))

nd_C__case_165 :: Curry_Prelude.C_Int -> FlatCurry.Curry_Types.C_TypeExpr
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore -> C_IOES C_State
  Curry_AbstractHaskell.C_TypeExpr
nd_C__case_165 x3 x4 x5 s cd cs = case x5 of
  Curry_Prelude.C_True -> let s8 = s
    in s8 `seq` (let s7 = leftSupply s8
                     s6 = rightSupply s8
    in s7 `seq` (s6 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id nd_C_failM)
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString "trTypeExpr: ")
    (let s5 = leftSupply s6
         s3 = rightSupply s6
    in s5 `seq` (s3 `seq` Curry_Prelude.nd_C_apply (let s2 = leftSupply s3
                                                        s4 = rightSupply s3
                                                        s0 = leftSupply s4
                                                        s1 = rightSupply s4
    in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq`
    Curry_Prelude.nd_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_lparen_comma_rparen
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Int
    s0 cd cs)
    (FlatCurry.Curry_Types.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_FlatCurry_dot_Types_dot_TypeExpr
    s1 cd cs) s2 cd cs)))) (Curry_Prelude.OP_Tuple2 x3 x4) s5 cd cs)) cd cs) s7
    cd cs))
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_165 x3 x4 l s cd
    cs) (nd_C__case_165 x3 x4 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_165 x3
    x4 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_165 x3 x4 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_165" [show x3, show x4, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_165" (showCons x5))

d_C__case_166 :: C_IOES C_State Curry_AbstractHaskell.C_TypeExpr
  -> (Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeExpr) -> Curry_Prelude.C_Int
  -> (Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeExpr) -> FlatCurry.Curry_Types.C_TypeExpr
  -> Cover -> ConstStore -> C_IOES C_State Curry_AbstractHaskell.C_TypeExpr
d_C__case_166 x5 x1 x3 x2 x4 cd cs = case x4 of
  FlatCurry.Curry_Types.C_FuncType x6 x7 -> d_OP_gt_plus_eq (d_C_trTypeExpr x1
    x2
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x3 (Curry_Prelude.C_Int (1)) cd cs) x7 cd cs)
    (d_OP_trTypeExpr_dot_uscore_hash_lambda227 x6 x1) cd cs
  FlatCurry.Curry_Types.C_TVar x8 -> x5
  FlatCurry.Curry_Types.C_TCons x9 x10 -> x5
  FlatCurry.Curry_Types.C_ForallType x11 x12 -> x5
  FlatCurry.Curry_Types.Choice_C_TypeExpr d i l r -> narrow d i (d_C__case_166
    x5 x1 x3 x2 l cd cs) (d_C__case_166 x5 x1 x3 x2 r cd cs)
  FlatCurry.Curry_Types.Choices_C_TypeExpr d i xs -> narrows cs d i (\z ->
    d_C__case_166 x5 x1 x3 x2 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_TypeExpr d c e -> guardCons d c (d_C__case_166
    x5 x1 x3 x2 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_TypeExpr d info -> failCons d (traceFail
    "TransFunctions._case_166" [show x5, show x1, show x3, show x2, show x4]
    info)
  _ -> failCons cd (consFail "TransFunctions._case_166" (showCons x4))

nd_C__case_166 :: C_IOES C_State Curry_AbstractHaskell.C_TypeExpr -> Func
  Curry_AbstractHaskell.C_TypeExpr (Func Curry_AbstractHaskell.C_TypeExpr
  Curry_AbstractHaskell.C_TypeExpr) -> Curry_Prelude.C_Int -> Func
  Curry_AbstractHaskell.C_TypeExpr Curry_AbstractHaskell.C_TypeExpr
  -> FlatCurry.Curry_Types.C_TypeExpr -> IDSupply -> Cover -> ConstStore
  -> C_IOES C_State Curry_AbstractHaskell.C_TypeExpr
nd_C__case_166 x5 x1 x3 x2 x4 s cd cs = case x4 of
  FlatCurry.Curry_Types.C_FuncType x6 x7 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_trTypeExpr x1 x2
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x3 (Curry_Prelude.C_Int (1)) cd cs) x7 s0 cd cs) (wrapNX id
    (nd_OP_trTypeExpr_dot_uscore_hash_lambda227 x6 x1)) s1 cd cs))
  FlatCurry.Curry_Types.C_TVar x8 -> x5
  FlatCurry.Curry_Types.C_TCons x9 x10 -> x5
  FlatCurry.Curry_Types.C_ForallType x11 x12 -> x5
  FlatCurry.Curry_Types.Choice_C_TypeExpr d i l r -> narrow d i (nd_C__case_166
    x5 x1 x3 x2 l s cd cs) (nd_C__case_166 x5 x1 x3 x2 r s cd cs)
  FlatCurry.Curry_Types.Choices_C_TypeExpr d i xs -> narrows cs d i (\z ->
    nd_C__case_166 x5 x1 x3 x2 z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_TypeExpr d c e -> guardCons d c (nd_C__case_166
    x5 x1 x3 x2 e s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_TypeExpr d info -> failCons d (traceFail
    "TransFunctions._case_166" [show x5, show x1, show x3, show x2, show x4]
    info)
  _ -> failCons cd (consFail "TransFunctions._case_166" (showCons x4))

d_C__case_169 :: Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeExpr
d_C__case_169 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> acceptCs id d_C_detFuncType
  Curry_Prelude.C_False -> acceptCs id d_C_nondetFuncType
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_169 l cd cs)
    (d_C__case_169 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_169 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_169 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_169" [show x2] info)
  _ -> failCons cd (consFail "TransFunctions._case_169" (showCons x2))

d_C__case_171 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_TypeExpr
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C__case_171 x9 x10 x1 x11 cd cs = case x11 of
  Curry_Prelude.C_True -> Curry_AbstractHaskell.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_AbstractHaskell_dot_TypeExpr
    (Curry_AbstractHaskell.C_TVar x1) (Curry_Prelude.d_C_head x10 cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_170 x10 x1 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_171 x9 x10 x1 l
    cd cs) (d_C__case_171 x9 x10 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_171 x9
    x10 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_171 x9 x10 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_171" [show x9, show x10, show x1, show x11] info)
  _ -> failCons cd (consFail "TransFunctions._case_171" (showCons x11))

d_C__case_170 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_TypeExpr
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C__case_170 x10 x1 x11 cd cs = case x11 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (Curry_Prelude.d_C_or cd cs)
    (Curry_Prelude.d_C_map (d_C_isHigherKinded x1) x10 cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_170 x10 x1 l cd
    cs) (d_C__case_170 x10 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_170 x10
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_170 x10 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_170" [show x10, show x1, show x11] info)
  _ -> failCons cd (consFail "TransFunctions._case_170" (showCons x11))

d_C__case_173 :: Curry_AbstractHaskell.C_TypeExpr -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_TypeExpr -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_TypeExpr -> Curry_AbstractHaskell.C_TypeExpr
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_TypeExpr
d_C__case_173 x4 x2 x9 x8 x3 x1 x10 cd cs = case x10 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons x4
    (d_OP_gatherContextTypeExprs_dot_gatherContextTypeExprs_tick_dot_265 x1 x2
    x3 (Curry_Prelude.d_OP_dollar Curry_Prelude.d_C_head (Curry_Prelude.d_C_tail
    x9 cd cs) cd cs) cd cs)
  Curry_Prelude.C_False -> d_C__case_172 x9 x3 x2 x1
    (Curry_Prelude.d_C_otherwise cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_173 x4 x2 x9 x8
    x3 x1 l cd cs) (d_C__case_173 x4 x2 x9 x8 x3 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_173 x4
    x2 x9 x8 x3 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_173 x4 x2 x9 x8
    x3 x1 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_173" [show x4, show x2, show x9, show x8, show x3
    , show x1, show x10] info)
  _ -> failCons cd (consFail "TransFunctions._case_173" (showCons x10))

d_C__case_172 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_TypeExpr
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_TypeExpr
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Curry_AbstractHaskell.C_TypeExpr -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_TypeExpr
d_C__case_172 x9 x3 x2 x1 x10 cd cs = case x10 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_foldl (acceptCs id
    (d_OP_gatherContextTypeExprs_dot_gatherContextTypeExprs_tick_dot_265 x1 x2))
    x3 x9 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_172 x9 x3 x2 x1 l
    cd cs) (d_C__case_172 x9 x3 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_172 x9
    x3 x2 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_172 x9 x3 x2 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_172" [show x9, show x3, show x2, show x1, show x10]
    info)
  _ -> failCons cd (consFail "TransFunctions._case_172" (showCons x10))

d_C__case_175 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_AbstractHaskell.C_TypeExpr
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_TypeExpr
  -> Curry_AbstractHaskell.C_TypeExpr -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_TypeExpr
d_C__case_175 x2 x5 x1 x3 x4 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> x3
  Curry_Prelude.C_False -> d_C__case_174 x3 x4 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_175 x2 x5 x1 x3
    x4 l cd cs) (d_C__case_175 x2 x5 x1 x3 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_175 x2
    x5 x1 x3 x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_175 x2 x5 x1 x3
    x4 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_175" [show x2, show x5, show x1, show x3, show x4
    , show x6] info)
  _ -> failCons cd (consFail "TransFunctions._case_175" (showCons x6))

d_C__case_174 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_TypeExpr
  -> Curry_AbstractHaskell.C_TypeExpr -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_TypeExpr
d_C__case_174 x3 x4 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons x4 x3
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_174 x3 x4 l cd
    cs) (d_C__case_174 x3 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_174 x3
    x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_174 x3 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_174" [show x3, show x4, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_174" (showCons x5))

d_C__case_181 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> FlatCurry.Curry_Types.C_Visibility
  -> FlatCurry.Curry_Types.C_TypeExpr -> FlatCurry.Curry_Types.C_Rule -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_FuncDecl)
d_C__case_181 x3 x2 x4 x5 x6 cd cs = case x6 of
  FlatCurry.Curry_Types.C_Rule x7 x8 -> let x9 = d_C_failM
                                              (Curry_Prelude.toCurryString
                                              "TransFunctions.trGlobalDecl: no global declaration")
                                              cd cs
    in d_C__case_180 x9 x3 x2 x4 x5 x8 cd cs
  FlatCurry.Curry_Types.C_External x32 -> d_C_failM (Curry_Prelude.toCurryString
    "TransFunctions.trGlobalDecl: no global declaration") cd cs
  FlatCurry.Curry_Types.Choice_C_Rule d i l r -> narrow d i (d_C__case_181 x3 x2
    x4 x5 l cd cs) (d_C__case_181 x3 x2 x4 x5 r cd cs)
  FlatCurry.Curry_Types.Choices_C_Rule d i xs -> narrows cs d i (\z ->
    d_C__case_181 x3 x2 x4 x5 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Rule d c e -> guardCons d c (d_C__case_181 x3 x2
    x4 x5 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Rule d info -> failCons d (traceFail
    "TransFunctions._case_181" [show x3, show x2, show x4, show x5, show x6]
    info)
  _ -> failCons cd (consFail "TransFunctions._case_181" (showCons x6))

nd_C__case_181 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> FlatCurry.Curry_Types.C_Visibility
  -> FlatCurry.Curry_Types.C_TypeExpr -> FlatCurry.Curry_Types.C_Rule
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_FuncDecl)
nd_C__case_181 x3 x2 x4 x5 x6 s cd cs = case x6 of
  FlatCurry.Curry_Types.C_Rule x7 x8 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` (let x9 = nd_C_failM (Curry_Prelude.toCurryString
                                 "TransFunctions.trGlobalDecl: no global declaration")
                                 s0 cd cs
    in nd_C__case_180 x9 x3 x2 x4 x5 x8 s1 cd cs)))
  FlatCurry.Curry_Types.C_External x32 -> let s0 = s
    in s0 `seq` nd_C_failM (Curry_Prelude.toCurryString
    "TransFunctions.trGlobalDecl: no global declaration") s0 cd cs
  FlatCurry.Curry_Types.Choice_C_Rule d i l r -> narrow d i (nd_C__case_181 x3
    x2 x4 x5 l s cd cs) (nd_C__case_181 x3 x2 x4 x5 r s cd cs)
  FlatCurry.Curry_Types.Choices_C_Rule d i xs -> narrows cs d i (\z ->
    nd_C__case_181 x3 x2 x4 x5 z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Rule d c e -> guardCons d c (nd_C__case_181 x3
    x2 x4 x5 e s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Rule d info -> failCons d (traceFail
    "TransFunctions._case_181" [show x3, show x2, show x4, show x5, show x6]
    info)
  _ -> failCons cd (consFail "TransFunctions._case_181" (showCons x6))

d_C__case_180 :: C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_FuncDecl) -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> FlatCurry.Curry_Types.C_Visibility -> FlatCurry.Curry_Types.C_TypeExpr
  -> FlatCurry.Curry_Types.C_Expr -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_FuncDecl)
d_C__case_180 x9 x3 x2 x4 x5 x8 cd cs = case x8 of
  FlatCurry.Curry_Types.C_Comb x10 x11 x12 -> d_C__case_179 x3 x2 x4 x5 x12 cd
    cs
  FlatCurry.Curry_Types.C_Var x19 -> x9
  FlatCurry.Curry_Types.C_Lit x20 -> x9
  FlatCurry.Curry_Types.C_Let x21 x22 -> x9
  FlatCurry.Curry_Types.C_Free x23 x24 -> x9
  FlatCurry.Curry_Types.C_Or x25 x26 -> x9
  FlatCurry.Curry_Types.C_Case x27 x28 x29 -> x9
  FlatCurry.Curry_Types.C_Typed x30 x31 -> x9
  FlatCurry.Curry_Types.Choice_C_Expr d i l r -> narrow d i (d_C__case_180 x9 x3
    x2 x4 x5 l cd cs) (d_C__case_180 x9 x3 x2 x4 x5 r cd cs)
  FlatCurry.Curry_Types.Choices_C_Expr d i xs -> narrows cs d i (\z ->
    d_C__case_180 x9 x3 x2 x4 x5 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Expr d c e -> guardCons d c (d_C__case_180 x9 x3
    x2 x4 x5 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Expr d info -> failCons d (traceFail
    "TransFunctions._case_180" [show x9, show x3, show x2, show x4, show x5
    , show x8] info)
  _ -> failCons cd (consFail "TransFunctions._case_180" (showCons x8))

nd_C__case_180 :: C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_FuncDecl) -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> FlatCurry.Curry_Types.C_Visibility -> FlatCurry.Curry_Types.C_TypeExpr
  -> FlatCurry.Curry_Types.C_Expr -> IDSupply -> Cover -> ConstStore -> C_IOES
  C_State (Curry_Prelude.OP_List Curry_AbstractHaskell.C_FuncDecl)
nd_C__case_180 x9 x3 x2 x4 x5 x8 s cd cs = case x8 of
  FlatCurry.Curry_Types.C_Comb x10 x11 x12 -> let s0 = s
    in s0 `seq` nd_C__case_179 x3 x2 x4 x5 x12 s0 cd cs
  FlatCurry.Curry_Types.C_Var x19 -> x9
  FlatCurry.Curry_Types.C_Lit x20 -> x9
  FlatCurry.Curry_Types.C_Let x21 x22 -> x9
  FlatCurry.Curry_Types.C_Free x23 x24 -> x9
  FlatCurry.Curry_Types.C_Or x25 x26 -> x9
  FlatCurry.Curry_Types.C_Case x27 x28 x29 -> x9
  FlatCurry.Curry_Types.C_Typed x30 x31 -> x9
  FlatCurry.Curry_Types.Choice_C_Expr d i l r -> narrow d i (nd_C__case_180 x9
    x3 x2 x4 x5 l s cd cs) (nd_C__case_180 x9 x3 x2 x4 x5 r s cd cs)
  FlatCurry.Curry_Types.Choices_C_Expr d i xs -> narrows cs d i (\z ->
    nd_C__case_180 x9 x3 x2 x4 x5 z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Expr d c e -> guardCons d c (nd_C__case_180 x9
    x3 x2 x4 x5 e s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Expr d info -> failCons d (traceFail
    "TransFunctions._case_180" [show x9, show x3, show x2, show x4, show x5
    , show x8] info)
  _ -> failCons cd (consFail "TransFunctions._case_180" (showCons x8))

d_C__case_179 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> FlatCurry.Curry_Types.C_Visibility
  -> FlatCurry.Curry_Types.C_TypeExpr -> Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_Expr -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_FuncDecl)
d_C__case_179 x3 x2 x4 x5 x12 cd cs = case x12 of
  Curry_Prelude.OP_Cons x13 x14 -> d_C__case_178 x3 x2 x4 x5 x13 x14 cd cs
  Curry_Prelude.OP_List -> d_C_failM (Curry_Prelude.toCurryString
    "TransFunctions.trGlobalDecl: no global declaration") cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_179 x3 x2 x4 x5
    l cd cs) (d_C__case_179 x3 x2 x4 x5 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_179 x3
    x2 x4 x5 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_179 x3 x2 x4 x5
    e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_179" [show x3, show x2, show x4, show x5, show x12]
    info)
  _ -> failCons cd (consFail "TransFunctions._case_179" (showCons x12))

nd_C__case_179 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> FlatCurry.Curry_Types.C_Visibility
  -> FlatCurry.Curry_Types.C_TypeExpr -> Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_Expr -> IDSupply -> Cover -> ConstStore -> C_IOES
  C_State (Curry_Prelude.OP_List Curry_AbstractHaskell.C_FuncDecl)
nd_C__case_179 x3 x2 x4 x5 x12 s cd cs = case x12 of
  Curry_Prelude.OP_Cons x13 x14 -> let s0 = s
    in s0 `seq` nd_C__case_178 x3 x2 x4 x5 x13 x14 s0 cd cs
  Curry_Prelude.OP_List -> let s0 = s
    in s0 `seq` nd_C_failM (Curry_Prelude.toCurryString
    "TransFunctions.trGlobalDecl: no global declaration") s0 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_179 x3 x2 x4 x5
    l s cd cs) (nd_C__case_179 x3 x2 x4 x5 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_179
    x3 x2 x4 x5 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C__case_179 x3 x2 x4 x5
    e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_179" [show x3, show x2, show x4, show x5, show x12]
    info)
  _ -> failCons cd (consFail "TransFunctions._case_179" (showCons x12))

d_C__case_178 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> FlatCurry.Curry_Types.C_Visibility
  -> FlatCurry.Curry_Types.C_TypeExpr -> FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr -> Cover -> ConstStore
  -> C_IOES C_State (Curry_Prelude.OP_List Curry_AbstractHaskell.C_FuncDecl)
d_C__case_178 x3 x2 x4 x5 x13 x14 cd cs = case x14 of
  Curry_Prelude.OP_Cons x15 x16 -> d_C__case_177 x3 x2 x4 x5 x13 x16 cd cs
  Curry_Prelude.OP_List -> d_C_failM (Curry_Prelude.toCurryString
    "TransFunctions.trGlobalDecl: no global declaration") cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_178 x3 x2 x4 x5
    x13 l cd cs) (d_C__case_178 x3 x2 x4 x5 x13 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_178 x3
    x2 x4 x5 x13 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_178 x3 x2 x4 x5
    x13 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_178" [show x3, show x2, show x4, show x5, show x13
    , show x14] info)
  _ -> failCons cd (consFail "TransFunctions._case_178" (showCons x14))

nd_C__case_178 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> FlatCurry.Curry_Types.C_Visibility
  -> FlatCurry.Curry_Types.C_TypeExpr -> FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_FuncDecl)
nd_C__case_178 x3 x2 x4 x5 x13 x14 s cd cs = case x14 of
  Curry_Prelude.OP_Cons x15 x16 -> let s0 = s
    in s0 `seq` nd_C__case_177 x3 x2 x4 x5 x13 x16 s0 cd cs
  Curry_Prelude.OP_List -> let s0 = s
    in s0 `seq` nd_C_failM (Curry_Prelude.toCurryString
    "TransFunctions.trGlobalDecl: no global declaration") s0 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_178 x3 x2 x4 x5
    x13 l s cd cs) (nd_C__case_178 x3 x2 x4 x5 x13 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_178
    x3 x2 x4 x5 x13 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C__case_178 x3 x2 x4 x5
    x13 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_178" [show x3, show x2, show x4, show x5, show x13
    , show x14] info)
  _ -> failCons cd (consFail "TransFunctions._case_178" (showCons x14))

d_C__case_177 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> FlatCurry.Curry_Types.C_Visibility
  -> FlatCurry.Curry_Types.C_TypeExpr -> FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr -> Cover -> ConstStore
  -> C_IOES C_State (Curry_Prelude.OP_List Curry_AbstractHaskell.C_FuncDecl)
d_C__case_177 x3 x2 x4 x5 x13 x16 cd cs = case x16 of
  Curry_Prelude.OP_List -> d_C__case_176 x3 x2 x4 x5 x13
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
    x3 (Curry_Prelude.C_Int (0)) cd cs) cd cs
  Curry_Prelude.OP_Cons x17 x18 -> d_C_failM (Curry_Prelude.toCurryString
    "TransFunctions.trGlobalDecl: no global declaration") cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_177 x3 x2 x4 x5
    x13 l cd cs) (d_C__case_177 x3 x2 x4 x5 x13 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_177 x3
    x2 x4 x5 x13 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_177 x3 x2 x4 x5
    x13 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_177" [show x3, show x2, show x4, show x5, show x13
    , show x16] info)
  _ -> failCons cd (consFail "TransFunctions._case_177" (showCons x16))

nd_C__case_177 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> FlatCurry.Curry_Types.C_Visibility
  -> FlatCurry.Curry_Types.C_TypeExpr -> FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_FuncDecl)
nd_C__case_177 x3 x2 x4 x5 x13 x16 s cd cs = case x16 of
  Curry_Prelude.OP_List -> let s0 = s
    in s0 `seq` nd_C__case_176 x3 x2 x4 x5 x13
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
    x3 (Curry_Prelude.C_Int (0)) cd cs) s0 cd cs
  Curry_Prelude.OP_Cons x17 x18 -> let s0 = s
    in s0 `seq` nd_C_failM (Curry_Prelude.toCurryString
    "TransFunctions.trGlobalDecl: no global declaration") s0 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_177 x3 x2 x4 x5
    x13 l s cd cs) (nd_C__case_177 x3 x2 x4 x5 x13 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_177
    x3 x2 x4 x5 x13 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C__case_177 x3 x2 x4 x5
    x13 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_177" [show x3, show x2, show x4, show x5, show x13
    , show x16] info)
  _ -> failCons cd (consFail "TransFunctions._case_177" (showCons x16))

d_C__case_176 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> FlatCurry.Curry_Types.C_Visibility
  -> FlatCurry.Curry_Types.C_TypeExpr -> FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_FuncDecl)
d_C__case_176 x3 x2 x4 x5 x13 x14 cd cs = case x14 of
  Curry_Prelude.C_True -> d_OP_gt_plus_eq (d_C_trCompleteExpr x13 cd cs)
    (d_OP_trGlobalDecl_dot_uscore_hash_lambda208 x5 x4 x2) cd cs
  Curry_Prelude.C_False -> d_C_failM (Curry_Prelude.toCurryString
    "TransFunctions.trGlobalDecl: no global declaration") cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_176 x3 x2 x4 x5
    x13 l cd cs) (d_C__case_176 x3 x2 x4 x5 x13 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_176 x3
    x2 x4 x5 x13 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_176 x3 x2 x4 x5
    x13 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_176" [show x3, show x2, show x4, show x5, show x13
    , show x14] info)
  _ -> failCons cd (consFail "TransFunctions._case_176" (showCons x14))

nd_C__case_176 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> FlatCurry.Curry_Types.C_Visibility
  -> FlatCurry.Curry_Types.C_TypeExpr -> FlatCurry.Curry_Types.C_Expr
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_FuncDecl)
nd_C__case_176 x3 x2 x4 x5 x13 x14 s cd cs = case x14 of
  Curry_Prelude.C_True -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_trCompleteExpr x13 s0 cd cs)
    (wrapNX id (nd_OP_trGlobalDecl_dot_uscore_hash_lambda208 x5 x4 x2)) s1 cd
    cs))
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C_failM (Curry_Prelude.toCurryString
    "TransFunctions.trGlobalDecl: no global declaration") s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_176 x3 x2 x4 x5
    x13 l s cd cs) (nd_C__case_176 x3 x2 x4 x5 x13 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_176 x3
    x2 x4 x5 x13 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_176 x3 x2 x4 x5
    x13 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_176" [show x3, show x2, show x4, show x5, show x13
    , show x14] info)
  _ -> failCons cd (consFail "TransFunctions._case_176" (showCons x14))

d_C__case_186 :: Curry_Prelude.C_Bool -> FlatCurry.Curry_Types.C_Expr -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_186 x2 x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_Comb x3 x4 x5 -> let x6 = Curry_Prelude.C_False
    in d_C__case_185 x6 x5 x4 x3 cd cs
  FlatCurry.Curry_Types.C_Var x15 -> x2
  FlatCurry.Curry_Types.C_Lit x16 -> x2
  FlatCurry.Curry_Types.C_Let x17 x18 -> x2
  FlatCurry.Curry_Types.C_Free x19 x20 -> x2
  FlatCurry.Curry_Types.C_Or x21 x22 -> x2
  FlatCurry.Curry_Types.C_Case x23 x24 x25 -> x2
  FlatCurry.Curry_Types.C_Typed x26 x27 -> x2
  FlatCurry.Curry_Types.Choice_C_Expr d i l r -> narrow d i (d_C__case_186 x2 l
    cd cs) (d_C__case_186 x2 r cd cs)
  FlatCurry.Curry_Types.Choices_C_Expr d i xs -> narrows cs d i (\z ->
    d_C__case_186 x2 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Expr d c e -> guardCons d c (d_C__case_186 x2 e
    cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Expr d info -> failCons d (traceFail
    "TransFunctions._case_186" [show x2, show x1] info)
  _ -> failCons cd (consFail "TransFunctions._case_186" (showCons x1))

d_C__case_185 :: Curry_Prelude.C_Bool -> Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_Expr -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> FlatCurry.Curry_Types.C_CombType -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C__case_185 x6 x5 x4 x3 cd cs = case x3 of
  FlatCurry.Curry_Types.C_FuncCall -> d_C__case_184 x4 x5 cd cs
  FlatCurry.Curry_Types.C_ConsCall -> x6
  FlatCurry.Curry_Types.C_FuncPartCall x13 -> x6
  FlatCurry.Curry_Types.C_ConsPartCall x14 -> x6
  FlatCurry.Curry_Types.Choice_C_CombType d i l r -> narrow d i (d_C__case_185
    x6 x5 x4 l cd cs) (d_C__case_185 x6 x5 x4 r cd cs)
  FlatCurry.Curry_Types.Choices_C_CombType d i xs -> narrows cs d i (\z ->
    d_C__case_185 x6 x5 x4 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_CombType d c e -> guardCons d c (d_C__case_185
    x6 x5 x4 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_CombType d info -> failCons d (traceFail
    "TransFunctions._case_185" [show x6, show x5, show x4, show x3] info)
  _ -> failCons cd (consFail "TransFunctions._case_185" (showCons x3))

d_C__case_184 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C__case_184 x4 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x7 x8 -> d_C__case_183 x4 x8 cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.C_False
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_184 x4 l cd cs)
    (d_C__case_184 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_184 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_184 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_184" [show x4, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_184" (showCons x5))

d_C__case_183 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C__case_183 x4 x8 cd cs = case x8 of
  Curry_Prelude.OP_Cons x9 x10 -> d_C__case_182 x9 x4 x10 cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.C_False
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_183 x4 l cd cs)
    (d_C__case_183 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_183 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_183 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_183" [show x4, show x8] info)
  _ -> failCons cd (consFail "TransFunctions._case_183" (showCons x8))

d_C__case_182 :: FlatCurry.Curry_Types.C_Expr -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_Expr
  -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_182 x9 x4 x10 cd cs = case x10 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_OP_amp_amp
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) x4 (d_C_globalGlobal cd cs) cd cs)
    (FlatCurry.Curry_Types.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_FlatCurry_dot_Types_dot_Expr
    x9 (FlatCurry.Curry_Types.C_Comb FlatCurry.Curry_Types.C_ConsCall
    (d_C_globalTemporary cd cs) Curry_Prelude.OP_List) cd cs) cd cs
  Curry_Prelude.OP_Cons x11 x12 -> Curry_Prelude.C_False
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_182 x9 x4 l cd
    cs) (d_C__case_182 x9 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_182 x9
    x4 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_182 x9 x4 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_182" [show x9, show x4, show x10] info)
  _ -> failCons cd (consFail "TransFunctions._case_182" (showCons x10))

d_C__case_188 :: Curry_Prelude.C_Int -> FlatCurry.Curry_Types.C_Rule -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_188 x3 x6 cd cs = case x6 of
  FlatCurry.Curry_Types.C_Rule x7 x8 -> d_C__case_187 x8 x3 x7 cd cs
  FlatCurry.Curry_Types.C_External x11 -> Curry_Prelude.C_False
  FlatCurry.Curry_Types.Choice_C_Rule d i l r -> narrow d i (d_C__case_188 x3 l
    cd cs) (d_C__case_188 x3 r cd cs)
  FlatCurry.Curry_Types.Choices_C_Rule d i xs -> narrows cs d i (\z ->
    d_C__case_188 x3 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Rule d c e -> guardCons d c (d_C__case_188 x3 e
    cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Rule d info -> failCons d (traceFail
    "TransFunctions._case_188" [show x3, show x6] info)
  _ -> failCons cd (consFail "TransFunctions._case_188" (showCons x6))

d_C__case_187 :: FlatCurry.Curry_Types.C_Expr -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C__case_187 x8 x3 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_OP_amp_amp
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
    x3 (Curry_Prelude.C_Int (0)) cd cs) (d_C_isGlobalCall x8 cd cs) cd cs
  Curry_Prelude.OP_Cons x9 x10 -> Curry_Prelude.C_False
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_187 x8 x3 l cd
    cs) (d_C__case_187 x8 x3 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_187 x8
    x3 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_187 x8 x3 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransFunctions._case_187" [show x8, show x3, show x7] info)
  _ -> failCons cd (consFail "TransFunctions._case_187" (showCons x7))

d_C__case_191 :: Curry_Classification.C_FuncHOClass
  -> Curry_Classification.C_NDClass -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  Curry_Classification.C_NDClass Curry_Classification.C_FuncHOClass -> Cover
  -> ConstStore -> C_IOES C_State Curry_Prelude.OP_Unit
d_C__case_191 x3 x1 x2 x6 cd cs = case x6 of
  Curry_Prelude.OP_Tuple2 x4 x5 -> d_C__case_190 x2 x5 x4 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C__case_191 x3 x1 x2 l
    cd cs) (d_C__case_191 x3 x1 x2 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C__case_191
    x3 x1 x2 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C__case_191 x3 x1 x2 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions._case_191" [show x3, show x1, show x2, show x6] info)
  _ -> failCons cd (consFail "TransFunctions._case_191" (showCons x6))

nd_C__case_191 :: Curry_Classification.C_FuncHOClass
  -> Curry_Classification.C_NDClass -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  Curry_Classification.C_NDClass Curry_Classification.C_FuncHOClass -> IDSupply
  -> Cover -> ConstStore -> C_IOES C_State Curry_Prelude.OP_Unit
nd_C__case_191 x3 x1 x2 x6 s cd cs = case x6 of
  Curry_Prelude.OP_Tuple2 x4 x5 -> let s0 = s
    in s0 `seq` nd_C__case_190 x2 x5 x4 s0 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (nd_C__case_191 x3 x1 x2
    l s cd cs) (nd_C__case_191 x3 x1 x2 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> nd_C__case_191
    x3 x1 x2 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (nd_C__case_191 x3 x1 x2
    e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions._case_191" [show x3, show x1, show x2, show x6] info)
  _ -> failCons cd (consFail "TransFunctions._case_191" (showCons x6))

d_C__case_190 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Classification.C_FuncHOClass -> Curry_Classification.C_NDClass
  -> Cover -> ConstStore -> C_IOES C_State Curry_Prelude.OP_Unit
d_C__case_190 x2 x5 x4 cd cs = case x4 of
  Curry_Classification.C_ND -> Curry_Prelude.d_OP_dollar d_C_failM
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString
    "Non-determinismic initial value for global `")
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char
    cd cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char
    cd cs) cd cs) cd cs) (Curry_Prelude.d_C_apply (Curry_Names.d_C_unRenameQName
    cd cs) x2 cd cs) cd cs) (Curry_Prelude.toCurryString "'") cd cs) cd cs) cd
    cs
  Curry_Classification.C_D -> let x6 = Curry_Prelude.d_OP_dollar d_C_failM
                                    (Curry_Prelude.d_OP_plus_plus
                                    (Curry_Prelude.toCurryString
                                    "Higher-order type for global `")
                                    (Curry_Prelude.d_OP_plus_plus
                                    (Curry_Prelude.d_C_apply
                                    (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_lparen_comma_rparen
                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_lbracket_rbracket
                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char
                                    cd cs) cd cs)
                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_lbracket_rbracket
                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char
                                    cd cs) cd cs) cd cs)
                                    (Curry_Prelude.d_C_apply
                                    (Curry_Names.d_C_unRenameQName cd cs) x2 cd
                                    cs) cd cs) (Curry_Prelude.toCurryString "'")
                                    cd cs) cd cs) cd cs
    in d_C__case_189 x6 x5 cd cs
  Curry_Classification.Choice_C_NDClass d i l r -> narrow d i (d_C__case_190 x2
    x5 l cd cs) (d_C__case_190 x2 x5 r cd cs)
  Curry_Classification.Choices_C_NDClass d i xs -> narrows cs d i (\z ->
    d_C__case_190 x2 x5 z cd cs) xs
  Curry_Classification.Guard_C_NDClass d c e -> guardCons d c (d_C__case_190 x2
    x5 e cd $! addCs c cs)
  Curry_Classification.Fail_C_NDClass d info -> failCons d (traceFail
    "TransFunctions._case_190" [show x2, show x5, show x4] info)
  _ -> failCons cd (consFail "TransFunctions._case_190" (showCons x4))

nd_C__case_190 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Classification.C_FuncHOClass -> Curry_Classification.C_NDClass
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State Curry_Prelude.OP_Unit
nd_C__case_190 x2 x5 x4 s cd cs = case x4 of
  Curry_Classification.C_ND -> let s14 = s
    in s14 `seq` (let s13 = leftSupply s14
                      s11 = rightSupply s14
    in s13 `seq` (s11 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id nd_C_failM)
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString
    "Non-determinismic initial value for global `")
    (Curry_Prelude.d_OP_plus_plus (let s10 = leftSupply s11
                                       s12 = rightSupply s11
                                       s7 = leftSupply s12
                                       s9 = rightSupply s12
    in s10 `seq` (s12 `seq` (s7 `seq` (s9 `seq` Curry_Prelude.nd_C_apply
    (let s6 = leftSupply s7
         s8 = rightSupply s7
         s2 = leftSupply s8
         s5 = rightSupply s8
    in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq`
    Curry_Prelude.nd_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_lparen_comma_rparen
    (let s1 = leftSupply s2
         s0 = rightSupply s2
    in s1 `seq` (s0 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char
    s0 cd cs) s1 cd cs)) (let s4 = leftSupply s5
                              s3 = rightSupply s5
    in s4 `seq` (s3 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char
    s3 cd cs) s4 cd cs)) s6 cd cs)))) (Curry_Prelude.nd_C_apply (wrapDX id
    (Curry_Names.d_C_unRenameQName cd cs)) x2 s9 cd cs) s10 cd cs))))
    (Curry_Prelude.toCurryString "'") cd cs) cd cs) s13 cd cs))
  Curry_Classification.C_D -> let s16 = s
    in s16 `seq` (let s14 = leftSupply s16
                      s15 = rightSupply s16
    in s14 `seq` (s15 `seq` (let x6 = let s13 = leftSupply s14
                                          s11 = rightSupply s14
                                   in s13 `seq` (s11 `seq`
                                   Curry_Prelude.nd_OP_dollar (wrapNX id
                                   nd_C_failM) (Curry_Prelude.d_OP_plus_plus
                                   (Curry_Prelude.toCurryString
                                   "Higher-order type for global `")
                                   (Curry_Prelude.d_OP_plus_plus
                                   (let s10 = leftSupply s11
                                        s12 = rightSupply s11
                                        s7 = leftSupply s12
                                        s9 = rightSupply s12
                                   in s10 `seq` (s12 `seq` (s7 `seq` (s9 `seq`
                                   Curry_Prelude.nd_C_apply (let s6 = leftSupply
                                                                   s7
                                                                 s8 = rightSupply
                                                                   s7
                                                                 s2 = leftSupply
                                                                   s8
                                                                 s5 = rightSupply
                                                                   s8
                                   in s6 `seq` (s8 `seq` (s2 `seq` (s5 `seq`
                                   Curry_Prelude.nd_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_lparen_comma_rparen
                                   (let s1 = leftSupply s2
                                        s0 = rightSupply s2
                                   in s1 `seq` (s0 `seq`
                                   Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_lbracket_rbracket
                                   (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char
                                   s0 cd cs) s1 cd cs)) (let s4 = leftSupply s5
                                                             s3 = rightSupply s5
                                   in s4 `seq` (s3 `seq`
                                   Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_lbracket_rbracket
                                   (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char
                                   s3 cd cs) s4 cd cs)) s6 cd cs))))
                                   (Curry_Prelude.nd_C_apply (wrapDX id
                                   (Curry_Names.d_C_unRenameQName cd cs)) x2 s9
                                   cd cs) s10 cd cs))))
                                   (Curry_Prelude.toCurryString "'") cd cs) cd
                                   cs) s13 cd cs)
    in nd_C__case_189 x6 x5 s15 cd cs)))
  Curry_Classification.Choice_C_NDClass d i l r -> narrow d i (nd_C__case_190 x2
    x5 l s cd cs) (nd_C__case_190 x2 x5 r s cd cs)
  Curry_Classification.Choices_C_NDClass d i xs -> narrows cs d i (\z ->
    nd_C__case_190 x2 x5 z s cd cs) xs
  Curry_Classification.Guard_C_NDClass d c e -> guardCons d c (nd_C__case_190 x2
    x5 e s cd $! addCs c cs)
  Curry_Classification.Fail_C_NDClass d info -> failCons d (traceFail
    "TransFunctions._case_190" [show x2, show x5, show x4] info)
  _ -> failCons cd (consFail "TransFunctions._case_190" (showCons x4))

d_C__case_189 :: C_IOES C_State Curry_Prelude.OP_Unit
  -> Curry_Classification.C_FuncHOClass -> Cover -> ConstStore -> C_IOES C_State
  Curry_Prelude.OP_Unit
d_C__case_189 x6 x5 cd cs = case x5 of
  Curry_Classification.C_FuncFO -> d_C_returnM Curry_Prelude.OP_Unit cd cs
  Curry_Classification.C_FuncHORes x7 -> x6
  Curry_Classification.C_FuncHO -> x6
  Curry_Classification.Choice_C_FuncHOClass d i l r -> narrow d i (d_C__case_189
    x6 l cd cs) (d_C__case_189 x6 r cd cs)
  Curry_Classification.Choices_C_FuncHOClass d i xs -> narrows cs d i (\z ->
    d_C__case_189 x6 z cd cs) xs
  Curry_Classification.Guard_C_FuncHOClass d c e -> guardCons d c (d_C__case_189
    x6 e cd $! addCs c cs)
  Curry_Classification.Fail_C_FuncHOClass d info -> failCons d (traceFail
    "TransFunctions._case_189" [show x6, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_189" (showCons x5))

nd_C__case_189 :: C_IOES C_State Curry_Prelude.OP_Unit
  -> Curry_Classification.C_FuncHOClass -> IDSupply -> Cover -> ConstStore
  -> C_IOES C_State Curry_Prelude.OP_Unit
nd_C__case_189 x6 x5 s cd cs = case x5 of
  Curry_Classification.C_FuncFO -> let s0 = s
    in s0 `seq` nd_C_returnM Curry_Prelude.OP_Unit s0 cd cs
  Curry_Classification.C_FuncHORes x7 -> x6
  Curry_Classification.C_FuncHO -> x6
  Curry_Classification.Choice_C_FuncHOClass d i l r -> narrow d i
    (nd_C__case_189 x6 l s cd cs) (nd_C__case_189 x6 r s cd cs)
  Curry_Classification.Choices_C_FuncHOClass d i xs -> narrows cs d i (\z ->
    nd_C__case_189 x6 z s cd cs) xs
  Curry_Classification.Guard_C_FuncHOClass d c e -> guardCons d c
    (nd_C__case_189 x6 e s cd $! addCs c cs)
  Curry_Classification.Fail_C_FuncHOClass d info -> failCons d (traceFail
    "TransFunctions._case_189" [show x6, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_189" (showCons x5))

d_C__case_193 :: FlatCurry.Curry_Types.C_FuncDecl -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> C_IOES
  C_State Curry_Prelude.OP_Unit
d_C__case_193 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> d_OP_gt_plus_eq (d_C_getNDClass x2 cd cs)
    (d_OP_checkGlobal_dot_uscore_hash_lambda202 x2) cd cs
  Curry_Prelude.C_False -> d_C__case_192 (Curry_Prelude.d_C_otherwise cd cs) cd
    cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_193 x1 x2 l cd
    cs) (d_C__case_193 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_193 x1
    x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_193 x1 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_193" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransFunctions._case_193" (showCons x3))

nd_C__case_193 :: FlatCurry.Curry_Types.C_FuncDecl -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> C_IOES C_State Curry_Prelude.OP_Unit
nd_C__case_193 x1 x2 x3 s cd cs = case x3 of
  Curry_Prelude.C_True -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getNDClass x2 s0 cd cs) (wrapNX
    id (nd_OP_checkGlobal_dot_uscore_hash_lambda202 x2)) s1 cd cs))
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_192 (Curry_Prelude.d_C_otherwise cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_193 x1 x2 l s cd
    cs) (nd_C__case_193 x1 x2 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_193 x1
    x2 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_193 x1 x2 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_193" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransFunctions._case_193" (showCons x3))

d_C__case_192 :: Curry_Prelude.C_Bool -> Cover -> ConstStore -> C_IOES C_State
  Curry_Prelude.OP_Unit
d_C__case_192 x1 cd cs = case x1 of
  Curry_Prelude.C_True -> d_C_returnM Curry_Prelude.OP_Unit cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_192 l cd cs)
    (d_C__case_192 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_192 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_192 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_192" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions._case_192" (showCons x1))

nd_C__case_192 :: Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> C_IOES C_State Curry_Prelude.OP_Unit
nd_C__case_192 x1 s cd cs = case x1 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` nd_C_returnM Curry_Prelude.OP_Unit s0 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_192 l s cd cs)
    (nd_C__case_192 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_192 z
    s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_192 e s cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_192" [show x1] info)
  _ -> failCons cd (consFail "TransFunctions._case_192" (showCons x1))

d_C__case_197 :: Curry_Classification.C_FuncHOClass
  -> FlatCurry.Curry_Types.C_FuncDecl -> Curry_Classification.C_NDClass -> Cover
  -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_FuncDecl)
d_C__case_197 x5 x3 x1 cd cs = case x1 of
  Curry_Classification.C_ND -> d_OP_gt_plus_eq (d_C_trNDFunc x3 cd cs)
    d_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda196
    cd cs
  Curry_Classification.C_D -> d_C__case_196 x3 x5 cd cs
  Curry_Classification.Choice_C_NDClass d i l r -> narrow d i (d_C__case_197 x5
    x3 l cd cs) (d_C__case_197 x5 x3 r cd cs)
  Curry_Classification.Choices_C_NDClass d i xs -> narrows cs d i (\z ->
    d_C__case_197 x5 x3 z cd cs) xs
  Curry_Classification.Guard_C_NDClass d c e -> guardCons d c (d_C__case_197 x5
    x3 e cd $! addCs c cs)
  Curry_Classification.Fail_C_NDClass d info -> failCons d (traceFail
    "TransFunctions._case_197" [show x5, show x3, show x1] info)
  _ -> failCons cd (consFail "TransFunctions._case_197" (showCons x1))

nd_C__case_197 :: Curry_Classification.C_FuncHOClass
  -> FlatCurry.Curry_Types.C_FuncDecl -> Curry_Classification.C_NDClass
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_FuncDecl)
nd_C__case_197 x5 x3 x1 s cd cs = case x1 of
  Curry_Classification.C_ND -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_trNDFunc x3 s0 cd cs) (wrapNX
    id
    nd_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda196)
    s1 cd cs))
  Curry_Classification.C_D -> let s0 = s
    in s0 `seq` nd_C__case_196 x3 x5 s0 cd cs
  Curry_Classification.Choice_C_NDClass d i l r -> narrow d i (nd_C__case_197 x5
    x3 l s cd cs) (nd_C__case_197 x5 x3 r s cd cs)
  Curry_Classification.Choices_C_NDClass d i xs -> narrows cs d i (\z ->
    nd_C__case_197 x5 x3 z s cd cs) xs
  Curry_Classification.Guard_C_NDClass d c e -> guardCons d c (nd_C__case_197 x5
    x3 e s cd $! addCs c cs)
  Curry_Classification.Fail_C_NDClass d info -> failCons d (traceFail
    "TransFunctions._case_197" [show x5, show x3, show x1] info)
  _ -> failCons cd (consFail "TransFunctions._case_197" (showCons x1))

d_C__case_196 :: FlatCurry.Curry_Types.C_FuncDecl
  -> Curry_Classification.C_FuncHOClass -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_FuncDecl)
d_C__case_196 x3 x5 cd cs = case x5 of
  Curry_Classification.C_FuncHO -> d_OP_gt_plus_eq (d_C_trDetFunc x3 cd cs)
    (d_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda198
    x3) cd cs
  Curry_Classification.C_FuncHORes x6 -> d_OP_gt_plus_eq (d_C_trDetFunc x3 cd
    cs)
    d_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda200
    cd cs
  Curry_Classification.C_FuncFO -> d_C__case_195 x3 (d_C_isGlobalDecl x3 cd cs)
    cd cs
  Curry_Classification.Choice_C_FuncHOClass d i l r -> narrow d i (d_C__case_196
    x3 l cd cs) (d_C__case_196 x3 r cd cs)
  Curry_Classification.Choices_C_FuncHOClass d i xs -> narrows cs d i (\z ->
    d_C__case_196 x3 z cd cs) xs
  Curry_Classification.Guard_C_FuncHOClass d c e -> guardCons d c (d_C__case_196
    x3 e cd $! addCs c cs)
  Curry_Classification.Fail_C_FuncHOClass d info -> failCons d (traceFail
    "TransFunctions._case_196" [show x3, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_196" (showCons x5))

nd_C__case_196 :: FlatCurry.Curry_Types.C_FuncDecl
  -> Curry_Classification.C_FuncHOClass -> IDSupply -> Cover -> ConstStore
  -> C_IOES C_State (Curry_Prelude.OP_List Curry_AbstractHaskell.C_FuncDecl)
nd_C__case_196 x3 x5 s cd cs = case x5 of
  Curry_Classification.C_FuncHO -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_trDetFunc x3 s0 cd cs) (wrapNX
    id
    (nd_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda198
    x3)) s1 cd cs))
  Curry_Classification.C_FuncHORes x6 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_trDetFunc x3 s0 cd cs) (wrapNX
    id
    nd_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda200)
    s1 cd cs))
  Curry_Classification.C_FuncFO -> let s0 = s
    in s0 `seq` nd_C__case_195 x3 (d_C_isGlobalDecl x3 cd cs) s0 cd cs
  Curry_Classification.Choice_C_FuncHOClass d i l r -> narrow d i
    (nd_C__case_196 x3 l s cd cs) (nd_C__case_196 x3 r s cd cs)
  Curry_Classification.Choices_C_FuncHOClass d i xs -> narrows cs d i (\z ->
    nd_C__case_196 x3 z s cd cs) xs
  Curry_Classification.Guard_C_FuncHOClass d c e -> guardCons d c
    (nd_C__case_196 x3 e s cd $! addCs c cs)
  Curry_Classification.Fail_C_FuncHOClass d info -> failCons d (traceFail
    "TransFunctions._case_196" [show x3, show x5] info)
  _ -> failCons cd (consFail "TransFunctions._case_196" (showCons x5))

d_C__case_195 :: FlatCurry.Curry_Types.C_FuncDecl -> Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_FuncDecl)
d_C__case_195 x3 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> d_C_trGlobalDecl x3 cd cs
  Curry_Prelude.C_False -> d_C__case_194 x3 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_195 x3 l cd cs)
    (d_C__case_195 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_195 x3
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_195 x3 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_195" [show x3, show x4] info)
  _ -> failCons cd (consFail "TransFunctions._case_195" (showCons x4))

nd_C__case_195 :: FlatCurry.Curry_Types.C_FuncDecl -> Curry_Prelude.C_Bool
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_FuncDecl)
nd_C__case_195 x3 x4 s cd cs = case x4 of
  Curry_Prelude.C_True -> let s0 = s in s0 `seq` nd_C_trGlobalDecl x3 s0 cd cs
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_194 x3 (Curry_Prelude.d_C_otherwise cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_195 x3 l s cd
    cs) (nd_C__case_195 x3 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_195 x3
    z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_195 x3 e s cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_195" [show x3, show x4] info)
  _ -> failCons cd (consFail "TransFunctions._case_195" (showCons x4))

d_C__case_194 :: FlatCurry.Curry_Types.C_FuncDecl -> Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_FuncDecl)
d_C__case_194 x3 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> d_OP_gt_plus_eq (d_C_trDetFunc x3 cd cs)
    d_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda201
    cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_194 x3 l cd cs)
    (d_C__case_194 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_194 x3
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_194 x3 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_194" [show x3, show x4] info)
  _ -> failCons cd (consFail "TransFunctions._case_194" (showCons x4))

nd_C__case_194 :: FlatCurry.Curry_Types.C_FuncDecl -> Curry_Prelude.C_Bool
  -> IDSupply -> Cover -> ConstStore -> C_IOES C_State (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_FuncDecl)
nd_C__case_194 x3 x4 s cd cs = case x4 of
  Curry_Prelude.C_True -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_trDetFunc x3 s0 cd cs) (wrapNX
    id
    nd_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193_dot_uscore_hash_lambda194_dot_uscore_hash_lambda201)
    s1 cd cs))
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_194 x3 l s cd
    cs) (nd_C__case_194 x3 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_194 x3
    z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_194 x3 e s cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_194" [show x3, show x4] info)
  _ -> failCons cd (consFail "TransFunctions._case_194" (showCons x4))

d_C__case_198 :: Curry_CompilerOpts.C_Options -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> FlatCurry.Curry_Types.C_FuncDecl
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_FuncDecl)
d_C__case_198 x3 x2 x1 x4 cd cs = case x4 of
  Curry_Prelude.C_False -> d_OP_gt_plus_eq (d_C_trNDFunc x1 cd cs)
    d_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda192 cd cs
  Curry_Prelude.C_True -> d_OP_gt_plus_eq (d_C_getNDClass x2 cd cs)
    (d_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193 x3 x1 x2)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_198 x3 x2 x1 l cd
    cs) (d_C__case_198 x3 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_198 x3
    x2 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_198 x3 x2 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_198" [show x3, show x2, show x1, show x4] info)
  _ -> failCons cd (consFail "TransFunctions._case_198" (showCons x4))

nd_C__case_198 :: Curry_CompilerOpts.C_Options -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> FlatCurry.Curry_Types.C_FuncDecl
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore -> C_IOES C_State
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_FuncDecl)
nd_C__case_198 x3 x2 x1 x4 s cd cs = case x4 of
  Curry_Prelude.C_False -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_trNDFunc x1 s0 cd cs) (wrapNX
    id nd_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda192) s1 cd
    cs))
  Curry_Prelude.C_True -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_OP_gt_plus_eq (nd_C_getNDClass x2 s0 cd cs) (wrapNX
    id (nd_OP_trFunc_dot_uscore_hash_lambda190_dot_uscore_hash_lambda193 x3 x1
    x2)) s1 cd cs))
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_198 x3 x2 x1 l s
    cd cs) (nd_C__case_198 x3 x2 x1 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_198 x3
    x2 x1 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_198 x3 x2 x1 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransFunctions._case_198" [show x3, show x2, show x1, show x4] info)
  _ -> failCons cd (consFail "TransFunctions._case_198" (showCons x4))

d_C__case_199 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> C_State -> Cover
  -> ConstStore -> C_State
d_C__case_199 x1 x3 x2 cd cs = case x2 of
  C_State x4 x5 x6 x7 x8 x9 x10 x11 -> C_State x4 x5 x6 x7 x8
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x3 x1 cd cs) x10 x11
  Choice_C_State d i l r -> narrow d i (d_C__case_199 x1 x3 l cd cs)
    (d_C__case_199 x1 x3 r cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z -> d_C__case_199 x1 x3 z cd cs)
    xs
  Guard_C_State d c e -> guardCons d c (d_C__case_199 x1 x3 e cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail "TransFunctions._case_199" [show
    x1, show x3, show x2] info)
  _ -> failCons cd (consFail "TransFunctions._case_199" (showCons x2))

nd_C__case_199 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Int -> C_State
  -> IDSupply -> Cover -> ConstStore -> C_State
nd_C__case_199 x1 x3 x2 s cd cs = case x2 of
  C_State x4 x5 x6 x7 x8 x9 x10 x11 -> C_State x4 x5 x6 x7 x8
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x3 x1 cd cs) x10 x11
  Choice_C_State d i l r -> narrow d i (nd_C__case_199 x1 x3 l s cd cs)
    (nd_C__case_199 x1 x3 r s cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z -> nd_C__case_199 x1 x3 z s cd
    cs) xs
  Guard_C_State d c e -> guardCons d c (nd_C__case_199 x1 x3 e s cd $! addCs c
    cs)
  Fail_C_State d info -> failCons d (traceFail "TransFunctions._case_199" [show
    x1, show x3, show x2] info)
  _ -> failCons cd (consFail "TransFunctions._case_199" (showCons x2))

d_C__case_200 :: Curry_Prelude.C_Int -> C_State -> Cover -> ConstStore
  -> C_State
d_C__case_200 x2 x1 cd cs = case x1 of
  C_State x3 x4 x5 x6 x7 x8 x9 x10 -> C_State x3 x4 x5 x6 x7
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x2 (Curry_Prelude.C_Int (1)) cd cs) x9 x10
  Choice_C_State d i l r -> narrow d i (d_C__case_200 x2 l cd cs) (d_C__case_200
    x2 r cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z -> d_C__case_200 x2 z cd cs) xs
  Guard_C_State d c e -> guardCons d c (d_C__case_200 x2 e cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail "TransFunctions._case_200" [show
    x2, show x1] info)
  _ -> failCons cd (consFail "TransFunctions._case_200" (showCons x1))

nd_C__case_200 :: Curry_Prelude.C_Int -> C_State -> IDSupply -> Cover
  -> ConstStore -> C_State
nd_C__case_200 x2 x1 s cd cs = case x1 of
  C_State x3 x4 x5 x6 x7 x8 x9 x10 -> C_State x3 x4 x5 x6 x7
    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
    x2 (Curry_Prelude.C_Int (1)) cd cs) x9 x10
  Choice_C_State d i l r -> narrow d i (nd_C__case_200 x2 l s cd cs)
    (nd_C__case_200 x2 r s cd cs)
  Choices_C_State d i xs -> narrows cs d i (\z -> nd_C__case_200 x2 z s cd cs)
    xs
  Guard_C_State d c e -> guardCons d c (nd_C__case_200 x2 e s cd $! addCs c cs)
  Fail_C_State d info -> failCons d (traceFail "TransFunctions._case_200" [show
    x2, show x1] info)
  _ -> failCons cd (consFail "TransFunctions._case_200" (showCons x1))

d_C__case_201 :: forall t0 t2 t1 . (Curry_Prelude.Curry t1, Curry_Prelude.Curry
  t2, Curry_Prelude.Curry t0) => (t0 -> Cover -> ConstStore -> C_IOES t1 t2)
  -> Curry_Prelude.OP_Tuple2 t0 t1 -> Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.C_Either (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_Tuple2 t2 t1))
d_C__case_201 x1 x4 cd cs = case x4 of
  Curry_Prelude.OP_Tuple2 x5 x6 -> Curry_Prelude.d_C_apply (d_C_runIOES
    (Curry_Prelude.d_C_apply x1 x5 cd cs) cd cs) x6 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C__case_201 x1 l cd
    cs) (d_C__case_201 x1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C__case_201
    x1 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C__case_201 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions._case_201" [show x1, show x4] info)
  _ -> failCons cd (consFail "TransFunctions._case_201" (showCons x4))

nd_C__case_201 :: forall t0 t2 t1 . (Curry_Prelude.Curry t1, Curry_Prelude.Curry
  t2, Curry_Prelude.Curry t0) => Func t0 (C_IOES t1 t2)
  -> Curry_Prelude.OP_Tuple2 t0 t1 -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.C_IO (Curry_Prelude.C_Either (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_Tuple2 t2 t1))
nd_C__case_201 x1 x4 s cd cs = case x4 of
  Curry_Prelude.OP_Tuple2 x5 x6 -> let s4 = s
    in s4 `seq` (let s3 = leftSupply s4
                     s2 = rightSupply s4
    in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (let s1 = leftSupply s2
                                                        s0 = rightSupply s2
    in s1 `seq` (s0 `seq` nd_C_runIOES (Curry_Prelude.nd_C_apply x1 x5 s0 cd cs)
    s1 cd cs)) x6 s3 cd cs))
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (nd_C__case_201 x1 l s cd
    cs) (nd_C__case_201 x1 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> nd_C__case_201
    x1 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (nd_C__case_201 x1 e s
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransFunctions._case_201" [show x1, show x4] info)
  _ -> failCons cd (consFail "TransFunctions._case_201" (showCons x4))

