{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE Rank2Types #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module Curry_TransTypes ( d_C_transTypes, nd_C_transTypes ) where

import Basics
import qualified Curry_AbstractHaskell
import qualified Curry_AbstractHaskellGoodies
import qualified Curry_Analysis
import qualified Curry_Classification
import qualified Curry_FiniteMap
import qualified FlatCurry.Curry_Goodies
import qualified FlatCurry.Curry_Types
import qualified Curry_List
import qualified Curry_Names
import qualified Curry_Prelude


d_C_transTypes :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_ConsHOClass -> Cover
  -> ConstStore -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_TypeDecl
  -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_TypeDecl
d_C_transTypes x1 cd cs = Curry_Prelude.d_C_concatMap (d_C_genTypeDeclarations
  x1) cd cs

nd_C_transTypes :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_ConsHOClass -> IDSupply -> Cover
  -> ConstStore -> Func (Curry_Prelude.OP_List FlatCurry.Curry_Types.C_TypeDecl)
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_TypeDecl)
nd_C_transTypes x1 s cd cs = let s0 = s
  in s0 `seq` Curry_Prelude.nd_C_concatMap (wrapNX id (nd_C_genTypeDeclarations
  x1)) s0 cd cs

d_C_genTypeDeclarations :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_ConsHOClass
  -> FlatCurry.Curry_Types.C_TypeDecl -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_TypeDecl
d_C_genTypeDeclarations x1 x2 cd cs = let x3 = x2 in d_C__case_710 x1 x3 cd cs

nd_C_genTypeDeclarations :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_ConsHOClass
  -> FlatCurry.Curry_Types.C_TypeDecl -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_TypeDecl
nd_C_genTypeDeclarations x1 x2 s cd cs = let s0 = s
  in s0 `seq` (let x3 = x2 in nd_C__case_710 x1 x3 s0 cd cs)

d_C_fcy2absVis :: FlatCurry.Curry_Types.C_Visibility -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Visibility
d_C_fcy2absVis x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_Public -> Curry_AbstractHaskell.C_Public
  FlatCurry.Curry_Types.C_Private -> Curry_AbstractHaskell.C_Private
  FlatCurry.Curry_Types.Choice_C_Visibility d i l r -> narrow d i
    (d_C_fcy2absVis l cd cs) (d_C_fcy2absVis r cd cs)
  FlatCurry.Curry_Types.Choices_C_Visibility d i xs -> narrows cs d i (\z ->
    d_C_fcy2absVis z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_Visibility d c e -> guardCons d c
    (d_C_fcy2absVis e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_Visibility d info -> failCons d (traceFail
    "TransTypes.fcy2absVis" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.fcy2absVis" (showCons x1))

d_C_fcy2absTVar :: Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_fcy2absTVar x1 cd cs = Curry_Prelude.OP_Tuple2 x1 (Curry_Prelude.OP_Cons
  (Curry_Prelude.C_Char 't'#) (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Int
  cd cs) x1 cd cs))

d_C_fcy2absCDecl :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass -> FlatCurry.Curry_Types.C_ConsDecl
  -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_ConsDecl
d_C_fcy2absCDecl x1 x2 x3 cd cs = case x3 of
  FlatCurry.Curry_Types.C_Cons x4 x5 x6 x7 -> let x8 = Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Maybe
                                                    (Curry_Classification.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Classification_dot_ConsHOClass
                                                    cd cs)
                                                    (Curry_FiniteMap.d_C_lookupFM
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                                    cd cs) cd cs)
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                                    cd cs) cd cs) cd cs) x2 x4
                                                    cd cs) (Curry_Prelude.C_Just
                                                    Curry_Classification.C_ConsHO)
                                                    cd cs
                                                  x9 = d_C_fcy2absVis x6 cd cs
                                                  x10 = Curry_AbstractHaskell.C_Cons
                                                    (Curry_Prelude.d_C_apply
                                                    (Curry_Names.d_C_mkFoConsName
                                                    cd cs) x4 cd cs) x5 x9
                                                    (Curry_Prelude.d_C_map
                                                    (d_C_fcy2absTExp x1) x7 cd
                                                    cs)
                                                  x11 = Curry_AbstractHaskell.C_Cons
                                                    (Curry_Prelude.d_C_apply
                                                    (Curry_Names.d_C_mkHoConsName
                                                    cd cs) x4 cd cs) x5 x9
                                                    (Curry_Prelude.d_C_map
                                                    (d_C_fcy2absHOTExp x1) x7 cd
                                                    cs)
    in d_C__case_706 x10 x11 x8 cd cs
  FlatCurry.Curry_Types.Choice_C_ConsDecl d i l r -> narrow d i
    (d_C_fcy2absCDecl x1 x2 l cd cs) (d_C_fcy2absCDecl x1 x2 r cd cs)
  FlatCurry.Curry_Types.Choices_C_ConsDecl d i xs -> narrows cs d i (\z ->
    d_C_fcy2absCDecl x1 x2 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_ConsDecl d c e -> guardCons d c
    (d_C_fcy2absCDecl x1 x2 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_ConsDecl d info -> failCons d (traceFail
    "TransTypes.fcy2absCDecl" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes.fcy2absCDecl" (showCons x3))

nd_C_fcy2absCDecl :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass -> FlatCurry.Curry_Types.C_ConsDecl
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_ConsDecl
nd_C_fcy2absCDecl x1 x2 x3 s cd cs = case x3 of
  FlatCurry.Curry_Types.C_Cons x4 x5 x6 x7 -> let s21 = s
    in s21 `seq` (let s13 = leftSupply s21
                      s22 = rightSupply s21
                      s17 = leftSupply s22
                      s20 = rightSupply s22
    in s13 `seq` (s22 `seq` (s17 `seq` (s20 `seq` (let x8 = let s12 = leftSupply
                                                                  s13
                                                                s14 = rightSupply
                                                                  s13
                                                                s0 = leftSupply
                                                                  s14
                                                                s11 = rightSupply
                                                                  s14
                                                         in s12 `seq` (s14 `seq`
                                                         (s0 `seq` (s11 `seq`
                                                         Curry_Prelude.nd_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Maybe
                                                         (Curry_Classification.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Classification_dot_ConsHOClass
                                                         s0 cd cs)
                                                         (let s10 = leftSupply
                                                                s11
                                                              s8 = rightSupply
                                                                s11
                                                         in s10 `seq` (s8 `seq`
                                                         Curry_FiniteMap.nd_C_lookupFM
                                                         (let s7 = leftSupply s8
                                                              s9 = rightSupply
                                                                s8
                                                              s3 = leftSupply s9
                                                              s6 = rightSupply
                                                                s9
                                                         in s7 `seq` (s9 `seq`
                                                         (s3 `seq` (s6 `seq`
                                                         Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                                                         (let s2 = leftSupply s3
                                                              s1 = rightSupply
                                                                s3
                                                         in s2 `seq` (s1 `seq`
                                                         Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                                         (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                                         s1 cd cs) s2 cd cs))
                                                         (let s5 = leftSupply s6
                                                              s4 = rightSupply
                                                                s6
                                                         in s5 `seq` (s4 `seq`
                                                         Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                                         (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                                         s4 cd cs) s5 cd cs)) s7
                                                         cd cs)))) x2 x4 s10 cd
                                                         cs))
                                                         (Curry_Prelude.C_Just
                                                         Curry_Classification.C_ConsHO)
                                                         s12 cd cs)))
                                                       x9 = d_C_fcy2absVis x6 cd
                                                         cs
                                                       x10 = let s15 = leftSupply
                                                                   s17
                                                                 s16 = rightSupply
                                                                   s17
                                                         in s15 `seq` (s16 `seq`
                                                         Curry_AbstractHaskell.C_Cons
                                                         (Curry_Prelude.nd_C_apply
                                                         (wrapDX id
                                                         (Curry_Names.d_C_mkFoConsName
                                                         cd cs)) x4 s15 cd cs)
                                                         x5 x9
                                                         (Curry_Prelude.nd_C_map
                                                         (wrapDX id
                                                         (d_C_fcy2absTExp x1))
                                                         x7 s16 cd cs))
                                                       x11 = let s18 = leftSupply
                                                                   s20
                                                                 s19 = rightSupply
                                                                   s20
                                                         in s18 `seq` (s19 `seq`
                                                         Curry_AbstractHaskell.C_Cons
                                                         (Curry_Prelude.nd_C_apply
                                                         (wrapDX id
                                                         (Curry_Names.d_C_mkHoConsName
                                                         cd cs)) x4 s18 cd cs)
                                                         x5 x9
                                                         (Curry_Prelude.nd_C_map
                                                         (wrapDX id
                                                         (d_C_fcy2absHOTExp x1))
                                                         x7 s19 cd cs))
    in d_C__case_706 x10 x11 x8 cd cs)))))
  FlatCurry.Curry_Types.Choice_C_ConsDecl d i l r -> narrow d i
    (nd_C_fcy2absCDecl x1 x2 l s cd cs) (nd_C_fcy2absCDecl x1 x2 r s cd cs)
  FlatCurry.Curry_Types.Choices_C_ConsDecl d i xs -> narrows cs d i (\z ->
    nd_C_fcy2absCDecl x1 x2 z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_ConsDecl d c e -> guardCons d c
    (nd_C_fcy2absCDecl x1 x2 e s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_ConsDecl d info -> failCons d (traceFail
    "TransTypes.fcy2absCDecl" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes.fcy2absCDecl" (showCons x3))

d_C_fcy2absTExp :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> FlatCurry.Curry_Types.C_TypeExpr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeExpr
d_C_fcy2absTExp x1 x2 cd cs = case x2 of
  FlatCurry.Curry_Types.C_TVar x3 -> Curry_AbstractHaskell.C_TVar
    (d_C_fcy2absTVar x3 cd cs)
  FlatCurry.Curry_Types.C_TCons x4 x5 -> Curry_AbstractHaskell.C_TCons x4
    (Curry_Prelude.d_C_map (d_C_fcy2absTExp x1) x5 cd cs)
  FlatCurry.Curry_Types.C_FuncType x6 x7 -> Curry_Prelude.d_OP_dollar (acceptCs
    id (Curry_AbstractHaskell.C_FuncType (d_C_fcy2absTExp x1 x6 cd cs)))
    (Curry_Prelude.d_OP_dollar (acceptCs id (Curry_AbstractHaskell.C_FuncType
    (d_C_coverType cd cs))) (Curry_AbstractHaskell.C_FuncType (d_C_consStoreType
    cd cs) (d_C_fcy2absTExp x1 x7 cd cs)) cd cs) cd cs
  FlatCurry.Curry_Types.C_ForallType x8 x9 -> let x10 = d_C_fcy2absTExp x1 x9 cd
                                                    cs
    in Curry_AbstractHaskell.C_ForallType (Curry_Prelude.d_C_map d_C_fcy2absTVar
    x8 cd cs) (Curry_Prelude.d_C_apply (d_C_genContext x1 cd cs) x10 cd cs) x10
  FlatCurry.Curry_Types.Choice_C_TypeExpr d i l r -> narrow d i (d_C_fcy2absTExp
    x1 l cd cs) (d_C_fcy2absTExp x1 r cd cs)
  FlatCurry.Curry_Types.Choices_C_TypeExpr d i xs -> narrows cs d i (\z ->
    d_C_fcy2absTExp x1 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_TypeExpr d c e -> guardCons d c (d_C_fcy2absTExp
    x1 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_TypeExpr d info -> failCons d (traceFail
    "TransTypes.fcy2absTExp" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransTypes.fcy2absTExp" (showCons x2))

d_C_fcy2absHOTExp :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> FlatCurry.Curry_Types.C_TypeExpr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeExpr
d_C_fcy2absHOTExp x1 x2 cd cs = case x2 of
  FlatCurry.Curry_Types.C_TVar x3 -> Curry_AbstractHaskell.C_TVar
    (d_C_fcy2absTVar x3 cd cs)
  FlatCurry.Curry_Types.C_TCons x4 x5 -> Curry_AbstractHaskell.C_TCons x4
    (Curry_Prelude.d_C_map (d_C_fcy2absHOTExp x1) x5 cd cs)
  FlatCurry.Curry_Types.C_FuncType x6 x7 -> d_OP_fcy2absHOTExp_dot_funcType_dot_49
    (d_C_fcy2absHOTExp x1 x6 cd cs) (d_C_fcy2absHOTExp x1 x7 cd cs) cd cs
  FlatCurry.Curry_Types.C_ForallType x8 x9 -> let x10 = d_C_fcy2absHOTExp x1 x9
                                                    cd cs
    in Curry_AbstractHaskell.C_ForallType (Curry_Prelude.d_C_map d_C_fcy2absTVar
    x8 cd cs) (Curry_Prelude.d_C_apply (d_C_genContext x1 cd cs) x10 cd cs) x10
  FlatCurry.Curry_Types.Choice_C_TypeExpr d i l r -> narrow d i
    (d_C_fcy2absHOTExp x1 l cd cs) (d_C_fcy2absHOTExp x1 r cd cs)
  FlatCurry.Curry_Types.Choices_C_TypeExpr d i xs -> narrows cs d i (\z ->
    d_C_fcy2absHOTExp x1 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_TypeExpr d c e -> guardCons d c
    (d_C_fcy2absHOTExp x1 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_TypeExpr d info -> failCons d (traceFail
    "TransTypes.fcy2absHOTExp" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransTypes.fcy2absHOTExp" (showCons x2))

d_OP_fcy2absHOTExp_dot_funcType_dot_49 :: Curry_AbstractHaskell.C_TypeExpr
  -> Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeExpr
d_OP_fcy2absHOTExp_dot_funcType_dot_49 x1 x2 cd cs =
  Curry_AbstractHaskell.C_TCons (d_C_basics (Curry_Prelude.toCurryString "Func")
  cd cs) (Curry_Prelude.OP_Cons x1 (Curry_Prelude.OP_Cons x2
  Curry_Prelude.OP_List))

d_C_genContext :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_Context
d_C_genContext x1 cd cs = Curry_Prelude.d_OP_dot (Curry_Prelude.d_C_map
  d_C_mkContext) (d_C_gatherContextTypeExprs x1) cd cs

d_C_mkContext :: Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Context
d_C_mkContext x1 cd cs = Curry_AbstractHaskell.C_Context
  (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_curryPrelude cd cs)
  (Curry_Prelude.toCurryString "Curry")) (Curry_Prelude.OP_Cons x1
  Curry_Prelude.OP_List)

d_C_gatherContextTypeExprs :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_TypeExpr
d_C_gatherContextTypeExprs x1 x2 cd cs = Curry_Prelude.d_OP_dollar
  (Curry_List.d_C_nub
  (Curry_AbstractHaskell.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_AbstractHaskell_dot_TypeExpr
  cd cs)) (d_OP_gatherContextTypeExprs_dot_gatherContextTypeExprs_tick_dot_61 x2
  x1 Curry_Prelude.OP_List x2 cd cs) cd cs

d_OP_gatherContextTypeExprs_dot_gatherContextTypeExprs_tick_dot_61 :: Curry_AbstractHaskell.C_TypeExpr
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_TypeExpr -> Curry_AbstractHaskell.C_TypeExpr -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_TypeExpr
d_OP_gatherContextTypeExprs_dot_gatherContextTypeExprs_tick_dot_61 x1 x2 x3 x4 cd cs =
  case x4 of
  Curry_AbstractHaskell.C_TVar x5 -> d_C__case_704 x2 x5 x1 x3 x4
    (Curry_Prelude.d_OP_bar_bar (d_C_isHigherKinded x5 x1 cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_elem
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Int cd
    cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) cd cs) x5 cd cs) x2 cd cs) cd cs) cd cs
  Curry_AbstractHaskell.C_FuncType x6 x7 -> d_OP_gatherContextTypeExprs_dot_gatherContextTypeExprs_tick_dot_61
    x1 x2 (d_OP_gatherContextTypeExprs_dot_gatherContextTypeExprs_tick_dot_61 x1
    x2 x3 x6 cd cs) x7 cd cs
  Curry_AbstractHaskell.C_TCons x8 x9 -> d_C__case_702 x4 x2 x9 x8 x3 x1
    (Curry_Prelude.d_OP_amp_amp
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) x8 (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_curryPrelude cd cs)
    (Curry_Prelude.toCurryString "C_Apply")) cd cs) (Curry_Prelude.d_OP_amp_amp
    (d_C_isTypeVar (Curry_Prelude.d_C_head x9 cd cs) cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_any (Curry_Prelude.d_C_flip
    (Curry_Prelude.d_C_notElem
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Int cd
    cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) cd cs)) x2) cd cs) (Curry_AbstractHaskellGoodies.d_C_tyVarsOf x4
    cd cs) cd cs) cd cs) cd cs) cd cs
  Curry_AbstractHaskell.C_ForallType x10 x11 x12 -> Curry_Prelude.d_OP_plus_plus
    x3 (Curry_Prelude.d_OP_dollar (Curry_Prelude.d_C_filter
    (Curry_Prelude.d_OP_dot (Curry_Prelude.d_C_all (Curry_Prelude.d_C_flip
    (Curry_Prelude.d_C_notElem
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Int cd
    cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) cd cs)) x10) cd cs) Curry_AbstractHaskellGoodies.d_C_tyVarsOf cd
    cs)) (d_C_gatherContextTypeExprs (Curry_Prelude.d_OP_plus_plus x2
    (Curry_AbstractHaskellGoodies.d_C_tyVarsOf x1 cd cs) cd cs) x12 cd cs) cd
    cs) cd cs
  Curry_AbstractHaskell.Choice_C_TypeExpr d i l r -> narrow d i
    (d_OP_gatherContextTypeExprs_dot_gatherContextTypeExprs_tick_dot_61 x1 x2 x3
    l cd cs) (d_OP_gatherContextTypeExprs_dot_gatherContextTypeExprs_tick_dot_61
    x1 x2 x3 r cd cs)
  Curry_AbstractHaskell.Choices_C_TypeExpr d i xs -> narrows cs d i (\z ->
    d_OP_gatherContextTypeExprs_dot_gatherContextTypeExprs_tick_dot_61 x1 x2 x3
    z cd cs) xs
  Curry_AbstractHaskell.Guard_C_TypeExpr d c e -> guardCons d c
    (d_OP_gatherContextTypeExprs_dot_gatherContextTypeExprs_tick_dot_61 x1 x2 x3
    e cd $! addCs c cs)
  Curry_AbstractHaskell.Fail_C_TypeExpr d info -> failCons d (traceFail
    "TransTypes.gatherContextTypeExprs.gatherContextTypeExprs'.61" [show x1
    , show x2, show x3, show x4] info)
  _ -> failCons cd (consFail
    "TransTypes.gatherContextTypeExprs.gatherContextTypeExprs'.61" (showCons
    x4))

d_C_isTypeVar :: Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isTypeVar x1 cd cs = case x1 of
  Curry_AbstractHaskell.C_TVar x2 -> Curry_Prelude.C_True
  Curry_AbstractHaskell.C_FuncType x3 x4 -> Curry_Prelude.C_False
  Curry_AbstractHaskell.C_TCons x5 x6 -> Curry_Prelude.C_False
  Curry_AbstractHaskell.C_ForallType x7 x8 x9 -> Curry_Prelude.C_False
  Curry_AbstractHaskell.Choice_C_TypeExpr d i l r -> narrow d i (d_C_isTypeVar l
    cd cs) (d_C_isTypeVar r cd cs)
  Curry_AbstractHaskell.Choices_C_TypeExpr d i xs -> narrows cs d i (\z ->
    d_C_isTypeVar z cd cs) xs
  Curry_AbstractHaskell.Guard_C_TypeExpr d c e -> guardCons d c (d_C_isTypeVar e
    cd $! addCs c cs)
  Curry_AbstractHaskell.Fail_C_TypeExpr d info -> failCons d (traceFail
    "TransTypes.isTypeVar" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.isTypeVar" (showCons x1))

d_C_isHigherKinded :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isHigherKinded x1 x2 cd cs = case x2 of
  Curry_AbstractHaskell.C_TVar x3 -> Curry_Prelude.C_False
  Curry_AbstractHaskell.C_FuncType x4 x5 -> Curry_Prelude.d_OP_bar_bar
    (d_C_isHigherKinded x1 x4 cd cs) (d_C_isHigherKinded x1 x5 cd cs) cd cs
  Curry_AbstractHaskell.C_ForallType x6 x7 x8 -> Curry_Prelude.d_OP_amp_amp
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_notElem
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Int cd
    cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) cd cs) x1 cd cs) x6 cd cs) (d_C_isHigherKinded x1 x8 cd cs) cd cs
  Curry_AbstractHaskell.C_TCons x9 x10 -> d_C__case_700 x9 x10 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) x9 (Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_curryPrelude cd cs)
    (Curry_Prelude.toCurryString "C_Apply")) cd cs) cd cs
  Curry_AbstractHaskell.Choice_C_TypeExpr d i l r -> narrow d i
    (d_C_isHigherKinded x1 l cd cs) (d_C_isHigherKinded x1 r cd cs)
  Curry_AbstractHaskell.Choices_C_TypeExpr d i xs -> narrows cs d i (\z ->
    d_C_isHigherKinded x1 z cd cs) xs
  Curry_AbstractHaskell.Guard_C_TypeExpr d c e -> guardCons d c
    (d_C_isHigherKinded x1 e cd $! addCs c cs)
  Curry_AbstractHaskell.Fail_C_TypeExpr d info -> failCons d (traceFail
    "TransTypes.isHigherKinded" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransTypes.isHigherKinded" (showCons x2))

d_C_showInstance :: Curry_Prelude.C_Bool -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass -> FlatCurry.Curry_Types.C_TypeDecl
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeDecl
d_C_showInstance x1 x2 x3 cd cs = case x3 of
  FlatCurry.Curry_Types.C_Type x4 x5 x6 x7 -> let x8 = Curry_Prelude.d_C_apply
                                                    (d_C_newVars cd cs)
                                                    (Curry_Prelude.OP_Cons
                                                    (Curry_Prelude.toCurryString
                                                    "cd") (Curry_Prelude.OP_Cons
                                                    (Curry_Prelude.toCurryString
                                                    "d") (Curry_Prelude.OP_Cons
                                                    (Curry_Prelude.toCurryString
                                                    "i") (Curry_Prelude.OP_Cons
                                                    (Curry_Prelude.toCurryString
                                                    "x") (Curry_Prelude.OP_Cons
                                                    (Curry_Prelude.toCurryString
                                                    "y") (Curry_Prelude.OP_Cons
                                                    (Curry_Prelude.toCurryString
                                                    "xs") (Curry_Prelude.OP_Cons
                                                    (Curry_Prelude.toCurryString
                                                    "c") (Curry_Prelude.OP_Cons
                                                    (Curry_Prelude.toCurryString
                                                    "e") (Curry_Prelude.OP_Cons
                                                    (Curry_Prelude.toCurryString
                                                    "_")
                                                    Curry_Prelude.OP_List)))))))))
                                                    cd cs
                                                  x9 = d_OP_showInstance_dot_uscore_hash_selFP2_hash_cd
                                                    x8 cd cs
                                                  x10 = d_OP_showInstance_dot_uscore_hash_selFP3_hash_d
                                                    x8 cd cs
                                                  x11 = d_OP_showInstance_dot_uscore_hash_selFP4_hash_i
                                                    x8 cd cs
                                                  x12 = d_OP_showInstance_dot_uscore_hash_selFP5_hash_x
                                                    x8 cd cs
                                                  x13 = d_OP_showInstance_dot_uscore_hash_selFP6_hash_y
                                                    x8 cd cs
                                                  x14 = d_OP_showInstance_dot_uscore_hash_selFP7_hash_xs
                                                    x8 cd cs
                                                  x15 = d_OP_showInstance_dot_uscore_hash_selFP8_hash_c
                                                    x8 cd cs
                                                  x16 = d_OP_showInstance_dot_uscore_hash_selFP9_hash_e
                                                    x8 cd cs
                                                  x17 = d_OP_showInstance_dot_uscore_hash_selFP10_hash_us
                                                    x8 cd cs
                                                  x18 = Curry_Prelude.d_C_map
                                                    d_C_fcy2absTVar x6 cd cs
                                                  x19 = Curry_AbstractHaskell.C_TCons
                                                    x4 (Curry_Prelude.d_C_map
                                                    (acceptCs id
                                                    Curry_AbstractHaskell.C_TVar)
                                                    x18 cd cs)
    in d_C__case_698 x1 x19 x4 x7 x2 x17 x16 x15 x9 x10 x14 x11 x13 x12 x18
    (Curry_Prelude.d_C_not x1 cd cs) cd cs
  FlatCurry.Curry_Types.C_TypeSyn x20 x21 x22 x23 -> Curry_Prelude.d_C_error
    (Curry_Prelude.toCurryString "TransTypes.showInstance") cd cs
  FlatCurry.Curry_Types.Choice_C_TypeDecl d i l r -> narrow d i
    (d_C_showInstance x1 x2 l cd cs) (d_C_showInstance x1 x2 r cd cs)
  FlatCurry.Curry_Types.Choices_C_TypeDecl d i xs -> narrows cs d i (\z ->
    d_C_showInstance x1 x2 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_TypeDecl d c e -> guardCons d c
    (d_C_showInstance x1 x2 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_TypeDecl d info -> failCons d (traceFail
    "TransTypes.showInstance" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes.showInstance" (showCons x3))

nd_C_showInstance :: Curry_Prelude.C_Bool -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass -> FlatCurry.Curry_Types.C_TypeDecl
  -> IDSupply -> Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeDecl
nd_C_showInstance x1 x2 x3 s cd cs = case x3 of
  FlatCurry.Curry_Types.C_Type x4 x5 x6 x7 -> let s4 = s
    in s4 `seq` (let s5 = leftSupply s4
                     s6 = rightSupply s4
                     s0 = leftSupply s5
                     s1 = rightSupply s5
                     s2 = leftSupply s6
                     s3 = rightSupply s6
    in s5 `seq` (s6 `seq` (s0 `seq` (s1 `seq` (s2 `seq` (s3 `seq`
    (let x8 = Curry_Prelude.nd_C_apply (wrapDX id (d_C_newVars cd cs))
           (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "cd")
           (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "d")
           (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "i")
           (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "x")
           (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "y")
           (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "xs")
           (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "c")
           (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "e")
           (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "_")
           Curry_Prelude.OP_List))))))))) s0 cd cs
         x9 = d_OP_showInstance_dot_uscore_hash_selFP2_hash_cd x8 cd cs
         x10 = d_OP_showInstance_dot_uscore_hash_selFP3_hash_d x8 cd cs
         x11 = d_OP_showInstance_dot_uscore_hash_selFP4_hash_i x8 cd cs
         x12 = d_OP_showInstance_dot_uscore_hash_selFP5_hash_x x8 cd cs
         x13 = d_OP_showInstance_dot_uscore_hash_selFP6_hash_y x8 cd cs
         x14 = d_OP_showInstance_dot_uscore_hash_selFP7_hash_xs x8 cd cs
         x15 = d_OP_showInstance_dot_uscore_hash_selFP8_hash_c x8 cd cs
         x16 = d_OP_showInstance_dot_uscore_hash_selFP9_hash_e x8 cd cs
         x17 = d_OP_showInstance_dot_uscore_hash_selFP10_hash_us x8 cd cs
         x18 = Curry_Prelude.nd_C_map (wrapDX id d_C_fcy2absTVar) x6 s1 cd cs
         x19 = Curry_AbstractHaskell.C_TCons x4 (Curry_Prelude.nd_C_map (wrapDX
           id (acceptCs id Curry_AbstractHaskell.C_TVar)) x18 s2 cd cs)
    in nd_C__case_698 x1 x19 x4 x7 x2 x17 x16 x15 x9 x10 x14 x11 x13 x12 x18
    (Curry_Prelude.d_C_not x1 cd cs) s3 cd cs)))))))
  FlatCurry.Curry_Types.C_TypeSyn x20 x21 x22 x23 -> Curry_Prelude.d_C_error
    (Curry_Prelude.toCurryString "TransTypes.showInstance") cd cs
  FlatCurry.Curry_Types.Choice_C_TypeDecl d i l r -> narrow d i
    (nd_C_showInstance x1 x2 l s cd cs) (nd_C_showInstance x1 x2 r s cd cs)
  FlatCurry.Curry_Types.Choices_C_TypeDecl d i xs -> narrows cs d i (\z ->
    nd_C_showInstance x1 x2 z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_TypeDecl d c e -> guardCons d c
    (nd_C_showInstance x1 x2 e s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_TypeDecl d info -> failCons d (traceFail
    "TransTypes.showInstance" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes.showInstance" (showCons x3))

d_OP_showInstance_dot_uscore_hash_selFP2_hash_cd :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_showInstance_dot_uscore_hash_selFP2_hash_cd x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_695 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_showInstance_dot_uscore_hash_selFP2_hash_cd l cd cs)
    (d_OP_showInstance_dot_uscore_hash_selFP2_hash_cd r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_showInstance_dot_uscore_hash_selFP2_hash_cd z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_showInstance_dot_uscore_hash_selFP2_hash_cd e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.showInstance._#selFP2#cd" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.showInstance._#selFP2#cd" (showCons
    x1))

d_OP_showInstance_dot_uscore_hash_selFP3_hash_d :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_showInstance_dot_uscore_hash_selFP3_hash_d x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_686 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_showInstance_dot_uscore_hash_selFP3_hash_d l cd cs)
    (d_OP_showInstance_dot_uscore_hash_selFP3_hash_d r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_showInstance_dot_uscore_hash_selFP3_hash_d z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_showInstance_dot_uscore_hash_selFP3_hash_d e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.showInstance._#selFP3#d" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.showInstance._#selFP3#d" (showCons x1))

d_OP_showInstance_dot_uscore_hash_selFP4_hash_i :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_showInstance_dot_uscore_hash_selFP4_hash_i x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_677 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_showInstance_dot_uscore_hash_selFP4_hash_i l cd cs)
    (d_OP_showInstance_dot_uscore_hash_selFP4_hash_i r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_showInstance_dot_uscore_hash_selFP4_hash_i z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_showInstance_dot_uscore_hash_selFP4_hash_i e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.showInstance._#selFP4#i" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.showInstance._#selFP4#i" (showCons x1))

d_OP_showInstance_dot_uscore_hash_selFP5_hash_x :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_showInstance_dot_uscore_hash_selFP5_hash_x x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_668 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_showInstance_dot_uscore_hash_selFP5_hash_x l cd cs)
    (d_OP_showInstance_dot_uscore_hash_selFP5_hash_x r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_showInstance_dot_uscore_hash_selFP5_hash_x z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_showInstance_dot_uscore_hash_selFP5_hash_x e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.showInstance._#selFP5#x" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.showInstance._#selFP5#x" (showCons x1))

d_OP_showInstance_dot_uscore_hash_selFP6_hash_y :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_showInstance_dot_uscore_hash_selFP6_hash_y x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_659 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_showInstance_dot_uscore_hash_selFP6_hash_y l cd cs)
    (d_OP_showInstance_dot_uscore_hash_selFP6_hash_y r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_showInstance_dot_uscore_hash_selFP6_hash_y z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_showInstance_dot_uscore_hash_selFP6_hash_y e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.showInstance._#selFP6#y" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.showInstance._#selFP6#y" (showCons x1))

d_OP_showInstance_dot_uscore_hash_selFP7_hash_xs :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_showInstance_dot_uscore_hash_selFP7_hash_xs x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_650 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_showInstance_dot_uscore_hash_selFP7_hash_xs l cd cs)
    (d_OP_showInstance_dot_uscore_hash_selFP7_hash_xs r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_showInstance_dot_uscore_hash_selFP7_hash_xs z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_showInstance_dot_uscore_hash_selFP7_hash_xs e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.showInstance._#selFP7#xs" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.showInstance._#selFP7#xs" (showCons
    x1))

d_OP_showInstance_dot_uscore_hash_selFP8_hash_c :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_showInstance_dot_uscore_hash_selFP8_hash_c x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_641 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_showInstance_dot_uscore_hash_selFP8_hash_c l cd cs)
    (d_OP_showInstance_dot_uscore_hash_selFP8_hash_c r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_showInstance_dot_uscore_hash_selFP8_hash_c z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_showInstance_dot_uscore_hash_selFP8_hash_c e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.showInstance._#selFP8#c" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.showInstance._#selFP8#c" (showCons x1))

d_OP_showInstance_dot_uscore_hash_selFP9_hash_e :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_showInstance_dot_uscore_hash_selFP9_hash_e x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_632 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_showInstance_dot_uscore_hash_selFP9_hash_e l cd cs)
    (d_OP_showInstance_dot_uscore_hash_selFP9_hash_e r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_showInstance_dot_uscore_hash_selFP9_hash_e z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_showInstance_dot_uscore_hash_selFP9_hash_e e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.showInstance._#selFP9#e" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.showInstance._#selFP9#e" (showCons x1))

d_OP_showInstance_dot_uscore_hash_selFP10_hash_us :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_showInstance_dot_uscore_hash_selFP10_hash_us x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_623 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_showInstance_dot_uscore_hash_selFP10_hash_us l cd cs)
    (d_OP_showInstance_dot_uscore_hash_selFP10_hash_us r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_showInstance_dot_uscore_hash_selFP10_hash_us z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_showInstance_dot_uscore_hash_selFP10_hash_us e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.showInstance._#selFP10#us" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.showInstance._#selFP10#us" (showCons
    x1))

d_C_showRule4List :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule
d_C_showRule4List cd cs = Curry_Prelude.OP_Tuple2
  (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString
  "showsPrec") cd cs) (Curry_AbstractHaskell.C_Rule Curry_Prelude.OP_List
  (Curry_AbstractHaskell.C_SimpleRhs (Curry_AbstractHaskellGoodies.d_C_constF
  (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString
  "showsPrec4CurryList") cd cs) cd cs)) Curry_Prelude.OP_List)

d_C_showConsRule :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_ConsHOClass
  -> FlatCurry.Curry_Types.C_ConsDecl -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
d_C_showConsRule x1 x2 cd cs = case x2 of
  FlatCurry.Curry_Types.C_Cons x3 x4 x5 x6 -> let x7 = Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Maybe
                                                    (Curry_Classification.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Classification_dot_ConsHOClass
                                                    cd cs)
                                                    (Curry_FiniteMap.d_C_lookupFM
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                                    cd cs) cd cs)
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                                    cd cs) cd cs) cd cs) x1 x3
                                                    cd cs) (Curry_Prelude.C_Just
                                                    Curry_Classification.C_ConsHO)
                                                    cd cs
    in d_C__case_614 x3 x4 x7 cd cs
  FlatCurry.Curry_Types.Choice_C_ConsDecl d i l r -> narrow d i
    (d_C_showConsRule x1 l cd cs) (d_C_showConsRule x1 r cd cs)
  FlatCurry.Curry_Types.Choices_C_ConsDecl d i xs -> narrows cs d i (\z ->
    d_C_showConsRule x1 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_ConsDecl d c e -> guardCons d c
    (d_C_showConsRule x1 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_ConsDecl d info -> failCons d (traceFail
    "TransTypes.showConsRule" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransTypes.showConsRule" (showCons x2))

nd_C_showConsRule :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_ConsHOClass
  -> FlatCurry.Curry_Types.C_ConsDecl -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
nd_C_showConsRule x1 x2 s cd cs = case x2 of
  FlatCurry.Curry_Types.C_Cons x3 x4 x5 x6 -> let s13 = s
    in s13 `seq` (let x7 = let s12 = leftSupply s13
                               s14 = rightSupply s13
                               s0 = leftSupply s14
                               s11 = rightSupply s14
                        in s12 `seq` (s14 `seq` (s0 `seq` (s11 `seq`
                        Curry_Prelude.nd_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Maybe
                        (Curry_Classification.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Classification_dot_ConsHOClass
                        s0 cd cs) (let s10 = leftSupply s11
                                       s8 = rightSupply s11
                        in s10 `seq` (s8 `seq` Curry_FiniteMap.nd_C_lookupFM
                        (let s7 = leftSupply s8
                             s9 = rightSupply s8
                             s3 = leftSupply s9
                             s6 = rightSupply s9
                        in s7 `seq` (s9 `seq` (s3 `seq` (s6 `seq`
                        Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                        (let s2 = leftSupply s3
                             s1 = rightSupply s3
                        in s2 `seq` (s1 `seq`
                        Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                        (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                        s1 cd cs) s2 cd cs)) (let s5 = leftSupply s6
                                                  s4 = rightSupply s6
                        in s5 `seq` (s4 `seq`
                        Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                        (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                        s4 cd cs) s5 cd cs)) s7 cd cs)))) x1 x3 s10 cd cs))
                        (Curry_Prelude.C_Just Curry_Classification.C_ConsHO) s12
                        cd cs)))
    in d_C__case_614 x3 x4 x7 cd cs)
  FlatCurry.Curry_Types.Choice_C_ConsDecl d i l r -> narrow d i
    (nd_C_showConsRule x1 l s cd cs) (nd_C_showConsRule x1 r s cd cs)
  FlatCurry.Curry_Types.Choices_C_ConsDecl d i xs -> narrows cs d i (\z ->
    nd_C_showConsRule x1 z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_ConsDecl d c e -> guardCons d c
    (nd_C_showConsRule x1 e s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_ConsDecl d info -> failCons d (traceFail
    "TransTypes.showConsRule" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransTypes.showConsRule" (showCons x2))

d_OP_showConsRule_dot_showListCons_dot_114 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Rule
d_OP_showConsRule_dot_showListCons_dot_114 x1 x2 cd cs =
  let x3 = Curry_Prelude.d_C_apply (d_C_newVars cd cs) (Curry_Prelude.OP_Cons
        (Curry_Prelude.toCurryString "d") (Curry_Prelude.OP_Cons
        (Curry_Prelude.toCurryString "x1") (Curry_Prelude.OP_Cons
        (Curry_Prelude.toCurryString "x2") Curry_Prelude.OP_List))) cd cs
      x4 = d_OP_showConsRule_dot_showListCons_dot_114_dot_uscore_hash_selFP12_hash_d
        x3 cd cs
      x5 = d_OP_showConsRule_dot_showListCons_dot_114_dot_uscore_hash_selFP13_hash_x1
        x3 cd cs
      x6 = d_OP_showConsRule_dot_showListCons_dot_114_dot_uscore_hash_selFP14_hash_x2
        x3 cd cs
  in Curry_Prelude.d_OP_dollar (d_C_simpleRule (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x4) (Curry_Prelude.OP_Cons (d_C_consPattern x2
  (Curry_Prelude.toCurryString "x") x1 cd cs) Curry_Prelude.OP_List)))
  (Curry_AbstractHaskellGoodies.d_C_applyF (Curry_AbstractHaskellGoodies.d_C_pre
  (Curry_Prelude.toCurryString "showParen") cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskellGoodies.d_C_applyF (Curry_AbstractHaskellGoodies.d_C_pre
  (Curry_Prelude.toCurryString ">") cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x4) (Curry_Prelude.OP_Cons (d_C_intc
  (Curry_Prelude.C_Int (5)) cd cs) Curry_Prelude.OP_List)) cd cs)
  (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_foldr1 (acceptCs id
  d_OP_showConsRule_dot_showListCons_dot_114_dot_uscore_hash_lambda6)
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskellGoodies.d_C_applyF
  (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString
  "showsPrec") cd cs) (Curry_Prelude.OP_Cons (d_C_intc (Curry_Prelude.C_Int (6))
  cd cs) (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x5)
  Curry_Prelude.OP_List)) cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskellGoodies.d_C_applyF (Curry_AbstractHaskellGoodies.d_C_pre
  (Curry_Prelude.toCurryString "showChar") cd cs) (Curry_Prelude.OP_Cons
  (d_C_charc (Curry_Prelude.C_Char ':'#) cd cs) Curry_Prelude.OP_List) cd cs)
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskellGoodies.d_C_applyF
  (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString
  "showsPrec") cd cs) (Curry_Prelude.OP_Cons (d_C_intc (Curry_Prelude.C_Int (5))
  cd cs) (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x6)
  Curry_Prelude.OP_List)) cd cs) Curry_Prelude.OP_List))) cd cs)
  Curry_Prelude.OP_List)) cd cs) cd cs

d_OP_showConsRule_dot_showListCons_dot_114_dot_uscore_hash_selFP12_hash_d :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_showConsRule_dot_showListCons_dot_114_dot_uscore_hash_selFP12_hash_d x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_612 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_showConsRule_dot_showListCons_dot_114_dot_uscore_hash_selFP12_hash_d l
    cd cs)
    (d_OP_showConsRule_dot_showListCons_dot_114_dot_uscore_hash_selFP12_hash_d r
    cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_showConsRule_dot_showListCons_dot_114_dot_uscore_hash_selFP12_hash_d z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_showConsRule_dot_showListCons_dot_114_dot_uscore_hash_selFP12_hash_d e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.showConsRule.showListCons.114._#selFP12#d" [show x1] info)
  _ -> failCons cd (consFail
    "TransTypes.showConsRule.showListCons.114._#selFP12#d" (showCons x1))

d_OP_showConsRule_dot_showListCons_dot_114_dot_uscore_hash_selFP13_hash_x1 :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_showConsRule_dot_showListCons_dot_114_dot_uscore_hash_selFP13_hash_x1 x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_609 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_showConsRule_dot_showListCons_dot_114_dot_uscore_hash_selFP13_hash_x1
    l cd cs)
    (d_OP_showConsRule_dot_showListCons_dot_114_dot_uscore_hash_selFP13_hash_x1
    r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_showConsRule_dot_showListCons_dot_114_dot_uscore_hash_selFP13_hash_x1 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_showConsRule_dot_showListCons_dot_114_dot_uscore_hash_selFP13_hash_x1
    e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.showConsRule.showListCons.114._#selFP13#x1" [show x1] info)
  _ -> failCons cd (consFail
    "TransTypes.showConsRule.showListCons.114._#selFP13#x1" (showCons x1))

d_OP_showConsRule_dot_showListCons_dot_114_dot_uscore_hash_selFP14_hash_x2 :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_showConsRule_dot_showListCons_dot_114_dot_uscore_hash_selFP14_hash_x2 x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_606 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_showConsRule_dot_showListCons_dot_114_dot_uscore_hash_selFP14_hash_x2
    l cd cs)
    (d_OP_showConsRule_dot_showListCons_dot_114_dot_uscore_hash_selFP14_hash_x2
    r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_showConsRule_dot_showListCons_dot_114_dot_uscore_hash_selFP14_hash_x2 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_showConsRule_dot_showListCons_dot_114_dot_uscore_hash_selFP14_hash_x2
    e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.showConsRule.showListCons.114._#selFP14#x2" [show x1] info)
  _ -> failCons cd (consFail
    "TransTypes.showConsRule.showListCons.114._#selFP14#x2" (showCons x1))

d_OP_showConsRule_dot_showListCons_dot_114_dot_uscore_hash_lambda6 :: Curry_AbstractHaskell.C_Expr
  -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_OP_showConsRule_dot_showListCons_dot_114_dot_uscore_hash_lambda6 x1 x2 cd cs =
  Curry_AbstractHaskell.C_InfixApply x1 (Curry_AbstractHaskellGoodies.d_C_pre
  (Curry_Prelude.toCurryString ".") cd cs) x2

d_OP_showConsRule_dot_showTupleCons_dot_114 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Rule
d_OP_showConsRule_dot_showTupleCons_dot_114 x1 x2 cd cs =
  Curry_Prelude.d_OP_dollar (d_C_simpleRule (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int
  (0)) (Curry_Prelude.toCurryString "_"))) (Curry_Prelude.OP_Cons
  (d_C_consPattern x2 (Curry_Prelude.toCurryString "x") x1 cd cs)
  Curry_Prelude.OP_List))) (Curry_AbstractHaskell.C_InfixApply
  (Curry_AbstractHaskellGoodies.d_C_applyF (Curry_AbstractHaskellGoodies.d_C_pre
  (Curry_Prelude.toCurryString "showString") cd cs) (Curry_Prelude.OP_Cons
  (Curry_Prelude.d_C_apply (Curry_AbstractHaskellGoodies.d_C_string2ac cd cs)
  (Curry_Prelude.toCurryString "(") cd cs) Curry_Prelude.OP_List) cd cs)
  (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString ".") cd cs)
  (Curry_Prelude.d_C_foldr (acceptCs id
  d_OP_showConsRule_dot_showTupleCons_dot_114_dot_uscore_hash_lambda7)
  (Curry_AbstractHaskellGoodies.d_C_applyF (Curry_AbstractHaskellGoodies.d_C_pre
  (Curry_Prelude.toCurryString "showChar") cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Lit (Curry_AbstractHaskell.C_Charc
  (Curry_Prelude.C_Char ')'#))) Curry_Prelude.OP_List) cd cs)
  (Curry_List.d_C_intersperse (Curry_AbstractHaskellGoodies.d_C_applyF
  (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString ":") cd cs)
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Lit
  (Curry_AbstractHaskell.C_Charc (Curry_Prelude.C_Char ','#)))
  Curry_Prelude.OP_List) cd cs) (Curry_Prelude.d_C_map
  d_OP_showConsRule_dot_showTupleCons_dot_114_dot_uscore_hash_lambda8
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_enumFromTo_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
  cd cs) (Curry_Prelude.C_Int (1)) cd cs) x1 cd cs) cd cs) cd cs) cd cs)) cd cs

d_OP_showConsRule_dot_showTupleCons_dot_114_dot_uscore_hash_lambda7 :: Curry_AbstractHaskell.C_Expr
  -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_OP_showConsRule_dot_showTupleCons_dot_114_dot_uscore_hash_lambda7 x1 x2 cd cs =
  Curry_AbstractHaskell.C_InfixApply x1 (Curry_AbstractHaskellGoodies.d_C_pre
  (Curry_Prelude.toCurryString ".") cd cs) x2

d_OP_showConsRule_dot_showTupleCons_dot_114_dot_uscore_hash_lambda8 :: Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_OP_showConsRule_dot_showTupleCons_dot_114_dot_uscore_hash_lambda8 x1 cd cs =
  Curry_AbstractHaskellGoodies.d_C_applyF (Curry_AbstractHaskellGoodies.d_C_pre
  (Curry_Prelude.toCurryString "shows") cd cs) (Curry_Prelude.OP_Cons (d_C_mkVar
  (Curry_Prelude.toCurryString "x") x1 cd cs) Curry_Prelude.OP_List) cd cs

d_OP_showConsRule_dot_showBody_dot_114 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Rule
d_OP_showConsRule_dot_showBody_dot_114 x1 x2 x3 cd cs =
  Curry_Prelude.d_OP_dollar (d_C_simpleRule (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int
  (0)) (Curry_Prelude.toCurryString "_"))) (Curry_Prelude.OP_Cons
  (d_C_consPattern x3 (Curry_Prelude.toCurryString "x") x1 cd cs)
  Curry_Prelude.OP_List))) (d_C__case_603 x1 x2
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
  x1 (Curry_Prelude.C_Int (0)) cd cs) cd cs) cd cs

d_OP_showConsRule_dot_showBody_dot_114_dot_uscore_hash_lambda9 :: Curry_AbstractHaskell.C_Expr
  -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_OP_showConsRule_dot_showBody_dot_114_dot_uscore_hash_lambda9 x1 x2 cd cs =
  Curry_AbstractHaskell.C_InfixApply (Curry_AbstractHaskellGoodies.d_C_applyF
  (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString "showChar")
  cd cs) (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Lit
  (Curry_AbstractHaskell.C_Charc (Curry_Prelude.C_Char ' '#)))
  Curry_Prelude.OP_List) cd cs) (Curry_AbstractHaskellGoodies.d_C_pre
  (Curry_Prelude.toCurryString ".") cd cs) (Curry_AbstractHaskell.C_InfixApply
  x1 (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString ".") cd
  cs) x2)

d_OP_showConsRule_dot_showBody_dot_114_dot_uscore_hash_lambda10 :: Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_OP_showConsRule_dot_showBody_dot_114_dot_uscore_hash_lambda10 x1 cd cs =
  Curry_AbstractHaskellGoodies.d_C_applyF (Curry_AbstractHaskellGoodies.d_C_pre
  (Curry_Prelude.toCurryString "shows") cd cs) (Curry_Prelude.OP_Cons (d_C_mkVar
  (Curry_Prelude.toCurryString "x") x1 cd cs) Curry_Prelude.OP_List) cd cs

d_OP_showConsRule_dot_rule_dot_114 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule
d_OP_showConsRule_dot_rule_dot_114 x1 x2 x3 cd cs = Curry_Prelude.OP_Tuple2
  (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString
  "showsPrec") cd cs) (d_C__case_602 x3 x2 x1 (Curry_Prelude.d_C_take
  (Curry_Prelude.C_Int (8)) (Curry_Prelude.d_C_snd x3 cd cs) cd cs) cd cs)

d_C_readInstance :: Curry_Prelude.C_Bool -> FlatCurry.Curry_Types.C_TypeDecl
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeDecl
d_C_readInstance x1 x2 cd cs = case x2 of
  FlatCurry.Curry_Types.C_Type x3 x4 x5 x6 -> let x7 = Curry_Prelude.d_C_map
                                                    d_C_fcy2absTVar x5 cd cs
                                                  x8 = Curry_AbstractHaskell.C_TCons
                                                    x3 (Curry_Prelude.d_C_map
                                                    (acceptCs id
                                                    Curry_AbstractHaskell.C_TVar)
                                                    x7 cd cs)
                                                  x9 = d_C__case_575 x3 x6
                                                    (d_C_isListType x3 cd cs) cd
                                                    cs
    in d_C__case_577 x1 x8 x9 x7 (Curry_Prelude.d_C_not x1 cd cs) cd cs
  FlatCurry.Curry_Types.C_TypeSyn x10 x11 x12 x13 -> Curry_Prelude.d_C_error
    (Curry_Prelude.toCurryString "TransTypes.readInstance") cd cs
  FlatCurry.Curry_Types.Choice_C_TypeDecl d i l r -> narrow d i
    (d_C_readInstance x1 l cd cs) (d_C_readInstance x1 r cd cs)
  FlatCurry.Curry_Types.Choices_C_TypeDecl d i xs -> narrows cs d i (\z ->
    d_C_readInstance x1 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_TypeDecl d c e -> guardCons d c
    (d_C_readInstance x1 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_TypeDecl d info -> failCons d (traceFail
    "TransTypes.readInstance" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransTypes.readInstance" (showCons x2))

d_C_readListRule :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule
d_C_readListRule x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> let x4 = Curry_Prelude.d_C_apply (d_C_newVars
                                         cd cs) (Curry_Prelude.OP_Cons
                                         (Curry_Prelude.toCurryString "d")
                                         (Curry_Prelude.OP_Cons
                                         (Curry_Prelude.toCurryString "s")
                                         (Curry_Prelude.OP_Cons
                                         (Curry_Prelude.toCurryString "xs")
                                         (Curry_Prelude.OP_Cons
                                         (Curry_Prelude.toCurryString "s2")
                                         Curry_Prelude.OP_List)))) cd cs
                                       x5 = d_OP_readListRule_dot_uscore_hash_selFP16_hash_d
                                         x4 cd cs
                                       x6 = d_OP_readListRule_dot_uscore_hash_selFP17_hash_s
                                         x4 cd cs
                                       x7 = d_OP_readListRule_dot_uscore_hash_selFP18_hash_xs
                                         x4 cd cs
                                       x8 = d_OP_readListRule_dot_uscore_hash_selFP19_hash_s2
                                         x4 cd cs
    in Curry_Prelude.OP_Tuple2 (Curry_AbstractHaskellGoodies.d_C_pre
    (Curry_Prelude.toCurryString "readsPrec") cd cs)
    (Curry_AbstractHaskell.C_Rule (Curry_Prelude.OP_Cons
    (Curry_AbstractHaskell.C_PVar x5) (Curry_Prelude.OP_Cons
    (Curry_AbstractHaskell.C_PVar x6) Curry_Prelude.OP_List))
    (Curry_Prelude.d_OP_dollar (acceptCs id Curry_AbstractHaskell.C_SimpleRhs)
    (Curry_AbstractHaskellGoodies.d_C_applyF
    (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString "map") cd
    cs) (Curry_Prelude.OP_Cons (Curry_AbstractHaskellGoodies.d_C_constF
    (Curry_Prelude.OP_Tuple2 x2 (Curry_Prelude.toCurryString "readList")) cd cs)
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskellGoodies.d_C_applyF
    (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString
    "readsPrec") cd cs) (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x5)
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x6)
    Curry_Prelude.OP_List)) cd cs) Curry_Prelude.OP_List)) cd cs) cd cs)
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_LocalFunc
    (Curry_AbstractHaskellGoodies.d_C_tfunc (Curry_Prelude.OP_Tuple2 x2
    (Curry_Prelude.toCurryString "readList")) (Curry_Prelude.C_Int (1))
    Curry_AbstractHaskell.C_Private (Curry_AbstractHaskellGoodies.d_OP_tilde_gt
    (Curry_AbstractHaskellGoodies.d_C_tupleType (Curry_Prelude.OP_Cons
    (Curry_AbstractHaskellGoodies.d_C_listType (Curry_AbstractHaskell.C_TVar
    (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int (0))
    (Curry_Prelude.toCurryString "a"))) cd cs) (Curry_Prelude.OP_Cons
    (Curry_AbstractHaskellGoodies.d_C_stringType cd cs) Curry_Prelude.OP_List))
    cd cs) (Curry_AbstractHaskellGoodies.d_C_tupleType (Curry_Prelude.OP_Cons
    (Curry_AbstractHaskell.C_TCons (Curry_Prelude.OP_Tuple2 x2
    (Curry_Prelude.toCurryString "OP_List")) (Curry_Prelude.OP_Cons
    (Curry_AbstractHaskell.C_TVar (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int
    (0)) (Curry_Prelude.toCurryString "a"))) Curry_Prelude.OP_List))
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskellGoodies.d_C_stringType cd cs)
    Curry_Prelude.OP_List)) cd cs) cd cs) (Curry_Prelude.OP_Cons (d_C_simpleRule
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskellGoodies.d_C_tuplePat
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_PVar x7)
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_PVar x8)
    Curry_Prelude.OP_List)) cd cs) Curry_Prelude.OP_List)
    (Curry_AbstractHaskellGoodies.d_C_tupleExpr (Curry_Prelude.OP_Cons
    (Curry_AbstractHaskellGoodies.d_C_applyF
    (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString "foldr")
    cd cs) (Curry_Prelude.OP_Cons (Curry_AbstractHaskellGoodies.d_C_constF
    (Curry_Prelude.OP_Tuple2 x2 (Curry_Prelude.toCurryString "OP_Cons")) cd cs)
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskellGoodies.d_C_constF
    (Curry_Prelude.OP_Tuple2 x2 (Curry_Prelude.toCurryString "OP_List")) cd cs)
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x7)
    Curry_Prelude.OP_List))) cd cs) (Curry_Prelude.OP_Cons
    (Curry_AbstractHaskell.C_Var x8) Curry_Prelude.OP_List)) cd cs) cd cs)
    Curry_Prelude.OP_List) cd cs)) Curry_Prelude.OP_List))
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C_readListRule l cd
    cs) (d_C_readListRule r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_C_readListRule z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C_readListRule e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransTypes.readListRule" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.readListRule" (showCons x1))

d_OP_readListRule_dot_uscore_hash_selFP16_hash_d :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_readListRule_dot_uscore_hash_selFP16_hash_d x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_572 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_readListRule_dot_uscore_hash_selFP16_hash_d l cd cs)
    (d_OP_readListRule_dot_uscore_hash_selFP16_hash_d r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_readListRule_dot_uscore_hash_selFP16_hash_d z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_readListRule_dot_uscore_hash_selFP16_hash_d e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.readListRule._#selFP16#d" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.readListRule._#selFP16#d" (showCons
    x1))

d_OP_readListRule_dot_uscore_hash_selFP17_hash_s :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_readListRule_dot_uscore_hash_selFP17_hash_s x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_568 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_readListRule_dot_uscore_hash_selFP17_hash_s l cd cs)
    (d_OP_readListRule_dot_uscore_hash_selFP17_hash_s r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_readListRule_dot_uscore_hash_selFP17_hash_s z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_readListRule_dot_uscore_hash_selFP17_hash_s e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.readListRule._#selFP17#s" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.readListRule._#selFP17#s" (showCons
    x1))

d_OP_readListRule_dot_uscore_hash_selFP18_hash_xs :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_readListRule_dot_uscore_hash_selFP18_hash_xs x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_564 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_readListRule_dot_uscore_hash_selFP18_hash_xs l cd cs)
    (d_OP_readListRule_dot_uscore_hash_selFP18_hash_xs r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_readListRule_dot_uscore_hash_selFP18_hash_xs z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_readListRule_dot_uscore_hash_selFP18_hash_xs e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.readListRule._#selFP18#xs" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.readListRule._#selFP18#xs" (showCons
    x1))

d_OP_readListRule_dot_uscore_hash_selFP19_hash_s2 :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_readListRule_dot_uscore_hash_selFP19_hash_s2 x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_560 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_readListRule_dot_uscore_hash_selFP19_hash_s2 l cd cs)
    (d_OP_readListRule_dot_uscore_hash_selFP19_hash_s2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_readListRule_dot_uscore_hash_selFP19_hash_s2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_readListRule_dot_uscore_hash_selFP19_hash_s2 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.readListRule._#selFP19#s2" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.readListRule._#selFP19#s2" (showCons
    x1))

d_C_readTupleRule :: FlatCurry.Curry_Types.C_ConsDecl -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_AbstractHaskell.C_Rule
d_C_readTupleRule x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_Cons x2 x3 x4 x5 -> d_C__case_556 x3 x2 cd cs
  FlatCurry.Curry_Types.Choice_C_ConsDecl d i l r -> narrow d i
    (d_C_readTupleRule l cd cs) (d_C_readTupleRule r cd cs)
  FlatCurry.Curry_Types.Choices_C_ConsDecl d i xs -> narrows cs d i (\z ->
    d_C_readTupleRule z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_ConsDecl d c e -> guardCons d c
    (d_C_readTupleRule e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_ConsDecl d info -> failCons d (traceFail
    "TransTypes.readTupleRule" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.readTupleRule" (showCons x1))

d_OP_readTupleRule_dot_uscore_hash_selFP21_hash_d :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_readTupleRule_dot_uscore_hash_selFP21_hash_d x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_555 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_readTupleRule_dot_uscore_hash_selFP21_hash_d l cd cs)
    (d_OP_readTupleRule_dot_uscore_hash_selFP21_hash_d r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_readTupleRule_dot_uscore_hash_selFP21_hash_d z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_readTupleRule_dot_uscore_hash_selFP21_hash_d e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.readTupleRule._#selFP21#d" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.readTupleRule._#selFP21#d" (showCons
    x1))

d_OP_readTupleRule_dot_uscore_hash_selFP22_hash_s :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_readTupleRule_dot_uscore_hash_selFP22_hash_s x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_552 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_readTupleRule_dot_uscore_hash_selFP22_hash_s l cd cs)
    (d_OP_readTupleRule_dot_uscore_hash_selFP22_hash_s r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_readTupleRule_dot_uscore_hash_selFP22_hash_s z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_readTupleRule_dot_uscore_hash_selFP22_hash_s e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.readTupleRule._#selFP22#s" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.readTupleRule._#selFP22#s" (showCons
    x1))

d_OP_readTupleRule_dot_uscore_hash_selFP23_hash_s2 :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_readTupleRule_dot_uscore_hash_selFP23_hash_s2 x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_549 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_readTupleRule_dot_uscore_hash_selFP23_hash_s2 l cd cs)
    (d_OP_readTupleRule_dot_uscore_hash_selFP23_hash_s2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_readTupleRule_dot_uscore_hash_selFP23_hash_s2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_readTupleRule_dot_uscore_hash_selFP23_hash_s2 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.readTupleRule._#selFP23#s2" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.readTupleRule._#selFP23#s2" (showCons
    x1))

d_C_readRule :: Curry_Prelude.OP_List FlatCurry.Curry_Types.C_ConsDecl -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule
d_C_readRule x1 cd cs = let x2 = Curry_Prelude.d_C_apply (Curry_Prelude.d_C_or
                              cd cs) (Curry_Prelude.d_C_foldr (acceptCs id
                              d_OP_readRule_dot_uscore_hash_lambda15)
                              Curry_Prelude.OP_List x1 cd cs) cd cs
                            x3 = d_C__case_546 x2 cd cs
  in Curry_Prelude.OP_Tuple2 (Curry_AbstractHaskellGoodies.d_C_pre
  (Curry_Prelude.toCurryString "readsPrec") cd cs) (d_C_simpleRule
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_PVar x3)
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_PVar (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.C_Int (1)) (Curry_Prelude.toCurryString "s")))
  Curry_Prelude.OP_List)) (Curry_Prelude.d_OP_dollar (Curry_Prelude.d_C_foldr1
  (acceptCs id d_OP_readRule_dot_uscore_hash_lambda17)) (Curry_Prelude.d_C_map
  d_C_readParen x1 cd cs) cd cs) cd cs)

d_OP_readRule_dot_uscore_hash_lambda15 :: FlatCurry.Curry_Types.C_ConsDecl
  -> Curry_Prelude.OP_List Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Bool
d_OP_readRule_dot_uscore_hash_lambda15 x1 x2 cd cs = case x1 of
  FlatCurry.Curry_Types.C_Cons x3 x4 x5 x6 -> Curry_Prelude.OP_Cons
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
    cd cs) x4 cd cs) (Curry_Prelude.C_Int (0)) cd cs) x2
  FlatCurry.Curry_Types.Choice_C_ConsDecl d i l r -> narrow d i
    (d_OP_readRule_dot_uscore_hash_lambda15 l x2 cd cs)
    (d_OP_readRule_dot_uscore_hash_lambda15 r x2 cd cs)
  FlatCurry.Curry_Types.Choices_C_ConsDecl d i xs -> narrows cs d i (\z ->
    d_OP_readRule_dot_uscore_hash_lambda15 z x2 cd cs) xs
  FlatCurry.Curry_Types.Guard_C_ConsDecl d c e -> guardCons d c
    (d_OP_readRule_dot_uscore_hash_lambda15 e x2 cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_ConsDecl d info -> failCons d (traceFail
    "TransTypes.readRule._#lambda15" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransTypes.readRule._#lambda15" (showCons x1))

d_OP_readRule_dot_uscore_hash_lambda17 :: Curry_AbstractHaskell.C_Expr
  -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_OP_readRule_dot_uscore_hash_lambda17 x1 x2 cd cs =
  Curry_AbstractHaskell.C_InfixApply x1 (Curry_AbstractHaskellGoodies.d_C_pre
  (Curry_Prelude.toCurryString "++") cd cs) x2

d_C_readParen :: FlatCurry.Curry_Types.C_ConsDecl -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C_readParen x1 cd cs = case x1 of
  FlatCurry.Curry_Types.C_Cons x2 x3 x4 x5 -> d_C__case_545 x3 x2 cd cs
  FlatCurry.Curry_Types.Choice_C_ConsDecl d i l r -> narrow d i (d_C_readParen l
    cd cs) (d_C_readParen r cd cs)
  FlatCurry.Curry_Types.Choices_C_ConsDecl d i xs -> narrows cs d i (\z ->
    d_C_readParen z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_ConsDecl d c e -> guardCons d c (d_C_readParen e
    cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_ConsDecl d info -> failCons d (traceFail
    "TransTypes.readParen" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.readParen" (showCons x1))

d_OP_readParen_dot_genReadsPrec_dot_172 :: Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Statement
d_OP_readParen_dot_genReadsPrec_dot_172 x1 cd cs = Curry_AbstractHaskell.C_SPat
  (Curry_AbstractHaskellGoodies.d_C_tuplePat (Curry_Prelude.OP_Cons (d_C_mkPVar
  (Curry_Prelude.toCurryString "x") x1 cd cs) (Curry_Prelude.OP_Cons (d_C_mkPVar
  (Curry_Prelude.toCurryString "r") x1 cd cs) Curry_Prelude.OP_List)) cd cs)
  (Curry_AbstractHaskellGoodies.d_C_applyF (Curry_AbstractHaskellGoodies.d_C_pre
  (Curry_Prelude.toCurryString "readsPrec") cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Lit (Curry_AbstractHaskell.C_Intc
  (Curry_Prelude.C_Int (11)))) (Curry_Prelude.OP_Cons (d_C_mkVar
  (Curry_Prelude.toCurryString "r")
  (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
  x1 (Curry_Prelude.C_Int (1)) cd cs) cd cs) Curry_Prelude.OP_List)) cd cs)

d_C_nondetInstance :: Curry_Prelude.C_Bool -> FlatCurry.Curry_Types.C_TypeDecl
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeDecl
d_C_nondetInstance x1 x2 cd cs = case x2 of
  FlatCurry.Curry_Types.C_Type x3 x4 x5 x6 -> let x7 = Curry_Prelude.d_C_map
                                                    d_C_fcy2absTVar x5 cd cs
                                                  x8 = Curry_AbstractHaskell.C_TCons
                                                    x3 (Curry_Prelude.d_C_map
                                                    (acceptCs id
                                                    Curry_AbstractHaskell.C_TVar)
                                                    x7 cd cs)
    in d_C__case_543 x1 x8 x3 (Curry_Prelude.d_C_not x1 cd cs) cd cs
  FlatCurry.Curry_Types.C_TypeSyn x9 x10 x11 x12 -> Curry_Prelude.d_C_error
    (Curry_Prelude.toCurryString "TransTypes.nondetInstance") cd cs
  FlatCurry.Curry_Types.Choice_C_TypeDecl d i l r -> narrow d i
    (d_C_nondetInstance x1 l cd cs) (d_C_nondetInstance x1 r cd cs)
  FlatCurry.Curry_Types.Choices_C_TypeDecl d i xs -> narrows cs d i (\z ->
    d_C_nondetInstance x1 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_TypeDecl d c e -> guardCons d c
    (d_C_nondetInstance x1 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_TypeDecl d info -> failCons d (traceFail
    "TransTypes.nondetInstance" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransTypes.nondetInstance" (showCons x2))

d_C_specialConsRules :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
d_C_specialConsRules x1 cd cs = Curry_Prelude.d_C_map
  d_OP_specialConsRules_dot_nameRule_dot_187 (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.toCurryString "choiceCons")
  (Curry_Prelude.d_C_apply (Curry_Names.d_C_mkChoiceName cd cs) x1 cd cs))
  (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple2 (Curry_Prelude.toCurryString
  "choicesCons") (Curry_Prelude.d_C_apply (Curry_Names.d_C_mkChoicesName cd cs)
  x1 cd cs)) (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.toCurryString "failCons") (Curry_Prelude.d_C_apply
  (Curry_Names.d_C_mkFailName cd cs) x1 cd cs)) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.toCurryString "guardCons")
  (Curry_Prelude.d_C_apply (Curry_Names.d_C_mkGuardName cd cs) x1 cd cs))
  Curry_Prelude.OP_List)))) cd cs

d_OP_specialConsRules_dot_nameRule_dot_187 :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule
d_OP_specialConsRules_dot_nameRule_dot_187 x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> Curry_Prelude.OP_Tuple2 (d_C_basics x2 cd cs)
    (d_C_simpleRule Curry_Prelude.OP_List
    (Curry_AbstractHaskellGoodies.d_C_constF x3 cd cs) cd cs)
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_specialConsRules_dot_nameRule_dot_187 l cd cs)
    (d_OP_specialConsRules_dot_nameRule_dot_187 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_specialConsRules_dot_nameRule_dot_187 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_specialConsRules_dot_nameRule_dot_187 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransTypes.specialConsRules.nameRule.187" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.specialConsRules.nameRule.187"
    (showCons x1))

d_C_tryRules :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
d_C_tryRules x1 cd cs = let x2 = Curry_Prelude.d_OP_dollar
                              (Curry_Prelude.d_C_map (acceptCs id
                              Curry_AbstractHaskell.C_Var))
                              (Curry_Prelude.d_C_apply (d_C_newVars cd cs)
                              (Curry_Prelude.OP_Cons
                              (Curry_Prelude.toCurryString "i")
                              (Curry_Prelude.OP_Cons
                              (Curry_Prelude.toCurryString "x")
                              (Curry_Prelude.OP_Cons
                              (Curry_Prelude.toCurryString "y")
                              (Curry_Prelude.OP_Cons
                              (Curry_Prelude.toCurryString "xs")
                              (Curry_Prelude.OP_Cons
                              (Curry_Prelude.toCurryString "c")
                              (Curry_Prelude.OP_Cons
                              (Curry_Prelude.toCurryString "e")
                              (Curry_Prelude.OP_Cons
                              (Curry_Prelude.toCurryString "cd")
                              (Curry_Prelude.OP_Cons
                              (Curry_Prelude.toCurryString "info")
                              Curry_Prelude.OP_List)))))))) cd cs) cd cs
                            x3 = d_OP_tryRules_dot_uscore_hash_selFP25_hash_i x2
                              cd cs
                            x4 = d_OP_tryRules_dot_uscore_hash_selFP26_hash_x x2
                              cd cs
                            x5 = d_OP_tryRules_dot_uscore_hash_selFP27_hash_y x2
                              cd cs
                            x6 = d_OP_tryRules_dot_uscore_hash_selFP28_hash_xs
                              x2 cd cs
                            x7 = d_OP_tryRules_dot_uscore_hash_selFP29_hash_c x2
                              cd cs
                            x8 = d_OP_tryRules_dot_uscore_hash_selFP30_hash_e x2
                              cd cs
                            x9 = d_OP_tryRules_dot_uscore_hash_selFP31_hash_cd
                              x2 cd cs
                            x10 = d_OP_tryRules_dot_uscore_hash_selFP32_hash_info
                              x2 cd cs
  in Curry_Prelude.d_C_map d_OP_tryRules_dot_nameRule_dot_191
  (Curry_Prelude.OP_Cons (Curry_Prelude.d_OP_dollar (d_C_simpleRule
  (Curry_Prelude.OP_Cons (d_C_mkChoicePattern x1 (Curry_Prelude.toCurryString
  "i") cd cs) Curry_Prelude.OP_List)) (Curry_AbstractHaskellGoodies.d_C_applyF
  (d_C_basics (Curry_Prelude.toCurryString "tryChoice") cd cs)
  (Curry_Prelude.OP_Cons x9 (Curry_Prelude.OP_Cons x3 (Curry_Prelude.OP_Cons x4
  (Curry_Prelude.OP_Cons x5 Curry_Prelude.OP_List)))) cd cs) cd cs)
  (Curry_Prelude.OP_Cons (Curry_Prelude.d_OP_dollar (d_C_simpleRule
  (Curry_Prelude.OP_Cons (d_C_mkChoicesPattern x1 cd cs) Curry_Prelude.OP_List))
  (Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
  (Curry_Prelude.toCurryString "tryChoices") cd cs) (Curry_Prelude.OP_Cons x9
  (Curry_Prelude.OP_Cons x3 (Curry_Prelude.OP_Cons x6 Curry_Prelude.OP_List)))
  cd cs) cd cs) (Curry_Prelude.OP_Cons (Curry_Prelude.d_OP_dollar
  (d_C_simpleRule (Curry_Prelude.OP_Cons (d_C_mkFailPattern x1 cd cs)
  Curry_Prelude.OP_List)) (Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
  (Curry_Prelude.toCurryString "Fail") cd cs) (Curry_Prelude.OP_Cons x9
  (Curry_Prelude.OP_Cons x10 Curry_Prelude.OP_List)) cd cs) cd cs)
  (Curry_Prelude.OP_Cons (Curry_Prelude.d_OP_dollar (d_C_simpleRule
  (Curry_Prelude.OP_Cons (d_C_mkGuardPattern x1 cd cs) Curry_Prelude.OP_List))
  (Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
  (Curry_Prelude.toCurryString "Guard") cd cs) (Curry_Prelude.OP_Cons x9
  (Curry_Prelude.OP_Cons x7 (Curry_Prelude.OP_Cons x8 Curry_Prelude.OP_List)))
  cd cs) cd cs) (Curry_Prelude.OP_Cons (Curry_Prelude.d_OP_dollar
  (d_C_simpleRule (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_PVar
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int (2))
  (Curry_Prelude.toCurryString "x"))) Curry_Prelude.OP_List))
  (Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
  (Curry_Prelude.toCurryString "Val") cd cs) (Curry_Prelude.OP_Cons x4
  Curry_Prelude.OP_List) cd cs) cd cs) Curry_Prelude.OP_List))))) cd cs

d_OP_tryRules_dot_uscore_hash_selFP25_hash_i :: Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_OP_tryRules_dot_uscore_hash_selFP25_hash_i x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_541 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_tryRules_dot_uscore_hash_selFP25_hash_i l cd cs)
    (d_OP_tryRules_dot_uscore_hash_selFP25_hash_i r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_tryRules_dot_uscore_hash_selFP25_hash_i z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_tryRules_dot_uscore_hash_selFP25_hash_i e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.tryRules._#selFP25#i" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.tryRules._#selFP25#i" (showCons x1))

d_OP_tryRules_dot_uscore_hash_selFP26_hash_x :: Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_OP_tryRules_dot_uscore_hash_selFP26_hash_x x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_533 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_tryRules_dot_uscore_hash_selFP26_hash_x l cd cs)
    (d_OP_tryRules_dot_uscore_hash_selFP26_hash_x r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_tryRules_dot_uscore_hash_selFP26_hash_x z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_tryRules_dot_uscore_hash_selFP26_hash_x e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.tryRules._#selFP26#x" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.tryRules._#selFP26#x" (showCons x1))

d_OP_tryRules_dot_uscore_hash_selFP27_hash_y :: Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_OP_tryRules_dot_uscore_hash_selFP27_hash_y x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_525 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_tryRules_dot_uscore_hash_selFP27_hash_y l cd cs)
    (d_OP_tryRules_dot_uscore_hash_selFP27_hash_y r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_tryRules_dot_uscore_hash_selFP27_hash_y z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_tryRules_dot_uscore_hash_selFP27_hash_y e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.tryRules._#selFP27#y" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.tryRules._#selFP27#y" (showCons x1))

d_OP_tryRules_dot_uscore_hash_selFP28_hash_xs :: Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_OP_tryRules_dot_uscore_hash_selFP28_hash_xs x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_517 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_tryRules_dot_uscore_hash_selFP28_hash_xs l cd cs)
    (d_OP_tryRules_dot_uscore_hash_selFP28_hash_xs r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_tryRules_dot_uscore_hash_selFP28_hash_xs z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_tryRules_dot_uscore_hash_selFP28_hash_xs e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.tryRules._#selFP28#xs" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.tryRules._#selFP28#xs" (showCons x1))

d_OP_tryRules_dot_uscore_hash_selFP29_hash_c :: Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_OP_tryRules_dot_uscore_hash_selFP29_hash_c x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_509 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_tryRules_dot_uscore_hash_selFP29_hash_c l cd cs)
    (d_OP_tryRules_dot_uscore_hash_selFP29_hash_c r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_tryRules_dot_uscore_hash_selFP29_hash_c z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_tryRules_dot_uscore_hash_selFP29_hash_c e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.tryRules._#selFP29#c" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.tryRules._#selFP29#c" (showCons x1))

d_OP_tryRules_dot_uscore_hash_selFP30_hash_e :: Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_OP_tryRules_dot_uscore_hash_selFP30_hash_e x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_501 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_tryRules_dot_uscore_hash_selFP30_hash_e l cd cs)
    (d_OP_tryRules_dot_uscore_hash_selFP30_hash_e r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_tryRules_dot_uscore_hash_selFP30_hash_e z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_tryRules_dot_uscore_hash_selFP30_hash_e e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.tryRules._#selFP30#e" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.tryRules._#selFP30#e" (showCons x1))

d_OP_tryRules_dot_uscore_hash_selFP31_hash_cd :: Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_OP_tryRules_dot_uscore_hash_selFP31_hash_cd x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_493 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_tryRules_dot_uscore_hash_selFP31_hash_cd l cd cs)
    (d_OP_tryRules_dot_uscore_hash_selFP31_hash_cd r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_tryRules_dot_uscore_hash_selFP31_hash_cd z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_tryRules_dot_uscore_hash_selFP31_hash_cd e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.tryRules._#selFP31#cd" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.tryRules._#selFP31#cd" (showCons x1))

d_OP_tryRules_dot_uscore_hash_selFP32_hash_info :: Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_OP_tryRules_dot_uscore_hash_selFP32_hash_info x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_485 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_tryRules_dot_uscore_hash_selFP32_hash_info l cd cs)
    (d_OP_tryRules_dot_uscore_hash_selFP32_hash_info r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_tryRules_dot_uscore_hash_selFP32_hash_info z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_tryRules_dot_uscore_hash_selFP32_hash_info e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.tryRules._#selFP32#info" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.tryRules._#selFP32#info" (showCons x1))

d_OP_tryRules_dot_nameRule_dot_191 :: forall t0 . (Curry_Prelude.Curry t0) => t0
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) t0
d_OP_tryRules_dot_nameRule_dot_191 x1 cd cs = Curry_Prelude.OP_Tuple2
  (d_C_basics (Curry_Prelude.toCurryString "try") cd cs) x1

d_C_matchRules :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
d_C_matchRules x1 cd cs = let x2 = Curry_Prelude.d_OP_dollar
                                (Curry_Prelude.d_C_map (acceptCs id
                                Curry_AbstractHaskell.C_PVar))
                                (Curry_Prelude.d_C_apply (d_C_newVars cd cs)
                                (Curry_Prelude.OP_Cons
                                (Curry_Prelude.toCurryString "_")
                                (Curry_Prelude.OP_Cons
                                (Curry_Prelude.toCurryString "_")
                                (Curry_Prelude.OP_Cons
                                (Curry_Prelude.toCurryString "_")
                                (Curry_Prelude.OP_Cons
                                (Curry_Prelude.toCurryString "_")
                                (Curry_Prelude.OP_Cons
                                (Curry_Prelude.toCurryString "_")
                                Curry_Prelude.OP_List))))) cd cs) cd cs
                              x3 = Curry_Prelude.d_OP_dollar
                                (Curry_Prelude.d_C_map (acceptCs id
                                Curry_AbstractHaskell.C_Var))
                                (Curry_Prelude.d_C_apply (d_C_newVars cd cs)
                                (Curry_Prelude.OP_Cons
                                (Curry_Prelude.toCurryString "i")
                                (Curry_Prelude.OP_Cons
                                (Curry_Prelude.toCurryString "x")
                                (Curry_Prelude.OP_Cons
                                (Curry_Prelude.toCurryString "y")
                                (Curry_Prelude.OP_Cons
                                (Curry_Prelude.toCurryString "xs")
                                (Curry_Prelude.OP_Cons
                                (Curry_Prelude.toCurryString "e")
                                (Curry_Prelude.OP_Cons
                                (Curry_Prelude.toCurryString "c")
                                (Curry_Prelude.OP_Cons
                                (Curry_Prelude.toCurryString "cd")
                                (Curry_Prelude.OP_Cons
                                (Curry_Prelude.toCurryString "info")
                                Curry_Prelude.OP_List)))))))) cd cs) cd cs
                              x4 = d_OP_matchRules_dot_uscore_hash_selFP34_hash_i
                                x3 cd cs
                              x5 = d_OP_matchRules_dot_uscore_hash_selFP35_hash_x
                                x3 cd cs
                              x6 = d_OP_matchRules_dot_uscore_hash_selFP36_hash_y
                                x3 cd cs
                              x7 = d_OP_matchRules_dot_uscore_hash_selFP37_hash_xs
                                x3 cd cs
                              x8 = d_OP_matchRules_dot_uscore_hash_selFP38_hash_e
                                x3 cd cs
                              x9 = d_OP_matchRules_dot_uscore_hash_selFP39_hash_c
                                x3 cd cs
                              x10 = d_OP_matchRules_dot_uscore_hash_selFP40_hash_cd
                                x3 cd cs
                              x11 = d_OP_matchRules_dot_uscore_hash_selFP41_hash_info
                                x3 cd cs
                              x12 = Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int
                                (1)) (Curry_Prelude.toCurryString "f")
  in Curry_Prelude.d_C_map d_OP_matchRules_dot_nameRule_dot_196
  (Curry_Prelude.OP_Cons (Curry_Prelude.d_OP_dollar (d_C_simpleRule
  (Curry_Prelude.d_OP_plus_plus (d_OP_matchRules_dot_matchAt_dot_196 x2 x12
  (Curry_Prelude.C_Int (0)) cd cs) (Curry_Prelude.OP_Cons (d_C_mkChoicePattern
  x1 (Curry_Prelude.toCurryString "i") cd cs) Curry_Prelude.OP_List) cd cs))
  (Curry_AbstractHaskellGoodies.d_C_applyV x12 (Curry_Prelude.OP_Cons x10
  (Curry_Prelude.OP_Cons x4 (Curry_Prelude.OP_Cons x5 (Curry_Prelude.OP_Cons x6
  Curry_Prelude.OP_List)))) cd cs) cd cs) (Curry_Prelude.OP_Cons
  (Curry_Prelude.d_OP_dollar (d_C_simpleRule (Curry_Prelude.d_OP_plus_plus
  (d_OP_matchRules_dot_matchAt_dot_196 x2 x12 (Curry_Prelude.C_Int (1)) cd cs)
  (Curry_Prelude.OP_Cons (d_C_mkNarrowedChoicesPattern x1
  (Curry_Prelude.toCurryString "i") cd cs) Curry_Prelude.OP_List) cd cs))
  (Curry_AbstractHaskellGoodies.d_C_applyV x12 (Curry_Prelude.OP_Cons x10
  (Curry_Prelude.OP_Cons x4 (Curry_Prelude.OP_Cons x7 Curry_Prelude.OP_List)))
  cd cs) cd cs) (Curry_Prelude.OP_Cons (Curry_Prelude.d_OP_dollar
  (d_C_simpleRule (Curry_Prelude.d_OP_plus_plus
  (d_OP_matchRules_dot_matchAt_dot_196 x2 x12 (Curry_Prelude.C_Int (2)) cd cs)
  (Curry_Prelude.OP_Cons (d_C_mkFreeChoicesPattern x1
  (Curry_Prelude.toCurryString "i") cd cs) Curry_Prelude.OP_List) cd cs))
  (Curry_AbstractHaskellGoodies.d_C_applyV x12 (Curry_Prelude.OP_Cons x10
  (Curry_Prelude.OP_Cons x4 (Curry_Prelude.OP_Cons x7 Curry_Prelude.OP_List)))
  cd cs) cd cs) (Curry_Prelude.OP_Cons (Curry_Prelude.d_OP_dollar
  (d_C_simpleRule (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_PVar
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int (0))
  (Curry_Prelude.toCurryString "_"))) (Curry_Prelude.d_OP_plus_plus x2
  (Curry_Prelude.OP_Cons (d_C_mkVarChoicesPattern x1 cd cs)
  Curry_Prelude.OP_List) cd cs))) (Curry_AbstractHaskellGoodies.d_C_applyF
  (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString "error") cd
  cs) (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_InfixApply
  (Curry_Prelude.d_C_apply (Curry_AbstractHaskellGoodies.d_C_string2ac cd cs)
  (Curry_Prelude.d_OP_plus_plus (d_C_showQName (Curry_Prelude.d_C_apply
  (Curry_Names.d_C_unRenameQName cd cs) x1 cd cs) cd cs)
  (Curry_Prelude.toCurryString ".match: Choices with ChoiceID ") cd cs) cd cs)
  (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString "++") cd
  cs) (Curry_AbstractHaskellGoodies.d_C_applyF
  (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString "show") cd
  cs) (Curry_Prelude.OP_Cons x4 Curry_Prelude.OP_List) cd cs))
  Curry_Prelude.OP_List) cd cs) cd cs) (Curry_Prelude.OP_Cons
  (Curry_Prelude.d_OP_dollar (d_C_simpleRule (Curry_Prelude.d_OP_plus_plus
  (d_OP_matchRules_dot_matchAt_dot_196 x2 x12 (Curry_Prelude.C_Int (3)) cd cs)
  (Curry_Prelude.OP_Cons (d_C_mkFailPattern x1 cd cs) Curry_Prelude.OP_List) cd
  cs)) (Curry_AbstractHaskellGoodies.d_C_applyV x12 (Curry_Prelude.OP_Cons x10
  (Curry_Prelude.OP_Cons x11 Curry_Prelude.OP_List)) cd cs) cd cs)
  (Curry_Prelude.OP_Cons (Curry_Prelude.d_OP_dollar (d_C_simpleRule
  (Curry_Prelude.d_OP_plus_plus (d_OP_matchRules_dot_matchAt_dot_196 x2 x12
  (Curry_Prelude.C_Int (4)) cd cs) (Curry_Prelude.OP_Cons (d_C_mkGuardPattern x1
  cd cs) Curry_Prelude.OP_List) cd cs)) (Curry_AbstractHaskellGoodies.d_C_applyV
  x12 (Curry_Prelude.OP_Cons x10 (Curry_Prelude.OP_Cons x9
  (Curry_Prelude.OP_Cons x8 Curry_Prelude.OP_List))) cd cs) cd cs)
  (Curry_Prelude.OP_Cons (Curry_Prelude.d_OP_dollar (d_C_simpleRule
  (Curry_Prelude.d_OP_plus_plus (d_OP_matchRules_dot_matchAt_dot_196 x2 x12
  (Curry_Prelude.C_Int (5)) cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int
  (7)) (Curry_Prelude.toCurryString "x"))) Curry_Prelude.OP_List) cd cs))
  (Curry_AbstractHaskellGoodies.d_C_applyV x12 (Curry_Prelude.OP_Cons x5
  Curry_Prelude.OP_List) cd cs) cd cs) Curry_Prelude.OP_List))))))) cd cs

d_OP_matchRules_dot_uscore_hash_selFP34_hash_i :: Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_OP_matchRules_dot_uscore_hash_selFP34_hash_i x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_477 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_matchRules_dot_uscore_hash_selFP34_hash_i l cd cs)
    (d_OP_matchRules_dot_uscore_hash_selFP34_hash_i r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_matchRules_dot_uscore_hash_selFP34_hash_i z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_matchRules_dot_uscore_hash_selFP34_hash_i e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.matchRules._#selFP34#i" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.matchRules._#selFP34#i" (showCons x1))

d_OP_matchRules_dot_uscore_hash_selFP35_hash_x :: Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_OP_matchRules_dot_uscore_hash_selFP35_hash_x x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_469 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_matchRules_dot_uscore_hash_selFP35_hash_x l cd cs)
    (d_OP_matchRules_dot_uscore_hash_selFP35_hash_x r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_matchRules_dot_uscore_hash_selFP35_hash_x z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_matchRules_dot_uscore_hash_selFP35_hash_x e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.matchRules._#selFP35#x" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.matchRules._#selFP35#x" (showCons x1))

d_OP_matchRules_dot_uscore_hash_selFP36_hash_y :: Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_OP_matchRules_dot_uscore_hash_selFP36_hash_y x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_461 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_matchRules_dot_uscore_hash_selFP36_hash_y l cd cs)
    (d_OP_matchRules_dot_uscore_hash_selFP36_hash_y r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_matchRules_dot_uscore_hash_selFP36_hash_y z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_matchRules_dot_uscore_hash_selFP36_hash_y e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.matchRules._#selFP36#y" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.matchRules._#selFP36#y" (showCons x1))

d_OP_matchRules_dot_uscore_hash_selFP37_hash_xs :: Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_OP_matchRules_dot_uscore_hash_selFP37_hash_xs x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_453 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_matchRules_dot_uscore_hash_selFP37_hash_xs l cd cs)
    (d_OP_matchRules_dot_uscore_hash_selFP37_hash_xs r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_matchRules_dot_uscore_hash_selFP37_hash_xs z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_matchRules_dot_uscore_hash_selFP37_hash_xs e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.matchRules._#selFP37#xs" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.matchRules._#selFP37#xs" (showCons x1))

d_OP_matchRules_dot_uscore_hash_selFP38_hash_e :: Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_OP_matchRules_dot_uscore_hash_selFP38_hash_e x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_445 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_matchRules_dot_uscore_hash_selFP38_hash_e l cd cs)
    (d_OP_matchRules_dot_uscore_hash_selFP38_hash_e r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_matchRules_dot_uscore_hash_selFP38_hash_e z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_matchRules_dot_uscore_hash_selFP38_hash_e e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.matchRules._#selFP38#e" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.matchRules._#selFP38#e" (showCons x1))

d_OP_matchRules_dot_uscore_hash_selFP39_hash_c :: Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_OP_matchRules_dot_uscore_hash_selFP39_hash_c x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_437 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_matchRules_dot_uscore_hash_selFP39_hash_c l cd cs)
    (d_OP_matchRules_dot_uscore_hash_selFP39_hash_c r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_matchRules_dot_uscore_hash_selFP39_hash_c z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_matchRules_dot_uscore_hash_selFP39_hash_c e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.matchRules._#selFP39#c" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.matchRules._#selFP39#c" (showCons x1))

d_OP_matchRules_dot_uscore_hash_selFP40_hash_cd :: Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_OP_matchRules_dot_uscore_hash_selFP40_hash_cd x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_429 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_matchRules_dot_uscore_hash_selFP40_hash_cd l cd cs)
    (d_OP_matchRules_dot_uscore_hash_selFP40_hash_cd r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_matchRules_dot_uscore_hash_selFP40_hash_cd z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_matchRules_dot_uscore_hash_selFP40_hash_cd e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.matchRules._#selFP40#cd" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.matchRules._#selFP40#cd" (showCons x1))

d_OP_matchRules_dot_uscore_hash_selFP41_hash_info :: Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_OP_matchRules_dot_uscore_hash_selFP41_hash_info x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_421 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_matchRules_dot_uscore_hash_selFP41_hash_info l cd cs)
    (d_OP_matchRules_dot_uscore_hash_selFP41_hash_info r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_matchRules_dot_uscore_hash_selFP41_hash_info z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_matchRules_dot_uscore_hash_selFP41_hash_info e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.matchRules._#selFP41#info" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.matchRules._#selFP41#info" (showCons
    x1))

d_OP_matchRules_dot_nameRule_dot_196 :: forall t0 . (Curry_Prelude.Curry
  t0) => t0 -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) t0
d_OP_matchRules_dot_nameRule_dot_196 x1 cd cs = Curry_Prelude.OP_Tuple2
  (d_C_basics (Curry_Prelude.toCurryString "match") cd cs) x1

d_OP_matchRules_dot_matchAt_dot_196 :: Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Pattern -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_Pattern
d_OP_matchRules_dot_matchAt_dot_196 x1 x2 x3 cd cs =
  Curry_Prelude.d_OP_plus_plus (Curry_Prelude.d_C_take x3 x1 cd cs)
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_PVar x2)
  (Curry_Prelude.d_C_drop x3 x1 cd cs)) cd cs

d_C_generableInstance :: Curry_Prelude.C_Bool -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass -> FlatCurry.Curry_Types.C_TypeDecl
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeDecl
d_C_generableInstance x1 x2 x3 cd cs = case x3 of
  FlatCurry.Curry_Types.C_Type x4 x5 x6 x7 -> let x8 = Curry_Prelude.d_C_map
                                                    d_C_fcy2absTVar x6 cd cs
                                                  x9 = Curry_AbstractHaskell.C_TCons
                                                    x4 (Curry_Prelude.d_C_map
                                                    (acceptCs id
                                                    Curry_AbstractHaskell.C_TVar)
                                                    x8 cd cs)
                                                  x10 = Curry_Prelude.d_C_apply
                                                    (d_C_newVars cd cs)
                                                    (Curry_Prelude.OP_Cons
                                                    (Curry_Prelude.toCurryString
                                                    "s") (Curry_Prelude.OP_Cons
                                                    (Curry_Prelude.toCurryString
                                                    "c") Curry_Prelude.OP_List))
                                                    cd cs
                                                  x11 = d_OP_generableInstance_dot_uscore_hash_selFP43_hash_s
                                                    x10 cd cs
                                                  x12 = d_OP_generableInstance_dot_uscore_hash_selFP44_hash_c
                                                    x10 cd cs
                                                  x13 = Curry_AbstractHaskell.C_Var
                                                    x11
                                                  x14 = Curry_Prelude.d_OP_dollar
                                                    Curry_AbstractHaskellGoodies.d_C_list2ac
                                                    (Curry_Prelude.d_C_map
                                                    (Curry_Prelude.d_OP_dot
                                                    d_C_intc
                                                    (FlatCurry.Curry_Goodies.d_C_consArity
                                                    cd cs) cd cs) x7 cd cs) cd
                                                    cs
                                                  x15 = Curry_AbstractHaskellGoodies.d_C_applyF
                                                    (Curry_Prelude.d_C_apply
                                                    (Curry_Names.d_C_mkChoicesName
                                                    cd cs) x4 cd cs)
                                                    (Curry_Prelude.OP_Cons
                                                    (Curry_AbstractHaskell.C_Var
                                                    x12) (Curry_Prelude.OP_Cons
                                                    (Curry_AbstractHaskellGoodies.d_C_applyF
                                                    (d_C_basics
                                                    (Curry_Prelude.toCurryString
                                                    "freeID") cd cs)
                                                    (Curry_Prelude.OP_Cons x14
                                                    (Curry_Prelude.OP_Cons x13
                                                    Curry_Prelude.OP_List)) cd
                                                    cs) (Curry_Prelude.OP_Cons
                                                    (Curry_Prelude.d_OP_dollar
                                                    Curry_AbstractHaskellGoodies.d_C_list2ac
                                                    (Curry_Prelude.d_C_map
                                                    (d_OP_generableInstance_dot_genCons_dot_208
                                                    x13 x12 x2) x7 cd cs) cd cs)
                                                    Curry_Prelude.OP_List))) cd
                                                    cs
    in d_C__case_413 x1 x9 x15 x12 x11 x8 (Curry_Prelude.d_C_not x1 cd cs) cd cs
  FlatCurry.Curry_Types.C_TypeSyn x16 x17 x18 x19 -> Curry_Prelude.d_C_error
    (Curry_Prelude.toCurryString "TransTypes.generableInstance") cd cs
  FlatCurry.Curry_Types.Choice_C_TypeDecl d i l r -> narrow d i
    (d_C_generableInstance x1 x2 l cd cs) (d_C_generableInstance x1 x2 r cd cs)
  FlatCurry.Curry_Types.Choices_C_TypeDecl d i xs -> narrows cs d i (\z ->
    d_C_generableInstance x1 x2 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_TypeDecl d c e -> guardCons d c
    (d_C_generableInstance x1 x2 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_TypeDecl d info -> failCons d (traceFail
    "TransTypes.generableInstance" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes.generableInstance" (showCons x3))

nd_C_generableInstance :: Curry_Prelude.C_Bool -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass -> FlatCurry.Curry_Types.C_TypeDecl
  -> IDSupply -> Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeDecl
nd_C_generableInstance x1 x2 x3 s cd cs = case x3 of
  FlatCurry.Curry_Types.C_Type x4 x5 x6 x7 -> let s13 = s
    in s13 `seq` (let s14 = leftSupply s13
                      s15 = rightSupply s13
                      s0 = leftSupply s14
                      s1 = rightSupply s14
                      s2 = leftSupply s15
                      s16 = rightSupply s15
                      s7 = leftSupply s16
                      s12 = rightSupply s16
    in s14 `seq` (s15 `seq` (s0 `seq` (s1 `seq` (s2 `seq` (s16 `seq` (s7 `seq`
    (s12 `seq` (let x8 = Curry_Prelude.nd_C_map (wrapDX id d_C_fcy2absTVar) x6
                      s0 cd cs
                    x9 = Curry_AbstractHaskell.C_TCons x4
                      (Curry_Prelude.nd_C_map (wrapDX id (acceptCs id
                      Curry_AbstractHaskell.C_TVar)) x8 s1 cd cs)
                    x10 = Curry_Prelude.nd_C_apply (wrapDX id (d_C_newVars cd
                      cs)) (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString
                      "s") (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString
                      "c") Curry_Prelude.OP_List)) s2 cd cs
                    x11 = d_OP_generableInstance_dot_uscore_hash_selFP43_hash_s
                      x10 cd cs
                    x12 = d_OP_generableInstance_dot_uscore_hash_selFP44_hash_c
                      x10 cd cs
                    x13 = Curry_AbstractHaskell.C_Var x11
                    x14 = let s6 = leftSupply s7
                              s5 = rightSupply s7
                      in s6 `seq` (s5 `seq` Curry_Prelude.nd_OP_dollar (wrapDX
                      id Curry_AbstractHaskellGoodies.d_C_list2ac)
                      (let s4 = leftSupply s5
                           s3 = rightSupply s5
                      in s4 `seq` (s3 `seq` Curry_Prelude.nd_C_map
                      (Curry_Prelude.nd_OP_dot (wrapDX id d_C_intc) (wrapDX id
                      (FlatCurry.Curry_Goodies.d_C_consArity cd cs)) s3 cd cs)
                      x7 s4 cd cs)) s6 cd cs)
                    x15 = let s8 = leftSupply s12
                              s11 = rightSupply s12
                      in s8 `seq` (s11 `seq`
                      Curry_AbstractHaskellGoodies.d_C_applyF
                      (Curry_Prelude.nd_C_apply (wrapDX id
                      (Curry_Names.d_C_mkChoicesName cd cs)) x4 s8 cd cs)
                      (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x12)
                      (Curry_Prelude.OP_Cons
                      (Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
                      (Curry_Prelude.toCurryString "freeID") cd cs)
                      (Curry_Prelude.OP_Cons x14 (Curry_Prelude.OP_Cons x13
                      Curry_Prelude.OP_List)) cd cs) (Curry_Prelude.OP_Cons
                      (let s10 = leftSupply s11
                           s9 = rightSupply s11
                      in s10 `seq` (s9 `seq` Curry_Prelude.nd_OP_dollar (wrapDX
                      id Curry_AbstractHaskellGoodies.d_C_list2ac)
                      (Curry_Prelude.nd_C_map (wrapNX id
                      (nd_OP_generableInstance_dot_genCons_dot_208 x13 x12 x2))
                      x7 s9 cd cs) s10 cd cs)) Curry_Prelude.OP_List))) cd cs)
    in d_C__case_413 x1 x9 x15 x12 x11 x8 (Curry_Prelude.d_C_not x1 cd cs) cd
    cs)))))))))
  FlatCurry.Curry_Types.C_TypeSyn x16 x17 x18 x19 -> Curry_Prelude.d_C_error
    (Curry_Prelude.toCurryString "TransTypes.generableInstance") cd cs
  FlatCurry.Curry_Types.Choice_C_TypeDecl d i l r -> narrow d i
    (nd_C_generableInstance x1 x2 l s cd cs) (nd_C_generableInstance x1 x2 r s
    cd cs)
  FlatCurry.Curry_Types.Choices_C_TypeDecl d i xs -> narrows cs d i (\z ->
    nd_C_generableInstance x1 x2 z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_TypeDecl d c e -> guardCons d c
    (nd_C_generableInstance x1 x2 e s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_TypeDecl d info -> failCons d (traceFail
    "TransTypes.generableInstance" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes.generableInstance" (showCons x3))

d_OP_generableInstance_dot_uscore_hash_selFP43_hash_s :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_generableInstance_dot_uscore_hash_selFP43_hash_s x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_411 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_generableInstance_dot_uscore_hash_selFP43_hash_s l cd cs)
    (d_OP_generableInstance_dot_uscore_hash_selFP43_hash_s r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_generableInstance_dot_uscore_hash_selFP43_hash_s z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_generableInstance_dot_uscore_hash_selFP43_hash_s e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.generableInstance._#selFP43#s" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.generableInstance._#selFP43#s"
    (showCons x1))

d_OP_generableInstance_dot_uscore_hash_selFP44_hash_c :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_generableInstance_dot_uscore_hash_selFP44_hash_c x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_409 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_generableInstance_dot_uscore_hash_selFP44_hash_c l cd cs)
    (d_OP_generableInstance_dot_uscore_hash_selFP44_hash_c r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_generableInstance_dot_uscore_hash_selFP44_hash_c z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_generableInstance_dot_uscore_hash_selFP44_hash_c e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.generableInstance._#selFP44#c" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.generableInstance._#selFP44#c"
    (showCons x1))

d_OP_generableInstance_dot_consArgs2gen_dot_208 :: Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr
d_OP_generableInstance_dot_consArgs2gen_dot_208 x1 x2 x3 cd cs =
  Curry_Prelude.d_OP_dollar (Curry_Prelude.d_C_map (Curry_Prelude.d_OP_dot
  (Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
  (Curry_Prelude.toCurryString "generate") cd cs)) (Curry_Prelude.d_C_flip
  (acceptCs (acceptCs id) Curry_Prelude.OP_Cons) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x2) Curry_Prelude.OP_List)) cd cs))
  (d_C_mkSuppList x3 x1 cd cs) cd cs

d_OP_generableInstance_dot_genCons_dot_208 :: Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_ConsHOClass
  -> FlatCurry.Curry_Types.C_ConsDecl -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_OP_generableInstance_dot_genCons_dot_208 x1 x2 x3 x4 cd cs = case x4 of
  FlatCurry.Curry_Types.C_Cons x5 x6 x7 x8 -> d_C__case_407 x5 x3 x6 x2 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Maybe
    (Curry_Classification.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Classification_dot_ConsHOClass
    cd cs) (Curry_FiniteMap.d_C_lookupFM
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs)
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) cd cs) cd cs) x3 x5 cd cs) (Curry_Prelude.C_Just
    Curry_Classification.C_ConsHO) cd cs) cd cs
  FlatCurry.Curry_Types.Choice_C_ConsDecl d i l r -> narrow d i
    (d_OP_generableInstance_dot_genCons_dot_208 x1 x2 x3 l cd cs)
    (d_OP_generableInstance_dot_genCons_dot_208 x1 x2 x3 r cd cs)
  FlatCurry.Curry_Types.Choices_C_ConsDecl d i xs -> narrows cs d i (\z ->
    d_OP_generableInstance_dot_genCons_dot_208 x1 x2 x3 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_ConsDecl d c e -> guardCons d c
    (d_OP_generableInstance_dot_genCons_dot_208 x1 x2 x3 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_ConsDecl d info -> failCons d (traceFail
    "TransTypes.generableInstance.genCons.208" [show x1, show x2, show x3, show
    x4] info)
  _ -> failCons cd (consFail "TransTypes.generableInstance.genCons.208"
    (showCons x4))

nd_OP_generableInstance_dot_genCons_dot_208 :: Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_ConsHOClass
  -> FlatCurry.Curry_Types.C_ConsDecl -> IDSupply -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
nd_OP_generableInstance_dot_genCons_dot_208 x1 x2 x3 x4 s cd cs = case x4 of
  FlatCurry.Curry_Types.C_Cons x5 x6 x7 x8 -> let s16 = s
    in s16 `seq` (let s15 = leftSupply s16
                      s13 = rightSupply s16
    in s15 `seq` (s13 `seq` nd_C__case_407 x5 x3 x6 x2 x1 (let s12 = leftSupply
                                                                 s13
                                                               s14 = rightSupply
                                                                 s13
                                                               s0 = leftSupply
                                                                 s14
                                                               s11 = rightSupply
                                                                 s14
    in s12 `seq` (s14 `seq` (s0 `seq` (s11 `seq`
    Curry_Prelude.nd_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Maybe
    (Curry_Classification.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Classification_dot_ConsHOClass
    s0 cd cs) (let s10 = leftSupply s11
                   s8 = rightSupply s11
    in s10 `seq` (s8 `seq` Curry_FiniteMap.nd_C_lookupFM (let s7 = leftSupply s8
                                                              s9 = rightSupply
                                                                s8
                                                              s3 = leftSupply s9
                                                              s6 = rightSupply
                                                                s9
    in s7 `seq` (s9 `seq` (s3 `seq` (s6 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
    (let s2 = leftSupply s3
         s1 = rightSupply s3
    in s2 `seq` (s1 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    s1 cd cs) s2 cd cs)) (let s5 = leftSupply s6
                              s4 = rightSupply s6
    in s5 `seq` (s4 `seq`
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    s4 cd cs) s5 cd cs)) s7 cd cs)))) x3 x5 s10 cd cs)) (Curry_Prelude.C_Just
    Curry_Classification.C_ConsHO) s12 cd cs)))) s15 cd cs))
  FlatCurry.Curry_Types.Choice_C_ConsDecl d i l r -> narrow d i
    (nd_OP_generableInstance_dot_genCons_dot_208 x1 x2 x3 l s cd cs)
    (nd_OP_generableInstance_dot_genCons_dot_208 x1 x2 x3 r s cd cs)
  FlatCurry.Curry_Types.Choices_C_ConsDecl d i xs -> narrows cs d i (\z ->
    nd_OP_generableInstance_dot_genCons_dot_208 x1 x2 x3 z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_ConsDecl d c e -> guardCons d c
    (nd_OP_generableInstance_dot_genCons_dot_208 x1 x2 x3 e s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_ConsDecl d info -> failCons d (traceFail
    "TransTypes.generableInstance.genCons.208" [show x1, show x2, show x3, show
    x4] info)
  _ -> failCons cd (consFail "TransTypes.generableInstance.genCons.208"
    (showCons x4))

d_C_normalformInstance :: Curry_Prelude.C_Bool -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass -> FlatCurry.Curry_Types.C_TypeDecl
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeDecl
d_C_normalformInstance x1 x2 x3 cd cs = case x3 of
  FlatCurry.Curry_Types.C_Type x4 x5 x6 x7 -> let x8 = Curry_Prelude.d_C_map
                                                    d_C_fcy2absTVar x6 cd cs
                                                  x9 = Curry_AbstractHaskell.C_TCons
                                                    x4 (Curry_Prelude.d_C_map
                                                    (acceptCs id
                                                    Curry_AbstractHaskell.C_TVar)
                                                    x8 cd cs)
    in d_C__case_405 x1 x9 x4 x7 x2 x8 (Curry_Prelude.d_C_not x1 cd cs) cd cs
  FlatCurry.Curry_Types.C_TypeSyn x10 x11 x12 x13 -> Curry_Prelude.d_C_error
    (Curry_Prelude.toCurryString "TransTypes.normalformInstance") cd cs
  FlatCurry.Curry_Types.Choice_C_TypeDecl d i l r -> narrow d i
    (d_C_normalformInstance x1 x2 l cd cs) (d_C_normalformInstance x1 x2 r cd
    cs)
  FlatCurry.Curry_Types.Choices_C_TypeDecl d i xs -> narrows cs d i (\z ->
    d_C_normalformInstance x1 x2 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_TypeDecl d c e -> guardCons d c
    (d_C_normalformInstance x1 x2 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_TypeDecl d info -> failCons d (traceFail
    "TransTypes.normalformInstance" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes.normalformInstance" (showCons x3))

nd_C_normalformInstance :: Curry_Prelude.C_Bool -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass -> FlatCurry.Curry_Types.C_TypeDecl
  -> IDSupply -> Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeDecl
nd_C_normalformInstance x1 x2 x3 s cd cs = case x3 of
  FlatCurry.Curry_Types.C_Type x4 x5 x6 x7 -> let s3 = s
    in s3 `seq` (let s0 = leftSupply s3
                     s4 = rightSupply s3
                     s1 = leftSupply s4
                     s2 = rightSupply s4
    in s0 `seq` (s4 `seq` (s1 `seq` (s2 `seq` (let x8 = Curry_Prelude.nd_C_map
                                                     (wrapDX id d_C_fcy2absTVar)
                                                     x6 s0 cd cs
                                                   x9 = Curry_AbstractHaskell.C_TCons
                                                     x4 (Curry_Prelude.nd_C_map
                                                     (wrapDX id (acceptCs id
                                                     Curry_AbstractHaskell.C_TVar))
                                                     x8 s1 cd cs)
    in nd_C__case_405 x1 x9 x4 x7 x2 x8 (Curry_Prelude.d_C_not x1 cd cs) s2 cd
    cs)))))
  FlatCurry.Curry_Types.C_TypeSyn x10 x11 x12 x13 -> Curry_Prelude.d_C_error
    (Curry_Prelude.toCurryString "TransTypes.normalformInstance") cd cs
  FlatCurry.Curry_Types.Choice_C_TypeDecl d i l r -> narrow d i
    (nd_C_normalformInstance x1 x2 l s cd cs) (nd_C_normalformInstance x1 x2 r s
    cd cs)
  FlatCurry.Curry_Types.Choices_C_TypeDecl d i xs -> narrows cs d i (\z ->
    nd_C_normalformInstance x1 x2 z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_TypeDecl d c e -> guardCons d c
    (nd_C_normalformInstance x1 x2 e s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_TypeDecl d info -> failCons d (traceFail
    "TransTypes.normalformInstance" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes.normalformInstance" (showCons x3))

d_C_normalformConsRule :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_ConsHOClass
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> FlatCurry.Curry_Types.C_ConsDecl -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
d_C_normalformConsRule x1 x2 x3 cd cs = case x3 of
  FlatCurry.Curry_Types.C_Cons x4 x5 x6 x7 -> let x8 = Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Maybe
                                                    (Curry_Classification.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Classification_dot_ConsHOClass
                                                    cd cs)
                                                    (Curry_FiniteMap.d_C_lookupFM
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                                    cd cs) cd cs)
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                                    cd cs) cd cs) cd cs) x1 x4
                                                    cd cs) (Curry_Prelude.C_Just
                                                    Curry_Classification.C_ConsHO)
                                                    cd cs
                                                  x9 = Curry_Prelude.d_C_length
                                                    x7 cd cs
                                                  x10 = Curry_Prelude.OP_Cons
                                                    (Curry_AbstractHaskell.C_PVar
                                                    (Curry_Prelude.OP_Tuple2
                                                    (Curry_Prelude.C_Int (4))
                                                    (Curry_Prelude.toCurryString
                                                    "d")))
                                                    (Curry_Prelude.OP_Cons
                                                    (Curry_AbstractHaskell.C_PVar
                                                    (Curry_Prelude.OP_Tuple2
                                                    (Curry_Prelude.C_Int (3))
                                                    (Curry_Prelude.toCurryString
                                                    "cs")))
                                                    Curry_Prelude.OP_List)
                                                  x11 = Curry_Prelude.OP_Cons
                                                    (Curry_AbstractHaskell.C_Var
                                                    (Curry_Prelude.OP_Tuple2
                                                    (Curry_Prelude.C_Int (4))
                                                    (Curry_Prelude.toCurryString
                                                    "d")))
                                                    (Curry_Prelude.OP_Cons
                                                    (Curry_AbstractHaskell.C_Var
                                                    (Curry_Prelude.OP_Tuple2
                                                    (Curry_Prelude.C_Int (3))
                                                    (Curry_Prelude.toCurryString
                                                    "cs")))
                                                    Curry_Prelude.OP_List)
    in d_C__case_403 x4 x2 x10 x11 x9 x8 cd cs
  FlatCurry.Curry_Types.Choice_C_ConsDecl d i l r -> narrow d i
    (d_C_normalformConsRule x1 x2 l cd cs) (d_C_normalformConsRule x1 x2 r cd
    cs)
  FlatCurry.Curry_Types.Choices_C_ConsDecl d i xs -> narrows cs d i (\z ->
    d_C_normalformConsRule x1 x2 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_ConsDecl d c e -> guardCons d c
    (d_C_normalformConsRule x1 x2 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_ConsDecl d info -> failCons d (traceFail
    "TransTypes.normalformConsRule" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes.normalformConsRule" (showCons x3))

nd_C_normalformConsRule :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_ConsHOClass
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> FlatCurry.Curry_Types.C_ConsDecl -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
nd_C_normalformConsRule x1 x2 x3 s cd cs = case x3 of
  FlatCurry.Curry_Types.C_Cons x4 x5 x6 x7 -> let s13 = s
    in s13 `seq` (let x8 = let s12 = leftSupply s13
                               s14 = rightSupply s13
                               s0 = leftSupply s14
                               s11 = rightSupply s14
                        in s12 `seq` (s14 `seq` (s0 `seq` (s11 `seq`
                        Curry_Prelude.nd_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Maybe
                        (Curry_Classification.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Classification_dot_ConsHOClass
                        s0 cd cs) (let s10 = leftSupply s11
                                       s8 = rightSupply s11
                        in s10 `seq` (s8 `seq` Curry_FiniteMap.nd_C_lookupFM
                        (let s7 = leftSupply s8
                             s9 = rightSupply s8
                             s3 = leftSupply s9
                             s6 = rightSupply s9
                        in s7 `seq` (s9 `seq` (s3 `seq` (s6 `seq`
                        Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                        (let s2 = leftSupply s3
                             s1 = rightSupply s3
                        in s2 `seq` (s1 `seq`
                        Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                        (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                        s1 cd cs) s2 cd cs)) (let s5 = leftSupply s6
                                                  s4 = rightSupply s6
                        in s5 `seq` (s4 `seq`
                        Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                        (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                        s4 cd cs) s5 cd cs)) s7 cd cs)))) x1 x4 s10 cd cs))
                        (Curry_Prelude.C_Just Curry_Classification.C_ConsHO) s12
                        cd cs)))
                      x9 = Curry_Prelude.d_C_length x7 cd cs
                      x10 = Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_PVar
                        (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int (4))
                        (Curry_Prelude.toCurryString "d")))
                        (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_PVar
                        (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int (3))
                        (Curry_Prelude.toCurryString "cs")))
                        Curry_Prelude.OP_List)
                      x11 = Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var
                        (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int (4))
                        (Curry_Prelude.toCurryString "d")))
                        (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var
                        (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int (3))
                        (Curry_Prelude.toCurryString "cs")))
                        Curry_Prelude.OP_List)
    in d_C__case_403 x4 x2 x10 x11 x9 x8 cd cs)
  FlatCurry.Curry_Types.Choice_C_ConsDecl d i l r -> narrow d i
    (nd_C_normalformConsRule x1 x2 l s cd cs) (nd_C_normalformConsRule x1 x2 r s
    cd cs)
  FlatCurry.Curry_Types.Choices_C_ConsDecl d i xs -> narrows cs d i (\z ->
    nd_C_normalformConsRule x1 x2 z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_ConsDecl d c e -> guardCons d c
    (nd_C_normalformConsRule x1 x2 e s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_ConsDecl d info -> failCons d (traceFail
    "TransTypes.normalformConsRule" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes.normalformConsRule" (showCons x3))

d_OP_normalformConsRule_dot_nfBody_dot_237 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Pattern -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_OP_normalformConsRule_dot_nfBody_dot_237 x1 x2 x3 x4 x5 cd cs =
  Curry_Prelude.d_C_foldr (acceptCs id
  (d_OP_normalformConsRule_dot_nfBody_dot_237_dot_uscore_hash_lambda25 x2 x3
  x4)) (Curry_AbstractHaskellGoodies.d_C_applyV (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.C_Int (1)) (Curry_Prelude.toCurryString "cont"))
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskellGoodies.d_C_applyF x5 (Curry_Prelude.d_C_map
  d_OP_normalformConsRule_dot_nfBody_dot_237_dot_uscore_hash_lambda26
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_enumFromTo_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
  cd cs) (Curry_Prelude.C_Int (1)) cd cs) x1 cd cs) cd cs) cd cs)
  Curry_Prelude.OP_List) x2 cd cs) cd cs) (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_enumFromTo_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
  cd cs) (Curry_Prelude.C_Int (1)) cd cs) x1 cd cs) cd cs

d_OP_normalformConsRule_dot_nfBody_dot_237_dot_uscore_hash_lambda25 :: Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Pattern -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Int -> Curry_AbstractHaskell.C_Expr
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_OP_normalformConsRule_dot_nfBody_dot_237_dot_uscore_hash_lambda25 x1 x2 x3 x4 x5 cd cs =
  Curry_AbstractHaskellGoodies.d_C_applyF x3 (Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Lambda
  (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar (Curry_Prelude.OP_Tuple2 x4
  (Curry_Prelude.OP_Cons (Curry_Prelude.C_Char 'y'#) (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Int
  cd cs) x4 cd cs)))) Curry_Prelude.OP_List) x2 cd cs) x5)
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var (Curry_Prelude.OP_Tuple2
  x4 (Curry_Prelude.OP_Cons (Curry_Prelude.C_Char 'x'#) (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Int
  cd cs) x4 cd cs)))) Curry_Prelude.OP_List)) x1 cd cs) cd cs

d_OP_normalformConsRule_dot_nfBody_dot_237_dot_uscore_hash_lambda26 :: Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_OP_normalformConsRule_dot_nfBody_dot_237_dot_uscore_hash_lambda26 x1 cd cs =
  Curry_AbstractHaskell.C_Var (Curry_Prelude.OP_Tuple2 x1 (Curry_Prelude.OP_Cons
  (Curry_Prelude.C_Char 'y'#) (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Int
  cd cs) x1 cd cs)))

d_OP_normalformConsRule_dot_rule_dot_237 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Pattern -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule
d_OP_normalformConsRule_dot_rule_dot_237 x1 x2 x3 x4 x5 cd cs =
  Curry_Prelude.OP_Tuple2 x4 (d_C_simpleRule (Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_PVar (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.C_Int (1)) (Curry_Prelude.toCurryString "cont")))
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_PComb x5
  (Curry_Prelude.d_C_map
  d_OP_normalformConsRule_dot_rule_dot_237_dot_uscore_hash_lambda24
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_enumFromTo_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
  cd cs) (Curry_Prelude.C_Int (1)) cd cs) x1 cd cs) cd cs))
  Curry_Prelude.OP_List)) x3 cd cs) (d_OP_normalformConsRule_dot_nfBody_dot_237
  x1 x2 x3 x4 x5 cd cs) cd cs)

d_OP_normalformConsRule_dot_rule_dot_237_dot_uscore_hash_lambda24 :: Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Pattern
d_OP_normalformConsRule_dot_rule_dot_237_dot_uscore_hash_lambda24 x1 cd cs =
  Curry_AbstractHaskell.C_PVar (Curry_Prelude.OP_Tuple2 x1
  (Curry_Prelude.OP_Cons (Curry_Prelude.C_Char 'x'#) (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Int
  cd cs) x1 cd cs)))

d_C_normalFormExtConsRules :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
d_C_normalFormExtConsRules x1 x2 x3 x4 cd cs = let x5 = Curry_Prelude.d_C_apply
                                                     (d_C_newVars cd cs)
                                                     (Curry_Prelude.OP_Cons
                                                     (Curry_Prelude.toCurryString
                                                     "d") (Curry_Prelude.OP_Cons
                                                     (Curry_Prelude.toCurryString
                                                     "info")
                                                     (Curry_Prelude.OP_Cons
                                                     (Curry_Prelude.toCurryString
                                                     "c") (Curry_Prelude.OP_Cons
                                                     (Curry_Prelude.toCurryString
                                                     "cs")
                                                     (Curry_Prelude.OP_Cons
                                                     (Curry_Prelude.toCurryString
                                                     "cd")
                                                     (Curry_Prelude.OP_Cons
                                                     (Curry_Prelude.toCurryString
                                                     "cont")
                                                     (Curry_Prelude.OP_Cons
                                                     (Curry_Prelude.toCurryString
                                                     "i") (Curry_Prelude.OP_Cons
                                                     (Curry_Prelude.toCurryString
                                                     "x") (Curry_Prelude.OP_Cons
                                                     (Curry_Prelude.toCurryString
                                                     "y") (Curry_Prelude.OP_Cons
                                                     (Curry_Prelude.toCurryString
                                                     "e") (Curry_Prelude.OP_Cons
                                                     (Curry_Prelude.toCurryString
                                                     "xs")
                                                     (Curry_Prelude.OP_Cons
                                                     (Curry_Prelude.toCurryString
                                                     "_")
                                                     Curry_Prelude.OP_List))))))))))))
                                                     cd cs
                                                   x6 = d_OP_normalFormExtConsRules_dot_uscore_hash_selFP46_hash_d
                                                     x5 cd cs
                                                   x7 = d_OP_normalFormExtConsRules_dot_uscore_hash_selFP47_hash_info
                                                     x5 cd cs
                                                   x8 = d_OP_normalFormExtConsRules_dot_uscore_hash_selFP48_hash_c
                                                     x5 cd cs
                                                   x9 = d_OP_normalFormExtConsRules_dot_uscore_hash_selFP49_hash_cs
                                                     x5 cd cs
                                                   x10 = d_OP_normalFormExtConsRules_dot_uscore_hash_selFP50_hash_cd
                                                     x5 cd cs
                                                   x11 = d_OP_normalFormExtConsRules_dot_uscore_hash_selFP51_hash_cont
                                                     x5 cd cs
                                                   x12 = d_OP_normalFormExtConsRules_dot_uscore_hash_selFP52_hash_i
                                                     x5 cd cs
                                                   x13 = d_OP_normalFormExtConsRules_dot_uscore_hash_selFP53_hash_x
                                                     x5 cd cs
                                                   x14 = d_OP_normalFormExtConsRules_dot_uscore_hash_selFP54_hash_y
                                                     x5 cd cs
                                                   x15 = d_OP_normalFormExtConsRules_dot_uscore_hash_selFP55_hash_e
                                                     x5 cd cs
                                                   x16 = d_OP_normalFormExtConsRules_dot_uscore_hash_selFP56_hash_xs
                                                     x5 cd cs
                                                   x17 = d_OP_normalFormExtConsRules_dot_uscore_hash_selFP57_hash_us
                                                     x5 cd cs
  in Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple2 x2 (d_C_simpleRule
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_PVar x11)
  (Curry_Prelude.OP_Cons (d_C_mkChoicePattern x1 (Curry_Prelude.toCurryString
  "i") cd cs) (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_PVar x6)
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_PVar x9)
  Curry_Prelude.OP_List)))) (Curry_AbstractHaskellGoodies.d_C_applyF x3
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x11)
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x10)
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x12)
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x13)
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x14)
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x10)
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x9)
  Curry_Prelude.OP_List))))))) cd cs) cd cs)) (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 x2 (d_C_simpleRule (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x11) (Curry_Prelude.OP_Cons
  (d_C_mkChoicesPattern x1 cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x6) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x9) Curry_Prelude.OP_List))))
  (Curry_AbstractHaskellGoodies.d_C_applyF x4 (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x11) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x10) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x12) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x16) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x6) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x9) Curry_Prelude.OP_List)))))) cd cs) cd cs))
  (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple2 x2 (d_C_simpleRule
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_PVar x11)
  (Curry_Prelude.OP_Cons (d_C_mkGuardPattern x1 cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x6) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x9) Curry_Prelude.OP_List))))
  (Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
  (Curry_Prelude.toCurryString "guardCons") cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x10) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x8) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskellGoodies.d_C_applyF x2 (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x11) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x15) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x6) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
  (Curry_Prelude.toCurryString "addCs") cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x8) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x9) Curry_Prelude.OP_List)) cd cs)
  Curry_Prelude.OP_List)))) cd cs) Curry_Prelude.OP_List))) cd cs) cd cs))
  (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple2 x2 (d_C_simpleRule
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_PVar x17)
  (Curry_Prelude.OP_Cons (d_C_mkFailPattern x1 cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x17) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x17) Curry_Prelude.OP_List))))
  (Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
  (Curry_Prelude.toCurryString "failCons") cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x10) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x7) Curry_Prelude.OP_List)) cd cs) cd cs))
  Curry_Prelude.OP_List)))

d_OP_normalFormExtConsRules_dot_uscore_hash_selFP46_hash_d :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_normalFormExtConsRules_dot_uscore_hash_selFP46_hash_d x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_401 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP46_hash_d l cd cs)
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP46_hash_d r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_normalFormExtConsRules_dot_uscore_hash_selFP46_hash_d z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP46_hash_d e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.normalFormExtConsRules._#selFP46#d" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.normalFormExtConsRules._#selFP46#d"
    (showCons x1))

d_OP_normalFormExtConsRules_dot_uscore_hash_selFP47_hash_info :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_normalFormExtConsRules_dot_uscore_hash_selFP47_hash_info x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_389 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP47_hash_info l cd cs)
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP47_hash_info r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_normalFormExtConsRules_dot_uscore_hash_selFP47_hash_info z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP47_hash_info e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.normalFormExtConsRules._#selFP47#info" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.normalFormExtConsRules._#selFP47#info"
    (showCons x1))

d_OP_normalFormExtConsRules_dot_uscore_hash_selFP48_hash_c :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_normalFormExtConsRules_dot_uscore_hash_selFP48_hash_c x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_377 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP48_hash_c l cd cs)
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP48_hash_c r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_normalFormExtConsRules_dot_uscore_hash_selFP48_hash_c z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP48_hash_c e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.normalFormExtConsRules._#selFP48#c" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.normalFormExtConsRules._#selFP48#c"
    (showCons x1))

d_OP_normalFormExtConsRules_dot_uscore_hash_selFP49_hash_cs :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_normalFormExtConsRules_dot_uscore_hash_selFP49_hash_cs x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_365 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP49_hash_cs l cd cs)
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP49_hash_cs r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_normalFormExtConsRules_dot_uscore_hash_selFP49_hash_cs z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP49_hash_cs e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.normalFormExtConsRules._#selFP49#cs" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.normalFormExtConsRules._#selFP49#cs"
    (showCons x1))

d_OP_normalFormExtConsRules_dot_uscore_hash_selFP50_hash_cd :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_normalFormExtConsRules_dot_uscore_hash_selFP50_hash_cd x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_353 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP50_hash_cd l cd cs)
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP50_hash_cd r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_normalFormExtConsRules_dot_uscore_hash_selFP50_hash_cd z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP50_hash_cd e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.normalFormExtConsRules._#selFP50#cd" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.normalFormExtConsRules._#selFP50#cd"
    (showCons x1))

d_OP_normalFormExtConsRules_dot_uscore_hash_selFP51_hash_cont :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_normalFormExtConsRules_dot_uscore_hash_selFP51_hash_cont x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_341 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP51_hash_cont l cd cs)
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP51_hash_cont r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_normalFormExtConsRules_dot_uscore_hash_selFP51_hash_cont z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP51_hash_cont e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.normalFormExtConsRules._#selFP51#cont" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.normalFormExtConsRules._#selFP51#cont"
    (showCons x1))

d_OP_normalFormExtConsRules_dot_uscore_hash_selFP52_hash_i :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_normalFormExtConsRules_dot_uscore_hash_selFP52_hash_i x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_329 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP52_hash_i l cd cs)
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP52_hash_i r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_normalFormExtConsRules_dot_uscore_hash_selFP52_hash_i z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP52_hash_i e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.normalFormExtConsRules._#selFP52#i" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.normalFormExtConsRules._#selFP52#i"
    (showCons x1))

d_OP_normalFormExtConsRules_dot_uscore_hash_selFP53_hash_x :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_normalFormExtConsRules_dot_uscore_hash_selFP53_hash_x x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_317 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP53_hash_x l cd cs)
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP53_hash_x r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_normalFormExtConsRules_dot_uscore_hash_selFP53_hash_x z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP53_hash_x e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.normalFormExtConsRules._#selFP53#x" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.normalFormExtConsRules._#selFP53#x"
    (showCons x1))

d_OP_normalFormExtConsRules_dot_uscore_hash_selFP54_hash_y :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_normalFormExtConsRules_dot_uscore_hash_selFP54_hash_y x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_305 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP54_hash_y l cd cs)
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP54_hash_y r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_normalFormExtConsRules_dot_uscore_hash_selFP54_hash_y z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP54_hash_y e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.normalFormExtConsRules._#selFP54#y" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.normalFormExtConsRules._#selFP54#y"
    (showCons x1))

d_OP_normalFormExtConsRules_dot_uscore_hash_selFP55_hash_e :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_normalFormExtConsRules_dot_uscore_hash_selFP55_hash_e x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_293 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP55_hash_e l cd cs)
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP55_hash_e r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_normalFormExtConsRules_dot_uscore_hash_selFP55_hash_e z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP55_hash_e e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.normalFormExtConsRules._#selFP55#e" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.normalFormExtConsRules._#selFP55#e"
    (showCons x1))

d_OP_normalFormExtConsRules_dot_uscore_hash_selFP56_hash_xs :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_normalFormExtConsRules_dot_uscore_hash_selFP56_hash_xs x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_281 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP56_hash_xs l cd cs)
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP56_hash_xs r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_normalFormExtConsRules_dot_uscore_hash_selFP56_hash_xs z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP56_hash_xs e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.normalFormExtConsRules._#selFP56#xs" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.normalFormExtConsRules._#selFP56#xs"
    (showCons x1))

d_OP_normalFormExtConsRules_dot_uscore_hash_selFP57_hash_us :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_normalFormExtConsRules_dot_uscore_hash_selFP57_hash_us x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_269 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP57_hash_us l cd cs)
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP57_hash_us r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_normalFormExtConsRules_dot_uscore_hash_selFP57_hash_us z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_normalFormExtConsRules_dot_uscore_hash_selFP57_hash_us e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.normalFormExtConsRules._#selFP57#us" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.normalFormExtConsRules._#selFP57#us"
    (showCons x1))

d_C_showConsConsRule :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_ConsHOClass
  -> FlatCurry.Curry_Types.C_ConsDecl -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
d_C_showConsConsRule x1 x2 cd cs = case x2 of
  FlatCurry.Curry_Types.C_Cons x3 x4 x5 x6 -> let x7 = Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Maybe
                                                    (Curry_Classification.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Classification_dot_ConsHOClass
                                                    cd cs)
                                                    (Curry_FiniteMap.d_C_lookupFM
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                                    cd cs) cd cs)
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                                    cd cs) cd cs) cd cs) x1 x3
                                                    cd cs) (Curry_Prelude.C_Just
                                                    Curry_Classification.C_ConsHO)
                                                    cd cs
    in d_C__case_257 x3 x4 x7 cd cs
  FlatCurry.Curry_Types.Choice_C_ConsDecl d i l r -> narrow d i
    (d_C_showConsConsRule x1 l cd cs) (d_C_showConsConsRule x1 r cd cs)
  FlatCurry.Curry_Types.Choices_C_ConsDecl d i xs -> narrows cs d i (\z ->
    d_C_showConsConsRule x1 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_ConsDecl d c e -> guardCons d c
    (d_C_showConsConsRule x1 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_ConsDecl d info -> failCons d (traceFail
    "TransTypes.showConsConsRule" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransTypes.showConsConsRule" (showCons x2))

nd_C_showConsConsRule :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_ConsHOClass
  -> FlatCurry.Curry_Types.C_ConsDecl -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
nd_C_showConsConsRule x1 x2 s cd cs = case x2 of
  FlatCurry.Curry_Types.C_Cons x3 x4 x5 x6 -> let s13 = s
    in s13 `seq` (let x7 = let s12 = leftSupply s13
                               s14 = rightSupply s13
                               s0 = leftSupply s14
                               s11 = rightSupply s14
                        in s12 `seq` (s14 `seq` (s0 `seq` (s11 `seq`
                        Curry_Prelude.nd_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Maybe
                        (Curry_Classification.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Classification_dot_ConsHOClass
                        s0 cd cs) (let s10 = leftSupply s11
                                       s8 = rightSupply s11
                        in s10 `seq` (s8 `seq` Curry_FiniteMap.nd_C_lookupFM
                        (let s7 = leftSupply s8
                             s9 = rightSupply s8
                             s3 = leftSupply s9
                             s6 = rightSupply s9
                        in s7 `seq` (s9 `seq` (s3 `seq` (s6 `seq`
                        Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                        (let s2 = leftSupply s3
                             s1 = rightSupply s3
                        in s2 `seq` (s1 `seq`
                        Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                        (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                        s1 cd cs) s2 cd cs)) (let s5 = leftSupply s6
                                                  s4 = rightSupply s6
                        in s5 `seq` (s4 `seq`
                        Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                        (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                        s4 cd cs) s5 cd cs)) s7 cd cs)))) x1 x3 s10 cd cs))
                        (Curry_Prelude.C_Just Curry_Classification.C_ConsHO) s12
                        cd cs)))
    in d_C__case_257 x3 x4 x7 cd cs)
  FlatCurry.Curry_Types.Choice_C_ConsDecl d i l r -> narrow d i
    (nd_C_showConsConsRule x1 l s cd cs) (nd_C_showConsConsRule x1 r s cd cs)
  FlatCurry.Curry_Types.Choices_C_ConsDecl d i xs -> narrows cs d i (\z ->
    nd_C_showConsConsRule x1 z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_ConsDecl d c e -> guardCons d c
    (nd_C_showConsConsRule x1 e s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_ConsDecl d info -> failCons d (traceFail
    "TransTypes.showConsConsRule" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransTypes.showConsConsRule" (showCons x2))

d_OP_showConsConsRule_dot_rule_dot_255 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_AbstractHaskell.C_Rule
d_OP_showConsConsRule_dot_rule_dot_255 x1 x2 cd cs = Curry_Prelude.OP_Tuple2
  (d_C_basics (Curry_Prelude.toCurryString "showCons") cd cs) (d_C_simpleRule
  (Curry_Prelude.OP_Cons (d_C_consPattern x2 (Curry_Prelude.toCurryString "_")
  x1 cd cs) Curry_Prelude.OP_List) (Curry_Prelude.d_OP_dollar
  (Curry_AbstractHaskellGoodies.d_C_string2ac cd cs) (Curry_Prelude.d_OP_dollar
  (Curry_List.d_C_intercalate (Curry_Prelude.toCurryString " "))
  (Curry_Prelude.OP_Cons (d_C_showQName (Curry_Prelude.d_C_apply
  (Curry_Names.d_C_unRenameQName cd cs) x2 cd cs) cd cs)
  (Curry_Prelude.d_C_replicate x1 (Curry_Prelude.toCurryString "_") cd cs)) cd
  cs) cd cs) cd cs)

d_C_showConsCatchRule :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule
d_C_showConsCatchRule x1 cd cs = let x2 = Curry_Prelude.d_C_apply (d_C_newVars
                                       cd cs) (Curry_Prelude.OP_Cons
                                       (Curry_Prelude.toCurryString "x")
                                       Curry_Prelude.OP_List) cd cs
                                     x3 = d_OP_showConsCatchRule_dot_uscore_hash_selFP59_hash_x
                                       x2 cd cs
  in Curry_Prelude.OP_Tuple2 (d_C_basics (Curry_Prelude.toCurryString
  "showCons") cd cs) (d_C_simpleRule (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x3) Curry_Prelude.OP_List)
  (Curry_AbstractHaskellGoodies.d_C_applyF (Curry_AbstractHaskellGoodies.d_C_pre
  (Curry_Prelude.toCurryString "error") cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_InfixApply (Curry_Prelude.d_C_apply
  (Curry_AbstractHaskellGoodies.d_C_string2ac cd cs)
  (Curry_Prelude.d_OP_plus_plus (d_C_showQName (Curry_Prelude.d_C_apply
  (Curry_Names.d_C_unRenameQName cd cs) x1 cd cs) cd cs)
  (Curry_Prelude.toCurryString ".showCons: no constructor: ") cd cs) cd cs)
  (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString "++") cd
  cs) (Curry_AbstractHaskellGoodies.d_C_applyF
  (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString "show") cd
  cs) (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x3)
  Curry_Prelude.OP_List) cd cs)) Curry_Prelude.OP_List) cd cs) cd cs)

d_OP_showConsCatchRule_dot_uscore_hash_selFP59_hash_x :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_showConsCatchRule_dot_uscore_hash_selFP59_hash_x x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_255 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_showConsCatchRule_dot_uscore_hash_selFP59_hash_x l cd cs)
    (d_OP_showConsCatchRule_dot_uscore_hash_selFP59_hash_x r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_showConsCatchRule_dot_uscore_hash_selFP59_hash_x z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_showConsCatchRule_dot_uscore_hash_selFP59_hash_x e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.showConsCatchRule._#selFP59#x" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.showConsCatchRule._#selFP59#x"
    (showCons x1))

d_C_searchNFConsRule :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_ConsHOClass
  -> FlatCurry.Curry_Types.C_ConsDecl -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
d_C_searchNFConsRule x1 x2 cd cs = case x2 of
  FlatCurry.Curry_Types.C_Cons x3 x4 x5 x6 -> let x7 = Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Maybe
                                                    (Curry_Classification.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Classification_dot_ConsHOClass
                                                    cd cs)
                                                    (Curry_FiniteMap.d_C_lookupFM
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                                    cd cs) cd cs)
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                                    cd cs) cd cs) cd cs) x1 x3
                                                    cd cs) (Curry_Prelude.C_Just
                                                    Curry_Classification.C_ConsHO)
                                                    cd cs
                                                  x8 = Curry_Prelude.d_C_apply
                                                    (d_C_newVars cd cs)
                                                    (Curry_Prelude.OP_Cons
                                                    (Curry_Prelude.toCurryString
                                                    "search")
                                                    (Curry_Prelude.OP_Cons
                                                    (Curry_Prelude.toCurryString
                                                    "cont")
                                                    (Curry_Prelude.OP_Cons
                                                    (Curry_Prelude.toCurryString
                                                    "_")
                                                    Curry_Prelude.OP_List))) cd
                                                    cs
                                                  x9 = d_OP_searchNFConsRule_dot_uscore_hash_selFP61_hash_search
                                                    x8 cd cs
                                                  x10 = d_OP_searchNFConsRule_dot_uscore_hash_selFP62_hash_cont
                                                    x8 cd cs
                                                  x11 = d_OP_searchNFConsRule_dot_uscore_hash_selFP63_hash_us
                                                    x8 cd cs
                                                  x12 = d_C__case_252 x4 x9 x11
                                                    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
                                                    x4 (Curry_Prelude.C_Int (0))
                                                    cd cs) cd cs
    in d_C__case_254 x3 x9 x12 x10 x4 x7 cd cs
  FlatCurry.Curry_Types.Choice_C_ConsDecl d i l r -> narrow d i
    (d_C_searchNFConsRule x1 l cd cs) (d_C_searchNFConsRule x1 r cd cs)
  FlatCurry.Curry_Types.Choices_C_ConsDecl d i xs -> narrows cs d i (\z ->
    d_C_searchNFConsRule x1 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_ConsDecl d c e -> guardCons d c
    (d_C_searchNFConsRule x1 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_ConsDecl d info -> failCons d (traceFail
    "TransTypes.searchNFConsRule" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransTypes.searchNFConsRule" (showCons x2))

nd_C_searchNFConsRule :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_ConsHOClass
  -> FlatCurry.Curry_Types.C_ConsDecl -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
nd_C_searchNFConsRule x1 x2 s cd cs = case x2 of
  FlatCurry.Curry_Types.C_Cons x3 x4 x5 x6 -> let s16 = s
    in s16 `seq` (let s13 = leftSupply s16
                      s15 = rightSupply s16
    in s13 `seq` (s15 `seq` (let x7 = let s12 = leftSupply s13
                                          s14 = rightSupply s13
                                          s0 = leftSupply s14
                                          s11 = rightSupply s14
                                   in s12 `seq` (s14 `seq` (s0 `seq` (s11 `seq`
                                   Curry_Prelude.nd_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Maybe
                                   (Curry_Classification.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Classification_dot_ConsHOClass
                                   s0 cd cs) (let s10 = leftSupply s11
                                                  s8 = rightSupply s11
                                   in s10 `seq` (s8 `seq`
                                   Curry_FiniteMap.nd_C_lookupFM
                                   (let s7 = leftSupply s8
                                        s9 = rightSupply s8
                                        s3 = leftSupply s9
                                        s6 = rightSupply s9
                                   in s7 `seq` (s9 `seq` (s3 `seq` (s6 `seq`
                                   Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                                   (let s2 = leftSupply s3
                                        s1 = rightSupply s3
                                   in s2 `seq` (s1 `seq`
                                   Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                   (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                   s1 cd cs) s2 cd cs)) (let s5 = leftSupply s6
                                                             s4 = rightSupply s6
                                   in s5 `seq` (s4 `seq`
                                   Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                   (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                   s4 cd cs) s5 cd cs)) s7 cd cs)))) x1 x3 s10
                                   cd cs)) (Curry_Prelude.C_Just
                                   Curry_Classification.C_ConsHO) s12 cd cs)))
                                 x8 = Curry_Prelude.nd_C_apply (wrapDX id
                                   (d_C_newVars cd cs)) (Curry_Prelude.OP_Cons
                                   (Curry_Prelude.toCurryString "search")
                                   (Curry_Prelude.OP_Cons
                                   (Curry_Prelude.toCurryString "cont")
                                   (Curry_Prelude.OP_Cons
                                   (Curry_Prelude.toCurryString "_")
                                   Curry_Prelude.OP_List))) s15 cd cs
                                 x9 = d_OP_searchNFConsRule_dot_uscore_hash_selFP61_hash_search
                                   x8 cd cs
                                 x10 = d_OP_searchNFConsRule_dot_uscore_hash_selFP62_hash_cont
                                   x8 cd cs
                                 x11 = d_OP_searchNFConsRule_dot_uscore_hash_selFP63_hash_us
                                   x8 cd cs
                                 x12 = d_C__case_252 x4 x9 x11
                                   (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
                                   x4 (Curry_Prelude.C_Int (0)) cd cs) cd cs
    in d_C__case_254 x3 x9 x12 x10 x4 x7 cd cs)))
  FlatCurry.Curry_Types.Choice_C_ConsDecl d i l r -> narrow d i
    (nd_C_searchNFConsRule x1 l s cd cs) (nd_C_searchNFConsRule x1 r s cd cs)
  FlatCurry.Curry_Types.Choices_C_ConsDecl d i xs -> narrows cs d i (\z ->
    nd_C_searchNFConsRule x1 z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_ConsDecl d c e -> guardCons d c
    (nd_C_searchNFConsRule x1 e s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_ConsDecl d info -> failCons d (traceFail
    "TransTypes.searchNFConsRule" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransTypes.searchNFConsRule" (showCons x2))

d_OP_searchNFConsRule_dot_uscore_hash_selFP61_hash_search :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_searchNFConsRule_dot_uscore_hash_selFP61_hash_search x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_251 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_searchNFConsRule_dot_uscore_hash_selFP61_hash_search l cd cs)
    (d_OP_searchNFConsRule_dot_uscore_hash_selFP61_hash_search r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_searchNFConsRule_dot_uscore_hash_selFP61_hash_search z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_searchNFConsRule_dot_uscore_hash_selFP61_hash_search e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.searchNFConsRule._#selFP61#search" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.searchNFConsRule._#selFP61#search"
    (showCons x1))

d_OP_searchNFConsRule_dot_uscore_hash_selFP62_hash_cont :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_searchNFConsRule_dot_uscore_hash_selFP62_hash_cont x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_248 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_searchNFConsRule_dot_uscore_hash_selFP62_hash_cont l cd cs)
    (d_OP_searchNFConsRule_dot_uscore_hash_selFP62_hash_cont r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_searchNFConsRule_dot_uscore_hash_selFP62_hash_cont z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_searchNFConsRule_dot_uscore_hash_selFP62_hash_cont e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.searchNFConsRule._#selFP62#cont" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.searchNFConsRule._#selFP62#cont"
    (showCons x1))

d_OP_searchNFConsRule_dot_uscore_hash_selFP63_hash_us :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_searchNFConsRule_dot_uscore_hash_selFP63_hash_us x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_245 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_searchNFConsRule_dot_uscore_hash_selFP63_hash_us l cd cs)
    (d_OP_searchNFConsRule_dot_uscore_hash_selFP63_hash_us r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_searchNFConsRule_dot_uscore_hash_selFP63_hash_us z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_searchNFConsRule_dot_uscore_hash_selFP63_hash_us e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.searchNFConsRule._#selFP63#us" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.searchNFConsRule._#selFP63#us"
    (showCons x1))

d_OP_searchNFConsRule_dot_nfBody_dot_265 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_OP_searchNFConsRule_dot_nfBody_dot_265 x1 x2 x3 x4 cd cs =
  Curry_Prelude.d_C_foldr (acceptCs id
  (d_OP_searchNFConsRule_dot_nfBody_dot_265_dot_uscore_hash_lambda27 x3))
  (Curry_AbstractHaskellGoodies.d_C_applyV x2 (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskellGoodies.d_C_applyF x4 (Curry_Prelude.d_C_map (d_C_mkVar
  (Curry_Prelude.toCurryString "y")) (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_enumFromTo_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
  cd cs) (Curry_Prelude.C_Int (1)) cd cs) x1 cd cs) cd cs) cd cs)
  Curry_Prelude.OP_List) cd cs) (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_enumFromTo_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
  cd cs) (Curry_Prelude.C_Int (1)) cd cs) x1 cd cs) cd cs

d_OP_searchNFConsRule_dot_nfBody_dot_265_dot_uscore_hash_lambda27 :: Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_OP_searchNFConsRule_dot_nfBody_dot_265_dot_uscore_hash_lambda27 x1 x2 x3 cd cs =
  Curry_AbstractHaskellGoodies.d_C_applyV x1 (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Lambda (Curry_Prelude.OP_Cons (d_C_mkPVar
  (Curry_Prelude.toCurryString "y") x2 cd cs) Curry_Prelude.OP_List) x3)
  (Curry_Prelude.OP_Cons (d_C_mkVar (Curry_Prelude.toCurryString "x") x2 cd cs)
  Curry_Prelude.OP_List)) cd cs

d_OP_searchNFConsRule_dot_rule_dot_265 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_AbstractHaskell.C_Rule
d_OP_searchNFConsRule_dot_rule_dot_265 x1 x2 x3 x4 x5 cd cs =
  Curry_Prelude.OP_Tuple2 (d_C_basics (Curry_Prelude.toCurryString "searchNF")
  cd cs) (d_C_simpleRule (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_PVar
  x3) (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_PVar x2)
  (Curry_Prelude.OP_Cons (d_C_consPattern x5 (Curry_Prelude.toCurryString "x")
  x1 cd cs) Curry_Prelude.OP_List))) (d_OP_searchNFConsRule_dot_nfBody_dot_265
  x1 x2 x4 x5 cd cs) cd cs)

d_C_searchNFCatchRule :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule
d_C_searchNFCatchRule x1 cd cs = let x2 = Curry_Prelude.d_C_apply (d_C_newVars
                                       cd cs) (Curry_Prelude.OP_Cons
                                       (Curry_Prelude.toCurryString "_")
                                       (Curry_Prelude.OP_Cons
                                       (Curry_Prelude.toCurryString "_")
                                       (Curry_Prelude.OP_Cons
                                       (Curry_Prelude.toCurryString "x")
                                       Curry_Prelude.OP_List))) cd cs
                                     x3 = d_OP_searchNFCatchRule_dot_uscore_hash_selFP65_hash_us1
                                       x2 cd cs
                                     x4 = d_OP_searchNFCatchRule_dot_uscore_hash_selFP66_hash_us2
                                       x2 cd cs
                                     x5 = d_OP_searchNFCatchRule_dot_uscore_hash_selFP67_hash_x
                                       x2 cd cs
  in Curry_Prelude.OP_Tuple2 (d_C_basics (Curry_Prelude.toCurryString
  "searchNF") cd cs) (d_C_simpleRule (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x3) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x4) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x5) Curry_Prelude.OP_List)))
  (Curry_AbstractHaskellGoodies.d_C_applyF (Curry_AbstractHaskellGoodies.d_C_pre
  (Curry_Prelude.toCurryString "error") cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_InfixApply (Curry_Prelude.d_C_apply
  (Curry_AbstractHaskellGoodies.d_C_string2ac cd cs)
  (Curry_Prelude.d_OP_plus_plus (d_C_showQName (Curry_Prelude.d_C_apply
  (Curry_Names.d_C_unRenameQName cd cs) x1 cd cs) cd cs)
  (Curry_Prelude.toCurryString ".searchNF: no constructor: ") cd cs) cd cs)
  (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString "++") cd
  cs) (Curry_AbstractHaskellGoodies.d_C_applyF
  (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString "show") cd
  cs) (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x5)
  Curry_Prelude.OP_List) cd cs)) Curry_Prelude.OP_List) cd cs) cd cs)

d_OP_searchNFCatchRule_dot_uscore_hash_selFP65_hash_us1 :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_searchNFCatchRule_dot_uscore_hash_selFP65_hash_us1 x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_242 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_searchNFCatchRule_dot_uscore_hash_selFP65_hash_us1 l cd cs)
    (d_OP_searchNFCatchRule_dot_uscore_hash_selFP65_hash_us1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_searchNFCatchRule_dot_uscore_hash_selFP65_hash_us1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_searchNFCatchRule_dot_uscore_hash_selFP65_hash_us1 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.searchNFCatchRule._#selFP65#us1" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.searchNFCatchRule._#selFP65#us1"
    (showCons x1))

d_OP_searchNFCatchRule_dot_uscore_hash_selFP66_hash_us2 :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_searchNFCatchRule_dot_uscore_hash_selFP66_hash_us2 x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_239 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_searchNFCatchRule_dot_uscore_hash_selFP66_hash_us2 l cd cs)
    (d_OP_searchNFCatchRule_dot_uscore_hash_selFP66_hash_us2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_searchNFCatchRule_dot_uscore_hash_selFP66_hash_us2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_searchNFCatchRule_dot_uscore_hash_selFP66_hash_us2 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.searchNFCatchRule._#selFP66#us2" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.searchNFCatchRule._#selFP66#us2"
    (showCons x1))

d_OP_searchNFCatchRule_dot_uscore_hash_selFP67_hash_x :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_searchNFCatchRule_dot_uscore_hash_selFP67_hash_x x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_236 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_searchNFCatchRule_dot_uscore_hash_selFP67_hash_x l cd cs)
    (d_OP_searchNFCatchRule_dot_uscore_hash_selFP67_hash_x r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_searchNFCatchRule_dot_uscore_hash_selFP67_hash_x z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_searchNFCatchRule_dot_uscore_hash_selFP67_hash_x e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.searchNFCatchRule._#selFP67#x" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.searchNFCatchRule._#selFP67#x"
    (showCons x1))

d_C_unifiableInstance :: Curry_Prelude.C_Bool -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass -> FlatCurry.Curry_Types.C_TypeDecl
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeDecl
d_C_unifiableInstance x1 x2 x3 cd cs = case x3 of
  FlatCurry.Curry_Types.C_Type x4 x5 x6 x7 -> let x8 = Curry_Prelude.d_C_map
                                                    d_C_fcy2absTVar x6 cd cs
                                                  x9 = Curry_AbstractHaskell.C_TCons
                                                    x4 (Curry_Prelude.d_C_map
                                                    (acceptCs id
                                                    Curry_AbstractHaskell.C_TVar)
                                                    x8 cd cs)
    in d_C__case_233 x1 x9 x4 x7 x2 x8 (Curry_Prelude.d_C_not x1 cd cs) cd cs
  FlatCurry.Curry_Types.C_TypeSyn x10 x11 x12 x13 -> Curry_Prelude.d_C_error
    (Curry_Prelude.toCurryString "TransTypes.unifiableInstance") cd cs
  FlatCurry.Curry_Types.Choice_C_TypeDecl d i l r -> narrow d i
    (d_C_unifiableInstance x1 x2 l cd cs) (d_C_unifiableInstance x1 x2 r cd cs)
  FlatCurry.Curry_Types.Choices_C_TypeDecl d i xs -> narrows cs d i (\z ->
    d_C_unifiableInstance x1 x2 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_TypeDecl d c e -> guardCons d c
    (d_C_unifiableInstance x1 x2 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_TypeDecl d info -> failCons d (traceFail
    "TransTypes.unifiableInstance" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes.unifiableInstance" (showCons x3))

nd_C_unifiableInstance :: Curry_Prelude.C_Bool -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass -> FlatCurry.Curry_Types.C_TypeDecl
  -> IDSupply -> Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeDecl
nd_C_unifiableInstance x1 x2 x3 s cd cs = case x3 of
  FlatCurry.Curry_Types.C_Type x4 x5 x6 x7 -> let s3 = s
    in s3 `seq` (let s0 = leftSupply s3
                     s4 = rightSupply s3
                     s1 = leftSupply s4
                     s2 = rightSupply s4
    in s0 `seq` (s4 `seq` (s1 `seq` (s2 `seq` (let x8 = Curry_Prelude.nd_C_map
                                                     (wrapDX id d_C_fcy2absTVar)
                                                     x6 s0 cd cs
                                                   x9 = Curry_AbstractHaskell.C_TCons
                                                     x4 (Curry_Prelude.nd_C_map
                                                     (wrapDX id (acceptCs id
                                                     Curry_AbstractHaskell.C_TVar))
                                                     x8 s1 cd cs)
    in nd_C__case_233 x1 x9 x4 x7 x2 x8 (Curry_Prelude.d_C_not x1 cd cs) s2 cd
    cs)))))
  FlatCurry.Curry_Types.C_TypeSyn x10 x11 x12 x13 -> Curry_Prelude.d_C_error
    (Curry_Prelude.toCurryString "TransTypes.unifiableInstance") cd cs
  FlatCurry.Curry_Types.Choice_C_TypeDecl d i l r -> narrow d i
    (nd_C_unifiableInstance x1 x2 l s cd cs) (nd_C_unifiableInstance x1 x2 r s
    cd cs)
  FlatCurry.Curry_Types.Choices_C_TypeDecl d i xs -> narrows cs d i (\z ->
    nd_C_unifiableInstance x1 x2 z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_TypeDecl d c e -> guardCons d c
    (nd_C_unifiableInstance x1 x2 e s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_TypeDecl d info -> failCons d (traceFail
    "TransTypes.unifiableInstance" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes.unifiableInstance" (showCons x3))

d_OP_unifiableInstance_dot_newFail_dot_281 :: forall t0 . (Curry_Prelude.Curry
  t0) => t0 -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 t0
  Curry_AbstractHaskell.C_Rule
d_OP_unifiableInstance_dot_newFail_dot_281 x1 cd cs = Curry_Prelude.OP_Tuple2 x1
  (d_C_simpleRule (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_PVar
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int (1))
  (Curry_Prelude.toCurryString "a"))) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int
  (2)) (Curry_Prelude.toCurryString "b"))) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int
  (3)) (Curry_Prelude.toCurryString "cd"))) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int
  (4)) (Curry_Prelude.toCurryString "_"))) Curry_Prelude.OP_List))))
  (Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
  (Curry_Prelude.toCurryString "Fail_C_Bool") cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int
  (3)) (Curry_Prelude.toCurryString "cd"))) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
  (Curry_Prelude.toCurryString "unificationFail") cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
  (Curry_Prelude.toCurryString "showCons") cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int
  (1)) (Curry_Prelude.toCurryString "a"))) Curry_Prelude.OP_List) cd cs)
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
  (Curry_Prelude.toCurryString "showCons") cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int
  (2)) (Curry_Prelude.toCurryString "b"))) Curry_Prelude.OP_List) cd cs)
  Curry_Prelude.OP_List)) cd cs) Curry_Prelude.OP_List)) cd cs) cd cs)

d_OP_unifiableInstance_dot_uscore_hash_lambda29 :: Curry_AbstractHaskell.C_Expr
  -> Curry_AbstractHaskell.C_Expr -> Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_OP_unifiableInstance_dot_uscore_hash_lambda29 x1 x2 x3 cd cs =
  Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
  (Curry_Prelude.toCurryString "bind") cd cs) (Curry_Prelude.OP_Cons x1
  (Curry_Prelude.OP_Cons x2 (Curry_Prelude.OP_Cons x3 Curry_Prelude.OP_List)))
  cd cs

d_OP_unifiableInstance_dot_uscore_hash_lambda30 :: Curry_AbstractHaskell.C_Expr
  -> Curry_AbstractHaskell.C_Expr -> Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_OP_unifiableInstance_dot_uscore_hash_lambda30 x1 x2 x3 cd cs =
  Curry_AbstractHaskell.C_InfixApply x2 (d_C_basics (Curry_Prelude.toCurryString
  ":=:") cd cs) (Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
  (Curry_Prelude.toCurryString "LazyBind") cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
  (Curry_Prelude.toCurryString "lazyBind") cd cs) (Curry_Prelude.OP_Cons x1
  (Curry_Prelude.OP_Cons x2 (Curry_Prelude.OP_Cons x3 Curry_Prelude.OP_List)))
  cd cs) Curry_Prelude.OP_List) cd cs)

d_C_unifiableConsRule :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_ConsHOClass
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> FlatCurry.Curry_Types.C_ConsDecl -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
d_C_unifiableConsRule x1 x2 x3 x4 cd cs = case x4 of
  FlatCurry.Curry_Types.C_Cons x5 x6 x7 x8 -> let x9 = Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Maybe
                                                    (Curry_Classification.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Classification_dot_ConsHOClass
                                                    cd cs)
                                                    (Curry_FiniteMap.d_C_lookupFM
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                                    cd cs) cd cs)
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                                    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                                    cd cs) cd cs) cd cs) x1 x5
                                                    cd cs) (Curry_Prelude.C_Just
                                                    Curry_Classification.C_ConsHO)
                                                    cd cs
                                                  x10 = Curry_Prelude.d_C_length
                                                    x8 cd cs
                                                  x11 = Curry_Prelude.OP_Tuple2
                                                    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
                                                    x10 (Curry_Prelude.C_Int
                                                    (2)) cd cs)
                                                    (Curry_Prelude.toCurryString
                                                    "cs")
                                                  x12 = Curry_Prelude.OP_Tuple2
                                                    (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
                                                    x10 (Curry_Prelude.C_Int
                                                    (1)) cd cs)
                                                    (Curry_Prelude.toCurryString
                                                    "d")
    in d_C__case_231 x5 x3 x2 x12 x11 x10 x9 cd cs
  FlatCurry.Curry_Types.Choice_C_ConsDecl d i l r -> narrow d i
    (d_C_unifiableConsRule x1 x2 x3 l cd cs) (d_C_unifiableConsRule x1 x2 x3 r
    cd cs)
  FlatCurry.Curry_Types.Choices_C_ConsDecl d i xs -> narrows cs d i (\z ->
    d_C_unifiableConsRule x1 x2 x3 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_ConsDecl d c e -> guardCons d c
    (d_C_unifiableConsRule x1 x2 x3 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_ConsDecl d info -> failCons d (traceFail
    "TransTypes.unifiableConsRule" [show x1, show x2, show x3, show x4] info)
  _ -> failCons cd (consFail "TransTypes.unifiableConsRule" (showCons x4))

nd_C_unifiableConsRule :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_ConsHOClass
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> FlatCurry.Curry_Types.C_ConsDecl -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
nd_C_unifiableConsRule x1 x2 x3 x4 s cd cs = case x4 of
  FlatCurry.Curry_Types.C_Cons x5 x6 x7 x8 -> let s13 = s
    in s13 `seq` (let x9 = let s12 = leftSupply s13
                               s14 = rightSupply s13
                               s0 = leftSupply s14
                               s11 = rightSupply s14
                        in s12 `seq` (s14 `seq` (s0 `seq` (s11 `seq`
                        Curry_Prelude.nd_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Maybe
                        (Curry_Classification.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Classification_dot_ConsHOClass
                        s0 cd cs) (let s10 = leftSupply s11
                                       s8 = rightSupply s11
                        in s10 `seq` (s8 `seq` Curry_FiniteMap.nd_C_lookupFM
                        (let s7 = leftSupply s8
                             s9 = rightSupply s8
                             s3 = leftSupply s9
                             s6 = rightSupply s9
                        in s7 `seq` (s9 `seq` (s3 `seq` (s6 `seq`
                        Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                        (let s2 = leftSupply s3
                             s1 = rightSupply s3
                        in s2 `seq` (s1 `seq`
                        Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                        (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                        s1 cd cs) s2 cd cs)) (let s5 = leftSupply s6
                                                  s4 = rightSupply s6
                        in s5 `seq` (s4 `seq`
                        Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                        (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                        s4 cd cs) s5 cd cs)) s7 cd cs)))) x1 x5 s10 cd cs))
                        (Curry_Prelude.C_Just Curry_Classification.C_ConsHO) s12
                        cd cs)))
                      x10 = Curry_Prelude.d_C_length x8 cd cs
                      x11 = Curry_Prelude.OP_Tuple2
                        (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
                        x10 (Curry_Prelude.C_Int (2)) cd cs)
                        (Curry_Prelude.toCurryString "cs")
                      x12 = Curry_Prelude.OP_Tuple2
                        (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
                        x10 (Curry_Prelude.C_Int (1)) cd cs)
                        (Curry_Prelude.toCurryString "d")
    in d_C__case_231 x5 x3 x2 x12 x11 x10 x9 cd cs)
  FlatCurry.Curry_Types.Choice_C_ConsDecl d i l r -> narrow d i
    (nd_C_unifiableConsRule x1 x2 x3 l s cd cs) (nd_C_unifiableConsRule x1 x2 x3
    r s cd cs)
  FlatCurry.Curry_Types.Choices_C_ConsDecl d i xs -> narrows cs d i (\z ->
    nd_C_unifiableConsRule x1 x2 x3 z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_ConsDecl d c e -> guardCons d c
    (nd_C_unifiableConsRule x1 x2 x3 e s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_ConsDecl d info -> failCons d (traceFail
    "TransTypes.unifiableConsRule" [show x1, show x2, show x3, show x4] info)
  _ -> failCons cd (consFail "TransTypes.unifiableConsRule" (showCons x4))

d_OP_unifiableConsRule_dot_unifBody_dot_294 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_OP_unifiableConsRule_dot_unifBody_dot_294 x1 x2 x3 x4 cd cs = d_C__case_229 x1
  x4 x3 x2
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
  x1 (Curry_Prelude.C_Int (0)) cd cs) cd cs

d_OP_unifiableConsRule_dot_unifBody_dot_294_dot_uscore_hash_lambda32 :: Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_AbstractHaskell.C_Expr
  -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_OP_unifiableConsRule_dot_unifBody_dot_294_dot_uscore_hash_lambda32 x1 x2 x3 x4 cd cs =
  Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
  (Curry_Prelude.toCurryString "&") cd cs) (Curry_Prelude.OP_Cons x3
  (Curry_Prelude.OP_Cons x4 (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var
  x2) (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x1)
  Curry_Prelude.OP_List)))) cd cs

d_OP_unifiableConsRule_dot_unifBody_dot_294_dot_uscore_hash_lambda33 :: Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_OP_unifiableConsRule_dot_unifBody_dot_294_dot_uscore_hash_lambda33 x1 x2 x3 x4 cd cs =
  Curry_AbstractHaskellGoodies.d_C_applyF x3 (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var (Curry_Prelude.OP_Tuple2 x4
  (Curry_Prelude.OP_Cons (Curry_Prelude.C_Char 'x'#) (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Int
  cd cs) x4 cd cs)))) (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var
  (Curry_Prelude.OP_Tuple2 x4 (Curry_Prelude.OP_Cons (Curry_Prelude.C_Char 'y'#)
  (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Int
  cd cs) x4 cd cs)))) (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x2)
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x1)
  Curry_Prelude.OP_List)))) cd cs

d_OP_unifiableConsRule_dot_rule_dot_294 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_AbstractHaskell.C_Rule
d_OP_unifiableConsRule_dot_rule_dot_294 x1 x2 x3 x4 x5 x6 cd cs =
  Curry_Prelude.OP_Tuple2 x4 (d_C_simpleRule (Curry_Prelude.OP_Cons
  (d_C_consPattern x6 (Curry_Prelude.toCurryString "x") x1 cd cs)
  (Curry_Prelude.OP_Cons (d_C_consPattern x6 (Curry_Prelude.toCurryString "y")
  x1 cd cs) (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_PVar x3)
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_PVar x2)
  Curry_Prelude.OP_List)))) (d_OP_unifiableConsRule_dot_unifBody_dot_294 x1 x2
  x3 x5 cd cs) cd cs)

d_C_bindConsRule :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_ConsHOClass
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> (Curry_AbstractHaskell.C_Expr
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr) -> (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr) -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int FlatCurry.Curry_Types.C_ConsDecl -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
d_C_bindConsRule x1 x2 x3 x4 x5 cd cs = case x5 of
  Curry_Prelude.OP_Tuple2 x6 x7 -> d_C__case_227 x1 x4 x3 x2 x6 x7 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C_bindConsRule x1 x2
    x3 x4 l cd cs) (d_C_bindConsRule x1 x2 x3 x4 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_C_bindConsRule x1 x2 x3 x4 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C_bindConsRule x1 x2
    x3 x4 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransTypes.bindConsRule" [show x1, show x2, show x3, show x4, show x5]
    info)
  _ -> failCons cd (consFail "TransTypes.bindConsRule" (showCons x5))

nd_C_bindConsRule :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_ConsHOClass
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Func
  Curry_AbstractHaskell.C_Expr (Func Curry_AbstractHaskell.C_Expr (Func
  Curry_AbstractHaskell.C_Expr Curry_AbstractHaskell.C_Expr)) -> Func
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr)
  Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  FlatCurry.Curry_Types.C_ConsDecl -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
nd_C_bindConsRule x1 x2 x3 x4 x5 s cd cs = case x5 of
  Curry_Prelude.OP_Tuple2 x6 x7 -> let s0 = s
    in s0 `seq` nd_C__case_227 x1 x4 x3 x2 x6 x7 s0 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (nd_C_bindConsRule x1 x2
    x3 x4 l s cd cs) (nd_C_bindConsRule x1 x2 x3 x4 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    nd_C_bindConsRule x1 x2 x3 x4 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (nd_C_bindConsRule x1 x2
    x3 x4 e s cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransTypes.bindConsRule" [show x1, show x2, show x3, show x4, show x5]
    info)
  _ -> failCons cd (consFail "TransTypes.bindConsRule" (showCons x5))

d_OP_bindConsRule_dot_rule_dot_308 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_TypeExpr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> (Curry_AbstractHaskell.C_Expr
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr) -> (Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr) -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule
d_OP_bindConsRule_dot_rule_dot_308 x1 x2 x3 x4 x5 x6 cd cs =
  Curry_Prelude.OP_Tuple2 x3 (d_C_simpleRule (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int
  (1)) (Curry_Prelude.toCurryString "cd"))) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int
  (2)) (Curry_Prelude.toCurryString "i"))) (Curry_Prelude.OP_Cons
  (Curry_Prelude.d_OP_dollar (acceptCs id (Curry_AbstractHaskell.C_PComb x6))
  (Curry_Prelude.d_C_map
  d_OP_bindConsRule_dot_rule_dot_308_dot_uscore_hash_lambda34
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_enumFromTo_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
  cd cs) (Curry_Prelude.C_Int (3)) cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
  (Curry_Prelude.d_C_length x2 cd cs) (Curry_Prelude.C_Int (2)) cd cs) cd cs) cd
  cs) cd cs) Curry_Prelude.OP_List))) (Curry_AbstractHaskell.C_InfixApply
  (Curry_AbstractHaskell.C_InfixApply (Curry_AbstractHaskell.C_Var
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int (2))
  (Curry_Prelude.toCurryString "i"))) (d_C_basics (Curry_Prelude.toCurryString
  ":=:") cd cs) (Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
  (Curry_Prelude.toCurryString "ChooseN") cd cs) (Curry_Prelude.OP_Cons
  (d_C_intc x1 cd cs) (Curry_Prelude.OP_Cons (Curry_Prelude.d_OP_dollar d_C_intc
  (Curry_Prelude.d_C_length x2 cd cs) cd cs) Curry_Prelude.OP_List)) cd cs))
  (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString ":") cd cs)
  (Curry_Prelude.d_C_apply x5 (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskellGoodies.d_C_list2ac (Curry_Prelude.d_C_zipWith3 x4
  (Curry_Prelude.d_C_repeat (Curry_AbstractHaskell.C_Var
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int (1))
  (Curry_Prelude.toCurryString "cd"))) cd cs) (d_C_mkIdList
  (Curry_Prelude.d_C_length x2 cd cs) (Curry_AbstractHaskell.C_Var
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int (2))
  (Curry_Prelude.toCurryString "i"))) cd cs) (Curry_Prelude.d_C_map
  d_OP_bindConsRule_dot_rule_dot_308_dot_uscore_hash_lambda35
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_enumFromTo_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
  cd cs) (Curry_Prelude.C_Int (3)) cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
  (Curry_Prelude.d_C_length x2 cd cs) (Curry_Prelude.C_Int (2)) cd cs) cd cs) cd
  cs) cd cs) cd cs) Curry_Prelude.OP_List) cd cs)) cd cs)

nd_OP_bindConsRule_dot_rule_dot_308 :: Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_TypeExpr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Func
  Curry_AbstractHaskell.C_Expr (Func Curry_AbstractHaskell.C_Expr (Func
  Curry_AbstractHaskell.C_Expr Curry_AbstractHaskell.C_Expr)) -> Func
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr)
  Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule
nd_OP_bindConsRule_dot_rule_dot_308 x1 x2 x3 x4 x5 x6 s cd cs = let s18 = s
  in s18 `seq` Curry_Prelude.OP_Tuple2 x3 (let s6 = leftSupply s18
                                               s17 = rightSupply s18
  in s6 `seq` (s17 `seq` d_C_simpleRule (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int
  (1)) (Curry_Prelude.toCurryString "cd"))) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int
  (2)) (Curry_Prelude.toCurryString "i"))) (Curry_Prelude.OP_Cons
  (let s5 = leftSupply s6
       s4 = rightSupply s6
  in s5 `seq` (s4 `seq` Curry_Prelude.nd_OP_dollar (wrapDX id (acceptCs id
  (Curry_AbstractHaskell.C_PComb x6))) (let s3 = leftSupply s4
                                            s2 = rightSupply s4
  in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_map (wrapDX id
  d_OP_bindConsRule_dot_rule_dot_308_dot_uscore_hash_lambda34)
  (let s1 = leftSupply s2
       s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply
  (wrapDX (wrapDX id)
  (Curry_Prelude.d_OP_uscore_impl_hash_enumFromTo_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
  cd cs)) (Curry_Prelude.C_Int (3)) s0 cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
  (Curry_Prelude.d_C_length x2 cd cs) (Curry_Prelude.C_Int (2)) cd cs) s1 cd
  cs)) s3 cd cs)) s5 cd cs)) Curry_Prelude.OP_List))) (let s7 = leftSupply s17
                                                           s16 = rightSupply s17
  in s7 `seq` (s16 `seq` Curry_AbstractHaskell.C_InfixApply
  (Curry_AbstractHaskell.C_InfixApply (Curry_AbstractHaskell.C_Var
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int (2))
  (Curry_Prelude.toCurryString "i"))) (d_C_basics (Curry_Prelude.toCurryString
  ":=:") cd cs) (Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
  (Curry_Prelude.toCurryString "ChooseN") cd cs) (Curry_Prelude.OP_Cons
  (d_C_intc x1 cd cs) (Curry_Prelude.OP_Cons (Curry_Prelude.nd_OP_dollar (wrapDX
  id d_C_intc) (Curry_Prelude.d_C_length x2 cd cs) s7 cd cs)
  Curry_Prelude.OP_List)) cd cs)) (Curry_AbstractHaskellGoodies.d_C_pre
  (Curry_Prelude.toCurryString ":") cd cs) (let s15 = leftSupply s16
                                                s14 = rightSupply s16
  in s15 `seq` (s14 `seq` Curry_Prelude.nd_C_apply x5 (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskellGoodies.d_C_list2ac (let s13 = leftSupply s14
                                                 s12 = rightSupply s14
  in s13 `seq` (s12 `seq` Curry_Prelude.nd_C_zipWith3 x4
  (Curry_Prelude.d_C_repeat (Curry_AbstractHaskell.C_Var
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int (1))
  (Curry_Prelude.toCurryString "cd"))) cd cs) (d_C_mkIdList
  (Curry_Prelude.d_C_length x2 cd cs) (Curry_AbstractHaskell.C_Var
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int (2))
  (Curry_Prelude.toCurryString "i"))) cd cs) (let s11 = leftSupply s12
                                                  s10 = rightSupply s12
  in s11 `seq` (s10 `seq` Curry_Prelude.nd_C_map (wrapDX id
  d_OP_bindConsRule_dot_rule_dot_308_dot_uscore_hash_lambda35)
  (let s9 = leftSupply s10
       s8 = rightSupply s10
  in s9 `seq` (s8 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply
  (wrapDX (wrapDX id)
  (Curry_Prelude.d_OP_uscore_impl_hash_enumFromTo_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
  cd cs)) (Curry_Prelude.C_Int (3)) s8 cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_plus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
  (Curry_Prelude.d_C_length x2 cd cs) (Curry_Prelude.C_Int (2)) cd cs) s9 cd
  cs)) s11 cd cs)) s13 cd cs)) cd cs) Curry_Prelude.OP_List) s15 cd cs)))) cd
  cs))

d_OP_bindConsRule_dot_rule_dot_308_dot_uscore_hash_lambda34 :: Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Pattern
d_OP_bindConsRule_dot_rule_dot_308_dot_uscore_hash_lambda34 x1 cd cs =
  Curry_AbstractHaskell.C_PVar (Curry_Prelude.OP_Tuple2 x1
  (Curry_Prelude.OP_Cons (Curry_Prelude.C_Char 'x'#) (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Int
  cd cs) x1 cd cs)))

d_OP_bindConsRule_dot_rule_dot_308_dot_uscore_hash_lambda35 :: Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_OP_bindConsRule_dot_rule_dot_308_dot_uscore_hash_lambda35 x1 cd cs =
  Curry_AbstractHaskell.C_Var (Curry_Prelude.OP_Tuple2 x1 (Curry_Prelude.OP_Cons
  (Curry_Prelude.C_Char 'x'#) (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Int
  cd cs) x1 cd cs)))

d_C_bindChoiceRule :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_AbstractHaskell.C_Rule
d_C_bindChoiceRule x1 x2 cd cs = let x3 = Curry_Prelude.d_C_apply (d_C_newVars
                                       cd cs) (Curry_Prelude.OP_Cons
                                       (Curry_Prelude.toCurryString "d")
                                       (Curry_Prelude.OP_Cons
                                       (Curry_Prelude.toCurryString "i")
                                       (Curry_Prelude.OP_Cons
                                       (Curry_Prelude.toCurryString "j")
                                       (Curry_Prelude.OP_Cons
                                       (Curry_Prelude.toCurryString "x")
                                       (Curry_Prelude.OP_Cons
                                       (Curry_Prelude.toCurryString "y")
                                       (Curry_Prelude.OP_Cons
                                       (Curry_Prelude.toCurryString "cd")
                                       Curry_Prelude.OP_List)))))) cd cs
                                     x4 = d_OP_bindChoiceRule_dot_uscore_hash_selFP69_hash_d
                                       x3 cd cs
                                     x5 = d_OP_bindChoiceRule_dot_uscore_hash_selFP70_hash_i
                                       x3 cd cs
                                     x6 = d_OP_bindChoiceRule_dot_uscore_hash_selFP71_hash_j
                                       x3 cd cs
                                     x7 = d_OP_bindChoiceRule_dot_uscore_hash_selFP72_hash_x
                                       x3 cd cs
                                     x8 = d_OP_bindChoiceRule_dot_uscore_hash_selFP73_hash_y
                                       x3 cd cs
                                     x9 = d_OP_bindChoiceRule_dot_uscore_hash_selFP74_hash_cd
                                       x3 cd cs
  in Curry_Prelude.OP_Tuple2 x2 (d_C_simpleRule (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x4) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x5) (Curry_Prelude.OP_Cons (d_C_mkChoicePattern
  x1 (Curry_Prelude.toCurryString "j") cd cs) Curry_Prelude.OP_List)))
  (Curry_AbstractHaskellGoodies.d_C_list2ac (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
  (Curry_Prelude.toCurryString "ConstraintChoice") cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x9) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x6) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskellGoodies.d_C_applyF x2 (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x4) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x5) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x7) Curry_Prelude.OP_List))) cd cs)
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskellGoodies.d_C_applyF x2
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x4) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x5) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x8) Curry_Prelude.OP_List))) cd cs)
  Curry_Prelude.OP_List)))) cd cs) Curry_Prelude.OP_List) cd cs) cd cs)

d_OP_bindChoiceRule_dot_uscore_hash_selFP69_hash_d :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_bindChoiceRule_dot_uscore_hash_selFP69_hash_d x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_224 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_bindChoiceRule_dot_uscore_hash_selFP69_hash_d l cd cs)
    (d_OP_bindChoiceRule_dot_uscore_hash_selFP69_hash_d r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_bindChoiceRule_dot_uscore_hash_selFP69_hash_d z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_bindChoiceRule_dot_uscore_hash_selFP69_hash_d e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.bindChoiceRule._#selFP69#d" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.bindChoiceRule._#selFP69#d" (showCons
    x1))

d_OP_bindChoiceRule_dot_uscore_hash_selFP70_hash_i :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_bindChoiceRule_dot_uscore_hash_selFP70_hash_i x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_218 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_bindChoiceRule_dot_uscore_hash_selFP70_hash_i l cd cs)
    (d_OP_bindChoiceRule_dot_uscore_hash_selFP70_hash_i r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_bindChoiceRule_dot_uscore_hash_selFP70_hash_i z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_bindChoiceRule_dot_uscore_hash_selFP70_hash_i e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.bindChoiceRule._#selFP70#i" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.bindChoiceRule._#selFP70#i" (showCons
    x1))

d_OP_bindChoiceRule_dot_uscore_hash_selFP71_hash_j :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_bindChoiceRule_dot_uscore_hash_selFP71_hash_j x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_212 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_bindChoiceRule_dot_uscore_hash_selFP71_hash_j l cd cs)
    (d_OP_bindChoiceRule_dot_uscore_hash_selFP71_hash_j r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_bindChoiceRule_dot_uscore_hash_selFP71_hash_j z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_bindChoiceRule_dot_uscore_hash_selFP71_hash_j e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.bindChoiceRule._#selFP71#j" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.bindChoiceRule._#selFP71#j" (showCons
    x1))

d_OP_bindChoiceRule_dot_uscore_hash_selFP72_hash_x :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_bindChoiceRule_dot_uscore_hash_selFP72_hash_x x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_206 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_bindChoiceRule_dot_uscore_hash_selFP72_hash_x l cd cs)
    (d_OP_bindChoiceRule_dot_uscore_hash_selFP72_hash_x r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_bindChoiceRule_dot_uscore_hash_selFP72_hash_x z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_bindChoiceRule_dot_uscore_hash_selFP72_hash_x e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.bindChoiceRule._#selFP72#x" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.bindChoiceRule._#selFP72#x" (showCons
    x1))

d_OP_bindChoiceRule_dot_uscore_hash_selFP73_hash_y :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_bindChoiceRule_dot_uscore_hash_selFP73_hash_y x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_200 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_bindChoiceRule_dot_uscore_hash_selFP73_hash_y l cd cs)
    (d_OP_bindChoiceRule_dot_uscore_hash_selFP73_hash_y r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_bindChoiceRule_dot_uscore_hash_selFP73_hash_y z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_bindChoiceRule_dot_uscore_hash_selFP73_hash_y e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.bindChoiceRule._#selFP73#y" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.bindChoiceRule._#selFP73#y" (showCons
    x1))

d_OP_bindChoiceRule_dot_uscore_hash_selFP74_hash_cd :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_bindChoiceRule_dot_uscore_hash_selFP74_hash_cd x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_194 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_bindChoiceRule_dot_uscore_hash_selFP74_hash_cd l cd cs)
    (d_OP_bindChoiceRule_dot_uscore_hash_selFP74_hash_cd r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_bindChoiceRule_dot_uscore_hash_selFP74_hash_cd z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_bindChoiceRule_dot_uscore_hash_selFP74_hash_cd e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.bindChoiceRule._#selFP74#cd" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.bindChoiceRule._#selFP74#cd" (showCons
    x1))

d_C_bindFreeRule :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_AbstractHaskell.C_Rule
d_C_bindFreeRule x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> let x5 = Curry_Prelude.d_C_apply (d_C_newVars
                                         cd cs) (Curry_Prelude.OP_Cons
                                         (Curry_Prelude.toCurryString "d")
                                         (Curry_Prelude.OP_Cons
                                         (Curry_Prelude.toCurryString "i")
                                         (Curry_Prelude.OP_Cons
                                         (Curry_Prelude.toCurryString "j")
                                         (Curry_Prelude.OP_Cons
                                         (Curry_Prelude.toCurryString "cd")
                                         (Curry_Prelude.OP_Cons
                                         (Curry_Prelude.toCurryString "xs")
                                         Curry_Prelude.OP_List))))) cd cs
                                       x6 = d_OP_bindFreeRule_dot_uscore_hash_selFP76_hash_d
                                         x5 cd cs
                                       x7 = d_OP_bindFreeRule_dot_uscore_hash_selFP77_hash_i
                                         x5 cd cs
                                       x8 = d_OP_bindFreeRule_dot_uscore_hash_selFP78_hash_j
                                         x5 cd cs
                                       x9 = d_OP_bindFreeRule_dot_uscore_hash_selFP79_hash_cd
                                         x5 cd cs
                                       x10 = d_OP_bindFreeRule_dot_uscore_hash_selFP80_hash_xs
                                         x5 cd cs
    in Curry_Prelude.OP_Tuple2 x2 (d_C_simpleRule (Curry_Prelude.OP_Cons
    (Curry_AbstractHaskell.C_PVar x6) (Curry_Prelude.OP_Cons
    (Curry_AbstractHaskell.C_PVar x7) (Curry_Prelude.OP_Cons
    (d_C_mkFreeChoicesPattern x1 (Curry_Prelude.toCurryString "j") cd cs)
    Curry_Prelude.OP_List))) (Curry_AbstractHaskellGoodies.d_C_applyF
    (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.d_OP_plus_plus x4
    (Curry_Prelude.toCurryString "OrNarrow") cd cs) cd cs)
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x6)
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x7)
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x9)
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x8)
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x10)
    Curry_Prelude.OP_List))))) cd cs) cd cs)
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C_bindFreeRule x1 l cd
    cs) (d_C_bindFreeRule x1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_C_bindFreeRule x1 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C_bindFreeRule x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransTypes.bindFreeRule" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransTypes.bindFreeRule" (showCons x2))

d_OP_bindFreeRule_dot_uscore_hash_selFP76_hash_d :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_bindFreeRule_dot_uscore_hash_selFP76_hash_d x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_188 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_bindFreeRule_dot_uscore_hash_selFP76_hash_d l cd cs)
    (d_OP_bindFreeRule_dot_uscore_hash_selFP76_hash_d r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_bindFreeRule_dot_uscore_hash_selFP76_hash_d z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_bindFreeRule_dot_uscore_hash_selFP76_hash_d e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.bindFreeRule._#selFP76#d" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.bindFreeRule._#selFP76#d" (showCons
    x1))

d_OP_bindFreeRule_dot_uscore_hash_selFP77_hash_i :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_bindFreeRule_dot_uscore_hash_selFP77_hash_i x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_183 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_bindFreeRule_dot_uscore_hash_selFP77_hash_i l cd cs)
    (d_OP_bindFreeRule_dot_uscore_hash_selFP77_hash_i r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_bindFreeRule_dot_uscore_hash_selFP77_hash_i z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_bindFreeRule_dot_uscore_hash_selFP77_hash_i e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.bindFreeRule._#selFP77#i" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.bindFreeRule._#selFP77#i" (showCons
    x1))

d_OP_bindFreeRule_dot_uscore_hash_selFP78_hash_j :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_bindFreeRule_dot_uscore_hash_selFP78_hash_j x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_178 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_bindFreeRule_dot_uscore_hash_selFP78_hash_j l cd cs)
    (d_OP_bindFreeRule_dot_uscore_hash_selFP78_hash_j r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_bindFreeRule_dot_uscore_hash_selFP78_hash_j z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_bindFreeRule_dot_uscore_hash_selFP78_hash_j e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.bindFreeRule._#selFP78#j" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.bindFreeRule._#selFP78#j" (showCons
    x1))

d_OP_bindFreeRule_dot_uscore_hash_selFP79_hash_cd :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_bindFreeRule_dot_uscore_hash_selFP79_hash_cd x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_173 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_bindFreeRule_dot_uscore_hash_selFP79_hash_cd l cd cs)
    (d_OP_bindFreeRule_dot_uscore_hash_selFP79_hash_cd r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_bindFreeRule_dot_uscore_hash_selFP79_hash_cd z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_bindFreeRule_dot_uscore_hash_selFP79_hash_cd e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.bindFreeRule._#selFP79#cd" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.bindFreeRule._#selFP79#cd" (showCons
    x1))

d_OP_bindFreeRule_dot_uscore_hash_selFP80_hash_xs :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_bindFreeRule_dot_uscore_hash_selFP80_hash_xs x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_168 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_bindFreeRule_dot_uscore_hash_selFP80_hash_xs l cd cs)
    (d_OP_bindFreeRule_dot_uscore_hash_selFP80_hash_xs r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_bindFreeRule_dot_uscore_hash_selFP80_hash_xs z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_bindFreeRule_dot_uscore_hash_selFP80_hash_xs e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.bindFreeRule._#selFP80#xs" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.bindFreeRule._#selFP80#xs" (showCons
    x1))

d_C_bindNarrowedRule :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_AbstractHaskell.C_Rule
d_C_bindNarrowedRule x1 x2 cd cs = let x3 = Curry_Prelude.d_C_apply (d_C_newVars
                                         cd cs) (Curry_Prelude.OP_Cons
                                         (Curry_Prelude.toCurryString "d")
                                         (Curry_Prelude.OP_Cons
                                         (Curry_Prelude.toCurryString "i")
                                         (Curry_Prelude.OP_Cons
                                         (Curry_Prelude.toCurryString "j")
                                         (Curry_Prelude.OP_Cons
                                         (Curry_Prelude.toCurryString "xs")
                                         (Curry_Prelude.OP_Cons
                                         (Curry_Prelude.toCurryString "cd")
                                         Curry_Prelude.OP_List))))) cd cs
                                       x4 = d_OP_bindNarrowedRule_dot_uscore_hash_selFP82_hash_d
                                         x3 cd cs
                                       x5 = d_OP_bindNarrowedRule_dot_uscore_hash_selFP83_hash_i
                                         x3 cd cs
                                       x6 = d_OP_bindNarrowedRule_dot_uscore_hash_selFP84_hash_j
                                         x3 cd cs
                                       x7 = d_OP_bindNarrowedRule_dot_uscore_hash_selFP85_hash_xs
                                         x3 cd cs
                                       x8 = d_OP_bindNarrowedRule_dot_uscore_hash_selFP86_hash_cd
                                         x3 cd cs
  in Curry_Prelude.OP_Tuple2 x2 (d_C_simpleRule (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x4) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x5) (Curry_Prelude.OP_Cons
  (d_C_mkNarrowedChoicesPattern x1 (Curry_Prelude.toCurryString "j") cd cs)
  Curry_Prelude.OP_List))) (Curry_AbstractHaskellGoodies.d_C_list2ac
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
  (Curry_Prelude.toCurryString "ConstraintChoices") cd cs)
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x8) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x6) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskellGoodies.d_C_applyF (Curry_AbstractHaskellGoodies.d_C_pre
  (Curry_Prelude.toCurryString "map") cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskellGoodies.d_C_applyF x2 (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x4) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x5) Curry_Prelude.OP_List)) cd cs)
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x7)
  Curry_Prelude.OP_List)) cd cs) Curry_Prelude.OP_List))) cd cs)
  Curry_Prelude.OP_List) cd cs) cd cs)

d_OP_bindNarrowedRule_dot_uscore_hash_selFP82_hash_d :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_bindNarrowedRule_dot_uscore_hash_selFP82_hash_d x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_163 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_bindNarrowedRule_dot_uscore_hash_selFP82_hash_d l cd cs)
    (d_OP_bindNarrowedRule_dot_uscore_hash_selFP82_hash_d r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_bindNarrowedRule_dot_uscore_hash_selFP82_hash_d z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_bindNarrowedRule_dot_uscore_hash_selFP82_hash_d e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.bindNarrowedRule._#selFP82#d" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.bindNarrowedRule._#selFP82#d" (showCons
    x1))

d_OP_bindNarrowedRule_dot_uscore_hash_selFP83_hash_i :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_bindNarrowedRule_dot_uscore_hash_selFP83_hash_i x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_158 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_bindNarrowedRule_dot_uscore_hash_selFP83_hash_i l cd cs)
    (d_OP_bindNarrowedRule_dot_uscore_hash_selFP83_hash_i r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_bindNarrowedRule_dot_uscore_hash_selFP83_hash_i z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_bindNarrowedRule_dot_uscore_hash_selFP83_hash_i e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.bindNarrowedRule._#selFP83#i" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.bindNarrowedRule._#selFP83#i" (showCons
    x1))

d_OP_bindNarrowedRule_dot_uscore_hash_selFP84_hash_j :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_bindNarrowedRule_dot_uscore_hash_selFP84_hash_j x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_153 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_bindNarrowedRule_dot_uscore_hash_selFP84_hash_j l cd cs)
    (d_OP_bindNarrowedRule_dot_uscore_hash_selFP84_hash_j r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_bindNarrowedRule_dot_uscore_hash_selFP84_hash_j z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_bindNarrowedRule_dot_uscore_hash_selFP84_hash_j e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.bindNarrowedRule._#selFP84#j" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.bindNarrowedRule._#selFP84#j" (showCons
    x1))

d_OP_bindNarrowedRule_dot_uscore_hash_selFP85_hash_xs :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_bindNarrowedRule_dot_uscore_hash_selFP85_hash_xs x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_148 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_bindNarrowedRule_dot_uscore_hash_selFP85_hash_xs l cd cs)
    (d_OP_bindNarrowedRule_dot_uscore_hash_selFP85_hash_xs r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_bindNarrowedRule_dot_uscore_hash_selFP85_hash_xs z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_bindNarrowedRule_dot_uscore_hash_selFP85_hash_xs e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.bindNarrowedRule._#selFP85#xs" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.bindNarrowedRule._#selFP85#xs"
    (showCons x1))

d_OP_bindNarrowedRule_dot_uscore_hash_selFP86_hash_cd :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_bindNarrowedRule_dot_uscore_hash_selFP86_hash_cd x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_143 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_bindNarrowedRule_dot_uscore_hash_selFP86_hash_cd l cd cs)
    (d_OP_bindNarrowedRule_dot_uscore_hash_selFP86_hash_cd r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_bindNarrowedRule_dot_uscore_hash_selFP86_hash_cd z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_bindNarrowedRule_dot_uscore_hash_selFP86_hash_cd e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.bindNarrowedRule._#selFP86#cd" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.bindNarrowedRule._#selFP86#cd"
    (showCons x1))

d_C_bindChoicesRule :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_AbstractHaskell.C_Rule
d_C_bindChoicesRule x1 x2 cd cs = let x3 = Curry_Prelude.d_C_apply (d_C_newVars
                                        cd cs) (Curry_Prelude.OP_Cons
                                        (Curry_Prelude.toCurryString "_")
                                        (Curry_Prelude.OP_Cons
                                        (Curry_Prelude.toCurryString "_")
                                        (Curry_Prelude.OP_Cons
                                        (Curry_Prelude.toCurryString "i")
                                        Curry_Prelude.OP_List))) cd cs
                                      x4 = d_OP_bindChoicesRule_dot_uscore_hash_selFP88_hash_us1
                                        x3 cd cs
                                      x5 = d_OP_bindChoicesRule_dot_uscore_hash_selFP89_hash_us2
                                        x3 cd cs
                                      x6 = d_OP_bindChoicesRule_dot_uscore_hash_selFP90_hash_i
                                        x3 cd cs
  in Curry_Prelude.OP_Tuple2 x2 (d_C_simpleRule (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x4) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x5) (Curry_Prelude.OP_Cons
  (d_C_mkVarChoicesPattern x1 cd cs) Curry_Prelude.OP_List)))
  (Curry_AbstractHaskellGoodies.d_C_applyF (Curry_AbstractHaskellGoodies.d_C_pre
  (Curry_Prelude.toCurryString "error") cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_InfixApply (Curry_Prelude.d_C_apply
  (Curry_AbstractHaskellGoodies.d_C_string2ac cd cs)
  (Curry_Prelude.d_OP_plus_plus (d_C_showQName (Curry_Prelude.d_C_apply
  (Curry_Names.d_C_unRenameQName cd cs) x1 cd cs) cd cs) (Curry_Prelude.OP_Cons
  (Curry_Prelude.C_Char '.'#) (Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.d_C_snd x2 cd cs) (Curry_Prelude.toCurryString
  ": Choices with ChoiceID: ") cd cs)) cd cs) cd cs)
  (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString "++") cd
  cs) (Curry_AbstractHaskellGoodies.d_C_applyF
  (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString "show") cd
  cs) (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x6)
  Curry_Prelude.OP_List) cd cs)) Curry_Prelude.OP_List) cd cs) cd cs)

d_OP_bindChoicesRule_dot_uscore_hash_selFP88_hash_us1 :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_bindChoicesRule_dot_uscore_hash_selFP88_hash_us1 x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_138 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_bindChoicesRule_dot_uscore_hash_selFP88_hash_us1 l cd cs)
    (d_OP_bindChoicesRule_dot_uscore_hash_selFP88_hash_us1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_bindChoicesRule_dot_uscore_hash_selFP88_hash_us1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_bindChoicesRule_dot_uscore_hash_selFP88_hash_us1 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.bindChoicesRule._#selFP88#us1" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.bindChoicesRule._#selFP88#us1"
    (showCons x1))

d_OP_bindChoicesRule_dot_uscore_hash_selFP89_hash_us2 :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_bindChoicesRule_dot_uscore_hash_selFP89_hash_us2 x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_135 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_bindChoicesRule_dot_uscore_hash_selFP89_hash_us2 l cd cs)
    (d_OP_bindChoicesRule_dot_uscore_hash_selFP89_hash_us2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_bindChoicesRule_dot_uscore_hash_selFP89_hash_us2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_bindChoicesRule_dot_uscore_hash_selFP89_hash_us2 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.bindChoicesRule._#selFP89#us2" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.bindChoicesRule._#selFP89#us2"
    (showCons x1))

d_OP_bindChoicesRule_dot_uscore_hash_selFP90_hash_i :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_bindChoicesRule_dot_uscore_hash_selFP90_hash_i x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_132 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_bindChoicesRule_dot_uscore_hash_selFP90_hash_i l cd cs)
    (d_OP_bindChoicesRule_dot_uscore_hash_selFP90_hash_i r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_bindChoicesRule_dot_uscore_hash_selFP90_hash_i z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_bindChoicesRule_dot_uscore_hash_selFP90_hash_i e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.bindChoicesRule._#selFP90#i" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.bindChoicesRule._#selFP90#i" (showCons
    x1))

d_C_bindFailRule :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_AbstractHaskell.C_Rule
d_C_bindFailRule x1 x2 cd cs = let x3 = Curry_Prelude.d_C_apply (d_C_newVars cd
                                     cs) (Curry_Prelude.OP_Cons
                                     (Curry_Prelude.toCurryString "info")
                                     Curry_Prelude.OP_List) cd cs
                                   x4 = d_OP_bindFailRule_dot_uscore_hash_selFP92_hash_info
                                     x3 cd cs
  in Curry_Prelude.OP_Tuple2 x2 (d_C_simpleRule (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int
  (1)) (Curry_Prelude.toCurryString "_"))) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int
  (2)) (Curry_Prelude.toCurryString "_"))) (Curry_Prelude.OP_Cons
  (d_C_mkFailPattern x1 cd cs) Curry_Prelude.OP_List)))
  (Curry_AbstractHaskellGoodies.d_C_list2ac (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
  (Curry_Prelude.toCurryString "Unsolvable") cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x4) Curry_Prelude.OP_List) cd cs)
  Curry_Prelude.OP_List) cd cs) cd cs)

d_OP_bindFailRule_dot_uscore_hash_selFP92_hash_info :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_bindFailRule_dot_uscore_hash_selFP92_hash_info x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_129 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_bindFailRule_dot_uscore_hash_selFP92_hash_info l cd cs)
    (d_OP_bindFailRule_dot_uscore_hash_selFP92_hash_info r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_bindFailRule_dot_uscore_hash_selFP92_hash_info z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_bindFailRule_dot_uscore_hash_selFP92_hash_info e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.bindFailRule._#selFP92#info" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.bindFailRule._#selFP92#info" (showCons
    x1))

d_C_bindGuardRule :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule
d_C_bindGuardRule x1 x2 cd cs = let x3 = Curry_Prelude.d_C_apply (d_C_newVars cd
                                      cs) (Curry_Prelude.OP_Cons
                                      (Curry_Prelude.toCurryString "d")
                                      (Curry_Prelude.OP_Cons
                                      (Curry_Prelude.toCurryString "i")
                                      (Curry_Prelude.OP_Cons
                                      (Curry_Prelude.toCurryString "c")
                                      (Curry_Prelude.OP_Cons
                                      (Curry_Prelude.toCurryString "e")
                                      Curry_Prelude.OP_List)))) cd cs
                                    x4 = d_OP_bindGuardRule_dot_uscore_hash_selFP94_hash_d
                                      x3 cd cs
                                    x5 = d_OP_bindGuardRule_dot_uscore_hash_selFP95_hash_i
                                      x3 cd cs
                                    x6 = d_OP_bindGuardRule_dot_uscore_hash_selFP96_hash_c
                                      x3 cd cs
                                    x7 = d_OP_bindGuardRule_dot_uscore_hash_selFP97_hash_e
                                      x3 cd cs
                                    x8 = Curry_Prelude.d_OP_dollar d_C_basics
                                      (d_C__case_128 x2 cd cs) cd cs
                                    x9 = d_C__case_127 x7 x5 x4 x8 x2 cd cs
  in Curry_Prelude.OP_Tuple2 x8 (d_C_simpleRule (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x4) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x5) (Curry_Prelude.OP_Cons (d_C_mkGuardPattern
  x1 cd cs) Curry_Prelude.OP_List))) (Curry_AbstractHaskell.C_InfixApply
  (Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
  (Curry_Prelude.toCurryString "getConstrList") cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_Var x6) Curry_Prelude.OP_List) cd cs)
  (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString "++") cd
  cs) x9) cd cs)

d_OP_bindGuardRule_dot_uscore_hash_selFP94_hash_d :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_bindGuardRule_dot_uscore_hash_selFP94_hash_d x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_126 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_bindGuardRule_dot_uscore_hash_selFP94_hash_d l cd cs)
    (d_OP_bindGuardRule_dot_uscore_hash_selFP94_hash_d r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_bindGuardRule_dot_uscore_hash_selFP94_hash_d z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_bindGuardRule_dot_uscore_hash_selFP94_hash_d e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.bindGuardRule._#selFP94#d" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.bindGuardRule._#selFP94#d" (showCons
    x1))

d_OP_bindGuardRule_dot_uscore_hash_selFP95_hash_i :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_bindGuardRule_dot_uscore_hash_selFP95_hash_i x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_122 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_bindGuardRule_dot_uscore_hash_selFP95_hash_i l cd cs)
    (d_OP_bindGuardRule_dot_uscore_hash_selFP95_hash_i r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_bindGuardRule_dot_uscore_hash_selFP95_hash_i z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_bindGuardRule_dot_uscore_hash_selFP95_hash_i e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.bindGuardRule._#selFP95#i" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.bindGuardRule._#selFP95#i" (showCons
    x1))

d_OP_bindGuardRule_dot_uscore_hash_selFP96_hash_c :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_bindGuardRule_dot_uscore_hash_selFP96_hash_c x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_118 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_bindGuardRule_dot_uscore_hash_selFP96_hash_c l cd cs)
    (d_OP_bindGuardRule_dot_uscore_hash_selFP96_hash_c r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_bindGuardRule_dot_uscore_hash_selFP96_hash_c z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_bindGuardRule_dot_uscore_hash_selFP96_hash_c e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.bindGuardRule._#selFP96#c" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.bindGuardRule._#selFP96#c" (showCons
    x1))

d_OP_bindGuardRule_dot_uscore_hash_selFP97_hash_e :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_bindGuardRule_dot_uscore_hash_selFP97_hash_e x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_114 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_bindGuardRule_dot_uscore_hash_selFP97_hash_e l cd cs)
    (d_OP_bindGuardRule_dot_uscore_hash_selFP97_hash_e r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_bindGuardRule_dot_uscore_hash_selFP97_hash_e z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_bindGuardRule_dot_uscore_hash_selFP97_hash_e e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.bindGuardRule._#selFP97#e" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.bindGuardRule._#selFP97#e" (showCons
    x1))

d_C_curryInstance :: Curry_Prelude.C_Bool -> FlatCurry.Curry_Types.C_TypeDecl
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeDecl
d_C_curryInstance x1 x2 cd cs = case x2 of
  FlatCurry.Curry_Types.C_Type x3 x4 x5 x6 -> let x7 = Curry_Prelude.d_C_map
                                                    d_C_fcy2absTVar x5 cd cs
                                                  x8 = Curry_AbstractHaskell.C_TCons
                                                    x3 (Curry_Prelude.d_C_map
                                                    (acceptCs id
                                                    Curry_AbstractHaskell.C_TVar)
                                                    x7 cd cs)
    in d_C__case_110 x1 x8 x7 (Curry_Prelude.d_C_not x1 cd cs) cd cs
  FlatCurry.Curry_Types.C_TypeSyn x9 x10 x11 x12 -> Curry_Prelude.d_C_error
    (Curry_Prelude.toCurryString "TransTypes.curryInstance") cd cs
  FlatCurry.Curry_Types.Choice_C_TypeDecl d i l r -> narrow d i
    (d_C_curryInstance x1 l cd cs) (d_C_curryInstance x1 r cd cs)
  FlatCurry.Curry_Types.Choices_C_TypeDecl d i xs -> narrows cs d i (\z ->
    d_C_curryInstance x1 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_TypeDecl d c e -> guardCons d c
    (d_C_curryInstance x1 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_TypeDecl d info -> failCons d (traceFail
    "TransTypes.curryInstance" [show x1, show x2] info)
  _ -> failCons cd (consFail "TransTypes.curryInstance" (showCons x2))

d_C_mkChoicePattern :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Pattern
d_C_mkChoicePattern x1 x2 cd cs = let x3 = Curry_Prelude.d_C_apply (d_C_newVars
                                        cd cs) (Curry_Prelude.OP_Cons
                                        (Curry_Prelude.toCurryString "cd")
                                        (Curry_Prelude.OP_Cons x2
                                        (Curry_Prelude.OP_Cons
                                        (Curry_Prelude.toCurryString "x")
                                        (Curry_Prelude.OP_Cons
                                        (Curry_Prelude.toCurryString "y")
                                        Curry_Prelude.OP_List)))) cd cs
                                      x4 = d_OP_mkChoicePattern_dot_uscore_hash_selFP99_hash_cd
                                        x3 cd cs
                                      x5 = d_OP_mkChoicePattern_dot_uscore_hash_selFP100_hash_idVar
                                        x3 cd cs
                                      x6 = d_OP_mkChoicePattern_dot_uscore_hash_selFP101_hash_x
                                        x3 cd cs
                                      x7 = d_OP_mkChoicePattern_dot_uscore_hash_selFP102_hash_y
                                        x3 cd cs
  in Curry_AbstractHaskell.C_PComb (Curry_Prelude.d_C_apply
  (Curry_Names.d_C_mkChoiceName cd cs) x1 cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x4) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x5) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x6) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x7) Curry_Prelude.OP_List))))

d_OP_mkChoicePattern_dot_uscore_hash_selFP99_hash_cd :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_mkChoicePattern_dot_uscore_hash_selFP99_hash_cd x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_108 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_mkChoicePattern_dot_uscore_hash_selFP99_hash_cd l cd cs)
    (d_OP_mkChoicePattern_dot_uscore_hash_selFP99_hash_cd r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_mkChoicePattern_dot_uscore_hash_selFP99_hash_cd z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_mkChoicePattern_dot_uscore_hash_selFP99_hash_cd e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.mkChoicePattern._#selFP99#cd" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.mkChoicePattern._#selFP99#cd" (showCons
    x1))

d_OP_mkChoicePattern_dot_uscore_hash_selFP100_hash_idVar :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_mkChoicePattern_dot_uscore_hash_selFP100_hash_idVar x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_104 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_mkChoicePattern_dot_uscore_hash_selFP100_hash_idVar l cd cs)
    (d_OP_mkChoicePattern_dot_uscore_hash_selFP100_hash_idVar r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_mkChoicePattern_dot_uscore_hash_selFP100_hash_idVar z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_mkChoicePattern_dot_uscore_hash_selFP100_hash_idVar e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.mkChoicePattern._#selFP100#idVar" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.mkChoicePattern._#selFP100#idVar"
    (showCons x1))

d_OP_mkChoicePattern_dot_uscore_hash_selFP101_hash_x :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_mkChoicePattern_dot_uscore_hash_selFP101_hash_x x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_100 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_mkChoicePattern_dot_uscore_hash_selFP101_hash_x l cd cs)
    (d_OP_mkChoicePattern_dot_uscore_hash_selFP101_hash_x r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_mkChoicePattern_dot_uscore_hash_selFP101_hash_x z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_mkChoicePattern_dot_uscore_hash_selFP101_hash_x e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.mkChoicePattern._#selFP101#x" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.mkChoicePattern._#selFP101#x" (showCons
    x1))

d_OP_mkChoicePattern_dot_uscore_hash_selFP102_hash_y :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_mkChoicePattern_dot_uscore_hash_selFP102_hash_y x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_96 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_mkChoicePattern_dot_uscore_hash_selFP102_hash_y l cd cs)
    (d_OP_mkChoicePattern_dot_uscore_hash_selFP102_hash_y r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_mkChoicePattern_dot_uscore_hash_selFP102_hash_y z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_mkChoicePattern_dot_uscore_hash_selFP102_hash_y e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.mkChoicePattern._#selFP102#y" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.mkChoicePattern._#selFP102#y" (showCons
    x1))

d_C_mkChoicesPattern :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Pattern
d_C_mkChoicesPattern x1 cd cs = let x2 = Curry_Prelude.d_C_apply (d_C_newVars cd
                                      cs) (Curry_Prelude.OP_Cons
                                      (Curry_Prelude.toCurryString "cd")
                                      (Curry_Prelude.OP_Cons
                                      (Curry_Prelude.toCurryString "i")
                                      (Curry_Prelude.OP_Cons
                                      (Curry_Prelude.toCurryString "xs")
                                      Curry_Prelude.OP_List))) cd cs
                                    x3 = d_OP_mkChoicesPattern_dot_uscore_hash_selFP104_hash_cd
                                      x2 cd cs
                                    x4 = d_OP_mkChoicesPattern_dot_uscore_hash_selFP105_hash_i
                                      x2 cd cs
                                    x5 = d_OP_mkChoicesPattern_dot_uscore_hash_selFP106_hash_xs
                                      x2 cd cs
  in Curry_AbstractHaskell.C_PComb (Curry_Prelude.d_C_apply
  (Curry_Names.d_C_mkChoicesName cd cs) x1 cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x3) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x4) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x5) Curry_Prelude.OP_List)))

d_OP_mkChoicesPattern_dot_uscore_hash_selFP104_hash_cd :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_mkChoicesPattern_dot_uscore_hash_selFP104_hash_cd x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_92 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_mkChoicesPattern_dot_uscore_hash_selFP104_hash_cd l cd cs)
    (d_OP_mkChoicesPattern_dot_uscore_hash_selFP104_hash_cd r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_mkChoicesPattern_dot_uscore_hash_selFP104_hash_cd z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_mkChoicesPattern_dot_uscore_hash_selFP104_hash_cd e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.mkChoicesPattern._#selFP104#cd" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.mkChoicesPattern._#selFP104#cd"
    (showCons x1))

d_OP_mkChoicesPattern_dot_uscore_hash_selFP105_hash_i :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_mkChoicesPattern_dot_uscore_hash_selFP105_hash_i x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_89 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_mkChoicesPattern_dot_uscore_hash_selFP105_hash_i l cd cs)
    (d_OP_mkChoicesPattern_dot_uscore_hash_selFP105_hash_i r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_mkChoicesPattern_dot_uscore_hash_selFP105_hash_i z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_mkChoicesPattern_dot_uscore_hash_selFP105_hash_i e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.mkChoicesPattern._#selFP105#i" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.mkChoicesPattern._#selFP105#i"
    (showCons x1))

d_OP_mkChoicesPattern_dot_uscore_hash_selFP106_hash_xs :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_mkChoicesPattern_dot_uscore_hash_selFP106_hash_xs x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_86 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_mkChoicesPattern_dot_uscore_hash_selFP106_hash_xs l cd cs)
    (d_OP_mkChoicesPattern_dot_uscore_hash_selFP106_hash_xs r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_mkChoicesPattern_dot_uscore_hash_selFP106_hash_xs z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_mkChoicesPattern_dot_uscore_hash_selFP106_hash_xs e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.mkChoicesPattern._#selFP106#xs" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.mkChoicesPattern._#selFP106#xs"
    (showCons x1))

d_C_mkNarrowedChoicesPattern :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Pattern
d_C_mkNarrowedChoicesPattern x1 x2 cd cs = let x3 = Curry_Prelude.d_C_apply
                                                 (d_C_newVars cd cs)
                                                 (Curry_Prelude.OP_Cons x2
                                                 (Curry_Prelude.OP_Cons
                                                 (Curry_Prelude.toCurryString
                                                 "cd") (Curry_Prelude.OP_Cons
                                                 (Curry_Prelude.toCurryString
                                                 "_") (Curry_Prelude.OP_Cons
                                                 (Curry_Prelude.toCurryString
                                                 "_") (Curry_Prelude.OP_Cons
                                                 (Curry_Prelude.toCurryString
                                                 "xs")
                                                 Curry_Prelude.OP_List))))) cd
                                                 cs
                                               x4 = d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP108_hash_i
                                                 x3 cd cs
                                               x5 = d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP109_hash_cd
                                                 x3 cd cs
                                               x6 = d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP110_hash_u1
                                                 x3 cd cs
                                               x7 = d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP111_hash_u2
                                                 x3 cd cs
                                               x8 = d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP112_hash_xs
                                                 x3 cd cs
  in Curry_AbstractHaskell.C_PComb (Curry_Prelude.d_C_apply
  (Curry_Names.d_C_mkChoicesName cd cs) x1 cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x5) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PAs x4 (Curry_AbstractHaskell.C_PComb (d_C_basics
  (Curry_Prelude.toCurryString "NarrowedID") cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x6) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x7) Curry_Prelude.OP_List))))
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_PVar x8)
  Curry_Prelude.OP_List)))

d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP108_hash_i :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP108_hash_i x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_83 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP108_hash_i l cd cs)
    (d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP108_hash_i r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP108_hash_i z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP108_hash_i e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.mkNarrowedChoicesPattern._#selFP108#i" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.mkNarrowedChoicesPattern._#selFP108#i"
    (showCons x1))

d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP109_hash_cd :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP109_hash_cd x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_78 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP109_hash_cd l cd cs)
    (d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP109_hash_cd r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP109_hash_cd z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP109_hash_cd e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.mkNarrowedChoicesPattern._#selFP109#cd" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.mkNarrowedChoicesPattern._#selFP109#cd"
    (showCons x1))

d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP110_hash_u1 :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP110_hash_u1 x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_73 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP110_hash_u1 l cd cs)
    (d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP110_hash_u1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP110_hash_u1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP110_hash_u1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.mkNarrowedChoicesPattern._#selFP110#u1" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.mkNarrowedChoicesPattern._#selFP110#u1"
    (showCons x1))

d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP111_hash_u2 :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP111_hash_u2 x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_68 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP111_hash_u2 l cd cs)
    (d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP111_hash_u2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP111_hash_u2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP111_hash_u2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.mkNarrowedChoicesPattern._#selFP111#u2" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.mkNarrowedChoicesPattern._#selFP111#u2"
    (showCons x1))

d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP112_hash_xs :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP112_hash_xs x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_63 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP112_hash_xs l cd cs)
    (d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP112_hash_xs r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP112_hash_xs z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_mkNarrowedChoicesPattern_dot_uscore_hash_selFP112_hash_xs e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.mkNarrowedChoicesPattern._#selFP112#xs" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.mkNarrowedChoicesPattern._#selFP112#xs"
    (showCons x1))

d_C_mkFreeChoicesPattern :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Pattern
d_C_mkFreeChoicesPattern x1 x2 cd cs = let x3 = Curry_Prelude.d_C_apply
                                             (d_C_newVars cd cs)
                                             (Curry_Prelude.OP_Cons x2
                                             (Curry_Prelude.OP_Cons
                                             (Curry_Prelude.toCurryString "cd")
                                             (Curry_Prelude.OP_Cons
                                             (Curry_Prelude.toCurryString "_")
                                             (Curry_Prelude.OP_Cons
                                             (Curry_Prelude.toCurryString "_")
                                             (Curry_Prelude.OP_Cons
                                             (Curry_Prelude.toCurryString "xs")
                                             Curry_Prelude.OP_List))))) cd cs
                                           x4 = d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP114_hash_i
                                             x3 cd cs
                                           x5 = d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP115_hash_cd
                                             x3 cd cs
                                           x6 = d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP116_hash_u1
                                             x3 cd cs
                                           x7 = d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP117_hash_u2
                                             x3 cd cs
                                           x8 = d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP118_hash_xs
                                             x3 cd cs
  in Curry_AbstractHaskell.C_PComb (Curry_Prelude.d_C_apply
  (Curry_Names.d_C_mkChoicesName cd cs) x1 cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x5) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PAs x4 (Curry_AbstractHaskell.C_PComb (d_C_basics
  (Curry_Prelude.toCurryString "FreeID") cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x6) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x7) Curry_Prelude.OP_List))))
  (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_PVar x8)
  Curry_Prelude.OP_List)))

d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP114_hash_i :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP114_hash_i x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_58 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP114_hash_i l cd cs)
    (d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP114_hash_i r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP114_hash_i z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP114_hash_i e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.mkFreeChoicesPattern._#selFP114#i" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.mkFreeChoicesPattern._#selFP114#i"
    (showCons x1))

d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP115_hash_cd :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP115_hash_cd x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_53 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP115_hash_cd l cd cs)
    (d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP115_hash_cd r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP115_hash_cd z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP115_hash_cd e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.mkFreeChoicesPattern._#selFP115#cd" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.mkFreeChoicesPattern._#selFP115#cd"
    (showCons x1))

d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP116_hash_u1 :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP116_hash_u1 x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_48 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP116_hash_u1 l cd cs)
    (d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP116_hash_u1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP116_hash_u1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP116_hash_u1 e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.mkFreeChoicesPattern._#selFP116#u1" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.mkFreeChoicesPattern._#selFP116#u1"
    (showCons x1))

d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP117_hash_u2 :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP117_hash_u2 x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_43 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP117_hash_u2 l cd cs)
    (d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP117_hash_u2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP117_hash_u2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP117_hash_u2 e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.mkFreeChoicesPattern._#selFP117#u2" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.mkFreeChoicesPattern._#selFP117#u2"
    (showCons x1))

d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP118_hash_xs :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP118_hash_xs x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_38 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP118_hash_xs l cd cs)
    (d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP118_hash_xs r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP118_hash_xs z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_mkFreeChoicesPattern_dot_uscore_hash_selFP118_hash_xs e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.mkFreeChoicesPattern._#selFP118#xs" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.mkFreeChoicesPattern._#selFP118#xs"
    (showCons x1))

d_C_mkVarChoicesPattern :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Pattern
d_C_mkVarChoicesPattern x1 cd cs = let x2 = Curry_Prelude.d_C_apply (d_C_newVars
                                         cd cs) (Curry_Prelude.OP_Cons
                                         (Curry_Prelude.toCurryString "cd")
                                         (Curry_Prelude.OP_Cons
                                         (Curry_Prelude.toCurryString "i")
                                         (Curry_Prelude.OP_Cons
                                         (Curry_Prelude.toCurryString "_")
                                         Curry_Prelude.OP_List))) cd cs
                                       x3 = d_OP_mkVarChoicesPattern_dot_uscore_hash_selFP120_hash_cd
                                         x2 cd cs
                                       x4 = d_OP_mkVarChoicesPattern_dot_uscore_hash_selFP121_hash_i
                                         x2 cd cs
                                       x5 = d_OP_mkVarChoicesPattern_dot_uscore_hash_selFP122_hash_xs
                                         x2 cd cs
  in Curry_AbstractHaskell.C_PComb (Curry_Prelude.d_C_apply
  (Curry_Names.d_C_mkChoicesName cd cs) x1 cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x3) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x4) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x5) Curry_Prelude.OP_List)))

d_OP_mkVarChoicesPattern_dot_uscore_hash_selFP120_hash_cd :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_mkVarChoicesPattern_dot_uscore_hash_selFP120_hash_cd x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_33 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_mkVarChoicesPattern_dot_uscore_hash_selFP120_hash_cd l cd cs)
    (d_OP_mkVarChoicesPattern_dot_uscore_hash_selFP120_hash_cd r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_mkVarChoicesPattern_dot_uscore_hash_selFP120_hash_cd z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_mkVarChoicesPattern_dot_uscore_hash_selFP120_hash_cd e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.mkVarChoicesPattern._#selFP120#cd" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.mkVarChoicesPattern._#selFP120#cd"
    (showCons x1))

d_OP_mkVarChoicesPattern_dot_uscore_hash_selFP121_hash_i :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_mkVarChoicesPattern_dot_uscore_hash_selFP121_hash_i x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_30 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_mkVarChoicesPattern_dot_uscore_hash_selFP121_hash_i l cd cs)
    (d_OP_mkVarChoicesPattern_dot_uscore_hash_selFP121_hash_i r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_mkVarChoicesPattern_dot_uscore_hash_selFP121_hash_i z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_mkVarChoicesPattern_dot_uscore_hash_selFP121_hash_i e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.mkVarChoicesPattern._#selFP121#i" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.mkVarChoicesPattern._#selFP121#i"
    (showCons x1))

d_OP_mkVarChoicesPattern_dot_uscore_hash_selFP122_hash_xs :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_mkVarChoicesPattern_dot_uscore_hash_selFP122_hash_xs x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_27 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_mkVarChoicesPattern_dot_uscore_hash_selFP122_hash_xs l cd cs)
    (d_OP_mkVarChoicesPattern_dot_uscore_hash_selFP122_hash_xs r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_mkVarChoicesPattern_dot_uscore_hash_selFP122_hash_xs z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_mkVarChoicesPattern_dot_uscore_hash_selFP122_hash_xs e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.mkVarChoicesPattern._#selFP122#xs" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.mkVarChoicesPattern._#selFP122#xs"
    (showCons x1))

d_C_mkFailPattern :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Pattern
d_C_mkFailPattern x1 cd cs = let x2 = Curry_Prelude.d_C_apply (d_C_newVars cd
                                   cs) (Curry_Prelude.OP_Cons
                                   (Curry_Prelude.toCurryString "cd")
                                   (Curry_Prelude.OP_Cons
                                   (Curry_Prelude.toCurryString "info")
                                   Curry_Prelude.OP_List)) cd cs
                                 x3 = d_OP_mkFailPattern_dot_uscore_hash_selFP124_hash_cd
                                   x2 cd cs
                                 x4 = d_OP_mkFailPattern_dot_uscore_hash_selFP125_hash_info
                                   x2 cd cs
  in Curry_AbstractHaskell.C_PComb (Curry_Prelude.d_C_apply
  (Curry_Names.d_C_mkFailName cd cs) x1 cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x3) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x4) Curry_Prelude.OP_List))

d_OP_mkFailPattern_dot_uscore_hash_selFP124_hash_cd :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_mkFailPattern_dot_uscore_hash_selFP124_hash_cd x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_24 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_mkFailPattern_dot_uscore_hash_selFP124_hash_cd l cd cs)
    (d_OP_mkFailPattern_dot_uscore_hash_selFP124_hash_cd r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_mkFailPattern_dot_uscore_hash_selFP124_hash_cd z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_mkFailPattern_dot_uscore_hash_selFP124_hash_cd e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.mkFailPattern._#selFP124#cd" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.mkFailPattern._#selFP124#cd" (showCons
    x1))

d_OP_mkFailPattern_dot_uscore_hash_selFP125_hash_info :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_mkFailPattern_dot_uscore_hash_selFP125_hash_info x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_22 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_mkFailPattern_dot_uscore_hash_selFP125_hash_info l cd cs)
    (d_OP_mkFailPattern_dot_uscore_hash_selFP125_hash_info r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_mkFailPattern_dot_uscore_hash_selFP125_hash_info z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_mkFailPattern_dot_uscore_hash_selFP125_hash_info e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.mkFailPattern._#selFP125#info" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.mkFailPattern._#selFP125#info"
    (showCons x1))

d_C_mkGuardPattern :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Pattern
d_C_mkGuardPattern x1 cd cs = let x2 = Curry_Prelude.d_C_apply (d_C_newVars cd
                                    cs) (Curry_Prelude.OP_Cons
                                    (Curry_Prelude.toCurryString "cd")
                                    (Curry_Prelude.OP_Cons
                                    (Curry_Prelude.toCurryString "c")
                                    (Curry_Prelude.OP_Cons
                                    (Curry_Prelude.toCurryString "e")
                                    Curry_Prelude.OP_List))) cd cs
                                  x3 = d_OP_mkGuardPattern_dot_uscore_hash_selFP127_hash_cd
                                    x2 cd cs
                                  x4 = d_OP_mkGuardPattern_dot_uscore_hash_selFP128_hash_c
                                    x2 cd cs
                                  x5 = d_OP_mkGuardPattern_dot_uscore_hash_selFP129_hash_e
                                    x2 cd cs
  in Curry_AbstractHaskell.C_PComb (Curry_Prelude.d_C_apply
  (Curry_Names.d_C_mkGuardName cd cs) x1 cd cs) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x3) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x4) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar x5) Curry_Prelude.OP_List)))

d_OP_mkGuardPattern_dot_uscore_hash_selFP127_hash_cd :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_mkGuardPattern_dot_uscore_hash_selFP127_hash_cd x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_20 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_mkGuardPattern_dot_uscore_hash_selFP127_hash_cd l cd cs)
    (d_OP_mkGuardPattern_dot_uscore_hash_selFP127_hash_cd r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_mkGuardPattern_dot_uscore_hash_selFP127_hash_cd z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_mkGuardPattern_dot_uscore_hash_selFP127_hash_cd e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.mkGuardPattern._#selFP127#cd" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.mkGuardPattern._#selFP127#cd" (showCons
    x1))

d_OP_mkGuardPattern_dot_uscore_hash_selFP128_hash_c :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_mkGuardPattern_dot_uscore_hash_selFP128_hash_c x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_17 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_mkGuardPattern_dot_uscore_hash_selFP128_hash_c l cd cs)
    (d_OP_mkGuardPattern_dot_uscore_hash_selFP128_hash_c r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_mkGuardPattern_dot_uscore_hash_selFP128_hash_c z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_mkGuardPattern_dot_uscore_hash_selFP128_hash_c e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.mkGuardPattern._#selFP128#c" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.mkGuardPattern._#selFP128#c" (showCons
    x1))

d_OP_mkGuardPattern_dot_uscore_hash_selFP129_hash_e :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_mkGuardPattern_dot_uscore_hash_selFP129_hash_e x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_14 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_mkGuardPattern_dot_uscore_hash_selFP129_hash_e l cd cs)
    (d_OP_mkGuardPattern_dot_uscore_hash_selFP129_hash_e r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_mkGuardPattern_dot_uscore_hash_selFP129_hash_e z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_mkGuardPattern_dot_uscore_hash_selFP129_hash_e e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes.mkGuardPattern._#selFP129#e" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.mkGuardPattern._#selFP129#e" (showCons
    x1))

d_C_mkPVar :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Pattern
d_C_mkPVar x1 x2 cd cs = Curry_Prelude.d_OP_dollar (acceptCs id
  Curry_AbstractHaskell.C_PVar) (d_C_mkVarName x1 x2 cd cs) cd cs

d_C_mkVar :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C_mkVar x1 x2 cd cs = Curry_Prelude.d_OP_dollar (acceptCs id
  Curry_AbstractHaskell.C_Var) (d_C_mkVarName x1 x2 cd cs) cd cs

d_C_mkTVar :: Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeExpr
d_C_mkTVar x1 cd cs = Curry_AbstractHaskell.C_TVar (Curry_Prelude.OP_Tuple2 x1
  (Curry_Prelude.OP_Cons (Curry_Prelude.C_Char 't'#) (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Int
  cd cs) x1 cd cs)))

d_C_mkVarName :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_mkVarName x1 x2 cd cs = d_C__case_11 x1 x2
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) x1 (Curry_Prelude.toCurryString "_") cd cs) cd cs

d_C_newVars :: Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_newVars cd cs = Curry_Prelude.d_C_zip (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_enumFrom_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
  cd cs) (Curry_Prelude.C_Int (1)) cd cs)

d_C_mkInstance :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Curry_AbstractHaskell.C_TypeExpr -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_AbstractHaskell.C_Rule) -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeDecl
d_C_mkInstance x1 x2 x3 x4 cd cs = Curry_Prelude.d_OP_dollar (acceptCs (acceptCs
  id) (Curry_AbstractHaskell.C_Instance x1 x3)) (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_concatMap (d_OP_mkInstance_dot_uscore_hash_lambda38 x4) cd
  cs) (Curry_Prelude.OP_Cons x1 x2) cd cs) cd cs

d_OP_mkInstance_dot_uscore_hash_lambda38 :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_Context
d_OP_mkInstance_dot_uscore_hash_lambda38 x1 x2 cd cs = Curry_Prelude.d_C_map
  (d_OP_mkInstance_dot_uscore_hash_lambda38_dot_uscore_hash_lambda39 x2) x1 cd
  cs

d_OP_mkInstance_dot_uscore_hash_lambda38_dot_uscore_hash_lambda39 :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Context
d_OP_mkInstance_dot_uscore_hash_lambda38_dot_uscore_hash_lambda39 x1 x2 cd cs =
  Curry_AbstractHaskell.C_Context x1 (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_TVar x2) Curry_Prelude.OP_List)

d_C_mkEmptyInstance :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_AbstractHaskell.C_TypeExpr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeDecl
d_C_mkEmptyInstance x1 x2 cd cs = Curry_AbstractHaskell.C_Instance x1 x2
  Curry_Prelude.OP_List Curry_Prelude.OP_List

d_C_consPattern :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Pattern
d_C_consPattern x1 x2 x3 cd cs = Curry_Prelude.d_OP_dollar (acceptCs id
  (Curry_AbstractHaskell.C_PComb x1)) (Curry_Prelude.d_C_map
  (Curry_Prelude.d_OP_dot (acceptCs id Curry_AbstractHaskell.C_PVar)
  (d_C_mkVarName x2) cd cs) (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_enumFromTo_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
  cd cs) (Curry_Prelude.C_Int (1)) cd cs) x3 cd cs) cd cs) cd cs

d_C_catchAllCase :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
d_C_catchAllCase x1 x2 cd cs = Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple2 x1
  (d_C_simpleRule (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_PVar
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int (1))
  (Curry_Prelude.toCurryString "_"))) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int
  (2)) (Curry_Prelude.toCurryString "_"))) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int
  (3)) (Curry_Prelude.toCurryString "d"))) (Curry_Prelude.OP_Cons
  (Curry_AbstractHaskell.C_PVar (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int
  (4)) (Curry_Prelude.toCurryString "_"))) Curry_Prelude.OP_List)))) x2 cd cs))
  Curry_Prelude.OP_List

d_C_simpleRule :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Pattern
  -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Rule
d_C_simpleRule x1 x2 cd cs = Curry_AbstractHaskell.C_Rule x1
  (Curry_AbstractHaskell.C_SimpleRhs x2) Curry_Prelude.OP_List

d_C_intc :: Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C_intc x1 cd cs = Curry_Prelude.d_OP_dollar (acceptCs id
  Curry_AbstractHaskell.C_Lit) (Curry_AbstractHaskell.C_Intc x1) cd cs

d_C_charc :: Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C_charc x1 cd cs = Curry_Prelude.d_OP_dollar (acceptCs id
  Curry_AbstractHaskell.C_Lit) (Curry_AbstractHaskell.C_Charc x1) cd cs

d_C_mkIdList :: Curry_Prelude.C_Int -> Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr
d_C_mkIdList x1 x2 cd cs = d_C__case_9 x1 x2
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
  x1 (Curry_Prelude.C_Int (0)) cd cs) cd cs

d_OP_mkIdList_dot_mkIdList_tick_dot_394 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Integral t0 -> t0
  -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr
d_OP_mkIdList_dot_mkIdList_tick_dot_394 x1 x2 x3 cd cs =
  let x4 = Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
        (Curry_Prelude.d_C_div x1 cd cs) x2 cd cs) (Curry_Prelude.d_C_apply
        (Curry_Prelude.d_C_fromInt
        (Curry_Prelude.d_OP_uscore_super_hash_Prelude_dot_Real_hash_Prelude_dot_Num
        (Curry_Prelude.d_OP_uscore_super_hash_Prelude_dot_Integral_hash_Prelude_dot_Real
        x1 cd cs) cd cs) cd cs) (Curry_Prelude.C_Int (2)) cd cs) cd cs
  in d_C__case_6 x1 x2 x3 x4 (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_eq_eq
  (Curry_Prelude.d_OP_uscore_super_hash_Prelude_dot_Ord_hash_Prelude_dot_Eq
  (Curry_Prelude.d_OP_uscore_super_hash_Prelude_dot_Real_hash_Prelude_dot_Ord
  (Curry_Prelude.d_OP_uscore_super_hash_Prelude_dot_Integral_hash_Prelude_dot_Real
  x1 cd cs) cd cs) cd cs) cd cs) x2 cd cs) (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_fromInt
  (Curry_Prelude.d_OP_uscore_super_hash_Prelude_dot_Real_hash_Prelude_dot_Num
  (Curry_Prelude.d_OP_uscore_super_hash_Prelude_dot_Integral_hash_Prelude_dot_Real
  x1 cd cs) cd cs) cd cs) (Curry_Prelude.C_Int (1)) cd cs) cd cs) cd cs

nd_OP_mkIdList_dot_mkIdList_tick_dot_394 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Integral t0 -> t0
  -> Curry_AbstractHaskell.C_Expr -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr
nd_OP_mkIdList_dot_mkIdList_tick_dot_394 x1 x2 x3 s cd cs = let s34 = s
  in s34 `seq` (let s11 = leftSupply s34
                    s33 = rightSupply s34
  in s11 `seq` (s33 `seq` (let x4 = let s10 = leftSupply s11
                                        s12 = rightSupply s11
                                        s2 = leftSupply s12
                                        s9 = rightSupply s12
                                 in s10 `seq` (s12 `seq` (s2 `seq` (s9 `seq`
                                 Curry_Prelude.nd_C_apply (let s1 = leftSupply
                                                                 s2
                                                               s0 = rightSupply
                                                                 s2
                                 in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply
                                 (Curry_Prelude.nd_C_div x1 s0 cd cs) x2 s1 cd
                                 cs)) (let s8 = leftSupply s9
                                           s7 = rightSupply s9
                                 in s8 `seq` (s7 `seq` Curry_Prelude.nd_C_apply
                                 (let s6 = leftSupply s7
                                      s5 = rightSupply s7
                                 in s6 `seq` (s5 `seq`
                                 Curry_Prelude.nd_C_fromInt (let s4 = leftSupply
                                                                   s5
                                                                 s3 = rightSupply
                                                                   s5
                                 in s4 `seq` (s3 `seq`
                                 Curry_Prelude.nd_OP_uscore_super_hash_Prelude_dot_Real_hash_Prelude_dot_Num
                                 (Curry_Prelude.nd_OP_uscore_super_hash_Prelude_dot_Integral_hash_Prelude_dot_Real
                                 x1 s3 cd cs) s4 cd cs)) s6 cd cs))
                                 (Curry_Prelude.C_Int (2)) s8 cd cs)) s10 cd
                                 cs)))
  in let s32 = leftSupply s33
         s30 = rightSupply s33
  in s32 `seq` (s30 `seq` nd_C__case_6 x1 x2 x3 x4 (let s29 = leftSupply s30
                                                        s31 = rightSupply s30
                                                        s21 = leftSupply s31
                                                        s28 = rightSupply s31
  in s29 `seq` (s31 `seq` (s21 `seq` (s28 `seq` Curry_Prelude.nd_C_apply
  (let s20 = leftSupply s21
       s19 = rightSupply s21
  in s20 `seq` (s19 `seq` Curry_Prelude.nd_C_apply (let s18 = leftSupply s19
                                                        s17 = rightSupply s19
  in s18 `seq` (s17 `seq` Curry_Prelude.nd_OP_eq_eq (let s16 = leftSupply s17
                                                         s15 = rightSupply s17
  in s16 `seq` (s15 `seq`
  Curry_Prelude.nd_OP_uscore_super_hash_Prelude_dot_Ord_hash_Prelude_dot_Eq
  (let s14 = leftSupply s15
       s13 = rightSupply s15
  in s14 `seq` (s13 `seq`
  Curry_Prelude.nd_OP_uscore_super_hash_Prelude_dot_Real_hash_Prelude_dot_Ord
  (Curry_Prelude.nd_OP_uscore_super_hash_Prelude_dot_Integral_hash_Prelude_dot_Real
  x1 s13 cd cs) s14 cd cs)) s16 cd cs)) s18 cd cs)) x2 s20 cd cs))
  (let s27 = leftSupply s28
       s26 = rightSupply s28
  in s27 `seq` (s26 `seq` Curry_Prelude.nd_C_apply (let s25 = leftSupply s26
                                                        s24 = rightSupply s26
  in s25 `seq` (s24 `seq` Curry_Prelude.nd_C_fromInt (let s23 = leftSupply s24
                                                          s22 = rightSupply s24
  in s23 `seq` (s22 `seq`
  Curry_Prelude.nd_OP_uscore_super_hash_Prelude_dot_Real_hash_Prelude_dot_Num
  (Curry_Prelude.nd_OP_uscore_super_hash_Prelude_dot_Integral_hash_Prelude_dot_Real
  x1 s22 cd cs) s23 cd cs)) s25 cd cs)) (Curry_Prelude.C_Int (1)) s27 cd cs))
  s29 cd cs)))) s32 cd cs))))

d_C_mkSuppList :: Curry_Prelude.C_Int -> Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr
d_C_mkSuppList x1 x2 cd cs = d_C__case_4 x1 x2
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
  x1 (Curry_Prelude.C_Int (0)) cd cs) cd cs

d_OP_mkSuppList_dot_mkSuppList_tick_dot_399 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Integral t0 -> t0
  -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr
d_OP_mkSuppList_dot_mkSuppList_tick_dot_399 x1 x2 x3 cd cs =
  let x4 = Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
        (Curry_Prelude.d_C_div x1 cd cs) x2 cd cs) (Curry_Prelude.d_C_apply
        (Curry_Prelude.d_C_fromInt
        (Curry_Prelude.d_OP_uscore_super_hash_Prelude_dot_Real_hash_Prelude_dot_Num
        (Curry_Prelude.d_OP_uscore_super_hash_Prelude_dot_Integral_hash_Prelude_dot_Real
        x1 cd cs) cd cs) cd cs) (Curry_Prelude.C_Int (2)) cd cs) cd cs
  in d_C__case_1 x1 x2 x3 x4 (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_eq_eq
  (Curry_Prelude.d_OP_uscore_super_hash_Prelude_dot_Ord_hash_Prelude_dot_Eq
  (Curry_Prelude.d_OP_uscore_super_hash_Prelude_dot_Real_hash_Prelude_dot_Ord
  (Curry_Prelude.d_OP_uscore_super_hash_Prelude_dot_Integral_hash_Prelude_dot_Real
  x1 cd cs) cd cs) cd cs) cd cs) x2 cd cs) (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_fromInt
  (Curry_Prelude.d_OP_uscore_super_hash_Prelude_dot_Real_hash_Prelude_dot_Num
  (Curry_Prelude.d_OP_uscore_super_hash_Prelude_dot_Integral_hash_Prelude_dot_Real
  x1 cd cs) cd cs) cd cs) (Curry_Prelude.C_Int (1)) cd cs) cd cs) cd cs

nd_OP_mkSuppList_dot_mkSuppList_tick_dot_399 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Integral t0 -> t0
  -> Curry_AbstractHaskell.C_Expr -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr
nd_OP_mkSuppList_dot_mkSuppList_tick_dot_399 x1 x2 x3 s cd cs = let s34 = s
  in s34 `seq` (let s11 = leftSupply s34
                    s33 = rightSupply s34
  in s11 `seq` (s33 `seq` (let x4 = let s10 = leftSupply s11
                                        s12 = rightSupply s11
                                        s2 = leftSupply s12
                                        s9 = rightSupply s12
                                 in s10 `seq` (s12 `seq` (s2 `seq` (s9 `seq`
                                 Curry_Prelude.nd_C_apply (let s1 = leftSupply
                                                                 s2
                                                               s0 = rightSupply
                                                                 s2
                                 in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply
                                 (Curry_Prelude.nd_C_div x1 s0 cd cs) x2 s1 cd
                                 cs)) (let s8 = leftSupply s9
                                           s7 = rightSupply s9
                                 in s8 `seq` (s7 `seq` Curry_Prelude.nd_C_apply
                                 (let s6 = leftSupply s7
                                      s5 = rightSupply s7
                                 in s6 `seq` (s5 `seq`
                                 Curry_Prelude.nd_C_fromInt (let s4 = leftSupply
                                                                   s5
                                                                 s3 = rightSupply
                                                                   s5
                                 in s4 `seq` (s3 `seq`
                                 Curry_Prelude.nd_OP_uscore_super_hash_Prelude_dot_Real_hash_Prelude_dot_Num
                                 (Curry_Prelude.nd_OP_uscore_super_hash_Prelude_dot_Integral_hash_Prelude_dot_Real
                                 x1 s3 cd cs) s4 cd cs)) s6 cd cs))
                                 (Curry_Prelude.C_Int (2)) s8 cd cs)) s10 cd
                                 cs)))
  in let s32 = leftSupply s33
         s30 = rightSupply s33
  in s32 `seq` (s30 `seq` nd_C__case_1 x1 x2 x3 x4 (let s29 = leftSupply s30
                                                        s31 = rightSupply s30
                                                        s21 = leftSupply s31
                                                        s28 = rightSupply s31
  in s29 `seq` (s31 `seq` (s21 `seq` (s28 `seq` Curry_Prelude.nd_C_apply
  (let s20 = leftSupply s21
       s19 = rightSupply s21
  in s20 `seq` (s19 `seq` Curry_Prelude.nd_C_apply (let s18 = leftSupply s19
                                                        s17 = rightSupply s19
  in s18 `seq` (s17 `seq` Curry_Prelude.nd_OP_eq_eq (let s16 = leftSupply s17
                                                         s15 = rightSupply s17
  in s16 `seq` (s15 `seq`
  Curry_Prelude.nd_OP_uscore_super_hash_Prelude_dot_Ord_hash_Prelude_dot_Eq
  (let s14 = leftSupply s15
       s13 = rightSupply s15
  in s14 `seq` (s13 `seq`
  Curry_Prelude.nd_OP_uscore_super_hash_Prelude_dot_Real_hash_Prelude_dot_Ord
  (Curry_Prelude.nd_OP_uscore_super_hash_Prelude_dot_Integral_hash_Prelude_dot_Real
  x1 s13 cd cs) s14 cd cs)) s16 cd cs)) s18 cd cs)) x2 s20 cd cs))
  (let s27 = leftSupply s28
       s26 = rightSupply s28
  in s27 `seq` (s26 `seq` Curry_Prelude.nd_C_apply (let s25 = leftSupply s26
                                                        s24 = rightSupply s26
  in s25 `seq` (s24 `seq` Curry_Prelude.nd_C_fromInt (let s23 = leftSupply s24
                                                          s22 = rightSupply s24
  in s23 `seq` (s22 `seq`
  Curry_Prelude.nd_OP_uscore_super_hash_Prelude_dot_Real_hash_Prelude_dot_Num
  (Curry_Prelude.nd_OP_uscore_super_hash_Prelude_dot_Integral_hash_Prelude_dot_Real
  x1 s22 cd cs) s23 cd cs)) s25 cd cs)) (Curry_Prelude.C_Int (1)) s27 cd cs))
  s29 cd cs)))) s32 cd cs))))

d_C_isListType :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_C_isListType x1 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs)
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) cd cs) x1 (Curry_Prelude.d_C_apply (Curry_Names.d_C_renameQName cd cs)
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.toCurryString "Prelude")
  (Curry_Prelude.toCurryString "[]")) cd cs) cd cs

d_C_isTupleType :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_C_isTupleType x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> Curry_Prelude.d_OP_amp_amp
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) x2 (Curry_Prelude.d_C_apply (Curry_Names.d_C_renameModule cd cs)
    (Curry_Prelude.toCurryString "Prelude") cd cs) cd cs)
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) (Curry_Prelude.d_C_take (Curry_Prelude.C_Int (8)) x3 cd cs)
    (Curry_Prelude.toCurryString "OP_Tuple") cd cs) cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C_isTupleType l cd cs)
    (d_C_isTupleType r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_C_isTupleType z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C_isTupleType e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransTypes.isTupleType" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.isTupleType" (showCons x1))

d_C_showQName :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_showQName x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> Curry_Prelude.d_OP_plus_plus x2
    (Curry_Prelude.OP_Cons (Curry_Prelude.C_Char '.'#) x3) cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C_showQName l cd cs)
    (d_C_showQName r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C_showQName
    z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C_showQName e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransTypes.showQName" [show x1] info)
  _ -> failCons cd (consFail "TransTypes.showQName" (showCons x1))

d_C_left :: Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C_left x1 cd cs = Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
  (Curry_Prelude.toCurryString "leftID") cd cs) (Curry_Prelude.OP_Cons x1
  Curry_Prelude.OP_List) cd cs

d_C_right :: Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C_right x1 cd cs = Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
  (Curry_Prelude.toCurryString "rightID") cd cs) (Curry_Prelude.OP_Cons x1
  Curry_Prelude.OP_List) cd cs

d_C_leftsupp :: Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C_leftsupp x1 cd cs = Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
  (Curry_Prelude.toCurryString "leftSupply") cd cs) (Curry_Prelude.OP_Cons x1
  Curry_Prelude.OP_List) cd cs

d_C_rightsupp :: Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C_rightsupp x1 cd cs = Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
  (Curry_Prelude.toCurryString "rightSupply") cd cs) (Curry_Prelude.OP_Cons x1
  Curry_Prelude.OP_List) cd cs

d_C_idType :: Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeExpr
d_C_idType cd cs = Curry_AbstractHaskellGoodies.d_C_baseType (d_C_basics
  (Curry_Prelude.toCurryString "ID") cd cs) cd cs

d_C_coverType :: Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeExpr
d_C_coverType cd cs = Curry_AbstractHaskellGoodies.d_C_baseType (d_C_basics
  (Curry_Prelude.toCurryString "Cover") cd cs) cd cs

d_C_consStoreType :: Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeExpr
d_C_consStoreType cd cs = Curry_AbstractHaskellGoodies.d_C_baseType (d_C_basics
  (Curry_Prelude.toCurryString "ConstStore") cd cs) cd cs

d_C_failInfoType :: Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeExpr
d_C_failInfoType cd cs = Curry_AbstractHaskellGoodies.d_C_baseType (d_C_basics
  (Curry_Prelude.toCurryString "FailInfo") cd cs) cd cs

d_C_constraintType :: Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeExpr
d_C_constraintType cd cs = Curry_AbstractHaskellGoodies.d_C_baseType (d_C_basics
  (Curry_Prelude.toCurryString "Constraints") cd cs) cd cs

d_C_basics :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_basics x1 cd cs = Curry_Prelude.OP_Tuple2 (Curry_Prelude.toCurryString
  "Basics") x1

d_C_curryPre :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_curryPre x1 cd cs = Curry_Prelude.OP_Tuple2 (Curry_Names.d_C_curryPrelude cd
  cs) x1

d_C_narrow :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_narrow cd cs = d_C_basics (Curry_Prelude.toCurryString "narrow") cd cs

d_C_narrows :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_narrows cd cs = d_C_basics (Curry_Prelude.toCurryString "narrows") cd cs

d_C_cover :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_cover cd cs = d_C_basics (Curry_Prelude.toCurryString "cover") cd cs

d_C_incCover :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_incCover cd cs = d_C_basics (Curry_Prelude.toCurryString "incCover") cd cs

d_C_curryAnd :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_curryAnd cd cs = Curry_Prelude.d_OP_dollar d_C_curryPre
  (Curry_Prelude.d_OP_plus_plus (Curry_Names.d_C_funcPrefix Curry_Prelude.C_True
  Curry_Classification.C_D Curry_Classification.C_FuncFO cd cs)
  (Curry_Names.d_C_genRename (Curry_Prelude.toCurryString "&&") cd cs) cd cs) cd
  cs

d_C_curryOr :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_curryOr cd cs = Curry_Prelude.d_OP_dollar d_C_curryPre
  (Curry_Prelude.d_OP_plus_plus (Curry_Names.d_C_funcPrefix Curry_Prelude.C_True
  Curry_Classification.C_D Curry_Classification.C_FuncFO cd cs)
  (Curry_Names.d_C_genRename (Curry_Prelude.toCurryString "||") cd cs) cd cs) cd
  cs

d_C_curryLt :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_curryLt cd cs = Curry_Prelude.d_OP_dollar d_C_curryPre
  (Curry_Prelude.d_OP_plus_plus (Curry_Names.d_C_funcPrefix Curry_Prelude.C_True
  Curry_Classification.C_D Curry_Classification.C_FuncFO cd cs)
  (Curry_Names.d_C_genRename (Curry_Prelude.toCurryString "<") cd cs) cd cs) cd
  cs

d_C__case_1 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Integral t0 -> t0
  -> Curry_AbstractHaskell.C_Expr -> t0 -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr
d_C__case_1 x1 x2 x3 x4 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons x3 Curry_Prelude.OP_List
  Curry_Prelude.C_False -> d_C__case_0 x3 x4 x1 x2 (Curry_Prelude.d_C_otherwise
    cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_1 x1 x2 x3 x4 l
    cd cs) (d_C__case_1 x1 x2 x3 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_1 x1 x2
    x3 x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_1 x1 x2 x3 x4 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "TransTypes._case_1"
    [show x1, show x2, show x3, show x4, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_1" (showCons x5))

nd_C__case_1 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Integral t0 -> t0
  -> Curry_AbstractHaskell.C_Expr -> t0 -> Curry_Prelude.C_Bool -> IDSupply
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr
nd_C__case_1 x1 x2 x3 x4 x5 s cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons x3 Curry_Prelude.OP_List
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_0 x3 x4 x1 x2 (Curry_Prelude.d_C_otherwise cd cs) s0
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_1 x1 x2 x3 x4 l
    s cd cs) (nd_C__case_1 x1 x2 x3 x4 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_1 x1
    x2 x3 x4 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_1 x1 x2 x3 x4 e
    s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "TransTypes._case_1"
    [show x1, show x2, show x3, show x4, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_1" (showCons x5))

d_C__case_0 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_AbstractHaskell.C_Expr -> t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Integral t0 -> t0 -> Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr
d_C__case_0 x3 x4 x1 x2 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_plus_plus
    (d_OP_mkSuppList_dot_mkSuppList_tick_dot_399 x1 (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_OP_minus
    (Curry_Prelude.d_OP_uscore_super_hash_Prelude_dot_Real_hash_Prelude_dot_Num
    (Curry_Prelude.d_OP_uscore_super_hash_Prelude_dot_Integral_hash_Prelude_dot_Real
    x1 cd cs) cd cs) cd cs) x2 cd cs) x4 cd cs) (d_C_leftsupp x3 cd cs) cd cs)
    (d_OP_mkSuppList_dot_mkSuppList_tick_dot_399 x1 x4 (d_C_rightsupp x3 cd cs)
    cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_0 x3 x4 x1 x2 l
    cd cs) (d_C__case_0 x3 x4 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_0 x3 x4
    x1 x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_0 x3 x4 x1 x2 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "TransTypes._case_0"
    [show x3, show x4, show x1, show x2, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_0" (showCons x5))

nd_C__case_0 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_AbstractHaskell.C_Expr -> t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Integral t0 -> t0 -> Curry_Prelude.C_Bool
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr
nd_C__case_0 x3 x4 x1 x2 x5 s cd cs = case x5 of
  Curry_Prelude.C_True -> let s12 = s
    in s12 `seq` (let s10 = leftSupply s12
                      s11 = rightSupply s12
    in s10 `seq` (s11 `seq` Curry_Prelude.d_OP_plus_plus (let s9 = leftSupply
                                                                s10
                                                              s8 = rightSupply
                                                                s10
    in s9 `seq` (s8 `seq` nd_OP_mkSuppList_dot_mkSuppList_tick_dot_399 x1
    (let s7 = leftSupply s8
         s6 = rightSupply s8
    in s7 `seq` (s6 `seq` Curry_Prelude.nd_C_apply (let s5 = leftSupply s6
                                                        s4 = rightSupply s6
    in s5 `seq` (s4 `seq` Curry_Prelude.nd_C_apply (let s3 = leftSupply s4
                                                        s2 = rightSupply s4
    in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_minus (let s1 = leftSupply s2
                                                         s0 = rightSupply s2
    in s1 `seq` (s0 `seq`
    Curry_Prelude.nd_OP_uscore_super_hash_Prelude_dot_Real_hash_Prelude_dot_Num
    (Curry_Prelude.nd_OP_uscore_super_hash_Prelude_dot_Integral_hash_Prelude_dot_Real
    x1 s0 cd cs) s1 cd cs)) s3 cd cs)) x2 s5 cd cs)) x4 s7 cd cs)) (d_C_leftsupp
    x3 cd cs) s9 cd cs)) (nd_OP_mkSuppList_dot_mkSuppList_tick_dot_399 x1 x4
    (d_C_rightsupp x3 cd cs) s11 cd cs) cd cs))
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_0 x3 x4 x1 x2 l
    s cd cs) (nd_C__case_0 x3 x4 x1 x2 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_0 x3
    x4 x1 x2 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_0 x3 x4 x1 x2 e
    s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "TransTypes._case_0"
    [show x3, show x4, show x1, show x2, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_0" (showCons x5))

d_C__case_4 :: Curry_Prelude.C_Int -> Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr
d_C__case_4 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_List
  Curry_Prelude.C_False -> d_C__case_3 x1 x2
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
    x1 (Curry_Prelude.C_Int (1)) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_4 x1 x2 l cd cs)
    (d_C__case_4 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_4 x1 x2
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_4 x1 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "TransTypes._case_4"
    [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_4" (showCons x3))

d_C__case_3 :: Curry_Prelude.C_Int -> Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr
d_C__case_3 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons (d_C_leftsupp x2 cd cs)
    Curry_Prelude.OP_List
  Curry_Prelude.C_False -> d_C__case_2 x2 x1 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_3 x1 x2 l cd cs)
    (d_C__case_3 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_3 x1 x2
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_3 x1 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "TransTypes._case_3"
    [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_3" (showCons x3))

d_C__case_2 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr
d_C__case_2 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> d_OP_mkSuppList_dot_mkSuppList_tick_dot_399
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Integral_hash_Prelude_dot_Int
    cd cs) x1 x2 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_2 x2 x1 l cd cs)
    (d_C__case_2 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_2 x2 x1
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_2 x2 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "TransTypes._case_2"
    [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_2" (showCons x3))

d_C__case_6 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Integral t0 -> t0
  -> Curry_AbstractHaskell.C_Expr -> t0 -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr
d_C__case_6 x1 x2 x3 x4 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons x3 Curry_Prelude.OP_List
  Curry_Prelude.C_False -> d_C__case_5 x3 x4 x1 x2 (Curry_Prelude.d_C_otherwise
    cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_6 x1 x2 x3 x4 l
    cd cs) (d_C__case_6 x1 x2 x3 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_6 x1 x2
    x3 x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_6 x1 x2 x3 x4 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "TransTypes._case_6"
    [show x1, show x2, show x3, show x4, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_6" (showCons x5))

nd_C__case_6 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_Prelude.OP_uscore_Dict_hash_Integral t0 -> t0
  -> Curry_AbstractHaskell.C_Expr -> t0 -> Curry_Prelude.C_Bool -> IDSupply
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr
nd_C__case_6 x1 x2 x3 x4 x5 s cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons x3 Curry_Prelude.OP_List
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_5 x3 x4 x1 x2 (Curry_Prelude.d_C_otherwise cd cs) s0
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_6 x1 x2 x3 x4 l
    s cd cs) (nd_C__case_6 x1 x2 x3 x4 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_6 x1
    x2 x3 x4 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_6 x1 x2 x3 x4 e
    s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "TransTypes._case_6"
    [show x1, show x2, show x3, show x4, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_6" (showCons x5))

d_C__case_5 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_AbstractHaskell.C_Expr -> t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Integral t0 -> t0 -> Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr
d_C__case_5 x3 x4 x1 x2 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_plus_plus
    (d_OP_mkIdList_dot_mkIdList_tick_dot_394 x1 (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_OP_minus
    (Curry_Prelude.d_OP_uscore_super_hash_Prelude_dot_Real_hash_Prelude_dot_Num
    (Curry_Prelude.d_OP_uscore_super_hash_Prelude_dot_Integral_hash_Prelude_dot_Real
    x1 cd cs) cd cs) cd cs) x2 cd cs) x4 cd cs) (d_C_left x3 cd cs) cd cs)
    (d_OP_mkIdList_dot_mkIdList_tick_dot_394 x1 x4 (d_C_right x3 cd cs) cd cs)
    cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_5 x3 x4 x1 x2 l
    cd cs) (d_C__case_5 x3 x4 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_5 x3 x4
    x1 x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_5 x3 x4 x1 x2 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "TransTypes._case_5"
    [show x3, show x4, show x1, show x2, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_5" (showCons x5))

nd_C__case_5 :: forall t0 . (Curry_Prelude.Curry
  t0) => Curry_AbstractHaskell.C_Expr -> t0
  -> Curry_Prelude.OP_uscore_Dict_hash_Integral t0 -> t0 -> Curry_Prelude.C_Bool
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr
nd_C__case_5 x3 x4 x1 x2 x5 s cd cs = case x5 of
  Curry_Prelude.C_True -> let s12 = s
    in s12 `seq` (let s10 = leftSupply s12
                      s11 = rightSupply s12
    in s10 `seq` (s11 `seq` Curry_Prelude.d_OP_plus_plus (let s9 = leftSupply
                                                                s10
                                                              s8 = rightSupply
                                                                s10
    in s9 `seq` (s8 `seq` nd_OP_mkIdList_dot_mkIdList_tick_dot_394 x1
    (let s7 = leftSupply s8
         s6 = rightSupply s8
    in s7 `seq` (s6 `seq` Curry_Prelude.nd_C_apply (let s5 = leftSupply s6
                                                        s4 = rightSupply s6
    in s5 `seq` (s4 `seq` Curry_Prelude.nd_C_apply (let s3 = leftSupply s4
                                                        s2 = rightSupply s4
    in s3 `seq` (s2 `seq` Curry_Prelude.nd_OP_minus (let s1 = leftSupply s2
                                                         s0 = rightSupply s2
    in s1 `seq` (s0 `seq`
    Curry_Prelude.nd_OP_uscore_super_hash_Prelude_dot_Real_hash_Prelude_dot_Num
    (Curry_Prelude.nd_OP_uscore_super_hash_Prelude_dot_Integral_hash_Prelude_dot_Real
    x1 s0 cd cs) s1 cd cs)) s3 cd cs)) x2 s5 cd cs)) x4 s7 cd cs)) (d_C_left x3
    cd cs) s9 cd cs)) (nd_OP_mkIdList_dot_mkIdList_tick_dot_394 x1 x4 (d_C_right
    x3 cd cs) s11 cd cs) cd cs))
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_5 x3 x4 x1 x2 l
    s cd cs) (nd_C__case_5 x3 x4 x1 x2 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_5 x3
    x4 x1 x2 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_5 x3 x4 x1 x2 e
    s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "TransTypes._case_5"
    [show x3, show x4, show x1, show x2, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_5" (showCons x5))

d_C__case_9 :: Curry_Prelude.C_Int -> Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr
d_C__case_9 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_List
  Curry_Prelude.C_False -> d_C__case_8 x1 x2
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
    x1 (Curry_Prelude.C_Int (1)) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_9 x1 x2 l cd cs)
    (d_C__case_9 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_9 x1 x2
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_9 x1 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "TransTypes._case_9"
    [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_9" (showCons x3))

d_C__case_8 :: Curry_Prelude.C_Int -> Curry_AbstractHaskell.C_Expr
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr
d_C__case_8 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons (d_C_left x2 cd cs)
    Curry_Prelude.OP_List
  Curry_Prelude.C_False -> d_C__case_7 x2 x1 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_8 x1 x2 l cd cs)
    (d_C__case_8 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_8 x1 x2
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_8 x1 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "TransTypes._case_8"
    [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_8" (showCons x3))

d_C__case_7 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr
d_C__case_7 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> d_OP_mkIdList_dot_mkIdList_tick_dot_394
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Integral_hash_Prelude_dot_Int
    cd cs) x1 x2 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_7 x2 x1 l cd cs)
    (d_C__case_7 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_7 x2 x1
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_7 x2 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "TransTypes._case_7"
    [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_7" (showCons x3))

d_C__case_11 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C__case_11 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Tuple2 x2 x1
  Curry_Prelude.C_False -> d_C__case_10 x2 x1 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_11 x1 x2 l cd cs)
    (d_C__case_11 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_11 x1
    x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_11 x1 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_11" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_11" (showCons x3))

d_C__case_10 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C__case_10 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Tuple2 x2
    (Curry_Prelude.d_OP_plus_plus x1 (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Int
    cd cs) x2 cd cs) cd cs)
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_10 x2 x1 l cd cs)
    (d_C__case_10 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_10 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_10 x2 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_10" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_10" (showCons x3))

d_C__case_14 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_14 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_13 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_14 l cd cs)
    (d_C__case_14 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_14 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_14 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_14" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_14" (showCons x3))

d_C__case_13 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_13 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_12 x6 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_13 l cd cs)
    (d_C__case_13 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_13 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_13 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_13" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_13" (showCons x5))

d_C__case_12 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_12 x6 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> x6
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_12 x6 l cd cs)
    (d_C__case_12 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_12 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_12 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_12" [show x6, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_12" (showCons x7))

d_C__case_17 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_17 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_16 x4 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_17 l cd cs)
    (d_C__case_17 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_17 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_17 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_17" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_17" (showCons x3))

d_C__case_16 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_16 x4 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_15 x4 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_16 x4 l cd cs)
    (d_C__case_16 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_16 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_16 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_16" [show x4, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_16" (showCons x5))

d_C__case_15 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_15 x4 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> x4
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_15 x4 l cd cs)
    (d_C__case_15 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_15 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_15 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_15" [show x4, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_15" (showCons x7))

d_C__case_20 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_20 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_19 x2 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_20 x2 l cd cs)
    (d_C__case_20 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_20 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_20 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_20" [show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_20" (showCons x3))

d_C__case_19 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_19 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_18 x2 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_19 x2 l cd cs)
    (d_C__case_19 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_19 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_19 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_19" [show x2, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_19" (showCons x5))

d_C__case_18 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_18 x2 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_18 x2 l cd cs)
    (d_C__case_18 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_18 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_18 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_18" [show x2, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_18" (showCons x7))

d_C__case_22 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_22 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_21 x4 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_22 l cd cs)
    (d_C__case_22 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_22 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_22 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_22" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_22" (showCons x3))

d_C__case_21 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_21 x4 x5 cd cs = case x5 of
  Curry_Prelude.OP_List -> x4
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_21 x4 l cd cs)
    (d_C__case_21 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_21 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_21 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_21" [show x4, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_21" (showCons x5))

d_C__case_24 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_24 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_23 x2 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_24 x2 l cd cs)
    (d_C__case_24 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_24 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_24 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_24" [show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_24" (showCons x3))

d_C__case_23 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_23 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_List -> x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_23 x2 l cd cs)
    (d_C__case_23 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_23 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_23 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_23" [show x2, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_23" (showCons x5))

d_C__case_27 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_27 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_26 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_27 l cd cs)
    (d_C__case_27 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_27 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_27 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_27" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_27" (showCons x3))

d_C__case_26 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_26 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_25 x6 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_26 l cd cs)
    (d_C__case_26 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_26 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_26 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_26" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_26" (showCons x5))

d_C__case_25 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_25 x6 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> x6
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_25 x6 l cd cs)
    (d_C__case_25 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_25 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_25 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_25" [show x6, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_25" (showCons x7))

d_C__case_30 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_30 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_29 x4 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_30 l cd cs)
    (d_C__case_30 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_30 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_30 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_30" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_30" (showCons x3))

d_C__case_29 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_29 x4 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_28 x4 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_29 x4 l cd cs)
    (d_C__case_29 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_29 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_29 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_29" [show x4, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_29" (showCons x5))

d_C__case_28 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_28 x4 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> x4
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_28 x4 l cd cs)
    (d_C__case_28 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_28 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_28 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_28" [show x4, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_28" (showCons x7))

d_C__case_33 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_33 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_32 x2 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_33 x2 l cd cs)
    (d_C__case_33 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_33 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_33 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_33" [show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_33" (showCons x3))

d_C__case_32 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_32 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_31 x2 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_32 x2 l cd cs)
    (d_C__case_32 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_32 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_32 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_32" [show x2, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_32" (showCons x5))

d_C__case_31 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_31 x2 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_31 x2 l cd cs)
    (d_C__case_31 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_31 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_31 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_31" [show x2, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_31" (showCons x7))

d_C__case_38 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_38 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_37 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_38 l cd cs)
    (d_C__case_38 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_38 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_38 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_38" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_38" (showCons x3))

d_C__case_37 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_37 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_36 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_37 l cd cs)
    (d_C__case_37 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_37 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_37 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_37" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_37" (showCons x5))

d_C__case_36 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_36 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_35 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_36 l cd cs)
    (d_C__case_36 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_36 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_36 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_36" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_36" (showCons x7))

d_C__case_35 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_35 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_34 x10 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_35 l cd cs)
    (d_C__case_35 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_35 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_35 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_35" [show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_35" (showCons x9))

d_C__case_34 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_34 x10 x11 cd cs = case x11 of
  Curry_Prelude.OP_List -> x10
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_34 x10 l cd cs)
    (d_C__case_34 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_34 x10
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_34 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_34" [show x10, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_34" (showCons x11))

d_C__case_43 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_43 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_42 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_43 l cd cs)
    (d_C__case_43 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_43 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_43 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_43" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_43" (showCons x3))

d_C__case_42 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_42 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_41 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_42 l cd cs)
    (d_C__case_42 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_42 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_42 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_42" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_42" (showCons x5))

d_C__case_41 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_41 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_40 x8 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_41 l cd cs)
    (d_C__case_41 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_41 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_41 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_41" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_41" (showCons x7))

d_C__case_40 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_40 x8 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_39 x8 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_40 x8 l cd cs)
    (d_C__case_40 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_40 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_40 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_40" [show x8, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_40" (showCons x9))

d_C__case_39 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_39 x8 x11 cd cs = case x11 of
  Curry_Prelude.OP_List -> x8
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_39 x8 l cd cs)
    (d_C__case_39 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_39 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_39 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_39" [show x8, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_39" (showCons x11))

d_C__case_48 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_48 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_47 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_48 l cd cs)
    (d_C__case_48 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_48 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_48 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_48" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_48" (showCons x3))

d_C__case_47 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_47 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_46 x6 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_47 l cd cs)
    (d_C__case_47 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_47 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_47 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_47" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_47" (showCons x5))

d_C__case_46 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_46 x6 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_45 x6 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_46 x6 l cd cs)
    (d_C__case_46 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_46 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_46 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_46" [show x6, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_46" (showCons x7))

d_C__case_45 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_45 x6 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_44 x6 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_45 x6 l cd cs)
    (d_C__case_45 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_45 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_45 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_45" [show x6, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_45" (showCons x9))

d_C__case_44 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_44 x6 x11 cd cs = case x11 of
  Curry_Prelude.OP_List -> x6
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_44 x6 l cd cs)
    (d_C__case_44 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_44 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_44 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_44" [show x6, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_44" (showCons x11))

d_C__case_53 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_53 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_52 x4 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_53 l cd cs)
    (d_C__case_53 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_53 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_53 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_53" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_53" (showCons x3))

d_C__case_52 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_52 x4 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_51 x4 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_52 x4 l cd cs)
    (d_C__case_52 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_52 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_52 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_52" [show x4, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_52" (showCons x5))

d_C__case_51 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_51 x4 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_50 x4 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_51 x4 l cd cs)
    (d_C__case_51 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_51 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_51 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_51" [show x4, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_51" (showCons x7))

d_C__case_50 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_50 x4 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_49 x4 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_50 x4 l cd cs)
    (d_C__case_50 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_50 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_50 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_50" [show x4, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_50" (showCons x9))

d_C__case_49 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_49 x4 x11 cd cs = case x11 of
  Curry_Prelude.OP_List -> x4
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_49 x4 l cd cs)
    (d_C__case_49 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_49 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_49 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_49" [show x4, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_49" (showCons x11))

d_C__case_58 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_58 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_57 x2 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_58 x2 l cd cs)
    (d_C__case_58 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_58 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_58 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_58" [show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_58" (showCons x3))

d_C__case_57 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_57 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_56 x2 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_57 x2 l cd cs)
    (d_C__case_57 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_57 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_57 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_57" [show x2, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_57" (showCons x5))

d_C__case_56 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_56 x2 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_55 x2 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_56 x2 l cd cs)
    (d_C__case_56 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_56 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_56 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_56" [show x2, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_56" (showCons x7))

d_C__case_55 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_55 x2 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_54 x2 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_55 x2 l cd cs)
    (d_C__case_55 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_55 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_55 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_55" [show x2, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_55" (showCons x9))

d_C__case_54 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_54 x2 x11 cd cs = case x11 of
  Curry_Prelude.OP_List -> x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_54 x2 l cd cs)
    (d_C__case_54 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_54 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_54 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_54" [show x2, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_54" (showCons x11))

d_C__case_63 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_63 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_62 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_63 l cd cs)
    (d_C__case_63 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_63 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_63 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_63" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_63" (showCons x3))

d_C__case_62 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_62 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_61 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_62 l cd cs)
    (d_C__case_62 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_62 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_62 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_62" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_62" (showCons x5))

d_C__case_61 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_61 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_60 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_61 l cd cs)
    (d_C__case_61 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_61 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_61 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_61" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_61" (showCons x7))

d_C__case_60 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_60 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_59 x10 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_60 l cd cs)
    (d_C__case_60 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_60 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_60 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_60" [show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_60" (showCons x9))

d_C__case_59 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_59 x10 x11 cd cs = case x11 of
  Curry_Prelude.OP_List -> x10
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_59 x10 l cd cs)
    (d_C__case_59 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_59 x10
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_59 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_59" [show x10, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_59" (showCons x11))

d_C__case_68 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_68 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_67 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_68 l cd cs)
    (d_C__case_68 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_68 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_68 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_68" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_68" (showCons x3))

d_C__case_67 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_67 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_66 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_67 l cd cs)
    (d_C__case_67 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_67 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_67 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_67" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_67" (showCons x5))

d_C__case_66 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_66 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_65 x8 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_66 l cd cs)
    (d_C__case_66 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_66 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_66 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_66" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_66" (showCons x7))

d_C__case_65 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_65 x8 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_64 x8 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_65 x8 l cd cs)
    (d_C__case_65 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_65 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_65 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_65" [show x8, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_65" (showCons x9))

d_C__case_64 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_64 x8 x11 cd cs = case x11 of
  Curry_Prelude.OP_List -> x8
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_64 x8 l cd cs)
    (d_C__case_64 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_64 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_64 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_64" [show x8, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_64" (showCons x11))

d_C__case_73 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_73 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_72 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_73 l cd cs)
    (d_C__case_73 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_73 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_73 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_73" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_73" (showCons x3))

d_C__case_72 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_72 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_71 x6 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_72 l cd cs)
    (d_C__case_72 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_72 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_72 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_72" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_72" (showCons x5))

d_C__case_71 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_71 x6 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_70 x6 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_71 x6 l cd cs)
    (d_C__case_71 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_71 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_71 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_71" [show x6, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_71" (showCons x7))

d_C__case_70 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_70 x6 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_69 x6 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_70 x6 l cd cs)
    (d_C__case_70 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_70 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_70 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_70" [show x6, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_70" (showCons x9))

d_C__case_69 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_69 x6 x11 cd cs = case x11 of
  Curry_Prelude.OP_List -> x6
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_69 x6 l cd cs)
    (d_C__case_69 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_69 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_69 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_69" [show x6, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_69" (showCons x11))

d_C__case_78 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_78 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_77 x4 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_78 l cd cs)
    (d_C__case_78 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_78 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_78 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_78" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_78" (showCons x3))

d_C__case_77 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_77 x4 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_76 x4 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_77 x4 l cd cs)
    (d_C__case_77 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_77 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_77 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_77" [show x4, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_77" (showCons x5))

d_C__case_76 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_76 x4 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_75 x4 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_76 x4 l cd cs)
    (d_C__case_76 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_76 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_76 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_76" [show x4, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_76" (showCons x7))

d_C__case_75 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_75 x4 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_74 x4 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_75 x4 l cd cs)
    (d_C__case_75 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_75 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_75 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_75" [show x4, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_75" (showCons x9))

d_C__case_74 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_74 x4 x11 cd cs = case x11 of
  Curry_Prelude.OP_List -> x4
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_74 x4 l cd cs)
    (d_C__case_74 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_74 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_74 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_74" [show x4, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_74" (showCons x11))

d_C__case_83 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_83 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_82 x2 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_83 x2 l cd cs)
    (d_C__case_83 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_83 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_83 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_83" [show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_83" (showCons x3))

d_C__case_82 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_82 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_81 x2 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_82 x2 l cd cs)
    (d_C__case_82 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_82 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_82 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_82" [show x2, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_82" (showCons x5))

d_C__case_81 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_81 x2 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_80 x2 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_81 x2 l cd cs)
    (d_C__case_81 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_81 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_81 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_81" [show x2, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_81" (showCons x7))

d_C__case_80 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_80 x2 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_79 x2 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_80 x2 l cd cs)
    (d_C__case_80 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_80 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_80 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_80" [show x2, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_80" (showCons x9))

d_C__case_79 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_79 x2 x11 cd cs = case x11 of
  Curry_Prelude.OP_List -> x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_79 x2 l cd cs)
    (d_C__case_79 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_79 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_79 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_79" [show x2, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_79" (showCons x11))

d_C__case_86 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_86 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_85 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_86 l cd cs)
    (d_C__case_86 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_86 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_86 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_86" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_86" (showCons x3))

d_C__case_85 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_85 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_84 x6 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_85 l cd cs)
    (d_C__case_85 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_85 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_85 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_85" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_85" (showCons x5))

d_C__case_84 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_84 x6 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> x6
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_84 x6 l cd cs)
    (d_C__case_84 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_84 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_84 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_84" [show x6, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_84" (showCons x7))

d_C__case_89 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_89 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_88 x4 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_89 l cd cs)
    (d_C__case_89 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_89 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_89 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_89" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_89" (showCons x3))

d_C__case_88 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_88 x4 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_87 x4 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_88 x4 l cd cs)
    (d_C__case_88 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_88 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_88 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_88" [show x4, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_88" (showCons x5))

d_C__case_87 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_87 x4 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> x4
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_87 x4 l cd cs)
    (d_C__case_87 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_87 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_87 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_87" [show x4, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_87" (showCons x7))

d_C__case_92 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_92 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_91 x2 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_92 x2 l cd cs)
    (d_C__case_92 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_92 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_92 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_92" [show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_92" (showCons x3))

d_C__case_91 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_91 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_90 x2 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_91 x2 l cd cs)
    (d_C__case_91 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_91 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_91 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_91" [show x2, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_91" (showCons x5))

d_C__case_90 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_90 x2 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_90 x2 l cd cs)
    (d_C__case_90 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_90 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_90 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_90" [show x2, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_90" (showCons x7))

d_C__case_96 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_96 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_95 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_96 l cd cs)
    (d_C__case_96 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_96 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_96 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_96" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_96" (showCons x3))

d_C__case_95 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_95 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_94 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_95 l cd cs)
    (d_C__case_95 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_95 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_95 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_95" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_95" (showCons x5))

d_C__case_94 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_94 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_93 x8 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_94 l cd cs)
    (d_C__case_94 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_94 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_94 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_94" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_94" (showCons x7))

d_C__case_93 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_93 x8 x9 cd cs = case x9 of
  Curry_Prelude.OP_List -> x8
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_93 x8 l cd cs)
    (d_C__case_93 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_93 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_93 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_93" [show x8, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_93" (showCons x9))

d_C__case_100 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_100 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_99 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_100 l cd cs)
    (d_C__case_100 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_100 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_100 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_100" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_100" (showCons x3))

d_C__case_99 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_99 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_98 x6 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_99 l cd cs)
    (d_C__case_99 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_99 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_99 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_99" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_99" (showCons x5))

d_C__case_98 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_98 x6 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_97 x6 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_98 x6 l cd cs)
    (d_C__case_98 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_98 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_98 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_98" [show x6, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_98" (showCons x7))

d_C__case_97 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_97 x6 x9 cd cs = case x9 of
  Curry_Prelude.OP_List -> x6
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_97 x6 l cd cs)
    (d_C__case_97 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_97 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_97 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_97" [show x6, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_97" (showCons x9))

d_C__case_104 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_104 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_103 x4 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_104 l cd cs)
    (d_C__case_104 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_104 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_104 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_104" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_104" (showCons x3))

d_C__case_103 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_103 x4 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_102 x4 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_103 x4 l cd cs)
    (d_C__case_103 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_103 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_103 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_103" [show x4, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_103" (showCons x5))

d_C__case_102 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_102 x4 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_101 x4 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_102 x4 l cd cs)
    (d_C__case_102 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_102 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_102 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_102" [show x4, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_102" (showCons x7))

d_C__case_101 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_101 x4 x9 cd cs = case x9 of
  Curry_Prelude.OP_List -> x4
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_101 x4 l cd cs)
    (d_C__case_101 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_101 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_101 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_101" [show x4, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_101" (showCons x9))

d_C__case_108 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_108 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_107 x2 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_108 x2 l cd cs)
    (d_C__case_108 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_108 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_108 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_108" [show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_108" (showCons x3))

d_C__case_107 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_107 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_106 x2 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_107 x2 l cd cs)
    (d_C__case_107 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_107 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_107 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_107" [show x2, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_107" (showCons x5))

d_C__case_106 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_106 x2 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_105 x2 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_106 x2 l cd cs)
    (d_C__case_106 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_106 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_106 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_106" [show x2, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_106" (showCons x7))

d_C__case_105 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_105 x2 x9 cd cs = case x9 of
  Curry_Prelude.OP_List -> x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_105 x2 l cd cs)
    (d_C__case_105 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_105 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_105 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_105" [show x2, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_105" (showCons x9))

d_C__case_110 :: Curry_Prelude.C_Bool -> Curry_AbstractHaskell.C_TypeExpr
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_TypeDecl
d_C__case_110 x1 x8 x7 x9 cd cs = case x9 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (d_C_mkInstance (d_C_basics
    (Curry_Prelude.toCurryString "Curry") cd cs) Curry_Prelude.OP_List x8 x7 cd
    cs) Curry_Prelude.OP_List cd cs
  Curry_Prelude.C_False -> d_C__case_109 x8 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_110 x1 x8 x7 l cd
    cs) (d_C__case_110 x1 x8 x7 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_110 x1
    x8 x7 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_110 x1 x8 x7 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_110" [show x1, show x8, show x7, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_110" (showCons x9))

d_C__case_109 :: Curry_AbstractHaskell.C_TypeExpr -> Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeDecl
d_C__case_109 x8 x9 cd cs = case x9 of
  Curry_Prelude.C_True -> d_C_mkEmptyInstance (d_C_basics
    (Curry_Prelude.toCurryString "Curry") cd cs) x8 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "TransTypes.curryInstance") cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_109 x8 l cd cs)
    (d_C__case_109 x8 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_109 x8
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_109 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_109" [show x8, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_109" (showCons x9))

d_C__case_114 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_114 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_113 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_114 l cd cs)
    (d_C__case_114 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_114 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_114 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_114" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_114" (showCons x3))

d_C__case_113 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_113 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_112 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_113 l cd cs)
    (d_C__case_113 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_113 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_113 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_113" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_113" (showCons x5))

d_C__case_112 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_112 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_111 x8 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_112 l cd cs)
    (d_C__case_112 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_112 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_112 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_112" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_112" (showCons x7))

d_C__case_111 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_111 x8 x9 cd cs = case x9 of
  Curry_Prelude.OP_List -> x8
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_111 x8 l cd cs)
    (d_C__case_111 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_111 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_111 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_111" [show x8, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_111" (showCons x9))

d_C__case_118 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_118 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_117 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_118 l cd cs)
    (d_C__case_118 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_118 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_118 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_118" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_118" (showCons x3))

d_C__case_117 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_117 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_116 x6 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_117 l cd cs)
    (d_C__case_117 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_117 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_117 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_117" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_117" (showCons x5))

d_C__case_116 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_116 x6 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_115 x6 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_116 x6 l cd cs)
    (d_C__case_116 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_116 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_116 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_116" [show x6, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_116" (showCons x7))

d_C__case_115 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_115 x6 x9 cd cs = case x9 of
  Curry_Prelude.OP_List -> x6
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_115 x6 l cd cs)
    (d_C__case_115 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_115 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_115 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_115" [show x6, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_115" (showCons x9))

d_C__case_122 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_122 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_121 x4 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_122 l cd cs)
    (d_C__case_122 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_122 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_122 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_122" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_122" (showCons x3))

d_C__case_121 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_121 x4 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_120 x4 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_121 x4 l cd cs)
    (d_C__case_121 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_121 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_121 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_121" [show x4, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_121" (showCons x5))

d_C__case_120 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_120 x4 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_119 x4 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_120 x4 l cd cs)
    (d_C__case_120 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_120 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_120 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_120" [show x4, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_120" (showCons x7))

d_C__case_119 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_119 x4 x9 cd cs = case x9 of
  Curry_Prelude.OP_List -> x4
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_119 x4 l cd cs)
    (d_C__case_119 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_119 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_119 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_119" [show x4, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_119" (showCons x9))

d_C__case_126 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_126 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_125 x2 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_126 x2 l cd cs)
    (d_C__case_126 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_126 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_126 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_126" [show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_126" (showCons x3))

d_C__case_125 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_125 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_124 x2 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_125 x2 l cd cs)
    (d_C__case_125 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_125 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_125 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_125" [show x2, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_125" (showCons x5))

d_C__case_124 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_124 x2 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_123 x2 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_124 x2 l cd cs)
    (d_C__case_124 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_124 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_124 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_124" [show x2, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_124" (showCons x7))

d_C__case_123 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_123 x2 x9 cd cs = case x9 of
  Curry_Prelude.OP_List -> x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_123 x2 l cd cs)
    (d_C__case_123 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_123 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_123 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_123" [show x2, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_123" (showCons x9))

d_C__case_127 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_127 x7 x5 x4 x8 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_AbstractHaskellGoodies.d_C_list2ac
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_InfixApply
    (Curry_AbstractHaskell.C_Var x5) (d_C_basics (Curry_Prelude.toCurryString
    ":=:") cd cs) (Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
    (Curry_Prelude.toCurryString "LazyBind") cd cs) (Curry_Prelude.OP_Cons
    (Curry_AbstractHaskellGoodies.d_C_applyF x8 (Curry_Prelude.OP_Cons
    (Curry_AbstractHaskell.C_Var x4) (Curry_Prelude.OP_Cons
    (Curry_AbstractHaskell.C_Var x5) (Curry_Prelude.OP_Cons
    (Curry_AbstractHaskell.C_Var x7) Curry_Prelude.OP_List))) cd cs)
    Curry_Prelude.OP_List) cd cs)) Curry_Prelude.OP_List) cd cs
  Curry_Prelude.C_False -> Curry_AbstractHaskellGoodies.d_C_applyF x8
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x4)
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x5)
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x7)
    Curry_Prelude.OP_List))) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_127 x7 x5 x4 x8 l
    cd cs) (d_C__case_127 x7 x5 x4 x8 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_127 x7
    x5 x4 x8 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_127 x7 x5 x4 x8 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_127" [show x7, show x5, show x4, show x8, show x2] info)
  _ -> failCons cd (consFail "TransTypes._case_127" (showCons x2))

d_C__case_128 :: Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_128 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.toCurryString "lazyBind"
  Curry_Prelude.C_False -> Curry_Prelude.toCurryString "bind"
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_128 l cd cs)
    (d_C__case_128 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_128 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_128 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_128" [show x2] info)
  _ -> failCons cd (consFail "TransTypes._case_128" (showCons x2))

d_C__case_129 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_129 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_List -> x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_129 x2 l cd cs)
    (d_C__case_129 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_129 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_129 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_129" [show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_129" (showCons x3))

d_C__case_132 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_132 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_131 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_132 l cd cs)
    (d_C__case_132 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_132 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_132 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_132" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_132" (showCons x3))

d_C__case_131 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_131 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_130 x6 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_131 l cd cs)
    (d_C__case_131 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_131 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_131 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_131" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_131" (showCons x5))

d_C__case_130 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_130 x6 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> x6
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_130 x6 l cd cs)
    (d_C__case_130 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_130 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_130 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_130" [show x6, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_130" (showCons x7))

d_C__case_135 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_135 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_134 x4 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_135 l cd cs)
    (d_C__case_135 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_135 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_135 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_135" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_135" (showCons x3))

d_C__case_134 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_134 x4 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_133 x4 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_134 x4 l cd cs)
    (d_C__case_134 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_134 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_134 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_134" [show x4, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_134" (showCons x5))

d_C__case_133 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_133 x4 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> x4
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_133 x4 l cd cs)
    (d_C__case_133 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_133 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_133 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_133" [show x4, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_133" (showCons x7))

d_C__case_138 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_138 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_137 x2 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_138 x2 l cd cs)
    (d_C__case_138 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_138 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_138 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_138" [show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_138" (showCons x3))

d_C__case_137 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_137 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_136 x2 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_137 x2 l cd cs)
    (d_C__case_137 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_137 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_137 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_137" [show x2, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_137" (showCons x5))

d_C__case_136 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_136 x2 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_136 x2 l cd cs)
    (d_C__case_136 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_136 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_136 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_136" [show x2, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_136" (showCons x7))

d_C__case_143 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_143 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_142 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_143 l cd cs)
    (d_C__case_143 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_143 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_143 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_143" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_143" (showCons x3))

d_C__case_142 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_142 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_141 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_142 l cd cs)
    (d_C__case_142 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_142 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_142 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_142" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_142" (showCons x5))

d_C__case_141 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_141 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_140 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_141 l cd cs)
    (d_C__case_141 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_141 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_141 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_141" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_141" (showCons x7))

d_C__case_140 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_140 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_139 x10 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_140 l cd cs)
    (d_C__case_140 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_140 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_140 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_140" [show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_140" (showCons x9))

d_C__case_139 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_139 x10 x11 cd cs = case x11 of
  Curry_Prelude.OP_List -> x10
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_139 x10 l cd cs)
    (d_C__case_139 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_139
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_139 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_139" [show x10, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_139" (showCons x11))

d_C__case_148 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_148 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_147 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_148 l cd cs)
    (d_C__case_148 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_148 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_148 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_148" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_148" (showCons x3))

d_C__case_147 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_147 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_146 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_147 l cd cs)
    (d_C__case_147 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_147 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_147 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_147" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_147" (showCons x5))

d_C__case_146 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_146 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_145 x8 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_146 l cd cs)
    (d_C__case_146 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_146 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_146 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_146" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_146" (showCons x7))

d_C__case_145 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_145 x8 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_144 x8 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_145 x8 l cd cs)
    (d_C__case_145 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_145 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_145 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_145" [show x8, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_145" (showCons x9))

d_C__case_144 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_144 x8 x11 cd cs = case x11 of
  Curry_Prelude.OP_List -> x8
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_144 x8 l cd cs)
    (d_C__case_144 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_144 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_144 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_144" [show x8, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_144" (showCons x11))

d_C__case_153 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_153 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_152 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_153 l cd cs)
    (d_C__case_153 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_153 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_153 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_153" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_153" (showCons x3))

d_C__case_152 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_152 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_151 x6 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_152 l cd cs)
    (d_C__case_152 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_152 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_152 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_152" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_152" (showCons x5))

d_C__case_151 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_151 x6 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_150 x6 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_151 x6 l cd cs)
    (d_C__case_151 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_151 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_151 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_151" [show x6, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_151" (showCons x7))

d_C__case_150 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_150 x6 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_149 x6 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_150 x6 l cd cs)
    (d_C__case_150 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_150 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_150 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_150" [show x6, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_150" (showCons x9))

d_C__case_149 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_149 x6 x11 cd cs = case x11 of
  Curry_Prelude.OP_List -> x6
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_149 x6 l cd cs)
    (d_C__case_149 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_149 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_149 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_149" [show x6, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_149" (showCons x11))

d_C__case_158 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_158 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_157 x4 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_158 l cd cs)
    (d_C__case_158 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_158 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_158 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_158" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_158" (showCons x3))

d_C__case_157 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_157 x4 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_156 x4 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_157 x4 l cd cs)
    (d_C__case_157 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_157 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_157 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_157" [show x4, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_157" (showCons x5))

d_C__case_156 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_156 x4 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_155 x4 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_156 x4 l cd cs)
    (d_C__case_156 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_156 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_156 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_156" [show x4, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_156" (showCons x7))

d_C__case_155 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_155 x4 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_154 x4 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_155 x4 l cd cs)
    (d_C__case_155 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_155 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_155 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_155" [show x4, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_155" (showCons x9))

d_C__case_154 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_154 x4 x11 cd cs = case x11 of
  Curry_Prelude.OP_List -> x4
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_154 x4 l cd cs)
    (d_C__case_154 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_154 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_154 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_154" [show x4, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_154" (showCons x11))

d_C__case_163 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_163 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_162 x2 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_163 x2 l cd cs)
    (d_C__case_163 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_163 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_163 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_163" [show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_163" (showCons x3))

d_C__case_162 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_162 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_161 x2 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_162 x2 l cd cs)
    (d_C__case_162 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_162 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_162 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_162" [show x2, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_162" (showCons x5))

d_C__case_161 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_161 x2 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_160 x2 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_161 x2 l cd cs)
    (d_C__case_161 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_161 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_161 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_161" [show x2, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_161" (showCons x7))

d_C__case_160 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_160 x2 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_159 x2 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_160 x2 l cd cs)
    (d_C__case_160 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_160 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_160 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_160" [show x2, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_160" (showCons x9))

d_C__case_159 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_159 x2 x11 cd cs = case x11 of
  Curry_Prelude.OP_List -> x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_159 x2 l cd cs)
    (d_C__case_159 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_159 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_159 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_159" [show x2, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_159" (showCons x11))

d_C__case_168 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_168 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_167 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_168 l cd cs)
    (d_C__case_168 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_168 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_168 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_168" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_168" (showCons x3))

d_C__case_167 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_167 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_166 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_167 l cd cs)
    (d_C__case_167 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_167 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_167 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_167" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_167" (showCons x5))

d_C__case_166 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_166 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_165 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_166 l cd cs)
    (d_C__case_166 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_166 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_166 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_166" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_166" (showCons x7))

d_C__case_165 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_165 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_164 x10 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_165 l cd cs)
    (d_C__case_165 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_165 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_165 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_165" [show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_165" (showCons x9))

d_C__case_164 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_164 x10 x11 cd cs = case x11 of
  Curry_Prelude.OP_List -> x10
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_164 x10 l cd cs)
    (d_C__case_164 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_164
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_164 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_164" [show x10, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_164" (showCons x11))

d_C__case_173 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_173 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_172 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_173 l cd cs)
    (d_C__case_173 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_173 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_173 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_173" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_173" (showCons x3))

d_C__case_172 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_172 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_171 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_172 l cd cs)
    (d_C__case_172 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_172 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_172 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_172" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_172" (showCons x5))

d_C__case_171 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_171 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_170 x8 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_171 l cd cs)
    (d_C__case_171 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_171 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_171 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_171" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_171" (showCons x7))

d_C__case_170 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_170 x8 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_169 x8 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_170 x8 l cd cs)
    (d_C__case_170 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_170 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_170 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_170" [show x8, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_170" (showCons x9))

d_C__case_169 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_169 x8 x11 cd cs = case x11 of
  Curry_Prelude.OP_List -> x8
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_169 x8 l cd cs)
    (d_C__case_169 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_169 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_169 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_169" [show x8, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_169" (showCons x11))

d_C__case_178 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_178 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_177 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_178 l cd cs)
    (d_C__case_178 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_178 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_178 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_178" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_178" (showCons x3))

d_C__case_177 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_177 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_176 x6 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_177 l cd cs)
    (d_C__case_177 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_177 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_177 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_177" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_177" (showCons x5))

d_C__case_176 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_176 x6 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_175 x6 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_176 x6 l cd cs)
    (d_C__case_176 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_176 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_176 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_176" [show x6, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_176" (showCons x7))

d_C__case_175 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_175 x6 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_174 x6 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_175 x6 l cd cs)
    (d_C__case_175 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_175 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_175 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_175" [show x6, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_175" (showCons x9))

d_C__case_174 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_174 x6 x11 cd cs = case x11 of
  Curry_Prelude.OP_List -> x6
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_174 x6 l cd cs)
    (d_C__case_174 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_174 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_174 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_174" [show x6, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_174" (showCons x11))

d_C__case_183 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_183 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_182 x4 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_183 l cd cs)
    (d_C__case_183 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_183 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_183 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_183" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_183" (showCons x3))

d_C__case_182 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_182 x4 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_181 x4 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_182 x4 l cd cs)
    (d_C__case_182 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_182 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_182 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_182" [show x4, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_182" (showCons x5))

d_C__case_181 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_181 x4 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_180 x4 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_181 x4 l cd cs)
    (d_C__case_181 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_181 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_181 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_181" [show x4, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_181" (showCons x7))

d_C__case_180 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_180 x4 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_179 x4 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_180 x4 l cd cs)
    (d_C__case_180 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_180 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_180 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_180" [show x4, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_180" (showCons x9))

d_C__case_179 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_179 x4 x11 cd cs = case x11 of
  Curry_Prelude.OP_List -> x4
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_179 x4 l cd cs)
    (d_C__case_179 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_179 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_179 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_179" [show x4, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_179" (showCons x11))

d_C__case_188 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_188 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_187 x2 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_188 x2 l cd cs)
    (d_C__case_188 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_188 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_188 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_188" [show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_188" (showCons x3))

d_C__case_187 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_187 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_186 x2 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_187 x2 l cd cs)
    (d_C__case_187 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_187 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_187 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_187" [show x2, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_187" (showCons x5))

d_C__case_186 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_186 x2 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_185 x2 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_186 x2 l cd cs)
    (d_C__case_186 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_186 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_186 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_186" [show x2, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_186" (showCons x7))

d_C__case_185 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_185 x2 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_184 x2 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_185 x2 l cd cs)
    (d_C__case_185 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_185 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_185 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_185" [show x2, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_185" (showCons x9))

d_C__case_184 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_184 x2 x11 cd cs = case x11 of
  Curry_Prelude.OP_List -> x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_184 x2 l cd cs)
    (d_C__case_184 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_184 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_184 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_184" [show x2, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_184" (showCons x11))

d_C__case_194 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_194 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_193 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_194 l cd cs)
    (d_C__case_194 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_194 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_194 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_194" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_194" (showCons x3))

d_C__case_193 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_193 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_192 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_193 l cd cs)
    (d_C__case_193 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_193 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_193 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_193" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_193" (showCons x5))

d_C__case_192 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_192 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_191 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_192 l cd cs)
    (d_C__case_192 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_192 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_192 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_192" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_192" (showCons x7))

d_C__case_191 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_191 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_190 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_191 l cd cs)
    (d_C__case_191 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_191 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_191 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_191" [show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_191" (showCons x9))

d_C__case_190 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_190 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_189 x12 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_190 l cd cs)
    (d_C__case_190 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_190 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_190 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_190" [show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_190" (showCons x11))

d_C__case_189 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_189 x12 x13 cd cs = case x13 of
  Curry_Prelude.OP_List -> x12
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_189 x12 l cd cs)
    (d_C__case_189 x12 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_189
    x12 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_189 x12 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_189" [show x12, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_189" (showCons x13))

d_C__case_200 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_200 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_199 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_200 l cd cs)
    (d_C__case_200 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_200 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_200 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_200" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_200" (showCons x3))

d_C__case_199 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_199 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_198 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_199 l cd cs)
    (d_C__case_199 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_199 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_199 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_199" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_199" (showCons x5))

d_C__case_198 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_198 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_197 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_198 l cd cs)
    (d_C__case_198 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_198 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_198 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_198" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_198" (showCons x7))

d_C__case_197 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_197 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_196 x10 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_197 l cd cs)
    (d_C__case_197 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_197 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_197 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_197" [show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_197" (showCons x9))

d_C__case_196 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_196 x10 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_195 x10 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_196 x10 l cd cs)
    (d_C__case_196 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_196
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_196 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_196" [show x10, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_196" (showCons x11))

d_C__case_195 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_195 x10 x13 cd cs = case x13 of
  Curry_Prelude.OP_List -> x10
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_195 x10 l cd cs)
    (d_C__case_195 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_195
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_195 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_195" [show x10, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_195" (showCons x13))

d_C__case_206 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_206 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_205 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_206 l cd cs)
    (d_C__case_206 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_206 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_206 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_206" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_206" (showCons x3))

d_C__case_205 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_205 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_204 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_205 l cd cs)
    (d_C__case_205 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_205 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_205 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_205" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_205" (showCons x5))

d_C__case_204 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_204 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_203 x8 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_204 l cd cs)
    (d_C__case_204 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_204 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_204 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_204" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_204" (showCons x7))

d_C__case_203 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_203 x8 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_202 x8 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_203 x8 l cd cs)
    (d_C__case_203 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_203 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_203 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_203" [show x8, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_203" (showCons x9))

d_C__case_202 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_202 x8 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_201 x8 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_202 x8 l cd cs)
    (d_C__case_202 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_202 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_202 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_202" [show x8, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_202" (showCons x11))

d_C__case_201 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_201 x8 x13 cd cs = case x13 of
  Curry_Prelude.OP_List -> x8
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_201 x8 l cd cs)
    (d_C__case_201 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_201 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_201 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_201" [show x8, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_201" (showCons x13))

d_C__case_212 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_212 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_211 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_212 l cd cs)
    (d_C__case_212 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_212 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_212 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_212" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_212" (showCons x3))

d_C__case_211 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_211 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_210 x6 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_211 l cd cs)
    (d_C__case_211 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_211 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_211 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_211" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_211" (showCons x5))

d_C__case_210 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_210 x6 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_209 x6 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_210 x6 l cd cs)
    (d_C__case_210 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_210 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_210 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_210" [show x6, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_210" (showCons x7))

d_C__case_209 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_209 x6 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_208 x6 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_209 x6 l cd cs)
    (d_C__case_209 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_209 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_209 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_209" [show x6, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_209" (showCons x9))

d_C__case_208 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_208 x6 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_207 x6 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_208 x6 l cd cs)
    (d_C__case_208 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_208 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_208 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_208" [show x6, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_208" (showCons x11))

d_C__case_207 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_207 x6 x13 cd cs = case x13 of
  Curry_Prelude.OP_List -> x6
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_207 x6 l cd cs)
    (d_C__case_207 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_207 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_207 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_207" [show x6, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_207" (showCons x13))

d_C__case_218 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_218 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_217 x4 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_218 l cd cs)
    (d_C__case_218 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_218 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_218 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_218" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_218" (showCons x3))

d_C__case_217 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_217 x4 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_216 x4 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_217 x4 l cd cs)
    (d_C__case_217 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_217 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_217 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_217" [show x4, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_217" (showCons x5))

d_C__case_216 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_216 x4 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_215 x4 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_216 x4 l cd cs)
    (d_C__case_216 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_216 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_216 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_216" [show x4, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_216" (showCons x7))

d_C__case_215 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_215 x4 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_214 x4 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_215 x4 l cd cs)
    (d_C__case_215 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_215 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_215 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_215" [show x4, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_215" (showCons x9))

d_C__case_214 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_214 x4 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_213 x4 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_214 x4 l cd cs)
    (d_C__case_214 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_214 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_214 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_214" [show x4, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_214" (showCons x11))

d_C__case_213 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_213 x4 x13 cd cs = case x13 of
  Curry_Prelude.OP_List -> x4
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_213 x4 l cd cs)
    (d_C__case_213 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_213 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_213 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_213" [show x4, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_213" (showCons x13))

d_C__case_224 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_224 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_223 x2 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_224 x2 l cd cs)
    (d_C__case_224 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_224 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_224 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_224" [show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_224" (showCons x3))

d_C__case_223 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_223 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_222 x2 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_223 x2 l cd cs)
    (d_C__case_223 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_223 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_223 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_223" [show x2, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_223" (showCons x5))

d_C__case_222 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_222 x2 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_221 x2 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_222 x2 l cd cs)
    (d_C__case_222 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_222 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_222 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_222" [show x2, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_222" (showCons x7))

d_C__case_221 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_221 x2 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_220 x2 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_221 x2 l cd cs)
    (d_C__case_221 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_221 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_221 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_221" [show x2, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_221" (showCons x9))

d_C__case_220 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_220 x2 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_219 x2 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_220 x2 l cd cs)
    (d_C__case_220 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_220 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_220 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_220" [show x2, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_220" (showCons x11))

d_C__case_219 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_219 x2 x13 cd cs = case x13 of
  Curry_Prelude.OP_List -> x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_219 x2 l cd cs)
    (d_C__case_219 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_219 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_219 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_219" [show x2, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_219" (showCons x13))

d_C__case_227 :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_ConsHOClass
  -> (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr) -> (Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr) -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Int
  -> FlatCurry.Curry_Types.C_ConsDecl -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
d_C__case_227 x1 x4 x3 x2 x6 x7 cd cs = case x7 of
  FlatCurry.Curry_Types.C_Cons x8 x9 x10 x11 -> let x12 = Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Maybe
                                                      (Curry_Classification.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Classification_dot_ConsHOClass
                                                      cd cs)
                                                      (Curry_FiniteMap.d_C_lookupFM
                                                      (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                                                      (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                                      (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                                      cd cs) cd cs)
                                                      (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                                      (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                                      cd cs) cd cs) cd cs) x1 x8
                                                      cd cs)
                                                      (Curry_Prelude.C_Just
                                                      Curry_Classification.C_ConsHO)
                                                      cd cs
    in d_C__case_226 x8 x4 x3 x2 x11 x6 x12 cd cs
  FlatCurry.Curry_Types.Choice_C_ConsDecl d i l r -> narrow d i (d_C__case_227
    x1 x4 x3 x2 x6 l cd cs) (d_C__case_227 x1 x4 x3 x2 x6 r cd cs)
  FlatCurry.Curry_Types.Choices_C_ConsDecl d i xs -> narrows cs d i (\z ->
    d_C__case_227 x1 x4 x3 x2 x6 z cd cs) xs
  FlatCurry.Curry_Types.Guard_C_ConsDecl d c e -> guardCons d c (d_C__case_227
    x1 x4 x3 x2 x6 e cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_ConsDecl d info -> failCons d (traceFail
    "TransTypes._case_227" [show x1, show x4, show x3, show x2, show x6, show
    x7] info)
  _ -> failCons cd (consFail "TransTypes._case_227" (showCons x7))

nd_C__case_227 :: Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_Classification.C_ConsHOClass -> Func
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr)
  Curry_AbstractHaskell.C_Expr -> Func Curry_AbstractHaskell.C_Expr (Func
  Curry_AbstractHaskell.C_Expr (Func Curry_AbstractHaskell.C_Expr
  Curry_AbstractHaskell.C_Expr)) -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Int
  -> FlatCurry.Curry_Types.C_ConsDecl -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
nd_C__case_227 x1 x4 x3 x2 x6 x7 s cd cs = case x7 of
  FlatCurry.Curry_Types.C_Cons x8 x9 x10 x11 -> let s16 = s
    in s16 `seq` (let s13 = leftSupply s16
                      s15 = rightSupply s16
    in s13 `seq` (s15 `seq` (let x12 = let s12 = leftSupply s13
                                           s14 = rightSupply s13
                                           s0 = leftSupply s14
                                           s11 = rightSupply s14
                                   in s12 `seq` (s14 `seq` (s0 `seq` (s11 `seq`
                                   Curry_Prelude.nd_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Maybe
                                   (Curry_Classification.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Classification_dot_ConsHOClass
                                   s0 cd cs) (let s10 = leftSupply s11
                                                  s8 = rightSupply s11
                                   in s10 `seq` (s8 `seq`
                                   Curry_FiniteMap.nd_C_lookupFM
                                   (let s7 = leftSupply s8
                                        s9 = rightSupply s8
                                        s3 = leftSupply s9
                                        s6 = rightSupply s9
                                   in s7 `seq` (s9 `seq` (s3 `seq` (s6 `seq`
                                   Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen
                                   (let s2 = leftSupply s3
                                        s1 = rightSupply s3
                                   in s2 `seq` (s1 `seq`
                                   Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                   (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                   s1 cd cs) s2 cd cs)) (let s5 = leftSupply s6
                                                             s4 = rightSupply s6
                                   in s5 `seq` (s4 `seq`
                                   Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket
                                   (Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
                                   s4 cd cs) s5 cd cs)) s7 cd cs)))) x1 x8 s10
                                   cd cs)) (Curry_Prelude.C_Just
                                   Curry_Classification.C_ConsHO) s12 cd cs)))
    in nd_C__case_226 x8 x4 x3 x2 x11 x6 x12 s15 cd cs)))
  FlatCurry.Curry_Types.Choice_C_ConsDecl d i l r -> narrow d i (nd_C__case_227
    x1 x4 x3 x2 x6 l s cd cs) (nd_C__case_227 x1 x4 x3 x2 x6 r s cd cs)
  FlatCurry.Curry_Types.Choices_C_ConsDecl d i xs -> narrows cs d i (\z ->
    nd_C__case_227 x1 x4 x3 x2 x6 z s cd cs) xs
  FlatCurry.Curry_Types.Guard_C_ConsDecl d c e -> guardCons d c (nd_C__case_227
    x1 x4 x3 x2 x6 e s cd $! addCs c cs)
  FlatCurry.Curry_Types.Fail_C_ConsDecl d info -> failCons d (traceFail
    "TransTypes._case_227" [show x1, show x4, show x3, show x2, show x6, show
    x7] info)
  _ -> failCons cd (consFail "TransTypes._case_227" (showCons x7))

d_C__case_226 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr) -> (Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr) -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_TypeExpr -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_AbstractHaskell.C_Rule)
d_C__case_226 x8 x4 x3 x2 x11 x6 x12 cd cs = case x12 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_map
    (d_OP_bindConsRule_dot_rule_dot_308 x6 x11 x2 x3 x4) (Curry_Prelude.OP_Cons
    x8 (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply
    (Curry_Names.d_C_mkHoConsName cd cs) x8 cd cs) Curry_Prelude.OP_List)) cd cs
  Curry_Prelude.C_False -> d_C__case_225 x8 x4 x3 x2 x11 x6
    (Curry_Prelude.d_C_otherwise cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_226 x8 x4 x3 x2
    x11 x6 l cd cs) (d_C__case_226 x8 x4 x3 x2 x11 x6 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_226 x8
    x4 x3 x2 x11 x6 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_226 x8 x4 x3 x2
    x11 x6 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_226" [show x8, show x4, show x3, show x2, show x11, show
    x6, show x12] info)
  _ -> failCons cd (consFail "TransTypes._case_226" (showCons x12))

nd_C__case_226 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Func
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr)
  Curry_AbstractHaskell.C_Expr -> Func Curry_AbstractHaskell.C_Expr (Func
  Curry_AbstractHaskell.C_Expr (Func Curry_AbstractHaskell.C_Expr
  Curry_AbstractHaskell.C_Expr)) -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_TypeExpr -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
nd_C__case_226 x8 x4 x3 x2 x11 x6 x12 s cd cs = case x12 of
  Curry_Prelude.C_True -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_map (wrapNX id
    (nd_OP_bindConsRule_dot_rule_dot_308 x6 x11 x2 x3 x4))
    (Curry_Prelude.OP_Cons x8 (Curry_Prelude.OP_Cons (Curry_Prelude.nd_C_apply
    (wrapDX id (Curry_Names.d_C_mkHoConsName cd cs)) x8 s0 cd cs)
    Curry_Prelude.OP_List)) s1 cd cs))
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_225 x8 x4 x3 x2 x11 x6 (Curry_Prelude.d_C_otherwise
    cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_226 x8 x4 x3 x2
    x11 x6 l s cd cs) (nd_C__case_226 x8 x4 x3 x2 x11 x6 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_226 x8
    x4 x3 x2 x11 x6 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_226 x8 x4 x3 x2
    x11 x6 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_226" [show x8, show x4, show x3, show x2, show x11, show
    x6, show x12] info)
  _ -> failCons cd (consFail "TransTypes._case_226" (showCons x12))

d_C__case_225 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr) -> (Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr) -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_TypeExpr -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_AbstractHaskell.C_Rule)
d_C__case_225 x8 x4 x3 x2 x11 x6 x12 cd cs = case x12 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons
    (d_OP_bindConsRule_dot_rule_dot_308 x6 x11 x2 x3 x4 x8 cd cs)
    Curry_Prelude.OP_List
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_225 x8 x4 x3 x2
    x11 x6 l cd cs) (d_C__case_225 x8 x4 x3 x2 x11 x6 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_225 x8
    x4 x3 x2 x11 x6 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_225 x8 x4 x3 x2
    x11 x6 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_225" [show x8, show x4, show x3, show x2, show x11, show
    x6, show x12] info)
  _ -> failCons cd (consFail "TransTypes._case_225" (showCons x12))

nd_C__case_225 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Func
  (Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr)
  Curry_AbstractHaskell.C_Expr -> Func Curry_AbstractHaskell.C_Expr (Func
  Curry_AbstractHaskell.C_Expr (Func Curry_AbstractHaskell.C_Expr
  Curry_AbstractHaskell.C_Expr)) -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_TypeExpr -> Curry_Prelude.C_Int
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
nd_C__case_225 x8 x4 x3 x2 x11 x6 x12 s cd cs = case x12 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` Curry_Prelude.OP_Cons (nd_OP_bindConsRule_dot_rule_dot_308 x6
    x11 x2 x3 x4 x8 s0 cd cs) Curry_Prelude.OP_List
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_225 x8 x4 x3 x2
    x11 x6 l s cd cs) (nd_C__case_225 x8 x4 x3 x2 x11 x6 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_225 x8
    x4 x3 x2 x11 x6 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_225 x8 x4 x3 x2
    x11 x6 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_225" [show x8, show x4, show x3, show x2, show x11, show
    x6, show x12] info)
  _ -> failCons cd (consFail "TransTypes._case_225" (showCons x12))

d_C__case_229 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_229 x1 x4 x3 x2 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_AbstractHaskellGoodies.d_C_constF (d_C_basics
    (Curry_Prelude.toCurryString "C_True") cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_228 x1 x4 x3 x2
    (Curry_Prelude.d_C_otherwise cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_229 x1 x4 x3 x2 l
    cd cs) (d_C__case_229 x1 x4 x3 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_229 x1
    x4 x3 x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_229 x1 x4 x3 x2 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_229" [show x1, show x4, show x3, show x2, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_229" (showCons x5))

d_C__case_228 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_228 x1 x4 x3 x2 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_foldr1 (acceptCs id
    (d_OP_unifiableConsRule_dot_unifBody_dot_294_dot_uscore_hash_lambda32 x2
    x3)) (Curry_Prelude.d_C_map
    (d_OP_unifiableConsRule_dot_unifBody_dot_294_dot_uscore_hash_lambda33 x2 x3
    x4) (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_enumFromTo_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
    cd cs) (Curry_Prelude.C_Int (1)) cd cs) x1 cd cs) cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_228 x1 x4 x3 x2 l
    cd cs) (d_C__case_228 x1 x4 x3 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_228 x1
    x4 x3 x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_228 x1 x4 x3 x2 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_228" [show x1, show x4, show x3, show x2, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_228" (showCons x5))

d_C__case_231 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
d_C__case_231 x5 x3 x2 x12 x11 x10 x9 cd cs = case x9 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_map
    (d_OP_unifiableConsRule_dot_rule_dot_294 x10 x11 x12 x2 x3)
    (Curry_Prelude.OP_Cons x5 (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply
    (Curry_Names.d_C_mkHoConsName cd cs) x5 cd cs) Curry_Prelude.OP_List)) cd cs
  Curry_Prelude.C_False -> d_C__case_230 x5 x3 x2 x12 x11 x10
    (Curry_Prelude.d_C_otherwise cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_231 x5 x3 x2 x12
    x11 x10 l cd cs) (d_C__case_231 x5 x3 x2 x12 x11 x10 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_231 x5
    x3 x2 x12 x11 x10 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_231 x5 x3 x2 x12
    x11 x10 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_231" [show x5, show x3, show x2, show x12, show x11, show
    x10, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_231" (showCons x9))

d_C__case_230 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
d_C__case_230 x5 x3 x2 x12 x11 x10 x13 cd cs = case x13 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons
    (d_OP_unifiableConsRule_dot_rule_dot_294 x10 x11 x12 x2 x3 x5 cd cs)
    Curry_Prelude.OP_List
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_230 x5 x3 x2 x12
    x11 x10 l cd cs) (d_C__case_230 x5 x3 x2 x12 x11 x10 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_230 x5
    x3 x2 x12 x11 x10 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_230 x5 x3 x2 x12
    x11 x10 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_230" [show x5, show x3, show x2, show x12, show x11, show
    x10, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_230" (showCons x13))

d_C__case_233 :: Curry_Prelude.C_Bool -> Curry_AbstractHaskell.C_TypeExpr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_ConsDecl -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeDecl
d_C__case_233 x1 x9 x4 x7 x2 x8 x10 cd cs = case x10 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_dollar (d_C_mkInstance (d_C_basics
    (Curry_Prelude.toCurryString "Unifiable") cd cs) Curry_Prelude.OP_List x9 x8
    cd cs) (Curry_Prelude.d_C_concat (Curry_Prelude.OP_Cons
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_concatMap (d_C_unifiableConsRule
    x2 (d_C_basics (Curry_Prelude.toCurryString "=.=") cd cs) (d_C_basics
    (Curry_Prelude.toCurryString "=:=") cd cs)) cd cs) x7 cd cs)
    (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Cons
    (d_OP_unifiableInstance_dot_newFail_dot_281 (d_C_basics
    (Curry_Prelude.toCurryString "=.=") cd cs) cd cs) Curry_Prelude.OP_List)
    (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_concatMap
    (d_C_unifiableConsRule x2 (d_C_basics (Curry_Prelude.toCurryString "=.<=")
    cd cs) (d_C_basics (Curry_Prelude.toCurryString "=:<=") cd cs)) cd cs) x7 cd
    cs) (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Cons
    (d_OP_unifiableInstance_dot_newFail_dot_281 (d_C_basics
    (Curry_Prelude.toCurryString "=.<=") cd cs) cd cs) Curry_Prelude.OP_List)
    (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_concatMap
    (d_C_bindConsRule x2 (d_C_basics (Curry_Prelude.toCurryString "bind") cd cs)
    (acceptCs (acceptCs id) d_OP_unifiableInstance_dot_uscore_hash_lambda29)
    (Curry_AbstractHaskellGoodies.d_C_applyF
    (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString "concat")
    cd cs))) cd cs) (Curry_Prelude.d_C_zip (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_enumFrom_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
    cd cs) (Curry_Prelude.C_Int (0)) cd cs) x7 cd cs) cd cs)
    (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Cons (d_C_bindChoiceRule x4
    (d_C_basics (Curry_Prelude.toCurryString "bind") cd cs) cd cs)
    (Curry_Prelude.OP_Cons (d_C_bindFreeRule x4 (d_C_basics
    (Curry_Prelude.toCurryString "bind") cd cs) cd cs) (Curry_Prelude.OP_Cons
    (d_C_bindNarrowedRule x4 (d_C_basics (Curry_Prelude.toCurryString "bind") cd
    cs) cd cs) (Curry_Prelude.OP_Cons (d_C_bindChoicesRule x4 (d_C_basics
    (Curry_Prelude.toCurryString "bind") cd cs) cd cs) (Curry_Prelude.OP_Cons
    (d_C_bindFailRule x4 (d_C_basics (Curry_Prelude.toCurryString "bind") cd cs)
    cd cs) (Curry_Prelude.OP_Cons (d_C_bindGuardRule x4 Curry_Prelude.C_False cd
    cs) Curry_Prelude.OP_List)))))) (Curry_Prelude.OP_Cons
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_concatMap (d_C_bindConsRule x2
    (d_C_basics (Curry_Prelude.toCurryString "lazyBind") cd cs) (acceptCs
    (acceptCs id) d_OP_unifiableInstance_dot_uscore_hash_lambda30)
    Curry_Prelude.d_C_head) cd cs) (Curry_Prelude.d_C_zip
    (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_enumFrom_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
    cd cs) (Curry_Prelude.C_Int (0)) cd cs) x7 cd cs) cd cs)
    (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Cons (d_C_bindChoiceRule x4
    (d_C_basics (Curry_Prelude.toCurryString "lazyBind") cd cs) cd cs)
    (Curry_Prelude.OP_Cons (d_C_bindFreeRule x4 (d_C_basics
    (Curry_Prelude.toCurryString "lazyBind") cd cs) cd cs)
    (Curry_Prelude.OP_Cons (d_C_bindNarrowedRule x4 (d_C_basics
    (Curry_Prelude.toCurryString "lazyBind") cd cs) cd cs)
    (Curry_Prelude.OP_Cons (d_C_bindChoicesRule x4 (d_C_basics
    (Curry_Prelude.toCurryString "lazyBind") cd cs) cd cs)
    (Curry_Prelude.OP_Cons (d_C_bindFailRule x4 (d_C_basics
    (Curry_Prelude.toCurryString "lazyBind") cd cs) cd cs)
    (Curry_Prelude.OP_Cons (d_C_bindGuardRule x4 Curry_Prelude.C_True cd cs)
    Curry_Prelude.OP_List)))))) Curry_Prelude.OP_List)))))))) cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_232 x9 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_233 x1 x9 x4 x7
    x2 x8 l cd cs) (d_C__case_233 x1 x9 x4 x7 x2 x8 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_233 x1
    x9 x4 x7 x2 x8 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_233 x1 x9 x4 x7
    x2 x8 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_233" [show x1, show x9, show x4, show x7, show x2, show x8
    , show x10] info)
  _ -> failCons cd (consFail "TransTypes._case_233" (showCons x10))

nd_C__case_233 :: Curry_Prelude.C_Bool -> Curry_AbstractHaskell.C_TypeExpr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_ConsDecl -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_TypeDecl
nd_C__case_233 x1 x9 x4 x7 x2 x8 x10 s cd cs = case x10 of
  Curry_Prelude.C_True -> let s20 = s
    in s20 `seq` (let s19 = leftSupply s20
                      s18 = rightSupply s20
    in s19 `seq` (s18 `seq` Curry_Prelude.nd_OP_dollar (wrapDX id
    (d_C_mkInstance (d_C_basics (Curry_Prelude.toCurryString "Unifiable") cd cs)
    Curry_Prelude.OP_List x9 x8 cd cs)) (Curry_Prelude.d_C_concat
    (let s2 = leftSupply s18
         s17 = rightSupply s18
    in s2 `seq` (s17 `seq` Curry_Prelude.OP_Cons (let s1 = leftSupply s2
                                                      s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_concatMap
    (wrapNX id (nd_C_unifiableConsRule x2 (d_C_basics
    (Curry_Prelude.toCurryString "=.=") cd cs) (d_C_basics
    (Curry_Prelude.toCurryString "=:=") cd cs))) s0 cd cs) x7 s1 cd cs))
    (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Cons
    (d_OP_unifiableInstance_dot_newFail_dot_281 (d_C_basics
    (Curry_Prelude.toCurryString "=.=") cd cs) cd cs) Curry_Prelude.OP_List)
    (let s5 = leftSupply s17
         s16 = rightSupply s17
    in s5 `seq` (s16 `seq` Curry_Prelude.OP_Cons (let s4 = leftSupply s5
                                                      s3 = rightSupply s5
    in s4 `seq` (s3 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_concatMap
    (wrapNX id (nd_C_unifiableConsRule x2 (d_C_basics
    (Curry_Prelude.toCurryString "=.<=") cd cs) (d_C_basics
    (Curry_Prelude.toCurryString "=:<=") cd cs))) s3 cd cs) x7 s4 cd cs))
    (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Cons
    (d_OP_unifiableInstance_dot_newFail_dot_281 (d_C_basics
    (Curry_Prelude.toCurryString "=.<=") cd cs) cd cs) Curry_Prelude.OP_List)
    (let s9 = leftSupply s16
         s14 = rightSupply s16
    in s9 `seq` (s14 `seq` Curry_Prelude.OP_Cons (let s8 = leftSupply s9
                                                      s10 = rightSupply s9
                                                      s6 = leftSupply s10
                                                      s7 = rightSupply s10
    in s8 `seq` (s10 `seq` (s6 `seq` (s7 `seq` Curry_Prelude.nd_C_apply
    (Curry_Prelude.nd_C_concatMap (wrapNX id (nd_C_bindConsRule x2 (d_C_basics
    (Curry_Prelude.toCurryString "bind") cd cs) (wrapDX (wrapDX (wrapDX id))
    (acceptCs (acceptCs id) d_OP_unifiableInstance_dot_uscore_hash_lambda29))
    (wrapDX id (Curry_AbstractHaskellGoodies.d_C_applyF
    (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString "concat")
    cd cs))))) s6 cd cs) (Curry_Prelude.d_C_zip (Curry_Prelude.nd_C_apply
    (wrapDX id
    (Curry_Prelude.d_OP_uscore_impl_hash_enumFrom_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
    cd cs)) (Curry_Prelude.C_Int (0)) s7 cd cs) x7 cd cs) s8 cd cs))))
    (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Cons (d_C_bindChoiceRule x4
    (d_C_basics (Curry_Prelude.toCurryString "bind") cd cs) cd cs)
    (Curry_Prelude.OP_Cons (d_C_bindFreeRule x4 (d_C_basics
    (Curry_Prelude.toCurryString "bind") cd cs) cd cs) (Curry_Prelude.OP_Cons
    (d_C_bindNarrowedRule x4 (d_C_basics (Curry_Prelude.toCurryString "bind") cd
    cs) cd cs) (Curry_Prelude.OP_Cons (d_C_bindChoicesRule x4 (d_C_basics
    (Curry_Prelude.toCurryString "bind") cd cs) cd cs) (Curry_Prelude.OP_Cons
    (d_C_bindFailRule x4 (d_C_basics (Curry_Prelude.toCurryString "bind") cd cs)
    cd cs) (Curry_Prelude.OP_Cons (d_C_bindGuardRule x4 Curry_Prelude.C_False cd
    cs) Curry_Prelude.OP_List)))))) (Curry_Prelude.OP_Cons (let s13 = leftSupply
                                                                  s14
                                                                s15 = rightSupply
                                                                  s14
                                                                s11 = leftSupply
                                                                  s15
                                                                s12 = rightSupply
                                                                  s15
    in s13 `seq` (s15 `seq` (s11 `seq` (s12 `seq` Curry_Prelude.nd_C_apply
    (Curry_Prelude.nd_C_concatMap (wrapNX id (nd_C_bindConsRule x2 (d_C_basics
    (Curry_Prelude.toCurryString "lazyBind") cd cs) (wrapDX (wrapDX (wrapDX id))
    (acceptCs (acceptCs id) d_OP_unifiableInstance_dot_uscore_hash_lambda30))
    (wrapDX id Curry_Prelude.d_C_head))) s11 cd cs) (Curry_Prelude.d_C_zip
    (Curry_Prelude.nd_C_apply (wrapDX id
    (Curry_Prelude.d_OP_uscore_impl_hash_enumFrom_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
    cd cs)) (Curry_Prelude.C_Int (0)) s12 cd cs) x7 cd cs) s13 cd cs))))
    (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Cons (d_C_bindChoiceRule x4
    (d_C_basics (Curry_Prelude.toCurryString "lazyBind") cd cs) cd cs)
    (Curry_Prelude.OP_Cons (d_C_bindFreeRule x4 (d_C_basics
    (Curry_Prelude.toCurryString "lazyBind") cd cs) cd cs)
    (Curry_Prelude.OP_Cons (d_C_bindNarrowedRule x4 (d_C_basics
    (Curry_Prelude.toCurryString "lazyBind") cd cs) cd cs)
    (Curry_Prelude.OP_Cons (d_C_bindChoicesRule x4 (d_C_basics
    (Curry_Prelude.toCurryString "lazyBind") cd cs) cd cs)
    (Curry_Prelude.OP_Cons (d_C_bindFailRule x4 (d_C_basics
    (Curry_Prelude.toCurryString "lazyBind") cd cs) cd cs)
    (Curry_Prelude.OP_Cons (d_C_bindGuardRule x4 Curry_Prelude.C_True cd cs)
    Curry_Prelude.OP_List)))))) Curry_Prelude.OP_List))))))))))) cd cs) s19 cd
    cs))
  Curry_Prelude.C_False -> d_C__case_232 x9 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_233 x1 x9 x4 x7
    x2 x8 l s cd cs) (nd_C__case_233 x1 x9 x4 x7 x2 x8 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_233 x1
    x9 x4 x7 x2 x8 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_233 x1 x9 x4 x7
    x2 x8 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_233" [show x1, show x9, show x4, show x7, show x2, show x8
    , show x10] info)
  _ -> failCons cd (consFail "TransTypes._case_233" (showCons x10))

d_C__case_232 :: Curry_AbstractHaskell.C_TypeExpr -> Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeDecl
d_C__case_232 x9 x10 cd cs = case x10 of
  Curry_Prelude.C_True -> d_C_mkEmptyInstance (d_C_basics
    (Curry_Prelude.toCurryString "Unifiable") cd cs) x9 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "TransTypes.unifiableInstance") cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_232 x9 l cd cs)
    (d_C__case_232 x9 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_232 x9
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_232 x9 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_232" [show x9, show x10] info)
  _ -> failCons cd (consFail "TransTypes._case_232" (showCons x10))

d_C__case_236 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_236 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_235 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_236 l cd cs)
    (d_C__case_236 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_236 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_236 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_236" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_236" (showCons x3))

d_C__case_235 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_235 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_234 x6 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_235 l cd cs)
    (d_C__case_235 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_235 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_235 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_235" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_235" (showCons x5))

d_C__case_234 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_234 x6 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> x6
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_234 x6 l cd cs)
    (d_C__case_234 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_234 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_234 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_234" [show x6, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_234" (showCons x7))

d_C__case_239 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_239 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_238 x4 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_239 l cd cs)
    (d_C__case_239 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_239 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_239 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_239" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_239" (showCons x3))

d_C__case_238 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_238 x4 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_237 x4 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_238 x4 l cd cs)
    (d_C__case_238 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_238 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_238 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_238" [show x4, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_238" (showCons x5))

d_C__case_237 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_237 x4 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> x4
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_237 x4 l cd cs)
    (d_C__case_237 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_237 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_237 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_237" [show x4, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_237" (showCons x7))

d_C__case_242 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_242 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_241 x2 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_242 x2 l cd cs)
    (d_C__case_242 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_242 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_242 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_242" [show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_242" (showCons x3))

d_C__case_241 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_241 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_240 x2 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_241 x2 l cd cs)
    (d_C__case_241 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_241 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_241 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_241" [show x2, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_241" (showCons x5))

d_C__case_240 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_240 x2 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_240 x2 l cd cs)
    (d_C__case_240 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_240 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_240 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_240" [show x2, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_240" (showCons x7))

d_C__case_245 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_245 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_244 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_245 l cd cs)
    (d_C__case_245 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_245 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_245 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_245" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_245" (showCons x3))

d_C__case_244 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_244 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_243 x6 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_244 l cd cs)
    (d_C__case_244 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_244 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_244 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_244" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_244" (showCons x5))

d_C__case_243 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_243 x6 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> x6
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_243 x6 l cd cs)
    (d_C__case_243 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_243 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_243 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_243" [show x6, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_243" (showCons x7))

d_C__case_248 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_248 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_247 x4 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_248 l cd cs)
    (d_C__case_248 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_248 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_248 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_248" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_248" (showCons x3))

d_C__case_247 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_247 x4 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_246 x4 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_247 x4 l cd cs)
    (d_C__case_247 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_247 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_247 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_247" [show x4, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_247" (showCons x5))

d_C__case_246 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_246 x4 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> x4
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_246 x4 l cd cs)
    (d_C__case_246 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_246 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_246 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_246" [show x4, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_246" (showCons x7))

d_C__case_251 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_251 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_250 x2 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_251 x2 l cd cs)
    (d_C__case_251 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_251 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_251 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_251" [show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_251" (showCons x3))

d_C__case_250 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_250 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_249 x2 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_250 x2 l cd cs)
    (d_C__case_250 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_250 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_250 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_250" [show x2, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_250" (showCons x5))

d_C__case_249 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_249 x2 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_249 x2 l cd cs)
    (d_C__case_249 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_249 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_249 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_249" [show x2, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_249" (showCons x7))

d_C__case_252 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C__case_252 x4 x9 x11 x12 cd cs = case x12 of
  Curry_Prelude.C_True -> x11
  Curry_Prelude.C_False -> x9
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_252 x4 x9 x11 l
    cd cs) (d_C__case_252 x4 x9 x11 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_252 x4
    x9 x11 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_252 x4 x9 x11 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_252" [show x4, show x9, show x11, show x12] info)
  _ -> failCons cd (consFail "TransTypes._case_252" (showCons x12))

d_C__case_254 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
d_C__case_254 x3 x9 x12 x10 x4 x7 cd cs = case x7 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_map
    (d_OP_searchNFConsRule_dot_rule_dot_265 x4 x10 x12 x9)
    (Curry_Prelude.OP_Cons x3 (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply
    (Curry_Names.d_C_mkHoConsName cd cs) x3 cd cs) Curry_Prelude.OP_List)) cd cs
  Curry_Prelude.C_False -> d_C__case_253 x3 x9 x12 x10 x4
    (Curry_Prelude.d_C_otherwise cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_254 x3 x9 x12 x10
    x4 l cd cs) (d_C__case_254 x3 x9 x12 x10 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_254 x3
    x9 x12 x10 x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_254 x3 x9 x12 x10
    x4 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_254" [show x3, show x9, show x12, show x10, show x4, show
    x7] info)
  _ -> failCons cd (consFail "TransTypes._case_254" (showCons x7))

d_C__case_253 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
d_C__case_253 x3 x9 x12 x10 x4 x13 cd cs = case x13 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons
    (d_OP_searchNFConsRule_dot_rule_dot_265 x4 x10 x12 x9 x3 cd cs)
    Curry_Prelude.OP_List
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_253 x3 x9 x12 x10
    x4 l cd cs) (d_C__case_253 x3 x9 x12 x10 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_253 x3
    x9 x12 x10 x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_253 x3 x9 x12 x10
    x4 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_253" [show x3, show x9, show x12, show x10, show x4, show
    x13] info)
  _ -> failCons cd (consFail "TransTypes._case_253" (showCons x13))

d_C__case_255 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_255 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_List -> x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_255 x2 l cd cs)
    (d_C__case_255 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_255 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_255 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_255" [show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_255" (showCons x3))

d_C__case_257 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
d_C__case_257 x3 x4 x7 cd cs = case x7 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_map
    (d_OP_showConsConsRule_dot_rule_dot_255 x4) (Curry_Prelude.OP_Cons x3
    (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply
    (Curry_Names.d_C_mkHoConsName cd cs) x3 cd cs) Curry_Prelude.OP_List)) cd cs
  Curry_Prelude.C_False -> d_C__case_256 x3 x4 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_257 x3 x4 l cd
    cs) (d_C__case_257 x3 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_257 x3
    x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_257 x3 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_257" [show x3, show x4, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_257" (showCons x7))

d_C__case_256 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
d_C__case_256 x3 x4 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons
    (d_OP_showConsConsRule_dot_rule_dot_255 x4 x3 cd cs) Curry_Prelude.OP_List
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_256 x3 x4 l cd
    cs) (d_C__case_256 x3 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_256 x3
    x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_256 x3 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_256" [show x3, show x4, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_256" (showCons x5))

d_C__case_269 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_269 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_268 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_269 l cd cs)
    (d_C__case_269 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_269 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_269 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_269" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_269" (showCons x3))

d_C__case_268 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_268 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_267 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_268 l cd cs)
    (d_C__case_268 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_268 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_268 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_268" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_268" (showCons x5))

d_C__case_267 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_267 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_266 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_267 l cd cs)
    (d_C__case_267 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_267 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_267 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_267" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_267" (showCons x7))

d_C__case_266 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_266 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_265 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_266 l cd cs)
    (d_C__case_266 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_266 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_266 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_266" [show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_266" (showCons x9))

d_C__case_265 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_265 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_264 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_265 l cd cs)
    (d_C__case_265 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_265 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_265 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_265" [show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_265" (showCons x11))

d_C__case_264 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_264 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_263 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_264 l cd cs)
    (d_C__case_264 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_264 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_264 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_264" [show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_264" (showCons x13))

d_C__case_263 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_263 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_262 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_263 l cd cs)
    (d_C__case_263 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_263 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_263 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_263" [show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_263" (showCons x15))

d_C__case_262 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_262 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_261 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_262 l cd cs)
    (d_C__case_262 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_262 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_262 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_262" [show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_262" (showCons x17))

d_C__case_261 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_261 x19 cd cs = case x19 of
  Curry_Prelude.OP_Cons x20 x21 -> d_C__case_260 x21 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_261 l cd cs)
    (d_C__case_261 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_261 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_261 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_261" [show x19] info)
  _ -> failCons cd (consFail "TransTypes._case_261" (showCons x19))

d_C__case_260 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_260 x21 cd cs = case x21 of
  Curry_Prelude.OP_Cons x22 x23 -> d_C__case_259 x23 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_260 l cd cs)
    (d_C__case_260 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_260 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_260 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_260" [show x21] info)
  _ -> failCons cd (consFail "TransTypes._case_260" (showCons x21))

d_C__case_259 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_259 x23 cd cs = case x23 of
  Curry_Prelude.OP_Cons x24 x25 -> d_C__case_258 x24 x25 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_259 l cd cs)
    (d_C__case_259 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_259 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_259 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_259" [show x23] info)
  _ -> failCons cd (consFail "TransTypes._case_259" (showCons x23))

d_C__case_258 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_258 x24 x25 cd cs = case x25 of
  Curry_Prelude.OP_List -> x24
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_258 x24 l cd cs)
    (d_C__case_258 x24 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_258
    x24 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_258 x24 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_258" [show x24, show x25] info)
  _ -> failCons cd (consFail "TransTypes._case_258" (showCons x25))

d_C__case_281 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_281 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_280 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_281 l cd cs)
    (d_C__case_281 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_281 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_281 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_281" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_281" (showCons x3))

d_C__case_280 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_280 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_279 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_280 l cd cs)
    (d_C__case_280 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_280 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_280 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_280" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_280" (showCons x5))

d_C__case_279 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_279 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_278 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_279 l cd cs)
    (d_C__case_279 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_279 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_279 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_279" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_279" (showCons x7))

d_C__case_278 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_278 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_277 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_278 l cd cs)
    (d_C__case_278 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_278 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_278 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_278" [show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_278" (showCons x9))

d_C__case_277 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_277 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_276 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_277 l cd cs)
    (d_C__case_277 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_277 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_277 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_277" [show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_277" (showCons x11))

d_C__case_276 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_276 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_275 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_276 l cd cs)
    (d_C__case_276 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_276 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_276 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_276" [show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_276" (showCons x13))

d_C__case_275 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_275 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_274 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_275 l cd cs)
    (d_C__case_275 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_275 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_275 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_275" [show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_275" (showCons x15))

d_C__case_274 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_274 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_273 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_274 l cd cs)
    (d_C__case_274 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_274 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_274 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_274" [show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_274" (showCons x17))

d_C__case_273 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_273 x19 cd cs = case x19 of
  Curry_Prelude.OP_Cons x20 x21 -> d_C__case_272 x21 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_273 l cd cs)
    (d_C__case_273 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_273 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_273 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_273" [show x19] info)
  _ -> failCons cd (consFail "TransTypes._case_273" (showCons x19))

d_C__case_272 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_272 x21 cd cs = case x21 of
  Curry_Prelude.OP_Cons x22 x23 -> d_C__case_271 x22 x23 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_272 l cd cs)
    (d_C__case_272 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_272 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_272 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_272" [show x21] info)
  _ -> failCons cd (consFail "TransTypes._case_272" (showCons x21))

d_C__case_271 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_271 x22 x23 cd cs = case x23 of
  Curry_Prelude.OP_Cons x24 x25 -> d_C__case_270 x22 x25 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_271 x22 l cd cs)
    (d_C__case_271 x22 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_271
    x22 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_271 x22 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_271" [show x22, show x23] info)
  _ -> failCons cd (consFail "TransTypes._case_271" (showCons x23))

d_C__case_270 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_270 x22 x25 cd cs = case x25 of
  Curry_Prelude.OP_List -> x22
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_270 x22 l cd cs)
    (d_C__case_270 x22 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_270
    x22 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_270 x22 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_270" [show x22, show x25] info)
  _ -> failCons cd (consFail "TransTypes._case_270" (showCons x25))

d_C__case_293 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_293 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_292 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_293 l cd cs)
    (d_C__case_293 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_293 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_293 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_293" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_293" (showCons x3))

d_C__case_292 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_292 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_291 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_292 l cd cs)
    (d_C__case_292 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_292 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_292 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_292" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_292" (showCons x5))

d_C__case_291 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_291 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_290 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_291 l cd cs)
    (d_C__case_291 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_291 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_291 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_291" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_291" (showCons x7))

d_C__case_290 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_290 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_289 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_290 l cd cs)
    (d_C__case_290 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_290 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_290 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_290" [show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_290" (showCons x9))

d_C__case_289 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_289 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_288 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_289 l cd cs)
    (d_C__case_289 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_289 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_289 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_289" [show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_289" (showCons x11))

d_C__case_288 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_288 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_287 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_288 l cd cs)
    (d_C__case_288 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_288 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_288 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_288" [show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_288" (showCons x13))

d_C__case_287 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_287 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_286 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_287 l cd cs)
    (d_C__case_287 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_287 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_287 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_287" [show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_287" (showCons x15))

d_C__case_286 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_286 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_285 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_286 l cd cs)
    (d_C__case_286 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_286 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_286 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_286" [show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_286" (showCons x17))

d_C__case_285 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_285 x19 cd cs = case x19 of
  Curry_Prelude.OP_Cons x20 x21 -> d_C__case_284 x20 x21 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_285 l cd cs)
    (d_C__case_285 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_285 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_285 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_285" [show x19] info)
  _ -> failCons cd (consFail "TransTypes._case_285" (showCons x19))

d_C__case_284 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_284 x20 x21 cd cs = case x21 of
  Curry_Prelude.OP_Cons x22 x23 -> d_C__case_283 x20 x23 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_284 x20 l cd cs)
    (d_C__case_284 x20 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_284
    x20 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_284 x20 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_284" [show x20, show x21] info)
  _ -> failCons cd (consFail "TransTypes._case_284" (showCons x21))

d_C__case_283 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_283 x20 x23 cd cs = case x23 of
  Curry_Prelude.OP_Cons x24 x25 -> d_C__case_282 x20 x25 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_283 x20 l cd cs)
    (d_C__case_283 x20 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_283
    x20 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_283 x20 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_283" [show x20, show x23] info)
  _ -> failCons cd (consFail "TransTypes._case_283" (showCons x23))

d_C__case_282 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_282 x20 x25 cd cs = case x25 of
  Curry_Prelude.OP_List -> x20
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_282 x20 l cd cs)
    (d_C__case_282 x20 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_282
    x20 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_282 x20 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_282" [show x20, show x25] info)
  _ -> failCons cd (consFail "TransTypes._case_282" (showCons x25))

d_C__case_305 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_305 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_304 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_305 l cd cs)
    (d_C__case_305 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_305 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_305 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_305" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_305" (showCons x3))

d_C__case_304 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_304 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_303 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_304 l cd cs)
    (d_C__case_304 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_304 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_304 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_304" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_304" (showCons x5))

d_C__case_303 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_303 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_302 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_303 l cd cs)
    (d_C__case_303 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_303 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_303 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_303" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_303" (showCons x7))

d_C__case_302 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_302 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_301 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_302 l cd cs)
    (d_C__case_302 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_302 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_302 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_302" [show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_302" (showCons x9))

d_C__case_301 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_301 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_300 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_301 l cd cs)
    (d_C__case_301 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_301 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_301 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_301" [show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_301" (showCons x11))

d_C__case_300 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_300 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_299 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_300 l cd cs)
    (d_C__case_300 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_300 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_300 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_300" [show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_300" (showCons x13))

d_C__case_299 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_299 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_298 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_299 l cd cs)
    (d_C__case_299 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_299 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_299 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_299" [show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_299" (showCons x15))

d_C__case_298 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_298 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_297 x18 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_298 l cd cs)
    (d_C__case_298 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_298 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_298 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_298" [show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_298" (showCons x17))

d_C__case_297 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_297 x18 x19 cd cs = case x19 of
  Curry_Prelude.OP_Cons x20 x21 -> d_C__case_296 x18 x21 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_297 x18 l cd cs)
    (d_C__case_297 x18 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_297
    x18 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_297 x18 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_297" [show x18, show x19] info)
  _ -> failCons cd (consFail "TransTypes._case_297" (showCons x19))

d_C__case_296 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_296 x18 x21 cd cs = case x21 of
  Curry_Prelude.OP_Cons x22 x23 -> d_C__case_295 x18 x23 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_296 x18 l cd cs)
    (d_C__case_296 x18 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_296
    x18 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_296 x18 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_296" [show x18, show x21] info)
  _ -> failCons cd (consFail "TransTypes._case_296" (showCons x21))

d_C__case_295 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_295 x18 x23 cd cs = case x23 of
  Curry_Prelude.OP_Cons x24 x25 -> d_C__case_294 x18 x25 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_295 x18 l cd cs)
    (d_C__case_295 x18 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_295
    x18 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_295 x18 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_295" [show x18, show x23] info)
  _ -> failCons cd (consFail "TransTypes._case_295" (showCons x23))

d_C__case_294 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_294 x18 x25 cd cs = case x25 of
  Curry_Prelude.OP_List -> x18
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_294 x18 l cd cs)
    (d_C__case_294 x18 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_294
    x18 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_294 x18 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_294" [show x18, show x25] info)
  _ -> failCons cd (consFail "TransTypes._case_294" (showCons x25))

d_C__case_317 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_317 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_316 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_317 l cd cs)
    (d_C__case_317 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_317 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_317 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_317" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_317" (showCons x3))

d_C__case_316 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_316 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_315 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_316 l cd cs)
    (d_C__case_316 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_316 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_316 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_316" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_316" (showCons x5))

d_C__case_315 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_315 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_314 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_315 l cd cs)
    (d_C__case_315 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_315 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_315 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_315" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_315" (showCons x7))

d_C__case_314 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_314 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_313 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_314 l cd cs)
    (d_C__case_314 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_314 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_314 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_314" [show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_314" (showCons x9))

d_C__case_313 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_313 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_312 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_313 l cd cs)
    (d_C__case_313 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_313 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_313 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_313" [show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_313" (showCons x11))

d_C__case_312 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_312 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_311 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_312 l cd cs)
    (d_C__case_312 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_312 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_312 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_312" [show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_312" (showCons x13))

d_C__case_311 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_311 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_310 x16 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_311 l cd cs)
    (d_C__case_311 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_311 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_311 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_311" [show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_311" (showCons x15))

d_C__case_310 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_310 x16 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_309 x16 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_310 x16 l cd cs)
    (d_C__case_310 x16 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_310
    x16 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_310 x16 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_310" [show x16, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_310" (showCons x17))

d_C__case_309 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_309 x16 x19 cd cs = case x19 of
  Curry_Prelude.OP_Cons x20 x21 -> d_C__case_308 x16 x21 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_309 x16 l cd cs)
    (d_C__case_309 x16 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_309
    x16 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_309 x16 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_309" [show x16, show x19] info)
  _ -> failCons cd (consFail "TransTypes._case_309" (showCons x19))

d_C__case_308 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_308 x16 x21 cd cs = case x21 of
  Curry_Prelude.OP_Cons x22 x23 -> d_C__case_307 x16 x23 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_308 x16 l cd cs)
    (d_C__case_308 x16 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_308
    x16 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_308 x16 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_308" [show x16, show x21] info)
  _ -> failCons cd (consFail "TransTypes._case_308" (showCons x21))

d_C__case_307 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_307 x16 x23 cd cs = case x23 of
  Curry_Prelude.OP_Cons x24 x25 -> d_C__case_306 x16 x25 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_307 x16 l cd cs)
    (d_C__case_307 x16 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_307
    x16 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_307 x16 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_307" [show x16, show x23] info)
  _ -> failCons cd (consFail "TransTypes._case_307" (showCons x23))

d_C__case_306 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_306 x16 x25 cd cs = case x25 of
  Curry_Prelude.OP_List -> x16
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_306 x16 l cd cs)
    (d_C__case_306 x16 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_306
    x16 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_306 x16 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_306" [show x16, show x25] info)
  _ -> failCons cd (consFail "TransTypes._case_306" (showCons x25))

d_C__case_329 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_329 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_328 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_329 l cd cs)
    (d_C__case_329 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_329 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_329 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_329" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_329" (showCons x3))

d_C__case_328 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_328 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_327 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_328 l cd cs)
    (d_C__case_328 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_328 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_328 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_328" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_328" (showCons x5))

d_C__case_327 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_327 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_326 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_327 l cd cs)
    (d_C__case_327 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_327 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_327 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_327" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_327" (showCons x7))

d_C__case_326 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_326 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_325 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_326 l cd cs)
    (d_C__case_326 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_326 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_326 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_326" [show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_326" (showCons x9))

d_C__case_325 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_325 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_324 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_325 l cd cs)
    (d_C__case_325 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_325 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_325 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_325" [show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_325" (showCons x11))

d_C__case_324 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_324 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_323 x14 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_324 l cd cs)
    (d_C__case_324 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_324 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_324 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_324" [show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_324" (showCons x13))

d_C__case_323 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_323 x14 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_322 x14 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_323 x14 l cd cs)
    (d_C__case_323 x14 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_323
    x14 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_323 x14 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_323" [show x14, show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_323" (showCons x15))

d_C__case_322 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_322 x14 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_321 x14 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_322 x14 l cd cs)
    (d_C__case_322 x14 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_322
    x14 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_322 x14 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_322" [show x14, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_322" (showCons x17))

d_C__case_321 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_321 x14 x19 cd cs = case x19 of
  Curry_Prelude.OP_Cons x20 x21 -> d_C__case_320 x14 x21 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_321 x14 l cd cs)
    (d_C__case_321 x14 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_321
    x14 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_321 x14 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_321" [show x14, show x19] info)
  _ -> failCons cd (consFail "TransTypes._case_321" (showCons x19))

d_C__case_320 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_320 x14 x21 cd cs = case x21 of
  Curry_Prelude.OP_Cons x22 x23 -> d_C__case_319 x14 x23 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_320 x14 l cd cs)
    (d_C__case_320 x14 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_320
    x14 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_320 x14 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_320" [show x14, show x21] info)
  _ -> failCons cd (consFail "TransTypes._case_320" (showCons x21))

d_C__case_319 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_319 x14 x23 cd cs = case x23 of
  Curry_Prelude.OP_Cons x24 x25 -> d_C__case_318 x14 x25 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_319 x14 l cd cs)
    (d_C__case_319 x14 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_319
    x14 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_319 x14 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_319" [show x14, show x23] info)
  _ -> failCons cd (consFail "TransTypes._case_319" (showCons x23))

d_C__case_318 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_318 x14 x25 cd cs = case x25 of
  Curry_Prelude.OP_List -> x14
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_318 x14 l cd cs)
    (d_C__case_318 x14 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_318
    x14 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_318 x14 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_318" [show x14, show x25] info)
  _ -> failCons cd (consFail "TransTypes._case_318" (showCons x25))

d_C__case_341 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_341 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_340 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_341 l cd cs)
    (d_C__case_341 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_341 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_341 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_341" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_341" (showCons x3))

d_C__case_340 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_340 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_339 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_340 l cd cs)
    (d_C__case_340 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_340 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_340 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_340" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_340" (showCons x5))

d_C__case_339 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_339 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_338 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_339 l cd cs)
    (d_C__case_339 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_339 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_339 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_339" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_339" (showCons x7))

d_C__case_338 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_338 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_337 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_338 l cd cs)
    (d_C__case_338 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_338 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_338 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_338" [show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_338" (showCons x9))

d_C__case_337 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_337 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_336 x12 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_337 l cd cs)
    (d_C__case_337 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_337 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_337 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_337" [show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_337" (showCons x11))

d_C__case_336 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_336 x12 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_335 x12 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_336 x12 l cd cs)
    (d_C__case_336 x12 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_336
    x12 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_336 x12 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_336" [show x12, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_336" (showCons x13))

d_C__case_335 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_335 x12 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_334 x12 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_335 x12 l cd cs)
    (d_C__case_335 x12 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_335
    x12 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_335 x12 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_335" [show x12, show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_335" (showCons x15))

d_C__case_334 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_334 x12 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_333 x12 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_334 x12 l cd cs)
    (d_C__case_334 x12 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_334
    x12 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_334 x12 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_334" [show x12, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_334" (showCons x17))

d_C__case_333 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_333 x12 x19 cd cs = case x19 of
  Curry_Prelude.OP_Cons x20 x21 -> d_C__case_332 x12 x21 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_333 x12 l cd cs)
    (d_C__case_333 x12 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_333
    x12 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_333 x12 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_333" [show x12, show x19] info)
  _ -> failCons cd (consFail "TransTypes._case_333" (showCons x19))

d_C__case_332 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_332 x12 x21 cd cs = case x21 of
  Curry_Prelude.OP_Cons x22 x23 -> d_C__case_331 x12 x23 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_332 x12 l cd cs)
    (d_C__case_332 x12 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_332
    x12 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_332 x12 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_332" [show x12, show x21] info)
  _ -> failCons cd (consFail "TransTypes._case_332" (showCons x21))

d_C__case_331 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_331 x12 x23 cd cs = case x23 of
  Curry_Prelude.OP_Cons x24 x25 -> d_C__case_330 x12 x25 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_331 x12 l cd cs)
    (d_C__case_331 x12 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_331
    x12 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_331 x12 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_331" [show x12, show x23] info)
  _ -> failCons cd (consFail "TransTypes._case_331" (showCons x23))

d_C__case_330 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_330 x12 x25 cd cs = case x25 of
  Curry_Prelude.OP_List -> x12
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_330 x12 l cd cs)
    (d_C__case_330 x12 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_330
    x12 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_330 x12 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_330" [show x12, show x25] info)
  _ -> failCons cd (consFail "TransTypes._case_330" (showCons x25))

d_C__case_353 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_353 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_352 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_353 l cd cs)
    (d_C__case_353 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_353 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_353 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_353" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_353" (showCons x3))

d_C__case_352 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_352 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_351 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_352 l cd cs)
    (d_C__case_352 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_352 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_352 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_352" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_352" (showCons x5))

d_C__case_351 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_351 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_350 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_351 l cd cs)
    (d_C__case_351 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_351 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_351 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_351" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_351" (showCons x7))

d_C__case_350 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_350 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_349 x10 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_350 l cd cs)
    (d_C__case_350 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_350 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_350 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_350" [show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_350" (showCons x9))

d_C__case_349 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_349 x10 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_348 x10 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_349 x10 l cd cs)
    (d_C__case_349 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_349
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_349 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_349" [show x10, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_349" (showCons x11))

d_C__case_348 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_348 x10 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_347 x10 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_348 x10 l cd cs)
    (d_C__case_348 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_348
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_348 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_348" [show x10, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_348" (showCons x13))

d_C__case_347 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_347 x10 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_346 x10 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_347 x10 l cd cs)
    (d_C__case_347 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_347
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_347 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_347" [show x10, show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_347" (showCons x15))

d_C__case_346 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_346 x10 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_345 x10 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_346 x10 l cd cs)
    (d_C__case_346 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_346
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_346 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_346" [show x10, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_346" (showCons x17))

d_C__case_345 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_345 x10 x19 cd cs = case x19 of
  Curry_Prelude.OP_Cons x20 x21 -> d_C__case_344 x10 x21 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_345 x10 l cd cs)
    (d_C__case_345 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_345
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_345 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_345" [show x10, show x19] info)
  _ -> failCons cd (consFail "TransTypes._case_345" (showCons x19))

d_C__case_344 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_344 x10 x21 cd cs = case x21 of
  Curry_Prelude.OP_Cons x22 x23 -> d_C__case_343 x10 x23 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_344 x10 l cd cs)
    (d_C__case_344 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_344
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_344 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_344" [show x10, show x21] info)
  _ -> failCons cd (consFail "TransTypes._case_344" (showCons x21))

d_C__case_343 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_343 x10 x23 cd cs = case x23 of
  Curry_Prelude.OP_Cons x24 x25 -> d_C__case_342 x10 x25 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_343 x10 l cd cs)
    (d_C__case_343 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_343
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_343 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_343" [show x10, show x23] info)
  _ -> failCons cd (consFail "TransTypes._case_343" (showCons x23))

d_C__case_342 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_342 x10 x25 cd cs = case x25 of
  Curry_Prelude.OP_List -> x10
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_342 x10 l cd cs)
    (d_C__case_342 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_342
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_342 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_342" [show x10, show x25] info)
  _ -> failCons cd (consFail "TransTypes._case_342" (showCons x25))

d_C__case_365 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_365 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_364 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_365 l cd cs)
    (d_C__case_365 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_365 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_365 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_365" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_365" (showCons x3))

d_C__case_364 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_364 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_363 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_364 l cd cs)
    (d_C__case_364 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_364 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_364 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_364" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_364" (showCons x5))

d_C__case_363 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_363 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_362 x8 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_363 l cd cs)
    (d_C__case_363 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_363 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_363 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_363" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_363" (showCons x7))

d_C__case_362 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_362 x8 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_361 x8 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_362 x8 l cd cs)
    (d_C__case_362 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_362 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_362 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_362" [show x8, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_362" (showCons x9))

d_C__case_361 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_361 x8 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_360 x8 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_361 x8 l cd cs)
    (d_C__case_361 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_361 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_361 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_361" [show x8, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_361" (showCons x11))

d_C__case_360 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_360 x8 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_359 x8 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_360 x8 l cd cs)
    (d_C__case_360 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_360 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_360 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_360" [show x8, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_360" (showCons x13))

d_C__case_359 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_359 x8 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_358 x8 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_359 x8 l cd cs)
    (d_C__case_359 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_359 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_359 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_359" [show x8, show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_359" (showCons x15))

d_C__case_358 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_358 x8 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_357 x8 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_358 x8 l cd cs)
    (d_C__case_358 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_358 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_358 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_358" [show x8, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_358" (showCons x17))

d_C__case_357 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_357 x8 x19 cd cs = case x19 of
  Curry_Prelude.OP_Cons x20 x21 -> d_C__case_356 x8 x21 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_357 x8 l cd cs)
    (d_C__case_357 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_357 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_357 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_357" [show x8, show x19] info)
  _ -> failCons cd (consFail "TransTypes._case_357" (showCons x19))

d_C__case_356 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_356 x8 x21 cd cs = case x21 of
  Curry_Prelude.OP_Cons x22 x23 -> d_C__case_355 x8 x23 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_356 x8 l cd cs)
    (d_C__case_356 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_356 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_356 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_356" [show x8, show x21] info)
  _ -> failCons cd (consFail "TransTypes._case_356" (showCons x21))

d_C__case_355 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_355 x8 x23 cd cs = case x23 of
  Curry_Prelude.OP_Cons x24 x25 -> d_C__case_354 x8 x25 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_355 x8 l cd cs)
    (d_C__case_355 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_355 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_355 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_355" [show x8, show x23] info)
  _ -> failCons cd (consFail "TransTypes._case_355" (showCons x23))

d_C__case_354 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_354 x8 x25 cd cs = case x25 of
  Curry_Prelude.OP_List -> x8
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_354 x8 l cd cs)
    (d_C__case_354 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_354 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_354 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_354" [show x8, show x25] info)
  _ -> failCons cd (consFail "TransTypes._case_354" (showCons x25))

d_C__case_377 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_377 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_376 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_377 l cd cs)
    (d_C__case_377 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_377 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_377 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_377" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_377" (showCons x3))

d_C__case_376 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_376 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_375 x6 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_376 l cd cs)
    (d_C__case_376 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_376 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_376 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_376" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_376" (showCons x5))

d_C__case_375 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_375 x6 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_374 x6 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_375 x6 l cd cs)
    (d_C__case_375 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_375 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_375 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_375" [show x6, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_375" (showCons x7))

d_C__case_374 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_374 x6 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_373 x6 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_374 x6 l cd cs)
    (d_C__case_374 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_374 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_374 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_374" [show x6, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_374" (showCons x9))

d_C__case_373 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_373 x6 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_372 x6 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_373 x6 l cd cs)
    (d_C__case_373 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_373 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_373 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_373" [show x6, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_373" (showCons x11))

d_C__case_372 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_372 x6 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_371 x6 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_372 x6 l cd cs)
    (d_C__case_372 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_372 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_372 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_372" [show x6, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_372" (showCons x13))

d_C__case_371 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_371 x6 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_370 x6 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_371 x6 l cd cs)
    (d_C__case_371 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_371 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_371 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_371" [show x6, show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_371" (showCons x15))

d_C__case_370 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_370 x6 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_369 x6 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_370 x6 l cd cs)
    (d_C__case_370 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_370 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_370 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_370" [show x6, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_370" (showCons x17))

d_C__case_369 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_369 x6 x19 cd cs = case x19 of
  Curry_Prelude.OP_Cons x20 x21 -> d_C__case_368 x6 x21 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_369 x6 l cd cs)
    (d_C__case_369 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_369 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_369 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_369" [show x6, show x19] info)
  _ -> failCons cd (consFail "TransTypes._case_369" (showCons x19))

d_C__case_368 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_368 x6 x21 cd cs = case x21 of
  Curry_Prelude.OP_Cons x22 x23 -> d_C__case_367 x6 x23 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_368 x6 l cd cs)
    (d_C__case_368 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_368 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_368 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_368" [show x6, show x21] info)
  _ -> failCons cd (consFail "TransTypes._case_368" (showCons x21))

d_C__case_367 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_367 x6 x23 cd cs = case x23 of
  Curry_Prelude.OP_Cons x24 x25 -> d_C__case_366 x6 x25 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_367 x6 l cd cs)
    (d_C__case_367 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_367 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_367 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_367" [show x6, show x23] info)
  _ -> failCons cd (consFail "TransTypes._case_367" (showCons x23))

d_C__case_366 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_366 x6 x25 cd cs = case x25 of
  Curry_Prelude.OP_List -> x6
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_366 x6 l cd cs)
    (d_C__case_366 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_366 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_366 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_366" [show x6, show x25] info)
  _ -> failCons cd (consFail "TransTypes._case_366" (showCons x25))

d_C__case_389 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_389 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_388 x4 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_389 l cd cs)
    (d_C__case_389 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_389 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_389 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_389" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_389" (showCons x3))

d_C__case_388 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_388 x4 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_387 x4 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_388 x4 l cd cs)
    (d_C__case_388 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_388 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_388 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_388" [show x4, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_388" (showCons x5))

d_C__case_387 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_387 x4 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_386 x4 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_387 x4 l cd cs)
    (d_C__case_387 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_387 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_387 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_387" [show x4, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_387" (showCons x7))

d_C__case_386 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_386 x4 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_385 x4 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_386 x4 l cd cs)
    (d_C__case_386 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_386 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_386 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_386" [show x4, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_386" (showCons x9))

d_C__case_385 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_385 x4 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_384 x4 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_385 x4 l cd cs)
    (d_C__case_385 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_385 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_385 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_385" [show x4, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_385" (showCons x11))

d_C__case_384 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_384 x4 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_383 x4 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_384 x4 l cd cs)
    (d_C__case_384 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_384 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_384 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_384" [show x4, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_384" (showCons x13))

d_C__case_383 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_383 x4 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_382 x4 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_383 x4 l cd cs)
    (d_C__case_383 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_383 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_383 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_383" [show x4, show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_383" (showCons x15))

d_C__case_382 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_382 x4 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_381 x4 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_382 x4 l cd cs)
    (d_C__case_382 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_382 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_382 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_382" [show x4, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_382" (showCons x17))

d_C__case_381 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_381 x4 x19 cd cs = case x19 of
  Curry_Prelude.OP_Cons x20 x21 -> d_C__case_380 x4 x21 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_381 x4 l cd cs)
    (d_C__case_381 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_381 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_381 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_381" [show x4, show x19] info)
  _ -> failCons cd (consFail "TransTypes._case_381" (showCons x19))

d_C__case_380 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_380 x4 x21 cd cs = case x21 of
  Curry_Prelude.OP_Cons x22 x23 -> d_C__case_379 x4 x23 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_380 x4 l cd cs)
    (d_C__case_380 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_380 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_380 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_380" [show x4, show x21] info)
  _ -> failCons cd (consFail "TransTypes._case_380" (showCons x21))

d_C__case_379 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_379 x4 x23 cd cs = case x23 of
  Curry_Prelude.OP_Cons x24 x25 -> d_C__case_378 x4 x25 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_379 x4 l cd cs)
    (d_C__case_379 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_379 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_379 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_379" [show x4, show x23] info)
  _ -> failCons cd (consFail "TransTypes._case_379" (showCons x23))

d_C__case_378 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_378 x4 x25 cd cs = case x25 of
  Curry_Prelude.OP_List -> x4
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_378 x4 l cd cs)
    (d_C__case_378 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_378 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_378 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_378" [show x4, show x25] info)
  _ -> failCons cd (consFail "TransTypes._case_378" (showCons x25))

d_C__case_401 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_401 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_400 x2 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_401 x2 l cd cs)
    (d_C__case_401 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_401 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_401 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_401" [show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_401" (showCons x3))

d_C__case_400 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_400 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_399 x2 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_400 x2 l cd cs)
    (d_C__case_400 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_400 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_400 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_400" [show x2, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_400" (showCons x5))

d_C__case_399 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_399 x2 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_398 x2 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_399 x2 l cd cs)
    (d_C__case_399 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_399 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_399 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_399" [show x2, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_399" (showCons x7))

d_C__case_398 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_398 x2 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_397 x2 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_398 x2 l cd cs)
    (d_C__case_398 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_398 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_398 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_398" [show x2, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_398" (showCons x9))

d_C__case_397 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_397 x2 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_396 x2 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_397 x2 l cd cs)
    (d_C__case_397 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_397 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_397 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_397" [show x2, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_397" (showCons x11))

d_C__case_396 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_396 x2 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_395 x2 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_396 x2 l cd cs)
    (d_C__case_396 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_396 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_396 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_396" [show x2, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_396" (showCons x13))

d_C__case_395 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_395 x2 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_394 x2 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_395 x2 l cd cs)
    (d_C__case_395 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_395 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_395 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_395" [show x2, show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_395" (showCons x15))

d_C__case_394 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_394 x2 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_393 x2 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_394 x2 l cd cs)
    (d_C__case_394 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_394 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_394 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_394" [show x2, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_394" (showCons x17))

d_C__case_393 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_393 x2 x19 cd cs = case x19 of
  Curry_Prelude.OP_Cons x20 x21 -> d_C__case_392 x2 x21 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_393 x2 l cd cs)
    (d_C__case_393 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_393 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_393 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_393" [show x2, show x19] info)
  _ -> failCons cd (consFail "TransTypes._case_393" (showCons x19))

d_C__case_392 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_392 x2 x21 cd cs = case x21 of
  Curry_Prelude.OP_Cons x22 x23 -> d_C__case_391 x2 x23 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_392 x2 l cd cs)
    (d_C__case_392 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_392 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_392 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_392" [show x2, show x21] info)
  _ -> failCons cd (consFail "TransTypes._case_392" (showCons x21))

d_C__case_391 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_391 x2 x23 cd cs = case x23 of
  Curry_Prelude.OP_Cons x24 x25 -> d_C__case_390 x2 x25 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_391 x2 l cd cs)
    (d_C__case_391 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_391 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_391 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_391" [show x2, show x23] info)
  _ -> failCons cd (consFail "TransTypes._case_391" (showCons x23))

d_C__case_390 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_390 x2 x25 cd cs = case x25 of
  Curry_Prelude.OP_List -> x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_390 x2 l cd cs)
    (d_C__case_390 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_390 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_390 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_390" [show x2, show x25] info)
  _ -> failCons cd (consFail "TransTypes._case_390" (showCons x25))

d_C__case_403 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Pattern -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Curry_Prelude.C_Int -> Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
d_C__case_403 x4 x2 x10 x11 x9 x8 cd cs = case x8 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_map
    (d_OP_normalformConsRule_dot_rule_dot_237 x9 x11 x10 x2)
    (Curry_Prelude.OP_Cons x4 (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply
    (Curry_Names.d_C_mkHoConsName cd cs) x4 cd cs) Curry_Prelude.OP_List)) cd cs
  Curry_Prelude.C_False -> d_C__case_402 x4 x2 x10 x11 x9
    (Curry_Prelude.d_C_otherwise cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_403 x4 x2 x10 x11
    x9 l cd cs) (d_C__case_403 x4 x2 x10 x11 x9 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_403 x4
    x2 x10 x11 x9 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_403 x4 x2 x10 x11
    x9 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_403" [show x4, show x2, show x10, show x11, show x9, show
    x8] info)
  _ -> failCons cd (consFail "TransTypes._case_403" (showCons x8))

d_C__case_402 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Pattern -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Curry_Prelude.C_Int -> Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
d_C__case_402 x4 x2 x10 x11 x9 x12 cd cs = case x12 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons
    (d_OP_normalformConsRule_dot_rule_dot_237 x9 x11 x10 x2 x4 cd cs)
    Curry_Prelude.OP_List
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_402 x4 x2 x10 x11
    x9 l cd cs) (d_C__case_402 x4 x2 x10 x11 x9 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_402 x4
    x2 x10 x11 x9 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_402 x4 x2 x10 x11
    x9 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_402" [show x4, show x2, show x10, show x11, show x9, show
    x12] info)
  _ -> failCons cd (consFail "TransTypes._case_402" (showCons x12))

d_C__case_405 :: Curry_Prelude.C_Bool -> Curry_AbstractHaskell.C_TypeExpr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_ConsDecl -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeDecl
d_C__case_405 x1 x9 x4 x7 x2 x8 x10 cd cs = case x10 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_dollar (d_C_mkInstance (d_C_basics
    (Curry_Prelude.toCurryString "NormalForm") cd cs) Curry_Prelude.OP_List x9
    x8 cd cs) (Curry_Prelude.d_C_concat (Curry_Prelude.OP_Cons
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_concatMap
    (d_C_normalformConsRule x2 (d_C_basics (Curry_Prelude.toCurryString "$!!")
    cd cs)) cd cs) x7 cd cs) (Curry_Prelude.OP_Cons (d_C_normalFormExtConsRules
    x4 (d_C_basics (Curry_Prelude.toCurryString "$!!") cd cs) (d_C_basics
    (Curry_Prelude.toCurryString "nfChoice") cd cs) (d_C_basics
    (Curry_Prelude.toCurryString "nfChoices") cd cs) cd cs)
    (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_concatMap
    (d_C_normalformConsRule x2 (d_C_basics (Curry_Prelude.toCurryString "$##")
    cd cs)) cd cs) x7 cd cs) (Curry_Prelude.OP_Cons (d_C_normalFormExtConsRules
    x4 (d_C_basics (Curry_Prelude.toCurryString "$##") cd cs) (d_C_basics
    (Curry_Prelude.toCurryString "gnfChoice") cd cs) (d_C_basics
    (Curry_Prelude.toCurryString "gnfChoices") cd cs) cd cs)
    (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_concatMap
    (d_C_showConsConsRule x2) cd cs) x7 cd cs) (Curry_Prelude.OP_Cons
    (Curry_Prelude.OP_Cons (d_C_showConsCatchRule x4 cd cs)
    Curry_Prelude.OP_List) (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_concatMap (d_C_searchNFConsRule x2) cd cs) x7 cd cs)
    (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Cons (d_C_searchNFCatchRule x4 cd
    cs) Curry_Prelude.OP_List) Curry_Prelude.OP_List)))))))) cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_404 x9 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_405 x1 x9 x4 x7
    x2 x8 l cd cs) (d_C__case_405 x1 x9 x4 x7 x2 x8 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_405 x1
    x9 x4 x7 x2 x8 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_405 x1 x9 x4 x7
    x2 x8 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_405" [show x1, show x9, show x4, show x7, show x2, show x8
    , show x10] info)
  _ -> failCons cd (consFail "TransTypes._case_405" (showCons x10))

nd_C__case_405 :: Curry_Prelude.C_Bool -> Curry_AbstractHaskell.C_TypeExpr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  FlatCurry.Curry_Types.C_ConsDecl -> Curry_FiniteMap.C_FM
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_TypeDecl
nd_C__case_405 x1 x9 x4 x7 x2 x8 x10 s cd cs = case x10 of
  Curry_Prelude.C_True -> let s16 = s
    in s16 `seq` (let s15 = leftSupply s16
                      s14 = rightSupply s16
    in s15 `seq` (s14 `seq` Curry_Prelude.nd_OP_dollar (wrapDX id
    (d_C_mkInstance (d_C_basics (Curry_Prelude.toCurryString "NormalForm") cd
    cs) Curry_Prelude.OP_List x9 x8 cd cs)) (Curry_Prelude.d_C_concat
    (let s2 = leftSupply s14
         s13 = rightSupply s14
    in s2 `seq` (s13 `seq` Curry_Prelude.OP_Cons (let s1 = leftSupply s2
                                                      s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_concatMap
    (wrapNX id (nd_C_normalformConsRule x2 (d_C_basics
    (Curry_Prelude.toCurryString "$!!") cd cs))) s0 cd cs) x7 s1 cd cs))
    (Curry_Prelude.OP_Cons (d_C_normalFormExtConsRules x4 (d_C_basics
    (Curry_Prelude.toCurryString "$!!") cd cs) (d_C_basics
    (Curry_Prelude.toCurryString "nfChoice") cd cs) (d_C_basics
    (Curry_Prelude.toCurryString "nfChoices") cd cs) cd cs) (let s5 = leftSupply
                                                                   s13
                                                                 s12 = rightSupply
                                                                   s13
    in s5 `seq` (s12 `seq` Curry_Prelude.OP_Cons (let s4 = leftSupply s5
                                                      s3 = rightSupply s5
    in s4 `seq` (s3 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_concatMap
    (wrapNX id (nd_C_normalformConsRule x2 (d_C_basics
    (Curry_Prelude.toCurryString "$##") cd cs))) s3 cd cs) x7 s4 cd cs))
    (Curry_Prelude.OP_Cons (d_C_normalFormExtConsRules x4 (d_C_basics
    (Curry_Prelude.toCurryString "$##") cd cs) (d_C_basics
    (Curry_Prelude.toCurryString "gnfChoice") cd cs) (d_C_basics
    (Curry_Prelude.toCurryString "gnfChoices") cd cs) cd cs)
    (let s8 = leftSupply s12
         s11 = rightSupply s12
    in s8 `seq` (s11 `seq` Curry_Prelude.OP_Cons (let s7 = leftSupply s8
                                                      s6 = rightSupply s8
    in s7 `seq` (s6 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_concatMap
    (wrapNX id (nd_C_showConsConsRule x2)) s6 cd cs) x7 s7 cd cs))
    (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Cons (d_C_showConsCatchRule x4 cd
    cs) Curry_Prelude.OP_List) (Curry_Prelude.OP_Cons (let s10 = leftSupply s11
                                                           s9 = rightSupply s11
    in s10 `seq` (s9 `seq` Curry_Prelude.nd_C_apply
    (Curry_Prelude.nd_C_concatMap (wrapNX id (nd_C_searchNFConsRule x2)) s9 cd
    cs) x7 s10 cd cs)) (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Cons
    (d_C_searchNFCatchRule x4 cd cs) Curry_Prelude.OP_List)
    Curry_Prelude.OP_List))))))))))) cd cs) s15 cd cs))
  Curry_Prelude.C_False -> d_C__case_404 x9 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_405 x1 x9 x4 x7
    x2 x8 l s cd cs) (nd_C__case_405 x1 x9 x4 x7 x2 x8 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_405 x1
    x9 x4 x7 x2 x8 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_405 x1 x9 x4 x7
    x2 x8 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_405" [show x1, show x9, show x4, show x7, show x2, show x8
    , show x10] info)
  _ -> failCons cd (consFail "TransTypes._case_405" (showCons x10))

d_C__case_404 :: Curry_AbstractHaskell.C_TypeExpr -> Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeDecl
d_C__case_404 x9 x10 cd cs = case x10 of
  Curry_Prelude.C_True -> d_C_mkEmptyInstance (d_C_basics
    (Curry_Prelude.toCurryString "NormalForm") cd cs) x9 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "TransTypes.normalformInstance") cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_404 x9 l cd cs)
    (d_C__case_404 x9 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_404 x9
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_404 x9 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_404" [show x9, show x10] info)
  _ -> failCons cd (consFail "TransTypes._case_404" (showCons x10))

d_C__case_407 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_AbstractHaskell.C_Expr -> Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_407 x5 x3 x6 x2 x1 x7 cd cs = case x7 of
  Curry_Prelude.C_True -> Curry_AbstractHaskellGoodies.d_C_applyF
    (Curry_Prelude.d_C_apply (Curry_Names.d_C_mkHoConsName cd cs) x5 cd cs)
    (d_OP_generableInstance_dot_consArgs2gen_dot_208 x1 x2 x6 cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_406 x6 x2 x1 x5
    (Curry_Prelude.d_C_otherwise cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_407 x5 x3 x6 x2
    x1 l cd cs) (d_C__case_407 x5 x3 x6 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_407 x5
    x3 x6 x2 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_407 x5 x3 x6 x2
    x1 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_407" [show x5, show x3, show x6, show x2, show x1, show
    x7] info)
  _ -> failCons cd (consFail "TransTypes._case_407" (showCons x7))

nd_C__case_407 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_FiniteMap.C_FM (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_Classification.C_ConsHOClass -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_AbstractHaskell.C_Expr -> Curry_Prelude.C_Bool
  -> IDSupply -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
nd_C__case_407 x5 x3 x6 x2 x1 x7 s cd cs = case x7 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` Curry_AbstractHaskellGoodies.d_C_applyF
    (Curry_Prelude.nd_C_apply (wrapDX id (Curry_Names.d_C_mkHoConsName cd cs))
    x5 s0 cd cs) (d_OP_generableInstance_dot_consArgs2gen_dot_208 x1 x2 x6 cd
    cs) cd cs
  Curry_Prelude.C_False -> d_C__case_406 x6 x2 x1 x5
    (Curry_Prelude.d_C_otherwise cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_407 x5 x3 x6 x2
    x1 l s cd cs) (nd_C__case_407 x5 x3 x6 x2 x1 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_407 x5
    x3 x6 x2 x1 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (nd_C__case_407 x5 x3 x6 x2
    x1 e s cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_407" [show x5, show x3, show x6, show x2, show x1, show
    x7] info)
  _ -> failCons cd (consFail "TransTypes._case_407" (showCons x7))

d_C__case_406 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_406 x6 x2 x1 x5 x7 cd cs = case x7 of
  Curry_Prelude.C_True -> Curry_AbstractHaskellGoodies.d_C_applyF x5
    (d_OP_generableInstance_dot_consArgs2gen_dot_208 x1 x2 x6 cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_406 x6 x2 x1 x5 l
    cd cs) (d_C__case_406 x6 x2 x1 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_406 x6
    x2 x1 x5 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_406 x6 x2 x1 x5 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_406" [show x6, show x2, show x1, show x5, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_406" (showCons x7))

d_C__case_409 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_409 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_408 x4 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_409 l cd cs)
    (d_C__case_409 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_409 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_409 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_409" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_409" (showCons x3))

d_C__case_408 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_408 x4 x5 cd cs = case x5 of
  Curry_Prelude.OP_List -> x4
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_408 x4 l cd cs)
    (d_C__case_408 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_408 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_408 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_408" [show x4, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_408" (showCons x5))

d_C__case_411 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_411 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_410 x2 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_411 x2 l cd cs)
    (d_C__case_411 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_411 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_411 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_411" [show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_411" (showCons x3))

d_C__case_410 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_410 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_List -> x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_410 x2 l cd cs)
    (d_C__case_410 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_410 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_410 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_410" [show x2, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_410" (showCons x5))

d_C__case_413 :: Curry_Prelude.C_Bool -> Curry_AbstractHaskell.C_TypeExpr
  -> Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_TypeDecl
d_C__case_413 x1 x9 x15 x12 x11 x8 x16 cd cs = case x16 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (d_C_mkInstance (d_C_basics
    (Curry_Prelude.toCurryString "Generable") cd cs) Curry_Prelude.OP_List x9 x8
    cd cs) (Curry_Prelude.OP_Cons (Curry_Prelude.OP_Tuple2 (d_C_basics
    (Curry_Prelude.toCurryString "generate") cd cs) (d_C_simpleRule
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_PVar x11)
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_PVar x12)
    Curry_Prelude.OP_List)) x15 cd cs)) Curry_Prelude.OP_List) cd cs
  Curry_Prelude.C_False -> d_C__case_412 x9 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_413 x1 x9 x15 x12
    x11 x8 l cd cs) (d_C__case_413 x1 x9 x15 x12 x11 x8 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_413 x1
    x9 x15 x12 x11 x8 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_413 x1 x9 x15 x12
    x11 x8 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_413" [show x1, show x9, show x15, show x12, show x11, show
    x8, show x16] info)
  _ -> failCons cd (consFail "TransTypes._case_413" (showCons x16))

d_C__case_412 :: Curry_AbstractHaskell.C_TypeExpr -> Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeDecl
d_C__case_412 x9 x10 cd cs = case x10 of
  Curry_Prelude.C_True -> d_C_mkEmptyInstance (d_C_basics
    (Curry_Prelude.toCurryString "Generable") cd cs) x9 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "TransTypes.generableInstance") cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_412 x9 l cd cs)
    (d_C__case_412 x9 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_412 x9
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_412 x9 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_412" [show x9, show x10] info)
  _ -> failCons cd (consFail "TransTypes._case_412" (showCons x10))

d_C__case_421 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_421 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_420 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_421 l cd cs)
    (d_C__case_421 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_421 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_421 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_421" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_421" (showCons x3))

d_C__case_420 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_420 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_419 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_420 l cd cs)
    (d_C__case_420 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_420 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_420 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_420" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_420" (showCons x5))

d_C__case_419 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_419 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_418 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_419 l cd cs)
    (d_C__case_419 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_419 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_419 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_419" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_419" (showCons x7))

d_C__case_418 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_418 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_417 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_418 l cd cs)
    (d_C__case_418 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_418 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_418 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_418" [show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_418" (showCons x9))

d_C__case_417 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_417 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_416 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_417 l cd cs)
    (d_C__case_417 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_417 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_417 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_417" [show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_417" (showCons x11))

d_C__case_416 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_416 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_415 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_416 l cd cs)
    (d_C__case_416 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_416 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_416 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_416" [show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_416" (showCons x13))

d_C__case_415 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_415 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_414 x16 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_415 l cd cs)
    (d_C__case_415 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_415 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_415 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_415" [show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_415" (showCons x15))

d_C__case_414 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_414 x16 x17 cd cs = case x17 of
  Curry_Prelude.OP_List -> x16
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_414 x16 l cd cs)
    (d_C__case_414 x16 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_414
    x16 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_414 x16 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_414" [show x16, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_414" (showCons x17))

d_C__case_429 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_429 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_428 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_429 l cd cs)
    (d_C__case_429 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_429 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_429 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_429" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_429" (showCons x3))

d_C__case_428 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_428 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_427 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_428 l cd cs)
    (d_C__case_428 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_428 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_428 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_428" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_428" (showCons x5))

d_C__case_427 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_427 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_426 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_427 l cd cs)
    (d_C__case_427 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_427 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_427 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_427" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_427" (showCons x7))

d_C__case_426 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_426 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_425 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_426 l cd cs)
    (d_C__case_426 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_426 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_426 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_426" [show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_426" (showCons x9))

d_C__case_425 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_425 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_424 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_425 l cd cs)
    (d_C__case_425 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_425 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_425 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_425" [show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_425" (showCons x11))

d_C__case_424 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_424 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_423 x14 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_424 l cd cs)
    (d_C__case_424 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_424 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_424 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_424" [show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_424" (showCons x13))

d_C__case_423 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_423 x14 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_422 x14 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_423 x14 l cd cs)
    (d_C__case_423 x14 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_423
    x14 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_423 x14 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_423" [show x14, show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_423" (showCons x15))

d_C__case_422 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_422 x14 x17 cd cs = case x17 of
  Curry_Prelude.OP_List -> x14
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_422 x14 l cd cs)
    (d_C__case_422 x14 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_422
    x14 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_422 x14 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_422" [show x14, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_422" (showCons x17))

d_C__case_437 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_437 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_436 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_437 l cd cs)
    (d_C__case_437 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_437 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_437 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_437" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_437" (showCons x3))

d_C__case_436 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_436 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_435 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_436 l cd cs)
    (d_C__case_436 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_436 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_436 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_436" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_436" (showCons x5))

d_C__case_435 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_435 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_434 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_435 l cd cs)
    (d_C__case_435 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_435 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_435 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_435" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_435" (showCons x7))

d_C__case_434 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_434 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_433 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_434 l cd cs)
    (d_C__case_434 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_434 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_434 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_434" [show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_434" (showCons x9))

d_C__case_433 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_433 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_432 x12 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_433 l cd cs)
    (d_C__case_433 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_433 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_433 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_433" [show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_433" (showCons x11))

d_C__case_432 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_432 x12 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_431 x12 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_432 x12 l cd cs)
    (d_C__case_432 x12 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_432
    x12 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_432 x12 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_432" [show x12, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_432" (showCons x13))

d_C__case_431 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_431 x12 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_430 x12 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_431 x12 l cd cs)
    (d_C__case_431 x12 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_431
    x12 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_431 x12 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_431" [show x12, show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_431" (showCons x15))

d_C__case_430 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_430 x12 x17 cd cs = case x17 of
  Curry_Prelude.OP_List -> x12
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_430 x12 l cd cs)
    (d_C__case_430 x12 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_430
    x12 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_430 x12 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_430" [show x12, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_430" (showCons x17))

d_C__case_445 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_445 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_444 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_445 l cd cs)
    (d_C__case_445 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_445 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_445 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_445" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_445" (showCons x3))

d_C__case_444 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_444 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_443 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_444 l cd cs)
    (d_C__case_444 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_444 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_444 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_444" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_444" (showCons x5))

d_C__case_443 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_443 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_442 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_443 l cd cs)
    (d_C__case_443 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_443 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_443 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_443" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_443" (showCons x7))

d_C__case_442 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_442 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_441 x10 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_442 l cd cs)
    (d_C__case_442 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_442 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_442 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_442" [show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_442" (showCons x9))

d_C__case_441 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_441 x10 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_440 x10 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_441 x10 l cd cs)
    (d_C__case_441 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_441
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_441 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_441" [show x10, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_441" (showCons x11))

d_C__case_440 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_440 x10 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_439 x10 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_440 x10 l cd cs)
    (d_C__case_440 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_440
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_440 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_440" [show x10, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_440" (showCons x13))

d_C__case_439 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_439 x10 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_438 x10 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_439 x10 l cd cs)
    (d_C__case_439 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_439
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_439 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_439" [show x10, show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_439" (showCons x15))

d_C__case_438 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_438 x10 x17 cd cs = case x17 of
  Curry_Prelude.OP_List -> x10
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_438 x10 l cd cs)
    (d_C__case_438 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_438
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_438 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_438" [show x10, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_438" (showCons x17))

d_C__case_453 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_453 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_452 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_453 l cd cs)
    (d_C__case_453 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_453 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_453 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_453" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_453" (showCons x3))

d_C__case_452 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_452 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_451 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_452 l cd cs)
    (d_C__case_452 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_452 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_452 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_452" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_452" (showCons x5))

d_C__case_451 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_451 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_450 x8 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_451 l cd cs)
    (d_C__case_451 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_451 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_451 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_451" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_451" (showCons x7))

d_C__case_450 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_450 x8 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_449 x8 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_450 x8 l cd cs)
    (d_C__case_450 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_450 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_450 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_450" [show x8, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_450" (showCons x9))

d_C__case_449 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_449 x8 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_448 x8 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_449 x8 l cd cs)
    (d_C__case_449 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_449 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_449 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_449" [show x8, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_449" (showCons x11))

d_C__case_448 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_448 x8 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_447 x8 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_448 x8 l cd cs)
    (d_C__case_448 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_448 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_448 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_448" [show x8, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_448" (showCons x13))

d_C__case_447 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_447 x8 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_446 x8 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_447 x8 l cd cs)
    (d_C__case_447 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_447 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_447 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_447" [show x8, show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_447" (showCons x15))

d_C__case_446 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_446 x8 x17 cd cs = case x17 of
  Curry_Prelude.OP_List -> x8
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_446 x8 l cd cs)
    (d_C__case_446 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_446 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_446 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_446" [show x8, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_446" (showCons x17))

d_C__case_461 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_461 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_460 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_461 l cd cs)
    (d_C__case_461 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_461 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_461 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_461" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_461" (showCons x3))

d_C__case_460 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_460 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_459 x6 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_460 l cd cs)
    (d_C__case_460 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_460 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_460 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_460" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_460" (showCons x5))

d_C__case_459 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_459 x6 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_458 x6 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_459 x6 l cd cs)
    (d_C__case_459 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_459 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_459 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_459" [show x6, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_459" (showCons x7))

d_C__case_458 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_458 x6 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_457 x6 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_458 x6 l cd cs)
    (d_C__case_458 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_458 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_458 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_458" [show x6, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_458" (showCons x9))

d_C__case_457 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_457 x6 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_456 x6 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_457 x6 l cd cs)
    (d_C__case_457 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_457 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_457 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_457" [show x6, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_457" (showCons x11))

d_C__case_456 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_456 x6 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_455 x6 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_456 x6 l cd cs)
    (d_C__case_456 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_456 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_456 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_456" [show x6, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_456" (showCons x13))

d_C__case_455 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_455 x6 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_454 x6 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_455 x6 l cd cs)
    (d_C__case_455 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_455 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_455 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_455" [show x6, show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_455" (showCons x15))

d_C__case_454 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_454 x6 x17 cd cs = case x17 of
  Curry_Prelude.OP_List -> x6
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_454 x6 l cd cs)
    (d_C__case_454 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_454 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_454 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_454" [show x6, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_454" (showCons x17))

d_C__case_469 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_469 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_468 x4 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_469 l cd cs)
    (d_C__case_469 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_469 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_469 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_469" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_469" (showCons x3))

d_C__case_468 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_468 x4 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_467 x4 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_468 x4 l cd cs)
    (d_C__case_468 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_468 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_468 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_468" [show x4, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_468" (showCons x5))

d_C__case_467 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_467 x4 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_466 x4 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_467 x4 l cd cs)
    (d_C__case_467 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_467 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_467 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_467" [show x4, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_467" (showCons x7))

d_C__case_466 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_466 x4 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_465 x4 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_466 x4 l cd cs)
    (d_C__case_466 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_466 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_466 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_466" [show x4, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_466" (showCons x9))

d_C__case_465 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_465 x4 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_464 x4 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_465 x4 l cd cs)
    (d_C__case_465 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_465 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_465 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_465" [show x4, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_465" (showCons x11))

d_C__case_464 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_464 x4 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_463 x4 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_464 x4 l cd cs)
    (d_C__case_464 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_464 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_464 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_464" [show x4, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_464" (showCons x13))

d_C__case_463 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_463 x4 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_462 x4 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_463 x4 l cd cs)
    (d_C__case_463 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_463 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_463 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_463" [show x4, show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_463" (showCons x15))

d_C__case_462 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_462 x4 x17 cd cs = case x17 of
  Curry_Prelude.OP_List -> x4
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_462 x4 l cd cs)
    (d_C__case_462 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_462 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_462 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_462" [show x4, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_462" (showCons x17))

d_C__case_477 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_477 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_476 x2 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_477 x2 l cd cs)
    (d_C__case_477 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_477 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_477 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_477" [show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_477" (showCons x3))

d_C__case_476 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_476 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_475 x2 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_476 x2 l cd cs)
    (d_C__case_476 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_476 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_476 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_476" [show x2, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_476" (showCons x5))

d_C__case_475 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_475 x2 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_474 x2 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_475 x2 l cd cs)
    (d_C__case_475 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_475 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_475 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_475" [show x2, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_475" (showCons x7))

d_C__case_474 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_474 x2 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_473 x2 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_474 x2 l cd cs)
    (d_C__case_474 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_474 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_474 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_474" [show x2, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_474" (showCons x9))

d_C__case_473 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_473 x2 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_472 x2 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_473 x2 l cd cs)
    (d_C__case_473 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_473 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_473 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_473" [show x2, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_473" (showCons x11))

d_C__case_472 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_472 x2 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_471 x2 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_472 x2 l cd cs)
    (d_C__case_472 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_472 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_472 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_472" [show x2, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_472" (showCons x13))

d_C__case_471 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_471 x2 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_470 x2 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_471 x2 l cd cs)
    (d_C__case_471 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_471 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_471 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_471" [show x2, show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_471" (showCons x15))

d_C__case_470 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_470 x2 x17 cd cs = case x17 of
  Curry_Prelude.OP_List -> x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_470 x2 l cd cs)
    (d_C__case_470 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_470 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_470 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_470" [show x2, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_470" (showCons x17))

d_C__case_485 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_485 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_484 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_485 l cd cs)
    (d_C__case_485 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_485 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_485 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_485" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_485" (showCons x3))

d_C__case_484 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_484 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_483 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_484 l cd cs)
    (d_C__case_484 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_484 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_484 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_484" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_484" (showCons x5))

d_C__case_483 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_483 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_482 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_483 l cd cs)
    (d_C__case_483 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_483 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_483 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_483" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_483" (showCons x7))

d_C__case_482 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_482 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_481 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_482 l cd cs)
    (d_C__case_482 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_482 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_482 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_482" [show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_482" (showCons x9))

d_C__case_481 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_481 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_480 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_481 l cd cs)
    (d_C__case_481 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_481 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_481 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_481" [show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_481" (showCons x11))

d_C__case_480 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_480 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_479 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_480 l cd cs)
    (d_C__case_480 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_480 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_480 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_480" [show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_480" (showCons x13))

d_C__case_479 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_479 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_478 x16 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_479 l cd cs)
    (d_C__case_479 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_479 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_479 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_479" [show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_479" (showCons x15))

d_C__case_478 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_478 x16 x17 cd cs = case x17 of
  Curry_Prelude.OP_List -> x16
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_478 x16 l cd cs)
    (d_C__case_478 x16 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_478
    x16 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_478 x16 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_478" [show x16, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_478" (showCons x17))

d_C__case_493 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_493 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_492 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_493 l cd cs)
    (d_C__case_493 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_493 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_493 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_493" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_493" (showCons x3))

d_C__case_492 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_492 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_491 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_492 l cd cs)
    (d_C__case_492 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_492 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_492 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_492" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_492" (showCons x5))

d_C__case_491 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_491 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_490 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_491 l cd cs)
    (d_C__case_491 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_491 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_491 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_491" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_491" (showCons x7))

d_C__case_490 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_490 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_489 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_490 l cd cs)
    (d_C__case_490 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_490 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_490 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_490" [show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_490" (showCons x9))

d_C__case_489 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_489 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_488 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_489 l cd cs)
    (d_C__case_489 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_489 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_489 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_489" [show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_489" (showCons x11))

d_C__case_488 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_488 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_487 x14 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_488 l cd cs)
    (d_C__case_488 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_488 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_488 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_488" [show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_488" (showCons x13))

d_C__case_487 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_487 x14 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_486 x14 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_487 x14 l cd cs)
    (d_C__case_487 x14 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_487
    x14 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_487 x14 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_487" [show x14, show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_487" (showCons x15))

d_C__case_486 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_486 x14 x17 cd cs = case x17 of
  Curry_Prelude.OP_List -> x14
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_486 x14 l cd cs)
    (d_C__case_486 x14 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_486
    x14 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_486 x14 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_486" [show x14, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_486" (showCons x17))

d_C__case_501 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_501 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_500 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_501 l cd cs)
    (d_C__case_501 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_501 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_501 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_501" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_501" (showCons x3))

d_C__case_500 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_500 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_499 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_500 l cd cs)
    (d_C__case_500 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_500 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_500 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_500" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_500" (showCons x5))

d_C__case_499 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_499 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_498 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_499 l cd cs)
    (d_C__case_499 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_499 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_499 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_499" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_499" (showCons x7))

d_C__case_498 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_498 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_497 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_498 l cd cs)
    (d_C__case_498 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_498 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_498 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_498" [show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_498" (showCons x9))

d_C__case_497 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_497 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_496 x12 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_497 l cd cs)
    (d_C__case_497 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_497 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_497 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_497" [show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_497" (showCons x11))

d_C__case_496 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_496 x12 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_495 x12 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_496 x12 l cd cs)
    (d_C__case_496 x12 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_496
    x12 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_496 x12 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_496" [show x12, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_496" (showCons x13))

d_C__case_495 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_495 x12 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_494 x12 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_495 x12 l cd cs)
    (d_C__case_495 x12 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_495
    x12 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_495 x12 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_495" [show x12, show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_495" (showCons x15))

d_C__case_494 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_494 x12 x17 cd cs = case x17 of
  Curry_Prelude.OP_List -> x12
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_494 x12 l cd cs)
    (d_C__case_494 x12 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_494
    x12 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_494 x12 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_494" [show x12, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_494" (showCons x17))

d_C__case_509 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_509 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_508 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_509 l cd cs)
    (d_C__case_509 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_509 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_509 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_509" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_509" (showCons x3))

d_C__case_508 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_508 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_507 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_508 l cd cs)
    (d_C__case_508 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_508 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_508 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_508" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_508" (showCons x5))

d_C__case_507 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_507 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_506 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_507 l cd cs)
    (d_C__case_507 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_507 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_507 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_507" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_507" (showCons x7))

d_C__case_506 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_506 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_505 x10 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_506 l cd cs)
    (d_C__case_506 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_506 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_506 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_506" [show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_506" (showCons x9))

d_C__case_505 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_505 x10 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_504 x10 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_505 x10 l cd cs)
    (d_C__case_505 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_505
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_505 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_505" [show x10, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_505" (showCons x11))

d_C__case_504 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_504 x10 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_503 x10 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_504 x10 l cd cs)
    (d_C__case_504 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_504
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_504 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_504" [show x10, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_504" (showCons x13))

d_C__case_503 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_503 x10 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_502 x10 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_503 x10 l cd cs)
    (d_C__case_503 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_503
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_503 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_503" [show x10, show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_503" (showCons x15))

d_C__case_502 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_502 x10 x17 cd cs = case x17 of
  Curry_Prelude.OP_List -> x10
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_502 x10 l cd cs)
    (d_C__case_502 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_502
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_502 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_502" [show x10, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_502" (showCons x17))

d_C__case_517 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_517 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_516 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_517 l cd cs)
    (d_C__case_517 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_517 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_517 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_517" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_517" (showCons x3))

d_C__case_516 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_516 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_515 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_516 l cd cs)
    (d_C__case_516 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_516 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_516 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_516" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_516" (showCons x5))

d_C__case_515 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_515 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_514 x8 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_515 l cd cs)
    (d_C__case_515 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_515 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_515 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_515" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_515" (showCons x7))

d_C__case_514 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_514 x8 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_513 x8 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_514 x8 l cd cs)
    (d_C__case_514 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_514 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_514 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_514" [show x8, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_514" (showCons x9))

d_C__case_513 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_513 x8 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_512 x8 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_513 x8 l cd cs)
    (d_C__case_513 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_513 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_513 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_513" [show x8, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_513" (showCons x11))

d_C__case_512 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_512 x8 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_511 x8 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_512 x8 l cd cs)
    (d_C__case_512 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_512 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_512 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_512" [show x8, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_512" (showCons x13))

d_C__case_511 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_511 x8 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_510 x8 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_511 x8 l cd cs)
    (d_C__case_511 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_511 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_511 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_511" [show x8, show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_511" (showCons x15))

d_C__case_510 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_510 x8 x17 cd cs = case x17 of
  Curry_Prelude.OP_List -> x8
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_510 x8 l cd cs)
    (d_C__case_510 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_510 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_510 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_510" [show x8, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_510" (showCons x17))

d_C__case_525 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_525 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_524 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_525 l cd cs)
    (d_C__case_525 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_525 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_525 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_525" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_525" (showCons x3))

d_C__case_524 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_524 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_523 x6 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_524 l cd cs)
    (d_C__case_524 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_524 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_524 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_524" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_524" (showCons x5))

d_C__case_523 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_523 x6 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_522 x6 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_523 x6 l cd cs)
    (d_C__case_523 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_523 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_523 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_523" [show x6, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_523" (showCons x7))

d_C__case_522 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_522 x6 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_521 x6 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_522 x6 l cd cs)
    (d_C__case_522 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_522 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_522 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_522" [show x6, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_522" (showCons x9))

d_C__case_521 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_521 x6 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_520 x6 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_521 x6 l cd cs)
    (d_C__case_521 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_521 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_521 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_521" [show x6, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_521" (showCons x11))

d_C__case_520 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_520 x6 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_519 x6 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_520 x6 l cd cs)
    (d_C__case_520 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_520 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_520 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_520" [show x6, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_520" (showCons x13))

d_C__case_519 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_519 x6 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_518 x6 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_519 x6 l cd cs)
    (d_C__case_519 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_519 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_519 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_519" [show x6, show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_519" (showCons x15))

d_C__case_518 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_518 x6 x17 cd cs = case x17 of
  Curry_Prelude.OP_List -> x6
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_518 x6 l cd cs)
    (d_C__case_518 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_518 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_518 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_518" [show x6, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_518" (showCons x17))

d_C__case_533 :: Curry_Prelude.OP_List Curry_AbstractHaskell.C_Expr -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_533 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_532 x4 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_533 l cd cs)
    (d_C__case_533 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_533 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_533 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_533" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_533" (showCons x3))

d_C__case_532 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_532 x4 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_531 x4 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_532 x4 l cd cs)
    (d_C__case_532 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_532 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_532 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_532" [show x4, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_532" (showCons x5))

d_C__case_531 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_531 x4 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_530 x4 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_531 x4 l cd cs)
    (d_C__case_531 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_531 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_531 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_531" [show x4, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_531" (showCons x7))

d_C__case_530 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_530 x4 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_529 x4 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_530 x4 l cd cs)
    (d_C__case_530 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_530 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_530 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_530" [show x4, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_530" (showCons x9))

d_C__case_529 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_529 x4 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_528 x4 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_529 x4 l cd cs)
    (d_C__case_529 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_529 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_529 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_529" [show x4, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_529" (showCons x11))

d_C__case_528 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_528 x4 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_527 x4 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_528 x4 l cd cs)
    (d_C__case_528 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_528 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_528 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_528" [show x4, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_528" (showCons x13))

d_C__case_527 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_527 x4 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_526 x4 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_527 x4 l cd cs)
    (d_C__case_527 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_527 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_527 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_527" [show x4, show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_527" (showCons x15))

d_C__case_526 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_526 x4 x17 cd cs = case x17 of
  Curry_Prelude.OP_List -> x4
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_526 x4 l cd cs)
    (d_C__case_526 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_526 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_526 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_526" [show x4, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_526" (showCons x17))

d_C__case_541 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_541 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_540 x2 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_541 x2 l cd cs)
    (d_C__case_541 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_541 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_541 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_541" [show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_541" (showCons x3))

d_C__case_540 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_540 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_539 x2 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_540 x2 l cd cs)
    (d_C__case_540 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_540 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_540 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_540" [show x2, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_540" (showCons x5))

d_C__case_539 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_539 x2 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_538 x2 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_539 x2 l cd cs)
    (d_C__case_539 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_539 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_539 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_539" [show x2, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_539" (showCons x7))

d_C__case_538 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_538 x2 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_537 x2 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_538 x2 l cd cs)
    (d_C__case_538 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_538 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_538 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_538" [show x2, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_538" (showCons x9))

d_C__case_537 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_537 x2 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_536 x2 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_537 x2 l cd cs)
    (d_C__case_537 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_537 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_537 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_537" [show x2, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_537" (showCons x11))

d_C__case_536 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_536 x2 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_535 x2 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_536 x2 l cd cs)
    (d_C__case_536 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_536 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_536 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_536" [show x2, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_536" (showCons x13))

d_C__case_535 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_535 x2 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_534 x2 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_535 x2 l cd cs)
    (d_C__case_535 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_535 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_535 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_535" [show x2, show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_535" (showCons x15))

d_C__case_534 :: Curry_AbstractHaskell.C_Expr -> Curry_Prelude.OP_List
  Curry_AbstractHaskell.C_Expr -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_534 x2 x17 cd cs = case x17 of
  Curry_Prelude.OP_List -> x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_534 x2 l cd cs)
    (d_C__case_534 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_534 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_534 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_534" [show x2, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_534" (showCons x17))

d_C__case_543 :: Curry_Prelude.C_Bool -> Curry_AbstractHaskell.C_TypeExpr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_TypeDecl
d_C__case_543 x1 x8 x3 x9 cd cs = case x9 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_dollar (d_C_mkInstance (d_C_basics
    (Curry_Prelude.toCurryString "NonDet") cd cs) Curry_Prelude.OP_List x8
    Curry_Prelude.OP_List cd cs) (Curry_Prelude.d_OP_plus_plus
    (d_C_specialConsRules x3 cd cs) (Curry_Prelude.d_OP_plus_plus (d_C_tryRules
    x3 cd cs) (d_C_matchRules x3 cd cs) cd cs) cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_542 x8 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_543 x1 x8 x3 l cd
    cs) (d_C__case_543 x1 x8 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_543 x1
    x8 x3 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_543 x1 x8 x3 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_543" [show x1, show x8, show x3, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_543" (showCons x9))

d_C__case_542 :: Curry_AbstractHaskell.C_TypeExpr -> Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeDecl
d_C__case_542 x8 x9 cd cs = case x9 of
  Curry_Prelude.C_True -> d_C_mkEmptyInstance (d_C_basics
    (Curry_Prelude.toCurryString "NonDet") cd cs) x8 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "TransTypes.nondetInstance") cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_542 x8 l cd cs)
    (d_C__case_542 x8 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_542 x8
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_542 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_542" [show x8, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_542" (showCons x9))

d_C__case_545 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_545 x3 x2 cd cs = case x2 of
  Curry_Prelude.OP_Tuple2 x6 x7 -> Curry_AbstractHaskellGoodies.d_C_applyF
    (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString
    "readParen") cd cs) (Curry_Prelude.OP_Cons (d_C__case_544 x3
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int
    x3 (Curry_Prelude.C_Int (0)) cd cs) cd cs) (Curry_Prelude.OP_Cons
    (Curry_AbstractHaskell.C_Lambda (Curry_Prelude.OP_Cons
    (Curry_AbstractHaskell.C_PVar (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int
    (2)) (Curry_Prelude.toCurryString "r"))) Curry_Prelude.OP_List)
    (Curry_AbstractHaskell.C_ListComp
    (Curry_AbstractHaskellGoodies.d_C_tupleExpr (Curry_Prelude.OP_Cons
    (Curry_AbstractHaskellGoodies.d_C_applyF x2 (Curry_Prelude.d_C_map
    (d_C_mkVar (Curry_Prelude.toCurryString "x")) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_enumFromTo_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
    cd cs) (Curry_Prelude.C_Int (1)) cd cs) x3 cd cs) cd cs) cd cs)
    (Curry_Prelude.OP_Cons (d_C_mkVar (Curry_Prelude.toCurryString "r") x3 cd
    cs) Curry_Prelude.OP_List)) cd cs) (Curry_Prelude.OP_Cons
    (Curry_AbstractHaskell.C_SPat (Curry_AbstractHaskellGoodies.d_C_tuplePat
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_PVar
    (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int (0))
    (Curry_Prelude.toCurryString "_"))) (Curry_Prelude.OP_Cons
    (Curry_AbstractHaskell.C_PVar (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int
    (1)) (Curry_Prelude.toCurryString "r0"))) Curry_Prelude.OP_List)) cd cs)
    (Curry_AbstractHaskellGoodies.d_C_applyF (d_C_basics
    (Curry_Prelude.toCurryString "readQualified") cd cs) (Curry_Prelude.OP_Cons
    (Curry_Prelude.d_C_apply (Curry_AbstractHaskellGoodies.d_C_string2ac cd cs)
    (Curry_Prelude.d_C_apply (Curry_Names.d_C_unRenameModule cd cs) x6 cd cs) cd
    cs) (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply
    (Curry_AbstractHaskellGoodies.d_C_string2ac cd cs)
    (Curry_Names.d_C_unGenRename (Curry_Prelude.d_C_snd x2 cd cs) cd cs) cd cs)
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var (Curry_Prelude.OP_Tuple2
    (Curry_Prelude.C_Int (2)) (Curry_Prelude.toCurryString "r")))
    Curry_Prelude.OP_List))) cd cs)) (Curry_Prelude.d_C_map
    d_OP_readParen_dot_genReadsPrec_dot_172 (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_enumFromTo_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
    cd cs) (Curry_Prelude.C_Int (1)) cd cs) x3 cd cs) cd cs))))
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var (Curry_Prelude.OP_Tuple2
    (Curry_Prelude.C_Int (1)) (Curry_Prelude.toCurryString "s")))
    Curry_Prelude.OP_List))) cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C__case_545 x3 l cd
    cs) (d_C__case_545 x3 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C__case_545
    x3 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C__case_545 x3 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransTypes._case_545" [show x3, show x2] info)
  _ -> failCons cd (consFail "TransTypes._case_545" (showCons x2))

d_C__case_544 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_AbstractHaskell.C_Expr
d_C__case_544 x3 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> Curry_AbstractHaskellGoodies.d_C_constF
    (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString "False")
    cd cs) cd cs
  Curry_Prelude.C_False -> Curry_AbstractHaskellGoodies.d_C_applyF
    (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString ">") cd
    cs) (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var
    (Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int (0))
    (Curry_Prelude.toCurryString "d"))) (Curry_Prelude.OP_Cons (d_C_intc
    (Curry_Prelude.C_Int (10)) cd cs) Curry_Prelude.OP_List)) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_544 x3 l cd cs)
    (d_C__case_544 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_544 x3
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_544 x3 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_544" [show x3, show x4] info)
  _ -> failCons cd (consFail "TransTypes._case_544" (showCons x4))

d_C__case_546 :: Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C__case_546 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int (0))
    (Curry_Prelude.toCurryString "d")
  Curry_Prelude.C_False -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.C_Int (0))
    (Curry_Prelude.toCurryString "_")
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_546 l cd cs)
    (d_C__case_546 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_546 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_546 e cd $! addCs
    c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_546" [show x2] info)
  _ -> failCons cd (consFail "TransTypes._case_546" (showCons x2))

d_C__case_549 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_549 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_548 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_549 l cd cs)
    (d_C__case_549 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_549 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_549 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_549" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_549" (showCons x3))

d_C__case_548 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_548 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_547 x6 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_548 l cd cs)
    (d_C__case_548 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_548 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_548 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_548" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_548" (showCons x5))

d_C__case_547 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_547 x6 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> x6
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_547 x6 l cd cs)
    (d_C__case_547 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_547 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_547 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_547" [show x6, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_547" (showCons x7))

d_C__case_552 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_552 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_551 x4 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_552 l cd cs)
    (d_C__case_552 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_552 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_552 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_552" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_552" (showCons x3))

d_C__case_551 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_551 x4 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_550 x4 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_551 x4 l cd cs)
    (d_C__case_551 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_551 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_551 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_551" [show x4, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_551" (showCons x5))

d_C__case_550 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_550 x4 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> x4
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_550 x4 l cd cs)
    (d_C__case_550 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_550 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_550 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_550" [show x4, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_550" (showCons x7))

d_C__case_555 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_555 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_554 x2 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_555 x2 l cd cs)
    (d_C__case_555 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_555 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_555 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_555" [show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_555" (showCons x3))

d_C__case_554 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_554 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_553 x2 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_554 x2 l cd cs)
    (d_C__case_554 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_554 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_554 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_554" [show x2, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_554" (showCons x5))

d_C__case_553 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_553 x2 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_553 x2 l cd cs)
    (d_C__case_553 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_553 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_553 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_553" [show x2, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_553" (showCons x7))

d_C__case_556 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule
d_C__case_556 x3 x2 cd cs = case x2 of
  Curry_Prelude.OP_Tuple2 x6 x7 -> let x8 = Curry_Prelude.d_C_apply (d_C_newVars
                                         cd cs) (Curry_Prelude.OP_Cons
                                         (Curry_Prelude.toCurryString "d")
                                         (Curry_Prelude.OP_Cons
                                         (Curry_Prelude.toCurryString "s")
                                         (Curry_Prelude.OP_Cons
                                         (Curry_Prelude.toCurryString "s2")
                                         Curry_Prelude.OP_List))) cd cs
                                       x9 = d_OP_readTupleRule_dot_uscore_hash_selFP21_hash_d
                                         x8 cd cs
                                       x10 = d_OP_readTupleRule_dot_uscore_hash_selFP22_hash_s
                                         x8 cd cs
                                       x11 = d_OP_readTupleRule_dot_uscore_hash_selFP23_hash_s2
                                         x8 cd cs
                                       x12 = Curry_Prelude.d_C_map d_C_mkTVar
                                         (Curry_Prelude.d_C_apply
                                         (Curry_Prelude.d_C_apply
                                         (Curry_Prelude.d_OP_uscore_impl_hash_enumFromTo_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
                                         cd cs) (Curry_Prelude.C_Int (0)) cd cs)
                                         (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
                                         x3 (Curry_Prelude.C_Int (1)) cd cs) cd
                                         cs) cd cs
    in Curry_Prelude.OP_Tuple2 (Curry_AbstractHaskellGoodies.d_C_pre
    (Curry_Prelude.toCurryString "readsPrec") cd cs)
    (Curry_AbstractHaskell.C_Rule (Curry_Prelude.OP_Cons
    (Curry_AbstractHaskell.C_PVar x9) (Curry_Prelude.OP_Cons
    (Curry_AbstractHaskell.C_PVar x10) Curry_Prelude.OP_List))
    (Curry_Prelude.d_OP_dollar (acceptCs id Curry_AbstractHaskell.C_SimpleRhs)
    (Curry_AbstractHaskellGoodies.d_C_applyF
    (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString "map") cd
    cs) (Curry_Prelude.OP_Cons (Curry_AbstractHaskellGoodies.d_C_constF
    (Curry_Prelude.OP_Tuple2 x6 (Curry_Prelude.toCurryString "readTuple")) cd
    cs) (Curry_Prelude.OP_Cons (Curry_AbstractHaskellGoodies.d_C_applyF
    (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString
    "readsPrec") cd cs) (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x9)
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x10)
    Curry_Prelude.OP_List)) cd cs) Curry_Prelude.OP_List)) cd cs) cd cs)
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_LocalFunc
    (Curry_AbstractHaskellGoodies.d_C_tfunc (Curry_Prelude.OP_Tuple2 x6
    (Curry_Prelude.toCurryString "readTuple")) (Curry_Prelude.C_Int (1))
    Curry_AbstractHaskell.C_Private (Curry_AbstractHaskellGoodies.d_OP_tilde_gt
    (Curry_AbstractHaskellGoodies.d_C_tupleType (Curry_Prelude.OP_Cons
    (Curry_AbstractHaskellGoodies.d_C_tupleType x12 cd cs)
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskellGoodies.d_C_stringType cd cs)
    Curry_Prelude.OP_List)) cd cs) (Curry_AbstractHaskellGoodies.d_C_tupleType
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_TCons
    (Curry_Prelude.OP_Tuple2 x6 (Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.toCurryString "OP_Tuple") (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Int
    cd cs) x3 cd cs) cd cs)) x12) (Curry_Prelude.OP_Cons
    (Curry_AbstractHaskellGoodies.d_C_stringType cd cs) Curry_Prelude.OP_List))
    cd cs) cd cs) (Curry_Prelude.OP_Cons (d_C_simpleRule (Curry_Prelude.OP_Cons
    (Curry_AbstractHaskellGoodies.d_C_tuplePat (Curry_Prelude.OP_Cons
    (Curry_Prelude.d_OP_dollar Curry_AbstractHaskellGoodies.d_C_tuplePat
    (Curry_Prelude.d_C_map (d_C_mkPVar (Curry_Prelude.toCurryString "x"))
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_enumFromTo_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
    cd cs) (Curry_Prelude.C_Int (1)) cd cs) x3 cd cs) cd cs) cd cs)
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_PVar x11)
    Curry_Prelude.OP_List)) cd cs) Curry_Prelude.OP_List)
    (Curry_AbstractHaskellGoodies.d_C_tupleExpr (Curry_Prelude.OP_Cons
    (Curry_AbstractHaskellGoodies.d_C_applyF x2 (Curry_Prelude.d_C_map
    (d_C_mkVar (Curry_Prelude.toCurryString "x")) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_enumFromTo_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
    cd cs) (Curry_Prelude.C_Int (1)) cd cs) x3 cd cs) cd cs) cd cs)
    (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Var x11)
    Curry_Prelude.OP_List)) cd cs) cd cs) Curry_Prelude.OP_List) cd cs))
    Curry_Prelude.OP_List))
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C__case_556 x3 l cd
    cs) (d_C__case_556 x3 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C__case_556
    x3 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C__case_556 x3 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "TransTypes._case_556" [show x3, show x2] info)
  _ -> failCons cd (consFail "TransTypes._case_556" (showCons x2))

d_C__case_560 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_560 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_559 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_560 l cd cs)
    (d_C__case_560 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_560 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_560 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_560" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_560" (showCons x3))

d_C__case_559 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_559 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_558 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_559 l cd cs)
    (d_C__case_559 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_559 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_559 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_559" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_559" (showCons x5))

d_C__case_558 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_558 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_557 x8 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_558 l cd cs)
    (d_C__case_558 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_558 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_558 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_558" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_558" (showCons x7))

d_C__case_557 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_557 x8 x9 cd cs = case x9 of
  Curry_Prelude.OP_List -> x8
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_557 x8 l cd cs)
    (d_C__case_557 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_557 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_557 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_557" [show x8, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_557" (showCons x9))

d_C__case_564 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_564 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_563 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_564 l cd cs)
    (d_C__case_564 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_564 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_564 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_564" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_564" (showCons x3))

d_C__case_563 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_563 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_562 x6 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_563 l cd cs)
    (d_C__case_563 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_563 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_563 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_563" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_563" (showCons x5))

d_C__case_562 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_562 x6 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_561 x6 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_562 x6 l cd cs)
    (d_C__case_562 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_562 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_562 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_562" [show x6, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_562" (showCons x7))

d_C__case_561 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_561 x6 x9 cd cs = case x9 of
  Curry_Prelude.OP_List -> x6
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_561 x6 l cd cs)
    (d_C__case_561 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_561 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_561 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_561" [show x6, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_561" (showCons x9))

d_C__case_568 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_568 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_567 x4 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_568 l cd cs)
    (d_C__case_568 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_568 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_568 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_568" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_568" (showCons x3))

d_C__case_567 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_567 x4 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_566 x4 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_567 x4 l cd cs)
    (d_C__case_567 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_567 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_567 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_567" [show x4, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_567" (showCons x5))

d_C__case_566 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_566 x4 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_565 x4 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_566 x4 l cd cs)
    (d_C__case_566 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_566 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_566 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_566" [show x4, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_566" (showCons x7))

d_C__case_565 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_565 x4 x9 cd cs = case x9 of
  Curry_Prelude.OP_List -> x4
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_565 x4 l cd cs)
    (d_C__case_565 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_565 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_565 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_565" [show x4, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_565" (showCons x9))

d_C__case_572 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_572 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_571 x2 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_572 x2 l cd cs)
    (d_C__case_572 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_572 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_572 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_572" [show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_572" (showCons x3))

d_C__case_571 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_571 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_570 x2 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_571 x2 l cd cs)
    (d_C__case_571 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_571 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_571 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_571" [show x2, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_571" (showCons x5))

d_C__case_570 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_570 x2 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_569 x2 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_570 x2 l cd cs)
    (d_C__case_570 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_570 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_570 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_570" [show x2, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_570" (showCons x7))

d_C__case_569 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_569 x2 x9 cd cs = case x9 of
  Curry_Prelude.OP_List -> x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_569 x2 l cd cs)
    (d_C__case_569 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_569 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_569 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_569" [show x2, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_569" (showCons x9))

d_C__case_575 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_ConsDecl
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule
d_C__case_575 x3 x6 x7 cd cs = case x7 of
  Curry_Prelude.C_True -> d_C_readListRule x3 cd cs
  Curry_Prelude.C_False -> d_C__case_574 x3 x6 (d_C_isTupleType x3 cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_575 x3 x6 l cd
    cs) (d_C__case_575 x3 x6 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_575 x3
    x6 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_575 x3 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_575" [show x3, show x6, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_575" (showCons x7))

d_C__case_574 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List FlatCurry.Curry_Types.C_ConsDecl
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule
d_C__case_574 x3 x6 x7 cd cs = case x7 of
  Curry_Prelude.C_True -> d_C_readTupleRule (Curry_Prelude.d_C_head x6 cd cs) cd
    cs
  Curry_Prelude.C_False -> d_C__case_573 x6 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_574 x3 x6 l cd
    cs) (d_C__case_574 x3 x6 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_574 x3
    x6 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_574 x3 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_574" [show x3, show x6, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_574" (showCons x7))

d_C__case_573 :: Curry_Prelude.OP_List FlatCurry.Curry_Types.C_ConsDecl
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule
d_C__case_573 x6 x7 cd cs = case x7 of
  Curry_Prelude.C_True -> d_C_readRule x6 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_573 x6 l cd cs)
    (d_C__case_573 x6 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_573 x6
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_573 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_573" [show x6, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_573" (showCons x7))

d_C__case_577 :: Curry_Prelude.C_Bool -> Curry_AbstractHaskell.C_TypeExpr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Curry_AbstractHaskell.C_Rule -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_TypeDecl
d_C__case_577 x1 x8 x9 x7 x10 cd cs = case x10 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (d_C_mkInstance
    (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString "Read")
    cd cs) Curry_Prelude.OP_List x8 x7 cd cs) (Curry_Prelude.OP_Cons x9
    Curry_Prelude.OP_List) cd cs
  Curry_Prelude.C_False -> d_C__case_576 x8 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_577 x1 x8 x9 x7 l
    cd cs) (d_C__case_577 x1 x8 x9 x7 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_577 x1
    x8 x9 x7 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_577 x1 x8 x9 x7 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_577" [show x1, show x8, show x9, show x7, show x10] info)
  _ -> failCons cd (consFail "TransTypes._case_577" (showCons x10))

d_C__case_576 :: Curry_AbstractHaskell.C_TypeExpr -> Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> Curry_AbstractHaskell.C_TypeDecl
d_C__case_576 x8 x9 cd cs = case x9 of
  Curry_Prelude.C_True -> d_C_mkEmptyInstance (d_C_basics
    (Curry_Prelude.toCurryString "Read") cd cs) x8 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "TransTypes.readInstance") cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_576 x8 l cd cs)
    (d_C__case_576 x8 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_576 x8
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_576 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_576" [show x8, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_576" (showCons x9))

d_C__case_602 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Rule
d_C__case_602 x3 x2 x1 x6 cd cs = case x6 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_601 x4 x3 x2 x1 x5
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x4 (Curry_Prelude.C_Char 'O'#) cd cs) cd cs
  Curry_Prelude.OP_List -> d_OP_showConsRule_dot_showBody_dot_114 x1 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_602 x3 x2 x1 l
    cd cs) (d_C__case_602 x3 x2 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_602 x3
    x2 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_602 x3 x2 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_602" [show x3, show x2, show x1, show x6] info)
  _ -> failCons cd (consFail "TransTypes._case_602" (showCons x6))

d_C__case_601 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Rule
d_C__case_601 x4 x3 x2 x1 x5 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> d_C__case_600 x3 x2 x1 x5 cd cs
  Curry_Prelude.C_False -> d_OP_showConsRule_dot_showBody_dot_114 x1 x2 x3 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_601 x4 x3 x2 x1
    x5 l cd cs) (d_C__case_601 x4 x3 x2 x1 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_601 x4
    x3 x2 x1 x5 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_601 x4 x3 x2 x1
    x5 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_601" [show x4, show x3, show x2, show x1, show x5, show
    x6] info)
  _ -> failCons cd (consFail "TransTypes._case_601" (showCons x6))

d_C__case_600 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Rule
d_C__case_600 x3 x2 x1 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_599 x6 x3 x2 x1 x7
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x6 (Curry_Prelude.C_Char 'P'#) cd cs) cd cs
  Curry_Prelude.OP_List -> d_OP_showConsRule_dot_showBody_dot_114 x1 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_600 x3 x2 x1 l
    cd cs) (d_C__case_600 x3 x2 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_600 x3
    x2 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_600 x3 x2 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_600" [show x3, show x2, show x1, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_600" (showCons x5))

d_C__case_599 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Rule
d_C__case_599 x6 x3 x2 x1 x7 x8 cd cs = case x8 of
  Curry_Prelude.C_True -> d_C__case_598 x3 x2 x1 x7 cd cs
  Curry_Prelude.C_False -> d_OP_showConsRule_dot_showBody_dot_114 x1 x2 x3 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_599 x6 x3 x2 x1
    x7 l cd cs) (d_C__case_599 x6 x3 x2 x1 x7 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_599 x6
    x3 x2 x1 x7 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_599 x6 x3 x2 x1
    x7 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_599" [show x6, show x3, show x2, show x1, show x7, show
    x8] info)
  _ -> failCons cd (consFail "TransTypes._case_599" (showCons x8))

d_C__case_598 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Rule
d_C__case_598 x3 x2 x1 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_597 x8 x3 x2 x1 x9
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x8 (Curry_Prelude.C_Char '_'#) cd cs) cd cs
  Curry_Prelude.OP_List -> d_OP_showConsRule_dot_showBody_dot_114 x1 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_598 x3 x2 x1 l
    cd cs) (d_C__case_598 x3 x2 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_598 x3
    x2 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_598 x3 x2 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_598" [show x3, show x2, show x1, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_598" (showCons x7))

d_C__case_597 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Rule
d_C__case_597 x8 x3 x2 x1 x9 x10 cd cs = case x10 of
  Curry_Prelude.C_True -> d_C__case_596 x3 x2 x1 x9 cd cs
  Curry_Prelude.C_False -> d_OP_showConsRule_dot_showBody_dot_114 x1 x2 x3 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_597 x8 x3 x2 x1
    x9 l cd cs) (d_C__case_597 x8 x3 x2 x1 x9 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_597 x8
    x3 x2 x1 x9 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_597 x8 x3 x2 x1
    x9 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_597" [show x8, show x3, show x2, show x1, show x9, show
    x10] info)
  _ -> failCons cd (consFail "TransTypes._case_597" (showCons x10))

d_C__case_596 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Rule
d_C__case_596 x3 x2 x1 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_595 x10 x3 x2 x1 x11
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x10 (Curry_Prelude.C_Char 'C'#) cd cs) cd cs
  Curry_Prelude.OP_List -> d_OP_showConsRule_dot_showBody_dot_114 x1 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_596 x3 x2 x1 l
    cd cs) (d_C__case_596 x3 x2 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_596 x3
    x2 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_596 x3 x2 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_596" [show x3, show x2, show x1, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_596" (showCons x9))

d_C__case_595 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Rule
d_C__case_595 x10 x3 x2 x1 x11 x12 cd cs = case x12 of
  Curry_Prelude.C_True -> d_C__case_594 x3 x2 x1 x11 cd cs
  Curry_Prelude.C_False -> d_C__case_587 x10 x3 x2 x1 x11
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x10 (Curry_Prelude.C_Char 'T'#) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_595 x10 x3 x2 x1
    x11 l cd cs) (d_C__case_595 x10 x3 x2 x1 x11 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_595 x10
    x3 x2 x1 x11 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_595 x10 x3 x2 x1
    x11 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_595" [show x10, show x3, show x2, show x1, show x11, show
    x12] info)
  _ -> failCons cd (consFail "TransTypes._case_595" (showCons x12))

d_C__case_587 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Rule
d_C__case_587 x10 x3 x2 x1 x11 x12 cd cs = case x12 of
  Curry_Prelude.C_True -> d_C__case_586 x3 x2 x1 x11 cd cs
  Curry_Prelude.C_False -> d_OP_showConsRule_dot_showBody_dot_114 x1 x2 x3 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_587 x10 x3 x2 x1
    x11 l cd cs) (d_C__case_587 x10 x3 x2 x1 x11 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_587 x10
    x3 x2 x1 x11 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_587 x10 x3 x2 x1
    x11 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_587" [show x10, show x3, show x2, show x1, show x11, show
    x12] info)
  _ -> failCons cd (consFail "TransTypes._case_587" (showCons x12))

d_C__case_586 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Rule
d_C__case_586 x3 x2 x1 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x20 x21 -> d_C__case_585 x20 x3 x2 x1 x21
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x20 (Curry_Prelude.C_Char 'u'#) cd cs) cd cs
  Curry_Prelude.OP_List -> d_OP_showConsRule_dot_showBody_dot_114 x1 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_586 x3 x2 x1 l
    cd cs) (d_C__case_586 x3 x2 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_586 x3
    x2 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_586 x3 x2 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_586" [show x3, show x2, show x1, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_586" (showCons x11))

d_C__case_585 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Rule
d_C__case_585 x20 x3 x2 x1 x21 x22 cd cs = case x22 of
  Curry_Prelude.C_True -> d_C__case_584 x3 x2 x1 x21 cd cs
  Curry_Prelude.C_False -> d_OP_showConsRule_dot_showBody_dot_114 x1 x2 x3 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_585 x20 x3 x2 x1
    x21 l cd cs) (d_C__case_585 x20 x3 x2 x1 x21 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_585 x20
    x3 x2 x1 x21 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_585 x20 x3 x2 x1
    x21 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_585" [show x20, show x3, show x2, show x1, show x21, show
    x22] info)
  _ -> failCons cd (consFail "TransTypes._case_585" (showCons x22))

d_C__case_584 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Rule
d_C__case_584 x3 x2 x1 x21 cd cs = case x21 of
  Curry_Prelude.OP_Cons x22 x23 -> d_C__case_583 x22 x3 x2 x1 x23
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x22 (Curry_Prelude.C_Char 'p'#) cd cs) cd cs
  Curry_Prelude.OP_List -> d_OP_showConsRule_dot_showBody_dot_114 x1 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_584 x3 x2 x1 l
    cd cs) (d_C__case_584 x3 x2 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_584 x3
    x2 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_584 x3 x2 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_584" [show x3, show x2, show x1, show x21] info)
  _ -> failCons cd (consFail "TransTypes._case_584" (showCons x21))

d_C__case_583 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Rule
d_C__case_583 x22 x3 x2 x1 x23 x24 cd cs = case x24 of
  Curry_Prelude.C_True -> d_C__case_582 x3 x2 x1 x23 cd cs
  Curry_Prelude.C_False -> d_OP_showConsRule_dot_showBody_dot_114 x1 x2 x3 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_583 x22 x3 x2 x1
    x23 l cd cs) (d_C__case_583 x22 x3 x2 x1 x23 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_583 x22
    x3 x2 x1 x23 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_583 x22 x3 x2 x1
    x23 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_583" [show x22, show x3, show x2, show x1, show x23, show
    x24] info)
  _ -> failCons cd (consFail "TransTypes._case_583" (showCons x24))

d_C__case_582 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Rule
d_C__case_582 x3 x2 x1 x23 cd cs = case x23 of
  Curry_Prelude.OP_Cons x24 x25 -> d_C__case_581 x24 x3 x2 x1 x25
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x24 (Curry_Prelude.C_Char 'l'#) cd cs) cd cs
  Curry_Prelude.OP_List -> d_OP_showConsRule_dot_showBody_dot_114 x1 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_582 x3 x2 x1 l
    cd cs) (d_C__case_582 x3 x2 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_582 x3
    x2 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_582 x3 x2 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_582" [show x3, show x2, show x1, show x23] info)
  _ -> failCons cd (consFail "TransTypes._case_582" (showCons x23))

d_C__case_581 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Rule
d_C__case_581 x24 x3 x2 x1 x25 x26 cd cs = case x26 of
  Curry_Prelude.C_True -> d_C__case_580 x3 x2 x1 x25 cd cs
  Curry_Prelude.C_False -> d_OP_showConsRule_dot_showBody_dot_114 x1 x2 x3 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_581 x24 x3 x2 x1
    x25 l cd cs) (d_C__case_581 x24 x3 x2 x1 x25 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_581 x24
    x3 x2 x1 x25 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_581 x24 x3 x2 x1
    x25 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_581" [show x24, show x3, show x2, show x1, show x25, show
    x26] info)
  _ -> failCons cd (consFail "TransTypes._case_581" (showCons x26))

d_C__case_580 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Rule
d_C__case_580 x3 x2 x1 x25 cd cs = case x25 of
  Curry_Prelude.OP_Cons x26 x27 -> d_C__case_579 x26 x3 x2 x1 x27
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x26 (Curry_Prelude.C_Char 'e'#) cd cs) cd cs
  Curry_Prelude.OP_List -> d_OP_showConsRule_dot_showBody_dot_114 x1 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_580 x3 x2 x1 l
    cd cs) (d_C__case_580 x3 x2 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_580 x3
    x2 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_580 x3 x2 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_580" [show x3, show x2, show x1, show x25] info)
  _ -> failCons cd (consFail "TransTypes._case_580" (showCons x25))

d_C__case_579 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Rule
d_C__case_579 x26 x3 x2 x1 x27 x28 cd cs = case x28 of
  Curry_Prelude.C_True -> d_C__case_578 x3 x2 x1 x27 cd cs
  Curry_Prelude.C_False -> d_OP_showConsRule_dot_showBody_dot_114 x1 x2 x3 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_579 x26 x3 x2 x1
    x27 l cd cs) (d_C__case_579 x26 x3 x2 x1 x27 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_579 x26
    x3 x2 x1 x27 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_579 x26 x3 x2 x1
    x27 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_579" [show x26, show x3, show x2, show x1, show x27, show
    x28] info)
  _ -> failCons cd (consFail "TransTypes._case_579" (showCons x28))

d_C__case_578 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Rule
d_C__case_578 x3 x2 x1 x27 cd cs = case x27 of
  Curry_Prelude.OP_List -> d_OP_showConsRule_dot_showTupleCons_dot_114 x1 x3 cd
    cs
  Curry_Prelude.OP_Cons x28 x29 -> d_OP_showConsRule_dot_showBody_dot_114 x1 x2
    x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_578 x3 x2 x1 l
    cd cs) (d_C__case_578 x3 x2 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_578 x3
    x2 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_578 x3 x2 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_578" [show x3, show x2, show x1, show x27] info)
  _ -> failCons cd (consFail "TransTypes._case_578" (showCons x27))

d_C__case_594 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Rule
d_C__case_594 x3 x2 x1 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_593 x12 x3 x2 x1 x13
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x12 (Curry_Prelude.C_Char 'o'#) cd cs) cd cs
  Curry_Prelude.OP_List -> d_OP_showConsRule_dot_showBody_dot_114 x1 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_594 x3 x2 x1 l
    cd cs) (d_C__case_594 x3 x2 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_594 x3
    x2 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_594 x3 x2 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_594" [show x3, show x2, show x1, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_594" (showCons x11))

d_C__case_593 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Rule
d_C__case_593 x12 x3 x2 x1 x13 x14 cd cs = case x14 of
  Curry_Prelude.C_True -> d_C__case_592 x3 x2 x1 x13 cd cs
  Curry_Prelude.C_False -> d_OP_showConsRule_dot_showBody_dot_114 x1 x2 x3 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_593 x12 x3 x2 x1
    x13 l cd cs) (d_C__case_593 x12 x3 x2 x1 x13 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_593 x12
    x3 x2 x1 x13 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_593 x12 x3 x2 x1
    x13 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_593" [show x12, show x3, show x2, show x1, show x13, show
    x14] info)
  _ -> failCons cd (consFail "TransTypes._case_593" (showCons x14))

d_C__case_592 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Rule
d_C__case_592 x3 x2 x1 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_591 x14 x3 x2 x1 x15
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x14 (Curry_Prelude.C_Char 'n'#) cd cs) cd cs
  Curry_Prelude.OP_List -> d_OP_showConsRule_dot_showBody_dot_114 x1 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_592 x3 x2 x1 l
    cd cs) (d_C__case_592 x3 x2 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_592 x3
    x2 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_592 x3 x2 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_592" [show x3, show x2, show x1, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_592" (showCons x13))

d_C__case_591 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Rule
d_C__case_591 x14 x3 x2 x1 x15 x16 cd cs = case x16 of
  Curry_Prelude.C_True -> d_C__case_590 x3 x2 x1 x15 cd cs
  Curry_Prelude.C_False -> d_OP_showConsRule_dot_showBody_dot_114 x1 x2 x3 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_591 x14 x3 x2 x1
    x15 l cd cs) (d_C__case_591 x14 x3 x2 x1 x15 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_591 x14
    x3 x2 x1 x15 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_591 x14 x3 x2 x1
    x15 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_591" [show x14, show x3, show x2, show x1, show x15, show
    x16] info)
  _ -> failCons cd (consFail "TransTypes._case_591" (showCons x16))

d_C__case_590 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Rule
d_C__case_590 x3 x2 x1 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_589 x16 x3 x2 x1 x17
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x16 (Curry_Prelude.C_Char 's'#) cd cs) cd cs
  Curry_Prelude.OP_List -> d_OP_showConsRule_dot_showBody_dot_114 x1 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_590 x3 x2 x1 l
    cd cs) (d_C__case_590 x3 x2 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_590 x3
    x2 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_590 x3 x2 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_590" [show x3, show x2, show x1, show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_590" (showCons x15))

d_C__case_589 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_AbstractHaskell.C_Rule
d_C__case_589 x16 x3 x2 x1 x17 x18 cd cs = case x18 of
  Curry_Prelude.C_True -> d_C__case_588 x3 x2 x1 x17 cd cs
  Curry_Prelude.C_False -> d_OP_showConsRule_dot_showBody_dot_114 x1 x2 x3 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_589 x16 x3 x2 x1
    x17 l cd cs) (d_C__case_589 x16 x3 x2 x1 x17 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_589 x16
    x3 x2 x1 x17 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_589 x16 x3 x2 x1
    x17 e cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_589" [show x16, show x3, show x2, show x1, show x17, show
    x18] info)
  _ -> failCons cd (consFail "TransTypes._case_589" (showCons x18))

d_C__case_588 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Rule
d_C__case_588 x3 x2 x1 x17 cd cs = case x17 of
  Curry_Prelude.OP_List -> d_OP_showConsRule_dot_showListCons_dot_114 x1 x3 cd
    cs
  Curry_Prelude.OP_Cons x18 x19 -> d_OP_showConsRule_dot_showBody_dot_114 x1 x2
    x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_588 x3 x2 x1 l
    cd cs) (d_C__case_588 x3 x2 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_588 x3
    x2 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_588 x3 x2 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_588" [show x3, show x2, show x1, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_588" (showCons x17))

d_C__case_603 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_AbstractHaskell.C_Expr
d_C__case_603 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_AbstractHaskellGoodies.d_C_applyF
    (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString
    "showString") cd cs) (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply
    (Curry_AbstractHaskellGoodies.d_C_string2ac cd cs)
    (Curry_Names.d_C_unGenRename (Curry_Prelude.d_C_snd x2 cd cs) cd cs) cd cs)
    Curry_Prelude.OP_List) cd cs
  Curry_Prelude.C_False -> Curry_AbstractHaskell.C_InfixApply
    (Curry_AbstractHaskellGoodies.d_C_applyF
    (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString
    "showString") cd cs) (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply
    (Curry_AbstractHaskellGoodies.d_C_string2ac cd cs) (Curry_Prelude.OP_Cons
    (Curry_Prelude.C_Char '('#) (Curry_Names.d_C_unGenRename
    (Curry_Prelude.d_C_snd x2 cd cs) cd cs)) cd cs) Curry_Prelude.OP_List) cd
    cs) (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString ".")
    cd cs) (Curry_Prelude.d_C_foldr (acceptCs id
    d_OP_showConsRule_dot_showBody_dot_114_dot_uscore_hash_lambda9)
    (Curry_AbstractHaskellGoodies.d_C_applyF
    (Curry_AbstractHaskellGoodies.d_C_pre (Curry_Prelude.toCurryString
    "showChar") cd cs) (Curry_Prelude.OP_Cons (Curry_AbstractHaskell.C_Lit
    (Curry_AbstractHaskell.C_Charc (Curry_Prelude.C_Char ')'#)))
    Curry_Prelude.OP_List) cd cs) (Curry_Prelude.d_C_map
    d_OP_showConsRule_dot_showBody_dot_114_dot_uscore_hash_lambda10
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_enumFromTo_hash_Prelude_dot_Enum_hash_Prelude_dot_Int
    cd cs) (Curry_Prelude.C_Int (1)) cd cs) x1 cd cs) cd cs) cd cs)
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_603 x1 x2 l cd
    cs) (d_C__case_603 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_603 x1
    x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_603 x1 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_603" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_603" (showCons x3))

d_C__case_606 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_606 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_605 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_606 l cd cs)
    (d_C__case_606 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_606 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_606 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_606" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_606" (showCons x3))

d_C__case_605 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_605 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_604 x6 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_605 l cd cs)
    (d_C__case_605 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_605 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_605 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_605" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_605" (showCons x5))

d_C__case_604 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_604 x6 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> x6
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_604 x6 l cd cs)
    (d_C__case_604 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_604 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_604 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_604" [show x6, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_604" (showCons x7))

d_C__case_609 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_609 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_608 x4 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_609 l cd cs)
    (d_C__case_609 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_609 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_609 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_609" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_609" (showCons x3))

d_C__case_608 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_608 x4 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_607 x4 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_608 x4 l cd cs)
    (d_C__case_608 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_608 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_608 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_608" [show x4, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_608" (showCons x5))

d_C__case_607 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_607 x4 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> x4
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_607 x4 l cd cs)
    (d_C__case_607 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_607 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_607 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_607" [show x4, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_607" (showCons x7))

d_C__case_612 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_612 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_611 x2 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_612 x2 l cd cs)
    (d_C__case_612 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_612 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_612 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_612" [show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_612" (showCons x3))

d_C__case_611 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_611 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_610 x2 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_611 x2 l cd cs)
    (d_C__case_611 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_611 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_611 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_611" [show x2, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_611" (showCons x5))

d_C__case_610 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_610 x2 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> x2
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_610 x2 l cd cs)
    (d_C__case_610 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_610 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_610 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_610" [show x2, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_610" (showCons x7))

d_C__case_614 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
d_C__case_614 x3 x4 x7 cd cs = case x7 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_map
    (d_OP_showConsRule_dot_rule_dot_114 x4 x3) (Curry_Prelude.OP_Cons x3
    (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply
    (Curry_Names.d_C_mkHoConsName cd cs) x3 cd cs) Curry_Prelude.OP_List)) cd cs
  Curry_Prelude.C_False -> d_C__case_613 x3 x4 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_614 x3 x4 l cd
    cs) (d_C__case_614 x3 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_614 x3
    x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_614 x3 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_614" [show x3, show x4, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_614" (showCons x7))

d_C__case_613 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) Curry_AbstractHaskell.C_Rule)
d_C__case_613 x3 x4 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons
    (d_OP_showConsRule_dot_rule_dot_114 x4 x3 x3 cd cs) Curry_Prelude.OP_List
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_613 x3 x4 l cd
    cs) (d_C__case_613 x3 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_613 x3
    x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_613 x3 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "TransTypes._case_613" [show x3, show x4, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_613" (showCons x5))

d_C__case_623 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_623 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_622 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_623 l cd cs)
    (d_C__case_623 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_623 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_623 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_623" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_623" (showCons x3))

d_C__case_622 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_622 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_621 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_622 l cd cs)
    (d_C__case_622 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_622 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_622 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_622" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_622" (showCons x5))

d_C__case_621 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_621 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_620 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_621 l cd cs)
    (d_C__case_621 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_621 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_621 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_621" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_621" (showCons x7))

d_C__case_620 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_620 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_619 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_620 l cd cs)
    (d_C__case_620 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_620 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_620 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_620" [show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_620" (showCons x9))

d_C__case_619 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_619 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_618 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_619 l cd cs)
    (d_C__case_619 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_619 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_619 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_619" [show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_619" (showCons x11))

d_C__case_618 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_618 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_617 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_618 l cd cs)
    (d_C__case_618 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_618 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_618 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_618" [show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_618" (showCons x13))

d_C__case_617 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_617 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_616 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_617 l cd cs)
    (d_C__case_617 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_617 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_617 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_617" [show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_617" (showCons x15))

d_C__case_616 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_616 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_615 x18 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_616 l cd cs)
    (d_C__case_616 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_616 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_616 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_616" [show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_616" (showCons x17))

d_C__case_615 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_615 x18 x19 cd cs = case x19 of
  Curry_Prelude.OP_List -> x18
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_615 x18 l cd cs)
    (d_C__case_615 x18 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_615
    x18 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_615 x18 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_615" [show x18, show x19] info)
  _ -> failCons cd (consFail "TransTypes._case_615" (showCons x19))

d_C__case_632 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_632 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_631 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_632 l cd cs)
    (d_C__case_632 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_632 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_632 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_632" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_632" (showCons x3))

d_C__case_631 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_631 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_630 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_631 l cd cs)
    (d_C__case_631 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_631 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_631 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_631" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_631" (showCons x5))

d_C__case_630 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_630 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_629 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_630 l cd cs)
    (d_C__case_630 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_630 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_630 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_630" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_630" (showCons x7))

d_C__case_629 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_629 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_628 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_629 l cd cs)
    (d_C__case_629 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_629 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_629 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_629" [show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_629" (showCons x9))

d_C__case_628 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_628 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_627 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_628 l cd cs)
    (d_C__case_628 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_628 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_628 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_628" [show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_628" (showCons x11))

d_C__case_627 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_627 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_626 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_627 l cd cs)
    (d_C__case_627 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_627 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_627 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_627" [show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_627" (showCons x13))

d_C__case_626 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_626 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_625 x16 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_626 l cd cs)
    (d_C__case_626 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_626 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_626 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_626" [show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_626" (showCons x15))

d_C__case_625 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_625 x16 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_624 x16 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_625 x16 l cd cs)
    (d_C__case_625 x16 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_625
    x16 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_625 x16 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_625" [show x16, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_625" (showCons x17))

d_C__case_624 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_624 x16 x19 cd cs = case x19 of
  Curry_Prelude.OP_List -> x16
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_624 x16 l cd cs)
    (d_C__case_624 x16 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_624
    x16 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_624 x16 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_624" [show x16, show x19] info)
  _ -> failCons cd (consFail "TransTypes._case_624" (showCons x19))

d_C__case_641 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_641 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_640 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_641 l cd cs)
    (d_C__case_641 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_641 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_641 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_641" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_641" (showCons x3))

d_C__case_640 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_640 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_639 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_640 l cd cs)
    (d_C__case_640 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_640 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_640 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_640" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_640" (showCons x5))

d_C__case_639 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_639 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_638 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_639 l cd cs)
    (d_C__case_639 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_639 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_639 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_639" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_639" (showCons x7))

d_C__case_638 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_638 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_637 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_638 l cd cs)
    (d_C__case_638 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_638 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_638 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_638" [show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_638" (showCons x9))

d_C__case_637 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_637 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_636 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_637 l cd cs)
    (d_C__case_637 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_637 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_637 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_637" [show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_637" (showCons x11))

d_C__case_636 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_636 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_635 x14 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_636 l cd cs)
    (d_C__case_636 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_636 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_636 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_636" [show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_636" (showCons x13))

d_C__case_635 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_635 x14 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_634 x14 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_635 x14 l cd cs)
    (d_C__case_635 x14 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_635
    x14 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_635 x14 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_635" [show x14, show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_635" (showCons x15))

d_C__case_634 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_634 x14 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_633 x14 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_634 x14 l cd cs)
    (d_C__case_634 x14 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_634
    x14 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_634 x14 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_634" [show x14, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_634" (showCons x17))

d_C__case_633 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_633 x14 x19 cd cs = case x19 of
  Curry_Prelude.OP_List -> x14
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_633 x14 l cd cs)
    (d_C__case_633 x14 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_633
    x14 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_633 x14 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_633" [show x14, show x19] info)
  _ -> failCons cd (consFail "TransTypes._case_633" (showCons x19))

d_C__case_650 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_650 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_649 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_650 l cd cs)
    (d_C__case_650 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_650 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_650 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_650" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_650" (showCons x3))

d_C__case_649 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_649 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_648 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_649 l cd cs)
    (d_C__case_649 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_649 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_649 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_649" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_649" (showCons x5))

d_C__case_648 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_648 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_647 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_648 l cd cs)
    (d_C__case_648 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_648 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_648 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_648" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_648" (showCons x7))

d_C__case_647 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_647 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_646 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_647 l cd cs)
    (d_C__case_647 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_647 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_647 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_647" [show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_647" (showCons x9))

d_C__case_646 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_646 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_645 x12 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_646 l cd cs)
    (d_C__case_646 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_646 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_646 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_646" [show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_646" (showCons x11))

d_C__case_645 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_645 x12 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_644 x12 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_645 x12 l cd cs)
    (d_C__case_645 x12 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_645
    x12 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_645 x12 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_645" [show x12, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_645" (showCons x13))

d_C__case_644 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_644 x12 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_643 x12 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_644 x12 l cd cs)
    (d_C__case_644 x12 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_644
    x12 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_644 x12 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_644" [show x12, show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_644" (showCons x15))

d_C__case_643 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_643 x12 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_642 x12 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_643 x12 l cd cs)
    (d_C__case_643 x12 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_643
    x12 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_643 x12 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_643" [show x12, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_643" (showCons x17))

d_C__case_642 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_642 x12 x19 cd cs = case x19 of
  Curry_Prelude.OP_List -> x12
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_642 x12 l cd cs)
    (d_C__case_642 x12 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_642
    x12 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_642 x12 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_642" [show x12, show x19] info)
  _ -> failCons cd (consFail "TransTypes._case_642" (showCons x19))

d_C__case_659 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_659 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_658 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_659 l cd cs)
    (d_C__case_659 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_659 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_659 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_659" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_659" (showCons x3))

d_C__case_658 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_658 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_657 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_658 l cd cs)
    (d_C__case_658 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_658 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_658 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_658" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_658" (showCons x5))

d_C__case_657 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_657 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_656 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_657 l cd cs)
    (d_C__case_657 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_657 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_657 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_657" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_657" (showCons x7))

d_C__case_656 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_656 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_655 x10 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_656 l cd cs)
    (d_C__case_656 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_656 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_656 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_656" [show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_656" (showCons x9))

d_C__case_655 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_655 x10 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_654 x10 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_655 x10 l cd cs)
    (d_C__case_655 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_655
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_655 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_655" [show x10, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_655" (showCons x11))

d_C__case_654 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_654 x10 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_653 x10 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_654 x10 l cd cs)
    (d_C__case_654 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_654
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_654 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_654" [show x10, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_654" (showCons x13))

d_C__case_653 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_653 x10 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_652 x10 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_653 x10 l cd cs)
    (d_C__case_653 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_653
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_653 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_653" [show x10, show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_653" (showCons x15))

d_C__case_652 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_652 x10 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_651 x10 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_652 x10 l cd cs)
    (d_C__case_652 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_652
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_652 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_652" [show x10, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_652" (showCons x17))

d_C__case_651 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_651 x10 x19 cd cs = case x19 of
  Curry_Prelude.OP_List -> x10
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_651 x10 l cd cs)
    (d_C__case_651 x10 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_651
    x10 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_651 x10 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_651" [show x10, show x19] info)
  _ -> failCons cd (consFail "TransTypes._case_651" (showCons x19))

d_C__case_668 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_668 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_667 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_668 l cd cs)
    (d_C__case_668 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_668 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_668 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_668" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_668" (showCons x3))

d_C__case_667 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_667 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_666 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_667 l cd cs)
    (d_C__case_667 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_667 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_667 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_667" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_667" (showCons x5))

d_C__case_666 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_666 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_665 x8 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_666 l cd cs)
    (d_C__case_666 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_666 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_666 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_666" [show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_666" (showCons x7))

d_C__case_665 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_665 x8 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_664 x8 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_665 x8 l cd cs)
    (d_C__case_665 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_665 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_665 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_665" [show x8, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_665" (showCons x9))

d_C__case_664 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_664 x8 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_663 x8 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_664 x8 l cd cs)
    (d_C__case_664 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_664 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_664 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_664" [show x8, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_664" (showCons x11))

d_C__case_663 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_663 x8 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_662 x8 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_663 x8 l cd cs)
    (d_C__case_663 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_663 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_663 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_663" [show x8, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_663" (showCons x13))

d_C__case_662 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_662 x8 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_661 x8 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_662 x8 l cd cs)
    (d_C__case_662 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_662 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_662 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_662" [show x8, show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_662" (showCons x15))

d_C__case_661 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_661 x8 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_660 x8 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_661 x8 l cd cs)
    (d_C__case_661 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_661 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_661 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_661" [show x8, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_661" (showCons x17))

d_C__case_660 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_660 x8 x19 cd cs = case x19 of
  Curry_Prelude.OP_List -> x8
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_660 x8 l cd cs)
    (d_C__case_660 x8 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_660 x8
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_660 x8 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_660" [show x8, show x19] info)
  _ -> failCons cd (consFail "TransTypes._case_660" (showCons x19))

d_C__case_677 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_677 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_676 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_677 l cd cs)
    (d_C__case_677 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_677 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_677 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_677" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_677" (showCons x3))

d_C__case_676 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_676 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_675 x6 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_676 l cd cs)
    (d_C__case_676 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_676 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_676 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_676" [show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_676" (showCons x5))

d_C__case_675 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_675 x6 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_674 x6 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_675 x6 l cd cs)
    (d_C__case_675 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_675 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_675 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_675" [show x6, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_675" (showCons x7))

d_C__case_674 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_674 x6 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_673 x6 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_674 x6 l cd cs)
    (d_C__case_674 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_674 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_674 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_674" [show x6, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_674" (showCons x9))

d_C__case_673 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_673 x6 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_672 x6 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_673 x6 l cd cs)
    (d_C__case_673 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_673 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_673 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_673" [show x6, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_673" (showCons x11))

d_C__case_672 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_672 x6 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_671 x6 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_672 x6 l cd cs)
    (d_C__case_672 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_672 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_672 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_672" [show x6, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_672" (showCons x13))

d_C__case_671 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_671 x6 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_670 x6 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_671 x6 l cd cs)
    (d_C__case_671 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_671 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_671 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_671" [show x6, show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_671" (showCons x15))

d_C__case_670 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_670 x6 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_669 x6 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_670 x6 l cd cs)
    (d_C__case_670 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_670 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_670 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_670" [show x6, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_670" (showCons x17))

d_C__case_669 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_669 x6 x19 cd cs = case x19 of
  Curry_Prelude.OP_List -> x6
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_669 x6 l cd cs)
    (d_C__case_669 x6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_669 x6
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_669 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_669" [show x6, show x19] info)
  _ -> failCons cd (consFail "TransTypes._case_669" (showCons x19))

d_C__case_686 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_686 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_685 x4 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_686 l cd cs)
    (d_C__case_686 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_686 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_686 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_686" [show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_686" (showCons x3))

d_C__case_685 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_685 x4 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_684 x4 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_685 x4 l cd cs)
    (d_C__case_685 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_685 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_685 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_685" [show x4, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_685" (showCons x5))

d_C__case_684 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_684 x4 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_683 x4 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_684 x4 l cd cs)
    (d_C__case_684 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_684 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_684 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_684" [show x4, show x7] info)
  _ -> failCons cd (consFail "TransTypes._case_684" (showCons x7))

d_C__case_683 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_683 x4 x9 cd cs = case x9 of
  Curry_Prelude.OP_Cons x10 x11 -> d_C__case_682 x4 x11 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_683 x4 l cd cs)
    (d_C__case_683 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_683 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_683 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_683" [show x4, show x9] info)
  _ -> failCons cd (consFail "TransTypes._case_683" (showCons x9))

d_C__case_682 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_682 x4 x11 cd cs = case x11 of
  Curry_Prelude.OP_Cons x12 x13 -> d_C__case_681 x4 x13 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_682 x4 l cd cs)
    (d_C__case_682 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_682 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_682 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_682" [show x4, show x11] info)
  _ -> failCons cd (consFail "TransTypes._case_682" (showCons x11))

d_C__case_681 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_681 x4 x13 cd cs = case x13 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_680 x4 x15 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_681 x4 l cd cs)
    (d_C__case_681 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_681 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_681 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_681" [show x4, show x13] info)
  _ -> failCons cd (consFail "TransTypes._case_681" (showCons x13))

d_C__case_680 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_680 x4 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_679 x4 x17 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_680 x4 l cd cs)
    (d_C__case_680 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_680 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_680 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_680" [show x4, show x15] info)
  _ -> failCons cd (consFail "TransTypes._case_680" (showCons x15))

d_C__case_679 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_679 x4 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_678 x4 x19 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_679 x4 l cd cs)
    (d_C__case_679 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_679 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_679 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_679" [show x4, show x17] info)
  _ -> failCons cd (consFail "TransTypes._case_679" (showCons x17))

d_C__case_678 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_678 x4 x19 cd cs = case x19 of
  Curry_Prelude.OP_List -> x4
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_678 x4 l cd cs)
    (d_C__case_678 x4 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_678 x4
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_678 x4 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_678" [show x4, show x19] info)
  _ -> failCons cd (consFail "TransTypes._case_678" (showCons x19))

d_C__case_695 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_695 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_694 x2 x5 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_695 x2 l cd cs)
    (d_C__case_695 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_695 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_695 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_695" [show x2, show x3] info)
  _ -> failCons cd (consFail "TransTypes._case_695" (showCons x3))

d_C__case_694 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_694 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_693 x2 x7 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_694 x2 l cd cs)
    (d_C__case_694 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_694 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_694 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "TransTypes._case_694" [show x2, show x5] info)
  _ -> failCons cd (consFail "TransTypes._case_694" (showCons x5))

d_C__case_693 :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_693 x2 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_692 x2 x9 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_693 x2 l cd cs)
    (d_C__case_693 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_6