{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE Rank2Types #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module Curry_Utils
  ( d_C_showMonoQualTypeExpr
  , d_C_showMonoTypeExpr
  , d_C_notNull
  , d_C_strip
  , d_C_lpad
  , d_C_rpad )
  where

import Basics
import qualified AbstractCurry.Curry_Types
import qualified Curry_Char
import qualified Curry_List
import qualified Curry_Prelude


d_C_showMonoQualTypeExpr :: Curry_Prelude.C_Bool
  -> AbstractCurry.Curry_Types.C_CQualTypeExpr -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_showMonoQualTypeExpr x1 x2 cd cs = case x2 of
  AbstractCurry.Curry_Types.C_CQualType x3 x4 -> Curry_Prelude.d_OP_plus_plus
    (d_C_showContext x1 x3 cd cs) (d_C_showMonoTypeExpr x1 x4 cd cs) cd cs
  AbstractCurry.Curry_Types.Choice_C_CQualTypeExpr d i l r -> narrow d i
    (d_C_showMonoQualTypeExpr x1 l cd cs) (d_C_showMonoQualTypeExpr x1 r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CQualTypeExpr d i xs -> narrows cs d i
    (\z -> d_C_showMonoQualTypeExpr x1 z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CQualTypeExpr d c e -> guardCons d c
    (d_C_showMonoQualTypeExpr x1 e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CQualTypeExpr d info -> failCons d (traceFail
    "Utils.showMonoQualTypeExpr" [show x1, show x2] info)
  _ -> failCons cd (consFail "Utils.showMonoQualTypeExpr" (showCons x2))

d_C_showContext :: Curry_Prelude.C_Bool -> AbstractCurry.Curry_Types.C_CContext
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_showContext x1 x2 cd cs = case x1 of
  Curry_Prelude.C_False -> d_C__case_17 x2 cd cs
  Curry_Prelude.C_True -> Curry_Prelude.OP_List
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C_showContext l x2 cd cs)
    (d_C_showContext r x2 cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C_showContext z
    x2 cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C_showContext e x2 cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Utils.showContext"
    [show x1, show x2] info)
  _ -> failCons cd (consFail "Utils.showContext" (showCons x1))

d_C_showConstraint :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) AbstractCurry.Curry_Types.C_CTypeExpr -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_showConstraint x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> d_C__case_14 x3 x2 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C_showConstraint l cd
    cs) (d_C_showConstraint r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_C_showConstraint z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C_showConstraint e
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Utils.showConstraint" [show x1] info)
  _ -> failCons cd (consFail "Utils.showConstraint" (showCons x1))

d_C_showMonoTypeExpr :: Curry_Prelude.C_Bool
  -> AbstractCurry.Curry_Types.C_CTypeExpr -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_showMonoTypeExpr x1 x2 cd cs = d_C_showMonoTypeExpr' x1 (Curry_Prelude.C_Int
  (0)) x2 cd cs

d_C_showMonoTypeExpr' :: Curry_Prelude.C_Bool -> Curry_Prelude.C_Int
  -> AbstractCurry.Curry_Types.C_CTypeExpr -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_showMonoTypeExpr' x1 x2 x3 cd cs = case x3 of
  AbstractCurry.Curry_Types.C_CTVar x4 -> d_C__case_13 x1 x4 cd cs
  AbstractCurry.Curry_Types.C_CFuncType x7 x8 -> Curry_Prelude.d_OP_dollar
    (d_C_parens (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
    cd cs) x2 cd cs) (Curry_Prelude.C_Int (0)) cd cs))
    (Curry_Prelude.d_OP_plus_plus (d_C_showMonoTypeExpr' x1 (Curry_Prelude.C_Int
    (1)) x7 cd cs) (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString
    " -> ") (d_C_showMonoTypeExpr' x1 (Curry_Prelude.C_Int (0)) x8 cd cs) cd cs)
    cd cs) cd cs
  AbstractCurry.Curry_Types.C_CTCons x9 -> d_C__case_11 x9 cd cs
  AbstractCurry.Curry_Types.C_CTApply x12 x13 -> Curry_Prelude.d_C_maybe
    (Curry_Prelude.d_OP_dollar (d_C_parens (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
    cd cs) x2 cd cs) (Curry_Prelude.C_Int (1)) cd cs))
    (Curry_Prelude.d_OP_plus_plus (d_C_showMonoTypeExpr' x1 (Curry_Prelude.C_Int
    (2)) x12 cd cs) (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString
    " ") (d_C_showMonoTypeExpr' x1 (Curry_Prelude.C_Int (2)) x13 cd cs) cd cs)
    cd cs) cd cs) (d_OP_showMonoTypeExpr_tick_dot_uscore_hash_lambda3 x3 x1)
    (d_OP_showMonoTypeExpr_tick_dot_funOfApply_dot_25 x3 cd cs) cd cs
  AbstractCurry.Curry_Types.Choice_C_CTypeExpr d i l r -> narrow d i
    (d_C_showMonoTypeExpr' x1 x2 l cd cs) (d_C_showMonoTypeExpr' x1 x2 r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CTypeExpr d i xs -> narrows cs d i (\z ->
    d_C_showMonoTypeExpr' x1 x2 z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CTypeExpr d c e -> guardCons d c
    (d_C_showMonoTypeExpr' x1 x2 e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CTypeExpr d info -> failCons d (traceFail
    "Utils.showMonoTypeExpr'" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "Utils.showMonoTypeExpr'" (showCons x3))

d_OP_showMonoTypeExpr_tick_dot_funOfApply_dot_25 :: AbstractCurry.Curry_Types.C_CTypeExpr
  -> Cover -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_OP_showMonoTypeExpr_tick_dot_funOfApply_dot_25 x1 cd cs =
  let x2 = Curry_Prelude.C_Nothing in d_C__case_10 x2 x1 cd cs

d_OP_showMonoTypeExpr_tick_dot_argsOfApply_dot_25 :: AbstractCurry.Curry_Types.C_CTypeExpr
  -> Cover -> ConstStore -> Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CTypeExpr
d_OP_showMonoTypeExpr_tick_dot_argsOfApply_dot_25 x1 cd cs =
  let x2 = Curry_Prelude.OP_List in d_C__case_8 x2 x1 cd cs

d_OP_showMonoTypeExpr_tick_dot_uscore_hash_lambda3 :: AbstractCurry.Curry_Types.C_CTypeExpr
  -> Curry_Prelude.C_Bool -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_showMonoTypeExpr_tick_dot_uscore_hash_lambda3 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Tuple2 x4 x5 -> d_C_showTypeCons x2 x4 x5
    (d_OP_showMonoTypeExpr_tick_dot_argsOfApply_dot_25 x1 cd cs) cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_showMonoTypeExpr_tick_dot_uscore_hash_lambda3 x1 x2 l cd cs)
    (d_OP_showMonoTypeExpr_tick_dot_uscore_hash_lambda3 x1 x2 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_showMonoTypeExpr_tick_dot_uscore_hash_lambda3 x1 x2 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c
    (d_OP_showMonoTypeExpr_tick_dot_uscore_hash_lambda3 x1 x2 e cd $! addCs c
    cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "Utils.showMonoTypeExpr'._#lambda3" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "Utils.showMonoTypeExpr'._#lambda3" (showCons x3))

d_C_showTypeCons :: Curry_Prelude.C_Bool -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CTypeExpr -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_showTypeCons x1 x2 x3 x4 cd cs = case x4 of
  Curry_Prelude.OP_List -> x3
  Curry_Prelude.OP_Cons x5 x6 -> d_C__case_6 x2 x4 x1 x3
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) x2 (Curry_Prelude.toCurryString "Prelude") cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_showTypeCons x1 x2 x3
    l cd cs) (d_C_showTypeCons x1 x2 x3 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_showTypeCons
    x1 x2 x3 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_showTypeCons x1 x2 x3
    e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Utils.showTypeCons" [show x1, show x2, show x3, show x4] info)
  _ -> failCons cd (consFail "Utils.showTypeCons" (showCons x4))

d_C_showPreludeTypeCons :: Curry_Prelude.C_Bool -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CTypeExpr -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_showPreludeTypeCons x1 x2 x3 cd cs = d_C__case_4 x3 x2 x1
  (Curry_Prelude.d_OP_amp_amp
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs) x2 (Curry_Prelude.toCurryString "[]") cd cs)
  (AbstractCurry.Curry_Types.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_AbstractCurry_dot_Types_dot_CTypeExpr
  (Curry_Prelude.d_C_head x3 cd cs) (AbstractCurry.Curry_Types.C_CTCons
  (AbstractCurry.Curry_Types.d_C_pre (Curry_Prelude.toCurryString "Char") cd
  cs)) cd cs) cd cs) cd cs

d_C_showIdentifier :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_showIdentifier cd cs = Curry_Prelude.d_C_filter (Curry_Prelude.d_C_flip
  (Curry_Prelude.d_C_notElem
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
  cs)) (Curry_Prelude.toCurryString "<>"))

d_C_parens :: Curry_Prelude.C_Bool -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_parens x1 x2 cd cs = case x1 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons (Curry_Prelude.C_Char '('#)
    (Curry_Prelude.d_OP_plus_plus x2 (Curry_Prelude.toCurryString ")") cd cs)
  Curry_Prelude.C_False -> x2
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C_parens l x2 cd cs)
    (d_C_parens r x2 cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C_parens z x2
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C_parens e x2 cd $! addCs
    c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Utils.parens" [show
    x1, show x2] info)
  _ -> failCons cd (consFail "Utils.parens" (showCons x1))

d_C_prefixMap :: forall t0 t1 . (Curry_Prelude.Curry t1, Curry_Prelude.Curry
  t0) => (t0 -> Cover -> ConstStore -> Curry_Prelude.OP_List t1)
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_List t1 -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t1
d_C_prefixMap x1 x2 x3 cd cs = Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_concatMap (Curry_Prelude.d_OP_plus_plus x3) cd cs)
  (Curry_Prelude.d_C_map x1 x2 cd cs) cd cs

nd_C_prefixMap :: forall t0 t1 . (Curry_Prelude.Curry t1, Curry_Prelude.Curry
  t0) => Func t0 (Curry_Prelude.OP_List t1) -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.OP_List t1 -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t1
nd_C_prefixMap x1 x2 x3 s cd cs = let s3 = s
  in s3 `seq` (let s2 = leftSupply s3
                   s4 = rightSupply s3
                   s0 = leftSupply s4
                   s1 = rightSupply s4
  in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` Curry_Prelude.nd_C_apply
  (Curry_Prelude.nd_C_concatMap (wrapDX id (Curry_Prelude.d_OP_plus_plus x3)) s0
  cd cs) (Curry_Prelude.nd_C_map x1 x2 s1 cd cs) s2 cd cs))))

d_C_combineMap :: forall t0 t1 . (Curry_Prelude.Curry t1, Curry_Prelude.Curry
  t0) => (t0 -> Cover -> ConstStore -> Curry_Prelude.OP_List t1)
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_List t1 -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t1
d_C_combineMap x1 x2 x3 cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x4 x5 -> Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.d_C_apply x1 x4 cd cs) (d_C_prefixMap x1 x5 x3 cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_combineMap x1 l x3 cd
    cs) (d_C_combineMap x1 r x3 cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_combineMap
    x1 z x3 cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_combineMap x1 e x3
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Utils.combineMap"
    [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "Utils.combineMap" (showCons x2))

nd_C_combineMap :: forall t0 t1 . (Curry_Prelude.Curry t1, Curry_Prelude.Curry
  t0) => Func t0 (Curry_Prelude.OP_List t1) -> Curry_Prelude.OP_List t0
  -> Curry_Prelude.OP_List t1 -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t1
nd_C_combineMap x1 x2 x3 s cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x4 x5 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` Curry_Prelude.d_OP_plus_plus (Curry_Prelude.nd_C_apply
    x1 x4 s0 cd cs) (nd_C_prefixMap x1 x5 x3 s1 cd cs) cd cs))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C_combineMap x1 l x3 s
    cd cs) (nd_C_combineMap x1 r x3 s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C_combineMap
    x1 z x3 s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (nd_C_combineMap x1 e x3 s
    cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Utils.combineMap"
    [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "Utils.combineMap" (showCons x2))

d_C_isTuple :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isTuple x1 cd cs = case x1 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_False
  Curry_Prelude.OP_Cons x2 x3 -> Curry_Prelude.d_OP_amp_amp
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x2 (Curry_Prelude.C_Char '('#) cd cs)
    (d_OP_isTuple_dot_p1_uscore_isTuple_dot_75 x3 cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_isTuple l cd cs)
    (d_C_isTuple r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_isTuple z cd
    cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C_isTuple e cd $! addCs
    c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Utils.isTuple"
    [show x1] info)
  _ -> failCons cd (consFail "Utils.isTuple" (showCons x1))

d_OP_isTuple_dot_p1_uscore_isTuple_dot_75 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_OP_isTuple_dot_p1_uscore_isTuple_dot_75 x1 cd cs = case x1 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_False
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_0 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_isTuple_dot_p1_uscore_isTuple_dot_75 l cd cs)
    (d_OP_isTuple_dot_p1_uscore_isTuple_dot_75 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_isTuple_dot_p1_uscore_isTuple_dot_75 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c
    (d_OP_isTuple_dot_p1_uscore_isTuple_dot_75 e cd $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "Utils.isTuple.p1_isTuple.75" [show x1] info)
  _ -> failCons cd (consFail "Utils.isTuple.p1_isTuple.75" (showCons x1))

d_C_notNull :: forall t0 . (Curry_Prelude.Curry t0) => Cover -> ConstStore
  -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_notNull cd cs = Curry_Prelude.d_OP_dot Curry_Prelude.d_C_not
  Curry_Prelude.d_C_null cd cs

d_C_strip :: Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_strip cd cs = Curry_Prelude.d_OP_dot (Curry_Prelude.d_C_reverse cd cs)
  (Curry_Prelude.d_OP_dot (Curry_Prelude.d_C_dropWhile Curry_Char.d_C_isSpace)
  (Curry_Prelude.d_OP_dot (Curry_Prelude.d_C_reverse cd cs)
  (Curry_Prelude.d_C_dropWhile Curry_Char.d_C_isSpace) cd cs) cd cs) cd cs

d_C_lpad :: Curry_Prelude.C_Int -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_lpad x1 x2 cd cs = Curry_Prelude.d_OP_plus_plus (Curry_Prelude.d_C_replicate
  (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
  x1 (Curry_Prelude.d_C_length x2 cd cs) cd cs) (Curry_Prelude.C_Char ' '#) cd
  cs) x2 cd cs

d_C_rpad :: Curry_Prelude.C_Int -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_rpad x1 x2 cd cs = Curry_Prelude.d_OP_plus_plus x2
  (Curry_Prelude.d_C_replicate
  (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int
  x1 (Curry_Prelude.d_C_length x2 cd cs) cd cs) (Curry_Prelude.C_Char ' '#) cd
  cs) cd cs

d_C__case_0 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_0 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x2 (Curry_Prelude.C_Char ')'#) cd cs
  Curry_Prelude.OP_Cons x4 x5 -> Curry_Prelude.d_OP_amp_amp
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char
    x2 (Curry_Prelude.C_Char ','#) cd cs)
    (d_OP_isTuple_dot_p1_uscore_isTuple_dot_75 (Curry_Prelude.OP_Cons x4 x5) cd
    cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_0 x2 l cd cs)
    (d_C__case_0 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_0 x2 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c (d_C__case_0 x2 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail "Utils._case_0"
    [show x2, show x3] info)
  _ -> failCons cd (consFail "Utils._case_0" (showCons x3))

d_C__case_4 :: Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CTypeExpr
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_4 x3 x2 x1 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> Curry_Prelude.toCurryString "String"
  Curry_Prelude.C_False -> d_C__case_3 x2 x3 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char cd
    cs) x2 (Curry_Prelude.toCurryString "[]") cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_4 x3 x2 x1 l cd
    cs) (d_C__case_4 x3 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_4 x3 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_4 x3 x2 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Utils._case_4"
    [show x3, show x2, show x1, show x4] info)
  _ -> failCons cd (consFail "Utils._case_4" (showCons x4))

d_C__case_3 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CTypeExpr
  -> Curry_Prelude.C_Bool -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_3 x2 x3 x1 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.toCurryString "[") (Curry_Prelude.d_OP_plus_plus
    (d_C_showMonoTypeExpr' x1 (Curry_Prelude.C_Int (0)) (Curry_Prelude.d_C_head
    x3 cd cs) cd cs) (Curry_Prelude.toCurryString "]") cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_2 x2 x3 x1 (d_C_isTuple x2 cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_3 x2 x3 x1 l cd
    cs) (d_C__case_3 x2 x3 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_3 x2 x3
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_3 x2 x3 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Utils._case_3"
    [show x2, show x3, show x1, show x4] info)
  _ -> failCons cd (consFail "Utils._case_3" (showCons x4))

d_C__case_2 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CTypeExpr
  -> Curry_Prelude.C_Bool -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_2 x2 x3 x1 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.toCurryString "(") (Curry_Prelude.d_OP_plus_plus
    (d_C_combineMap (d_C_showMonoTypeExpr' x1 (Curry_Prelude.C_Int (0))) x3
    (Curry_Prelude.toCurryString ",") cd cs) (Curry_Prelude.toCurryString ")")
    cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_1 x3 x1 x2 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_2 x2 x3 x1 l cd
    cs) (d_C__case_2 x2 x3 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_2 x2 x3
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_2 x2 x3 x1 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Utils._case_2"
    [show x2, show x3, show x1, show x4] info)
  _ -> failCons cd (consFail "Utils._case_2" (showCons x4))

d_C__case_1 :: Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CTypeExpr
  -> Curry_Prelude.C_Bool -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_1 x3 x1 x2 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_plus_plus x2 (d_C_prefixMap
    (d_C_showMonoTypeExpr' x1 (Curry_Prelude.C_Int (2))) x3
    (Curry_Prelude.toCurryString " ") cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_1 x3 x1 x2 l cd
    cs) (d_C__case_1 x3 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_1 x3 x1
    x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_1 x3 x1 x2 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Utils._case_1"
    [show x3, show x1, show x2, show x4] info)
  _ -> failCons cd (consFail "Utils._case_1" (showCons x4))

d_C__case_6 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CTypeExpr
  -> Curry_Prelude.C_Bool -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_6 x2 x4 x1 x3 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> d_C_showPreludeTypeCons x1 x3 x4 cd cs
  Curry_Prelude.C_False -> d_C__case_5 x4 x1 x3 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_6 x2 x4 x1 x3 l
    cd cs) (d_C__case_6 x2 x4 x1 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_6 x2 x4
    x1 x3 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_6 x2 x4 x1 x3 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Utils._case_6"
    [show x2, show x4, show x1, show x3, show x5] info)
  _ -> failCons cd (consFail "Utils._case_6" (showCons x5))

d_C__case_5 :: Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CTypeExpr
  -> Curry_Prelude.C_Bool -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_5 x4 x1 x3 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_plus_plus x3 (d_C_prefixMap
    (d_C_showMonoTypeExpr' x1 (Curry_Prelude.C_Int (2))) x4
    (Curry_Prelude.toCurryString " ") cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_5 x4 x1 x3 l cd
    cs) (d_C__case_5 x4 x1 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_5 x4 x1
    x3 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_5 x4 x1 x3 e
    cd $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Utils._case_5"
    [show x4, show x1, show x3, show x5] info)
  _ -> failCons cd (consFail "Utils._case_5" (showCons x5))

d_C__case_8 :: Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CTypeExpr
  -> AbstractCurry.Curry_Types.C_CTypeExpr -> Cover -> ConstStore
  -> Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CTypeExpr
d_C__case_8 x2 x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CTApply x3 x4 -> let x5 = Curry_Prelude.d_OP_plus_plus
                                                     (d_OP_showMonoTypeExpr_tick_dot_argsOfApply_dot_25
                                                     x3 cd cs)
                                                     (Curry_Prelude.OP_Cons x4
                                                     Curry_Prelude.OP_List) cd
                                                     cs
    in d_C__case_7 x5 x4 x3 cd cs
  AbstractCurry.Curry_Types.C_CTVar x12 -> x2
  AbstractCurry.Curry_Types.C_CFuncType x13 x14 -> x2
  AbstractCurry.Curry_Types.C_CTCons x15 -> x2
  AbstractCurry.Curry_Types.Choice_C_CTypeExpr d i l r -> narrow d i
    (d_C__case_8 x2 l cd cs) (d_C__case_8 x2 r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CTypeExpr d i xs -> narrows cs d i (\z ->
    d_C__case_8 x2 z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CTypeExpr d c e -> guardCons d c
    (d_C__case_8 x2 e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CTypeExpr d info -> failCons d (traceFail
    "Utils._case_8" [show x2, show x1] info)
  _ -> failCons cd (consFail "Utils._case_8" (showCons x1))

d_C__case_7 :: Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CTypeExpr
  -> AbstractCurry.Curry_Types.C_CTypeExpr
  -> AbstractCurry.Curry_Types.C_CTypeExpr -> Cover -> ConstStore
  -> Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CTypeExpr
d_C__case_7 x5 x4 x3 cd cs = case x3 of
  AbstractCurry.Curry_Types.C_CTCons x6 -> Curry_Prelude.OP_Cons x4
    Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CTVar x7 -> x5
  AbstractCurry.Curry_Types.C_CFuncType x8 x9 -> x5
  AbstractCurry.Curry_Types.C_CTApply x10 x11 -> x5
  AbstractCurry.Curry_Types.Choice_C_CTypeExpr d i l r -> narrow d i
    (d_C__case_7 x5 x4 l cd cs) (d_C__case_7 x5 x4 r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CTypeExpr d i xs -> narrows cs d i (\z ->
    d_C__case_7 x5 x4 z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CTypeExpr d c e -> guardCons d c
    (d_C__case_7 x5 x4 e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CTypeExpr d info -> failCons d (traceFail
    "Utils._case_7" [show x5, show x4, show x3] info)
  _ -> failCons cd (consFail "Utils._case_7" (showCons x3))

d_C__case_10 :: Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> AbstractCurry.Curry_Types.C_CTypeExpr -> Cover
  -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C__case_10 x2 x1 cd cs = case x1 of
  AbstractCurry.Curry_Types.C_CTApply x3 x4 -> let x5 = d_OP_showMonoTypeExpr_tick_dot_funOfApply_dot_25
                                                     x3 cd cs
    in d_C__case_9 x5 x3 cd cs
  AbstractCurry.Curry_Types.C_CTVar x12 -> x2
  AbstractCurry.Curry_Types.C_CFuncType x13 x14 -> x2
  AbstractCurry.Curry_Types.C_CTCons x15 -> x2
  AbstractCurry.Curry_Types.Choice_C_CTypeExpr d i l r -> narrow d i
    (d_C__case_10 x2 l cd cs) (d_C__case_10 x2 r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CTypeExpr d i xs -> narrows cs d i (\z ->
    d_C__case_10 x2 z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CTypeExpr d c e -> guardCons d c
    (d_C__case_10 x2 e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CTypeExpr d info -> failCons d (traceFail
    "Utils._case_10" [show x2, show x1] info)
  _ -> failCons cd (consFail "Utils._case_10" (showCons x1))

d_C__case_9 :: Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> AbstractCurry.Curry_Types.C_CTypeExpr -> Cover
  -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C__case_9 x5 x3 cd cs = case x3 of
  AbstractCurry.Curry_Types.C_CTCons x6 -> Curry_Prelude.C_Just x6
  AbstractCurry.Curry_Types.C_CTVar x7 -> x5
  AbstractCurry.Curry_Types.C_CFuncType x8 x9 -> x5
  AbstractCurry.Curry_Types.C_CTApply x10 x11 -> x5
  AbstractCurry.Curry_Types.Choice_C_CTypeExpr d i l r -> narrow d i
    (d_C__case_9 x5 l cd cs) (d_C__case_9 x5 r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CTypeExpr d i xs -> narrows cs d i (\z ->
    d_C__case_9 x5 z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CTypeExpr d c e -> guardCons d c
    (d_C__case_9 x5 e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CTypeExpr d info -> failCons d (traceFail
    "Utils._case_9" [show x5, show x3] info)
  _ -> failCons cd (consFail "Utils._case_9" (showCons x3))

d_C__case_11 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_11 x9 cd cs = case x9 of
  Curry_Prelude.OP_Tuple2 x10 x11 -> x11
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C__case_11 l cd cs)
    (d_C__case_11 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C__case_11 z
    cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C__case_11 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail "Utils._case_11"
    [show x9] info)
  _ -> failCons cd (consFail "Utils._case_11" (showCons x9))

d_C__case_13 :: Curry_Prelude.C_Bool -> Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_13 x1 x4 cd cs = case x4 of
  Curry_Prelude.OP_Tuple2 x5 x6 -> d_C__case_12 x6 x1 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C__case_13 x1 l cd cs)
    (d_C__case_13 x1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C__case_13
    x1 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C__case_13 x1 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail "Utils._case_13"
    [show x1, show x4] info)
  _ -> failCons cd (consFail "Utils._case_13" (showCons x4))

d_C__case_12 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_12 x6 x1 cd cs = case x1 of
  Curry_Prelude.C_True -> Curry_Prelude.toCurryString "()"
  Curry_Prelude.C_False -> Curry_Prelude.d_C_apply (d_C_showIdentifier cd cs) x6
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_12 x6 l cd cs)
    (d_C__case_12 x6 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_12 x6 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_12 x6 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Utils._case_12"
    [show x6, show x1] info)
  _ -> failCons cd (consFail "Utils._case_12" (showCons x1))

d_C__case_14 :: AbstractCurry.Curry_Types.C_CTypeExpr -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_14 x3 x2 cd cs = case x2 of
  Curry_Prelude.OP_Tuple2 x4 x5 -> Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.d_C_apply (d_C_showIdentifier cd cs) x5 cd cs)
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString " ")
    (d_C_showMonoTypeExpr Curry_Prelude.C_False x3 cd cs) cd cs) cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C__case_14 x3 l cd cs)
    (d_C__case_14 x3 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C__case_14
    x3 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c (d_C__case_14 x3 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail "Utils._case_14"
    [show x3, show x2] info)
  _ -> failCons cd (consFail "Utils._case_14" (showCons x2))

d_C__case_17 :: AbstractCurry.Curry_Types.C_CContext -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_17 x2 cd cs = case x2 of
  AbstractCurry.Curry_Types.C_CContext x3 -> d_C__case_16 x3
    (Curry_Prelude.d_C_null x3 cd cs) cd cs
  AbstractCurry.Curry_Types.Choice_C_CContext d i l r -> narrow d i
    (d_C__case_17 l cd cs) (d_C__case_17 r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CContext d i xs -> narrows cs d i (\z ->
    d_C__case_17 z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CContext d c e -> guardCons d c
    (d_C__case_17 e cd $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CContext d info -> failCons d (traceFail
    "Utils._case_17" [show x2] info)
  _ -> failCons cd (consFail "Utils._case_17" (showCons x2))

d_C__case_16 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  AbstractCurry.Curry_Types.C_CTypeExpr) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_16 x3 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_List
  Curry_Prelude.C_False -> d_C__case_15 x3 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_16 x3 l cd cs)
    (d_C__case_16 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_16 x3 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_16 x3 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Utils._case_16"
    [show x3, show x4] info)
  _ -> failCons cd (consFail "Utils._case_16" (showCons x4))

d_C__case_15 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  AbstractCurry.Curry_Types.C_CTypeExpr) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_15 x3 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_plus_plus (d_C_parens
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int
    cd cs) (Curry_Prelude.d_C_length x3 cd cs) cd cs) (Curry_Prelude.C_Int (1))
    cd cs) (Curry_List.d_C_intercalate (Curry_Prelude.toCurryString ", ")
    (Curry_Prelude.d_C_map d_C_showConstraint x3 cd cs) cd cs) cd cs)
    (Curry_Prelude.toCurryString " => ") cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_15 x3 l cd cs)
    (d_C__case_15 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_15 x3 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c (d_C__case_15 x3 e cd $!
    addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail "Utils._case_15"
    [show x3, show x4] info)
  _ -> failCons cd (consFail "Utils._case_15" (showCons x4))

