{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE QuantifiedConstraints #-}
{-# LANGUAGE RankNTypes #-}
{-# LANGUAGE PolyKinds #-}
{-# LANGUAGE MultiParamTypeClasses #-}
{-# LANGUAGE FlexibleInstances #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module AbstractCurry.Curry_Build
  ( d_C_simpleCurryProg
  , d_C_simpleInstanceDecl
  , d_C_simpleCCons
  , d_C_applyTC
  , d_OP_tilde_gt
  , d_C_baseType
  , d_C_listType
  , d_C_tupleType
  , d_C_ioType
  , d_C_maybeType
  , d_C_stringType
  , d_C_intType
  , d_C_floatType
  , d_C_boolType
  , d_C_charType
  , d_C_unitType
  , d_C_dateType
  , d_C_emptyClassType
  , d_C_singleClassType
  , d_C_singleCConstraint
  , d_C_cfunc
  , d_C_cmtfunc
  , d_C_stFunc
  , d_C_stCmtFunc
  , d_C_simpleRule
  , d_C_simpleRuleWithLocals
  , d_C_guardedRule
  , d_C_noGuard
  , d_C_simpleRhs
  , d_C_applyF
  , d_C_applyE
  , d_C_constF
  , d_C_applyV
  , d_C_applyJust
  , d_C_applyMaybe
  , d_C_tupleExpr
  , d_C_ifThenElseExp
  , d_C_letExpr
  , d_C_simpleTyped
  , d_C_doExpr
  , d_C_cBranch
  , d_C_tuplePattern
  , d_C_pVars
  , d_C_pInt
  , d_C_pFloat
  , d_C_pChar
  , d_C_pNil
  , d_C_listPattern
  , d_C_stringPattern
  , d_C_list2ac
  , d_C_cInt
  , d_C_cFloat
  , d_C_cChar
  , d_C_string2ac
  , d_C_toVar
  , d_C_cvar
  , d_C_cpvar
  , d_C_ctvar )
  where

import Basics
import qualified AbstractCurry.Curry_Types
import qualified Curry_Prelude


d_C_simpleCurryProg :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CTypeDecl
  -> Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CFuncDecl
  -> Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_COpDecl -> Cover
  -> ConstStore -> AbstractCurry.Curry_Types.C_CurryProg
d_C_simpleCurryProg x1 x2 x3 x4 x5 cd cs = AbstractCurry.Curry_Types.C_CurryProg
  x1 x2 Curry_Prelude.C_Nothing Curry_Prelude.OP_List Curry_Prelude.OP_List x3
  x4 x5

d_C_simpleInstanceDecl :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> AbstractCurry.Curry_Types.C_CTypeExpr -> Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CFuncDecl -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CInstanceDecl
d_C_simpleInstanceDecl x1 x2 x3 cd cs = AbstractCurry.Curry_Types.C_CInstance x1
  (AbstractCurry.Curry_Types.C_CContext Curry_Prelude.OP_List)
  (Curry_Prelude.OP_Cons x2 Curry_Prelude.OP_List) x3

d_C_simpleCCons :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CVisibility -> Cover -> ConstStore
  -> Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CTypeExpr -> Cover
  -> ConstStore -> AbstractCurry.Curry_Types.C_CConsDecl
d_C_simpleCCons cd cs = acceptCs (acceptCs (acceptCs id))
  AbstractCurry.Curry_Types.C_CCons

d_C_applyTC :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CTypeExpr -> Cover
  -> ConstStore -> AbstractCurry.Curry_Types.C_CTypeExpr
d_C_applyTC x1 x2 cd cs = Curry_Prelude.d_C_foldl (acceptCs (acceptCs id)
  AbstractCurry.Curry_Types.C_CTApply) (AbstractCurry.Curry_Types.C_CTCons x1)
  x2 cd cs

d_OP_tilde_gt :: AbstractCurry.Curry_Types.C_CTypeExpr
  -> AbstractCurry.Curry_Types.C_CTypeExpr -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CTypeExpr
d_OP_tilde_gt x1 x2 cd cs = AbstractCurry.Curry_Types.C_CFuncType x1 x2

d_C_baseType :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> AbstractCurry.Curry_Types.C_CTypeExpr
d_C_baseType x1 cd cs = AbstractCurry.Curry_Types.C_CTCons x1

d_C_listType :: AbstractCurry.Curry_Types.C_CTypeExpr -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CTypeExpr
d_C_listType x1 cd cs = AbstractCurry.Curry_Types.C_CTApply
  (AbstractCurry.Curry_Types.C_CTCons (AbstractCurry.Curry_Types.d_C_pre
  (Curry_Prelude.toCurryString "[]") cd cs)) x1

d_C_tupleType :: Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CTypeExpr
  -> Cover -> ConstStore -> AbstractCurry.Curry_Types.C_CTypeExpr
d_C_tupleType x1 cd cs = let x2 = Curry_Prelude.d_C_length x1 cd cs
  in d_C__case_13 x2 x1
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int_hash
  x2 (Curry_Prelude.C_Int (0)) cd cs) cd cs

d_C_ioType :: AbstractCurry.Curry_Types.C_CTypeExpr -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CTypeExpr
d_C_ioType x1 cd cs = AbstractCurry.Curry_Types.C_CTApply
  (AbstractCurry.Curry_Types.C_CTCons (AbstractCurry.Curry_Types.d_C_pre
  (Curry_Prelude.toCurryString "IO") cd cs)) x1

d_C_maybeType :: AbstractCurry.Curry_Types.C_CTypeExpr -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CTypeExpr
d_C_maybeType x1 cd cs = AbstractCurry.Curry_Types.C_CTApply
  (AbstractCurry.Curry_Types.C_CTCons (AbstractCurry.Curry_Types.d_C_pre
  (Curry_Prelude.toCurryString "Maybe") cd cs)) x1

d_C_stringType :: Cover -> ConstStore -> AbstractCurry.Curry_Types.C_CTypeExpr
d_C_stringType cd cs = d_C_baseType (AbstractCurry.Curry_Types.d_C_pre
  (Curry_Prelude.toCurryString "String") cd cs) cd cs

d_C_intType :: Cover -> ConstStore -> AbstractCurry.Curry_Types.C_CTypeExpr
d_C_intType cd cs = d_C_baseType (AbstractCurry.Curry_Types.d_C_pre
  (Curry_Prelude.toCurryString "Int") cd cs) cd cs

d_C_floatType :: Cover -> ConstStore -> AbstractCurry.Curry_Types.C_CTypeExpr
d_C_floatType cd cs = d_C_baseType (AbstractCurry.Curry_Types.d_C_pre
  (Curry_Prelude.toCurryString "Float") cd cs) cd cs

d_C_boolType :: Cover -> ConstStore -> AbstractCurry.Curry_Types.C_CTypeExpr
d_C_boolType cd cs = d_C_baseType (AbstractCurry.Curry_Types.d_C_pre
  (Curry_Prelude.toCurryString "Bool") cd cs) cd cs

d_C_charType :: Cover -> ConstStore -> AbstractCurry.Curry_Types.C_CTypeExpr
d_C_charType cd cs = d_C_baseType (AbstractCurry.Curry_Types.d_C_pre
  (Curry_Prelude.toCurryString "Char") cd cs) cd cs

d_C_unitType :: Cover -> ConstStore -> AbstractCurry.Curry_Types.C_CTypeExpr
d_C_unitType cd cs = d_C_baseType (AbstractCurry.Curry_Types.d_C_pre
  (Curry_Prelude.toCurryString "()") cd cs) cd cs

d_C_dateType :: Cover -> ConstStore -> AbstractCurry.Curry_Types.C_CTypeExpr
d_C_dateType cd cs = d_C_baseType (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.toCurryString "Time") (Curry_Prelude.toCurryString
  "CalendarTime")) cd cs

d_C_emptyClassType :: AbstractCurry.Curry_Types.C_CTypeExpr -> Cover
  -> ConstStore -> AbstractCurry.Curry_Types.C_CQualTypeExpr
d_C_emptyClassType x1 cd cs = AbstractCurry.Curry_Types.C_CQualType
  (AbstractCurry.Curry_Types.C_CContext Curry_Prelude.OP_List) x1

d_C_singleClassType :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> AbstractCurry.Curry_Types.C_CTypeExpr
  -> AbstractCurry.Curry_Types.C_CTypeExpr -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CQualTypeExpr
d_C_singleClassType x1 x2 x3 cd cs = AbstractCurry.Curry_Types.C_CQualType
  (AbstractCurry.Curry_Types.C_CContext (Curry_Prelude.OP_Cons
  (Curry_Prelude.OP_Tuple2 x1 (Curry_Prelude.OP_Cons x2 Curry_Prelude.OP_List))
  Curry_Prelude.OP_List)) x3

d_C_singleCConstraint :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> AbstractCurry.Curry_Types.C_CTypeExpr -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CTypeExpr)
d_C_singleCConstraint x1 x2 cd cs = Curry_Prelude.OP_Tuple2 x1
  (Curry_Prelude.OP_Cons x2 Curry_Prelude.OP_List)

d_C_cfunc :: Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.C_Int -> Cover
  -> ConstStore -> AbstractCurry.Curry_Types.C_CVisibility -> Cover
  -> ConstStore -> AbstractCurry.Curry_Types.C_CQualTypeExpr -> Cover
  -> ConstStore -> Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CRule
  -> Cover -> ConstStore -> AbstractCurry.Curry_Types.C_CFuncDecl
d_C_cfunc cd cs = acceptCs (acceptCs (acceptCs (acceptCs (acceptCs id))))
  AbstractCurry.Curry_Types.C_CFunc

d_C_cmtfunc :: Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.C_Int -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CVisibility -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CQualTypeExpr -> Cover -> ConstStore
  -> Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CRule -> Cover
  -> ConstStore -> AbstractCurry.Curry_Types.C_CFuncDecl
d_C_cmtfunc cd cs = acceptCs (acceptCs (acceptCs (acceptCs (acceptCs (acceptCs
  id))))) AbstractCurry.Curry_Types.C_CmtFunc

d_C_stFunc :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> AbstractCurry.Curry_Types.C_CVisibility
  -> AbstractCurry.Curry_Types.C_CTypeExpr -> Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CRule -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CFuncDecl
d_C_stFunc x1 x2 x3 x4 x5 cd cs = Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply (d_C_cfunc cd cs) x1 cd cs) x2 cd cs) x3 cd cs)
  (d_C_emptyClassType x4 cd cs) cd cs) x5 cd cs

d_C_stCmtFunc :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int
  -> AbstractCurry.Curry_Types.C_CVisibility
  -> AbstractCurry.Curry_Types.C_CTypeExpr -> Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CRule -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CFuncDecl
d_C_stCmtFunc x1 x2 x3 x4 x5 x6 cd cs = Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (d_C_cmtfunc cd cs) x1 cd
  cs) x2 cd cs) x3 cd cs) x4 cd cs) (d_C_emptyClassType x5 cd cs) cd cs) x6 cd
  cs

d_C_simpleRule :: Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CPattern
  -> AbstractCurry.Curry_Types.C_CExpr -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CRule
d_C_simpleRule x1 x2 cd cs = AbstractCurry.Curry_Types.C_CRule x1
  (AbstractCurry.Curry_Types.C_CSimpleRhs x2 Curry_Prelude.OP_List)

d_C_simpleRuleWithLocals :: Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CPattern -> AbstractCurry.Curry_Types.C_CExpr
  -> Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CLocalDecl -> Cover
  -> ConstStore -> AbstractCurry.Curry_Types.C_CRule
d_C_simpleRuleWithLocals x1 x2 x3 cd cs = AbstractCurry.Curry_Types.C_CRule x1
  (AbstractCurry.Curry_Types.C_CSimpleRhs x2 x3)

d_C_guardedRule :: Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CPattern
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  AbstractCurry.Curry_Types.C_CExpr AbstractCurry.Curry_Types.C_CExpr)
  -> Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CLocalDecl -> Cover
  -> ConstStore -> AbstractCurry.Curry_Types.C_CRule
d_C_guardedRule x1 x2 x3 cd cs = d_C__case_10 x2 x3 x1
  (Curry_Prelude.d_OP_amp_amp
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int_hash
  (Curry_Prelude.d_C_length x2 cd cs) (Curry_Prelude.C_Int (1)) cd cs)
  (AbstractCurry.Curry_Types.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_AbstractCurry_dot_Types_dot_CExpr_hash
  (Curry_Prelude.d_C_fst (Curry_Prelude.d_C_head x2 cd cs) cd cs)
  (AbstractCurry.Curry_Types.C_CSymbol (AbstractCurry.Curry_Types.d_C_pre
  (Curry_Prelude.toCurryString "True") cd cs)) cd cs) cd cs) cd cs

d_C_noGuard :: AbstractCurry.Curry_Types.C_CExpr -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 AbstractCurry.Curry_Types.C_CExpr
  AbstractCurry.Curry_Types.C_CExpr
d_C_noGuard x1 cd cs = Curry_Prelude.OP_Tuple2
  (AbstractCurry.Curry_Types.C_CSymbol (AbstractCurry.Curry_Types.d_C_pre
  (Curry_Prelude.toCurryString "True") cd cs)) x1

d_C_simpleRhs :: AbstractCurry.Curry_Types.C_CExpr -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CRhs
d_C_simpleRhs x1 cd cs = AbstractCurry.Curry_Types.C_CSimpleRhs x1
  Curry_Prelude.OP_List

d_C_applyF :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CExpr -> Cover
  -> ConstStore -> AbstractCurry.Curry_Types.C_CExpr
d_C_applyF x1 x2 cd cs = Curry_Prelude.d_C_foldl (acceptCs (acceptCs id)
  AbstractCurry.Curry_Types.C_CApply) (AbstractCurry.Curry_Types.C_CSymbol x1)
  x2 cd cs

d_C_applyE :: AbstractCurry.Curry_Types.C_CExpr -> Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CExpr -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CExpr
d_C_applyE x1 x2 cd cs = Curry_Prelude.d_C_foldl (acceptCs (acceptCs id)
  AbstractCurry.Curry_Types.C_CApply) x1 x2 cd cs

d_C_constF :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> AbstractCurry.Curry_Types.C_CExpr
d_C_constF x1 cd cs = d_C_applyF x1 Curry_Prelude.OP_List cd cs

d_C_applyV :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CExpr -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CExpr
d_C_applyV x1 x2 cd cs = Curry_Prelude.d_C_foldl (acceptCs (acceptCs id)
  AbstractCurry.Curry_Types.C_CApply) (AbstractCurry.Curry_Types.C_CVar x1) x2
  cd cs

d_C_applyJust :: AbstractCurry.Curry_Types.C_CExpr -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CExpr
d_C_applyJust x1 cd cs = d_C_applyF (AbstractCurry.Curry_Types.d_C_pre
  (Curry_Prelude.toCurryString "Just") cd cs) (Curry_Prelude.OP_Cons x1
  Curry_Prelude.OP_List) cd cs

d_C_applyMaybe :: AbstractCurry.Curry_Types.C_CExpr
  -> AbstractCurry.Curry_Types.C_CExpr -> AbstractCurry.Curry_Types.C_CExpr
  -> Cover -> ConstStore -> AbstractCurry.Curry_Types.C_CExpr
d_C_applyMaybe x1 x2 x3 cd cs = d_C_applyF (AbstractCurry.Curry_Types.d_C_pre
  (Curry_Prelude.toCurryString "maybe") cd cs) (Curry_Prelude.OP_Cons x1
  (Curry_Prelude.OP_Cons x2 (Curry_Prelude.OP_Cons x3 Curry_Prelude.OP_List)))
  cd cs

d_C_tupleExpr :: Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CExpr
  -> Cover -> ConstStore -> AbstractCurry.Curry_Types.C_CExpr
d_C_tupleExpr x1 cd cs = let x2 = Curry_Prelude.d_C_length x1 cd cs
  in d_C__case_8 x2 x1
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int_hash
  x2 (Curry_Prelude.C_Int (0)) cd cs) cd cs

d_C_ifThenElseExp :: AbstractCurry.Curry_Types.C_CExpr
  -> AbstractCurry.Curry_Types.C_CExpr -> AbstractCurry.Curry_Types.C_CExpr
  -> Cover -> ConstStore -> AbstractCurry.Curry_Types.C_CExpr
d_C_ifThenElseExp x1 x2 x3 cd cs = d_C_applyF (AbstractCurry.Curry_Types.d_C_pre
  (Curry_Prelude.toCurryString "if_then_else") cd cs) (Curry_Prelude.OP_Cons x1
  (Curry_Prelude.OP_Cons x2 (Curry_Prelude.OP_Cons x3 Curry_Prelude.OP_List)))
  cd cs

d_C_letExpr :: Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CLocalDecl
  -> AbstractCurry.Curry_Types.C_CExpr -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CExpr
d_C_letExpr x1 x2 cd cs = d_C__case_5 x1 x2 (Curry_Prelude.d_C_null x1 cd cs) cd
  cs

d_C_simpleTyped :: AbstractCurry.Curry_Types.C_CExpr
  -> AbstractCurry.Curry_Types.C_CTypeExpr -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CExpr
d_C_simpleTyped x1 x2 cd cs = AbstractCurry.Curry_Types.C_CTyped x1
  (d_C_emptyClassType x2 cd cs)

d_C_doExpr :: Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CStatement
  -> Cover -> ConstStore -> AbstractCurry.Curry_Types.C_CExpr
d_C_doExpr x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> let x4 = AbstractCurry.Curry_Types.C_CDoExpr x1
    in d_C__case_4 x4 x3 x1 x2 cd cs
  Curry_Prelude.OP_List -> AbstractCurry.Curry_Types.C_CDoExpr x1
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_doExpr l cd cs)
    (d_C_doExpr r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_doExpr z cd
    cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C_doExpr e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "AbstractCurry.Build.doExpr" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Build.doExpr" (showCons x1))

d_C_cBranch :: AbstractCurry.Curry_Types.C_CPattern
  -> AbstractCurry.Curry_Types.C_CExpr -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 AbstractCurry.Curry_Types.C_CPattern
  AbstractCurry.Curry_Types.C_CRhs
d_C_cBranch x1 x2 cd cs = Curry_Prelude.OP_Tuple2 x1
  (AbstractCurry.Curry_Types.C_CSimpleRhs x2 Curry_Prelude.OP_List)

d_C_tuplePattern :: Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CPattern
  -> Cover -> ConstStore -> AbstractCurry.Curry_Types.C_CPattern
d_C_tuplePattern x1 cd cs = let x2 = Curry_Prelude.d_C_length x1 cd cs
  in d_C__case_2 x2 x1
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int_hash
  x2 (Curry_Prelude.C_Int (0)) cd cs) cd cs

d_C_pVars :: Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CPattern
d_C_pVars x1 cd cs = Curry_Prelude.d_C_map d_OP_pVars_dot_uscore_hash_lambda2
  (Curry_Prelude.d_OP_uscore_impl_hash_enumFromTo_hash_Prelude_dot_Enum_hash_Prelude_dot_Int_hash
  (Curry_Prelude.C_Int (0))
  (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int_hash
  x1 (Curry_Prelude.C_Int (1)) cd cs) cd cs) cd cs

d_OP_pVars_dot_uscore_hash_lambda2 :: Curry_Prelude.C_Int -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CPattern
d_OP_pVars_dot_uscore_hash_lambda2 x1 cd cs = AbstractCurry.Curry_Types.C_CPVar
  (Curry_Prelude.OP_Tuple2 x1 (Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.toCurryString "x") (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Int_hash
  cd cs) x1 cd cs) cd cs))

d_C_pInt :: Curry_Prelude.C_Int -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CPattern
d_C_pInt x1 cd cs = AbstractCurry.Curry_Types.C_CPLit
  (AbstractCurry.Curry_Types.C_CIntc x1)

d_C_pFloat :: Curry_Prelude.C_Float -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CPattern
d_C_pFloat x1 cd cs = AbstractCurry.Curry_Types.C_CPLit
  (AbstractCurry.Curry_Types.C_CFloatc x1)

d_C_pChar :: Curry_Prelude.C_Char -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CPattern
d_C_pChar x1 cd cs = AbstractCurry.Curry_Types.C_CPLit
  (AbstractCurry.Curry_Types.C_CCharc x1)

d_C_pNil :: Cover -> ConstStore -> AbstractCurry.Curry_Types.C_CPattern
d_C_pNil cd cs = AbstractCurry.Curry_Types.C_CPComb
  (AbstractCurry.Curry_Types.d_C_pre (Curry_Prelude.toCurryString "[]") cd cs)
  Curry_Prelude.OP_List

d_C_listPattern :: Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CPattern
  -> Cover -> ConstStore -> AbstractCurry.Curry_Types.C_CPattern
d_C_listPattern x1 cd cs = case x1 of
  Curry_Prelude.OP_List -> d_C_pNil cd cs
  Curry_Prelude.OP_Cons x2 x3 -> AbstractCurry.Curry_Types.C_CPComb
    (AbstractCurry.Curry_Types.d_C_pre (Curry_Prelude.toCurryString ":") cd cs)
    (Curry_Prelude.OP_Cons x2 (Curry_Prelude.OP_Cons (d_C_listPattern x3 cd cs)
    Curry_Prelude.OP_List))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_listPattern l cd cs)
    (d_C_listPattern r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_listPattern
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C_listPattern e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "AbstractCurry.Build.listPattern" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Build.listPattern" (showCons x1))

d_C_stringPattern :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CPattern
d_C_stringPattern cd cs = Curry_Prelude.d_OP_dot (acceptCs id
  AbstractCurry.Curry_Types.C_CPLit) (acceptCs id
  AbstractCurry.Curry_Types.C_CStringc) cd cs

d_C_list2ac :: Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CExpr -> Cover
  -> ConstStore -> AbstractCurry.Curry_Types.C_CExpr
d_C_list2ac x1 cd cs = case x1 of
  Curry_Prelude.OP_List -> d_C_constF (AbstractCurry.Curry_Types.d_C_pre
    (Curry_Prelude.toCurryString "[]") cd cs) cd cs
  Curry_Prelude.OP_Cons x2 x3 -> d_C_applyF (AbstractCurry.Curry_Types.d_C_pre
    (Curry_Prelude.toCurryString ":") cd cs) (Curry_Prelude.OP_Cons x2
    (Curry_Prelude.OP_Cons (d_C_list2ac x3 cd cs) Curry_Prelude.OP_List)) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_list2ac l cd cs)
    (d_C_list2ac r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_list2ac z cd
    cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C_list2ac e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "AbstractCurry.Build.list2ac" [show x1] info)
  _ -> failCons cd (consFail "AbstractCurry.Build.list2ac" (showCons x1))

d_C_cInt :: Curry_Prelude.C_Int -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CExpr
d_C_cInt x1 cd cs = AbstractCurry.Curry_Types.C_CLit
  (AbstractCurry.Curry_Types.C_CIntc x1)

d_C_cFloat :: Curry_Prelude.C_Float -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CExpr
d_C_cFloat x1 cd cs = AbstractCurry.Curry_Types.C_CLit
  (AbstractCurry.Curry_Types.C_CFloatc x1)

d_C_cChar :: Curry_Prelude.C_Char -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CExpr
d_C_cChar x1 cd cs = AbstractCurry.Curry_Types.C_CLit
  (AbstractCurry.Curry_Types.C_CCharc x1)

d_C_string2ac :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> AbstractCurry.Curry_Types.C_CExpr
d_C_string2ac x1 cd cs = AbstractCurry.Curry_Types.C_CLit
  (AbstractCurry.Curry_Types.C_CStringc x1)

d_C_toVar :: Curry_Prelude.C_Int -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CExpr
d_C_toVar x1 cd cs = AbstractCurry.Curry_Types.C_CVar (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.C_Int (1)) (Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.toCurryString "x") (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Int_hash
  cd cs) x1 cd cs) cd cs))

d_C_cvar :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CExpr
d_C_cvar x1 cd cs = AbstractCurry.Curry_Types.C_CVar (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.C_Int (1)) x1)

d_C_cpvar :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CPattern
d_C_cpvar x1 cd cs = AbstractCurry.Curry_Types.C_CPVar (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.C_Int (1)) x1)

d_C_ctvar :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CTypeExpr
d_C_ctvar x1 cd cs = AbstractCurry.Curry_Types.C_CTVar (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.C_Int (1)) x1)

d_C__case_13 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CTypeExpr -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> AbstractCurry.Curry_Types.C_CTypeExpr
d_C__case_13 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> d_C_baseType (AbstractCurry.Curry_Types.d_C_pre
    (Curry_Prelude.toCurryString "()") cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_12 x2 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int_hash
    x2 (Curry_Prelude.C_Int (1)) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_13 x2 x1 l cd cs)
    (d_C__case_13 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_13 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_13 x2 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractCurry.Build._case_13" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "AbstractCurry.Build._case_13" (showCons x3))

d_C__case_12 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CTypeExpr -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> AbstractCurry.Curry_Types.C_CTypeExpr
d_C__case_12 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_head x1 cd cs
  Curry_Prelude.C_False -> d_C__case_11 x1 x2 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_12 x2 x1 l cd cs)
    (d_C__case_12 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_12 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_12 x2 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractCurry.Build._case_12" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "AbstractCurry.Build._case_12" (showCons x3))

d_C__case_11 :: Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CTypeExpr
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CTypeExpr
d_C__case_11 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_foldl (acceptCs (acceptCs id)
    AbstractCurry.Curry_Types.C_CTApply) (AbstractCurry.Curry_Types.C_CTCons
    (AbstractCurry.Curry_Types.d_C_pre (Curry_Prelude.OP_Cons
    (Curry_Prelude.C_Char '('#) (Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.d_C_take
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int_hash
    x2 (Curry_Prelude.C_Int (1)) cd cs) (Curry_Prelude.d_C_repeat
    (Curry_Prelude.C_Char ','#) cd cs) cd cs) (Curry_Prelude.toCurryString ")")
    cd cs)) cd cs)) x1 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_11 x1 x2 l cd cs)
    (d_C__case_11 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_11 x1
    x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_11 x1 x2 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractCurry.Build._case_11" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractCurry.Build._case_11" (showCons x3))

d_C__case_10 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  AbstractCurry.Curry_Types.C_CExpr AbstractCurry.Curry_Types.C_CExpr)
  -> Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CLocalDecl
  -> Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CPattern
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CRule
d_C__case_10 x2 x3 x1 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> AbstractCurry.Curry_Types.C_CRule x1
    (AbstractCurry.Curry_Types.C_CSimpleRhs (Curry_Prelude.d_C_snd
    (Curry_Prelude.d_C_head x2 cd cs) cd cs) x3)
  Curry_Prelude.C_False -> d_C__case_9 x3 x2 x1 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_10 x2 x3 x1 l cd
    cs) (d_C__case_10 x2 x3 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_10 x2
    x3 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_10 x2 x3
    x1 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractCurry.Build._case_10" [show x2, show x3, show x1, show x4] info)
  _ -> failCons cd (consFail "AbstractCurry.Build._case_10" (showCons x4))

d_C__case_9 :: Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CLocalDecl
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  AbstractCurry.Curry_Types.C_CExpr AbstractCurry.Curry_Types.C_CExpr)
  -> Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CPattern
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CRule
d_C__case_9 x3 x2 x1 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> AbstractCurry.Curry_Types.C_CRule x1
    (AbstractCurry.Curry_Types.C_CGuardedRhs x2 x3)
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_9 x3 x2 x1 l cd
    cs) (d_C__case_9 x3 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_9 x3 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_9 x3 x2 x1
    e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractCurry.Build._case_9" [show x3, show x2, show x1, show x4] info)
  _ -> failCons cd (consFail "AbstractCurry.Build._case_9" (showCons x4))

d_C__case_8 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CExpr -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> AbstractCurry.Curry_Types.C_CExpr
d_C__case_8 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> d_C_constF (AbstractCurry.Curry_Types.d_C_pre
    (Curry_Prelude.toCurryString "()") cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_7 x2 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int_hash
    x2 (Curry_Prelude.C_Int (1)) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_8 x2 x1 l cd cs)
    (d_C__case_8 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_8 x2 x1
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_8 x2 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractCurry.Build._case_8" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "AbstractCurry.Build._case_8" (showCons x3))

d_C__case_7 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CExpr -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> AbstractCurry.Curry_Types.C_CExpr
d_C__case_7 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_head x1 cd cs
  Curry_Prelude.C_False -> d_C__case_6 x1 x2 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_7 x2 x1 l cd cs)
    (d_C__case_7 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_7 x2 x1
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_7 x2 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractCurry.Build._case_7" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "AbstractCurry.Build._case_7" (showCons x3))

d_C__case_6 :: Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CExpr
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CExpr
d_C__case_6 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> d_C_applyF (AbstractCurry.Curry_Types.d_C_pre
    (Curry_Prelude.OP_Cons (Curry_Prelude.C_Char '('#)
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.d_C_take
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int_hash
    x2 (Curry_Prelude.C_Int (1)) cd cs) (Curry_Prelude.d_C_repeat
    (Curry_Prelude.C_Char ','#) cd cs) cd cs) (Curry_Prelude.toCurryString ")")
    cd cs)) cd cs) x1 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_6 x1 x2 l cd cs)
    (d_C__case_6 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_6 x1 x2
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_6 x1 x2 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractCurry.Build._case_6" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractCurry.Build._case_6" (showCons x3))

d_C__case_5 :: Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CLocalDecl
  -> AbstractCurry.Curry_Types.C_CExpr -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> AbstractCurry.Curry_Types.C_CExpr
d_C__case_5 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> x2
  Curry_Prelude.C_False -> AbstractCurry.Curry_Types.C_CLetDecl x1 x2
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_5 x1 x2 l cd cs)
    (d_C__case_5 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_5 x1 x2
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_5 x1 x2 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractCurry.Build._case_5" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractCurry.Build._case_5" (showCons x3))

d_C__case_4 :: AbstractCurry.Curry_Types.C_CExpr -> Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CStatement -> Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CStatement
  -> AbstractCurry.Curry_Types.C_CStatement -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CExpr
d_C__case_4 x4 x3 x1 x2 cd cs = case x2 of
  AbstractCurry.Curry_Types.C_CSExpr x5 -> d_C__case_3 x1 x5 x3 cd cs
  AbstractCurry.Curry_Types.C_CSPat x8 x9 -> x4
  AbstractCurry.Curry_Types.C_CSLet x10 -> x4
  AbstractCurry.Curry_Types.Choice_C_CStatement d i l r -> narrow d i
    (d_C__case_4 x4 x3 x1 l cd cs) (d_C__case_4 x4 x3 x1 r cd cs)
  AbstractCurry.Curry_Types.Choices_C_CStatement d i xs -> narrows cs d i (\z ->
    d_C__case_4 x4 x3 x1 z cd cs) xs
  AbstractCurry.Curry_Types.Guard_C_CStatement d c e -> guardCons d c ((\x ->
    d_C__case_4 x4 x3 x1 e cd x) $! addCs c cs)
  AbstractCurry.Curry_Types.Fail_C_CStatement d info -> failCons d (traceFail
    "AbstractCurry.Build._case_4" [show x4, show x3, show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractCurry.Build._case_4" (showCons x2))

d_C__case_3 :: Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CStatement
  -> AbstractCurry.Curry_Types.C_CExpr -> Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CStatement -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CExpr
d_C__case_3 x1 x5 x3 cd cs = case x3 of
  Curry_Prelude.OP_List -> x5
  Curry_Prelude.OP_Cons x6 x7 -> AbstractCurry.Curry_Types.C_CDoExpr x1
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_3 x1 x5 l cd cs)
    (d_C__case_3 x1 x5 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_3 x1
    x5 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C__case_3 x1 x5 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "AbstractCurry.Build._case_3" [show x1, show x5, show x3] info)
  _ -> failCons cd (consFail "AbstractCurry.Build._case_3" (showCons x3))

d_C__case_2 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CPattern -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> AbstractCurry.Curry_Types.C_CPattern
d_C__case_2 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> AbstractCurry.Curry_Types.C_CPComb
    (AbstractCurry.Curry_Types.d_C_pre (Curry_Prelude.toCurryString "()") cd cs)
    Curry_Prelude.OP_List
  Curry_Prelude.C_False -> d_C__case_1 x2 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int_hash
    x2 (Curry_Prelude.C_Int (1)) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_2 x2 x1 l cd cs)
    (d_C__case_2 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_2 x2 x1
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_2 x2 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractCurry.Build._case_2" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "AbstractCurry.Build._case_2" (showCons x3))

d_C__case_1 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  AbstractCurry.Curry_Types.C_CPattern -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> AbstractCurry.Curry_Types.C_CPattern
d_C__case_1 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_head x1 cd cs
  Curry_Prelude.C_False -> d_C__case_0 x1 x2 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_1 x2 x1 l cd cs)
    (d_C__case_1 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_1 x2 x1
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_1 x2 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractCurry.Build._case_1" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "AbstractCurry.Build._case_1" (showCons x3))

d_C__case_0 :: Curry_Prelude.OP_List AbstractCurry.Curry_Types.C_CPattern
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> AbstractCurry.Curry_Types.C_CPattern
d_C__case_0 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> AbstractCurry.Curry_Types.C_CPComb
    (AbstractCurry.Curry_Types.d_C_pre (Curry_Prelude.OP_Cons
    (Curry_Prelude.C_Char '('#) (Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.d_C_take
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int_hash
    x2 (Curry_Prelude.C_Int (1)) cd cs) (Curry_Prelude.d_C_repeat
    (Curry_Prelude.C_Char ','#) cd cs) cd cs) (Curry_Prelude.toCurryString ")")
    cd cs)) cd cs) x1
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_0 x1 x2 l cd cs)
    (d_C__case_0 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_0 x1 x2
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_0 x1 x2 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractCurry.Build._case_0" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractCurry.Build._case_0" (showCons x3))

