{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE QuantifiedConstraints #-}
{-# LANGUAGE RankNTypes #-}
{-# LANGUAGE PolyKinds #-}
{-# LANGUAGE MultiParamTypeClasses #-}
{-# LANGUAGE FlexibleInstances #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module AbstractHaskell.Curry_Goodies
  ( d_C_lowerFirst
  , d_C_tupleName
  , d_C_ctvar
  , d_OP_tilde_gt
  , d_C_baseType
  , d_C_listType
  , d_C_tupleType
  , d_C_ioType
  , d_C_maybeType
  , d_C_stringType
  , d_C_intType
  , d_C_boolType
  , d_C_dateType
  , d_C_tyVarsOf
  , d_C_tfunc
  , d_C_ctfunc
  , d_C_cmtfunc
  , d_C_funcDecls
  , d_C_funcName
  , d_C_typeOf
  , d_C_commentOf
  , d_C_simpleRule
  , d_C_applyF
  , d_C_constF
  , d_C_applyV
  , d_C_tuplePat
  , d_C_tupleExpr
  , d_C_string2ac
  , d_C_pre
  , d_C_cvar
  , d_C_clet
  , d_C_list2ac
  , d_C_declVar
  , d_C_renameSymbolInProg
  , nd_C_renameSymbolInProg
  , d_C_renameSymbolInTypeDecl
  , nd_C_renameSymbolInTypeDecl
  , d_C_renameSymbolInConsDecl
  , nd_C_renameSymbolInConsDecl
  , d_C_renameSymbolInNewConsDecl
  , nd_C_renameSymbolInNewConsDecl
  , d_C_renameSymbolInTypeExpr
  , nd_C_renameSymbolInTypeExpr
  , d_C_renameSymbolInExpr
  , nd_C_renameSymbolInExpr
  , d_C_renameSymbolInPat
  , nd_C_renameSymbolInPat
  , d_C_renameSymbolInBranch
  , nd_C_renameSymbolInBranch
  , d_C_renameSymbolInStat
  , nd_C_renameSymbolInStat
  , d_C_renameSymbolInLocal
  , nd_C_renameSymbolInLocal
  , d_C_renameSymbolInTypeSig
  , nd_C_renameSymbolInTypeSig
  , d_C_renameSymbolInContext
  , nd_C_renameSymbolInContext
  , d_C_renameSymbolInFunc
  , nd_C_renameSymbolInFunc
  , d_C_renameSymbolInRules
  , nd_C_renameSymbolInRules
  , d_C_renameSymbolInRule
  , nd_C_renameSymbolInRule
  , d_C_renameSymbolInRhs
  , nd_C_renameSymbolInRhs
  , d_C_renameOpDecl
  , nd_C_renameOpDecl )
  where

import Basics
import qualified AbstractHaskell.Curry_Types
import qualified Data.Curry_Char
import qualified Data.Curry_List
import qualified Curry_Prelude


d_C_lowerFirst :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_lowerFirst x1 cd cs = case x1 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x2 x3 -> Curry_Prelude.OP_Cons
    (Data.Curry_Char.d_C_toLower x2 cd cs) x3
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_lowerFirst l cd cs)
    (d_C_lowerFirst r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_lowerFirst z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C_lowerFirst e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.lowerFirst" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.lowerFirst" (showCons x1))

d_C_tupleName :: Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_tupleName x1 cd cs = d_C__case_5 x1 (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
  cd cs) x1 cd cs) (Curry_Prelude.C_Int (1)) cd cs) cd cs

d_C_ctvar :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_TypeExpr
d_C_ctvar x1 cd cs = AbstractHaskell.Curry_Types.C_TVar (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.C_Int (1)) x1)

d_OP_tilde_gt :: AbstractHaskell.Curry_Types.C_TypeExpr
  -> AbstractHaskell.Curry_Types.C_TypeExpr -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_TypeExpr
d_OP_tilde_gt x1 x2 cd cs = AbstractHaskell.Curry_Types.C_FuncType x1 x2

d_C_baseType :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> AbstractHaskell.Curry_Types.C_TypeExpr
d_C_baseType x1 cd cs = AbstractHaskell.Curry_Types.C_TCons x1
  Curry_Prelude.OP_List

d_C_listType :: AbstractHaskell.Curry_Types.C_TypeExpr -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_TypeExpr
d_C_listType x1 cd cs = AbstractHaskell.Curry_Types.C_TCons (d_C_pre
  (Curry_Prelude.toCurryString "[]") cd cs) (Curry_Prelude.OP_Cons x1
  Curry_Prelude.OP_List)

d_C_tupleType :: Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_TypeExpr
  -> Cover -> ConstStore -> AbstractHaskell.Curry_Types.C_TypeExpr
d_C_tupleType x1 cd cs = let x2 = Curry_Prelude.d_C_length x1 cd cs
  in d_C__case_3 x2 x1
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int_hash
  x2 (Curry_Prelude.C_Int (0)) cd cs) cd cs

d_C_ioType :: AbstractHaskell.Curry_Types.C_TypeExpr -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_TypeExpr
d_C_ioType x1 cd cs = AbstractHaskell.Curry_Types.C_TCons (d_C_pre
  (Curry_Prelude.toCurryString "IO") cd cs) (Curry_Prelude.OP_Cons x1
  Curry_Prelude.OP_List)

d_C_maybeType :: AbstractHaskell.Curry_Types.C_TypeExpr -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_TypeExpr
d_C_maybeType x1 cd cs = AbstractHaskell.Curry_Types.C_TCons (d_C_pre
  (Curry_Prelude.toCurryString "Maybe") cd cs) (Curry_Prelude.OP_Cons x1
  Curry_Prelude.OP_List)

d_C_stringType :: Cover -> ConstStore -> AbstractHaskell.Curry_Types.C_TypeExpr
d_C_stringType cd cs = d_C_baseType (d_C_pre (Curry_Prelude.toCurryString
  "String") cd cs) cd cs

d_C_intType :: Cover -> ConstStore -> AbstractHaskell.Curry_Types.C_TypeExpr
d_C_intType cd cs = d_C_baseType (d_C_pre (Curry_Prelude.toCurryString "Int") cd
  cs) cd cs

d_C_boolType :: Cover -> ConstStore -> AbstractHaskell.Curry_Types.C_TypeExpr
d_C_boolType cd cs = d_C_baseType (d_C_pre (Curry_Prelude.toCurryString "Bool")
  cd cs) cd cs

d_C_dateType :: Cover -> ConstStore -> AbstractHaskell.Curry_Types.C_TypeExpr
d_C_dateType cd cs = d_C_baseType (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.toCurryString "Time") (Curry_Prelude.toCurryString
  "CalendarTime")) cd cs

d_C_tyVarsOf :: AbstractHaskell.Curry_Types.C_TypeExpr -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_tyVarsOf x1 cd cs = case x1 of
  AbstractHaskell.Curry_Types.C_TVar x2 -> Curry_Prelude.OP_Cons x2
    Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_FuncType x3 x4 -> Data.Curry_List.d_C_union
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen_hash_0_hash_hash_1_hash_hash
    Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Int_hash
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket_hash_0_hash_hash
    Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash))
    (d_C_tyVarsOf x3 cd cs) (d_C_tyVarsOf x4 cd cs) cd cs
  AbstractHaskell.Curry_Types.C_TCons x5 x6 -> Curry_Prelude.d_C_foldr (acceptCs
    id (Data.Curry_List.d_C_union
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen_hash_0_hash_hash_1_hash_hash
    Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Int_hash
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket_hash_0_hash_hash
    Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash))))
    Curry_Prelude.OP_List (Curry_Prelude.d_C_map d_C_tyVarsOf x6 cd cs) cd cs
  AbstractHaskell.Curry_Types.C_ForallType x7 x8 x9 -> Data.Curry_List.d_OP_backslash_backslash
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lparen_comma_rparen_hash_0_hash_hash_1_hash_hash
    Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Int_hash
    (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket_hash_0_hash_hash
    Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash))
    (d_C_tyVarsOf x9 cd cs) (Curry_Prelude.d_C_map Curry_Prelude.d_C_fst x7 cd
    cs) cd cs
  AbstractHaskell.Curry_Types.Choice_C_TypeExpr d i l r -> narrow d i
    (d_C_tyVarsOf l cd cs) (d_C_tyVarsOf r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_TypeExpr d i xs -> narrows cs d i (\z ->
    d_C_tyVarsOf z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_TypeExpr d c e -> guardCons d c ((\x ->
    d_C_tyVarsOf e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_TypeExpr d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.tyVarsOf" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.tyVarsOf" (showCons x1))

d_C_tfunc :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> AbstractHaskell.Curry_Types.C_Visibility
  -> AbstractHaskell.Curry_Types.C_TypeExpr -> Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_Rule -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_FuncDecl
d_C_tfunc x1 x2 x3 x4 x5 cd cs = AbstractHaskell.Curry_Types.C_Func
  Curry_Prelude.OP_List x1 x2 x3 (AbstractHaskell.Curry_Types.C_CType
  Curry_Prelude.OP_List x4) (AbstractHaskell.Curry_Types.C_Rules x5)

d_C_ctfunc :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> AbstractHaskell.Curry_Types.C_Visibility
  -> Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_Context
  -> AbstractHaskell.Curry_Types.C_TypeExpr -> Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_Rule -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_FuncDecl
d_C_ctfunc x1 x2 x3 x4 x5 x6 cd cs = AbstractHaskell.Curry_Types.C_Func
  Curry_Prelude.OP_List x1 x2 x3 (AbstractHaskell.Curry_Types.C_CType x4 x5)
  (AbstractHaskell.Curry_Types.C_Rules x6)

d_C_cmtfunc :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Int
  -> AbstractHaskell.Curry_Types.C_Visibility -> Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_Context
  -> AbstractHaskell.Curry_Types.C_TypeExpr -> Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_Rule -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_FuncDecl
d_C_cmtfunc x1 x2 x3 x4 x5 x6 x7 cd cs = AbstractHaskell.Curry_Types.C_Func x1
  x2 x3 x4 (AbstractHaskell.Curry_Types.C_CType x5 x6)
  (AbstractHaskell.Curry_Types.C_Rules x7)

d_C_funcDecls :: AbstractHaskell.Curry_Types.C_Prog -> Cover -> ConstStore
  -> Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_FuncDecl
d_C_funcDecls x1 cd cs = case x1 of
  AbstractHaskell.Curry_Types.C_Prog x2 x3 x4 x5 x6 -> x5
  AbstractHaskell.Curry_Types.Choice_C_Prog d i l r -> narrow d i (d_C_funcDecls
    l cd cs) (d_C_funcDecls r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Prog d i xs -> narrows cs d i (\z ->
    d_C_funcDecls z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Prog d c e -> guardCons d c ((\x ->
    d_C_funcDecls e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Prog d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.funcDecls" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.funcDecls" (showCons x1))

d_C_funcName :: AbstractHaskell.Curry_Types.C_FuncDecl -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_funcName x1 cd cs = case x1 of
  AbstractHaskell.Curry_Types.C_Func x2 x3 x4 x5 x6 x7 -> x3
  AbstractHaskell.Curry_Types.Choice_C_FuncDecl d i l r -> narrow d i
    (d_C_funcName l cd cs) (d_C_funcName r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_FuncDecl d i xs -> narrows cs d i (\z ->
    d_C_funcName z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_FuncDecl d c e -> guardCons d c ((\x ->
    d_C_funcName e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_FuncDecl d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.funcName" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.funcName" (showCons x1))

d_C_typeOf :: AbstractHaskell.Curry_Types.C_FuncDecl -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_TypeSig
d_C_typeOf x1 cd cs = case x1 of
  AbstractHaskell.Curry_Types.C_Func x2 x3 x4 x5 x6 x7 -> x6
  AbstractHaskell.Curry_Types.Choice_C_FuncDecl d i l r -> narrow d i
    (d_C_typeOf l cd cs) (d_C_typeOf r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_FuncDecl d i xs -> narrows cs d i (\z ->
    d_C_typeOf z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_FuncDecl d c e -> guardCons d c ((\x ->
    d_C_typeOf e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_FuncDecl d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.typeOf" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.typeOf" (showCons x1))

d_C_commentOf :: AbstractHaskell.Curry_Types.C_FuncDecl -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_commentOf x1 cd cs = case x1 of
  AbstractHaskell.Curry_Types.C_Func x2 x3 x4 x5 x6 x7 -> x2
  AbstractHaskell.Curry_Types.Choice_C_FuncDecl d i l r -> narrow d i
    (d_C_commentOf l cd cs) (d_C_commentOf r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_FuncDecl d i xs -> narrows cs d i (\z ->
    d_C_commentOf z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_FuncDecl d c e -> guardCons d c ((\x ->
    d_C_commentOf e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_FuncDecl d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.commentOf" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.commentOf" (showCons x1))

d_C_simpleRule :: Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_Pattern
  -> AbstractHaskell.Curry_Types.C_Expr -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_Rules
d_C_simpleRule x1 x2 cd cs = AbstractHaskell.Curry_Types.C_Rules
  (Curry_Prelude.OP_Cons (AbstractHaskell.Curry_Types.C_Rule x1
  (AbstractHaskell.Curry_Types.C_SimpleRhs x2) Curry_Prelude.OP_List)
  Curry_Prelude.OP_List)

d_C_applyF :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_Expr -> Cover
  -> ConstStore -> AbstractHaskell.Curry_Types.C_Expr
d_C_applyF x1 x2 cd cs = Curry_Prelude.d_C_foldl (acceptCs (acceptCs id)
  AbstractHaskell.Curry_Types.C_Apply) (AbstractHaskell.Curry_Types.C_Symbol x1)
  x2 cd cs

d_C_constF :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> AbstractHaskell.Curry_Types.C_Expr
d_C_constF x1 cd cs = d_C_applyF x1 Curry_Prelude.OP_List cd cs

d_C_applyV :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_Expr -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_Expr
d_C_applyV x1 x2 cd cs = Curry_Prelude.d_C_foldl (acceptCs (acceptCs id)
  AbstractHaskell.Curry_Types.C_Apply) (AbstractHaskell.Curry_Types.C_Var x1) x2
  cd cs

d_C_tuplePat :: Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_Pattern
  -> Cover -> ConstStore -> AbstractHaskell.Curry_Types.C_Pattern
d_C_tuplePat x1 cd cs = AbstractHaskell.Curry_Types.C_PTuple x1

d_C_tupleExpr :: Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_Expr
  -> Cover -> ConstStore -> AbstractHaskell.Curry_Types.C_Expr
d_C_tupleExpr x1 cd cs = AbstractHaskell.Curry_Types.C_Tuple x1

d_C_string2ac :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_Expr
d_C_string2ac cd cs = Curry_Prelude.d_OP_dot (acceptCs id
  AbstractHaskell.Curry_Types.C_Lit) (acceptCs id
  AbstractHaskell.Curry_Types.C_Stringc) cd cs

d_C_pre :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_pre x1 cd cs = Curry_Prelude.OP_Tuple2 (Curry_Prelude.toCurryString
  "Prelude") x1

d_C_cvar :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_Expr
d_C_cvar x1 cd cs = AbstractHaskell.Curry_Types.C_Var (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.C_Int (1)) x1)

d_C_clet :: Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_LocalDecl
  -> AbstractHaskell.Curry_Types.C_Expr -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_Expr
d_C_clet x1 x2 cd cs = d_C__case_0 x1 x2 (Curry_Prelude.d_C_null x1 cd cs) cd cs

d_C_list2ac :: Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_Expr -> Cover
  -> ConstStore -> AbstractHaskell.Curry_Types.C_Expr
d_C_list2ac x1 cd cs = AbstractHaskell.Curry_Types.C_List x1

d_C_declVar :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> AbstractHaskell.Curry_Types.C_Expr -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_LocalDecl
d_C_declVar x1 x2 cd cs = AbstractHaskell.Curry_Types.C_LocalPat
  (AbstractHaskell.Curry_Types.C_PVar x1) x2 Curry_Prelude.OP_List

d_C_renameSymbolInProg :: (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_Prog -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_Prog
d_C_renameSymbolInProg x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Prog x3 x4 x5 x6 x7 -> AbstractHaskell.Curry_Types.C_Prog
    (Curry_Prelude.d_C_fst (Curry_Prelude.d_C_apply x1 (Curry_Prelude.OP_Tuple2
    x3 Curry_Prelude.OP_List) cd cs) cd cs) (Curry_Prelude.d_C_map
    (d_OP_renameSymbolInProg_dot_uscore_hash_lambda1 x1) x4 cd cs)
    (Curry_Prelude.d_C_map (d_C_renameSymbolInTypeDecl x1) x5 cd cs)
    (Curry_Prelude.d_C_map (d_C_renameSymbolInFunc x1) x6 cd cs)
    (Curry_Prelude.d_C_map (d_C_renameOpDecl x1) x7 cd cs)
  AbstractHaskell.Curry_Types.Choice_C_Prog d i l r -> narrow d i
    (d_C_renameSymbolInProg x1 l cd cs) (d_C_renameSymbolInProg x1 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Prog d i xs -> narrows cs d i (\z ->
    d_C_renameSymbolInProg x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Prog d c e -> guardCons d c ((\x ->
    d_C_renameSymbolInProg x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Prog d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInProg" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInProg"
    (showCons x2))

nd_C_renameSymbolInProg :: Func (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_Prog -> IDSupply -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_Prog
nd_C_renameSymbolInProg x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Prog x3 x4 x5 x6 x7 -> let s5 = s
    in s5 `seq` (let s6 = leftSupply s5
                     s7 = rightSupply s5
                     s0 = leftSupply s6
                     s1 = rightSupply s6
                     s2 = leftSupply s7
                     s8 = rightSupply s7
                     s3 = leftSupply s8
                     s4 = rightSupply s8
    in s6 `seq` (s7 `seq` (s0 `seq` (s1 `seq` (s2 `seq` (s8 `seq` (s3 `seq`
    (s4 `seq` AbstractHaskell.Curry_Types.C_Prog (Curry_Prelude.d_C_fst
    (Curry_Prelude.nd_C_apply x1 (Curry_Prelude.OP_Tuple2 x3
    Curry_Prelude.OP_List) s0 cd cs) cd cs) (Curry_Prelude.nd_C_map (wrapNX id
    (nd_OP_renameSymbolInProg_dot_uscore_hash_lambda1 x1)) x4 s1 cd cs)
    (Curry_Prelude.nd_C_map (wrapNX id (nd_C_renameSymbolInTypeDecl x1)) x5 s2
    cd cs) (Curry_Prelude.nd_C_map (wrapNX id (nd_C_renameSymbolInFunc x1)) x6
    s3 cd cs) (Curry_Prelude.nd_C_map (wrapNX id (nd_C_renameOpDecl x1)) x7 s4
    cd cs)))))))))
  AbstractHaskell.Curry_Types.Choice_C_Prog d i l r -> narrow d i
    (nd_C_renameSymbolInProg x1 l s cd cs) (nd_C_renameSymbolInProg x1 r s cd
    cs)
  AbstractHaskell.Curry_Types.Choices_C_Prog d i xs -> narrows cs d i (\z ->
    nd_C_renameSymbolInProg x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Prog d c e -> guardCons d c ((\x ->
    nd_C_renameSymbolInProg x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Prog d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInProg" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInProg"
    (showCons x2))

d_OP_renameSymbolInProg_dot_uscore_hash_lambda1 :: (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_renameSymbolInProg_dot_uscore_hash_lambda1 x1 x2 cd cs =
  Curry_Prelude.d_OP_dollar Curry_Prelude.d_C_fst (Curry_Prelude.d_C_apply x1
  (Curry_Prelude.OP_Tuple2 x2 Curry_Prelude.OP_List) cd cs) cd cs

nd_OP_renameSymbolInProg_dot_uscore_hash_lambda1 :: Func
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> IDSupply -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
nd_OP_renameSymbolInProg_dot_uscore_hash_lambda1 x1 x2 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dollar (wrapDX id
  Curry_Prelude.d_C_fst) (Curry_Prelude.nd_C_apply x1 (Curry_Prelude.OP_Tuple2
  x2 Curry_Prelude.OP_List) s0 cd cs) s1 cd cs))

d_C_renameSymbolInTypeDecl :: (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_TypeDecl -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_TypeDecl
d_C_renameSymbolInTypeDecl x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Type x3 x4 x5 x6 -> AbstractHaskell.Curry_Types.C_Type
    (Curry_Prelude.d_C_apply x1 x3 cd cs) x4 x5 (Curry_Prelude.d_C_map
    (d_C_renameSymbolInConsDecl x1) x6 cd cs)
  AbstractHaskell.Curry_Types.C_TypeSyn x7 x8 x9 x10 -> AbstractHaskell.Curry_Types.C_TypeSyn
    (Curry_Prelude.d_C_apply x1 x7 cd cs) x8 x9 (d_C_renameSymbolInTypeExpr x1
    x10 cd cs)
  AbstractHaskell.Curry_Types.C_TypeNew x11 x12 x13 x14 -> AbstractHaskell.Curry_Types.C_TypeNew
    (Curry_Prelude.d_C_apply x1 x11 cd cs) x12 x13
    (d_C_renameSymbolInNewConsDecl x1 x14 cd cs)
  AbstractHaskell.Curry_Types.C_Instance x15 x16 x17 x18 -> AbstractHaskell.Curry_Types.C_Instance
    (Curry_Prelude.d_C_apply x1 x15 cd cs) (d_C_renameSymbolInTypeExpr x1 x16 cd
    cs) (Curry_Prelude.d_C_map (d_C_renameSymbolInContext x1) x17 cd cs)
    (Curry_Prelude.d_C_map
    (d_OP_renameSymbolInTypeDecl_dot_renameSymbolInInstRule_dot_101 x1) x18 cd
    cs)
  AbstractHaskell.Curry_Types.Choice_C_TypeDecl d i l r -> narrow d i
    (d_C_renameSymbolInTypeDecl x1 l cd cs) (d_C_renameSymbolInTypeDecl x1 r cd
    cs)
  AbstractHaskell.Curry_Types.Choices_C_TypeDecl d i xs -> narrows cs d i (\z ->
    d_C_renameSymbolInTypeDecl x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_TypeDecl d c e -> guardCons d c ((\x ->
    d_C_renameSymbolInTypeDecl x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_TypeDecl d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInTypeDecl" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInTypeDecl"
    (showCons x2))

nd_C_renameSymbolInTypeDecl :: Func (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_TypeDecl -> IDSupply -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_TypeDecl
nd_C_renameSymbolInTypeDecl x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Type x3 x4 x5 x6 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` AbstractHaskell.Curry_Types.C_Type
    (Curry_Prelude.nd_C_apply x1 x3 s0 cd cs) x4 x5 (Curry_Prelude.nd_C_map
    (wrapNX id (nd_C_renameSymbolInConsDecl x1)) x6 s1 cd cs)))
  AbstractHaskell.Curry_Types.C_TypeSyn x7 x8 x9 x10 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` AbstractHaskell.Curry_Types.C_TypeSyn
    (Curry_Prelude.nd_C_apply x1 x7 s0 cd cs) x8 x9 (nd_C_renameSymbolInTypeExpr
    x1 x10 s1 cd cs)))
  AbstractHaskell.Curry_Types.C_TypeNew x11 x12 x13 x14 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` AbstractHaskell.Curry_Types.C_TypeNew
    (Curry_Prelude.nd_C_apply x1 x11 s0 cd cs) x12 x13
    (nd_C_renameSymbolInNewConsDecl x1 x14 s1 cd cs)))
  AbstractHaskell.Curry_Types.C_Instance x15 x16 x17 x18 -> let s4 = s
    in s4 `seq` (let s5 = leftSupply s4
                     s6 = rightSupply s4
                     s0 = leftSupply s5
                     s1 = rightSupply s5
                     s2 = leftSupply s6
                     s3 = rightSupply s6
    in s5 `seq` (s6 `seq` (s0 `seq` (s1 `seq` (s2 `seq` (s3 `seq`
    AbstractHaskell.Curry_Types.C_Instance (Curry_Prelude.nd_C_apply x1 x15 s0
    cd cs) (nd_C_renameSymbolInTypeExpr x1 x16 s1 cd cs) (Curry_Prelude.nd_C_map
    (wrapNX id (nd_C_renameSymbolInContext x1)) x17 s2 cd cs)
    (Curry_Prelude.nd_C_map (wrapNX id
    (nd_OP_renameSymbolInTypeDecl_dot_renameSymbolInInstRule_dot_101 x1)) x18 s3
    cd cs)))))))
  AbstractHaskell.Curry_Types.Choice_C_TypeDecl d i l r -> narrow d i
    (nd_C_renameSymbolInTypeDecl x1 l s cd cs) (nd_C_renameSymbolInTypeDecl x1 r
    s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_TypeDecl d i xs -> narrows cs d i (\z ->
    nd_C_renameSymbolInTypeDecl x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_TypeDecl d c e -> guardCons d c ((\x ->
    nd_C_renameSymbolInTypeDecl x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_TypeDecl d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInTypeDecl" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInTypeDecl"
    (showCons x2))

d_OP_renameSymbolInTypeDecl_dot_renameSymbolInInstRule_dot_101 :: (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) AbstractHaskell.Curry_Types.C_Rule -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) AbstractHaskell.Curry_Types.C_Rule
d_OP_renameSymbolInTypeDecl_dot_renameSymbolInInstRule_dot_101 x1 x2 cd cs =
  case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> Curry_Prelude.OP_Tuple2
    (Curry_Prelude.d_C_apply x1 x3 cd cs) (d_C_renameSymbolInRule x1 x4 cd cs)
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_renameSymbolInTypeDecl_dot_renameSymbolInInstRule_dot_101 x1 l cd cs)
    (d_OP_renameSymbolInTypeDecl_dot_renameSymbolInInstRule_dot_101 x1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_renameSymbolInTypeDecl_dot_renameSymbolInInstRule_dot_101 x1 z cd cs)
    xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_renameSymbolInTypeDecl_dot_renameSymbolInInstRule_dot_101 x1 e cd x) $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInTypeDecl.renameSymbolInInstRule.101"
    [show x1, show x2] info)
  _ -> failCons cd (consFail
    "AbstractHaskell.Goodies.renameSymbolInTypeDecl.renameSymbolInInstRule.101"
    (showCons x2))

nd_OP_renameSymbolInTypeDecl_dot_renameSymbolInInstRule_dot_101 :: Func
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) AbstractHaskell.Curry_Types.C_Rule -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) AbstractHaskell.Curry_Types.C_Rule
nd_OP_renameSymbolInTypeDecl_dot_renameSymbolInInstRule_dot_101 x1 x2 s cd cs =
  case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` Curry_Prelude.OP_Tuple2 (Curry_Prelude.nd_C_apply x1
    x3 s0 cd cs) (nd_C_renameSymbolInRule x1 x4 s1 cd cs)))
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (nd_OP_renameSymbolInTypeDecl_dot_renameSymbolInInstRule_dot_101 x1 l s cd
    cs) (nd_OP_renameSymbolInTypeDecl_dot_renameSymbolInInstRule_dot_101 x1 r s
    cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    nd_OP_renameSymbolInTypeDecl_dot_renameSymbolInInstRule_dot_101 x1 z s cd
    cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    nd_OP_renameSymbolInTypeDecl_dot_renameSymbolInInstRule_dot_101 x1 e s cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInTypeDecl.renameSymbolInInstRule.101"
    [show x1, show x2] info)
  _ -> failCons cd (consFail
    "AbstractHaskell.Goodies.renameSymbolInTypeDecl.renameSymbolInInstRule.101"
    (showCons x2))

d_C_renameSymbolInConsDecl :: (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_ConsDecl -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_ConsDecl
d_C_renameSymbolInConsDecl x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Cons x3 x4 x5 x6 -> AbstractHaskell.Curry_Types.C_Cons
    (Curry_Prelude.d_C_apply x1 x3 cd cs) x4 x5 (Curry_Prelude.d_C_map
    (d_C_renameSymbolInTypeExpr x1) x6 cd cs)
  AbstractHaskell.Curry_Types.Choice_C_ConsDecl d i l r -> narrow d i
    (d_C_renameSymbolInConsDecl x1 l cd cs) (d_C_renameSymbolInConsDecl x1 r cd
    cs)
  AbstractHaskell.Curry_Types.Choices_C_ConsDecl d i xs -> narrows cs d i (\z ->
    d_C_renameSymbolInConsDecl x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_ConsDecl d c e -> guardCons d c ((\x ->
    d_C_renameSymbolInConsDecl x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_ConsDecl d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInConsDecl" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInConsDecl"
    (showCons x2))

nd_C_renameSymbolInConsDecl :: Func (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_ConsDecl -> IDSupply -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_ConsDecl
nd_C_renameSymbolInConsDecl x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Cons x3 x4 x5 x6 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` AbstractHaskell.Curry_Types.C_Cons
    (Curry_Prelude.nd_C_apply x1 x3 s0 cd cs) x4 x5 (Curry_Prelude.nd_C_map
    (wrapNX id (nd_C_renameSymbolInTypeExpr x1)) x6 s1 cd cs)))
  AbstractHaskell.Curry_Types.Choice_C_ConsDecl d i l r -> narrow d i
    (nd_C_renameSymbolInConsDecl x1 l s cd cs) (nd_C_renameSymbolInConsDecl x1 r
    s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_ConsDecl d i xs -> narrows cs d i (\z ->
    nd_C_renameSymbolInConsDecl x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_ConsDecl d c e -> guardCons d c ((\x ->
    nd_C_renameSymbolInConsDecl x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_ConsDecl d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInConsDecl" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInConsDecl"
    (showCons x2))

d_C_renameSymbolInNewConsDecl :: (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_NewConsDecl -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_NewConsDecl
d_C_renameSymbolInNewConsDecl x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_NewCons x3 x4 x5 -> Curry_Prelude.d_OP_dollar
    (acceptCs id (AbstractHaskell.Curry_Types.C_NewCons (Curry_Prelude.d_C_apply
    x1 x3 cd cs) x4)) (d_C_renameSymbolInTypeExpr x1 x5 cd cs) cd cs
  AbstractHaskell.Curry_Types.Choice_C_NewConsDecl d i l r -> narrow d i
    (d_C_renameSymbolInNewConsDecl x1 l cd cs) (d_C_renameSymbolInNewConsDecl x1
    r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_NewConsDecl d i xs -> narrows cs d i
    (\z -> d_C_renameSymbolInNewConsDecl x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_NewConsDecl d c e -> guardCons d c ((\x ->
    d_C_renameSymbolInNewConsDecl x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_NewConsDecl d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInNewConsDecl" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInNewConsDecl"
    (showCons x2))

nd_C_renameSymbolInNewConsDecl :: Func (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_NewConsDecl -> IDSupply -> Cover
  -> ConstStore -> AbstractHaskell.Curry_Types.C_NewConsDecl
nd_C_renameSymbolInNewConsDecl x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_NewCons x3 x4 x5 -> let s3 = s
    in s3 `seq` (let s2 = leftSupply s3
                     s4 = rightSupply s3
                     s0 = leftSupply s4
                     s1 = rightSupply s4
    in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` Curry_Prelude.nd_OP_dollar (wrapDX
    id (acceptCs id (AbstractHaskell.Curry_Types.C_NewCons
    (Curry_Prelude.nd_C_apply x1 x3 s0 cd cs) x4))) (nd_C_renameSymbolInTypeExpr
    x1 x5 s1 cd cs) s2 cd cs))))
  AbstractHaskell.Curry_Types.Choice_C_NewConsDecl d i l r -> narrow d i
    (nd_C_renameSymbolInNewConsDecl x1 l s cd cs)
    (nd_C_renameSymbolInNewConsDecl x1 r s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_NewConsDecl d i xs -> narrows cs d i
    (\z -> nd_C_renameSymbolInNewConsDecl x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_NewConsDecl d c e -> guardCons d c ((\x ->
    nd_C_renameSymbolInNewConsDecl x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_NewConsDecl d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInNewConsDecl" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInNewConsDecl"
    (showCons x2))

d_C_renameSymbolInTypeExpr :: (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_TypeExpr -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_TypeExpr
d_C_renameSymbolInTypeExpr x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_TCons x3 x4 -> AbstractHaskell.Curry_Types.C_TCons
    (Curry_Prelude.d_C_apply x1 x3 cd cs) (Curry_Prelude.d_C_map
    (d_C_renameSymbolInTypeExpr x1) x4 cd cs)
  AbstractHaskell.Curry_Types.C_FuncType x5 x6 -> AbstractHaskell.Curry_Types.C_FuncType
    (d_C_renameSymbolInTypeExpr x1 x5 cd cs) (d_C_renameSymbolInTypeExpr x1 x6
    cd cs)
  AbstractHaskell.Curry_Types.C_TVar x7 -> AbstractHaskell.Curry_Types.C_TVar x7
  AbstractHaskell.Curry_Types.C_ForallType x8 x9 x10 -> AbstractHaskell.Curry_Types.C_ForallType
    x8 (Curry_Prelude.d_C_map (d_C_renameSymbolInContext x1) x9 cd cs)
    (d_C_renameSymbolInTypeExpr x1 x10 cd cs)
  AbstractHaskell.Curry_Types.Choice_C_TypeExpr d i l r -> narrow d i
    (d_C_renameSymbolInTypeExpr x1 l cd cs) (d_C_renameSymbolInTypeExpr x1 r cd
    cs)
  AbstractHaskell.Curry_Types.Choices_C_TypeExpr d i xs -> narrows cs d i (\z ->
    d_C_renameSymbolInTypeExpr x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_TypeExpr d c e -> guardCons d c ((\x ->
    d_C_renameSymbolInTypeExpr x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_TypeExpr d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInTypeExpr" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInTypeExpr"
    (showCons x2))

nd_C_renameSymbolInTypeExpr :: Func (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_TypeExpr -> IDSupply -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_TypeExpr
nd_C_renameSymbolInTypeExpr x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_TCons x3 x4 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` AbstractHaskell.Curry_Types.C_TCons
    (Curry_Prelude.nd_C_apply x1 x3 s0 cd cs) (Curry_Prelude.nd_C_map (wrapNX id
    (nd_C_renameSymbolInTypeExpr x1)) x4 s1 cd cs)))
  AbstractHaskell.Curry_Types.C_FuncType x5 x6 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` AbstractHaskell.Curry_Types.C_FuncType
    (nd_C_renameSymbolInTypeExpr x1 x5 s0 cd cs) (nd_C_renameSymbolInTypeExpr x1
    x6 s1 cd cs)))
  AbstractHaskell.Curry_Types.C_TVar x7 -> AbstractHaskell.Curry_Types.C_TVar x7
  AbstractHaskell.Curry_Types.C_ForallType x8 x9 x10 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` AbstractHaskell.Curry_Types.C_ForallType x8
    (Curry_Prelude.nd_C_map (wrapNX id (nd_C_renameSymbolInContext x1)) x9 s0 cd
    cs) (nd_C_renameSymbolInTypeExpr x1 x10 s1 cd cs)))
  AbstractHaskell.Curry_Types.Choice_C_TypeExpr d i l r -> narrow d i
    (nd_C_renameSymbolInTypeExpr x1 l s cd cs) (nd_C_renameSymbolInTypeExpr x1 r
    s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_TypeExpr d i xs -> narrows cs d i (\z ->
    nd_C_renameSymbolInTypeExpr x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_TypeExpr d c e -> guardCons d c ((\x ->
    nd_C_renameSymbolInTypeExpr x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_TypeExpr d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInTypeExpr" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInTypeExpr"
    (showCons x2))

d_C_renameSymbolInExpr :: (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_Expr -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_Expr
d_C_renameSymbolInExpr x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Var x3 -> x2
  AbstractHaskell.Curry_Types.C_Lit x4 -> x2
  AbstractHaskell.Curry_Types.C_Symbol x5 -> AbstractHaskell.Curry_Types.C_Symbol
    (Curry_Prelude.d_C_apply x1 x5 cd cs)
  AbstractHaskell.Curry_Types.C_Apply x6 x7 -> AbstractHaskell.Curry_Types.C_Apply
    (d_C_renameSymbolInExpr x1 x6 cd cs) (d_C_renameSymbolInExpr x1 x7 cd cs)
  AbstractHaskell.Curry_Types.C_InfixApply x8 x9 x10 -> AbstractHaskell.Curry_Types.C_InfixApply
    (d_C_renameSymbolInExpr x1 x8 cd cs) (Curry_Prelude.d_C_apply x1 x9 cd cs)
    (d_C_renameSymbolInExpr x1 x10 cd cs)
  AbstractHaskell.Curry_Types.C_Lambda x11 x12 -> AbstractHaskell.Curry_Types.C_Lambda
    (Curry_Prelude.d_C_map (d_C_renameSymbolInPat x1) x11 cd cs)
    (d_C_renameSymbolInExpr x1 x12 cd cs)
  AbstractHaskell.Curry_Types.C_Let x13 x14 -> AbstractHaskell.Curry_Types.C_Let
    (Curry_Prelude.d_C_map (d_C_renameSymbolInLocal x1) x13 cd cs)
    (d_C_renameSymbolInExpr x1 x14 cd cs)
  AbstractHaskell.Curry_Types.C_DoExpr x15 -> AbstractHaskell.Curry_Types.C_DoExpr
    (Curry_Prelude.d_C_map (d_C_renameSymbolInStat x1) x15 cd cs)
  AbstractHaskell.Curry_Types.C_ListComp x16 x17 -> AbstractHaskell.Curry_Types.C_ListComp
    (d_C_renameSymbolInExpr x1 x16 cd cs) (Curry_Prelude.d_C_map
    (d_C_renameSymbolInStat x1) x17 cd cs)
  AbstractHaskell.Curry_Types.C_Case x18 x19 -> AbstractHaskell.Curry_Types.C_Case
    (d_C_renameSymbolInExpr x1 x18 cd cs) (Curry_Prelude.d_C_map
    (d_C_renameSymbolInBranch x1) x19 cd cs)
  AbstractHaskell.Curry_Types.C_Typed x20 x21 -> AbstractHaskell.Curry_Types.C_Typed
    (d_C_renameSymbolInExpr x1 x20 cd cs) x21
  AbstractHaskell.Curry_Types.C_IfThenElse x22 x23 x24 -> AbstractHaskell.Curry_Types.C_IfThenElse
    (d_C_renameSymbolInExpr x1 x22 cd cs) (d_C_renameSymbolInExpr x1 x23 cd cs)
    (d_C_renameSymbolInExpr x1 x24 cd cs)
  AbstractHaskell.Curry_Types.C_Tuple x25 -> AbstractHaskell.Curry_Types.C_Tuple
    (Curry_Prelude.d_C_map (d_C_renameSymbolInExpr x1) x25 cd cs)
  AbstractHaskell.Curry_Types.C_List x26 -> AbstractHaskell.Curry_Types.C_List
    (Curry_Prelude.d_C_map (d_C_renameSymbolInExpr x1) x26 cd cs)
  AbstractHaskell.Curry_Types.Choice_C_Expr d i l r -> narrow d i
    (d_C_renameSymbolInExpr x1 l cd cs) (d_C_renameSymbolInExpr x1 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Expr d i xs -> narrows cs d i (\z ->
    d_C_renameSymbolInExpr x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Expr d c e -> guardCons d c ((\x ->
    d_C_renameSymbolInExpr x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Expr d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInExpr" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInExpr"
    (showCons x2))

nd_C_renameSymbolInExpr :: Func (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_Expr -> IDSupply -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_Expr
nd_C_renameSymbolInExpr x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Var x3 -> x2
  AbstractHaskell.Curry_Types.C_Lit x4 -> x2
  AbstractHaskell.Curry_Types.C_Symbol x5 -> let s0 = s
    in s0 `seq` AbstractHaskell.Curry_Types.C_Symbol (Curry_Prelude.nd_C_apply
    x1 x5 s0 cd cs)
  AbstractHaskell.Curry_Types.C_Apply x6 x7 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` AbstractHaskell.Curry_Types.C_Apply
    (nd_C_renameSymbolInExpr x1 x6 s0 cd cs) (nd_C_renameSymbolInExpr x1 x7 s1
    cd cs)))
  AbstractHaskell.Curry_Types.C_InfixApply x8 x9 x10 -> let s3 = s
    in s3 `seq` (let s0 = leftSupply s3
                     s4 = rightSupply s3
                     s1 = leftSupply s4
                     s2 = rightSupply s4
    in s0 `seq` (s4 `seq` (s1 `seq` (s2 `seq`
    AbstractHaskell.Curry_Types.C_InfixApply (nd_C_renameSymbolInExpr x1 x8 s0
    cd cs) (Curry_Prelude.nd_C_apply x1 x9 s1 cd cs) (nd_C_renameSymbolInExpr x1
    x10 s2 cd cs)))))
  AbstractHaskell.Curry_Types.C_Lambda x11 x12 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` AbstractHaskell.Curry_Types.C_Lambda
    (Curry_Prelude.nd_C_map (wrapNX id (nd_C_renameSymbolInPat x1)) x11 s0 cd
    cs) (nd_C_renameSymbolInExpr x1 x12 s1 cd cs)))
  AbstractHaskell.Curry_Types.C_Let x13 x14 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` AbstractHaskell.Curry_Types.C_Let
    (Curry_Prelude.nd_C_map (wrapNX id (nd_C_renameSymbolInLocal x1)) x13 s0 cd
    cs) (nd_C_renameSymbolInExpr x1 x14 s1 cd cs)))
  AbstractHaskell.Curry_Types.C_DoExpr x15 -> let s0 = s
    in s0 `seq` AbstractHaskell.Curry_Types.C_DoExpr (Curry_Prelude.nd_C_map
    (wrapNX id (nd_C_renameSymbolInStat x1)) x15 s0 cd cs)
  AbstractHaskell.Curry_Types.C_ListComp x16 x17 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` AbstractHaskell.Curry_Types.C_ListComp
    (nd_C_renameSymbolInExpr x1 x16 s0 cd cs) (Curry_Prelude.nd_C_map (wrapNX id
    (nd_C_renameSymbolInStat x1)) x17 s1 cd cs)))
  AbstractHaskell.Curry_Types.C_Case x18 x19 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` AbstractHaskell.Curry_Types.C_Case
    (nd_C_renameSymbolInExpr x1 x18 s0 cd cs) (Curry_Prelude.nd_C_map (wrapNX id
    (nd_C_renameSymbolInBranch x1)) x19 s1 cd cs)))
  AbstractHaskell.Curry_Types.C_Typed x20 x21 -> let s0 = s
    in s0 `seq` AbstractHaskell.Curry_Types.C_Typed (nd_C_renameSymbolInExpr x1
    x20 s0 cd cs) x21
  AbstractHaskell.Curry_Types.C_IfThenElse x22 x23 x24 -> let s3 = s
    in s3 `seq` (let s0 = leftSupply s3
                     s4 = rightSupply s3
                     s1 = leftSupply s4
                     s2 = rightSupply s4
    in s0 `seq` (s4 `seq` (s1 `seq` (s2 `seq`
    AbstractHaskell.Curry_Types.C_IfThenElse (nd_C_renameSymbolInExpr x1 x22 s0
    cd cs) (nd_C_renameSymbolInExpr x1 x23 s1 cd cs) (nd_C_renameSymbolInExpr x1
    x24 s2 cd cs)))))
  AbstractHaskell.Curry_Types.C_Tuple x25 -> let s0 = s
    in s0 `seq` AbstractHaskell.Curry_Types.C_Tuple (Curry_Prelude.nd_C_map
    (wrapNX id (nd_C_renameSymbolInExpr x1)) x25 s0 cd cs)
  AbstractHaskell.Curry_Types.C_List x26 -> let s0 = s
    in s0 `seq` AbstractHaskell.Curry_Types.C_List (Curry_Prelude.nd_C_map
    (wrapNX id (nd_C_renameSymbolInExpr x1)) x26 s0 cd cs)
  AbstractHaskell.Curry_Types.Choice_C_Expr d i l r -> narrow d i
    (nd_C_renameSymbolInExpr x1 l s cd cs) (nd_C_renameSymbolInExpr x1 r s cd
    cs)
  AbstractHaskell.Curry_Types.Choices_C_Expr d i xs -> narrows cs d i (\z ->
    nd_C_renameSymbolInExpr x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Expr d c e -> guardCons d c ((\x ->
    nd_C_renameSymbolInExpr x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Expr d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInExpr" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInExpr"
    (showCons x2))

d_C_renameSymbolInPat :: (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_Pattern -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_Pattern
d_C_renameSymbolInPat x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_PComb x3 x4 -> AbstractHaskell.Curry_Types.C_PComb
    (Curry_Prelude.d_C_apply x1 x3 cd cs) (Curry_Prelude.d_C_map
    (d_C_renameSymbolInPat x1) x4 cd cs)
  AbstractHaskell.Curry_Types.C_PAs x5 x6 -> AbstractHaskell.Curry_Types.C_PAs
    x5 (d_C_renameSymbolInPat x1 x6 cd cs)
  AbstractHaskell.Curry_Types.C_PTuple x7 -> AbstractHaskell.Curry_Types.C_PTuple
    (Curry_Prelude.d_C_map (d_C_renameSymbolInPat x1) x7 cd cs)
  AbstractHaskell.Curry_Types.C_PList x8 -> AbstractHaskell.Curry_Types.C_PList
    (Curry_Prelude.d_C_map (d_C_renameSymbolInPat x1) x8 cd cs)
  AbstractHaskell.Curry_Types.C_PVar x9 -> x2
  AbstractHaskell.Curry_Types.C_PLit x10 -> x2
  AbstractHaskell.Curry_Types.Choice_C_Pattern d i l r -> narrow d i
    (d_C_renameSymbolInPat x1 l cd cs) (d_C_renameSymbolInPat x1 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Pattern d i xs -> narrows cs d i (\z ->
    d_C_renameSymbolInPat x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Pattern d c e -> guardCons d c ((\x ->
    d_C_renameSymbolInPat x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Pattern d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInPat" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInPat"
    (showCons x2))

nd_C_renameSymbolInPat :: Func (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_Pattern -> IDSupply -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_Pattern
nd_C_renameSymbolInPat x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_PComb x3 x4 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` AbstractHaskell.Curry_Types.C_PComb
    (Curry_Prelude.nd_C_apply x1 x3 s0 cd cs) (Curry_Prelude.nd_C_map (wrapNX id
    (nd_C_renameSymbolInPat x1)) x4 s1 cd cs)))
  AbstractHaskell.Curry_Types.C_PAs x5 x6 -> let s0 = s
    in s0 `seq` AbstractHaskell.Curry_Types.C_PAs x5 (nd_C_renameSymbolInPat x1
    x6 s0 cd cs)
  AbstractHaskell.Curry_Types.C_PTuple x7 -> let s0 = s
    in s0 `seq` AbstractHaskell.Curry_Types.C_PTuple (Curry_Prelude.nd_C_map
    (wrapNX id (nd_C_renameSymbolInPat x1)) x7 s0 cd cs)
  AbstractHaskell.Curry_Types.C_PList x8 -> let s0 = s
    in s0 `seq` AbstractHaskell.Curry_Types.C_PList (Curry_Prelude.nd_C_map
    (wrapNX id (nd_C_renameSymbolInPat x1)) x8 s0 cd cs)
  AbstractHaskell.Curry_Types.C_PVar x9 -> x2
  AbstractHaskell.Curry_Types.C_PLit x10 -> x2
  AbstractHaskell.Curry_Types.Choice_C_Pattern d i l r -> narrow d i
    (nd_C_renameSymbolInPat x1 l s cd cs) (nd_C_renameSymbolInPat x1 r s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Pattern d i xs -> narrows cs d i (\z ->
    nd_C_renameSymbolInPat x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Pattern d c e -> guardCons d c ((\x ->
    nd_C_renameSymbolInPat x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Pattern d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInPat" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInPat"
    (showCons x2))

d_C_renameSymbolInBranch :: (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_BranchExpr -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_BranchExpr
d_C_renameSymbolInBranch x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Branch x3 x4 -> AbstractHaskell.Curry_Types.C_Branch
    (d_C_renameSymbolInPat x1 x3 cd cs) (d_C_renameSymbolInExpr x1 x4 cd cs)
  AbstractHaskell.Curry_Types.Choice_C_BranchExpr d i l r -> narrow d i
    (d_C_renameSymbolInBranch x1 l cd cs) (d_C_renameSymbolInBranch x1 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_BranchExpr d i xs -> narrows cs d i
    (\z -> d_C_renameSymbolInBranch x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_BranchExpr d c e -> guardCons d c ((\x ->
    d_C_renameSymbolInBranch x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_BranchExpr d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInBranch" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInBranch"
    (showCons x2))

nd_C_renameSymbolInBranch :: Func (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_BranchExpr -> IDSupply -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_BranchExpr
nd_C_renameSymbolInBranch x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Branch x3 x4 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` AbstractHaskell.Curry_Types.C_Branch
    (nd_C_renameSymbolInPat x1 x3 s0 cd cs) (nd_C_renameSymbolInExpr x1 x4 s1 cd
    cs)))
  AbstractHaskell.Curry_Types.Choice_C_BranchExpr d i l r -> narrow d i
    (nd_C_renameSymbolInBranch x1 l s cd cs) (nd_C_renameSymbolInBranch x1 r s
    cd cs)
  AbstractHaskell.Curry_Types.Choices_C_BranchExpr d i xs -> narrows cs d i
    (\z -> nd_C_renameSymbolInBranch x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_BranchExpr d c e -> guardCons d c ((\x ->
    nd_C_renameSymbolInBranch x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_BranchExpr d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInBranch" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInBranch"
    (showCons x2))

d_C_renameSymbolInStat :: (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_Statement -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_Statement
d_C_renameSymbolInStat x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_SExpr x3 -> AbstractHaskell.Curry_Types.C_SExpr
    (d_C_renameSymbolInExpr x1 x3 cd cs)
  AbstractHaskell.Curry_Types.C_SPat x4 x5 -> AbstractHaskell.Curry_Types.C_SPat
    (d_C_renameSymbolInPat x1 x4 cd cs) (d_C_renameSymbolInExpr x1 x5 cd cs)
  AbstractHaskell.Curry_Types.C_SLet x6 -> AbstractHaskell.Curry_Types.C_SLet
    (Curry_Prelude.d_C_map (d_C_renameSymbolInLocal x1) x6 cd cs)
  AbstractHaskell.Curry_Types.Choice_C_Statement d i l r -> narrow d i
    (d_C_renameSymbolInStat x1 l cd cs) (d_C_renameSymbolInStat x1 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Statement d i xs -> narrows cs d i
    (\z -> d_C_renameSymbolInStat x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Statement d c e -> guardCons d c ((\x ->
    d_C_renameSymbolInStat x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Statement d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInStat" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInStat"
    (showCons x2))

nd_C_renameSymbolInStat :: Func (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_Statement -> IDSupply -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_Statement
nd_C_renameSymbolInStat x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_SExpr x3 -> let s0 = s
    in s0 `seq` AbstractHaskell.Curry_Types.C_SExpr (nd_C_renameSymbolInExpr x1
    x3 s0 cd cs)
  AbstractHaskell.Curry_Types.C_SPat x4 x5 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` AbstractHaskell.Curry_Types.C_SPat
    (nd_C_renameSymbolInPat x1 x4 s0 cd cs) (nd_C_renameSymbolInExpr x1 x5 s1 cd
    cs)))
  AbstractHaskell.Curry_Types.C_SLet x6 -> let s0 = s
    in s0 `seq` AbstractHaskell.Curry_Types.C_SLet (Curry_Prelude.nd_C_map
    (wrapNX id (nd_C_renameSymbolInLocal x1)) x6 s0 cd cs)
  AbstractHaskell.Curry_Types.Choice_C_Statement d i l r -> narrow d i
    (nd_C_renameSymbolInStat x1 l s cd cs) (nd_C_renameSymbolInStat x1 r s cd
    cs)
  AbstractHaskell.Curry_Types.Choices_C_Statement d i xs -> narrows cs d i
    (\z -> nd_C_renameSymbolInStat x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Statement d c e -> guardCons d c ((\x ->
    nd_C_renameSymbolInStat x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Statement d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInStat" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInStat"
    (showCons x2))

d_C_renameSymbolInLocal :: (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_LocalDecl -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_LocalDecl
d_C_renameSymbolInLocal x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_LocalFunc x3 -> AbstractHaskell.Curry_Types.C_LocalFunc
    (d_C_renameSymbolInFunc x1 x3 cd cs)
  AbstractHaskell.Curry_Types.C_LocalPat x4 x5 x6 -> AbstractHaskell.Curry_Types.C_LocalPat
    (d_C_renameSymbolInPat x1 x4 cd cs) (d_C_renameSymbolInExpr x1 x5 cd cs)
    (Curry_Prelude.d_C_map (d_C_renameSymbolInLocal x1) x6 cd cs)
  AbstractHaskell.Curry_Types.Choice_C_LocalDecl d i l r -> narrow d i
    (d_C_renameSymbolInLocal x1 l cd cs) (d_C_renameSymbolInLocal x1 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_LocalDecl d i xs -> narrows cs d i
    (\z -> d_C_renameSymbolInLocal x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_LocalDecl d c e -> guardCons d c ((\x ->
    d_C_renameSymbolInLocal x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_LocalDecl d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInLocal" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInLocal"
    (showCons x2))

nd_C_renameSymbolInLocal :: Func (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_LocalDecl -> IDSupply -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_LocalDecl
nd_C_renameSymbolInLocal x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_LocalFunc x3 -> let s0 = s
    in s0 `seq` AbstractHaskell.Curry_Types.C_LocalFunc (nd_C_renameSymbolInFunc
    x1 x3 s0 cd cs)
  AbstractHaskell.Curry_Types.C_LocalPat x4 x5 x6 -> let s3 = s
    in s3 `seq` (let s0 = leftSupply s3
                     s4 = rightSupply s3
                     s1 = leftSupply s4
                     s2 = rightSupply s4
    in s0 `seq` (s4 `seq` (s1 `seq` (s2 `seq`
    AbstractHaskell.Curry_Types.C_LocalPat (nd_C_renameSymbolInPat x1 x4 s0 cd
    cs) (nd_C_renameSymbolInExpr x1 x5 s1 cd cs) (Curry_Prelude.nd_C_map (wrapNX
    id (nd_C_renameSymbolInLocal x1)) x6 s2 cd cs)))))
  AbstractHaskell.Curry_Types.Choice_C_LocalDecl d i l r -> narrow d i
    (nd_C_renameSymbolInLocal x1 l s cd cs) (nd_C_renameSymbolInLocal x1 r s cd
    cs)
  AbstractHaskell.Curry_Types.Choices_C_LocalDecl d i xs -> narrows cs d i
    (\z -> nd_C_renameSymbolInLocal x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_LocalDecl d c e -> guardCons d c ((\x ->
    nd_C_renameSymbolInLocal x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_LocalDecl d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInLocal" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInLocal"
    (showCons x2))

d_C_renameSymbolInTypeSig :: (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_TypeSig -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_TypeSig
d_C_renameSymbolInTypeSig x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Untyped -> AbstractHaskell.Curry_Types.C_Untyped
  AbstractHaskell.Curry_Types.C_CType x3 x4 -> AbstractHaskell.Curry_Types.C_CType
    (Curry_Prelude.d_C_map (d_C_renameSymbolInContext x1) x3 cd cs)
    (d_C_renameSymbolInTypeExpr x1 x4 cd cs)
  AbstractHaskell.Curry_Types.Choice_C_TypeSig d i l r -> narrow d i
    (d_C_renameSymbolInTypeSig x1 l cd cs) (d_C_renameSymbolInTypeSig x1 r cd
    cs)
  AbstractHaskell.Curry_Types.Choices_C_TypeSig d i xs -> narrows cs d i (\z ->
    d_C_renameSymbolInTypeSig x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_TypeSig d c e -> guardCons d c ((\x ->
    d_C_renameSymbolInTypeSig x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_TypeSig d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInTypeSig" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInTypeSig"
    (showCons x2))

nd_C_renameSymbolInTypeSig :: Func (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_TypeSig -> IDSupply -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_TypeSig
nd_C_renameSymbolInTypeSig x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Untyped -> AbstractHaskell.Curry_Types.C_Untyped
  AbstractHaskell.Curry_Types.C_CType x3 x4 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` AbstractHaskell.Curry_Types.C_CType
    (Curry_Prelude.nd_C_map (wrapNX id (nd_C_renameSymbolInContext x1)) x3 s0 cd
    cs) (nd_C_renameSymbolInTypeExpr x1 x4 s1 cd cs)))
  AbstractHaskell.Curry_Types.Choice_C_TypeSig d i l r -> narrow d i
    (nd_C_renameSymbolInTypeSig x1 l s cd cs) (nd_C_renameSymbolInTypeSig x1 r s
    cd cs)
  AbstractHaskell.Curry_Types.Choices_C_TypeSig d i xs -> narrows cs d i (\z ->
    nd_C_renameSymbolInTypeSig x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_TypeSig d c e -> guardCons d c ((\x ->
    nd_C_renameSymbolInTypeSig x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_TypeSig d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInTypeSig" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInTypeSig"
    (showCons x2))

d_C_renameSymbolInContext :: (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_Context -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_Context
d_C_renameSymbolInContext x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Context x3 x4 x5 x6 -> AbstractHaskell.Curry_Types.C_Context
    x3 x4 (Curry_Prelude.d_C_apply x1 x5 cd cs) (Curry_Prelude.d_C_map
    (d_C_renameSymbolInTypeExpr x1) x6 cd cs)
  AbstractHaskell.Curry_Types.Choice_C_Context d i l r -> narrow d i
    (d_C_renameSymbolInContext x1 l cd cs) (d_C_renameSymbolInContext x1 r cd
    cs)
  AbstractHaskell.Curry_Types.Choices_C_Context d i xs -> narrows cs d i (\z ->
    d_C_renameSymbolInContext x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Context d c e -> guardCons d c ((\x ->
    d_C_renameSymbolInContext x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Context d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInContext" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInContext"
    (showCons x2))

nd_C_renameSymbolInContext :: Func (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_Context -> IDSupply -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_Context
nd_C_renameSymbolInContext x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Context x3 x4 x5 x6 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` AbstractHaskell.Curry_Types.C_Context x3 x4
    (Curry_Prelude.nd_C_apply x1 x5 s0 cd cs) (Curry_Prelude.nd_C_map (wrapNX id
    (nd_C_renameSymbolInTypeExpr x1)) x6 s1 cd cs)))
  AbstractHaskell.Curry_Types.Choice_C_Context d i l r -> narrow d i
    (nd_C_renameSymbolInContext x1 l s cd cs) (nd_C_renameSymbolInContext x1 r s
    cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Context d i xs -> narrows cs d i (\z ->
    nd_C_renameSymbolInContext x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Context d c e -> guardCons d c ((\x ->
    nd_C_renameSymbolInContext x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Context d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInContext" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInContext"
    (showCons x2))

d_C_renameSymbolInFunc :: (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_FuncDecl -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_FuncDecl
d_C_renameSymbolInFunc x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Func x3 x4 x5 x6 x7 x8 -> AbstractHaskell.Curry_Types.C_Func
    x3 (Curry_Prelude.d_C_apply x1 x4 cd cs) x5 x6 (d_C_renameSymbolInTypeSig x1
    x7 cd cs) (d_C_renameSymbolInRules x1 x8 cd cs)
  AbstractHaskell.Curry_Types.Choice_C_FuncDecl d i l r -> narrow d i
    (d_C_renameSymbolInFunc x1 l cd cs) (d_C_renameSymbolInFunc x1 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_FuncDecl d i xs -> narrows cs d i (\z ->
    d_C_renameSymbolInFunc x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_FuncDecl d c e -> guardCons d c ((\x ->
    d_C_renameSymbolInFunc x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_FuncDecl d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInFunc" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInFunc"
    (showCons x2))

nd_C_renameSymbolInFunc :: Func (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_FuncDecl -> IDSupply -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_FuncDecl
nd_C_renameSymbolInFunc x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Func x3 x4 x5 x6 x7 x8 -> let s3 = s
    in s3 `seq` (let s0 = leftSupply s3
                     s4 = rightSupply s3
                     s1 = leftSupply s4
                     s2 = rightSupply s4
    in s0 `seq` (s4 `seq` (s1 `seq` (s2 `seq` AbstractHaskell.Curry_Types.C_Func
    x3 (Curry_Prelude.nd_C_apply x1 x4 s0 cd cs) x5 x6
    (nd_C_renameSymbolInTypeSig x1 x7 s1 cd cs) (nd_C_renameSymbolInRules x1 x8
    s2 cd cs)))))
  AbstractHaskell.Curry_Types.Choice_C_FuncDecl d i l r -> narrow d i
    (nd_C_renameSymbolInFunc x1 l s cd cs) (nd_C_renameSymbolInFunc x1 r s cd
    cs)
  AbstractHaskell.Curry_Types.Choices_C_FuncDecl d i xs -> narrows cs d i (\z ->
    nd_C_renameSymbolInFunc x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_FuncDecl d c e -> guardCons d c ((\x ->
    nd_C_renameSymbolInFunc x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_FuncDecl d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInFunc" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInFunc"
    (showCons x2))

d_C_renameSymbolInRules :: (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_Rules -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_Rules
d_C_renameSymbolInRules x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Rules x3 -> AbstractHaskell.Curry_Types.C_Rules
    (Curry_Prelude.d_C_map (d_C_renameSymbolInRule x1) x3 cd cs)
  AbstractHaskell.Curry_Types.C_External -> AbstractHaskell.Curry_Types.C_External
  AbstractHaskell.Curry_Types.Choice_C_Rules d i l r -> narrow d i
    (d_C_renameSymbolInRules x1 l cd cs) (d_C_renameSymbolInRules x1 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Rules d i xs -> narrows cs d i (\z ->
    d_C_renameSymbolInRules x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Rules d c e -> guardCons d c ((\x ->
    d_C_renameSymbolInRules x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Rules d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInRules" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInRules"
    (showCons x2))

nd_C_renameSymbolInRules :: Func (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_Rules -> IDSupply -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_Rules
nd_C_renameSymbolInRules x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Rules x3 -> let s0 = s
    in s0 `seq` AbstractHaskell.Curry_Types.C_Rules (Curry_Prelude.nd_C_map
    (wrapNX id (nd_C_renameSymbolInRule x1)) x3 s0 cd cs)
  AbstractHaskell.Curry_Types.C_External -> AbstractHaskell.Curry_Types.C_External
  AbstractHaskell.Curry_Types.Choice_C_Rules d i l r -> narrow d i
    (nd_C_renameSymbolInRules x1 l s cd cs) (nd_C_renameSymbolInRules x1 r s cd
    cs)
  AbstractHaskell.Curry_Types.Choices_C_Rules d i xs -> narrows cs d i (\z ->
    nd_C_renameSymbolInRules x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Rules d c e -> guardCons d c ((\x ->
    nd_C_renameSymbolInRules x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Rules d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInRules" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInRules"
    (showCons x2))

d_C_renameSymbolInRule :: (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_Rule -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_Rule
d_C_renameSymbolInRule x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Rule x3 x4 x5 -> AbstractHaskell.Curry_Types.C_Rule
    (Curry_Prelude.d_C_map (d_C_renameSymbolInPat x1) x3 cd cs)
    (d_C_renameSymbolInRhs x1 x4 cd cs) (Curry_Prelude.d_C_map
    (d_C_renameSymbolInLocal x1) x5 cd cs)
  AbstractHaskell.Curry_Types.Choice_C_Rule d i l r -> narrow d i
    (d_C_renameSymbolInRule x1 l cd cs) (d_C_renameSymbolInRule x1 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Rule d i xs -> narrows cs d i (\z ->
    d_C_renameSymbolInRule x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Rule d c e -> guardCons d c ((\x ->
    d_C_renameSymbolInRule x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Rule d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInRule" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInRule"
    (showCons x2))

nd_C_renameSymbolInRule :: Func (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_Rule -> IDSupply -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_Rule
nd_C_renameSymbolInRule x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Rule x3 x4 x5 -> let s3 = s
    in s3 `seq` (let s0 = leftSupply s3
                     s4 = rightSupply s3
                     s1 = leftSupply s4
                     s2 = rightSupply s4
    in s0 `seq` (s4 `seq` (s1 `seq` (s2 `seq` AbstractHaskell.Curry_Types.C_Rule
    (Curry_Prelude.nd_C_map (wrapNX id (nd_C_renameSymbolInPat x1)) x3 s0 cd cs)
    (nd_C_renameSymbolInRhs x1 x4 s1 cd cs) (Curry_Prelude.nd_C_map (wrapNX id
    (nd_C_renameSymbolInLocal x1)) x5 s2 cd cs)))))
  AbstractHaskell.Curry_Types.Choice_C_Rule d i l r -> narrow d i
    (nd_C_renameSymbolInRule x1 l s cd cs) (nd_C_renameSymbolInRule x1 r s cd
    cs)
  AbstractHaskell.Curry_Types.Choices_C_Rule d i xs -> narrows cs d i (\z ->
    nd_C_renameSymbolInRule x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Rule d c e -> guardCons d c ((\x ->
    nd_C_renameSymbolInRule x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Rule d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInRule" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInRule"
    (showCons x2))

d_C_renameSymbolInRhs :: (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_Rhs -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_Rhs
d_C_renameSymbolInRhs x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_SimpleRhs x3 -> AbstractHaskell.Curry_Types.C_SimpleRhs
    (d_C_renameSymbolInExpr x1 x3 cd cs)
  AbstractHaskell.Curry_Types.C_GuardedRhs x4 -> Curry_Prelude.d_OP_dollar
    (acceptCs id AbstractHaskell.Curry_Types.C_GuardedRhs)
    (Curry_Prelude.d_C_map (d_OP_renameSymbolInRhs_dot_uscore_hash_lambda8 x1)
    x4 cd cs) cd cs
  AbstractHaskell.Curry_Types.Choice_C_Rhs d i l r -> narrow d i
    (d_C_renameSymbolInRhs x1 l cd cs) (d_C_renameSymbolInRhs x1 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Rhs d i xs -> narrows cs d i (\z ->
    d_C_renameSymbolInRhs x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Rhs d c e -> guardCons d c ((\x ->
    d_C_renameSymbolInRhs x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Rhs d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInRhs" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInRhs"
    (showCons x2))

nd_C_renameSymbolInRhs :: Func (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_Rhs -> IDSupply -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_Rhs
nd_C_renameSymbolInRhs x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_SimpleRhs x3 -> let s0 = s
    in s0 `seq` AbstractHaskell.Curry_Types.C_SimpleRhs (nd_C_renameSymbolInExpr
    x1 x3 s0 cd cs)
  AbstractHaskell.Curry_Types.C_GuardedRhs x4 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dollar (wrapDX id (acceptCs id
    AbstractHaskell.Curry_Types.C_GuardedRhs)) (Curry_Prelude.nd_C_map (wrapNX
    id (nd_OP_renameSymbolInRhs_dot_uscore_hash_lambda8 x1)) x4 s0 cd cs) s1 cd
    cs))
  AbstractHaskell.Curry_Types.Choice_C_Rhs d i l r -> narrow d i
    (nd_C_renameSymbolInRhs x1 l s cd cs) (nd_C_renameSymbolInRhs x1 r s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Rhs d i xs -> narrows cs d i (\z ->
    nd_C_renameSymbolInRhs x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Rhs d c e -> guardCons d c ((\x ->
    nd_C_renameSymbolInRhs x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Rhs d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInRhs" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameSymbolInRhs"
    (showCons x2))

d_OP_renameSymbolInRhs_dot_uscore_hash_lambda8 :: (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.OP_Tuple2
  AbstractHaskell.Curry_Types.C_Expr AbstractHaskell.Curry_Types.C_Expr -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 AbstractHaskell.Curry_Types.C_Expr
  AbstractHaskell.Curry_Types.C_Expr
d_OP_renameSymbolInRhs_dot_uscore_hash_lambda8 x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> Curry_Prelude.OP_Tuple2
    (d_C_renameSymbolInExpr x1 x3 cd cs) (d_C_renameSymbolInExpr x1 x4 cd cs)
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_renameSymbolInRhs_dot_uscore_hash_lambda8 x1 l cd cs)
    (d_OP_renameSymbolInRhs_dot_uscore_hash_lambda8 x1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_renameSymbolInRhs_dot_uscore_hash_lambda8 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_renameSymbolInRhs_dot_uscore_hash_lambda8 x1 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInRhs._#lambda8" [show x1, show x2]
    info)
  _ -> failCons cd (consFail
    "AbstractHaskell.Goodies.renameSymbolInRhs._#lambda8" (showCons x2))

nd_OP_renameSymbolInRhs_dot_uscore_hash_lambda8 :: Func (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Curry_Prelude.OP_Tuple2 AbstractHaskell.Curry_Types.C_Expr
  AbstractHaskell.Curry_Types.C_Expr -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 AbstractHaskell.Curry_Types.C_Expr
  AbstractHaskell.Curry_Types.C_Expr
nd_OP_renameSymbolInRhs_dot_uscore_hash_lambda8 x1 x2 s cd cs = case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> let s2 = s
    in s2 `seq` (let s0 = leftSupply s2
                     s1 = rightSupply s2
    in s0 `seq` (s1 `seq` Curry_Prelude.OP_Tuple2 (nd_C_renameSymbolInExpr x1 x3
    s0 cd cs) (nd_C_renameSymbolInExpr x1 x4 s1 cd cs)))
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (nd_OP_renameSymbolInRhs_dot_uscore_hash_lambda8 x1 l s cd cs)
    (nd_OP_renameSymbolInRhs_dot_uscore_hash_lambda8 x1 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    nd_OP_renameSymbolInRhs_dot_uscore_hash_lambda8 x1 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    nd_OP_renameSymbolInRhs_dot_uscore_hash_lambda8 x1 e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameSymbolInRhs._#lambda8" [show x1, show x2]
    info)
  _ -> failCons cd (consFail
    "AbstractHaskell.Goodies.renameSymbolInRhs._#lambda8" (showCons x2))

d_C_renameOpDecl :: (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_OpDecl -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_OpDecl
d_C_renameOpDecl x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Op x3 x4 x5 -> AbstractHaskell.Curry_Types.C_Op
    (Curry_Prelude.d_C_apply x1 x3 cd cs) x4 x5
  AbstractHaskell.Curry_Types.Choice_C_OpDecl d i l r -> narrow d i
    (d_C_renameOpDecl x1 l cd cs) (d_C_renameOpDecl x1 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_OpDecl d i xs -> narrows cs d i (\z ->
    d_C_renameOpDecl x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_OpDecl d c e -> guardCons d c ((\x ->
    d_C_renameOpDecl x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_OpDecl d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameOpDecl" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameOpDecl" (showCons
    x2))

nd_C_renameOpDecl :: Func (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> AbstractHaskell.Curry_Types.C_OpDecl -> IDSupply -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_OpDecl
nd_C_renameOpDecl x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Op x3 x4 x5 -> let s0 = s
    in s0 `seq` AbstractHaskell.Curry_Types.C_Op (Curry_Prelude.nd_C_apply x1 x3
    s0 cd cs) x4 x5
  AbstractHaskell.Curry_Types.Choice_C_OpDecl d i l r -> narrow d i
    (nd_C_renameOpDecl x1 l s cd cs) (nd_C_renameOpDecl x1 r s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_OpDecl d i xs -> narrows cs d i (\z ->
    nd_C_renameOpDecl x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_OpDecl d c e -> guardCons d c ((\x ->
    nd_C_renameOpDecl x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_OpDecl d info -> failCons d (traceFail
    "AbstractHaskell.Goodies.renameOpDecl" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies.renameOpDecl" (showCons
    x2))

d_C__case_5 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_5 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> d_C_pre (Curry_Prelude.OP_Cons (Curry_Prelude.C_Char
    '('#) (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.d_C_replicate
    (Curry_Prelude.d_OP_uscore_impl_hash_minus_hash_Prelude_dot_Num_hash_Prelude_dot_Int_hash
    x1 (Curry_Prelude.C_Int (1)) cd cs) (Curry_Prelude.C_Char ','#) cd cs)
    (Curry_Prelude.toCurryString ")") cd cs)) cd cs
  Curry_Prelude.C_False -> d_C__case_4 x1 (Curry_Prelude.d_C_otherwise cd cs) cd
    cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_5 x1 l cd cs)
    (d_C__case_5 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_5 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_5 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Goodies._case_5" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies._case_5" (showCons x2))

d_C__case_4 :: Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_4 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_dollar Curry_Prelude.d_C_error
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString
    "tupleName: illegal arity ") (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Int_hash
    cd cs) x1 cd cs) cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_4 x1 l cd cs)
    (d_C__case_4 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_4 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_4 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Goodies._case_4" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies._case_4" (showCons x2))

d_C__case_3 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_TypeExpr -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> AbstractHaskell.Curry_Types.C_TypeExpr
d_C__case_3 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> d_C_baseType (d_C_pre (Curry_Prelude.toCurryString
    "()") cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_2 x2 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int_hash
    x2 (Curry_Prelude.C_Int (1)) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_3 x2 x1 l cd cs)
    (d_C__case_3 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_3 x2 x1
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_3 x2 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Goodies._case_3" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies._case_3" (showCons x3))

d_C__case_2 :: Curry_Prelude.C_Int -> Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_TypeExpr -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> AbstractHaskell.Curry_Types.C_TypeExpr
d_C__case_2 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_head x1 cd cs
  Curry_Prelude.C_False -> d_C__case_1 x1 x2 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_2 x2 x1 l cd cs)
    (d_C__case_2 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_2 x2 x1
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_2 x2 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Goodies._case_2" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies._case_2" (showCons x3))

d_C__case_1 :: Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_TypeExpr
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_TypeExpr
d_C__case_1 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> AbstractHaskell.Curry_Types.C_TCons (d_C_tupleName x2
    cd cs) x1
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_1 x1 x2 l cd cs)
    (d_C__case_1 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_1 x1 x2
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_1 x1 x2 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Goodies._case_1" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies._case_1" (showCons x3))

d_C__case_0 :: Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_LocalDecl
  -> AbstractHaskell.Curry_Types.C_Expr -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> AbstractHaskell.Curry_Types.C_Expr
d_C__case_0 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> x2
  Curry_Prelude.C_False -> AbstractHaskell.Curry_Types.C_Let x1 x2
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_0 x1 x2 l cd cs)
    (d_C__case_0 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_0 x1 x2
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_0 x1 x2 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Goodies._case_0" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Goodies._case_0" (showCons x3))

