{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE QuantifiedConstraints #-}
{-# LANGUAGE RankNTypes #-}
{-# LANGUAGE PolyKinds #-}
{-# LANGUAGE MultiParamTypeClasses #-}
{-# LANGUAGE FlexibleInstances #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module AbstractHaskell.Curry_Printer
  ( C_Options (..)
  , d_C_currentModule
  , nd_C_currentModule
  , d_C_qualImpModule
  , nd_C_qualImpModule
  , d_C_traceFailure
  , nd_C_traceFailure
  , d_C_kics2Mode
  , nd_C_kics2Mode
  , d_C_defaultOptions
  , nd_C_defaultOptions
  , d_C_pPrint
  , nd_C_pPrint
  , d_C_ppProg
  , nd_C_ppProg
  , d_C_ppHeader
  , nd_C_ppHeader
  , d_C_ppDecls
  , nd_C_ppDecls
  , d_C_ppImports
  , nd_C_ppImports )
  where

import Basics
import qualified AbstractHaskell.Curry_Goodies
import qualified AbstractHaskell.Curry_Types
import qualified Data.Curry_List
import qualified Curry_Prelude
import qualified Text.Curry_Pretty
import qualified Text.Curry_PrettyImpl


data C_Options
  = C_Options (Curry_Prelude.OP_List Curry_Prelude.C_Char)
    (Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
    -> Curry_Prelude.C_Bool) Curry_Prelude.C_Bool Curry_Prelude.C_Bool
  | HO_C_Options (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Func
    (Curry_Prelude.OP_List Curry_Prelude.C_Char) Curry_Prelude.C_Bool)
    Curry_Prelude.C_Bool Curry_Prelude.C_Bool
  | Choice_C_Options Cover ID C_Options C_Options
  | Choices_C_Options Cover ID [C_Options]
  | Fail_C_Options Cover FailInfo
  | Guard_C_Options Cover Constraints C_Options

instance Show C_Options where
  showsPrec d (Choice_C_Options cd i x y) = showsChoice d cd i x y
  showsPrec d (Choices_C_Options cd i xs) = showsChoices d cd i xs
  showsPrec d (Guard_C_Options cd c e) = showsGuard d cd c e
  showsPrec _ (Fail_C_Options cd info) = showChar '!'
  showsPrec _ (C_Options x1 x2 x3 x4) = showString "(Options" . (showChar ' ' .
    (shows x1 . (showChar ' ' . (shows x2 . (showChar ' ' . (shows x3 .
    (showChar ' ' . (shows x4 . showChar ')'))))))))
  showsPrec _ (HO_C_Options x1 x2 x3 x4) = showString "(Options" . (showChar
    ' ' . (shows x1 . (showChar ' ' . (shows x2 . (showChar ' ' . (shows x3 .
    (showChar ' ' . (shows x4 . showChar ')'))))))))

instance Read C_Options where
  readsPrec d s = readParen ((>) d 10) (\r -> [(C_Options x1 x2 x3 x4, r4) | (_
    , r0) <- readQualified "AbstractHaskell.Printer" "Options" r, (x1, r1) <-
    readsPrec 11 r0, (x2, r2) <- readsPrec 11 r1, (x3, r3) <- readsPrec 11 r2,
    (x4, r4) <- readsPrec 11 r3]) s

instance NonDet C_Options where
  choiceCons = Choice_C_Options
  choicesCons = Choices_C_Options
  failCons = Fail_C_Options
  guardCons = Guard_C_Options
  try (Choice_C_Options cd i x y) = tryChoice cd i x y
  try (Choices_C_Options cd i xs) = tryChoices cd i xs
  try (Fail_C_Options cd info) = Fail cd info
  try (Guard_C_Options cd c e) = Guard cd c e
  try x = Val x
  match f _ _ _ _ _ (Choice_C_Options cd i x y) = f cd i x y
  match _ f _ _ _ _ (Choices_C_Options cd i@(NarrowedID _ _) xs) = f cd i xs
  match _ _ f _ _ _ (Choices_C_Options cd i@(FreeID _ _) xs) = f cd i xs
  match _ _ _ _ _ _ (Choices_C_Options cd i _) = error
    ("AbstractHaskell.Printer.Options.match: Choices with ChoiceID " ++ show i)
  match _ _ _ f _ _ (Fail_C_Options cd info) = f cd info
  match _ _ _ _ f _ (Guard_C_Options cd c e) = f cd c e
  match _ _ _ _ _ f x = f x

instance Generable C_Options where
  generate s c = Choices_C_Options c (freeID [4] s) [HO_C_Options (generate
    (leftSupply (leftSupply s)) c) (generate (rightSupply (leftSupply s)) c)
    (generate (leftSupply (rightSupply s)) c) (generate (rightSupply
    (rightSupply s)) c)]

instance NormalForm C_Options where
  ($!!) cont (C_Options x1 x2 x3 x4) d cs = ($!!) (\y1 d cs -> ($!!)
    (\y2 d cs -> ($!!) (\y3 d cs -> ($!!) (\y4 d cs -> cont (C_Options y1 y2 y3
    y4) d cs) x4 d cs) x3 d cs) x2 d cs) x1 d cs
  ($!!) cont (HO_C_Options x1 x2 x3 x4) d cs = ($!!) (\y1 d cs -> ($!!)
    (\y2 d cs -> ($!!) (\y3 d cs -> ($!!) (\y4 d cs -> cont (HO_C_Options y1 y2
    y3 y4) d cs) x4 d cs) x3 d cs) x2 d cs) x1 d cs
  ($!!) cont (Choice_C_Options cd i x y) d cs = nfChoice cont cd i x y cd cs
  ($!!) cont (Choices_C_Options cd i xs) d cs = nfChoices cont cd i xs d cs
  ($!!) cont (Guard_C_Options cd c e) d cs = guardCons cd c (($!!) cont e d
    (addCs c cs))
  ($!!) _ (Fail_C_Options cd info) _ _ = failCons cd info
  ($##) cont (C_Options x1 x2 x3 x4) d cs = ($##) (\y1 d cs -> ($##)
    (\y2 d cs -> ($##) (\y3 d cs -> ($##) (\y4 d cs -> cont (C_Options y1 y2 y3
    y4) d cs) x4 d cs) x3 d cs) x2 d cs) x1 d cs
  ($##) cont (HO_C_Options x1 x2 x3 x4) d cs = ($##) (\y1 d cs -> ($##)
    (\y2 d cs -> ($##) (\y3 d cs -> ($##) (\y4 d cs -> cont (HO_C_Options y1 y2
    y3 y4) d cs) x4 d cs) x3 d cs) x2 d cs) x1 d cs
  ($##) cont (Choice_C_Options cd i x y) d cs = gnfChoice cont cd i x y cd cs
  ($##) cont (Choices_C_Options cd i xs) d cs = gnfChoices cont cd i xs d cs
  ($##) cont (Guard_C_Options cd c e) d cs = guardCons cd c (($##) cont e d
    (addCs c cs))
  ($##) _ (Fail_C_Options cd info) _ _ = failCons cd info
  showCons (C_Options _ _ _ _) = "AbstractHaskell.Printer.Options _ _ _ _"
  showCons (HO_C_Options _ _ _ _) = "AbstractHaskell.Printer.Options _ _ _ _"
  showCons x = error
    ("AbstractHaskell.Printer.Options.showCons: no constructor: " ++ show x)
  searchNF search cont (C_Options x1 x2 x3 x4) = search (\y1 -> search (\y2 ->
    search (\y3 -> search (\y4 -> cont (C_Options y1 y2 y3 y4)) x4) x3) x2) x1
  searchNF search cont (HO_C_Options x1 x2 x3 x4) = search (\y1 -> search
    (\y2 -> search (\y3 -> search (\y4 -> cont (HO_C_Options y1 y2 y3 y4)) x4)
    x3) x2) x1
  searchNF _ _ x = error
    ("AbstractHaskell.Printer.Options.searchNF: no constructor: " ++ show x)

instance Unifiable C_Options where
  (=.=) (C_Options x1 x2 x3 x4) (C_Options y1 y2 y3 y4) d cs = (&) ((=:=) x1 y1
    d cs) ((&) ((=:=) x2 y2 d cs) ((&) ((=:=) x3 y3 d cs) ((=:=) x4 y4 d cs) d
    cs) d cs) d cs
  (=.=) (HO_C_Options x1 x2 x3 x4) (HO_C_Options y1 y2 y3 y4) d cs = (&) ((=:=)
    x1 y1 d cs) ((&) ((=:=) x2 y2 d cs) ((&) ((=:=) x3 y3 d cs) ((=:=) x4 y4 d
    cs) d cs) d cs) d cs
  (=.=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  (=.<=) (C_Options x1 x2 x3 x4) (C_Options y1 y2 y3 y4) d cs = (&) ((=:<=) x1
    y1 d cs) ((&) ((=:<=) x2 y2 d cs) ((&) ((=:<=) x3 y3 d cs) ((=:<=) x4 y4 d
    cs) d cs) d cs) d cs
  (=.<=) (HO_C_Options x1 x2 x3 x4) (HO_C_Options y1 y2 y3 y4) d cs = (&)
    ((=:<=) x1 y1 d cs) ((&) ((=:<=) x2 y2 d cs) ((&) ((=:<=) x3 y3 d cs)
    ((=:<=) x4 y4 d cs) d cs) d cs) d cs
  (=.<=) a b cd _ = Fail_C_Bool cd (unificationFail (showCons a) (showCons b))
  bind cd i (C_Options x3 x4 x5 x6) = (i :=: ChooseN 0 4) : concat [bind cd
    (leftID (leftID i)) x3, bind cd (rightID (leftID i)) x4, bind cd (leftID
    (rightID i)) x5, bind cd (rightID (rightID i)) x6]
  bind cd i (HO_C_Options x3 x4 x5 x6) = (i :=: ChooseN 0 4) : concat [bind cd
    (leftID (leftID i)) x3, bind cd (rightID (leftID i)) x4, bind cd (leftID
    (rightID i)) x5, bind cd (rightID (rightID i)) x6]
  bind d i (Choice_C_Options cd j x y) = [ConstraintChoice cd j (bind d i x)
    (bind d i y)]
  bind d i (Choices_C_Options cd j@(FreeID _ _) xs) = bindOrNarrow d i cd j xs
  bind d i (Choices_C_Options cd j@(NarrowedID _ _) xs) = [ConstraintChoices cd
    j (map (bind d i) xs)]
  bind _ _ (Choices_C_Options cd i _) = error
    ("AbstractHaskell.Printer.Options.bind: Choices with ChoiceID: " ++ show i)
  bind _ _ (Fail_C_Options cd info) = [Unsolvable info]
  bind d i (Guard_C_Options cd c e) = getConstrList c ++ bind d i e
  lazyBind cd i (C_Options x3 x4 x5 x6) = (i :=: ChooseN 0 4) : [leftID (leftID
    i) :=: LazyBind (lazyBind cd (leftID (leftID i)) x3), rightID (leftID i) :=:
    LazyBind (lazyBind cd (rightID (leftID i)) x4), leftID (rightID i) :=:
    LazyBind (lazyBind cd (leftID (rightID i)) x5), rightID (rightID i) :=:
    LazyBind (lazyBind cd (rightID (rightID i)) x6)]
  lazyBind cd i (HO_C_Options x3 x4 x5 x6) = (i :=: ChooseN 0 4) : [leftID
    (leftID i) :=: LazyBind (lazyBind cd (leftID (leftID i)) x3), rightID
    (leftID i) :=: LazyBind (lazyBind cd (rightID (leftID i)) x4), leftID
    (rightID i) :=: LazyBind (lazyBind cd (leftID (rightID i)) x5), rightID
    (rightID i) :=: LazyBind (lazyBind cd (rightID (rightID i)) x6)]
  lazyBind d i (Choice_C_Options cd j x y) = [ConstraintChoice cd j (lazyBind d
    i x) (lazyBind d i y)]
  lazyBind d i (Choices_C_Options cd j@(FreeID _ _) xs) = lazyBindOrNarrow d i
    cd j xs
  lazyBind d i (Choices_C_Options cd j@(NarrowedID _ _) xs) = [ConstraintChoices
    cd j (map (lazyBind d i) xs)]
  lazyBind _ _ (Choices_C_Options cd i _) = error
    ("AbstractHaskell.Printer.Options.lazyBind: Choices with ChoiceID: " ++ show
    i)
  lazyBind _ _ (Fail_C_Options cd info) = [Unsolvable info]
  lazyBind d i (Guard_C_Options cd c e) = getConstrList c ++ [i :=: LazyBind
    (lazyBind d i e)]

instance Curry C_Options where

d_C_currentModule :: C_Options -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_currentModule x1 cd cs = case x1 of
  C_Options x2 x3 x4 x5 -> x2
  Choice_C_Options d i l r -> narrow d i (d_C_currentModule l cd cs)
    (d_C_currentModule r cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z -> d_C_currentModule z cd cs)
    xs
  Guard_C_Options d c e -> guardCons d c ((\x -> d_C_currentModule e cd x) $!
    addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail
    "AbstractHaskell.Printer.currentModule" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.currentModule" (showCons
    x1))

nd_C_currentModule :: C_Options -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
nd_C_currentModule x1 s cd cs = case x1 of
  HO_C_Options x2 x3 x4 x5 -> x2
  Choice_C_Options d i l r -> narrow d i (nd_C_currentModule l s cd cs)
    (nd_C_currentModule r s cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z -> nd_C_currentModule z s cd
    cs) xs
  Guard_C_Options d c e -> guardCons d c ((\x -> nd_C_currentModule e s cd x) $!
    addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail
    "AbstractHaskell.Printer.currentModule" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.currentModule" (showCons
    x1))

d_C_qualImpModule :: C_Options -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_qualImpModule x1 cd cs = case x1 of
  C_Options x2 x3 x4 x5 -> x3
  Choice_C_Options d i l r -> narrow d i (d_C_qualImpModule l cd cs)
    (d_C_qualImpModule r cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z -> d_C_qualImpModule z cd cs)
    xs
  Guard_C_Options d c e -> guardCons d c ((\x -> d_C_qualImpModule e cd x) $!
    addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail
    "AbstractHaskell.Printer.qualImpModule" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.qualImpModule" (showCons
    x1))

nd_C_qualImpModule :: C_Options -> IDSupply -> Cover -> ConstStore -> Func
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) Curry_Prelude.C_Bool
nd_C_qualImpModule x1 s cd cs = case x1 of
  HO_C_Options x2 x3 x4 x5 -> x3
  Choice_C_Options d i l r -> narrow d i (nd_C_qualImpModule l s cd cs)
    (nd_C_qualImpModule r s cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z -> nd_C_qualImpModule z s cd
    cs) xs
  Guard_C_Options d c e -> guardCons d c ((\x -> nd_C_qualImpModule e s cd x) $!
    addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail
    "AbstractHaskell.Printer.qualImpModule" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.qualImpModule" (showCons
    x1))

d_C_traceFailure :: C_Options -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_traceFailure x1 cd cs = case x1 of
  C_Options x2 x3 x4 x5 -> x4
  Choice_C_Options d i l r -> narrow d i (d_C_traceFailure l cd cs)
    (d_C_traceFailure r cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z -> d_C_traceFailure z cd cs) xs
  Guard_C_Options d c e -> guardCons d c ((\x -> d_C_traceFailure e cd x) $!
    addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail
    "AbstractHaskell.Printer.traceFailure" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.traceFailure" (showCons
    x1))

nd_C_traceFailure :: C_Options -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
nd_C_traceFailure x1 s cd cs = case x1 of
  HO_C_Options x2 x3 x4 x5 -> x4
  Choice_C_Options d i l r -> narrow d i (nd_C_traceFailure l s cd cs)
    (nd_C_traceFailure r s cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z -> nd_C_traceFailure z s cd cs)
    xs
  Guard_C_Options d c e -> guardCons d c ((\x -> nd_C_traceFailure e s cd x) $!
    addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail
    "AbstractHaskell.Printer.traceFailure" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.traceFailure" (showCons
    x1))

d_C_kics2Mode :: C_Options -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_kics2Mode x1 cd cs = case x1 of
  C_Options x2 x3 x4 x5 -> x5
  Choice_C_Options d i l r -> narrow d i (d_C_kics2Mode l cd cs) (d_C_kics2Mode
    r cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z -> d_C_kics2Mode z cd cs) xs
  Guard_C_Options d c e -> guardCons d c ((\x -> d_C_kics2Mode e cd x) $! addCs
    c cs)
  Fail_C_Options d info -> failCons d (traceFail
    "AbstractHaskell.Printer.kics2Mode" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.kics2Mode" (showCons x1))

nd_C_kics2Mode :: C_Options -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
nd_C_kics2Mode x1 s cd cs = case x1 of
  HO_C_Options x2 x3 x4 x5 -> x5
  Choice_C_Options d i l r -> narrow d i (nd_C_kics2Mode l s cd cs)
    (nd_C_kics2Mode r s cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z -> nd_C_kics2Mode z s cd cs) xs
  Guard_C_Options d c e -> guardCons d c ((\x -> nd_C_kics2Mode e s cd x) $!
    addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail
    "AbstractHaskell.Printer.kics2Mode" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.kics2Mode" (showCons x1))

d_C_defaultOptions :: Cover -> ConstStore -> C_Options
d_C_defaultOptions cd cs = C_Options Curry_Prelude.OP_List
  (Curry_Prelude.d_C_const Curry_Prelude.C_False) Curry_Prelude.C_False
  Curry_Prelude.C_False

nd_C_defaultOptions :: IDSupply -> Cover -> ConstStore -> C_Options
nd_C_defaultOptions s cd cs = HO_C_Options Curry_Prelude.OP_List (wrapDX id
  (Curry_Prelude.d_C_const Curry_Prelude.C_False)) Curry_Prelude.C_False
  Curry_Prelude.C_False

d_C_pPrint :: Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_pPrint cd cs = Text.Curry_PrettyImpl.d_C_showWidth (Curry_Prelude.C_Int
  (80))

nd_C_pPrint :: IDSupply -> Cover -> ConstStore -> Func
  Text.Curry_PrettyImpl.C_Doc (Curry_Prelude.OP_List Curry_Prelude.C_Char)
nd_C_pPrint s cd cs = wrapNX id (Text.Curry_PrettyImpl.nd_C_showWidth
  (Curry_Prelude.C_Int (80)))

d_C_ppProg :: C_Options -> AbstractHaskell.Curry_Types.C_Prog -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C_ppProg x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Prog x3 x4 x5 x6 x7 -> let x8 = d_C__case_44 x3
                                                             x1 cd cs
    in Text.Curry_Pretty.d_C_compose
    (Text.Curry_Pretty.d_OP_lt_dollar_plus_dollar_gt cd cs)
    (Curry_Prelude.OP_Cons (d_C_ppHeader x8 x3 x5 x6 cd cs)
    (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply (d_C_ppImports x8 cd cs) x4
    cd cs) (Curry_Prelude.OP_Cons (d_C_ppDecls x8 x7 x5 x6 cd cs)
    Curry_Prelude.OP_List))) cd cs
  AbstractHaskell.Curry_Types.Choice_C_Prog d i l r -> narrow d i (d_C_ppProg x1
    l cd cs) (d_C_ppProg x1 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Prog d i xs -> narrows cs d i (\z ->
    d_C_ppProg x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Prog d c e -> guardCons d c ((\x ->
    d_C_ppProg x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Prog d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppProg" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppProg" (showCons x2))

nd_C_ppProg :: C_Options -> AbstractHaskell.Curry_Types.C_Prog -> IDSupply
  -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppProg x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Prog x3 x4 x5 x6 x7 -> let s12 = s
    in s12 `seq` (let s0 = leftSupply s12
                      s10 = rightSupply s12
    in s0 `seq` (s10 `seq` (let x8 = nd_C__case_44 x3 x1 s0 cd cs
    in let s9 = leftSupply s10
           s11 = rightSupply s10
           s1 = leftSupply s11
           s8 = rightSupply s11
    in s9 `seq` (s11 `seq` (s1 `seq` (s8 `seq` Text.Curry_Pretty.nd_C_compose
    (Text.Curry_Pretty.nd_OP_lt_dollar_plus_dollar_gt s1 cd cs)
    (let s2 = leftSupply s8
         s7 = rightSupply s8
    in s2 `seq` (s7 `seq` Curry_Prelude.OP_Cons (nd_C_ppHeader x8 x3 x5 x6 s2 cd
    cs) (let s5 = leftSupply s7
             s6 = rightSupply s7
    in s5 `seq` (s6 `seq` Curry_Prelude.OP_Cons (let s4 = leftSupply s5
                                                     s3 = rightSupply s5
    in s4 `seq` (s3 `seq` Curry_Prelude.nd_C_apply (nd_C_ppImports x8 s3 cd cs)
    x4 s4 cd cs)) (Curry_Prelude.OP_Cons (nd_C_ppDecls x8 x7 x5 x6 s6 cd cs)
    Curry_Prelude.OP_List))))) s9 cd cs))))))
  AbstractHaskell.Curry_Types.Choice_C_Prog d i l r -> narrow d i (nd_C_ppProg
    x1 l s cd cs) (nd_C_ppProg x1 r s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Prog d i xs -> narrows cs d i (\z ->
    nd_C_ppProg x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Prog d c e -> guardCons d c ((\x ->
    nd_C_ppProg x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Prog d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppProg" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppProg" (showCons x2))

d_C_ppHeader :: C_Options -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_TypeDecl
  -> Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_FuncDecl -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C_ppHeader x1 x2 x3 x4 cd cs = Curry_Prelude.d_OP_dollar (d_C_indent cd cs)
  (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_C_sep cd cs)
  (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (Text.Curry_Pretty.d_C_text
  (Curry_Prelude.toCurryString "module") cd cs) cd cs)
  (Text.Curry_Pretty.d_C_text (d_C__case_43 x1 x2 (d_C_traceFailure x1 cd cs) cd
  cs) cd cs) cd cs) (Curry_Prelude.OP_Cons (d_C_ppExports x1 x3 x4 cd cs)
  (Curry_Prelude.OP_Cons (Text.Curry_Pretty.d_C_text
  (Curry_Prelude.toCurryString "where") cd cs) Curry_Prelude.OP_List))) cd cs)
  cd cs

nd_C_ppHeader :: C_Options -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_TypeDecl
  -> Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_FuncDecl -> IDSupply
  -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppHeader x1 x2 x3 x4 s cd cs = let s23 = s
  in s23 `seq` (let s22 = leftSupply s23
                    s24 = rightSupply s23
                    s0 = leftSupply s24
                    s20 = rightSupply s24
  in s22 `seq` (s24 `seq` (s0 `seq` (s20 `seq` Curry_Prelude.nd_OP_dollar
  (nd_C_indent s0 cd cs) (let s19 = leftSupply s20
                              s21 = rightSupply s20
                              s1 = leftSupply s21
                              s18 = rightSupply s21
  in s19 `seq` (s21 `seq` (s1 `seq` (s18 `seq` Curry_Prelude.nd_C_apply
  (Text.Curry_Pretty.nd_C_sep s1 cd cs) (let s13 = leftSupply s18
                                             s17 = rightSupply s18
  in s13 `seq` (s17 `seq` Curry_Prelude.OP_Cons (let s12 = leftSupply s13
                                                     s14 = rightSupply s13
                                                     s5 = leftSupply s14
                                                     s11 = rightSupply s14
  in s12 `seq` (s14 `seq` (s5 `seq` (s11 `seq` Curry_Prelude.nd_C_apply
  (let s4 = leftSupply s5
       s6 = rightSupply s5
       s2 = leftSupply s6
       s3 = rightSupply s6
  in s4 `seq` (s6 `seq` (s2 `seq` (s3 `seq` Curry_Prelude.nd_C_apply
  (Text.Curry_Pretty.nd_OP_lt_plus_gt s2 cd cs) (Text.Curry_Pretty.nd_C_text
  (Curry_Prelude.toCurryString "module") s3 cd cs) s4 cd cs))))
  (let s10 = leftSupply s11
       s9 = rightSupply s11
  in s10 `seq` (s9 `seq` Text.Curry_Pretty.nd_C_text (let s8 = leftSupply s9
                                                          s7 = rightSupply s9
  in s8 `seq` (s7 `seq` nd_C__case_43 x1 x2 (nd_C_traceFailure x1 s7 cd cs) s8
  cd cs)) s10 cd cs)) s12 cd cs)))) (let s15 = leftSupply s17
                                         s16 = rightSupply s17
  in s15 `seq` (s16 `seq` Curry_Prelude.OP_Cons (nd_C_ppExports x1 x3 x4 s15 cd
  cs) (Curry_Prelude.OP_Cons (Text.Curry_Pretty.nd_C_text
  (Curry_Prelude.toCurryString "where") s16 cd cs) Curry_Prelude.OP_List)))))
  s19 cd cs)))) s22 cd cs))))

d_C_ppDecls :: C_Options -> Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_OpDecl -> Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_TypeDecl -> Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_FuncDecl -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C_ppDecls x1 x2 x3 x4 cd cs = Text.Curry_Pretty.d_C_compose
  (Text.Curry_Pretty.d_OP_lt_dollar_plus_dollar_gt cd cs) (Curry_Prelude.OP_Cons
  (Curry_Prelude.d_C_apply (d_C_ppOpDecls cd cs) x2 cd cs)
  (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply (d_C_ppTypeDecls x1 cd cs) x3
  cd cs) (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply (d_C_ppFuncDecls x1 cd
  cs) x4 cd cs) Curry_Prelude.OP_List))) cd cs

nd_C_ppDecls :: C_Options -> Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_OpDecl -> Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_TypeDecl -> Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_FuncDecl -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppDecls x1 x2 x3 x4 s cd cs = let s13 = s
  in s13 `seq` (let s12 = leftSupply s13
                    s14 = rightSupply s13
                    s0 = leftSupply s14
                    s11 = rightSupply s14
  in s12 `seq` (s14 `seq` (s0 `seq` (s11 `seq` Text.Curry_Pretty.nd_C_compose
  (Text.Curry_Pretty.nd_OP_lt_dollar_plus_dollar_gt s0 cd cs)
  (let s3 = leftSupply s11
       s10 = rightSupply s11
  in s3 `seq` (s10 `seq` Curry_Prelude.OP_Cons (let s2 = leftSupply s3
                                                    s1 = rightSupply s3
  in s2 `seq` (s1 `seq` Curry_Prelude.nd_C_apply (nd_C_ppOpDecls s1 cd cs) x2 s2
  cd cs)) (let s6 = leftSupply s10
               s9 = rightSupply s10
  in s6 `seq` (s9 `seq` Curry_Prelude.OP_Cons (let s5 = leftSupply s6
                                                   s4 = rightSupply s6
  in s5 `seq` (s4 `seq` Curry_Prelude.nd_C_apply (nd_C_ppTypeDecls x1 s4 cd cs)
  x3 s5 cd cs)) (Curry_Prelude.OP_Cons (let s8 = leftSupply s9
                                            s7 = rightSupply s9
  in s8 `seq` (s7 `seq` Curry_Prelude.nd_C_apply (nd_C_ppFuncDecls x1 s7 cd cs)
  x4 s8 cd cs)) Curry_Prelude.OP_List))))) s12 cd cs))))

d_C_ppExports :: C_Options -> Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_TypeDecl -> Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_FuncDecl -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C_ppExports x1 x2 x3 cd cs = Curry_Prelude.d_OP_dollar
  (Text.Curry_Pretty.d_C_tupledSpaced cd cs) (Curry_Prelude.d_OP_dollar
  (Curry_Prelude.d_C_filter (Curry_Prelude.d_OP_dot Curry_Prelude.d_C_not
  Text.Curry_Pretty.d_C_isEmpty cd cs)) (Curry_Prelude.d_OP_plus_plus
  (Curry_Prelude.d_C_map (d_OP_ppExports_dot_ppTypeExport_dot_13 x1) x2 cd cs)
  (Curry_Prelude.d_C_map (d_OP_ppExports_dot_ppFuncExport_dot_13 x1) x3 cd cs)
  cd cs) cd cs) cd cs

nd_C_ppExports :: C_Options -> Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_TypeDecl -> Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_FuncDecl -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppExports x1 x2 x3 s cd cs = let s9 = s
  in s9 `seq` (let s8 = leftSupply s9
                   s10 = rightSupply s9
                   s0 = leftSupply s10
                   s6 = rightSupply s10
  in s8 `seq` (s10 `seq` (s0 `seq` (s6 `seq` Curry_Prelude.nd_OP_dollar
  (Text.Curry_Pretty.nd_C_tupledSpaced s0 cd cs) (let s5 = leftSupply s6
                                                      s7 = rightSupply s6
                                                      s1 = leftSupply s7
                                                      s4 = rightSupply s7
  in s5 `seq` (s7 `seq` (s1 `seq` (s4 `seq` Curry_Prelude.nd_OP_dollar (wrapNX
  id (Curry_Prelude.nd_C_filter (Curry_Prelude.nd_OP_dot (wrapDX id
  Curry_Prelude.d_C_not) (wrapNX id Text.Curry_Pretty.nd_C_isEmpty) s1 cd cs)))
  (let s2 = leftSupply s4
       s3 = rightSupply s4
  in s2 `seq` (s3 `seq` Curry_Prelude.d_OP_plus_plus (Curry_Prelude.nd_C_map
  (wrapNX id (nd_OP_ppExports_dot_ppTypeExport_dot_13 x1)) x2 s2 cd cs)
  (Curry_Prelude.nd_C_map (wrapNX id (nd_OP_ppExports_dot_ppFuncExport_dot_13
  x1)) x3 s3 cd cs) cd cs)) s5 cd cs)))) s8 cd cs))))

d_OP_ppExports_dot_ppTypeExport_dot_13 :: C_Options
  -> AbstractHaskell.Curry_Types.C_TypeDecl -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_OP_ppExports_dot_ppTypeExport_dot_13 x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Type x3 x4 x5 x6 -> d_C__case_42 x4 x3 x1
    (AbstractHaskell.Curry_Types.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_AbstractHaskell_dot_Types_dot_Visibility_hash
    x4 AbstractHaskell.Curry_Types.C_Public cd cs) cd cs
  AbstractHaskell.Curry_Types.C_TypeSyn x7 x8 x9 x10 -> d_C__case_40 x8 x7 x1
    (AbstractHaskell.Curry_Types.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_AbstractHaskell_dot_Types_dot_Visibility_hash
    x8 AbstractHaskell.Curry_Types.C_Public cd cs) cd cs
  AbstractHaskell.Curry_Types.C_TypeNew x11 x12 x13 x14 -> d_C__case_38 x12 x11
    x1
    (AbstractHaskell.Curry_Types.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_AbstractHaskell_dot_Types_dot_Visibility_hash
    x12 AbstractHaskell.Curry_Types.C_Public cd cs) cd cs
  AbstractHaskell.Curry_Types.C_Instance x15 x16 x17 x18 -> Text.Curry_Pretty.d_C_empty
    cd cs
  AbstractHaskell.Curry_Types.Choice_C_TypeDecl d i l r -> narrow d i
    (d_OP_ppExports_dot_ppTypeExport_dot_13 x1 l cd cs)
    (d_OP_ppExports_dot_ppTypeExport_dot_13 x1 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_TypeDecl d i xs -> narrows cs d i (\z ->
    d_OP_ppExports_dot_ppTypeExport_dot_13 x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_TypeDecl d c e -> guardCons d c ((\x ->
    d_OP_ppExports_dot_ppTypeExport_dot_13 x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_TypeDecl d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppExports.ppTypeExport.13" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppExports.ppTypeExport.13"
    (showCons x2))

nd_OP_ppExports_dot_ppTypeExport_dot_13 :: C_Options
  -> AbstractHaskell.Curry_Types.C_TypeDecl -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_OP_ppExports_dot_ppTypeExport_dot_13 x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Type x3 x4 x5 x6 -> let s0 = s
    in s0 `seq` nd_C__case_42 x4 x3 x1
    (AbstractHaskell.Curry_Types.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_AbstractHaskell_dot_Types_dot_Visibility_hash
    x4 AbstractHaskell.Curry_Types.C_Public cd cs) s0 cd cs
  AbstractHaskell.Curry_Types.C_TypeSyn x7 x8 x9 x10 -> let s0 = s
    in s0 `seq` nd_C__case_40 x8 x7 x1
    (AbstractHaskell.Curry_Types.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_AbstractHaskell_dot_Types_dot_Visibility_hash
    x8 AbstractHaskell.Curry_Types.C_Public cd cs) s0 cd cs
  AbstractHaskell.Curry_Types.C_TypeNew x11 x12 x13 x14 -> let s0 = s
    in s0 `seq` nd_C__case_38 x12 x11 x1
    (AbstractHaskell.Curry_Types.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_AbstractHaskell_dot_Types_dot_Visibility_hash
    x12 AbstractHaskell.Curry_Types.C_Public cd cs) s0 cd cs
  AbstractHaskell.Curry_Types.C_Instance x15 x16 x17 x18 -> let s0 = s
    in s0 `seq` Text.Curry_Pretty.nd_C_empty s0 cd cs
  AbstractHaskell.Curry_Types.Choice_C_TypeDecl d i l r -> narrow d i
    (nd_OP_ppExports_dot_ppTypeExport_dot_13 x1 l s cd cs)
    (nd_OP_ppExports_dot_ppTypeExport_dot_13 x1 r s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_TypeDecl d i xs -> narrows cs d i (\z ->
    nd_OP_ppExports_dot_ppTypeExport_dot_13 x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_TypeDecl d c e -> guardCons d c ((\x ->
    nd_OP_ppExports_dot_ppTypeExport_dot_13 x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_TypeDecl d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppExports.ppTypeExport.13" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppExports.ppTypeExport.13"
    (showCons x2))

d_OP_ppExports_dot_ppFuncExport_dot_13 :: C_Options
  -> AbstractHaskell.Curry_Types.C_FuncDecl -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_OP_ppExports_dot_ppFuncExport_dot_13 x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Func x3 x4 x5 x6 x7 x8 -> d_C__case_36 x6 x4 x1
    (AbstractHaskell.Curry_Types.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_AbstractHaskell_dot_Types_dot_Visibility_hash
    x6 AbstractHaskell.Curry_Types.C_Public cd cs) cd cs
  AbstractHaskell.Curry_Types.Choice_C_FuncDecl d i l r -> narrow d i
    (d_OP_ppExports_dot_ppFuncExport_dot_13 x1 l cd cs)
    (d_OP_ppExports_dot_ppFuncExport_dot_13 x1 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_FuncDecl d i xs -> narrows cs d i (\z ->
    d_OP_ppExports_dot_ppFuncExport_dot_13 x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_FuncDecl d c e -> guardCons d c ((\x ->
    d_OP_ppExports_dot_ppFuncExport_dot_13 x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_FuncDecl d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppExports.ppFuncExport.13" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppExports.ppFuncExport.13"
    (showCons x2))

nd_OP_ppExports_dot_ppFuncExport_dot_13 :: C_Options
  -> AbstractHaskell.Curry_Types.C_FuncDecl -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_OP_ppExports_dot_ppFuncExport_dot_13 x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Func x3 x4 x5 x6 x7 x8 -> let s0 = s
    in s0 `seq` nd_C__case_36 x6 x4 x1
    (AbstractHaskell.Curry_Types.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_AbstractHaskell_dot_Types_dot_Visibility_hash
    x6 AbstractHaskell.Curry_Types.C_Public cd cs) s0 cd cs
  AbstractHaskell.Curry_Types.Choice_C_FuncDecl d i l r -> narrow d i
    (nd_OP_ppExports_dot_ppFuncExport_dot_13 x1 l s cd cs)
    (nd_OP_ppExports_dot_ppFuncExport_dot_13 x1 r s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_FuncDecl d i xs -> narrows cs d i (\z ->
    nd_OP_ppExports_dot_ppFuncExport_dot_13 x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_FuncDecl d c e -> guardCons d c ((\x ->
    nd_OP_ppExports_dot_ppFuncExport_dot_13 x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_FuncDecl d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppExports.ppFuncExport.13" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppExports.ppFuncExport.13"
    (showCons x2))

d_C_ppImports :: C_Options -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C_ppImports x1 cd cs = Curry_Prelude.d_OP_dot (Text.Curry_Pretty.d_C_vsep cd
  cs) (Curry_Prelude.d_C_map (d_C_ppImport x1)) cd cs

nd_C_ppImports :: C_Options -> IDSupply -> Cover -> ConstStore -> Func
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  Text.Curry_PrettyImpl.C_Doc
nd_C_ppImports x1 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (Text.Curry_Pretty.nd_C_vsep s0
  cd cs) (wrapNX id (Curry_Prelude.nd_C_map (wrapNX id (nd_C_ppImport x1)))) s1
  cd cs))

d_C_ppImport :: C_Options -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C_ppImport x1 x2 cd cs = d_C__case_34 x2 x1 (Curry_Prelude.d_C_apply
  (d_C_qualImpModule x1 cd cs) x2 cd cs) cd cs

nd_C_ppImport :: C_Options -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> IDSupply -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppImport x1 x2 s cd cs = let s4 = s
  in s4 `seq` (let s3 = leftSupply s4
                   s2 = rightSupply s4
  in s3 `seq` (s2 `seq` nd_C__case_34 x2 x1 (let s1 = leftSupply s2
                                                 s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (nd_C_qualImpModule x1 s0 cd
  cs) x2 s1 cd cs)) s3 cd cs))

d_C_ppOpDecls :: Cover -> ConstStore -> Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_OpDecl -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C_ppOpDecls cd cs = Curry_Prelude.d_OP_dot (Text.Curry_Pretty.d_C_vsep cd cs)
  (Curry_Prelude.d_C_map d_C_ppOpDecl) cd cs

nd_C_ppOpDecls :: IDSupply -> Cover -> ConstStore -> Func (Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_OpDecl) Text.Curry_PrettyImpl.C_Doc
nd_C_ppOpDecls s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (Text.Curry_Pretty.nd_C_vsep s0
  cd cs) (wrapNX id (Curry_Prelude.nd_C_map (wrapNX id nd_C_ppOpDecl))) s1 cd
  cs))

d_C_ppOpDecl :: AbstractHaskell.Curry_Types.C_OpDecl -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C_ppOpDecl x1 cd cs = case x1 of
  AbstractHaskell.Curry_Types.C_Op x2 x3 x4 -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (d_C_ppFixity x3 cd cs) cd cs)
    (Text.Curry_Pretty.d_C_int x4 cd cs) cd cs) cd cs) (d_C_ppInfixOp
    (Curry_Prelude.d_C_snd x2 cd cs) cd cs) cd cs
  AbstractHaskell.Curry_Types.Choice_C_OpDecl d i l r -> narrow d i
    (d_C_ppOpDecl l cd cs) (d_C_ppOpDecl r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_OpDecl d i xs -> narrows cs d i (\z ->
    d_C_ppOpDecl z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_OpDecl d c e -> guardCons d c ((\x ->
    d_C_ppOpDecl e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_OpDecl d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppOpDecl" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppOpDecl" (showCons x1))

nd_C_ppOpDecl :: AbstractHaskell.Curry_Types.C_OpDecl -> IDSupply -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppOpDecl x1 s cd cs = case x1 of
  AbstractHaskell.Curry_Types.C_Op x2 x3 x4 -> let s15 = s
    in s15 `seq` (let s14 = leftSupply s15
                      s16 = rightSupply s15
                      s11 = leftSupply s16
                      s13 = rightSupply s16
    in s14 `seq` (s16 `seq` (s11 `seq` (s13 `seq` Curry_Prelude.nd_C_apply
    (let s10 = leftSupply s11
         s12 = rightSupply s11
         s0 = leftSupply s12
         s8 = rightSupply s12
    in s10 `seq` (s12 `seq` (s0 `seq` (s8 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s0 cd cs) (let s7 = leftSupply s8
                                                       s9 = rightSupply s8
                                                       s4 = leftSupply s9
                                                       s6 = rightSupply s9
    in s7 `seq` (s9 `seq` (s4 `seq` (s6 `seq` Curry_Prelude.nd_C_apply
    (let s3 = leftSupply s4
         s5 = rightSupply s4
         s1 = leftSupply s5
         s2 = rightSupply s5
    in s3 `seq` (s5 `seq` (s1 `seq` (s2 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s1 cd cs) (nd_C_ppFixity x3 s2 cd cs) s3
    cd cs)))) (Text.Curry_Pretty.nd_C_int x4 s6 cd cs) s7 cd cs)))) s10 cd
    cs)))) (nd_C_ppInfixOp (Curry_Prelude.d_C_snd x2 cd cs) s13 cd cs) s14 cd
    cs))))
  AbstractHaskell.Curry_Types.Choice_C_OpDecl d i l r -> narrow d i
    (nd_C_ppOpDecl l s cd cs) (nd_C_ppOpDecl r s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_OpDecl d i xs -> narrows cs d i (\z ->
    nd_C_ppOpDecl z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_OpDecl d c e -> guardCons d c ((\x ->
    nd_C_ppOpDecl e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_OpDecl d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppOpDecl" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppOpDecl" (showCons x1))

d_C_ppFixity :: AbstractHaskell.Curry_Types.C_Fixity -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C_ppFixity x1 cd cs = case x1 of
  AbstractHaskell.Curry_Types.C_InfixOp -> Text.Curry_Pretty.d_C_text
    (Curry_Prelude.toCurryString "infix") cd cs
  AbstractHaskell.Curry_Types.C_InfixlOp -> Text.Curry_Pretty.d_C_text
    (Curry_Prelude.toCurryString "infixl") cd cs
  AbstractHaskell.Curry_Types.C_InfixrOp -> Text.Curry_Pretty.d_C_text
    (Curry_Prelude.toCurryString "infixr") cd cs
  AbstractHaskell.Curry_Types.Choice_C_Fixity d i l r -> narrow d i
    (d_C_ppFixity l cd cs) (d_C_ppFixity r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Fixity d i xs -> narrows cs d i (\z ->
    d_C_ppFixity z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Fixity d c e -> guardCons d c ((\x ->
    d_C_ppFixity e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Fixity d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppFixity" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppFixity" (showCons x1))

nd_C_ppFixity :: AbstractHaskell.Curry_Types.C_Fixity -> IDSupply -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppFixity x1 s cd cs = case x1 of
  AbstractHaskell.Curry_Types.C_InfixOp -> let s0 = s
    in s0 `seq` Text.Curry_Pretty.nd_C_text (Curry_Prelude.toCurryString
    "infix") s0 cd cs
  AbstractHaskell.Curry_Types.C_InfixlOp -> let s0 = s
    in s0 `seq` Text.Curry_Pretty.nd_C_text (Curry_Prelude.toCurryString
    "infixl") s0 cd cs
  AbstractHaskell.Curry_Types.C_InfixrOp -> let s0 = s
    in s0 `seq` Text.Curry_Pretty.nd_C_text (Curry_Prelude.toCurryString
    "infixr") s0 cd cs
  AbstractHaskell.Curry_Types.Choice_C_Fixity d i l r -> narrow d i
    (nd_C_ppFixity l s cd cs) (nd_C_ppFixity r s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Fixity d i xs -> narrows cs d i (\z ->
    nd_C_ppFixity z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Fixity d c e -> guardCons d c ((\x ->
    nd_C_ppFixity e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Fixity d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppFixity" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppFixity" (showCons x1))

d_C_ppTypeDecls :: C_Options -> Cover -> ConstStore -> Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_TypeDecl -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C_ppTypeDecls x1 cd cs = Curry_Prelude.d_OP_dot (Text.Curry_Pretty.d_C_compose
  (Text.Curry_Pretty.d_OP_lt_dollar_plus_dollar_gt cd cs))
  (Curry_Prelude.d_C_map (d_C_ppTypeDecl x1)) cd cs

nd_C_ppTypeDecls :: C_Options -> IDSupply -> Cover -> ConstStore -> Func
  (Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_TypeDecl)
  Text.Curry_PrettyImpl.C_Doc
nd_C_ppTypeDecls x1 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (wrapNX id
  (Text.Curry_Pretty.nd_C_compose
  (Text.Curry_Pretty.nd_OP_lt_dollar_plus_dollar_gt s0 cd cs))) (wrapNX id
  (Curry_Prelude.nd_C_map (wrapNX id (nd_C_ppTypeDecl x1)))) s1 cd cs))

d_C_ppTypeDecl :: C_Options -> AbstractHaskell.Curry_Types.C_TypeDecl -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C_ppTypeDecl x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_TypeSyn x3 x4 x5 x6 -> Curry_Prelude.d_OP_dollar
    (d_C_indent cd cs) (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_slash_gt cd cs) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (Text.Curry_Pretty.d_C_text
    (Curry_Prelude.toCurryString "type") cd cs) cd cs) (d_C_ppName x3 cd cs) cd
    cs) cd cs) (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_C_fillSep cd cs)
    (Curry_Prelude.d_C_map d_C_ppTypeVar x5 cd cs) cd cs) cd cs) cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (Text.Curry_Pretty.d_C_equals cd
    cs) cd cs) (Curry_Prelude.d_C_apply (d_C_ppTypeExp x1 cd cs) x6 cd cs) cd
    cs) cd cs) cd cs
  AbstractHaskell.Curry_Types.C_TypeNew x7 x8 x9 x10 -> Curry_Prelude.d_OP_dollar
    (d_C_indent cd cs) (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_slash_gt cd cs) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (Text.Curry_Pretty.d_C_text
    (Curry_Prelude.toCurryString "newtype") cd cs) cd cs) (d_C_ppName x7 cd cs)
    cd cs) cd cs) (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_C_fillSep cd cs)
    (Curry_Prelude.d_C_map d_C_ppTypeVar x9 cd cs) cd cs) cd cs) cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (Text.Curry_Pretty.d_C_equals cd
    cs) cd cs) (d_C_ppNewConsDecl x1 x10 cd cs) cd cs) cd cs) cd cs
  AbstractHaskell.Curry_Types.C_Type x11 x12 x13 x14 -> d_C__case_31 x14 x1 x13
    x11 (Curry_Prelude.d_C_null x14 cd cs) cd cs
  AbstractHaskell.Curry_Types.C_Instance x15 x16 x17 x18 -> Curry_Prelude.d_OP_dollar
    (d_C_indent cd cs) (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs)
    (Text.Curry_Pretty.d_C_text (Curry_Prelude.toCurryString "instance") cd cs)
    cd cs) (d_C_ppContexts x1 x17 cd cs) cd cs) cd cs) (d_C_ppQName x1 x15 cd
    cs) cd cs) cd cs) (d_C_ppTypeExpr x1 (Curry_Prelude.C_Int (2)) x16 cd cs) cd
    cs) cd cs) (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_dollar_dollar cd cs) (Text.Curry_Pretty.d_C_text
    (Curry_Prelude.toCurryString "where") cd cs) cd cs) (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_C_vsep cd cs) (Curry_Prelude.d_C_map
    (d_OP_ppTypeDecl_dot_ppInstRule_dot_64 x1) x18 cd cs) cd cs) cd cs) cd cs)
    cd cs
  AbstractHaskell.Curry_Types.Choice_C_TypeDecl d i l r -> narrow d i
    (d_C_ppTypeDecl x1 l cd cs) (d_C_ppTypeDecl x1 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_TypeDecl d i xs -> narrows cs d i (\z ->
    d_C_ppTypeDecl x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_TypeDecl d c e -> guardCons d c ((\x ->
    d_C_ppTypeDecl x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_TypeDecl d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppTypeDecl" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppTypeDecl" (showCons x2))

nd_C_ppTypeDecl :: C_Options -> AbstractHaskell.Curry_Types.C_TypeDecl
  -> IDSupply -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppTypeDecl x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_TypeSyn x3 x4 x5 x6 -> let s41 = s
    in s41 `seq` (let s40 = leftSupply s41
                      s42 = rightSupply s41
                      s0 = leftSupply s42
                      s38 = rightSupply s42
    in s40 `seq` (s42 `seq` (s0 `seq` (s38 `seq` Curry_Prelude.nd_OP_dollar
    (nd_C_indent s0 cd cs) (let s37 = leftSupply s38
                                s39 = rightSupply s38
                                s24 = leftSupply s39
                                s35 = rightSupply s39
    in s37 `seq` (s39 `seq` (s24 `seq` (s35 `seq` Curry_Prelude.nd_C_apply
    (let s23 = leftSupply s24
         s25 = rightSupply s24
         s1 = leftSupply s25
         s21 = rightSupply s25
    in s23 `seq` (s25 `seq` (s1 `seq` (s21 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_slash_gt s1 cd cs) (let s20 = leftSupply s21
                                                        s22 = rightSupply s21
                                                        s13 = leftSupply s22
                                                        s18 = rightSupply s22
    in s20 `seq` (s22 `seq` (s13 `seq` (s18 `seq` Curry_Prelude.nd_C_apply
    (let s12 = leftSupply s13
         s14 = rightSupply s13
         s2 = leftSupply s14
         s10 = rightSupply s14
    in s12 `seq` (s14 `seq` (s2 `seq` (s10 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s2 cd cs) (let s9 = leftSupply s10
                                                       s11 = rightSupply s10
                                                       s6 = leftSupply s11
                                                       s8 = rightSupply s11
    in s9 `seq` (s11 `seq` (s6 `seq` (s8 `seq` Curry_Prelude.nd_C_apply
    (let s5 = leftSupply s6
         s7 = rightSupply s6
         s3 = leftSupply s7
         s4 = rightSupply s7
    in s5 `seq` (s7 `seq` (s3 `seq` (s4 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s3 cd cs) (Text.Curry_Pretty.nd_C_text
    (Curry_Prelude.toCurryString "type") s4 cd cs) s5 cd cs)))) (nd_C_ppName x3
    s8 cd cs) s9 cd cs)))) s12 cd cs)))) (let s17 = leftSupply s18
                                              s19 = rightSupply s18
                                              s15 = leftSupply s19
                                              s16 = rightSupply s19
    in s17 `seq` (s19 `seq` (s15 `seq` (s16 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_fillSep s15 cd cs) (Curry_Prelude.nd_C_map (wrapNX
    id nd_C_ppTypeVar) x5 s16 cd cs) s17 cd cs)))) s20 cd cs)))) s23 cd cs))))
    (let s34 = leftSupply s35
         s36 = rightSupply s35
         s29 = leftSupply s36
         s33 = rightSupply s36
    in s34 `seq` (s36 `seq` (s29 `seq` (s33 `seq` Curry_Prelude.nd_C_apply
    (let s28 = leftSupply s29
         s30 = rightSupply s29
         s26 = leftSupply s30
         s27 = rightSupply s30
    in s28 `seq` (s30 `seq` (s26 `seq` (s27 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s26 cd cs)
    (Text.Curry_Pretty.nd_C_equals s27 cd cs) s28 cd cs))))
    (let s32 = leftSupply s33
         s31 = rightSupply s33
    in s32 `seq` (s31 `seq` Curry_Prelude.nd_C_apply (nd_C_ppTypeExp x1 s31 cd
    cs) x6 s32 cd cs)) s34 cd cs)))) s37 cd cs)))) s40 cd cs))))
  AbstractHaskell.Curry_Types.C_TypeNew x7 x8 x9 x10 -> let s39 = s
    in s39 `seq` (let s38 = leftSupply s39
                      s40 = rightSupply s39
                      s0 = leftSupply s40
                      s36 = rightSupply s40
    in s38 `seq` (s40 `seq` (s0 `seq` (s36 `seq` Curry_Prelude.nd_OP_dollar
    (nd_C_indent s0 cd cs) (let s35 = leftSupply s36
                                s37 = rightSupply s36
                                s24 = leftSupply s37
                                s33 = rightSupply s37
    in s35 `seq` (s37 `seq` (s24 `seq` (s33 `seq` Curry_Prelude.nd_C_apply
    (let s23 = leftSupply s24
         s25 = rightSupply s24
         s1 = leftSupply s25
         s21 = rightSupply s25
    in s23 `seq` (s25 `seq` (s1 `seq` (s21 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_slash_gt s1 cd cs) (let s20 = leftSupply s21
                                                        s22 = rightSupply s21
                                                        s13 = leftSupply s22
                                                        s18 = rightSupply s22
    in s20 `seq` (s22 `seq` (s13 `seq` (s18 `seq` Curry_Prelude.nd_C_apply
    (let s12 = leftSupply s13
         s14 = rightSupply s13
         s2 = leftSupply s14
         s10 = rightSupply s14
    in s12 `seq` (s14 `seq` (s2 `seq` (s10 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s2 cd cs) (let s9 = leftSupply s10
                                                       s11 = rightSupply s10
                                                       s6 = leftSupply s11
                                                       s8 = rightSupply s11
    in s9 `seq` (s11 `seq` (s6 `seq` (s8 `seq` Curry_Prelude.nd_C_apply
    (let s5 = leftSupply s6
         s7 = rightSupply s6
         s3 = leftSupply s7
         s4 = rightSupply s7
    in s5 `seq` (s7 `seq` (s3 `seq` (s4 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s3 cd cs) (Text.Curry_Pretty.nd_C_text
    (Curry_Prelude.toCurryString "newtype") s4 cd cs) s5 cd cs)))) (nd_C_ppName
    x7 s8 cd cs) s9 cd cs)))) s12 cd cs)))) (let s17 = leftSupply s18
                                                 s19 = rightSupply s18
                                                 s15 = leftSupply s19
                                                 s16 = rightSupply s19
    in s17 `seq` (s19 `seq` (s15 `seq` (s16 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_fillSep s15 cd cs) (Curry_Prelude.nd_C_map (wrapNX
    id nd_C_ppTypeVar) x9 s16 cd cs) s17 cd cs)))) s20 cd cs)))) s23 cd cs))))
    (let s32 = leftSupply s33
         s34 = rightSupply s33
         s29 = leftSupply s34
         s31 = rightSupply s34
    in s32 `seq` (s34 `seq` (s29 `seq` (s31 `seq` Curry_Prelude.nd_C_apply
    (let s28 = leftSupply s29
         s30 = rightSupply s29
         s26 = leftSupply s30
         s27 = rightSupply s30
    in s28 `seq` (s30 `seq` (s26 `seq` (s27 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s26 cd cs)
    (Text.Curry_Pretty.nd_C_equals s27 cd cs) s28 cd cs)))) (nd_C_ppNewConsDecl
    x1 x10 s31 cd cs) s32 cd cs)))) s35 cd cs)))) s38 cd cs))))
  AbstractHaskell.Curry_Types.C_Type x11 x12 x13 x14 -> let s0 = s
    in s0 `seq` nd_C__case_31 x14 x1 x13 x11 (Curry_Prelude.d_C_null x14 cd cs)
    s0 cd cs
  AbstractHaskell.Curry_Types.C_Instance x15 x16 x17 x18 -> let s47 = s
    in s47 `seq` (let s46 = leftSupply s47
                      s48 = rightSupply s47
                      s0 = leftSupply s48
                      s44 = rightSupply s48
    in s46 `seq` (s48 `seq` (s0 `seq` (s44 `seq` Curry_Prelude.nd_OP_dollar
    (nd_C_indent s0 cd cs) (let s43 = leftSupply s44
                                s45 = rightSupply s44
                                s28 = leftSupply s45
                                s41 = rightSupply s45
    in s43 `seq` (s45 `seq` (s28 `seq` (s41 `seq` Curry_Prelude.nd_C_apply
    (let s27 = leftSupply s28
         s29 = rightSupply s28
         s1 = leftSupply s29
         s25 = rightSupply s29
    in s27 `seq` (s29 `seq` (s1 `seq` (s25 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s1 cd cs) (let s24 = leftSupply s25
                                                       s26 = rightSupply s25
                                                       s21 = leftSupply s26
                                                       s23 = rightSupply s26
    in s24 `seq` (s26 `seq` (s21 `seq` (s23 `seq` Curry_Prelude.nd_C_apply
    (let s20 = leftSupply s21
         s22 = rightSupply s21
         s2 = leftSupply s22
         s18 = rightSupply s22
    in s20 `seq` (s22 `seq` (s2 `seq` (s18 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s2 cd cs) (let s17 = leftSupply s18
                                                       s19 = rightSupply s18
                                                       s14 = leftSupply s19
                                                       s16 = rightSupply s19
    in s17 `seq` (s19 `seq` (s14 `seq` (s16 `seq` Curry_Prelude.nd_C_apply
    (let s13 = leftSupply s14
         s15 = rightSupply s14
         s3 = leftSupply s15
         s11 = rightSupply s15
    in s13 `seq` (s15 `seq` (s3 `seq` (s11 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s3 cd cs) (let s10 = leftSupply s11
                                                       s12 = rightSupply s11
                                                       s7 = leftSupply s12
                                                       s9 = rightSupply s12
    in s10 `seq` (s12 `seq` (s7 `seq` (s9 `seq` Curry_Prelude.nd_C_apply
    (let s6 = leftSupply s7
         s8 = rightSupply s7
         s4 = leftSupply s8
         s5 = rightSupply s8
    in s6 `seq` (s8 `seq` (s4 `seq` (s5 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s4 cd cs) (Text.Curry_Pretty.nd_C_text
    (Curry_Prelude.toCurryString "instance") s5 cd cs) s6 cd cs))))
    (nd_C_ppContexts x1 x17 s9 cd cs) s10 cd cs)))) s13 cd cs)))) (nd_C_ppQName
    x1 x15 s16 cd cs) s17 cd cs)))) s20 cd cs)))) (nd_C_ppTypeExpr x1
    (Curry_Prelude.C_Int (2)) x16 s23 cd cs) s24 cd cs)))) s27 cd cs))))
    (let s40 = leftSupply s41
         s42 = rightSupply s41
         s33 = leftSupply s42
         s38 = rightSupply s42
    in s40 `seq` (s42 `seq` (s33 `seq` (s38 `seq` Curry_Prelude.nd_C_apply
    (let s32 = leftSupply s33
         s34 = rightSupply s33
         s30 = leftSupply s34
         s31 = rightSupply s34
    in s32 `seq` (s34 `seq` (s30 `seq` (s31 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_dollar_dollar s30 cd cs)
    (Text.Curry_Pretty.nd_C_text (Curry_Prelude.toCurryString "where") s31 cd
    cs) s32 cd cs)))) (let s37 = leftSupply s38
                           s39 = rightSupply s38
                           s35 = leftSupply s39
                           s36 = rightSupply s39
    in s37 `seq` (s39 `seq` (s35 `seq` (s36 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_vsep s35 cd cs) (Curry_Prelude.nd_C_map (wrapNX id
    (nd_OP_ppTypeDecl_dot_ppInstRule_dot_64 x1)) x18 s36 cd cs) s37 cd cs))))
    s40 cd cs)))) s43 cd cs)))) s46 cd cs))))
  AbstractHaskell.Curry_Types.Choice_C_TypeDecl d i l r -> narrow d i
    (nd_C_ppTypeDecl x1 l s cd cs) (nd_C_ppTypeDecl x1 r s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_TypeDecl d i xs -> narrows cs d i (\z ->
    nd_C_ppTypeDecl x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_TypeDecl d c e -> guardCons d c ((\x ->
    nd_C_ppTypeDecl x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_TypeDecl d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppTypeDecl" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppTypeDecl" (showCons x2))

d_OP_ppTypeDecl_dot_ppInstRule_dot_64 :: forall t0 . (Curry_Prelude.Curry
  t0) => C_Options -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 t0
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  AbstractHaskell.Curry_Types.C_Rule -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_OP_ppTypeDecl_dot_ppInstRule_dot_64 x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> d_C__case_29 x4 x1 x3 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_ppTypeDecl_dot_ppInstRule_dot_64 x1 l cd cs)
    (d_OP_ppTypeDecl_dot_ppInstRule_dot_64 x1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_ppTypeDecl_dot_ppInstRule_dot_64 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_ppTypeDecl_dot_ppInstRule_dot_64 x1 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppTypeDecl.ppInstRule.64" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppTypeDecl.ppInstRule.64"
    (showCons x2))

nd_OP_ppTypeDecl_dot_ppInstRule_dot_64 :: forall t0 . (Curry_Prelude.Curry
  t0) => C_Options -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Tuple2 t0
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  AbstractHaskell.Curry_Types.C_Rule -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_OP_ppTypeDecl_dot_ppInstRule_dot_64 x1 x2 s cd cs = case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> let s0 = s
    in s0 `seq` nd_C__case_29 x4 x1 x3 s0 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (nd_OP_ppTypeDecl_dot_ppInstRule_dot_64 x1 l s cd cs)
    (nd_OP_ppTypeDecl_dot_ppInstRule_dot_64 x1 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    nd_OP_ppTypeDecl_dot_ppInstRule_dot_64 x1 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    nd_OP_ppTypeDecl_dot_ppInstRule_dot_64 x1 e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppTypeDecl.ppInstRule.64" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppTypeDecl.ppInstRule.64"
    (showCons x2))

d_C_ppConsDecls :: C_Options -> Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_ConsDecl -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C_ppConsDecls x1 x2 cd cs = Curry_Prelude.d_OP_dollar
  (Text.Curry_Pretty.d_C_vsep cd cs) (Curry_Prelude.d_C_zipWith
  (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (Curry_Prelude.OP_Cons
  (Text.Curry_Pretty.d_C_equals cd cs) (Curry_Prelude.d_C_repeat
  (Text.Curry_Pretty.d_C_bar cd cs) cd cs)) (Curry_Prelude.d_C_map
  (d_C_ppConsDecl x1) x2 cd cs) cd cs) cd cs

nd_C_ppConsDecls :: C_Options -> Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_ConsDecl -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppConsDecls x1 x2 s cd cs = let s11 = s
  in s11 `seq` (let s10 = leftSupply s11
                    s12 = rightSupply s11
                    s0 = leftSupply s12
                    s7 = rightSupply s12
  in s10 `seq` (s12 `seq` (s0 `seq` (s7 `seq` Curry_Prelude.nd_OP_dollar
  (Text.Curry_Pretty.nd_C_vsep s0 cd cs) (let s8 = leftSupply s7
                                              s9 = rightSupply s7
                                              s6 = leftSupply s8
                                              s1 = rightSupply s8
                                              s4 = leftSupply s9
                                              s5 = rightSupply s9
  in s8 `seq` (s9 `seq` (s6 `seq` (s1 `seq` (s4 `seq` (s5 `seq`
  Curry_Prelude.nd_C_zipWith (Text.Curry_Pretty.nd_OP_lt_plus_gt s1 cd cs)
  (let s2 = leftSupply s4
       s3 = rightSupply s4
  in s2 `seq` (s3 `seq` Curry_Prelude.OP_Cons (Text.Curry_Pretty.nd_C_equals s2
  cd cs) (Curry_Prelude.d_C_repeat (Text.Curry_Pretty.nd_C_bar s3 cd cs) cd
  cs))) (Curry_Prelude.nd_C_map (wrapNX id (nd_C_ppConsDecl x1)) x2 s5 cd cs) s6
  cd cs)))))) s10 cd cs))))

d_C_ppConsDecl :: C_Options -> AbstractHaskell.Curry_Types.C_ConsDecl -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C_ppConsDecl x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Cons x3 x4 x5 x6 -> d_C__case_28 x6 x1 x3 cd cs
  AbstractHaskell.Curry_Types.Choice_C_ConsDecl d i l r -> narrow d i
    (d_C_ppConsDecl x1 l cd cs) (d_C_ppConsDecl x1 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_ConsDecl d i xs -> narrows cs d i (\z ->
    d_C_ppConsDecl x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_ConsDecl d c e -> guardCons d c ((\x ->
    d_C_ppConsDecl x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_ConsDecl d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppConsDecl" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppConsDecl" (showCons x2))

nd_C_ppConsDecl :: C_Options -> AbstractHaskell.Curry_Types.C_ConsDecl
  -> IDSupply -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppConsDecl x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Cons x3 x4 x5 x6 -> let s0 = s
    in s0 `seq` nd_C__case_28 x6 x1 x3 s0 cd cs
  AbstractHaskell.Curry_Types.Choice_C_ConsDecl d i l r -> narrow d i
    (nd_C_ppConsDecl x1 l s cd cs) (nd_C_ppConsDecl x1 r s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_ConsDecl d i xs -> narrows cs d i (\z ->
    nd_C_ppConsDecl x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_ConsDecl d c e -> guardCons d c ((\x ->
    nd_C_ppConsDecl x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_ConsDecl d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppConsDecl" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppConsDecl" (showCons x2))

d_C_ppNewConsDecl :: C_Options -> AbstractHaskell.Curry_Types.C_NewConsDecl
  -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C_ppNewConsDecl x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_NewCons x3 x4 x5 -> d_C__case_27 x5 x1 x3 cd cs
  AbstractHaskell.Curry_Types.Choice_C_NewConsDecl d i l r -> narrow d i
    (d_C_ppNewConsDecl x1 l cd cs) (d_C_ppNewConsDecl x1 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_NewConsDecl d i xs -> narrows cs d i
    (\z -> d_C_ppNewConsDecl x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_NewConsDecl d c e -> guardCons d c ((\x ->
    d_C_ppNewConsDecl x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_NewConsDecl d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppNewConsDecl" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppNewConsDecl" (showCons
    x2))

nd_C_ppNewConsDecl :: C_Options -> AbstractHaskell.Curry_Types.C_NewConsDecl
  -> IDSupply -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppNewConsDecl x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_NewCons x3 x4 x5 -> let s0 = s
    in s0 `seq` nd_C__case_27 x5 x1 x3 s0 cd cs
  AbstractHaskell.Curry_Types.Choice_C_NewConsDecl d i l r -> narrow d i
    (nd_C_ppNewConsDecl x1 l s cd cs) (nd_C_ppNewConsDecl x1 r s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_NewConsDecl d i xs -> narrows cs d i
    (\z -> nd_C_ppNewConsDecl x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_NewConsDecl d c e -> guardCons d c ((\x ->
    nd_C_ppNewConsDecl x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_NewConsDecl d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppNewConsDecl" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppNewConsDecl" (showCons
    x2))

d_C_ppContexts :: C_Options -> Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_Context -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C_ppContexts x1 x2 cd cs = d_C__case_26 x2 x1 (Curry_Prelude.d_C_null x2 cd
  cs) cd cs

nd_C_ppContexts :: C_Options -> Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_Context -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppContexts x1 x2 s cd cs = let s0 = s
  in s0 `seq` nd_C__case_26 x2 x1 (Curry_Prelude.d_C_null x2 cd cs) s0 cd cs

d_C_ppContext :: C_Options -> AbstractHaskell.Curry_Types.C_Context -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C_ppContext x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Context x3 x4 x5 x6 -> let x7 = d_C__case_24 x3
                                                             (Curry_Prelude.d_C_null
                                                             x3 cd cs) cd cs
    in Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) x7 cd cs)
    (d_C_ppContexts x1 x4 cd cs) cd cs) cd cs) (Curry_Prelude.d_C_apply
    (d_C_ppTypeExp x1 cd cs) (AbstractHaskell.Curry_Types.C_TCons x5 x6) cd cs)
    cd cs
  AbstractHaskell.Curry_Types.Choice_C_Context d i l r -> narrow d i
    (d_C_ppContext x1 l cd cs) (d_C_ppContext x1 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Context d i xs -> narrows cs d i (\z ->
    d_C_ppContext x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Context d c e -> guardCons d c ((\x ->
    d_C_ppContext x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Context d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppContext" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppContext" (showCons x2))

nd_C_ppContext :: C_Options -> AbstractHaskell.Curry_Types.C_Context -> IDSupply
  -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppContext x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Context x3 x4 x5 x6 -> let s18 = s
    in s18 `seq` (let s0 = leftSupply s18
                      s16 = rightSupply s18
    in s0 `seq` (s16 `seq` (let x7 = nd_C__case_24 x3 (Curry_Prelude.d_C_null x3
                                  cd cs) s0 cd cs
    in let s15 = leftSupply s16
           s17 = rightSupply s16
           s10 = leftSupply s17
           s14 = rightSupply s17
    in s15 `seq` (s17 `seq` (s10 `seq` (s14 `seq` Curry_Prelude.nd_C_apply
    (let s9 = leftSupply s10
         s11 = rightSupply s10
         s1 = leftSupply s11
         s7 = rightSupply s11
    in s9 `seq` (s11 `seq` (s1 `seq` (s7 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s1 cd cs) (let s6 = leftSupply s7
                                                       s8 = rightSupply s7
                                                       s4 = leftSupply s8
                                                       s5 = rightSupply s8
    in s6 `seq` (s8 `seq` (s4 `seq` (s5 `seq` Curry_Prelude.nd_C_apply
    (let s3 = leftSupply s4
         s2 = rightSupply s4
    in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s2 cd cs) x7 s3 cd cs)) (nd_C_ppContexts
    x1 x4 s5 cd cs) s6 cd cs)))) s9 cd cs)))) (let s13 = leftSupply s14
                                                   s12 = rightSupply s14
    in s13 `seq` (s12 `seq` Curry_Prelude.nd_C_apply (nd_C_ppTypeExp x1 s12 cd
    cs) (AbstractHaskell.Curry_Types.C_TCons x5 x6) s13 cd cs)) s15 cd cs))))))
  AbstractHaskell.Curry_Types.Choice_C_Context d i l r -> narrow d i
    (nd_C_ppContext x1 l s cd cs) (nd_C_ppContext x1 r s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Context d i xs -> narrows cs d i (\z ->
    nd_C_ppContext x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Context d c e -> guardCons d c ((\x ->
    nd_C_ppContext x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Context d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppContext" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppContext" (showCons x2))

d_C_ppTypeExp :: C_Options -> Cover -> ConstStore
  -> AbstractHaskell.Curry_Types.C_TypeExpr -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C_ppTypeExp x1 cd cs = d_C_ppTypeExpr x1 (Curry_Prelude.C_Int (0))

nd_C_ppTypeExp :: C_Options -> IDSupply -> Cover -> ConstStore -> Func
  AbstractHaskell.Curry_Types.C_TypeExpr Text.Curry_PrettyImpl.C_Doc
nd_C_ppTypeExp x1 s cd cs = wrapNX id (nd_C_ppTypeExpr x1 (Curry_Prelude.C_Int
  (0)))

d_C_ppTypeExpr :: C_Options -> Curry_Prelude.C_Int
  -> AbstractHaskell.Curry_Types.C_TypeExpr -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C_ppTypeExpr x1 x2 x3 cd cs = case x3 of
  AbstractHaskell.Curry_Types.C_TVar x4 -> d_C_ppTypeVar x4 cd cs
  AbstractHaskell.Curry_Types.C_FuncType x5 x6 -> Curry_Prelude.d_OP_dollar
    (d_C_parensIf (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
    cd cs) x2 cd cs) (Curry_Prelude.C_Int (0)) cd cs)) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_OP_lt_slash_gt cd cs)
    (d_C_ppTypeExpr x1 (Curry_Prelude.C_Int (1)) x5 cd cs) cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (Text.Curry_Pretty.d_C_rarrow cd
    cs) cd cs) (Curry_Prelude.d_C_apply (d_C_ppTypeExp x1 cd cs) x6 cd cs) cd
    cs) cd cs) cd cs
  AbstractHaskell.Curry_Types.C_TCons x7 x8 -> d_C__case_22 x8 x7 x1 x2
    (Curry_Prelude.d_OP_amp_amp (d_C_isList x7 cd cs)
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int_hash
    (Curry_Prelude.d_C_length x8 cd cs) (Curry_Prelude.C_Int (1)) cd cs) cd cs)
    cd cs
  AbstractHaskell.Curry_Types.C_ForallType x9 x10 x11 -> Curry_Prelude.d_OP_dollar
    (d_C_parensIf (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
    cd cs) x2 cd cs) (Curry_Prelude.C_Int (0)) cd cs)) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (Text.Curry_Pretty.d_C_text
    (Curry_Prelude.toCurryString "forall") cd cs) cd cs)
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_C_fillSep cd cs)
    (Curry_Prelude.d_C_map (Curry_Prelude.d_OP_dot d_C_ppTypeVar
    Curry_Prelude.d_C_fst cd cs) x9 cd cs) cd cs) cd cs) cd cs)
    (Text.Curry_Pretty.d_C_dot cd cs) cd cs) cd cs) (d_C_ppContexts x1 x10 cd
    cs) cd cs) cd cs) (Curry_Prelude.d_C_apply (d_C_ppTypeExp x1 cd cs) x11 cd
    cs) cd cs) cd cs
  AbstractHaskell.Curry_Types.Choice_C_TypeExpr d i l r -> narrow d i
    (d_C_ppTypeExpr x1 x2 l cd cs) (d_C_ppTypeExpr x1 x2 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_TypeExpr d i xs -> narrows cs d i (\z ->
    d_C_ppTypeExpr x1 x2 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_TypeExpr d c e -> guardCons d c ((\x ->
    d_C_ppTypeExpr x1 x2 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_TypeExpr d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppTypeExpr" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppTypeExpr" (showCons x3))

nd_C_ppTypeExpr :: C_Options -> Curry_Prelude.C_Int
  -> AbstractHaskell.Curry_Types.C_TypeExpr -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppTypeExpr x1 x2 x3 s cd cs = case x3 of
  AbstractHaskell.Curry_Types.C_TVar x4 -> let s0 = s
    in s0 `seq` nd_C_ppTypeVar x4 s0 cd cs
  AbstractHaskell.Curry_Types.C_FuncType x5 x6 -> let s23 = s
    in s23 `seq` (let s22 = leftSupply s23
                      s24 = rightSupply s23
                      s2 = leftSupply s24
                      s20 = rightSupply s24
    in s22 `seq` (s24 `seq` (s2 `seq` (s20 `seq` Curry_Prelude.nd_OP_dollar
    (wrapNX id (nd_C_parensIf (let s1 = leftSupply s2
                                   s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply
    (wrapDX (wrapDX id)
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
    cd cs)) x2 s0 cd cs) (Curry_Prelude.C_Int (0)) s1 cd cs))))
    (let s19 = leftSupply s20
         s21 = rightSupply s20
         s6 = leftSupply s21
         s17 = rightSupply s21
    in s19 `seq` (s21 `seq` (s6 `seq` (s17 `seq` Curry_Prelude.nd_C_apply
    (let s5 = leftSupply s6
         s7 = rightSupply s6
         s3 = leftSupply s7
         s4 = rightSupply s7
    in s5 `seq` (s7 `seq` (s3 `seq` (s4 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_slash_gt s3 cd cs) (nd_C_ppTypeExpr x1
    (Curry_Prelude.C_Int (1)) x5 s4 cd cs) s5 cd cs)))) (let s16 = leftSupply
                                                               s17
                                                             s18 = rightSupply
                                                               s17
                                                             s11 = leftSupply
                                                               s18
                                                             s15 = rightSupply
                                                               s18
    in s16 `seq` (s18 `seq` (s11 `seq` (s15 `seq` Curry_Prelude.nd_C_apply
    (let s10 = leftSupply s11
         s12 = rightSupply s11
         s8 = leftSupply s12
         s9 = rightSupply s12
    in s10 `seq` (s12 `seq` (s8 `seq` (s9 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s8 cd cs) (Text.Curry_Pretty.nd_C_rarrow
    s9 cd cs) s10 cd cs)))) (let s14 = leftSupply s15
                                 s13 = rightSupply s15
    in s14 `seq` (s13 `seq` Curry_Prelude.nd_C_apply (nd_C_ppTypeExp x1 s13 cd
    cs) x6 s14 cd cs)) s16 cd cs)))) s19 cd cs)))) s22 cd cs))))
  AbstractHaskell.Curry_Types.C_TCons x7 x8 -> let s0 = s
    in s0 `seq` nd_C__case_22 x8 x7 x1 x2 (Curry_Prelude.d_OP_amp_amp
    (d_C_isList x7 cd cs)
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Int_hash
    (Curry_Prelude.d_C_length x8 cd cs) (Curry_Prelude.C_Int (1)) cd cs) cd cs)
    s0 cd cs
  AbstractHaskell.Curry_Types.C_ForallType x9 x10 x11 -> let s45 = s
    in s45 `seq` (let s44 = leftSupply s45
                      s46 = rightSupply s45
                      s2 = leftSupply s46
                      s42 = rightSupply s46
    in s44 `seq` (s46 `seq` (s2 `seq` (s42 `seq` Curry_Prelude.nd_OP_dollar
    (wrapNX id (nd_C_parensIf (let s1 = leftSupply s2
                                   s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply
    (wrapDX (wrapDX id)
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
    cd cs)) x2 s0 cd cs) (Curry_Prelude.C_Int (0)) s1 cd cs))))
    (let s41 = leftSupply s42
         s43 = rightSupply s42
         s36 = leftSupply s43
         s40 = rightSupply s43
    in s41 `seq` (s43 `seq` (s36 `seq` (s40 `seq` Curry_Prelude.nd_C_apply
    (let s35 = leftSupply s36
         s37 = rightSupply s36
         s3 = leftSupply s37
         s33 = rightSupply s37
    in s35 `seq` (s37 `seq` (s3 `seq` (s33 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s3 cd cs) (let s32 = leftSupply s33
                                                       s34 = rightSupply s33
                                                       s29 = leftSupply s34
                                                       s31 = rightSupply s34
    in s32 `seq` (s34 `seq` (s29 `seq` (s31 `seq` Curry_Prelude.nd_C_apply
    (let s28 = leftSupply s29
         s30 = rightSupply s29
         s4 = leftSupply s30
         s26 = rightSupply s30
    in s28 `seq` (s30 `seq` (s4 `seq` (s26 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s4 cd cs) (let s25 = leftSupply s26
                                                       s27 = rightSupply s26
                                                       s22 = leftSupply s27
                                                       s24 = rightSupply s27
    in s25 `seq` (s27 `seq` (s22 `seq` (s24 `seq` Curry_Prelude.nd_C_apply
    (let s21 = leftSupply s22
         s23 = rightSupply s22
         s5 = leftSupply s23
         s19 = rightSupply s23
    in s21 `seq` (s23 `seq` (s5 `seq` (s19 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s5 cd cs) (let s18 = leftSupply s19
                                                       s20 = rightSupply s19
                                                       s9 = leftSupply s20
                                                       s16 = rightSupply s20
    in s18 `seq` (s20 `seq` (s9 `seq` (s16 `seq` Curry_Prelude.nd_C_apply
    (let s8 = leftSupply s9
         s10 = rightSupply s9
         s6 = leftSupply s10
         s7 = rightSupply s10
    in s8 `seq` (s10 `seq` (s6 `seq` (s7 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s6 cd cs) (Text.Curry_Pretty.nd_C_text
    (Curry_Prelude.toCurryString "forall") s7 cd cs) s8 cd cs))))
    (let s15 = leftSupply s16
         s17 = rightSupply s16
         s11 = leftSupply s17
         s14 = rightSupply s17
    in s15 `seq` (s17 `seq` (s11 `seq` (s14 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_fillSep s11 cd cs) (let s13 = leftSupply s14
                                                    s12 = rightSupply s14
    in s13 `seq` (s12 `seq` Curry_Prelude.nd_C_map (Curry_Prelude.nd_OP_dot
    (wrapNX id nd_C_ppTypeVar) (wrapDX id Curry_Prelude.d_C_fst) s12 cd cs) x9
    s13 cd cs)) s15 cd cs)))) s18 cd cs)))) s21 cd cs))))
    (Text.Curry_Pretty.nd_C_dot s24 cd cs) s25 cd cs)))) s28 cd cs))))
    (nd_C_ppContexts x1 x10 s31 cd cs) s32 cd cs)))) s35 cd cs))))
    (let s39 = leftSupply s40
         s38 = rightSupply s40
    in s39 `seq` (s38 `seq` Curry_Prelude.nd_C_apply (nd_C_ppTypeExp x1 s38 cd
    cs) x11 s39 cd cs)) s41 cd cs)))) s44 cd cs))))
  AbstractHaskell.Curry_Types.Choice_C_TypeExpr d i l r -> narrow d i
    (nd_C_ppTypeExpr x1 x2 l s cd cs) (nd_C_ppTypeExpr x1 x2 r s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_TypeExpr d i xs -> narrows cs d i (\z ->
    nd_C_ppTypeExpr x1 x2 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_TypeExpr d c e -> guardCons d c ((\x ->
    nd_C_ppTypeExpr x1 x2 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_TypeExpr d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppTypeExpr" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppTypeExpr" (showCons x3))

d_C_ppTypeVar :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C_ppTypeVar x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> Text.Curry_Pretty.d_C_text x3 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C_ppTypeVar l cd cs)
    (d_C_ppTypeVar r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C_ppTypeVar
    z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x -> d_C_ppTypeVar e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppTypeVar" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppTypeVar" (showCons x1))

nd_C_ppTypeVar :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppTypeVar x1 s cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> let s0 = s
    in s0 `seq` Text.Curry_Pretty.nd_C_text x3 s0 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (nd_C_ppTypeVar l s cd
    cs) (nd_C_ppTypeVar r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> nd_C_ppTypeVar
    z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x -> nd_C_ppTypeVar e
    s cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppTypeVar" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppTypeVar" (showCons x1))

d_C_ppFunc :: Cover -> ConstStore -> AbstractHaskell.Curry_Types.C_FuncDecl
  -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C_ppFunc cd cs = d_C_ppFuncDecl (d_C_defaultOptions cd cs)

nd_C_ppFunc :: IDSupply -> Cover -> ConstStore -> Func
  AbstractHaskell.Curry_Types.C_FuncDecl Text.Curry_PrettyImpl.C_Doc
nd_C_ppFunc s cd cs = let s0 = s
  in s0 `seq` wrapNX id (nd_C_ppFuncDecl (nd_C_defaultOptions s0 cd cs))

d_C_ppFuncDecls :: C_Options -> Cover -> ConstStore -> Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_FuncDecl -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C_ppFuncDecls x1 cd cs = Curry_Prelude.d_OP_dot (Text.Curry_Pretty.d_C_compose
  (Text.Curry_Pretty.d_OP_lt_dollar_plus_dollar_gt cd cs))
  (Curry_Prelude.d_C_map (d_C_ppFuncDecl x1)) cd cs

nd_C_ppFuncDecls :: C_Options -> IDSupply -> Cover -> ConstStore -> Func
  (Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_FuncDecl)
  Text.Curry_PrettyImpl.C_Doc
nd_C_ppFuncDecls x1 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (wrapNX id
  (Text.Curry_Pretty.nd_C_compose
  (Text.Curry_Pretty.nd_OP_lt_dollar_plus_dollar_gt s0 cd cs))) (wrapNX id
  (Curry_Prelude.nd_C_map (wrapNX id (nd_C_ppFuncDecl x1)))) s1 cd cs))

d_C_ppFuncDecl :: C_Options -> AbstractHaskell.Curry_Types.C_FuncDecl -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C_ppFuncDecl x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Func x3 x4 x5 x6 x7 x8 -> d_C__case_19 x4 x1 x7
    x3 x8 cd cs
  AbstractHaskell.Curry_Types.Choice_C_FuncDecl d i l r -> narrow d i
    (d_C_ppFuncDecl x1 l cd cs) (d_C_ppFuncDecl x1 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_FuncDecl d i xs -> narrows cs d i (\z ->
    d_C_ppFuncDecl x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_FuncDecl d c e -> guardCons d c ((\x ->
    d_C_ppFuncDecl x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_FuncDecl d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppFuncDecl" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppFuncDecl" (showCons x2))

nd_C_ppFuncDecl :: C_Options -> AbstractHaskell.Curry_Types.C_FuncDecl
  -> IDSupply -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppFuncDecl x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Func x3 x4 x5 x6 x7 x8 -> let s0 = s
    in s0 `seq` nd_C__case_19 x4 x1 x7 x3 x8 s0 cd cs
  AbstractHaskell.Curry_Types.Choice_C_FuncDecl d i l r -> narrow d i
    (nd_C_ppFuncDecl x1 l s cd cs) (nd_C_ppFuncDecl x1 r s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_FuncDecl d i xs -> narrows cs d i (\z ->
    nd_C_ppFuncDecl x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_FuncDecl d c e -> guardCons d c ((\x ->
    nd_C_ppFuncDecl x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_FuncDecl d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppFuncDecl" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppFuncDecl" (showCons x2))

d_C_ppComment :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C_ppComment cd cs = Curry_Prelude.d_OP_dot (Text.Curry_Pretty.d_C_vsep cd cs)
  (Curry_Prelude.d_OP_dot (Curry_Prelude.d_C_map
  d_OP_ppComment_dot_uscore_hash_lambda22) Curry_Prelude.d_C_lines cd cs) cd cs

nd_C_ppComment :: IDSupply -> Cover -> ConstStore -> Func (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) Text.Curry_PrettyImpl.C_Doc
nd_C_ppComment s cd cs = let s3 = s
  in s3 `seq` (let s2 = leftSupply s3
                   s4 = rightSupply s3
                   s0 = leftSupply s4
                   s1 = rightSupply s4
  in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` Curry_Prelude.nd_OP_dot
  (Text.Curry_Pretty.nd_C_vsep s0 cd cs) (Curry_Prelude.nd_OP_dot (wrapNX id
  (Curry_Prelude.nd_C_map (wrapNX id nd_OP_ppComment_dot_uscore_hash_lambda22)))
  (wrapDX id Curry_Prelude.d_C_lines) s1 cd cs) s2 cd cs))))

d_OP_ppComment_dot_uscore_hash_lambda22 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_OP_ppComment_dot_uscore_hash_lambda22 x1 cd cs = Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs)
  (Text.Curry_Pretty.d_C_text (Curry_Prelude.toCurryString "---") cd cs) cd cs)
  (Text.Curry_Pretty.d_C_text x1 cd cs) cd cs

nd_OP_ppComment_dot_uscore_hash_lambda22 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_OP_ppComment_dot_uscore_hash_lambda22 x1 s cd cs = let s7 = s
  in s7 `seq` (let s6 = leftSupply s7
                   s8 = rightSupply s7
                   s3 = leftSupply s8
                   s5 = rightSupply s8
  in s6 `seq` (s8 `seq` (s3 `seq` (s5 `seq` Curry_Prelude.nd_C_apply
  (let s2 = leftSupply s3
       s4 = rightSupply s3
       s0 = leftSupply s4
       s1 = rightSupply s4
  in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` Curry_Prelude.nd_C_apply
  (Text.Curry_Pretty.nd_OP_lt_plus_gt s0 cd cs) (Text.Curry_Pretty.nd_C_text
  (Curry_Prelude.toCurryString "---") s1 cd cs) s2 cd cs))))
  (Text.Curry_Pretty.nd_C_text x1 s5 cd cs) s6 cd cs))))

d_C_ppTypeSig :: C_Options -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> AbstractHaskell.Curry_Types.C_TypeSig -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C_ppTypeSig x1 x2 x3 cd cs = case x3 of
  AbstractHaskell.Curry_Types.C_Untyped -> Text.Curry_Pretty.d_C_empty cd cs
  AbstractHaskell.Curry_Types.C_CType x4 x5 -> Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_C_hsep cd cs) (Curry_Prelude.OP_Cons (d_C_ppPrefixOp x2
    cd cs) (Curry_Prelude.OP_Cons (Text.Curry_Pretty.d_C_doubleColon cd cs)
    (Curry_Prelude.OP_Cons (d_C_ppScopedTyVars x5 cd cs) (Curry_Prelude.OP_Cons
    (d_C_ppContexts x1 x4 cd cs) (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply
    (d_C_ppTypeExp x1 cd cs) x5 cd cs) Curry_Prelude.OP_List))))) cd cs
  AbstractHaskell.Curry_Types.Choice_C_TypeSig d i l r -> narrow d i
    (d_C_ppTypeSig x1 x2 l cd cs) (d_C_ppTypeSig x1 x2 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_TypeSig d i xs -> narrows cs d i (\z ->
    d_C_ppTypeSig x1 x2 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_TypeSig d c e -> guardCons d c ((\x ->
    d_C_ppTypeSig x1 x2 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_TypeSig d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppTypeSig" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppTypeSig" (showCons x3))

nd_C_ppTypeSig :: C_Options -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> AbstractHaskell.Curry_Types.C_TypeSig -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppTypeSig x1 x2 x3 s cd cs = case x3 of
  AbstractHaskell.Curry_Types.C_Untyped -> let s0 = s
    in s0 `seq` Text.Curry_Pretty.nd_C_empty s0 cd cs
  AbstractHaskell.Curry_Types.C_CType x4 x5 -> let s13 = s
    in s13 `seq` (let s12 = leftSupply s13
                      s14 = rightSupply s13
                      s0 = leftSupply s14
                      s11 = rightSupply s14
    in s12 `seq` (s14 `seq` (s0 `seq` (s11 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_hsep s0 cd cs) (let s1 = leftSupply s11
                                                s10 = rightSupply s11
    in s1 `seq` (s10 `seq` Curry_Prelude.OP_Cons (nd_C_ppPrefixOp x2 s1 cd cs)
    (let s2 = leftSupply s10
         s9 = rightSupply s10
    in s2 `seq` (s9 `seq` Curry_Prelude.OP_Cons
    (Text.Curry_Pretty.nd_C_doubleColon s2 cd cs) (let s3 = leftSupply s9
                                                       s8 = rightSupply s9
    in s3 `seq` (s8 `seq` Curry_Prelude.OP_Cons (nd_C_ppScopedTyVars x5 s3 cd
    cs) (let s4 = leftSupply s8
             s7 = rightSupply s8
    in s4 `seq` (s7 `seq` Curry_Prelude.OP_Cons (nd_C_ppContexts x1 x4 s4 cd cs)
    (Curry_Prelude.OP_Cons (let s6 = leftSupply s7
                                s5 = rightSupply s7
    in s6 `seq` (s5 `seq` Curry_Prelude.nd_C_apply (nd_C_ppTypeExp x1 s5 cd cs)
    x5 s6 cd cs)) Curry_Prelude.OP_List))))))))) s12 cd cs))))
  AbstractHaskell.Curry_Types.Choice_C_TypeSig d i l r -> narrow d i
    (nd_C_ppTypeSig x1 x2 l s cd cs) (nd_C_ppTypeSig x1 x2 r s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_TypeSig d i xs -> narrows cs d i (\z ->
    nd_C_ppTypeSig x1 x2 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_TypeSig d c e -> guardCons d c ((\x ->
    nd_C_ppTypeSig x1 x2 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_TypeSig d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppTypeSig" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppTypeSig" (showCons x3))

d_C_ppScopedTyVars :: AbstractHaskell.Curry_Types.C_TypeExpr -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C_ppScopedTyVars x1 cd cs =
  let x2 = AbstractHaskell.Curry_Goodies.d_C_tyVarsOf x1 cd cs
  in d_C__case_17 x2 (Curry_Prelude.d_C_null x2 cd cs) cd cs

nd_C_ppScopedTyVars :: AbstractHaskell.Curry_Types.C_TypeExpr -> IDSupply
  -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppScopedTyVars x1 s cd cs = let s0 = s
  in s0 `seq` (let x2 = AbstractHaskell.Curry_Goodies.d_C_tyVarsOf x1 cd cs
  in nd_C__case_17 x2 (Curry_Prelude.d_C_null x2 cd cs) s0 cd cs)

d_C_ppRule :: C_Options -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> AbstractHaskell.Curry_Types.C_Rule -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C_ppRule x1 x2 x3 cd cs = case x3 of
  AbstractHaskell.Curry_Types.C_Rule x4 x5 x6 -> Curry_Prelude.d_OP_dollar
    (d_C_indent cd cs) (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_dollar_dollar cd cs) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_OP_lt_slash_gt cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_C_hsep cd cs) (Curry_Prelude.OP_Cons (d_C_ppPrefixOp x2
    cd cs) (Curry_Prelude.d_C_map (d_C_ppPattern x1 (Curry_Prelude.C_Int (1)))
    x4 cd cs)) cd cs) cd cs) (Text.Curry_Pretty.d_C_equals cd cs) cd cs) cd cs)
    (d_C_ppRhs x1 x5 cd cs) cd cs) cd cs) (d_C_ppLocalDecls x1 x6 cd cs) cd cs)
    cd cs
  AbstractHaskell.Curry_Types.Choice_C_Rule d i l r -> narrow d i (d_C_ppRule x1
    x2 l cd cs) (d_C_ppRule x1 x2 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Rule d i xs -> narrows cs d i (\z ->
    d_C_ppRule x1 x2 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Rule d c e -> guardCons d c ((\x ->
    d_C_ppRule x1 x2 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Rule d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppRule" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppRule" (showCons x3))

nd_C_ppRule :: C_Options -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> AbstractHaskell.Curry_Types.C_Rule -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppRule x1 x2 x3 s cd cs = case x3 of
  AbstractHaskell.Curry_Types.C_Rule x4 x5 x6 -> let s33 = s
    in s33 `seq` (let s32 = leftSupply s33
                      s34 = rightSupply s33
                      s0 = leftSupply s34
                      s30 = rightSupply s34
    in s32 `seq` (s34 `seq` (s0 `seq` (s30 `seq` Curry_Prelude.nd_OP_dollar
    (nd_C_indent s0 cd cs) (let s29 = leftSupply s30
                                s31 = rightSupply s30
                                s26 = leftSupply s31
                                s28 = rightSupply s31
    in s29 `seq` (s31 `seq` (s26 `seq` (s28 `seq` Curry_Prelude.nd_C_apply
    (let s25 = leftSupply s26
         s27 = rightSupply s26
         s1 = leftSupply s27
         s23 = rightSupply s27
    in s25 `seq` (s27 `seq` (s1 `seq` (s23 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_dollar_dollar s1 cd cs) (let s22 = leftSupply s23
                                                          s24 = rightSupply s23
                                                          s19 = leftSupply s24
                                                          s21 = rightSupply s24
    in s22 `seq` (s24 `seq` (s19 `seq` (s21 `seq` Curry_Prelude.nd_C_apply
    (let s18 = leftSupply s19
         s20 = rightSupply s19
         s2 = leftSupply s20
         s16 = rightSupply s20
    in s18 `seq` (s20 `seq` (s2 `seq` (s16 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_slash_gt s2 cd cs) (let s15 = leftSupply s16
                                                        s17 = rightSupply s16
                                                        s12 = leftSupply s17
                                                        s14 = rightSupply s17
    in s15 `seq` (s17 `seq` (s12 `seq` (s14 `seq` Curry_Prelude.nd_C_apply
    (let s11 = leftSupply s12
         s13 = rightSupply s12
         s3 = leftSupply s13
         s9 = rightSupply s13
    in s11 `seq` (s13 `seq` (s3 `seq` (s9 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s3 cd cs) (let s8 = leftSupply s9
                                                       s10 = rightSupply s9
                                                       s4 = leftSupply s10
                                                       s7 = rightSupply s10
    in s8 `seq` (s10 `seq` (s4 `seq` (s7 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_hsep s4 cd cs) (let s5 = leftSupply s7
                                                s6 = rightSupply s7
    in s5 `seq` (s6 `seq` Curry_Prelude.OP_Cons (nd_C_ppPrefixOp x2 s5 cd cs)
    (Curry_Prelude.nd_C_map (wrapNX id (nd_C_ppPattern x1 (Curry_Prelude.C_Int
    (1)))) x4 s6 cd cs))) s8 cd cs)))) s11 cd cs))))
    (Text.Curry_Pretty.nd_C_equals s14 cd cs) s15 cd cs)))) s18 cd cs))))
    (nd_C_ppRhs x1 x5 s21 cd cs) s22 cd cs)))) s25 cd cs)))) (nd_C_ppLocalDecls
    x1 x6 s28 cd cs) s29 cd cs)))) s32 cd cs))))
  AbstractHaskell.Curry_Types.Choice_C_Rule d i l r -> narrow d i (nd_C_ppRule
    x1 x2 l s cd cs) (nd_C_ppRule x1 x2 r s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Rule d i xs -> narrows cs d i (\z ->
    nd_C_ppRule x1 x2 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Rule d c e -> guardCons d c ((\x ->
    nd_C_ppRule x1 x2 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Rule d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppRule" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppRule" (showCons x3))

d_C_ppRhs :: C_Options -> AbstractHaskell.Curry_Types.C_Rhs -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C_ppRhs x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_SimpleRhs x3 -> d_C_ppExpr x1
    (Curry_Prelude.C_Int (0)) x3 cd cs
  AbstractHaskell.Curry_Types.C_GuardedRhs x4 -> Curry_Prelude.d_OP_dollar
    (d_C_indent cd cs) (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_C_vsep cd
    cs) (Curry_Prelude.d_C_map (d_C_ppCond x1) x4 cd cs) cd cs) cd cs
  AbstractHaskell.Curry_Types.Choice_C_Rhs d i l r -> narrow d i (d_C_ppRhs x1 l
    cd cs) (d_C_ppRhs x1 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Rhs d i xs -> narrows cs d i (\z ->
    d_C_ppRhs x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Rhs d c e -> guardCons d c ((\x ->
    d_C_ppRhs x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Rhs d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppRhs" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppRhs" (showCons x2))

nd_C_ppRhs :: C_Options -> AbstractHaskell.Curry_Types.C_Rhs -> IDSupply
  -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppRhs x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_SimpleRhs x3 -> let s0 = s
    in s0 `seq` nd_C_ppExpr x1 (Curry_Prelude.C_Int (0)) x3 s0 cd cs
  AbstractHaskell.Curry_Types.C_GuardedRhs x4 -> let s7 = s
    in s7 `seq` (let s6 = leftSupply s7
                     s8 = rightSupply s7
                     s0 = leftSupply s8
                     s4 = rightSupply s8
    in s6 `seq` (s8 `seq` (s0 `seq` (s4 `seq` Curry_Prelude.nd_OP_dollar
    (nd_C_indent s0 cd cs) (let s3 = leftSupply s4
                                s5 = rightSupply s4
                                s1 = leftSupply s5
                                s2 = rightSupply s5
    in s3 `seq` (s5 `seq` (s1 `seq` (s2 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_vsep s1 cd cs) (Curry_Prelude.nd_C_map (wrapNX id
    (nd_C_ppCond x1)) x4 s2 cd cs) s3 cd cs)))) s6 cd cs))))
  AbstractHaskell.Curry_Types.Choice_C_Rhs d i l r -> narrow d i (nd_C_ppRhs x1
    l s cd cs) (nd_C_ppRhs x1 r s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Rhs d i xs -> narrows cs d i (\z ->
    nd_C_ppRhs x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Rhs d c e -> guardCons d c ((\x ->
    nd_C_ppRhs x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Rhs d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppRhs" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppRhs" (showCons x2))

d_C_ppCond :: C_Options -> Curry_Prelude.OP_Tuple2
  AbstractHaskell.Curry_Types.C_Expr AbstractHaskell.Curry_Types.C_Expr -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C_ppCond x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_OP_lt_slash_gt cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (Text.Curry_Pretty.d_C_bar cd cs)
    cd cs) (d_C_ppExpr x1 (Curry_Prelude.C_Int (0)) x3 cd cs) cd cs) cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (Text.Curry_Pretty.d_C_equals cd
    cs) cd cs) (d_C_ppExpr x1 (Curry_Prelude.C_Int (0)) x4 cd cs) cd cs) cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C_ppCond x1 l cd cs)
    (d_C_ppCond x1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C_ppCond x1
    z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x -> d_C_ppCond x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppCond" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppCond" (showCons x2))

nd_C_ppCond :: C_Options -> Curry_Prelude.OP_Tuple2
  AbstractHaskell.Curry_Types.C_Expr AbstractHaskell.Curry_Types.C_Expr
  -> IDSupply -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppCond x1 x2 s cd cs = case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> let s23 = s
    in s23 `seq` (let s22 = leftSupply s23
                      s24 = rightSupply s23
                      s11 = leftSupply s24
                      s20 = rightSupply s24
    in s22 `seq` (s24 `seq` (s11 `seq` (s20 `seq` Curry_Prelude.nd_C_apply
    (let s10 = leftSupply s11
         s12 = rightSupply s11
         s0 = leftSupply s12
         s8 = rightSupply s12
    in s10 `seq` (s12 `seq` (s0 `seq` (s8 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_slash_gt s0 cd cs) (let s7 = leftSupply s8
                                                        s9 = rightSupply s8
                                                        s4 = leftSupply s9
                                                        s6 = rightSupply s9
    in s7 `seq` (s9 `seq` (s4 `seq` (s6 `seq` Curry_Prelude.nd_C_apply
    (let s3 = leftSupply s4
         s5 = rightSupply s4
         s1 = leftSupply s5
         s2 = rightSupply s5
    in s3 `seq` (s5 `seq` (s1 `seq` (s2 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s1 cd cs) (Text.Curry_Pretty.nd_C_bar s2
    cd cs) s3 cd cs)))) (nd_C_ppExpr x1 (Curry_Prelude.C_Int (0)) x3 s6 cd cs)
    s7 cd cs)))) s10 cd cs)))) (let s19 = leftSupply s20
                                    s21 = rightSupply s20
                                    s16 = leftSupply s21
                                    s18 = rightSupply s21
    in s19 `seq` (s21 `seq` (s16 `seq` (s18 `seq` Curry_Prelude.nd_C_apply
    (let s15 = leftSupply s16
         s17 = rightSupply s16
         s13 = leftSupply s17
         s14 = rightSupply s17
    in s15 `seq` (s17 `seq` (s13 `seq` (s14 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s13 cd cs)
    (Text.Curry_Pretty.nd_C_equals s14 cd cs) s15 cd cs)))) (nd_C_ppExpr x1
    (Curry_Prelude.C_Int (0)) x4 s18 cd cs) s19 cd cs)))) s22 cd cs))))
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (nd_C_ppCond x1 l s cd
    cs) (nd_C_ppCond x1 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> nd_C_ppCond x1
    z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x -> nd_C_ppCond x1 e
    s cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppCond" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppCond" (showCons x2))

d_C_ppLocalDecls :: C_Options -> Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_LocalDecl -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C_ppLocalDecls x1 x2 cd cs = d_C__case_15 x2 x1 (Curry_Prelude.d_C_null x2 cd
  cs) cd cs

nd_C_ppLocalDecls :: C_Options -> Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_LocalDecl -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppLocalDecls x1 x2 s cd cs = let s0 = s
  in s0 `seq` nd_C__case_15 x2 x1 (Curry_Prelude.d_C_null x2 cd cs) s0 cd cs

d_C_ppBlock :: C_Options -> Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_LocalDecl -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C_ppBlock x1 x2 cd cs = Text.Curry_Pretty.d_C_align
  (Text.Curry_Pretty.d_C_compose
  (Text.Curry_Pretty.d_OP_lt_dollar_bang_dollar_gt cd cs) (Curry_Prelude.d_C_map
  (d_C_ppLocalDecl x1) x2 cd cs) cd cs) cd cs

nd_C_ppBlock :: C_Options -> Curry_Prelude.OP_List
  AbstractHaskell.Curry_Types.C_LocalDecl -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppBlock x1 x2 s cd cs = let s6 = s
  in s6 `seq` (let s5 = leftSupply s6
                   s3 = rightSupply s6
  in s5 `seq` (s3 `seq` Text.Curry_Pretty.nd_C_align (let s2 = leftSupply s3
                                                          s4 = rightSupply s3
                                                          s0 = leftSupply s4
                                                          s1 = rightSupply s4
  in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` Text.Curry_Pretty.nd_C_compose
  (Text.Curry_Pretty.nd_OP_lt_dollar_bang_dollar_gt s0 cd cs)
  (Curry_Prelude.nd_C_map (wrapNX id (nd_C_ppLocalDecl x1)) x2 s1 cd cs) s2 cd
  cs)))) s5 cd cs))

d_C_ppLocalDecl :: C_Options -> AbstractHaskell.Curry_Types.C_LocalDecl -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C_ppLocalDecl x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_LocalFunc x3 -> d_C_ppFuncDecl x1 x3 cd cs
  AbstractHaskell.Curry_Types.C_LocalPat x4 x5 x6 -> Curry_Prelude.d_OP_dollar
    (d_C_indent cd cs) (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_dollar_dollar cd cs) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (d_C_ppPattern x1
    (Curry_Prelude.C_Int (0)) x4 cd cs) cd cs) (Text.Curry_Pretty.d_C_equals cd
    cs) cd cs) cd cs) (d_C_ppExpr x1 (Curry_Prelude.C_Int (0)) x5 cd cs) cd cs)
    cd cs) (d_C_ppLocalDecls x1 x6 cd cs) cd cs) cd cs
  AbstractHaskell.Curry_Types.Choice_C_LocalDecl d i l r -> narrow d i
    (d_C_ppLocalDecl x1 l cd cs) (d_C_ppLocalDecl x1 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_LocalDecl d i xs -> narrows cs d i
    (\z -> d_C_ppLocalDecl x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_LocalDecl d c e -> guardCons d c ((\x ->
    d_C_ppLocalDecl x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_LocalDecl d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppLocalDecl" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppLocalDecl" (showCons
    x2))

nd_C_ppLocalDecl :: C_Options -> AbstractHaskell.Curry_Types.C_LocalDecl
  -> IDSupply -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppLocalDecl x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_LocalFunc x3 -> let s0 = s
    in s0 `seq` nd_C_ppFuncDecl x1 x3 s0 cd cs
  AbstractHaskell.Curry_Types.C_LocalPat x4 x5 x6 -> let s27 = s
    in s27 `seq` (let s26 = leftSupply s27
                      s28 = rightSupply s27
                      s0 = leftSupply s28
                      s24 = rightSupply s28
    in s26 `seq` (s28 `seq` (s0 `seq` (s24 `seq` Curry_Prelude.nd_OP_dollar
    (nd_C_indent s0 cd cs) (let s23 = leftSupply s24
                                s25 = rightSupply s24
                                s20 = leftSupply s25
                                s22 = rightSupply s25
    in s23 `seq` (s25 `seq` (s20 `seq` (s22 `seq` Curry_Prelude.nd_C_apply
    (let s19 = leftSupply s20
         s21 = rightSupply s20
         s1 = leftSupply s21
         s17 = rightSupply s21
    in s19 `seq` (s21 `seq` (s1 `seq` (s17 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_dollar_dollar s1 cd cs) (let s16 = leftSupply s17
                                                          s18 = rightSupply s17
                                                          s13 = leftSupply s18
                                                          s15 = rightSupply s18
    in s16 `seq` (s18 `seq` (s13 `seq` (s15 `seq` Curry_Prelude.nd_C_apply
    (let s12 = leftSupply s13
         s14 = rightSupply s13
         s2 = leftSupply s14
         s10 = rightSupply s14
    in s12 `seq` (s14 `seq` (s2 `seq` (s10 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s2 cd cs) (let s9 = leftSupply s10
                                                       s11 = rightSupply s10
                                                       s6 = leftSupply s11
                                                       s8 = rightSupply s11
    in s9 `seq` (s11 `seq` (s6 `seq` (s8 `seq` Curry_Prelude.nd_C_apply
    (let s5 = leftSupply s6
         s7 = rightSupply s6
         s3 = leftSupply s7
         s4 = rightSupply s7
    in s5 `seq` (s7 `seq` (s3 `seq` (s4 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s3 cd cs) (nd_C_ppPattern x1
    (Curry_Prelude.C_Int (0)) x4 s4 cd cs) s5 cd cs))))
    (Text.Curry_Pretty.nd_C_equals s8 cd cs) s9 cd cs)))) s12 cd cs))))
    (nd_C_ppExpr x1 (Curry_Prelude.C_Int (0)) x5 s15 cd cs) s16 cd cs)))) s19 cd
    cs)))) (nd_C_ppLocalDecls x1 x6 s22 cd cs) s23 cd cs)))) s26 cd cs))))
  AbstractHaskell.Curry_Types.Choice_C_LocalDecl d i l r -> narrow d i
    (nd_C_ppLocalDecl x1 l s cd cs) (nd_C_ppLocalDecl x1 r s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_LocalDecl d i xs -> narrows cs d i
    (\z -> nd_C_ppLocalDecl x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_LocalDecl d c e -> guardCons d c ((\x ->
    nd_C_ppLocalDecl x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_LocalDecl d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppLocalDecl" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppLocalDecl" (showCons
    x2))

d_C_ppExp :: Cover -> ConstStore -> AbstractHaskell.Curry_Types.C_Expr -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C_ppExp cd cs = d_C_ppExpr (d_C_defaultOptions cd cs) (Curry_Prelude.C_Int
  (0))

nd_C_ppExp :: IDSupply -> Cover -> ConstStore -> Func
  AbstractHaskell.Curry_Types.C_Expr Text.Curry_PrettyImpl.C_Doc
nd_C_ppExp s cd cs = let s0 = s
  in s0 `seq` wrapNX id (nd_C_ppExpr (nd_C_defaultOptions s0 cd cs)
  (Curry_Prelude.C_Int (0)))

d_C_ppExpr :: C_Options -> Curry_Prelude.C_Int
  -> AbstractHaskell.Curry_Types.C_Expr -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C_ppExpr x1 x2 x3 cd cs = case x3 of
  AbstractHaskell.Curry_Types.C_Var x4 -> d_C_ppVar x4 cd cs
  AbstractHaskell.Curry_Types.C_Lit x5 -> d_C_ppLiteral x5 cd cs
  AbstractHaskell.Curry_Types.C_Symbol x6 -> d_C_ppPrefixQOp x1 x6 cd cs
  AbstractHaskell.Curry_Types.C_Apply x7 x8 -> Curry_Prelude.d_OP_dollar
    (d_C_parensIf (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
    cd cs) x2 cd cs) (Curry_Prelude.C_Int (1)) cd cs)) (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_C_fillSep cd cs) (Curry_Prelude.OP_Cons (d_C_ppExpr x1
    (Curry_Prelude.C_Int (1)) x7 cd cs) (Curry_Prelude.OP_Cons (d_C_ppExpr x1
    (Curry_Prelude.C_Int (2)) x8 cd cs) Curry_Prelude.OP_List)) cd cs) cd cs
  AbstractHaskell.Curry_Types.C_InfixApply x9 x10 x11 -> Curry_Prelude.d_OP_dollar
    (d_C_parensIf (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
    cd cs) x2 cd cs) (Curry_Prelude.C_Int (0)) cd cs)) (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_C_fillSep cd cs) (Curry_Prelude.OP_Cons
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (d_C_ppExpr x1
    (Curry_Prelude.C_Int (1)) x9 cd cs) cd cs) (d_C_ppInfixQOp x1 x10 cd cs) cd
    cs) (Curry_Prelude.OP_Cons (d_C_ppExpr x1 (Curry_Prelude.C_Int (1)) x11 cd
    cs) Curry_Prelude.OP_List)) cd cs) cd cs
  AbstractHaskell.Curry_Types.C_Lambda x12 x13 -> Curry_Prelude.d_OP_dollar
    (d_C_parensIf (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
    cd cs) x2 cd cs) (Curry_Prelude.C_Int (0)) cd cs)) (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_C_fillSep cd cs) (Curry_Prelude.OP_Cons
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (Text.Curry_Pretty.d_OP_lt_gt
    (Text.Curry_Pretty.d_C_char (Curry_Prelude.C_Char '\\'#) cd cs)
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_C_hsep cd cs)
    (Curry_Prelude.d_C_map (d_C_ppPattern x1 (Curry_Prelude.C_Int (1))) x12 cd
    cs) cd cs) cd cs) cd cs) (Text.Curry_Pretty.d_C_rarrow cd cs) cd cs)
    (Curry_Prelude.OP_Cons (d_C_ppExpr x1 (Curry_Prelude.C_Int (0)) x13 cd cs)
    Curry_Prelude.OP_List)) cd cs) cd cs
  AbstractHaskell.Curry_Types.C_Let x14 x15 -> Curry_Prelude.d_OP_dollar
    (d_C_parensIf (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
    cd cs) x2 cd cs) (Curry_Prelude.C_Int (0)) cd cs)) (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_C_sep cd cs) (Curry_Prelude.OP_Cons
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (Text.Curry_Pretty.d_C_text
    (Curry_Prelude.toCurryString "let") cd cs) cd cs) (d_C_ppBlock x1 x14 cd cs)
    cd cs) (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs)
    (Text.Curry_Pretty.d_C_text (Curry_Prelude.toCurryString "in") cd cs) cd cs)
    (d_C_ppExpr x1 (Curry_Prelude.C_Int (0)) x15 cd cs) cd cs)
    Curry_Prelude.OP_List)) cd cs) cd cs
  AbstractHaskell.Curry_Types.C_DoExpr x16 -> Curry_Prelude.d_OP_dollar
    (d_C_parensIf (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
    cd cs) x2 cd cs) (Curry_Prelude.C_Int (0)) cd cs)) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs)
    (Text.Curry_Pretty.d_C_text (Curry_Prelude.toCurryString "do") cd cs) cd cs)
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_C_vsep cd cs)
    (Curry_Prelude.d_C_map (d_C_ppStmt x1) x16 cd cs) cd cs) cd cs) cd cs
  AbstractHaskell.Curry_Types.C_ListComp x17 x18 -> Curry_Prelude.d_OP_dollar
    (Text.Curry_Pretty.d_C_brackets cd cs) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (d_C_ppExpr x1
    (Curry_Prelude.C_Int (0)) x17 cd cs) cd cs) (Text.Curry_Pretty.d_C_bar cd
    cs) cd cs) cd cs) (Curry_Prelude.d_C_apply (d_C_sequence cd cs)
    (Curry_Prelude.d_C_map (d_C_ppStmt x1) x18 cd cs) cd cs) cd cs) cd cs
  AbstractHaskell.Curry_Types.C_Case x19 x20 -> d_C_parensIf
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
    cd cs) x2 cd cs) (Curry_Prelude.C_Int (0)) cd cs) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_OP_dollar_dollar cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs)
    (Text.Curry_Pretty.d_C_text (Curry_Prelude.toCurryString "case") cd cs) cd
    cs) (d_C_ppExpr x1 (Curry_Prelude.C_Int (0)) x19 cd cs) cd cs) cd cs)
    (Text.Curry_Pretty.d_C_text (Curry_Prelude.toCurryString "of") cd cs) cd cs)
    cd cs) (Text.Curry_Pretty.d_C_align (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_C_vsep cd cs) (Curry_Prelude.d_C_map (d_C_ppBranchExpr
    x1) x20 cd cs) cd cs) cd cs) cd cs) cd cs
  AbstractHaskell.Curry_Types.C_Typed x21 x22 -> Curry_Prelude.d_OP_dollar
    (d_C_parensIf (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
    cd cs) x2 cd cs) (Curry_Prelude.C_Int (0)) cd cs)) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (d_C_ppExpr x1
    (Curry_Prelude.C_Int (0)) x21 cd cs) cd cs)
    (Text.Curry_Pretty.d_C_doubleColon cd cs) cd cs) cd cs)
    (Curry_Prelude.d_C_apply (d_C_ppTypeExp x1 cd cs) x22 cd cs) cd cs) cd cs
  AbstractHaskell.Curry_Types.C_IfThenElse x23 x24 x25 -> Curry_Prelude.d_OP_dollar
    (d_C_parensIf (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
    cd cs) x2 cd cs) (Curry_Prelude.C_Int (0)) cd cs)) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs)
    (Text.Curry_Pretty.d_C_text (Curry_Prelude.toCurryString "if") cd cs) cd cs)
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_C_fillSep cd cs)
    (Curry_Prelude.OP_Cons (d_C_ppExpr x1 (Curry_Prelude.C_Int (0)) x23 cd cs)
    (Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (Text.Curry_Pretty.d_C_text
    (Curry_Prelude.toCurryString "then") cd cs) cd cs) (d_C_ppExpr x1
    (Curry_Prelude.C_Int (0)) x24 cd cs) cd cs) (Curry_Prelude.OP_Cons
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (Text.Curry_Pretty.d_C_text
    (Curry_Prelude.toCurryString "else") cd cs) cd cs) (d_C_ppExpr x1
    (Curry_Prelude.C_Int (0)) x25 cd cs) cd cs) Curry_Prelude.OP_List))) cd cs)
    cd cs) cd cs
  AbstractHaskell.Curry_Types.C_Tuple x26 -> Curry_Prelude.d_C_apply (d_C_tupled
    cd cs) (Curry_Prelude.d_C_map (d_C_ppExpr x1 (Curry_Prelude.C_Int (0))) x26
    cd cs) cd cs
  AbstractHaskell.Curry_Types.C_List x27 -> Curry_Prelude.d_C_apply (d_C_list cd
    cs) (Curry_Prelude.d_C_map (d_C_ppExpr x1 (Curry_Prelude.C_Int (0))) x27 cd
    cs) cd cs
  AbstractHaskell.Curry_Types.Choice_C_Expr d i l r -> narrow d i (d_C_ppExpr x1
    x2 l cd cs) (d_C_ppExpr x1 x2 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Expr d i xs -> narrows cs d i (\z ->
    d_C_ppExpr x1 x2 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Expr d c e -> guardCons d c ((\x ->
    d_C_ppExpr x1 x2 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Expr d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppExpr" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppExpr" (showCons x3))

nd_C_ppExpr :: C_Options -> Curry_Prelude.C_Int
  -> AbstractHaskell.Curry_Types.C_Expr -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppExpr x1 x2 x3 s cd cs = case x3 of
  AbstractHaskell.Curry_Types.C_Var x4 -> let s0 = s
    in s0 `seq` nd_C_ppVar x4 s0 cd cs
  AbstractHaskell.Curry_Types.C_Lit x5 -> let s0 = s
    in s0 `seq` nd_C_ppLiteral x5 s0 cd cs
  AbstractHaskell.Curry_Types.C_Symbol x6 -> let s0 = s
    in s0 `seq` nd_C_ppPrefixQOp x1 x6 s0 cd cs
  AbstractHaskell.Curry_Types.C_Apply x7 x8 -> let s11 = s
    in s11 `seq` (let s10 = leftSupply s11
                      s12 = rightSupply s11
                      s2 = leftSupply s12
                      s8 = rightSupply s12
    in s10 `seq` (s12 `seq` (s2 `seq` (s8 `seq` Curry_Prelude.nd_OP_dollar
    (wrapNX id (nd_C_parensIf (let s1 = leftSupply s2
                                   s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply
    (wrapDX (wrapDX id)
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
    cd cs)) x2 s0 cd cs) (Curry_Prelude.C_Int (1)) s1 cd cs))))
    (let s7 = leftSupply s8
         s9 = rightSupply s8
         s3 = leftSupply s9
         s6 = rightSupply s9
    in s7 `seq` (s9 `seq` (s3 `seq` (s6 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_fillSep s3 cd cs) (let s4 = leftSupply s6
                                                   s5 = rightSupply s6
    in s4 `seq` (s5 `seq` Curry_Prelude.OP_Cons (nd_C_ppExpr x1
    (Curry_Prelude.C_Int (1)) x7 s4 cd cs) (Curry_Prelude.OP_Cons (nd_C_ppExpr
    x1 (Curry_Prelude.C_Int (2)) x8 s5 cd cs) Curry_Prelude.OP_List))) s7 cd
    cs)))) s10 cd cs))))
  AbstractHaskell.Curry_Types.C_InfixApply x9 x10 x11 -> let s19 = s
    in s19 `seq` (let s18 = leftSupply s19
                      s20 = rightSupply s19
                      s2 = leftSupply s20
                      s16 = rightSupply s20
    in s18 `seq` (s20 `seq` (s2 `seq` (s16 `seq` Curry_Prelude.nd_OP_dollar
    (wrapNX id (nd_C_parensIf (let s1 = leftSupply s2
                                   s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply
    (wrapDX (wrapDX id)
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
    cd cs)) x2 s0 cd cs) (Curry_Prelude.C_Int (0)) s1 cd cs))))
    (let s15 = leftSupply s16
         s17 = rightSupply s16
         s3 = leftSupply s17
         s14 = rightSupply s17
    in s15 `seq` (s17 `seq` (s3 `seq` (s14 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_fillSep s3 cd cs) (let s11 = leftSupply s14
                                                   s13 = rightSupply s14
    in s11 `seq` (s13 `seq` Curry_Prelude.OP_Cons (let s10 = leftSupply s11
                                                       s12 = rightSupply s11
                                                       s7 = leftSupply s12
                                                       s9 = rightSupply s12
    in s10 `seq` (s12 `seq` (s7 `seq` (s9 `seq` Curry_Prelude.nd_C_apply
    (let s6 = leftSupply s7
         s8 = rightSupply s7
         s4 = leftSupply s8
         s5 = rightSupply s8
    in s6 `seq` (s8 `seq` (s4 `seq` (s5 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s4 cd cs) (nd_C_ppExpr x1
    (Curry_Prelude.C_Int (1)) x9 s5 cd cs) s6 cd cs)))) (nd_C_ppInfixQOp x1 x10
    s9 cd cs) s10 cd cs)))) (Curry_Prelude.OP_Cons (nd_C_ppExpr x1
    (Curry_Prelude.C_Int (1)) x11 s13 cd cs) Curry_Prelude.OP_List))) s15 cd
    cs)))) s18 cd cs))))
  AbstractHaskell.Curry_Types.C_Lambda x12 x13 -> let s27 = s
    in s27 `seq` (let s26 = leftSupply s27
                      s28 = rightSupply s27
                      s2 = leftSupply s28
                      s24 = rightSupply s28
    in s26 `seq` (s28 `seq` (s2 `seq` (s24 `seq` Curry_Prelude.nd_OP_dollar
    (wrapNX id (nd_C_parensIf (let s1 = leftSupply s2
                                   s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply
    (wrapDX (wrapDX id)
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
    cd cs)) x2 s0 cd cs) (Curry_Prelude.C_Int (0)) s1 cd cs))))
    (let s23 = leftSupply s24
         s25 = rightSupply s24
         s3 = leftSupply s25
         s22 = rightSupply s25
    in s23 `seq` (s25 `seq` (s3 `seq` (s22 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_fillSep s3 cd cs) (let s19 = leftSupply s22
                                                   s21 = rightSupply s22
    in s19 `seq` (s21 `seq` Curry_Prelude.OP_Cons (let s18 = leftSupply s19
                                                       s20 = rightSupply s19
                                                       s15 = leftSupply s20
                                                       s17 = rightSupply s20
    in s18 `seq` (s20 `seq` (s15 `seq` (s17 `seq` Curry_Prelude.nd_C_apply
    (let s14 = leftSupply s15
         s16 = rightSupply s15
         s4 = leftSupply s16
         s12 = rightSupply s16
    in s14 `seq` (s16 `seq` (s4 `seq` (s12 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s4 cd cs) (let s11 = leftSupply s12
                                                       s13 = rightSupply s12
                                                       s5 = leftSupply s13
                                                       s9 = rightSupply s13
    in s11 `seq` (s13 `seq` (s5 `seq` (s9 `seq` Text.Curry_Pretty.nd_OP_lt_gt
    (Text.Curry_Pretty.nd_C_char (Curry_Prelude.C_Char '\\'#) s5 cd cs)
    (let s8 = leftSupply s9
         s10 = rightSupply s9
         s6 = leftSupply s10
         s7 = rightSupply s10
    in s8 `seq` (s10 `seq` (s6 `seq` (s7 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_hsep s6 cd cs) (Curry_Prelude.nd_C_map (wrapNX id
    (nd_C_ppPattern x1 (Curry_Prelude.C_Int (1)))) x12 s7 cd cs) s8 cd cs))))
    s11 cd cs)))) s14 cd cs)))) (Text.Curry_Pretty.nd_C_rarrow s17 cd cs) s18 cd
    cs)))) (Curry_Prelude.OP_Cons (nd_C_ppExpr x1 (Curry_Prelude.C_Int (0)) x13
    s21 cd cs) Curry_Prelude.OP_List))) s23 cd cs)))) s26 cd cs))))
  AbstractHaskell.Curry_Types.C_Let x14 x15 -> let s27 = s
    in s27 `seq` (let s26 = leftSupply s27
                      s28 = rightSupply s27
                      s2 = leftSupply s28
                      s24 = rightSupply s28
    in s26 `seq` (s28 `seq` (s2 `seq` (s24 `seq` Curry_Prelude.nd_OP_dollar
    (wrapNX id (nd_C_parensIf (let s1 = leftSupply s2
                                   s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply
    (wrapDX (wrapDX id)
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
    cd cs)) x2 s0 cd cs) (Curry_Prelude.C_Int (0)) s1 cd cs))))
    (let s23 = leftSupply s24
         s25 = rightSupply s24
         s3 = leftSupply s25
         s22 = rightSupply s25
    in s23 `seq` (s25 `seq` (s3 `seq` (s22 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_sep s3 cd cs) (let s11 = leftSupply s22
                                               s20 = rightSupply s22
    in s11 `seq` (s20 `seq` Curry_Prelude.OP_Cons (let s10 = leftSupply s11
                                                       s12 = rightSupply s11
                                                       s7 = leftSupply s12
                                                       s9 = rightSupply s12
    in s10 `seq` (s12 `seq` (s7 `seq` (s9 `seq` Curry_Prelude.nd_C_apply
    (let s6 = leftSupply s7
         s8 = rightSupply s7
         s4 = leftSupply s8
         s5 = rightSupply s8
    in s6 `seq` (s8 `seq` (s4 `seq` (s5 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s4 cd cs) (Text.Curry_Pretty.nd_C_text
    (Curry_Prelude.toCurryString "let") s5 cd cs) s6 cd cs)))) (nd_C_ppBlock x1
    x14 s9 cd cs) s10 cd cs)))) (Curry_Prelude.OP_Cons (let s19 = leftSupply s20
                                                            s21 = rightSupply
                                                              s20
                                                            s16 = leftSupply s21
                                                            s18 = rightSupply
                                                              s21
    in s19 `seq` (s21 `seq` (s16 `seq` (s18 `seq` Curry_Prelude.nd_C_apply
    (let s15 = leftSupply s16
         s17 = rightSupply s16
         s13 = leftSupply s17
         s14 = rightSupply s17
    in s15 `seq` (s17 `seq` (s13 `seq` (s14 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s13 cd cs) (Text.Curry_Pretty.nd_C_text
    (Curry_Prelude.toCurryString "in") s14 cd cs) s15 cd cs)))) (nd_C_ppExpr x1
    (Curry_Prelude.C_Int (0)) x15 s18 cd cs) s19 cd cs))))
    Curry_Prelude.OP_List))) s23 cd cs)))) s26 cd cs))))
  AbstractHaskell.Curry_Types.C_DoExpr x16 -> let s17 = s
    in s17 `seq` (let s16 = leftSupply s17
                      s18 = rightSupply s17
                      s2 = leftSupply s18
                      s14 = rightSupply s18
    in s16 `seq` (s18 `seq` (s2 `seq` (s14 `seq` Curry_Prelude.nd_OP_dollar
    (wrapNX id (nd_C_parensIf (let s1 = leftSupply s2
                                   s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply
    (wrapDX (wrapDX id)
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
    cd cs)) x2 s0 cd cs) (Curry_Prelude.C_Int (0)) s1 cd cs))))
    (let s13 = leftSupply s14
         s15 = rightSupply s14
         s6 = leftSupply s15
         s11 = rightSupply s15
    in s13 `seq` (s15 `seq` (s6 `seq` (s11 `seq` Curry_Prelude.nd_C_apply
    (let s5 = leftSupply s6
         s7 = rightSupply s6
         s3 = leftSupply s7
         s4 = rightSupply s7
    in s5 `seq` (s7 `seq` (s3 `seq` (s4 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s3 cd cs) (Text.Curry_Pretty.nd_C_text
    (Curry_Prelude.toCurryString "do") s4 cd cs) s5 cd cs))))
    (let s10 = leftSupply s11
         s12 = rightSupply s11
         s8 = leftSupply s12
         s9 = rightSupply s12
    in s10 `seq` (s12 `seq` (s8 `seq` (s9 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_vsep s8 cd cs) (Curry_Prelude.nd_C_map (wrapNX id
    (nd_C_ppStmt x1)) x16 s9 cd cs) s10 cd cs)))) s13 cd cs)))) s16 cd cs))))
  AbstractHaskell.Curry_Types.C_ListComp x17 x18 -> let s23 = s
    in s23 `seq` (let s22 = leftSupply s23
                      s24 = rightSupply s23
                      s0 = leftSupply s24
                      s20 = rightSupply s24
    in s22 `seq` (s24 `seq` (s0 `seq` (s20 `seq` Curry_Prelude.nd_OP_dollar
    (Text.Curry_Pretty.nd_C_brackets s0 cd cs) (let s19 = leftSupply s20
                                                    s21 = rightSupply s20
                                                    s12 = leftSupply s21
                                                    s17 = rightSupply s21
    in s19 `seq` (s21 `seq` (s12 `seq` (s17 `seq` Curry_Prelude.nd_C_apply
    (let s11 = leftSupply s12
         s13 = rightSupply s12
         s1 = leftSupply s13
         s9 = rightSupply s13
    in s11 `seq` (s13 `seq` (s1 `seq` (s9 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s1 cd cs) (let s8 = leftSupply s9
                                                       s10 = rightSupply s9
                                                       s5 = leftSupply s10
                                                       s7 = rightSupply s10
    in s8 `seq` (s10 `seq` (s5 `seq` (s7 `seq` Curry_Prelude.nd_C_apply
    (let s4 = leftSupply s5
         s6 = rightSupply s5
         s2 = leftSupply s6
         s3 = rightSupply s6
    in s4 `seq` (s6 `seq` (s2 `seq` (s3 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s2 cd cs) (nd_C_ppExpr x1
    (Curry_Prelude.C_Int (0)) x17 s3 cd cs) s4 cd cs))))
    (Text.Curry_Pretty.nd_C_bar s7 cd cs) s8 cd cs)))) s11 cd cs))))
    (let s16 = leftSupply s17
         s18 = rightSupply s17
         s14 = leftSupply s18
         s15 = rightSupply s18
    in s16 `seq` (s18 `seq` (s14 `seq` (s15 `seq` Curry_Prelude.nd_C_apply
    (nd_C_sequence s14 cd cs) (Curry_Prelude.nd_C_map (wrapNX id (nd_C_ppStmt
    x1)) x18 s15 cd cs) s16 cd cs)))) s19 cd cs)))) s22 cd cs))))
  AbstractHaskell.Curry_Types.C_Case x19 x20 -> let s35 = s
    in s35 `seq` (let s34 = leftSupply s35
                      s36 = rightSupply s35
                      s2 = leftSupply s36
                      s32 = rightSupply s36
    in s34 `seq` (s36 `seq` (s2 `seq` (s32 `seq` nd_C_parensIf
    (let s1 = leftSupply s2
         s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply
    (wrapDX (wrapDX id)
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
    cd cs)) x2 s0 cd cs) (Curry_Prelude.C_Int (0)) s1 cd cs))
    (let s31 = leftSupply s32
         s33 = rightSupply s32
         s22 = leftSupply s33
         s30 = rightSupply s33
    in s31 `seq` (s33 `seq` (s22 `seq` (s30 `seq` Curry_Prelude.nd_C_apply
    (let s21 = leftSupply s22
         s23 = rightSupply s22
         s3 = leftSupply s23
         s19 = rightSupply s23
    in s21 `seq` (s23 `seq` (s3 `seq` (s19 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_dollar_dollar s3 cd cs) (let s18 = leftSupply s19
                                                          s20 = rightSupply s19
                                                          s15 = leftSupply s20
                                                          s17 = rightSupply s20
    in s18 `seq` (s20 `seq` (s15 `seq` (s17 `seq` Curry_Prelude.nd_C_apply
    (let s14 = leftSupply s15
         s16 = rightSupply s15
         s4 = leftSupply s16
         s12 = rightSupply s16
    in s14 `seq` (s16 `seq` (s4 `seq` (s12 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s4 cd cs) (let s11 = leftSupply s12
                                                       s13 = rightSupply s12
                                                       s8 = leftSupply s13
                                                       s10 = rightSupply s13
    in s11 `seq` (s13 `seq` (s8 `seq` (s10 `seq` Curry_Prelude.nd_C_apply
    (let s7 = leftSupply s8
         s9 = rightSupply s8
         s5 = leftSupply s9
         s6 = rightSupply s9
    in s7 `seq` (s9 `seq` (s5 `seq` (s6 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s5 cd cs) (Text.Curry_Pretty.nd_C_text
    (Curry_Prelude.toCurryString "case") s6 cd cs) s7 cd cs)))) (nd_C_ppExpr x1
    (Curry_Prelude.C_Int (0)) x19 s10 cd cs) s11 cd cs)))) s14 cd cs))))
    (Text.Curry_Pretty.nd_C_text (Curry_Prelude.toCurryString "of") s17 cd cs)
    s18 cd cs)))) s21 cd cs)))) (let s29 = leftSupply s30
                                     s27 = rightSupply s30
    in s29 `seq` (s27 `seq` Text.Curry_Pretty.nd_C_align (let s26 = leftSupply
                                                                s27
                                                              s28 = rightSupply
                                                                s27
                                                              s24 = leftSupply
                                                                s28
                                                              s25 = rightSupply
                                                                s28
    in s26 `seq` (s28 `seq` (s24 `seq` (s25 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_vsep s24 cd cs) (Curry_Prelude.nd_C_map (wrapNX id
    (nd_C_ppBranchExpr x1)) x20 s25 cd cs) s26 cd cs)))) s29 cd cs)) s31 cd
    cs)))) s34 cd cs))))
  AbstractHaskell.Curry_Types.C_Typed x21 x22 -> let s23 = s
    in s23 `seq` (let s22 = leftSupply s23
                      s24 = rightSupply s23
                      s2 = leftSupply s24
                      s20 = rightSupply s24
    in s22 `seq` (s24 `seq` (s2 `seq` (s20 `seq` Curry_Prelude.nd_OP_dollar
    (wrapNX id (nd_C_parensIf (let s1 = leftSupply s2
                                   s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply
    (wrapDX (wrapDX id)
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
    cd cs)) x2 s0 cd cs) (Curry_Prelude.C_Int (0)) s1 cd cs))))
    (let s19 = leftSupply s20
         s21 = rightSupply s20
         s14 = leftSupply s21
         s18 = rightSupply s21
    in s19 `seq` (s21 `seq` (s14 `seq` (s18 `seq` Curry_Prelude.nd_C_apply
    (let s13 = leftSupply s14
         s15 = rightSupply s14
         s3 = leftSupply s15
         s11 = rightSupply s15
    in s13 `seq` (s15 `seq` (s3 `seq` (s11 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s3 cd cs) (let s10 = leftSupply s11
                                                       s12 = rightSupply s11
                                                       s7 = leftSupply s12
                                                       s9 = rightSupply s12
    in s10 `seq` (s12 `seq` (s7 `seq` (s9 `seq` Curry_Prelude.nd_C_apply
    (let s6 = leftSupply s7
         s8 = rightSupply s7
         s4 = leftSupply s8
         s5 = rightSupply s8
    in s6 `seq` (s8 `seq` (s4 `seq` (s5 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s4 cd cs) (nd_C_ppExpr x1
    (Curry_Prelude.C_Int (0)) x21 s5 cd cs) s6 cd cs))))
    (Text.Curry_Pretty.nd_C_doubleColon s9 cd cs) s10 cd cs)))) s13 cd cs))))
    (let s17 = leftSupply s18
         s16 = rightSupply s18
    in s17 `seq` (s16 `seq` Curry_Prelude.nd_C_apply (nd_C_ppTypeExp x1 s16 cd
    cs) x22 s17 cd cs)) s19 cd cs)))) s22 cd cs))))
  AbstractHaskell.Curry_Types.C_IfThenElse x23 x24 x25 -> let s37 = s
    in s37 `seq` (let s36 = leftSupply s37
                      s38 = rightSupply s37
                      s2 = leftSupply s38
                      s34 = rightSupply s38
    in s36 `seq` (s38 `seq` (s2 `seq` (s34 `seq` Curry_Prelude.nd_OP_dollar
    (wrapNX id (nd_C_parensIf (let s1 = leftSupply s2
                                   s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply
    (wrapDX (wrapDX id)
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
    cd cs)) x2 s0 cd cs) (Curry_Prelude.C_Int (0)) s1 cd cs))))
    (let s33 = leftSupply s34
         s35 = rightSupply s34
         s6 = leftSupply s35
         s31 = rightSupply s35
    in s33 `seq` (s35 `seq` (s6 `seq` (s31 `seq` Curry_Prelude.nd_C_apply
    (let s5 = leftSupply s6
         s7 = rightSupply s6
         s3 = leftSupply s7
         s4 = rightSupply s7
    in s5 `seq` (s7 `seq` (s3 `seq` (s4 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s3 cd cs) (Text.Curry_Pretty.nd_C_text
    (Curry_Prelude.toCurryString "if") s4 cd cs) s5 cd cs))))
    (let s30 = leftSupply s31
         s32 = rightSupply s31
         s8 = leftSupply s32
         s29 = rightSupply s32
    in s30 `seq` (s32 `seq` (s8 `seq` (s29 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_fillSep s8 cd cs) (let s9 = leftSupply s29
                                                   s28 = rightSupply s29
    in s9 `seq` (s28 `seq` Curry_Prelude.OP_Cons (nd_C_ppExpr x1
    (Curry_Prelude.C_Int (0)) x23 s9 cd cs) (let s17 = leftSupply s28
                                                 s26 = rightSupply s28
    in s17 `seq` (s26 `seq` Curry_Prelude.OP_Cons (let s16 = leftSupply s17
                                                       s18 = rightSupply s17
                                                       s13 = leftSupply s18
                                                       s15 = rightSupply s18
    in s16 `seq` (s18 `seq` (s13 `seq` (s15 `seq` Curry_Prelude.nd_C_apply
    (let s12 = leftSupply s13
         s14 = rightSupply s13
         s10 = leftSupply s14
         s11 = rightSupply s14
    in s12 `seq` (s14 `seq` (s10 `seq` (s11 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s10 cd cs) (Text.Curry_Pretty.nd_C_text
    (Curry_Prelude.toCurryString "then") s11 cd cs) s12 cd cs)))) (nd_C_ppExpr
    x1 (Curry_Prelude.C_Int (0)) x24 s15 cd cs) s16 cd cs))))
    (Curry_Prelude.OP_Cons (let s25 = leftSupply s26
                                s27 = rightSupply s26
                                s22 = leftSupply s27
                                s24 = rightSupply s27
    in s25 `seq` (s27 `seq` (s22 `seq` (s24 `seq` Curry_Prelude.nd_C_apply
    (let s21 = leftSupply s22
         s23 = rightSupply s22
         s19 = leftSupply s23
         s20 = rightSupply s23
    in s21 `seq` (s23 `seq` (s19 `seq` (s20 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s19 cd cs) (Text.Curry_Pretty.nd_C_text
    (Curry_Prelude.toCurryString "else") s20 cd cs) s21 cd cs)))) (nd_C_ppExpr
    x1 (Curry_Prelude.C_Int (0)) x25 s24 cd cs) s25 cd cs))))
    Curry_Prelude.OP_List))))) s30 cd cs)))) s33 cd cs)))) s36 cd cs))))
  AbstractHaskell.Curry_Types.C_Tuple x26 -> let s3 = s
    in s3 `seq` (let s2 = leftSupply s3
                     s4 = rightSupply s3
                     s0 = leftSupply s4
                     s1 = rightSupply s4
    in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` Curry_Prelude.nd_C_apply
    (nd_C_tupled s0 cd cs) (Curry_Prelude.nd_C_map (wrapNX id (nd_C_ppExpr x1
    (Curry_Prelude.C_Int (0)))) x26 s1 cd cs) s2 cd cs))))
  AbstractHaskell.Curry_Types.C_List x27 -> let s3 = s
    in s3 `seq` (let s2 = leftSupply s3
                     s4 = rightSupply s3
                     s0 = leftSupply s4
                     s1 = rightSupply s4
    in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` Curry_Prelude.nd_C_apply
    (nd_C_list s0 cd cs) (Curry_Prelude.nd_C_map (wrapNX id (nd_C_ppExpr x1
    (Curry_Prelude.C_Int (0)))) x27 s1 cd cs) s2 cd cs))))
  AbstractHaskell.Curry_Types.Choice_C_Expr d i l r -> narrow d i (nd_C_ppExpr
    x1 x2 l s cd cs) (nd_C_ppExpr x1 x2 r s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Expr d i xs -> narrows cs d i (\z ->
    nd_C_ppExpr x1 x2 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Expr d c e -> guardCons d c ((\x ->
    nd_C_ppExpr x1 x2 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Expr d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppExpr" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppExpr" (showCons x3))

d_C_ppStmt :: C_Options -> AbstractHaskell.Curry_Types.C_Statement -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C_ppStmt x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_SExpr x3 -> d_C_ppExpr x1 (Curry_Prelude.C_Int
    (0)) x3 cd cs
  AbstractHaskell.Curry_Types.C_SPat x4 x5 -> Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_C_fillSep cd cs) (Curry_Prelude.OP_Cons (d_C_ppPattern
    x1 (Curry_Prelude.C_Int (0)) x4 cd cs) (Curry_Prelude.OP_Cons
    (Text.Curry_Pretty.d_C_larrow cd cs) (Curry_Prelude.OP_Cons (d_C_ppExpr x1
    (Curry_Prelude.C_Int (0)) x5 cd cs) Curry_Prelude.OP_List))) cd cs
  AbstractHaskell.Curry_Types.C_SLet x6 -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs)
    (Text.Curry_Pretty.d_C_text (Curry_Prelude.toCurryString "let") cd cs) cd
    cs) (d_C_ppBlock x1 x6 cd cs) cd cs
  AbstractHaskell.Curry_Types.Choice_C_Statement d i l r -> narrow d i
    (d_C_ppStmt x1 l cd cs) (d_C_ppStmt x1 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Statement d i xs -> narrows cs d i
    (\z -> d_C_ppStmt x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Statement d c e -> guardCons d c ((\x ->
    d_C_ppStmt x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Statement d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppStmt" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppStmt" (showCons x2))

nd_C_ppStmt :: C_Options -> AbstractHaskell.Curry_Types.C_Statement -> IDSupply
  -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppStmt x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_SExpr x3 -> let s0 = s
    in s0 `seq` nd_C_ppExpr x1 (Curry_Prelude.C_Int (0)) x3 s0 cd cs
  AbstractHaskell.Curry_Types.C_SPat x4 x5 -> let s7 = s
    in s7 `seq` (let s6 = leftSupply s7
                     s8 = rightSupply s7
                     s0 = leftSupply s8
                     s5 = rightSupply s8
    in s6 `seq` (s8 `seq` (s0 `seq` (s5 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_fillSep s0 cd cs) (let s1 = leftSupply s5
                                                   s4 = rightSupply s5
    in s1 `seq` (s4 `seq` Curry_Prelude.OP_Cons (nd_C_ppPattern x1
    (Curry_Prelude.C_Int (0)) x4 s1 cd cs) (let s2 = leftSupply s4
                                                s3 = rightSupply s4
    in s2 `seq` (s3 `seq` Curry_Prelude.OP_Cons (Text.Curry_Pretty.nd_C_larrow
    s2 cd cs) (Curry_Prelude.OP_Cons (nd_C_ppExpr x1 (Curry_Prelude.C_Int (0))
    x5 s3 cd cs) Curry_Prelude.OP_List))))) s6 cd cs))))
  AbstractHaskell.Curry_Types.C_SLet x6 -> let s7 = s
    in s7 `seq` (let s6 = leftSupply s7
                     s8 = rightSupply s7
                     s3 = leftSupply s8
                     s5 = rightSupply s8
    in s6 `seq` (s8 `seq` (s3 `seq` (s5 `seq` Curry_Prelude.nd_C_apply
    (let s2 = leftSupply s3
         s4 = rightSupply s3
         s0 = leftSupply s4
         s1 = rightSupply s4
    in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s0 cd cs) (Text.Curry_Pretty.nd_C_text
    (Curry_Prelude.toCurryString "let") s1 cd cs) s2 cd cs)))) (nd_C_ppBlock x1
    x6 s5 cd cs) s6 cd cs))))
  AbstractHaskell.Curry_Types.Choice_C_Statement d i l r -> narrow d i
    (nd_C_ppStmt x1 l s cd cs) (nd_C_ppStmt x1 r s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Statement d i xs -> narrows cs d i
    (\z -> nd_C_ppStmt x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Statement d c e -> guardCons d c ((\x ->
    nd_C_ppStmt x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Statement d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppStmt" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppStmt" (showCons x2))

d_C_ppPattern :: C_Options -> Curry_Prelude.C_Int
  -> AbstractHaskell.Curry_Types.C_Pattern -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C_ppPattern x1 x2 x3 cd cs = case x3 of
  AbstractHaskell.Curry_Types.C_PVar x4 -> d_C_ppVar x4 cd cs
  AbstractHaskell.Curry_Types.C_PLit x5 -> d_C_ppLitPattern x1 x5 cd cs
  AbstractHaskell.Curry_Types.C_PComb x6 x7 -> Curry_Prelude.d_OP_dollar
    (d_C_parensIf (Curry_Prelude.d_OP_amp_amp (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
    cd cs) x2 cd cs) (Curry_Prelude.C_Int (0)) cd cs) (Curry_Prelude.d_C_not
    (Curry_Prelude.d_C_null x7 cd cs) cd cs) cd cs)) (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_C_hsep cd cs) (Curry_Prelude.OP_Cons (d_C_ppQName x1 x6
    cd cs) (Curry_Prelude.d_C_map (d_C_ppPattern x1 (Curry_Prelude.C_Int (1)))
    x7 cd cs)) cd cs) cd cs
  AbstractHaskell.Curry_Types.C_PAs x8 x9 -> Text.Curry_Pretty.d_OP_lt_gt
    (Text.Curry_Pretty.d_OP_lt_gt (d_C_ppVar x8 cd cs) (Text.Curry_Pretty.d_C_at
    cd cs) cd cs) (d_C_ppPattern x1 (Curry_Prelude.C_Int (1)) x9 cd cs) cd cs
  AbstractHaskell.Curry_Types.C_PTuple x10 -> Curry_Prelude.d_C_apply
    (d_C_tupled cd cs) (Curry_Prelude.d_C_map (d_C_ppPattern x1
    (Curry_Prelude.C_Int (0))) x10 cd cs) cd cs
  AbstractHaskell.Curry_Types.C_PList x11 -> Curry_Prelude.d_C_apply (d_C_list
    cd cs) (Curry_Prelude.d_C_map (d_C_ppPattern x1 (Curry_Prelude.C_Int (0)))
    x11 cd cs) cd cs
  AbstractHaskell.Curry_Types.Choice_C_Pattern d i l r -> narrow d i
    (d_C_ppPattern x1 x2 l cd cs) (d_C_ppPattern x1 x2 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Pattern d i xs -> narrows cs d i (\z ->
    d_C_ppPattern x1 x2 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Pattern d c e -> guardCons d c ((\x ->
    d_C_ppPattern x1 x2 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Pattern d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppPattern" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppPattern" (showCons x3))

nd_C_ppPattern :: C_Options -> Curry_Prelude.C_Int
  -> AbstractHaskell.Curry_Types.C_Pattern -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppPattern x1 x2 x3 s cd cs = case x3 of
  AbstractHaskell.Curry_Types.C_PVar x4 -> let s0 = s
    in s0 `seq` nd_C_ppVar x4 s0 cd cs
  AbstractHaskell.Curry_Types.C_PLit x5 -> let s0 = s
    in s0 `seq` nd_C_ppLitPattern x1 x5 s0 cd cs
  AbstractHaskell.Curry_Types.C_PComb x6 x7 -> let s11 = s
    in s11 `seq` (let s10 = leftSupply s11
                      s12 = rightSupply s11
                      s2 = leftSupply s12
                      s8 = rightSupply s12
    in s10 `seq` (s12 `seq` (s2 `seq` (s8 `seq` Curry_Prelude.nd_OP_dollar
    (wrapNX id (nd_C_parensIf (Curry_Prelude.d_OP_amp_amp (let s1 = leftSupply
                                                                 s2
                                                               s0 = rightSupply
                                                                 s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply
    (wrapDX (wrapDX id)
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
    cd cs)) x2 s0 cd cs) (Curry_Prelude.C_Int (0)) s1 cd cs))
    (Curry_Prelude.d_C_not (Curry_Prelude.d_C_null x7 cd cs) cd cs) cd cs)))
    (let s7 = leftSupply s8
         s9 = rightSupply s8
         s3 = leftSupply s9
         s6 = rightSupply s9
    in s7 `seq` (s9 `seq` (s3 `seq` (s6 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_hsep s3 cd cs) (let s4 = leftSupply s6
                                                s5 = rightSupply s6
    in s4 `seq` (s5 `seq` Curry_Prelude.OP_Cons (nd_C_ppQName x1 x6 s4 cd cs)
    (Curry_Prelude.nd_C_map (wrapNX id (nd_C_ppPattern x1 (Curry_Prelude.C_Int
    (1)))) x7 s5 cd cs))) s7 cd cs)))) s10 cd cs))))
  AbstractHaskell.Curry_Types.C_PAs x8 x9 -> let s7 = s
    in s7 `seq` (let s6 = leftSupply s7
                     s8 = rightSupply s7
                     s3 = leftSupply s8
                     s5 = rightSupply s8
    in s6 `seq` (s8 `seq` (s3 `seq` (s5 `seq` Text.Curry_Pretty.nd_OP_lt_gt
    (let s2 = leftSupply s3
         s4 = rightSupply s3
         s0 = leftSupply s4
         s1 = rightSupply s4
    in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` Text.Curry_Pretty.nd_OP_lt_gt
    (nd_C_ppVar x8 s0 cd cs) (Text.Curry_Pretty.nd_C_at s1 cd cs) s2 cd cs))))
    (nd_C_ppPattern x1 (Curry_Prelude.C_Int (1)) x9 s5 cd cs) s6 cd cs))))
  AbstractHaskell.Curry_Types.C_PTuple x10 -> let s3 = s
    in s3 `seq` (let s2 = leftSupply s3
                     s4 = rightSupply s3
                     s0 = leftSupply s4
                     s1 = rightSupply s4
    in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` Curry_Prelude.nd_C_apply
    (nd_C_tupled s0 cd cs) (Curry_Prelude.nd_C_map (wrapNX id (nd_C_ppPattern x1
    (Curry_Prelude.C_Int (0)))) x10 s1 cd cs) s2 cd cs))))
  AbstractHaskell.Curry_Types.C_PList x11 -> let s3 = s
    in s3 `seq` (let s2 = leftSupply s3
                     s4 = rightSupply s3
                     s0 = leftSupply s4
                     s1 = rightSupply s4
    in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` Curry_Prelude.nd_C_apply
    (nd_C_list s0 cd cs) (Curry_Prelude.nd_C_map (wrapNX id (nd_C_ppPattern x1
    (Curry_Prelude.C_Int (0)))) x11 s1 cd cs) s2 cd cs))))
  AbstractHaskell.Curry_Types.Choice_C_Pattern d i l r -> narrow d i
    (nd_C_ppPattern x1 x2 l s cd cs) (nd_C_ppPattern x1 x2 r s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Pattern d i xs -> narrows cs d i (\z ->
    nd_C_ppPattern x1 x2 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Pattern d c e -> guardCons d c ((\x ->
    nd_C_ppPattern x1 x2 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Pattern d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppPattern" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppPattern" (showCons x3))

d_C_ppVar :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C_ppVar x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> Text.Curry_Pretty.d_C_text x3 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C_ppVar l cd cs)
    (d_C_ppVar r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C_ppVar z cd
    cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x -> d_C_ppVar e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppVar" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppVar" (showCons x1))

nd_C_ppVar :: Curry_Prelude.OP_Tuple2 Curry_Prelude.C_Int (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppVar x1 s cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> let s0 = s
    in s0 `seq` Text.Curry_Pretty.nd_C_text x3 s0 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (nd_C_ppVar l s cd cs)
    (nd_C_ppVar r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> nd_C_ppVar z s
    cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x -> nd_C_ppVar e s cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppVar" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppVar" (showCons x1))

d_C_ppLitPattern :: C_Options -> AbstractHaskell.Curry_Types.C_Literal -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C_ppLitPattern x1 x2 cd cs = d_C__case_13 x1 x2 (d_C_kics2Mode x1 cd cs) cd cs

nd_C_ppLitPattern :: C_Options -> AbstractHaskell.Curry_Types.C_Literal
  -> IDSupply -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppLitPattern x1 x2 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_C__case_13 x1 x2 (nd_C_kics2Mode x1 s0 cd cs) s1 cd
  cs))

d_OP_ppLitPattern_dot_wrapUnboxed_dot_210 :: C_Options
  -> AbstractHaskell.Curry_Types.C_Literal -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_OP_ppLitPattern_dot_wrapUnboxed_dot_210 x1 x2 x3 cd cs =
  Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_C_parens cd cs)
  (Text.Curry_Pretty.d_OP_lt_gt (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs)
  (d_C_ppQName x1 x3 cd cs) cd cs) (d_C_ppLiteral x2 cd cs) cd cs)
  (Text.Curry_Pretty.d_C_char (Curry_Prelude.C_Char '#'#) cd cs) cd cs) cd cs

nd_OP_ppLitPattern_dot_wrapUnboxed_dot_210 :: C_Options
  -> AbstractHaskell.Curry_Types.C_Literal -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_OP_ppLitPattern_dot_wrapUnboxed_dot_210 x1 x2 x3 s cd cs = let s15 = s
  in s15 `seq` (let s14 = leftSupply s15
                    s16 = rightSupply s15
                    s0 = leftSupply s16
                    s12 = rightSupply s16
  in s14 `seq` (s16 `seq` (s0 `seq` (s12 `seq` Curry_Prelude.nd_C_apply
  (Text.Curry_Pretty.nd_C_parens s0 cd cs) (let s11 = leftSupply s12
                                                s13 = rightSupply s12
                                                s8 = leftSupply s13
                                                s10 = rightSupply s13
  in s11 `seq` (s13 `seq` (s8 `seq` (s10 `seq` Text.Curry_Pretty.nd_OP_lt_gt
  (let s7 = leftSupply s8
       s9 = rightSupply s8
       s4 = leftSupply s9
       s6 = rightSupply s9
  in s7 `seq` (s9 `seq` (s4 `seq` (s6 `seq` Curry_Prelude.nd_C_apply
  (let s3 = leftSupply s4
       s5 = rightSupply s4
       s1 = leftSupply s5
       s2 = rightSupply s5
  in s3 `seq` (s5 `seq` (s1 `seq` (s2 `seq` Curry_Prelude.nd_C_apply
  (Text.Curry_Pretty.nd_OP_lt_plus_gt s1 cd cs) (nd_C_ppQName x1 x3 s2 cd cs) s3
  cd cs)))) (nd_C_ppLiteral x2 s6 cd cs) s7 cd cs))))
  (Text.Curry_Pretty.nd_C_char (Curry_Prelude.C_Char '#'#) s10 cd cs) s11 cd
  cs)))) s14 cd cs))))

d_C_ppBranchExpr :: C_Options -> AbstractHaskell.Curry_Types.C_BranchExpr
  -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C_ppBranchExpr x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Branch x3 x4 -> Curry_Prelude.d_OP_dollar
    (d_C_indent cd cs) (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs)
    (d_C_ppPattern x1 (Curry_Prelude.C_Int (0)) x3 cd cs) cd cs)
    (Text.Curry_Pretty.d_C_rarrow cd cs) cd cs) cd cs) (d_C_ppExpr x1
    (Curry_Prelude.C_Int (0)) x4 cd cs) cd cs) cd cs
  AbstractHaskell.Curry_Types.Choice_C_BranchExpr d i l r -> narrow d i
    (d_C_ppBranchExpr x1 l cd cs) (d_C_ppBranchExpr x1 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_BranchExpr d i xs -> narrows cs d i
    (\z -> d_C_ppBranchExpr x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_BranchExpr d c e -> guardCons d c ((\x ->
    d_C_ppBranchExpr x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_BranchExpr d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppBranchExpr" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppBranchExpr" (showCons
    x2))

nd_C_ppBranchExpr :: C_Options -> AbstractHaskell.Curry_Types.C_BranchExpr
  -> IDSupply -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppBranchExpr x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Branch x3 x4 -> let s19 = s
    in s19 `seq` (let s18 = leftSupply s19
                      s20 = rightSupply s19
                      s0 = leftSupply s20
                      s16 = rightSupply s20
    in s18 `seq` (s20 `seq` (s0 `seq` (s16 `seq` Curry_Prelude.nd_OP_dollar
    (nd_C_indent s0 cd cs) (let s15 = leftSupply s16
                                s17 = rightSupply s16
                                s12 = leftSupply s17
                                s14 = rightSupply s17
    in s15 `seq` (s17 `seq` (s12 `seq` (s14 `seq` Curry_Prelude.nd_C_apply
    (let s11 = leftSupply s12
         s13 = rightSupply s12
         s1 = leftSupply s13
         s9 = rightSupply s13
    in s11 `seq` (s13 `seq` (s1 `seq` (s9 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s1 cd cs) (let s8 = leftSupply s9
                                                       s10 = rightSupply s9
                                                       s5 = leftSupply s10
                                                       s7 = rightSupply s10
    in s8 `seq` (s10 `seq` (s5 `seq` (s7 `seq` Curry_Prelude.nd_C_apply
    (let s4 = leftSupply s5
         s6 = rightSupply s5
         s2 = leftSupply s6
         s3 = rightSupply s6
    in s4 `seq` (s6 `seq` (s2 `seq` (s3 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s2 cd cs) (nd_C_ppPattern x1
    (Curry_Prelude.C_Int (0)) x3 s3 cd cs) s4 cd cs))))
    (Text.Curry_Pretty.nd_C_rarrow s7 cd cs) s8 cd cs)))) s11 cd cs))))
    (nd_C_ppExpr x1 (Curry_Prelude.C_Int (0)) x4 s14 cd cs) s15 cd cs)))) s18 cd
    cs))))
  AbstractHaskell.Curry_Types.Choice_C_BranchExpr d i l r -> narrow d i
    (nd_C_ppBranchExpr x1 l s cd cs) (nd_C_ppBranchExpr x1 r s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_BranchExpr d i xs -> narrows cs d i
    (\z -> nd_C_ppBranchExpr x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_BranchExpr d c e -> guardCons d c ((\x ->
    nd_C_ppBranchExpr x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_BranchExpr d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppBranchExpr" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppBranchExpr" (showCons
    x2))

d_C_ppLiteral :: AbstractHaskell.Curry_Types.C_Literal -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C_ppLiteral x1 cd cs = case x1 of
  AbstractHaskell.Curry_Types.C_Intc x2 -> Text.Curry_Pretty.d_C_int x2 cd cs
  AbstractHaskell.Curry_Types.C_Floatc x3 -> Text.Curry_Pretty.d_C_float x3 cd
    cs
  AbstractHaskell.Curry_Types.C_Charc x4 -> Text.Curry_Pretty.d_C_text
    (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Char_hash
    cd cs) x4 cd cs) cd cs
  AbstractHaskell.Curry_Types.C_Stringc x5 -> Text.Curry_Pretty.d_C_text
    (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_lbracket_rbracket_hash_0_hash_hash
    Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char_hash
    cd cs) x5 cd cs) cd cs
  AbstractHaskell.Curry_Types.Choice_C_Literal d i l r -> narrow d i
    (d_C_ppLiteral l cd cs) (d_C_ppLiteral r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Literal d i xs -> narrows cs d i (\z ->
    d_C_ppLiteral z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Literal d c e -> guardCons d c ((\x ->
    d_C_ppLiteral e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Literal d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppLiteral" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppLiteral" (showCons x1))

nd_C_ppLiteral :: AbstractHaskell.Curry_Types.C_Literal -> IDSupply -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppLiteral x1 s cd cs = case x1 of
  AbstractHaskell.Curry_Types.C_Intc x2 -> let s0 = s
    in s0 `seq` Text.Curry_Pretty.nd_C_int x2 s0 cd cs
  AbstractHaskell.Curry_Types.C_Floatc x3 -> let s0 = s
    in s0 `seq` Text.Curry_Pretty.nd_C_float x3 s0 cd cs
  AbstractHaskell.Curry_Types.C_Charc x4 -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Text.Curry_Pretty.nd_C_text (Curry_Prelude.nd_C_apply
    (wrapDX id
    (Curry_Prelude.d_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_Prelude_dot_Char_hash
    cd cs)) x4 s0 cd cs) s1 cd cs))
  AbstractHaskell.Curry_Types.C_Stringc x5 -> let s4 = s
    in s4 `seq` (let s3 = leftSupply s4
                     s2 = rightSupply s4
    in s3 `seq` (s2 `seq` Text.Curry_Pretty.nd_C_text (let s1 = leftSupply s2
                                                           s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply
    (Curry_Prelude.nd_OP_uscore_impl_hash_show_hash_Prelude_dot_Show_hash_lbracket_rbracket_hash_0_hash_hash
    (wrapNX id
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Show_hash_Prelude_dot_Char_hash)
    s0 cd cs) x5 s1 cd cs)) s3 cd cs))
  AbstractHaskell.Curry_Types.Choice_C_Literal d i l r -> narrow d i
    (nd_C_ppLiteral l s cd cs) (nd_C_ppLiteral r s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Literal d i xs -> narrows cs d i (\z ->
    nd_C_ppLiteral z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Literal d c e -> guardCons d c ((\x ->
    nd_C_ppLiteral e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Literal d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppLiteral" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppLiteral" (showCons x1))

d_C_ppPrefixOp :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C_ppPrefixOp x1 cd cs = d_C_parensIf (Curry_Prelude.d_C_apply
  (d_C_isInfixOpName cd cs) x1 cd cs) (Text.Curry_Pretty.d_C_text x1 cd cs) cd
  cs

nd_C_ppPrefixOp :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> IDSupply
  -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppPrefixOp x1 s cd cs = let s3 = s
  in s3 `seq` (let s2 = leftSupply s3
                   s4 = rightSupply s3
                   s0 = leftSupply s4
                   s1 = rightSupply s4
  in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` nd_C_parensIf
  (Curry_Prelude.nd_C_apply (wrapDX id (d_C_isInfixOpName cd cs)) x1 s0 cd cs)
  (Text.Curry_Pretty.nd_C_text x1 s1 cd cs) s2 cd cs))))

d_C_ppInfixOp :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C_ppInfixOp x1 cd cs = d_C__case_10 x1 (Curry_Prelude.d_C_apply
  (d_C_isInfixOpName cd cs) x1 cd cs) cd cs

nd_C_ppInfixOp :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> IDSupply
  -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppInfixOp x1 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_C__case_10 x1 (Curry_Prelude.nd_C_apply (wrapDX id
  (d_C_isInfixOpName cd cs)) x1 s0 cd cs) s1 cd cs))

d_C_ppPrefixQOp :: C_Options -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C_ppPrefixQOp x1 x2 cd cs = d_C_parensIf (Curry_Prelude.d_C_apply
  (d_C_isInfixOpName cd cs) (Curry_Prelude.d_C_snd x2 cd cs) cd cs) (d_C_ppQName
  x1 x2 cd cs) cd cs

nd_C_ppPrefixQOp :: C_Options -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply
  -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppPrefixQOp x1 x2 s cd cs = let s3 = s
  in s3 `seq` (let s2 = leftSupply s3
                   s4 = rightSupply s3
                   s0 = leftSupply s4
                   s1 = rightSupply s4
  in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` nd_C_parensIf
  (Curry_Prelude.nd_C_apply (wrapDX id (d_C_isInfixOpName cd cs))
  (Curry_Prelude.d_C_snd x2 cd cs) s0 cd cs) (nd_C_ppQName x1 x2 s1 cd cs) s2 cd
  cs))))

d_C_ppInfixQOp :: C_Options -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C_ppInfixQOp x1 x2 cd cs = d_C__case_9 x2 x1 (Curry_Prelude.d_C_apply
  (d_C_isInfixOpName cd cs) (Curry_Prelude.d_C_snd x2 cd cs) cd cs) cd cs

nd_C_ppInfixQOp :: C_Options -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply
  -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppInfixQOp x1 x2 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_C__case_9 x2 x1 (Curry_Prelude.nd_C_apply (wrapDX id
  (d_C_isInfixOpName cd cs)) (Curry_Prelude.d_C_snd x2 cd cs) s0 cd cs) s1 cd
  cs))

d_C_ppName :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C_ppName x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> Text.Curry_Pretty.d_C_text x3 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C_ppName l cd cs)
    (d_C_ppName r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C_ppName z
    cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x -> d_C_ppName e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppName" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppName" (showCons x1))

nd_C_ppName :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply
  -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppName x1 s cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> let s0 = s
    in s0 `seq` Text.Curry_Pretty.nd_C_text x3 s0 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (nd_C_ppName l s cd cs)
    (nd_C_ppName r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> nd_C_ppName z
    s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x -> nd_C_ppName e s
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppName" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppName" (showCons x1))

d_C_ppQName :: C_Options -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C_ppQName x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> d_C__case_8 x3 x1 x4
    (Curry_Prelude.d_OP_bar_bar
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket_hash_0_hash_hash
    Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
    x3 (d_C_currentModule x1 cd cs) cd cs) (Curry_Prelude.d_C_not
    (Curry_Prelude.d_C_apply (d_C_qualImpModule x1 cd cs) x3 cd cs) cd cs) cd
    cs) cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C_ppQName x1 l cd cs)
    (d_C_ppQName x1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C_ppQName x1
    z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x -> d_C_ppQName x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppQName" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppQName" (showCons x2))

nd_C_ppQName :: C_Options -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply
  -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C_ppQName x1 x2 s cd cs = case x2 of
  Curry_Prelude.OP_Tuple2 x3 x4 -> let s8 = s
    in s8 `seq` (let s7 = leftSupply s8
                     s6 = rightSupply s8
    in s7 `seq` (s6 `seq` nd_C__case_8 x3 x1 x4 (let s2 = leftSupply s6
                                                     s5 = rightSupply s6
    in s2 `seq` (s5 `seq` Curry_Prelude.d_OP_bar_bar (let s1 = leftSupply s2
                                                          s0 = rightSupply s2
    in s1 `seq` (s0 `seq`
    Curry_Prelude.nd_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket_hash_0_hash_hash
    (wrapNX id
    Curry_Prelude.nd_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash)
    x3 (nd_C_currentModule x1 s0 cd cs) s1 cd cs)) (Curry_Prelude.d_C_not
    (let s4 = leftSupply s5
         s3 = rightSupply s5
    in s4 `seq` (s3 `seq` Curry_Prelude.nd_C_apply (nd_C_qualImpModule x1 s3 cd
    cs) x3 s4 cd cs)) cd cs) cd cs)) s7 cd cs))
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (nd_C_ppQName x1 l s cd
    cs) (nd_C_ppQName x1 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> nd_C_ppQName
    x1 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x -> nd_C_ppQName x1 e
    s cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractHaskell.Printer.ppQName" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.ppQName" (showCons x2))

d_C_isList :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_C_isList x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket_hash_0_hash_hash
    Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
    x3 (Curry_Prelude.toCurryString "[]") cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C_isList l cd cs)
    (d_C_isList r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C_isList z
    cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x -> d_C_isList e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractHaskell.Printer.isList" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.isList" (showCons x1))

d_C_isTuple :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_C_isTuple x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> d_C__case_6 x3 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C_isTuple l cd cs)
    (d_C_isTuple r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C_isTuple z
    cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x -> d_C_isTuple e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractHaskell.Printer.isTuple" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.isTuple" (showCons x1))

d_OP_isTuple_dot_p1_uscore_isTuple_dot_256 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_OP_isTuple_dot_p1_uscore_isTuple_dot_256 x1 cd cs = case x1 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_False
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_5 x2 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_isTuple_dot_p1_uscore_isTuple_dot_256 l cd cs)
    (d_OP_isTuple_dot_p1_uscore_isTuple_dot_256 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_isTuple_dot_p1_uscore_isTuple_dot_256 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x ->
    d_OP_isTuple_dot_p1_uscore_isTuple_dot_256 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "AbstractHaskell.Printer.isTuple.p1_isTuple.256" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.isTuple.p1_isTuple.256"
    (showCons x1))

d_C_isInfixOpName :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_isInfixOpName cd cs = Curry_Prelude.d_C_all (Curry_Prelude.d_C_flip
  (Curry_Prelude.d_C_elem
  Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash)
  (d_C_infixIDs cd cs)) cd cs

d_C_infixIDs :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_infixIDs cd cs = Curry_Prelude.toCurryString "~!@#$%^&*+-=<>?./|\\:"

d_C_parensIf :: Curry_Prelude.C_Bool -> Text.Curry_PrettyImpl.C_Doc -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C_parensIf x1 x2 cd cs = case x1 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_C_parens
    cd cs) x2 cd cs
  Curry_Prelude.C_False -> d_C__case_4 x2 (Curry_Prelude.d_C_otherwise cd cs) cd
    cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C_parensIf l x2 cd cs)
    (d_C_parensIf r x2 cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C_parensIf z x2
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C_parensIf e x2 cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer.parensIf" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.parensIf" (showCons x1))

nd_C_parensIf :: Curry_Prelude.C_Bool -> Text.Curry_PrettyImpl.C_Doc -> IDSupply
  -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C_parensIf x1 x2 s cd cs = case x1 of
  Curry_Prelude.C_True -> let s2 = s
    in s2 `seq` (let s1 = leftSupply s2
                     s0 = rightSupply s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_parens s0 cd cs) x2 s1 cd cs))
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_4 x2 (Curry_Prelude.d_C_otherwise cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C_parensIf l x2 s cd cs)
    (nd_C_parensIf r x2 s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C_parensIf z
    x2 s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C_parensIf e x2 s
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer.parensIf" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.parensIf" (showCons x1))

d_C_indent :: Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C_indent cd cs = Text.Curry_Pretty.d_C_nest (Curry_Prelude.C_Int (2))

nd_C_indent :: IDSupply -> Cover -> ConstStore -> Func
  Text.Curry_PrettyImpl.C_Doc Text.Curry_PrettyImpl.C_Doc
nd_C_indent s cd cs = wrapNX id (Text.Curry_Pretty.nd_C_nest
  (Curry_Prelude.C_Int (2)))

d_C_sequence :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Text.Curry_PrettyImpl.C_Doc -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C_sequence cd cs = Curry_Prelude.d_OP_dot (Text.Curry_Pretty.d_C_fillSep cd
  cs) (Text.Curry_Pretty.d_C_punctuate (Text.Curry_Pretty.d_C_comma cd cs)) cd
  cs

nd_C_sequence :: IDSupply -> Cover -> ConstStore -> Func (Curry_Prelude.OP_List
  Text.Curry_PrettyImpl.C_Doc) Text.Curry_PrettyImpl.C_Doc
nd_C_sequence s cd cs = let s3 = s
  in s3 `seq` (let s2 = leftSupply s3
                   s4 = rightSupply s3
                   s0 = leftSupply s4
                   s1 = rightSupply s4
  in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` Curry_Prelude.nd_OP_dot
  (Text.Curry_Pretty.nd_C_fillSep s0 cd cs) (wrapNX id
  (Text.Curry_Pretty.nd_C_punctuate (Text.Curry_Pretty.nd_C_comma s1 cd cs))) s2
  cd cs))))

d_C_fillEncloseSep :: Text.Curry_PrettyImpl.C_Doc -> Text.Curry_PrettyImpl.C_Doc
  -> Text.Curry_PrettyImpl.C_Doc -> Curry_Prelude.OP_List
  Text.Curry_PrettyImpl.C_Doc -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C_fillEncloseSep x1 x2 x3 x4 cd cs = case x4 of
  Curry_Prelude.OP_List -> Text.Curry_Pretty.d_OP_lt_gt x1 x2 cd cs
  Curry_Prelude.OP_Cons x5 x6 -> Text.Curry_Pretty.d_C_enclose x1 x2
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_C_fillCat cd cs)
    (Curry_Prelude.OP_Cons x5 (Curry_Prelude.d_C_map
    (Text.Curry_Pretty.d_OP_lt_gt x3) x6 cd cs)) cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_fillEncloseSep x1 x2
    x3 l cd cs) (d_C_fillEncloseSep x1 x2 x3 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_C_fillEncloseSep x1 x2 x3 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C_fillEncloseSep
    x1 x2 x3 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "AbstractHaskell.Printer.fillEncloseSep" [show x1, show x2, show x3, show
    x4] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.fillEncloseSep" (showCons
    x4))

nd_C_fillEncloseSep :: Text.Curry_PrettyImpl.C_Doc
  -> Text.Curry_PrettyImpl.C_Doc -> Text.Curry_PrettyImpl.C_Doc
  -> Curry_Prelude.OP_List Text.Curry_PrettyImpl.C_Doc -> IDSupply -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C_fillEncloseSep x1 x2 x3 x4 s cd cs = case x4 of
  Curry_Prelude.OP_List -> let s0 = s
    in s0 `seq` Text.Curry_Pretty.nd_OP_lt_gt x1 x2 s0 cd cs
  Curry_Prelude.OP_Cons x5 x6 -> let s6 = s
    in s6 `seq` (let s5 = leftSupply s6
                     s3 = rightSupply s6
    in s5 `seq` (s3 `seq` Text.Curry_Pretty.nd_C_enclose x1 x2
    (let s2 = leftSupply s3
         s4 = rightSupply s3
         s0 = leftSupply s4
         s1 = rightSupply s4
    in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_fillCat s0 cd cs) (Curry_Prelude.OP_Cons x5
    (Curry_Prelude.nd_C_map (wrapNX id (Text.Curry_Pretty.nd_OP_lt_gt x3)) x6 s1
    cd cs)) s2 cd cs)))) s5 cd cs))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C_fillEncloseSep x1 x2
    x3 l s cd cs) (nd_C_fillEncloseSep x1 x2 x3 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    nd_C_fillEncloseSep x1 x2 x3 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> nd_C_fillEncloseSep
    x1 x2 x3 e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "AbstractHaskell.Printer.fillEncloseSep" [show x1, show x2, show x3, show
    x4] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.fillEncloseSep" (showCons
    x4))

d_C_list :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Text.Curry_PrettyImpl.C_Doc -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C_list cd cs = d_C_fillEncloseSep (Text.Curry_Pretty.d_C_lbracket cd cs)
  (Text.Curry_Pretty.d_C_rbracket cd cs) (Text.Curry_Pretty.d_OP_lt_gt
  (Text.Curry_Pretty.d_C_comma cd cs) (Text.Curry_Pretty.d_C_space cd cs) cd cs)

nd_C_list :: IDSupply -> Cover -> ConstStore -> Func (Curry_Prelude.OP_List
  Text.Curry_PrettyImpl.C_Doc) Text.Curry_PrettyImpl.C_Doc
nd_C_list s cd cs = let s7 = s
  in s7 `seq` (let s0 = leftSupply s7
                   s8 = rightSupply s7
                   s1 = leftSupply s8
                   s5 = rightSupply s8
  in s0 `seq` (s8 `seq` (s1 `seq` (s5 `seq` wrapNX id (nd_C_fillEncloseSep
  (Text.Curry_Pretty.nd_C_lbracket s0 cd cs) (Text.Curry_Pretty.nd_C_rbracket s1
  cd cs) (let s4 = leftSupply s5
              s6 = rightSupply s5
              s2 = leftSupply s6
              s3 = rightSupply s6
  in s4 `seq` (s6 `seq` (s2 `seq` (s3 `seq` Text.Curry_Pretty.nd_OP_lt_gt
  (Text.Curry_Pretty.nd_C_comma s2 cd cs) (Text.Curry_Pretty.nd_C_space s3 cd
  cs) s4 cd cs)))))))))

d_C_tupled :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Text.Curry_PrettyImpl.C_Doc -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C_tupled cd cs = d_C_fillEncloseSep (Text.Curry_Pretty.d_C_lparen cd cs)
  (Text.Curry_Pretty.d_C_rparen cd cs) (Text.Curry_Pretty.d_OP_lt_gt
  (Text.Curry_Pretty.d_C_comma cd cs) (Text.Curry_Pretty.d_C_space cd cs) cd cs)

nd_C_tupled :: IDSupply -> Cover -> ConstStore -> Func (Curry_Prelude.OP_List
  Text.Curry_PrettyImpl.C_Doc) Text.Curry_PrettyImpl.C_Doc
nd_C_tupled s cd cs = let s7 = s
  in s7 `seq` (let s0 = leftSupply s7
                   s8 = rightSupply s7
                   s1 = leftSupply s8
                   s5 = rightSupply s8
  in s0 `seq` (s8 `seq` (s1 `seq` (s5 `seq` wrapNX id (nd_C_fillEncloseSep
  (Text.Curry_Pretty.nd_C_lparen s0 cd cs) (Text.Curry_Pretty.nd_C_rparen s1 cd
  cs) (let s4 = leftSupply s5
           s6 = rightSupply s5
           s2 = leftSupply s6
           s3 = rightSupply s6
  in s4 `seq` (s6 `seq` (s2 `seq` (s3 `seq` Text.Curry_Pretty.nd_OP_lt_gt
  (Text.Curry_Pretty.nd_C_comma s2 cd cs) (Text.Curry_Pretty.nd_C_space s3 cd
  cs) s4 cd cs)))))))))

d_C_curryPrefix :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_curryPrefix cd cs = Curry_Prelude.toCurryString "Curry_"

d_C_tracePrefix :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_tracePrefix cd cs = Curry_Prelude.toCurryString "Trace_"

d_C_curryPrelude :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_curryPrelude cd cs = Curry_Prelude.d_C_apply (d_C_renameModule cd cs)
  (Curry_Prelude.toCurryString "Prelude") cd cs

d_C_renameModule :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_renameModule cd cs = d_C_onLastIdentifier (Curry_Prelude.d_OP_plus_plus
  (d_C_curryPrefix cd cs)) cd cs

d_C_unRenameModule :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_unRenameModule cd cs = d_C_onLastIdentifier (d_C_dropPrefix
  Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
  (d_C_curryPrefix cd cs)) cd cs

d_C_addTrace :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_addTrace cd cs = Curry_Prelude.d_OP_dot (d_C_renameModule cd cs)
  (Curry_Prelude.d_OP_dot (d_C_onLastIdentifier (Curry_Prelude.d_OP_plus_plus
  (d_C_tracePrefix cd cs)) cd cs) (d_C_unRenameModule cd cs) cd cs) cd cs

d_C_removeTrace :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_removeTrace cd cs = Curry_Prelude.d_OP_dot (d_C_renameModule cd cs)
  (Curry_Prelude.d_OP_dot (d_C_onLastIdentifier (d_C_dropPrefix
  Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
  (d_C_tracePrefix cd cs)) cd cs) (d_C_unRenameModule cd cs) cd cs) cd cs

d_C_onLastIdentifier :: (Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_onLastIdentifier x1 cd cs = Curry_Prelude.d_OP_dot
  (d_C_joinModuleIdentifiers cd cs) (Curry_Prelude.d_OP_dot (d_C_onLast x1)
  d_C_splitModuleIdentifiers cd cs) cd cs

nd_C_onLastIdentifier :: Func (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply -> Cover
  -> ConstStore -> Func (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
nd_C_onLastIdentifier x1 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` Curry_Prelude.nd_OP_dot (wrapDX id
  (d_C_joinModuleIdentifiers cd cs)) (Curry_Prelude.nd_OP_dot (wrapNX id
  (nd_C_onLast x1)) (wrapDX id d_C_splitModuleIdentifiers) s0 cd cs) s1 cd cs))

d_C_onLast :: forall t0 . (Curry_Prelude.Curry t0) => (t0 -> Cover -> ConstStore
  -> t0) -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0
d_C_onLast x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "Names.onLast: empty list") cd cs
  Curry_Prelude.OP_Cons x3 x4 -> d_C__case_3 x1 x3 x4 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_onLast x1 l cd cs)
    (d_C_onLast x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_onLast x1 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C_onLast x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "AbstractHaskell.Printer.onLast" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.onLast" (showCons x2))

nd_C_onLast :: forall t0 . (Curry_Prelude.Curry t0) => Func t0 t0
  -> Curry_Prelude.OP_List t0 -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0
nd_C_onLast x1 x2 s cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_error (Curry_Prelude.toCurryString
    "Names.onLast: empty list") cd cs
  Curry_Prelude.OP_Cons x3 x4 -> let s0 = s
    in s0 `seq` nd_C__case_3 x1 x3 x4 s0 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C_onLast x1 l s cd cs)
    (nd_C_onLast x1 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C_onLast x1 z
    s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> nd_C_onLast x1 e s
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "AbstractHaskell.Printer.onLast" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer.onLast" (showCons x2))

d_C_splitModuleIdentifiers :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_splitModuleIdentifiers x1 cd cs = let x2 = Curry_Prelude.d_C_apply
                                            (Curry_Prelude.d_C_break
                                            (Curry_Prelude.d_C_flip (acceptCs id
                                            Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash)
                                            (Curry_Prelude.C_Char '.'#)) cd cs)
                                            x1 cd cs
                                          x3 = d_OP_splitModuleIdentifiers_dot_uscore_hash_selFP2_hash_pref
                                            x2 cd cs
                                          x4 = d_OP_splitModuleIdentifiers_dot_uscore_hash_selFP3_hash_rest
                                            x2 cd cs
  in Curry_Prelude.OP_Cons x3 (d_C__case_2 x4 cd cs)

d_OP_splitModuleIdentifiers_dot_uscore_hash_selFP2_hash_pref :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitModuleIdentifiers_dot_uscore_hash_selFP2_hash_pref x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitModuleIdentifiers_dot_uscore_hash_selFP2_hash_pref l cd cs)
    (d_OP_splitModuleIdentifiers_dot_uscore_hash_selFP2_hash_pref r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitModuleIdentifiers_dot_uscore_hash_selFP2_hash_pref z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_splitModuleIdentifiers_dot_uscore_hash_selFP2_hash_pref e cd x) $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractHaskell.Printer.splitModuleIdentifiers._#selFP2#pref" [show x1]
    info)
  _ -> failCons cd (consFail
    "AbstractHaskell.Printer.splitModuleIdentifiers._#selFP2#pref" (showCons
    x1))

d_OP_splitModuleIdentifiers_dot_uscore_hash_selFP3_hash_rest :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitModuleIdentifiers_dot_uscore_hash_selFP3_hash_rest x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitModuleIdentifiers_dot_uscore_hash_selFP3_hash_rest l cd cs)
    (d_OP_splitModuleIdentifiers_dot_uscore_hash_selFP3_hash_rest r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitModuleIdentifiers_dot_uscore_hash_selFP3_hash_rest z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_splitModuleIdentifiers_dot_uscore_hash_selFP3_hash_rest e cd x) $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractHaskell.Printer.splitModuleIdentifiers._#selFP3#rest" [show x1]
    info)
  _ -> failCons cd (consFail
    "AbstractHaskell.Printer.splitModuleIdentifiers._#selFP3#rest" (showCons
    x1))

d_C_joinModuleIdentifiers :: Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_joinModuleIdentifiers cd cs = Curry_Prelude.d_C_foldr1 (acceptCs id
  d_OP_joinModuleIdentifiers_dot_combine_dot_317)

d_OP_joinModuleIdentifiers_dot_combine_dot_317 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_joinModuleIdentifiers_dot_combine_dot_317 x1 x2 cd cs =
  Curry_Prelude.d_OP_plus_plus x1 (Curry_Prelude.OP_Cons (Curry_Prelude.C_Char
  '.'#) x2) cd cs

d_C_dropPrefix :: forall t0 . (Curry_Prelude.Curry t0) => (Curry_Prelude.OP_Unit
  -> Cover -> ConstStore -> Curry_Prelude.OP_uscore_Dict_hash_Eq t0)
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0
d_C_dropPrefix x1 x2 x3 cd cs = d_C__case_1 x3 x2 x1
  (Data.Curry_List.d_C_isPrefixOf x1 x2 x3 cd cs) cd cs

nd_C_dropPrefix :: forall t0 . (Curry_Prelude.Curry t0) => Func
  Curry_Prelude.OP_Unit (Curry_Prelude.OP_uscore_Dict_hash_Eq t0)
  -> Curry_Prelude.OP_List t0 -> Curry_Prelude.OP_List t0 -> IDSupply -> Cover
  -> ConstStore -> Curry_Prelude.OP_List t0
nd_C_dropPrefix x1 x2 x3 s cd cs = let s2 = s
  in s2 `seq` (let s1 = leftSupply s2
                   s0 = rightSupply s2
  in s1 `seq` (s0 `seq` nd_C__case_1 x3 x2 x1 (Data.Curry_List.nd_C_isPrefixOf
  x1 x2 x3 s0 cd cs) s1 cd cs))

d_C__case_44 :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> C_Options -> Cover
  -> ConstStore -> C_Options
d_C__case_44 x3 x1 cd cs = case x1 of
  C_Options x9 x10 x11 x12 -> C_Options x3 x10 x11 x12
  Choice_C_Options d i l r -> narrow d i (d_C__case_44 x3 l cd cs) (d_C__case_44
    x3 r cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z -> d_C__case_44 x3 z cd cs) xs
  Guard_C_Options d c e -> guardCons d c ((\x -> d_C__case_44 x3 e cd x) $!
    addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_44" [show x3, show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_44" (showCons x1))

nd_C__case_44 :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> C_Options
  -> IDSupply -> Cover -> ConstStore -> C_Options
nd_C__case_44 x3 x1 s cd cs = case x1 of
  HO_C_Options x9 x10 x11 x12 -> HO_C_Options x3 x10 x11 x12
  Choice_C_Options d i l r -> narrow d i (nd_C__case_44 x3 l s cd cs)
    (nd_C__case_44 x3 r s cd cs)
  Choices_C_Options d i xs -> narrows cs d i (\z -> nd_C__case_44 x3 z s cd cs)
    xs
  Guard_C_Options d c e -> guardCons d c ((\x -> nd_C__case_44 x3 e s cd x) $!
    addCs c cs)
  Fail_C_Options d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_44" [show x3, show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_44" (showCons x1))

d_C__case_43 :: C_Options -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_43 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (d_C_addTrace cd cs) x2 cd cs
  Curry_Prelude.C_False -> x2
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_43 x1 x2 l cd cs)
    (d_C__case_43 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_43 x1
    x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_43 x1 x2 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_43" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_43" (showCons x3))

nd_C__case_43 :: C_Options -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
nd_C__case_43 x1 x2 x3 s cd cs = case x3 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` Curry_Prelude.nd_C_apply (wrapDX id (d_C_addTrace cd cs)) x2 s0
    cd cs
  Curry_Prelude.C_False -> x2
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_43 x1 x2 l s cd
    cs) (nd_C__case_43 x1 x2 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_43 x1
    x2 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_43 x1 x2
    e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_43" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_43" (showCons x3))

d_C__case_38 :: AbstractHaskell.Curry_Types.C_Visibility
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> C_Options
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C__case_38 x12 x11 x1 x13 cd cs = case x13 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (d_C_ppQName x1 x11 cd cs) cd cs)
    (Text.Curry_Pretty.d_C_text (Curry_Prelude.toCurryString "(..)") cd cs) cd
    cs
  Curry_Prelude.C_False -> d_C__case_37 (Curry_Prelude.d_C_otherwise cd cs) cd
    cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_38 x12 x11 x1 l
    cd cs) (d_C__case_38 x12 x11 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_38 x12
    x11 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_38 x12 x11
    x1 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_38" [show x12, show x11, show x1, show x13]
    info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_38" (showCons x13))

nd_C__case_38 :: AbstractHaskell.Curry_Types.C_Visibility
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> C_Options
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_38 x12 x11 x1 x13 s cd cs = case x13 of
  Curry_Prelude.C_True -> let s7 = s
    in s7 `seq` (let s6 = leftSupply s7
                     s8 = rightSupply s7
                     s3 = leftSupply s8
                     s5 = rightSupply s8
    in s6 `seq` (s8 `seq` (s3 `seq` (s5 `seq` Curry_Prelude.nd_C_apply
    (let s2 = leftSupply s3
         s4 = rightSupply s3
         s0 = leftSupply s4
         s1 = rightSupply s4
    in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s0 cd cs) (nd_C_ppQName x1 x11 s1 cd cs)
    s2 cd cs)))) (Text.Curry_Pretty.nd_C_text (Curry_Prelude.toCurryString
    "(..)") s5 cd cs) s6 cd cs))))
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_37 (Curry_Prelude.d_C_otherwise cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_38 x12 x11 x1 l
    s cd cs) (nd_C__case_38 x12 x11 x1 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_38 x12
    x11 x1 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_38 x12
    x11 x1 e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_38" [show x12, show x11, show x1, show x13]
    info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_38" (showCons x13))

d_C__case_37 :: Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C__case_37 x1 cd cs = case x1 of
  Curry_Prelude.C_True -> Text.Curry_Pretty.d_C_empty cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_37 l cd cs)
    (d_C__case_37 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_37 z cd
    cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_37 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_37" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_37" (showCons x1))

nd_C__case_37 :: Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_37 x1 s cd cs = case x1 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` Text.Curry_Pretty.nd_C_empty s0 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_37 l s cd cs)
    (nd_C__case_37 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_37 z s
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_37 e s cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_37" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_37" (showCons x1))

d_C__case_40 :: AbstractHaskell.Curry_Types.C_Visibility
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> C_Options
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C__case_40 x8 x7 x1 x9 cd cs = case x9 of
  Curry_Prelude.C_True -> d_C_ppQName x1 x7 cd cs
  Curry_Prelude.C_False -> d_C__case_39 (Curry_Prelude.d_C_otherwise cd cs) cd
    cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_40 x8 x7 x1 l cd
    cs) (d_C__case_40 x8 x7 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_40 x8
    x7 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_40 x8 x7
    x1 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_40" [show x8, show x7, show x1, show x9]
    info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_40" (showCons x9))

nd_C__case_40 :: AbstractHaskell.Curry_Types.C_Visibility
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> C_Options
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_40 x8 x7 x1 x9 s cd cs = case x9 of
  Curry_Prelude.C_True -> let s0 = s in s0 `seq` nd_C_ppQName x1 x7 s0 cd cs
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_39 (Curry_Prelude.d_C_otherwise cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_40 x8 x7 x1 l s
    cd cs) (nd_C__case_40 x8 x7 x1 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_40 x8
    x7 x1 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_40 x8 x7
    x1 e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_40" [show x8, show x7, show x1, show x9]
    info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_40" (showCons x9))

d_C__case_39 :: Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C__case_39 x1 cd cs = case x1 of
  Curry_Prelude.C_True -> Text.Curry_Pretty.d_C_empty cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_39 l cd cs)
    (d_C__case_39 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_39 z cd
    cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_39 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_39" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_39" (showCons x1))

nd_C__case_39 :: Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_39 x1 s cd cs = case x1 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` Text.Curry_Pretty.nd_C_empty s0 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_39 l s cd cs)
    (nd_C__case_39 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_39 z s
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_39 e s cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_39" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_39" (showCons x1))

d_C__case_42 :: AbstractHaskell.Curry_Types.C_Visibility
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> C_Options
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C__case_42 x4 x3 x1 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (d_C_ppQName x1 x3 cd cs) cd cs)
    (Text.Curry_Pretty.d_C_text (Curry_Prelude.toCurryString "(..)") cd cs) cd
    cs
  Curry_Prelude.C_False -> d_C__case_41 (Curry_Prelude.d_C_otherwise cd cs) cd
    cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_42 x4 x3 x1 l cd
    cs) (d_C__case_42 x4 x3 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_42 x4
    x3 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_42 x4 x3
    x1 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_42" [show x4, show x3, show x1, show x5]
    info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_42" (showCons x5))

nd_C__case_42 :: AbstractHaskell.Curry_Types.C_Visibility
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> C_Options
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_42 x4 x3 x1 x5 s cd cs = case x5 of
  Curry_Prelude.C_True -> let s7 = s
    in s7 `seq` (let s6 = leftSupply s7
                     s8 = rightSupply s7
                     s3 = leftSupply s8
                     s5 = rightSupply s8
    in s6 `seq` (s8 `seq` (s3 `seq` (s5 `seq` Curry_Prelude.nd_C_apply
    (let s2 = leftSupply s3
         s4 = rightSupply s3
         s0 = leftSupply s4
         s1 = rightSupply s4
    in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s0 cd cs) (nd_C_ppQName x1 x3 s1 cd cs)
    s2 cd cs)))) (Text.Curry_Pretty.nd_C_text (Curry_Prelude.toCurryString
    "(..)") s5 cd cs) s6 cd cs))))
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_41 (Curry_Prelude.d_C_otherwise cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_42 x4 x3 x1 l s
    cd cs) (nd_C__case_42 x4 x3 x1 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_42 x4
    x3 x1 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_42 x4 x3
    x1 e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_42" [show x4, show x3, show x1, show x5]
    info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_42" (showCons x5))

d_C__case_41 :: Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C__case_41 x1 cd cs = case x1 of
  Curry_Prelude.C_True -> Text.Curry_Pretty.d_C_empty cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_41 l cd cs)
    (d_C__case_41 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_41 z cd
    cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_41 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_41" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_41" (showCons x1))

nd_C__case_41 :: Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_41 x1 s cd cs = case x1 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` Text.Curry_Pretty.nd_C_empty s0 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_41 l s cd cs)
    (nd_C__case_41 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_41 z s
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_41 e s cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_41" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_41" (showCons x1))

d_C__case_36 :: AbstractHaskell.Curry_Types.C_Visibility
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> C_Options
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C__case_36 x6 x4 x1 x7 cd cs = case x7 of
  Curry_Prelude.C_True -> d_C_ppPrefixQOp x1 x4 cd cs
  Curry_Prelude.C_False -> d_C__case_35 (Curry_Prelude.d_C_otherwise cd cs) cd
    cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_36 x6 x4 x1 l cd
    cs) (d_C__case_36 x6 x4 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_36 x6
    x4 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_36 x6 x4
    x1 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_36" [show x6, show x4, show x1, show x7]
    info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_36" (showCons x7))

nd_C__case_36 :: AbstractHaskell.Curry_Types.C_Visibility
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> C_Options
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_36 x6 x4 x1 x7 s cd cs = case x7 of
  Curry_Prelude.C_True -> let s0 = s in s0 `seq` nd_C_ppPrefixQOp x1 x4 s0 cd cs
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_35 (Curry_Prelude.d_C_otherwise cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_36 x6 x4 x1 l s
    cd cs) (nd_C__case_36 x6 x4 x1 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_36 x6
    x4 x1 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_36 x6 x4
    x1 e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_36" [show x6, show x4, show x1, show x7]
    info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_36" (showCons x7))

d_C__case_35 :: Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C__case_35 x1 cd cs = case x1 of
  Curry_Prelude.C_True -> Text.Curry_Pretty.d_C_empty cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_35 l cd cs)
    (d_C__case_35 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_35 z cd
    cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_35 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_35" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_35" (showCons x1))

nd_C__case_35 :: Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_35 x1 s cd cs = case x1 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` Text.Curry_Pretty.nd_C_empty s0 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_35 l s cd cs)
    (nd_C__case_35 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_35 z s
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_35 e s cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_35" [show x1] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_35" (showCons x1))

d_C__case_34 :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> C_Options
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C__case_34 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_dollar (d_C_indent cd cs)
    (Curry_Prelude.d_OP_dollar (Text.Curry_Pretty.d_C_fillSep cd cs)
    (Curry_Prelude.d_OP_dollar (Curry_Prelude.d_C_map
    Text.Curry_Pretty.d_C_text) (Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "import")
    (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "qualified")
    Curry_Prelude.OP_List)) (d_C__case_33 x1 x2 (d_C_traceFailure x1 cd cs) cd
    cs) cd cs) cd cs) cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_32 x2 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_34 x2 x1 l cd cs)
    (d_C__case_34 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_34 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_34 x2 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_34" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_34" (showCons x3))

nd_C__case_34 :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> C_Options
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_34 x2 x1 x3 s cd cs = case x3 of
  Curry_Prelude.C_True -> let s11 = s
    in s11 `seq` (let s10 = leftSupply s11
                      s12 = rightSupply s11
                      s0 = leftSupply s12
                      s8 = rightSupply s12
    in s10 `seq` (s12 `seq` (s0 `seq` (s8 `seq` Curry_Prelude.nd_OP_dollar
    (nd_C_indent s0 cd cs) (let s7 = leftSupply s8
                                s9 = rightSupply s8
                                s1 = leftSupply s9
                                s6 = rightSupply s9
    in s7 `seq` (s9 `seq` (s1 `seq` (s6 `seq` Curry_Prelude.nd_OP_dollar
    (Text.Curry_Pretty.nd_C_fillSep s1 cd cs) (let s5 = leftSupply s6
                                                   s4 = rightSupply s6
    in s5 `seq` (s4 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id
    (Curry_Prelude.nd_C_map (wrapNX id Text.Curry_Pretty.nd_C_text)))
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.OP_Cons
    (Curry_Prelude.toCurryString "import") (Curry_Prelude.OP_Cons
    (Curry_Prelude.toCurryString "qualified") Curry_Prelude.OP_List))
    (let s3 = leftSupply s4
         s2 = rightSupply s4
    in s3 `seq` (s2 `seq` nd_C__case_33 x1 x2 (nd_C_traceFailure x1 s2 cd cs) s3
    cd cs)) cd cs) s5 cd cs)) s7 cd cs)))) s10 cd cs))))
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_32 x2 (Curry_Prelude.d_C_otherwise cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_34 x2 x1 l s cd
    cs) (nd_C__case_34 x2 x1 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_34 x2
    x1 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_34 x2 x1
    e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_34" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_34" (showCons x3))

d_C__case_32 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C__case_32 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_dollar (d_C_indent cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (Text.Curry_Pretty.d_C_text
    (Curry_Prelude.toCurryString "import") cd cs) cd cs)
    (Text.Curry_Pretty.d_C_text x2 cd cs) cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_32 x2 l cd cs)
    (d_C__case_32 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_32 x2 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_32 x2 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_32" [show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_32" (showCons x3))

nd_C__case_32 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_32 x2 x3 s cd cs = case x3 of
  Curry_Prelude.C_True -> let s11 = s
    in s11 `seq` (let s10 = leftSupply s11
                      s12 = rightSupply s11
                      s0 = leftSupply s12
                      s8 = rightSupply s12
    in s10 `seq` (s12 `seq` (s0 `seq` (s8 `seq` Curry_Prelude.nd_OP_dollar
    (nd_C_indent s0 cd cs) (let s7 = leftSupply s8
                                s9 = rightSupply s8
                                s4 = leftSupply s9
                                s6 = rightSupply s9
    in s7 `seq` (s9 `seq` (s4 `seq` (s6 `seq` Curry_Prelude.nd_C_apply
    (let s3 = leftSupply s4
         s5 = rightSupply s4
         s1 = leftSupply s5
         s2 = rightSupply s5
    in s3 `seq` (s5 `seq` (s1 `seq` (s2 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s1 cd cs) (Text.Curry_Pretty.nd_C_text
    (Curry_Prelude.toCurryString "import") s2 cd cs) s3 cd cs))))
    (Text.Curry_Pretty.nd_C_text x2 s6 cd cs) s7 cd cs)))) s10 cd cs))))
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_32 x2 l s cd cs)
    (nd_C__case_32 x2 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_32 x2
    z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_32 x2 e s
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_32" [show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_32" (showCons x3))

d_C__case_33 :: C_Options -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_33 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply
    (d_C_addTrace cd cs) x2 cd cs) (Curry_Prelude.OP_Cons
    (Curry_Prelude.toCurryString "as") (Curry_Prelude.OP_Cons x2
    Curry_Prelude.OP_List))
  Curry_Prelude.C_False -> Curry_Prelude.OP_Cons x2 Curry_Prelude.OP_List
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_33 x1 x2 l cd cs)
    (d_C__case_33 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_33 x1
    x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_33 x1 x2 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_33" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_33" (showCons x3))

nd_C__case_33 :: C_Options -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
nd_C__case_33 x1 x2 x3 s cd cs = case x3 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` Curry_Prelude.OP_Cons (Curry_Prelude.nd_C_apply (wrapDX id
    (d_C_addTrace cd cs)) x2 s0 cd cs) (Curry_Prelude.OP_Cons
    (Curry_Prelude.toCurryString "as") (Curry_Prelude.OP_Cons x2
    Curry_Prelude.OP_List))
  Curry_Prelude.C_False -> Curry_Prelude.OP_Cons x2 Curry_Prelude.OP_List
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_33 x1 x2 l s cd
    cs) (nd_C__case_33 x1 x2 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_33 x1
    x2 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_33 x1 x2
    e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_33" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_33" (showCons x3))

d_C__case_31 :: Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_ConsDecl
  -> C_Options -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C__case_31 x14 x1 x13 x11 x15 cd cs = case x15 of
  Curry_Prelude.C_True -> Text.Curry_Pretty.d_C_empty cd cs
  Curry_Prelude.C_False -> d_C__case_30 x14 x1 x13 x11
    (Curry_Prelude.d_C_otherwise cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_31 x14 x1 x13 x11
    l cd cs) (d_C__case_31 x14 x1 x13 x11 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_31 x14
    x1 x13 x11 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_31 x14 x1
    x13 x11 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_31" [show x14, show x1, show x13, show x11
    , show x15] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_31" (showCons x15))

nd_C__case_31 :: Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_ConsDecl
  -> C_Options -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool
  -> IDSupply -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_31 x14 x1 x13 x11 x15 s cd cs = case x15 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` Text.Curry_Pretty.nd_C_empty s0 cd cs
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_30 x14 x1 x13 x11 (Curry_Prelude.d_C_otherwise cd cs)
    s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_31 x14 x1 x13
    x11 l s cd cs) (nd_C__case_31 x14 x1 x13 x11 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_31 x14
    x1 x13 x11 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_31 x14 x1
    x13 x11 e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_31" [show x14, show x1, show x13, show x11
    , show x15] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_31" (showCons x15))

d_C__case_30 :: Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_ConsDecl
  -> C_Options -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C__case_30 x14 x1 x13 x11 x15 cd cs = case x15 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_dollar (d_C_indent cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_dollar_dollar cd cs) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (Text.Curry_Pretty.d_C_text
    (Curry_Prelude.toCurryString "data") cd cs) cd cs) (d_C_ppName x11 cd cs) cd
    cs) cd cs) (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_C_fillSep cd cs)
    (Curry_Prelude.d_C_map d_C_ppTypeVar x13 cd cs) cd cs) cd cs) cd cs)
    (d_C_ppConsDecls x1 x14 cd cs) cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_30 x14 x1 x13 x11
    l cd cs) (d_C__case_30 x14 x1 x13 x11 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_30 x14
    x1 x13 x11 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_30 x14 x1
    x13 x11 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_30" [show x14, show x1, show x13, show x11
    , show x15] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_30" (showCons x15))

nd_C__case_30 :: Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_ConsDecl
  -> C_Options -> Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool
  -> IDSupply -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_30 x14 x1 x13 x11 x15 s cd cs = case x15 of
  Curry_Prelude.C_True -> let s31 = s
    in s31 `seq` (let s30 = leftSupply s31
                      s32 = rightSupply s31
                      s0 = leftSupply s32
                      s28 = rightSupply s32
    in s30 `seq` (s32 `seq` (s0 `seq` (s28 `seq` Curry_Prelude.nd_OP_dollar
    (nd_C_indent s0 cd cs) (let s27 = leftSupply s28
                                s29 = rightSupply s28
                                s24 = leftSupply s29
                                s26 = rightSupply s29
    in s27 `seq` (s29 `seq` (s24 `seq` (s26 `seq` Curry_Prelude.nd_C_apply
    (let s23 = leftSupply s24
         s25 = rightSupply s24
         s1 = leftSupply s25
         s21 = rightSupply s25
    in s23 `seq` (s25 `seq` (s1 `seq` (s21 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_dollar_dollar s1 cd cs) (let s20 = leftSupply s21
                                                          s22 = rightSupply s21
                                                          s13 = leftSupply s22
                                                          s18 = rightSupply s22
    in s20 `seq` (s22 `seq` (s13 `seq` (s18 `seq` Curry_Prelude.nd_C_apply
    (let s12 = leftSupply s13
         s14 = rightSupply s13
         s2 = leftSupply s14
         s10 = rightSupply s14
    in s12 `seq` (s14 `seq` (s2 `seq` (s10 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s2 cd cs) (let s9 = leftSupply s10
                                                       s11 = rightSupply s10
                                                       s6 = leftSupply s11
                                                       s8 = rightSupply s11
    in s9 `seq` (s11 `seq` (s6 `seq` (s8 `seq` Curry_Prelude.nd_C_apply
    (let s5 = leftSupply s6
         s7 = rightSupply s6
         s3 = leftSupply s7
         s4 = rightSupply s7
    in s5 `seq` (s7 `seq` (s3 `seq` (s4 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s3 cd cs) (Text.Curry_Pretty.nd_C_text
    (Curry_Prelude.toCurryString "data") s4 cd cs) s5 cd cs)))) (nd_C_ppName x11
    s8 cd cs) s9 cd cs)))) s12 cd cs)))) (let s17 = leftSupply s18
                                              s19 = rightSupply s18
                                              s15 = leftSupply s19
                                              s16 = rightSupply s19
    in s17 `seq` (s19 `seq` (s15 `seq` (s16 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_fillSep s15 cd cs) (Curry_Prelude.nd_C_map (wrapNX
    id nd_C_ppTypeVar) x13 s16 cd cs) s17 cd cs)))) s20 cd cs)))) s23 cd cs))))
    (nd_C_ppConsDecls x1 x14 s26 cd cs) s27 cd cs)))) s30 cd cs))))
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_30 x14 x1 x13
    x11 l s cd cs) (nd_C__case_30 x14 x1 x13 x11 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_30 x14
    x1 x13 x11 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_30 x14 x1
    x13 x11 e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_30" [show x14, show x1, show x13, show x11
    , show x15] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_30" (showCons x15))

d_C__case_29 :: forall t0 . (Curry_Prelude.Curry
  t0) => AbstractHaskell.Curry_Types.C_Rule -> C_Options
  -> Curry_Prelude.OP_Tuple2 t0 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C__case_29 x4 x1 x3 cd cs = case x3 of
  Curry_Prelude.OP_Tuple2 x5 x6 -> d_C_ppRule x1 x6 x4 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C__case_29 x4 x1 l cd
    cs) (d_C__case_29 x4 x1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C__case_29
    x4 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x -> d_C__case_29 x4
    x1 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_29" [show x4, show x1, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_29" (showCons x3))

nd_C__case_29 :: forall t0 . (Curry_Prelude.Curry
  t0) => AbstractHaskell.Curry_Types.C_Rule -> C_Options
  -> Curry_Prelude.OP_Tuple2 t0 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> IDSupply -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_29 x4 x1 x3 s cd cs = case x3 of
  Curry_Prelude.OP_Tuple2 x5 x6 -> let s0 = s
    in s0 `seq` nd_C_ppRule x1 x6 x4 s0 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (nd_C__case_29 x4 x1 l s
    cd cs) (nd_C__case_29 x4 x1 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> nd_C__case_29
    x4 x1 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x -> nd_C__case_29 x4
    x1 e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_29" [show x4, show x1, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_29" (showCons x3))

d_C__case_28 :: Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_TypeExpr
  -> C_Options -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C__case_28 x6 x1 x3 cd cs = case x3 of
  Curry_Prelude.OP_Tuple2 x7 x8 -> Curry_Prelude.d_OP_dollar (d_C_indent cd cs)
    (Curry_Prelude.d_OP_dollar (Text.Curry_Pretty.d_C_fillSep cd cs)
    (Curry_Prelude.OP_Cons (d_C_ppPrefixOp x8 cd cs) (Curry_Prelude.d_C_map
    (d_C_ppTypeExpr x1 (Curry_Prelude.C_Int (2))) x6 cd cs)) cd cs) cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C__case_28 x6 x1 l cd
    cs) (d_C__case_28 x6 x1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C__case_28
    x6 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x -> d_C__case_28 x6
    x1 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_28" [show x6, show x1, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_28" (showCons x3))

nd_C__case_28 :: Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_TypeExpr
  -> C_Options -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply
  -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_28 x6 x1 x3 s cd cs = case x3 of
  Curry_Prelude.OP_Tuple2 x7 x8 -> let s9 = s
    in s9 `seq` (let s8 = leftSupply s9
                     s10 = rightSupply s9
                     s0 = leftSupply s10
                     s6 = rightSupply s10
    in s8 `seq` (s10 `seq` (s0 `seq` (s6 `seq` Curry_Prelude.nd_OP_dollar
    (nd_C_indent s0 cd cs) (let s5 = leftSupply s6
                                s7 = rightSupply s6
                                s1 = leftSupply s7
                                s4 = rightSupply s7
    in s5 `seq` (s7 `seq` (s1 `seq` (s4 `seq` Curry_Prelude.nd_OP_dollar
    (Text.Curry_Pretty.nd_C_fillSep s1 cd cs) (let s2 = leftSupply s4
                                                   s3 = rightSupply s4
    in s2 `seq` (s3 `seq` Curry_Prelude.OP_Cons (nd_C_ppPrefixOp x8 s2 cd cs)
    (Curry_Prelude.nd_C_map (wrapNX id (nd_C_ppTypeExpr x1 (Curry_Prelude.C_Int
    (2)))) x6 s3 cd cs))) s5 cd cs)))) s8 cd cs))))
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (nd_C__case_28 x6 x1 l s
    cd cs) (nd_C__case_28 x6 x1 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> nd_C__case_28
    x6 x1 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x -> nd_C__case_28 x6
    x1 e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_28" [show x6, show x1, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_28" (showCons x3))

d_C__case_27 :: AbstractHaskell.Curry_Types.C_TypeExpr -> C_Options
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C__case_27 x5 x1 x3 cd cs = case x3 of
  Curry_Prelude.OP_Tuple2 x6 x7 -> Curry_Prelude.d_OP_dollar (d_C_indent cd cs)
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_C_fillSep cd cs)
    (Curry_Prelude.OP_Cons (d_C_ppPrefixOp x7 cd cs) (Curry_Prelude.OP_Cons
    (d_C_ppTypeExpr x1 (Curry_Prelude.C_Int (2)) x5 cd cs)
    Curry_Prelude.OP_List)) cd cs) cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C__case_27 x5 x1 l cd
    cs) (d_C__case_27 x5 x1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C__case_27
    x5 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x -> d_C__case_27 x5
    x1 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_27" [show x5, show x1, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_27" (showCons x3))

nd_C__case_27 :: AbstractHaskell.Curry_Types.C_TypeExpr -> C_Options
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_27 x5 x1 x3 s cd cs = case x3 of
  Curry_Prelude.OP_Tuple2 x6 x7 -> let s9 = s
    in s9 `seq` (let s8 = leftSupply s9
                     s10 = rightSupply s9
                     s0 = leftSupply s10
                     s6 = rightSupply s10
    in s8 `seq` (s10 `seq` (s0 `seq` (s6 `seq` Curry_Prelude.nd_OP_dollar
    (nd_C_indent s0 cd cs) (let s5 = leftSupply s6
                                s7 = rightSupply s6
                                s1 = leftSupply s7
                                s4 = rightSupply s7
    in s5 `seq` (s7 `seq` (s1 `seq` (s4 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_fillSep s1 cd cs) (let s2 = leftSupply s4
                                                   s3 = rightSupply s4
    in s2 `seq` (s3 `seq` Curry_Prelude.OP_Cons (nd_C_ppPrefixOp x7 s2 cd cs)
    (Curry_Prelude.OP_Cons (nd_C_ppTypeExpr x1 (Curry_Prelude.C_Int (2)) x5 s3
    cd cs) Curry_Prelude.OP_List))) s5 cd cs)))) s8 cd cs))))
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (nd_C__case_27 x5 x1 l s
    cd cs) (nd_C__case_27 x5 x1 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> nd_C__case_27
    x5 x1 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x -> nd_C__case_27 x5
    x1 e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_27" [show x5, show x1, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_27" (showCons x3))

d_C__case_26 :: Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_Context
  -> C_Options -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C__case_26 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Text.Curry_Pretty.d_C_empty cd cs
  Curry_Prelude.C_False -> d_C__case_25 x2 x1 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_26 x2 x1 l cd cs)
    (d_C__case_26 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_26 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_26 x2 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_26" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_26" (showCons x3))

nd_C__case_26 :: Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_Context
  -> C_Options -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_26 x2 x1 x3 s cd cs = case x3 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` Text.Curry_Pretty.nd_C_empty s0 cd cs
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_25 x2 x1 (Curry_Prelude.d_C_otherwise cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_26 x2 x1 l s cd
    cs) (nd_C__case_26 x2 x1 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_26 x2
    x1 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_26 x2 x1
    e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_26" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_26" (showCons x3))

d_C__case_25 :: Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_Context
  -> C_Options -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C__case_25 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (Curry_Prelude.d_C_apply
    (d_C_tupled cd cs) (Curry_Prelude.d_C_map (d_C_ppContext x1) x2 cd cs) cd
    cs) cd cs) (Text.Curry_Pretty.d_C_doubleArrow cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_25 x2 x1 l cd cs)
    (d_C__case_25 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_25 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_25 x2 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_25" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_25" (showCons x3))

nd_C__case_25 :: Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_Context
  -> C_Options -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_25 x2 x1 x3 s cd cs = case x3 of
  Curry_Prelude.C_True -> let s11 = s
    in s11 `seq` (let s10 = leftSupply s11
                      s12 = rightSupply s11
                      s7 = leftSupply s12
                      s9 = rightSupply s12
    in s10 `seq` (s12 `seq` (s7 `seq` (s9 `seq` Curry_Prelude.nd_C_apply
    (let s6 = leftSupply s7
         s8 = rightSupply s7
         s0 = leftSupply s8
         s4 = rightSupply s8
    in s6 `seq` (s8 `seq` (s0 `seq` (s4 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s0 cd cs) (let s3 = leftSupply s4
                                                       s5 = rightSupply s4
                                                       s1 = leftSupply s5
                                                       s2 = rightSupply s5
    in s3 `seq` (s5 `seq` (s1 `seq` (s2 `seq` Curry_Prelude.nd_C_apply
    (nd_C_tupled s1 cd cs) (Curry_Prelude.nd_C_map (wrapNX id (nd_C_ppContext
    x1)) x2 s2 cd cs) s3 cd cs)))) s6 cd cs))))
    (Text.Curry_Pretty.nd_C_doubleArrow s9 cd cs) s10 cd cs))))
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_25 x2 x1 l s cd
    cs) (nd_C__case_25 x2 x1 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_25 x2
    x1 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_25 x2 x1
    e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_25" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_25" (showCons x3))

d_C__case_24 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C__case_24 x3 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> Text.Curry_Pretty.d_C_empty cd cs
  Curry_Prelude.C_False -> d_C__case_23 x3 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_24 x3 l cd cs)
    (d_C__case_24 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_24 x3 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_24 x3 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_24" [show x3, show x4] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_24" (showCons x4))

nd_C__case_24 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_24 x3 x4 s cd cs = case x4 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` Text.Curry_Pretty.nd_C_empty s0 cd cs
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_23 x3 (Curry_Prelude.d_C_otherwise cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_24 x3 l s cd cs)
    (nd_C__case_24 x3 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_24 x3
    z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_24 x3 e s
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_24" [show x3, show x4] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_24" (showCons x4))

d_C__case_23 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C__case_23 x3 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs)
    (Text.Curry_Pretty.d_C_text (Curry_Prelude.toCurryString "forall") cd cs) cd
    cs) (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_C_fillSep cd cs)
    (Curry_Prelude.d_C_map d_C_ppTypeVar x3 cd cs) cd cs) cd cs) cd cs)
    (Text.Curry_Pretty.d_C_dot cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_23 x3 l cd cs)
    (d_C__case_23 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_23 x3 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_23 x3 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_23" [show x3, show x4] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_23" (showCons x4))

nd_C__case_23 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_23 x3 x4 s cd cs = case x4 of
  Curry_Prelude.C_True -> let s19 = s
    in s19 `seq` (let s18 = leftSupply s19
                      s20 = rightSupply s19
                      s15 = leftSupply s20
                      s17 = rightSupply s20
    in s18 `seq` (s20 `seq` (s15 `seq` (s17 `seq` Curry_Prelude.nd_C_apply
    (let s14 = leftSupply s15
         s16 = rightSupply s15
         s0 = leftSupply s16
         s12 = rightSupply s16
    in s14 `seq` (s16 `seq` (s0 `seq` (s12 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s0 cd cs) (let s11 = leftSupply s12
                                                       s13 = rightSupply s12
                                                       s4 = leftSupply s13
                                                       s9 = rightSupply s13
    in s11 `seq` (s13 `seq` (s4 `seq` (s9 `seq` Curry_Prelude.nd_C_apply
    (let s3 = leftSupply s4
         s5 = rightSupply s4
         s1 = leftSupply s5
         s2 = rightSupply s5
    in s3 `seq` (s5 `seq` (s1 `seq` (s2 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s1 cd cs) (Text.Curry_Pretty.nd_C_text
    (Curry_Prelude.toCurryString "forall") s2 cd cs) s3 cd cs))))
    (let s8 = leftSupply s9
         s10 = rightSupply s9
         s6 = leftSupply s10
         s7 = rightSupply s10
    in s8 `seq` (s10 `seq` (s6 `seq` (s7 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_fillSep s6 cd cs) (Curry_Prelude.nd_C_map (wrapNX id
    nd_C_ppTypeVar) x3 s7 cd cs) s8 cd cs)))) s11 cd cs)))) s14 cd cs))))
    (Text.Curry_Pretty.nd_C_dot s17 cd cs) s18 cd cs))))
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_23 x3 l s cd cs)
    (nd_C__case_23 x3 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_23 x3
    z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_23 x3 e s
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_23" [show x3, show x4] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_23" (showCons x4))

d_C__case_22 :: Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_TypeExpr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> C_Options
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C__case_22 x8 x7 x1 x2 x9 cd cs = case x9 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_C_brackets cd cs) (Curry_Prelude.d_C_apply
    (d_C_ppTypeExp x1 cd cs) (Curry_Prelude.d_C_head x8 cd cs) cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_21 x7 x8 x1 x2 (d_C_isTuple x7 cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_22 x8 x7 x1 x2 l
    cd cs) (d_C__case_22 x8 x7 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_22 x8
    x7 x1 x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_22 x8 x7
    x1 x2 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_22" [show x8, show x7, show x1, show x2, show
    x9] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_22" (showCons x9))

nd_C__case_22 :: Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_TypeExpr
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> C_Options
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_22 x8 x7 x1 x2 x9 s cd cs = case x9 of
  Curry_Prelude.C_True -> let s5 = s
    in s5 `seq` (let s4 = leftSupply s5
                     s6 = rightSupply s5
                     s0 = leftSupply s6
                     s3 = rightSupply s6
    in s4 `seq` (s6 `seq` (s0 `seq` (s3 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_brackets s0 cd cs) (let s2 = leftSupply s3
                                                    s1 = rightSupply s3
    in s2 `seq` (s1 `seq` Curry_Prelude.nd_C_apply (nd_C_ppTypeExp x1 s1 cd cs)
    (Curry_Prelude.d_C_head x8 cd cs) s2 cd cs)) s4 cd cs))))
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_21 x7 x8 x1 x2 (d_C_isTuple x7 cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_22 x8 x7 x1 x2 l
    s cd cs) (nd_C__case_22 x8 x7 x1 x2 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_22 x8
    x7 x1 x2 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_22 x8 x7
    x1 x2 e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_22" [show x8, show x7, show x1, show x2, show
    x9] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_22" (showCons x9))

d_C__case_21 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_TypeExpr -> C_Options
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C__case_21 x7 x8 x1 x2 x9 cd cs = case x9 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (d_C_tupled cd cs)
    (Curry_Prelude.d_C_map (d_C_ppTypeExp x1 cd cs) x8 cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_20 x8 x1 x7 x2 (Curry_Prelude.d_C_otherwise
    cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_21 x7 x8 x1 x2 l
    cd cs) (d_C__case_21 x7 x8 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_21 x7
    x8 x1 x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_21 x7 x8
    x1 x2 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_21" [show x7, show x8, show x1, show x2, show
    x9] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_21" (showCons x9))

nd_C__case_21 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_TypeExpr -> C_Options
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_21 x7 x8 x1 x2 x9 s cd cs = case x9 of
  Curry_Prelude.C_True -> let s5 = s
    in s5 `seq` (let s4 = leftSupply s5
                     s6 = rightSupply s5
                     s0 = leftSupply s6
                     s3 = rightSupply s6
    in s4 `seq` (s6 `seq` (s0 `seq` (s3 `seq` Curry_Prelude.nd_C_apply
    (nd_C_tupled s0 cd cs) (let s2 = leftSupply s3
                                s1 = rightSupply s3
    in s2 `seq` (s1 `seq` Curry_Prelude.nd_C_map (nd_C_ppTypeExp x1 s1 cd cs) x8
    s2 cd cs)) s4 cd cs))))
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_20 x8 x1 x7 x2 (Curry_Prelude.d_C_otherwise cd cs) s0
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_21 x7 x8 x1 x2 l
    s cd cs) (nd_C__case_21 x7 x8 x1 x2 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_21 x7
    x8 x1 x2 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_21 x7 x8
    x1 x2 e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_21" [show x7, show x8, show x1, show x2, show
    x9] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_21" (showCons x9))

d_C__case_20 :: Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_TypeExpr
  -> C_Options -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C__case_20 x8 x1 x7 x2 x9 cd cs = case x9 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_dollar (d_C_parensIf
    (Curry_Prelude.d_OP_amp_amp (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
    cd cs) x2 cd cs) (Curry_Prelude.C_Int (1)) cd cs) (Curry_Prelude.d_C_not
    (Curry_Prelude.d_C_null x8 cd cs) cd cs) cd cs)) (Curry_Prelude.d_OP_dollar
    (Text.Curry_Pretty.d_C_fillSep cd cs) (Curry_Prelude.OP_Cons (d_C_ppQName x1
    x7 cd cs) (Curry_Prelude.d_C_map (d_C_ppTypeExpr x1 (Curry_Prelude.C_Int
    (2))) x8 cd cs)) cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_20 x8 x1 x7 x2 l
    cd cs) (d_C__case_20 x8 x1 x7 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_20 x8
    x1 x7 x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_20 x8 x1
    x7 x2 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_20" [show x8, show x1, show x7, show x2, show
    x9] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_20" (showCons x9))

nd_C__case_20 :: Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_TypeExpr
  -> C_Options -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Int -> Curry_Prelude.C_Bool -> IDSupply -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_20 x8 x1 x7 x2 x9 s cd cs = case x9 of
  Curry_Prelude.C_True -> let s11 = s
    in s11 `seq` (let s10 = leftSupply s11
                      s12 = rightSupply s11
                      s2 = leftSupply s12
                      s8 = rightSupply s12
    in s10 `seq` (s12 `seq` (s2 `seq` (s8 `seq` Curry_Prelude.nd_OP_dollar
    (wrapNX id (nd_C_parensIf (Curry_Prelude.d_OP_amp_amp (let s1 = leftSupply
                                                                 s2
                                                               s0 = rightSupply
                                                                 s2
    in s1 `seq` (s0 `seq` Curry_Prelude.nd_C_apply (Curry_Prelude.nd_C_apply
    (wrapDX (wrapDX id)
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
    cd cs)) x2 s0 cd cs) (Curry_Prelude.C_Int (1)) s1 cd cs))
    (Curry_Prelude.d_C_not (Curry_Prelude.d_C_null x8 cd cs) cd cs) cd cs)))
    (let s7 = leftSupply s8
         s9 = rightSupply s8
         s3 = leftSupply s9
         s6 = rightSupply s9
    in s7 `seq` (s9 `seq` (s3 `seq` (s6 `seq` Curry_Prelude.nd_OP_dollar
    (Text.Curry_Pretty.nd_C_fillSep s3 cd cs) (let s4 = leftSupply s6
                                                   s5 = rightSupply s6
    in s4 `seq` (s5 `seq` Curry_Prelude.OP_Cons (nd_C_ppQName x1 x7 s4 cd cs)
    (Curry_Prelude.nd_C_map (wrapNX id (nd_C_ppTypeExpr x1 (Curry_Prelude.C_Int
    (2)))) x8 s5 cd cs))) s7 cd cs)))) s10 cd cs))))
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_20 x8 x1 x7 x2 l
    s cd cs) (nd_C__case_20 x8 x1 x7 x2 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_20 x8
    x1 x7 x2 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_20 x8 x1
    x7 x2 e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_20" [show x8, show x1, show x7, show x2, show
    x9] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_20" (showCons x9))

d_C__case_19 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> C_Options -> AbstractHaskell.Curry_Types.C_TypeSig -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> AbstractHaskell.Curry_Types.C_Rules -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C__case_19 x4 x1 x7 x3 x8 cd cs = case x8 of
  AbstractHaskell.Curry_Types.C_Rules x9 -> d_C__case_18 x9 x1 x7 x3 x4 cd cs
  AbstractHaskell.Curry_Types.C_External -> Text.Curry_Pretty.d_C_empty cd cs
  AbstractHaskell.Curry_Types.Choice_C_Rules d i l r -> narrow d i (d_C__case_19
    x4 x1 x7 x3 l cd cs) (d_C__case_19 x4 x1 x7 x3 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Rules d i xs -> narrows cs d i (\z ->
    d_C__case_19 x4 x1 x7 x3 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Rules d c e -> guardCons d c ((\x ->
    d_C__case_19 x4 x1 x7 x3 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Rules d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_19" [show x4, show x1, show x7, show x3, show
    x8] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_19" (showCons x8))

nd_C__case_19 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> C_Options -> AbstractHaskell.Curry_Types.C_TypeSig -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> AbstractHaskell.Curry_Types.C_Rules -> IDSupply
  -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_19 x4 x1 x7 x3 x8 s cd cs = case x8 of
  AbstractHaskell.Curry_Types.C_Rules x9 -> let s0 = s
    in s0 `seq` nd_C__case_18 x9 x1 x7 x3 x4 s0 cd cs
  AbstractHaskell.Curry_Types.C_External -> let s0 = s
    in s0 `seq` Text.Curry_Pretty.nd_C_empty s0 cd cs
  AbstractHaskell.Curry_Types.Choice_C_Rules d i l r -> narrow d i
    (nd_C__case_19 x4 x1 x7 x3 l s cd cs) (nd_C__case_19 x4 x1 x7 x3 r s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Rules d i xs -> narrows cs d i (\z ->
    nd_C__case_19 x4 x1 x7 x3 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Rules d c e -> guardCons d c ((\x ->
    nd_C__case_19 x4 x1 x7 x3 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Rules d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_19" [show x4, show x1, show x7, show x3, show
    x8] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_19" (showCons x8))

d_C__case_18 :: Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_Rule
  -> C_Options -> AbstractHaskell.Curry_Types.C_TypeSig -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C__case_18 x9 x1 x7 x3 x4 cd cs = case x4 of
  Curry_Prelude.OP_Tuple2 x10 x11 -> Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_OP_dollar_dollar cd cs)
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_dollar_dollar cd cs) (Curry_Prelude.d_C_apply
    (d_C_ppComment cd cs) x3 cd cs) cd cs) (Curry_Prelude.d_C_apply (d_C_indent
    cd cs) (d_C_ppTypeSig x1 x11 x7 cd cs) cd cs) cd cs) cd cs)
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_C_vsep cd cs)
    (Curry_Prelude.d_C_map (d_C_ppRule x1 x11) x9 cd cs) cd cs) cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C__case_18 x9 x1 x7 x3
    l cd cs) (d_C__case_18 x9 x1 x7 x3 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C__case_18
    x9 x1 x7 x3 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x -> d_C__case_18 x9
    x1 x7 x3 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_18" [show x9, show x1, show x7, show x3, show
    x4] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_18" (showCons x4))

nd_C__case_18 :: Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_Rule
  -> C_Options -> AbstractHaskell.Curry_Types.C_TypeSig -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> IDSupply
  -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_18 x9 x1 x7 x3 x4 s cd cs = case x4 of
  Curry_Prelude.OP_Tuple2 x10 x11 -> let s25 = s
    in s25 `seq` (let s24 = leftSupply s25
                      s26 = rightSupply s25
                      s17 = leftSupply s26
                      s22 = rightSupply s26
    in s24 `seq` (s26 `seq` (s17 `seq` (s22 `seq` Curry_Prelude.nd_C_apply
    (let s16 = leftSupply s17
         s18 = rightSupply s17
         s0 = leftSupply s18
         s14 = rightSupply s18
    in s16 `seq` (s18 `seq` (s0 `seq` (s14 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_dollar_dollar s0 cd cs) (let s13 = leftSupply s14
                                                          s15 = rightSupply s14
                                                          s6 = leftSupply s15
                                                          s11 = rightSupply s15
    in s13 `seq` (s15 `seq` (s6 `seq` (s11 `seq` Curry_Prelude.nd_C_apply
    (let s5 = leftSupply s6
         s7 = rightSupply s6
         s1 = leftSupply s7
         s4 = rightSupply s7
    in s5 `seq` (s7 `seq` (s1 `seq` (s4 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_dollar_dollar s1 cd cs) (let s3 = leftSupply s4
                                                          s2 = rightSupply s4
    in s3 `seq` (s2 `seq` Curry_Prelude.nd_C_apply (nd_C_ppComment s2 cd cs) x3
    s3 cd cs)) s5 cd cs)))) (let s10 = leftSupply s11
                                 s12 = rightSupply s11
                                 s8 = leftSupply s12
                                 s9 = rightSupply s12
    in s10 `seq` (s12 `seq` (s8 `seq` (s9 `seq` Curry_Prelude.nd_C_apply
    (nd_C_indent s8 cd cs) (nd_C_ppTypeSig x1 x11 x7 s9 cd cs) s10 cd cs)))) s13
    cd cs)))) s16 cd cs)))) (let s21 = leftSupply s22
                                 s23 = rightSupply s22
                                 s19 = leftSupply s23
                                 s20 = rightSupply s23
    in s21 `seq` (s23 `seq` (s19 `seq` (s20 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_vsep s19 cd cs) (Curry_Prelude.nd_C_map (wrapNX id
    (nd_C_ppRule x1 x11)) x9 s20 cd cs) s21 cd cs)))) s24 cd cs))))
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (nd_C__case_18 x9 x1 x7
    x3 l s cd cs) (nd_C__case_18 x9 x1 x7 x3 r s cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> nd_C__case_18
    x9 x1 x7 x3 z s cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x -> nd_C__case_18 x9
    x1 x7 x3 e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_18" [show x9, show x1, show x7, show x3, show
    x4] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_18" (showCons x4))

d_C__case_17 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C__case_17 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Text.Curry_Pretty.d_C_empty cd cs
  Curry_Prelude.C_False -> d_C__case_16 x2 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_17 x2 l cd cs)
    (d_C__case_17 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_17 x2 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_17 x2 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_17" [show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_17" (showCons x3))

nd_C__case_17 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_17 x2 x3 s cd cs = case x3 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` Text.Curry_Pretty.nd_C_empty s0 cd cs
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_16 x2 (Curry_Prelude.d_C_otherwise cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_17 x2 l s cd cs)
    (nd_C__case_17 x2 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_17 x2
    z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_17 x2 e s
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_17" [show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_17" (showCons x3))

d_C__case_16 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C__case_16 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs)
    (Text.Curry_Pretty.d_C_text (Curry_Prelude.toCurryString "forall") cd cs) cd
    cs) (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_C_fillSep cd cs)
    (Curry_Prelude.d_C_map d_C_ppTypeVar x2 cd cs) cd cs) cd cs) cd cs)
    (Text.Curry_Pretty.d_C_dot cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_16 x2 l cd cs)
    (d_C__case_16 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_16 x2 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_16 x2 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_16" [show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_16" (showCons x3))

nd_C__case_16 :: Curry_Prelude.OP_List (Curry_Prelude.OP_Tuple2
  Curry_Prelude.C_Int (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_16 x2 x3 s cd cs = case x3 of
  Curry_Prelude.C_True -> let s19 = s
    in s19 `seq` (let s18 = leftSupply s19
                      s20 = rightSupply s19
                      s15 = leftSupply s20
                      s17 = rightSupply s20
    in s18 `seq` (s20 `seq` (s15 `seq` (s17 `seq` Curry_Prelude.nd_C_apply
    (let s14 = leftSupply s15
         s16 = rightSupply s15
         s0 = leftSupply s16
         s12 = rightSupply s16
    in s14 `seq` (s16 `seq` (s0 `seq` (s12 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s0 cd cs) (let s11 = leftSupply s12
                                                       s13 = rightSupply s12
                                                       s4 = leftSupply s13
                                                       s9 = rightSupply s13
    in s11 `seq` (s13 `seq` (s4 `seq` (s9 `seq` Curry_Prelude.nd_C_apply
    (let s3 = leftSupply s4
         s5 = rightSupply s4
         s1 = leftSupply s5
         s2 = rightSupply s5
    in s3 `seq` (s5 `seq` (s1 `seq` (s2 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s1 cd cs) (Text.Curry_Pretty.nd_C_text
    (Curry_Prelude.toCurryString "forall") s2 cd cs) s3 cd cs))))
    (let s8 = leftSupply s9
         s10 = rightSupply s9
         s6 = leftSupply s10
         s7 = rightSupply s10
    in s8 `seq` (s10 `seq` (s6 `seq` (s7 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_fillSep s6 cd cs) (Curry_Prelude.nd_C_map (wrapNX id
    nd_C_ppTypeVar) x2 s7 cd cs) s8 cd cs)))) s11 cd cs)))) s14 cd cs))))
    (Text.Curry_Pretty.nd_C_dot s17 cd cs) s18 cd cs))))
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_16 x2 l s cd cs)
    (nd_C__case_16 x2 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_16 x2
    z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_16 x2 e s
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_16" [show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_16" (showCons x3))

d_C__case_15 :: Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_LocalDecl
  -> C_Options -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C__case_15 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Text.Curry_Pretty.d_C_empty cd cs
  Curry_Prelude.C_False -> d_C__case_14 x2 x1 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_15 x2 x1 l cd cs)
    (d_C__case_15 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_15 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_15 x2 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_15" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_15" (showCons x3))

nd_C__case_15 :: Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_LocalDecl
  -> C_Options -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_15 x2 x1 x3 s cd cs = case x3 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` Text.Curry_Pretty.nd_C_empty s0 cd cs
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_14 x2 x1 (Curry_Prelude.d_C_otherwise cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_15 x2 x1 l s cd
    cs) (nd_C__case_15 x2 x1 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_15 x2
    x1 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_15 x2 x1
    e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_15" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_15" (showCons x3))

d_C__case_14 :: Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_LocalDecl
  -> C_Options -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C__case_14 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_OP_dollar_dollar cd cs) (Text.Curry_Pretty.d_C_text
    (Curry_Prelude.toCurryString "where") cd cs) cd cs) (d_C_ppBlock x1 x2 cd
    cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_14 x2 x1 l cd cs)
    (d_C__case_14 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_14 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_14 x2 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_14" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_14" (showCons x3))

nd_C__case_14 :: Curry_Prelude.OP_List AbstractHaskell.Curry_Types.C_LocalDecl
  -> C_Options -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_14 x2 x1 x3 s cd cs = case x3 of
  Curry_Prelude.C_True -> let s7 = s
    in s7 `seq` (let s6 = leftSupply s7
                     s8 = rightSupply s7
                     s3 = leftSupply s8
                     s5 = rightSupply s8
    in s6 `seq` (s8 `seq` (s3 `seq` (s5 `seq` Curry_Prelude.nd_C_apply
    (let s2 = leftSupply s3
         s4 = rightSupply s3
         s0 = leftSupply s4
         s1 = rightSupply s4
    in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_dollar_dollar s0 cd cs)
    (Text.Curry_Pretty.nd_C_text (Curry_Prelude.toCurryString "where") s1 cd cs)
    s2 cd cs)))) (nd_C_ppBlock x1 x2 s5 cd cs) s6 cd cs))))
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_14 x2 x1 l s cd
    cs) (nd_C__case_14 x2 x1 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_14 x2
    x1 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_14 x2 x1
    e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_14" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_14" (showCons x3))

d_C__case_13 :: C_Options -> AbstractHaskell.Curry_Types.C_Literal
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C__case_13 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> d_C__case_12 x1 x2 cd cs
  Curry_Prelude.C_False -> d_C__case_11 x2 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_13 x1 x2 l cd cs)
    (d_C__case_13 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_13 x1
    x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_13 x1 x2 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_13" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_13" (showCons x3))

nd_C__case_13 :: C_Options -> AbstractHaskell.Curry_Types.C_Literal
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_13 x1 x2 x3 s cd cs = case x3 of
  Curry_Prelude.C_True -> let s0 = s in s0 `seq` nd_C__case_12 x1 x2 s0 cd cs
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_11 x2 (Curry_Prelude.d_C_otherwise cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_13 x1 x2 l s cd
    cs) (nd_C__case_13 x1 x2 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_13 x1
    x2 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_13 x1 x2
    e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_13" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_13" (showCons x3))

d_C__case_11 :: AbstractHaskell.Curry_Types.C_Literal -> Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C__case_11 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> d_C_ppLiteral x2 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_11 x2 l cd cs)
    (d_C__case_11 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_11 x2 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_11 x2 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_11" [show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_11" (showCons x3))

nd_C__case_11 :: AbstractHaskell.Curry_Types.C_Literal -> Curry_Prelude.C_Bool
  -> IDSupply -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_11 x2 x3 s cd cs = case x3 of
  Curry_Prelude.C_True -> let s0 = s in s0 `seq` nd_C_ppLiteral x2 s0 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_11 x2 l s cd cs)
    (nd_C__case_11 x2 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_11 x2
    z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_11 x2 e s
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_11" [show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_11" (showCons x3))

d_C__case_12 :: C_Options -> AbstractHaskell.Curry_Types.C_Literal -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C__case_12 x1 x2 cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Charc x3 -> d_OP_ppLitPattern_dot_wrapUnboxed_dot_210
    x1 x2 (Curry_Prelude.OP_Tuple2 (d_C_curryPrelude cd cs)
    (Curry_Prelude.toCurryString "C_Char")) cd cs
  AbstractHaskell.Curry_Types.C_Floatc x4 -> d_OP_ppLitPattern_dot_wrapUnboxed_dot_210
    x1 x2 (Curry_Prelude.OP_Tuple2 (d_C_curryPrelude cd cs)
    (Curry_Prelude.toCurryString "C_Float")) cd cs
  AbstractHaskell.Curry_Types.C_Intc x5 -> Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_C_parens cd cs) (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_OP_lt_plus_gt cd cs)
    (d_C_ppQName x1 (Curry_Prelude.OP_Tuple2 (d_C_curryPrelude cd cs)
    (Curry_Prelude.toCurryString "C_Int")) cd cs) cd cs)
    (Curry_Prelude.d_C_apply (Text.Curry_Pretty.d_C_parens cd cs) (d_C_ppLiteral
    x2 cd cs) cd cs) cd cs) cd cs
  AbstractHaskell.Curry_Types.C_Stringc x6 -> d_C_ppLiteral x2 cd cs
  AbstractHaskell.Curry_Types.Choice_C_Literal d i l r -> narrow d i
    (d_C__case_12 x1 l cd cs) (d_C__case_12 x1 r cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Literal d i xs -> narrows cs d i (\z ->
    d_C__case_12 x1 z cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Literal d c e -> guardCons d c ((\x ->
    d_C__case_12 x1 e cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Literal d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_12" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_12" (showCons x2))

nd_C__case_12 :: C_Options -> AbstractHaskell.Curry_Types.C_Literal -> IDSupply
  -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_12 x1 x2 s cd cs = case x2 of
  AbstractHaskell.Curry_Types.C_Charc x3 -> let s0 = s
    in s0 `seq` nd_OP_ppLitPattern_dot_wrapUnboxed_dot_210 x1 x2
    (Curry_Prelude.OP_Tuple2 (d_C_curryPrelude cd cs)
    (Curry_Prelude.toCurryString "C_Char")) s0 cd cs
  AbstractHaskell.Curry_Types.C_Floatc x4 -> let s0 = s
    in s0 `seq` nd_OP_ppLitPattern_dot_wrapUnboxed_dot_210 x1 x2
    (Curry_Prelude.OP_Tuple2 (d_C_curryPrelude cd cs)
    (Curry_Prelude.toCurryString "C_Float")) s0 cd cs
  AbstractHaskell.Curry_Types.C_Intc x5 -> let s15 = s
    in s15 `seq` (let s14 = leftSupply s15
                      s16 = rightSupply s15
                      s0 = leftSupply s16
                      s12 = rightSupply s16
    in s14 `seq` (s16 `seq` (s0 `seq` (s12 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_parens s0 cd cs) (let s11 = leftSupply s12
                                                  s13 = rightSupply s12
                                                  s4 = leftSupply s13
                                                  s9 = rightSupply s13
    in s11 `seq` (s13 `seq` (s4 `seq` (s9 `seq` Curry_Prelude.nd_C_apply
    (let s3 = leftSupply s4
         s5 = rightSupply s4
         s1 = leftSupply s5
         s2 = rightSupply s5
    in s3 `seq` (s5 `seq` (s1 `seq` (s2 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_OP_lt_plus_gt s1 cd cs) (nd_C_ppQName x1
    (Curry_Prelude.OP_Tuple2 (d_C_curryPrelude cd cs)
    (Curry_Prelude.toCurryString "C_Int")) s2 cd cs) s3 cd cs))))
    (let s8 = leftSupply s9
         s10 = rightSupply s9
         s6 = leftSupply s10
         s7 = rightSupply s10
    in s8 `seq` (s10 `seq` (s6 `seq` (s7 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_parens s6 cd cs) (nd_C_ppLiteral x2 s7 cd cs) s8 cd
    cs)))) s11 cd cs)))) s14 cd cs))))
  AbstractHaskell.Curry_Types.C_Stringc x6 -> let s0 = s
    in s0 `seq` nd_C_ppLiteral x2 s0 cd cs
  AbstractHaskell.Curry_Types.Choice_C_Literal d i l r -> narrow d i
    (nd_C__case_12 x1 l s cd cs) (nd_C__case_12 x1 r s cd cs)
  AbstractHaskell.Curry_Types.Choices_C_Literal d i xs -> narrows cs d i (\z ->
    nd_C__case_12 x1 z s cd cs) xs
  AbstractHaskell.Curry_Types.Guard_C_Literal d c e -> guardCons d c ((\x ->
    nd_C__case_12 x1 e s cd x) $! addCs c cs)
  AbstractHaskell.Curry_Types.Fail_C_Literal d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_12" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_12" (showCons x2))

d_C__case_10 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C__case_10 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Text.Curry_Pretty.d_C_text x1 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_C_bquotes cd cs) (Text.Curry_Pretty.d_C_text x1 cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_10 x1 l cd cs)
    (d_C__case_10 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_10 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_10 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_10" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_10" (showCons x2))

nd_C__case_10 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_10 x1 x2 s cd cs = case x2 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` Text.Curry_Pretty.nd_C_text x1 s0 cd cs
  Curry_Prelude.C_False -> let s3 = s
    in s3 `seq` (let s2 = leftSupply s3
                     s4 = rightSupply s3
                     s0 = leftSupply s4
                     s1 = rightSupply s4
    in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_bquotes s0 cd cs) (Text.Curry_Pretty.nd_C_text x1 s1
    cd cs) s2 cd cs))))
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_10 x1 l s cd cs)
    (nd_C__case_10 x1 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_10 x1
    z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_10 x1 e s
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_10" [show x1, show x2] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_10" (showCons x2))

d_C__case_9 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> C_Options -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
d_C__case_9 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> d_C_ppQName x1 x2 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_apply
    (Text.Curry_Pretty.d_C_bquotes cd cs) (d_C_ppQName x1 x2 cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_9 x2 x1 l cd cs)
    (d_C__case_9 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_9 x2 x1
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_9 x2 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_9" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_9" (showCons x3))

nd_C__case_9 :: Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> C_Options -> Curry_Prelude.C_Bool -> IDSupply -> Cover -> ConstStore
  -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_9 x2 x1 x3 s cd cs = case x3 of
  Curry_Prelude.C_True -> let s0 = s in s0 `seq` nd_C_ppQName x1 x2 s0 cd cs
  Curry_Prelude.C_False -> let s3 = s
    in s3 `seq` (let s2 = leftSupply s3
                     s4 = rightSupply s3
                     s0 = leftSupply s4
                     s1 = rightSupply s4
    in s2 `seq` (s4 `seq` (s0 `seq` (s1 `seq` Curry_Prelude.nd_C_apply
    (Text.Curry_Pretty.nd_C_bquotes s0 cd cs) (nd_C_ppQName x1 x2 s1 cd cs) s2
    cd cs))))
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_9 x2 x1 l s cd
    cs) (nd_C__case_9 x2 x1 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_9 x2
    x1 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_9 x2 x1 e
    s cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_9" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_9" (showCons x3))

d_C__case_8 :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> C_Options
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C__case_8 x3 x1 x4 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Text.Curry_Pretty.d_C_text x4 cd cs
  Curry_Prelude.C_False -> d_C__case_7 x4 x3 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_8 x3 x1 x4 l cd
    cs) (d_C__case_8 x3 x1 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_8 x3 x1
    x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_8 x3 x1 x4
    e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_8" [show x3, show x1, show x4, show x5] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_8" (showCons x5))

nd_C__case_8 :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> C_Options
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool
  -> IDSupply -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_8 x3 x1 x4 x5 s cd cs = case x5 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` Text.Curry_Pretty.nd_C_text x4 s0 cd cs
  Curry_Prelude.C_False -> let s0 = s
    in s0 `seq` nd_C__case_7 x4 x3 (Curry_Prelude.d_C_otherwise cd cs) s0 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_8 x3 x1 x4 l s
    cd cs) (nd_C__case_8 x3 x1 x4 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_8 x3
    x1 x4 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_8 x3 x1
    x4 e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_8" [show x3, show x1, show x4, show x5] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_8" (showCons x5))

d_C__case_7 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C__case_7 x4 x3 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_dollar Text.Curry_Pretty.d_C_text
    (Curry_Prelude.d_OP_plus_plus x3 (Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.toCurryString ".") x4 cd cs) cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_7 x4 x3 l cd cs)
    (d_C__case_7 x4 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_7 x4 x3
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_7 x4 x3 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_7" [show x4, show x3, show x5] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_7" (showCons x5))

nd_C__case_7 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool
  -> IDSupply -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_7 x4 x3 x5 s cd cs = case x5 of
  Curry_Prelude.C_True -> let s0 = s
    in s0 `seq` Curry_Prelude.nd_OP_dollar (wrapNX id
    Text.Curry_Pretty.nd_C_text) (Curry_Prelude.d_OP_plus_plus x3
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.toCurryString ".") x4 cd cs) cd
    cs) s0 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_7 x4 x3 l s cd
    cs) (nd_C__case_7 x4 x3 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_7 x4
    x3 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_7 x4 x3 e
    s cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_7" [show x4, show x3, show x5] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_7" (showCons x5))

d_C__case_6 :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C__case_6 x3 cd cs = case x3 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_False
  Curry_Prelude.OP_Cons x4 x5 -> Curry_Prelude.d_OP_amp_amp
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
    x4 (Curry_Prelude.C_Char '('#) cd cs)
    (d_OP_isTuple_dot_p1_uscore_isTuple_dot_256 x5 cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_6 l cd cs)
    (d_C__case_6 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_6 z cd
    cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C__case_6 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_6" [show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_6" (showCons x3))

d_C__case_5 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_5 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
    x2 (Curry_Prelude.C_Char ')'#) cd cs
  Curry_Prelude.OP_Cons x4 x5 -> Curry_Prelude.d_OP_amp_amp
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
    x2 (Curry_Prelude.C_Char ','#) cd cs)
    (d_OP_isTuple_dot_p1_uscore_isTuple_dot_256 (Curry_Prelude.OP_Cons x4 x5) cd
    cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_5 x2 l cd cs)
    (d_C__case_5 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_5 x2 z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C__case_5 x2 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_5" [show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_5" (showCons x3))

d_C__case_4 :: Text.Curry_PrettyImpl.C_Doc -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
d_C__case_4 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> x2
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_4 x2 l cd cs)
    (d_C__case_4 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_4 x2 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_4 x2 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_4" [show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_4" (showCons x3))

nd_C__case_4 :: Text.Curry_PrettyImpl.C_Doc -> Curry_Prelude.C_Bool -> IDSupply
  -> Cover -> ConstStore -> Text.Curry_PrettyImpl.C_Doc
nd_C__case_4 x2 x3 s cd cs = case x3 of
  Curry_Prelude.C_True -> x2
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_4 x2 l s cd cs)
    (nd_C__case_4 x2 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_4 x2 z
    s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_4 x2 e s
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_4" [show x2, show x3] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_4" (showCons x3))

d_C__case_3 :: forall t0 . (Curry_Prelude.Curry t0) => (t0 -> Cover
  -> ConstStore -> t0) -> t0 -> Curry_Prelude.OP_List t0 -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0
d_C__case_3 x1 x3 x4 cd cs = case x4 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Cons (Curry_Prelude.d_C_apply x1 x3
    cd cs) Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x5 x6 -> Curry_Prelude.OP_Cons x3 (d_C_onLast x1 x4 cd
    cs)
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_3 x1 x3 l cd cs)
    (d_C__case_3 x1 x3 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_3 x1
    x3 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C__case_3 x1 x3 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_3" [show x1, show x3, show x4] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_3" (showCons x4))

nd_C__case_3 :: forall t0 . (Curry_Prelude.Curry t0) => Func t0 t0 -> t0
  -> Curry_Prelude.OP_List t0 -> IDSupply -> Cover -> ConstStore
  -> Curry_Prelude.OP_List t0
nd_C__case_3 x1 x3 x4 s cd cs = case x4 of
  Curry_Prelude.OP_List -> let s0 = s
    in s0 `seq` Curry_Prelude.OP_Cons (Curry_Prelude.nd_C_apply x1 x3 s0 cd cs)
    Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x5 x6 -> let s0 = s
    in s0 `seq` Curry_Prelude.OP_Cons x3 (nd_C_onLast x1 x4 s0 cd cs)
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (nd_C__case_3 x1 x3 l s cd
    cs) (nd_C__case_3 x1 x3 r s cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> nd_C__case_3 x1
    x3 z s cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> nd_C__case_3 x1 x3
    e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_3" [show x1, show x3, show x4] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_3" (showCons x4))

d_C__case_2 :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_2 x4 cd cs = case x4 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x5 x6 -> d_C_splitModuleIdentifiers x6 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_2 l cd cs)
    (d_C__case_2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_2 z cd
    cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C__case_2 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_2" [show x4] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_2" (showCons x4))

d_C__case_1 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List t0
  -> Curry_Prelude.OP_List t0 -> (Curry_Prelude.OP_Unit -> Cover -> ConstStore
  -> Curry_Prelude.OP_uscore_Dict_hash_Eq t0) -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List t0
d_C__case_1 x3 x2 x1 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_drop (Curry_Prelude.d_C_length x2 cd
    cs) x3 cd cs
  Curry_Prelude.C_False -> d_C__case_0 x3 (Curry_Prelude.d_C_otherwise cd cs) cd
    cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_1 x3 x2 x1 l cd
    cs) (d_C__case_1 x3 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_1 x3 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_1 x3 x2 x1
    e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_1" [show x3, show x2, show x1, show x4] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_1" (showCons x4))

nd_C__case_1 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List t0
  -> Curry_Prelude.OP_List t0 -> Func Curry_Prelude.OP_Unit
  (Curry_Prelude.OP_uscore_Dict_hash_Eq t0) -> Curry_Prelude.C_Bool -> IDSupply
  -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
nd_C__case_1 x3 x2 x1 x4 s cd cs = case x4 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_drop (Curry_Prelude.d_C_length x2 cd
    cs) x3 cd cs
  Curry_Prelude.C_False -> d_C__case_0 x3 (Curry_Prelude.d_C_otherwise cd cs) cd
    cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (nd_C__case_1 x3 x2 x1 l s
    cd cs) (nd_C__case_1 x3 x2 x1 r s cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> nd_C__case_1 x3
    x2 x1 z s cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> nd_C__case_1 x3 x2
    x1 e s cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_1" [show x3, show x2, show x1, show x4] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_1" (showCons x4))

d_C__case_0 :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.OP_List t0
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List t0
d_C__case_0 x3 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> x3
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_0 x3 l cd cs)
    (d_C__case_0 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_0 x3 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_0 x3 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "AbstractHaskell.Printer._case_0" [show x3, show x4] info)
  _ -> failCons cd (consFail "AbstractHaskell.Printer._case_0" (showCons x4))

