{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE QuantifiedConstraints #-}
{-# LANGUAGE RankNTypes #-}
{-# LANGUAGE PolyKinds #-}
{-# LANGUAGE MultiParamTypeClasses #-}
{-# LANGUAGE FlexibleInstances #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif

module System.Curry_FilePath
  ( d_C_pathSeparator
  , d_C_pathSeparators
  , d_C_isPathSeparator
  , d_C_searchPathSeparator
  , d_C_isSearchPathSeparator
  , d_C_extSeparator
  , d_C_isExtSeparator
  , d_C_splitSearchPath
  , d_C_getSearchPath
  , d_C_splitExtension
  , d_C_takeExtension
  , d_C_replaceExtension
  , d_OP_lt_dot_gt
  , d_C_dropExtension
  , d_C_addExtension
  , d_C_hasExtension
  , d_C_splitExtensions
  , d_C_dropExtensions
  , d_C_takeExtensions
  , d_C_isExtensionOf
  , d_C_splitDrive
  , d_C_joinDrive
  , d_C_takeDrive
  , d_C_dropDrive
  , d_C_hasDrive
  , d_C_isDrive
  , d_C_splitFileName
  , d_C_replaceFileName
  , d_C_dropFileName
  , d_C_takeFileName
  , d_C_takeBaseName
  , d_C_replaceBaseName
  , d_C_hasTrailingPathSeparator
  , d_C_addTrailingPathSeparator
  , d_C_dropTrailingPathSeparator
  , d_C_takeDirectory
  , d_C_replaceDirectory
  , d_C_combine
  , d_OP_lt_slash_gt
  , d_C_splitPath
  , d_C_splitDirectories
  , d_C_joinPath
  , d_C_equalFilePath
  , d_C_makeRelative
  , d_C_normalise
  , d_C_isValid
  , d_C_makeValid
  , d_C_isRelative
  , d_C_isAbsolute )
  where

import Basics
import qualified Data.Curry_Char
import qualified Data.Curry_List
import qualified Data.Curry_Maybe
import qualified Curry_Prelude
import qualified System.Curry_Environment


d_C_pathSeparator :: Cover -> ConstStore -> Curry_Prelude.C_Char
d_C_pathSeparator cd cs = d_C__case_100 (System.Curry_Environment.d_C_isWindows
  cd cs) cd cs

d_C_pathSeparators :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_pathSeparators cd cs = d_C__case_99 (System.Curry_Environment.d_C_isWindows
  cd cs) cd cs

d_C_isPathSeparator :: Cover -> ConstStore -> Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_C_isPathSeparator cd cs = Curry_Prelude.d_C_flip (Curry_Prelude.d_C_elem
  Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash)
  (d_C_pathSeparators cd cs)

d_C_searchPathSeparator :: Cover -> ConstStore -> Curry_Prelude.C_Char
d_C_searchPathSeparator cd cs = d_C__case_98
  (System.Curry_Environment.d_C_isWindows cd cs) cd cs

d_C_isSearchPathSeparator :: Cover -> ConstStore -> Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_isSearchPathSeparator cd cs = Curry_Prelude.d_C_flip (acceptCs id
  Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash)
  (d_C_searchPathSeparator cd cs)

d_C_extSeparator :: Cover -> ConstStore -> Curry_Prelude.C_Char
d_C_extSeparator cd cs = Curry_Prelude.C_Char '.'#

d_C_isExtSeparator :: Cover -> ConstStore -> Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_C_isExtSeparator cd cs = Curry_Prelude.d_C_flip (acceptCs id
  Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash)
  (d_C_extSeparator cd cs)

d_C_splitSearchPath :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_splitSearchPath cd cs = d_OP_splitSearchPath_dot_f_dot_16

d_OP_splitSearchPath_dot_g_dot_16 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_splitSearchPath_dot_g_dot_16 x1 cd cs = case x1 of
  Curry_Prelude.OP_List -> d_C__case_97 (System.Curry_Environment.d_C_isPosix cd
    cs) cd cs
  Curry_Prelude.OP_Cons x2 x3 -> Curry_Prelude.OP_Cons x1 Curry_Prelude.OP_List
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_splitSearchPath_dot_g_dot_16 l cd cs)
    (d_OP_splitSearchPath_dot_g_dot_16 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_splitSearchPath_dot_g_dot_16 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x ->
    d_OP_splitSearchPath_dot_g_dot_16 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath.splitSearchPath.g.16" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.splitSearchPath.g.16" (showCons
    x1))

d_OP_splitSearchPath_dot_f_dot_16 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_splitSearchPath_dot_f_dot_16 x1 cd cs = d_C__case_96 x1
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_break (d_C_isSearchPathSeparator
  cd cs) cd cs) x1 cd cs) cd cs

d_C_getSearchPath :: Cover -> ConstStore -> Curry_Prelude.C_IO
  (Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C_getSearchPath cd cs = Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_gt_eq_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (System.Curry_Environment.d_C_getEnv (Curry_Prelude.toCurryString
  "PATH") cd cs) cd cs) (Curry_Prelude.d_OP_dot
  (Curry_Prelude.d_OP_uscore_impl_hash_return_hash_Prelude_dot_Monad_hash_Prelude_dot_IO_hash
  cd cs) (d_C_splitSearchPath cd cs) cd cs) cd cs

d_C_splitExtension :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_splitExtension x1 cd cs = let x2 = d_C_splitFileName_ x1 cd cs
                                  x3 = d_OP_splitExtension_dot_uscore_hash_selFP5_hash_a
                                    x2 cd cs
                                  x4 = d_OP_splitExtension_dot_uscore_hash_selFP6_hash_b
                                    x2 cd cs
                                  x5 = Curry_Prelude.d_OP_dollar
                                    (Curry_Prelude.d_C_break (d_C_isExtSeparator
                                    cd cs) cd cs) (Curry_Prelude.d_C_apply
                                    (Curry_Prelude.d_C_reverse cd cs) x4 cd cs)
                                    cd cs
                                  x6 = d_OP_splitExtension_dot_uscore_hash_selFP3_hash_c
                                    x5 cd cs
                                  x7 = d_OP_splitExtension_dot_uscore_hash_selFP4_hash_d
                                    x5 cd cs
  in d_C__case_94 x6 x3 x1 x7 cd cs

d_OP_splitExtension_dot_uscore_hash_selFP5_hash_a :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitExtension_dot_uscore_hash_selFP5_hash_a x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitExtension_dot_uscore_hash_selFP5_hash_a l cd cs)
    (d_OP_splitExtension_dot_uscore_hash_selFP5_hash_a r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitExtension_dot_uscore_hash_selFP5_hash_a z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_splitExtension_dot_uscore_hash_selFP5_hash_a e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.splitExtension._#selFP5#a" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.splitExtension._#selFP5#a"
    (showCons x1))

d_OP_splitExtension_dot_uscore_hash_selFP6_hash_b :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitExtension_dot_uscore_hash_selFP6_hash_b x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitExtension_dot_uscore_hash_selFP6_hash_b l cd cs)
    (d_OP_splitExtension_dot_uscore_hash_selFP6_hash_b r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitExtension_dot_uscore_hash_selFP6_hash_b z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_splitExtension_dot_uscore_hash_selFP6_hash_b e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.splitExtension._#selFP6#b" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.splitExtension._#selFP6#b"
    (showCons x1))

d_OP_splitExtension_dot_uscore_hash_selFP3_hash_c :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitExtension_dot_uscore_hash_selFP3_hash_c x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitExtension_dot_uscore_hash_selFP3_hash_c l cd cs)
    (d_OP_splitExtension_dot_uscore_hash_selFP3_hash_c r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitExtension_dot_uscore_hash_selFP3_hash_c z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_splitExtension_dot_uscore_hash_selFP3_hash_c e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.splitExtension._#selFP3#c" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.splitExtension._#selFP3#c"
    (showCons x1))

d_OP_splitExtension_dot_uscore_hash_selFP4_hash_d :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitExtension_dot_uscore_hash_selFP4_hash_d x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitExtension_dot_uscore_hash_selFP4_hash_d l cd cs)
    (d_OP_splitExtension_dot_uscore_hash_selFP4_hash_d r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitExtension_dot_uscore_hash_selFP4_hash_d z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_splitExtension_dot_uscore_hash_selFP4_hash_d e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.splitExtension._#selFP4#d" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.splitExtension._#selFP4#d"
    (showCons x1))

d_C_takeExtension :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_takeExtension cd cs = Curry_Prelude.d_OP_dot Curry_Prelude.d_C_snd
  d_C_splitExtension cd cs

d_C_replaceExtension :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_replaceExtension x1 x2 cd cs = Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply (d_OP_lt_dot_gt cd cs) (Curry_Prelude.d_C_apply
  (d_C_dropExtension cd cs) x1 cd cs) cd cs) x2 cd cs

d_OP_lt_dot_gt :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_lt_dot_gt cd cs = acceptCs id d_C_addExtension

d_C_dropExtension :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_dropExtension cd cs = Curry_Prelude.d_OP_dot Curry_Prelude.d_C_fst
  d_C_splitExtension cd cs

d_C_addExtension :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_addExtension x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_List -> x1
  Curry_Prelude.OP_Cons x3 x4 -> let x5 = d_C_splitDrive x1 cd cs
                                     x6 = d_OP_addExtension_dot_uscore_hash_selFP8_hash_a
                                       x5 cd cs
                                     x7 = d_OP_addExtension_dot_uscore_hash_selFP9_hash_b
                                       x5 cd cs
                                     x8 = d_C__case_93 x3 x2 x7
                                       (Curry_Prelude.d_C_apply
                                       (d_C_isExtSeparator cd cs) x3 cd cs) cd
                                       cs
    in d_C_joinDrive x6 x8 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_addExtension x1 l cd
    cs) (d_C_addExtension x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_addExtension
    x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C_addExtension x1
    e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath.addExtension" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.FilePath.addExtension" (showCons x2))

d_OP_addExtension_dot_uscore_hash_selFP8_hash_a :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_addExtension_dot_uscore_hash_selFP8_hash_a x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_addExtension_dot_uscore_hash_selFP8_hash_a l cd cs)
    (d_OP_addExtension_dot_uscore_hash_selFP8_hash_a r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_addExtension_dot_uscore_hash_selFP8_hash_a z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_addExtension_dot_uscore_hash_selFP8_hash_a e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.addExtension._#selFP8#a" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.addExtension._#selFP8#a" (showCons
    x1))

d_OP_addExtension_dot_uscore_hash_selFP9_hash_b :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_addExtension_dot_uscore_hash_selFP9_hash_b x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_addExtension_dot_uscore_hash_selFP9_hash_b l cd cs)
    (d_OP_addExtension_dot_uscore_hash_selFP9_hash_b r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_addExtension_dot_uscore_hash_selFP9_hash_b z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_addExtension_dot_uscore_hash_selFP9_hash_b e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.addExtension._#selFP9#b" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.addExtension._#selFP9#b" (showCons
    x1))

d_C_hasExtension :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_hasExtension cd cs = Curry_Prelude.d_OP_dot (Curry_Prelude.d_C_any
  (d_C_isExtSeparator cd cs) cd cs) (d_C_takeFileName cd cs) cd cs

d_C_splitExtensions :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_splitExtensions x1 cd cs = let x2 = d_C_splitFileName_ x1 cd cs
                                   x3 = d_OP_splitExtensions_dot_uscore_hash_selFP14_hash_a
                                     x2 cd cs
                                   x4 = d_OP_splitExtensions_dot_uscore_hash_selFP15_hash_b
                                     x2 cd cs
                                   x5 = Curry_Prelude.d_C_apply
                                     (Curry_Prelude.d_C_break
                                     (d_C_isExtSeparator cd cs) cd cs) x4 cd cs
                                   x6 = d_OP_splitExtensions_dot_uscore_hash_selFP12_hash_c
                                     x5 cd cs
                                   x7 = d_OP_splitExtensions_dot_uscore_hash_selFP13_hash_d
                                     x5 cd cs
  in Curry_Prelude.OP_Tuple2 (Curry_Prelude.d_OP_plus_plus x3 x6 cd cs) x7

d_OP_splitExtensions_dot_uscore_hash_selFP14_hash_a :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitExtensions_dot_uscore_hash_selFP14_hash_a x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitExtensions_dot_uscore_hash_selFP14_hash_a l cd cs)
    (d_OP_splitExtensions_dot_uscore_hash_selFP14_hash_a r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitExtensions_dot_uscore_hash_selFP14_hash_a z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_splitExtensions_dot_uscore_hash_selFP14_hash_a e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.splitExtensions._#selFP14#a" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.splitExtensions._#selFP14#a"
    (showCons x1))

d_OP_splitExtensions_dot_uscore_hash_selFP15_hash_b :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitExtensions_dot_uscore_hash_selFP15_hash_b x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitExtensions_dot_uscore_hash_selFP15_hash_b l cd cs)
    (d_OP_splitExtensions_dot_uscore_hash_selFP15_hash_b r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitExtensions_dot_uscore_hash_selFP15_hash_b z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_splitExtensions_dot_uscore_hash_selFP15_hash_b e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.splitExtensions._#selFP15#b" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.splitExtensions._#selFP15#b"
    (showCons x1))

d_OP_splitExtensions_dot_uscore_hash_selFP12_hash_c :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitExtensions_dot_uscore_hash_selFP12_hash_c x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitExtensions_dot_uscore_hash_selFP12_hash_c l cd cs)
    (d_OP_splitExtensions_dot_uscore_hash_selFP12_hash_c r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitExtensions_dot_uscore_hash_selFP12_hash_c z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_splitExtensions_dot_uscore_hash_selFP12_hash_c e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.splitExtensions._#selFP12#c" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.splitExtensions._#selFP12#c"
    (showCons x1))

d_OP_splitExtensions_dot_uscore_hash_selFP13_hash_d :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitExtensions_dot_uscore_hash_selFP13_hash_d x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitExtensions_dot_uscore_hash_selFP13_hash_d l cd cs)
    (d_OP_splitExtensions_dot_uscore_hash_selFP13_hash_d r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitExtensions_dot_uscore_hash_selFP13_hash_d z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_splitExtensions_dot_uscore_hash_selFP13_hash_d e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.splitExtensions._#selFP13#d" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.splitExtensions._#selFP13#d"
    (showCons x1))

d_C_dropExtensions :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_dropExtensions cd cs = Curry_Prelude.d_OP_dot Curry_Prelude.d_C_fst
  d_C_splitExtensions cd cs

d_C_takeExtensions :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_takeExtensions cd cs = Curry_Prelude.d_OP_dot Curry_Prelude.d_C_snd
  d_C_splitExtensions cd cs

d_C_isExtensionOf :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isExtensionOf x1 x2 cd cs = let x3 = x1 in d_C__case_92 x2 x3 cd cs

d_C_isLetter :: Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isLetter x1 cd cs = Curry_Prelude.d_OP_bar_bar (Curry_Prelude.d_OP_amp_amp
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Char_hash
  cd cs) x1 cd cs) (Curry_Prelude.C_Char 'a'#) cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Char_hash
  x1 (Curry_Prelude.C_Char 'z'#) cd cs) cd cs) (Curry_Prelude.d_OP_amp_amp
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Char_hash
  cd cs) x1 cd cs) (Curry_Prelude.C_Char 'A'#) cd cs)
  (Curry_Prelude.d_OP_uscore_impl_hash_lt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Char_hash
  x1 (Curry_Prelude.C_Char 'Z'#) cd cs) cd cs) cd cs

d_C_splitDrive :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_splitDrive x1 cd cs = let x2 = d_C_readDriveLetter x1 cd cs
                              x3 = d_C_readDriveUNC x1 cd cs
                              x4 = d_C_readDriveShare x1 cd cs
  in d_C__case_90 x2 x3 x4 x1 (System.Curry_Environment.d_C_isPosix cd cs) cd cs

d_C_addSlash :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_addSlash x1 x2 cd cs = let x3 = Curry_Prelude.d_C_span (d_C_isPathSeparator
                                 cd cs) x2 cd cs
                               x4 = d_OP_addSlash_dot_uscore_hash_selFP17_hash_c
                                 x3 cd cs
                               x5 = d_OP_addSlash_dot_uscore_hash_selFP18_hash_d
                                 x3 cd cs
  in Curry_Prelude.OP_Tuple2 (Curry_Prelude.d_OP_plus_plus x1 x4 cd cs) x5

d_OP_addSlash_dot_uscore_hash_selFP17_hash_c :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_addSlash_dot_uscore_hash_selFP17_hash_c x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_addSlash_dot_uscore_hash_selFP17_hash_c l cd cs)
    (d_OP_addSlash_dot_uscore_hash_selFP17_hash_c r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_addSlash_dot_uscore_hash_selFP17_hash_c z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_addSlash_dot_uscore_hash_selFP17_hash_c e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.addSlash._#selFP17#c" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.addSlash._#selFP17#c" (showCons
    x1))

d_OP_addSlash_dot_uscore_hash_selFP18_hash_d :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_addSlash_dot_uscore_hash_selFP18_hash_d x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_addSlash_dot_uscore_hash_selFP18_hash_d l cd cs)
    (d_OP_addSlash_dot_uscore_hash_selFP18_hash_d r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_addSlash_dot_uscore_hash_selFP18_hash_d z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_addSlash_dot_uscore_hash_selFP18_hash_d e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.addSlash._#selFP18#d" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.addSlash._#selFP18#d" (showCons
    x1))

d_C_readDriveUNC :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C_readDriveUNC x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_85 x2 x3 cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.C_Nothing
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_readDriveUNC l cd cs)
    (d_C_readDriveUNC r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_readDriveUNC
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C_readDriveUNC e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath.readDriveUNC" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.readDriveUNC" (showCons x1))

d_OP_readDriveUNC_dot_uscore_hash_selFP20_hash_a :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_readDriveUNC_dot_uscore_hash_selFP20_hash_a x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_readDriveUNC_dot_uscore_hash_selFP20_hash_a l cd cs)
    (d_OP_readDriveUNC_dot_uscore_hash_selFP20_hash_a r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_readDriveUNC_dot_uscore_hash_selFP20_hash_a z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_readDriveUNC_dot_uscore_hash_selFP20_hash_a e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.readDriveUNC._#selFP20#a" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.readDriveUNC._#selFP20#a"
    (showCons x1))

d_OP_readDriveUNC_dot_uscore_hash_selFP21_hash_b :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_readDriveUNC_dot_uscore_hash_selFP21_hash_b x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_readDriveUNC_dot_uscore_hash_selFP21_hash_b l cd cs)
    (d_OP_readDriveUNC_dot_uscore_hash_selFP21_hash_b r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_readDriveUNC_dot_uscore_hash_selFP21_hash_b z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_readDriveUNC_dot_uscore_hash_selFP21_hash_b e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.readDriveUNC._#selFP21#b" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.readDriveUNC._#selFP21#b"
    (showCons x1))

d_C_readDriveLetter :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C_readDriveLetter x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_70 x2 x3 cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.C_Nothing
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_readDriveLetter l cd
    cs) (d_C_readDriveLetter r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_C_readDriveLetter z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C_readDriveLetter
    e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath.readDriveLetter" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.readDriveLetter" (showCons x1))

d_C_readDriveShare :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C_readDriveShare x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_64 x2 x3 cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.C_Nothing
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_readDriveShare l cd
    cs) (d_C_readDriveShare r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_C_readDriveShare z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C_readDriveShare
    e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath.readDriveShare" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.readDriveShare" (showCons x1))

d_OP_readDriveShare_dot_uscore_hash_selFP23_hash_a :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_readDriveShare_dot_uscore_hash_selFP23_hash_a x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_readDriveShare_dot_uscore_hash_selFP23_hash_a l cd cs)
    (d_OP_readDriveShare_dot_uscore_hash_selFP23_hash_a r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_readDriveShare_dot_uscore_hash_selFP23_hash_a z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_readDriveShare_dot_uscore_hash_selFP23_hash_a e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.readDriveShare._#selFP23#a" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.readDriveShare._#selFP23#a"
    (showCons x1))

d_OP_readDriveShare_dot_uscore_hash_selFP24_hash_b :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_readDriveShare_dot_uscore_hash_selFP24_hash_b x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_readDriveShare_dot_uscore_hash_selFP24_hash_b l cd cs)
    (d_OP_readDriveShare_dot_uscore_hash_selFP24_hash_b r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_readDriveShare_dot_uscore_hash_selFP24_hash_b z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_readDriveShare_dot_uscore_hash_selFP24_hash_b e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.readDriveShare._#selFP24#b" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.readDriveShare._#selFP24#b"
    (showCons x1))

d_C_readDriveShareName :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_readDriveShareName x1 cd cs = let x2 = Curry_Prelude.d_C_apply
                                        (Curry_Prelude.d_C_break
                                        (d_C_isPathSeparator cd cs) cd cs) x1 cd
                                        cs
                                      x3 = d_OP_readDriveShareName_dot_uscore_hash_selFP26_hash_a
                                        x2 cd cs
                                      x4 = d_OP_readDriveShareName_dot_uscore_hash_selFP27_hash_b
                                        x2 cd cs
  in d_C_addSlash x3 x4 cd cs

d_OP_readDriveShareName_dot_uscore_hash_selFP26_hash_a :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_readDriveShareName_dot_uscore_hash_selFP26_hash_a x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_readDriveShareName_dot_uscore_hash_selFP26_hash_a l cd cs)
    (d_OP_readDriveShareName_dot_uscore_hash_selFP26_hash_a r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_readDriveShareName_dot_uscore_hash_selFP26_hash_a z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_readDriveShareName_dot_uscore_hash_selFP26_hash_a e cd x) $! addCs c
    cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.readDriveShareName._#selFP26#a" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.readDriveShareName._#selFP26#a"
    (showCons x1))

d_OP_readDriveShareName_dot_uscore_hash_selFP27_hash_b :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_readDriveShareName_dot_uscore_hash_selFP27_hash_b x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_readDriveShareName_dot_uscore_hash_selFP27_hash_b l cd cs)
    (d_OP_readDriveShareName_dot_uscore_hash_selFP27_hash_b r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_readDriveShareName_dot_uscore_hash_selFP27_hash_b z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_readDriveShareName_dot_uscore_hash_selFP27_hash_b e cd x) $! addCs c
    cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.readDriveShareName._#selFP27#b" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.readDriveShareName._#selFP27#b"
    (showCons x1))

d_C_joinDrive :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_joinDrive x1 x2 cd cs = d_C__case_62 x1 x2
  (System.Curry_Environment.d_C_isPosix cd cs) cd cs

d_C_takeDrive :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_takeDrive cd cs = Curry_Prelude.d_OP_dot Curry_Prelude.d_C_fst
  d_C_splitDrive cd cs

d_C_dropDrive :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_dropDrive cd cs = Curry_Prelude.d_OP_dot Curry_Prelude.d_C_snd
  d_C_splitDrive cd cs

d_C_hasDrive :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_hasDrive cd cs = Curry_Prelude.d_OP_dot Curry_Prelude.d_C_not
  (Curry_Prelude.d_OP_dot Curry_Prelude.d_C_null (d_C_takeDrive cd cs) cd cs) cd
  cs

d_C_isDrive :: Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_isDrive cd cs = Curry_Prelude.d_OP_dot Curry_Prelude.d_C_null (d_C_dropDrive
  cd cs) cd cs

d_C_splitFileName :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_splitFileName x1 cd cs = let x2 = d_C_splitFileName_ x1 cd cs
                                 x3 = d_OP_splitFileName_dot_uscore_hash_selFP29_hash_dir
                                   x2 cd cs
                                 x4 = d_OP_splitFileName_dot_uscore_hash_selFP30_hash_name
                                   x2 cd cs
  in Curry_Prelude.OP_Tuple2 (d_C__case_52 x3 (Curry_Prelude.d_C_null x3 cd cs)
  cd cs) x4

d_OP_splitFileName_dot_uscore_hash_selFP29_hash_dir :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitFileName_dot_uscore_hash_selFP29_hash_dir x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitFileName_dot_uscore_hash_selFP29_hash_dir l cd cs)
    (d_OP_splitFileName_dot_uscore_hash_selFP29_hash_dir r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitFileName_dot_uscore_hash_selFP29_hash_dir z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_splitFileName_dot_uscore_hash_selFP29_hash_dir e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.splitFileName._#selFP29#dir" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.splitFileName._#selFP29#dir"
    (showCons x1))

d_OP_splitFileName_dot_uscore_hash_selFP30_hash_name :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitFileName_dot_uscore_hash_selFP30_hash_name x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitFileName_dot_uscore_hash_selFP30_hash_name l cd cs)
    (d_OP_splitFileName_dot_uscore_hash_selFP30_hash_name r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitFileName_dot_uscore_hash_selFP30_hash_name z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_splitFileName_dot_uscore_hash_selFP30_hash_name e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.splitFileName._#selFP30#name" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.splitFileName._#selFP30#name"
    (showCons x1))

d_C_splitFileName_ :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_splitFileName_ x1 cd cs = let x2 = d_C_splitDrive x1 cd cs
                                  x3 = d_OP_splitFileName_uscore_dot_uscore_hash_selFP35_hash_c
                                    x2 cd cs
                                  x4 = d_OP_splitFileName_uscore_dot_uscore_hash_selFP36_hash_d
                                    x2 cd cs
                                  x5 = Curry_Prelude.d_OP_dollar
                                    (Curry_Prelude.d_C_break
                                    (d_C_isPathSeparator cd cs) cd cs)
                                    (Curry_Prelude.d_C_apply
                                    (Curry_Prelude.d_C_reverse cd cs) x4 cd cs)
                                    cd cs
                                  x6 = d_OP_splitFileName_uscore_dot_uscore_hash_selFP33_hash_a
                                    x5 cd cs
                                  x7 = d_OP_splitFileName_uscore_dot_uscore_hash_selFP34_hash_b
                                    x5 cd cs
  in Curry_Prelude.OP_Tuple2 (Curry_Prelude.d_OP_plus_plus x3
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_reverse cd cs) x7 cd cs) cd cs)
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_reverse cd cs) x6 cd cs)

d_OP_splitFileName_uscore_dot_uscore_hash_selFP35_hash_c :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitFileName_uscore_dot_uscore_hash_selFP35_hash_c x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitFileName_uscore_dot_uscore_hash_selFP35_hash_c l cd cs)
    (d_OP_splitFileName_uscore_dot_uscore_hash_selFP35_hash_c r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitFileName_uscore_dot_uscore_hash_selFP35_hash_c z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_splitFileName_uscore_dot_uscore_hash_selFP35_hash_c e cd x) $! addCs c
    cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.splitFileName_._#selFP35#c" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.splitFileName_._#selFP35#c"
    (showCons x1))

d_OP_splitFileName_uscore_dot_uscore_hash_selFP36_hash_d :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitFileName_uscore_dot_uscore_hash_selFP36_hash_d x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitFileName_uscore_dot_uscore_hash_selFP36_hash_d l cd cs)
    (d_OP_splitFileName_uscore_dot_uscore_hash_selFP36_hash_d r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitFileName_uscore_dot_uscore_hash_selFP36_hash_d z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_splitFileName_uscore_dot_uscore_hash_selFP36_hash_d e cd x) $! addCs c
    cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.splitFileName_._#selFP36#d" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.splitFileName_._#selFP36#d"
    (showCons x1))

d_OP_splitFileName_uscore_dot_uscore_hash_selFP33_hash_a :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitFileName_uscore_dot_uscore_hash_selFP33_hash_a x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitFileName_uscore_dot_uscore_hash_selFP33_hash_a l cd cs)
    (d_OP_splitFileName_uscore_dot_uscore_hash_selFP33_hash_a r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitFileName_uscore_dot_uscore_hash_selFP33_hash_a z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_splitFileName_uscore_dot_uscore_hash_selFP33_hash_a e cd x) $! addCs c
    cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.splitFileName_._#selFP33#a" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.splitFileName_._#selFP33#a"
    (showCons x1))

d_OP_splitFileName_uscore_dot_uscore_hash_selFP34_hash_b :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitFileName_uscore_dot_uscore_hash_selFP34_hash_b x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitFileName_uscore_dot_uscore_hash_selFP34_hash_b l cd cs)
    (d_OP_splitFileName_uscore_dot_uscore_hash_selFP34_hash_b r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitFileName_uscore_dot_uscore_hash_selFP34_hash_b z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_splitFileName_uscore_dot_uscore_hash_selFP34_hash_b e cd x) $! addCs c
    cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.splitFileName_._#selFP34#b" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.splitFileName_._#selFP34#b"
    (showCons x1))

d_C_replaceFileName :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_replaceFileName x1 x2 cd cs = let x3 = d_C_splitFileName_ x1 cd cs
                                      x4 = d_OP_replaceFileName_dot_uscore_hash_selFP38_hash_a
                                        x3 cd cs
  in Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (d_OP_lt_slash_gt cd cs)
  x4 cd cs) x2 cd cs

d_OP_replaceFileName_dot_uscore_hash_selFP38_hash_a :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_replaceFileName_dot_uscore_hash_selFP38_hash_a x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_replaceFileName_dot_uscore_hash_selFP38_hash_a l cd cs)
    (d_OP_replaceFileName_dot_uscore_hash_selFP38_hash_a r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_replaceFileName_dot_uscore_hash_selFP38_hash_a z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_replaceFileName_dot_uscore_hash_selFP38_hash_a e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.replaceFileName._#selFP38#a" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.replaceFileName._#selFP38#a"
    (showCons x1))

d_C_dropFileName :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_dropFileName cd cs = Curry_Prelude.d_OP_dot Curry_Prelude.d_C_fst
  d_C_splitFileName cd cs

d_C_takeFileName :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_takeFileName cd cs = Curry_Prelude.d_OP_dot Curry_Prelude.d_C_snd
  d_C_splitFileName cd cs

d_C_takeBaseName :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_takeBaseName cd cs = Curry_Prelude.d_OP_dot (d_C_dropExtension cd cs)
  (d_C_takeFileName cd cs) cd cs

d_C_replaceBaseName :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_replaceBaseName x1 x2 cd cs = let x3 = d_C_splitFileName_ x1 cd cs
                                      x4 = d_OP_replaceBaseName_dot_uscore_hash_selFP40_hash_a
                                        x3 cd cs
                                      x5 = d_OP_replaceBaseName_dot_uscore_hash_selFP41_hash_b
                                        x3 cd cs
                                      x6 = Curry_Prelude.d_C_apply
                                        (d_C_takeExtension cd cs) x5 cd cs
  in d_C_combineAlways x4 (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (d_OP_lt_dot_gt cd cs) x2 cd cs) x6 cd cs) cd cs

d_OP_replaceBaseName_dot_uscore_hash_selFP40_hash_a :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_replaceBaseName_dot_uscore_hash_selFP40_hash_a x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_replaceBaseName_dot_uscore_hash_selFP40_hash_a l cd cs)
    (d_OP_replaceBaseName_dot_uscore_hash_selFP40_hash_a r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_replaceBaseName_dot_uscore_hash_selFP40_hash_a z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_replaceBaseName_dot_uscore_hash_selFP40_hash_a e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.replaceBaseName._#selFP40#a" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.replaceBaseName._#selFP40#a"
    (showCons x1))

d_OP_replaceBaseName_dot_uscore_hash_selFP41_hash_b :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_replaceBaseName_dot_uscore_hash_selFP41_hash_b x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_replaceBaseName_dot_uscore_hash_selFP41_hash_b l cd cs)
    (d_OP_replaceBaseName_dot_uscore_hash_selFP41_hash_b r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_replaceBaseName_dot_uscore_hash_selFP41_hash_b z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_replaceBaseName_dot_uscore_hash_selFP41_hash_b e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.replaceBaseName._#selFP41#b" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.replaceBaseName._#selFP41#b"
    (showCons x1))

d_C_hasTrailingPathSeparator :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_hasTrailingPathSeparator x1 cd cs = case x1 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_False
  Curry_Prelude.OP_Cons x2 x3 -> Curry_Prelude.d_C_apply (d_C_isPathSeparator cd
    cs) (Data.Curry_List.d_C_last x1 cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_C_hasTrailingPathSeparator l cd cs) (d_C_hasTrailingPathSeparator r cd
    cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_C_hasTrailingPathSeparator z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x ->
    d_C_hasTrailingPathSeparator e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath.hasTrailingPathSeparator" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.hasTrailingPathSeparator"
    (showCons x1))

d_C_addTrailingPathSeparator :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_addTrailingPathSeparator x1 cd cs = d_C__case_51 x1
  (d_C_hasTrailingPathSeparator x1 cd cs) cd cs

d_C_dropTrailingPathSeparator :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_dropTrailingPathSeparator x1 cd cs = d_C__case_50 x1
  (Curry_Prelude.d_OP_amp_amp (d_C_hasTrailingPathSeparator x1 cd cs)
  (Curry_Prelude.d_C_not (Curry_Prelude.d_C_apply (d_C_isDrive cd cs) x1 cd cs)
  cd cs) cd cs) cd cs

d_C_takeDirectory :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_takeDirectory x1 cd cs = let x2 = Curry_Prelude.d_C_apply (d_C_dropFileName
                                   cd cs) x1 cd cs
                                 x3 = Curry_Prelude.d_OP_dollar
                                   (Curry_Prelude.d_C_reverse cd cs)
                                   (Curry_Prelude.d_OP_dollar
                                   (Curry_Prelude.d_C_dropWhile
                                   (d_C_isPathSeparator cd cs))
                                   (Curry_Prelude.d_C_apply
                                   (Curry_Prelude.d_C_reverse cd cs) x2 cd cs)
                                   cd cs) cd cs
  in d_C__case_48 x2 x3 (Curry_Prelude.d_C_apply (d_C_isDrive cd cs) x2 cd cs)
  cd cs

d_C_replaceDirectory :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_replaceDirectory x1 x2 cd cs = d_C_combineAlways x2 (Curry_Prelude.d_C_apply
  (d_C_takeFileName cd cs) x1 cd cs) cd cs

d_C_combine :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_combine x1 x2 cd cs = d_C__case_46 x2 x1 (Curry_Prelude.d_OP_bar_bar
  (Curry_Prelude.d_C_apply (d_C_hasDrive cd cs) x2 cd cs)
  (Curry_Prelude.d_OP_amp_amp (Curry_Prelude.d_C_not (Curry_Prelude.d_C_null x2
  cd cs) cd cs) (Curry_Prelude.d_C_apply (d_C_isPathSeparator cd cs)
  (Curry_Prelude.d_C_head x2 cd cs) cd cs) cd cs) cd cs) cd cs

d_C_combineAlways :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_combineAlways x1 x2 cd cs = d_C__case_44 x1 x2 (Curry_Prelude.d_C_null x1 cd
  cs) cd cs

d_OP_lt_slash_gt :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_lt_slash_gt cd cs = acceptCs id d_C_combine

d_C_splitPath :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_splitPath x1 cd cs = let x2 = d_C_splitDrive x1 cd cs
                             x3 = d_OP_splitPath_dot_uscore_hash_selFP49_hash_drive
                               x2 cd cs
                             x4 = d_OP_splitPath_dot_uscore_hash_selFP50_hash_path
                               x2 cd cs
  in Curry_Prelude.d_OP_plus_plus (d_C__case_39 x3 (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket_hash_0_hash_hash
  Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
  cd cs) x3 cd cs) Curry_Prelude.OP_List cd cs) cd cs)
  (d_OP_splitPath_dot_f_dot_187 x4 cd cs) cd cs

d_OP_splitPath_dot_uscore_hash_selFP49_hash_drive :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitPath_dot_uscore_hash_selFP49_hash_drive x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitPath_dot_uscore_hash_selFP49_hash_drive l cd cs)
    (d_OP_splitPath_dot_uscore_hash_selFP49_hash_drive r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitPath_dot_uscore_hash_selFP49_hash_drive z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_splitPath_dot_uscore_hash_selFP49_hash_drive e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.splitPath._#selFP49#drive" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.splitPath._#selFP49#drive"
    (showCons x1))

d_OP_splitPath_dot_uscore_hash_selFP50_hash_path :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitPath_dot_uscore_hash_selFP50_hash_path x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitPath_dot_uscore_hash_selFP50_hash_path l cd cs)
    (d_OP_splitPath_dot_uscore_hash_selFP50_hash_path r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitPath_dot_uscore_hash_selFP50_hash_path z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_splitPath_dot_uscore_hash_selFP50_hash_path e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.splitPath._#selFP50#path" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.splitPath._#selFP50#path"
    (showCons x1))

d_OP_splitPath_dot_f_dot_187 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_OP_splitPath_dot_f_dot_187 x1 cd cs = case x1 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x2 x3 -> let x4 = Curry_Prelude.d_C_apply
                                       (Curry_Prelude.d_C_break
                                       (d_C_isPathSeparator cd cs) cd cs) x1 cd
                                       cs
                                     x5 = d_OP_splitPath_dot_f_dot_187_dot_uscore_hash_selFP47_hash_a
                                       x4 cd cs
                                     x6 = d_OP_splitPath_dot_f_dot_187_dot_uscore_hash_selFP48_hash_b
                                       x4 cd cs
                                     x7 = Curry_Prelude.d_C_apply
                                       (Curry_Prelude.d_C_break
                                       (Curry_Prelude.d_OP_dot
                                       Curry_Prelude.d_C_not
                                       (d_C_isPathSeparator cd cs) cd cs) cd cs)
                                       x6 cd cs
                                     x8 = d_OP_splitPath_dot_f_dot_187_dot_uscore_hash_selFP45_hash_c
                                       x7 cd cs
                                     x9 = d_OP_splitPath_dot_f_dot_187_dot_uscore_hash_selFP46_hash_d
                                       x7 cd cs
    in Curry_Prelude.OP_Cons (Curry_Prelude.d_OP_plus_plus x5 x8 cd cs)
    (d_OP_splitPath_dot_f_dot_187 x9 cd cs)
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_splitPath_dot_f_dot_187 l cd cs) (d_OP_splitPath_dot_f_dot_187 r cd
    cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_splitPath_dot_f_dot_187 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x ->
    d_OP_splitPath_dot_f_dot_187 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath.splitPath.f.187" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.splitPath.f.187" (showCons x1))

d_OP_splitPath_dot_f_dot_187_dot_uscore_hash_selFP47_hash_a :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitPath_dot_f_dot_187_dot_uscore_hash_selFP47_hash_a x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitPath_dot_f_dot_187_dot_uscore_hash_selFP47_hash_a l cd cs)
    (d_OP_splitPath_dot_f_dot_187_dot_uscore_hash_selFP47_hash_a r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitPath_dot_f_dot_187_dot_uscore_hash_selFP47_hash_a z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_splitPath_dot_f_dot_187_dot_uscore_hash_selFP47_hash_a e cd x) $! addCs
    c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.splitPath.f.187._#selFP47#a" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.splitPath.f.187._#selFP47#a"
    (showCons x1))

d_OP_splitPath_dot_f_dot_187_dot_uscore_hash_selFP48_hash_b :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitPath_dot_f_dot_187_dot_uscore_hash_selFP48_hash_b x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitPath_dot_f_dot_187_dot_uscore_hash_selFP48_hash_b l cd cs)
    (d_OP_splitPath_dot_f_dot_187_dot_uscore_hash_selFP48_hash_b r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitPath_dot_f_dot_187_dot_uscore_hash_selFP48_hash_b z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_splitPath_dot_f_dot_187_dot_uscore_hash_selFP48_hash_b e cd x) $! addCs
    c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.splitPath.f.187._#selFP48#b" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.splitPath.f.187._#selFP48#b"
    (showCons x1))

d_OP_splitPath_dot_f_dot_187_dot_uscore_hash_selFP45_hash_c :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitPath_dot_f_dot_187_dot_uscore_hash_selFP45_hash_c x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitPath_dot_f_dot_187_dot_uscore_hash_selFP45_hash_c l cd cs)
    (d_OP_splitPath_dot_f_dot_187_dot_uscore_hash_selFP45_hash_c r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitPath_dot_f_dot_187_dot_uscore_hash_selFP45_hash_c z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_splitPath_dot_f_dot_187_dot_uscore_hash_selFP45_hash_c e cd x) $! addCs
    c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.splitPath.f.187._#selFP45#c" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.splitPath.f.187._#selFP45#c"
    (showCons x1))

d_OP_splitPath_dot_f_dot_187_dot_uscore_hash_selFP46_hash_d :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitPath_dot_f_dot_187_dot_uscore_hash_selFP46_hash_d x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_splitPath_dot_f_dot_187_dot_uscore_hash_selFP46_hash_d l cd cs)
    (d_OP_splitPath_dot_f_dot_187_dot_uscore_hash_selFP46_hash_d r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_splitPath_dot_f_dot_187_dot_uscore_hash_selFP46_hash_d z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_splitPath_dot_f_dot_187_dot_uscore_hash_selFP46_hash_d e cd x) $! addCs
    c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.splitPath.f.187._#selFP46#d" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.splitPath.f.187._#selFP46#d"
    (showCons x1))

d_C_splitDirectories :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C_splitDirectories x1 cd cs = let x2 = d_C_splitPath x1 cd cs
  in d_C__case_38 x1 x2 (Curry_Prelude.d_C_apply (d_C_hasDrive cd cs) x1 cd cs)
  cd cs

d_OP_splitDirectories_dot_g_dot_198 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_splitDirectories_dot_g_dot_198 x1 cd cs =
  let x2 = Curry_Prelude.d_C_takeWhile (Curry_Prelude.d_OP_dot
        Curry_Prelude.d_C_not (d_C_isPathSeparator cd cs) cd cs) x1 cd cs
  in d_C__case_37 x2 x1 (Curry_Prelude.d_C_null x2 cd cs) cd cs

d_OP_splitDirectories_dot_f_dot_198 :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_splitDirectories_dot_f_dot_198 x1 cd cs = Curry_Prelude.d_C_map
  d_OP_splitDirectories_dot_g_dot_198 x1 cd cs

d_C_joinPath :: Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_joinPath x1 cd cs = Curry_Prelude.d_C_foldr (acceptCs id d_C_combine)
  Curry_Prelude.OP_List x1 cd cs

d_C_equalFilePath :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_equalFilePath x1 x2 cd cs =
  Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket_hash_0_hash_hash
  Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
  (d_OP_equalFilePath_dot_f_dot_208 x1 cd cs) (d_OP_equalFilePath_dot_f_dot_208
  x2 cd cs) cd cs

d_OP_equalFilePath_dot_dropTrailSlash_dot_208 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_equalFilePath_dot_dropTrailSlash_dot_208 x1 cd cs = d_C__case_36 x1
  (Curry_Prelude.d_OP_amp_amp (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
  cd cs) (Curry_Prelude.d_C_length x1 cd cs) cd cs) (Curry_Prelude.C_Int (2)) cd
  cs) (Curry_Prelude.d_C_apply (d_C_isPathSeparator cd cs)
  (Data.Curry_List.d_C_last x1 cd cs) cd cs) cd cs) cd cs

d_OP_equalFilePath_dot_f_dot_208 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_equalFilePath_dot_f_dot_208 x1 cd cs = d_C__case_34 x1
  (System.Curry_Environment.d_C_isWindows cd cs) cd cs

d_C_makeRelative :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_makeRelative x1 x2 cd cs = d_C__case_32 x2 x1 (d_C_equalFilePath x1 x2 cd
  cs) cd cs

d_OP_makeRelative_dot_g_dot_214 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_makeRelative_dot_g_dot_214 x1 cd cs = let x2 = Curry_Prelude.d_OP_dollar
                                                 (Curry_Prelude.d_C_break
                                                 (d_C_isPathSeparator cd cs) cd
                                                 cs)
                                                 (Curry_Prelude.d_C_dropWhile
                                                 (d_C_isPathSeparator cd cs) x1
                                                 cd cs) cd cs
                                               x3 = d_OP_makeRelative_dot_g_dot_214_dot_uscore_hash_selFP52_hash_a
                                                 x2 cd cs
                                               x4 = d_OP_makeRelative_dot_g_dot_214_dot_uscore_hash_selFP53_hash_b
                                                 x2 cd cs
  in Curry_Prelude.OP_Tuple2 (Curry_Prelude.d_C_dropWhile (d_C_isPathSeparator
  cd cs) x3 cd cs) (Curry_Prelude.d_C_dropWhile (d_C_isPathSeparator cd cs) x4
  cd cs)

d_OP_makeRelative_dot_g_dot_214_dot_uscore_hash_selFP52_hash_a :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_makeRelative_dot_g_dot_214_dot_uscore_hash_selFP52_hash_a x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_makeRelative_dot_g_dot_214_dot_uscore_hash_selFP52_hash_a l cd cs)
    (d_OP_makeRelative_dot_g_dot_214_dot_uscore_hash_selFP52_hash_a r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_makeRelative_dot_g_dot_214_dot_uscore_hash_selFP52_hash_a z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_makeRelative_dot_g_dot_214_dot_uscore_hash_selFP52_hash_a e cd x) $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.makeRelative.g.214._#selFP52#a" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.makeRelative.g.214._#selFP52#a"
    (showCons x1))

d_OP_makeRelative_dot_g_dot_214_dot_uscore_hash_selFP53_hash_b :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_makeRelative_dot_g_dot_214_dot_uscore_hash_selFP53_hash_b x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_makeRelative_dot_g_dot_214_dot_uscore_hash_selFP53_hash_b l cd cs)
    (d_OP_makeRelative_dot_g_dot_214_dot_uscore_hash_selFP53_hash_b r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_makeRelative_dot_g_dot_214_dot_uscore_hash_selFP53_hash_b z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_makeRelative_dot_g_dot_214_dot_uscore_hash_selFP53_hash_b e cd x) $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.makeRelative.g.214._#selFP53#b" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.makeRelative.g.214._#selFP53#b"
    (showCons x1))

d_OP_makeRelative_dot_f_dot_214 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_makeRelative_dot_f_dot_214 x1 x2 x3 cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_dropWhile (d_C_isPathSeparator cd
    cs) x3 cd cs
  Curry_Prelude.OP_Cons x4 x5 -> let x6 = d_OP_makeRelative_dot_g_dot_214 x2 cd
                                       cs
                                     x7 = d_OP_makeRelative_dot_f_dot_214_dot_uscore_hash_selFP58_hash_x1
                                       x6 cd cs
                                     x8 = d_OP_makeRelative_dot_f_dot_214_dot_uscore_hash_selFP59_hash_x2
                                       x6 cd cs
                                     x9 = d_OP_makeRelative_dot_g_dot_214 x3 cd
                                       cs
                                     x10 = d_OP_makeRelative_dot_f_dot_214_dot_uscore_hash_selFP56_hash_y1
                                       x9 cd cs
                                     x11 = d_OP_makeRelative_dot_f_dot_214_dot_uscore_hash_selFP57_hash_y2
                                       x9 cd cs
    in d_C__case_29 x10 x7 x1 x11 x8 (d_C_equalFilePath x7 x10 cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_makeRelative_dot_f_dot_214 x1 l x3 cd cs)
    (d_OP_makeRelative_dot_f_dot_214 x1 r x3 cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_makeRelative_dot_f_dot_214 x1 z x3 cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x ->
    d_OP_makeRelative_dot_f_dot_214 x1 e x3 cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath.makeRelative.f.214" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "System.FilePath.makeRelative.f.214" (showCons x2))

d_OP_makeRelative_dot_f_dot_214_dot_uscore_hash_selFP58_hash_x1 :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_makeRelative_dot_f_dot_214_dot_uscore_hash_selFP58_hash_x1 x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_makeRelative_dot_f_dot_214_dot_uscore_hash_selFP58_hash_x1 l cd cs)
    (d_OP_makeRelative_dot_f_dot_214_dot_uscore_hash_selFP58_hash_x1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_makeRelative_dot_f_dot_214_dot_uscore_hash_selFP58_hash_x1 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_makeRelative_dot_f_dot_214_dot_uscore_hash_selFP58_hash_x1 e cd x) $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.makeRelative.f.214._#selFP58#x1" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.makeRelative.f.214._#selFP58#x1"
    (showCons x1))

d_OP_makeRelative_dot_f_dot_214_dot_uscore_hash_selFP59_hash_x2 :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_makeRelative_dot_f_dot_214_dot_uscore_hash_selFP59_hash_x2 x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_makeRelative_dot_f_dot_214_dot_uscore_hash_selFP59_hash_x2 l cd cs)
    (d_OP_makeRelative_dot_f_dot_214_dot_uscore_hash_selFP59_hash_x2 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_makeRelative_dot_f_dot_214_dot_uscore_hash_selFP59_hash_x2 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_makeRelative_dot_f_dot_214_dot_uscore_hash_selFP59_hash_x2 e cd x) $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.makeRelative.f.214._#selFP59#x2" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.makeRelative.f.214._#selFP59#x2"
    (showCons x1))

d_OP_makeRelative_dot_f_dot_214_dot_uscore_hash_selFP56_hash_y1 :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_makeRelative_dot_f_dot_214_dot_uscore_hash_selFP56_hash_y1 x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_makeRelative_dot_f_dot_214_dot_uscore_hash_selFP56_hash_y1 l cd cs)
    (d_OP_makeRelative_dot_f_dot_214_dot_uscore_hash_selFP56_hash_y1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_makeRelative_dot_f_dot_214_dot_uscore_hash_selFP56_hash_y1 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_makeRelative_dot_f_dot_214_dot_uscore_hash_selFP56_hash_y1 e cd x) $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.makeRelative.f.214._#selFP56#y1" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.makeRelative.f.214._#selFP56#y1"
    (showCons x1))

d_OP_makeRelative_dot_f_dot_214_dot_uscore_hash_selFP57_hash_y2 :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_makeRelative_dot_f_dot_214_dot_uscore_hash_selFP57_hash_y2 x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_makeRelative_dot_f_dot_214_dot_uscore_hash_selFP57_hash_y2 l cd cs)
    (d_OP_makeRelative_dot_f_dot_214_dot_uscore_hash_selFP57_hash_y2 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_makeRelative_dot_f_dot_214_dot_uscore_hash_selFP57_hash_y2 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_makeRelative_dot_f_dot_214_dot_uscore_hash_selFP57_hash_y2 e cd x) $!
    addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.makeRelative.f.214._#selFP57#y2" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.makeRelative.f.214._#selFP57#y2"
    (showCons x1))

d_OP_makeRelative_dot_dropAbs_dot_214 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_makeRelative_dot_dropAbs_dot_214 x1 cd cs = case x1 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_apply (d_C_dropDrive cd cs)
    Curry_Prelude.OP_List cd cs
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_28 x2 x3 (Curry_Prelude.d_C_apply
    (d_C_isPathSeparator cd cs) x2 cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_makeRelative_dot_dropAbs_dot_214 l cd cs)
    (d_OP_makeRelative_dot_dropAbs_dot_214 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_makeRelative_dot_dropAbs_dot_214 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x ->
    d_OP_makeRelative_dot_dropAbs_dot_214 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath.makeRelative.dropAbs.214" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.makeRelative.dropAbs.214"
    (showCons x1))

d_OP_makeRelative_dot_takeAbs_dot_214 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_makeRelative_dot_takeAbs_dot_214 x1 cd cs = case x1 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_OP_dollar (Curry_Prelude.d_C_map
    d_OP_makeRelative_dot_takeAbs_dot_214_dot_uscore_hash_lambda10)
    (Curry_Prelude.d_C_apply (d_C_takeDrive cd cs) Curry_Prelude.OP_List cd cs)
    cd cs
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_26 x2 x1 (Curry_Prelude.d_C_apply
    (d_C_isPathSeparator cd cs) x2 cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_makeRelative_dot_takeAbs_dot_214 l cd cs)
    (d_OP_makeRelative_dot_takeAbs_dot_214 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_makeRelative_dot_takeAbs_dot_214 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x ->
    d_OP_makeRelative_dot_takeAbs_dot_214 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath.makeRelative.takeAbs.214" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.makeRelative.takeAbs.214"
    (showCons x1))

d_OP_makeRelative_dot_takeAbs_dot_214_dot_uscore_hash_lambda10 :: Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.C_Char
d_OP_makeRelative_dot_takeAbs_dot_214_dot_uscore_hash_lambda10 x1 cd cs =
  d_C__case_24 x1 (Curry_Prelude.d_C_apply (d_C_isPathSeparator cd cs) x1 cd cs)
  cd cs

d_OP_makeRelative_dot_takeAbs_dot_214_dot_uscore_hash_lambda11 :: Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.C_Char
d_OP_makeRelative_dot_takeAbs_dot_214_dot_uscore_hash_lambda11 x1 cd cs =
  d_C__case_23 x1 (Curry_Prelude.d_C_apply (d_C_isPathSeparator cd cs) x1 cd cs)
  cd cs

d_C_normalise :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_normalise x1 cd cs = let x2 = d_C_splitDrive x1 cd cs
                             x3 = d_OP_normalise_dot_uscore_hash_selFP61_hash_drv
                               x2 cd cs
                             x4 = d_OP_normalise_dot_uscore_hash_selFP62_hash_pth
                               x2 cd cs
                             x5 = Curry_Prelude.d_OP_dot d_C_joinPath
                               (Curry_Prelude.d_OP_dot
                               d_OP_normalise_dot_dropDots_dot_239
                               (Curry_Prelude.d_OP_dot d_C_splitDirectories
                               d_OP_normalise_dot_propSep_dot_239 cd cs) cd cs)
                               cd cs
  in Curry_Prelude.d_OP_plus_plus (d_C_joinDrive (d_C_normaliseDrive x3 cd cs)
  (Curry_Prelude.d_C_apply x5 x4 cd cs) cd cs) (d_C__case_22 x4
  (d_OP_normalise_dot_isDirPath_dot_239 x4 cd cs) cd cs) cd cs

d_OP_normalise_dot_uscore_hash_selFP61_hash_drv :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_normalise_dot_uscore_hash_selFP61_hash_drv x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_normalise_dot_uscore_hash_selFP61_hash_drv l cd cs)
    (d_OP_normalise_dot_uscore_hash_selFP61_hash_drv r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_normalise_dot_uscore_hash_selFP61_hash_drv z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_normalise_dot_uscore_hash_selFP61_hash_drv e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.normalise._#selFP61#drv" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.normalise._#selFP61#drv" (showCons
    x1))

d_OP_normalise_dot_uscore_hash_selFP62_hash_pth :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_normalise_dot_uscore_hash_selFP62_hash_pth x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_normalise_dot_uscore_hash_selFP62_hash_pth l cd cs)
    (d_OP_normalise_dot_uscore_hash_selFP62_hash_pth r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_normalise_dot_uscore_hash_selFP62_hash_pth z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_normalise_dot_uscore_hash_selFP62_hash_pth e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.normalise._#selFP62#pth" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.normalise._#selFP62#pth" (showCons
    x1))

d_OP_normalise_dot_lastSep_dot_239 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_OP_normalise_dot_lastSep_dot_239 x1 cd cs = Curry_Prelude.d_OP_amp_amp
  (Curry_Prelude.d_C_not (Curry_Prelude.d_C_null x1 cd cs) cd cs)
  (Curry_Prelude.d_C_apply (d_C_isPathSeparator cd cs) (Data.Curry_List.d_C_last
  x1 cd cs) cd cs) cd cs

d_OP_normalise_dot_isDirPath_dot_239 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_OP_normalise_dot_isDirPath_dot_239 x1 cd cs = Curry_Prelude.d_OP_bar_bar
  (d_OP_normalise_dot_lastSep_dot_239 x1 cd cs) (Curry_Prelude.d_OP_amp_amp
  (Curry_Prelude.d_C_not (Curry_Prelude.d_C_null x1 cd cs) cd cs)
  (Curry_Prelude.d_OP_amp_amp
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
  (Data.Curry_List.d_C_last x1 cd cs) (Curry_Prelude.C_Char '.'#) cd cs)
  (d_OP_normalise_dot_lastSep_dot_239 (Data.Curry_List.d_C_init x1 cd cs) cd cs)
  cd cs) cd cs) cd cs

d_OP_normalise_dot_propSep_dot_239 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_normalise_dot_propSep_dot_239 x1 cd cs = case x1 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x2 x3 -> d_C__case_21 x2 x1 x3 cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_normalise_dot_propSep_dot_239 l cd cs)
    (d_OP_normalise_dot_propSep_dot_239 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_normalise_dot_propSep_dot_239 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x ->
    d_OP_normalise_dot_propSep_dot_239 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath.normalise.propSep.239" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.normalise.propSep.239" (showCons
    x1))

d_OP_normalise_dot_dropDots_tick_dot_239 :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_normalise_dot_dropDots_tick_dot_239 x1 x2 cd cs = case x2 of
  Curry_Prelude.OP_List -> Curry_Prelude.d_C_apply (Curry_Prelude.d_C_reverse cd
    cs) x1 cd cs
  Curry_Prelude.OP_Cons x3 x4 -> d_C__case_15 x3 x4 x1
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket_hash_0_hash_hash
    Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
    x3 (Curry_Prelude.toCurryString ".") cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i
    (d_OP_normalise_dot_dropDots_tick_dot_239 x1 l cd cs)
    (d_OP_normalise_dot_dropDots_tick_dot_239 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z ->
    d_OP_normalise_dot_dropDots_tick_dot_239 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x ->
    d_OP_normalise_dot_dropDots_tick_dot_239 x1 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath.normalise.dropDots'.239" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.FilePath.normalise.dropDots'.239" (showCons
    x2))

d_OP_normalise_dot_dropDots_dot_239 :: Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_OP_normalise_dot_dropDots_dot_239 x1 cd cs = d_C__case_13 x1
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_all (Curry_Prelude.d_C_flip
  (acceptCs id
  (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket_hash_0_hash_hash
  Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash))
  (Curry_Prelude.toCurryString ".")) cd cs) x1 cd cs) cd cs

d_C_normaliseDrive :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_normaliseDrive x1 cd cs = let x2 = Curry_Prelude.d_C_map
                                    d_OP_normaliseDrive_dot_repSlash_dot_259 x1
                                    cd cs
  in d_C__case_11 x2 x1 (System.Curry_Environment.d_C_isPosix cd cs) cd cs

d_OP_normaliseDrive_dot_repSlash_dot_259 :: Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_Char
d_OP_normaliseDrive_dot_repSlash_dot_259 x1 cd cs = d_C__case_8 x1
  (Curry_Prelude.d_C_apply (d_C_isPathSeparator cd cs) x1 cd cs) cd cs

d_C_badCharacters :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C_badCharacters cd cs = Curry_Prelude.toCurryString ":*?><|\""

d_C_badElements :: Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C_badElements cd cs = Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString
  "CON") (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "PRN")
  (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "AUX")
  (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "NUL")
  (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "COM1")
  (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "COM2")
  (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "COM3")
  (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "COM4")
  (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "COM5")
  (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "COM6")
  (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "COM7")
  (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "COM8")
  (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "COM9")
  (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "LPT1")
  (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "LPT2")
  (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "LPT3")
  (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "LPT4")
  (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "LPT5")
  (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "LPT6")
  (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "LPT7")
  (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "LPT8")
  (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "LPT9")
  (Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString "CLOCK$")
  Curry_Prelude.OP_List))))))))))))))))))))))

d_C_isValid :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C_isValid x1 cd cs = case x1 of
  Curry_Prelude.OP_List -> Curry_Prelude.C_False
  Curry_Prelude.OP_Cons x2 x3 -> let x4 = Curry_Prelude.d_C_apply (d_C_dropDrive
                                       cd cs) x1 cd cs
    in d_C__case_7 x1 x4 (System.Curry_Environment.d_C_isPosix cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_isValid l cd cs)
    (d_C_isValid r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_isValid z cd
    cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C_isValid e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath.isValid" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.isValid" (showCons x1))

d_OP_isValid_dot_f_dot_272 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_OP_isValid_dot_f_dot_272 x1 cd cs = Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_elem
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket_hash_0_hash_hash
  Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash)
  (Curry_Prelude.d_C_map Data.Curry_Char.d_C_toUpper (Curry_Prelude.d_C_apply
  (d_C_dropExtensions cd cs) x1 cd cs) cd cs) cd cs) (d_C_badElements cd cs) cd
  cs

d_C_makeValid :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C_makeValid x1 cd cs = case x1 of
  Curry_Prelude.OP_List -> Curry_Prelude.toCurryString "_"
  Curry_Prelude.OP_Cons x2 x3 -> let x4 = d_C_splitDrive x1 cd cs
                                     x5 = d_OP_makeValid_dot_uscore_hash_selFP70_hash_drv
                                       x4 cd cs
                                     x6 = d_OP_makeValid_dot_uscore_hash_selFP71_hash_pth
                                       x4 cd cs
    in d_C__case_5 x1 x6 x5 (System.Curry_Environment.d_C_isPosix cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C_makeValid l cd cs)
    (d_C_makeValid r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C_makeValid z
    cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C_makeValid e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath.makeValid" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.makeValid" (showCons x1))

d_OP_makeValid_dot_uscore_hash_selFP70_hash_drv :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_makeValid_dot_uscore_hash_selFP70_hash_drv x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_makeValid_dot_uscore_hash_selFP70_hash_drv l cd cs)
    (d_OP_makeValid_dot_uscore_hash_selFP70_hash_drv r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_makeValid_dot_uscore_hash_selFP70_hash_drv z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_makeValid_dot_uscore_hash_selFP70_hash_drv e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.makeValid._#selFP70#drv" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.makeValid._#selFP70#drv" (showCons
    x1))

d_OP_makeValid_dot_uscore_hash_selFP71_hash_pth :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_makeValid_dot_uscore_hash_selFP71_hash_pth x1 cd cs = case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_makeValid_dot_uscore_hash_selFP71_hash_pth l cd cs)
    (d_OP_makeValid_dot_uscore_hash_selFP71_hash_pth r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_makeValid_dot_uscore_hash_selFP71_hash_pth z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_makeValid_dot_uscore_hash_selFP71_hash_pth e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.makeValid._#selFP71#pth" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.makeValid._#selFP71#pth" (showCons
    x1))

d_OP_makeValid_dot_f_dot_281 :: Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Char
d_OP_makeValid_dot_f_dot_281 x1 cd cs = d_C__case_2 x1 (Curry_Prelude.d_C_apply
  (Curry_Prelude.d_C_elem
  Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
  x1 cd cs) (d_C_badCharacters cd cs) cd cs) cd cs

d_OP_makeValid_dot_validChars_dot_281 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_makeValid_dot_validChars_dot_281 x1 cd cs = Curry_Prelude.d_C_map
  d_OP_makeValid_dot_f_dot_281 x1 cd cs

d_OP_makeValid_dot_h_dot_281 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_makeValid_dot_h_dot_281 x1 cd cs = let x2 = d_C_splitExtensions x1 cd cs
                                            x3 = d_OP_makeValid_dot_h_dot_281_dot_uscore_hash_selFP65_hash_a
                                              x2 cd cs
                                            x4 = d_OP_makeValid_dot_h_dot_281_dot_uscore_hash_selFP66_hash_b
                                              x2 cd cs
  in d_C__case_0 x3 x1 x4 (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_elem
  (Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_lbracket_rbracket_hash_0_hash_hash
  Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash)
  (Curry_Prelude.d_C_map Data.Curry_Char.d_C_toUpper x3 cd cs) cd cs)
  (d_C_badElements cd cs) cd cs) cd cs

d_OP_makeValid_dot_h_dot_281_dot_uscore_hash_selFP65_hash_a :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_makeValid_dot_h_dot_281_dot_uscore_hash_selFP65_hash_a x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_makeValid_dot_h_dot_281_dot_uscore_hash_selFP65_hash_a l cd cs)
    (d_OP_makeValid_dot_h_dot_281_dot_uscore_hash_selFP65_hash_a r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_makeValid_dot_h_dot_281_dot_uscore_hash_selFP65_hash_a z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_makeValid_dot_h_dot_281_dot_uscore_hash_selFP65_hash_a e cd x) $! addCs
    c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.makeValid.h.281._#selFP65#a" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.makeValid.h.281._#selFP65#a"
    (showCons x1))

d_OP_makeValid_dot_h_dot_281_dot_uscore_hash_selFP66_hash_b :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_makeValid_dot_h_dot_281_dot_uscore_hash_selFP66_hash_b x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_makeValid_dot_h_dot_281_dot_uscore_hash_selFP66_hash_b l cd cs)
    (d_OP_makeValid_dot_h_dot_281_dot_uscore_hash_selFP66_hash_b r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_makeValid_dot_h_dot_281_dot_uscore_hash_selFP66_hash_b z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_makeValid_dot_h_dot_281_dot_uscore_hash_selFP66_hash_b e cd x) $! addCs
    c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.makeValid.h.281._#selFP66#b" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.makeValid.h.281._#selFP66#b"
    (showCons x1))

d_OP_makeValid_dot_g_dot_281 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_OP_makeValid_dot_g_dot_281 x1 cd cs = let x2 = Curry_Prelude.d_OP_dollar
                                              (Curry_Prelude.d_C_span
                                              (d_C_isPathSeparator cd cs))
                                              (Curry_Prelude.d_C_apply
                                              (Curry_Prelude.d_C_reverse cd cs)
                                              x1 cd cs) cd cs
                                            x3 = d_OP_makeValid_dot_g_dot_281_dot_uscore_hash_selFP68_hash_a
                                              x2 cd cs
                                            x4 = d_OP_makeValid_dot_g_dot_281_dot_uscore_hash_selFP69_hash_b
                                              x2 cd cs
  in Curry_Prelude.d_OP_plus_plus (d_OP_makeValid_dot_h_dot_281
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_reverse cd cs) x4 cd cs) cd cs)
  (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_reverse cd cs) x3 cd cs) cd cs

d_OP_makeValid_dot_g_dot_281_dot_uscore_hash_selFP68_hash_a :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_makeValid_dot_g_dot_281_dot_uscore_hash_selFP68_hash_a x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x2
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_makeValid_dot_g_dot_281_dot_uscore_hash_selFP68_hash_a l cd cs)
    (d_OP_makeValid_dot_g_dot_281_dot_uscore_hash_selFP68_hash_a r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_makeValid_dot_g_dot_281_dot_uscore_hash_selFP68_hash_a z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_makeValid_dot_g_dot_281_dot_uscore_hash_selFP68_hash_a e cd x) $! addCs
    c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.makeValid.g.281._#selFP68#a" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.makeValid.g.281._#selFP68#a"
    (showCons x1))

d_OP_makeValid_dot_g_dot_281_dot_uscore_hash_selFP69_hash_b :: Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_makeValid_dot_g_dot_281_dot_uscore_hash_selFP69_hash_b x1 cd cs =
  case x1 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> x3
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i
    (d_OP_makeValid_dot_g_dot_281_dot_uscore_hash_selFP69_hash_b l cd cs)
    (d_OP_makeValid_dot_g_dot_281_dot_uscore_hash_selFP69_hash_b r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z ->
    d_OP_makeValid_dot_g_dot_281_dot_uscore_hash_selFP69_hash_b z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x ->
    d_OP_makeValid_dot_g_dot_281_dot_uscore_hash_selFP69_hash_b e cd x) $! addCs
    c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath.makeValid.g.281._#selFP69#b" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath.makeValid.g.281._#selFP69#b"
    (showCons x1))

d_OP_makeValid_dot_validElements_dot_281 :: Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_OP_makeValid_dot_validElements_dot_281 x1 cd cs = Curry_Prelude.d_OP_dollar
  d_C_joinPath (Curry_Prelude.d_OP_dollar (Curry_Prelude.d_C_map
  d_OP_makeValid_dot_g_dot_281) (d_C_splitPath x1 cd cs) cd cs) cd cs

d_C_isRelative :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_isRelative cd cs = Curry_Prelude.d_OP_dot d_C_isRelativeDrive (d_C_takeDrive
  cd cs) cd cs

d_C_isRelativeDrive :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_C_isRelativeDrive x1 cd cs = Curry_Prelude.d_OP_bar_bar
  (Curry_Prelude.d_C_null x1 cd cs) (Curry_Prelude.d_C_maybe
  Curry_Prelude.C_False (Curry_Prelude.d_OP_dot Curry_Prelude.d_C_not
  (Curry_Prelude.d_OP_dot (d_C_isPathSeparator cd cs) (Curry_Prelude.d_OP_dot
  Data.Curry_List.d_C_last Curry_Prelude.d_C_fst cd cs) cd cs) cd cs)
  (d_C_readDriveLetter x1 cd cs) cd cs) cd cs

d_C_isAbsolute :: Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C_isAbsolute cd cs = Curry_Prelude.d_OP_dot Curry_Prelude.d_C_not
  (d_C_isRelative cd cs) cd cs

d_C__case_100 :: Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_Char
d_C__case_100 x1 cd cs = case x1 of
  Curry_Prelude.C_True -> Curry_Prelude.C_Char '\\'#
  Curry_Prelude.C_False -> Curry_Prelude.C_Char '/'#
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_100 l cd cs)
    (d_C__case_100 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_100 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_100 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_100" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath._case_100" (showCons x1))

d_C__case_99 :: Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_99 x1 cd cs = case x1 of
  Curry_Prelude.C_True -> Curry_Prelude.toCurryString "\\/"
  Curry_Prelude.C_False -> Curry_Prelude.toCurryString "/"
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_99 l cd cs)
    (d_C__case_99 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_99 z cd
    cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_99 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_99" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath._case_99" (showCons x1))

d_C__case_98 :: Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_Char
d_C__case_98 x1 cd cs = case x1 of
  Curry_Prelude.C_True -> Curry_Prelude.C_Char ';'#
  Curry_Prelude.C_False -> Curry_Prelude.C_Char ':'#
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_98 l cd cs)
    (d_C__case_98 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_98 z cd
    cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_98 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_98" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath._case_98" (showCons x1))

d_C__case_97 :: Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_97 x1 cd cs = case x1 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString
    ".") Curry_Prelude.OP_List
  Curry_Prelude.C_False -> Curry_Prelude.OP_List
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_97 l cd cs)
    (d_C__case_97 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_97 z cd
    cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_97 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_97" [show x1] info)
  _ -> failCons cd (consFail "System.FilePath._case_97" (showCons x1))

d_C__case_96 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_96 x1 x4 cd cs = case x4 of
  Curry_Prelude.OP_Tuple2 x2 x3 -> d_C__case_95 x2 x3 cd cs
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C__case_96 x1 l cd cs)
    (d_C__case_96 x1 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C__case_96
    x1 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x -> d_C__case_96 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath._case_96" [show x1, show x4] info)
  _ -> failCons cd (consFail "System.FilePath._case_96" (showCons x4))

d_C__case_95 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_95 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_List -> d_OP_splitSearchPath_dot_g_dot_16 x2 cd cs
  Curry_Prelude.OP_Cons x4 x5 -> Curry_Prelude.d_OP_plus_plus
    (d_OP_splitSearchPath_dot_g_dot_16 x2 cd cs)
    (d_OP_splitSearchPath_dot_f_dot_16 x5 cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_95 x2 l cd cs)
    (d_C__case_95 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_95 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C__case_95 x2 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath._case_95" [show x2, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_95" (showCons x3))

d_C__case_94 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_94 x6 x3 x1 x7 cd cs = case x7 of
  Curry_Prelude.OP_List -> Curry_Prelude.OP_Tuple2 x1 Curry_Prelude.OP_List
  Curry_Prelude.OP_Cons x8 x9 -> Curry_Prelude.OP_Tuple2
    (Curry_Prelude.d_OP_plus_plus x3 (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_reverse cd cs) x9 cd cs) cd cs) (Curry_Prelude.OP_Cons x8
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_reverse cd cs) x6 cd cs))
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_94 x6 x3 x1 l cd
    cs) (d_C__case_94 x6 x3 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_94 x6
    x3 x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C__case_94 x6 x3
    x1 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath._case_94" [show x6, show x3, show x1, show x7] info)
  _ -> failCons cd (consFail "System.FilePath._case_94" (showCons x7))

d_C__case_93 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_93 x3 x2 x7 x8 cd cs = case x8 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_plus_plus x7 x2 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_OP_plus_plus x7
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.OP_Cons (d_C_extSeparator cd
    cs) Curry_Prelude.OP_List) x2 cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_93 x3 x2 x7 l cd
    cs) (d_C__case_93 x3 x2 x7 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_93 x3
    x2 x7 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_93 x3 x2
    x7 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_93" [show x3, show x2, show x7, show x8] info)
  _ -> failCons cd (consFail "System.FilePath._case_93" (showCons x8))

d_C__case_92 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Bool
d_C__case_92 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_91 x4 x2 x3
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
    x4 (Curry_Prelude.C_Char '.'#) cd cs) cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.d_OP_dollar
    (Data.Curry_List.d_C_isSuffixOf
    Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
    (Curry_Prelude.OP_Cons (Curry_Prelude.C_Char '.'#) x3))
    (Curry_Prelude.d_C_apply (d_C_takeExtensions cd cs) x2 cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_92 x2 l cd cs)
    (d_C__case_92 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_92 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C__case_92 x2 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath._case_92" [show x2, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_92" (showCons x3))

d_C__case_91 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_91 x4 x2 x3 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_dollar
    (Data.Curry_List.d_C_isSuffixOf
    Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
    x3) (Curry_Prelude.d_C_apply (d_C_takeExtensions cd cs) x2 cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_OP_dollar
    (Data.Curry_List.d_C_isSuffixOf
    Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
    (Curry_Prelude.OP_Cons (Curry_Prelude.C_Char '.'#) x3))
    (Curry_Prelude.d_C_apply (d_C_takeExtensions cd cs) x2 cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_91 x4 x2 x3 l cd
    cs) (d_C__case_91 x4 x2 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_91 x4
    x2 x3 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_91 x4 x2
    x3 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_91" [show x4, show x2, show x3, show x5] info)
  _ -> failCons cd (consFail "System.FilePath._case_91" (showCons x5))

d_C__case_90 :: Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C__case_90 x2 x3 x4 x1 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_span (Curry_Prelude.d_C_flip
    (acceptCs id
    Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash)
    (Curry_Prelude.C_Char '/'#)) x1 cd cs
  Curry_Prelude.C_False -> d_C__case_89 x2 x3 x4 x1 (Data.Curry_Maybe.d_C_isJust
    x2 cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_90 x2 x3 x4 x1 l
    cd cs) (d_C__case_90 x2 x3 x4 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_90 x2
    x3 x4 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_90 x2 x3
    x4 x1 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_90" [show x2, show x3, show x4, show x1, show x5]
    info)
  _ -> failCons cd (consFail "System.FilePath._case_90" (showCons x5))

d_C__case_89 :: Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C__case_89 x2 x3 x4 x1 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Data.Curry_Maybe.d_C_fromJust x2 cd cs
  Curry_Prelude.C_False -> d_C__case_88 x3 x4 x1 (Data.Curry_Maybe.d_C_isJust x3
    cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_89 x2 x3 x4 x1 l
    cd cs) (d_C__case_89 x2 x3 x4 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_89 x2
    x3 x4 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_89 x2 x3
    x4 x1 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_89" [show x2, show x3, show x4, show x1, show x5]
    info)
  _ -> failCons cd (consFail "System.FilePath._case_89" (showCons x5))

d_C__case_88 :: Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C__case_88 x3 x4 x1 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Data.Curry_Maybe.d_C_fromJust x3 cd cs
  Curry_Prelude.C_False -> d_C__case_87 x4 x1 (Data.Curry_Maybe.d_C_isJust x4 cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_88 x3 x4 x1 l cd
    cs) (d_C__case_88 x3 x4 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_88 x3
    x4 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_88 x3 x4
    x1 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_88" [show x3, show x4, show x1, show x5] info)
  _ -> failCons cd (consFail "System.FilePath._case_88" (showCons x5))

d_C__case_87 :: Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C__case_87 x4 x1 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Data.Curry_Maybe.d_C_fromJust x4 cd cs
  Curry_Prelude.C_False -> d_C__case_86 x1 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_87 x4 x1 l cd cs)
    (d_C__case_87 x4 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_87 x4
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_87 x4 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_87" [show x4, show x1, show x5] info)
  _ -> failCons cd (consFail "System.FilePath._case_87" (showCons x5))

d_C__case_86 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)
d_C__case_86 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Tuple2 Curry_Prelude.OP_List x1
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_86 x1 l cd cs)
    (d_C__case_86 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_86 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_86 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_86" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.FilePath._case_86" (showCons x2))

d_C__case_85 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_85 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_84 x4 x2 x5 cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.C_Nothing
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_85 x2 l cd cs)
    (d_C__case_85 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_85 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C__case_85 x2 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath._case_85" [show x2, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_85" (showCons x3))

d_C__case_84 :: Curry_Prelude.C_Char -> Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_84 x4 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_83 x6 x7 x4 x2
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
    x6 (Curry_Prelude.C_Char '?'#) cd cs) cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.C_Nothing
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_84 x4 x2 l cd
    cs) (d_C__case_84 x4 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_84 x4
    x2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C__case_84 x4 x2
    e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath._case_84" [show x4, show x2, show x5] info)
  _ -> failCons cd (consFail "System.FilePath._case_84" (showCons x5))

d_C__case_83 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Char -> Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_83 x6 x7 x4 x2 x8 cd cs = case x8 of
  Curry_Prelude.C_True -> d_C__case_82 x4 x2 x7 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.C_Nothing
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_83 x6 x7 x4 x2 l
    cd cs) (d_C__case_83 x6 x7 x4 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_83 x6
    x7 x4 x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_83 x6 x7
    x4 x2 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_83" [show x6, show x7, show x4, show x2, show x8]
    info)
  _ -> failCons cd (consFail "System.FilePath._case_83" (showCons x8))

d_C__case_82 :: Curry_Prelude.C_Char -> Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_82 x4 x2 x7 cd cs = case x7 of
  Curry_Prelude.OP_Cons x8 x9 -> d_C__case_81 x8 x4 x2 x9
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_all (d_C_isPathSeparator cd cs)
    cd cs) (Curry_Prelude.OP_Cons x2 (Curry_Prelude.OP_Cons x4
    (Curry_Prelude.OP_Cons x8 Curry_Prelude.OP_List))) cd cs) cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.C_Nothing
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_82 x4 x2 l cd
    cs) (d_C__case_82 x4 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_82 x4
    x2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C__case_82 x4 x2
    e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath._case_82" [show x4, show x2, show x7] info)
  _ -> failCons cd (consFail "System.FilePath._case_82" (showCons x7))

d_C__case_81 :: Curry_Prelude.C_Char -> Curry_Prelude.C_Char
  -> Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_81 x8 x4 x2 x9 x11 cd cs = case x11 of
  Curry_Prelude.C_True -> let x10 = d_C__case_72 x9 x8 x4 x2
                                (d_C_readDriveLetter x9 cd cs) cd cs
    in d_C__case_80 x9 x10 x8 x4 x2 (Curry_Prelude.d_C_map
    Data.Curry_Char.d_C_toUpper x9 cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.C_Nothing
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_81 x8 x4 x2 x9 l
    cd cs) (d_C__case_81 x8 x4 x2 x9 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_81 x8
    x4 x2 x9 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_81 x8 x4
    x2 x9 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_81" [show x8, show x4, show x2, show x9, show x11]
    info)
  _ -> failCons cd (consFail "System.FilePath._case_81" (showCons x11))

d_C__case_72 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Char -> Curry_Prelude.C_Char -> Curry_Prelude.C_Char
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Cover
  -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C__case_72 x9 x8 x4 x2 x12 cd cs = case x12 of
  Curry_Prelude.C_Just x11 -> d_C__case_71 x8 x4 x2 x11 cd cs
  Curry_Prelude.C_Nothing -> Curry_Prelude.C_Nothing
  Curry_Prelude.Choice_C_Maybe d i l r -> narrow d i (d_C__case_72 x9 x8 x4 x2 l
    cd cs) (d_C__case_72 x9 x8 x4 x2 r cd cs)
  Curry_Prelude.Choices_C_Maybe d i xs -> narrows cs d i (\z -> d_C__case_72 x9
    x8 x4 x2 z cd cs) xs
  Curry_Prelude.Guard_C_Maybe d c e -> guardCons d c ((\x -> d_C__case_72 x9 x8
    x4 x2 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Maybe d info -> failCons d (traceFail
    "System.FilePath._case_72" [show x9, show x8, show x4, show x2, show x12]
    info)
  _ -> failCons cd (consFail "System.FilePath._case_72" (showCons x12))

d_C__case_71 :: Curry_Prelude.C_Char -> Curry_Prelude.C_Char
  -> Curry_Prelude.C_Char -> Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char) -> Cover
  -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C__case_71 x8 x4 x2 x11 cd cs = case x11 of
  Curry_Prelude.OP_Tuple2 x12 x13 -> Curry_Prelude.C_Just
    (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Cons x2 (Curry_Prelude.OP_Cons x4
    (Curry_Prelude.OP_Cons (Curry_Prelude.C_Char '?'#) (Curry_Prelude.OP_Cons x8
    x12)))) x13)
  Curry_Prelude.Choice_OP_Tuple2 d i l r -> narrow d i (d_C__case_71 x8 x4 x2 l
    cd cs) (d_C__case_71 x8 x4 x2 r cd cs)
  Curry_Prelude.Choices_OP_Tuple2 d i xs -> narrows cs d i (\z -> d_C__case_71
    x8 x4 x2 z cd cs) xs
  Curry_Prelude.Guard_OP_Tuple2 d c e -> guardCons d c ((\x -> d_C__case_71 x8
    x4 x2 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_Tuple2 d info -> failCons d (traceFail
    "System.FilePath._case_71" [show x8, show x4, show x2, show x11] info)
  _ -> failCons cd (consFail "System.FilePath._case_71" (showCons x11))

d_C__case_80 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
  -> Curry_Prelude.C_Char -> Curry_Prelude.C_Char -> Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_80 x9 x10 x8 x4 x2 x16 cd cs = case x16 of
  Curry_Prelude.OP_Cons x14 x15 -> d_C__case_79 x14 x10 x15 x9 x8 x4 x2
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
    x14 (Curry_Prelude.C_Char 'U'#) cd cs) cd cs
  Curry_Prelude.OP_List -> x10
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_80 x9 x10 x8 x4
    x2 l cd cs) (d_C__case_80 x9 x10 x8 x4 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_80 x9
    x10 x8 x4 x2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C__case_80 x9 x10
    x8 x4 x2 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath._case_80" [show x9, show x10, show x8, show x4, show x2
    , show x16] info)
  _ -> failCons cd (consFail "System.FilePath._case_80" (showCons x16))

d_C__case_79 :: Curry_Prelude.C_Char -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Char -> Curry_Prelude.C_Char -> Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_79 x14 x10 x15 x9 x8 x4 x2 x16 cd cs = case x16 of
  Curry_Prelude.C_True -> d_C__case_78 x10 x9 x8 x4 x2 x15 cd cs
  Curry_Prelude.C_False -> x10
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_79 x14 x10 x15 x9
    x8 x4 x2 l cd cs) (d_C__case_79 x14 x10 x15 x9 x8 x4 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_79 x14
    x10 x15 x9 x8 x4 x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_79 x14 x10
    x15 x9 x8 x4 x2 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_79" [show x14, show x10, show x15, show x9, show x8
    , show x4, show x2, show x16] info)
  _ -> failCons cd (consFail "System.FilePath._case_79" (showCons x16))

d_C__case_78 :: Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Char -> Curry_Prelude.C_Char -> Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_78 x10 x9 x8 x4 x2 x15 cd cs = case x15 of
  Curry_Prelude.OP_Cons x16 x17 -> d_C__case_77 x16 x10 x17 x9 x8 x4 x2
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
    x16 (Curry_Prelude.C_Char 'N'#) cd cs) cd cs
  Curry_Prelude.OP_List -> x10
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_78 x10 x9 x8 x4
    x2 l cd cs) (d_C__case_78 x10 x9 x8 x4 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_78 x10
    x9 x8 x4 x2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C__case_78 x10 x9
    x8 x4 x2 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath._case_78" [show x10, show x9, show x8, show x4, show x2
    , show x15] info)
  _ -> failCons cd (consFail "System.FilePath._case_78" (showCons x15))

d_C__case_77 :: Curry_Prelude.C_Char -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Char -> Curry_Prelude.C_Char -> Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_77 x16 x10 x17 x9 x8 x4 x2 x18 cd cs = case x18 of
  Curry_Prelude.C_True -> d_C__case_76 x10 x9 x8 x4 x2 x17 cd cs
  Curry_Prelude.C_False -> x10
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_77 x16 x10 x17 x9
    x8 x4 x2 l cd cs) (d_C__case_77 x16 x10 x17 x9 x8 x4 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_77 x16
    x10 x17 x9 x8 x4 x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_77 x16 x10
    x17 x9 x8 x4 x2 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_77" [show x16, show x10, show x17, show x9, show x8
    , show x4, show x2, show x18] info)
  _ -> failCons cd (consFail "System.FilePath._case_77" (showCons x18))

d_C__case_76 :: Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Char -> Curry_Prelude.C_Char -> Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_76 x10 x9 x8 x4 x2 x17 cd cs = case x17 of
  Curry_Prelude.OP_Cons x18 x19 -> d_C__case_75 x18 x10 x19 x9 x8 x4 x2
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
    x18 (Curry_Prelude.C_Char 'C'#) cd cs) cd cs
  Curry_Prelude.OP_List -> x10
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_76 x10 x9 x8 x4
    x2 l cd cs) (d_C__case_76 x10 x9 x8 x4 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_76 x10
    x9 x8 x4 x2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C__case_76 x10 x9
    x8 x4 x2 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath._case_76" [show x10, show x9, show x8, show x4, show x2
    , show x17] info)
  _ -> failCons cd (consFail "System.FilePath._case_76" (showCons x17))

d_C__case_75 :: Curry_Prelude.C_Char -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Char -> Curry_Prelude.C_Char -> Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_75 x18 x10 x19 x9 x8 x4 x2 x20 cd cs = case x20 of
  Curry_Prelude.C_True -> d_C__case_74 x10 x9 x8 x4 x2 x19 cd cs
  Curry_Prelude.C_False -> x10
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_75 x18 x10 x19 x9
    x8 x4 x2 l cd cs) (d_C__case_75 x18 x10 x19 x9 x8 x4 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_75 x18
    x10 x19 x9 x8 x4 x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_75 x18 x10
    x19 x9 x8 x4 x2 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_75" [show x18, show x10, show x19, show x9, show x8
    , show x4, show x2, show x20] info)
  _ -> failCons cd (consFail "System.FilePath._case_75" (showCons x20))

d_C__case_74 :: Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char)) -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Char -> Curry_Prelude.C_Char -> Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_74 x10 x9 x8 x4 x2 x19 cd cs = case x19 of
  Curry_Prelude.OP_Cons x20 x21 -> d_C__case_73 x20 x10 x9 x8 x4 x2
    (Curry_Prelude.d_C_apply (d_C_isPathSeparator cd cs) x20 cd cs) cd cs
  Curry_Prelude.OP_List -> x10
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_74 x10 x9 x8 x4
    x2 l cd cs) (d_C__case_74 x10 x9 x8 x4 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_74 x10
    x9 x8 x4 x2 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C__case_74 x10 x9
    x8 x4 x2 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath._case_74" [show x10, show x9, show x8, show x4, show x2
    , show x19] info)
  _ -> failCons cd (consFail "System.FilePath._case_74" (showCons x19))

d_C__case_73 :: Curry_Prelude.C_Char -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)) -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Char -> Curry_Prelude.C_Char
  -> Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_73 x20 x10 x9 x8 x4 x2 x25 cd cs = case x25 of
  Curry_Prelude.C_True -> let x22 = d_C_readDriveShareName
                                (Curry_Prelude.d_C_drop (Curry_Prelude.C_Int
                                (4)) x9 cd cs) cd cs
                              x23 = d_OP_readDriveUNC_dot_uscore_hash_selFP20_hash_a
                                x22 cd cs
                              x24 = d_OP_readDriveUNC_dot_uscore_hash_selFP21_hash_b
                                x22 cd cs
    in Curry_Prelude.C_Just (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Cons x2
    (Curry_Prelude.OP_Cons x4 (Curry_Prelude.OP_Cons (Curry_Prelude.C_Char '?'#)
    (Curry_Prelude.OP_Cons x8 (Curry_Prelude.d_OP_plus_plus
    (Curry_Prelude.d_C_take (Curry_Prelude.C_Int (4)) x9 cd cs) x23 cd cs)))))
    x24)
  Curry_Prelude.C_False -> x10
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_73 x20 x10 x9 x8
    x4 x2 l cd cs) (d_C__case_73 x20 x10 x9 x8 x4 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_73 x20
    x10 x9 x8 x4 x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_73 x20 x10
    x9 x8 x4 x2 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_73" [show x20, show x10, show x9, show x8, show x4
    , show x2, show x25] info)
  _ -> failCons cd (consFail "System.FilePath._case_73" (showCons x25))

d_C__case_70 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_70 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_69 x4 x5 x2
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
    x4 (Curry_Prelude.C_Char ':'#) cd cs) cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.C_Nothing
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_70 x2 l cd cs)
    (d_C__case_70 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_70 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C__case_70 x2 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath._case_70" [show x2, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_70" (showCons x3))

d_C__case_69 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C__case_69 x4 x5 x2 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> d_C__case_68 x2 x5 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.C_Nothing
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_69 x4 x5 x2 l cd
    cs) (d_C__case_69 x4 x5 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_69 x4
    x5 x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_69 x4 x5
    x2 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_69" [show x4, show x5, show x2, show x6] info)
  _ -> failCons cd (consFail "System.FilePath._case_69" (showCons x6))

d_C__case_68 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_68 x2 x5 cd cs = case x5 of
  Curry_Prelude.OP_Cons x6 x7 -> d_C__case_67 x6 x2 x7
    (Curry_Prelude.d_OP_amp_amp (d_C_isLetter x2 cd cs) (Curry_Prelude.d_C_apply
    (d_C_isPathSeparator cd cs) x6 cd cs) cd cs) cd cs
  Curry_Prelude.OP_List -> d_C__case_65 x2 x5 (d_C_isLetter x2 cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_68 x2 l cd cs)
    (d_C__case_68 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_68 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C__case_68 x2 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath._case_68" [show x2, show x5] info)
  _ -> failCons cd (consFail "System.FilePath._case_68" (showCons x5))

d_C__case_65 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_65 x2 x5 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> Curry_Prelude.C_Just (Curry_Prelude.OP_Tuple2
    (Curry_Prelude.OP_Cons x2 (Curry_Prelude.toCurryString ":")) x5)
  Curry_Prelude.C_False -> Curry_Prelude.C_Nothing
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_65 x2 x5 l cd cs)
    (d_C__case_65 x2 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_65 x2
    x5 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_65 x2 x5 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_65" [show x2, show x5, show x6] info)
  _ -> failCons cd (consFail "System.FilePath._case_65" (showCons x6))

d_C__case_67 :: Curry_Prelude.C_Char -> Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C__case_67 x6 x2 x7 x8 cd cs = case x8 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_dollar (acceptCs id
    Curry_Prelude.C_Just) (d_C_addSlash (Curry_Prelude.OP_Cons x2
    (Curry_Prelude.toCurryString ":")) (Curry_Prelude.OP_Cons x6 x7) cd cs) cd
    cs
  Curry_Prelude.C_False -> d_C__case_66 x2 x7 x6 (d_C_isLetter x2 cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_67 x6 x2 x7 l cd
    cs) (d_C__case_67 x6 x2 x7 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_67 x6
    x2 x7 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_67 x6 x2
    x7 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_67" [show x6, show x2, show x7, show x8] info)
  _ -> failCons cd (consFail "System.FilePath._case_67" (showCons x8))

d_C__case_66 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C__case_66 x2 x7 x6 x8 cd cs = case x8 of
  Curry_Prelude.C_True -> Curry_Prelude.C_Just (Curry_Prelude.OP_Tuple2
    (Curry_Prelude.OP_Cons x2 (Curry_Prelude.toCurryString ":"))
    (Curry_Prelude.OP_Cons x6 x7))
  Curry_Prelude.C_False -> Curry_Prelude.C_Nothing
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_66 x2 x7 x6 l cd
    cs) (d_C__case_66 x2 x7 x6 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_66 x2
    x7 x6 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_66 x2 x7
    x6 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_66" [show x2, show x7, show x6, show x8] info)
  _ -> failCons cd (consFail "System.FilePath._case_66" (showCons x8))

d_C__case_64 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Cover -> ConstStore -> Curry_Prelude.C_Maybe
  (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  (Curry_Prelude.OP_List Curry_Prelude.C_Char))
d_C__case_64 x2 x3 cd cs = case x3 of
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_63 x4 x2 x5
    (Curry_Prelude.d_OP_amp_amp (Curry_Prelude.d_C_apply (d_C_isPathSeparator cd
    cs) x2 cd cs) (Curry_Prelude.d_C_apply (d_C_isPathSeparator cd cs) x4 cd cs)
    cd cs) cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.C_Nothing
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_64 x2 l cd cs)
    (d_C__case_64 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_64 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C__case_64 x2 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath._case_64" [show x2, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_64" (showCons x3))

d_C__case_63 :: Curry_Prelude.C_Char -> Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Maybe (Curry_Prelude.OP_Tuple2
  (Curry_Prelude.OP_List Curry_Prelude.C_Char) (Curry_Prelude.OP_List
  Curry_Prelude.C_Char))
d_C__case_63 x4 x2 x5 x9 cd cs = case x9 of
  Curry_Prelude.C_True -> let x6 = d_C_readDriveShareName x5 cd cs
                              x7 = d_OP_readDriveShare_dot_uscore_hash_selFP23_hash_a
                                x6 cd cs
                              x8 = d_OP_readDriveShare_dot_uscore_hash_selFP24_hash_b
                                x6 cd cs
    in Curry_Prelude.C_Just (Curry_Prelude.OP_Tuple2 (Curry_Prelude.OP_Cons x2
    (Curry_Prelude.OP_Cons x4 x7)) x8)
  Curry_Prelude.C_False -> Curry_Prelude.C_Nothing
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_63 x4 x2 x5 l cd
    cs) (d_C__case_63 x4 x2 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_63 x4
    x2 x5 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_63 x4 x2
    x5 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_63" [show x4, show x2, show x5, show x9] info)
  _ -> failCons cd (consFail "System.FilePath._case_63" (showCons x9))

d_C__case_62 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_62 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_plus_plus x1 x2 cd cs
  Curry_Prelude.C_False -> d_C__case_61 x1 x2 (Curry_Prelude.d_C_null x1 cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_62 x1 x2 l cd cs)
    (d_C__case_62 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_62 x1
    x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_62 x1 x2 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_62" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_62" (showCons x3))

d_C__case_61 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_61 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> x2
  Curry_Prelude.C_False -> d_C__case_60 x2 x1 (Curry_Prelude.d_C_null x2 cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_61 x1 x2 l cd cs)
    (d_C__case_61 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_61 x1
    x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_61 x1 x2 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_61" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_61" (showCons x3))

d_C__case_60 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_60 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> x1
  Curry_Prelude.C_False -> d_C__case_59 x1 x2 (Curry_Prelude.d_C_apply
    (d_C_isPathSeparator cd cs) (Data.Curry_List.d_C_last x1 cd cs) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_60 x2 x1 l cd cs)
    (d_C__case_60 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_60 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_60 x2 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_60" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_60" (showCons x3))

d_C__case_59 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_59 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_plus_plus x1 x2 cd cs
  Curry_Prelude.C_False -> d_C__case_58 x1 x2 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_59 x1 x2 l cd cs)
    (d_C__case_59 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_59 x1
    x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_59 x1 x2 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_59" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_59" (showCons x3))

d_C__case_58 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_58 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> d_C__case_57 x2 x1 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_58 x1 x2 l cd cs)
    (d_C__case_58 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_58 x1
    x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_58 x1 x2 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_58" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_58" (showCons x3))

d_C__case_57 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_57 x2 x1 cd cs = case x1 of
  Curry_Prelude.OP_Cons x3 x4 -> d_C__case_56 x2 x1 x3 x4 cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.d_OP_plus_plus x1
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.OP_Cons (d_C_pathSeparator cd
    cs) Curry_Prelude.OP_List) x2 cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_57 x2 l cd cs)
    (d_C__case_57 x2 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_57 x2
    z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C__case_57 x2 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath._case_57" [show x2, show x1] info)
  _ -> failCons cd (consFail "System.FilePath._case_57" (showCons x1))

d_C__case_56 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_56 x2 x1 x3 x4 cd cs = case x4 of
  Curry_Prelude.OP_Cons x5 x6 -> d_C__case_55 x5 x2 x1 x6 x3
    (Curry_Prelude.d_OP_uscore_impl_hash_eq_eq_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
    x5 (Curry_Prelude.C_Char ':'#) cd cs) cd cs
  Curry_Prelude.OP_List -> Curry_Prelude.d_OP_plus_plus x1
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.OP_Cons (d_C_pathSeparator cd
    cs) Curry_Prelude.OP_List) x2 cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_56 x2 x1 x3 l cd
    cs) (d_C__case_56 x2 x1 x3 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_56 x2
    x1 x3 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C__case_56 x2 x1
    x3 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath._case_56" [show x2, show x1, show x3, show x4] info)
  _ -> failCons cd (consFail "System.FilePath._case_56" (showCons x4))

d_C__case_55 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_55 x5 x2 x1 x6 x3 x7 cd cs = case x7 of
  Curry_Prelude.C_True -> d_C__case_54 x2 x1 x3 x6 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_OP_plus_plus x1
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.OP_Cons (d_C_pathSeparator cd
    cs) Curry_Prelude.OP_List) x2 cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_55 x5 x2 x1 x6 x3
    l cd cs) (d_C__case_55 x5 x2 x1 x6 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_55 x5
    x2 x1 x6 x3 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_55 x5 x2
    x1 x6 x3 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_55" [show x5, show x2, show x1, show x6, show x3
    , show x7] info)
  _ -> failCons cd (consFail "System.FilePath._case_55" (showCons x7))

d_C__case_54 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_54 x2 x1 x3 x6 cd cs = case x6 of
  Curry_Prelude.OP_List -> d_C__case_53 x3 x2 x1 (d_C_isLetter x3 cd cs) cd cs
  Curry_Prelude.OP_Cons x7 x8 -> Curry_Prelude.d_OP_plus_plus x1
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.OP_Cons (d_C_pathSeparator cd
    cs) Curry_Prelude.OP_List) x2 cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_54 x2 x1 x3 l cd
    cs) (d_C__case_54 x2 x1 x3 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_54 x2
    x1 x3 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C__case_54 x2 x1
    x3 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath._case_54" [show x2, show x1, show x3, show x6] info)
  _ -> failCons cd (consFail "System.FilePath._case_54" (showCons x6))

d_C__case_53 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_53 x3 x2 x1 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_plus_plus x1 x2 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_OP_plus_plus x1
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.OP_Cons (d_C_pathSeparator cd
    cs) Curry_Prelude.OP_List) x2 cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_53 x3 x2 x1 l cd
    cs) (d_C__case_53 x3 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_53 x3
    x2 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_53 x3 x2
    x1 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_53" [show x3, show x2, show x1, show x4] info)
  _ -> failCons cd (consFail "System.FilePath._case_53" (showCons x4))

d_C__case_52 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_52 x3 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> Curry_Prelude.toCurryString "./"
  Curry_Prelude.C_False -> x3
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_52 x3 l cd cs)
    (d_C__case_52 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_52 x3 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_52 x3 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_52" [show x3, show x4] info)
  _ -> failCons cd (consFail "System.FilePath._case_52" (showCons x4))

d_C__case_51 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_51 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> x1
  Curry_Prelude.C_False -> Curry_Prelude.d_OP_plus_plus x1
    (Curry_Prelude.OP_Cons (d_C_pathSeparator cd cs) Curry_Prelude.OP_List) cd
    cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_51 x1 l cd cs)
    (d_C__case_51 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_51 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_51 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_51" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.FilePath._case_51" (showCons x2))

d_C__case_50 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_50 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> let x2 = Curry_Prelude.d_OP_dollar
                                (Curry_Prelude.d_C_reverse cd cs)
                                (Curry_Prelude.d_OP_dollar
                                (Curry_Prelude.d_C_dropWhile
                                (d_C_isPathSeparator cd cs))
                                (Curry_Prelude.d_C_apply
                                (Curry_Prelude.d_C_reverse cd cs) x1 cd cs) cd
                                cs) cd cs
    in d_C__case_49 x2 (Curry_Prelude.d_C_null x2 cd cs) cd cs
  Curry_Prelude.C_False -> x1
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_50 x1 l cd cs)
    (d_C__case_50 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_50 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_50 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_50" [show x1, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_50" (showCons x3))

d_C__case_49 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_49 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons (d_C_pathSeparator cd cs)
    Curry_Prelude.OP_List
  Curry_Prelude.C_False -> x2
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_49 x2 l cd cs)
    (d_C__case_49 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_49 x2 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_49 x2 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_49" [show x2, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_49" (showCons x3))

d_C__case_48 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_48 x2 x3 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> x2
  Curry_Prelude.C_False -> d_C__case_47 x2 x3 (Curry_Prelude.d_OP_amp_amp
    (Curry_Prelude.d_C_null x3 cd cs) (Curry_Prelude.d_C_not
    (Curry_Prelude.d_C_null x2 cd cs) cd cs) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_48 x2 x3 l cd cs)
    (d_C__case_48 x2 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_48 x2
    x3 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_48 x2 x3 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_48" [show x2, show x3, show x4] info)
  _ -> failCons cd (consFail "System.FilePath._case_48" (showCons x4))

d_C__case_47 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_47 x2 x3 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> x2
  Curry_Prelude.C_False -> x3
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_47 x2 x3 l cd cs)
    (d_C__case_47 x2 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_47 x2
    x3 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_47 x2 x3 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_47" [show x2, show x3, show x4] info)
  _ -> failCons cd (consFail "System.FilePath._case_47" (showCons x4))

d_C__case_46 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_46 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> x2
  Curry_Prelude.C_False -> d_C__case_45 x2 x1 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_46 x2 x1 l cd cs)
    (d_C__case_46 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_46 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_46 x2 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_46" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_46" (showCons x3))

d_C__case_45 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_45 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> d_C_combineAlways x1 x2 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_45 x2 x1 l cd cs)
    (d_C__case_45 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_45 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_45 x2 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_45" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_45" (showCons x3))

d_C__case_44 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_44 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> x2
  Curry_Prelude.C_False -> d_C__case_43 x2 x1 (Curry_Prelude.d_C_null x2 cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_44 x1 x2 l cd cs)
    (d_C__case_44 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_44 x1
    x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_44 x1 x2 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_44" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_44" (showCons x3))

d_C__case_43 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_43 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> x1
  Curry_Prelude.C_False -> d_C__case_42 x1 x2 (Curry_Prelude.d_C_apply
    (d_C_isPathSeparator cd cs) (Data.Curry_List.d_C_last x1 cd cs) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_43 x2 x1 l cd cs)
    (d_C__case_43 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_43 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_43 x2 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_43" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_43" (showCons x3))

d_C__case_42 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_42 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_plus_plus x1 x2 cd cs
  Curry_Prelude.C_False -> d_C__case_41 x1 x2 (Curry_Prelude.d_C_apply
    (d_C_isDrive cd cs) x1 cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_42 x1 x2 l cd cs)
    (d_C__case_42 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_42 x1
    x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_42 x1 x2 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_42" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_42" (showCons x3))

d_C__case_41 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_41 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> d_C_joinDrive x1 x2 cd cs
  Curry_Prelude.C_False -> d_C__case_40 x2 x1 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_41 x1 x2 l cd cs)
    (d_C__case_41 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_41 x1
    x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_41 x1 x2 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_41" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_41" (showCons x3))

d_C__case_40 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_40 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_plus_plus x1
    (Curry_Prelude.d_OP_plus_plus (Curry_Prelude.OP_Cons (d_C_pathSeparator cd
    cs) Curry_Prelude.OP_List) x2 cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_40 x2 x1 l cd cs)
    (d_C__case_40 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_40 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_40 x2 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_40" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_40" (showCons x3))

d_C__case_39 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_39 x3 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons x3 Curry_Prelude.OP_List
  Curry_Prelude.C_False -> Curry_Prelude.OP_List
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_39 x3 l cd cs)
    (d_C__case_39 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_39 x3 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_39 x3 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_39" [show x3, show x4] info)
  _ -> failCons cd (consFail "System.FilePath._case_39" (showCons x4))

d_C__case_38 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_38 x1 x2 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons (Curry_Prelude.d_C_head x2 cd
    cs) (d_OP_splitDirectories_dot_f_dot_198 (Curry_Prelude.d_C_tail x2 cd cs)
    cd cs)
  Curry_Prelude.C_False -> d_OP_splitDirectories_dot_f_dot_198 x2 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_38 x1 x2 l cd cs)
    (d_C__case_38 x1 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_38 x1
    x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_38 x1 x2 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_38" [show x1, show x2, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_38" (showCons x3))

d_C__case_37 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_37 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> x1
  Curry_Prelude.C_False -> x2
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_37 x2 x1 l cd cs)
    (d_C__case_37 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_37 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_37 x2 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_37" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_37" (showCons x3))

d_C__case_36 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_36 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Data.Curry_List.d_C_init x1 cd cs
  Curry_Prelude.C_False -> d_C__case_35 x1 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_36 x1 l cd cs)
    (d_C__case_36 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_36 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_36 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_36" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.FilePath._case_36" (showCons x2))

d_C__case_35 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_35 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> x1
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_35 x1 l cd cs)
    (d_C__case_35 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_35 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_35 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_35" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.FilePath._case_35" (showCons x2))

d_C__case_34 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_34 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_dollar
    d_OP_equalFilePath_dot_dropTrailSlash_dot_208 (Curry_Prelude.d_OP_dollar
    (Curry_Prelude.d_C_map Data.Curry_Char.d_C_toLower) (d_C_normalise x1 cd cs)
    cd cs) cd cs
  Curry_Prelude.C_False -> d_C__case_33 x1 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_34 x1 l cd cs)
    (d_C__case_34 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_34 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_34 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_34" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.FilePath._case_34" (showCons x2))

d_C__case_33 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_33 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_dollar
    d_OP_equalFilePath_dot_dropTrailSlash_dot_208 (d_C_normalise x1 cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_33 x1 l cd cs)
    (d_C__case_33 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_33 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_33 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_33" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.FilePath._case_33" (showCons x2))

d_C__case_32 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_32 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.toCurryString "."
  Curry_Prelude.C_False -> d_C__case_31 x2 x1 (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_slash_eq_hash_Prelude_dot_Eq_hash_lbracket_rbracket_hash_0_hash_hash
    Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash
    cd cs) (d_OP_makeRelative_dot_takeAbs_dot_214 x1 cd cs) cd cs)
    (d_OP_makeRelative_dot_takeAbs_dot_214 x2 cd cs) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_32 x2 x1 l cd cs)
    (d_C__case_32 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_32 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_32 x2 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_32" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_32" (showCons x3))

d_C__case_31 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_31 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> x2
  Curry_Prelude.C_False -> d_C__case_30 x2 x1 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_31 x2 x1 l cd cs)
    (d_C__case_31 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_31 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_31 x2 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_31" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_31" (showCons x3))

d_C__case_30 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_30 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> d_OP_makeRelative_dot_f_dot_214 x2
    (d_OP_makeRelative_dot_dropAbs_dot_214 x1 cd cs)
    (d_OP_makeRelative_dot_dropAbs_dot_214 x2 cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_30 x2 x1 l cd cs)
    (d_C__case_30 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_30 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_30 x2 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_30" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_30" (showCons x3))

d_C__case_29 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_29 x10 x7 x1 x11 x8 x12 cd cs = case x12 of
  Curry_Prelude.C_True -> d_OP_makeRelative_dot_f_dot_214 x1 x8 x11 cd cs
  Curry_Prelude.C_False -> x1
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_29 x10 x7 x1 x11
    x8 l cd cs) (d_C__case_29 x10 x7 x1 x11 x8 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_29 x10
    x7 x1 x11 x8 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_29 x10 x7
    x1 x11 x8 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_29" [show x10, show x7, show x1, show x11, show x8
    , show x12] info)
  _ -> failCons cd (consFail "System.FilePath._case_29" (showCons x12))

d_C__case_28 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_28 x2 x3 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> x3
  Curry_Prelude.C_False -> d_C__case_27 x3 x2 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_28 x2 x3 l cd cs)
    (d_C__case_28 x2 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_28 x2
    x3 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_28 x2 x3 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_28" [show x2, show x3, show x4] info)
  _ -> failCons cd (consFail "System.FilePath._case_28" (showCons x4))

d_C__case_27 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_27 x3 x2 x4 cd cs = case x4 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_apply (d_C_dropDrive cd cs)
    (Curry_Prelude.OP_Cons x2 x3) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_27 x3 x2 l cd cs)
    (d_C__case_27 x3 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_27 x3
    x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_27 x3 x2 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_27" [show x3, show x2, show x4] info)
  _ -> failCons cd (consFail "System.FilePath._case_27" (showCons x4))

d_C__case_26 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_26 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons (d_C_pathSeparator cd cs)
    Curry_Prelude.OP_List
  Curry_Prelude.C_False -> d_C__case_25 x1 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_26 x2 x1 l cd cs)
    (d_C__case_26 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_26 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_26 x2 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_26" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_26" (showCons x3))

d_C__case_25 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_25 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_dollar (Curry_Prelude.d_C_map
    d_OP_makeRelative_dot_takeAbs_dot_214_dot_uscore_hash_lambda11)
    (Curry_Prelude.d_C_apply (d_C_takeDrive cd cs) x1 cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_25 x1 l cd cs)
    (d_C__case_25 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_25 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_25 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_25" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.FilePath._case_25" (showCons x2))

d_C__case_24 :: Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Char
d_C__case_24 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> d_C_pathSeparator cd cs
  Curry_Prelude.C_False -> Data.Curry_Char.d_C_toLower x1 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_24 x1 l cd cs)
    (d_C__case_24 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_24 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_24 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_24" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.FilePath._case_24" (showCons x2))

d_C__case_23 :: Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Char
d_C__case_23 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> d_C_pathSeparator cd cs
  Curry_Prelude.C_False -> Data.Curry_Char.d_C_toLower x1 cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_23 x1 l cd cs)
    (d_C__case_23 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_23 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_23 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_23" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.FilePath._case_23" (showCons x2))

d_C__case_22 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_22 x4 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons (d_C_pathSeparator cd cs)
    Curry_Prelude.OP_List
  Curry_Prelude.C_False -> Curry_Prelude.OP_List
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_22 x4 l cd cs)
    (d_C__case_22 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_22 x4 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_22 x4 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_22" [show x4, show x5] info)
  _ -> failCons cd (consFail "System.FilePath._case_22" (showCons x5))

d_C__case_21 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_21 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.OP_List -> d_C__case_20 x2 x1 (Curry_Prelude.d_C_apply
    (d_C_isPathSeparator cd cs) x2 cd cs) cd cs
  Curry_Prelude.OP_Cons x4 x5 -> d_C__case_18 x4 x2 x5
    (Curry_Prelude.d_OP_amp_amp (Curry_Prelude.d_C_apply (d_C_isPathSeparator cd
    cs) x2 cd cs) (Curry_Prelude.d_C_apply (d_C_isPathSeparator cd cs) x4 cd cs)
    cd cs) cd cs
  Curry_Prelude.Choice_OP_List d i l r -> narrow d i (d_C__case_21 x2 x1 l cd
    cs) (d_C__case_21 x2 x1 r cd cs)
  Curry_Prelude.Choices_OP_List d i xs -> narrows cs d i (\z -> d_C__case_21 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_OP_List d c e -> guardCons d c ((\x -> d_C__case_21 x2 x1
    e cd x) $! addCs c cs)
  Curry_Prelude.Fail_OP_List d info -> failCons d (traceFail
    "System.FilePath._case_21" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_21" (showCons x3))

d_C__case_18 :: Curry_Prelude.C_Char -> Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_18 x4 x2 x5 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> d_OP_normalise_dot_propSep_dot_239
    (Curry_Prelude.OP_Cons x2 x5) cd cs
  Curry_Prelude.C_False -> d_C__case_17 x2 x5 x4 (Curry_Prelude.d_C_apply
    (d_C_isPathSeparator cd cs) x2 cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_18 x4 x2 x5 l cd
    cs) (d_C__case_18 x4 x2 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_18 x4
    x2 x5 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_18 x4 x2
    x5 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_18" [show x4, show x2, show x5, show x6] info)
  _ -> failCons cd (consFail "System.FilePath._case_18" (showCons x6))

d_C__case_17 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_17 x2 x5 x4 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons (d_C_pathSeparator cd cs)
    (d_OP_normalise_dot_propSep_dot_239 (Curry_Prelude.OP_Cons x4 x5) cd cs)
  Curry_Prelude.C_False -> d_C__case_16 x5 x4 x2 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_17 x2 x5 x4 l cd
    cs) (d_C__case_17 x2 x5 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_17 x2
    x5 x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_17 x2 x5
    x4 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_17" [show x2, show x5, show x4, show x6] info)
  _ -> failCons cd (consFail "System.FilePath._case_17" (showCons x6))

d_C__case_16 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Char -> Curry_Prelude.C_Char -> Curry_Prelude.C_Bool
  -> Cover -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_16 x5 x4 x2 x6 cd cs = case x6 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons x2
    (d_OP_normalise_dot_propSep_dot_239 (Curry_Prelude.OP_Cons x4 x5) cd cs)
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_16 x5 x4 x2 l cd
    cs) (d_C__case_16 x5 x4 x2 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_16 x5
    x4 x2 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_16 x5 x4
    x2 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_16" [show x5, show x4, show x2, show x6] info)
  _ -> failCons cd (consFail "System.FilePath._case_16" (showCons x6))

d_C__case_20 :: Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_20 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons (d_C_pathSeparator cd cs)
    Curry_Prelude.OP_List
  Curry_Prelude.C_False -> d_C__case_19 x1 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_20 x2 x1 l cd cs)
    (d_C__case_20 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_20 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_20 x2 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_20" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_20" (showCons x3))

d_C__case_19 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_19 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> x1
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_19 x1 l cd cs)
    (d_C__case_19 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_19 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_19 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_19" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.FilePath._case_19" (showCons x2))

d_C__case_15 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_15 x3 x4 x1 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> d_OP_normalise_dot_dropDots_tick_dot_239 x1 x4 cd cs
  Curry_Prelude.C_False -> d_C__case_14 x4 x1 x3 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_15 x3 x4 x1 l cd
    cs) (d_C__case_15 x3 x4 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_15 x3
    x4 x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_15 x3 x4
    x1 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_15" [show x3, show x4, show x1, show x5] info)
  _ -> failCons cd (consFail "System.FilePath._case_15" (showCons x5))

d_C__case_14 :: Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_14 x4 x1 x3 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> d_OP_normalise_dot_dropDots_tick_dot_239
    (Curry_Prelude.OP_Cons x3 x1) x4 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_14 x4 x1 x3 l cd
    cs) (d_C__case_14 x4 x1 x3 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_14 x4
    x1 x3 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_14 x4 x1
    x3 e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_14" [show x4, show x1, show x3, show x5] info)
  _ -> failCons cd (consFail "System.FilePath._case_14" (showCons x5))

d_C__case_13 :: Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_13 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons (Curry_Prelude.toCurryString
    ".") Curry_Prelude.OP_List
  Curry_Prelude.C_False -> d_C__case_12 x1 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_13 x1 l cd cs)
    (d_C__case_13 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_13 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_13 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_13" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.FilePath._case_13" (showCons x2))

d_C__case_12 :: Curry_Prelude.OP_List (Curry_Prelude.OP_List
  Curry_Prelude.C_Char) -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List (Curry_Prelude.OP_List Curry_Prelude.C_Char)
d_C__case_12 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> d_OP_normalise_dot_dropDots_tick_dot_239
    Curry_Prelude.OP_List x1 cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_12 x1 l cd cs)
    (d_C__case_12 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_12 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_12 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_12" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.FilePath._case_12" (showCons x2))

d_C__case_11 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_11 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> x1
  Curry_Prelude.C_False -> d_C__case_10 x2 x1 (Curry_Prelude.d_C_otherwise cd
    cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_11 x2 x1 l cd cs)
    (d_C__case_11 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_11 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_11 x2 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_11" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_11" (showCons x3))

d_C__case_10 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_10 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> d_C__case_9 x2 x1 (Curry_Prelude.d_OP_dollar
    Data.Curry_Maybe.d_C_isJust (d_C_readDriveLetter x2 cd cs) cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_10 x2 x1 l cd cs)
    (d_C__case_10 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_10 x2
    x1 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_10 x2 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_10" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_10" (showCons x3))

d_C__case_9 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_9 x2 x1 x3 cd cs = case x3 of
  Curry_Prelude.C_True -> Curry_Prelude.d_C_map Data.Curry_Char.d_C_toUpper x2
    cd cs
  Curry_Prelude.C_False -> x1
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_9 x2 x1 l cd cs)
    (d_C__case_9 x2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_9 x2 x1
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_9 x2 x1 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_9" [show x2, show x1, show x3] info)
  _ -> failCons cd (consFail "System.FilePath._case_9" (showCons x3))

d_C__case_8 :: Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Char
d_C__case_8 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> d_C_pathSeparator cd cs
  Curry_Prelude.C_False -> x1
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_8 x1 l cd cs)
    (d_C__case_8 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_8 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_8 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_8" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.FilePath._case_8" (showCons x2))

d_C__case_7 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_7 x1 x4 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.C_True
  Curry_Prelude.C_False -> d_C__case_6 x1 x4 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_7 x1 x4 l cd cs)
    (d_C__case_7 x1 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_7 x1 x4
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_7 x1 x4 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_7" [show x1, show x4, show x5] info)
  _ -> failCons cd (consFail "System.FilePath._case_7" (showCons x5))

d_C__case_6 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Bool
d_C__case_6 x1 x4 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_amp_amp (Curry_Prelude.d_C_not
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_any (Curry_Prelude.d_C_flip
    (Curry_Prelude.d_C_elem
    Curry_Prelude.d_OP_uscore_inst_hash_Prelude_dot_Eq_hash_Prelude_dot_Char_hash)
    (d_C_badCharacters cd cs)) cd cs) x4 cd cs) cd cs)
    (Curry_Prelude.d_OP_amp_amp (Curry_Prelude.d_C_not
    (Curry_Prelude.d_OP_dollar (Curry_Prelude.d_C_any d_OP_isValid_dot_f_dot_272
    cd cs) (d_C_splitDirectories x4 cd cs) cd cs) cd cs) (Curry_Prelude.d_C_not
    (Curry_Prelude.d_OP_amp_amp (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
    cd cs) (Curry_Prelude.d_C_length x1 cd cs) cd cs) (Curry_Prelude.C_Int (2))
    cd cs) (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_all (d_C_isPathSeparator
    cd cs) cd cs) x1 cd cs) cd cs) cd cs) cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_6 x1 x4 l cd cs)
    (d_C__case_6 x1 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_6 x1 x4
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_6 x1 x4 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_6" [show x1, show x4, show x5] info)
  _ -> failCons cd (consFail "System.FilePath._case_6" (showCons x5))

d_C__case_5 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_5 x1 x6 x5 x7 cd cs = case x7 of
  Curry_Prelude.C_True -> x1
  Curry_Prelude.C_False -> d_C__case_4 x1 x6 x5 (Curry_Prelude.d_OP_amp_amp
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply
    (Curry_Prelude.d_OP_uscore_impl_hash_gt_eq_hash_Prelude_dot_Ord_hash_Prelude_dot_Int_hash
    cd cs) (Curry_Prelude.d_C_length x1 cd cs) cd cs) (Curry_Prelude.C_Int (2))
    cd cs) (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_all (d_C_isPathSeparator
    cd cs) cd cs) x1 cd cs) cd cs) cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_5 x1 x6 x5 l cd
    cs) (d_C__case_5 x1 x6 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_5 x1 x6
    x5 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_5 x1 x6 x5
    e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_5" [show x1, show x6, show x5, show x7] info)
  _ -> failCons cd (consFail "System.FilePath._case_5" (showCons x7))

d_C__case_4 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_4 x1 x6 x5 x7 cd cs = case x7 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_plus_plus (Curry_Prelude.d_C_take
    (Curry_Prelude.C_Int (2)) x1 cd cs) (Curry_Prelude.toCurryString "drive") cd
    cs
  Curry_Prelude.C_False -> d_C__case_3 x6 x5 (Curry_Prelude.d_C_otherwise cd cs)
    cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_4 x1 x6 x5 l cd
    cs) (d_C__case_4 x1 x6 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_4 x1 x6
    x5 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_4 x1 x6 x5
    e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_4" [show x1, show x6, show x5, show x7] info)
  _ -> failCons cd (consFail "System.FilePath._case_4" (showCons x7))

d_C__case_3 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_3 x6 x5 x7 cd cs = case x7 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_dollar (d_C_joinDrive x5)
    (Curry_Prelude.d_OP_dollar d_OP_makeValid_dot_validElements_dot_281
    (d_OP_makeValid_dot_validChars_dot_281 x6 cd cs) cd cs) cd cs
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_3 x6 x5 l cd cs)
    (d_C__case_3 x6 x5 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_3 x6 x5
    z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_3 x6 x5 e
    cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_3" [show x6, show x5, show x7] info)
  _ -> failCons cd (consFail "System.FilePath._case_3" (showCons x7))

d_C__case_2 :: Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Char
d_C__case_2 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.C_Char '_'#
  Curry_Prelude.C_False -> d_C__case_1 x1 (Curry_Prelude.d_C_otherwise cd cs) cd
    cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_2 x1 l cd cs)
    (d_C__case_2 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_2 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_2 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_2" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.FilePath._case_2" (showCons x2))

d_C__case_1 :: Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover
  -> ConstStore -> Curry_Prelude.C_Char
d_C__case_1 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> x1
  Curry_Prelude.C_False -> Curry_Prelude.d_C_failed cd cs
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_1 x1 l cd cs)
    (d_C__case_1 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_1 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_1 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_1" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.FilePath._case_1" (showCons x2))

d_C__case_0 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char -> Curry_Prelude.C_Bool -> Cover -> ConstStore
  -> Curry_Prelude.OP_List Curry_Prelude.C_Char
d_C__case_0 x3 x1 x4 x5 cd cs = case x5 of
  Curry_Prelude.C_True -> Curry_Prelude.d_OP_plus_plus x3
    (Curry_Prelude.d_C_apply (Curry_Prelude.d_C_apply (d_OP_lt_dot_gt cd cs)
    (Curry_Prelude.toCurryString "_") cd cs) x4 cd cs) cd cs
  Curry_Prelude.C_False -> x1
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_0 x3 x1 x4 l cd
    cs) (d_C__case_0 x3 x1 x4 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_0 x3 x1
    x4 z cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_0 x3 x1 x4
    e cd x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.FilePath._case_0" [show x3, show x1, show x4, show x5] info)
  _ -> failCons cd (consFail "System.FilePath._case_0" (showCons x5))

