{-# LANGUAGE MagicHash #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE QuantifiedConstraints #-}
{-# LANGUAGE RankNTypes #-}
{-# LANGUAGE PolyKinds #-}
{-# LANGUAGE MultiParamTypeClasses #-}
{-# LANGUAGE FlexibleInstances #-}
{-# LANGUAGE CPP #-}
{-# OPTIONS_GHC -fno-warn-overlapping-patterns #-}
{-# OPTIONS_GHC -fno-warn-missing-methods #-}
#if __GLASGOW_HASKELL__ >= 800
{-# OPTIONS_GHC -fno-warn-redundant-constraints #-}
#else
{-# OPTIONS_GHC -fno-warn-duplicate-constraints #-}
#endif
{-# LANGUAGE CPP, ForeignFunctionInterface, MultiParamTypeClasses #-}

module System.Curry_Process
  ( d_C_system, d_C_exitWith, d_C_sleep, d_C_getPID )
  where

import Basics
import qualified Curry_Prelude
import qualified System.Curry_Environment

import Control.Exception as C (IOException, handle)
import System.Exit            (ExitCode (..), exitWith)
import System.Process         (system)

#if defined(mingw32_HOST_OS) || defined(__MINGW32__)
import System.Win32.Process
#else
import System.Posix.Process (getProcessID)
#endif

d_C_system :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.C_Int
d_C_system x1 cd cs = let x2 = System.Curry_Environment.d_C_isWindows cd cs
                          x3 = d_C__case_0 x1 x2 cd cs
  in Curry_Prelude.d_OP_dollar_hash_hash d_C_prim_system x3 cd cs

d_C_exitWith :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_Prelude.C_IO t0
d_C_exitWith x1 cd cs = Curry_Prelude.d_OP_dollar_hash d_C_prim_exitWith x1 cd
  cs

d_C_sleep :: Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.C_IO
  Curry_Prelude.OP_Unit
d_C_sleep x1 cd cs = Curry_Prelude.d_OP_dollar_hash d_C_prim_sleep x1 cd cs

d_C_getPID :: Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_Int
d_C_getPID cd cs = external_d_C_getPID cd cs

d_C_prim_system :: Curry_Prelude.OP_List Curry_Prelude.C_Char -> Cover
  -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_Int
d_C_prim_system x1 cd cs = external_d_C_prim_system x1 cd cs

d_C_prim_exitWith :: forall t0 . (Curry_Prelude.Curry t0) => Curry_Prelude.C_Int
  -> Cover -> ConstStore -> Curry_Prelude.C_IO t0
d_C_prim_exitWith x1 cd cs = external_d_C_prim_exitWith x1 cd cs

d_C_prim_sleep :: Curry_Prelude.C_Int -> Cover -> ConstStore
  -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
d_C_prim_sleep x1 cd cs = external_d_C_prim_sleep x1 cd cs

d_C__case_0 :: Curry_Prelude.OP_List Curry_Prelude.C_Char
  -> Curry_Prelude.C_Bool -> Cover -> ConstStore -> Curry_Prelude.OP_List
  Curry_Prelude.C_Char
d_C__case_0 x1 x2 cd cs = case x2 of
  Curry_Prelude.C_True -> Curry_Prelude.OP_Cons (Curry_Prelude.C_Char '"'#)
    (Curry_Prelude.d_OP_plus_plus x1 (Curry_Prelude.toCurryString "\"") cd cs)
  Curry_Prelude.C_False -> x1
  Curry_Prelude.Choice_C_Bool d i l r -> narrow d i (d_C__case_0 x1 l cd cs)
    (d_C__case_0 x1 r cd cs)
  Curry_Prelude.Choices_C_Bool d i xs -> narrows cs d i (\z -> d_C__case_0 x1 z
    cd cs) xs
  Curry_Prelude.Guard_C_Bool d c e -> guardCons d c ((\x -> d_C__case_0 x1 e cd
    x) $! addCs c cs)
  Curry_Prelude.Fail_C_Bool d info -> failCons d (traceFail
    "System.Process._case_0" [show x1, show x2] info)
  _ -> failCons cd (consFail "System.Process._case_0" (showCons x2))

-- #endimport - do not remove this line!

#if defined(mingw32_HOST_OS) || defined(__MINGW32__)
foreign import stdcall unsafe "windows.h GetCurrentProcessId"
  getProcessID :: IO ProcessId
#endif

external_d_C_getPID :: Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.C_Int
external_d_C_getPID _ _ = toCurry $ do
  pid <- getProcessID
  return (fromIntegral pid :: Int)

external_d_C_prim_system :: Curry_Prelude.C_String -> Cover -> ConstStore
                         -> Curry_Prelude.C_IO Curry_Prelude.C_Int
external_d_C_prim_system str _ _ = toCurry system str

instance ConvertCurryHaskell Curry_Prelude.C_Int ExitCode where
  toCurry ExitSuccess     = toCurry (0 :: Int)
  toCurry (ExitFailure i) = toCurry i

  fromCurry j = let i = fromCurry j :: Int
                in if i == 0 then ExitSuccess else ExitFailure i

external_d_C_prim_exitWith :: Curry_Prelude.Curry a
                           => Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.C_IO a
external_d_C_prim_exitWith c _ _ = fromIO (exitWith (fromCurry c))

external_d_C_prim_sleep :: Curry_Prelude.C_Int -> Cover -> ConstStore -> Curry_Prelude.C_IO Curry_Prelude.OP_Unit
external_d_C_prim_sleep x _ _ =
  toCurry (\i -> system ("sleep " ++ show (i :: Int)) >> return ()) x -- TODO

external_d_C_isWindows :: Cover -> ConstStore -> Curry_Prelude.C_Bool
#if defined(mingw32_HOST_OS) || defined(__MINGW32__)
external_d_C_isWindows _ _ = Curry_Prelude.C_True
#else
external_d_C_isWindows _ _ = Curry_Prelude.C_False
#endif
