#!/bin/sh
# This shell script updates some tools by downloading the current version
# from the Curry package repository.
#
# Note that the execution of this script requires an already installed 'cypm'!

# use local Curry executable if it exists (e.g., we are inside the distro):
CURRYBIN=`pwd`/../bin/curry
if [ -x "$CURRYBIN" ] ; then
  CPMOPTS="-d curry_bin=$CURRYBIN"
else
  CPMOPTS=
fi
CPM="cypm $CPMOPTS"

TOOLDIR=`pwd`

##############################################################################
echo "Updating 'cpm'..."
mv cpm/Makefile Makefile.cpm  # keep old Makefile
mv cpm/vendor/cass/src/CASS/PackageConfig.curry CASS_PackageConfig.curry
rm -rf cpm
$CPM checkout cpm
cd cpm
rm -rf .git* bin package.json
make fetchdeps
rm -rf vendor/*/.git*
rm -rf dependencies.txt fetch-dependencies.sh Makefile
cd "$TOOLDIR"
mv Makefile.cpm cpm/Makefile
mv CASS_PackageConfig.curry cpm/vendor/cass/src/CASS/PackageConfig.curry
echo "'cpm' updated from package repository."

##############################################################################
echo "Updating 'optimize'..."
mv optimize/Makefile Makefile.optimize  # keep old Makefile
mv optimize/.cpm/packages/cass/src/CASS/PackageConfig.curry CASS_PackageConfig.curry
mv optimize/package.json optimize_package.json
rm -rf optimize
$CPM checkout transbooleq
mv transbooleq optimize
cd optimize
$CPM install --noexec
rm -rf .git*
rm -rf .cpm/*_cache
rm -rf .cpm/packages/*/.git*
cd .cpm/packages
 CANAV=`ls -d cass-analysis-*`
 mv $CANAV cass-analysis
 CASSV=`ls -d cass-*\.*\.*`
 mv $CASSV cass
 ln -s cass-analysis $CANAV
 ln -s cass $CASSV
 PKGV=`ls -d containers-*`
 mv $PKGV containers
 ln -s containers $PKGV
 PKGV=`ls -d cpm-query-*`
 mv $PKGV cpm-query
 ln -s containers $PKGV
 PKGV=`ls -d csv-*`
 mv $PKGV csv
 ln -s csv $PKGV
 PKGV=`ls -d currypath-*`
 mv $PKGV currypath
 ln -s currypath $PKGV
 PKGV=`ls -d det-parse-*`
 mv $PKGV det-parse
 ln -s det-parse $PKGV
 PKGV=`ls -d directory-*`
 mv $PKGV directory
 ln -s directory $PKGV
 PKGV=`ls -d execpath-*`
 mv $PKGV execpath
 ln -s execpath $PKGV
 PKGV=`ls -d extra-*`
 mv $PKGV extra
 ln -s extra $PKGV
 PKGV=`ls -d filepath-*`
 mv $PKGV filepath
 ln -s filepath $PKGV
 PKGV=`ls -d flatcurry-*`
 mv $PKGV flatcurry
 ln -s flatcurry $PKGV
 PKGV=`ls -d frontend-exec-*`
 mv $PKGV frontend-exec
 ln -s frontend-exec $PKGV
 PKGV=`ls -d io-extra-*`
 mv $PKGV io-extra
 ln -s io-extra $PKGV
 PKGV=`ls -d json-*`
 mv $PKGV json
 ln -s json $PKGV
 PKGV=`ls -d process-*`
 mv $PKGV process
 ln -s process $PKGV
 PKGV=`ls -d profiling-*`
 mv $PKGV profiling
 ln -s profiling $PKGV
 PKGV=`ls -d propertyfile-*`
 mv $PKGV propertyfile
 ln -s propertyfile $PKGV
 PKGV=`ls -d queue-*`
 mv $PKGV queue
 ln -s queue $PKGV
 PKGV=`ls -d random-*`
 mv $PKGV random
 ln -s random $PKGV
 PKGV=`ls -d read-legacy-*`
 mv $PKGV read-legacy
 ln -s read-legacy $PKGV
 PKGV=`ls -d rw-data-*`
 mv $PKGV rw-data
 ln -s rw-data $PKGV
 PKGV=`ls -d scc-*`
 mv $PKGV scc
 ln -s scc $PKGV
 PKGV=`ls -d socket-*`
 mv $PKGV socket
 ln -s socket $PKGV
 PKGV=`ls -d string-trie-*`
 mv $PKGV string-trie
 ln -s string-trie $PKGV
 PKGV=`ls -d time-*`
 mv $PKGV time
 ln -s time $PKGV
 PKGV=`ls -d transformers-*`
 mv $PKGV transformers
 ln -s transformers $PKGV
 PKGV=`ls -d url-base-*`
 mv $PKGV url-base
 ln -s url-base $PKGV
 PKGV=`ls -d wl-pprint-*`
 mv $PKGV wl-pprint
 ln -s wl-pprint $PKGV
 PKGV=`ls -d xml-*`
 mv $PKGV xml
 ln -s xml $PKGV
cd "$TOOLDIR"
mv Makefile.optimize optimize/Makefile
mv CASS_PackageConfig.curry optimize/.cpm/packages/cass/src/CASS/PackageConfig.curry
mv optimize_package.json optimize/package.json
echo "'optimize' updated from package repository."
