------------------------------------------------------------------------------
-- Overlapping analysis:
-- check whether functions are defined with overlapping left-hand sides
-- (i.e., whether they are defined with OR expressions)
--
-- Michael Hanus, September 1999
------------------------------------------------------------------------------

module AnaOverlapping(analyseOverlappings,orInExpr) where

import Flat

------------------------------------------------------------------------------
-- The overlapping analysis can be applied to individual modules.
-- It assigns to a FlatCurry module the list of all function names
-- together with a flag which is True if this function is defined
-- with overlapping left-hand sides.

analyseOverlappings :: Prog -> [(String,Bool)]
analyseOverlappings (Prog _ _ _ funs _ _) = map overlapFun funs
  where
    overlapFun (Func name _ _ (Rule _ e))   = (name, orInExpr e)
    overlapFun (Func name _ _ (External _)) = (name, False)

--------------------------------------------------------------------------
-- Check an expression for occurrences of OR:
orInExpr :: Expr -> Bool
orInExpr (Var _) = False
orInExpr (Lit _) = False
orInExpr (Comb _ _ es) = foldr (||) False (map orInExpr es)
orInExpr (Apply e1 e2) = orInExpr e1 || orInExpr e2
orInExpr (Constr _ e) = orInExpr e
orInExpr (Or _ _) = True
orInExpr (Case _ e bs) = orInExpr e || any orInBranch bs
                   where orInBranch (Branch _ be) = orInExpr be
orInExpr (GuardedExpr _ e1 e2) = orInExpr e1 || orInExpr e2
orInExpr (Choice _) = False -- OR in committed choice have only local effects

