-----------------------------------------------------------------------------
-- Pattern matching analysis for Curry programs
--
-- This analysis shows for each function in a Curry program
-- its translation into definition based on case and or expressions,
-- i.e., it shows the explicit pattern matching strategy for each function.
--
-- Michael Hanus, Janauary 2002
-----------------------------------------------------------------------------

module AnaPatternMatch(showPatternMatching) where

import Flat
import FlatTools
import Char

showPatternMatching :: Prog -> [(String,String)]
showPatternMatching (Prog _ _ _ funs _ tt) = map showPat funs
 where
  showPat (Func name _ _ (Rule vs e))
   | length vs == 2 && not (isAlpha (head (translate tt name))) -- infix op
     = (name, showCurryVar (head vs) ++ " " ++ translate tt name ++ " " ++
              showCurryVar (vs!!1) ++
              " = " ++ showCurryExpr (translate tt) False 0 e)
   | otherwise
     = (name, translate tt name ++ concatMap (\i->" "++showCurryVar i) vs ++
                " = " ++ showCurryExpr (translate tt) False 0 e)
  showPat (Func name _ _ (External _)) =
         (name, translate tt name ++" is externally defined")

  translate [] f = f
  translate (Trans name intname : trs) f =
            if f==intname then name else translate trs f


-- end of AnaPatternMatch
