-----------------------------------------------------------------------------
-- Type analysis
--
-- This simple analysis is integrated into the CIDER programming envionment
-- and computes a type representation for each function.
--
-- Johannes Koj, October 2000
-- Michael Hanus, February 2002
-----------------------------------------------------------------------------

module AnaTypes(analyseTypes) where

import Flat
import FlatTools
import Types
import Base
import Char

-----------------------------------------------------------------------------
-- analysis

analyseTypes :: ProgAnalysis String
analyseTypes (Prog modname _ _ funs _ trans) = map anaFun funs
 where
   anaFun (Func name _ ftype _) =
       (name, showId (rename name) ++" :: "++ showCurryType rename False ftype)

   rename = stripModName (cutPath modname) trans

   showId i = if isAlpha (head i) then i
                                  else "("++i++")"

-- end of AnaTypes
