-----------------------------------------------------------------------------
-- This module contains some functions relevant to various modules.
--
-- Michael Hanus, October 2001
-----------------------------------------------------------------------------

import List
import Flat

-----------------------------------------------------------------------------
-- pretty printing a list of function names:

ppFunList :: (String->String) -> [String] -> String
ppFunList rename = concat . intersperse ", " . map rename


--- Renaming function from internal names into visible names.
--- If the internal name is exported from the current module,
--- the module prefix is stripped off, otherwise nothing is changed.
--- @param modname - name of the current module
--- @param trans - translation table as in FlatCurry
--- @param iname - internal name to translate
--- @result translated name
stripModName :: String -> [Translation] -> String -> String
stripModName modname trans iname =
   if takeWhile (/='.') iname == modname then revTrans trans iname
                                         else iname
 where
   revTrans [] n = n
   revTrans ((Trans n1 n2):ts) n | n==n2 = n1
                                 | otherwise = revTrans ts n

-- cut the leading path from a file/module name:
cutPath :: String -> String
cutPath p = if suf=="" then pre else cutPath (tail suf)
  where (pre,suf) = break (\x->x=='/') p

-- end of Base
