-----------------------------------------------------------------------------
-- call analysis
--
-- * this analysis is integrated into CIDER and computes the list of all
--   functions that call this function in their defining rules
--
-- * analyseCalledBys is the exported function
--
-- Johannes Koj, October 2000
-----------------------------------------------------------------------------

import Base
import Flat
import Types

-----------------------------------------------------------------------------
-- analysis

analyseCalledBys :: ProgAnalysis String
analyseCalledBys (Prog modname _ _ funs _ trans) = map anaFun funs
 where
   anaFun (Func name _ _ _) =
                  (name, ppFunList rename (concatMap (getCalls name) funs))

   rename = stripModName (cutPath modname) trans


getCalls :: String -> FuncDecl -> [String]
getCalls name1 (Func name2 _ _ (External _)) = []
getCalls name1 (Func name2 _ _ (Rule _ e)) | isCalled name1 e = [name2]
                                           | otherwise        = []

isCalled :: String -> Expr -> Bool
isCalled _ (Var _) = False
isCalled _ (Lit _) = False
isCalled name (Comb _ c es) | c==name   = True
                            | otherwise = or (map (isCalled name) es)
isCalled name (Apply e1 e2)  = (isCalled name e1) || (isCalled name e2)
isCalled name (Constr _ e)   = isCalled name e
isCalled name (Or e1 e2)     = (isCalled name e1) || (isCalled name e2)
isCalled name (Case _ _ ces) = or (map isCalledCase ces)
  where isCalledCase (Branch _ e) = isCalled name e
isCalled name (GuardedExpr _ e1 e2) = (isCalled name e1) || (isCalled name e2)
isCalled name (Choice e) = isCalled name e

-- end of CalledByAnalysis
