import Base
import Evaluator
import Tk
import Flat
import Ports

-- width and height of the debugger window:
width  = 700
height = 600

debugw rename debugserver
  | send (NextExpr initexpr initredex) debugserver
  = TkCol [] [
      TkRow [] [
        TkButton closeH [TkText "Close"],
        TkButton backwH [TkText "<="],
        TkButton fwdH   [TkText "=>"],
        TkButton setBPH [TkText "Set Breakpoint"]
      ],
      TkCanvasScroll [TkRef canvas, TkHeight height, TkWidth width,
                      TkBackground "white",
                      TkItems (expr2citems rename initexpr initredex)],
      TkEntry [TkRef status, TkActive False, TkCmd statusH, TkFillX]
    ]
  where initexpr,initredex,canvas,status free

        closeH gp = send TerminateDebugger debugserver &> tkCExit gp

        backwH gp = let est,expr,redex free
                    in send (PrevExpr expr redex) debugserver &>
                       tkCClearCanvas canvas gp &>
                       tkCConfig canvas
                         (TkItems (expr2citems rename expr redex)) gp

        fwdH gp = let expr,redex free
                  in send (NextExpr expr redex) debugserver &>
                     tkCClearCanvas canvas gp &>
                     tkCConfig canvas
                         (TkItems (expr2citems rename expr redex)) gp

        setBPH gp = tkCConfig status (TkActive True) gp &>
                    tkCConfig status (TkBackground "white") gp &>
                    tkCFocus status gp &>
                    tkCSetValue status "" gp

        statusH gp = let bp free
                     in tkCGetValue status gp bp &>
                        send (SetBreakPoint bp) debugserver &>
                        tkCSetValue status "" gp &>
                        tkCConfig status (TkBackground "lightgray") gp &>
                        tkCConfig status (TkActive False) gp

        addcitems [] _ = success
        addcitems (i:is) gp = tkCConfig canvas i gp &> addcitems is gp

--start expr = openWish "Debugger" >>= (startApp [] expr)

--dbtest = do
--  p <- readFlatCurry "examples/demo"
--  startDebugger p (Comb FuncCall "demo.main" [])

startDebugger :: Prog -> Expr -> IO ()
startDebugger (Prog modname _ _ funs _ trans) e =
    openWish "Debugger" >>=
    startDebuggerWindow (stripModName (cutPath modname) trans) funs e

startDebuggerWindow rename funs (Comb FuncCall c es) gp
  | let p,s free in
    openPort p s &>
    ((let (((redex,rexprs):_),_) = getRedex (initialEst funs
                                                        (Comb FuncCall c es))
                                            (Comb FuncCall ("."++c) es)
     in serveDebug s (Comb FuncCall ("."++c) es) redex rexprs [] [] "" Forward)
     & runWidgetOnPort (debugw rename p) gp)
  = done

data Node = Node String [Node] String Int Int Int

mindiff=7
rowsize=30
colsize=10
topframe=10
leftmargin = 15  -- left margin in canvas

expr2citems ::  (String->String) -> Expr -> Expr -> [TkCanvasItem]
expr2citems rename expr redex =
   node2citems rename 0 (fst3 (expr2node expr redex "black" 0 [1] [0]))

expr2node :: Expr -> Expr -> String -> Int -> [Int] -> [Int] -> (Node,[Int],[Int])
expr2node (Var x) redex color row cols mods = (newnode,setcol row cols (getcol newnode),mods)
  where newcolor=if redex==Var x then "red" else color
        newnode=makeleaf (ppExpr 0 (Var x)) newcolor row cols mods
expr2node (Lit l) redex color row cols mods = (newnode,setcol row cols (getcol newnode),mods)
  where newnode=makeleaf (ppExpr 0 (Lit l)) color row cols mods
expr2node (Constr v e) redex color row cols mods | redex==Constr v e = buildtree "let" [e] redex "red" row cols mods
                                                 | otherwise = buildtree "let" [e] redex color row cols mods
expr2node (Apply e1 e2) redex color row cols mods | redex==Apply e1 e2 = buildtree "@" [e1,e2] redex "red" row cols mods
                                                  | otherwise = buildtree "@" [e1,e2] redex color row cols mods
expr2node (Comb ct c es) redex color row cols mods | ct/=ConsCall = buildtree (getOrigName c) es redex newcolor row cols mods
                                                   | otherwise = buildtree c es redex newcolor row cols mods
  where newcolor=if redex==Comb ct c es then "red" else color
expr2node (GuardedExpr v e1 e2) redex color row cols mods | redex==GuardedExpr v e1 e2 = buildtree "guard" [e1,e2] redex "red" row cols mods
                                                          | otherwise = buildtree "guard" [e1,e2] redex color row cols mods

buildtree :: String -> [Expr] -> Expr -> String -> Int -> [Int] -> [Int] -> (Node,[Int],[Int])
buildtree label es redex color row cols mods = let (ch,newcols,newmods)=visitchildren es (row+1)
                                                                                      (if (length cols)<=(row+1) then (cols++[1]) else cols) 
                                                                                      (if (length cols)<=(row +1) then (mods++[0]) else mods) []
                                                   newnode=makenode label ch color row newcols newmods
                                               in (newnode,setcol row newcols (getcol newnode),updatemods newmods newnode)
  where visitchildren [] _ cs ms nodes = (nodes,cs,ms)
        visitchildren (e:es) r cs ms nodes = let (node,cs2,ms2)=expr2node e redex color r cs ms in visitchildren es r cs2 ms2 (nodes++[node])

node2citems :: (String->String) -> Int -> Node -> [TkCanvasItem]
node2citems rename modsum (Node label [] color row col mod) =
  [TkCText ((col+modsum)*colsize+leftmargin+15,row*rowsize+topframe)
           (rename label)
           ("-fill "++color)]
node2citems rename modsum (Node label (n:ns) color row col mod) = 
  (map (\(Node _ _ _ row2 col2 _)->
         TkLine [((col+modsum)*colsize+leftmargin,row*rowsize+topframe),
                 ((col2+modsum+mod)*colsize+leftmargin,row2*rowsize+topframe)]
                ("-fill "++color)) (n:ns)) ++
  [TkCText ((col+modsum)*colsize+leftmargin+15,row*rowsize+topframe)
           (rename label)
           ("-fill "++color)] ++
  (concatMap (node2citems rename (modsum+mod)) (n:ns))

makeleaf :: String -> String -> Int -> [Int] -> [Int] -> Node
makeleaf label color row cols mods =
   Node label [] color row (cols!!row) (mods!!row)

makenode :: String -> [Node] -> String -> Int -> [Int] -> [Int] -> Node
makenode label nodes color row cols mods =
   Node label nodes color row (col+mod) mod
 where
   col = if (length nodes)>0
         then (foldr (+) 0 (map getcol nodes)) `div` (length nodes)
         else 1
   mod=max2 (mods!!row) ((cols!!row)-col) 
                                     

setcol :: Int -> [Int] -> Int -> [Int]
setcol _ [] _ = []
setcol row (c:cs) x | row==0 = (x+mindiff):cs
                    | otherwise = c:(setcol (row-1) cs x)

updatemods :: [Int] -> Node -> [Int]
updatemods mods (Node _ _ _ row _ mod) = update row mods
  where update r (m:ms) | r==0 = mod:ms
                        | otherwise = m:(update (r-1) ms)

addchildren :: Node -> [Node] -> Node
addchildren n [] = n
addchildren n1 (n2:ns) = addchildren (addchild n1 n2) ns

addchild :: Node -> Node -> Node
addchild (Node label ch color row col mod) newch = Node label (ch++[newch]) color row col mod

getrow :: Node -> Int
getrow (Node _ _ _ row _ _) = row

getcol :: Node -> Int
getcol (Node _ _ _ _ col _) = col

----------------------------------------------------------------------------

data DebugServerMsg = NextExpr Expr Expr
                    | PrevExpr Expr Expr
                    | SetBreakPoint String
                    | TerminateDebugger

data Direction = Forward | Backward

serveDebug eval rigid
serveDebug (TerminateDebugger:_) _ _ _ _ _ _ _ = success

serveDebug ((SetBreakPoint bp):msgs) expr redex rexprs stack history _ dir =
  serveDebug msgs expr redex rexprs stack history bp dir

serveDebug ((NextExpr expr1 redex1):msgs) expr2 redex2 rexprs [] history breakpoint dir
  | rexprs==[] = expr1=:=expr2 &> redex1=:=redex2 &>
                 serveDebug msgs expr2 redex2 rexprs [] history breakpoint Forward
  | otherwise = let break=(breakEval breakpoint redex2) || (redex2==newredex)
                    expr3=set redex2 expr2 (snd (head rexprs))
                    (((newredex,newrexprs):esres),red)=getRedex (fst (head rexprs)) expr3
                    newmsgs=if break then msgs else ((NextExpr expr1 redex1):msgs)
                    newhis=if break then (expr2,redex2,rexprs,[]):history else history
                    newstack=(if (length rexprs)>1 then [(expr2,redex2,tail rexprs)] else [])++
                             (map (\(e,estes)->(expr3,e,estes)) esres)
                in (if break then expr1=:=expr2 &> redex1=:=redex2 else success) &>
                serveDebug newmsgs expr3 newredex newrexprs newstack newhis breakpoint Forward

serveDebug ((NextExpr expr1 redex1):msgs) expr2 redex2 rexprs1 ((expr3,redex3,rexprs2):stack) history breakpoint dir
  | rexprs1==[] = if (breakEval breakpoint redex2) then 
                    expr1=:=expr2 &> redex1=:=redex2 &>
                    serveDebug msgs (Comb FuncCall "failed"[]) redex3 rexprs2 ((expr3,redex3,rexprs2):stack) history breakpoint Forward
                   else
                    serveDebug ((NextExpr expr1 redex1):msgs) (Comb FuncCall "failed"[]) redex3 rexprs2 ((expr3,redex3,rexprs2):stack) history breakpoint Forward
  | expr4==expr2 && (length rexprs1)>1 = expr1=:=expr2 &> redex1=:=redex2 &>
                                         serveDebug msgs expr2 redex2 (tail rexprs1) ((expr3,redex3,rexprs2):stack) ((expr2,redex2,rexprs1,(expr3,redex3,rexprs2):stack):history) breakpoint dir
  | expr4==expr2 = expr1=:=expr2 &> redex1=:=redex2 &>
                   serveDebug msgs expr3 redex3 rexprs2 stack ((expr2,redex2,rexprs1,(expr3,redex3,rexprs2):stack):history) breakpoint Forward
  | otherwise = let (((newredex,newrexprs):esres),red)=getRedex (fst (head rexprs1)) expr4
                    break=(breakEval breakpoint redex2) || (redex2==newredex)
                    newstack=(if (length rexprs1)>1 then [(expr2,redex2,tail rexprs1)] else [])++
                             (map (\(e,estes)->(expr4,e,estes)) esres)++
                             ((expr3,redex3,rexprs2):stack)
                    newmsgs=if break then msgs else ((NextExpr expr1 redex1):msgs)
                    newhis=if break then (expr2,redex2,rexprs1,(expr3,redex3,rexprs2):stack):history else history
                in (if break then expr1=:=expr2 &> redex1=:=redex2 else success) &>
                   serveDebug newmsgs expr4 newredex newrexprs newstack newhis breakpoint Forward
  where expr4=set redex2 expr2 (snd (head rexprs1))


serveDebug ((PrevExpr expr1 redex1):msgs) expr2 redex2 rexprs stack [] breakpoint Forward =
  serveDebug ((PrevExpr expr1 redex1):msgs) expr2 redex2 rexprs stack [] breakpoint Backward

serveDebug ((PrevExpr expr1 redex1):msgs) expr2 redex2 rexprs stack (h:hs) breakpoint Forward =
  serveDebug ((PrevExpr expr1 redex1):msgs) expr2 redex2 rexprs stack hs breakpoint Backward

serveDebug ((PrevExpr expr1 redex1):msgs) expr2 redex2 rexprs stack [] breakpoint Backward =
  expr1=:=expr2 &> redex1=:=redex2 &> 
  serveDebug msgs expr2 redex2 rexprs stack [] breakpoint Backward

serveDebug ((PrevExpr expr1 redex1):msgs) expr2 redex2 rexprs1 [] ((expr3,redex3,rexprs2,stack):history) breakpoint Backward =
  expr1=:=expr3 &> redex1=:=redex3 &> 
  serveDebug msgs expr3 redex3 rexprs2 stack history breakpoint Backward

serveDebug ((PrevExpr expr1 redex1):msgs) expr2 redex2 rexprs1 ((expr4,redex4,rexprs3):stack1) ((expr3,redex3,rexprs2,stack2):history) breakpoint Backward
 = expr1=:=expr3 &> redex1=:=redex3 &>
   serveDebug msgs expr3 redex3 rexprs2 stack2 history breakpoint Backward


breakEval :: String -> Expr -> Bool
breakEval ""     _ = True
breakEval (c:cs) e = let res = [ c | (Comb FuncCall c _) <- [e]]
                      in if res==[]
                         then False
                         else endsWith (getOrigName (head res)) (c:cs)
 where
   endsWith s e = drop (length s - length e) s == e


--auxiliary
max2 x y | x>y = x
         | otherwise = y

fst3 (x,_,_) = x
