-----------------------------------------------------------------------------
-- GUI for programming environment cider
--
-- Johannes Koj, October 2000
-- Modified by Michael Hanus, December 2000
-----------------------------------------------------------------------------

import Conf
import GUIServer
import Tk
import Read
import Ports

-----------------------------------------------------------------------------

mainw guiServer | send (SetEditWindow editwindow) guiServer &>
                  send (GetAnaNames ananames) guiServer =
   TkCol [TkLeft] [
    TkRow [] [
      TkMenuButton [
        TkText "File",
        TkMenu [TkMButton newH "New",
                TkMSeparator,
                TkMButton openH "Open...",
                TkMButton saveH "Save",
                TkMButton saveAsH "Save As...",
                TkMSeparator,
                TkMButton exitH "Exit"]
      ],
      TkMenuButton [
        TkText "Edit",
        TkMenu [TkMButton cutH "Cut",
                TkMButton copyH "Copy",
                TkMButton pasteH "Paste",
                TkMSeparator,
                TkMButton searchH "Search..."]
      ],
      TkMenuButton [
        TkText "Tools",
        TkMenu [TkMButton compileH "Compile",
                TkMButton debugH "Debug 'main'"]
      ]
    ],
    TkRow [] [
      TkCol [] [
        TkCol [] [TkLabel [TkText "Select Function"]],
        TkMatrix []
          [[TkListBox [TkRef topfunwindow, TkWidth 18, TkHeight 23,
                       TkBackground "yellow", TkCmd topfunH, TkFillY],
            TkScrollV topfunwindow [TkFillY]],
           [TkScrollH topfunwindow [TkFillX]]]
      ],
      TkCol [] [
        TkCol [] [TkLabel [TkRef editlabel, TkText "Edit Window"]],
        TkTextEditScroll [TkRef editwindow, TkWidth 70, TkHeight 28,
                          TkBackground "white"]
      ],
      TkCol [] [
        TkCol [] [TkLabel [TkText "Select Analysis"]],
        TkListBox [TkRef anawindow, TkWidth 18, TkHeight 23, TkList ananames,
                   TkBackground "yellow", TkCmd anawinH, TkFillY]
      ]
    ],
    TkRow [] [
      TkTextEditScroll [TkRef infowindow, TkWidth 110, TkHeight 8]
    ],
    TkRow [] [
      TkTextEdit [TkRef statuswindow, TkCmd statusH, TkActive False,
                  TkTcl "-relief raised", TkWidth 90, TkHeight 1, TkFillX]
    ]
  ]
  where topfunwindow,anawindow,editwindow,infowindow,statuswindow,
                     editlabel,ananames free

        exitH gp = send Terminate guiServer &> tkCExit gp

        newH gp = let editwin free
                  in send (GetEditWindow editwin) guiServer &>
                     send New guiServer &>
                     tkCSetValue editlabel "Edit Window" gp &>
                     tkCSetValue editwin "" gp &>
                     tkCSetValue infowindow "" gp &>
                     tkCConfig topfunwindow (TkList []) gp

        openH gp =
          let editwin,anaindex,ana,filename,contents,topfuns,parserout free
          in tkCGetOpenFile filename filterOpenFiles gp &>
             if filename==""
             then success
             else tkCSetValue editlabel filename gp &>
                  tkCSetValue infowindow "" gp &>
                  tkCConfig infowindow (TkBackground "lightgray") gp &>
                  tkCConfig statuswindow (TkActive True) gp &>
                  tkCConfig statuswindow (TkBackground "red") gp &>
                  tkCSetValue statuswindow "Compiling ..." gp &>
                  tkCConfig statuswindow (TkActive False) gp &>
                  send (Open filename contents parserout topfuns) guiServer &>
                  tkCConfig statuswindow (TkActive True) gp &>
                  tkCSetValue statuswindow "" gp &>
                  tkCConfig statuswindow (TkBackground "lightgray") gp &>
                  tkCConfig statuswindow (TkActive False) gp &>          
                  tkCConfig infowindow (TkBackground "white") gp &>
                  tkCSetValue infowindow parserout gp &>
                  send (GetEditWindow editwin) guiServer &>
                  tkCSetValue editwin contents gp &>
                  tkCConfig topfunwindow (TkList topfuns) gp &>
                  tkCGetValue anawindow gp anaindex &>
                  (if anaindex==""
                   then success
                   else tkCGetListbox anawindow (readNat anaindex) ana gp &>
                        send (SetAna ana) guiServer )

        saveH gp = let contents,editwin free
                   in send (GetEditWindow editwin) guiServer &>
                      tkCGetValue editwin gp contents &>
                      send (Save contents) guiServer

        saveAsH gp =
          let filename,contents,editwin free
          in tkCGetSaveFile filename
                            [("Curry Files",".curry"),
                             ("Literate Curry files",".lcurry")] gp &>
             send (GetEditWindow editwin) guiServer &>
             tkCGetValue editwin gp contents &>
             send (SaveAs filename contents) guiServer

        cutH gp = let editwin,cs free
                  in send (GetEditWindow editwin) guiServer &>
                     tkCCut editwin cs gp &>
                     send (SetCopyString cs) guiServer

        copyH gp = let editwin,cs free
                   in send (GetEditWindow editwin) guiServer &>
                      tkCCopy editwin cs gp &>
                      send (SetCopyString cs) guiServer

        pasteH gp = let editwin,cs free
                    in send (GetEditWindow editwin) guiServer &>
                       send (GetCopyString cs) guiServer &>
                       tkCPaste editwin cs gp

        searchH gp = send (SetStatusMode "search") guiServer &>
                     tkCConfig statuswindow (TkActive True) gp &>
                     tkCConfig statuswindow (TkTcl "-relief sunken") gp &>
                     tkCConfig statuswindow (TkBackground "red") gp &>
                     tkCFocus statuswindow gp

        statusH gp = let mode free
                     in send (GetStatusMode mode) guiServer &>
                        if mode=="search" then search gp else success

        topfunH gp =
          let editwin,index1,index2,name free
          in send (GetEditWindow editwin) guiServer &>
             getListBoxName topfunwindow name gp &>
             searchDef (name++" ") editwin (0,1) 0 index1 &>
             (if (index1/=(-1,-1))
              then tkCSeeI editwin index1 gp
              else (searchDef ("> "++name++" ") editwin (0,1) 0 index2 &>
                    if (index2/=(-1,-1))
                    then tkCSeeI editwin index2 gp
                    else success)) &>
             anaH gp
          where
            searchDef pattern win (r,c) maxrow res
              | c==0 = res=:=(r,c)
              | r<maxrow = res=:=(-1,-1)
              | otherwise = let index free
                            in tkCSearchI win pattern (r,c+1) index gp &>
                               if index==""
                               then res=:=(-1,-1)
                               else let (r2,c2) = string2index index 
                                        newmaxrow = if r2>maxrow
                                                    then r2
                                                    else maxrow
                                    in searchDef pattern win
                                           (string2index index) newmaxrow res

        anawinH gp = let ana free
                     in getListBoxName anawindow ana gp &>
                        send (SetAna ana) guiServer &>
                        anaH gp

        anaH gp =
          let result,fun,color,index free
          in tkCGetValue topfunwindow gp index &>
             (if index==""
              then success
              else tkCGetListbox topfunwindow (readNat index) fun gp &>
                   tkCSetValue infowindow "" gp &>
                   tkCConfig infowindow (TkBackground "lightgray") gp &>
                   tkCConfig statuswindow (TkActive True) gp &>
                   tkCConfig statuswindow (TkBackground "red") gp &>
                   tkCSetValue statuswindow "Analyzing ..." gp &>
                   tkCConfig statuswindow (TkActive False) gp &>
                   send (GetAnaRes fun result color) guiServer &>
                   tkCConfig statuswindow (TkActive True) gp &>
                   tkCSetValue statuswindow "" gp &>
                   tkCConfig statuswindow (TkBackground "lightgray") gp &>
                   tkCConfig statuswindow (TkActive False) gp &>
                   tkCConfig infowindow (TkBackground "white") gp &>
                   tkCSetValue infowindow result gp &>
                   tkCSetListColor topfunwindow (readNat index) color gp )

        compileH gp =
          let editwin,contents1,contents2,topfuns,parserout,anaindex,ana free
          in send (GetEditWindow editwin) guiServer &>
             tkCGetValue editwin gp contents1 &>
             send (Save contents1) guiServer &>
             tkCSetValue infowindow "" gp &>
             tkCConfig infowindow (TkBackground "lightgray") gp &>
             tkCConfig statuswindow (TkActive True) gp &>
             tkCConfig statuswindow (TkBackground "red") gp &>
             tkCSetValue statuswindow "Compiling ..." gp &>
             tkCConfig statuswindow (TkActive False) gp &>
             send (Open "" contents2 parserout topfuns) guiServer &>
             tkCConfig statuswindow (TkActive True) gp &>
             tkCSetValue statuswindow "" gp &>
             tkCConfig statuswindow (TkBackground "lightgray") gp &>
             tkCConfig statuswindow (TkActive False) gp &>
             tkCConfig infowindow (TkBackground "white") gp &>
             tkCSetValue infowindow parserout gp &>
             tkCConfig topfunwindow (TkList topfuns) gp &>
             tkCGetValue anawindow gp anaindex &>
             (if anaindex==""
              then success
              else tkCGetListbox anawindow (readNat anaindex) ana gp &>
                   send (SetAna ana) guiServer )

        debugH gp =
          let answer free
          in tkCSetValue infowindow "" gp &>
             tkCConfig infowindow (TkBackground "lightgray") gp &>
             send (StartDebugger answer) guiServer &>
             tkCConfig infowindow (TkBackground "white") gp &>
             tkCSetValue infowindow answer gp

        search gp =
          let editwin,pattern,index free
          in send (GetEditWindow editwin) guiServer &>
             tkCGetValue statuswindow gp pattern &>
             if (pattern/="" && (last pattern)=='\n')
             then send (SetStatusMode "") guiServer &>
                  tkCSetValue statuswindow "" gp &>
                  tkCConfig statuswindow (TkActive False) gp &>
                  tkCConfig statuswindow (TkBackground "lightgray") gp &>
                  tkCConfig statuswindow (TkTcl "-relief raised") gp &>
                  tkCDelTag editwin "patterntag" gp &>
                  tkCIncMark editwin 1 gp
            else tkCSearchM editwin pattern TkInsert index gp &>
                 if (index/="")
                 then let (r,c)=string2index index in
                      tkCSetMark editwin (r,c) TkInsert gp &>
                      tkCSeeM editwin TkInsert gp &>
                      tkCDelTag editwin "patterntag" gp &>
                      tkCAddTag editwin "patterntag" (r,c)
                                        (r,c+(length pattern)) gp &>
                      tkCSetTagBackground editwin "patterntag" "red" gp
              else tkCSetValue statuswindow "no match" gp &>
                   tkCConfig statuswindow (TkActive False) gp &>
                   wait 50000 &> 
                   tkCConfig statuswindow (TkActive True) gp &>
                   tkCSetValue statuswindow pattern gp

        getListBoxName listbox name gp =
              let index free
              in tkCGetValue listbox gp index &>
                 tkCGetListbox listbox (readNat index) name gp

-----------------------------------------------------------------------------
-- auxiliary

last (x:xs) = if xs==[] then x else last xs

wait n = if n==0 then success else wait (n-1)

-----------------------------------------------------------------------------