import Flat
import DaVinci

-- The general type of each program analysis.
-- A program analysis is a mapping from (FlatCurry) programs into
-- a list which associates to each (internal) function name an
-- analysis result.

type ProgAnalysis a = Prog -> [(String,a)]


-- The result type of analyzing a single function to be shown in
-- the CIDER environment. Thus, each program analysis to be
-- integrated in CIDER (see module "Conf") must be of type
-- (ProgAnalysis AnaRes).
-- A "Message" denotes a textual result and a "Graph" denotes
-- a graph (to be visualized by DaVinci) as a result.
-- The second argument is in both cases a color for the
-- function entry (works only in newer versions of Tk)

data AnaRes = Message String String | Graph DvGraph String

