-----------------------------------------------------------------------
-- Some extensions of the standard TK library of PAKCS
-----------------------------------------------------------------------
-- This file must be appended to the standard Tk library
-- and the export list must be extended by:
--
-- TkMarkItem(..),string2index,tkCGetOpenFile,tkCGetSaveFile,
-- tkCSeeI,tkCSeeM,tkCSearchI,tkCSearchM,tkCCopy,tkCCut,tkCPaste,
-- tkCSetMark,tkCIncMark,tkCAddTag,tkCDelTag,tkCSetTagBackground,
-- tkCSetListColor,tkCClearCanvas,tkCGetListbox

-- modal dialogs

tkCGetOpenFile :: String -> [(String,String)] -> Port SP_Msg -> Success
tkCGetOpenFile filename filetypes wp
 | send (SP_Put ("puts [tk_getOpenFile -filetypes {"++(concat (map (\(x,y)->"{{"++x++"} {"++y++"}} ") filetypes))++"}]\n")) wp &>
   send (SP_GetLine filename) wp
 = success

tkCGetSaveFile :: String -> [(String,String)] -> Port SP_Msg -> Success
tkCGetSaveFile filename filetypes wp
 | send (SP_Put ("puts [tk_getSaveFile -filetypes {"++(concat (map (\(x,y)->"{{"++x++"} {"++y++"}} ") filetypes))++"}]\n")) wp &>
   send (SP_GetLine filename) wp
 = success

-- widget commands

type TkIndex = (Int,Int)

data TkMarkItem = TkInsert | TkCurrent | TkUserDefinedMark String
data TkTagItem = TkTag String

data TkCommandItem =
  TkSeeI TkIndex |   -- for text widgets only: see index
  TkSeeM TkMarkItem |
  TkSetMark TkMarkItem TkIndex |  -- for text widgets only: set mark to index
  TkIncMark TkMarkItem Int |       -- for text widgets only: inc mark
  TkAddTag TkTagItem TkIndex TkIndex | -- for text widgets only
  TkDelTag  TkTagItem |
  TkSetTagBackground TkTagItem String |
  TkSetListColor Int String | -- for listbox widgets: set (foreground) color of item
  TkClear | -- clear for canvas widgets only
  TkPaste String

data TkCommandRetItem =
  TkSearchM String TkMarkItem | -- for text widgets only: search pattern from index
  TkSearchI String TkIndex |
  TkGet Int | -- for listbox widgets: get the contents of index
  TkCut |    -- for text widgets only: cut marked text
  TkCopy   -- for textedit widgets: copy marked text

string2index s = ((readNat r),(readNat c))
  where (r,_:c) = span (\x->(x/='.')) s

tkCSeeI eval rigid
tkCSeeI (TkRefLabel wpv var wtype) (r,c) wport
  | checkWishConsistency wpv wport &>
    send (SP_Put cmd) wport
  = success
  where label=(tkRefname2Label var)
        cmd=if wtype=="textedit" then label++" see "++(show r)++"."++(show c)++"\n"
              else trace ("WARNING: TkSeeI ignored for widget type \""++wtype++"\"\n") ""


tkCSeeM eval rigid
tkCSeeM (TkRefLabel wpv var wtype) TkInsert wport
  | checkWishConsistency wpv wport &>
    send (SP_Put cmd) wport
  = success
  where label=(tkRefname2Label var)
        cmd=if wtype=="textedit" then label++" see "++"insert"++"\n"
              else trace ("WARNING: TkSeeM ignored for widget type \""++wtype++"\"\n") ""

tkCSearchI eval rigid
tkCSearchI (TkRefLabel wpv var wtype) pattern (r,c) retVar wport
  | checkWishConsistency wpv wport &>
    send (SP_Put cmd) wport &>
    tkGetVarMsg "tkCmdRetVar" wport retVar
  = success
  where label=(tkRefname2Label var)
        cmd=if wtype=="textedit" then "putvar tkCmdRetVar ["++label++" search \""++pattern++"\" "++(show r)++"."++(show c)++"]\n"
              else trace ("WARNING: TkSearchI ignored for widget type \""++wtype++"\"\n") ""


tkCSearchM eval rigid
tkCSearchM (TkRefLabel wpv var wtype) pattern TkInsert retVar wport
  | checkWishConsistency wpv wport &>
    send (SP_Put cmd) wport &>
    tkGetVarMsg "tkCmdRetVar" wport retVar
  = success
  where label=(tkRefname2Label var)
        cmd=if wtype=="textedit" then "putvar tkCmdRetVar ["++label++" search \""++pattern++"\" "++"insert"++"]\n"
              else trace ("WARNING: TkSearchM ignored for widget type \""++wtype++"\"\n") ""

tkCCopy eval rigid
tkCCopy (TkRefLabel wpv var wtype) retVar wport
  | checkWishConsistency wpv wport &>
    send (SP_Put cmd) wport &>
    tkGetVarMsg "tkCmdRetVar" wport retVar
  = success
  where label=(tkRefname2Label var)
        cmd=if wtype=="textedit" then "if {["++label++" tag ranges sel] != \"\"} then {"++
                                      "set x [split ["++label++" tag ranges sel] \" \"]; "++
                                      "putvar tkCmdRetVar ["++ label++" get [lindex $x 0] [lindex $x 1]]}"++
                                      " else {putvar tkCmdRetVar \"\"}"
              else trace ("WARNING: TkCopy ignored for widget type \""++wtype++"\"\n") ""

tkCCut eval rigid
tkCCut (TkRefLabel wpv var wtype) retVar wport
  | checkWishConsistency wpv wport &>
    send (SP_Put cmd) wport &>
    tkGetVarMsg "tkCmdRetVar" wport retVar
  = success
  where label=(tkRefname2Label var)
        cmd=if wtype=="textedit" then "if {["++label++" tag ranges sel] != \"\"} then {"++
                      "set x [split ["++label++" tag ranges sel] \" \"]; "++
                      " putvar tkCmdRetVar ["++label++" get [lindex $x 0] [lindex $x 1]]; "++
                      " set z \"\";"++
                      "append z ["++label++" delete [lindex $x 0] [lindex $x 1]] $y}"++
                      " else {putvar tkCmdRetVar \"\"}\n"
              else trace ("WARNING: TkCut ignored for widget type \""++wtype++"\"\n") ""

tkCPaste eval rigid
tkCPaste (TkRefLabel wpv var wtype) s wport
  | checkWishConsistency wpv wport &>
    send (SP_Put cmd) wport
  = success
  where label=(tkRefname2Label var)
        cmd=if wtype=="textedit" then label++" insert ["++label++" index insert] \""++(escape_tcl s)++"\"\n"
              else trace ("WARNING: TkPaste ignored for widget type \""++wtype++"\"\n") ""

tkCSetMark eval rigid
tkCSetMark (TkRefLabel wpv var wtype) (r,c) TkInsert wport
  | checkWishConsistency wpv wport &>
    send (SP_Put cmd) wport
  = success
  where label=(tkRefname2Label var)
        cmd=if wtype=="textedit" then label++" mark set insert "++(show r)++"."++(show c)++"\n"
              else trace ("WARNING: TkSetMark ignored for widget type \""++wtype++"\"\n") ""

tkCIncMark eval rigid
tkCIncMark (TkRefLabel wpv var wtype) i wport
  | checkWishConsistency wpv wport &>
    send (SP_Put cmd) wport
  = success
  where label=(tkRefname2Label var)
        cmd=if wtype=="textedit" then label++" mark set insert \"insert + "++(show i)++" chars\"\n"
              else trace ("WARNING: TkIncMark ignored for widget type \""++wtype++"\"\n") ""

tkCAddTag eval rigid
tkCAddTag (TkRefLabel wpv var wtype) tagname (r1,c1) (r2,c2) wport
  | checkWishConsistency wpv wport &>
    send (SP_Put cmd) wport
  = success
  where label=(tkRefname2Label var)
        cmd=if wtype=="textedit" then label++" tag add "++tagname++" "++(show r1)++"."++(show c1)++" "++(show r2)++"."++(show c2)++"\n"
              else trace ("WARNING: TkAddTag ignored for widget type \""++wtype++"\"\n") ""

tkCDelTag eval rigid
tkCDelTag (TkRefLabel wpv var wtype) tagname wport
  | checkWishConsistency wpv wport &>
    send (SP_Put cmd) wport
  = success
  where label=(tkRefname2Label var)
        cmd=if wtype=="textedit" then label++" tag delete "++tagname++"\n"
              else trace ("WARNING: TkDelTag ignored for widget type \""++wtype++"\"\n") ""

tkCSetTagBackground eval rigid
tkCSetTagBackground (TkRefLabel wpv var wtype) tagname color wport
  | checkWishConsistency wpv wport &>
    send (SP_Put cmd) wport
  = success
  where label=(tkRefname2Label var)
        cmd=if wtype=="textedit" then label++" tag configure "++tagname++" -background \""++color++"\"\n"
              else trace ("WARNING: TkSetTagBackground ignored for widget type \""++wtype++"\"\n") ""

tkCSetListColor eval rigid
tkCSetListColor (TkRefLabel wpv var wtype) i color wport
  | checkWishConsistency wpv wport &>
    send (SP_Put cmd) wport
  = success
  where label=(tkRefname2Label var)
        cmd=if wtype=="listbox" then label++" itemconfigure "++(show i)++" -foreground "++color++"\n"
              else trace ("WARNING: TkSetListColor ignored for widget type \""++wtype++"\"\n") ""

tkCClearCanvas eval rigid
tkCClearCanvas (TkRefLabel wpv var wtype) wport
  | checkWishConsistency wpv wport &>
    send (SP_Put cmd) wport
  = success
 where
   label = tkRefname2Label var
   cmd = if wtype=="canvas"
         then label++" addtag cleartag all\n"++label++" delete cleartag\n"
         else trace ("WARNING: TkCanvasClear ignored for widget type \""
                     ++wtype++"\"\n") ""

tkCGetListbox eval rigid
tkCGetListbox (TkRefLabel wpv var wtype) i retVar wport
  | checkWishConsistency wpv wport &>
    send (SP_Put cmd) wport &>
    tkGetVarMsg "tkCmdRetVar" wport retVar
  = success
 where
   label = tkRefname2Label var

   cmd = if wtype=="listbox"
         then "putvar tkCmdRetVar ["++label++" get "++(show i)++"]\n"
         else trace ("WARNING: TkListboxGet ignored for widget type \""
                     ++wtype++"\"\n") ""


-- end of Tk extensions
