-- "parallel" conjunction:
pand False     _ = False
pand _     False = False
pand True  True  = True

--main = and f f

f = g

g = False

hd (x:xs) = x

----------------------------------------------------------------------
-- quicksort:
qsort :: [Int] -> [Int] 
qsort []     = []
qsort (x:l)  = qsort (filter (gt x) l) ++ x : qsort (filter (leq x) l)

gt  x y = x > y
leq x y = x <= y

--main = qsort [5,0,3,1,2,4,8,6,9,7]

----------------------------------------------------------------------

append :: [t] -> [t] -> [t]
append []     x  = x
append (x:xs) ys = x : append xs ys

last xs | xs=:=append ys [x] = x  where x,ys free

--main = last [1]

-- reverse the order of elements in a list:

rev :: [t] -> [t]
rev []     = []
rev (x:xs) = append (rev xs) [x]

--main = rev [1,2,3,4,5,6,7,8,9,10,1,2,3,4,5,6,7,8,9,10,1,2,3,4,5,6,7,8,9,10]

-----------------------------------------------------------------------
-- Concurrent object-oriented programming in Curry:
-- a bank account implemented as an object waiting for messages of type
-- Deposit a, Withdraw a, or Balance b:

data Message = Deposit Int | Withdraw Int | Balance Int

account :: Int -> [Message] -> Success
account eval rigid  -- account is a consumer
account _ []                 =  success
account n (Deposit  a : ms)  =  account (n+a) ms
account n (Withdraw a : ms)  =  account (n-a) ms
account n (Balance  b : ms)  =  b=:=n & account n ms

make_account s = account 0 s -- create bank account

main = let x free in start x

-- send a message:
sendMsg msg obj | obj =:= msg:obj1  = obj1  where obj1 free  -- send a message

-- client process for bank account:
client s | s1 =:= sendMsg (Balance b) s =
  if b==50 then s1=:=[]   -- stop process
           else if b>50 then client (sendMsg (Withdraw 30) s1)  -- buy
                        else client (sendMsg (Deposit  70) s1)  -- work
  where s1,b free

start s = make_account s & client (sendMsg (Deposit 100) s) -- simulation

double x = x+x

z = 0
z = 1

--main = double z
 
--main = z + z
