# cass-analysis - Base libraries and implementation of program analyses for CASS

This directory contains the implementation of various
program analyses which can be used with CASS
(the Curry Analysis Server System), available in the package `cass`.

To use an analysis in CASS, it needs to be registered (see the
constant `registeredAnalysis` in module `CASS.Registry` of package `cass`).
The possible types of analyses to be registered are defined in
module `Analysis.Types`. The analyses types are parametric w.r.t. the
domain of abstract values. In order to compare values (e.g., to check
whether a fixpoint is reached) or to persistently store analyses
results (to support an incremental modular analysis), the type
of analysis values must be instances of the classes
`Eq`, `Read`, `Show`, and `ReadWrite`. The latter class
is required to support a compact and faster processing of data.

Whereas instances of `Eq`, `Read`, and `Show` can be automatically
derived (via a `deriving` annotation in the type definition),
instances of `ReadWrite` can be generated by the tool `curry-rw-data`.
This tool is available as a Curry package and can be installed by

    > cypm install rw-data-generator

Then, `ReadWrite` instances of all data types defined in module `Mod`
can be generated by the command

    > curry-rw-data Mod

This generates a new module `ModRW` containing the instance
definitions. To use these in CASS, it is reasonable to put
these instances into the module implementing the analysis.
See module `Analysis.Deterministic` for an example for this strucutre.

Technical details
-----------------

The ideas behind the construction of various program analyses
can be found in this paper:

M. Hanus, F. Skrlac:
[A Modular and Generic Analysis Server System for Functional Logic Programs](https://dx.doi.org/10.1145/2543728.2543744),
ACM SIGPLAN 2014 Workshop on Partial Evaluation and Program Manipulation
(PEPM'14), ACM Press, pp. 181-188, 2014
