Change log for curry-frontend
=============================

Version 3.1.0
=============

  Features
  --------
  * Added support for attaching quick fix suggestions to error messages.
    - Implemented quick fixes for unused variable warnings.
    - Implemented quick fixes for case mode warnings.
    - Implemented quick fixes for errors from missing function implementations.
    - Implemented quick fixes for missing field warnings.
  * The case mode of variables is now checked before the type checker, to improve
    error messages related to wrongly (de-)capitalized names.

  Bug fixes
  ---------
  * Fixed some instances where lazy pattern matches were discarded during desugaring.


  Breaking changes for library users
  ----------------------------------

  * FlatCurry `Expr` now annotates local variables with types:
    - `Free [(VarIndex, TypeExpr)]` (was `[VarIndex]`),
    - `Let [(VarIndex, TypeExpr, Expr)]` (was `[(VarIndex, Expr)]`).

  Library updates
  ---------------
  * Bumped stack resolver to 23.19

  CI changes
  ----------
  * Switched to GitHub CI

Version 3.0.0
=============

  Features
  --------
  * Added support for multi-parameter type classes (enabled with `-XMultiParamTypeClasses`),
    allowing type classes to be constrained across multiple type variables.
  * Added support for functional dependencies (enabled with `-XFunctionalDependencies`),
    enabling a class type variable to depend on another class variable.
  * Added support for flexible contexts (enabled with `-XFlexibleContexts`),
    relaxing rules on context specifications so that some class variables can be fixed to specific types.
  * Added support for flexible instances (enabled with `-XFlexibleInstances`),
    which allows similar flexibility in type class instances.
  * `-XFunctionalDependencies` implies `-XMultiParamTypeClasses`.
  * Prefixed frontend modules with `Curry.Frontend` to improve usability as a library

  Improvements
  ------------
  * Use Eq.== instead of Data.=== for primitive type comparisons to prevent non-deterministic issues in KiCS2.

  Bug fixes
  ---------
  * Fixed a bug in the annotated types of certain functional patterns.

Version 2.1.1
=============

  Improvements for downstream tools
  ---------------------------------

  * Generated interface files now optionally include a pragma that indicates the source code origin of identifiers. This improves the language server.
  * Added the option `-Oadd-failed-case`. If on, the front-end inserts explicit branches for failing pattern matches in each case and rule. It is on by default. The old behavior can be restored with `-Ono-add-failed-case`.

  Bug fixes
  ---------
  * Fixed a bug where the AST information gets printed in a wrong order.

Version 2.1.0
=============

  Breaking changes
  ----------------
  * Enabled 'AnonFreeVars' and 'FunctionalPatterns' extensions by default
  * Added 'NoFunctionalPatterns' and 'NoAnonFreeVars' Language extensions to disable the respective extensions
  * Added 'NoDataDeriving' language extension to disable automatic deriving of 'Data' instances (implied by 'NoImplicitPrelude')
  * Deprecated the '--extended' options to enable 'AnonFreeVars' and 'FunctionalPatterns' (now on by default)

  Improvements
  ------------
  * Improved handling of implied language extensions
  * Improved handling of tool options via pragmas
  * Improved desugaring of (non-linear) functional pattern
  * Improved desugaring of string literal pattern in case-expressions

  Bug fixes
  ---------
  * Fixed bug with tuple constructor not being recognized in some cases
  * Fixed bug where a cyclic module import leads to a compiler crash in rare cases
  * Fixed multiple bugs where type annotations in the generated flat curry code were incorrect

  CI, library and build improvements
  ----------------------------------
  * Now using GHC 9.2.7 (stack LTS 20.22)
  * Added the option ('-tbfc') to export typed flat curry in a binary format
  * Passes 'allow-different-user' to stack to fix CI and multi-user problems
  * Stack is now using a locally installed GHC to avoid build problems
  * Added *.hie file to improve IDE support for development of the complier frontend
  * Added gitlab CI pipeline configuration
  * Exported and generalizeed various files and functions for consuption in different tools (backends, language server)

Version 2.0.0
=============

  * Implemented the "MonadFail-Proposal" for curry
    (see <https://wiki.haskell.org/MonadFail_Proposal>)
  * Data class (see <https://arxiv.org/abs/1908.10607>)
  * Fixed bug with partially imported Typeclasses
  * Fixed bug with parsing of empty blocks
  * Fixed bug with re-export of record labels

Version 1.0.4
=============

  * Fixed bug in type checking of instances
  * Fixed bugs in deriving of `Bounded` instances.

Version 1.0.3
=============

  * Fixed bug in type checking of typeclasses

Version 1.0.2
=============

  * Added 'short-ast' and 'ast' as new compilation targets
  * Fixed bug with wrong type of free variables in the intermediate language.
  * Fixed bug with generated default implementations of nullary class methods.
  * Fixed bug in desugaring of record patterns.
  * Fixed bug that external data declarations weren't considered when
    AbstractCurry was generated

Version 1.0.1
=============

  * Fixed bug with wrong order of super classes in selector functions
    generated by the dictionary transformation.
  * Changed desugaring of numeric literals. It now generates calls to the
    functions `Prelude.fromInt` and `Prelude.fromFloat`.
  * Fixed bug with wrong original names of imported record labels
  * Fixed bug when compiling type constructor classes with super classes
  * Adjusted warning message for potentially unreachable pattern matches

Version 1.0.0
=============

  * Added support for typeclasses as known from Haskell

Version 0.4.2
=============

  * Improved readability of environment information in dumps
    (option dump-simple)
  * Added option to dump all bindings instead of just local ones
    (dump-all-bindings)
  * Introduced annotated FlatCurry as a new output format
    (annotated-flat)

Version 0.4.1
=============

  * Added a simple cabal test suite
  * Split import of interfaces/modules and expansion and checking of
    import specifications into two modules.
  * Improved error messages generated by export check (fixes #1253)
  * Split checking and expansion of export specification into two
    subsequent steps (by Yannik Potdevin, fixes #1335)
  * Consider parenthesized type expressions in the Curry AST (by Katharina Rahf)
  * Added syntax extension `ExistentialQuantification` that allows the use
    of existentially quantified types in data and newtype constructors
  * Fixed bug that type declarations weren't syntax checked

Version 0.4.0
=============

  * Refactored AbstractCurry generation

  * Complete refactoring of FlatCurry generation

  * Removed support for Curry's record syntax and introduced Haskell's record
    syntax instead

  * During desugaring record updates are translated to fcase-expressions instead
    of introducing explicit update functions

  * HTML generation now places HTML files for hierarchical modules into
    files named `<Module>_curry.html`, i.e., no sub-folders reflecting
    the the module name hierarchy are generated. In addition, if the option
    `--html-dir` is not given, the current directory is used as the output
    directory.

  * Removed record type extensions

  * Enabled declaration of (mutually) recursive record types

  * Removed expansion of record types in type error messages

  * Replaced `MessageM` monad with `CYT` monads and moved `CYT` monads
    to package `curry-base`

  * Implemented warnings for overlapping module aliases - fixes #14

  * The check for overlapping rules has been completely refactored and
    improved to now also handle rigid case expressions.

  * The check for missing pattern matching alternatives now correctly handles
    String literals - fixes #1048.

  * Added warnings for top-level functions without type signatures - fixes #769

  * Moved pretty-printing of types from Checks.TypeCheck to Base.CurryTypes

  * Type synonyms in typed expressions are now desugared - fixes #921

  * Declaration of operator precedence is now optional in infix operator
    declarations

  * Moved module `InterfaceEquivalence` to curry-base
    (`Curry.Syntax.InterfaceEquivalence`)

  * Converted literate Haskell files into simple Haskell files

  * Removed support for FlatCurry XML files.

  * Added syntax extension `NegativeLiterals` to translate negated literals
    into negative literals instead of a call to `Prelude.negate` and
    `Prelude.negateFloat`, respectively.

  * The frontend now considers options pragmas of the following form:

    ~~~ {.curry}
    {-# OPTIONS_CYMAKE opt1 ... optn #-}
    ~~~

    The string following `OPTIONS_CYMAKE` will be split at white spaces
    and treated like an ordinary command line argument string.

    If one wishes to provide options containing spaces, e.g., directory
    paths or alike, this can be achieved by quoting the respective argument
    using either `'single quotes'` or `'double quotes'` (may bot be mixed).

    Note that *following options are excluded*:

      * A change of the current mode
        (e.g., change from compilation to HTML generation)
      * A change of the import  paths
      * A change of the library paths
      * A change of the compilation targets
        (e.g., change from FlatCurry to AbstractCurry)

    These options can only be set via the command line.

  * Refactored the source code HTML generation.
    The generation now supports full Curry with all supported extensions,
    i.e., it supports pragmas, record types and functional patterns.
    Furthermore, the created HTML has been simplified, and updated towards
    HTML 5.

  * The HTML generation now accepts an option `--htmldir=dir` to specify
    the output directory of the generated HTML files.

Version 0.3.10
==============

  * Various improvements of the internal structure.

  * Improved status messages. The compilation status message are now of the form

        [m of n] Compiling/Skipping <Module> (<source file>, <target file>)

  * Implemented support for custom preprocessors. It is now possible to run
    a custom preprocessor command via the following options:

    * `-F` enables support for a preprocessor
    * `-pgmF <cmd>` set the preprocessor command to `<cmd>`
    * `-optF <arg>` adds an additional argument to the preprocessor command
      (can be repeated to add multiple arguments)

    The preprocessor is applied to all source files which are (re)compiled
    after unliterating *and after determining the import list*.
    Consequently, adding modules via the preprocessor will results in
    compilation errors due to missing imports.
    On the other hand, the frontend will automatically determine changed
    files which are then handed to the preprocessor.

    The command is called with at least three arguments:

     #. The (normalised) file name of the source file currently processed.
        **This name is intended only for reference.**
     #. The name of the file containing the (potentially unliterated)
        contents of the original file.
        **This is the file the preprocessor should read from.**
     #. The name of the file where the preprocessed source code should go to.
        **This is the file the preprocessor should write to.**
     #. Optionally, any additional arguments specified using `-optF`.

Version 0.3.9
=============

  * Simplified verbosity options by merging options "-v1" and "-v2".
    Now only "-v0" and "-v1" are supported.

  * Fixed bug in non-exhaustive pattern matching check which occured
    when retrieving the siblings of a constructor imported using an alias.

  * Fixed bug when using functional patterns in `case`-expressions.
    Functional patterns are only allowed in the patterns of a function
    definition and forbidden elsewhere, i.e., in `case`-expressions,
    `do`-sequences, list comprehensions or lambda expressions.

  * Implementation of module pragmas added. Module pragmas of the following
    types are now parsed and represented in the abstract syntax tree:

    ~~~ {.curry}
    {-# LANGUAGE LANG_EXT+ #-}
    {-# OPTIONS "string" #-}
    {-# OPTIONS_TOOL "string" #-}
    module Main where
    ~~~

    where

      - `LANGEXT+` is a non-empty, comma-separated list of the following
        language extensions: `AnonFreeVars`, `FunctionalPatterns`,
        `NoImplicitPrelude`, `Records`
      - `TOOL` is either `KICS2`, `PAKCS`, or some other tool, represented
        as `Unknown String`.

    While the distinct language pragmas enable the respective language
    extensions, the OPTIONS pragma is ignored.

    All other texts given in the pragma braces is ignored and treated as
    a nested comment.

  * Error message for different arities of function equations now also
    report the corresponding source code positions.

Version 0.3.8
=============

  * Implemented warnings for non-exhaustive pattern matchings
    both in function declarations and `case`-expressions - fixes #349.

  * Extended options to enable/disable certain types of warnings.

  * Fixed problem when defining an operator directly after an import statement
    without import restrictions - fixes #494.

  * Fixed bug w.r.t. polymorphically typed local variables - fixes #480.

  * Fixed missing polymorphism in record labels - fixes #445.

  * Dumping of intermediate structures improved.

  * Fixed bug in type checking w.r.t. recursive type synonyms - fixes 489.

  * Reactivation of Curry interface files.
    During adaption of the MCC frontend to FlatCurry the Curry interface
    files have been deactivated and replaced by FlatCurry's interface
    files. To allow the later addition of type classes to Curry,
    they have now been reactivated.

  * Implemented missing semantics of functional patterns in combination
    with non-linear left-hand-sides and as-patterns.

  * Various improvements.

Version 0.3.7
=============

  * Support for typed FlatCurry expressions added. Now additional type
    information given by the programmer as in

    ~~~ {.curry}
    null (unknown :: [()])
    ~~~

    is represented in FlatCurry and cann therefore be processed by other
    programs like PAKCS or KICS2.

Version 0.3.6
=============

  * Error messages are now sorted according to their source code position.

Version 0.3.5
=============

  * Improved reporting of mutiple type signatures.

Version 0.3.4
=============

  * Bug in renaming phase fixed.

Version 0.3.3
=============

  * Corrected translation of `fcase`-expressions.

Version 0.3.2
=============

  * Non-linear left-hand-sides now work with guarded expressions - fixes #328.

  * Implemented precedence check - fixes #327.

  * Case completion refactored and corrected - fixes #323.

  * Various improvements and refactorings.

Version 0.3.1
=============

  * Corrected renaming of anonymous free variables - fixes #288.

Version 0.3.0
=============

  * Massive refactoring of the previous version.

  * All compiler warnings removed.

  * Fixed various implementation bugs (#9, #16, #19, #29, #289).
