%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Definitions of builtins of module Directory:
%

:- use_module('../prologbasics').
:- use_module(library(system)).

prim_doesFileExist(FileName,_,'$io'(Exists)) :-
	string2Atom(FileName,FName),
	(existsFile(FName) -> Exists='Prelude.True' ; Exists='Prelude.False').

prim_doesDirectoryExist(DirName,_,'$io'(Exists)) :-
	string2Atom(DirName,Dir),
	(existsDirectory(Dir) -> Exists='Prelude.True' ; Exists='Prelude.False').

prim_getModificationTime(FileName,_,'$io'(Time)) :-
	string2Atom(FileName,FName),
	fileModTime(FName,Time).

prim_fileSize(FileName,_,'$io'(Size)) :-
	string2Atom(FileName,FName),
	fileSize(FName,Size).

prim_getDirectoryContents(DirName,_,'$io'(EntryNames)) :-
	string2Atom(DirName,Dir),
	directory_files(Dir,Entries),
	map2(atom2String,Entries,EntryNames).

prim_createDirectory(DirName,_,'$io'('Prelude.()')) :-
	string2Atom(DirName,DName),
	make_directory(DName).

prim_removeFile(FileName,_,'$io'('Prelude.()')) :-
	string2Atom(FileName,FName),
	deleteFile(FName).


