%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Definitions of builtins of module IOExts:
%

:- use_module('../prologbasics').
:- ensure_loaded(user:prim_ports). % for IOExts.choiceStreamOrMsgs

:- dynamic globalAssoc/2.

prim_setAssoc(Key,Val,_,'$io'('Prelude.()')) :-
        string2Atom(Key,KeyA),
	(retract(globalAssoc(KeyA,_)) -> true ; true),
	assertz(globalAssoc(KeyA,Val)),
	!.

prim_getAssoc(Key,_,'$io'(R)) :-
        string2Atom(Key,KeyA),
	(globalAssoc(KeyA,Val) -> R='Prelude.Just'(Val) ; R='Prelude.Nothing'),
	!.

% shell command execution:
prim_execCmd(CmdString,_,'$io'('Prelude.(,,)'(StdIn,StdOut,StdErr))) :-
	string2Atom(CmdString,Cmd),
	execCommand(Cmd,StdIn,StdOut,StdErr).


% shell command execution:
prim_connectToCmd(CmdString,_,'$io'('$stream'('$inoutstream'(StdOut,StdIn)))) :-
	string2Atom(CmdString,Cmd),
	execCommand(Cmd,StdIn,StdOut,std).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% primitives implementing IORefs:

% New IORefs are represented as mutable values. The "share" constructor
% is put around to be conform with the remaining implementation where
% all mutables are "marked" by this constructor.
?- block 'prim_newIORef'(?,?,?,-,?).
'prim_newIORef'(Val,_,'$io'('IOExts.IORef'(share(MutVal))),E0,E) :-
        var(Val), !,
	create_mutable('$eval'(Val),MutVal), E0=E.
'prim_newIORef'(Val,_,'$io'('IOExts.IORef'(share(MutVal))),E0,E) :-
	create_mutable(Val,MutVal), E0=E.

% When an IORef is read and its value is not evaluated, the current value
% is wrapped into a new mutable in order to implement sharing
% of evaluations of IORefs. The current IORef is updated so that
% it refers to the new mutable (without this indirection, there is
% a risk of creating cyclic structures when the IORef itself is updated).
?- block prim_readIORef(?,?,?,-,?).
prim_readIORef(RIORef,_,'$io'(V),E0,E) :-
        user:deref(RIORef,'IOExts.IORef'(share(MutVal))),
        get_mutable(Val,MutVal),
	(Val='$eval'(V) -> true
	  ; create_mutable(Val,MutV),
	    update_mutable(share(MutV),MutVal),
	    V=share(MutV)),
        E0=E.

% Assign a new value to an IORef:
?- block prim_writeIORef(?,?,?,?,-,?).
prim_writeIORef(RIORef,Val,_,R,E0,E) :-
        user:deref(RIORef,IORef),
	prim_writeIORef_exec(IORef,Val,R), E0=E.

prim_writeIORef_exec('IOExts.IORef'(share(MutVal)),Val,'$io'('Prelude.()')) :-
        var(Val), !,
	update_mutable('$eval'(Val),MutVal).
prim_writeIORef_exec('IOExts.IORef'(share(MutVal)),Val,'$io'('Prelude.()')) :-
	update_mutable(Val,MutVal).

