%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Definitions of builtins of module IOExts:
%

:- use_module('../prologbasics').
:- use_module('../basics').


% create a new INET socket:
socketINET(_,'$io'(Socket)) :- newSocket(Socket).


% bind an INET socket to a port:
prim_socketBind(Socket,Port,_,'$io'('Prelude.()')) :- socketBind(Socket,_Host,Port).


% set backlog queue of a socket:
prim_socketListen(Socket,Length,_,'$io'('Prelude.()')) :-
        socketListen(Socket,Length), !.


% return the first connection to a socket as a read/write stream:
prim_socketAccept(Socket,_,
		  '$io'('Prelude.(,)'(ClientS,
				      '$stream'('$inoutstream'(InStream,OutStream))))) :-
        socketAccept(Socket,Client,InStream,OutStream),
	atom2String(Client,ClientS), !.

% return a connection to a socket within a time limit as a read/write stream,
% otherwise Nothing:
prim_waitForSocketAccept(Socket,TimeOut,_,'$io'(Result)) :-
	(TimeOut<0 -> TO=off
	            ; TOSec is TimeOut//1000,
	              TOMSec is (TimeOut mod 1000) * 1000, % in milliseconds
	              TO = TOSec:TOMSec),
	(waitForSocketClientStream(Socket,TO,Client,InStream,OutStream)
	 -> atom2String(Client,ClientS),
	    Result = 'Prelude.Just'('Prelude.(,)'(ClientS,
			      '$stream'('$inoutstream'(InStream,OutStream))))
	  ; Result = 'Prelude.Nothing').


% open a connection to a Unix socket:
prim_connectToSocket(SHst,SNr,_,'$io'('$stream'('$inoutstream'(InStream,OutStream)))) :-
        string2Atom(SHst,Host), !,
        newSocket(Socket),
        socketConnect(Socket,Host,SNr,InStream,OutStream).


