%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Definitions of builtins of module System:
%

:- use_module('../prologbasics').
:- use_module(prim_standard).
:- use_module(library(system)).

prim_getCPUTime(_,'$io'(MS)) :- getRunTime(MS).

prim_getElapsedTime(_,'$io'(MS)) :- getElapsedTime(MS).

prim_getDate(_,'$io'('System.Date'(Y,M,D,H,Min,S))) :-
        currentTime(Y,M,D,H,Min,S).

prim_getArgs(_,'$io'(StringArgs)) :-
        (rtargs(Args) -> true ; getProgramArgs(Args)),
        map2(atom2String,Args,StringArgs).

prim_getEnviron(Var,_,'$io'(Value)) :-
	string2Atom(Var,AtomVar),
	(environ(AtomVar,AtomValue) -> atom2String(AtomValue,Value)
	                             ; Value = []). % empty string if undefined

prim_getHostname(_,'$io'(String)) :-
        getHostname(Name),
        atom2String(Name,String).

prim_getPID(_,'$io'(Pid)) :- currentPID(Pid).

prim_getProgName(_,'$io'(String)) :-
        currentModule(Name),
        atom2String(Name,String).

prim_system(S,_,'$io'(Status)) :-
	string2Atom(S,Cmd),
	system(Cmd,Status).

prim_exitWith(Code,_,_,_,_) :- halt(Code).

prim_sleep(S,_,'$io'('Prelude.()')) :- sleep(S).

% evaluate the argument to normal form and print the evaluation time:
?- block 'prim_evalTime'(?,?,-,?).
'prim_evalTime'(T,NF,E0,E) :-
	garbage_collect,
	getRunTime(RTime1),
	getElapsedTime(ETime1),
	statistics(garbage_collection,[GC1,_,_]),
	normalizeAndCheck(T,NF,E0,E1),
	getRunTime(RTime2),
	getElapsedTime(ETime2),
	statistics(garbage_collection,[GC2,_,_]),
	writeErr('EVALTIME: Runtime: '),
	RTime is RTime2-RTime1, writeErr(RTime),
	writeErr(' msec.'), nlErr,
	writeErr('EVALTIME: Elapsed time: '),
	ETime is ETime2-ETime1, writeErr(ETime),
	writeErr(' msec.'), nlErr,
	writeErr('EVALTIME: Number of garbage collections: '),
	GC is GC2-GC1, writeErr(GC), nlErr,
	garbageCollectorOn, E1=E.

% evaluate the argument to normal form (without garbage collection)
% and print the evaluation time and memory usage:
?- block 'prim_evalSpace'(?,?,-,?).
'prim_evalSpace'(T,NF,E0,E) :-
	garbage_collect,
	garbageCollectorOff,
	getRunTime(RTime1),
	getElapsedTime(ETime1),
	statistics(garbage_collection,[GC1,_,_]),
	statistics(global_stack,[GSU1,_]),
	statistics(local_stack,[LSU1,_]),
	normalizeAndCheck(T,NF,E0,E1),
	getRunTime(RTime2),
	getElapsedTime(ETime2),
	statistics(garbage_collection,[GC2,_,_]),
	statistics(global_stack,[GSU2,_]),
	statistics(local_stack,[LSU2,_]),
	writeErr('EVALTIME: Runtime: '),
	RTime is RTime2-RTime1, writeErr(RTime),
	writeErr(' msec.'), nlErr,
	writeErr('EVALTIME: Elapsed time: '),
	ETime is ETime2-ETime1, writeErr(ETime),
	writeErr(' msec.'), nlErr,
	writeErr('EVALTIME: Number of garbage collections: '),
	GC is GC2-GC1, writeErr(GC), nlErr,
	writeErr('EVALTIME: Global stack usage: '),
	GS is GSU2-GSU1, writeErr(GS), nlErr,
	writeErr('EVALTIME: Local stack usage: '),
	LS is LSU2-LSU1, writeErr(LS), nlErr,
	garbageCollectorOn, E1=E.
