%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Definitions of builtins of module Unsafe:
%

:- use_module('../prologbasics').
:- use_module(prim_readshowterm).

?- block 'prim_unsafePerformIO'(?,?,-,?).
'prim_unsafePerformIO'(Action,H,E0,E) :-
        worldToken(World),
        prim_apply(Action,World,'$io'(Result),E0,E1),
	user:hnf(Result,H,E1,E).

?- block 'prim_spawnConstraint'(?,?,?,-,?).
'prim_spawnConstraint'(Guard,Exp,H,E0,E) :-
        user:hnf(Guard,S,E0,_), S='Prelude.success',
	user:hnf(Exp,H,E0,E).

prim_isVar(Term,H) :- (var(Term) -> H='Prelude.True' ; H='Prelude.False').

prim_identicalVar(Y,X,H) :-
        ((var(X), var(Y), X==Y) -> H='Prelude.True' ; H='Prelude.False').


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% conversion of Curry data terms (with variables) into string representation in
% standard prefix notation

prim_showAnyTerm(Term,String) :-
        copy_term(Term,CTerm),
	groundTermVars(CTerm,0,_),
	show_term(CTerm,unqualified,String,[]).

prim_showAnyQTerm(Term,String) :-
        copy_term(Term,CTerm),
	groundTermVars(CTerm,0,_),
	show_term(CTerm,qualified,String,[]).

?- block prim_showAnyExpression(?,?,-,?).
prim_showAnyExpression(Exp,String,E0,E) :-
        removeShares(Exp,UExp), copy_term(UExp,CExp),
	groundTermVars(CExp,0,_),
	show_term(CExp,unqualified,String,[]), E0=E.

?- block prim_showAnyExpression(?,?,-,?).
prim_showAnyQExpression(Exp,String,E0,E) :-
        removeShares(Exp,UExp), copy_term(UExp,CExp),
	groundTermVars(CExp,0,_),
	show_term(CExp,qualified,String,[]), E0=E.


% bind free variables in a term to a printable ground representation:
groundTermVars(X,I,I1) :- var(X), !,
	X='_'(I),
	I1 is I+1.
groundTermVars(A,I,I) :- atom(A), !.
groundTermVars(T,I,I1) :-
	T =.. [_|Args],
	groundTermsVars(Args,I,I1).

groundTermsVars([],I,I).
groundTermsVars([A|As],I,I2) :-
	groundTermVars(A,I,I1),
	groundTermsVars(As,I1,I2).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% conversion of standard prefix string representations of Curry terms
% into Curry terms:

% conversion of string representations of Curry terms into Curry terms:
prim_readsAnyQTerm(String,['Prelude.(,)'(Term,TailString)]) :-
	map2(char_int,String,PrologString),
	readTerm(PrologString,any_qualified,Tail,GTerm),
	ungroundTermVars(GTerm,Term,_),
	map2(char_int,TailString,Tail), !.
prim_readsAnyQTerm(_,[]). % parse error

prim_readsAnyUnqualifiedTerm(Prefixes,String,['Prelude.(,)'(Term,TailString)]) :-
	(Prefixes=[] -> PrefixDots=any
	              ; map2(prefix2prefixdot,Prefixes,PrefixDots)),
	map2(char_int,String,PrologString),
	readTerm(PrologString,any_unqualified(PrefixDots),Tail,GTerm),
	ungroundTermVars(GTerm,Term,_),
	map2(char_int,TailString,Tail), !.
prim_readsAnyUnqualifiedTerm(_,_,[]). % parse error


% replace ground representations by free variables in a term:
ungroundTermVars('_'(I),X,Binds) :- !,
	getVarIndex(Binds,I,X).
ungroundTermVars(A,A,_) :- atom(A), !.
ungroundTermVars(T,VT,Binds) :-
	T =.. [C|Args],
	ungroundTermsVars(Args,VArgs,Binds),
	VT =.. [C|VArgs].

ungroundTermsVars([],[],_).
ungroundTermsVars([A|As],[VA|VAs],Binds) :-
	ungroundTermVars(A,VA,Binds),
	ungroundTermsVars(As,VAs,Binds).

getVarIndex(Binds,Idx,Var) :- var(Binds), !, Binds=[(Idx=Var)|_].
getVarIndex([(Idx=V)|_],Idx,Var) :- !, V=Var.
getVarIndex([_|Binds],Idx,Var) :- getVarIndex(Binds,Idx,Var).

